# LLVM.jl

*A Julia wrapper for LLVM.*

This package provides a wrapper for the LLVM compiler framework, based on the LLVM C API.
You can use LLVM.jl to work with LLVM code generated by Julia, to interoperate with the
Julia compiler, or to create your own compiler. It is heavily used by the different GPU
compilers for the Julia programming language.

There are different levels of abstraction and functionality available in this package:

- functionality in the top-level `LLVM` module: high-level wrappers for the LLVM C API, and
  additional functionality to make working with LLVM easier;
- functionality in `LLVM.Interop`: specific functionality to interoperate with the Julia
  compiler, and to work with LLVM code generated by Julia;
- functionality in the `LLVM.API` submodule: a direct mapping of the LLVM C API to Julia.
  This is useful when you need to work with the LLVM C API directly, or when you need
  functionality that is not yet wrapped in the top-level module.

For installation instructions, please refer to the
[README](https://github.com/JuliaLLVM/LLVM.jl/blob/master/README.md).
