# elements data, initially generated from https://github.com/Bowserinator/Periodic-Table-JSON
# by the script:
#
# using JSON
# data = open(JSON.parse, "elements.json");
# function el(io, d)
#     print(io, "    Element(name=", repr(d["name"]))
#     for k in sort!(collect(keys(d)))
#         if k != "name" && (!isa(d[k], String) || !isempty(d[k]))
#             v = d[k]
#             if v isa Vector{Any}
#                 v = Vector{Int}(v)
#             end
#             print(io, ",\n            $k=", repr(v))
#         end
#     end
#     println(io, "),")
# end
# open("elements.jl", "w") do f
#     println("const _elements_data = ["
#     for d in data
#         el(f, d)
#     end
#     println("]")
# end

const _elements_data = [
    Element(name="Hydrogen",
            appearance="colorless gas",
            atomic_mass=1.008u,
            boil=20.271K,
            category="diatomic nonmetal",
            cpk_hex="#ffffff",
            density=0.08988e-3g/cm^3,
            discovered_by="Henry Cavendish",
            el_config="1s¹",
            melt=13.99K,
            molar_heat=28.836J/(mol*K),
            named_by="Antoine Lavoisier",
            number=1,
            period=1,
            phase="Gas",
            shells=[1],
            source="https://en.wikipedia.org/wiki/Hydrogen",
            spectral_img="https://en.wikipedia.org/wiki/File:Hydrogen_Spectra.jpg",
            summary="Hydrogen is a chemical element with chemical symbol H and atomic number 1. With an atomic weight of 1.00794 u, hydrogen is the lightest element on the periodic table. Its monatomic form (H) is the most abundant chemical substance in the Universe, constituting roughly 75% of all baryonic mass.",
            symbol="H",
            xpos=1,
            ypos=1),
    Element(name="Helium",
            appearance="colorless gas, exhibiting a red-orange glow when placed in a high-voltage electric field",
            atomic_mass=4.002602u,
            boil=4.222K,
            category="noble gas",
            cpk_hex="#d9ffff",
            density=0.1786e-3g/cm^3,
            discovered_by="Pierre Janssen",
            el_config="1s²",
            melt=0.95K,
            number=2,
            period=1,
            phase="Gas",
            shells=[2],
            source="https://en.wikipedia.org/wiki/Helium",
            spectral_img="https://en.wikipedia.org/wiki/File:Helium_spectrum.jpg",
            summary="Helium is a chemical element with symbol He and atomic number 2. It is a colorless, odorless, tasteless, non-toxic, inert, monatomic gas that heads the noble gas group in the periodic table. Its boiling and melting points are the lowest among all the elements.",
            symbol="He",
            xpos=18,
            ypos=1),
    Element(name="Lithium",
            appearance="silvery-white",
            atomic_mass=6.94u,
            boil=1603.0K,
            category="alkali metal",
            cpk_hex="#cc80ff",
            density=0.534g/cm^3,
            discovered_by="Johan August Arfwedson",
            el_config="1s² 2s¹",
            melt=453.65K,
            molar_heat=24.86J/(mol*K),
            number=3,
            period=2,
            phase="Solid",
            shells=[2, 1],
            source="https://en.wikipedia.org/wiki/Lithium",
            summary="Lithium (from Greek:λίθος lithos, \"stone\") is a chemical element with the symbol Li and atomic number 3. It is a soft, silver-white metal belonging to the alkali metal group of chemical elements. Under standard conditions it is the lightest metal and the least dense solid element.",
            symbol="Li",
            xpos=1,
            ypos=2),
    Element(name="Beryllium",
            appearance="white-gray metallic",
            atomic_mass=9.0121831u,
            boil=2742.0K,
            category="alkaline earth metal",
            cpk_hex="#c2ff00",
            density=1.85g/cm^3,
            discovered_by="Louis Nicolas Vauquelin",
            el_config="1s² 2s²",
            melt=1560.0K,
            molar_heat=16.443J/(mol*K),
            number=4,
            period=2,
            phase="Solid",
            shells=[2, 2],
            source="https://en.wikipedia.org/wiki/Beryllium",
            summary="Beryllium is a chemical element with symbol Be and atomic number 4. It is created through stellar nucleosynthesis and is a relatively rare element in the universe. It is a divalent element which occurs naturally only in combination with other elements in minerals.",
            symbol="Be",
            xpos=2,
            ypos=2),
    Element(name="Boron",
            appearance="black-brown",
            atomic_mass=10.81u,
            boil=4200.0K,
            category="metalloid",
            cpk_hex="#ffb5b5",
            density=2.08g/cm^3,
            discovered_by="Joseph Louis Gay-Lussac",
            el_config="1s² 2s² 2p¹",
            melt=2349.0K,
            molar_heat=11.087J/(mol*K),
            number=5,
            period=2,
            phase="Solid",
            shells=[2, 3],
            source="https://en.wikipedia.org/wiki/Boron",
            summary="Boron is a metalloid chemical element with symbol B and atomic number 5. Produced entirely by cosmic ray spallation and supernovae and not by stellar nucleosynthesis, it is a low-abundance element in both the Solar system and the Earth's crust. Boron is concentrated on Earth by the water-solubility of its more common naturally occurring compounds, the borate minerals.",
            symbol="B",
            xpos=13,
            ypos=2),
    Element(name="Carbon",
            atomic_mass=12.011u,
            category="polyatomic nonmetal",
            cpk_hex="#909090",
            density=1.821g/cm^3,
            discovered_by="Ancient Egypt",
            el_config="1s² 2s² 2p²",
            molar_heat=8.517J/(mol*K),
            number=6,
            period=2,
            phase="Solid",
            shells=[2, 4],
            source="https://en.wikipedia.org/wiki/Carbon",
            spectral_img="https://en.wikipedia.org/wiki/File:Carbon_Spectra.jpg",
            summary="Carbon (from Latin:carbo \"coal\") is a chemical element with symbol C and atomic number 6. On the periodic table, it is the first (row 2) of six elements in column (group) 14, which have in common the composition of their outer electron shell. It is nonmetallic and tetravalent—making four electrons available to form covalent chemical bonds.",
            symbol="C",
            xpos=14,
            ypos=2),
    Element(name="Nitrogen",
            appearance="colorless gas, liquid or solid",
            atomic_mass=14.007u,
            boil=77.355K,
            category="diatomic nonmetal",
            cpk_hex="#3050f8",
            density=1.251e-3g/cm^3,
            discovered_by="Daniel Rutherford",
            el_config="1s² 2s² 2p³",
            melt=63.15K,
            named_by="Jean-Antoine Chaptal",
            number=7,
            period=2,
            phase="Gas",
            shells=[2, 5],
            source="https://en.wikipedia.org/wiki/Nitrogen",
            spectral_img="https://en.wikipedia.org/wiki/File:Nitrogen_Spectra.jpg",
            summary="Nitrogen is a chemical element with symbol N and atomic number 7. It is the lightest pnictogen and at room temperature, it is a transparent, odorless diatomic gas. Nitrogen is a common element in the universe, estimated at about seventh in total abundance in the Milky Way and the Solar System.",
            symbol="N",
            xpos=15,
            ypos=2),
    Element(name="Oxygen",
            atomic_mass=15.999u,
            boil=90.188K,
            category="diatomic nonmetal",
            cpk_hex="#ff0d0d",
            density=1.429e-3g/cm^3,
            discovered_by="Carl Wilhelm Scheele",
            el_config="1s² 2s² 2p⁴",
            melt=54.36K,
            named_by="Antoine Lavoisier",
            number=8,
            period=2,
            phase="Gas",
            shells=[2, 6],
            source="https://en.wikipedia.org/wiki/Oxygen",
            spectral_img="https://en.wikipedia.org/wiki/File:Oxygen_spectre.jpg",
            summary="Oxygen is a chemical element with symbol O and atomic number 8. It is a member of the chalcogen group on the periodic table and is a highly reactive nonmetal and oxidizing agent that readily forms compounds (notably oxides) with most elements. By mass, oxygen is the third-most abundant element in the universe, after hydrogen and helium.",
            symbol="O",
            xpos=16,
            ypos=2),
    Element(name="Fluorine",
            atomic_mass=18.998403163u,
            boil=85.03K,
            category="diatomic nonmetal",
            cpk_hex="#90e050",
            density=1.696e-3g/cm^3,
            discovered_by="André-Marie Ampère",
            el_config="1s² 2s² 2p⁵",
            melt=53.48K,
            named_by="Humphry Davy",
            number=9,
            period=2,
            phase="Gas",
            shells=[2, 7],
            source="https://en.wikipedia.org/wiki/Fluorine",
            summary="Fluorine is a chemical element with symbol F and atomic number 9. It is the lightest halogen and exists as a highly toxic pale yellow diatomic gas at standard conditions. As the most electronegative element, it is extremely reactive:almost all other elements, including some noble gases, form compounds with fluorine.",
            symbol="F",
            xpos=17,
            ypos=2),
    Element(name="Neon",
            appearance="colorless gas exhibiting an orange-red glow when placed in a high voltage electric field",
            atomic_mass=20.1797u,
            boil=27.104K,
            category="noble gas",
            cpk_hex="#b3e3f5",
            density=0.9002e-3g/cm^3,
            discovered_by="Morris Travers",
            el_config="1s² 2s² 2p⁶",
            melt=24.56K,
            number=10,
            period=2,
            phase="Gas",
            shells=[2, 8],
            source="https://en.wikipedia.org/wiki/Neon",
            spectral_img="https://en.wikipedia.org/wiki/File:Neon_spectra.jpg",
            summary="Neon is a chemical element with symbol Ne and atomic number 10. It is in group 18 (noble gases) of the periodic table. Neon is a colorless, odorless, inert monatomic gas under standard conditions, with about two-thirds the density of air.",
            symbol="Ne",
            xpos=18,
            ypos=2),
    Element(name="Sodium",
            appearance="silvery white metallic",
            atomic_mass=22.98976928u,
            boil=1156.09K,
            category="alkali metal",
            cpk_hex="#ab5cf2",
            density=0.968g/cm^3,
            discovered_by="Humphry Davy",
            el_config="1s² 2s² 2p⁶ 3s¹",
            melt=370.944K,
            molar_heat=28.23J/(mol*K),
            number=11,
            period=3,
            phase="Solid",
            shells=[2, 8, 1],
            source="https://en.wikipedia.org/wiki/Sodium",
            spectral_img="https://en.wikipedia.org/wiki/File:Sodium_Spectra.jpg",
            summary="Sodium /ˈsoʊdiəm/ is a chemical element with symbol Na (from Ancient Greek Νάτριο) and atomic number 11. It is a soft, silver-white, highly reactive metal. In the Periodic table it is in column 1 (alkali metals), and shares with the other six elements in that column that it has a single electron in its outer shell, which it readily donates, creating a positively charged atom - a cation.",
            symbol="Na",
            xpos=1,
            ypos=3),
    Element(name="Magnesium",
            appearance="shiny grey solid",
            atomic_mass=24.305u,
            boil=1363.0K,
            category="alkaline earth metal",
            cpk_hex="#8aff00",
            density=1.738g/cm^3,
            discovered_by="Joseph Black",
            el_config="1s² 2s² 2p⁶ 3s²",
            melt=923.0K,
            molar_heat=24.869J/(mol*K),
            number=12,
            period=3,
            phase="Solid",
            shells=[2, 8, 2],
            source="https://en.wikipedia.org/wiki/Magnesium",
            spectral_img="https://en.wikipedia.org/wiki/File:Magnesium_Spectra.jpg",
            summary="Magnesium is a chemical element with symbol Mg and atomic number 12. It is a shiny gray solid which bears a close physical resemblance to the other five elements in the second column (Group 2, or alkaline earth metals) of the periodic table:they each have the same electron configuration in their outer electron shell producing a similar crystal structure. Magnesium is the ninth most abundant element in the universe.",
            symbol="Mg",
            xpos=2,
            ypos=3),
    Element(name="Aluminium",
            appearance="silvery gray metallic",
            atomic_mass=26.9815384u,
            boil=2743.0K,
            category="post-transition metal",
            cpk_hex="#bfa6a6",
            density=2.7g/cm^3,
            el_config="1s² 2s² 2p⁶ 3s² 3p¹",
            melt=933.47K,
            molar_heat=24.2J/(mol*K),
            named_by="Humphry Davy",
            number=13,
            period=3,
            phase="Solid",
            shells=[2, 8, 3],
            source="https://en.wikipedia.org/wiki/Aluminium",
            summary="Aluminium (or aluminum; see different endings) is a chemical element in the boron group with symbol Al and atomic number 13. It is a silvery-white, soft, nonmagnetic, ductile metal. Aluminium is the third most abundant element (after oxygen and silicon), and the most abundant metal, in the Earth's crust.",
            symbol="Al",
            xpos=13,
            ypos=3),
    Element(name="Silicon",
            appearance="crystalline, reflective with bluish-tinged faces",
            atomic_mass=28.085u,
            boil=3538.0K,
            category="metalloid",
            cpk_hex="#f0c8a0",
            density=2.329g/cm^3,
            discovered_by="Jöns Jacob Berzelius",
            el_config="1s² 2s² 2p⁶ 3s² 3p²",
            melt=1687.0K,
            molar_heat=19.789J/(mol*K),
            named_by="Thomas Thomson (chemist)",
            number=14,
            period=3,
            phase="Solid",
            shells=[2, 8, 4],
            source="https://en.wikipedia.org/wiki/Silicon",
            spectral_img="https://en.wikipedia.org/wiki/File:Silicon_Spectra.jpg",
            summary="Silicon is a chemical element with symbol Si and atomic number 14. It is a tetravalent metalloid, more reactive than germanium, the metalloid directly below it in the table. Controversy about silicon's character dates to its discovery.",
            symbol="Si",
            xpos=14,
            ypos=3),
    Element(name="Phosphorus",
            appearance="colourless, waxy white, yellow, scarlet, red, violet, black",
            atomic_mass=30.973761998u,
            category="polyatomic nonmetal",
            cpk_hex="#ff8000",
            density=1.82g/cm^3,
            discovered_by="Hennig Brand",
            el_config="1s² 2s² 2p⁶ 3s² 3p³",
            molar_heat=23.824J/(mol*K),
            number=15,
            period=3,
            phase="Solid",
            shells=[2, 8, 5],
            source="https://en.wikipedia.org/wiki/Phosphorus",
            summary="Phosphorus is a chemical element with symbol P and atomic number 15. As an element, phosphorus exists in two major forms—white phosphorus and red phosphorus—but due to its high reactivity, phosphorus is never found as a free element on Earth. Instead phosphorus-containing minerals are almost always present in their maximally oxidised state, as inorganic phosphate rocks.",
            symbol="P",
            xpos=15,
            ypos=3),
    Element(name="Sulfur",
            appearance="lemon yellow sintered microcrystals",
            atomic_mass=32.06u,
            boil=717.8K,
            category="polyatomic nonmetal",
            cpk_hex="#ffff30",
            density=2.07g/cm^3,
            discovered_by="Ancient China",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁴",
            melt=388.36K,
            molar_heat=22.75J/(mol*K),
            number=16,
            period=3,
            phase="Solid",
            shells=[2, 8, 6],
            source="https://en.wikipedia.org/wiki/Sulfur",
            spectral_img="https://en.wikipedia.org/wiki/File:Sulfur_Spectrum.jpg",
            summary="Sulfur or sulphur (see spelling differences) is a chemical element with symbol S and atomic number 16. It is an abundant, multivalent non-metal. Under normal conditions, sulfur atoms form cyclic octatomic molecules with chemical formula S8.",
            symbol="S",
            xpos=16,
            ypos=3),
    Element(name="Chlorine",
            appearance="pale yellow-green gas",
            atomic_mass=35.45u,
            boil=239.11K,
            category="diatomic nonmetal",
            cpk_hex="#1ff01f",
            density=3.2e-3g/cm^3,
            discovered_by="Carl Wilhelm Scheele",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁵",
            melt=171.6K,
            number=17,
            period=3,
            phase="Gas",
            shells=[2, 8, 7],
            source="https://en.wikipedia.org/wiki/Chlorine",
            spectral_img="https://en.wikipedia.org/wiki/File:Chlorine_spectrum_visible.png",
            summary="Chlorine is a chemical element with symbol Cl and atomic number 17. It also has a relative atomic mass of 35.5. Chlorine is in the halogen group (17) and is the second lightest halogen following fluorine.",
            symbol="Cl",
            xpos=17,
            ypos=3),
    Element(name="Argon",
            appearance="colorless gas exhibiting a lilac/violet glow when placed in a high voltage electric field",
            atomic_mass=39.95u,
            boil=87.302K,
            category="noble gas",
            cpk_hex="#80d1e3",
            density=1.784e-3g/cm^3,
            discovered_by="Lord Rayleigh",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶",
            melt=83.81K,
            number=18,
            period=3,
            phase="Gas",
            shells=[2, 8, 8],
            source="https://en.wikipedia.org/wiki/Argon",
            spectral_img="https://en.wikipedia.org/wiki/File:Argon_Spectrum.png",
            summary="Argon is a chemical element with symbol Ar and atomic number 18. It is in group 18 of the periodic table and is a noble gas. Argon is the third most common gas in the Earth's atmosphere, at 0.934% (9,340 ppmv), making it over twice as abundant as the next most common atmospheric gas, water vapor (which averages about 4000 ppmv, but varies greatly), and 23 times as abundant as the next most common non-condensing atmospheric gas, carbon dioxide (400 ppmv), and more than 500 times as abundant as the next most common noble gas, neon (18 ppmv).",
            symbol="Ar",
            xpos=18,
            ypos=3),
    Element(name="Potassium",
            appearance="silvery gray",
            atomic_mass=39.0983u,
            boil=1032.0K,
            category="alkali metal",
            cpk_hex="#8f40d4",
            density=0.862g/cm^3,
            discovered_by="Humphry Davy",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s¹",
            melt=336.7K,
            molar_heat=29.6J/(mol*K),
            number=19,
            period=4,
            phase="Solid",
            shells=[2, 8, 8, 1],
            source="https://en.wikipedia.org/wiki/Potassium",
            spectral_img="https://en.wikipedia.org/wiki/File:Potassium_Spectrum.jpg",
            summary="Potassium is a chemical element with symbol K (derived from Neo-Latin, kalium) and atomic number 19. It was first isolated from potash, the ashes of plants, from which its name is derived. In the Periodic table, potassium is one of seven elements in column (group) 1 (alkali metals):they all have a single valence electron in their outer electron shell, which they readily give up to create an atom with a positive charge - a cation, and combine with anions to form salts.",
            symbol="K",
            xpos=1,
            ypos=4),
    Element(name="Calcium",
            atomic_mass=40.078u,
            boil=1757.0K,
            category="alkaline earth metal",
            cpk_hex="#3dff00",
            density=1.55g/cm^3,
            discovered_by="Humphry Davy",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s²",
            melt=1115.0K,
            molar_heat=25.929J/(mol*K),
            number=20,
            period=4,
            phase="Solid",
            shells=[2, 8, 8, 2],
            source="https://en.wikipedia.org/wiki/Calcium",
            spectral_img="https://en.wikipedia.org/wiki/File:Calcium_Spectrum.png",
            summary="Calcium is a chemical element with symbol Ca and atomic number 20. Calcium is a soft gray alkaline earth metal, fifth-most-abundant element by mass in the Earth's crust. The ion Ca2+ is also the fifth-most-abundant dissolved ion in seawater by both molarity and mass, after sodium, chloride, magnesium, and sulfate.",
            symbol="Ca",
            xpos=2,
            ypos=4),
    Element(name="Scandium",
            appearance="silvery white",
            atomic_mass=44.955907u,
            boil=3109.0K,
            category="transition metal",
            cpk_hex="#e6e6e6",
            density=2.985g/cm^3,
            discovered_by="Lars Fredrik Nilson",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹",
            melt=1814.0K,
            molar_heat=25.52J/(mol*K),
            number=21,
            period=4,
            phase="Solid",
            shells=[2, 8, 9, 2],
            source="https://en.wikipedia.org/wiki/Scandium",
            summary="Scandium is a chemical element with symbol Sc and atomic number 21. A silvery-white metallic d-block element, it has historically been sometimes classified as a rare earth element, together with yttrium and the lanthanoids. It was discovered in 1879 by spectral analysis of the minerals euxenite and gadolinite from Scandinavia.",
            symbol="Sc",
            xpos=3,
            ypos=4),
    Element(name="Titanium",
            appearance="silvery grey-white metallic",
            atomic_mass=47.867u,
            boil=3560.0K,
            category="transition metal",
            cpk_hex="#bfc2c7",
            density=4.506g/cm^3,
            discovered_by="William Gregor",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d²",
            melt=1941.0K,
            molar_heat=25.06J/(mol*K),
            named_by="Martin Heinrich Klaproth",
            number=22,
            period=4,
            phase="Solid",
            shells=[2, 8, 10, 2],
            source="https://en.wikipedia.org/wiki/Titanium",
            summary="Titanium is a chemical element with symbol Ti and atomic number 22. It is a lustrous transition metal with a silver color, low density and high strength. It is highly resistant to corrosion in sea water, aqua regia and chlorine.",
            symbol="Ti",
            xpos=4,
            ypos=4),
    Element(name="Vanadium",
            appearance="blue-silver-grey metal",
            atomic_mass=50.9415u,
            boil=3680.0K,
            category="transition metal",
            cpk_hex="#a6a6ab",
            density=6.0g/cm^3,
            discovered_by="Andrés Manuel del Río",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d³",
            melt=2183.0K,
            molar_heat=24.89J/(mol*K),
            named_by="Isotopes of vanadium",
            number=23,
            period=4,
            phase="Solid",
            shells=[2, 8, 11, 2],
            source="https://en.wikipedia.org/wiki/Vanadium",
            summary="Vanadium is a chemical element with symbol V and atomic number 23. It is a hard, silvery grey, ductile and malleable transition metal. The element is found only in chemically combined form in nature, but once isolated artificially, the formation of an oxide layer stabilizes the free metal somewhat against further oxidation.",
            symbol="V",
            xpos=5,
            ypos=4),
    Element(name="Chromium",
            appearance="silvery metallic",
            atomic_mass=51.9961u,
            boil=2944.0K,
            category="transition metal",
            cpk_hex="#8a99c7",
            density=7.19g/cm^3,
            discovered_by="Louis Nicolas Vauquelin",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s¹ 3d⁵",
            melt=2180.0K,
            molar_heat=23.35J/(mol*K),
            number=24,
            period=4,
            phase="Solid",
            shells=[2, 8, 13, 1],
            source="https://en.wikipedia.org/wiki/Chromium",
            summary="Chromium is a chemical element with symbol Cr and atomic number 24. It is the first element in Group 6. It is a steely-gray, lustrous, hard and brittle metal which takes a high polish, resists tarnishing, and has a high melting point.",
            symbol="Cr",
            xpos=6,
            ypos=4),
    Element(name="Manganese",
            appearance="silvery metallic",
            atomic_mass=54.938043u,
            boil=2334.0K,
            category="transition metal",
            cpk_hex="#9c7ac7",
            density=7.21g/cm^3,
            discovered_by="Torbern Olof Bergman",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d⁵",
            melt=1519.0K,
            molar_heat=26.32J/(mol*K),
            number=25,
            period=4,
            phase="Solid",
            shells=[2, 8, 13, 2],
            source="https://en.wikipedia.org/wiki/Manganese",
            summary="Manganese is a chemical element with symbol Mn and atomic number 25. It is not found as a free element in nature; it is often found in combination with iron, and in many minerals. Manganese is a metal with important industrial metal alloy uses, particularly in stainless steels.",
            symbol="Mn",
            xpos=7,
            ypos=4),
    Element(name="Iron",
            appearance="lustrous metallic with a grayish tinge",
            atomic_mass=55.845u,
            boil=3134.0K,
            category="transition metal",
            cpk_hex="#e06633",
            density=7.874g/cm^3,
            discovered_by="5000 BC",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d⁶",
            melt=1811.0K,
            molar_heat=25.1J/(mol*K),
            number=26,
            period=4,
            phase="Solid",
            shells=[2, 8, 14, 2],
            source="https://en.wikipedia.org/wiki/Iron",
            spectral_img="https://en.wikipedia.org/wiki/File:Iron_Spectrum.jpg",
            summary="Iron is a chemical element with symbol Fe (from Latin:ferrum) and atomic number 26. It is a metal in the first transition series. It is by mass the most common element on Earth, forming much of Earth's outer and inner core.",
            symbol="Fe",
            xpos=8,
            ypos=4),
    Element(name="Cobalt",
            appearance="hard lustrous gray metal",
            atomic_mass=58.933194u,
            boil=3200.0K,
            category="transition metal",
            color="metallic gray",
            cpk_hex="#f090a0",
            density=8.9g/cm^3,
            discovered_by="Georg Brandt",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d⁷",
            melt=1768.0K,
            molar_heat=24.81J/(mol*K),
            number=27,
            period=4,
            phase="Solid",
            shells=[2, 8, 15, 2],
            source="https://en.wikipedia.org/wiki/Cobalt",
            summary="Cobalt is a chemical element with symbol Co and atomic number 27. Like nickel, cobalt in the Earth's crust is found only in chemically combined form, save for small deposits found in alloys of natural meteoric iron. The free element, produced by reductive smelting, is a hard, lustrous, silver-gray metal.",
            symbol="Co",
            xpos=9,
            ypos=4),
    Element(name="Nickel",
            appearance="lustrous, metallic, and silver with a gold tinge",
            atomic_mass=58.6934u,
            boil=3003.0K,
            category="transition metal",
            cpk_hex="#50d050",
            density=8.908g/cm^3,
            discovered_by="Axel Fredrik Cronstedt",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d⁸",
            melt=1728.0K,
            molar_heat=26.07J/(mol*K),
            number=28,
            period=4,
            phase="Solid",
            shells=[2, 8, 16, 2],
            source="https://en.wikipedia.org/wiki/Nickel",
            summary="Nickel is a chemical element with symbol Ni and atomic number 28. It is a silvery-white lustrous metal with a slight golden tinge. Nickel belongs to the transition metals and is hard and ductile.",
            symbol="Ni",
            xpos=10,
            ypos=4),
    Element(name="Copper",
            appearance="red-orange metallic luster",
            atomic_mass=63.546u,
            boil=2835.0K,
            category="transition metal",
            cpk_hex="#c88033",
            density=8.96g/cm^3,
            discovered_by="Middle East",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s¹ 3d¹⁰",
            melt=1357.77K,
            molar_heat=24.44J/(mol*K),
            number=29,
            period=4,
            phase="Solid",
            shells=[2, 8, 18, 1],
            source="https://en.wikipedia.org/wiki/Copper",
            summary="Copper is a chemical element with symbol Cu (from Latin:cuprum) and atomic number 29. It is a soft, malleable and ductile metal with very high thermal and electrical conductivity. A freshly exposed surface of pure copper has a reddish-orange color.",
            symbol="Cu",
            xpos=11,
            ypos=4),
    Element(name="Zinc",
            appearance="silver-gray",
            atomic_mass=65.38u,
            boil=1180.0K,
            category="transition metal",
            cpk_hex="#7d80b0",
            density=7.14g/cm^3,
            discovered_by="India",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰",
            melt=692.68K,
            molar_heat=25.47J/(mol*K),
            number=30,
            period=4,
            phase="Solid",
            shells=[2, 8, 18, 2],
            source="https://en.wikipedia.org/wiki/Zinc",
            summary="Zinc, in commerce also spelter, is a chemical element with symbol Zn and atomic number 30. It is the first element of group 12 of the periodic table. In some respects zinc is chemically similar to magnesium:its ion is of similar size and its only common oxidation state is +2.",
            symbol="Zn",
            xpos=12,
            ypos=4),
    Element(name="Gallium",
            appearance="silver-white",
            atomic_mass=69.723u,
            boil=2673.0K,
            category="post-transition metal",
            cpk_hex="#c28f8f",
            density=5.91g/cm^3,
            discovered_by="Lecoq de Boisbaudran",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p¹",
            melt=302.9146K,
            molar_heat=25.86J/(mol*K),
            number=31,
            period=4,
            phase="Solid",
            shells=[2, 8, 18, 3],
            source="https://en.wikipedia.org/wiki/Gallium",
            summary="Gallium is a chemical element with symbol Ga and atomic number 31. Elemental gallium does not occur in free form in nature, but as the gallium(III) compounds that are in trace amounts in zinc ores and in bauxite. Gallium is a soft, silvery metal, and elemental gallium is a brittle solid at low temperatures, and melts at 29.76 °C (85.57 °F) (slightly above room temperature).",
            symbol="Ga",
            xpos=13,
            ypos=4),
    Element(name="Germanium",
            appearance="grayish-white",
            atomic_mass=72.630u,
            boil=3106.0K,
            category="metalloid",
            cpk_hex="#668f8f",
            density=5.323g/cm^3,
            discovered_by="Clemens Winkler",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p²",
            melt=1211.4K,
            molar_heat=23.222J/(mol*K),
            number=32,
            period=4,
            phase="Solid",
            shells=[2, 8, 18, 4],
            source="https://en.wikipedia.org/wiki/Germanium",
            summary="Germanium is a chemical element with symbol Ge and atomic number 32. It is a lustrous, hard, grayish-white metalloid in the carbon group, chemically similar to its group neighbors tin and silicon. Purified germanium is a semiconductor, with an appearance most similar to elemental silicon.",
            symbol="Ge",
            xpos=14,
            ypos=4),
    Element(name="Arsenic",
            appearance="metallic grey",
            atomic_mass=74.921595u,
            category="metalloid",
            cpk_hex="#bd80e3",
            density=5.727g/cm^3,
            discovered_by="Bronze Age",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p³",
            molar_heat=24.64J/(mol*K),
            number=33,
            period=4,
            phase="Solid",
            shells=[2, 8, 18, 5],
            source="https://en.wikipedia.org/wiki/Arsenic",
            summary="Arsenic is a chemical element with symbol As and atomic number 33. Arsenic occurs in many minerals, usually in conjunction with sulfur and metals, and also as a pure elemental crystal. Arsenic is a metalloid.",
            symbol="As",
            xpos=15,
            ypos=4),
    Element(name="Selenium",
            appearance="black, red, and gray (not pictured) allotropes",
            atomic_mass=78.971u,
            boil=958.0K,
            category="polyatomic nonmetal",
            cpk_hex="#ffa100",
            density=4.81g/cm^3,
            discovered_by="Jöns Jakob Berzelius",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁴",
            melt=494.0K,
            molar_heat=25.363J/(mol*K),
            number=34,
            period=4,
            phase="Solid",
            shells=[2, 8, 18, 6],
            source="https://en.wikipedia.org/wiki/Selenium",
            summary="Selenium is a chemical element with symbol Se and atomic number 34. It is a nonmetal with properties that are intermediate between those of its periodic table column-adjacent chalcogen elements sulfur and tellurium. It rarely occurs in its elemental state in nature, or as pure ore compounds.",
            symbol="Se",
            xpos=16,
            ypos=4),
    Element(name="Bromine",
            atomic_mass=79.904u,
            boil=332.0K,
            category="diatomic nonmetal",
            cpk_hex="#a62929",
            density=3.1028g/cm^3,
            discovered_by="Antoine Jérôme Balard",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁵",
            melt=265.8K,
            number=35,
            period=4,
            phase="Liquid",
            shells=[2, 8, 18, 7],
            source="https://en.wikipedia.org/wiki/Bromine",
            summary="Bromine (from Ancient Greek:βρῶμος, brómos, meaning \"stench\") is a chemical element with symbol Br, and atomic number 35. It is a halogen. The element was isolated independently by two chemists, Carl Jacob Löwig and Antoine Jerome Balard, in 1825–1826.",
            symbol="Br",
            xpos=17,
            ypos=4),
    Element(name="Krypton",
            appearance="colorless gas, exhibiting a whitish glow in a high electric field",
            atomic_mass=83.798u,
            boil=119.93K,
            category="noble gas",
            cpk_hex="#5cb8d1",
            density=3.749e-3g/cm^3,
            discovered_by="William Ramsay",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶",
            melt=115.78K,
            number=36,
            period=4,
            phase="Gas",
            shells=[2, 8, 18, 8],
            source="https://en.wikipedia.org/wiki/Krypton",
            spectral_img="https://en.wikipedia.org/wiki/File:Krypton_Spectrum.jpg",
            summary="Krypton (from Greek:κρυπτός kryptos \"the hidden one\") is a chemical element with symbol Kr and atomic number 36. It is a member of group 18 (noble gases) elements. A colorless, odorless, tasteless noble gas, krypton occurs in trace amounts in the atmosphere, is isolated by fractionally distilling liquefied air, and is often used with other rare gases in fluorescent lamps.",
            symbol="Kr",
            xpos=18,
            ypos=4),
    Element(name="Rubidium",
            appearance="grey white",
            atomic_mass=85.4678u,
            boil=961.0K,
            category="alkali metal",
            cpk_hex="#702eb0",
            density=1.532g/cm^3,
            discovered_by="Robert Bunsen",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹",
            melt=312.45K,
            molar_heat=31.06J/(mol*K),
            number=37,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 8, 1],
            source="https://en.wikipedia.org/wiki/Rubidium",
            summary="Rubidium is a chemical element with symbol Rb and atomic number 37. Rubidium is a soft, silvery-white metallic element of the alkali metal group, with an atomic mass of 85.4678. Elemental rubidium is highly reactive, with properties similar to those of other alkali metals, such as very rapid oxidation in air.",
            symbol="Rb",
            xpos=1,
            ypos=5),
    Element(name="Strontium",
            atomic_mass=87.62u,
            boil=1650.0K,
            category="alkaline earth metal",
            cpk_hex="#00ff00",
            density=2.64g/cm^3,
            discovered_by="William Cruickshank (chemist)",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s²",
            melt=1050.0K,
            molar_heat=26.4J/(mol*K),
            number=38,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 8, 2],
            source="https://en.wikipedia.org/wiki/Strontium",
            summary="Strontium is a chemical element with symbol Sr and atomic number 38. An alkaline earth metal, strontium is a soft silver-white or yellowish metallic element that is highly reactive chemically. The metal turns yellow when it is exposed to air.",
            symbol="Sr",
            xpos=2,
            ypos=5),
    Element(name="Yttrium",
            appearance="silvery white",
            atomic_mass=88.905838u,
            boil=3203.0K,
            category="transition metal",
            cpk_hex="#94ffff",
            density=4.472g/cm^3,
            discovered_by="Johan Gadolin",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹",
            melt=1799.0K,
            molar_heat=26.53J/(mol*K),
            number=39,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 9, 2],
            source="https://en.wikipedia.org/wiki/Yttrium",
            summary="Yttrium is a chemical element with symbol Y and atomic number 39. It is a silvery-metallic transition metal chemically similar to the lanthanides and it has often been classified as a \"rare earth element\". Yttrium is almost always found combined with the lanthanides in rare earth minerals and is never found in nature as a free element.",
            symbol="Y",
            xpos=3,
            ypos=5),
    Element(name="Zirconium",
            appearance="silvery white",
            atomic_mass=91.224u,
            boil=4650.0K,
            category="transition metal",
            cpk_hex="#94e0e0",
            density=6.52g/cm^3,
            discovered_by="Martin Heinrich Klaproth",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d²",
            melt=2128.0K,
            molar_heat=25.36J/(mol*K),
            number=40,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 10, 2],
            source="https://en.wikipedia.org/wiki/Zirconium",
            summary="Zirconium is a chemical element with symbol Zr and atomic number 40. The name of zirconium is taken from the name of the mineral zircon, the most important source of zirconium. The word zircon comes from the Persian word zargun زرگون, meaning \"gold-colored\".",
            symbol="Zr",
            xpos=4,
            ypos=5),
    Element(name="Niobium",
            appearance="gray metallic, bluish when oxidized",
            atomic_mass=92.90637u,
            boil=5017.0K,
            category="transition metal",
            cpk_hex="#73c2c9",
            density=8.57g/cm^3,
            discovered_by="Charles Hatchett",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹ 4d⁴",
            melt=2750.0K,
            molar_heat=24.6J/(mol*K),
            number=41,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 12, 1],
            source="https://en.wikipedia.org/wiki/Niobium",
            summary="Niobium, formerly columbium, is a chemical element with symbol Nb (formerly Cb) and atomic number 41. It is a soft, grey, ductile transition metal, which is often found in the pyrochlore mineral, the main commercial source for niobium, and columbite. The name comes from Greek mythology:Niobe, daughter of Tantalus since it is so similar to tantalum.",
            symbol="Nb",
            xpos=5,
            ypos=5),
    Element(name="Molybdenum",
            appearance="gray metallic",
            atomic_mass=95.95u,
            boil=4912.0K,
            category="transition metal",
            cpk_hex="#54b5b5",
            density=10.28g/cm^3,
            discovered_by="Carl Wilhelm Scheele",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹ 4d⁵",
            melt=2896.0K,
            molar_heat=24.06J/(mol*K),
            number=42,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 13, 1],
            source="https://en.wikipedia.org/wiki/Molybdenum",
            summary="Molybdenum is a chemical element with symbol Mo and atomic number 42. The name is from Neo-Latin molybdaenum, from Ancient Greek Μόλυβδος molybdos, meaning lead, since its ores were confused with lead ores. Molybdenum minerals have been known throughout history, but the element was discovered (in the sense of differentiating it as a new entity from the mineral salts of other metals) in 1778 by Carl Wilhelm Scheele.",
            symbol="Mo",
            xpos=6,
            ypos=5),
    Element(name="Technetium",
            appearance="shiny gray metal",
            atomic_mass=97.0u,
            boil=4538.0K,
            category="transition metal",
            cpk_hex="#3b9e9e",
            density=11.0g/cm^3,
            discovered_by="Emilio Segrè",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d⁵",
            melt=2430.0K,
            molar_heat=24.27J/(mol*K),
            number=43,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 13, 2],
            source="https://en.wikipedia.org/wiki/Technetium",
            summary="Technetium (/tɛkˈniːʃiəm/) is a chemical element with symbol Tc and atomic number 43. It is the element with the lowest atomic number in the periodic table that has no stable isotopes:every form of it is radioactive. Nearly all technetium is produced synthetically, and only minute amounts are found in nature.",
            symbol="Tc",
            xpos=7,
            ypos=5),
    Element(name="Ruthenium",
            appearance="silvery white metallic",
            atomic_mass=101.07u,
            boil=4423.0K,
            category="transition metal",
            cpk_hex="#248f8f",
            density=12.45g/cm^3,
            discovered_by="Karl Ernst Claus",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹ 4d⁷",
            melt=2607.0K,
            molar_heat=24.06J/(mol*K),
            number=44,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 15, 1],
            source="https://en.wikipedia.org/wiki/Ruthenium",
            summary="Ruthenium is a chemical element with symbol Ru and atomic number 44. It is a rare transition metal belonging to the platinum group of the periodic table. Like the other metals of the platinum group, ruthenium is inert to most other chemicals.",
            symbol="Ru",
            xpos=8,
            ypos=5),
    Element(name="Rhodium",
            appearance="silvery white metallic",
            atomic_mass=102.90549u,
            boil=3968.0K,
            category="transition metal",
            cpk_hex="#0a7d8c",
            density=12.41g/cm^3,
            discovered_by="William Hyde Wollaston",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹ 4d⁸",
            melt=2237.0K,
            molar_heat=24.98J/(mol*K),
            number=45,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 16, 1],
            source="https://en.wikipedia.org/wiki/Rhodium",
            summary="Rhodium is a chemical element with symbol Rh and atomic number 45. It is a rare, silvery-white, hard, and chemically inert transition metal. It is a member of the platinum group.",
            symbol="Rh",
            xpos=9,
            ypos=5),
    Element(name="Palladium",
            appearance="silvery white",
            atomic_mass=106.42u,
            boil=3236.0K,
            category="transition metal",
            cpk_hex="#006985",
            density=12.023g/cm^3,
            discovered_by="William Hyde Wollaston",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 4d¹⁰",
            melt=1828.05K,
            molar_heat=25.98J/(mol*K),
            number=46,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 18],
            source="https://en.wikipedia.org/wiki/Palladium",
            summary="Palladium is a chemical element with symbol Pd and atomic number 46. It is a rare and lustrous silvery-white metal discovered in 1803 by William Hyde Wollaston. He named it after the asteroid Pallas, which was itself named after the epithet of the Greek goddess Athena, acquired by her when she slew Pallas.",
            symbol="Pd",
            xpos=10,
            ypos=5),
    Element(name="Silver",
            appearance="lustrous white metal",
            atomic_mass=107.8682u,
            boil=2435.0K,
            category="transition metal",
            cpk_hex="#c0c0c0",
            density=10.49g/cm^3,
            discovered_by="unknown, before 5000 BC",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹ 4d¹⁰",
            melt=1234.93K,
            molar_heat=25.35J/(mol*K),
            number=47,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 18, 1],
            source="https://en.wikipedia.org/wiki/Silver",
            summary="Silver is a chemical element with symbol Ag (Greek:άργυρος árguros, Latin:argentum, both from the Indo-European root *h₂erǵ- for \"grey\" or \"shining\") and atomic number 47. A soft, white, lustrous transition metal, it possesses the highest electrical conductivity, thermal conductivity and reflectivity of any metal. The metal occurs naturally in its pure, free form (native silver), as an alloy with gold and other metals, and in minerals such as argentite and chlorargyrite.",
            symbol="Ag",
            xpos=11,
            ypos=5),
    Element(name="Cadmium",
            appearance="silvery bluish-gray metallic",
            atomic_mass=112.414u,
            boil=1040.0K,
            category="transition metal",
            cpk_hex="#ffd98f",
            density=8.65g/cm^3,
            discovered_by="Karl Samuel Leberecht Hermann",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰",
            melt=594.22K,
            molar_heat=26.02J/(mol*K),
            named_by="Isotopes of cadmium",
            number=48,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 18, 2],
            source="https://en.wikipedia.org/wiki/Cadmium",
            summary="Cadmium is a chemical element with symbol Cd and atomic number 48. This soft, bluish-white metal is chemically similar to the two other stable metals in group 12, zinc and mercury. Like zinc, it prefers oxidation state +2 in most of its compounds and like mercury it shows a low melting point compared to transition metals.",
            symbol="Cd",
            xpos=12,
            ypos=5),
    Element(name="Indium",
            appearance="silvery lustrous gray",
            atomic_mass=114.818u,
            boil=2345.0K,
            category="post-transition metal",
            cpk_hex="#a67573",
            density=7.31g/cm^3,
            discovered_by="Ferdinand Reich",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p¹",
            melt=429.7485K,
            molar_heat=26.74J/(mol*K),
            number=49,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 18, 3],
            source="https://en.wikipedia.org/wiki/Indium",
            summary="Indium is a chemical element with symbol In and atomic number 49. It is a post-transition metallic element that is rare in Earth's crust. The metal is very soft, malleable and easily fusible, with a melting point higher than sodium, but lower than lithium or tin.",
            symbol="In",
            xpos=13,
            ypos=5),
    Element(name="Tin",
            appearance="silvery-white (beta, β) or gray (alpha, α)",
            atomic_mass=118.710u,
            boil=2875.0K,
            category="post-transition metal",
            cpk_hex="#668080",
            density=7.365g/cm^3,
            discovered_by="unknown, before 3500 BC",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p²",
            melt=505.08K,
            molar_heat=27.112J/(mol*K),
            number=50,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 18, 4],
            source="https://en.wikipedia.org/wiki/Tin",
            summary="Tin is a chemical element with the symbol Sn (for Latin:stannum) and atomic number 50. It is a main group metal in group 14 of the periodic table. Tin shows a chemical similarity to both neighboring group-14 elements, germanium and lead, and has two possible oxidation states, +2 and the slightly more stable +4.",
            symbol="Sn",
            xpos=14,
            ypos=5),
    Element(name="Antimony",
            appearance="silvery lustrous gray",
            atomic_mass=121.760u,
            boil=1908.0K,
            category="metalloid",
            cpk_hex="#9e63b5",
            density=6.697g/cm^3,
            discovered_by="unknown, before 3000 BC",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p³",
            melt=903.78K,
            molar_heat=25.23J/(mol*K),
            number=51,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 18, 5],
            source="https://en.wikipedia.org/wiki/Antimony",
            summary="Antimony is a chemical element with symbol Sb (from Latin:stibium) and atomic number 51. A lustrous gray metalloid, it is found in nature mainly as the sulfide mineral stibnite (Sb2S3). Antimony compounds have been known since ancient times and were used for cosmetics; metallic antimony was also known, but it was erroneously identified as lead upon its discovery.",
            symbol="Sb",
            xpos=15,
            ypos=5),
    Element(name="Tellurium",
            atomic_mass=127.60u,
            boil=1261.0K,
            category="metalloid",
            cpk_hex="#d47a00",
            density=6.24g/cm^3,
            discovered_by="Franz-Joseph Müller von Reichenstein",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁴",
            melt=722.66K,
            molar_heat=25.73J/(mol*K),
            number=52,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 18, 6],
            source="https://en.wikipedia.org/wiki/Tellurium",
            summary="Tellurium is a chemical element with symbol Te and atomic number 52. It is a brittle, mildly toxic, rare, silver-white metalloid. Tellurium is chemically related to selenium and sulfur.",
            symbol="Te",
            xpos=16,
            ypos=5),
    Element(name="Iodine",
            appearance="lustrous metallic gray, violet as a gas",
            atomic_mass=126.90447u,
            boil=457.4K,
            category="diatomic nonmetal",
            cpk_hex="#940094",
            density=4.933g/cm^3,
            discovered_by="Bernard Courtois",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁵",
            melt=386.85K,
            number=53,
            period=5,
            phase="Solid",
            shells=[2, 8, 18, 18, 7],
            source="https://en.wikipedia.org/wiki/Iodine",
            summary="Iodine is a chemical element with symbol I and atomic number 53. The name is from Greek ἰοειδής ioeidēs, meaning violet or purple, due to the color of iodine vapor. Iodine and its compounds are primarily used in nutrition, and industrially in the production of acetic acid and certain polymers.",
            symbol="I",
            xpos=17,
            ypos=5),
    Element(name="Xenon",
            appearance="colorless gas, exhibiting a blue glow when placed in a high voltage electric field",
            atomic_mass=131.293u,
            boil=165.051K,
            category="noble gas",
            cpk_hex="#429eb0",
            density=5.894e-3g/cm^3,
            discovered_by="William Ramsay",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶",
            melt=161.4K,
            number=54,
            period=5,
            phase="Gas",
            shells=[2, 8, 18, 18, 8],
            source="https://en.wikipedia.org/wiki/Xenon",
            spectral_img="https://en.wikipedia.org/wiki/File:Xenon_Spectrum.jpg",
            summary="Xenon is a chemical element with symbol Xe and atomic number 54. It is a colorless, dense, odorless noble gas, that occurs in the Earth's atmosphere in trace amounts. Although generally unreactive, xenon can undergo a few chemical reactions such as the formation of xenon hexafluoroplatinate, the first noble gas compound to be synthesized.",
            symbol="Xe",
            xpos=18,
            ypos=5),
    Element(name="Cesium",
            appearance="silvery gold",
            atomic_mass=132.90545196u,
            boil=944.0K,
            category="alkali metal",
            cpk_hex="#57178f",
            density=1.93g/cm^3,
            discovered_by="Robert Bunsen",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s¹",
            melt=301.7K,
            molar_heat=32.21J/(mol*K),
            number=55,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 18, 8, 1],
            source="https://en.wikipedia.org/wiki/Cesium",
            summary="Caesium or cesium is a chemical element with symbol Cs and atomic number 55. It is a soft, silvery-gold alkali metal with a melting point of 28 °C (82 °F), which makes it one of only five elemental metals that are liquid at or near room temperature. Caesium is an alkali metal and has physical and chemical properties similar to those of rubidium and potassium.",
            symbol="Cs",
            xpos=1,
            ypos=6),
    Element(name="Barium",
            atomic_mass=137.327u,
            boil=2118.0K,
            category="alkaline earth metal",
            cpk_hex="#00c900",
            density=3.51g/cm^3,
            discovered_by="Carl Wilhelm Scheele",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s²",
            melt=1000.0K,
            molar_heat=28.07J/(mol*K),
            number=56,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 18, 8, 2],
            source="https://en.wikipedia.org/wiki/Barium",
            summary="Barium is a chemical element with symbol Ba and atomic number 56. It is the fifth element in Group 2, a soft silvery metallic alkaline earth metal. Because of its high chemical reactivity barium is never found in nature as a free element.",
            symbol="Ba",
            xpos=2,
            ypos=6),
    Element(name="Lanthanum",
            appearance="silvery white",
            atomic_mass=138.90547u,
            boil=3737.0K,
            category="lanthanide",
            cpk_hex="#70d4ff",
            density=6.162g/cm^3,
            discovered_by="Carl Gustaf Mosander",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 5d¹",
            melt=1193.0K,
            molar_heat=27.11J/(mol*K),
            number=57,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 18, 9, 2],
            source="https://en.wikipedia.org/wiki/Lanthanum",
            summary="Lanthanum is a soft, ductile, silvery-white metallic chemical element with symbol La and atomic number 57. It tarnishes rapidly when exposed to air and is soft enough to be cut with a knife. It gave its name to the lanthanide series, a group of 15 similar elements between lanthanum and lutetium in the periodic table:it is also sometimes considered the first element of the 6th-period transition metals.",
            symbol="La",
            xpos=3,
            ypos=9),
    Element(name="Cerium",
            appearance="silvery white",
            atomic_mass=140.116u,
            boil=3716.0K,
            category="lanthanide",
            cpk_hex="#ffffc7",
            density=6.77g/cm^3,
            discovered_by="Martin Heinrich Klaproth",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 5d¹ 4f¹",
            melt=1068.0K,
            molar_heat=26.94J/(mol*K),
            number=58,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 19, 9, 2],
            source="https://en.wikipedia.org/wiki/Cerium",
            summary="Cerium is a chemical element with symbol Ce and atomic number 58. It is a soft, silvery, ductile metal which easily oxidizes in air. Cerium was named after the dwarf planet Ceres (itself named after the Roman goddess of agriculture).",
            symbol="Ce",
            xpos=4,
            ypos=9),
    Element(name="Praseodymium",
            appearance="grayish white",
            atomic_mass=140.90766u,
            boil=3403.0K,
            category="lanthanide",
            cpk_hex="#d9ffc7",
            density=6.77g/cm^3,
            discovered_by="Carl Auer von Welsbach",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f³",
            melt=1208.0K,
            molar_heat=27.2J/(mol*K),
            number=59,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 21, 8, 2],
            source="https://en.wikipedia.org/wiki/Praseodymium",
            summary="Praseodymium is a chemical element with symbol Pr and atomic number 59. Praseodymium is a soft, silvery, malleable and ductile metal in the lanthanide group. It is valued for its magnetic, electrical, chemical, and optical properties.",
            symbol="Pr",
            xpos=5,
            ypos=9),
    Element(name="Neodymium",
            appearance="silvery white",
            atomic_mass=144.242u,
            boil=3347.0K,
            category="lanthanide",
            cpk_hex="#c7ffc7",
            density=7.01g/cm^3,
            discovered_by="Carl Auer von Welsbach",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁴",
            melt=1297.0K,
            molar_heat=27.45J/(mol*K),
            number=60,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 22, 8, 2],
            source="https://en.wikipedia.org/wiki/Neodymium",
            summary="Neodymium is a chemical element with symbol Nd and atomic number 60. It is a soft silvery metal that tarnishes in air. Neodymium was discovered in 1885 by the Austrian chemist Carl Auer von Welsbach.",
            symbol="Nd",
            xpos=6,
            ypos=9),
    Element(name="Promethium",
            appearance="metallic",
            atomic_mass=145.0u,
            boil=3273.0K,
            category="lanthanide",
            cpk_hex="#a3ffc7",
            density=7.26g/cm^3,
            discovered_by="Chien Shiung Wu",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁵",
            melt=1315.0K,
            named_by="Isotopes of promethium",
            number=61,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 23, 8, 2],
            source="https://en.wikipedia.org/wiki/Promethium",
            summary="Promethium, originally prometheum, is a chemical element with the symbol Pm and atomic number 61. All of its isotopes are radioactive; it is one of only two such elements that are followed in the periodic table by elements with stable forms, a distinction shared with technetium. Chemically, promethium is a lanthanide, which forms salts when combined with other elements.",
            symbol="Pm",
            xpos=7,
            ypos=9),
    Element(name="Samarium",
            appearance="silvery white",
            atomic_mass=150.36u,
            boil=2173.0K,
            category="lanthanide",
            cpk_hex="#8fffc7",
            density=7.52g/cm^3,
            discovered_by="Lecoq de Boisbaudran",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁶",
            melt=1345.0K,
            molar_heat=29.54J/(mol*K),
            number=62,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 24, 8, 2],
            source="https://en.wikipedia.org/wiki/Samarium",
            summary="Samarium is a chemical element with symbol Sm and atomic number 62. It is a moderately hard silvery metal that readily oxidizes in air. Being a typical member of the lanthanide series, samarium usually assumes the oxidation state +3.",
            symbol="Sm",
            xpos=8,
            ypos=9),
    Element(name="Europium",
            atomic_mass=151.964u,
            boil=1802.0K,
            category="lanthanide",
            cpk_hex="#61ffc7",
            density=5.264g/cm^3,
            discovered_by="Eugène-Anatole Demarçay",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁷",
            melt=1099.0K,
            molar_heat=27.66J/(mol*K),
            number=63,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 25, 8, 2],
            source="https://en.wikipedia.org/wiki/Europium",
            summary="Europium is a chemical element with symbol Eu and atomic number 63. It was isolated in 1901 and is named after the continent of Europe. It is a moderately hard, silvery metal which readily oxidizes in air and water.",
            symbol="Eu",
            xpos=9,
            ypos=9),
    Element(name="Gadolinium",
            appearance="silvery white",
            atomic_mass=157.25u,
            boil=3273.0K,
            category="lanthanide",
            cpk_hex="#45ffc7",
            density=7.9g/cm^3,
            discovered_by="Jean Charles Galissard de Marignac",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁷ 5d¹",
            melt=1585.0K,
            molar_heat=37.03J/(mol*K),
            number=64,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 25, 9, 2],
            source="https://en.wikipedia.org/wiki/Gadolinium",
            summary="Gadolinium is a chemical element with symbol Gd and atomic number 64. It is a silvery-white, malleable and ductile rare-earth metal. It is found in nature only in combined (salt) form.",
            symbol="Gd",
            xpos=10,
            ypos=9),
    Element(name="Terbium",
            appearance="silvery white",
            atomic_mass=158.925354u,
            boil=3396.0K,
            category="lanthanide",
            cpk_hex="#30ffc7",
            density=8.23g/cm^3,
            discovered_by="Carl Gustaf Mosander",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁹",
            melt=1629.0K,
            molar_heat=28.91J/(mol*K),
            number=65,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 27, 8, 2],
            source="https://en.wikipedia.org/wiki/Terbium",
            summary="Terbium is a chemical element with symbol Tb and atomic number 65. It is a silvery-white rare earth metal that is malleable, ductile and soft enough to be cut with a knife. Terbium is never found in nature as a free element, but it is contained in many minerals, including cerite, gadolinite, monazite, xenotime and euxenite.",
            symbol="Tb",
            xpos=11,
            ypos=9),
    Element(name="Dysprosium",
            appearance="silvery white",
            atomic_mass=162.500u,
            boil=2840.0K,
            category="lanthanide",
            cpk_hex="#1fffc7",
            density=8.54g/cm^3,
            discovered_by="Lecoq de Boisbaudran",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁰",
            melt=1680.0K,
            molar_heat=27.7J/(mol*K),
            number=66,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 28, 8, 2],
            source="https://en.wikipedia.org/wiki/Dysprosium",
            summary="Dysprosium is a chemical element with the symbol Dy and atomic number 66. It is a rare earth element with a metallic silver luster. Dysprosium is never found in nature as a free element, though it is found in various minerals, such as xenotime.",
            symbol="Dy",
            xpos=12,
            ypos=9),
    Element(name="Holmium",
            appearance="silvery white",
            atomic_mass=164.930329u,
            boil=2873.0K,
            category="lanthanide",
            cpk_hex="#00ff9c",
            density=8.79g/cm^3,
            discovered_by="Marc Delafontaine",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹¹",
            melt=1734.0K,
            molar_heat=27.15J/(mol*K),
            number=67,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 29, 8, 2],
            source="https://en.wikipedia.org/wiki/Holmium",
            summary="Holmium is a chemical element with symbol Ho and atomic number 67. Part of the lanthanide series, holmium is a rare earth element. Holmium was discovered by Swedish chemist Per Theodor Cleve.",
            symbol="Ho",
            xpos=13,
            ypos=9),
    Element(name="Erbium",
            appearance="silvery white",
            atomic_mass=167.259u,
            boil=3141.0K,
            category="lanthanide",
            cpk_hex="#00e675",
            density=9.066g/cm^3,
            discovered_by="Carl Gustaf Mosander",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹²",
            melt=1802.0K,
            molar_heat=28.12J/(mol*K),
            number=68,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 30, 8, 2],
            source="https://en.wikipedia.org/wiki/Erbium",
            summary="Erbium is a chemical element in the lanthanide series, with symbol Er and atomic number 68. A silvery-white solid metal when artificially isolated, natural erbium is always found in chemical combination with other elements on Earth. As such, it is a rare earth element which is associated with several other rare elements in the mineral gadolinite from Ytterby in Sweden, where yttrium, ytterbium, and terbium were discovered.",
            symbol="Er",
            xpos=14,
            ypos=9),
    Element(name="Thulium",
            appearance="silvery gray",
            atomic_mass=168.934219u,
            boil=2223.0K,
            category="lanthanide",
            cpk_hex="#00d452",
            density=9.32g/cm^3,
            discovered_by="Per Teodor Cleve",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹³",
            melt=1818.0K,
            molar_heat=27.03J/(mol*K),
            number=69,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 31, 8, 2],
            source="https://en.wikipedia.org/wiki/Thulium",
            summary="Thulium is a chemical element with symbol Tm and atomic number 69. It is the thirteenth and antepenultimate (third-last) element in the lanthanide series. Like the other lanthanides, the most common oxidation state is +3, seen in its oxide, halides and other compounds.",
            symbol="Tm",
            xpos=15,
            ypos=9),
    Element(name="Ytterbium",
            atomic_mass=173.045u,
            boil=1469.0K,
            category="lanthanide",
            cpk_hex="#00bf38",
            density=6.9g/cm^3,
            discovered_by="Jean Charles Galissard de Marignac",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴",
            melt=1097.0K,
            molar_heat=26.74J/(mol*K),
            number=70,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 8, 2],
            source="https://en.wikipedia.org/wiki/Ytterbium",
            summary="Ytterbium is a chemical element with symbol Yb and atomic number 70. It is the fourteenth and penultimate element in the lanthanide series, which is the basis of the relative stability of its +2 oxidation state. However, like the other lanthanides, its most common oxidation state is +3, seen in its oxide, halides and other compounds.",
            symbol="Yb",
            xpos=16,
            ypos=9),
    Element(name="Lutetium",
            appearance="silvery white",
            atomic_mass=174.9668u,
            boil=3675.0K,
            category="lanthanide",
            cpk_hex="#00ab24",
            density=9.841g/cm^3,
            discovered_by="Georges Urbain",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹",
            melt=1925.0K,
            molar_heat=26.86J/(mol*K),
            number=71,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 9, 2],
            source="https://en.wikipedia.org/wiki/Lutetium",
            summary="Lutetium is a chemical element with symbol Lu and atomic number 71. It is a silvery white metal, which resists corrosion in dry, but not in moist air. It is considered the first element of the 6th-period transition metals and the last element in the lanthanide series, and is traditionally counted among the rare earths.",
            symbol="Lu",
            xpos=17,
            ypos=9),
    Element(name="Hafnium",
            appearance="steel gray",
            atomic_mass=178.486u,
            boil=4876.0K,
            category="transition metal",
            cpk_hex="#4dc2ff",
            density=13.31g/cm^3,
            discovered_by="Dirk Coster",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d²",
            melt=2506.0K,
            molar_heat=25.73J/(mol*K),
            number=72,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 10, 2],
            source="https://en.wikipedia.org/wiki/Hafnium",
            spectral_img="https://en.wikipedia.org/wiki/File:Hafnium_spectrum_visible.png",
            summary="Hafnium is a chemical element with symbol Hf and atomic number 72. A lustrous, silvery gray, tetravalent transition metal, hafnium chemically resembles zirconium and is found in zirconium minerals. Its existence was predicted by Dmitri Mendeleev in 1869, though it was not identified until 1923, making it the penultimate stable element to be discovered (rhenium was identified two years later).",
            symbol="Hf",
            xpos=4,
            ypos=6),
    Element(name="Tantalum",
            appearance="gray blue",
            atomic_mass=180.94788u,
            boil=5731.0K,
            category="transition metal",
            cpk_hex="#4da6ff",
            density=16.69g/cm^3,
            discovered_by="Anders Gustaf Ekeberg",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d³",
            melt=3290.0K,
            molar_heat=25.36J/(mol*K),
            number=73,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 11, 2],
            source="https://en.wikipedia.org/wiki/Tantalum",
            spectral_img="https://en.wikipedia.org/wiki/File:Tantalum_spectrum_visible.png",
            summary="Tantalum is a chemical element with symbol Ta and atomic number 73. Previously known as tantalium, its name comes from Tantalus, an antihero from Greek mythology. Tantalum is a rare, hard, blue-gray, lustrous transition metal that is highly corrosion-resistant.",
            symbol="Ta",
            xpos=5,
            ypos=6),
    Element(name="Tungsten",
            appearance="grayish white, lustrous",
            atomic_mass=183.84u,
            boil=6203.0K,
            category="transition metal",
            cpk_hex="#2194d6",
            density=19.25g/cm^3,
            discovered_by="Carl Wilhelm Scheele",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d⁴",
            melt=3695.0K,
            molar_heat=24.27J/(mol*K),
            number=74,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 12, 2],
            source="https://en.wikipedia.org/wiki/Tungsten",
            summary="Tungsten, also known as wolfram, is a chemical element with symbol W and atomic number 74. The word tungsten comes from the Swedish language tung sten, which directly translates to heavy stone. Its name in Swedish is volfram, however, in order to distinguish it from scheelite, which in Swedish is alternatively named tungsten.",
            symbol="W",
            xpos=6,
            ypos=6),
    Element(name="Rhenium",
            appearance="silvery-grayish",
            atomic_mass=186.207u,
            boil=5869.0K,
            category="transition metal",
            cpk_hex="#267dab",
            density=21.02g/cm^3,
            discovered_by="Masataka Ogawa",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d⁵",
            melt=3459.0K,
            molar_heat=25.48J/(mol*K),
            named_by="Walter Noddack",
            number=75,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 13, 2],
            source="https://en.wikipedia.org/wiki/Rhenium",
            summary="Rhenium is a chemical element with symbol Re and atomic number 75. It is a silvery-white, heavy, third-row transition metal in group 7 of the periodic table. With an estimated average concentration of 1 part per billion (ppb), rhenium is one of the rarest elements in the Earth's crust.",
            symbol="Re",
            xpos=7,
            ypos=6),
    Element(name="Osmium",
            appearance="silvery, blue cast",
            atomic_mass=190.23u,
            boil=5285.0K,
            category="transition metal",
            cpk_hex="#266696",
            density=22.59g/cm^3,
            discovered_by="Smithson Tennant",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d⁶",
            melt=3306.0K,
            molar_heat=24.7J/(mol*K),
            number=76,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 14, 2],
            source="https://en.wikipedia.org/wiki/Osmium",
            summary="Osmium (from Greek osme (ὀσμή) meaning \"smell\") is a chemical element with symbol Os and atomic number 76. It is a hard, brittle, bluish-white transition metal in the platinum group that is found as a trace element in alloys, mostly in platinum ores. Osmium is the densest naturally occurring element, with a density of 22.59 g/cm3.",
            symbol="Os",
            xpos=8,
            ypos=6),
    Element(name="Iridium",
            appearance="silvery white",
            atomic_mass=192.217u,
            boil=4403.0K,
            category="transition metal",
            cpk_hex="#175487",
            density=22.56g/cm^3,
            discovered_by="Smithson Tennant",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d⁷",
            melt=2719.0K,
            molar_heat=25.1J/(mol*K),
            number=77,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 15, 2],
            source="https://en.wikipedia.org/wiki/Iridium",
            summary="Iridium is a chemical element with symbol Ir and atomic number 77. A very hard, brittle, silvery-white transition metal of the platinum group, iridium is generally credited with being the second densest element (after osmium) based on measured density, although calculations involving the space lattices of the elements show that iridium is denser. It is also the most corrosion-resistant metal, even at temperatures as high as 2000 °C. Although only certain molten salts and halogens are corrosive to solid iridium, finely divided iridium dust is much more reactive and can be flammable.",
            symbol="Ir",
            xpos=9,
            ypos=6),
    Element(name="Platinum",
            appearance="silvery white",
            atomic_mass=195.084u,
            boil=4098.0K,
            category="transition metal",
            cpk_hex="#d0d0e0",
            density=21.45g/cm^3,
            discovered_by="Antonio de Ulloa",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d⁹",
            melt=2041.4K,
            molar_heat=25.86J/(mol*K),
            number=78,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 17, 1],
            source="https://en.wikipedia.org/wiki/Platinum",
            summary="Platinum is a chemical element with symbol Pt and atomic number 78. It is a dense, malleable, ductile, highly unreactive, precious, gray-white transition metal. Its name is derived from the Spanish term platina, which is literally translated into \"little silver\".",
            symbol="Pt",
            xpos=10,
            ypos=6),
    Element(name="Gold",
            appearance="metallic yellow",
            atomic_mass=196.966570u,
            boil=3243.0K,
            category="transition metal",
            cpk_hex="#ffd123",
            density=19.3g/cm^3,
            discovered_by="Middle East",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s¹ 4f¹⁴ 5d¹⁰",
            melt=1337.33K,
            molar_heat=25.418J/(mol*K),
            number=79,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 18, 1],
            source="https://en.wikipedia.org/wiki/Gold",
            summary="Gold is a chemical element with symbol Au (from Latin:aurum) and atomic number 79. In its purest form, it is a bright, slightly reddish yellow, dense, soft, malleable and ductile metal. Chemically, gold is a transition metal and a group 11 element.",
            symbol="Au",
            xpos=11,
            ypos=6),
    Element(name="Mercury",
            appearance="silvery",
            atomic_mass=200.592u,
            boil=629.88K,
            category="transition metal",
            cpk_hex="#b8b8d0",
            density=13.534g/cm^3,
            discovered_by="unknown, before 2000 BCE",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰",
            melt=234.321K,
            molar_heat=27.983J/(mol*K),
            number=80,
            period=6,
            phase="Liquid",
            shells=[2, 8, 18, 32, 18, 2],
            source="https://en.wikipedia.org/wiki/Mercury (Element)",
            summary="Mercury is a chemical element with symbol Hg and atomic number 80. It is commonly known as quicksilver and was formerly named hydrargyrum (/haɪˈdrɑːrdʒərəm/). A heavy, silvery d-block element, mercury is the only metallic element that is liquid at standard conditions for temperature and pressure; the only other element that is liquid under these conditions is bromine, though metals such as caesium, gallium, and rubidium melt just above room temperature.",
            symbol="Hg",
            xpos=12,
            ypos=6),
    Element(name="Thallium",
            appearance="silvery white",
            atomic_mass=204.38u,
            boil=1746.0K,
            category="post-transition metal",
            cpk_hex="#a6544d",
            density=11.85g/cm^3,
            discovered_by="William Crookes",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p¹",
            melt=577.0K,
            molar_heat=26.32J/(mol*K),
            number=81,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 18, 3],
            source="https://en.wikipedia.org/wiki/Thallium",
            summary="Thallium is a chemical element with symbol Tl and atomic number 81. This soft gray post-transition metal is not found free in nature. When isolated, it resembles tin, but discolors when exposed to air.",
            symbol="Tl",
            xpos=13,
            ypos=6),
    Element(name="Lead",
            appearance="metallic gray",
            atomic_mass=207.2u,
            boil=2022.0K,
            category="post-transition metal",
            cpk_hex="#575961",
            density=11.34g/cm^3,
            discovered_by="Middle East",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p²",
            melt=600.61K,
            molar_heat=26.65J/(mol*K),
            number=82,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 18, 4],
            source="https://en.wikipedia.org/wiki/Lead_(element)",
            summary="Lead (/lɛd/) is a chemical element in the carbon group with symbol Pb (from Latin:plumbum) and atomic number 82. Lead is a soft, malleable and heavy post-transition metal. Metallic lead has a bluish-white color after being freshly cut, but it soon tarnishes to a dull grayish color when exposed to air.",
            symbol="Pb",
            xpos=14,
            ypos=6),
    Element(name="Bismuth",
            appearance="lustrous silver",
            atomic_mass=208.98040u,
            boil=1837.0K,
            category="post-transition metal",
            cpk_hex="#9e4fb5",
            density=9.78g/cm^3,
            discovered_by="Claude François Geoffroy",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p³",
            melt=544.7K,
            molar_heat=25.52J/(mol*K),
            number=83,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 18, 5],
            source="https://en.wikipedia.org/wiki/Bismuth",
            summary="Bismuth is a chemical element with symbol Bi and atomic number 83. Bismuth, a pentavalent post-transition metal, chemically resembles arsenic and antimony. Elemental bismuth may occur naturally, although its sulfide and oxide form important commercial ores.",
            symbol="Bi",
            xpos=15,
            ypos=6),
    Element(name="Polonium",
            appearance="silvery",
            atomic_mass=209.0u,
            boil=1235.0K,
            category="post-transition metal",
            cpk_hex="#ab5c00",
            density=9.196g/cm^3,
            discovered_by="Pierre Curie",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁴",
            melt=527.0K,
            molar_heat=26.4J/(mol*K),
            number=84,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 18, 6],
            source="https://en.wikipedia.org/wiki/Polonium",
            summary="Polonium is a chemical element with symbol Po and atomic number 84, discovered in 1898 by Marie Curie and Pierre Curie. A rare and highly radioactive element with no stable isotopes, polonium is chemically similar to bismuth and tellurium, and it occurs in uranium ores. Applications of polonium are few.",
            symbol="Po",
            xpos=16,
            ypos=6),
    Element(name="Astatine",
            appearance="unknown, probably metallic",
            atomic_mass=210.0u,
            boil=610.0K,
            category="metalloid",
            cpk_hex="#754f45",
            density=26.35g/cm^3,
            discovered_by="Dale R. Corson",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁵",
            melt=575.0K,
            number=85,
            period=6,
            phase="Solid",
            shells=[2, 8, 18, 32, 18, 7],
            source="https://en.wikipedia.org/wiki/Astatine",
            summary="Astatine is a very rare radioactive chemical element with the chemical symbol At and atomic number 85. It occurs on Earth as the decay product of various heavier elements. All its isotopes are short-lived; the most stable is astatine-210, with a half-life of 8.1 hours.",
            symbol="At",
            xpos=17,
            ypos=6),
    Element(name="Radon",
            appearance="colorless gas, occasionally glows green or red in discharge tubes",
            atomic_mass=222.0u,
            boil=211.5K,
            category="noble gas",
            cpk_hex="#428296",
            density=9.73e-3g/cm^3,
            discovered_by="Friedrich Ernst Dorn",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶",
            melt=202.0K,
            number=86,
            period=6,
            phase="Gas",
            shells=[2, 8, 18, 32, 18, 8],
            source="https://en.wikipedia.org/wiki/Radon",
            spectral_img="https://en.wikipedia.org/wiki/File:Radon_spectrum.png",
            summary="Radon is a chemical element with symbol Rn and atomic number 86. It is a radioactive, colorless, odorless, tasteless noble gas, occurring naturally as a decay product of radium. Its most stable isotope, 222Rn, has a half-life of 3.8 days.",
            symbol="Rn",
            xpos=18,
            ypos=6),
    Element(name="Francium",
            atomic_mass=223.0u,
            boil=950.0K,
            category="alkali metal",
            cpk_hex="#420066",
            density=1.87g/cm^3,
            discovered_by="Marguerite Perey",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s¹",
            melt=300.0K,
            number=87,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 18, 8, 1],
            source="https://en.wikipedia.org/wiki/Francium",
            summary="Francium is a chemical element with symbol Fr and atomic number 87. It used to be known as eka-caesium and actinium K. It is the second-least electronegative element, behind only caesium. Francium is a highly radioactive metal that decays into astatine, radium, and radon.",
            symbol="Fr",
            xpos=1,
            ypos=7),
    Element(name="Radium",
            appearance="silvery white metallic",
            atomic_mass=226.0u,
            boil=2010.0K,
            category="alkaline earth metal",
            cpk_hex="#007d00",
            density=5.5g/cm^3,
            discovered_by="Pierre Curie",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s²",
            melt=1233.0K,
            number=88,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 18, 8, 2],
            source="https://en.wikipedia.org/wiki/Radium",
            summary="Radium is a chemical element with symbol Ra and atomic number 88. It is the sixth element in group 2 of the periodic table, also known as the alkaline earth metals. Pure radium is almost colorless, but it readily combines with nitrogen (rather than oxygen) on exposure to air, forming a black surface layer of radium nitride (Ra3N2).",
            symbol="Ra",
            xpos=2,
            ypos=7),
    Element(name="Actinium",
            atomic_mass=227.0u,
            boil=3500.0K,
            category="actinide",
            cpk_hex="#70abfa",
            density=10.0g/cm^3,
            discovered_by="Friedrich Oskar Giesel",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 6d¹",
            melt=1500.0K,
            molar_heat=27.2J/(mol*K),
            number=89,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 18, 9, 2],
            source="https://en.wikipedia.org/wiki/Actinium",
            summary="Actinium is a radioactive chemical element with symbol Ac (not to be confused with the abbreviation for an acetyl group) and atomic number 89, which was discovered in 1899. It was the first non-primordial radioactive element to be isolated. Polonium, radium and radon were observed before actinium, but they were not isolated until 1902.",
            symbol="Ac",
            xpos=3,
            ypos=10),
    Element(name="Thorium",
            appearance="silvery, often with black tarnish",
            atomic_mass=232.0377u,
            boil=5061.0K,
            category="actinide",
            cpk_hex="#00baff",
            density=11.724g/cm^3,
            discovered_by="Jöns Jakob Berzelius",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 6d²",
            melt=2023.0K,
            molar_heat=26.23J/(mol*K),
            number=90,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 18, 10, 2],
            source="https://en.wikipedia.org/wiki/Thorium",
            summary="Thorium is a chemical element with symbol Th and atomic number 90. A radioactive actinide metal, thorium is one of only two significantly radioactive elements that still occur naturally in large quantities as a primordial element (the other being uranium). It was discovered in 1828 by the Norwegian Reverend and amateur mineralogist Morten Thrane Esmark and identified by the Swedish chemist Jöns Jakob Berzelius, who named it after Thor, the Norse god of thunder.",
            symbol="Th",
            xpos=4,
            ypos=10),
    Element(name="Protactinium",
            appearance="bright, silvery metallic luster",
            atomic_mass=231.03588u,
            boil=4300.0K,
            category="actinide",
            cpk_hex="#00a1ff",
            density=15.37g/cm^3,
            discovered_by="William Crookes",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f² 6d¹",
            melt=1841.0K,
            named_by="Otto Hahn",
            number=91,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 20, 9, 2],
            source="https://en.wikipedia.org/wiki/Protactinium",
            summary="Protactinium is a chemical element with symbol Pa and atomic number 91. It is a dense, silvery-gray metal which readily reacts with oxygen, water vapor and inorganic acids. It forms various chemical compounds where protactinium is usually present in the oxidation state +5, but can also assume +4 and even +2 or +3 states.",
            symbol="Pa",
            xpos=5,
            ypos=10),
    Element(name="Uranium",
            atomic_mass=238.02891u,
            boil=4404.0K,
            category="actinide",
            cpk_hex="#008fff",
            density=19.1g/cm^3,
            discovered_by="Martin Heinrich Klaproth",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f³ 6d¹",
            melt=1405.3K,
            molar_heat=27.665J/(mol*K),
            number=92,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 21, 9, 2],
            source="https://en.wikipedia.org/wiki/Uranium",
            summary="Uranium is a chemical element with symbol U and atomic number 92. It is a silvery-white metal in the actinide series of the periodic table. A uranium atom has 92 protons and 92 electrons, of which 6 are valence electrons.",
            symbol="U",
            xpos=6,
            ypos=10),
    Element(name="Neptunium",
            appearance="silvery metallic",
            atomic_mass=237.0u,
            boil=4447.0K,
            category="actinide",
            cpk_hex="#0080ff",
            density=20.45g/cm^3,
            discovered_by="Edwin McMillan",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f⁴ 6d¹",
            melt=912.0K,
            molar_heat=29.46J/(mol*K),
            number=93,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 22, 9, 2],
            source="https://en.wikipedia.org/wiki/Neptunium",
            summary="Neptunium is a chemical element with symbol Np and atomic number 93. A radioactive actinide metal, neptunium is the first transuranic element. Its position in the periodic table just after uranium, named after the planet Uranus, led to it being named after Neptune, the next planet beyond Uranus.",
            symbol="Np",
            xpos=7,
            ypos=10),
    Element(name="Plutonium",
            appearance="silvery white, tarnishing to dark gray in air",
            atomic_mass=244.0u,
            boil=3505.0K,
            category="actinide",
            cpk_hex="#006bff",
            density=19.816g/cm^3,
            discovered_by="Glenn T. Seaborg",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f⁶",
            melt=912.5K,
            molar_heat=35.5J/(mol*K),
            number=94,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 24, 8, 2],
            source="https://en.wikipedia.org/wiki/Plutonium",
            summary="Plutonium is a transuranic radioactive chemical element with symbol Pu and atomic number 94. It is an actinide metal of silvery-gray appearance that tarnishes when exposed to air, and forms a dull coating when oxidized. The element normally exhibits six allotropes and four oxidation states.",
            symbol="Pu",
            xpos=8,
            ypos=10),
    Element(name="Americium",
            appearance="silvery white",
            atomic_mass=243.0u,
            boil=2880.0K,
            category="actinide",
            cpk_hex="#545cf2",
            density=12.0g/cm^3,
            discovered_by="Glenn T. Seaborg",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f⁷",
            melt=1449.0K,
            molar_heat=62.7J/(mol*K),
            number=95,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 25, 8, 2],
            source="https://en.wikipedia.org/wiki/Americium",
            spectral_img="https://en.wikipedia.org/wiki/File:Americium_spectrum_visible.png",
            summary="Americium is a radioactive transuranic chemical element with symbol Am and atomic number 95. This member of the actinide series is located in the periodic table under the lanthanide element europium, and thus by analogy was named after the Americas. Americium was first produced in 1944 by the group of Glenn T.Seaborg from Berkeley, California, at the metallurgical laboratory of University of Chicago.",
            symbol="Am",
            xpos=9,
            ypos=10),
    Element(name="Curium",
            appearance="silvery metallic, glows purple in the dark",
            atomic_mass=247.0u,
            boil=3383.0K,
            category="actinide",
            cpk_hex="#785ce3",
            density=13.51g/cm^3,
            discovered_by="Glenn T. Seaborg",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f⁷ 6d¹",
            melt=1613.0K,
            number=96,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 25, 9, 2],
            source="https://en.wikipedia.org/wiki/Curium",
            summary="Curium is a transuranic radioactive chemical element with symbol Cm and atomic number 96. This element of the actinide series was named after Marie and Pierre Curie – both were known for their research on radioactivity. Curium was first intentionally produced and identified in July 1944 by the group of Glenn T. Seaborg at the University of California, Berkeley.",
            symbol="Cm",
            xpos=10,
            ypos=10),
    Element(name="Berkelium",
            appearance="silvery",
            atomic_mass=247.0u,
            boil=2900.0K,
            category="actinide",
            cpk_hex="#8a4fe3",
            density=14.78g/cm^3,
            discovered_by="Lawrence Berkeley National Laboratory",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f⁹",
            melt=1259.0K,
            number=97,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 27, 8, 2],
            source="https://en.wikipedia.org/wiki/Berkelium",
            summary="Berkelium is a transuranic radioactive chemical element with symbol Bk and atomic number 97. It is a member of the actinide and transuranium element series. It is named after the city of Berkeley, California, the location of the University of California Radiation Laboratory where it was discovered in December 1949.",
            symbol="Bk",
            xpos=11,
            ypos=10),
    Element(name="Californium",
            appearance="silvery",
            atomic_mass=251.0u,
            boil=1743.0K,
            category="actinide",
            cpk_hex="#a136d4",
            density=15.1g/cm^3,
            discovered_by="Lawrence Berkeley National Laboratory",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁰",
            melt=1173.0K,
            number=98,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 28, 8, 2],
            source="https://en.wikipedia.org/wiki/Californium",
            summary="Californium is a radioactive metallic chemical element with symbol Cf and atomic number 98. The element was first made in 1950 at the University of California Radiation Laboratory in Berkeley, by bombarding curium with alpha particles (helium-4 ions). It is an actinide element, the sixth transuranium element to be synthesized, and has the second-highest atomic mass of all the elements that have been produced in amounts large enough to see with the unaided eye (after einsteinium).",
            symbol="Cf",
            xpos=12,
            ypos=10),
    Element(name="Einsteinium",
            appearance="silver-colored",
            atomic_mass=252.0u,
            boil=1269.0K,
            category="actinide",
            cpk_hex="#b31fd4",
            density=8.84g/cm^3,
            discovered_by="Lawrence Berkeley National Laboratory",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹¹",
            melt=1133.0K,
            number=99,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 29, 8, 2],
            source="https://en.wikipedia.org/wiki/Einsteinium",
            summary="Einsteinium is a synthetic element with symbol Es and atomic number 99. It is the seventh transuranic element, and an actinide. Einsteinium was discovered as a component of the debris of the first hydrogen bomb explosion in 1952, and named after Albert Einstein.",
            symbol="Es",
            xpos=13,
            ypos=10),
    Element(name="Fermium",
            atomic_mass=257.0u,
            category="actinide",
            cpk_hex="#b31fba",
            discovered_by="Lawrence Berkeley National Laboratory",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹²",
            melt=1800.0K,
            number=100,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 30, 8, 2],
            source="https://en.wikipedia.org/wiki/Fermium",
            summary="Fermium is a synthetic element with symbol Fm and atomic number 100. It is a member of the actinide series. It is the heaviest element that can be formed by neutron bombardment of lighter elements, and hence the last element that can be prepared in macroscopic quantities, although pure fermium metal has not yet been prepared.",
            symbol="Fm",
            xpos=14,
            ypos=10),
    Element(name="Mendelevium",
            atomic_mass=258.0u,
            category="actinide",
            cpk_hex="#b30da6",
            discovered_by="Lawrence Berkeley National Laboratory",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹³",
            melt=1100.0K,
            number=101,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 31, 8, 2],
            source="https://en.wikipedia.org/wiki/Mendelevium",
            summary="Mendelevium is a synthetic element with chemical symbol Md (formerly Mv) and atomic number 101. A metallic radioactive transuranic element in the actinide series, it is the first element that currently cannot be produced in macroscopic quantities through neutron bombardment of lighter elements. It is the antepenultimate actinide and the ninth transuranic element.",
            symbol="Md",
            xpos=15,
            ypos=10),
    Element(name="Nobelium",
            atomic_mass=259.0u,
            category="actinide",
            cpk_hex="#bd0d87",
            discovered_by="Joint Institute for Nuclear Research",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴",
            melt=1100.0K,
            number=102,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 8, 2],
            source="https://en.wikipedia.org/wiki/Nobelium",
            summary="Nobelium is a synthetic chemical element with symbol No and atomic number 102. It is named in honor of Alfred Nobel, the inventor of dynamite and benefactor of science. A radioactive metal, it is the tenth transuranic element and is the penultimate member of the actinide series.",
            symbol="No",
            xpos=16,
            ypos=10),
    Element(name="Lawrencium",
            atomic_mass=262.0u,
            category="actinide",
            cpk_hex="#c70066",
            discovered_by="Lawrence Berkeley National Laboratory",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 7p¹",
            melt=1900.0K,
            number=103,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 8, 3],
            source="https://en.wikipedia.org/wiki/Lawrencium",
            summary="Lawrencium is a synthetic chemical element with chemical symbol Lr (formerly Lw) and atomic number 103. It is named in honor of Ernest Lawrence, inventor of the cyclotron, a device that was used to discover many artificial radioactive elements. A radioactive metal, lawrencium is the eleventh transuranic element and is also the final member of the actinide series.",
            symbol="Lr",
            xpos=17,
            ypos=10),
    Element(name="Rutherfordium",
            atomic_mass=267.0u,
            boil=5800.0K,
            category="transition metal",
            cpk_hex="#cc0059",
            density=23.2g/cm^3,
            discovered_by="Joint Institute for Nuclear Research",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d²",
            melt=2400.0K,
            number=104,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 10, 2],
            source="https://en.wikipedia.org/wiki/Rutherfordium",
            summary="Rutherfordium is a chemical element with symbol Rf and atomic number 104, named in honor of physicist Ernest Rutherford. It is a synthetic element (an element that can be created in a laboratory but is not found in nature) and radioactive; the most stable known isotope, 267Rf, has a half-life of approximately 1.3 hours. In the periodic table of the elements, it is a d - block element and the second of the fourth - row transition elements.",
            symbol="Rf",
            xpos=4,
            ypos=7),
    Element(name="Dubnium",
            atomic_mass=270.0u,
            category="transition metal",
            cpk_hex="#d1004f",
            density=29.3g/cm^3,
            discovered_by="Joint Institute for Nuclear Research",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d³",
            number=105,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 11, 2],
            source="https://en.wikipedia.org/wiki/Dubnium",
            summary="Dubnium is a chemical element with symbol Db and atomic number 105. It is named after the town of Dubna in Russia (north of Moscow), where it was first produced. It is a synthetic element (an element that can be created in a laboratory but is not found in nature) and radioactive; the most stable known isotope, dubnium-268, has a half-life of approximately 28 hours.",
            symbol="Db",
            xpos=5,
            ypos=7),
    Element(name="Seaborgium",
            atomic_mass=269.0u,
            category="transition metal",
            cpk_hex="#d90045",
            density=35.0g/cm^3,
            discovered_by="Lawrence Berkeley National Laboratory",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁴",
            number=106,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 12, 2],
            source="https://en.wikipedia.org/wiki/Seaborgium",
            summary="Seaborgium is a synthetic element with symbol Sg and atomic number 106. Its most stable isotope 271Sg has a half-life of 1.9 minutes. A more recently discovered isotope 269Sg has a potentially slightly longer half-life (ca.",
            symbol="Sg",
            xpos=6,
            ypos=7),
    Element(name="Bohrium",
            atomic_mass=270.0u,
            category="transition metal",
            cpk_hex="#e00038",
            density=37.1g/cm^3,
            discovered_by="Gesellschaft für Schwerionenforschung",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁵",
            number=107,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 13, 2],
            source="https://en.wikipedia.org/wiki/Bohrium",
            summary="Bohrium is a chemical element with symbol Bh and atomic number 107. It is named after Danish physicist Niels Bohr. It is a synthetic element (an element that can be created in a laboratory but is not found in nature) and radioactive; the most stable known isotope, 270Bh, has a half-life of approximately 61 seconds.",
            symbol="Bh",
            xpos=7,
            ypos=7),
    Element(name="Hassium",
            atomic_mass=270.0u,
            category="transition metal",
            cpk_hex="#e6002e",
            density=40.7g/cm^3,
            discovered_by="Gesellschaft für Schwerionenforschung",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁶",
            melt=126.0K,
            number=108,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 14, 2],
            source="https://en.wikipedia.org/wiki/Hassium",
            summary="Hassium is a chemical element with symbol Hs and atomic number 108, named after the German state of Hesse. It is a synthetic element (an element that can be created in a laboratory but is not found in nature) and radioactive; the most stable known isotope, 269Hs, has a half-life of approximately 9.7 seconds, although an unconfirmed metastable state, 277mHs, may have a longer half-life of about 130 seconds. More than 100 atoms of hassium have been synthesized to date.",
            symbol="Hs",
            xpos=8,
            ypos=7),
    Element(name="Meitnerium",
            atomic_mass=278.0u,
            category="unknown, probably transition metal",
            cpk_hex="#eb0026",
            density=37.4g/cm^3,
            discovered_by="Gesellschaft für Schwerionenforschung",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁷",
            number=109,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 15, 2],
            source="https://en.wikipedia.org/wiki/Meitnerium",
            summary="Meitnerium is a chemical element with symbol Mt and atomic number 109. It is an extremely radioactive synthetic element (an element not found in nature that can be created in a laboratory). The most stable known isotope, meitnerium-278, has a half-life of 7.6 seconds.",
            symbol="Mt",
            xpos=9,
            ypos=7),
    Element(name="Darmstadtium",
            atomic_mass=281.0u,
            category="unknown, probably transition metal",
            density=34.8g/cm^3,
            discovered_by="Gesellschaft für Schwerionenforschung",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁸",
            number=110,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 16, 2],
            source="https://en.wikipedia.org/wiki/Darmstadtium",
            summary="Darmstadtium is a chemical element with symbol Ds and atomic number 110. It is an extremely radioactive synthetic element. The most stable known isotope, darmstadtium-281, has a half-life of approximately 10 seconds.",
            symbol="Ds",
            xpos=10,
            ypos=7),
    Element(name="Roentgenium",
            atomic_mass=281.0u,
            category="unknown, probably transition metal",
            density=28.7g/cm^3,
            discovered_by="Gesellschaft für Schwerionenforschung",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁹",
            number=111,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 17, 2],
            source="https://en.wikipedia.org/wiki/Roentgenium",
            summary="Roentgenium is a chemical element with symbol Rg and atomic number 111. It is an extremely radioactive synthetic element (an element that can be created in a laboratory but is not found in nature); the most stable known isotope, roentgenium-282, has a half-life of 2.1 minutes. Roentgenium was first created in 1994 by the GSI Helmholtz Centre for Heavy Ion Research near Darmstadt, Germany.",
            symbol="Rg",
            xpos=11,
            ypos=7),
    Element(name="Copernicium",
            atomic_mass=285.0u,
            boil=3570.0K,
            category="transition metal",
            density=23.7e-3g/cm^3, # estimation for gas phase
            discovered_by="Gesellschaft für Schwerionenforschung",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰",
            number=112,
            period=7,
            phase="Gas",
            shells=[2, 8, 18, 32, 32, 18, 2],
            source="https://en.wikipedia.org/wiki/Copernicium",
            summary="Copernicium is a chemical element with symbol Cn and atomic number 112. It is an extremely radioactive synthetic element that can only be created in a laboratory. The most stable known isotope, copernicium-285, has a half-life of approximately 29 seconds, but it is possible that this copernicium isotope may have a nuclear isomer with a longer half-life, 8.9 min.",
            symbol="Cn",
            xpos=12,
            ypos=7),
    Element(name="Nihonium",
            atomic_mass=286.0u,
            boil=1430.0K,
            category="unknown, probably transition metal",
            density=16.0g/cm^3,
            discovered_by="RIKEN",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p¹",
            melt=700.0K,
            number=113,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 18, 3],
            source="https://en.wikipedia.org/wiki/Ununtrium",
            summary="Nihonium is a chemical element with atomic number 113. It has a symbol Nh. It is a synthetic element (an element that can be created in a laboratory but is not found in nature) and is extremely radioactive; its most stable known isotope, nihonium-286, has a half-life of 20 seconds.",
            symbol="Nh",
            xpos=13,
            ypos=7),
    Element(name="Flerovium",
            atomic_mass=289.0u,
            boil=420.0K,
            category="post-transition metal",
            density=14.0g/cm^3,
            discovered_by="Joint Institute for Nuclear Research",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p²",
            melt=340.0K,
            number=114,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 18, 4],
            source="https://en.wikipedia.org/wiki/Flerovium",
            summary="Flerovium is a superheavy artificial chemical element with symbol Fl and atomic number 114. It is an extremely radioactive synthetic element. The element is named after the Flerov Laboratory of Nuclear Reactions of the Joint Institute for Nuclear Research in Dubna, Russia, where the element was discovered in 1998.",
            symbol="Fl",
            xpos=14,
            ypos=7),
    Element(name="Moscovium",
            atomic_mass=289.0u,
            boil=1400.0K,
            category="unknown, probably post-transition metal",
            density=13.5g/cm^3,
            discovered_by="Joint Institute for Nuclear Research",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p³",
            melt=670.0K,
            number=115,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 18, 5],
            source="https://en.wikipedia.org/wiki/Ununpentium",
            summary="Moscovium is the name of a synthetic superheavy element in the periodic table that has the symbol Mc and has the atomic number 115. It is an extremely radioactive element; its most stable known isotope, moscovium-289, has a half-life of only 220 milliseconds. It is also known as eka-bismuth or simply element 115.",
            symbol="Mc",
            xpos=15,
            ypos=7),
    Element(name="Livermorium",
            atomic_mass=293.0u,
            boil=1085.0K, #Average of 1035--1135
            category="unknown, probably post-transition metal",
            density=12.9g/cm^3,
            discovered_by="Joint Institute for Nuclear Research",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p⁴",
            melt=709.0K, #Average of 637--780, rounded (up) to nearest integer
            number=116,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 18, 6],
            source="https://en.wikipedia.org/wiki/Livermorium",
            summary="Livermorium is a synthetic superheavy element with symbol Lv and atomic number 116. It is an extremely radioactive element that has only been created in the laboratory and has not been observed in nature. The element is named after the Lawrence Livermore National Laboratory in the United States, which collaborated with the Joint Institute for Nuclear Research in Dubna, Russia to discover livermorium in 2000.",
            symbol="Lv",
            xpos=16,
            ypos=7),
    Element(name="Tennessine",
            atomic_mass=293.0u,
            boil=883.0K,
            category="unknown, probably metalloid",
            density=7.17g/cm^3,
            discovered_by="Joint Institute for Nuclear Research",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p⁵",
            melt=723.0K,
            number=117,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 18, 7],
            source="https://en.wikipedia.org/wiki/Tennessine",
            summary="Tennessine is a superheavy artificial chemical element with an atomic number of 117 and a symbol of Ts. Also known as eka-astatine or element 117, it is the second-heaviest known element and penultimate element of the 7th period of the periodic table. As of 2016, fifteen tennessine atoms have been observed:six when it was first synthesized in 2010, seven in 2012, and two in 2014.",
            symbol="Ts",
            xpos=17,
            ypos=7),
    Element(name="Oganesson",
            atomic_mass=294.0u,
            boil=350.0K,
            category="unknown, predicted to be noble gas",
            density=4.95g/cm^3,
            discovered_by="Joint Institute for Nuclear Research",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p⁶",
            number=118,
            period=7,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 18, 8],
            source="https://en.wikipedia.org/wiki/Oganesson",
            summary="Oganesson is IUPAC's name for the transactinide element with the atomic number 118 and element symbol Og. It is also known as eka-radon or element 118, and on the periodic table of the elements it is a p-block element and the last one of the 7th period. Oganesson is currently the only synthetic member of group 18.",
            symbol="Og",
            xpos=18,
            ypos=7),
    Element(name="Ununennium",
            atomic_mass=315.0u,
            boil=630.0K,
            category="unknown, but predicted to be an alkali metal",
            density=3.0g/cm^3,
            discovered_by="GSI Helmholtz Centre for Heavy Ion Research",
            el_config="1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p⁶ 8s¹",
            number=119,
            period=8,
            phase="Solid",
            shells=[2, 8, 18, 32, 32, 18, 8, 1],
            source="https://en.wikipedia.org/wiki/Ununennium",
            summary="Ununennium, also known as eka-francium or simply element 119, is the hypothetical chemical element with symbol Uue and atomic number 119. Ununennium and Uue are the temporary systematic IUPAC name and symbol respectively, until a permanent name is decided upon. In the periodic table of the elements, it is expected to be an s-block element, an alkali metal, and the first element in the eighth period.",
            symbol="Uue",
            xpos=1,
            ypos=8),
]
