var documenterSearchIndex = {"docs":
[{"location":"#RingLists","page":"RingLists","title":"RingLists","text":"","category":"section"},{"location":"","page":"RingLists","title":"RingLists","text":"A RingList is a list of distinct values that is unchanged by rotation. These can be created by giving a list of values or a one-dimensional array of values:","category":"page"},{"location":"","page":"RingLists","title":"RingLists","text":"julia> using RingLists\n\njulia> a = RingList(1,2,3,4);\n\njulia> b = RingList([2,3,4,1]);\n\njulia> a==b\ntrue\n\njulia> println(a)\n[ 1 → 2 → 3 → 4 → 1 ]","category":"page"},{"location":"","page":"RingLists","title":"RingLists","text":"Note the repeat of element 1 in the output showing that the list wraps around.","category":"page"},{"location":"#Functions","page":"RingLists","title":"Functions","text":"","category":"section"},{"location":"","page":"RingLists","title":"RingLists","text":"In this list, a stands for a RingList.","category":"page"},{"location":"","page":"RingLists","title":"RingLists","text":"length(a) gives the number of elements held in the RingList.\nkeys(a) returns an iterator of the elements in a.\nhaskey(a,x) checks if x is an element of the RingList.\nVector(a) returns a one-dimensional array of the elements in a.\nSet(a) returns the elements of a (as an unordered collection).\ncollect(a) returns the elements of a in an ordered list. \ncopy(a) makes an independent copy of a.\nshuffle(a) returns a new RingList with the same elements as a but in randomized order.\nnext(a,x) returns the next element after x in a; also a[x].\nprevious(a,x) returns the element y with a[y]==x; also a(y).\nfirst(a) returns an element of a that is, if possible, the smallest element of a. Call first(a,false) to ignore trying to start at the smallest element. Fails if a is empty.\ndelete!(a,x) removes x from the collection linking together its predecessor and successor.\ninsert!(a,x) inserts the element a into the RingList. No guarantee where it will end up.\ninsertbefore!(a,x,y) inserts x into a before y.\ninsertafter!(a,x,y) inserts x into a after y. For example:","category":"page"},{"location":"","page":"RingLists","title":"RingLists","text":"> a = RingList(1,2,3)\n[ 1 → 2 → 3 → 1 ]\n\njulia> insertafter!(a,99,2)\n\njulia> a\n[ 1 → 2 → 99 → 3 → 1 ]","category":"page"},{"location":"","page":"RingLists","title":"RingLists","text":"reverse(a) returns a new RingList with the elements reversed.","category":"page"},{"location":"","page":"RingLists","title":"RingLists","text":"julia> a = RingList(1,2,3,4,5)\n[ 1 → 2 → 3 → 4 → 5 → 1 ]\n\njulia> b = reverse(a)\n[ 1 → 5 → 4 → 3 → 2 → 1 ]","category":"page"},{"location":"","page":"RingLists","title":"RingLists","text":"firsts(a) returns a new RingList built by taking the first member  of each element of a.","category":"page"},{"location":"","page":"RingLists","title":"RingLists","text":"julia> a\n[ (19, 20) → (20, 25) → (25, 31) → (31, 27) → (27, 19) → (19, 20) ]\n\njulia> firsts(a)\n[ 19 → 20 → 25 → 31 → 27 → 19 ]","category":"page"},{"location":"#Iteration","page":"RingLists","title":"Iteration","text":"","category":"section"},{"location":"","page":"RingLists","title":"RingLists","text":"RingList elements can be iterated:","category":"page"},{"location":"","page":"RingLists","title":"RingLists","text":"julia> a = RingList(1,2,3,4,5)\n[ 1 → 2 → 3 → 4 → 5 → 1 ]\n\njulia> for x in a\n       println(x)\n       end\n1\n2\n3\n4\n5","category":"page"}]
}
