var documenterSearchIndex = {"docs":
[{"location":"#SimplePartitions","page":"SimplePartitions","title":"SimplePartitions","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"Module for set partitions. We define a Partition to be a wrapper around the DisjointUnion type defined in the DataStructures module, but with a bit more functionality.","category":"page"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"We also include IntegerPartition.","category":"page"},{"location":"#Partition-Constructor","page":"SimplePartitions","title":"Partition Constructor","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"A new Partition is created by specifying the ground set. That is, if A is a Set{T} (for some type T) or an IntSet, then Partition(A) creates a new Partition whose ground set is A and the parts are singletons.","category":"page"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"julia> using ShowSet\n\njulia> using SimplePartitions\n\njulia> A = Set(1:10)\n{1,2,3,4,5,6,7,8,9,10}\n\njulia> P = Partition(A)\n{{9},{6},{5},{8},{1},{3},{2},{10},{7},{4}}","category":"page"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"The parameter to Partition may also be a list (one-dimensional array) or a positive integer n, in which case a partition of the set {1,2,...,n} is created.","category":"page"},{"location":"#Construct-from-a-set-of-sets","page":"SimplePartitions","title":"Construct from a set of sets","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"If S is a set of sets then PartitionBuilder(S) creates a new partition whose parts are the sets in S. The sets in S must be nonempty and pairwise disjoint.","category":"page"},{"location":"#Construct-from-a-Permutation","page":"SimplePartitions","title":"Construct from a Permutation","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"If p is a Permutation, then Partition(p) creates a new partition whose parts are the cycles of p.","category":"page"},{"location":"#Construct-from-a-Dict","page":"SimplePartitions","title":"Construct from a Dict","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"If d is a dictionary, the Partition(d) creates a new partition whose elements are the keys of d in which two elements a and b are in the same part if and only if d[a] == d[b].","category":"page"},{"location":"#Functions","page":"SimplePartitions","title":"Functions","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"num_elements(P): returns the number of elements in the ground","category":"page"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"set of P.","category":"page"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"num_parts(P): returns the number of parts in P.\nparts(P): returns the set of the parts in this partition.\ncollect(P) returns a one-dimensional array containing the parts.\nground_set(P): returns (a copy of) the ground set of P.\nin(a,P): test if a (element) is in the ground set of P.\nin(A,P): test if A (set) is a part of P.\nmerge_parts!(P,a,b): Modify P by merging the parts of P that contain the elements a and b. This may also be called with a list for the second argument: merge_parts!(P,[a,b,...]).\nin_same_part(P,a,b): returns true if a and b are in the same part of P.\nfind_part(P,a): returns the set of elements in P that are in the same part as a.","category":"page"},{"location":"#Operations","page":"SimplePartitions","title":"Operations","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"join(P,Q) returns the join of partitions P and Q. This can also be invoked as P+Q or as P∨Q.\nmeet(P,Q) returns the meet of the partitions. This can also be invoked as P*Q or as P∧Q.\nP+x where P is a partition and x is a new element creates a new partition in which x is added as a singleton.\nP+A where P is a partition and A is a set of elements (that are disjoint from the elements already in P) creates a new partition by adding A as a part.","category":"page"},{"location":"#Relations","page":"SimplePartitions","title":"Relations","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"P==Q determines if P and Q are equal partitions.\nP<=Q determines if P is a refinement of Q. That is, we return true if each part of P is a subset of a part of Q. Note that P and Q must have the same ground set or else an error is thrown. The variants P<Q, P>=Q, and P>Q are available with the expected meanings. Calling refines(P,Q) is the same as P<=Q.","category":"page"},{"location":"#Iteration","page":"SimplePartitions","title":"Iteration","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"It is possible to iterate over the parts of a Partition:","category":"page"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"julia> using SimplePartitions, ShowSet\n\njulia> P = Partition(7); merge_parts!(P,1,2); merge_parts!(P,3,4); merge_parts!(P,3,5);\n\njulia> @show P\nP = {{3,4,5},{6},{1,2},{7}}\n\njulia> for p in P; println(p); end\n{7}\n{6}\n{3,4,5}\n{1,2}","category":"page"},{"location":"#Generating-All-Partitions-of-a-Set","page":"SimplePartitions","title":"Generating All Partitions of a Set","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"all_partitions(A::Set) creates a Set containing all possible partitions of A.\nall_partitions(n::Int) creates a Set containing all possible partitions of the set {1,2,...,n}.","category":"page"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"Both of these take an optional second argument k to specify that only partitions with exactly k parts should be returned.","category":"page"},{"location":"#Examples","page":"SimplePartitions","title":"Examples","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"Note: Sets are nicely displayed here because we invoked using ShowSet.","category":"page"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"julia> A = Set([\"alpha\", \"bravo\", \"charlie\", \"delta\", \"echo\"])\n{alpha,bravo,charlie,delta,echo}\n\njulia> P = Partition(A)\n{{delta},{echo},{charlie},{bravo},{alpha}}\n\njulia> merge_parts!(P,\"alpha\", \"bravo\")\n\njulia> merge_parts!(P,\"echo\", \"bravo\")\n\njulia> merge_parts!(P,\"charlie\", \"delta\")\n\njulia> P\n{{charlie,delta},{alpha,bravo,echo}}\n\njulia> Q = Partition(A);\n\njulia> merge_parts!(Q,\"alpha\", \"echo\")\n\njulia> merge_parts!(Q,\"delta\",\"alpha\")\n\njulia> Q\n{{charlie},{bravo},{alpha,delta,echo}}\n\njulia> P+Q\n{{alpha,bravo,charlie,delta,echo}}\n\njulia> P*Q\n{{delta},{charlie},{bravo},{alpha,echo}}","category":"page"},{"location":"#Integer-Partitions","page":"SimplePartitions","title":"Integer Partitions","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"The type IntegerPartition represents a partition of an integer. These can be constructed either from a one-dimensional array of integers or as individual arguments:","category":"page"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"IntegerPartition([a,b,c,...]) or\nIntegerPartition(a,b,c,...)","category":"page"},{"location":"#Operations/Functions","page":"SimplePartitions","title":"Operations/Functions","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"parts(P) returns a list containing the parts.\nsum(P) returns the sum of the parts.\nnum_parts(P) returns the number of parts.\nFerrers(P) prints a Ferrer's diagram of P.\nconj(P) or P' returns the Ferrer's conjugate of P\nP+Q returns the concatenation of P and Q:","category":"page"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"julia> P = IntegerPartition(2,2,4)\n(4+2+2)\n\njulia> Q = IntegerPartition(5,2,1)\n(5+2+1)\n\njulia> P+Q\n(5+4+2+2+2+1)","category":"page"},{"location":"#To-do-list","page":"SimplePartitions","title":"To do list","text":"","category":"section"},{"location":"","page":"SimplePartitions","title":"SimplePartitions","text":"Create RandomPartition(n) [and RandomPartition(Set)].","category":"page"}]
}
