var documenterSearchIndex = {"docs":
[{"location":"#SimplePolynomials","page":"SimplePolynomials","title":"SimplePolynomials","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"This module defines two types:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"SimplePolynomial: These are polynomials with exact coefficients (integers, rationals, Gaussian integers, Gaussian rationals, or Mods). The objective is exactness perhaps at the expense of computational efficiency.\nSimpleRationalFunction: These are fractions whose numerator and denominator are SimplePolynomials.","category":"page"},{"location":"#Caveat","page":"SimplePolynomials","title":"Caveat","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The polynomials (and rational functions) in this module all have exact and arbitrary size precision. That means there will not be rounding or overflow issues, but the cost is performance. The Polynomials package is more efficient.  Other computer algebra packages may perform better. ","category":"page"},{"location":"#Basics","page":"SimplePolynomials","title":"Basics","text":"","category":"section"},{"location":"#Polynomials","page":"SimplePolynomials","title":"Polynomials","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"A SimplePolynomial is a polynomial in one variable with exact coefficients. There are a few options to create a SimplePolynomial:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> using SimplePolynomials\n\njulia> p = SimplePolynomial([2,-4,1])\n2 - 4*x + x^2\n\njulia> p = SimplePolynomial(2,-4,1,0)\n2 - 4*x + x^2","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The getx() function returns SimplePolynomial(0,1). Assigning that result to a variable named x makes creating polynomials rather natural.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> x = getx()\nx\n\njulia> p = 2 - 4x + x^2\n2 - 4*x + x^2","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Polynomial coefficients may also be rational numbers, Gaussian integers, Gaussian rationals, or modular numbers.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = 3x^2 - im*x + 4\n4 - im*x + 3*x^2\n\njulia> p = (3//2)x^2 - 4\n-4//1 + 3//2*x^2\n\njulia> using Mods\n\njulia> p = Mod{17}(3) - 2x^2\nMod{17}(3) + Mod{17}(15)*x^2","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The coefficients of a SimplePolynomial may not be floating point numbers.","category":"page"},{"location":"#Coefficients","page":"SimplePolynomials","title":"Coefficients","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The coefficients of a SimplePolynomial can be accessed with the coeffs function:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = 1 -5x + 11x^2 + 4x^3\n1 - 5*x + 11*x^2 + 4*x^3\n\njulia> coeffs(p)\n4-element Array{Int64,1}:\n  1\n -5\n 11\n  4","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Use square brackets to retrieve a coefficient associated with a given power:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p[2]     # coefficient of x^2\n11\n\njulia> p[0]     # constant term, the zero index is allowed\n1\n\njulia> p[11]    # zero is returned if the index exceeds the degree\n0\n\njulia> p[-1]    # negative indices are not allowed\nERROR: index [-1] must be nonnegative","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Note that a SimplePolynomial is an immutable object and one may not change its coefficients.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = 3x^2 - 5x +1\n1 - 5*x + 3*x^2\n\njulia> p[1] = 6\nERROR: MethodError: no method matching setindex!(::SimplePolynomial, ::Int64, ::Int64)","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The degree function returns the degree of the polynomial and lead returns the coefficient of that term.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> degree(p)\n3\n\njulia> lead(p)\n4","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Nonzero constant polynomials have degree zero. The zero polynomial should have degree -∞ but this is not an Int, so we return -1. This is also the only case in which lead returns 0:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = SimplePolynomial(0)\n0\n\njulia> degree(p)\n-1\n\njulia> lead(p)\n0","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The function monic(p) returns a SimplePolynomial formed by dividing all coefficients by the leading term:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = 4-8x + 2x^2\n4 - 8*x + 2*x^2\n\njulia> monic(p)\n2 - 4*x + x^2\n\njulia> p = 3x^2-5\n-5 + 3*x^2\n\njulia> monic(p)\n-5//3 + x^2","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The function eltype returns the Julia type of the coefficients.","category":"page"},{"location":"#Rational-Functions","page":"SimplePolynomials","title":"Rational Functions","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"A SimpleRationalFunction is the ratio of two polynomials:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = 3x + x^3\n3*x + x^3\n\njulia> q = 1-x+x^2\n1 - x + x^2\n\njulia> p/q\n(3*x + x^3) / (1 - x + x^2)","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"A SimpleRationalFunction is always represented as the ratio of relatively prime polynomials; that is, any common factors between numerator and denominator are cancelled.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = (x-1)*(x-2)*(x-3)\n-6 + 11*x - 6*x^2 + x^3\n\njulia> q = (x-1)*(x+5)\n-5 + 4*x + x^2\n\njulia> p/q\n(6 - 5*x + x^2) / (5 + x)","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Furthermore, the denominator of a SimpleRationalFunction is always a monic polynomial; that is, the leading coefficient is one.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> (x-3)/(2x^2-5)\n(-3//2 + 1//2*x) / (-5//2 + x^2)","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Of course, division by zero is forbidden:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = x^2-5;\n\njulia> q = SimplePolynomial(0);\n\njulia> p/q\nERROR: Denominator cannot be zero","category":"page"},{"location":"#Numerator-and-denominator","page":"SimplePolynomials","title":"Numerator and denominator","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Use numerator and denominator to extract the relevant parts of a SimpleRationalFunction:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> f = (x^2 - 3x + 2) / (x-4)\n(2 - 3*x + x^2) / (-4 + x)\n\njulia> numerator(f)\n2 - 3*x + x^2\n\njulia> denominator(f)\n-4 + x","category":"page"},{"location":"#Three-line-printing","page":"SimplePolynomials","title":"Three-line  printing","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The string3 function can be used to give a nice visualization of a SimpleRationalFunction:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> f = (x^2 - 3x + 2) / (x-4)\n(2 - 3*x + x^2) / (-4 + x)\n\njulia> println(string3(f))\n2 - 3*x + x^2\n-------------\n   -4 + x","category":"page"},{"location":"#Operations","page":"SimplePolynomials","title":"Operations","text":"","category":"section"},{"location":"#Arithmetic","page":"SimplePolynomials","title":"Arithmetic","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The usual operations of addition +, subtraction -, multiplication *, and division / may be used with any combination of exact numbers, polynomials, or rational functions.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Exponentiation by an integer power may be performed for any SimplePolynomial or SimpleRationalFunction.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = 1+x\n1 + x\n\njulia> for k=-3:3\n       println(p^k)\n       end\n1 / (1 + 3*x + 3*x^2 + x^3)\n1 / (1 + 2*x + x^2)\n1 / (1 + x)\n1\n1 + x\n1 + 2*x + x^2\n1 + 3*x + 3*x^2 + x^3","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"For polynomials, division results in a SimpleRationalFunction. Alternatively, use diverm to find the quotient and remainder:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> a = 3x^3 + 5x -1\n-1 + 5*x + 3*x^3\n\njulia> b = x^2+3\n3 + x^2\n\njulia> (q,r) = divrem(a,b)\n(3*x, -1 - 4*x)\n\njulia> q*b + r == a\ntrue","category":"page"},{"location":"#Evaluation","page":"SimplePolynomials","title":"Evaluation","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Polynomials and rational functions behave as functions; they can be evaluated as follows:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = 3x^2 + 5x +1\n1 + 5*x + 3*x^2\n\njulia> p(10)\n351\n\njulia> p(0.5)  # evaluation with a float is permitted\n4.25\n\njulia> f = p/(x+5)\n(1 + 5*x + 3*x^2) / (5 + x)\n\njulia> f(10)\n117//5\n\njulia> f(3.2 - 4.1im)   \n4.575609756097562 - 9.812195121951218im","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The argument of a polynomial or simple rational function may be a square matrix.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> A = [ 2 3 ; 0 -1];\n\njulia> p = -2 - x + x^2;\n\njulia> p(A)\n2×2 Array{BigInt,2}:\n 0  0\n 0  0","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The argument of a polynomial or rational function may itself be a polynomial or a rational function.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = 3x^2 + 5x +1\n1 + 5*x + 3*x^2\n\njulia> q = 2x-3\n-3 + 2*x\n\njulia> p(q)\n13 - 26*x + 12*x^2\n\njulia> 3q^2 + 5q + 1\n13 - 26*x + 12*x^2","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Beware that multiplication requires the * symbol. Observe:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> (x^2-2)*(x-3)\n6 - 2*x - 3*x^2 + x^3\n\njulia> (x^2-2)(x-3)\n7 - 6*x + x^2","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"In the second case, we are evaluating the function (x^2-2) with the argument (x-3):","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> (x-3)^2 - 2\n7 - 6*x + x^2","category":"page"},{"location":"#Conversion-to-a-function","page":"SimplePolynomials","title":"Conversion to a function","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Given p, the syntax p(x) evaluates p at x. Of course, p is of type SimplePolynomial (or SimpleRationalFunction). If you want a Function that evaluates p, use make_function(p).","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> x = getx();\n\njulia> p = 5 + 2x + 4x^2\n5 + 2*x + 4*x^2\n\njulia> p(10)\n425\n\njulia> P = make_function(p)\n#1 (generic function with 1 method)\n\njulia> P(10)\n425","category":"page"},{"location":"#GCD-and-LCM","page":"SimplePolynomials","title":"GCD and LCM","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Given  SimplePolynomials a and b, gcd(a,b) returns a greatest common divisor of a and b. This is a polynomial of highest degree that divides both a and b without remainder. Note that this is not unique as a nonzero multiple of a GCD is also a GCD of the two polynomials. The polynomial returned is always monic.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = (2x-1) * (x+5)\n-5 + 9*x + 2*x^2\n\njulia> q = (2x-1) * (x^2-4)\n4 - 8*x - x^2 + 2*x^3\n\njulia> gcd(p,q)\n-1//2 + x","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Similarly, lcm(a,b) returns a least common multiple of a and b. As with gcd, this is not uniquely defined; we return a monic least common multiple.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> lcm(p,q)\n10//1 - 18//1*x - 13//2*x^2 + 9//2*x^3 + x^4","category":"page"},{"location":"#Roots","page":"SimplePolynomials","title":"Roots","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"For polynomials, roots(p) returns a list of values x for which p(x)==0. These are floating point and so are likely not to be exact.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = x^2-x-1\n-1 - x + x^2\n\njulia> roots(p)\n2-element Array{Float64,1}:\n -0.6180339887498948\n  1.618033988749895\n\njulia> p.(ans)\n2-element Array{Float64,1}:\n -1.1102230246251565e-16\n  2.220446049250313e-16","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"We can achieve greater accuracy using newton_roots:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> newton_roots(p)\n2-element Array{BigFloat,1}:\n -0.6180339887498948482045868343656381177203091798057628621354486227052604628189011\n  1.61803398874989484820458683436563811772030917980576286213544862270526046281891\n\njulia> p.(ans)\n2-element Array{BigFloat,1}:\n -8.636168555094444625386351862800399571116000364436281385023703470168591803162427e-78\n  1.727233711018888925077270372560079914223200072887256277004740694033718360632485e-77","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The function newton_roots calls newton_solve for each root returned by roots. See the help messages. ","category":"page"},{"location":"#Rational-roots","page":"SimplePolynomials","title":"Rational roots","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The function rational_roots returns the Multiset of all rational  roots of a polynomial.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = (2x-3)^2 * (4x+3) * x^2 * (x^2+1)\n27*x^2 - 9*x^4 + 16*x^5 - 36*x^6 + 16*x^7\n\njulia> rational_roots(p)\n{-3//4,0//1,0//1,3//2,3//2}\n\njulia> roots(p)\n7-element Array{Complex{Float64},1}:\n   -0.7499999999999999 + 0.0im\n 3.885780586188048e-16 - 1.0000000000000009im\n 3.885780586188048e-16 + 1.0000000000000009im\n    1.4999999920796347 + 0.0im\n    1.5000000079203661 + 0.0im\n                   0.0 + 0.0im\n                   0.0 + 0.0im","category":"page"},{"location":"#Calculus","page":"SimplePolynomials","title":"Calculus","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"derivative() returns the derivative of a SimplePolynomial or SimpleRationalFunction. We may also use p' for derivative(p).","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = x^5 - 3x + 2\n2 - 3*x + x^5\n\njulia> derivative(p)\n-3 + 5*x^4\n\njulia> p'\n-3 + 5*x^4\n\njulia> f = (x^2-5)/(x+3)\n(-5 + x^2) / (3 + x)\n\njulia> f'\n(5 + 6*x + x^2) / (9 + 6*x + x^2)","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"integral(p) returns the integral of p with constant term zero.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> p = 1 + 3x - 5x^2\n1 + 3*x - 5*x^2\n\njulia> integral(p)\nx + 3//2*x^2 - 5//3*x^3\n\njulia> derivative(ans)\n1 + 3*x - 5*x^2","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The integral of a rational funtion is not necessarily a rational function; it is not implemented in this module.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> f = 1/(1+x^2)\n1 / (1 + x^2)\n\njulia> integral(f)\nERROR: MethodError: no method matching integral(::SimpleRationalFunction)","category":"page"},{"location":"#Binomial-Coefficient","page":"SimplePolynomials","title":"Binomial Coefficient","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The binomial function is extended to work either SimplePolynomial or SimpleRationalFunction upper arguments (and Integer lower arguments).","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> x = getx()\nx\n\njulia> p = binomial(x,3)\n1//3*x - 1//2*x^2 + 1//6*x^3\n\njulia> p(10)\n120//1\n\njulia> binomial(10,3)\n120","category":"page"},{"location":"#Interpolation","page":"SimplePolynomials","title":"Interpolation","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Given a list of (exact) numbers, the interpolate function returns a polynomial that generates that list.   Specifically, if vals is the list of numbers, then interpolate(vals) returns a polynomial p such that p(0) is the first element of the list, p(1) is the second element, and so forth.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Here is a simple example that illustrates that p(0) gives the first element of the list:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> vals = [1,4,9,16,25];\n\njulia> interpolate(vals)\n1 + 2*x + x^2","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"In this next example, we find a polynomial p such that p(n) is the sum of the first n perfect squares.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"julia> f(n) = sum(k^2 for k=0:n)\nf (generic function with 1 method)\n\njulia> vals = [f(n) for n=0:5]\n6-element Vector{Int64}:\n  0\n  1\n  5\n 14\n 30\n 55\n\njulia> p = interpolate(vals)\n1//6*x + 1//2*x^2 + 1//3*x^3\n\njulia> p(10)\n385//1\n\njulia> f(10)\n385","category":"page"},{"location":"#Conversion-between-SimplePolynomial-and-Polynomial","page":"SimplePolynomials","title":"Conversion between SimplePolynomial and  Polynomial","text":"","category":"section"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"The Polynomials module also defines polynomials with many additional properties. However, those polynomials allow floating point coefficients.","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"Conversion between a SimplePolynomial  and a Polynomial  is simple:","category":"page"},{"location":"","page":"SimplePolynomials","title":"SimplePolynomials","text":"If p is a SimplePolynomial, then Polynomial(p) is the corresponding Polynomial type.\nIf p is a Polynomial, the SimplePolynomial(p) returns its SimplePolynomial version. However, this will not work if the coefficients in p are floating point.","category":"page"}]
}
