```@meta
CurrentModule = Yao
```

# Yao

*A General Purpose Quantum Computation Simulation Framework*

Welcome to [Yao](https://github.com/QuantumBFS/Yao.jl), a **Flexible**, **Extensible**, **Efficient** Framework for
Quantum Algorithm Design. **Yao** (幺) is the Chinese character for normalized but not orthogonal.

We aim to provide a powerful tool for researchers, students to study and explore quantum computing in near term
future, before quantum computer being used in large-scale.

## Quick Starts

You can learn how to use Yao with some quick examples in this section. There are three badges on the top of each tutorial that allows you to open it in [mybinder](https://mybinder.org/), preview it in [nbviewer](https://nbviewer.jupyter.org/) or download the tutorial as `.zip` file, which includes the notebook and the scripts and other related materials.

### Contribution

If you are interesting in polishing or contributing our tutorial, you can just open a [PR in our tutorial repo](https://github.com/QuantumBFS/tutorials/compare).

### Syntax

The tutorials are written with [Literate](https://github.com/fredrikekre/Literate.jl).

## Pluto Notebooks

There is also a set of Pluto notebooks available in [the notebooks folder](notebooks)

## Manual

```@contents
Pages = [
    "man/array_registers.md",
    "man/blocks.md",
    "man/registers.md",
    "man/extending_blocks.md",
]
Depth = 1
```
