/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.IVariableProvider;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructure;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructureManager;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.Variable;
import com.microsoft.java.debug.core.adapter.variables.VariableDetailUtils;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.adapter.variables.VariableUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class VariablesRequestHandler
implements IDebugRequestHandler {
    protected final Logger logger;

    public VariablesRequestHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.VARIABLES);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command var1_1, Requests.Arguments var2_2, Messages.Response var3_3, IDebugAdapterContext var4_4) {
        var5_5 = var4_4.getVariableFormatter();
        var6_6 = (Requests.VariablesArguments)var2_2;
        var7_7 = DebugSettings.getCurrent().showStaticVariables;
        var8_8 = var5_5.getDefaultOptions();
        var9_9 = var4_4.getProvider(IVariableProvider.class);
        VariableUtils.applyFormatterOptions(var8_8, var6_6.format != null && var6_6.format.hex != false);
        var10_10 = var4_4.getProvider(IEvaluationProvider.class);
        var11_11 = new ArrayList<Types.Variable>();
        var12_12 = var4_4.getRecyclableIdPool().getObjectById(var6_6.variablesReference);
        if (var12_12 == null) {
            var3_3.body = new Responses.VariablesResponseBody(var11_11);
            return CompletableFuture.completedFuture(var3_3);
        }
        if (!(var12_12 instanceof VariableProxy)) {
            throw AdapterUtils.createCompletionException(String.format("VariablesRequest: Invalid variablesReference %d.", new Object[]{var6_6.variablesReference}), ErrorCode.GET_VARIABLE_FAILURE);
        }
        var13_13 = (VariableProxy)var12_12;
        var14_14 = new ArrayList<E>();
        var15_15 = var4_4.getStackFrameManager();
        var16_16 = var13_13.getEvaluateName();
        var17_17 = var13_13.isUnboundedType();
        if (var13_13.getProxiedVariable() instanceof StackFrameReference) {
            var18_18 = (StackFrameReference)var13_13.getProxiedVariable();
            var19_20 = var15_15.getStackFrame((StackFrameReference)var18_18);
            if (var19_20 == null) {
                throw AdapterUtils.createCompletionException(String.format("Invalid stackframe id %d to get variables.", new Object[]{var6_6.variablesReference}), ErrorCode.GET_VARIABLE_FAILURE);
            }
            try {
                var20_21 = var18_18.getThread().uniqueID();
                var22_27 = var4_4.getStepRequestManager().getMethodResult(var20_21);
                if (var22_27 != null) {
                    var23_29 = AdapterUtils.isWin != false || AdapterUtils.isMac != false ? "\u23af\u25ba" : "->";
                    var14_14.add(new Variable((String)var23_29 + var22_27.method.name() + "()", var22_27.value, null));
                }
                var14_14.addAll(VariableUtils.listLocalVariables((StackFrame)var19_20));
                var23_29 = VariableUtils.getThisVariable(var19_20);
                if (var23_29 != null) {
                    var14_14.add(var23_29);
                }
                if (!var7_7 || !var19_20.location().method().isStatic()) ** GOTO lbl89
                var14_14.addAll(VariableUtils.listStaticVariables(var19_20));
            }
            catch (AbsentInformationException | InternalException | InvalidStackFrameException var20_22) {
                throw AdapterUtils.createCompletionException(String.format("Failed to get variables. Reason: %s", new Object[]{var20_22.toString()}), ErrorCode.GET_VARIABLE_FAILURE, var20_22);
            }
        } else {
            try {
                var18_18 = (ObjectReference)var13_13.getProxiedVariable();
                if (DebugSettings.getCurrent().showLogicalStructure && var10_10 != null) {
                    var19_20 = null;
                    try {
                        var19_20 = JavaLogicalStructureManager.getLogicalStructure((ObjectReference)var18_18);
                    }
                    catch (Exception var20_23) {
                        this.logger.log(Level.WARNING, "Failed to get the logical structure for the variable, fall back to the Object view.", var20_23);
                    }
                    if (var17_17 && var19_20 != null && var16_16 != null) {
                        var16_16 = "((" + var19_20.getFullyQualifiedName() + ")" + var16_16 + ")";
                        var17_17 = false;
                    }
                    while (var19_20 != null) {
                        var20_24 = var19_20.getValueExpression();
                        var21_31 = var19_20.getVariables();
                        try {
                            if (var20_24 != null) {
                                var16_16 = var16_16 == null ? null : var16_16 + "." + var20_24.evaluateName;
                                var17_17 = var20_24.returnUnboundedType;
                                var22_27 = var19_20.getValue((ObjectReference)var18_18, var13_13.getThread(), var10_10);
                                if (var22_27 instanceof ObjectReference) {
                                    var18_18 = (ObjectReference)var22_27;
                                    var19_20 = JavaLogicalStructureManager.getLogicalStructure((ObjectReference)var18_18);
                                    continue;
                                }
                                var14_14 = Arrays.asList(new Variable[]{new Variable("logical structure", (Value)var22_27)});
                            } else if (var21_31 != null && ((JavaLogicalStructure.LogicalVariable[])var21_31).length > 0) {
                                for (Object var25_33 : var21_31) {
                                    var26_34 = var25_33.getName();
                                    var27_36 = var25_33.getValue((ObjectReference)var18_18, var13_13.getThread(), var10_10);
                                    var28_38 = new Variable((String)var26_34, (Value)var27_36, var25_33.getEvaluateName());
                                    var28_38.setUnboundedType(var25_33.returnUnboundedType());
                                    var14_14.add(var28_38);
                                }
                            }
                        }
                        catch (Exception var22_28) {
                            this.logger.log(Level.WARNING, "Failed to get the logical structure for the variable, fall back to the Object view.", var22_28);
                        }
                        var19_20 = null;
                    }
                }
                if (var14_14.isEmpty() && VariableUtils.hasChildren((Value)var18_18, var7_7)) {
                    var14_14 = var6_6.count > 0 ? VariableUtils.listFieldVariables(var18_18, var6_6.start, var6_6.count) : VariableUtils.listFieldVariables((ObjectReference)var18_18, var7_7);
                }
            }
            catch (AbsentInformationException var18_19) {
                throw AdapterUtils.createCompletionException(String.format("Failed to get variables. Reason: %s", new Object[]{var18_19.toString()}), ErrorCode.GET_VARIABLE_FAILURE, var18_19);
            }
        }
lbl89:
        // 3 sources

        var18_18 = this.getDuplicateNames((Collection<String>)var14_14.stream().map((Function<Variable, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$0(com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Ljava/lang/String;)()).collect(Collectors.toList()));
        var19_20 = new HashMap<K, V>();
        if (!var18_18.isEmpty()) {
            var20_25 = var14_14.stream().filter((Predicate<Variable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handle$1(java.util.Set com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Z)(var18_18)).collect(Collectors.groupingBy((Function<Variable, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$2(com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Ljava/lang/String;)(), Collectors.toList()));
            var20_25.forEach((BiConsumer<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$handle$3(com.microsoft.java.debug.core.adapter.variables.IVariableFormatter java.util.Map java.util.Map java.lang.String java.util.List ), (Ljava/lang/String;Ljava/util/List;)V)((IVariableFormatter)var5_5, var8_8, var19_20));
        }
        for (Object var21_31 : var14_14) {
            var22_27 = var21_31.value;
            var23_29 = var21_31.name;
            if (var19_20.containsKey(var21_31)) {
                var23_29 = (String)var19_20.get(var21_31);
            }
            var24_32 = -1;
            var25_33 = null;
            if (var22_27 instanceof ArrayReference) {
                var24_32 = ((ArrayReference)var22_27).length();
            } else if (var22_27 instanceof ObjectReference && DebugSettings.getCurrent().showLogicalStructure && var10_10 != null) {
                try {
                    var26_34 = JavaLogicalStructureManager.getLogicalStructure((ObjectReference)var22_27);
                    if (var26_34 != null && var26_34.getSizeExpression() != null && (var25_33 = var26_34.getSize((ObjectReference)var22_27, var13_13.getThread(), var10_10)) != null && var25_33 instanceof IntegerValue) {
                        var24_32 = ((IntegerValue)var25_33).value();
                    }
                }
                catch (Exception var26_35) {
                    this.logger.log(Level.INFO, "Failed to get the logical size of the variable", var26_35);
                }
            }
            var26_34 = null;
            if (var21_31.evaluateName == null || var16_16 == null && var13_13.getProxiedVariable() instanceof ObjectReference) {
                var26_34 = null;
            } else if (var17_17 && !var13_13.isIndexedVariable()) {
                var27_36 = ((ObjectReference)var13_13.getProxiedVariable()).referenceType().name();
                var27_36 = var27_36.replaceAll("\\$", ".");
                var26_34 = var9_9.getEvaluateName(var21_31.evaluateName, "((" + (String)var27_36 + ")" + var16_16 + ")", false);
            } else {
                var26_34 = var16_16 != null && var16_16.contains("%s") != false ? String.format(var16_16, new Object[]{var21_31.evaluateName}) : var9_9.getEvaluateName(var21_31.evaluateName, var16_16, var13_13.isIndexedVariable());
            }
            var27_37 = 0;
            if (var24_32 > 0 || var24_32 < 0 && var22_27 instanceof ObjectReference) {
                var28_38 = new VariableProxy(var13_13.getThread(), var13_13.getScope(), var22_27, var13_13, (String)var26_34);
                var27_37 = var4_4.getRecyclableIdPool().addObject(var13_13.getThreadId(), var28_38);
                var28_38.setIndexedVariable(var24_32 >= 0);
                var28_38.setUnboundedType(var21_31.isUnboundedType());
            }
            var28_39 = false;
            var29_40 = null;
            try {
                var29_40 = var5_5.valueToString((Value)var22_27, var8_8);
            }
            catch (OutOfMemoryError var30_42) {
                var28_39 = true;
                this.logger.log(Level.SEVERE, "Failed to convert the value of a large object to a string", var30_42);
                var29_40 = "<Unable to display the value of a large object>";
            }
            catch (Exception var30_43) {
                var28_39 = true;
                this.logger.log(Level.SEVERE, "Failed to resolve the variable value", var30_43);
                var29_40 = "<Failed to resolve the variable value due to \"" + var30_43.getMessage() + "\">";
            }
            var30_41 = "";
            try {
                var30_41 = var5_5.typeToString(var22_27 == null ? null : var22_27.type(), var8_8);
            }
            catch (Exception var31_45) {
                this.logger.log(Level.SEVERE, "Failed to resolve the variable type", var31_45);
                var30_41 = "";
            }
            var31_44 = new Types.Variable((String)var23_29, var29_40, var30_41, var27_37, (String)var26_34);
            var31_44.indexedVariables = Math.max(var24_32, 0);
            var32_46 = null;
            if (!var28_39) {
                if (var25_33 != null) {
                    var32_46 = "size=" + var5_5.valueToString((Value)var25_33, var8_8);
                } else if (DebugSettings.getCurrent().showToString) {
                    try {
                        var32_46 = VariableDetailUtils.formatDetailsValue((Value)var22_27, var13_13.getThread(), var5_5, var8_8, var10_10);
                    }
                    catch (OutOfMemoryError var33_48) {
                        this.logger.log(Level.SEVERE, "Failed to compute the toString() value of a large object", var33_48);
                        var32_46 = "<Unable to display the details of a large object>";
                    }
                    catch (Exception var33_49) {
                        this.logger.log(Level.SEVERE, "Failed to compute the toString() value", var33_49);
                        var32_46 = "<Failed to resolve the variable details due to \"" + var33_49.getMessage() + "\">";
                    }
                }
            }
            if (var32_46 != null) {
                var31_44.value = var31_44.value + " " + var32_46;
            }
            var11_11.add(var31_44);
        }
        if (var11_11.isEmpty() && var13_13.getProxiedVariable() instanceof ObjectReference) {
            var11_11.add(new Types.Variable("Class has no fields", "", null, 0, null));
        }
        var3_3.body = new Responses.VariablesResponseBody(var11_11);
        return CompletableFuture.completedFuture(var3_3);
    }

    private Set<String> getDuplicateNames(Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string : collection) {
            if (!hashSet2.contains(string)) {
                hashSet2.add(string);
                continue;
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    private static /* synthetic */ void lambda$handle$3(IVariableFormatter iVariableFormatter, Map map, Map map2, String string, List list) {
        Type type;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        for (Variable variable : list) {
            type = variable.getDeclaringType();
            if (type == null) continue;
            String string2 = iVariableFormatter.typeToString(type, map);
            String string3 = String.format("%s (%s)", variable.name, string2);
            if (!hashSet.add(string3)) {
                bl = true;
                break;
            }
            map2.put(variable, string3);
        }
        if (bl) {
            for (Variable variable : list) {
                type = variable.getDeclaringType();
                if (type == null) continue;
                map2.put(variable, String.format("%s (%s)", variable.name, type.name()));
            }
        }
    }

    private static /* synthetic */ String lambda$handle$2(Variable variable) {
        return variable.name;
    }

    private static /* synthetic */ boolean lambda$handle$1(Set set, Variable variable) {
        return set.contains(variable.name);
    }

    private static /* synthetic */ String lambda$handle$0(Variable variable) {
        return variable.name;
    }
}

