/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.formatter.NumericFormatEnum;
import com.microsoft.java.debug.core.adapter.variables.Variable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class VariableUtils {
    public static boolean hasChildren(Value value, boolean bl) {
        if (value == null || !(value instanceof ObjectReference)) {
            return false;
        }
        ReferenceType referenceType = ((ObjectReference)value).referenceType();
        if (referenceType instanceof ArrayType) {
            return ((ArrayReference)value).length() > 0;
        }
        return referenceType.allFields().stream().anyMatch(field -> bl || !field.isStatic());
    }

    public static List<Variable> listFieldVariables(ObjectReference objectReference, boolean bl) throws AbsentInformationException {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        ReferenceType referenceType = objectReference.referenceType();
        if (referenceType instanceof ArrayType) {
            int n = 0;
            boolean bl2 = Objects.equals(referenceType.signature(), "[Ljava/lang/Object;");
            for (Value value : ((ArrayReference)objectReference).getValues()) {
                Variable variable = new Variable(String.valueOf(n++), value);
                variable.setUnboundedType(bl2);
                arrayList.add(variable);
            }
            return arrayList;
        }
        List list = referenceType.allFields().stream().filter(field -> bl || !field.isStatic()).sorted((field, field2) -> {
            try {
                boolean bl = field.isStatic();
                boolean bl2 = field2.isStatic();
                if (bl && !bl2) {
                    return -1;
                }
                if (!bl && bl2) {
                    return 1;
                }
                return field.name().compareToIgnoreCase(field2.name());
            }
            catch (Exception exception) {
                return -1;
            }
        }).collect(Collectors.toList());
        VariableUtils.bulkFetchValues(list, DebugSettings.getCurrent().limitOfVariablesPerJdwpRequest, list2 -> {
            Map<Field, Value> map = objectReference.getValues((List<? extends Field>)list2);
            for (Field field : list2) {
                Variable variable = new Variable(field.name(), map.get(field));
                variable.field = field;
                arrayList.add(variable);
            }
        });
        return arrayList;
    }

    public static List<Variable> listFieldVariables(ObjectReference objectReference, int n, int n2) throws AbsentInformationException {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        Type type = objectReference.type();
        if (type instanceof ArrayType) {
            int n3 = n;
            boolean bl = Objects.equals(type.signature(), "[Ljava/lang/Object;");
            for (Value value : ((ArrayReference)objectReference).getValues(n, n2)) {
                Variable variable = new Variable(String.valueOf(n3++), value);
                variable.setUnboundedType(bl);
                arrayList.add(variable);
            }
            return arrayList;
        }
        throw new UnsupportedOperationException("Only Array type is supported.");
    }

    public static List<Variable> listLocalVariables(StackFrame stackFrame) throws AbsentInformationException {
        ArrayList<Variable> arrayList;
        block10: {
            arrayList = new ArrayList<Variable>();
            if (stackFrame.location().method().isNative()) {
                return arrayList;
            }
            try {
                List<LocalVariable> list = stackFrame.visibleVariables();
                VariableUtils.bulkFetchValues(list, DebugSettings.getCurrent().limitOfVariablesPerJdwpRequest, list2 -> {
                    Map<LocalVariable, Value> map = stackFrame.getValues((List<? extends LocalVariable>)list2);
                    for (LocalVariable localVariable : list2) {
                        Variable variable = new Variable(localVariable.name(), map.get(localVariable));
                        variable.local = localVariable;
                        arrayList.add(variable);
                    }
                });
            }
            catch (AbsentInformationException absentInformationException) {
                try {
                    if (stackFrame.location().method().argumentTypes().size() == 0) {
                        return arrayList;
                    }
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    // empty catch block
                }
                int n = 0;
                try {
                    List<Value> list = stackFrame.getArgumentValues();
                    if (list == null) {
                        return arrayList;
                    }
                    for (Value value : list) {
                        Variable variable = new Variable("arg" + n, value);
                        variable.argumentIndex = n++;
                        arrayList.add(variable);
                    }
                }
                catch (InternalException internalException) {
                    if (internalException.errorCode() == 32) break block10;
                    throw absentInformationException;
                }
            }
        }
        return arrayList;
    }

    public static Variable getThisVariable(StackFrame stackFrame) {
        ObjectReference objectReference = stackFrame.thisObject();
        if (objectReference == null) {
            return null;
        }
        return new Variable("this", objectReference);
    }

    public static List<Variable> listStaticVariables(StackFrame stackFrame) {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        ReferenceType referenceType = stackFrame.location().declaringType();
        List list = referenceType.allFields().stream().filter(TypeComponent::isStatic).collect(Collectors.toList());
        VariableUtils.bulkFetchValues(list, DebugSettings.getCurrent().limitOfVariablesPerJdwpRequest, list2 -> {
            Map<Field, Value> map = referenceType.getValues((List<? extends Field>)list2);
            for (Field field : list2) {
                Variable variable = new Variable(field.name(), map.get(field));
                variable.field = field;
                arrayList.add(variable);
            }
        });
        return arrayList;
    }

    public static void applyFormatterOptions(Map<String, Object> map, boolean bl) {
        Map<String, Object> map2 = map;
        boolean bl2 = DebugSettings.getCurrent().showQualifiedNames;
        if (bl || DebugSettings.getCurrent().showHex) {
            map2.put("numeric_format", (Object)NumericFormatEnum.HEX);
        }
        if (bl2) {
            map2.put("qualified_class_name", true);
        }
        if (DebugSettings.getCurrent().maxStringLength > 0) {
            map2.put("max_string_length", DebugSettings.getCurrent().maxStringLength);
        }
        if (DebugSettings.getCurrent().numericPrecision > 0) {
            map2.put("numeric_precision", DebugSettings.getCurrent().numericPrecision);
        }
    }

    public static String getEvaluateName(String string, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        if (bl) {
            if (string2 == null) {
                return null;
            }
            return String.format("%s[%s]", string2, string);
        }
        if (string2 == null) {
            return string;
        }
        return String.format("%s.%s", string2, string);
    }

    private static <T> void bulkFetchValues(List<T> list, int n, Consumer<List<T>> consumer) {
        int n2 = list.size();
        n = n < 1 ? 1 : n;
        int n3 = n2 / n + Math.min(n2 % n, 1);
        for (int i = 0; i < n3; ++i) {
            int n4 = i * n;
            int n5 = Math.min(n4 + n, n2);
            List<T> list2 = list.subList(n4, n5);
            consumer.accept(list2);
        }
    }

    private VariableUtils() {
    }
}

