/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.DebugException;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;

public final class StackFrameUtility {
    public static boolean isNative(StackFrame stackFrame) {
        return stackFrame.location().method().isNative();
    }

    public static void pop(StackFrame stackFrame) throws DebugException {
        try {
            stackFrame.thread().popFrames(stackFrame);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new DebugException(String.format("%s occurred popping stack frame.", incompatibleThreadStateException.getMessage()), incompatibleThreadStateException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new DebugException("Cannot pop up the top stack farme.", invalidStackFrameException);
        }
        catch (NativeMethodException nativeMethodException) {
            throw new DebugException("Cannot pop up the stack frame because it is not valid for a native method.", nativeMethodException);
        }
        catch (RuntimeException runtimeException) {
            throw new DebugException(String.format("Runtime exception happened: %s", runtimeException.getMessage()), runtimeException);
        }
    }

    public static String getName(StackFrame stackFrame) {
        return stackFrame.location().method().name();
    }

    public static String getSignature(StackFrame stackFrame) {
        return stackFrame.location().method().signature();
    }

    public static boolean isObsolete(StackFrame stackFrame) {
        return stackFrame.location().method().isObsolete();
    }

    public static String getSourcePath(StackFrame stackFrame) {
        try {
            return stackFrame.location().sourcePath();
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    public static ReferenceType getDeclaringType(StackFrame stackFrame) {
        return stackFrame.location().method().declaringType();
    }
}

