/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ScopesRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SCOPES);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Requests.ScopesArguments scopesArguments = (Requests.ScopesArguments)arguments;
        ArrayList<Types.Scope> arrayList = new ArrayList<Types.Scope>();
        StackFrameReference stackFrameReference = (StackFrameReference)iDebugAdapterContext.getRecyclableIdPool().getObjectById(scopesArguments.frameId);
        if (stackFrameReference == null) {
            response.body = new Responses.ScopesResponseBody(arrayList);
            return CompletableFuture.completedFuture(response);
        }
        ThreadReference threadReference = stackFrameReference.getThread();
        VariableProxy variableProxy = new VariableProxy(threadReference, "Local", stackFrameReference, null, null);
        int n = iDebugAdapterContext.getRecyclableIdPool().addObject(threadReference.uniqueID(), variableProxy);
        arrayList.add(new Types.Scope(variableProxy.getScope(), n, false));
        response.body = new Responses.ScopesResponseBody(arrayList);
        return CompletableFuture.completedFuture(response);
    }
}

