/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.IStackTraceProvider;
import com.microsoft.java.debug.core.adapter.stacktrace.DecodedMethod;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public class StackTraceRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.STACKTRACE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Requests.StackTraceArguments stackTraceArguments = (Requests.StackTraceArguments)arguments;
        ArrayList<Types.StackFrame> arrayList = new ArrayList<Types.StackFrame>();
        if (stackTraceArguments.startFrame < 0 || stackTraceArguments.levels < 0) {
            response.body = new Responses.StackTraceResponseBody(arrayList, 0);
            return CompletableFuture.completedFuture(response);
        }
        ThreadReference threadReference = DebugUtility.getThread(iDebugAdapterContext.getDebugSession(), stackTraceArguments.threadId);
        int n = 0;
        if (threadReference != null) {
            try {
                n = threadReference.frameCount();
                if (n <= stackTraceArguments.startFrame) {
                    response.body = new Responses.StackTraceResponseBody(arrayList, n);
                    return CompletableFuture.completedFuture(response);
                }
                StackFrame[] stackFrameArray = iDebugAdapterContext.getStackFrameManager().reloadStackFrames(threadReference);
                int n2 = stackTraceArguments.levels == 0 ? n - stackTraceArguments.startFrame : Math.min(n - stackTraceArguments.startFrame, stackTraceArguments.levels);
                for (int i = stackTraceArguments.startFrame; i < stackFrameArray.length && n2-- > 0; ++i) {
                    StackFrameReference stackFrameReference = new StackFrameReference(threadReference, i);
                    int n3 = iDebugAdapterContext.getRecyclableIdPool().addObject(threadReference.uniqueID(), stackFrameReference);
                    IStackTraceProvider iStackTraceProvider = iDebugAdapterContext.getProvider(IStackTraceProvider.class);
                    DecodedMethod decodedMethod = iStackTraceProvider.decode(threadReference.frame(i).location().method());
                    arrayList.add(this.convertDebuggerStackFrameToClient(stackFrameArray[i], n3, iDebugAdapterContext, decodedMethod));
                }
            }
            catch (AbsentInformationException | IncompatibleThreadStateException | ObjectCollectedException | IndexOutOfBoundsException | URISyntaxException exception) {
                exception.printStackTrace();
                System.out.println(exception.getMessage());
            }
        }
        response.body = new Responses.StackTraceResponseBody(arrayList, n);
        return CompletableFuture.completedFuture(response);
    }

    private Types.StackFrame convertDebuggerStackFrameToClient(StackFrame stackFrame, int n, IDebugAdapterContext iDebugAdapterContext, DecodedMethod decodedMethod) throws URISyntaxException, AbsentInformationException {
        Location location = stackFrame.location();
        Types.Source source = this.convertDebuggerSourceToClient(location, iDebugAdapterContext);
        String string = decodedMethod.format();
        int n2 = AdapterUtils.convertLineNumber(location.lineNumber(), iDebugAdapterContext.isDebuggerLinesStartAt1(), iDebugAdapterContext.isClientLinesStartAt1());
        if (n2 < 0 && !location.method().isNative()) {
            source = null;
        }
        String string2 = decodedMethod.isGenerated() ? "subtle" : null;
        return new Types.StackFrame(n, string, source, n2, iDebugAdapterContext.isClientColumnsStartAt1() ? 1 : 0, string2);
    }

    private Types.Source convertDebuggerSourceToClient(Location location, IDebugAdapterContext iDebugAdapterContext) throws URISyntaxException {
        String string = location.declaringType().name();
        String string2 = "";
        String string3 = "";
        try {
            string2 = location.sourceName();
            string3 = location.sourcePath();
        }
        catch (AbsentInformationException absentInformationException) {
            String string4 = AdapterUtils.parseEnclosingType(string);
            string2 = string4.substring(string4.lastIndexOf(46) + 1) + ".java";
            string3 = string4.replace('.', File.separatorChar) + ".java";
        }
        return StackTraceRequestHandler.convertDebuggerSourceToClient(string, string2, string3, iDebugAdapterContext);
    }

    public static Types.Source convertDebuggerSourceToClient(String string, String string3, String string4, IDebugAdapterContext iDebugAdapterContext) throws URISyntaxException {
        String string5 = iDebugAdapterContext.getSourceLookupCache().computeIfAbsent(string, string2 -> {
            String string3 = iDebugAdapterContext.getProvider(ISourceLookUpProvider.class).getSourceFileURI((String)string2, string4);
            return StringUtils.isBlank((CharSequence)string3) ? "" : string3;
        });
        if (!StringUtils.isBlank((CharSequence)string5)) {
            if (string5.startsWith("file:")) {
                String string6 = AdapterUtils.convertPath(string5, iDebugAdapterContext.isDebuggerPathsAreUri(), iDebugAdapterContext.isClientPathsAreUri());
                return new Types.Source(string3, string6, 0);
            }
            return new Types.Source(string3, string5, 0);
        }
        String string7 = AdapterUtils.sourceLookup(iDebugAdapterContext.getSourcePaths(), string4);
        if (string7 != null) {
            return new Types.Source(string3, string7, 0);
        }
        return null;
    }
}

