/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.stacktrace;

import com.microsoft.java.debug.core.adapter.formatter.SimpleTypeFormatter;
import com.microsoft.java.debug.core.adapter.stacktrace.DecodedMethod;
import com.sun.jdi.Method;
import java.util.List;
import java.util.stream.Collectors;

public class JavaMethod
implements DecodedMethod {
    private Method method;

    public JavaMethod(Method method) {
        this.method = method;
    }

    @Override
    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.method.declaringType().name();
        stringBuilder.append(SimpleTypeFormatter.trimTypeName(string));
        stringBuilder.append(".");
        List list = this.method.argumentTypeNames().stream().map(SimpleTypeFormatter::trimTypeName).collect(Collectors.toList());
        stringBuilder.append("(");
        stringBuilder.append(String.join((CharSequence)",", list));
        stringBuilder.append(")");
        if (this.method.isNative()) {
            stringBuilder.append("[native method]");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isGenerated() {
        return this.method.isBridge() || this.method.isSynthetic();
    }
}

