/*
 * Decompiled with CFR 0.152.
 */
package metaconfig.internal;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class Levenshtein$ {
    public static final Levenshtein$ MODULE$ = new Levenshtein$();

    public Option<String> closestCandidate(String query, Seq<String> candidates) {
        Seq candidatesWithRatio = (Seq)candidates.flatMap((Function1 & Serializable)candidate -> {
            double levDist = MODULE$.distance((String)candidate, query);
            double ratio = levDist / (double)package$.MODULE$.max(query.length(), candidate.length());
            if (ratio < 0.4) {
                return new Some((Object)new Tuple2(candidate, (Object)BoxesRunTime.boxToDouble((double)ratio)));
            }
            return None$.MODULE$;
        });
        Option result = ((IterableOps)candidatesWithRatio.sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._2$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).headOption().map((Function1 & Serializable)x$2 -> (String)x$2._1());
        return result.orElse((Function0 & Serializable)() -> MODULE$.prefixCandidate(query, candidates));
    }

    private Option<String> prefixCandidate(String query, Seq<String> candidates) {
        Seq prefixCandidates = (Seq)candidates.flatMap((Function1 & Serializable)candidate -> {
            if (candidate.startsWith(query)) {
                return new Some(candidate);
            }
            return None$.MODULE$;
        });
        return Option$.MODULE$.apply((Object)prefixCandidates).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Levenshtein$.$anonfun$prefixCandidate$2(x$3))).map((Function1 & Serializable)x$4 -> (String)x$4.head());
    }

    public int distance(String s1, String s2) {
        int[][] dist = (int[][])Array$.MODULE$.tabulate(s2.length() + 1, s1.length() + 1, (Function2)(JFunction2.mcIII.sp & Serializable)(j, i) -> {
            if (j == 0) {
                return i;
            }
            if (i == 0) {
                return j;
            }
            return 0;
        }, (ClassTag)ClassTag$.MODULE$.Int());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), s2.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), s1.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            dist$1[j$1][i] = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s2), j - 1) == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s1), i - 1) ? dist[j - 1][i - 1] : RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(dist[j - 1][i]), dist[j][i - 1])), dist[j - 1][i - 1]) + 1;
        }));
        return dist[s2.length()][s1.length()];
    }

    public static final /* synthetic */ boolean $anonfun$prefixCandidate$2(Seq x$3) {
        return x$3.length() == 1;
    }

    private Levenshtein$() {
    }
}

