use crate::kind::{SyntaxKind as SK, SyntaxNode, SyntaxToken, SML};
pub use rowan::ast::{AstNode, AstPtr};
pub const GENERATED_BY: &str = "crates/sml-syntax/build.rs";
pub type SyntaxNodePtr = rowan::ast::SyntaxNodePtr<SML>;
#[allow(unused)]
fn tokens<P>(parent: &P, kind: SK) -> impl Iterator<Item = SyntaxToken> + use<P>
where
    P: AstNode<Language = SML>,
{
    parent
        .syntax()
        .children_with_tokens()
        .filter_map(rowan::NodeOrToken::into_token)
        .filter(move |tok| tok.kind() == kind)
}
#[allow(unused)]
fn token_children<P, C>(parent: &P) -> impl Iterator<Item = C> + use<P, C>
where
    P: AstNode<Language = SML>,
    SyntaxToken: TryInto<C>,
{
    parent
        .syntax()
        .children_with_tokens()
        .filter_map(rowan::NodeOrToken::into_token)
        .filter_map(|x| x.try_into().ok())
}
#[allow(unused)]
fn node_children<P, C>(parent: &P) -> impl Iterator<Item = C> + use<P, C>
where
    P: AstNode<Language = SML>,
    C: AstNode<Language = SML>,
{
    parent.syntax().children().filter_map(C::cast)
}
pub enum DecOne {
    HoleDec(HoleDec),
    ValDec(ValDec),
    FunDec(FunDec),
    TyDec(TyDec),
    DatDec(DatDec),
    DatCopyDec(DatCopyDec),
    AbstypeDec(AbstypeDec),
    ExDec(ExDec),
    OpenDec(OpenDec),
    InfixDec(InfixDec),
    InfixrDec(InfixrDec),
    NonfixDec(NonfixDec),
    DoDec(DoDec),
    LocalDec(LocalDec),
    StructureDec(StructureDec),
    SignatureDec(SignatureDec),
    FunctorDec(FunctorDec),
    ExpDec(ExpDec),
    IncludeDec(IncludeDec),
    EsImportDec(EsImportDec),
}
impl AstNode for DecOne {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        matches!(
            kind, SK::HoleDec | SK::ValDec | SK::FunDec | SK::TyDec | SK::DatDec |
            SK::DatCopyDec | SK::AbstypeDec | SK::ExDec | SK::OpenDec | SK::InfixDec |
            SK::InfixrDec | SK::NonfixDec | SK::DoDec | SK::LocalDec | SK::StructureDec |
            SK::SignatureDec | SK::FunctorDec | SK::ExpDec | SK::IncludeDec |
            SK::EsImportDec
        )
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        let ret = match node.kind() {
            SK::HoleDec => Self::HoleDec(HoleDec(node)),
            SK::ValDec => Self::ValDec(ValDec(node)),
            SK::FunDec => Self::FunDec(FunDec(node)),
            SK::TyDec => Self::TyDec(TyDec(node)),
            SK::DatDec => Self::DatDec(DatDec(node)),
            SK::DatCopyDec => Self::DatCopyDec(DatCopyDec(node)),
            SK::AbstypeDec => Self::AbstypeDec(AbstypeDec(node)),
            SK::ExDec => Self::ExDec(ExDec(node)),
            SK::OpenDec => Self::OpenDec(OpenDec(node)),
            SK::InfixDec => Self::InfixDec(InfixDec(node)),
            SK::InfixrDec => Self::InfixrDec(InfixrDec(node)),
            SK::NonfixDec => Self::NonfixDec(NonfixDec(node)),
            SK::DoDec => Self::DoDec(DoDec(node)),
            SK::LocalDec => Self::LocalDec(LocalDec(node)),
            SK::StructureDec => Self::StructureDec(StructureDec(node)),
            SK::SignatureDec => Self::SignatureDec(SignatureDec(node)),
            SK::FunctorDec => Self::FunctorDec(FunctorDec(node)),
            SK::ExpDec => Self::ExpDec(ExpDec(node)),
            SK::IncludeDec => Self::IncludeDec(IncludeDec(node)),
            SK::EsImportDec => Self::EsImportDec(EsImportDec(node)),
            _ => return None,
        };
        Some(ret)
    }
    fn syntax(&self) -> &SyntaxNode {
        match self {
            Self::HoleDec(x) => x.syntax(),
            Self::ValDec(x) => x.syntax(),
            Self::FunDec(x) => x.syntax(),
            Self::TyDec(x) => x.syntax(),
            Self::DatDec(x) => x.syntax(),
            Self::DatCopyDec(x) => x.syntax(),
            Self::AbstypeDec(x) => x.syntax(),
            Self::ExDec(x) => x.syntax(),
            Self::OpenDec(x) => x.syntax(),
            Self::InfixDec(x) => x.syntax(),
            Self::InfixrDec(x) => x.syntax(),
            Self::NonfixDec(x) => x.syntax(),
            Self::DoDec(x) => x.syntax(),
            Self::LocalDec(x) => x.syntax(),
            Self::StructureDec(x) => x.syntax(),
            Self::SignatureDec(x) => x.syntax(),
            Self::FunctorDec(x) => x.syntax(),
            Self::ExpDec(x) => x.syntax(),
            Self::IncludeDec(x) => x.syntax(),
            Self::EsImportDec(x) => x.syntax(),
        }
    }
}
pub enum TyHeadKind {
    TypeKw,
    EqtypeKw,
}
impl TyHeadKind {
    pub fn to_str(&self) -> &'static str {
        match *self {
            Self::TypeKw => "type",
            Self::EqtypeKw => "eqtype",
        }
    }
}
pub struct TyHead {
    pub token: SyntaxToken,
    pub kind: TyHeadKind,
}
impl TryFrom<SyntaxToken> for TyHead {
    type Error = ();
    fn try_from(token: SyntaxToken) -> Result<Self, Self::Error> {
        let kind = match token.kind() {
            SK::TypeKw => TyHeadKind::TypeKw,
            SK::EqtypeKw => TyHeadKind::EqtypeKw,
            _ => return Err(()),
        };
        Ok(Self { token, kind })
    }
}
pub enum NameStarEqKind {
    Name,
    Star,
    Eq,
}
impl NameStarEqKind {
    pub fn to_str(&self) -> &'static str {
        match *self {
            Self::Name => "Name",
            Self::Star => "*",
            Self::Eq => "=",
        }
    }
}
pub struct NameStarEq {
    pub token: SyntaxToken,
    pub kind: NameStarEqKind,
}
impl TryFrom<SyntaxToken> for NameStarEq {
    type Error = ();
    fn try_from(token: SyntaxToken) -> Result<Self, Self::Error> {
        let kind = match token.kind() {
            SK::Name => NameStarEqKind::Name,
            SK::Star => NameStarEqKind::Star,
            SK::Eq => NameStarEqKind::Eq,
            _ => return Err(()),
        };
        Ok(Self { token, kind })
    }
}
pub enum Exp {
    HoleExp(HoleExp),
    WildcardExp(WildcardExp),
    OpAndalsoExp(OpAndalsoExp),
    OpOrelseExp(OpOrelseExp),
    SConExp(SConExp),
    PathExp(PathExp),
    RecordExp(RecordExp),
    SelectorExp(SelectorExp),
    ParenExp(ParenExp),
    TupleExp(TupleExp),
    ListExp(ListExp),
    VectorExp(VectorExp),
    SeqExp(SeqExp),
    LetExp(LetExp),
    AppExp(AppExp),
    InfixExp(InfixExp),
    TypedExp(TypedExp),
    AndalsoExp(AndalsoExp),
    OrelseExp(OrelseExp),
    HandleExp(HandleExp),
    RaiseExp(RaiseExp),
    IfExp(IfExp),
    WhileExp(WhileExp),
    CaseExp(CaseExp),
    FnExp(FnExp),
}
impl AstNode for Exp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        matches!(
            kind, SK::HoleExp | SK::WildcardExp | SK::OpAndalsoExp | SK::OpOrelseExp |
            SK::SConExp | SK::PathExp | SK::RecordExp | SK::SelectorExp | SK::ParenExp |
            SK::TupleExp | SK::ListExp | SK::VectorExp | SK::SeqExp | SK::LetExp |
            SK::AppExp | SK::InfixExp | SK::TypedExp | SK::AndalsoExp | SK::OrelseExp |
            SK::HandleExp | SK::RaiseExp | SK::IfExp | SK::WhileExp | SK::CaseExp |
            SK::FnExp
        )
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        let ret = match node.kind() {
            SK::HoleExp => Self::HoleExp(HoleExp(node)),
            SK::WildcardExp => Self::WildcardExp(WildcardExp(node)),
            SK::OpAndalsoExp => Self::OpAndalsoExp(OpAndalsoExp(node)),
            SK::OpOrelseExp => Self::OpOrelseExp(OpOrelseExp(node)),
            SK::SConExp => Self::SConExp(SConExp(node)),
            SK::PathExp => Self::PathExp(PathExp(node)),
            SK::RecordExp => Self::RecordExp(RecordExp(node)),
            SK::SelectorExp => Self::SelectorExp(SelectorExp(node)),
            SK::ParenExp => Self::ParenExp(ParenExp(node)),
            SK::TupleExp => Self::TupleExp(TupleExp(node)),
            SK::ListExp => Self::ListExp(ListExp(node)),
            SK::VectorExp => Self::VectorExp(VectorExp(node)),
            SK::SeqExp => Self::SeqExp(SeqExp(node)),
            SK::LetExp => Self::LetExp(LetExp(node)),
            SK::AppExp => Self::AppExp(AppExp(node)),
            SK::InfixExp => Self::InfixExp(InfixExp(node)),
            SK::TypedExp => Self::TypedExp(TypedExp(node)),
            SK::AndalsoExp => Self::AndalsoExp(AndalsoExp(node)),
            SK::OrelseExp => Self::OrelseExp(OrelseExp(node)),
            SK::HandleExp => Self::HandleExp(HandleExp(node)),
            SK::RaiseExp => Self::RaiseExp(RaiseExp(node)),
            SK::IfExp => Self::IfExp(IfExp(node)),
            SK::WhileExp => Self::WhileExp(WhileExp(node)),
            SK::CaseExp => Self::CaseExp(CaseExp(node)),
            SK::FnExp => Self::FnExp(FnExp(node)),
            _ => return None,
        };
        Some(ret)
    }
    fn syntax(&self) -> &SyntaxNode {
        match self {
            Self::HoleExp(x) => x.syntax(),
            Self::WildcardExp(x) => x.syntax(),
            Self::OpAndalsoExp(x) => x.syntax(),
            Self::OpOrelseExp(x) => x.syntax(),
            Self::SConExp(x) => x.syntax(),
            Self::PathExp(x) => x.syntax(),
            Self::RecordExp(x) => x.syntax(),
            Self::SelectorExp(x) => x.syntax(),
            Self::ParenExp(x) => x.syntax(),
            Self::TupleExp(x) => x.syntax(),
            Self::ListExp(x) => x.syntax(),
            Self::VectorExp(x) => x.syntax(),
            Self::SeqExp(x) => x.syntax(),
            Self::LetExp(x) => x.syntax(),
            Self::AppExp(x) => x.syntax(),
            Self::InfixExp(x) => x.syntax(),
            Self::TypedExp(x) => x.syntax(),
            Self::AndalsoExp(x) => x.syntax(),
            Self::OrelseExp(x) => x.syntax(),
            Self::HandleExp(x) => x.syntax(),
            Self::RaiseExp(x) => x.syntax(),
            Self::IfExp(x) => x.syntax(),
            Self::WhileExp(x) => x.syntax(),
            Self::CaseExp(x) => x.syntax(),
            Self::FnExp(x) => x.syntax(),
        }
    }
}
pub enum SigExp {
    SigSigExp(SigSigExp),
    NameSigExp(NameSigExp),
    WhereTypeSigExp(WhereTypeSigExp),
    WhereSigExp(WhereSigExp),
}
impl AstNode for SigExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        matches!(
            kind, SK::SigSigExp | SK::NameSigExp | SK::WhereTypeSigExp | SK::WhereSigExp
        )
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        let ret = match node.kind() {
            SK::SigSigExp => Self::SigSigExp(SigSigExp(node)),
            SK::NameSigExp => Self::NameSigExp(NameSigExp(node)),
            SK::WhereTypeSigExp => Self::WhereTypeSigExp(WhereTypeSigExp(node)),
            SK::WhereSigExp => Self::WhereSigExp(WhereSigExp(node)),
            _ => return None,
        };
        Some(ret)
    }
    fn syntax(&self) -> &SyntaxNode {
        match self {
            Self::SigSigExp(x) => x.syntax(),
            Self::NameSigExp(x) => x.syntax(),
            Self::WhereTypeSigExp(x) => x.syntax(),
            Self::WhereSigExp(x) => x.syntax(),
        }
    }
}
pub enum Pat {
    WildcardPat(WildcardPat),
    SConPat(SConPat),
    ConPat(ConPat),
    RecordPat(RecordPat),
    ParenPat(ParenPat),
    TuplePat(TuplePat),
    ListPat(ListPat),
    VectorPat(VectorPat),
    InfixPat(InfixPat),
    TypedPat(TypedPat),
    AsPat(AsPat),
    OrPat(OrPat),
}
impl AstNode for Pat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        matches!(
            kind, SK::WildcardPat | SK::SConPat | SK::ConPat | SK::RecordPat |
            SK::ParenPat | SK::TuplePat | SK::ListPat | SK::VectorPat | SK::InfixPat |
            SK::TypedPat | SK::AsPat | SK::OrPat
        )
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        let ret = match node.kind() {
            SK::WildcardPat => Self::WildcardPat(WildcardPat(node)),
            SK::SConPat => Self::SConPat(SConPat(node)),
            SK::ConPat => Self::ConPat(ConPat(node)),
            SK::RecordPat => Self::RecordPat(RecordPat(node)),
            SK::ParenPat => Self::ParenPat(ParenPat(node)),
            SK::TuplePat => Self::TuplePat(TuplePat(node)),
            SK::ListPat => Self::ListPat(ListPat(node)),
            SK::VectorPat => Self::VectorPat(VectorPat(node)),
            SK::InfixPat => Self::InfixPat(InfixPat(node)),
            SK::TypedPat => Self::TypedPat(TypedPat(node)),
            SK::AsPat => Self::AsPat(AsPat(node)),
            SK::OrPat => Self::OrPat(OrPat(node)),
            _ => return None,
        };
        Some(ret)
    }
    fn syntax(&self) -> &SyntaxNode {
        match self {
            Self::WildcardPat(x) => x.syntax(),
            Self::SConPat(x) => x.syntax(),
            Self::ConPat(x) => x.syntax(),
            Self::RecordPat(x) => x.syntax(),
            Self::ParenPat(x) => x.syntax(),
            Self::TuplePat(x) => x.syntax(),
            Self::ListPat(x) => x.syntax(),
            Self::VectorPat(x) => x.syntax(),
            Self::InfixPat(x) => x.syntax(),
            Self::TypedPat(x) => x.syntax(),
            Self::AsPat(x) => x.syntax(),
            Self::OrPat(x) => x.syntax(),
        }
    }
}
pub enum FunBindCaseHead {
    PrefixFunBindCaseHead(PrefixFunBindCaseHead),
    InfixFunBindCaseHead(InfixFunBindCaseHead),
}
impl AstNode for FunBindCaseHead {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        matches!(kind, SK::PrefixFunBindCaseHead | SK::InfixFunBindCaseHead)
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        let ret = match node.kind() {
            SK::PrefixFunBindCaseHead => {
                Self::PrefixFunBindCaseHead(PrefixFunBindCaseHead(node))
            }
            SK::InfixFunBindCaseHead => {
                Self::InfixFunBindCaseHead(InfixFunBindCaseHead(node))
            }
            _ => return None,
        };
        Some(ret)
    }
    fn syntax(&self) -> &SyntaxNode {
        match self {
            Self::PrefixFunBindCaseHead(x) => x.syntax(),
            Self::InfixFunBindCaseHead(x) => x.syntax(),
        }
    }
}
pub enum ExBindInner {
    OfTy(OfTy),
    EqExp(EqExp),
}
impl AstNode for ExBindInner {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        matches!(kind, SK::OfTy | SK::EqExp)
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        let ret = match node.kind() {
            SK::OfTy => Self::OfTy(OfTy(node)),
            SK::EqExp => Self::EqExp(EqExp(node)),
            _ => return None,
        };
        Some(ret)
    }
    fn syntax(&self) -> &SyntaxNode {
        match self {
            Self::OfTy(x) => x.syntax(),
            Self::EqExp(x) => x.syntax(),
        }
    }
}
pub enum FunctorArg {
    FunctorArgNameSigExp(FunctorArgNameSigExp),
    Dec(Dec),
}
impl AstNode for FunctorArg {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        matches!(kind, SK::FunctorArgNameSigExp | SK::Dec)
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        let ret = match node.kind() {
            SK::FunctorArgNameSigExp => {
                Self::FunctorArgNameSigExp(FunctorArgNameSigExp(node))
            }
            SK::Dec => Self::Dec(Dec(node)),
            _ => return None,
        };
        Some(ret)
    }
    fn syntax(&self) -> &SyntaxNode {
        match self {
            Self::FunctorArgNameSigExp(x) => x.syntax(),
            Self::Dec(x) => x.syntax(),
        }
    }
}
pub enum StrExp {
    StructStrExp(StructStrExp),
    PathStrExp(PathStrExp),
    AscriptionStrExp(AscriptionStrExp),
    AppStrExp(AppStrExp),
    LetStrExp(LetStrExp),
}
impl AstNode for StrExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        matches!(
            kind, SK::StructStrExp | SK::PathStrExp | SK::AscriptionStrExp |
            SK::AppStrExp | SK::LetStrExp
        )
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        let ret = match node.kind() {
            SK::StructStrExp => Self::StructStrExp(StructStrExp(node)),
            SK::PathStrExp => Self::PathStrExp(PathStrExp(node)),
            SK::AscriptionStrExp => Self::AscriptionStrExp(AscriptionStrExp(node)),
            SK::AppStrExp => Self::AppStrExp(AppStrExp(node)),
            SK::LetStrExp => Self::LetStrExp(LetStrExp(node)),
            _ => return None,
        };
        Some(ret)
    }
    fn syntax(&self) -> &SyntaxNode {
        match self {
            Self::StructStrExp(x) => x.syntax(),
            Self::PathStrExp(x) => x.syntax(),
            Self::AscriptionStrExp(x) => x.syntax(),
            Self::AppStrExp(x) => x.syntax(),
            Self::LetStrExp(x) => x.syntax(),
        }
    }
}
pub enum EsImportSpecSourceKind {
    Name,
    StringLit,
}
impl EsImportSpecSourceKind {
    pub fn to_str(&self) -> &'static str {
        match *self {
            Self::Name => "Name",
            Self::StringLit => "StringLit",
        }
    }
}
pub struct EsImportSpecSource {
    pub token: SyntaxToken,
    pub kind: EsImportSpecSourceKind,
}
impl TryFrom<SyntaxToken> for EsImportSpecSource {
    type Error = ();
    fn try_from(token: SyntaxToken) -> Result<Self, Self::Error> {
        let kind = match token.kind() {
            SK::Name => EsImportSpecSourceKind::Name,
            SK::StringLit => EsImportSpecSourceKind::StringLit,
            _ => return Err(()),
        };
        Ok(Self { token, kind })
    }
}
pub enum AscriptionKind {
    Colon,
    ColonGt,
}
impl AscriptionKind {
    pub fn to_str(&self) -> &'static str {
        match *self {
            Self::Colon => ":",
            Self::ColonGt => ":>",
        }
    }
}
pub struct Ascription {
    pub token: SyntaxToken,
    pub kind: AscriptionKind,
}
impl TryFrom<SyntaxToken> for Ascription {
    type Error = ();
    fn try_from(token: SyntaxToken) -> Result<Self, Self::Error> {
        let kind = match token.kind() {
            SK::Colon => AscriptionKind::Colon,
            SK::ColonGt => AscriptionKind::ColonGt,
            _ => return Err(()),
        };
        Ok(Self { token, kind })
    }
}
pub enum AppStrExpArg {
    AppStrExpArgStrExp(AppStrExpArgStrExp),
    Dec(Dec),
}
impl AstNode for AppStrExpArg {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        matches!(kind, SK::AppStrExpArgStrExp | SK::Dec)
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        let ret = match node.kind() {
            SK::AppStrExpArgStrExp => Self::AppStrExpArgStrExp(AppStrExpArgStrExp(node)),
            SK::Dec => Self::Dec(Dec(node)),
            _ => return None,
        };
        Some(ret)
    }
    fn syntax(&self) -> &SyntaxNode {
        match self {
            Self::AppStrExpArgStrExp(x) => x.syntax(),
            Self::Dec(x) => x.syntax(),
        }
    }
}
pub enum WhereOrAndKind {
    WhereKw,
    AndKw,
}
impl WhereOrAndKind {
    pub fn to_str(&self) -> &'static str {
        match *self {
            Self::WhereKw => "where",
            Self::AndKw => "and",
        }
    }
}
pub struct WhereOrAnd {
    pub token: SyntaxToken,
    pub kind: WhereOrAndKind,
}
impl TryFrom<SyntaxToken> for WhereOrAnd {
    type Error = ();
    fn try_from(token: SyntaxToken) -> Result<Self, Self::Error> {
        let kind = match token.kind() {
            SK::WhereKw => WhereOrAndKind::WhereKw,
            SK::AndKw => WhereOrAndKind::AndKw,
            _ => return Err(()),
        };
        Ok(Self { token, kind })
    }
}
pub enum Ty {
    HoleTy(HoleTy),
    WildcardTy(WildcardTy),
    TyVarTy(TyVarTy),
    RecordTy(RecordTy),
    ConTy(ConTy),
    OneArgConTy(OneArgConTy),
    TupleTy(TupleTy),
    FnTy(FnTy),
    ParenTy(ParenTy),
}
impl AstNode for Ty {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        matches!(
            kind, SK::HoleTy | SK::WildcardTy | SK::TyVarTy | SK::RecordTy | SK::ConTy |
            SK::OneArgConTy | SK::TupleTy | SK::FnTy | SK::ParenTy
        )
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        let ret = match node.kind() {
            SK::HoleTy => Self::HoleTy(HoleTy(node)),
            SK::WildcardTy => Self::WildcardTy(WildcardTy(node)),
            SK::TyVarTy => Self::TyVarTy(TyVarTy(node)),
            SK::RecordTy => Self::RecordTy(RecordTy(node)),
            SK::ConTy => Self::ConTy(ConTy(node)),
            SK::OneArgConTy => Self::OneArgConTy(OneArgConTy(node)),
            SK::TupleTy => Self::TupleTy(TupleTy(node)),
            SK::FnTy => Self::FnTy(FnTy(node)),
            SK::ParenTy => Self::ParenTy(ParenTy(node)),
            _ => return None,
        };
        Some(ret)
    }
    fn syntax(&self) -> &SyntaxNode {
        match self {
            Self::HoleTy(x) => x.syntax(),
            Self::WildcardTy(x) => x.syntax(),
            Self::TyVarTy(x) => x.syntax(),
            Self::RecordTy(x) => x.syntax(),
            Self::ConTy(x) => x.syntax(),
            Self::OneArgConTy(x) => x.syntax(),
            Self::TupleTy(x) => x.syntax(),
            Self::FnTy(x) => x.syntax(),
            Self::ParenTy(x) => x.syntax(),
        }
    }
}
pub enum SConKind {
    IntLit,
    RealLit,
    WordLit,
    CharLit,
    StringLit,
}
impl SConKind {
    pub fn to_str(&self) -> &'static str {
        match *self {
            Self::IntLit => "IntLit",
            Self::RealLit => "RealLit",
            Self::WordLit => "WordLit",
            Self::CharLit => "CharLit",
            Self::StringLit => "StringLit",
        }
    }
}
pub struct SCon {
    pub token: SyntaxToken,
    pub kind: SConKind,
}
impl TryFrom<SyntaxToken> for SCon {
    type Error = ();
    fn try_from(token: SyntaxToken) -> Result<Self, Self::Error> {
        let kind = match token.kind() {
            SK::IntLit => SConKind::IntLit,
            SK::RealLit => SConKind::RealLit,
            SK::WordLit => SConKind::WordLit,
            SK::CharLit => SConKind::CharLit,
            SK::StringLit => SConKind::StringLit,
            _ => return Err(()),
        };
        Ok(Self { token, kind })
    }
}
pub enum LabKind {
    Name,
    Star,
    IntLit,
}
impl LabKind {
    pub fn to_str(&self) -> &'static str {
        match *self {
            Self::Name => "Name",
            Self::Star => "*",
            Self::IntLit => "IntLit",
        }
    }
}
pub struct Lab {
    pub token: SyntaxToken,
    pub kind: LabKind,
}
impl TryFrom<SyntaxToken> for Lab {
    type Error = ();
    fn try_from(token: SyntaxToken) -> Result<Self, Self::Error> {
        let kind = match token.kind() {
            SK::Name => LabKind::Name,
            SK::Star => LabKind::Star,
            SK::IntLit => LabKind::IntLit,
            _ => return Err(()),
        };
        Ok(Self { token, kind })
    }
}
pub enum PatRowInner {
    RestPatRow(RestPatRow),
    LabAndPatPatRow(LabAndPatPatRow),
    LabPatRow(LabPatRow),
}
impl AstNode for PatRowInner {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        matches!(kind, SK::RestPatRow | SK::LabAndPatPatRow | SK::LabPatRow)
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        let ret = match node.kind() {
            SK::RestPatRow => Self::RestPatRow(RestPatRow(node)),
            SK::LabAndPatPatRow => Self::LabAndPatPatRow(LabAndPatPatRow(node)),
            SK::LabPatRow => Self::LabPatRow(LabPatRow(node)),
            _ => return None,
        };
        Some(ret)
    }
    fn syntax(&self) -> &SyntaxNode {
        match self {
            Self::RestPatRow(x) => x.syntax(),
            Self::LabAndPatPatRow(x) => x.syntax(),
            Self::LabPatRow(x) => x.syntax(),
        }
    }
}
#[derive(Clone)]
pub struct Root(SyntaxNode);
impl Root {
    pub fn decs(&self) -> impl Iterator<Item = Dec> + use<> {
        node_children(self)
    }
}
impl std::fmt::Debug for Root {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        self.syntax().fmt(f)
    }
}
impl AstNode for Root {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::Root
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct Dec(SyntaxNode);
impl Dec {
    pub fn dec_with_tail(&self) -> Option<DecWithTail> {
        node_children(self).next()
    }
    pub fn semicolon(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Semicolon).next()
    }
}
impl AstNode for Dec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::Dec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct DecWithTail(SyntaxNode);
impl DecWithTail {
    pub fn dec_in_seqs(&self) -> impl Iterator<Item = DecInSeq> + use<> {
        node_children(self)
    }
    pub fn sharing_tails(&self) -> impl Iterator<Item = SharingTail> + use<> {
        node_children(self)
    }
}
impl AstNode for DecWithTail {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::DecWithTail
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct DecInSeq(SyntaxNode);
impl DecInSeq {
    pub fn dec_one(&self) -> Option<DecOne> {
        node_children(self).next()
    }
    pub fn semicolon(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Semicolon).next()
    }
}
impl AstNode for DecInSeq {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::DecInSeq
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct SharingTail(SyntaxNode);
impl SharingTail {
    pub fn sharing_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::SharingKw).next()
    }
    pub fn type_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::TypeKw).next()
    }
    pub fn path_eqs(&self) -> impl Iterator<Item = PathEq> + use<> {
        node_children(self)
    }
}
impl AstNode for SharingTail {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::SharingTail
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct HoleDec(SyntaxNode);
impl HoleDec {
    pub fn dot_dot_dot(&self) -> Option<SyntaxToken> {
        tokens(self, SK::DotDotDot).next()
    }
}
impl AstNode for HoleDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::HoleDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ValDec(SyntaxNode);
impl ValDec {
    pub fn val_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::ValKw).next()
    }
    pub fn ty_var_seq(&self) -> Option<TyVarSeq> {
        node_children(self).next()
    }
    pub fn val_binds(&self) -> impl Iterator<Item = ValBind> + use<> {
        node_children(self)
    }
}
impl AstNode for ValDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ValDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct FunDec(SyntaxNode);
impl FunDec {
    pub fn fun_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::FunKw).next()
    }
    pub fn ty_var_seq(&self) -> Option<TyVarSeq> {
        node_children(self).next()
    }
    pub fn fun_binds(&self) -> impl Iterator<Item = FunBind> + use<> {
        node_children(self)
    }
}
impl AstNode for FunDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::FunDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TyDec(SyntaxNode);
impl TyDec {
    pub fn ty_head(&self) -> Option<TyHead> {
        token_children(self).next()
    }
    pub fn ty_binds(&self) -> impl Iterator<Item = TyBind> + use<> {
        node_children(self)
    }
}
impl AstNode for TyDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TyDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct DatDec(SyntaxNode);
impl DatDec {
    pub fn datatype_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::DatatypeKw).next()
    }
    pub fn dat_binds(&self) -> impl Iterator<Item = DatBind> + use<> {
        node_children(self)
    }
    pub fn with_type(&self) -> Option<WithType> {
        node_children(self).next()
    }
}
impl AstNode for DatDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::DatDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct DatCopyDec(SyntaxNode);
impl DatCopyDec {
    pub fn lhs_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::DatatypeKw).next()
    }
    pub fn name(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Name).next()
    }
    pub fn eq(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Eq).next()
    }
    pub fn rhs_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::DatatypeKw).nth(1usize)
    }
    pub fn path(&self) -> Option<Path> {
        node_children(self).next()
    }
}
impl AstNode for DatCopyDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::DatCopyDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct AbstypeDec(SyntaxNode);
impl AbstypeDec {
    pub fn abstype_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AbstypeKw).next()
    }
    pub fn dat_binds(&self) -> impl Iterator<Item = DatBind> + use<> {
        node_children(self)
    }
    pub fn with_type(&self) -> Option<WithType> {
        node_children(self).next()
    }
    pub fn with_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::WithKw).next()
    }
    pub fn decs(&self) -> impl Iterator<Item = Dec> + use<> {
        node_children(self)
    }
    pub fn end_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::EndKw).next()
    }
}
impl AstNode for AbstypeDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::AbstypeDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ExDec(SyntaxNode);
impl ExDec {
    pub fn exception_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::ExceptionKw).next()
    }
    pub fn ex_binds(&self) -> impl Iterator<Item = ExBind> + use<> {
        node_children(self)
    }
}
impl AstNode for ExDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ExDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct OpenDec(SyntaxNode);
impl OpenDec {
    pub fn open_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OpenKw).next()
    }
    pub fn paths(&self) -> impl Iterator<Item = Path> + use<> {
        node_children(self)
    }
}
impl AstNode for OpenDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::OpenDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct InfixDec(SyntaxNode);
impl InfixDec {
    pub fn infix_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::InfixKw).next()
    }
    pub fn int_lit(&self) -> Option<SyntaxToken> {
        tokens(self, SK::IntLit).next()
    }
    pub fn name_star_eqs(&self) -> impl Iterator<Item = NameStarEq> + use<> {
        token_children(self)
    }
}
impl AstNode for InfixDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::InfixDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct InfixrDec(SyntaxNode);
impl InfixrDec {
    pub fn infixr_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::InfixrKw).next()
    }
    pub fn int_lit(&self) -> Option<SyntaxToken> {
        tokens(self, SK::IntLit).next()
    }
    pub fn name_star_eqs(&self) -> impl Iterator<Item = NameStarEq> + use<> {
        token_children(self)
    }
}
impl AstNode for InfixrDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::InfixrDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct NonfixDec(SyntaxNode);
impl NonfixDec {
    pub fn nonfix_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::NonfixKw).next()
    }
    pub fn name_star_eqs(&self) -> impl Iterator<Item = NameStarEq> + use<> {
        token_children(self)
    }
}
impl AstNode for NonfixDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::NonfixDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct DoDec(SyntaxNode);
impl DoDec {
    pub fn do_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::DoKw).next()
    }
    pub fn exp(&self) -> Option<Exp> {
        node_children(self).next()
    }
}
impl AstNode for DoDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::DoDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct LocalDec(SyntaxNode);
impl LocalDec {
    pub fn local_dec_hd(&self) -> Option<LocalDecHd> {
        node_children(self).next()
    }
    pub fn local_dec_tl(&self) -> Option<LocalDecTl> {
        node_children(self).next()
    }
    pub fn end_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::EndKw).next()
    }
}
impl AstNode for LocalDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::LocalDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct StructureDec(SyntaxNode);
impl StructureDec {
    pub fn structure_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::StructureKw).next()
    }
    pub fn str_binds(&self) -> impl Iterator<Item = StrBind> + use<> {
        node_children(self)
    }
}
impl AstNode for StructureDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::StructureDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct SignatureDec(SyntaxNode);
impl SignatureDec {
    pub fn signature_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::SignatureKw).next()
    }
    pub fn sig_binds(&self) -> impl Iterator<Item = SigBind> + use<> {
        node_children(self)
    }
}
impl AstNode for SignatureDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::SignatureDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct FunctorDec(SyntaxNode);
impl FunctorDec {
    pub fn functor_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::FunctorKw).next()
    }
    pub fn functor_binds(&self) -> impl Iterator<Item = FunctorBind> + use<> {
        node_children(self)
    }
}
impl AstNode for FunctorDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::FunctorDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ExpDec(SyntaxNode);
impl ExpDec {
    pub fn exp(&self) -> Option<Exp> {
        node_children(self).next()
    }
}
impl AstNode for ExpDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ExpDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct IncludeDec(SyntaxNode);
impl IncludeDec {
    pub fn include_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::IncludeKw).next()
    }
    pub fn sig_exps(&self) -> impl Iterator<Item = SigExp> + use<> {
        node_children(self)
    }
}
impl AstNode for IncludeDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::IncludeDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct EsImportDec(SyntaxNode);
impl EsImportDec {
    pub fn esimport_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::EsimportKw).next()
    }
    pub fn attrs(&self) -> Option<EsImportAttrs> {
        node_children(self).next()
    }
    pub fn default_import(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Name).next()
    }
    pub fn comma(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Comma).next()
    }
    pub fn specs(&self) -> Option<EsImportSpecs> {
        node_children(self).next()
    }
    pub fn from_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Name).nth(1usize)
    }
    pub fn module_name(&self) -> Option<SyntaxToken> {
        tokens(self, SK::StringLit).next()
    }
}
impl AstNode for EsImportDec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::EsImportDec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TyVarSeq(SyntaxNode);
impl TyVarSeq {
    pub fn l_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LRound).next()
    }
    pub fn ty_var_args(&self) -> impl Iterator<Item = TyVarArg> + use<> {
        node_children(self)
    }
    pub fn r_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RRound).next()
    }
}
impl AstNode for TyVarSeq {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TyVarSeq
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ValBind(SyntaxNode);
impl ValBind {
    pub fn rec_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RecKw).next()
    }
    pub fn pat(&self) -> Option<Pat> {
        node_children(self).next()
    }
    pub fn eq_exp(&self) -> Option<EqExp> {
        node_children(self).next()
    }
    pub fn and_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AndKw).next()
    }
}
impl AstNode for ValBind {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ValBind
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct FunBind(SyntaxNode);
impl FunBind {
    pub fn bar(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Bar).next()
    }
    pub fn fun_bind_cases(&self) -> impl Iterator<Item = FunBindCase> + use<> {
        node_children(self)
    }
    pub fn and_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AndKw).next()
    }
}
impl AstNode for FunBind {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::FunBind
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TyBind(SyntaxNode);
impl TyBind {
    pub fn ty_var_seq(&self) -> Option<TyVarSeq> {
        node_children(self).next()
    }
    pub fn name(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Name).next()
    }
    pub fn eq_ty(&self) -> Option<EqTy> {
        node_children(self).next()
    }
    pub fn and_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AndKw).next()
    }
}
impl AstNode for TyBind {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TyBind
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct DatBind(SyntaxNode);
impl DatBind {
    pub fn ty_var_seq(&self) -> Option<TyVarSeq> {
        node_children(self).next()
    }
    pub fn name(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Name).next()
    }
    pub fn eq_con_binds(&self) -> Option<EqConBinds> {
        node_children(self).next()
    }
    pub fn and_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AndKw).next()
    }
}
impl AstNode for DatBind {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::DatBind
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct WithType(SyntaxNode);
impl WithType {
    pub fn withtype_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::WithtypeKw).next()
    }
    pub fn ty_binds(&self) -> impl Iterator<Item = TyBind> + use<> {
        node_children(self)
    }
}
impl AstNode for WithType {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::WithType
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct Path(SyntaxNode);
impl Path {
    pub fn name_star_eq_dots(&self) -> impl Iterator<Item = NameStarEqDot> + use<> {
        node_children(self)
    }
}
impl AstNode for Path {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::Path
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ExBind(SyntaxNode);
impl ExBind {
    pub fn op_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OpKw).next()
    }
    pub fn name_star_eq(&self) -> Option<NameStarEq> {
        token_children(self).next()
    }
    pub fn ex_bind_inner(&self) -> Option<ExBindInner> {
        node_children(self).next()
    }
    pub fn and_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AndKw).next()
    }
}
impl AstNode for ExBind {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ExBind
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct LocalDecHd(SyntaxNode);
impl LocalDecHd {
    pub fn local_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LocalKw).next()
    }
    pub fn decs(&self) -> impl Iterator<Item = Dec> + use<> {
        node_children(self)
    }
}
impl AstNode for LocalDecHd {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::LocalDecHd
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct LocalDecTl(SyntaxNode);
impl LocalDecTl {
    pub fn in_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::InKw).next()
    }
    pub fn decs(&self) -> impl Iterator<Item = Dec> + use<> {
        node_children(self)
    }
}
impl AstNode for LocalDecTl {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::LocalDecTl
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct StrBind(SyntaxNode);
impl StrBind {
    pub fn name(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Name).next()
    }
    pub fn ascription_tail(&self) -> Option<AscriptionTail> {
        node_children(self).next()
    }
    pub fn eq_str_exp(&self) -> Option<EqStrExp> {
        node_children(self).next()
    }
    pub fn and_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AndKw).next()
    }
}
impl AstNode for StrBind {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::StrBind
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct SigBind(SyntaxNode);
impl SigBind {
    pub fn name(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Name).next()
    }
    pub fn eq(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Eq).next()
    }
    pub fn sig_exp(&self) -> Option<SigExp> {
        node_children(self).next()
    }
    pub fn and_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AndKw).next()
    }
}
impl AstNode for SigBind {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::SigBind
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct FunctorBind(SyntaxNode);
impl FunctorBind {
    pub fn functor_name(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Name).next()
    }
    pub fn l_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LRound).next()
    }
    pub fn functor_args(&self) -> impl Iterator<Item = FunctorArg> + use<> {
        node_children(self)
    }
    pub fn r_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RRound).next()
    }
    pub fn ascription_tail(&self) -> Option<AscriptionTail> {
        node_children(self).next()
    }
    pub fn eq(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Eq).next()
    }
    pub fn body(&self) -> Option<StrExp> {
        node_children(self).next()
    }
    pub fn and_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AndKw).next()
    }
}
impl AstNode for FunctorBind {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::FunctorBind
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct EsImportAttrs(SyntaxNode);
impl EsImportAttrs {
    pub fn l_square(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LSquare).next()
    }
    pub fn names(&self) -> impl Iterator<Item = SyntaxToken> + use<> {
        tokens(self, SK::Name)
    }
    pub fn r_square(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RSquare).next()
    }
}
impl AstNode for EsImportAttrs {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::EsImportAttrs
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct EsImportSpecs(SyntaxNode);
impl EsImportSpecs {
    pub fn l_curly(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LCurly).next()
    }
    pub fn es_import_spec_args(&self) -> impl Iterator<Item = EsImportSpecArg> + use<> {
        node_children(self)
    }
    pub fn r_curly(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RCurly).next()
    }
}
impl AstNode for EsImportSpecs {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::EsImportSpecs
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct EqExp(SyntaxNode);
impl EqExp {
    pub fn eq(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Eq).next()
    }
    pub fn exp(&self) -> Option<Exp> {
        node_children(self).next()
    }
}
impl AstNode for EqExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::EqExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct EqTy(SyntaxNode);
impl EqTy {
    pub fn eq(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Eq).next()
    }
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
}
impl AstNode for EqTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::EqTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct FunBindCase(SyntaxNode);
impl FunBindCase {
    pub fn fun_bind_case_head(&self) -> Option<FunBindCaseHead> {
        node_children(self).next()
    }
    pub fn pats(&self) -> impl Iterator<Item = Pat> + use<> {
        node_children(self)
    }
    pub fn ty_annotation(&self) -> Option<TyAnnotation> {
        node_children(self).next()
    }
    pub fn eq_exp(&self) -> Option<EqExp> {
        node_children(self).next()
    }
    pub fn bar(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Bar).next()
    }
}
impl AstNode for FunBindCase {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::FunBindCase
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TyAnnotation(SyntaxNode);
impl TyAnnotation {
    pub fn ascription(&self) -> Option<Ascription> {
        token_children(self).next()
    }
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
}
impl AstNode for TyAnnotation {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TyAnnotation
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct EqConBinds(SyntaxNode);
impl EqConBinds {
    pub fn eq(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Eq).next()
    }
    pub fn bar(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Bar).next()
    }
    pub fn con_binds(&self) -> impl Iterator<Item = ConBind> + use<> {
        node_children(self)
    }
}
impl AstNode for EqConBinds {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::EqConBinds
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ConBind(SyntaxNode);
impl ConBind {
    pub fn op_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OpKw).next()
    }
    pub fn name_star_eq(&self) -> Option<NameStarEq> {
        token_children(self).next()
    }
    pub fn of_ty(&self) -> Option<OfTy> {
        node_children(self).next()
    }
    pub fn bar(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Bar).next()
    }
}
impl AstNode for ConBind {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ConBind
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct OfTy(SyntaxNode);
impl OfTy {
    pub fn of_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OfKw).next()
    }
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
}
impl AstNode for OfTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::OfTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct AscriptionTail(SyntaxNode);
impl AscriptionTail {
    pub fn ascription(&self) -> Option<Ascription> {
        token_children(self).next()
    }
    pub fn sig_exp(&self) -> Option<SigExp> {
        node_children(self).next()
    }
}
impl AstNode for AscriptionTail {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::AscriptionTail
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct EqStrExp(SyntaxNode);
impl EqStrExp {
    pub fn eq(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Eq).next()
    }
    pub fn str_exp(&self) -> Option<StrExp> {
        node_children(self).next()
    }
}
impl AstNode for EqStrExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::EqStrExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct EsImportSpecArg(SyntaxNode);
impl EsImportSpecArg {
    pub fn es_import_spec(&self) -> Option<EsImportSpec> {
        node_children(self).next()
    }
    pub fn comma(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Comma).next()
    }
}
impl AstNode for EsImportSpecArg {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::EsImportSpecArg
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct EsImportSpec(SyntaxNode);
impl EsImportSpec {
    pub fn es_import_spec_source(&self) -> Option<EsImportSpecSource> {
        token_children(self).next()
    }
    pub fn as_pat_tail(&self) -> Option<AsPatTail> {
        node_children(self).next()
    }
    pub fn ty_annotation(&self) -> Option<TyAnnotation> {
        node_children(self).next()
    }
}
impl AstNode for EsImportSpec {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::EsImportSpec
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct AsPatTail(SyntaxNode);
impl AsPatTail {
    pub fn as_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AsKw).next()
    }
    pub fn pat(&self) -> Option<Pat> {
        node_children(self).next()
    }
}
impl AstNode for AsPatTail {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::AsPatTail
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct PrefixFunBindCaseHead(SyntaxNode);
impl PrefixFunBindCaseHead {
    pub fn op_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OpKw).next()
    }
    pub fn name_star_eq(&self) -> Option<NameStarEq> {
        token_children(self).next()
    }
}
impl AstNode for PrefixFunBindCaseHead {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::PrefixFunBindCaseHead
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct InfixFunBindCaseHead(SyntaxNode);
impl InfixFunBindCaseHead {
    pub fn l_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LRound).next()
    }
    pub fn lhs(&self) -> Option<Pat> {
        node_children(self).next()
    }
    pub fn name_star_eq(&self) -> Option<NameStarEq> {
        token_children(self).next()
    }
    pub fn rhs(&self) -> Option<Pat> {
        node_children(self).nth(1usize)
    }
    pub fn r_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RRound).next()
    }
}
impl AstNode for InfixFunBindCaseHead {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::InfixFunBindCaseHead
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct FunctorArgNameSigExp(SyntaxNode);
impl FunctorArgNameSigExp {
    pub fn name(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Name).next()
    }
    pub fn ascription(&self) -> Option<Ascription> {
        token_children(self).next()
    }
    pub fn sig_exp(&self) -> Option<SigExp> {
        node_children(self).next()
    }
}
impl AstNode for FunctorArgNameSigExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::FunctorArgNameSigExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct StructStrExp(SyntaxNode);
impl StructStrExp {
    pub fn struct_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::StructKw).next()
    }
    pub fn decs(&self) -> impl Iterator<Item = Dec> + use<> {
        node_children(self)
    }
    pub fn end_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::EndKw).next()
    }
}
impl AstNode for StructStrExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::StructStrExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct PathStrExp(SyntaxNode);
impl PathStrExp {
    pub fn path(&self) -> Option<Path> {
        node_children(self).next()
    }
}
impl AstNode for PathStrExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::PathStrExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct AscriptionStrExp(SyntaxNode);
impl AscriptionStrExp {
    pub fn str_exp(&self) -> Option<StrExp> {
        node_children(self).next()
    }
    pub fn ascription_tail(&self) -> Option<AscriptionTail> {
        node_children(self).next()
    }
}
impl AstNode for AscriptionStrExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::AscriptionStrExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct AppStrExp(SyntaxNode);
impl AppStrExp {
    pub fn name(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Name).next()
    }
    pub fn l_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LRound).next()
    }
    pub fn app_str_exp_args(&self) -> impl Iterator<Item = AppStrExpArg> + use<> {
        node_children(self)
    }
    pub fn r_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RRound).next()
    }
}
impl AstNode for AppStrExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::AppStrExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct LetStrExp(SyntaxNode);
impl LetStrExp {
    pub fn let_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LetKw).next()
    }
    pub fn decs(&self) -> impl Iterator<Item = Dec> + use<> {
        node_children(self)
    }
    pub fn in_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::InKw).next()
    }
    pub fn str_exp(&self) -> Option<StrExp> {
        node_children(self).next()
    }
    pub fn end_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::EndKw).next()
    }
}
impl AstNode for LetStrExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::LetStrExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct AppStrExpArgStrExp(SyntaxNode);
impl AppStrExpArgStrExp {
    pub fn str_exp(&self) -> Option<StrExp> {
        node_children(self).next()
    }
}
impl AstNode for AppStrExpArgStrExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::AppStrExpArgStrExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct SigSigExp(SyntaxNode);
impl SigSigExp {
    pub fn sig_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::SigKw).next()
    }
    pub fn decs(&self) -> impl Iterator<Item = Dec> + use<> {
        node_children(self)
    }
    pub fn end_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::EndKw).next()
    }
}
impl AstNode for SigSigExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::SigSigExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct NameSigExp(SyntaxNode);
impl NameSigExp {
    pub fn name(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Name).next()
    }
}
impl AstNode for NameSigExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::NameSigExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct WhereTypeSigExp(SyntaxNode);
impl WhereTypeSigExp {
    pub fn sig_exp(&self) -> Option<SigExp> {
        node_children(self).next()
    }
    pub fn where_or_and(&self) -> Option<WhereOrAnd> {
        token_children(self).next()
    }
    pub fn type_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::TypeKw).next()
    }
    pub fn ty_var_seq(&self) -> Option<TyVarSeq> {
        node_children(self).next()
    }
    pub fn path(&self) -> Option<Path> {
        node_children(self).next()
    }
    pub fn eq(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Eq).next()
    }
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
}
impl AstNode for WhereTypeSigExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::WhereTypeSigExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct WhereSigExp(SyntaxNode);
impl WhereSigExp {
    pub fn sig_exp(&self) -> Option<SigExp> {
        node_children(self).next()
    }
    pub fn where_or_and(&self) -> Option<WhereOrAnd> {
        token_children(self).next()
    }
    pub fn lhs(&self) -> Option<Path> {
        node_children(self).next()
    }
    pub fn eq(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Eq).next()
    }
    pub fn rhs(&self) -> Option<Path> {
        node_children(self).nth(1usize)
    }
}
impl AstNode for WhereSigExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::WhereSigExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct PathEq(SyntaxNode);
impl PathEq {
    pub fn path(&self) -> Option<Path> {
        node_children(self).next()
    }
    pub fn eq(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Eq).next()
    }
}
impl AstNode for PathEq {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::PathEq
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct HoleExp(SyntaxNode);
impl HoleExp {
    pub fn dot_dot_dot(&self) -> Option<SyntaxToken> {
        tokens(self, SK::DotDotDot).next()
    }
}
impl AstNode for HoleExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::HoleExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct WildcardExp(SyntaxNode);
impl WildcardExp {
    pub fn underscore(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Underscore).next()
    }
}
impl AstNode for WildcardExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::WildcardExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct OpAndalsoExp(SyntaxNode);
impl OpAndalsoExp {
    pub fn op_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OpKw).next()
    }
    pub fn andalso_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AndalsoKw).next()
    }
}
impl AstNode for OpAndalsoExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::OpAndalsoExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct OpOrelseExp(SyntaxNode);
impl OpOrelseExp {
    pub fn op_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OpKw).next()
    }
    pub fn orelse_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OrelseKw).next()
    }
}
impl AstNode for OpOrelseExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::OpOrelseExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct SConExp(SyntaxNode);
impl SConExp {
    pub fn s_con(&self) -> Option<SCon> {
        token_children(self).next()
    }
}
impl AstNode for SConExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::SConExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct PathExp(SyntaxNode);
impl PathExp {
    pub fn op_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OpKw).next()
    }
    pub fn path(&self) -> Option<Path> {
        node_children(self).next()
    }
}
impl AstNode for PathExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::PathExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct RecordExp(SyntaxNode);
impl RecordExp {
    pub fn l_curly(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LCurly).next()
    }
    pub fn exp_rows(&self) -> impl Iterator<Item = ExpRow> + use<> {
        node_children(self)
    }
    pub fn r_curly(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RCurly).next()
    }
}
impl AstNode for RecordExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::RecordExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct SelectorExp(SyntaxNode);
impl SelectorExp {
    pub fn hash(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Hash).next()
    }
    pub fn lab(&self) -> Option<Lab> {
        token_children(self).next()
    }
}
impl AstNode for SelectorExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::SelectorExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ParenExp(SyntaxNode);
impl ParenExp {
    pub fn l_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LRound).next()
    }
    pub fn exp(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn r_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RRound).next()
    }
}
impl AstNode for ParenExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ParenExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TupleExp(SyntaxNode);
impl TupleExp {
    pub fn l_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LRound).next()
    }
    pub fn exp_args(&self) -> impl Iterator<Item = ExpArg> + use<> {
        node_children(self)
    }
    pub fn r_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RRound).next()
    }
}
impl AstNode for TupleExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TupleExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ListExp(SyntaxNode);
impl ListExp {
    pub fn l_square(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LSquare).next()
    }
    pub fn exp_args(&self) -> impl Iterator<Item = ExpArg> + use<> {
        node_children(self)
    }
    pub fn r_square(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RSquare).next()
    }
}
impl AstNode for ListExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ListExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct VectorExp(SyntaxNode);
impl VectorExp {
    pub fn hash(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Hash).next()
    }
    pub fn list_exp(&self) -> Option<ListExp> {
        node_children(self).next()
    }
}
impl AstNode for VectorExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::VectorExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct SeqExp(SyntaxNode);
impl SeqExp {
    pub fn l_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LRound).next()
    }
    pub fn exps_in_seq(&self) -> impl Iterator<Item = ExpInSeq> + use<> {
        node_children(self)
    }
    pub fn r_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RRound).next()
    }
}
impl AstNode for SeqExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::SeqExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct LetExp(SyntaxNode);
impl LetExp {
    pub fn let_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LetKw).next()
    }
    pub fn decs(&self) -> impl Iterator<Item = Dec> + use<> {
        node_children(self)
    }
    pub fn in_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::InKw).next()
    }
    pub fn exps_in_seq(&self) -> impl Iterator<Item = ExpInSeq> + use<> {
        node_children(self)
    }
    pub fn end_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::EndKw).next()
    }
}
impl AstNode for LetExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::LetExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct AppExp(SyntaxNode);
impl AppExp {
    pub fn func(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn arg(&self) -> Option<Exp> {
        node_children(self).nth(1usize)
    }
}
impl AstNode for AppExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::AppExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct InfixExp(SyntaxNode);
impl InfixExp {
    pub fn lhs(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn name_star_eq(&self) -> Option<NameStarEq> {
        token_children(self).next()
    }
    pub fn rhs(&self) -> Option<Exp> {
        node_children(self).nth(1usize)
    }
}
impl AstNode for InfixExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::InfixExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TypedExp(SyntaxNode);
impl TypedExp {
    pub fn exp(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn ascription(&self) -> Option<Ascription> {
        token_children(self).next()
    }
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
}
impl AstNode for TypedExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TypedExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct AndalsoExp(SyntaxNode);
impl AndalsoExp {
    pub fn lhs(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn andalso_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::AndalsoKw).next()
    }
    pub fn rhs(&self) -> Option<Exp> {
        node_children(self).nth(1usize)
    }
}
impl AstNode for AndalsoExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::AndalsoExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct OrelseExp(SyntaxNode);
impl OrelseExp {
    pub fn lhs(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn orelse_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OrelseKw).next()
    }
    pub fn rhs(&self) -> Option<Exp> {
        node_children(self).nth(1usize)
    }
}
impl AstNode for OrelseExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::OrelseExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct HandleExp(SyntaxNode);
impl HandleExp {
    pub fn exp(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn handle_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::HandleKw).next()
    }
    pub fn matcher(&self) -> Option<Matcher> {
        node_children(self).next()
    }
}
impl AstNode for HandleExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::HandleExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct RaiseExp(SyntaxNode);
impl RaiseExp {
    pub fn raise_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RaiseKw).next()
    }
    pub fn exp(&self) -> Option<Exp> {
        node_children(self).next()
    }
}
impl AstNode for RaiseExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::RaiseExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct IfExp(SyntaxNode);
impl IfExp {
    pub fn if_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::IfKw).next()
    }
    pub fn cond(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn then_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::ThenKw).next()
    }
    pub fn yes(&self) -> Option<Exp> {
        node_children(self).nth(1usize)
    }
    pub fn else_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::ElseKw).next()
    }
    pub fn no(&self) -> Option<Exp> {
        node_children(self).nth(2usize)
    }
}
impl AstNode for IfExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::IfExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct WhileExp(SyntaxNode);
impl WhileExp {
    pub fn while_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::WhileKw).next()
    }
    pub fn cond(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn do_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::DoKw).next()
    }
    pub fn body(&self) -> Option<Exp> {
        node_children(self).nth(1usize)
    }
}
impl AstNode for WhileExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::WhileExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct CaseExp(SyntaxNode);
impl CaseExp {
    pub fn case_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::CaseKw).next()
    }
    pub fn exp(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn of_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OfKw).next()
    }
    pub fn matcher(&self) -> Option<Matcher> {
        node_children(self).next()
    }
}
impl AstNode for CaseExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::CaseExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct FnExp(SyntaxNode);
impl FnExp {
    pub fn fn_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::FnKw).next()
    }
    pub fn matcher(&self) -> Option<Matcher> {
        node_children(self).next()
    }
}
impl AstNode for FnExp {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::FnExp
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ExpRow(SyntaxNode);
impl ExpRow {
    pub fn lab(&self) -> Option<Lab> {
        token_children(self).next()
    }
    pub fn eq_exp(&self) -> Option<EqExp> {
        node_children(self).next()
    }
    pub fn comma(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Comma).next()
    }
}
impl AstNode for ExpRow {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ExpRow
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ExpArg(SyntaxNode);
impl ExpArg {
    pub fn exp(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn comma(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Comma).next()
    }
}
impl AstNode for ExpArg {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ExpArg
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ExpInSeq(SyntaxNode);
impl ExpInSeq {
    pub fn exp(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn semicolon(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Semicolon).next()
    }
}
impl AstNode for ExpInSeq {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ExpInSeq
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct Matcher(SyntaxNode);
impl Matcher {
    pub fn bar(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Bar).next()
    }
    pub fn arms(&self) -> impl Iterator<Item = Arm> + use<> {
        node_children(self)
    }
}
impl AstNode for Matcher {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::Matcher
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct Arm(SyntaxNode);
impl Arm {
    pub fn pat(&self) -> Option<Pat> {
        node_children(self).next()
    }
    pub fn eq_gt(&self) -> Option<SyntaxToken> {
        tokens(self, SK::EqGt).next()
    }
    pub fn exp(&self) -> Option<Exp> {
        node_children(self).next()
    }
    pub fn bar(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Bar).next()
    }
}
impl AstNode for Arm {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::Arm
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct WildcardPat(SyntaxNode);
impl WildcardPat {
    pub fn underscore(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Underscore).next()
    }
}
impl AstNode for WildcardPat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::WildcardPat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct SConPat(SyntaxNode);
impl SConPat {
    pub fn s_con(&self) -> Option<SCon> {
        token_children(self).next()
    }
}
impl AstNode for SConPat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::SConPat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ConPat(SyntaxNode);
impl ConPat {
    pub fn op_kw(&self) -> Option<SyntaxToken> {
        tokens(self, SK::OpKw).next()
    }
    pub fn path(&self) -> Option<Path> {
        node_children(self).next()
    }
    pub fn pat(&self) -> Option<Pat> {
        node_children(self).next()
    }
}
impl AstNode for ConPat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ConPat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct RecordPat(SyntaxNode);
impl RecordPat {
    pub fn l_curly(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LCurly).next()
    }
    pub fn pat_rows(&self) -> impl Iterator<Item = PatRow> + use<> {
        node_children(self)
    }
    pub fn r_curly(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RCurly).next()
    }
}
impl AstNode for RecordPat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::RecordPat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ParenPat(SyntaxNode);
impl ParenPat {
    pub fn l_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LRound).next()
    }
    pub fn pat(&self) -> Option<Pat> {
        node_children(self).next()
    }
    pub fn r_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RRound).next()
    }
}
impl AstNode for ParenPat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ParenPat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TuplePat(SyntaxNode);
impl TuplePat {
    pub fn l_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LRound).next()
    }
    pub fn pat_args(&self) -> impl Iterator<Item = PatArg> + use<> {
        node_children(self)
    }
    pub fn r_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RRound).next()
    }
}
impl AstNode for TuplePat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TuplePat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ListPat(SyntaxNode);
impl ListPat {
    pub fn l_square(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LSquare).next()
    }
    pub fn pat_args(&self) -> impl Iterator<Item = PatArg> + use<> {
        node_children(self)
    }
    pub fn r_square(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RSquare).next()
    }
}
impl AstNode for ListPat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ListPat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct VectorPat(SyntaxNode);
impl VectorPat {
    pub fn hash(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Hash).next()
    }
    pub fn list_pat(&self) -> Option<ListPat> {
        node_children(self).next()
    }
}
impl AstNode for VectorPat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::VectorPat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct InfixPat(SyntaxNode);
impl InfixPat {
    pub fn lhs(&self) -> Option<Pat> {
        node_children(self).next()
    }
    pub fn name_star_eq(&self) -> Option<NameStarEq> {
        token_children(self).next()
    }
    pub fn rhs(&self) -> Option<Pat> {
        node_children(self).nth(1usize)
    }
}
impl AstNode for InfixPat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::InfixPat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TypedPat(SyntaxNode);
impl TypedPat {
    pub fn pat(&self) -> Option<Pat> {
        node_children(self).next()
    }
    pub fn ascription(&self) -> Option<Ascription> {
        token_children(self).next()
    }
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
}
impl AstNode for TypedPat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TypedPat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct AsPat(SyntaxNode);
impl AsPat {
    pub fn pat(&self) -> Option<Pat> {
        node_children(self).next()
    }
    pub fn as_pat_tail(&self) -> Option<AsPatTail> {
        node_children(self).next()
    }
}
impl AstNode for AsPat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::AsPat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct OrPat(SyntaxNode);
impl OrPat {
    pub fn lhs(&self) -> Option<Pat> {
        node_children(self).next()
    }
    pub fn bar(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Bar).next()
    }
    pub fn rhs(&self) -> Option<Pat> {
        node_children(self).nth(1usize)
    }
}
impl AstNode for OrPat {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::OrPat
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct PatRow(SyntaxNode);
impl PatRow {
    pub fn pat_row_inner(&self) -> Option<PatRowInner> {
        node_children(self).next()
    }
    pub fn comma(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Comma).next()
    }
}
impl AstNode for PatRow {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::PatRow
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct PatArg(SyntaxNode);
impl PatArg {
    pub fn pat(&self) -> Option<Pat> {
        node_children(self).next()
    }
    pub fn comma(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Comma).next()
    }
}
impl AstNode for PatArg {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::PatArg
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct RestPatRow(SyntaxNode);
impl RestPatRow {
    pub fn dot_dot_dot(&self) -> Option<SyntaxToken> {
        tokens(self, SK::DotDotDot).next()
    }
}
impl AstNode for RestPatRow {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::RestPatRow
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct LabAndPatPatRow(SyntaxNode);
impl LabAndPatPatRow {
    pub fn lab(&self) -> Option<Lab> {
        token_children(self).next()
    }
    pub fn eq(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Eq).next()
    }
    pub fn pat(&self) -> Option<Pat> {
        node_children(self).next()
    }
}
impl AstNode for LabAndPatPatRow {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::LabAndPatPatRow
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct LabPatRow(SyntaxNode);
impl LabPatRow {
    pub fn name_star_eq(&self) -> Option<NameStarEq> {
        token_children(self).next()
    }
    pub fn ty_annotation(&self) -> Option<TyAnnotation> {
        node_children(self).next()
    }
    pub fn as_pat_tail(&self) -> Option<AsPatTail> {
        node_children(self).next()
    }
}
impl AstNode for LabPatRow {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::LabPatRow
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct HoleTy(SyntaxNode);
impl HoleTy {
    pub fn dot_dot_dot(&self) -> Option<SyntaxToken> {
        tokens(self, SK::DotDotDot).next()
    }
}
impl AstNode for HoleTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::HoleTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct WildcardTy(SyntaxNode);
impl WildcardTy {
    pub fn underscore(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Underscore).next()
    }
}
impl AstNode for WildcardTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::WildcardTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TyVarTy(SyntaxNode);
impl TyVarTy {
    pub fn ty_var(&self) -> Option<SyntaxToken> {
        tokens(self, SK::TyVar).next()
    }
}
impl AstNode for TyVarTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TyVarTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct RecordTy(SyntaxNode);
impl RecordTy {
    pub fn l_curly(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LCurly).next()
    }
    pub fn ty_rows(&self) -> impl Iterator<Item = TyRow> + use<> {
        node_children(self)
    }
    pub fn r_curly(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RCurly).next()
    }
}
impl AstNode for RecordTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::RecordTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ConTy(SyntaxNode);
impl ConTy {
    pub fn ty_seq(&self) -> Option<TySeq> {
        node_children(self).next()
    }
    pub fn path(&self) -> Option<Path> {
        node_children(self).next()
    }
}
impl AstNode for ConTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ConTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct OneArgConTy(SyntaxNode);
impl OneArgConTy {
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
    pub fn path(&self) -> Option<Path> {
        node_children(self).next()
    }
}
impl AstNode for OneArgConTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::OneArgConTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TupleTy(SyntaxNode);
impl TupleTy {
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
    pub fn star_tys(&self) -> impl Iterator<Item = StarTy> + use<> {
        node_children(self)
    }
}
impl AstNode for TupleTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TupleTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct FnTy(SyntaxNode);
impl FnTy {
    pub fn param(&self) -> Option<Ty> {
        node_children(self).next()
    }
    pub fn minus_gt(&self) -> Option<SyntaxToken> {
        tokens(self, SK::MinusGt).next()
    }
    pub fn res(&self) -> Option<Ty> {
        node_children(self).nth(1usize)
    }
}
impl AstNode for FnTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::FnTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct ParenTy(SyntaxNode);
impl ParenTy {
    pub fn l_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LRound).next()
    }
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
    pub fn r_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RRound).next()
    }
}
impl AstNode for ParenTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::ParenTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TyRow(SyntaxNode);
impl TyRow {
    pub fn lab(&self) -> Option<Lab> {
        token_children(self).next()
    }
    pub fn ascription(&self) -> Option<Ascription> {
        token_children(self).next()
    }
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
    pub fn comma(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Comma).next()
    }
}
impl AstNode for TyRow {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TyRow
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TySeq(SyntaxNode);
impl TySeq {
    pub fn l_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::LRound).next()
    }
    pub fn ty_args(&self) -> impl Iterator<Item = TyArg> + use<> {
        node_children(self)
    }
    pub fn r_round(&self) -> Option<SyntaxToken> {
        tokens(self, SK::RRound).next()
    }
}
impl AstNode for TySeq {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TySeq
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct StarTy(SyntaxNode);
impl StarTy {
    pub fn star(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Star).next()
    }
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
}
impl AstNode for StarTy {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::StarTy
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct NameStarEqDot(SyntaxNode);
impl NameStarEqDot {
    pub fn name_star_eq(&self) -> Option<NameStarEq> {
        token_children(self).next()
    }
    pub fn dot(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Dot).next()
    }
}
impl AstNode for NameStarEqDot {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::NameStarEqDot
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TyArg(SyntaxNode);
impl TyArg {
    pub fn ty(&self) -> Option<Ty> {
        node_children(self).next()
    }
    pub fn comma(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Comma).next()
    }
}
impl AstNode for TyArg {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TyArg
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
pub struct TyVarArg(SyntaxNode);
impl TyVarArg {
    pub fn ty_var(&self) -> Option<SyntaxToken> {
        tokens(self, SK::TyVar).next()
    }
    pub fn comma(&self) -> Option<SyntaxToken> {
        tokens(self, SK::Comma).next()
    }
}
impl AstNode for TyVarArg {
    type Language = SML;
    fn can_cast(kind: SK) -> bool {
        kind == SK::TyVarArg
    }
    fn cast(node: SyntaxNode) -> Option<Self> {
        Self::can_cast(node.kind()).then_some(Self(node))
    }
    fn syntax(&self) -> &SyntaxNode {
        &self.0
    }
}
