// Declare C MPI functions

extern int (* MPITRAMPOLINE_CONST MPIABI_Send)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
);
int MPI_Send(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
);
int PMPI_Send(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Recv)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Status * status
);
int MPI_Recv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Status * status
);
int PMPI_Recv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Get_count)(
  const MPIABI_Status * status,
  MPIABI_Datatype datatype,
  int * count
);
int MPI_Get_count(
  const MPI_Status * status,
  MPI_Datatype datatype,
  int * count
);
int PMPI_Get_count(
  const MPI_Status * status,
  MPI_Datatype datatype,
  int * count
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Bsend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
);
int MPI_Bsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
);
int PMPI_Bsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ssend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
);
int MPI_Ssend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
);
int PMPI_Ssend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Rsend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
);
int MPI_Rsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
);
int PMPI_Rsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Buffer_attach)(
  void * buffer,
  int size
);
int MPI_Buffer_attach(
  void * buffer,
  int size
);
int PMPI_Buffer_attach(
  void * buffer,
  int size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Buffer_detach)(
  void * buffer_addr,
  int * size
);
int MPI_Buffer_detach(
  void * buffer_addr,
  int * size
);
int PMPI_Buffer_detach(
  void * buffer_addr,
  int * size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Isend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Isend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Isend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ibsend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ibsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ibsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Issend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Issend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Issend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Irsend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Irsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Irsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Irecv)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Irecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Irecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Wait)(
  MPIABI_Request * request,
  MPIABI_Status * status
);
int MPI_Wait(
  MPI_Request * request,
  MPI_Status * status
);
int PMPI_Wait(
  MPI_Request * request,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Test)(
  MPIABI_Request * request,
  int * flag,
  MPIABI_Status * status
);
int MPI_Test(
  MPI_Request * request,
  int * flag,
  MPI_Status * status
);
int PMPI_Test(
  MPI_Request * request,
  int * flag,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Request_free)(
  MPIABI_Request * request
);
int MPI_Request_free(
  MPI_Request * request
);
int PMPI_Request_free(
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Waitany)(
  int count,
  MPIABI_Request * array_of_requests,
  int * index,
  MPIABI_Status * status
);
int MPI_Waitany(
  int count,
  MPI_Request * array_of_requests,
  int * index,
  MPI_Status * status
);
int PMPI_Waitany(
  int count,
  MPI_Request * array_of_requests,
  int * index,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Testany)(
  int count,
  MPIABI_Request * array_of_requests,
  int * index,
  int * flag,
  MPIABI_Status * status
);
int MPI_Testany(
  int count,
  MPI_Request * array_of_requests,
  int * index,
  int * flag,
  MPI_Status * status
);
int PMPI_Testany(
  int count,
  MPI_Request * array_of_requests,
  int * index,
  int * flag,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Waitall)(
  int count,
  MPIABI_Request * array_of_requests,
  MPIABI_Status * array_of_statuses
);
int MPI_Waitall(
  int count,
  MPI_Request * array_of_requests,
  MPI_Status * array_of_statuses
);
int PMPI_Waitall(
  int count,
  MPI_Request * array_of_requests,
  MPI_Status * array_of_statuses
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Testall)(
  int count,
  MPIABI_Request * array_of_requests,
  int * flag,
  MPIABI_Status * array_of_statuses
);
int MPI_Testall(
  int count,
  MPI_Request * array_of_requests,
  int * flag,
  MPI_Status * array_of_statuses
);
int PMPI_Testall(
  int count,
  MPI_Request * array_of_requests,
  int * flag,
  MPI_Status * array_of_statuses
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Waitsome)(
  int incount,
  MPIABI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPIABI_Status * array_of_statuses
);
int MPI_Waitsome(
  int incount,
  MPI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPI_Status * array_of_statuses
);
int PMPI_Waitsome(
  int incount,
  MPI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPI_Status * array_of_statuses
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Testsome)(
  int incount,
  MPIABI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPIABI_Status * array_of_statuses
);
int MPI_Testsome(
  int incount,
  MPI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPI_Status * array_of_statuses
);
int PMPI_Testsome(
  int incount,
  MPI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPI_Status * array_of_statuses
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Request_get_status)(
  MPIABI_Request request,
  int * flag,
  MPIABI_Status * status
);
int MPI_Request_get_status(
  MPI_Request request,
  int * flag,
  MPI_Status * status
);
int PMPI_Request_get_status(
  MPI_Request request,
  int * flag,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Iprobe)(
  int source,
  int tag,
  MPIABI_Comm comm,
  int * flag,
  MPIABI_Status * status
);
int MPI_Iprobe(
  int source,
  int tag,
  MPI_Comm comm,
  int * flag,
  MPI_Status * status
);
int PMPI_Iprobe(
  int source,
  int tag,
  MPI_Comm comm,
  int * flag,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Probe)(
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Status * status
);
int MPI_Probe(
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Status * status
);
int PMPI_Probe(
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Improbe)(
  int source,
  int tag,
  MPIABI_Comm comm,
  int * flag,
  MPIABI_Message * message,
  MPIABI_Status * status
);
int MPI_Improbe(
  int source,
  int tag,
  MPI_Comm comm,
  int * flag,
  MPI_Message * message,
  MPI_Status * status
);
int PMPI_Improbe(
  int source,
  int tag,
  MPI_Comm comm,
  int * flag,
  MPI_Message * message,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Mprobe)(
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Message * message,
  MPIABI_Status * status
);
int MPI_Mprobe(
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Message * message,
  MPI_Status * status
);
int PMPI_Mprobe(
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Message * message,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Mrecv)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Message * message,
  MPIABI_Status * status
);
int MPI_Mrecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Message * message,
  MPI_Status * status
);
int PMPI_Mrecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Message * message,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Imrecv)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Message * message,
  MPIABI_Request * request
);
int MPI_Imrecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Message * message,
  MPI_Request * request
);
int PMPI_Imrecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Message * message,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Cancel)(
  MPIABI_Request * request
);
int MPI_Cancel(
  MPI_Request * request
);
int PMPI_Cancel(
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Test_cancelled)(
  const MPIABI_Status * status,
  int * flag
);
int MPI_Test_cancelled(
  const MPI_Status * status,
  int * flag
);
int PMPI_Test_cancelled(
  const MPI_Status * status,
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Send_init)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Send_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Send_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Bsend_init)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Bsend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Bsend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ssend_init)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ssend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ssend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Rsend_init)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Rsend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Rsend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Recv_init)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Recv_init(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Recv_init(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Start)(
  MPIABI_Request * request
);
int MPI_Start(
  MPI_Request * request
);
int PMPI_Start(
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Startall)(
  int count,
  MPIABI_Request * array_of_requests
);
int MPI_Startall(
  int count,
  MPI_Request * array_of_requests
);
int PMPI_Startall(
  int count,
  MPI_Request * array_of_requests
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Sendrecv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  int dest,
  int sendtag,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int source,
  int recvtag,
  MPIABI_Comm comm,
  MPIABI_Status * status
);
int MPI_Sendrecv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  int dest,
  int sendtag,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int source,
  int recvtag,
  MPI_Comm comm,
  MPI_Status * status
);
int PMPI_Sendrecv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  int dest,
  int sendtag,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int source,
  int recvtag,
  MPI_Comm comm,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Sendrecv_replace)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int sendtag,
  int source,
  int recvtag,
  MPIABI_Comm comm,
  MPIABI_Status * status
);
int MPI_Sendrecv_replace(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int sendtag,
  int source,
  int recvtag,
  MPI_Comm comm,
  MPI_Status * status
);
int PMPI_Sendrecv_replace(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int sendtag,
  int source,
  int recvtag,
  MPI_Comm comm,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_contiguous)(
  int count,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
);
int MPI_Type_contiguous(
  int count,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
int PMPI_Type_contiguous(
  int count,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_vector)(
  int count,
  int blocklength,
  int stride,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
);
int MPI_Type_vector(
  int count,
  int blocklength,
  int stride,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
int PMPI_Type_vector(
  int count,
  int blocklength,
  int stride,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_hvector)(
  int count,
  int blocklength,
  MPIABI_Aint stride,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
);
int MPI_Type_create_hvector(
  int count,
  int blocklength,
  MPI_Aint stride,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
int PMPI_Type_create_hvector(
  int count,
  int blocklength,
  MPI_Aint stride,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_indexed)(
  int count,
  const int * array_of_blocklengths,
  const int * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
);
int MPI_Type_indexed(
  int count,
  const int * array_of_blocklengths,
  const int * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
int PMPI_Type_indexed(
  int count,
  const int * array_of_blocklengths,
  const int * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_hindexed)(
  int count,
  const int * array_of_blocklengths,
  const MPIABI_Aint * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
);
int MPI_Type_create_hindexed(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
int PMPI_Type_create_hindexed(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_indexed_block)(
  int count,
  int blocklength,
  const int * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
);
int MPI_Type_create_indexed_block(
  int count,
  int blocklength,
  const int * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
int PMPI_Type_create_indexed_block(
  int count,
  int blocklength,
  const int * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_hindexed_block)(
  int count,
  int blocklength,
  const MPIABI_Aint * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
);
int MPI_Type_create_hindexed_block(
  int count,
  int blocklength,
  const MPI_Aint * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
int PMPI_Type_create_hindexed_block(
  int count,
  int blocklength,
  const MPI_Aint * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_struct)(
  int count,
  const int * array_of_blocklengths,
  const MPIABI_Aint * array_of_displacements,
  const MPIABI_Datatype * array_of_types,
  MPIABI_Datatype * newtype
);
int MPI_Type_create_struct(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  const MPI_Datatype * array_of_types,
  MPI_Datatype * newtype
);
int PMPI_Type_create_struct(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  const MPI_Datatype * array_of_types,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_struct)(
  int count,
  const int * array_of_blocklengths,
  const MPIABI_Aint * array_of_displacements,
  const MPIABI_Datatype * array_of_types,
  MPIABI_Datatype * newtype
);
int MPI_Type_struct(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  const MPI_Datatype * array_of_types,
  MPI_Datatype * newtype
);
int PMPI_Type_struct(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  const MPI_Datatype * array_of_types,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_subarray)(
  int ndims,
  const int * array_of_sizes,
  const int * array_of_subsizes,
  const int * array_of_starts,
  int ordder,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
);
int MPI_Type_create_subarray(
  int ndims,
  const int * array_of_sizes,
  const int * array_of_subsizes,
  const int * array_of_starts,
  int ordder,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
int PMPI_Type_create_subarray(
  int ndims,
  const int * array_of_sizes,
  const int * array_of_subsizes,
  const int * array_of_starts,
  int ordder,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_darray)(
  int size,
  int rank,
  int ndims,
  const int * array_of_gsizes,
  const int * array_of_distribs,
  const int * array_of_dargs,
  const int * array_of_psizes,
  int order,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
);
int MPI_Type_create_darray(
  int size,
  int rank,
  int ndims,
  const int * array_of_gsizes,
  const int * array_of_distribs,
  const int * array_of_dargs,
  const int * array_of_psizes,
  int order,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
int PMPI_Type_create_darray(
  int size,
  int rank,
  int ndims,
  const int * array_of_gsizes,
  const int * array_of_distribs,
  const int * array_of_dargs,
  const int * array_of_psizes,
  int order,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Get_address)(
  const void * location,
  MPIABI_Aint * address
);
int MPI_Get_address(
  const void * location,
  MPI_Aint * address
);
int PMPI_Get_address(
  const void * location,
  MPI_Aint * address
);
extern MPIABI_Aint (* MPITRAMPOLINE_CONST MPIABI_Aint_add)(
  MPIABI_Aint base,
  MPIABI_Aint disp
);
MPI_Aint MPI_Aint_add(
  MPI_Aint base,
  MPI_Aint disp
);
MPI_Aint PMPI_Aint_add(
  MPI_Aint base,
  MPI_Aint disp
);
extern MPIABI_Aint (* MPITRAMPOLINE_CONST MPIABI_Aint_diff)(
  MPIABI_Aint addr1,
  MPIABI_Aint addr2
);
MPI_Aint MPI_Aint_diff(
  MPI_Aint addr1,
  MPI_Aint addr2
);
MPI_Aint PMPI_Aint_diff(
  MPI_Aint addr1,
  MPI_Aint addr2
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_size)(
  MPIABI_Datatype datatype,
  int * size
);
int MPI_Type_size(
  MPI_Datatype datatype,
  int * size
);
int PMPI_Type_size(
  MPI_Datatype datatype,
  int * size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_size_x)(
  MPIABI_Datatype datatype,
  MPIABI_Count * size
);
int MPI_Type_size_x(
  MPI_Datatype datatype,
  MPI_Count * size
);
int PMPI_Type_size_x(
  MPI_Datatype datatype,
  MPI_Count * size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_get_extent)(
  MPIABI_Datatype datatype,
  MPIABI_Aint * lb,
  MPIABI_Aint * extent
);
int MPI_Type_get_extent(
  MPI_Datatype datatype,
  MPI_Aint * lb,
  MPI_Aint * extent
);
int PMPI_Type_get_extent(
  MPI_Datatype datatype,
  MPI_Aint * lb,
  MPI_Aint * extent
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_get_extent_x)(
  MPIABI_Datatype datatype,
  MPIABI_Count * lb,
  MPIABI_Count * extent
);
int MPI_Type_get_extent_x(
  MPI_Datatype datatype,
  MPI_Count * lb,
  MPI_Count * extent
);
int PMPI_Type_get_extent_x(
  MPI_Datatype datatype,
  MPI_Count * lb,
  MPI_Count * extent
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_resized)(
  MPIABI_Datatype oldtype,
  MPIABI_Aint lb,
  MPIABI_Aint extent,
  MPIABI_Datatype * newtype
);
int MPI_Type_create_resized(
  MPI_Datatype oldtype,
  MPI_Aint lb,
  MPI_Aint extent,
  MPI_Datatype * newtype
);
int PMPI_Type_create_resized(
  MPI_Datatype oldtype,
  MPI_Aint lb,
  MPI_Aint extent,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_get_true_extent)(
  MPIABI_Datatype datatype,
  MPIABI_Aint * true_lb,
  MPIABI_Aint * true_extent
);
int MPI_Type_get_true_extent(
  MPI_Datatype datatype,
  MPI_Aint * true_lb,
  MPI_Aint * true_extent
);
int PMPI_Type_get_true_extent(
  MPI_Datatype datatype,
  MPI_Aint * true_lb,
  MPI_Aint * true_extent
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_get_true_extent_x)(
  MPIABI_Datatype datatype,
  MPIABI_Count * true_lb,
  MPIABI_Count * true_extent
);
int MPI_Type_get_true_extent_x(
  MPI_Datatype datatype,
  MPI_Count * true_lb,
  MPI_Count * true_extent
);
int PMPI_Type_get_true_extent_x(
  MPI_Datatype datatype,
  MPI_Count * true_lb,
  MPI_Count * true_extent
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_commit)(
  MPIABI_Datatype * datatype
);
int MPI_Type_commit(
  MPI_Datatype * datatype
);
int PMPI_Type_commit(
  MPI_Datatype * datatype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_free)(
  MPIABI_Datatype * datatype
);
int MPI_Type_free(
  MPI_Datatype * datatype
);
int PMPI_Type_free(
  MPI_Datatype * datatype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_dup)(
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
);
int MPI_Type_dup(
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
int PMPI_Type_dup(
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Get_elements)(
  const MPIABI_Status * status,
  MPIABI_Datatype datatype,
  int * count
);
int MPI_Get_elements(
  const MPI_Status * status,
  MPI_Datatype datatype,
  int * count
);
int PMPI_Get_elements(
  const MPI_Status * status,
  MPI_Datatype datatype,
  int * count
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Get_elements_x)(
  const MPIABI_Status * status,
  MPIABI_Datatype datatype,
  MPIABI_Count * count
);
int MPI_Get_elements_x(
  const MPI_Status * status,
  MPI_Datatype datatype,
  MPI_Count * count
);
int PMPI_Get_elements_x(
  const MPI_Status * status,
  MPI_Datatype datatype,
  MPI_Count * count
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_get_envelope)(
  MPIABI_Datatype datatype,
  int * num_integers,
  int * num_addresses,
  int * num_datatypes,
  int * combiner
);
int MPI_Type_get_envelope(
  MPI_Datatype datatype,
  int * num_integers,
  int * num_addresses,
  int * num_datatypes,
  int * combiner
);
int PMPI_Type_get_envelope(
  MPI_Datatype datatype,
  int * num_integers,
  int * num_addresses,
  int * num_datatypes,
  int * combiner
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_get_contents)(
  MPIABI_Datatype datatype,
  int max_integers,
  int max_addresses,
  int max_datatypes,
  int * array_of_integers,
  MPIABI_Aint * array_of_addresses,
  MPIABI_Datatype * array_of_datatypes
);
int MPI_Type_get_contents(
  MPI_Datatype datatype,
  int max_integers,
  int max_addresses,
  int max_datatypes,
  int * array_of_integers,
  MPI_Aint * array_of_addresses,
  MPI_Datatype * array_of_datatypes
);
int PMPI_Type_get_contents(
  MPI_Datatype datatype,
  int max_integers,
  int max_addresses,
  int max_datatypes,
  int * array_of_integers,
  MPI_Aint * array_of_addresses,
  MPI_Datatype * array_of_datatypes
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Pack)(
  const void * inbuf,
  int incount,
  MPIABI_Datatype datatype,
  void * outbuf,
  int outsize,
  int * position,
  MPIABI_Comm comm
);
int MPI_Pack(
  const void * inbuf,
  int incount,
  MPI_Datatype datatype,
  void * outbuf,
  int outsize,
  int * position,
  MPI_Comm comm
);
int PMPI_Pack(
  const void * inbuf,
  int incount,
  MPI_Datatype datatype,
  void * outbuf,
  int outsize,
  int * position,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Unpack)(
  const void * inbuf,
  int insize,
  int * position,
  void * outbuf,
  int outcount,
  MPIABI_Datatype datatype,
  MPIABI_Comm comm
);
int MPI_Unpack(
  const void * inbuf,
  int insize,
  int * position,
  void * outbuf,
  int outcount,
  MPI_Datatype datatype,
  MPI_Comm comm
);
int PMPI_Unpack(
  const void * inbuf,
  int insize,
  int * position,
  void * outbuf,
  int outcount,
  MPI_Datatype datatype,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Pack_size)(
  int incount,
  MPIABI_Datatype datatype,
  MPIABI_Comm comm,
  int * size
);
int MPI_Pack_size(
  int incount,
  MPI_Datatype datatype,
  MPI_Comm comm,
  int * size
);
int PMPI_Pack_size(
  int incount,
  MPI_Datatype datatype,
  MPI_Comm comm,
  int * size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Pack_external)(
  const char * datarep,
  const void * inbuf,
  int incount,
  MPIABI_Datatype datatype,
  void * outbuf,
  MPIABI_Aint outsize,
  MPIABI_Aint * position
);
int MPI_Pack_external(
  const char * datarep,
  const void * inbuf,
  int incount,
  MPI_Datatype datatype,
  void * outbuf,
  MPI_Aint outsize,
  MPI_Aint * position
);
int PMPI_Pack_external(
  const char * datarep,
  const void * inbuf,
  int incount,
  MPI_Datatype datatype,
  void * outbuf,
  MPI_Aint outsize,
  MPI_Aint * position
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Unpack_external)(
  const char * datarep,
  const void * inbuf,
  MPIABI_Aint insize,
  MPIABI_Aint * position,
  void * outbuf,
  int outcount,
  MPIABI_Datatype datatype
);
int MPI_Unpack_external(
  const char * datarep,
  const void * inbuf,
  MPI_Aint insize,
  MPI_Aint * position,
  void * outbuf,
  int outcount,
  MPI_Datatype datatype
);
int PMPI_Unpack_external(
  const char * datarep,
  const void * inbuf,
  MPI_Aint insize,
  MPI_Aint * position,
  void * outbuf,
  int outcount,
  MPI_Datatype datatype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Pack_external_size)(
  const char * datarep,
  int incount,
  MPIABI_Datatype datatype,
  MPIABI_Aint * size
);
int MPI_Pack_external_size(
  const char * datarep,
  int incount,
  MPI_Datatype datatype,
  MPI_Aint * size
);
int PMPI_Pack_external_size(
  const char * datarep,
  int incount,
  MPI_Datatype datatype,
  MPI_Aint * size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Barrier)(
  MPIABI_Comm comm
);
int MPI_Barrier(
  MPI_Comm comm
);
int PMPI_Barrier(
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Bcast)(
  void * buffer,
  int count,
  MPIABI_Datatype datatype,
  int root,
  MPIABI_Comm comm
);
int MPI_Bcast(
  void * buffer,
  int count,
  MPI_Datatype datatype,
  int root,
  MPI_Comm comm
);
int PMPI_Bcast(
  void * buffer,
  int count,
  MPI_Datatype datatype,
  int root,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Gather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
);
int MPI_Gather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
);
int PMPI_Gather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Gatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
);
int MPI_Gatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
);
int PMPI_Gatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Scatter)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
);
int MPI_Scatter(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
);
int PMPI_Scatter(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Scatterv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
);
int MPI_Scatterv(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
);
int PMPI_Scatterv(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Allgather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
);
int MPI_Allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
int PMPI_Allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Allgatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
);
int MPI_Allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
int PMPI_Allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Alltoall)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
);
int MPI_Alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
int PMPI_Alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Alltoallv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
);
int MPI_Alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
int PMPI_Alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Alltoallw)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Datatype * recvtypes,
  MPIABI_Comm comm
);
int MPI_Alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm
);
int PMPI_Alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Reduce)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  int root,
  MPIABI_Comm comm
);
int MPI_Reduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  int root,
  MPI_Comm comm
);
int PMPI_Reduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  int root,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Op_create)(
  MPIABI_User_function * user_fn,
  int commute,
  MPIABI_Op * op
);
int MPI_Op_create(
  MPI_User_function * user_fn,
  int commute,
  MPI_Op * op
);
int PMPI_Op_create(
  MPI_User_function * user_fn,
  int commute,
  MPI_Op * op
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Op_free)(
  MPIABI_Op * op
);
int MPI_Op_free(
  MPI_Op * op
);
int PMPI_Op_free(
  MPI_Op * op
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Allreduce)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
);
int MPI_Allreduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
);
int PMPI_Allreduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Op_commutative)(
  MPIABI_Op op,
  int * commute
);
int MPI_Op_commutative(
  MPI_Op op,
  int * commute
);
int PMPI_Op_commutative(
  MPI_Op op,
  int * commute
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Reduce_local)(
  const void * inbuf,
  void * inoutbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op
);
int MPI_Reduce_local(
  const void * inbuf,
  void * inoutbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op
);
int PMPI_Reduce_local(
  const void * inbuf,
  void * inoutbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Reduce_scatter_block)(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
);
int MPI_Reduce_scatter_block(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
);
int PMPI_Reduce_scatter_block(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Reduce_scatter)(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
);
int MPI_Reduce_scatter(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
);
int PMPI_Reduce_scatter(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Scan)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
);
int MPI_Scan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
);
int PMPI_Scan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Exscan)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
);
int MPI_Exscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
);
int PMPI_Exscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ibarrier)(
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ibarrier(
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ibarrier(
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ibcast)(
  void * buffer,
  int count,
  MPIABI_Datatype datatype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ibcast(
  void * buffer,
  int count,
  MPI_Datatype datatype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ibcast(
  void * buffer,
  int count,
  MPI_Datatype datatype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Igather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Igather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Igather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Igatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Igatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Igatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Iscatter)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Iscatter(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Iscatter(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Iscatterv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Iscatterv(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Iscatterv(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Iallgather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Iallgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Iallgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Iallgatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Iallgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Iallgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ialltoall)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ialltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ialltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ialltoallv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ialltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ialltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ialltoallw)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Datatype * recvtypes,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ialltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ialltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ireduce)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ireduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ireduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  int root,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Iallreduce)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Iallreduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Iallreduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ireduce_scatter_block)(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ireduce_scatter_block(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ireduce_scatter_block(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ireduce_scatter)(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ireduce_scatter(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ireduce_scatter(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Iscan)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Iscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Iscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Iexscan)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Iexscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Iexscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_size)(
  MPIABI_Group group,
  int * size
);
int MPI_Group_size(
  MPI_Group group,
  int * size
);
int PMPI_Group_size(
  MPI_Group group,
  int * size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_rank)(
  MPIABI_Group group,
  int * rank
);
int MPI_Group_rank(
  MPI_Group group,
  int * rank
);
int PMPI_Group_rank(
  MPI_Group group,
  int * rank
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_translate_ranks)(
  MPIABI_Group group1,
  int n,
  const int * ranks1,
  MPIABI_Group group2,
  int * ranks2
);
int MPI_Group_translate_ranks(
  MPI_Group group1,
  int n,
  const int * ranks1,
  MPI_Group group2,
  int * ranks2
);
int PMPI_Group_translate_ranks(
  MPI_Group group1,
  int n,
  const int * ranks1,
  MPI_Group group2,
  int * ranks2
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_compare)(
  MPIABI_Group group1,
  MPIABI_Group group2,
  int * result
);
int MPI_Group_compare(
  MPI_Group group1,
  MPI_Group group2,
  int * result
);
int PMPI_Group_compare(
  MPI_Group group1,
  MPI_Group group2,
  int * result
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_group)(
  MPIABI_Comm comm,
  MPIABI_Group * group
);
int MPI_Comm_group(
  MPI_Comm comm,
  MPI_Group * group
);
int PMPI_Comm_group(
  MPI_Comm comm,
  MPI_Group * group
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_union)(
  MPIABI_Group group1,
  MPIABI_Group group2,
  MPIABI_Group * newgroup
);
int MPI_Group_union(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
);
int PMPI_Group_union(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_intersection)(
  MPIABI_Group group1,
  MPIABI_Group group2,
  MPIABI_Group * newgroup
);
int MPI_Group_intersection(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
);
int PMPI_Group_intersection(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_difference)(
  MPIABI_Group group1,
  MPIABI_Group group2,
  MPIABI_Group * newgroup
);
int MPI_Group_difference(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
);
int PMPI_Group_difference(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_incl)(
  MPIABI_Group group,
  int n,
  const int * ranks,
  MPIABI_Group * newgroup
);
int MPI_Group_incl(
  MPI_Group group,
  int n,
  const int * ranks,
  MPI_Group * newgroup
);
int PMPI_Group_incl(
  MPI_Group group,
  int n,
  const int * ranks,
  MPI_Group * newgroup
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_excl)(
  MPIABI_Group group,
  int n,
  const int * ranks,
  MPIABI_Group * newgroup
);
int MPI_Group_excl(
  MPI_Group group,
  int n,
  const int * ranks,
  MPI_Group * newgroup
);
int PMPI_Group_excl(
  MPI_Group group,
  int n,
  const int * ranks,
  MPI_Group * newgroup
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_range_incl)(
  MPIABI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPIABI_Group * newgroup
);
int MPI_Group_range_incl(
  MPI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPI_Group * newgroup
);
int PMPI_Group_range_incl(
  MPI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPI_Group * newgroup
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_range_excl)(
  MPIABI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPIABI_Group * newgroup
);
int MPI_Group_range_excl(
  MPI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPI_Group * newgroup
);
int PMPI_Group_range_excl(
  MPI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPI_Group * newgroup
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Group_free)(
  MPIABI_Group * group
);
int MPI_Group_free(
  MPI_Group * group
);
int PMPI_Group_free(
  MPI_Group * group
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_size)(
  MPIABI_Comm comm,
  int * size
);
int MPI_Comm_size(
  MPI_Comm comm,
  int * size
);
int PMPI_Comm_size(
  MPI_Comm comm,
  int * size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_rank)(
  MPIABI_Comm comm,
  int * rank
);
int MPI_Comm_rank(
  MPI_Comm comm,
  int * rank
);
int PMPI_Comm_rank(
  MPI_Comm comm,
  int * rank
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_compare)(
  MPIABI_Comm comm1,
  MPIABI_Comm comm2,
  int * result
);
int MPI_Comm_compare(
  MPI_Comm comm1,
  MPI_Comm comm2,
  int * result
);
int PMPI_Comm_compare(
  MPI_Comm comm1,
  MPI_Comm comm2,
  int * result
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_dup)(
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm
);
int MPI_Comm_dup(
  MPI_Comm comm,
  MPI_Comm * newcomm
);
int PMPI_Comm_dup(
  MPI_Comm comm,
  MPI_Comm * newcomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_dup_with_info)(
  MPIABI_Comm comm,
  MPIABI_Info info,
  MPIABI_Comm * newcomm
);
int MPI_Comm_dup_with_info(
  MPI_Comm comm,
  MPI_Info info,
  MPI_Comm * newcomm
);
int PMPI_Comm_dup_with_info(
  MPI_Comm comm,
  MPI_Info info,
  MPI_Comm * newcomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_idup)(
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm,
  MPIABI_Request * request
);
int MPI_Comm_idup(
  MPI_Comm comm,
  MPI_Comm * newcomm,
  MPI_Request * request
);
int PMPI_Comm_idup(
  MPI_Comm comm,
  MPI_Comm * newcomm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_create)(
  MPIABI_Comm comm,
  MPIABI_Group group,
  MPIABI_Comm * newcomm
);
int MPI_Comm_create(
  MPI_Comm comm,
  MPI_Group group,
  MPI_Comm * newcomm
);
int PMPI_Comm_create(
  MPI_Comm comm,
  MPI_Group group,
  MPI_Comm * newcomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_create_group)(
  MPIABI_Comm comm,
  MPIABI_Group group,
  int tag,
  MPIABI_Comm * newcomm
);
int MPI_Comm_create_group(
  MPI_Comm comm,
  MPI_Group group,
  int tag,
  MPI_Comm * newcomm
);
int PMPI_Comm_create_group(
  MPI_Comm comm,
  MPI_Group group,
  int tag,
  MPI_Comm * newcomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_split)(
  MPIABI_Comm comm,
  int color,
  int key,
  MPIABI_Comm * newcomm
);
int MPI_Comm_split(
  MPI_Comm comm,
  int color,
  int key,
  MPI_Comm * newcomm
);
int PMPI_Comm_split(
  MPI_Comm comm,
  int color,
  int key,
  MPI_Comm * newcomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_split_type)(
  MPIABI_Comm comm,
  int split_type,
  int key,
  MPIABI_Info info,
  MPIABI_Comm * newcomm
);
int MPI_Comm_split_type(
  MPI_Comm comm,
  int split_type,
  int key,
  MPI_Info info,
  MPI_Comm * newcomm
);
int PMPI_Comm_split_type(
  MPI_Comm comm,
  int split_type,
  int key,
  MPI_Info info,
  MPI_Comm * newcomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_free)(
  MPIABI_Comm * comm
);
int MPI_Comm_free(
  MPI_Comm * comm
);
int PMPI_Comm_free(
  MPI_Comm * comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_set_info)(
  MPIABI_Comm comm,
  MPIABI_Info info
);
int MPI_Comm_set_info(
  MPI_Comm comm,
  MPI_Info info
);
int PMPI_Comm_set_info(
  MPI_Comm comm,
  MPI_Info info
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_get_info)(
  MPIABI_Comm comm,
  MPIABI_Info * info
);
int MPI_Comm_get_info(
  MPI_Comm comm,
  MPI_Info * info
);
int PMPI_Comm_get_info(
  MPI_Comm comm,
  MPI_Info * info
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_test_inter)(
  MPIABI_Comm comm,
  int * flag
);
int MPI_Comm_test_inter(
  MPI_Comm comm,
  int * flag
);
int PMPI_Comm_test_inter(
  MPI_Comm comm,
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_remote_size)(
  MPIABI_Comm comm,
  int * size
);
int MPI_Comm_remote_size(
  MPI_Comm comm,
  int * size
);
int PMPI_Comm_remote_size(
  MPI_Comm comm,
  int * size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_remote_group)(
  MPIABI_Comm comm,
  MPIABI_Group * group
);
int MPI_Comm_remote_group(
  MPI_Comm comm,
  MPI_Group * group
);
int PMPI_Comm_remote_group(
  MPI_Comm comm,
  MPI_Group * group
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Intercomm_create)(
  MPIABI_Comm local_comm,
  int local_leader,
  MPIABI_Comm peer_comm,
  int remote_leader,
  int tag,
  MPIABI_Comm * newintercomm
);
int MPI_Intercomm_create(
  MPI_Comm local_comm,
  int local_leader,
  MPI_Comm peer_comm,
  int remote_leader,
  int tag,
  MPI_Comm * newintercomm
);
int PMPI_Intercomm_create(
  MPI_Comm local_comm,
  int local_leader,
  MPI_Comm peer_comm,
  int remote_leader,
  int tag,
  MPI_Comm * newintercomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Intercomm_merge)(
  MPIABI_Comm intercomm,
  int high,
  MPIABI_Comm * newintracomm
);
int MPI_Intercomm_merge(
  MPI_Comm intercomm,
  int high,
  MPI_Comm * newintracomm
);
int PMPI_Intercomm_merge(
  MPI_Comm intercomm,
  int high,
  MPI_Comm * newintracomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_create_keyval)(
  MPIABI_Comm_copy_attr_function * comm_copy_attr_fn,
  MPIABI_Comm_delete_attr_function * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state
);
int MPI_Comm_create_keyval(
  MPI_Comm_copy_attr_function * comm_copy_attr_fn,
  MPI_Comm_delete_attr_function * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state
);
int PMPI_Comm_create_keyval(
  MPI_Comm_copy_attr_function * comm_copy_attr_fn,
  MPI_Comm_delete_attr_function * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_free_keyval)(
  int * comm_keyval
);
int MPI_Comm_free_keyval(
  int * comm_keyval
);
int PMPI_Comm_free_keyval(
  int * comm_keyval
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_set_attr)(
  MPIABI_Comm comm,
  int comm_keyval,
  void * attribute_val
);
int MPI_Comm_set_attr(
  MPI_Comm comm,
  int comm_keyval,
  void * attribute_val
);
int PMPI_Comm_set_attr(
  MPI_Comm comm,
  int comm_keyval,
  void * attribute_val
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_get_attr)(
  MPIABI_Comm comm,
  int comm_keyval,
  void * attribute_val,
  int * flag
);
int MPI_Comm_get_attr(
  MPI_Comm comm,
  int comm_keyval,
  void * attribute_val,
  int * flag
);
int PMPI_Comm_get_attr(
  MPI_Comm comm,
  int comm_keyval,
  void * attribute_val,
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_delete_attr)(
  MPIABI_Comm comm,
  int comm_keyval
);
int MPI_Comm_delete_attr(
  MPI_Comm comm,
  int comm_keyval
);
int PMPI_Comm_delete_attr(
  MPI_Comm comm,
  int comm_keyval
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_create_keyval)(
  MPIABI_Win_copy_attr_function * win_copy_attr_fn,
  MPIABI_Win_delete_attr_function * win_delete_attr_fn,
  int * win_keyval,
  void * extra_state
);
int MPI_Win_create_keyval(
  MPI_Win_copy_attr_function * win_copy_attr_fn,
  MPI_Win_delete_attr_function * win_delete_attr_fn,
  int * win_keyval,
  void * extra_state
);
int PMPI_Win_create_keyval(
  MPI_Win_copy_attr_function * win_copy_attr_fn,
  MPI_Win_delete_attr_function * win_delete_attr_fn,
  int * win_keyval,
  void * extra_state
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_free_keyval)(
  int * win_keyval
);
int MPI_Win_free_keyval(
  int * win_keyval
);
int PMPI_Win_free_keyval(
  int * win_keyval
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_set_attr)(
  MPIABI_Win win,
  int win_keyval,
  void * attribute_val
);
int MPI_Win_set_attr(
  MPI_Win win,
  int win_keyval,
  void * attribute_val
);
int PMPI_Win_set_attr(
  MPI_Win win,
  int win_keyval,
  void * attribute_val
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_get_attr)(
  MPIABI_Win win,
  int win_keyval,
  void * attribute_val,
  int * flag
);
int MPI_Win_get_attr(
  MPI_Win win,
  int win_keyval,
  void * attribute_val,
  int * flag
);
int PMPI_Win_get_attr(
  MPI_Win win,
  int win_keyval,
  void * attribute_val,
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_delete_attr)(
  MPIABI_Win win,
  int win_keyval
);
int MPI_Win_delete_attr(
  MPI_Win win,
  int win_keyval
);
int PMPI_Win_delete_attr(
  MPI_Win win,
  int win_keyval
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_keyval)(
  MPIABI_Type_copy_attr_function * type_copy_attr_fn,
  MPIABI_Type_delete_attr_function * type_delete_attr_fn,
  int * type_keyval,
  void * extra_state
);
int MPI_Type_create_keyval(
  MPI_Type_copy_attr_function * type_copy_attr_fn,
  MPI_Type_delete_attr_function * type_delete_attr_fn,
  int * type_keyval,
  void * extra_state
);
int PMPI_Type_create_keyval(
  MPI_Type_copy_attr_function * type_copy_attr_fn,
  MPI_Type_delete_attr_function * type_delete_attr_fn,
  int * type_keyval,
  void * extra_state
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_free_keyval)(
  int * type_keyval
);
int MPI_Type_free_keyval(
  int * type_keyval
);
int PMPI_Type_free_keyval(
  int * type_keyval
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_set_attr)(
  MPIABI_Datatype type,
  int type_keyval,
  void * attribute_val
);
int MPI_Type_set_attr(
  MPI_Datatype type,
  int type_keyval,
  void * attribute_val
);
int PMPI_Type_set_attr(
  MPI_Datatype type,
  int type_keyval,
  void * attribute_val
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_get_attr)(
  MPIABI_Datatype type,
  int type_keyval,
  void * attribute_val,
  int * flag
);
int MPI_Type_get_attr(
  MPI_Datatype type,
  int type_keyval,
  void * attribute_val,
  int * flag
);
int PMPI_Type_get_attr(
  MPI_Datatype type,
  int type_keyval,
  void * attribute_val,
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_delete_attr)(
  MPIABI_Datatype type,
  int type_keyval
);
int MPI_Type_delete_attr(
  MPI_Datatype type,
  int type_keyval
);
int PMPI_Type_delete_attr(
  MPI_Datatype type,
  int type_keyval
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_set_name)(
  MPIABI_Comm comm,
  const char * comm_name
);
int MPI_Comm_set_name(
  MPI_Comm comm,
  const char * comm_name
);
int PMPI_Comm_set_name(
  MPI_Comm comm,
  const char * comm_name
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_get_name)(
  MPIABI_Comm comm,
  char * comm_name,
  int * resultlen
);
int MPI_Comm_get_name(
  MPI_Comm comm,
  char * comm_name,
  int * resultlen
);
int PMPI_Comm_get_name(
  MPI_Comm comm,
  char * comm_name,
  int * resultlen
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_set_name)(
  MPIABI_Datatype type,
  const char * type_name
);
int MPI_Type_set_name(
  MPI_Datatype type,
  const char * type_name
);
int PMPI_Type_set_name(
  MPI_Datatype type,
  const char * type_name
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_get_name)(
  MPIABI_Datatype type,
  char * type_name,
  int * resultlen
);
int MPI_Type_get_name(
  MPI_Datatype type,
  char * type_name,
  int * resultlen
);
int PMPI_Type_get_name(
  MPI_Datatype type,
  char * type_name,
  int * resultlen
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_set_name)(
  MPIABI_Win win,
  const char * win_name
);
int MPI_Win_set_name(
  MPI_Win win,
  const char * win_name
);
int PMPI_Win_set_name(
  MPI_Win win,
  const char * win_name
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_get_name)(
  MPIABI_Win win,
  char * win_name,
  int * resultlen
);
int MPI_Win_get_name(
  MPI_Win win,
  char * win_name,
  int * resultlen
);
int PMPI_Win_get_name(
  MPI_Win win,
  char * win_name,
  int * resultlen
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Cart_create)(
  MPIABI_Comm comm_old,
  int ndims,
  const int * dims,
  const int * periods,
  int reorder,
  MPIABI_Comm * comm_cart
);
int MPI_Cart_create(
  MPI_Comm comm_old,
  int ndims,
  const int * dims,
  const int * periods,
  int reorder,
  MPI_Comm * comm_cart
);
int PMPI_Cart_create(
  MPI_Comm comm_old,
  int ndims,
  const int * dims,
  const int * periods,
  int reorder,
  MPI_Comm * comm_cart
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Dims_create)(
  int nnodes,
  int ndims,
  int * dims
);
int MPI_Dims_create(
  int nnodes,
  int ndims,
  int * dims
);
int PMPI_Dims_create(
  int nnodes,
  int ndims,
  int * dims
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Graph_create)(
  MPIABI_Comm comm_old,
  int nnodes,
  const int * index,
  const int * edges,
  int reorder,
  MPIABI_Comm * comm_graph
);
int MPI_Graph_create(
  MPI_Comm comm_old,
  int nnodes,
  const int * index,
  const int * edges,
  int reorder,
  MPI_Comm * comm_graph
);
int PMPI_Graph_create(
  MPI_Comm comm_old,
  int nnodes,
  const int * index,
  const int * edges,
  int reorder,
  MPI_Comm * comm_graph
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Dist_graph_create_adjacent)(
  MPIABI_Comm comm_old,
  int indegree,
  const int * sources,
  const int * sourceweights,
  int outdegree,
  const int * destinations,
  const int * destweights,
  MPIABI_Info info,
  int reorder,
  MPIABI_Comm * comm_dist_graph
);
int MPI_Dist_graph_create_adjacent(
  MPI_Comm comm_old,
  int indegree,
  const int * sources,
  const int * sourceweights,
  int outdegree,
  const int * destinations,
  const int * destweights,
  MPI_Info info,
  int reorder,
  MPI_Comm * comm_dist_graph
);
int PMPI_Dist_graph_create_adjacent(
  MPI_Comm comm_old,
  int indegree,
  const int * sources,
  const int * sourceweights,
  int outdegree,
  const int * destinations,
  const int * destweights,
  MPI_Info info,
  int reorder,
  MPI_Comm * comm_dist_graph
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Dist_graph_create)(
  MPIABI_Comm comm_old,
  int n,
  const int * sources,
  const int * degrees,
  const int * destinations,
  const int * weights,
  MPIABI_Info info,
  int reorder,
  MPIABI_Comm * comm_dist_graph
);
int MPI_Dist_graph_create(
  MPI_Comm comm_old,
  int n,
  const int * sources,
  const int * degrees,
  const int * destinations,
  const int * weights,
  MPI_Info info,
  int reorder,
  MPI_Comm * comm_dist_graph
);
int PMPI_Dist_graph_create(
  MPI_Comm comm_old,
  int n,
  const int * sources,
  const int * degrees,
  const int * destinations,
  const int * weights,
  MPI_Info info,
  int reorder,
  MPI_Comm * comm_dist_graph
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Topo_test)(
  MPIABI_Comm comm,
  int * status
);
int MPI_Topo_test(
  MPI_Comm comm,
  int * status
);
int PMPI_Topo_test(
  MPI_Comm comm,
  int * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Graphdims_get)(
  MPIABI_Comm comm,
  int * nnodes,
  int * nedges
);
int MPI_Graphdims_get(
  MPI_Comm comm,
  int * nnodes,
  int * nedges
);
int PMPI_Graphdims_get(
  MPI_Comm comm,
  int * nnodes,
  int * nedges
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Graph_get)(
  MPIABI_Comm comm,
  int maxindex,
  int maxedges,
  int * index,
  int * edges
);
int MPI_Graph_get(
  MPI_Comm comm,
  int maxindex,
  int maxedges,
  int * index,
  int * edges
);
int PMPI_Graph_get(
  MPI_Comm comm,
  int maxindex,
  int maxedges,
  int * index,
  int * edges
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Cartdim_get)(
  MPIABI_Comm comm,
  int * ndims
);
int MPI_Cartdim_get(
  MPI_Comm comm,
  int * ndims
);
int PMPI_Cartdim_get(
  MPI_Comm comm,
  int * ndims
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Cart_get)(
  MPIABI_Comm comm,
  int maxdims,
  int * dims,
  int * periods,
  int * coords
);
int MPI_Cart_get(
  MPI_Comm comm,
  int maxdims,
  int * dims,
  int * periods,
  int * coords
);
int PMPI_Cart_get(
  MPI_Comm comm,
  int maxdims,
  int * dims,
  int * periods,
  int * coords
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Cart_rank)(
  MPIABI_Comm comm,
  const int * coords,
  int * rank
);
int MPI_Cart_rank(
  MPI_Comm comm,
  const int * coords,
  int * rank
);
int PMPI_Cart_rank(
  MPI_Comm comm,
  const int * coords,
  int * rank
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Cart_coords)(
  MPIABI_Comm comm,
  int rank,
  int maxdims,
  int * coords
);
int MPI_Cart_coords(
  MPI_Comm comm,
  int rank,
  int maxdims,
  int * coords
);
int PMPI_Cart_coords(
  MPI_Comm comm,
  int rank,
  int maxdims,
  int * coords
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Graph_neighbors_count)(
  MPIABI_Comm comm,
  int rank,
  int * nneighbors
);
int MPI_Graph_neighbors_count(
  MPI_Comm comm,
  int rank,
  int * nneighbors
);
int PMPI_Graph_neighbors_count(
  MPI_Comm comm,
  int rank,
  int * nneighbors
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Graph_neighbors)(
  MPIABI_Comm comm,
  int rank,
  int maxneighbors,
  int * neighbors
);
int MPI_Graph_neighbors(
  MPI_Comm comm,
  int rank,
  int maxneighbors,
  int * neighbors
);
int PMPI_Graph_neighbors(
  MPI_Comm comm,
  int rank,
  int maxneighbors,
  int * neighbors
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Dist_graph_neighbors_count)(
  MPIABI_Comm comm,
  int * indegree,
  int * outdegree,
  int * weighted
);
int MPI_Dist_graph_neighbors_count(
  MPI_Comm comm,
  int * indegree,
  int * outdegree,
  int * weighted
);
int PMPI_Dist_graph_neighbors_count(
  MPI_Comm comm,
  int * indegree,
  int * outdegree,
  int * weighted
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Dist_graph_neighbors)(
  MPIABI_Comm comm,
  int maxindeegree,
  int * sources,
  int * wourceweights,
  int maxoutdegree,
  int * destinations,
  int * destweights
);
int MPI_Dist_graph_neighbors(
  MPI_Comm comm,
  int maxindeegree,
  int * sources,
  int * wourceweights,
  int maxoutdegree,
  int * destinations,
  int * destweights
);
int PMPI_Dist_graph_neighbors(
  MPI_Comm comm,
  int maxindeegree,
  int * sources,
  int * wourceweights,
  int maxoutdegree,
  int * destinations,
  int * destweights
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Cart_shift)(
  MPIABI_Comm comm,
  int direction,
  int disp,
  int * rank_source,
  int * rank_dest
);
int MPI_Cart_shift(
  MPI_Comm comm,
  int direction,
  int disp,
  int * rank_source,
  int * rank_dest
);
int PMPI_Cart_shift(
  MPI_Comm comm,
  int direction,
  int disp,
  int * rank_source,
  int * rank_dest
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Cart_sub)(
  MPIABI_Comm comm,
  const int * remain_dims,
  MPIABI_Comm * newcomm
);
int MPI_Cart_sub(
  MPI_Comm comm,
  const int * remain_dims,
  MPI_Comm * newcomm
);
int PMPI_Cart_sub(
  MPI_Comm comm,
  const int * remain_dims,
  MPI_Comm * newcomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Cart_map)(
  MPIABI_Comm comm,
  int ndims,
  const int * dims,
  const int * periods,
  int * newrank
);
int MPI_Cart_map(
  MPI_Comm comm,
  int ndims,
  const int * dims,
  const int * periods,
  int * newrank
);
int PMPI_Cart_map(
  MPI_Comm comm,
  int ndims,
  const int * dims,
  const int * periods,
  int * newrank
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Graph_map)(
  MPIABI_Comm comm,
  int nnodes,
  const int * index,
  const int * edges,
  int * newrank
);
int MPI_Graph_map(
  MPI_Comm comm,
  int nnodes,
  const int * index,
  const int * edges,
  int * newrank
);
int PMPI_Graph_map(
  MPI_Comm comm,
  int nnodes,
  const int * index,
  const int * edges,
  int * newrank
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Neighbor_allgather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
);
int MPI_Neighbor_allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
int PMPI_Neighbor_allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Neighbor_allgatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
);
int MPI_Neighbor_allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
int PMPI_Neighbor_allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Neighbor_alltoall)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
);
int MPI_Neighbor_alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
int PMPI_Neighbor_alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Neighbor_alltoallv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
);
int MPI_Neighbor_alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
int PMPI_Neighbor_alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Neighbor_alltoallw)(
  const void * sendbuf,
  const int * sendcounts,
  const MPIABI_Aint * sdispls,
  const MPIABI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Aint * rdispls,
  const MPIABI_Datatype * recvtypes,
  MPIABI_Comm comm
);
int MPI_Neighbor_alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const MPI_Aint * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPI_Aint * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm
);
int PMPI_Neighbor_alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const MPI_Aint * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPI_Aint * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ineighbor_allgather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ineighbor_allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ineighbor_allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ineighbor_allgatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ineighbor_allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ineighbor_allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ineighbor_alltoall)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ineighbor_alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ineighbor_alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ineighbor_alltoallv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ineighbor_alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ineighbor_alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Ineighbor_alltoallw)(
  const void * sendbuf,
  const int * sendcounts,
  const MPIABI_Aint * sdispls,
  const MPIABI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Aint * rdispls,
  const MPIABI_Datatype * recvtypes,
  MPIABI_Comm comm,
  MPIABI_Request * request
);
int MPI_Ineighbor_alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const MPI_Aint * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPI_Aint * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm,
  MPI_Request * request
);
int PMPI_Ineighbor_alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const MPI_Aint * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPI_Aint * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Get_version)(
  int * version,
  int * subversion
);
int MPI_Get_version(
  int * version,
  int * subversion
);
int PMPI_Get_version(
  int * version,
  int * subversion
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Get_library_version)(
  char * version,
  int * resultlen
);
int MPI_Get_library_version(
  char * version,
  int * resultlen
);
int PMPI_Get_library_version(
  char * version,
  int * resultlen
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Get_processor_name)(
  char * name,
  int * resultlen
);
int MPI_Get_processor_name(
  char * name,
  int * resultlen
);
int PMPI_Get_processor_name(
  char * name,
  int * resultlen
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Alloc_mem)(
  MPIABI_Aint size,
  MPIABI_Info info,
  void * baseptr
);
int MPI_Alloc_mem(
  MPI_Aint size,
  MPI_Info info,
  void * baseptr
);
int PMPI_Alloc_mem(
  MPI_Aint size,
  MPI_Info info,
  void * baseptr
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Free_mem)(
  void * base
);
int MPI_Free_mem(
  void * base
);
int PMPI_Free_mem(
  void * base
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_create_errhandler)(
  MPIABI_Comm_errhandler_function * comm_errhandler_fn,
  MPIABI_Errhandler * errhandler
);
int MPI_Comm_create_errhandler(
  MPI_Comm_errhandler_function * comm_errhandler_fn,
  MPI_Errhandler * errhandler
);
int PMPI_Comm_create_errhandler(
  MPI_Comm_errhandler_function * comm_errhandler_fn,
  MPI_Errhandler * errhandler
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_set_errhandler)(
  MPIABI_Comm comm,
  MPIABI_Errhandler errhandler
);
int MPI_Comm_set_errhandler(
  MPI_Comm comm,
  MPI_Errhandler errhandler
);
int PMPI_Comm_set_errhandler(
  MPI_Comm comm,
  MPI_Errhandler errhandler
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_get_errhandler)(
  MPIABI_Comm comm,
  MPIABI_Errhandler * errhandler
);
int MPI_Comm_get_errhandler(
  MPI_Comm comm,
  MPI_Errhandler * errhandler
);
int PMPI_Comm_get_errhandler(
  MPI_Comm comm,
  MPI_Errhandler * errhandler
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_create_errhandler)(
  MPIABI_Win_errhandler_function * win_errhandler_fn,
  MPIABI_Errhandler * errhandler
);
int MPI_Win_create_errhandler(
  MPI_Win_errhandler_function * win_errhandler_fn,
  MPI_Errhandler * errhandler
);
int PMPI_Win_create_errhandler(
  MPI_Win_errhandler_function * win_errhandler_fn,
  MPI_Errhandler * errhandler
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_set_errhandler)(
  MPIABI_Win win,
  MPIABI_Errhandler errhandler
);
int MPI_Win_set_errhandler(
  MPI_Win win,
  MPI_Errhandler errhandler
);
int PMPI_Win_set_errhandler(
  MPI_Win win,
  MPI_Errhandler errhandler
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_get_errhandler)(
  MPIABI_Win win,
  MPIABI_Errhandler * errhandler
);
int MPI_Win_get_errhandler(
  MPI_Win win,
  MPI_Errhandler * errhandler
);
int PMPI_Win_get_errhandler(
  MPI_Win win,
  MPI_Errhandler * errhandler
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_create_errhandler)(
  MPIABI_File_errhandler_function * file_errhandler_fn,
  MPIABI_Errhandler * errhandler
);
int MPI_File_create_errhandler(
  MPI_File_errhandler_function * file_errhandler_fn,
  MPI_Errhandler * errhandler
);
int PMPI_File_create_errhandler(
  MPI_File_errhandler_function * file_errhandler_fn,
  MPI_Errhandler * errhandler
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_set_errhandler)(
  MPIABI_File file,
  MPIABI_Errhandler errhandler
);
int MPI_File_set_errhandler(
  MPI_File file,
  MPI_Errhandler errhandler
);
int PMPI_File_set_errhandler(
  MPI_File file,
  MPI_Errhandler errhandler
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_get_errhandler)(
  MPIABI_File file,
  MPIABI_Errhandler * errhandler
);
int MPI_File_get_errhandler(
  MPI_File file,
  MPI_Errhandler * errhandler
);
int PMPI_File_get_errhandler(
  MPI_File file,
  MPI_Errhandler * errhandler
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Errhandler_free)(
  MPIABI_Errhandler * errhandler
);
int MPI_Errhandler_free(
  MPI_Errhandler * errhandler
);
int PMPI_Errhandler_free(
  MPI_Errhandler * errhandler
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Error_string)(
  int errorcode,
  char * string,
  int * resultlen
);
int MPI_Error_string(
  int errorcode,
  char * string,
  int * resultlen
);
int PMPI_Error_string(
  int errorcode,
  char * string,
  int * resultlen
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Error_class)(
  int errorcode,
  int * errorclass
);
int MPI_Error_class(
  int errorcode,
  int * errorclass
);
int PMPI_Error_class(
  int errorcode,
  int * errorclass
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Add_error_class)(
  int * errorclass
);
int MPI_Add_error_class(
  int * errorclass
);
int PMPI_Add_error_class(
  int * errorclass
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Add_error_code)(
  int errorclass,
  int * errorcode
);
int MPI_Add_error_code(
  int errorclass,
  int * errorcode
);
int PMPI_Add_error_code(
  int errorclass,
  int * errorcode
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Add_error_string)(
  int errorcode,
  const char * string
);
int MPI_Add_error_string(
  int errorcode,
  const char * string
);
int PMPI_Add_error_string(
  int errorcode,
  const char * string
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_call_errhandler)(
  MPIABI_Comm comm,
  int errorcode
);
int MPI_Comm_call_errhandler(
  MPI_Comm comm,
  int errorcode
);
int PMPI_Comm_call_errhandler(
  MPI_Comm comm,
  int errorcode
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_call_errhandler)(
  MPIABI_Win win,
  int errorcode
);
int MPI_Win_call_errhandler(
  MPI_Win win,
  int errorcode
);
int PMPI_Win_call_errhandler(
  MPI_Win win,
  int errorcode
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_call_errhandler)(
  MPIABI_File file,
  int errorcode
);
int MPI_File_call_errhandler(
  MPI_File file,
  int errorcode
);
int PMPI_File_call_errhandler(
  MPI_File file,
  int errorcode
);
extern double (* MPITRAMPOLINE_CONST MPIABI_Wtime)(
);
double MPI_Wtime(
);
double PMPI_Wtime(
);
extern double (* MPITRAMPOLINE_CONST MPIABI_Wtick)(
);
double MPI_Wtick(
);
double PMPI_Wtick(
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Init)(
  int * argc,
  char *** argv
);
int MPI_Init(
  int * argc,
  char *** argv
);
int PMPI_Init(
  int * argc,
  char *** argv
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Finalize)(
);
int MPI_Finalize(
);
int PMPI_Finalize(
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Initialized)(
  int * flag
);
int MPI_Initialized(
  int * flag
);
int PMPI_Initialized(
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Abort)(
  MPIABI_Comm comm,
  int errorcode
);
int MPI_Abort(
  MPI_Comm comm,
  int errorcode
);
int PMPI_Abort(
  MPI_Comm comm,
  int errorcode
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Finalized)(
  int * flag
);
int MPI_Finalized(
  int * flag
);
int PMPI_Finalized(
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Info_create)(
  MPIABI_Info * info
);
int MPI_Info_create(
  MPI_Info * info
);
int PMPI_Info_create(
  MPI_Info * info
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Info_set)(
  MPIABI_Info info,
  const char * key,
  const char * value
);
int MPI_Info_set(
  MPI_Info info,
  const char * key,
  const char * value
);
int PMPI_Info_set(
  MPI_Info info,
  const char * key,
  const char * value
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Info_delete)(
  MPIABI_Info info,
  const char * key
);
int MPI_Info_delete(
  MPI_Info info,
  const char * key
);
int PMPI_Info_delete(
  MPI_Info info,
  const char * key
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Info_get)(
  MPIABI_Info info,
  const char * key,
  int valuelen,
  char * value,
  int * flag
);
int MPI_Info_get(
  MPI_Info info,
  const char * key,
  int valuelen,
  char * value,
  int * flag
);
int PMPI_Info_get(
  MPI_Info info,
  const char * key,
  int valuelen,
  char * value,
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Info_get_valuelen)(
  MPIABI_Info info,
  const char * key,
  int * valuelen,
  int * flag
);
int MPI_Info_get_valuelen(
  MPI_Info info,
  const char * key,
  int * valuelen,
  int * flag
);
int PMPI_Info_get_valuelen(
  MPI_Info info,
  const char * key,
  int * valuelen,
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Info_get_nkeys)(
  MPIABI_Info info,
  int * nkeys
);
int MPI_Info_get_nkeys(
  MPI_Info info,
  int * nkeys
);
int PMPI_Info_get_nkeys(
  MPI_Info info,
  int * nkeys
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Info_get_nthkey)(
  MPIABI_Info info,
  int n,
  char * key
);
int MPI_Info_get_nthkey(
  MPI_Info info,
  int n,
  char * key
);
int PMPI_Info_get_nthkey(
  MPI_Info info,
  int n,
  char * key
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Info_dup)(
  MPIABI_Info info,
  MPIABI_Info * newinfo
);
int MPI_Info_dup(
  MPI_Info info,
  MPI_Info * newinfo
);
int PMPI_Info_dup(
  MPI_Info info,
  MPI_Info * newinfo
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Info_free)(
  MPIABI_Info * info
);
int MPI_Info_free(
  MPI_Info * info
);
int PMPI_Info_free(
  MPI_Info * info
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_spawn)(
  const char * command,
  char ** argv,
  int maxprocs,
  MPIABI_Info info,
  int root,
  MPIABI_Comm comm,
  MPIABI_Comm * intercomm,
  int * array_off_errcodes
);
int MPI_Comm_spawn(
  const char * command,
  char ** argv,
  int maxprocs,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * intercomm,
  int * array_off_errcodes
);
int PMPI_Comm_spawn(
  const char * command,
  char ** argv,
  int maxprocs,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * intercomm,
  int * array_off_errcodes
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_get_parent)(
  MPIABI_Comm * parent
);
int MPI_Comm_get_parent(
  MPI_Comm * parent
);
int PMPI_Comm_get_parent(
  MPI_Comm * parent
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_spawn_multiple)(
  int count,
  char ** array_of_commands,
  char *** array_of_argv,
  const int * array_of_maxprocs,
  const MPIABI_Info * array_of_info,
  int root,
  MPIABI_Comm comm,
  MPIABI_Comm * intercomm,
  int * array_of_errcodes
);
int MPI_Comm_spawn_multiple(
  int count,
  char ** array_of_commands,
  char *** array_of_argv,
  const int * array_of_maxprocs,
  const MPI_Info * array_of_info,
  int root,
  MPI_Comm comm,
  MPI_Comm * intercomm,
  int * array_of_errcodes
);
int PMPI_Comm_spawn_multiple(
  int count,
  char ** array_of_commands,
  char *** array_of_argv,
  const int * array_of_maxprocs,
  const MPI_Info * array_of_info,
  int root,
  MPI_Comm comm,
  MPI_Comm * intercomm,
  int * array_of_errcodes
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Open_port)(
  MPIABI_Info info,
  char * port_name
);
int MPI_Open_port(
  MPI_Info info,
  char * port_name
);
int PMPI_Open_port(
  MPI_Info info,
  char * port_name
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Close_port)(
  const char * port_name
);
int MPI_Close_port(
  const char * port_name
);
int PMPI_Close_port(
  const char * port_name
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_accept)(
  const char * port_name,
  MPIABI_Info info,
  int root,
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm
);
int MPI_Comm_accept(
  const char * port_name,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * newcomm
);
int PMPI_Comm_accept(
  const char * port_name,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * newcomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_connect)(
  const char * port_name,
  MPIABI_Info info,
  int root,
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm
);
int MPI_Comm_connect(
  const char * port_name,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * newcomm
);
int PMPI_Comm_connect(
  const char * port_name,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * newcomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Publish_name)(
  const char * service_name,
  MPIABI_Info info,
  const char * port_name
);
int MPI_Publish_name(
  const char * service_name,
  MPI_Info info,
  const char * port_name
);
int PMPI_Publish_name(
  const char * service_name,
  MPI_Info info,
  const char * port_name
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Unpublish_name)(
  const char * service_name,
  MPIABI_Info info,
  const char * port_name
);
int MPI_Unpublish_name(
  const char * service_name,
  MPI_Info info,
  const char * port_name
);
int PMPI_Unpublish_name(
  const char * service_name,
  MPI_Info info,
  const char * port_name
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Lookup_name)(
  const char * service_name,
  MPIABI_Info info,
  char * port_name
);
int MPI_Lookup_name(
  const char * service_name,
  MPI_Info info,
  char * port_name
);
int PMPI_Lookup_name(
  const char * service_name,
  MPI_Info info,
  char * port_name
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_disconnect)(
  MPIABI_Comm * comm
);
int MPI_Comm_disconnect(
  MPI_Comm * comm
);
int PMPI_Comm_disconnect(
  MPI_Comm * comm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Comm_join)(
  int fd,
  MPIABI_Comm * intercomm
);
int MPI_Comm_join(
  int fd,
  MPI_Comm * intercomm
);
int PMPI_Comm_join(
  int fd,
  MPI_Comm * intercomm
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_create)(
  void * base,
  MPIABI_Aint size,
  int disp_unit,
  MPIABI_Info info,
  MPIABI_Comm comm,
  MPIABI_Win * win
);
int MPI_Win_create(
  void * base,
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  MPI_Win * win
);
int PMPI_Win_create(
  void * base,
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  MPI_Win * win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_allocate)(
  MPIABI_Aint size,
  int disp_unit,
  MPIABI_Info info,
  MPIABI_Comm comm,
  void * baseptr,
  MPIABI_Win * win
);
int MPI_Win_allocate(
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  void * baseptr,
  MPI_Win * win
);
int PMPI_Win_allocate(
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  void * baseptr,
  MPI_Win * win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_allocate_shared)(
  MPIABI_Aint size,
  int disp_unit,
  MPIABI_Info info,
  MPIABI_Comm comm,
  void * baseptr,
  MPIABI_Win * win
);
int MPI_Win_allocate_shared(
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  void * baseptr,
  MPI_Win * win
);
int PMPI_Win_allocate_shared(
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  void * baseptr,
  MPI_Win * win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_shared_query)(
  MPIABI_Win win,
  int rank,
  MPIABI_Aint * size,
  int * disp_unit,
  void * baseptr
);
int MPI_Win_shared_query(
  MPI_Win win,
  int rank,
  MPI_Aint * size,
  int * disp_unit,
  void * baseptr
);
int PMPI_Win_shared_query(
  MPI_Win win,
  int rank,
  MPI_Aint * size,
  int * disp_unit,
  void * baseptr
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_create_dynamic)(
  MPIABI_Info info,
  MPIABI_Comm comm,
  MPIABI_Win * win
);
int MPI_Win_create_dynamic(
  MPI_Info info,
  MPI_Comm comm,
  MPI_Win * win
);
int PMPI_Win_create_dynamic(
  MPI_Info info,
  MPI_Comm comm,
  MPI_Win * win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_attach)(
  MPIABI_Win win,
  void * base,
  MPIABI_Aint size
);
int MPI_Win_attach(
  MPI_Win win,
  void * base,
  MPI_Aint size
);
int PMPI_Win_attach(
  MPI_Win win,
  void * base,
  MPI_Aint size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_detach)(
  MPIABI_Win win,
  const void * base
);
int MPI_Win_detach(
  MPI_Win win,
  const void * base
);
int PMPI_Win_detach(
  MPI_Win win,
  const void * base
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_free)(
  MPIABI_Win * win
);
int MPI_Win_free(
  MPI_Win * win
);
int PMPI_Win_free(
  MPI_Win * win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_get_group)(
  MPIABI_Win win,
  MPIABI_Group * group
);
int MPI_Win_get_group(
  MPI_Win win,
  MPI_Group * group
);
int PMPI_Win_get_group(
  MPI_Win win,
  MPI_Group * group
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_set_info)(
  MPIABI_Win win,
  MPIABI_Info info
);
int MPI_Win_set_info(
  MPI_Win win,
  MPI_Info info
);
int PMPI_Win_set_info(
  MPI_Win win,
  MPI_Info info
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_get_info)(
  MPIABI_Win win,
  MPIABI_Info * info_used
);
int MPI_Win_get_info(
  MPI_Win win,
  MPI_Info * info_used
);
int PMPI_Win_get_info(
  MPI_Win win,
  MPI_Info * info_used
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Put)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win
);
int MPI_Put(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win
);
int PMPI_Put(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Get)(
  void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win
);
int MPI_Get(
  void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win
);
int PMPI_Get(
  void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Accumulate)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win
);
int MPI_Accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win
);
int PMPI_Accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Get_accumulate)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPIABI_Datatype result_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win
);
int MPI_Get_accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPI_Datatype result_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win
);
int PMPI_Get_accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPI_Datatype result_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Fetch_and_op)(
  const void * origin_addr,
  void * result_addr,
  MPIABI_Datatype datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  MPIABI_Op op,
  MPIABI_Win win
);
int MPI_Fetch_and_op(
  const void * origin_addr,
  void * result_addr,
  MPI_Datatype datatype,
  int target_rank,
  MPI_Aint target_disp,
  MPI_Op op,
  MPI_Win win
);
int PMPI_Fetch_and_op(
  const void * origin_addr,
  void * result_addr,
  MPI_Datatype datatype,
  int target_rank,
  MPI_Aint target_disp,
  MPI_Op op,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Compare_and_swap)(
  const void * origin_addr,
  const void * compare_addr,
  void * result_addr,
  MPIABI_Datatype datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  MPIABI_Win win
);
int MPI_Compare_and_swap(
  const void * origin_addr,
  const void * compare_addr,
  void * result_addr,
  MPI_Datatype datatype,
  int target_rank,
  MPI_Aint target_disp,
  MPI_Win win
);
int PMPI_Compare_and_swap(
  const void * origin_addr,
  const void * compare_addr,
  void * result_addr,
  MPI_Datatype datatype,
  int target_rank,
  MPI_Aint target_disp,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Rput)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win,
  MPIABI_Request * request
);
int MPI_Rput(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win,
  MPI_Request * request
);
int PMPI_Rput(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Rget)(
  void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win,
  MPIABI_Request * request
);
int MPI_Rget(
  void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win,
  MPI_Request * request
);
int PMPI_Rget(
  void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Raccumulate)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win,
  MPIABI_Request * request
);
int MPI_Raccumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win,
  MPI_Request * request
);
int PMPI_Raccumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Rget_accumulate)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPIABI_Datatype result_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win,
  MPIABI_Request * request
);
int MPI_Rget_accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPI_Datatype result_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win,
  MPI_Request * request
);
int PMPI_Rget_accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPI_Datatype result_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_fence)(
  int assert,
  MPIABI_Win win
);
int MPI_Win_fence(
  int assert,
  MPI_Win win
);
int PMPI_Win_fence(
  int assert,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_start)(
  MPIABI_Group group,
  int assert,
  MPIABI_Win win
);
int MPI_Win_start(
  MPI_Group group,
  int assert,
  MPI_Win win
);
int PMPI_Win_start(
  MPI_Group group,
  int assert,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_complete)(
  MPIABI_Win win
);
int MPI_Win_complete(
  MPI_Win win
);
int PMPI_Win_complete(
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_post)(
  MPIABI_Group group,
  int assert,
  MPIABI_Win win
);
int MPI_Win_post(
  MPI_Group group,
  int assert,
  MPI_Win win
);
int PMPI_Win_post(
  MPI_Group group,
  int assert,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_wait)(
  MPIABI_Win win
);
int MPI_Win_wait(
  MPI_Win win
);
int PMPI_Win_wait(
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_test)(
  MPIABI_Win win,
  int * flag
);
int MPI_Win_test(
  MPI_Win win,
  int * flag
);
int PMPI_Win_test(
  MPI_Win win,
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_lock)(
  int lock_type,
  int rank,
  int assert,
  MPIABI_Win win
);
int MPI_Win_lock(
  int lock_type,
  int rank,
  int assert,
  MPI_Win win
);
int PMPI_Win_lock(
  int lock_type,
  int rank,
  int assert,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_lock_all)(
  int assert,
  MPIABI_Win win
);
int MPI_Win_lock_all(
  int assert,
  MPI_Win win
);
int PMPI_Win_lock_all(
  int assert,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_unlock)(
  int rank,
  MPIABI_Win win
);
int MPI_Win_unlock(
  int rank,
  MPI_Win win
);
int PMPI_Win_unlock(
  int rank,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_unlock_all)(
  MPIABI_Win win
);
int MPI_Win_unlock_all(
  MPI_Win win
);
int PMPI_Win_unlock_all(
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_flush)(
  int rank,
  MPIABI_Win win
);
int MPI_Win_flush(
  int rank,
  MPI_Win win
);
int PMPI_Win_flush(
  int rank,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_flush_all)(
  MPIABI_Win win
);
int MPI_Win_flush_all(
  MPI_Win win
);
int PMPI_Win_flush_all(
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_flush_local)(
  int rank,
  MPIABI_Win win
);
int MPI_Win_flush_local(
  int rank,
  MPI_Win win
);
int PMPI_Win_flush_local(
  int rank,
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_flush_local_all)(
  MPIABI_Win win
);
int MPI_Win_flush_local_all(
  MPI_Win win
);
int PMPI_Win_flush_local_all(
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Win_sync)(
  MPIABI_Win win
);
int MPI_Win_sync(
  MPI_Win win
);
int PMPI_Win_sync(
  MPI_Win win
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Grequest_start)(
  MPIABI_Grequest_query_function * query_fn,
  MPIABI_Grequest_free_function * free_fn,
  MPIABI_Grequest_cancel_function * cancel_fn,
  void * extra_state,
  MPIABI_Request * request
);
int MPI_Grequest_start(
  MPI_Grequest_query_function * query_fn,
  MPI_Grequest_free_function * free_fn,
  MPI_Grequest_cancel_function * cancel_fn,
  void * extra_state,
  MPI_Request * request
);
int PMPI_Grequest_start(
  MPI_Grequest_query_function * query_fn,
  MPI_Grequest_free_function * free_fn,
  MPI_Grequest_cancel_function * cancel_fn,
  void * extra_state,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Grequest_complete)(
  MPIABI_Request request
);
int MPI_Grequest_complete(
  MPI_Request request
);
int PMPI_Grequest_complete(
  MPI_Request request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Status_set_elements)(
  MPIABI_Status * status,
  MPIABI_Datatype datatype,
  int count
);
int MPI_Status_set_elements(
  MPI_Status * status,
  MPI_Datatype datatype,
  int count
);
int PMPI_Status_set_elements(
  MPI_Status * status,
  MPI_Datatype datatype,
  int count
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Status_set_elements_x)(
  MPIABI_Status * status,
  MPIABI_Datatype datatype,
  MPIABI_Count count
);
int MPI_Status_set_elements_x(
  MPI_Status * status,
  MPI_Datatype datatype,
  MPI_Count count
);
int PMPI_Status_set_elements_x(
  MPI_Status * status,
  MPI_Datatype datatype,
  MPI_Count count
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Status_set_cancelled)(
  MPIABI_Status * status,
  int flag
);
int MPI_Status_set_cancelled(
  MPI_Status * status,
  int flag
);
int PMPI_Status_set_cancelled(
  MPI_Status * status,
  int flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Init_thread)(
  int * argc,
  char * * * argv,
  int required,
  int * provided
);
int MPI_Init_thread(
  int * argc,
  char * * * argv,
  int required,
  int * provided
);
int PMPI_Init_thread(
  int * argc,
  char * * * argv,
  int required,
  int * provided
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Query_thread)(
  int * provided
);
int MPI_Query_thread(
  int * provided
);
int PMPI_Query_thread(
  int * provided
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Is_thread_main)(
  int * flag
);
int MPI_Is_thread_main(
  int * flag
);
int PMPI_Is_thread_main(
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_open)(
  MPIABI_Comm comm,
  const char * filename,
  int amode,
  MPIABI_Info info,
  MPIABI_File * fh
);
int MPI_File_open(
  MPI_Comm comm,
  const char * filename,
  int amode,
  MPI_Info info,
  MPI_File * fh
);
int PMPI_File_open(
  MPI_Comm comm,
  const char * filename,
  int amode,
  MPI_Info info,
  MPI_File * fh
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_close)(
  MPIABI_File * fh
);
int MPI_File_close(
  MPI_File * fh
);
int PMPI_File_close(
  MPI_File * fh
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_delete)(
  const char * filename,
  MPIABI_Info info
);
int MPI_File_delete(
  const char * filename,
  MPI_Info info
);
int PMPI_File_delete(
  const char * filename,
  MPI_Info info
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_set_size)(
  MPIABI_File fh,
  MPIABI_Offset size
);
int MPI_File_set_size(
  MPI_File fh,
  MPI_Offset size
);
int PMPI_File_set_size(
  MPI_File fh,
  MPI_Offset size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_preallocate)(
  MPIABI_File fh,
  MPIABI_Offset size
);
int MPI_File_preallocate(
  MPI_File fh,
  MPI_Offset size
);
int PMPI_File_preallocate(
  MPI_File fh,
  MPI_Offset size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_get_size)(
  MPIABI_File fh,
  MPIABI_Offset * size
);
int MPI_File_get_size(
  MPI_File fh,
  MPI_Offset * size
);
int PMPI_File_get_size(
  MPI_File fh,
  MPI_Offset * size
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_get_group)(
  MPIABI_File fh,
  MPIABI_Group * group
);
int MPI_File_get_group(
  MPI_File fh,
  MPI_Group * group
);
int PMPI_File_get_group(
  MPI_File fh,
  MPI_Group * group
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_get_amode)(
  MPIABI_File fh,
  int * amode
);
int MPI_File_get_amode(
  MPI_File fh,
  int * amode
);
int PMPI_File_get_amode(
  MPI_File fh,
  int * amode
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_set_info)(
  MPIABI_File fh,
  MPIABI_Info info
);
int MPI_File_set_info(
  MPI_File fh,
  MPI_Info info
);
int PMPI_File_set_info(
  MPI_File fh,
  MPI_Info info
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_get_info)(
  MPIABI_File fh,
  MPIABI_Info * info_used
);
int MPI_File_get_info(
  MPI_File fh,
  MPI_Info * info_used
);
int PMPI_File_get_info(
  MPI_File fh,
  MPI_Info * info_used
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_set_view)(
  MPIABI_File fh,
  MPIABI_Offset disp,
  MPIABI_Datatype etype,
  MPIABI_Datatype filetype,
  const char * datarep,
  MPIABI_Info info
);
int MPI_File_set_view(
  MPI_File fh,
  MPI_Offset disp,
  MPI_Datatype etype,
  MPI_Datatype filetype,
  const char * datarep,
  MPI_Info info
);
int PMPI_File_set_view(
  MPI_File fh,
  MPI_Offset disp,
  MPI_Datatype etype,
  MPI_Datatype filetype,
  const char * datarep,
  MPI_Info info
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_get_view)(
  MPIABI_File fh,
  MPIABI_Offset * disp,
  MPIABI_Datatype * etype,
  MPIABI_Datatype * filetype,
  char * datarep
);
int MPI_File_get_view(
  MPI_File fh,
  MPI_Offset * disp,
  MPI_Datatype * etype,
  MPI_Datatype * filetype,
  char * datarep
);
int PMPI_File_get_view(
  MPI_File fh,
  MPI_Offset * disp,
  MPI_Datatype * etype,
  MPI_Datatype * filetype,
  char * datarep
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read_at)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_read_at(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_read_at(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read_at_all)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_read_at_all(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_read_at_all(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write_at)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_write_at(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_write_at(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write_at_all)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_write_at_all(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_write_at_all(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_iread_at)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
);
int MPI_File_iread_at(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
int PMPI_File_iread_at(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_iread_at_all)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
);
int MPI_File_iread_at_all(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
int PMPI_File_iread_at_all(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_iwrite_at)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
);
int MPI_File_iwrite_at(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
int PMPI_File_iwrite_at(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_iwrite_at_all)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
);
int MPI_File_iwrite_at_all(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
int PMPI_File_iwrite_at_all(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_read(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_read(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read_all)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_read_all(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_read_all(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_write(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_write(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write_all)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_write_all(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_write_all(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_iread)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
);
int MPI_File_iread(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
int PMPI_File_iread(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_iread_all)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
);
int MPI_File_iread_all(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
int PMPI_File_iread_all(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_iwrite)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
);
int MPI_File_iwrite(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
int PMPI_File_iwrite(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_iwrite_all)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
);
int MPI_File_iwrite_all(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
int PMPI_File_iwrite_all(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_seek)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  int whence
);
int MPI_File_seek(
  MPI_File fh,
  MPI_Offset offset,
  int whence
);
int PMPI_File_seek(
  MPI_File fh,
  MPI_Offset offset,
  int whence
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_get_position)(
  MPIABI_File fh,
  MPIABI_Offset * offset
);
int MPI_File_get_position(
  MPI_File fh,
  MPI_Offset * offset
);
int PMPI_File_get_position(
  MPI_File fh,
  MPI_Offset * offset
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_get_byte_offset)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  MPIABI_Offset * disp
);
int MPI_File_get_byte_offset(
  MPI_File fh,
  MPI_Offset offset,
  MPI_Offset * disp
);
int PMPI_File_get_byte_offset(
  MPI_File fh,
  MPI_Offset offset,
  MPI_Offset * disp
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read_shared)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_read_shared(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_read_shared(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write_shared)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_write_shared(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_write_shared(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_iread_shared)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
);
int MPI_File_iread_shared(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
int PMPI_File_iread_shared(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_iwrite_shared)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
);
int MPI_File_iwrite_shared(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
int PMPI_File_iwrite_shared(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read_ordered)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_read_ordered(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_read_ordered(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write_ordered)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
);
int MPI_File_write_ordered(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
int PMPI_File_write_ordered(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_seek_shared)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  int whence
);
int MPI_File_seek_shared(
  MPI_File fh,
  MPI_Offset offset,
  int whence
);
int PMPI_File_seek_shared(
  MPI_File fh,
  MPI_Offset offset,
  int whence
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_get_position_shared)(
  MPIABI_File fh,
  MPIABI_Offset * offset
);
int MPI_File_get_position_shared(
  MPI_File fh,
  MPI_Offset * offset
);
int PMPI_File_get_position_shared(
  MPI_File fh,
  MPI_Offset * offset
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read_at_all_begin)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype
);
int MPI_File_read_at_all_begin(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype
);
int PMPI_File_read_at_all_begin(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read_at_all_end)(
  MPIABI_File fh,
  void * buf,
  MPIABI_Status * status
);
int MPI_File_read_at_all_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
);
int PMPI_File_read_at_all_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write_at_all_begin)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype
);
int MPI_File_write_at_all_begin(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype
);
int PMPI_File_write_at_all_begin(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write_at_all_end)(
  MPIABI_File fh,
  const void * buf,
  MPIABI_Status * status
);
int MPI_File_write_at_all_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
);
int PMPI_File_write_at_all_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read_all_begin)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype
);
int MPI_File_read_all_begin(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype
);
int PMPI_File_read_all_begin(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read_all_end)(
  MPIABI_File fh,
  void * buf,
  MPIABI_Status * status
);
int MPI_File_read_all_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
);
int PMPI_File_read_all_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write_all_begin)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype
);
int MPI_File_write_all_begin(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype
);
int PMPI_File_write_all_begin(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write_all_end)(
  MPIABI_File fh,
  const void * buf,
  MPIABI_Status * status
);
int MPI_File_write_all_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
);
int PMPI_File_write_all_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read_ordered_begin)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype
);
int MPI_File_read_ordered_begin(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype
);
int PMPI_File_read_ordered_begin(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_read_ordered_end)(
  MPIABI_File fh,
  void * buf,
  MPIABI_Status * status
);
int MPI_File_read_ordered_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
);
int PMPI_File_read_ordered_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write_ordered_begin)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype
);
int MPI_File_write_ordered_begin(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype
);
int PMPI_File_write_ordered_begin(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_write_ordered_end)(
  MPIABI_File fh,
  const void * buf,
  MPIABI_Status * status
);
int MPI_File_write_ordered_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
);
int PMPI_File_write_ordered_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_get_type_extent)(
  MPIABI_File fh,
  MPIABI_Datatype datatype,
  MPIABI_Aint * extent
);
int MPI_File_get_type_extent(
  MPI_File fh,
  MPI_Datatype datatype,
  MPI_Aint * extent
);
int PMPI_File_get_type_extent(
  MPI_File fh,
  MPI_Datatype datatype,
  MPI_Aint * extent
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Register_datarep)(
  const char * datarep,
  MPIABI_Datarep_conversion_function * read_conversion_fn,
  MPIABI_Datarep_conversion_function * write_conversion_fn,
  MPIABI_Datarep_extent_function * dtype_file_extent_fn,
  void * extra_state
);
int MPI_Register_datarep(
  const char * datarep,
  MPI_Datarep_conversion_function * read_conversion_fn,
  MPI_Datarep_conversion_function * write_conversion_fn,
  MPI_Datarep_extent_function * dtype_file_extent_fn,
  void * extra_state
);
int PMPI_Register_datarep(
  const char * datarep,
  MPI_Datarep_conversion_function * read_conversion_fn,
  MPI_Datarep_conversion_function * write_conversion_fn,
  MPI_Datarep_extent_function * dtype_file_extent_fn,
  void * extra_state
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_set_atomicity)(
  MPIABI_File fh,
  int flag
);
int MPI_File_set_atomicity(
  MPI_File fh,
  int flag
);
int PMPI_File_set_atomicity(
  MPI_File fh,
  int flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_get_atomicity)(
  MPIABI_File fh,
  int * flag
);
int MPI_File_get_atomicity(
  MPI_File fh,
  int * flag
);
int PMPI_File_get_atomicity(
  MPI_File fh,
  int * flag
);
extern int (* MPITRAMPOLINE_CONST MPIABI_File_sync)(
  MPIABI_File fh
);
int MPI_File_sync(
  MPI_File fh
);
int PMPI_File_sync(
  MPI_File fh
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_f90_real)(
  int precision,
  int range,
  MPIABI_Datatype * newtype
);
int MPI_Type_create_f90_real(
  int precision,
  int range,
  MPI_Datatype * newtype
);
int PMPI_Type_create_f90_real(
  int precision,
  int range,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_f90_complex)(
  int precision,
  int range,
  MPIABI_Datatype * newtype
);
int MPI_Type_create_f90_complex(
  int precision,
  int range,
  MPI_Datatype * newtype
);
int PMPI_Type_create_f90_complex(
  int precision,
  int range,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_create_f90_integer)(
  int range,
  MPIABI_Datatype * newtype
);
int MPI_Type_create_f90_integer(
  int range,
  MPI_Datatype * newtype
);
int PMPI_Type_create_f90_integer(
  int range,
  MPI_Datatype * newtype
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Type_match_size)(
  int typeclass,
  int size,
  MPIABI_Datatype * datatype
);
int MPI_Type_match_size(
  int typeclass,
  int size,
  MPI_Datatype * datatype
);
int PMPI_Type_match_size(
  int typeclass,
  int size,
  MPI_Datatype * datatype
);
extern MPIABI_Comm (* MPITRAMPOLINE_CONST MPIABI_Comm_f2c)(
  MPIABI_Fint comm
);
MPI_Comm MPI_Comm_f2c(
  MPI_Fint comm
);
MPI_Comm PMPI_Comm_f2c(
  MPI_Fint comm
);
extern MPIABI_Fint (* MPITRAMPOLINE_CONST MPIABI_Comm_c2f)(
  MPIABI_Comm comm
);
MPI_Fint MPI_Comm_c2f(
  MPI_Comm comm
);
MPI_Fint PMPI_Comm_c2f(
  MPI_Comm comm
);
extern MPIABI_Datatype (* MPITRAMPOLINE_CONST MPIABI_Type_f2c)(
  MPIABI_Fint datatype
);
MPI_Datatype MPI_Type_f2c(
  MPI_Fint datatype
);
MPI_Datatype PMPI_Type_f2c(
  MPI_Fint datatype
);
extern MPIABI_Fint (* MPITRAMPOLINE_CONST MPIABI_Type_c2f)(
  MPIABI_Datatype datatype
);
MPI_Fint MPI_Type_c2f(
  MPI_Datatype datatype
);
MPI_Fint PMPI_Type_c2f(
  MPI_Datatype datatype
);
extern MPIABI_Group (* MPITRAMPOLINE_CONST MPIABI_Group_f2c)(
  MPIABI_Fint group
);
MPI_Group MPI_Group_f2c(
  MPI_Fint group
);
MPI_Group PMPI_Group_f2c(
  MPI_Fint group
);
extern MPIABI_Fint (* MPITRAMPOLINE_CONST MPIABI_Group_c2f)(
  MPIABI_Group group
);
MPI_Fint MPI_Group_c2f(
  MPI_Group group
);
MPI_Fint PMPI_Group_c2f(
  MPI_Group group
);
extern MPIABI_Request (* MPITRAMPOLINE_CONST MPIABI_Request_f2c)(
  MPIABI_Fint request
);
MPI_Request MPI_Request_f2c(
  MPI_Fint request
);
MPI_Request PMPI_Request_f2c(
  MPI_Fint request
);
extern MPIABI_Fint (* MPITRAMPOLINE_CONST MPIABI_Request_c2f)(
  MPIABI_Request request
);
MPI_Fint MPI_Request_c2f(
  MPI_Request request
);
MPI_Fint PMPI_Request_c2f(
  MPI_Request request
);
extern MPIABI_File (* MPITRAMPOLINE_CONST MPIABI_File_f2c)(
  MPIABI_Fint file
);
MPI_File MPI_File_f2c(
  MPI_Fint file
);
MPI_File PMPI_File_f2c(
  MPI_Fint file
);
extern MPIABI_Fint (* MPITRAMPOLINE_CONST MPIABI_File_c2f)(
  MPIABI_File file
);
MPI_Fint MPI_File_c2f(
  MPI_File file
);
MPI_Fint PMPI_File_c2f(
  MPI_File file
);
extern MPIABI_Win (* MPITRAMPOLINE_CONST MPIABI_Win_f2c)(
  MPIABI_Fint win
);
MPI_Win MPI_Win_f2c(
  MPI_Fint win
);
MPI_Win PMPI_Win_f2c(
  MPI_Fint win
);
extern MPIABI_Fint (* MPITRAMPOLINE_CONST MPIABI_Win_c2f)(
  MPIABI_Win win
);
MPI_Fint MPI_Win_c2f(
  MPI_Win win
);
MPI_Fint PMPI_Win_c2f(
  MPI_Win win
);
extern MPIABI_Op (* MPITRAMPOLINE_CONST MPIABI_Op_f2c)(
  MPIABI_Fint op
);
MPI_Op MPI_Op_f2c(
  MPI_Fint op
);
MPI_Op PMPI_Op_f2c(
  MPI_Fint op
);
extern MPIABI_Fint (* MPITRAMPOLINE_CONST MPIABI_Op_c2f)(
  MPIABI_Op op
);
MPI_Fint MPI_Op_c2f(
  MPI_Op op
);
MPI_Fint PMPI_Op_c2f(
  MPI_Op op
);
extern MPIABI_Info (* MPITRAMPOLINE_CONST MPIABI_Info_f2c)(
  MPIABI_Fint info
);
MPI_Info MPI_Info_f2c(
  MPI_Fint info
);
MPI_Info PMPI_Info_f2c(
  MPI_Fint info
);
extern MPIABI_Fint (* MPITRAMPOLINE_CONST MPIABI_Info_c2f)(
  MPIABI_Info info
);
MPI_Fint MPI_Info_c2f(
  MPI_Info info
);
MPI_Fint PMPI_Info_c2f(
  MPI_Info info
);
extern MPIABI_Errhandler (* MPITRAMPOLINE_CONST MPIABI_Errhandler_f2c)(
  MPIABI_Fint info
);
MPI_Errhandler MPI_Errhandler_f2c(
  MPI_Fint info
);
MPI_Errhandler PMPI_Errhandler_f2c(
  MPI_Fint info
);
extern MPIABI_Fint (* MPITRAMPOLINE_CONST MPIABI_Errhandler_c2f)(
  MPIABI_Errhandler info
);
MPI_Fint MPI_Errhandler_c2f(
  MPI_Errhandler info
);
MPI_Fint PMPI_Errhandler_c2f(
  MPI_Errhandler info
);
extern MPIABI_Message (* MPITRAMPOLINE_CONST MPIABI_Message_f2c)(
  MPIABI_Fint message
);
MPI_Message MPI_Message_f2c(
  MPI_Fint message
);
MPI_Message PMPI_Message_f2c(
  MPI_Fint message
);
extern MPIABI_Fint (* MPITRAMPOLINE_CONST MPIABI_Message_c2f)(
  MPIABI_Message message
);
MPI_Fint MPI_Message_c2f(
  MPI_Message message
);
MPI_Fint PMPI_Message_c2f(
  MPI_Message message
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Status_f2c)(
  const MPIABI_Fint * f_status,
  MPIABI_Status * c_status
);
int MPI_Status_f2c(
  const MPI_Fint * f_status,
  MPI_Status * c_status
);
int PMPI_Status_f2c(
  const MPI_Fint * f_status,
  MPI_Status * c_status
);
extern int (* MPITRAMPOLINE_CONST MPIABI_Status_c2f)(
  const MPIABI_Status * c_status,
  MPIABI_Fint * f_status
);
int MPI_Status_c2f(
  const MPI_Status * c_status,
  MPI_Fint * f_status
);
int PMPI_Status_c2f(
  const MPI_Status * c_status,
  MPI_Fint * f_status
);
extern int (* MPITRAMPOLINE_CONST MPIXABI_Query_cuda_support)(
);
int MPIX_Query_cuda_support(
);
int PMPIX_Query_cuda_support(
);
extern int (* MPITRAMPOLINE_CONST MPIXABI_Query_hip_support)(
);
int MPIX_Query_hip_support(
);
int PMPIX_Query_hip_support(
);
extern int (* MPITRAMPOLINE_CONST MPIXABI_Query_rocm_support)(
);
int MPIX_Query_rocm_support(
);
int PMPIX_Query_rocm_support(
);
extern int (* MPITRAMPOLINE_CONST MPIXABI_Query_ze_support)(
);
int MPIX_Query_ze_support(
);
int PMPIX_Query_ze_support(
);
