// Define C MPI functions

int MPIABI_Send(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
) {
  return MPI_Send(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Recv(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Status * status
) {
  return MPI_Recv(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    source,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_Get_count(
  const MPIABI_Status * status,
  MPIABI_Datatype datatype,
  int * count
) {
  return MPI_Get_count(
    (const MPI_Status *)(WPI_const_StatusPtr)status,
    (MPI_Datatype)(WPI_Datatype)datatype,
    count
  );
}

int MPIABI_Bsend(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
) {
  return MPI_Bsend(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Ssend(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
) {
  return MPI_Ssend(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Rsend(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
) {
  return MPI_Rsend(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Buffer_attach(
  void * buffer,
  int size
) {
  return MPI_Buffer_attach(
    buffer,
    size
  );
}

int MPIABI_Buffer_detach(
  void * buffer_addr,
  int * size
) {
  return MPI_Buffer_detach(
    buffer_addr,
    size
  );
}

int MPIABI_Isend(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Isend(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Ibsend(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ibsend(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Issend(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Issend(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Irsend(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Irsend(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Irecv(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Irecv(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    source,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Wait(
  MPIABI_Request * request,
  MPIABI_Status * status
) {
  return MPI_Wait(
    (MPI_Request *)(WPI_RequestPtr)request,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_Test(
  MPIABI_Request * request,
  int * flag,
  MPIABI_Status * status
) {
  return MPI_Test(
    (MPI_Request *)(WPI_RequestPtr)request,
    flag,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_Request_free(
  MPIABI_Request * request
) {
  return MPI_Request_free(
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Request_get_status(
  MPIABI_Request request,
  int * flag,
  MPIABI_Status * status
) {
  return MPI_Request_get_status(
    (MPI_Request)(WPI_Request)request,
    flag,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_Iprobe(
  int source,
  int tag,
  MPIABI_Comm comm,
  int * flag,
  MPIABI_Status * status
) {
  return MPI_Iprobe(
    source,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    flag,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_Probe(
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Status * status
) {
  return MPI_Probe(
    source,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_Improbe(
  int source,
  int tag,
  MPIABI_Comm comm,
  int * flag,
  MPIABI_Message * message,
  MPIABI_Status * status
) {
  return MPI_Improbe(
    source,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    flag,
    (MPI_Message *)(WPI_MessagePtr)message,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_Mprobe(
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Message * message,
  MPIABI_Status * status
) {
  return MPI_Mprobe(
    source,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Message *)(WPI_MessagePtr)message,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_Mrecv(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Message * message,
  MPIABI_Status * status
) {
  return MPI_Mrecv(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Message *)(WPI_MessagePtr)message,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_Imrecv(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Message * message,
  MPIABI_Request * request
) {
  return MPI_Imrecv(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Message *)(WPI_MessagePtr)message,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Cancel(
  MPIABI_Request * request
) {
  return MPI_Cancel(
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Test_cancelled(
  const MPIABI_Status * status,
  int * flag
) {
  return MPI_Test_cancelled(
    (const MPI_Status *)(WPI_const_StatusPtr)status,
    flag
  );
}

int MPIABI_Send_init(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Send_init(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Bsend_init(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Bsend_init(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Ssend_init(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ssend_init(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Rsend_init(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Rsend_init(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Recv_init(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Recv_init(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    source,
    tag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Start(
  MPIABI_Request * request
) {
  return MPI_Start(
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Sendrecv(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  int dest,
  int sendtag,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int source,
  int recvtag,
  MPIABI_Comm comm,
  MPIABI_Status * status
) {
  return MPI_Sendrecv(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    dest,
    sendtag,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    source,
    recvtag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_Sendrecv_replace(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int sendtag,
  int source,
  int recvtag,
  MPIABI_Comm comm,
  MPIABI_Status * status
) {
  return MPI_Sendrecv_replace(
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    dest,
    sendtag,
    source,
    recvtag,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_Type_contiguous(
  int count,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_contiguous(
    count,
    (MPI_Datatype)(WPI_Datatype)oldtype,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_vector(
  int count,
  int blocklength,
  int stride,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_vector(
    count,
    blocklength,
    stride,
    (MPI_Datatype)(WPI_Datatype)oldtype,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_create_hvector(
  int count,
  int blocklength,
  MPIABI_Aint stride,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_create_hvector(
    count,
    blocklength,
    (MPI_Aint)(WPI_Aint)stride,
    (MPI_Datatype)(WPI_Datatype)oldtype,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_indexed(
  int count,
  const int * array_of_blocklengths,
  const int * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_indexed(
    count,
    array_of_blocklengths,
    array_of_displacements,
    (MPI_Datatype)(WPI_Datatype)oldtype,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_create_hindexed(
  int count,
  const int * array_of_blocklengths,
  const MPIABI_Aint * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_create_hindexed(
    count,
    array_of_blocklengths,
    (const MPI_Aint *)(const WPI_Aint *)array_of_displacements,
    (MPI_Datatype)(WPI_Datatype)oldtype,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_create_indexed_block(
  int count,
  int blocklength,
  const int * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_create_indexed_block(
    count,
    blocklength,
    array_of_displacements,
    (MPI_Datatype)(WPI_Datatype)oldtype,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_create_hindexed_block(
  int count,
  int blocklength,
  const MPIABI_Aint * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_create_hindexed_block(
    count,
    blocklength,
    (const MPI_Aint *)(const WPI_Aint *)array_of_displacements,
    (MPI_Datatype)(WPI_Datatype)oldtype,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_create_subarray(
  int ndims,
  const int * array_of_sizes,
  const int * array_of_subsizes,
  const int * array_of_starts,
  int ordder,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_create_subarray(
    ndims,
    array_of_sizes,
    array_of_subsizes,
    array_of_starts,
    ordder,
    (MPI_Datatype)(WPI_Datatype)oldtype,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_create_darray(
  int size,
  int rank,
  int ndims,
  const int * array_of_gsizes,
  const int * array_of_distribs,
  const int * array_of_dargs,
  const int * array_of_psizes,
  int order,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_create_darray(
    size,
    rank,
    ndims,
    array_of_gsizes,
    array_of_distribs,
    array_of_dargs,
    array_of_psizes,
    order,
    (MPI_Datatype)(WPI_Datatype)oldtype,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Get_address(
  const void * location,
  MPIABI_Aint * address
) {
  return MPI_Get_address(
    location,
    (MPI_Aint *)(WPI_Aint *)address
  );
}

MPIABI_Aint MPIABI_Aint_add(
  MPIABI_Aint base,
  MPIABI_Aint disp
) {
  return (MPIABI_Aint)(WPI_Aint)MPI_Aint_add(
    (MPI_Aint)(WPI_Aint)base,
    (MPI_Aint)(WPI_Aint)disp
  );
}

MPIABI_Aint MPIABI_Aint_diff(
  MPIABI_Aint addr1,
  MPIABI_Aint addr2
) {
  return (MPIABI_Aint)(WPI_Aint)MPI_Aint_diff(
    (MPI_Aint)(WPI_Aint)addr1,
    (MPI_Aint)(WPI_Aint)addr2
  );
}

int MPIABI_Type_size(
  MPIABI_Datatype datatype,
  int * size
) {
  return MPI_Type_size(
    (MPI_Datatype)(WPI_Datatype)datatype,
    size
  );
}

int MPIABI_Type_size_x(
  MPIABI_Datatype datatype,
  MPIABI_Count * size
) {
  return MPI_Type_size_x(
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Count *)(WPI_Count *)size
  );
}

int MPIABI_Type_get_extent(
  MPIABI_Datatype datatype,
  MPIABI_Aint * lb,
  MPIABI_Aint * extent
) {
  return MPI_Type_get_extent(
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Aint *)(WPI_Aint *)lb,
    (MPI_Aint *)(WPI_Aint *)extent
  );
}

int MPIABI_Type_get_extent_x(
  MPIABI_Datatype datatype,
  MPIABI_Count * lb,
  MPIABI_Count * extent
) {
  return MPI_Type_get_extent_x(
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Count *)(WPI_Count *)lb,
    (MPI_Count *)(WPI_Count *)extent
  );
}

int MPIABI_Type_create_resized(
  MPIABI_Datatype oldtype,
  MPIABI_Aint lb,
  MPIABI_Aint extent,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_create_resized(
    (MPI_Datatype)(WPI_Datatype)oldtype,
    (MPI_Aint)(WPI_Aint)lb,
    (MPI_Aint)(WPI_Aint)extent,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_get_true_extent(
  MPIABI_Datatype datatype,
  MPIABI_Aint * true_lb,
  MPIABI_Aint * true_extent
) {
  return MPI_Type_get_true_extent(
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Aint *)(WPI_Aint *)true_lb,
    (MPI_Aint *)(WPI_Aint *)true_extent
  );
}

int MPIABI_Type_get_true_extent_x(
  MPIABI_Datatype datatype,
  MPIABI_Count * true_lb,
  MPIABI_Count * true_extent
) {
  return MPI_Type_get_true_extent_x(
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Count *)(WPI_Count *)true_lb,
    (MPI_Count *)(WPI_Count *)true_extent
  );
}

int MPIABI_Type_commit(
  MPIABI_Datatype * datatype
) {
  return MPI_Type_commit(
    (MPI_Datatype *)(WPI_DatatypePtr)datatype
  );
}

int MPIABI_Type_free(
  MPIABI_Datatype * datatype
) {
  return MPI_Type_free(
    (MPI_Datatype *)(WPI_DatatypePtr)datatype
  );
}

int MPIABI_Type_dup(
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_dup(
    (MPI_Datatype)(WPI_Datatype)oldtype,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Get_elements(
  const MPIABI_Status * status,
  MPIABI_Datatype datatype,
  int * count
) {
  return MPI_Get_elements(
    (const MPI_Status *)(WPI_const_StatusPtr)status,
    (MPI_Datatype)(WPI_Datatype)datatype,
    count
  );
}

int MPIABI_Get_elements_x(
  const MPIABI_Status * status,
  MPIABI_Datatype datatype,
  MPIABI_Count * count
) {
  return MPI_Get_elements_x(
    (const MPI_Status *)(WPI_const_StatusPtr)status,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Count *)(WPI_Count *)count
  );
}

int MPIABI_Type_get_envelope(
  MPIABI_Datatype datatype,
  int * num_integers,
  int * num_addresses,
  int * num_datatypes,
  int * combiner
) {
  return MPI_Type_get_envelope(
    (MPI_Datatype)(WPI_Datatype)datatype,
    num_integers,
    num_addresses,
    num_datatypes,
    combiner
  );
}

int MPIABI_Pack(
  const void * inbuf,
  int incount,
  MPIABI_Datatype datatype,
  void * outbuf,
  int outsize,
  int * position,
  MPIABI_Comm comm
) {
  return MPI_Pack(
    inbuf,
    incount,
    (MPI_Datatype)(WPI_Datatype)datatype,
    outbuf,
    outsize,
    position,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Unpack(
  const void * inbuf,
  int insize,
  int * position,
  void * outbuf,
  int outcount,
  MPIABI_Datatype datatype,
  MPIABI_Comm comm
) {
  return MPI_Unpack(
    inbuf,
    insize,
    position,
    outbuf,
    outcount,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Pack_size(
  int incount,
  MPIABI_Datatype datatype,
  MPIABI_Comm comm,
  int * size
) {
  return MPI_Pack_size(
    incount,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Comm)(WPI_Comm)comm,
    size
  );
}

int MPIABI_Pack_external(
  const char * datarep,
  const void * inbuf,
  int incount,
  MPIABI_Datatype datatype,
  void * outbuf,
  MPIABI_Aint outsize,
  MPIABI_Aint * position
) {
  return MPI_Pack_external(
    datarep,
    inbuf,
    incount,
    (MPI_Datatype)(WPI_Datatype)datatype,
    outbuf,
    (MPI_Aint)(WPI_Aint)outsize,
    (MPI_Aint *)(WPI_Aint *)position
  );
}

int MPIABI_Unpack_external(
  const char * datarep,
  const void * inbuf,
  MPIABI_Aint insize,
  MPIABI_Aint * position,
  void * outbuf,
  int outcount,
  MPIABI_Datatype datatype
) {
  return MPI_Unpack_external(
    datarep,
    inbuf,
    (MPI_Aint)(WPI_Aint)insize,
    (MPI_Aint *)(WPI_Aint *)position,
    outbuf,
    outcount,
    (MPI_Datatype)(WPI_Datatype)datatype
  );
}

int MPIABI_Pack_external_size(
  const char * datarep,
  int incount,
  MPIABI_Datatype datatype,
  MPIABI_Aint * size
) {
  return MPI_Pack_external_size(
    datarep,
    incount,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Aint *)(WPI_Aint *)size
  );
}

int MPIABI_Barrier(
  MPIABI_Comm comm
) {
  return MPI_Barrier(
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Bcast(
  void * buffer,
  int count,
  MPIABI_Datatype datatype,
  int root,
  MPIABI_Comm comm
) {
  return MPI_Bcast(
    buffer,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    root,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Gather(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
) {
  return MPI_Gather(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    root,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Gatherv(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
) {
  return MPI_Gatherv(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    root,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Scatter(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
) {
  return MPI_Scatter(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    root,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Scatterv(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
) {
  return MPI_Scatterv(
    sendbuf,
    sendcounts,
    displs,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    root,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Allgather(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) {
  return MPI_Allgather(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Allgatherv(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) {
  return MPI_Allgatherv(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Alltoall(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) {
  return MPI_Alltoall(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) {
  return MPI_Alltoallv(
    sendbuf,
    sendcounts,
    sdispls,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Reduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  int root,
  MPIABI_Comm comm
) {
  return MPI_Reduce(
    sendbuf,
    recvbuf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    root,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Allreduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
) {
  return MPI_Allreduce(
    sendbuf,
    recvbuf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Op_commutative(
  MPIABI_Op op,
  int * commute
) {
  return MPI_Op_commutative(
    (MPI_Op)(WPI_Op)op,
    commute
  );
}

int MPIABI_Reduce_local(
  const void * inbuf,
  void * inoutbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op
) {
  return MPI_Reduce_local(
    inbuf,
    inoutbuf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op
  );
}

int MPIABI_Reduce_scatter_block(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
) {
  return MPI_Reduce_scatter_block(
    sendbuf,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Reduce_scatter(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
) {
  return MPI_Reduce_scatter(
    sendbuf,
    recvbuf,
    recvcounts,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Scan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
) {
  return MPI_Scan(
    sendbuf,
    recvbuf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Exscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
) {
  return MPI_Exscan(
    sendbuf,
    recvbuf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Ibarrier(
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ibarrier(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Ibcast(
  void * buffer,
  int count,
  MPIABI_Datatype datatype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ibcast(
    buffer,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    root,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Igather(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Igather(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    root,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Igatherv(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Igatherv(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    root,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Iscatter(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Iscatter(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    root,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Iscatterv(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Iscatterv(
    sendbuf,
    sendcounts,
    displs,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    root,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Iallgather(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Iallgather(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Iallgatherv(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Iallgatherv(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Ialltoall(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ialltoall(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Ialltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ialltoallv(
    sendbuf,
    sendcounts,
    sdispls,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Ireduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ireduce(
    sendbuf,
    recvbuf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    root,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Iallreduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Iallreduce(
    sendbuf,
    recvbuf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Ireduce_scatter_block(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ireduce_scatter_block(
    sendbuf,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Ireduce_scatter(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ireduce_scatter(
    sendbuf,
    recvbuf,
    recvcounts,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Iscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Iscan(
    sendbuf,
    recvbuf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Iexscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Iexscan(
    sendbuf,
    recvbuf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Group_size(
  MPIABI_Group group,
  int * size
) {
  return MPI_Group_size(
    (MPI_Group)(WPI_Group)group,
    size
  );
}

int MPIABI_Group_rank(
  MPIABI_Group group,
  int * rank
) {
  return MPI_Group_rank(
    (MPI_Group)(WPI_Group)group,
    rank
  );
}

int MPIABI_Group_translate_ranks(
  MPIABI_Group group1,
  int n,
  const int * ranks1,
  MPIABI_Group group2,
  int * ranks2
) {
  return MPI_Group_translate_ranks(
    (MPI_Group)(WPI_Group)group1,
    n,
    ranks1,
    (MPI_Group)(WPI_Group)group2,
    ranks2
  );
}

int MPIABI_Group_compare(
  MPIABI_Group group1,
  MPIABI_Group group2,
  int * result
) {
  return MPI_Group_compare(
    (MPI_Group)(WPI_Group)group1,
    (MPI_Group)(WPI_Group)group2,
    result
  );
}

int MPIABI_Comm_group(
  MPIABI_Comm comm,
  MPIABI_Group * group
) {
  return MPI_Comm_group(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Group *)(WPI_GroupPtr)group
  );
}

int MPIABI_Group_union(
  MPIABI_Group group1,
  MPIABI_Group group2,
  MPIABI_Group * newgroup
) {
  return MPI_Group_union(
    (MPI_Group)(WPI_Group)group1,
    (MPI_Group)(WPI_Group)group2,
    (MPI_Group *)(WPI_GroupPtr)newgroup
  );
}

int MPIABI_Group_intersection(
  MPIABI_Group group1,
  MPIABI_Group group2,
  MPIABI_Group * newgroup
) {
  return MPI_Group_intersection(
    (MPI_Group)(WPI_Group)group1,
    (MPI_Group)(WPI_Group)group2,
    (MPI_Group *)(WPI_GroupPtr)newgroup
  );
}

int MPIABI_Group_difference(
  MPIABI_Group group1,
  MPIABI_Group group2,
  MPIABI_Group * newgroup
) {
  return MPI_Group_difference(
    (MPI_Group)(WPI_Group)group1,
    (MPI_Group)(WPI_Group)group2,
    (MPI_Group *)(WPI_GroupPtr)newgroup
  );
}

int MPIABI_Group_incl(
  MPIABI_Group group,
  int n,
  const int * ranks,
  MPIABI_Group * newgroup
) {
  return MPI_Group_incl(
    (MPI_Group)(WPI_Group)group,
    n,
    ranks,
    (MPI_Group *)(WPI_GroupPtr)newgroup
  );
}

int MPIABI_Group_excl(
  MPIABI_Group group,
  int n,
  const int * ranks,
  MPIABI_Group * newgroup
) {
  return MPI_Group_excl(
    (MPI_Group)(WPI_Group)group,
    n,
    ranks,
    (MPI_Group *)(WPI_GroupPtr)newgroup
  );
}

int MPIABI_Group_range_incl(
  MPIABI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPIABI_Group * newgroup
) {
  return MPI_Group_range_incl(
    (MPI_Group)(WPI_Group)group,
    n,
    ranges,
    (MPI_Group *)(WPI_GroupPtr)newgroup
  );
}

int MPIABI_Group_range_excl(
  MPIABI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPIABI_Group * newgroup
) {
  return MPI_Group_range_excl(
    (MPI_Group)(WPI_Group)group,
    n,
    ranges,
    (MPI_Group *)(WPI_GroupPtr)newgroup
  );
}

int MPIABI_Group_free(
  MPIABI_Group * group
) {
  return MPI_Group_free(
    (MPI_Group *)(WPI_GroupPtr)group
  );
}

int MPIABI_Comm_size(
  MPIABI_Comm comm,
  int * size
) {
  return MPI_Comm_size(
    (MPI_Comm)(WPI_Comm)comm,
    size
  );
}

int MPIABI_Comm_rank(
  MPIABI_Comm comm,
  int * rank
) {
  return MPI_Comm_rank(
    (MPI_Comm)(WPI_Comm)comm,
    rank
  );
}

int MPIABI_Comm_compare(
  MPIABI_Comm comm1,
  MPIABI_Comm comm2,
  int * result
) {
  return MPI_Comm_compare(
    (MPI_Comm)(WPI_Comm)comm1,
    (MPI_Comm)(WPI_Comm)comm2,
    result
  );
}

int MPIABI_Comm_dup(
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm
) {
  return MPI_Comm_dup(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Comm *)(WPI_CommPtr)newcomm
  );
}

int MPIABI_Comm_dup_with_info(
  MPIABI_Comm comm,
  MPIABI_Info info,
  MPIABI_Comm * newcomm
) {
  return MPI_Comm_dup_with_info(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Info)(WPI_Info)info,
    (MPI_Comm *)(WPI_CommPtr)newcomm
  );
}

int MPIABI_Comm_idup(
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm,
  MPIABI_Request * request
) {
  return MPI_Comm_idup(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Comm *)(WPI_CommPtr)newcomm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Comm_create(
  MPIABI_Comm comm,
  MPIABI_Group group,
  MPIABI_Comm * newcomm
) {
  return MPI_Comm_create(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Group)(WPI_Group)group,
    (MPI_Comm *)(WPI_CommPtr)newcomm
  );
}

int MPIABI_Comm_create_group(
  MPIABI_Comm comm,
  MPIABI_Group group,
  int tag,
  MPIABI_Comm * newcomm
) {
  return MPI_Comm_create_group(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Group)(WPI_Group)group,
    tag,
    (MPI_Comm *)(WPI_CommPtr)newcomm
  );
}

int MPIABI_Comm_split(
  MPIABI_Comm comm,
  int color,
  int key,
  MPIABI_Comm * newcomm
) {
  return MPI_Comm_split(
    (MPI_Comm)(WPI_Comm)comm,
    color,
    key,
    (MPI_Comm *)(WPI_CommPtr)newcomm
  );
}

int MPIABI_Comm_split_type(
  MPIABI_Comm comm,
  int split_type,
  int key,
  MPIABI_Info info,
  MPIABI_Comm * newcomm
) {
  return MPI_Comm_split_type(
    (MPI_Comm)(WPI_Comm)comm,
    split_type,
    key,
    (MPI_Info)(WPI_Info)info,
    (MPI_Comm *)(WPI_CommPtr)newcomm
  );
}

int MPIABI_Comm_free(
  MPIABI_Comm * comm
) {
  return MPI_Comm_free(
    (MPI_Comm *)(WPI_CommPtr)comm
  );
}

int MPIABI_Comm_set_info(
  MPIABI_Comm comm,
  MPIABI_Info info
) {
  return MPI_Comm_set_info(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Info)(WPI_Info)info
  );
}

int MPIABI_Comm_get_info(
  MPIABI_Comm comm,
  MPIABI_Info * info
) {
  return MPI_Comm_get_info(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Info *)(WPI_InfoPtr)info
  );
}

int MPIABI_Comm_test_inter(
  MPIABI_Comm comm,
  int * flag
) {
  return MPI_Comm_test_inter(
    (MPI_Comm)(WPI_Comm)comm,
    flag
  );
}

int MPIABI_Comm_remote_size(
  MPIABI_Comm comm,
  int * size
) {
  return MPI_Comm_remote_size(
    (MPI_Comm)(WPI_Comm)comm,
    size
  );
}

int MPIABI_Comm_remote_group(
  MPIABI_Comm comm,
  MPIABI_Group * group
) {
  return MPI_Comm_remote_group(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Group *)(WPI_GroupPtr)group
  );
}

int MPIABI_Intercomm_create(
  MPIABI_Comm local_comm,
  int local_leader,
  MPIABI_Comm peer_comm,
  int remote_leader,
  int tag,
  MPIABI_Comm * newintercomm
) {
  return MPI_Intercomm_create(
    (MPI_Comm)(WPI_Comm)local_comm,
    local_leader,
    (MPI_Comm)(WPI_Comm)peer_comm,
    remote_leader,
    tag,
    (MPI_Comm *)(WPI_CommPtr)newintercomm
  );
}

int MPIABI_Intercomm_merge(
  MPIABI_Comm intercomm,
  int high,
  MPIABI_Comm * newintracomm
) {
  return MPI_Intercomm_merge(
    (MPI_Comm)(WPI_Comm)intercomm,
    high,
    (MPI_Comm *)(WPI_CommPtr)newintracomm
  );
}

int MPIABI_Comm_create_keyval(
  MPIABI_Comm_copy_attr_function * comm_copy_attr_fn,
  MPIABI_Comm_delete_attr_function * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state
) {
  return MPI_Comm_create_keyval(
    (MPI_Comm_copy_attr_function *)(WPI_Comm_copy_attr_function *)comm_copy_attr_fn,
    (MPI_Comm_delete_attr_function *)(WPI_Comm_delete_attr_function *)comm_delete_attr_fn,
    comm_keyval,
    extra_state
  );
}

int MPIABI_Comm_free_keyval(
  int * comm_keyval
) {
  return MPI_Comm_free_keyval(
    comm_keyval
  );
}

int MPIABI_Comm_set_attr(
  MPIABI_Comm comm,
  int comm_keyval,
  void * attribute_val
) {
  return MPI_Comm_set_attr(
    (MPI_Comm)(WPI_Comm)comm,
    comm_keyval,
    attribute_val
  );
}

int MPIABI_Comm_get_attr(
  MPIABI_Comm comm,
  int comm_keyval,
  void * attribute_val,
  int * flag
) {
  return MPI_Comm_get_attr(
    (MPI_Comm)(WPI_Comm)comm,
    comm_keyval,
    attribute_val,
    flag
  );
}

int MPIABI_Comm_delete_attr(
  MPIABI_Comm comm,
  int comm_keyval
) {
  return MPI_Comm_delete_attr(
    (MPI_Comm)(WPI_Comm)comm,
    comm_keyval
  );
}

int MPIABI_Win_create_keyval(
  MPIABI_Win_copy_attr_function * win_copy_attr_fn,
  MPIABI_Win_delete_attr_function * win_delete_attr_fn,
  int * win_keyval,
  void * extra_state
) {
  return MPI_Win_create_keyval(
    (MPI_Win_copy_attr_function *)(WPI_Win_copy_attr_function *)win_copy_attr_fn,
    (MPI_Win_delete_attr_function *)(WPI_Win_delete_attr_function *)win_delete_attr_fn,
    win_keyval,
    extra_state
  );
}

int MPIABI_Win_free_keyval(
  int * win_keyval
) {
  return MPI_Win_free_keyval(
    win_keyval
  );
}

int MPIABI_Win_set_attr(
  MPIABI_Win win,
  int win_keyval,
  void * attribute_val
) {
  return MPI_Win_set_attr(
    (MPI_Win)(WPI_Win)win,
    win_keyval,
    attribute_val
  );
}

int MPIABI_Win_get_attr(
  MPIABI_Win win,
  int win_keyval,
  void * attribute_val,
  int * flag
) {
  return MPI_Win_get_attr(
    (MPI_Win)(WPI_Win)win,
    win_keyval,
    attribute_val,
    flag
  );
}

int MPIABI_Win_delete_attr(
  MPIABI_Win win,
  int win_keyval
) {
  return MPI_Win_delete_attr(
    (MPI_Win)(WPI_Win)win,
    win_keyval
  );
}

int MPIABI_Type_create_keyval(
  MPIABI_Type_copy_attr_function * type_copy_attr_fn,
  MPIABI_Type_delete_attr_function * type_delete_attr_fn,
  int * type_keyval,
  void * extra_state
) {
  return MPI_Type_create_keyval(
    (MPI_Type_copy_attr_function *)(WPI_Type_copy_attr_function *)type_copy_attr_fn,
    (MPI_Type_delete_attr_function *)(WPI_Type_delete_attr_function *)type_delete_attr_fn,
    type_keyval,
    extra_state
  );
}

int MPIABI_Type_free_keyval(
  int * type_keyval
) {
  return MPI_Type_free_keyval(
    type_keyval
  );
}

int MPIABI_Type_set_attr(
  MPIABI_Datatype type,
  int type_keyval,
  void * attribute_val
) {
  return MPI_Type_set_attr(
    (MPI_Datatype)(WPI_Datatype)type,
    type_keyval,
    attribute_val
  );
}

int MPIABI_Type_get_attr(
  MPIABI_Datatype type,
  int type_keyval,
  void * attribute_val,
  int * flag
) {
  return MPI_Type_get_attr(
    (MPI_Datatype)(WPI_Datatype)type,
    type_keyval,
    attribute_val,
    flag
  );
}

int MPIABI_Type_delete_attr(
  MPIABI_Datatype type,
  int type_keyval
) {
  return MPI_Type_delete_attr(
    (MPI_Datatype)(WPI_Datatype)type,
    type_keyval
  );
}

int MPIABI_Comm_set_name(
  MPIABI_Comm comm,
  const char * comm_name
) {
  return MPI_Comm_set_name(
    (MPI_Comm)(WPI_Comm)comm,
    comm_name
  );
}

int MPIABI_Comm_get_name(
  MPIABI_Comm comm,
  char * comm_name,
  int * resultlen
) {
  return MPI_Comm_get_name(
    (MPI_Comm)(WPI_Comm)comm,
    comm_name,
    resultlen
  );
}

int MPIABI_Type_set_name(
  MPIABI_Datatype type,
  const char * type_name
) {
  return MPI_Type_set_name(
    (MPI_Datatype)(WPI_Datatype)type,
    type_name
  );
}

int MPIABI_Type_get_name(
  MPIABI_Datatype type,
  char * type_name,
  int * resultlen
) {
  return MPI_Type_get_name(
    (MPI_Datatype)(WPI_Datatype)type,
    type_name,
    resultlen
  );
}

int MPIABI_Win_set_name(
  MPIABI_Win win,
  const char * win_name
) {
  return MPI_Win_set_name(
    (MPI_Win)(WPI_Win)win,
    win_name
  );
}

int MPIABI_Win_get_name(
  MPIABI_Win win,
  char * win_name,
  int * resultlen
) {
  return MPI_Win_get_name(
    (MPI_Win)(WPI_Win)win,
    win_name,
    resultlen
  );
}

int MPIABI_Cart_create(
  MPIABI_Comm comm_old,
  int ndims,
  const int * dims,
  const int * periods,
  int reorder,
  MPIABI_Comm * comm_cart
) {
  return MPI_Cart_create(
    (MPI_Comm)(WPI_Comm)comm_old,
    ndims,
    dims,
    periods,
    reorder,
    (MPI_Comm *)(WPI_CommPtr)comm_cart
  );
}

int MPIABI_Dims_create(
  int nnodes,
  int ndims,
  int * dims
) {
  return MPI_Dims_create(
    nnodes,
    ndims,
    dims
  );
}

int MPIABI_Graph_create(
  MPIABI_Comm comm_old,
  int nnodes,
  const int * index,
  const int * edges,
  int reorder,
  MPIABI_Comm * comm_graph
) {
  return MPI_Graph_create(
    (MPI_Comm)(WPI_Comm)comm_old,
    nnodes,
    index,
    edges,
    reorder,
    (MPI_Comm *)(WPI_CommPtr)comm_graph
  );
}

int MPIABI_Dist_graph_create_adjacent(
  MPIABI_Comm comm_old,
  int indegree,
  const int * sources,
  const int * sourceweights,
  int outdegree,
  const int * destinations,
  const int * destweights,
  MPIABI_Info info,
  int reorder,
  MPIABI_Comm * comm_dist_graph
) {
  return MPI_Dist_graph_create_adjacent(
    (MPI_Comm)(WPI_Comm)comm_old,
    indegree,
    sources,
    sourceweights,
    outdegree,
    destinations,
    destweights,
    (MPI_Info)(WPI_Info)info,
    reorder,
    (MPI_Comm *)(WPI_CommPtr)comm_dist_graph
  );
}

int MPIABI_Dist_graph_create(
  MPIABI_Comm comm_old,
  int n,
  const int * sources,
  const int * degrees,
  const int * destinations,
  const int * weights,
  MPIABI_Info info,
  int reorder,
  MPIABI_Comm * comm_dist_graph
) {
  return MPI_Dist_graph_create(
    (MPI_Comm)(WPI_Comm)comm_old,
    n,
    sources,
    degrees,
    destinations,
    weights,
    (MPI_Info)(WPI_Info)info,
    reorder,
    (MPI_Comm *)(WPI_CommPtr)comm_dist_graph
  );
}

int MPIABI_Topo_test(
  MPIABI_Comm comm,
  int * status
) {
  return MPI_Topo_test(
    (MPI_Comm)(WPI_Comm)comm,
    status
  );
}

int MPIABI_Graphdims_get(
  MPIABI_Comm comm,
  int * nnodes,
  int * nedges
) {
  return MPI_Graphdims_get(
    (MPI_Comm)(WPI_Comm)comm,
    nnodes,
    nedges
  );
}

int MPIABI_Graph_get(
  MPIABI_Comm comm,
  int maxindex,
  int maxedges,
  int * index,
  int * edges
) {
  return MPI_Graph_get(
    (MPI_Comm)(WPI_Comm)comm,
    maxindex,
    maxedges,
    index,
    edges
  );
}

int MPIABI_Cartdim_get(
  MPIABI_Comm comm,
  int * ndims
) {
  return MPI_Cartdim_get(
    (MPI_Comm)(WPI_Comm)comm,
    ndims
  );
}

int MPIABI_Cart_get(
  MPIABI_Comm comm,
  int maxdims,
  int * dims,
  int * periods,
  int * coords
) {
  return MPI_Cart_get(
    (MPI_Comm)(WPI_Comm)comm,
    maxdims,
    dims,
    periods,
    coords
  );
}

int MPIABI_Cart_rank(
  MPIABI_Comm comm,
  const int * coords,
  int * rank
) {
  return MPI_Cart_rank(
    (MPI_Comm)(WPI_Comm)comm,
    coords,
    rank
  );
}

int MPIABI_Cart_coords(
  MPIABI_Comm comm,
  int rank,
  int maxdims,
  int * coords
) {
  return MPI_Cart_coords(
    (MPI_Comm)(WPI_Comm)comm,
    rank,
    maxdims,
    coords
  );
}

int MPIABI_Graph_neighbors_count(
  MPIABI_Comm comm,
  int rank,
  int * nneighbors
) {
  return MPI_Graph_neighbors_count(
    (MPI_Comm)(WPI_Comm)comm,
    rank,
    nneighbors
  );
}

int MPIABI_Graph_neighbors(
  MPIABI_Comm comm,
  int rank,
  int maxneighbors,
  int * neighbors
) {
  return MPI_Graph_neighbors(
    (MPI_Comm)(WPI_Comm)comm,
    rank,
    maxneighbors,
    neighbors
  );
}

int MPIABI_Dist_graph_neighbors_count(
  MPIABI_Comm comm,
  int * indegree,
  int * outdegree,
  int * weighted
) {
  return MPI_Dist_graph_neighbors_count(
    (MPI_Comm)(WPI_Comm)comm,
    indegree,
    outdegree,
    weighted
  );
}

int MPIABI_Dist_graph_neighbors(
  MPIABI_Comm comm,
  int maxindeegree,
  int * sources,
  int * wourceweights,
  int maxoutdegree,
  int * destinations,
  int * destweights
) {
  return MPI_Dist_graph_neighbors(
    (MPI_Comm)(WPI_Comm)comm,
    maxindeegree,
    sources,
    wourceweights,
    maxoutdegree,
    destinations,
    destweights
  );
}

int MPIABI_Cart_shift(
  MPIABI_Comm comm,
  int direction,
  int disp,
  int * rank_source,
  int * rank_dest
) {
  return MPI_Cart_shift(
    (MPI_Comm)(WPI_Comm)comm,
    direction,
    disp,
    rank_source,
    rank_dest
  );
}

int MPIABI_Cart_sub(
  MPIABI_Comm comm,
  const int * remain_dims,
  MPIABI_Comm * newcomm
) {
  return MPI_Cart_sub(
    (MPI_Comm)(WPI_Comm)comm,
    remain_dims,
    (MPI_Comm *)(WPI_CommPtr)newcomm
  );
}

int MPIABI_Cart_map(
  MPIABI_Comm comm,
  int ndims,
  const int * dims,
  const int * periods,
  int * newrank
) {
  return MPI_Cart_map(
    (MPI_Comm)(WPI_Comm)comm,
    ndims,
    dims,
    periods,
    newrank
  );
}

int MPIABI_Graph_map(
  MPIABI_Comm comm,
  int nnodes,
  const int * index,
  const int * edges,
  int * newrank
) {
  return MPI_Graph_map(
    (MPI_Comm)(WPI_Comm)comm,
    nnodes,
    index,
    edges,
    newrank
  );
}

int MPIABI_Neighbor_allgather(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) {
  return MPI_Neighbor_allgather(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Neighbor_allgatherv(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) {
  return MPI_Neighbor_allgatherv(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Neighbor_alltoall(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) {
  return MPI_Neighbor_alltoall(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)senddtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Neighbor_alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) {
  return MPI_Neighbor_alltoallv(
    sendbuf,
    sendcounts,
    sdispls,
    (MPI_Datatype)(WPI_Datatype)senddtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm
  );
}

int MPIABI_Ineighbor_allgather(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ineighbor_allgather(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Ineighbor_allgatherv(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ineighbor_allgatherv(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Ineighbor_alltoall(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ineighbor_alltoall(
    sendbuf,
    sendcount,
    (MPI_Datatype)(WPI_Datatype)senddtype,
    recvbuf,
    recvcount,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Ineighbor_alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) {
  return MPI_Ineighbor_alltoallv(
    sendbuf,
    sendcounts,
    sdispls,
    (MPI_Datatype)(WPI_Datatype)senddtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPI_Datatype)(WPI_Datatype)recvtype,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Get_version(
  int * version,
  int * subversion
) {
  return MPI_Get_version(
    version,
    subversion
  );
}

int MPIABI_Get_processor_name(
  char * name,
  int * resultlen
) {
  return MPI_Get_processor_name(
    name,
    resultlen
  );
}

int MPIABI_Alloc_mem(
  MPIABI_Aint size,
  MPIABI_Info info,
  void * baseptr
) {
  return MPI_Alloc_mem(
    (MPI_Aint)(WPI_Aint)size,
    (MPI_Info)(WPI_Info)info,
    baseptr
  );
}

int MPIABI_Free_mem(
  void * base
) {
  return MPI_Free_mem(
    base
  );
}

int MPIABI_Comm_create_errhandler(
  MPIABI_Comm_errhandler_function * comm_errhandler_fn,
  MPIABI_Errhandler * errhandler
) {
  return MPI_Comm_create_errhandler(
    (MPI_Comm_errhandler_function *)(WPI_Comm_errhandler_function *)comm_errhandler_fn,
    (MPI_Errhandler *)(WPI_ErrhandlerPtr)errhandler
  );
}

int MPIABI_Comm_set_errhandler(
  MPIABI_Comm comm,
  MPIABI_Errhandler errhandler
) {
  return MPI_Comm_set_errhandler(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Errhandler)(WPI_Errhandler)errhandler
  );
}

int MPIABI_Comm_get_errhandler(
  MPIABI_Comm comm,
  MPIABI_Errhandler * errhandler
) {
  return MPI_Comm_get_errhandler(
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Errhandler *)(WPI_ErrhandlerPtr)errhandler
  );
}

int MPIABI_Win_create_errhandler(
  MPIABI_Win_errhandler_function * win_errhandler_fn,
  MPIABI_Errhandler * errhandler
) {
  return MPI_Win_create_errhandler(
    (MPI_Win_errhandler_function *)(WPI_Win_errhandler_function *)win_errhandler_fn,
    (MPI_Errhandler *)(WPI_ErrhandlerPtr)errhandler
  );
}

int MPIABI_Win_set_errhandler(
  MPIABI_Win win,
  MPIABI_Errhandler errhandler
) {
  return MPI_Win_set_errhandler(
    (MPI_Win)(WPI_Win)win,
    (MPI_Errhandler)(WPI_Errhandler)errhandler
  );
}

int MPIABI_Win_get_errhandler(
  MPIABI_Win win,
  MPIABI_Errhandler * errhandler
) {
  return MPI_Win_get_errhandler(
    (MPI_Win)(WPI_Win)win,
    (MPI_Errhandler *)(WPI_ErrhandlerPtr)errhandler
  );
}

int MPIABI_File_create_errhandler(
  MPIABI_File_errhandler_function * file_errhandler_fn,
  MPIABI_Errhandler * errhandler
) {
  return MPI_File_create_errhandler(
    (MPI_File_errhandler_function *)(WPI_File_errhandler_function *)file_errhandler_fn,
    (MPI_Errhandler *)(WPI_ErrhandlerPtr)errhandler
  );
}

int MPIABI_File_set_errhandler(
  MPIABI_File file,
  MPIABI_Errhandler errhandler
) {
  return MPI_File_set_errhandler(
    (MPI_File)(WPI_File)file,
    (MPI_Errhandler)(WPI_Errhandler)errhandler
  );
}

int MPIABI_File_get_errhandler(
  MPIABI_File file,
  MPIABI_Errhandler * errhandler
) {
  return MPI_File_get_errhandler(
    (MPI_File)(WPI_File)file,
    (MPI_Errhandler *)(WPI_ErrhandlerPtr)errhandler
  );
}

int MPIABI_Errhandler_free(
  MPIABI_Errhandler * errhandler
) {
  return MPI_Errhandler_free(
    (MPI_Errhandler *)(WPI_ErrhandlerPtr)errhandler
  );
}

int MPIABI_Error_string(
  int errorcode,
  char * string,
  int * resultlen
) {
  return MPI_Error_string(
    errorcode,
    string,
    resultlen
  );
}

int MPIABI_Error_class(
  int errorcode,
  int * errorclass
) {
  return MPI_Error_class(
    errorcode,
    errorclass
  );
}

int MPIABI_Add_error_class(
  int * errorclass
) {
  return MPI_Add_error_class(
    errorclass
  );
}

int MPIABI_Add_error_code(
  int errorclass,
  int * errorcode
) {
  return MPI_Add_error_code(
    errorclass,
    errorcode
  );
}

int MPIABI_Add_error_string(
  int errorcode,
  const char * string
) {
  return MPI_Add_error_string(
    errorcode,
    string
  );
}

int MPIABI_Comm_call_errhandler(
  MPIABI_Comm comm,
  int errorcode
) {
  return MPI_Comm_call_errhandler(
    (MPI_Comm)(WPI_Comm)comm,
    errorcode
  );
}

int MPIABI_Win_call_errhandler(
  MPIABI_Win win,
  int errorcode
) {
  return MPI_Win_call_errhandler(
    (MPI_Win)(WPI_Win)win,
    errorcode
  );
}

int MPIABI_File_call_errhandler(
  MPIABI_File file,
  int errorcode
) {
  return MPI_File_call_errhandler(
    (MPI_File)(WPI_File)file,
    errorcode
  );
}

double MPIABI_Wtime(
) {
  return MPI_Wtime(
  );
}

double MPIABI_Wtick(
) {
  return MPI_Wtick(
  );
}

int MPIABI_Init(
  int * argc,
  char *** argv
) {
  return MPI_Init(
    argc,
    argv
  );
}

int MPIABI_Finalize(
) {
  return MPI_Finalize(
  );
}

int MPIABI_Initialized(
  int * flag
) {
  return MPI_Initialized(
    flag
  );
}

int MPIABI_Abort(
  MPIABI_Comm comm,
  int errorcode
) {
  return MPI_Abort(
    (MPI_Comm)(WPI_Comm)comm,
    errorcode
  );
}

int MPIABI_Finalized(
  int * flag
) {
  return MPI_Finalized(
    flag
  );
}

int MPIABI_Info_create(
  MPIABI_Info * info
) {
  return MPI_Info_create(
    (MPI_Info *)(WPI_InfoPtr)info
  );
}

int MPIABI_Info_set(
  MPIABI_Info info,
  const char * key,
  const char * value
) {
  return MPI_Info_set(
    (MPI_Info)(WPI_Info)info,
    key,
    value
  );
}

int MPIABI_Info_delete(
  MPIABI_Info info,
  const char * key
) {
  return MPI_Info_delete(
    (MPI_Info)(WPI_Info)info,
    key
  );
}

int MPIABI_Info_get(
  MPIABI_Info info,
  const char * key,
  int valuelen,
  char * value,
  int * flag
) {
  return MPI_Info_get(
    (MPI_Info)(WPI_Info)info,
    key,
    valuelen,
    value,
    flag
  );
}

int MPIABI_Info_get_valuelen(
  MPIABI_Info info,
  const char * key,
  int * valuelen,
  int * flag
) {
  return MPI_Info_get_valuelen(
    (MPI_Info)(WPI_Info)info,
    key,
    valuelen,
    flag
  );
}

int MPIABI_Info_get_nkeys(
  MPIABI_Info info,
  int * nkeys
) {
  return MPI_Info_get_nkeys(
    (MPI_Info)(WPI_Info)info,
    nkeys
  );
}

int MPIABI_Info_get_nthkey(
  MPIABI_Info info,
  int n,
  char * key
) {
  return MPI_Info_get_nthkey(
    (MPI_Info)(WPI_Info)info,
    n,
    key
  );
}

int MPIABI_Info_dup(
  MPIABI_Info info,
  MPIABI_Info * newinfo
) {
  return MPI_Info_dup(
    (MPI_Info)(WPI_Info)info,
    (MPI_Info *)(WPI_InfoPtr)newinfo
  );
}

int MPIABI_Info_free(
  MPIABI_Info * info
) {
  return MPI_Info_free(
    (MPI_Info *)(WPI_InfoPtr)info
  );
}

int MPIABI_Comm_spawn(
  const char * command,
  char ** argv,
  int maxprocs,
  MPIABI_Info info,
  int root,
  MPIABI_Comm comm,
  MPIABI_Comm * intercomm,
  int * array_off_errcodes
) {
  return MPI_Comm_spawn(
    command,
    argv,
    maxprocs,
    (MPI_Info)(WPI_Info)info,
    root,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Comm *)(WPI_CommPtr)intercomm,
    array_off_errcodes
  );
}

int MPIABI_Comm_get_parent(
  MPIABI_Comm * parent
) {
  return MPI_Comm_get_parent(
    (MPI_Comm *)(WPI_CommPtr)parent
  );
}

int MPIABI_Open_port(
  MPIABI_Info info,
  char * port_name
) {
  return MPI_Open_port(
    (MPI_Info)(WPI_Info)info,
    port_name
  );
}

int MPIABI_Close_port(
  const char * port_name
) {
  return MPI_Close_port(
    port_name
  );
}

int MPIABI_Comm_accept(
  const char * port_name,
  MPIABI_Info info,
  int root,
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm
) {
  return MPI_Comm_accept(
    port_name,
    (MPI_Info)(WPI_Info)info,
    root,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Comm *)(WPI_CommPtr)newcomm
  );
}

int MPIABI_Comm_connect(
  const char * port_name,
  MPIABI_Info info,
  int root,
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm
) {
  return MPI_Comm_connect(
    port_name,
    (MPI_Info)(WPI_Info)info,
    root,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Comm *)(WPI_CommPtr)newcomm
  );
}

int MPIABI_Publish_name(
  const char * service_name,
  MPIABI_Info info,
  const char * port_name
) {
  return MPI_Publish_name(
    service_name,
    (MPI_Info)(WPI_Info)info,
    port_name
  );
}

int MPIABI_Unpublish_name(
  const char * service_name,
  MPIABI_Info info,
  const char * port_name
) {
  return MPI_Unpublish_name(
    service_name,
    (MPI_Info)(WPI_Info)info,
    port_name
  );
}

int MPIABI_Lookup_name(
  const char * service_name,
  MPIABI_Info info,
  char * port_name
) {
  return MPI_Lookup_name(
    service_name,
    (MPI_Info)(WPI_Info)info,
    port_name
  );
}

int MPIABI_Comm_disconnect(
  MPIABI_Comm * comm
) {
  return MPI_Comm_disconnect(
    (MPI_Comm *)(WPI_CommPtr)comm
  );
}

int MPIABI_Comm_join(
  int fd,
  MPIABI_Comm * intercomm
) {
  return MPI_Comm_join(
    fd,
    (MPI_Comm *)(WPI_CommPtr)intercomm
  );
}

int MPIABI_Win_create(
  void * base,
  MPIABI_Aint size,
  int disp_unit,
  MPIABI_Info info,
  MPIABI_Comm comm,
  MPIABI_Win * win
) {
  return MPI_Win_create(
    base,
    (MPI_Aint)(WPI_Aint)size,
    disp_unit,
    (MPI_Info)(WPI_Info)info,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Win *)(WPI_WinPtr)win
  );
}

int MPIABI_Win_allocate(
  MPIABI_Aint size,
  int disp_unit,
  MPIABI_Info info,
  MPIABI_Comm comm,
  void * baseptr,
  MPIABI_Win * win
) {
  return MPI_Win_allocate(
    (MPI_Aint)(WPI_Aint)size,
    disp_unit,
    (MPI_Info)(WPI_Info)info,
    (MPI_Comm)(WPI_Comm)comm,
    baseptr,
    (MPI_Win *)(WPI_WinPtr)win
  );
}

int MPIABI_Win_allocate_shared(
  MPIABI_Aint size,
  int disp_unit,
  MPIABI_Info info,
  MPIABI_Comm comm,
  void * baseptr,
  MPIABI_Win * win
) {
  return MPI_Win_allocate_shared(
    (MPI_Aint)(WPI_Aint)size,
    disp_unit,
    (MPI_Info)(WPI_Info)info,
    (MPI_Comm)(WPI_Comm)comm,
    baseptr,
    (MPI_Win *)(WPI_WinPtr)win
  );
}

int MPIABI_Win_shared_query(
  MPIABI_Win win,
  int rank,
  MPIABI_Aint * size,
  int * disp_unit,
  void * baseptr
) {
  return MPI_Win_shared_query(
    (MPI_Win)(WPI_Win)win,
    rank,
    (MPI_Aint *)(WPI_Aint *)size,
    disp_unit,
    baseptr
  );
}

int MPIABI_Win_create_dynamic(
  MPIABI_Info info,
  MPIABI_Comm comm,
  MPIABI_Win * win
) {
  return MPI_Win_create_dynamic(
    (MPI_Info)(WPI_Info)info,
    (MPI_Comm)(WPI_Comm)comm,
    (MPI_Win *)(WPI_WinPtr)win
  );
}

int MPIABI_Win_attach(
  MPIABI_Win win,
  void * base,
  MPIABI_Aint size
) {
  return MPI_Win_attach(
    (MPI_Win)(WPI_Win)win,
    base,
    (MPI_Aint)(WPI_Aint)size
  );
}

int MPIABI_Win_detach(
  MPIABI_Win win,
  const void * base
) {
  return MPI_Win_detach(
    (MPI_Win)(WPI_Win)win,
    base
  );
}

int MPIABI_Win_free(
  MPIABI_Win * win
) {
  return MPI_Win_free(
    (MPI_Win *)(WPI_WinPtr)win
  );
}

int MPIABI_Win_get_group(
  MPIABI_Win win,
  MPIABI_Group * group
) {
  return MPI_Win_get_group(
    (MPI_Win)(WPI_Win)win,
    (MPI_Group *)(WPI_GroupPtr)group
  );
}

int MPIABI_Win_set_info(
  MPIABI_Win win,
  MPIABI_Info info
) {
  return MPI_Win_set_info(
    (MPI_Win)(WPI_Win)win,
    (MPI_Info)(WPI_Info)info
  );
}

int MPIABI_Win_get_info(
  MPIABI_Win win,
  MPIABI_Info * info_used
) {
  return MPI_Win_get_info(
    (MPI_Win)(WPI_Win)win,
    (MPI_Info *)(WPI_InfoPtr)info_used
  );
}

int MPIABI_Put(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win
) {
  return MPI_Put(
    origin_addr,
    origin_count,
    (MPI_Datatype)(WPI_Datatype)origin_datatype,
    target_rank,
    (MPI_Aint)(WPI_Aint)target_disp,
    target_count,
    (MPI_Datatype)(WPI_Datatype)target_datatype,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Get(
  void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win
) {
  return MPI_Get(
    origin_addr,
    origin_count,
    (MPI_Datatype)(WPI_Datatype)origin_datatype,
    target_rank,
    (MPI_Aint)(WPI_Aint)target_disp,
    target_count,
    (MPI_Datatype)(WPI_Datatype)target_datatype,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Accumulate(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win
) {
  return MPI_Accumulate(
    origin_addr,
    origin_count,
    (MPI_Datatype)(WPI_Datatype)origin_datatype,
    target_rank,
    (MPI_Aint)(WPI_Aint)target_disp,
    target_count,
    (MPI_Datatype)(WPI_Datatype)target_datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Get_accumulate(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPIABI_Datatype result_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win
) {
  return MPI_Get_accumulate(
    origin_addr,
    origin_count,
    (MPI_Datatype)(WPI_Datatype)origin_datatype,
    result_addr,
    result_count,
    (MPI_Datatype)(WPI_Datatype)result_datatype,
    target_rank,
    (MPI_Aint)(WPI_Aint)target_disp,
    target_count,
    (MPI_Datatype)(WPI_Datatype)target_datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Fetch_and_op(
  const void * origin_addr,
  void * result_addr,
  MPIABI_Datatype datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  MPIABI_Op op,
  MPIABI_Win win
) {
  return MPI_Fetch_and_op(
    origin_addr,
    result_addr,
    (MPI_Datatype)(WPI_Datatype)datatype,
    target_rank,
    (MPI_Aint)(WPI_Aint)target_disp,
    (MPI_Op)(WPI_Op)op,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Compare_and_swap(
  const void * origin_addr,
  const void * compare_addr,
  void * result_addr,
  MPIABI_Datatype datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  MPIABI_Win win
) {
  return MPI_Compare_and_swap(
    origin_addr,
    compare_addr,
    result_addr,
    (MPI_Datatype)(WPI_Datatype)datatype,
    target_rank,
    (MPI_Aint)(WPI_Aint)target_disp,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Rput(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win,
  MPIABI_Request * request
) {
  return MPI_Rput(
    origin_addr,
    origin_count,
    (MPI_Datatype)(WPI_Datatype)origin_datatype,
    target_rank,
    (MPI_Aint)(WPI_Aint)target_disp,
    target_count,
    (MPI_Datatype)(WPI_Datatype)target_datatype,
    (MPI_Win)(WPI_Win)win,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Rget(
  void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win,
  MPIABI_Request * request
) {
  return MPI_Rget(
    origin_addr,
    origin_count,
    (MPI_Datatype)(WPI_Datatype)origin_datatype,
    target_rank,
    (MPI_Aint)(WPI_Aint)target_disp,
    target_count,
    (MPI_Datatype)(WPI_Datatype)target_datatype,
    (MPI_Win)(WPI_Win)win,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Raccumulate(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win,
  MPIABI_Request * request
) {
  return MPI_Raccumulate(
    origin_addr,
    origin_count,
    (MPI_Datatype)(WPI_Datatype)origin_datatype,
    target_rank,
    (MPI_Aint)(WPI_Aint)target_disp,
    target_count,
    (MPI_Datatype)(WPI_Datatype)target_datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Win)(WPI_Win)win,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Rget_accumulate(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPIABI_Datatype result_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win,
  MPIABI_Request * request
) {
  return MPI_Rget_accumulate(
    origin_addr,
    origin_count,
    (MPI_Datatype)(WPI_Datatype)origin_datatype,
    result_addr,
    result_count,
    (MPI_Datatype)(WPI_Datatype)result_datatype,
    target_rank,
    (MPI_Aint)(WPI_Aint)target_disp,
    target_count,
    (MPI_Datatype)(WPI_Datatype)target_datatype,
    (MPI_Op)(WPI_Op)op,
    (MPI_Win)(WPI_Win)win,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_Win_fence(
  int assert,
  MPIABI_Win win
) {
  return MPI_Win_fence(
    assert,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_start(
  MPIABI_Group group,
  int assert,
  MPIABI_Win win
) {
  return MPI_Win_start(
    (MPI_Group)(WPI_Group)group,
    assert,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_complete(
  MPIABI_Win win
) {
  return MPI_Win_complete(
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_post(
  MPIABI_Group group,
  int assert,
  MPIABI_Win win
) {
  return MPI_Win_post(
    (MPI_Group)(WPI_Group)group,
    assert,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_wait(
  MPIABI_Win win
) {
  return MPI_Win_wait(
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_test(
  MPIABI_Win win,
  int * flag
) {
  return MPI_Win_test(
    (MPI_Win)(WPI_Win)win,
    flag
  );
}

int MPIABI_Win_lock(
  int lock_type,
  int rank,
  int assert,
  MPIABI_Win win
) {
  return MPI_Win_lock(
    lock_type,
    rank,
    assert,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_lock_all(
  int assert,
  MPIABI_Win win
) {
  return MPI_Win_lock_all(
    assert,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_unlock(
  int rank,
  MPIABI_Win win
) {
  return MPI_Win_unlock(
    rank,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_unlock_all(
  MPIABI_Win win
) {
  return MPI_Win_unlock_all(
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_flush(
  int rank,
  MPIABI_Win win
) {
  return MPI_Win_flush(
    rank,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_flush_all(
  MPIABI_Win win
) {
  return MPI_Win_flush_all(
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_flush_local(
  int rank,
  MPIABI_Win win
) {
  return MPI_Win_flush_local(
    rank,
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_flush_local_all(
  MPIABI_Win win
) {
  return MPI_Win_flush_local_all(
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Win_sync(
  MPIABI_Win win
) {
  return MPI_Win_sync(
    (MPI_Win)(WPI_Win)win
  );
}

int MPIABI_Grequest_complete(
  MPIABI_Request request
) {
  return MPI_Grequest_complete(
    (MPI_Request)(WPI_Request)request
  );
}

int MPIABI_Status_set_elements(
  MPIABI_Status * status,
  MPIABI_Datatype datatype,
  int count
) {
  return MPI_Status_set_elements(
    (MPI_Status *)(WPI_StatusPtr)status,
    (MPI_Datatype)(WPI_Datatype)datatype,
    count
  );
}

int MPIABI_Status_set_elements_x(
  MPIABI_Status * status,
  MPIABI_Datatype datatype,
  MPIABI_Count count
) {
  return MPI_Status_set_elements_x(
    (MPI_Status *)(WPI_StatusPtr)status,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Count)(WPI_Count)count
  );
}

int MPIABI_Status_set_cancelled(
  MPIABI_Status * status,
  int flag
) {
  return MPI_Status_set_cancelled(
    (MPI_Status *)(WPI_StatusPtr)status,
    flag
  );
}

int MPIABI_Init_thread(
  int * argc,
  char * * * argv,
  int required,
  int * provided
) {
  return MPI_Init_thread(
    argc,
    argv,
    required,
    provided
  );
}

int MPIABI_Query_thread(
  int * provided
) {
  return MPI_Query_thread(
    provided
  );
}

int MPIABI_Is_thread_main(
  int * flag
) {
  return MPI_Is_thread_main(
    flag
  );
}

int MPIABI_File_open(
  MPIABI_Comm comm,
  const char * filename,
  int amode,
  MPIABI_Info info,
  MPIABI_File * fh
) {
  return MPI_File_open(
    (MPI_Comm)(WPI_Comm)comm,
    filename,
    amode,
    (MPI_Info)(WPI_Info)info,
    (MPI_File *)(WPI_FilePtr)fh
  );
}

int MPIABI_File_close(
  MPIABI_File * fh
) {
  return MPI_File_close(
    (MPI_File *)(WPI_FilePtr)fh
  );
}

int MPIABI_File_delete(
  const char * filename,
  MPIABI_Info info
) {
  return MPI_File_delete(
    filename,
    (MPI_Info)(WPI_Info)info
  );
}

int MPIABI_File_set_size(
  MPIABI_File fh,
  MPIABI_Offset size
) {
  return MPI_File_set_size(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)size
  );
}

int MPIABI_File_preallocate(
  MPIABI_File fh,
  MPIABI_Offset size
) {
  return MPI_File_preallocate(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)size
  );
}

int MPIABI_File_get_size(
  MPIABI_File fh,
  MPIABI_Offset * size
) {
  return MPI_File_get_size(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset *)(WPI_Offset *)size
  );
}

int MPIABI_File_get_group(
  MPIABI_File fh,
  MPIABI_Group * group
) {
  return MPI_File_get_group(
    (MPI_File)(WPI_File)fh,
    (MPI_Group *)(WPI_GroupPtr)group
  );
}

int MPIABI_File_get_amode(
  MPIABI_File fh,
  int * amode
) {
  return MPI_File_get_amode(
    (MPI_File)(WPI_File)fh,
    amode
  );
}

int MPIABI_File_set_info(
  MPIABI_File fh,
  MPIABI_Info info
) {
  return MPI_File_set_info(
    (MPI_File)(WPI_File)fh,
    (MPI_Info)(WPI_Info)info
  );
}

int MPIABI_File_get_info(
  MPIABI_File fh,
  MPIABI_Info * info_used
) {
  return MPI_File_get_info(
    (MPI_File)(WPI_File)fh,
    (MPI_Info *)(WPI_InfoPtr)info_used
  );
}

int MPIABI_File_set_view(
  MPIABI_File fh,
  MPIABI_Offset disp,
  MPIABI_Datatype etype,
  MPIABI_Datatype filetype,
  const char * datarep,
  MPIABI_Info info
) {
  return MPI_File_set_view(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)disp,
    (MPI_Datatype)(WPI_Datatype)etype,
    (MPI_Datatype)(WPI_Datatype)filetype,
    datarep,
    (MPI_Info)(WPI_Info)info
  );
}

int MPIABI_File_get_view(
  MPIABI_File fh,
  MPIABI_Offset * disp,
  MPIABI_Datatype * etype,
  MPIABI_Datatype * filetype,
  char * datarep
) {
  return MPI_File_get_view(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset *)(WPI_Offset *)disp,
    (MPI_Datatype *)(WPI_DatatypePtr)etype,
    (MPI_Datatype *)(WPI_DatatypePtr)filetype,
    datarep
  );
}

int MPIABI_File_read_at(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_read_at(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_read_at_all(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_read_at_all(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_write_at(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_write_at(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_write_at_all(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_write_at_all(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_iread_at(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) {
  return MPI_File_iread_at(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_File_iread_at_all(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) {
  return MPI_File_iread_at_all(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_File_iwrite_at(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) {
  return MPI_File_iwrite_at(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_File_iwrite_at_all(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) {
  return MPI_File_iwrite_at_all(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_File_read(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_read(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_read_all(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_read_all(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_write(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_write(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_write_all(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_write_all(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_iread(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) {
  return MPI_File_iread(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_File_iread_all(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) {
  return MPI_File_iread_all(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_File_iwrite(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) {
  return MPI_File_iwrite(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_File_iwrite_all(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) {
  return MPI_File_iwrite_all(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_File_seek(
  MPIABI_File fh,
  MPIABI_Offset offset,
  int whence
) {
  return MPI_File_seek(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    whence
  );
}

int MPIABI_File_get_position(
  MPIABI_File fh,
  MPIABI_Offset * offset
) {
  return MPI_File_get_position(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset *)(WPI_Offset *)offset
  );
}

int MPIABI_File_get_byte_offset(
  MPIABI_File fh,
  MPIABI_Offset offset,
  MPIABI_Offset * disp
) {
  return MPI_File_get_byte_offset(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    (MPI_Offset *)(WPI_Offset *)disp
  );
}

int MPIABI_File_read_shared(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_read_shared(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_write_shared(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_write_shared(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_iread_shared(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) {
  return MPI_File_iread_shared(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_File_iwrite_shared(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) {
  return MPI_File_iwrite_shared(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Request *)(WPI_RequestPtr)request
  );
}

int MPIABI_File_read_ordered(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_read_ordered(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_write_ordered(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) {
  return MPI_File_write_ordered(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_seek_shared(
  MPIABI_File fh,
  MPIABI_Offset offset,
  int whence
) {
  return MPI_File_seek_shared(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    whence
  );
}

int MPIABI_File_get_position_shared(
  MPIABI_File fh,
  MPIABI_Offset * offset
) {
  return MPI_File_get_position_shared(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset *)(WPI_Offset *)offset
  );
}

int MPIABI_File_read_at_all_begin(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype
) {
  return MPI_File_read_at_all_begin(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype
  );
}

int MPIABI_File_read_at_all_end(
  MPIABI_File fh,
  void * buf,
  MPIABI_Status * status
) {
  return MPI_File_read_at_all_end(
    (MPI_File)(WPI_File)fh,
    buf,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_write_at_all_begin(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype
) {
  return MPI_File_write_at_all_begin(
    (MPI_File)(WPI_File)fh,
    (MPI_Offset)(WPI_Offset)offset,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype
  );
}

int MPIABI_File_write_at_all_end(
  MPIABI_File fh,
  const void * buf,
  MPIABI_Status * status
) {
  return MPI_File_write_at_all_end(
    (MPI_File)(WPI_File)fh,
    buf,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_read_all_begin(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype
) {
  return MPI_File_read_all_begin(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype
  );
}

int MPIABI_File_read_all_end(
  MPIABI_File fh,
  void * buf,
  MPIABI_Status * status
) {
  return MPI_File_read_all_end(
    (MPI_File)(WPI_File)fh,
    buf,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_write_all_begin(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype
) {
  return MPI_File_write_all_begin(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype
  );
}

int MPIABI_File_write_all_end(
  MPIABI_File fh,
  const void * buf,
  MPIABI_Status * status
) {
  return MPI_File_write_all_end(
    (MPI_File)(WPI_File)fh,
    buf,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_read_ordered_begin(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype
) {
  return MPI_File_read_ordered_begin(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype
  );
}

int MPIABI_File_read_ordered_end(
  MPIABI_File fh,
  void * buf,
  MPIABI_Status * status
) {
  return MPI_File_read_ordered_end(
    (MPI_File)(WPI_File)fh,
    buf,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_write_ordered_begin(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype
) {
  return MPI_File_write_ordered_begin(
    (MPI_File)(WPI_File)fh,
    buf,
    count,
    (MPI_Datatype)(WPI_Datatype)datatype
  );
}

int MPIABI_File_write_ordered_end(
  MPIABI_File fh,
  const void * buf,
  MPIABI_Status * status
) {
  return MPI_File_write_ordered_end(
    (MPI_File)(WPI_File)fh,
    buf,
    (MPI_Status *)(WPI_StatusPtr)status
  );
}

int MPIABI_File_get_type_extent(
  MPIABI_File fh,
  MPIABI_Datatype datatype,
  MPIABI_Aint * extent
) {
  return MPI_File_get_type_extent(
    (MPI_File)(WPI_File)fh,
    (MPI_Datatype)(WPI_Datatype)datatype,
    (MPI_Aint *)(WPI_Aint *)extent
  );
}

int MPIABI_File_set_atomicity(
  MPIABI_File fh,
  int flag
) {
  return MPI_File_set_atomicity(
    (MPI_File)(WPI_File)fh,
    flag
  );
}

int MPIABI_File_get_atomicity(
  MPIABI_File fh,
  int * flag
) {
  return MPI_File_get_atomicity(
    (MPI_File)(WPI_File)fh,
    flag
  );
}

int MPIABI_File_sync(
  MPIABI_File fh
) {
  return MPI_File_sync(
    (MPI_File)(WPI_File)fh
  );
}

int MPIABI_Type_create_f90_real(
  int precision,
  int range,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_create_f90_real(
    precision,
    range,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_create_f90_complex(
  int precision,
  int range,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_create_f90_complex(
    precision,
    range,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_create_f90_integer(
  int range,
  MPIABI_Datatype * newtype
) {
  return MPI_Type_create_f90_integer(
    range,
    (MPI_Datatype *)(WPI_DatatypePtr)newtype
  );
}

int MPIABI_Type_match_size(
  int typeclass,
  int size,
  MPIABI_Datatype * datatype
) {
  return MPI_Type_match_size(
    typeclass,
    size,
    (MPI_Datatype *)(WPI_DatatypePtr)datatype
  );
}

MPIABI_Comm MPIABI_Comm_f2c(
  MPIABI_Fint comm
) {
  return (MPIABI_Comm)(WPI_Comm)MPI_Comm_f2c(
    (MPI_Fint)(WPI_Fint)comm
  );
}

MPIABI_Fint MPIABI_Comm_c2f(
  MPIABI_Comm comm
) {
  return (MPIABI_Fint)(WPI_Fint)MPI_Comm_c2f(
    (MPI_Comm)(WPI_Comm)comm
  );
}

MPIABI_Datatype MPIABI_Type_f2c(
  MPIABI_Fint datatype
) {
  return (MPIABI_Datatype)(WPI_Datatype)MPI_Type_f2c(
    (MPI_Fint)(WPI_Fint)datatype
  );
}

MPIABI_Fint MPIABI_Type_c2f(
  MPIABI_Datatype datatype
) {
  return (MPIABI_Fint)(WPI_Fint)MPI_Type_c2f(
    (MPI_Datatype)(WPI_Datatype)datatype
  );
}

MPIABI_Group MPIABI_Group_f2c(
  MPIABI_Fint group
) {
  return (MPIABI_Group)(WPI_Group)MPI_Group_f2c(
    (MPI_Fint)(WPI_Fint)group
  );
}

MPIABI_Fint MPIABI_Group_c2f(
  MPIABI_Group group
) {
  return (MPIABI_Fint)(WPI_Fint)MPI_Group_c2f(
    (MPI_Group)(WPI_Group)group
  );
}

MPIABI_Request MPIABI_Request_f2c(
  MPIABI_Fint request
) {
  return (MPIABI_Request)(WPI_Request)MPI_Request_f2c(
    (MPI_Fint)(WPI_Fint)request
  );
}

MPIABI_Fint MPIABI_Request_c2f(
  MPIABI_Request request
) {
  return (MPIABI_Fint)(WPI_Fint)MPI_Request_c2f(
    (MPI_Request)(WPI_Request)request
  );
}

MPIABI_File MPIABI_File_f2c(
  MPIABI_Fint file
) {
  return (MPIABI_File)(WPI_File)MPI_File_f2c(
    (MPI_Fint)(WPI_Fint)file
  );
}

MPIABI_Fint MPIABI_File_c2f(
  MPIABI_File file
) {
  return (MPIABI_Fint)(WPI_Fint)MPI_File_c2f(
    (MPI_File)(WPI_File)file
  );
}

MPIABI_Win MPIABI_Win_f2c(
  MPIABI_Fint win
) {
  return (MPIABI_Win)(WPI_Win)MPI_Win_f2c(
    (MPI_Fint)(WPI_Fint)win
  );
}

MPIABI_Fint MPIABI_Win_c2f(
  MPIABI_Win win
) {
  return (MPIABI_Fint)(WPI_Fint)MPI_Win_c2f(
    (MPI_Win)(WPI_Win)win
  );
}

MPIABI_Op MPIABI_Op_f2c(
  MPIABI_Fint op
) {
  return (MPIABI_Op)(WPI_Op)MPI_Op_f2c(
    (MPI_Fint)(WPI_Fint)op
  );
}

MPIABI_Fint MPIABI_Op_c2f(
  MPIABI_Op op
) {
  return (MPIABI_Fint)(WPI_Fint)MPI_Op_c2f(
    (MPI_Op)(WPI_Op)op
  );
}

MPIABI_Info MPIABI_Info_f2c(
  MPIABI_Fint info
) {
  return (MPIABI_Info)(WPI_Info)MPI_Info_f2c(
    (MPI_Fint)(WPI_Fint)info
  );
}

MPIABI_Fint MPIABI_Info_c2f(
  MPIABI_Info info
) {
  return (MPIABI_Fint)(WPI_Fint)MPI_Info_c2f(
    (MPI_Info)(WPI_Info)info
  );
}

MPIABI_Errhandler MPIABI_Errhandler_f2c(
  MPIABI_Fint info
) {
  return (MPIABI_Errhandler)(WPI_Errhandler)MPI_Errhandler_f2c(
    (MPI_Fint)(WPI_Fint)info
  );
}

MPIABI_Fint MPIABI_Errhandler_c2f(
  MPIABI_Errhandler info
) {
  return (MPIABI_Fint)(WPI_Fint)MPI_Errhandler_c2f(
    (MPI_Errhandler)(WPI_Errhandler)info
  );
}

MPIABI_Message MPIABI_Message_f2c(
  MPIABI_Fint message
) {
  return (MPIABI_Message)(WPI_Message)MPI_Message_f2c(
    (MPI_Fint)(WPI_Fint)message
  );
}

MPIABI_Fint MPIABI_Message_c2f(
  MPIABI_Message message
) {
  return (MPIABI_Fint)(WPI_Fint)MPI_Message_c2f(
    (MPI_Message)(WPI_Message)message
  );
}

int MPIABI_Status_f2c(
  const MPIABI_Fint * f_status,
  MPIABI_Status * c_status
) {
  return MPI_Status_f2c(
    (const MPI_Fint *)(const WPI_Fint *)f_status,
    (MPI_Status *)(WPI_StatusPtr)c_status
  );
}

int MPIABI_Status_c2f(
  const MPIABI_Status * c_status,
  MPIABI_Fint * f_status
) {
  return MPI_Status_c2f(
    (const MPI_Status *)(WPI_const_StatusPtr)c_status,
    (MPI_Fint *)(WPI_Fint *)f_status
  );
}

