// Define C MPI functions


int (* MPIABI_Send)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
) = NULL;
int MPI_Send(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
) {
  return (*MPIABI_Send)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm
  );
}
int PMPI_Send(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
) {
  return (*MPIABI_Send)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Recv)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Status * status
) = NULL;
int MPI_Recv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Status * status
) {
  return (*MPIABI_Recv)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    source,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Status *)status
  );
}
int PMPI_Recv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Status * status
) {
  return (*MPIABI_Recv)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    source,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Get_count)(
  const MPIABI_Status * status,
  MPIABI_Datatype datatype,
  int * count
) = NULL;
int MPI_Get_count(
  const MPI_Status * status,
  MPI_Datatype datatype,
  int * count
) {
  return (*MPIABI_Get_count)(
    (const MPIABI_Status *)status,
    (MPIABI_Datatype)datatype,
    count
  );
}
int PMPI_Get_count(
  const MPI_Status * status,
  MPI_Datatype datatype,
  int * count
) {
  return (*MPIABI_Get_count)(
    (const MPIABI_Status *)status,
    (MPIABI_Datatype)datatype,
    count
  );
}

int (* MPIABI_Bsend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
) = NULL;
int MPI_Bsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
) {
  return (*MPIABI_Bsend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm
  );
}
int PMPI_Bsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
) {
  return (*MPIABI_Bsend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Ssend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
) = NULL;
int MPI_Ssend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
) {
  return (*MPIABI_Ssend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm
  );
}
int PMPI_Ssend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
) {
  return (*MPIABI_Ssend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Rsend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm
) = NULL;
int MPI_Rsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
) {
  return (*MPIABI_Rsend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm
  );
}
int PMPI_Rsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm
) {
  return (*MPIABI_Rsend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Buffer_attach)(
  void * buffer,
  int size
) = NULL;
int MPI_Buffer_attach(
  void * buffer,
  int size
) {
  return (*MPIABI_Buffer_attach)(
    buffer,
    size
  );
}
int PMPI_Buffer_attach(
  void * buffer,
  int size
) {
  return (*MPIABI_Buffer_attach)(
    buffer,
    size
  );
}

int (* MPIABI_Buffer_detach)(
  void * buffer_addr,
  int * size
) = NULL;
int MPI_Buffer_detach(
  void * buffer_addr,
  int * size
) {
  return (*MPIABI_Buffer_detach)(
    buffer_addr,
    size
  );
}
int PMPI_Buffer_detach(
  void * buffer_addr,
  int * size
) {
  return (*MPIABI_Buffer_detach)(
    buffer_addr,
    size
  );
}

int (* MPIABI_Isend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Isend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Isend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Isend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Isend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ibsend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ibsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ibsend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ibsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ibsend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Issend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Issend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Issend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Issend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Issend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Irsend)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Irsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Irsend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Irsend(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Irsend)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Irecv)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Irecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Irecv)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    source,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Irecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Irecv)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    source,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Wait)(
  MPIABI_Request * request,
  MPIABI_Status * status
) = NULL;
int MPI_Wait(
  MPI_Request * request,
  MPI_Status * status
) {
  return (*MPIABI_Wait)(
    (MPIABI_Request *)request,
    (MPIABI_Status *)status
  );
}
int PMPI_Wait(
  MPI_Request * request,
  MPI_Status * status
) {
  return (*MPIABI_Wait)(
    (MPIABI_Request *)request,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Test)(
  MPIABI_Request * request,
  int * flag,
  MPIABI_Status * status
) = NULL;
int MPI_Test(
  MPI_Request * request,
  int * flag,
  MPI_Status * status
) {
  return (*MPIABI_Test)(
    (MPIABI_Request *)request,
    flag,
    (MPIABI_Status *)status
  );
}
int PMPI_Test(
  MPI_Request * request,
  int * flag,
  MPI_Status * status
) {
  return (*MPIABI_Test)(
    (MPIABI_Request *)request,
    flag,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Request_free)(
  MPIABI_Request * request
) = NULL;
int MPI_Request_free(
  MPI_Request * request
) {
  return (*MPIABI_Request_free)(
    (MPIABI_Request *)request
  );
}
int PMPI_Request_free(
  MPI_Request * request
) {
  return (*MPIABI_Request_free)(
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Waitany)(
  int count,
  MPIABI_Request * array_of_requests,
  int * index,
  MPIABI_Status * status
) = NULL;
int MPI_Waitany(
  int count,
  MPI_Request * array_of_requests,
  int * index,
  MPI_Status * status
) {
  return (*MPIABI_Waitany)(
    count,
    (MPIABI_Request *)array_of_requests,
    index,
    (MPIABI_Status *)status
  );
}
int PMPI_Waitany(
  int count,
  MPI_Request * array_of_requests,
  int * index,
  MPI_Status * status
) {
  return (*MPIABI_Waitany)(
    count,
    (MPIABI_Request *)array_of_requests,
    index,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Testany)(
  int count,
  MPIABI_Request * array_of_requests,
  int * index,
  int * flag,
  MPIABI_Status * status
) = NULL;
int MPI_Testany(
  int count,
  MPI_Request * array_of_requests,
  int * index,
  int * flag,
  MPI_Status * status
) {
  return (*MPIABI_Testany)(
    count,
    (MPIABI_Request *)array_of_requests,
    index,
    flag,
    (MPIABI_Status *)status
  );
}
int PMPI_Testany(
  int count,
  MPI_Request * array_of_requests,
  int * index,
  int * flag,
  MPI_Status * status
) {
  return (*MPIABI_Testany)(
    count,
    (MPIABI_Request *)array_of_requests,
    index,
    flag,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Waitall)(
  int count,
  MPIABI_Request * array_of_requests,
  MPIABI_Status * array_of_statuses
) = NULL;
int MPI_Waitall(
  int count,
  MPI_Request * array_of_requests,
  MPI_Status * array_of_statuses
) {
  return (*MPIABI_Waitall)(
    count,
    (MPIABI_Request *)array_of_requests,
    (MPIABI_Status *)array_of_statuses
  );
}
int PMPI_Waitall(
  int count,
  MPI_Request * array_of_requests,
  MPI_Status * array_of_statuses
) {
  return (*MPIABI_Waitall)(
    count,
    (MPIABI_Request *)array_of_requests,
    (MPIABI_Status *)array_of_statuses
  );
}

int (* MPIABI_Testall)(
  int count,
  MPIABI_Request * array_of_requests,
  int * flag,
  MPIABI_Status * array_of_statuses
) = NULL;
int MPI_Testall(
  int count,
  MPI_Request * array_of_requests,
  int * flag,
  MPI_Status * array_of_statuses
) {
  return (*MPIABI_Testall)(
    count,
    (MPIABI_Request *)array_of_requests,
    flag,
    (MPIABI_Status *)array_of_statuses
  );
}
int PMPI_Testall(
  int count,
  MPI_Request * array_of_requests,
  int * flag,
  MPI_Status * array_of_statuses
) {
  return (*MPIABI_Testall)(
    count,
    (MPIABI_Request *)array_of_requests,
    flag,
    (MPIABI_Status *)array_of_statuses
  );
}

int (* MPIABI_Waitsome)(
  int incount,
  MPIABI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPIABI_Status * array_of_statuses
) = NULL;
int MPI_Waitsome(
  int incount,
  MPI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPI_Status * array_of_statuses
) {
  return (*MPIABI_Waitsome)(
    incount,
    (MPIABI_Request *)array_of_requests,
    outcount,
    array_of_indices,
    (MPIABI_Status *)array_of_statuses
  );
}
int PMPI_Waitsome(
  int incount,
  MPI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPI_Status * array_of_statuses
) {
  return (*MPIABI_Waitsome)(
    incount,
    (MPIABI_Request *)array_of_requests,
    outcount,
    array_of_indices,
    (MPIABI_Status *)array_of_statuses
  );
}

int (* MPIABI_Testsome)(
  int incount,
  MPIABI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPIABI_Status * array_of_statuses
) = NULL;
int MPI_Testsome(
  int incount,
  MPI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPI_Status * array_of_statuses
) {
  return (*MPIABI_Testsome)(
    incount,
    (MPIABI_Request *)array_of_requests,
    outcount,
    array_of_indices,
    (MPIABI_Status *)array_of_statuses
  );
}
int PMPI_Testsome(
  int incount,
  MPI_Request * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPI_Status * array_of_statuses
) {
  return (*MPIABI_Testsome)(
    incount,
    (MPIABI_Request *)array_of_requests,
    outcount,
    array_of_indices,
    (MPIABI_Status *)array_of_statuses
  );
}

int (* MPIABI_Request_get_status)(
  MPIABI_Request request,
  int * flag,
  MPIABI_Status * status
) = NULL;
int MPI_Request_get_status(
  MPI_Request request,
  int * flag,
  MPI_Status * status
) {
  return (*MPIABI_Request_get_status)(
    (MPIABI_Request)request,
    flag,
    (MPIABI_Status *)status
  );
}
int PMPI_Request_get_status(
  MPI_Request request,
  int * flag,
  MPI_Status * status
) {
  return (*MPIABI_Request_get_status)(
    (MPIABI_Request)request,
    flag,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Iprobe)(
  int source,
  int tag,
  MPIABI_Comm comm,
  int * flag,
  MPIABI_Status * status
) = NULL;
int MPI_Iprobe(
  int source,
  int tag,
  MPI_Comm comm,
  int * flag,
  MPI_Status * status
) {
  return (*MPIABI_Iprobe)(
    source,
    tag,
    (MPIABI_Comm)comm,
    flag,
    (MPIABI_Status *)status
  );
}
int PMPI_Iprobe(
  int source,
  int tag,
  MPI_Comm comm,
  int * flag,
  MPI_Status * status
) {
  return (*MPIABI_Iprobe)(
    source,
    tag,
    (MPIABI_Comm)comm,
    flag,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Probe)(
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Status * status
) = NULL;
int MPI_Probe(
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Status * status
) {
  return (*MPIABI_Probe)(
    source,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Status *)status
  );
}
int PMPI_Probe(
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Status * status
) {
  return (*MPIABI_Probe)(
    source,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Improbe)(
  int source,
  int tag,
  MPIABI_Comm comm,
  int * flag,
  MPIABI_Message * message,
  MPIABI_Status * status
) = NULL;
int MPI_Improbe(
  int source,
  int tag,
  MPI_Comm comm,
  int * flag,
  MPI_Message * message,
  MPI_Status * status
) {
  return (*MPIABI_Improbe)(
    source,
    tag,
    (MPIABI_Comm)comm,
    flag,
    (MPIABI_Message *)message,
    (MPIABI_Status *)status
  );
}
int PMPI_Improbe(
  int source,
  int tag,
  MPI_Comm comm,
  int * flag,
  MPI_Message * message,
  MPI_Status * status
) {
  return (*MPIABI_Improbe)(
    source,
    tag,
    (MPIABI_Comm)comm,
    flag,
    (MPIABI_Message *)message,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Mprobe)(
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Message * message,
  MPIABI_Status * status
) = NULL;
int MPI_Mprobe(
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Message * message,
  MPI_Status * status
) {
  return (*MPIABI_Mprobe)(
    source,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Message *)message,
    (MPIABI_Status *)status
  );
}
int PMPI_Mprobe(
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Message * message,
  MPI_Status * status
) {
  return (*MPIABI_Mprobe)(
    source,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Message *)message,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Mrecv)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Message * message,
  MPIABI_Status * status
) = NULL;
int MPI_Mrecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Message * message,
  MPI_Status * status
) {
  return (*MPIABI_Mrecv)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Message *)message,
    (MPIABI_Status *)status
  );
}
int PMPI_Mrecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Message * message,
  MPI_Status * status
) {
  return (*MPIABI_Mrecv)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Message *)message,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Imrecv)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Message * message,
  MPIABI_Request * request
) = NULL;
int MPI_Imrecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Message * message,
  MPI_Request * request
) {
  return (*MPIABI_Imrecv)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Message *)message,
    (MPIABI_Request *)request
  );
}
int PMPI_Imrecv(
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Message * message,
  MPI_Request * request
) {
  return (*MPIABI_Imrecv)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Message *)message,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Cancel)(
  MPIABI_Request * request
) = NULL;
int MPI_Cancel(
  MPI_Request * request
) {
  return (*MPIABI_Cancel)(
    (MPIABI_Request *)request
  );
}
int PMPI_Cancel(
  MPI_Request * request
) {
  return (*MPIABI_Cancel)(
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Test_cancelled)(
  const MPIABI_Status * status,
  int * flag
) = NULL;
int MPI_Test_cancelled(
  const MPI_Status * status,
  int * flag
) {
  return (*MPIABI_Test_cancelled)(
    (const MPIABI_Status *)status,
    flag
  );
}
int PMPI_Test_cancelled(
  const MPI_Status * status,
  int * flag
) {
  return (*MPIABI_Test_cancelled)(
    (const MPIABI_Status *)status,
    flag
  );
}

int (* MPIABI_Send_init)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Send_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Send_init)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Send_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Send_init)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Bsend_init)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Bsend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Bsend_init)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Bsend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Bsend_init)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ssend_init)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ssend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ssend_init)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ssend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ssend_init)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Rsend_init)(
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Rsend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Rsend_init)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Rsend_init(
  const void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Rsend_init)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Recv_init)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int source,
  int tag,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Recv_init(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Recv_init)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    source,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Recv_init(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int source,
  int tag,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Recv_init)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    source,
    tag,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Start)(
  MPIABI_Request * request
) = NULL;
int MPI_Start(
  MPI_Request * request
) {
  return (*MPIABI_Start)(
    (MPIABI_Request *)request
  );
}
int PMPI_Start(
  MPI_Request * request
) {
  return (*MPIABI_Start)(
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Startall)(
  int count,
  MPIABI_Request * array_of_requests
) = NULL;
int MPI_Startall(
  int count,
  MPI_Request * array_of_requests
) {
  return (*MPIABI_Startall)(
    count,
    (MPIABI_Request *)array_of_requests
  );
}
int PMPI_Startall(
  int count,
  MPI_Request * array_of_requests
) {
  return (*MPIABI_Startall)(
    count,
    (MPIABI_Request *)array_of_requests
  );
}

int (* MPIABI_Sendrecv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  int dest,
  int sendtag,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int source,
  int recvtag,
  MPIABI_Comm comm,
  MPIABI_Status * status
) = NULL;
int MPI_Sendrecv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  int dest,
  int sendtag,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int source,
  int recvtag,
  MPI_Comm comm,
  MPI_Status * status
) {
  return (*MPIABI_Sendrecv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    dest,
    sendtag,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    source,
    recvtag,
    (MPIABI_Comm)comm,
    (MPIABI_Status *)status
  );
}
int PMPI_Sendrecv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  int dest,
  int sendtag,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int source,
  int recvtag,
  MPI_Comm comm,
  MPI_Status * status
) {
  return (*MPIABI_Sendrecv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    dest,
    sendtag,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    source,
    recvtag,
    (MPIABI_Comm)comm,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Sendrecv_replace)(
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  int dest,
  int sendtag,
  int source,
  int recvtag,
  MPIABI_Comm comm,
  MPIABI_Status * status
) = NULL;
int MPI_Sendrecv_replace(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int sendtag,
  int source,
  int recvtag,
  MPI_Comm comm,
  MPI_Status * status
) {
  return (*MPIABI_Sendrecv_replace)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    sendtag,
    source,
    recvtag,
    (MPIABI_Comm)comm,
    (MPIABI_Status *)status
  );
}
int PMPI_Sendrecv_replace(
  void * buf,
  int count,
  MPI_Datatype datatype,
  int dest,
  int sendtag,
  int source,
  int recvtag,
  MPI_Comm comm,
  MPI_Status * status
) {
  return (*MPIABI_Sendrecv_replace)(
    buf,
    count,
    (MPIABI_Datatype)datatype,
    dest,
    sendtag,
    source,
    recvtag,
    (MPIABI_Comm)comm,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_Type_contiguous)(
  int count,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_contiguous(
  int count,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_contiguous)(
    count,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_contiguous(
  int count,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_contiguous)(
    count,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_vector)(
  int count,
  int blocklength,
  int stride,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_vector(
  int count,
  int blocklength,
  int stride,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_vector)(
    count,
    blocklength,
    stride,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_vector(
  int count,
  int blocklength,
  int stride,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_vector)(
    count,
    blocklength,
    stride,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_create_hvector)(
  int count,
  int blocklength,
  MPIABI_Aint stride,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_create_hvector(
  int count,
  int blocklength,
  MPI_Aint stride,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_hvector)(
    count,
    blocklength,
    (MPIABI_Aint)stride,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_create_hvector(
  int count,
  int blocklength,
  MPI_Aint stride,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_hvector)(
    count,
    blocklength,
    (MPIABI_Aint)stride,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_indexed)(
  int count,
  const int * array_of_blocklengths,
  const int * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_indexed(
  int count,
  const int * array_of_blocklengths,
  const int * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_indexed)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_indexed(
  int count,
  const int * array_of_blocklengths,
  const int * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_indexed)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_create_hindexed)(
  int count,
  const int * array_of_blocklengths,
  const MPIABI_Aint * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_create_hindexed(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_hindexed)(
    count,
    array_of_blocklengths,
    (const MPIABI_Aint *)array_of_displacements,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_create_hindexed(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_hindexed)(
    count,
    array_of_blocklengths,
    (const MPIABI_Aint *)array_of_displacements,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_create_indexed_block)(
  int count,
  int blocklength,
  const int * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_create_indexed_block(
  int count,
  int blocklength,
  const int * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_indexed_block)(
    count,
    blocklength,
    array_of_displacements,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_create_indexed_block(
  int count,
  int blocklength,
  const int * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_indexed_block)(
    count,
    blocklength,
    array_of_displacements,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_create_hindexed_block)(
  int count,
  int blocklength,
  const MPIABI_Aint * array_of_displacements,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_create_hindexed_block(
  int count,
  int blocklength,
  const MPI_Aint * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_hindexed_block)(
    count,
    blocklength,
    (const MPIABI_Aint *)array_of_displacements,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_create_hindexed_block(
  int count,
  int blocklength,
  const MPI_Aint * array_of_displacements,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_hindexed_block)(
    count,
    blocklength,
    (const MPIABI_Aint *)array_of_displacements,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_create_struct)(
  int count,
  const int * array_of_blocklengths,
  const MPIABI_Aint * array_of_displacements,
  const MPIABI_Datatype * array_of_types,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_create_struct(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  const MPI_Datatype * array_of_types,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_struct)(
    count,
    array_of_blocklengths,
    (const MPIABI_Aint *)array_of_displacements,
    (const MPIABI_Datatype *)array_of_types,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_create_struct(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  const MPI_Datatype * array_of_types,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_struct)(
    count,
    array_of_blocklengths,
    (const MPIABI_Aint *)array_of_displacements,
    (const MPIABI_Datatype *)array_of_types,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_struct)(
  int count,
  const int * array_of_blocklengths,
  const MPIABI_Aint * array_of_displacements,
  const MPIABI_Datatype * array_of_types,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_struct(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  const MPI_Datatype * array_of_types,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_struct)(
    count,
    array_of_blocklengths,
    (const MPIABI_Aint *)array_of_displacements,
    (const MPIABI_Datatype *)array_of_types,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_struct(
  int count,
  const int * array_of_blocklengths,
  const MPI_Aint * array_of_displacements,
  const MPI_Datatype * array_of_types,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_struct)(
    count,
    array_of_blocklengths,
    (const MPIABI_Aint *)array_of_displacements,
    (const MPIABI_Datatype *)array_of_types,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_create_subarray)(
  int ndims,
  const int * array_of_sizes,
  const int * array_of_subsizes,
  const int * array_of_starts,
  int ordder,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_create_subarray(
  int ndims,
  const int * array_of_sizes,
  const int * array_of_subsizes,
  const int * array_of_starts,
  int ordder,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_subarray)(
    ndims,
    array_of_sizes,
    array_of_subsizes,
    array_of_starts,
    ordder,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_create_subarray(
  int ndims,
  const int * array_of_sizes,
  const int * array_of_subsizes,
  const int * array_of_starts,
  int ordder,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_subarray)(
    ndims,
    array_of_sizes,
    array_of_subsizes,
    array_of_starts,
    ordder,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_create_darray)(
  int size,
  int rank,
  int ndims,
  const int * array_of_gsizes,
  const int * array_of_distribs,
  const int * array_of_dargs,
  const int * array_of_psizes,
  int order,
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_create_darray(
  int size,
  int rank,
  int ndims,
  const int * array_of_gsizes,
  const int * array_of_distribs,
  const int * array_of_dargs,
  const int * array_of_psizes,
  int order,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_darray)(
    size,
    rank,
    ndims,
    array_of_gsizes,
    array_of_distribs,
    array_of_dargs,
    array_of_psizes,
    order,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_create_darray(
  int size,
  int rank,
  int ndims,
  const int * array_of_gsizes,
  const int * array_of_distribs,
  const int * array_of_dargs,
  const int * array_of_psizes,
  int order,
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_darray)(
    size,
    rank,
    ndims,
    array_of_gsizes,
    array_of_distribs,
    array_of_dargs,
    array_of_psizes,
    order,
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Get_address)(
  const void * location,
  MPIABI_Aint * address
) = NULL;
int MPI_Get_address(
  const void * location,
  MPI_Aint * address
) {
  return (*MPIABI_Get_address)(
    location,
    (MPIABI_Aint *)address
  );
}
int PMPI_Get_address(
  const void * location,
  MPI_Aint * address
) {
  return (*MPIABI_Get_address)(
    location,
    (MPIABI_Aint *)address
  );
}

MPIABI_Aint (* MPIABI_Aint_add)(
  MPIABI_Aint base,
  MPIABI_Aint disp
) = NULL;
MPI_Aint MPI_Aint_add(
  MPI_Aint base,
  MPI_Aint disp
) {
  return (MPI_Aint)(*MPIABI_Aint_add)(
    (MPIABI_Aint)base,
    (MPIABI_Aint)disp
  );
}
MPI_Aint PMPI_Aint_add(
  MPI_Aint base,
  MPI_Aint disp
) {
  return (MPI_Aint)(*MPIABI_Aint_add)(
    (MPIABI_Aint)base,
    (MPIABI_Aint)disp
  );
}

MPIABI_Aint (* MPIABI_Aint_diff)(
  MPIABI_Aint addr1,
  MPIABI_Aint addr2
) = NULL;
MPI_Aint MPI_Aint_diff(
  MPI_Aint addr1,
  MPI_Aint addr2
) {
  return (MPI_Aint)(*MPIABI_Aint_diff)(
    (MPIABI_Aint)addr1,
    (MPIABI_Aint)addr2
  );
}
MPI_Aint PMPI_Aint_diff(
  MPI_Aint addr1,
  MPI_Aint addr2
) {
  return (MPI_Aint)(*MPIABI_Aint_diff)(
    (MPIABI_Aint)addr1,
    (MPIABI_Aint)addr2
  );
}

int (* MPIABI_Type_size)(
  MPIABI_Datatype datatype,
  int * size
) = NULL;
int MPI_Type_size(
  MPI_Datatype datatype,
  int * size
) {
  return (*MPIABI_Type_size)(
    (MPIABI_Datatype)datatype,
    size
  );
}
int PMPI_Type_size(
  MPI_Datatype datatype,
  int * size
) {
  return (*MPIABI_Type_size)(
    (MPIABI_Datatype)datatype,
    size
  );
}

int (* MPIABI_Type_size_x)(
  MPIABI_Datatype datatype,
  MPIABI_Count * size
) = NULL;
int MPI_Type_size_x(
  MPI_Datatype datatype,
  MPI_Count * size
) {
  return (*MPIABI_Type_size_x)(
    (MPIABI_Datatype)datatype,
    (MPIABI_Count *)size
  );
}
int PMPI_Type_size_x(
  MPI_Datatype datatype,
  MPI_Count * size
) {
  return (*MPIABI_Type_size_x)(
    (MPIABI_Datatype)datatype,
    (MPIABI_Count *)size
  );
}

int (* MPIABI_Type_get_extent)(
  MPIABI_Datatype datatype,
  MPIABI_Aint * lb,
  MPIABI_Aint * extent
) = NULL;
int MPI_Type_get_extent(
  MPI_Datatype datatype,
  MPI_Aint * lb,
  MPI_Aint * extent
) {
  return (*MPIABI_Type_get_extent)(
    (MPIABI_Datatype)datatype,
    (MPIABI_Aint *)lb,
    (MPIABI_Aint *)extent
  );
}
int PMPI_Type_get_extent(
  MPI_Datatype datatype,
  MPI_Aint * lb,
  MPI_Aint * extent
) {
  return (*MPIABI_Type_get_extent)(
    (MPIABI_Datatype)datatype,
    (MPIABI_Aint *)lb,
    (MPIABI_Aint *)extent
  );
}

int (* MPIABI_Type_get_extent_x)(
  MPIABI_Datatype datatype,
  MPIABI_Count * lb,
  MPIABI_Count * extent
) = NULL;
int MPI_Type_get_extent_x(
  MPI_Datatype datatype,
  MPI_Count * lb,
  MPI_Count * extent
) {
  return (*MPIABI_Type_get_extent_x)(
    (MPIABI_Datatype)datatype,
    (MPIABI_Count *)lb,
    (MPIABI_Count *)extent
  );
}
int PMPI_Type_get_extent_x(
  MPI_Datatype datatype,
  MPI_Count * lb,
  MPI_Count * extent
) {
  return (*MPIABI_Type_get_extent_x)(
    (MPIABI_Datatype)datatype,
    (MPIABI_Count *)lb,
    (MPIABI_Count *)extent
  );
}

int (* MPIABI_Type_create_resized)(
  MPIABI_Datatype oldtype,
  MPIABI_Aint lb,
  MPIABI_Aint extent,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_create_resized(
  MPI_Datatype oldtype,
  MPI_Aint lb,
  MPI_Aint extent,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_resized)(
    (MPIABI_Datatype)oldtype,
    (MPIABI_Aint)lb,
    (MPIABI_Aint)extent,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_create_resized(
  MPI_Datatype oldtype,
  MPI_Aint lb,
  MPI_Aint extent,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_resized)(
    (MPIABI_Datatype)oldtype,
    (MPIABI_Aint)lb,
    (MPIABI_Aint)extent,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_get_true_extent)(
  MPIABI_Datatype datatype,
  MPIABI_Aint * true_lb,
  MPIABI_Aint * true_extent
) = NULL;
int MPI_Type_get_true_extent(
  MPI_Datatype datatype,
  MPI_Aint * true_lb,
  MPI_Aint * true_extent
) {
  return (*MPIABI_Type_get_true_extent)(
    (MPIABI_Datatype)datatype,
    (MPIABI_Aint *)true_lb,
    (MPIABI_Aint *)true_extent
  );
}
int PMPI_Type_get_true_extent(
  MPI_Datatype datatype,
  MPI_Aint * true_lb,
  MPI_Aint * true_extent
) {
  return (*MPIABI_Type_get_true_extent)(
    (MPIABI_Datatype)datatype,
    (MPIABI_Aint *)true_lb,
    (MPIABI_Aint *)true_extent
  );
}

int (* MPIABI_Type_get_true_extent_x)(
  MPIABI_Datatype datatype,
  MPIABI_Count * true_lb,
  MPIABI_Count * true_extent
) = NULL;
int MPI_Type_get_true_extent_x(
  MPI_Datatype datatype,
  MPI_Count * true_lb,
  MPI_Count * true_extent
) {
  return (*MPIABI_Type_get_true_extent_x)(
    (MPIABI_Datatype)datatype,
    (MPIABI_Count *)true_lb,
    (MPIABI_Count *)true_extent
  );
}
int PMPI_Type_get_true_extent_x(
  MPI_Datatype datatype,
  MPI_Count * true_lb,
  MPI_Count * true_extent
) {
  return (*MPIABI_Type_get_true_extent_x)(
    (MPIABI_Datatype)datatype,
    (MPIABI_Count *)true_lb,
    (MPIABI_Count *)true_extent
  );
}

int (* MPIABI_Type_commit)(
  MPIABI_Datatype * datatype
) = NULL;
int MPI_Type_commit(
  MPI_Datatype * datatype
) {
  return (*MPIABI_Type_commit)(
    (MPIABI_Datatype *)datatype
  );
}
int PMPI_Type_commit(
  MPI_Datatype * datatype
) {
  return (*MPIABI_Type_commit)(
    (MPIABI_Datatype *)datatype
  );
}

int (* MPIABI_Type_free)(
  MPIABI_Datatype * datatype
) = NULL;
int MPI_Type_free(
  MPI_Datatype * datatype
) {
  return (*MPIABI_Type_free)(
    (MPIABI_Datatype *)datatype
  );
}
int PMPI_Type_free(
  MPI_Datatype * datatype
) {
  return (*MPIABI_Type_free)(
    (MPIABI_Datatype *)datatype
  );
}

int (* MPIABI_Type_dup)(
  MPIABI_Datatype oldtype,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_dup(
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_dup)(
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_dup(
  MPI_Datatype oldtype,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_dup)(
    (MPIABI_Datatype)oldtype,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Get_elements)(
  const MPIABI_Status * status,
  MPIABI_Datatype datatype,
  int * count
) = NULL;
int MPI_Get_elements(
  const MPI_Status * status,
  MPI_Datatype datatype,
  int * count
) {
  return (*MPIABI_Get_elements)(
    (const MPIABI_Status *)status,
    (MPIABI_Datatype)datatype,
    count
  );
}
int PMPI_Get_elements(
  const MPI_Status * status,
  MPI_Datatype datatype,
  int * count
) {
  return (*MPIABI_Get_elements)(
    (const MPIABI_Status *)status,
    (MPIABI_Datatype)datatype,
    count
  );
}

int (* MPIABI_Get_elements_x)(
  const MPIABI_Status * status,
  MPIABI_Datatype datatype,
  MPIABI_Count * count
) = NULL;
int MPI_Get_elements_x(
  const MPI_Status * status,
  MPI_Datatype datatype,
  MPI_Count * count
) {
  return (*MPIABI_Get_elements_x)(
    (const MPIABI_Status *)status,
    (MPIABI_Datatype)datatype,
    (MPIABI_Count *)count
  );
}
int PMPI_Get_elements_x(
  const MPI_Status * status,
  MPI_Datatype datatype,
  MPI_Count * count
) {
  return (*MPIABI_Get_elements_x)(
    (const MPIABI_Status *)status,
    (MPIABI_Datatype)datatype,
    (MPIABI_Count *)count
  );
}

int (* MPIABI_Type_get_envelope)(
  MPIABI_Datatype datatype,
  int * num_integers,
  int * num_addresses,
  int * num_datatypes,
  int * combiner
) = NULL;
int MPI_Type_get_envelope(
  MPI_Datatype datatype,
  int * num_integers,
  int * num_addresses,
  int * num_datatypes,
  int * combiner
) {
  return (*MPIABI_Type_get_envelope)(
    (MPIABI_Datatype)datatype,
    num_integers,
    num_addresses,
    num_datatypes,
    combiner
  );
}
int PMPI_Type_get_envelope(
  MPI_Datatype datatype,
  int * num_integers,
  int * num_addresses,
  int * num_datatypes,
  int * combiner
) {
  return (*MPIABI_Type_get_envelope)(
    (MPIABI_Datatype)datatype,
    num_integers,
    num_addresses,
    num_datatypes,
    combiner
  );
}

int (* MPIABI_Type_get_contents)(
  MPIABI_Datatype datatype,
  int max_integers,
  int max_addresses,
  int max_datatypes,
  int * array_of_integers,
  MPIABI_Aint * array_of_addresses,
  MPIABI_Datatype * array_of_datatypes
) = NULL;
int MPI_Type_get_contents(
  MPI_Datatype datatype,
  int max_integers,
  int max_addresses,
  int max_datatypes,
  int * array_of_integers,
  MPI_Aint * array_of_addresses,
  MPI_Datatype * array_of_datatypes
) {
  return (*MPIABI_Type_get_contents)(
    (MPIABI_Datatype)datatype,
    max_integers,
    max_addresses,
    max_datatypes,
    array_of_integers,
    (MPIABI_Aint *)array_of_addresses,
    (MPIABI_Datatype *)array_of_datatypes
  );
}
int PMPI_Type_get_contents(
  MPI_Datatype datatype,
  int max_integers,
  int max_addresses,
  int max_datatypes,
  int * array_of_integers,
  MPI_Aint * array_of_addresses,
  MPI_Datatype * array_of_datatypes
) {
  return (*MPIABI_Type_get_contents)(
    (MPIABI_Datatype)datatype,
    max_integers,
    max_addresses,
    max_datatypes,
    array_of_integers,
    (MPIABI_Aint *)array_of_addresses,
    (MPIABI_Datatype *)array_of_datatypes
  );
}

int (* MPIABI_Pack)(
  const void * inbuf,
  int incount,
  MPIABI_Datatype datatype,
  void * outbuf,
  int outsize,
  int * position,
  MPIABI_Comm comm
) = NULL;
int MPI_Pack(
  const void * inbuf,
  int incount,
  MPI_Datatype datatype,
  void * outbuf,
  int outsize,
  int * position,
  MPI_Comm comm
) {
  return (*MPIABI_Pack)(
    inbuf,
    incount,
    (MPIABI_Datatype)datatype,
    outbuf,
    outsize,
    position,
    (MPIABI_Comm)comm
  );
}
int PMPI_Pack(
  const void * inbuf,
  int incount,
  MPI_Datatype datatype,
  void * outbuf,
  int outsize,
  int * position,
  MPI_Comm comm
) {
  return (*MPIABI_Pack)(
    inbuf,
    incount,
    (MPIABI_Datatype)datatype,
    outbuf,
    outsize,
    position,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Unpack)(
  const void * inbuf,
  int insize,
  int * position,
  void * outbuf,
  int outcount,
  MPIABI_Datatype datatype,
  MPIABI_Comm comm
) = NULL;
int MPI_Unpack(
  const void * inbuf,
  int insize,
  int * position,
  void * outbuf,
  int outcount,
  MPI_Datatype datatype,
  MPI_Comm comm
) {
  return (*MPIABI_Unpack)(
    inbuf,
    insize,
    position,
    outbuf,
    outcount,
    (MPIABI_Datatype)datatype,
    (MPIABI_Comm)comm
  );
}
int PMPI_Unpack(
  const void * inbuf,
  int insize,
  int * position,
  void * outbuf,
  int outcount,
  MPI_Datatype datatype,
  MPI_Comm comm
) {
  return (*MPIABI_Unpack)(
    inbuf,
    insize,
    position,
    outbuf,
    outcount,
    (MPIABI_Datatype)datatype,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Pack_size)(
  int incount,
  MPIABI_Datatype datatype,
  MPIABI_Comm comm,
  int * size
) = NULL;
int MPI_Pack_size(
  int incount,
  MPI_Datatype datatype,
  MPI_Comm comm,
  int * size
) {
  return (*MPIABI_Pack_size)(
    incount,
    (MPIABI_Datatype)datatype,
    (MPIABI_Comm)comm,
    size
  );
}
int PMPI_Pack_size(
  int incount,
  MPI_Datatype datatype,
  MPI_Comm comm,
  int * size
) {
  return (*MPIABI_Pack_size)(
    incount,
    (MPIABI_Datatype)datatype,
    (MPIABI_Comm)comm,
    size
  );
}

int (* MPIABI_Pack_external)(
  const char * datarep,
  const void * inbuf,
  int incount,
  MPIABI_Datatype datatype,
  void * outbuf,
  MPIABI_Aint outsize,
  MPIABI_Aint * position
) = NULL;
int MPI_Pack_external(
  const char * datarep,
  const void * inbuf,
  int incount,
  MPI_Datatype datatype,
  void * outbuf,
  MPI_Aint outsize,
  MPI_Aint * position
) {
  return (*MPIABI_Pack_external)(
    datarep,
    inbuf,
    incount,
    (MPIABI_Datatype)datatype,
    outbuf,
    (MPIABI_Aint)outsize,
    (MPIABI_Aint *)position
  );
}
int PMPI_Pack_external(
  const char * datarep,
  const void * inbuf,
  int incount,
  MPI_Datatype datatype,
  void * outbuf,
  MPI_Aint outsize,
  MPI_Aint * position
) {
  return (*MPIABI_Pack_external)(
    datarep,
    inbuf,
    incount,
    (MPIABI_Datatype)datatype,
    outbuf,
    (MPIABI_Aint)outsize,
    (MPIABI_Aint *)position
  );
}

int (* MPIABI_Unpack_external)(
  const char * datarep,
  const void * inbuf,
  MPIABI_Aint insize,
  MPIABI_Aint * position,
  void * outbuf,
  int outcount,
  MPIABI_Datatype datatype
) = NULL;
int MPI_Unpack_external(
  const char * datarep,
  const void * inbuf,
  MPI_Aint insize,
  MPI_Aint * position,
  void * outbuf,
  int outcount,
  MPI_Datatype datatype
) {
  return (*MPIABI_Unpack_external)(
    datarep,
    inbuf,
    (MPIABI_Aint)insize,
    (MPIABI_Aint *)position,
    outbuf,
    outcount,
    (MPIABI_Datatype)datatype
  );
}
int PMPI_Unpack_external(
  const char * datarep,
  const void * inbuf,
  MPI_Aint insize,
  MPI_Aint * position,
  void * outbuf,
  int outcount,
  MPI_Datatype datatype
) {
  return (*MPIABI_Unpack_external)(
    datarep,
    inbuf,
    (MPIABI_Aint)insize,
    (MPIABI_Aint *)position,
    outbuf,
    outcount,
    (MPIABI_Datatype)datatype
  );
}

int (* MPIABI_Pack_external_size)(
  const char * datarep,
  int incount,
  MPIABI_Datatype datatype,
  MPIABI_Aint * size
) = NULL;
int MPI_Pack_external_size(
  const char * datarep,
  int incount,
  MPI_Datatype datatype,
  MPI_Aint * size
) {
  return (*MPIABI_Pack_external_size)(
    datarep,
    incount,
    (MPIABI_Datatype)datatype,
    (MPIABI_Aint *)size
  );
}
int PMPI_Pack_external_size(
  const char * datarep,
  int incount,
  MPI_Datatype datatype,
  MPI_Aint * size
) {
  return (*MPIABI_Pack_external_size)(
    datarep,
    incount,
    (MPIABI_Datatype)datatype,
    (MPIABI_Aint *)size
  );
}

int (* MPIABI_Barrier)(
  MPIABI_Comm comm
) = NULL;
int MPI_Barrier(
  MPI_Comm comm
) {
  return (*MPIABI_Barrier)(
    (MPIABI_Comm)comm
  );
}
int PMPI_Barrier(
  MPI_Comm comm
) {
  return (*MPIABI_Barrier)(
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Bcast)(
  void * buffer,
  int count,
  MPIABI_Datatype datatype,
  int root,
  MPIABI_Comm comm
) = NULL;
int MPI_Bcast(
  void * buffer,
  int count,
  MPI_Datatype datatype,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Bcast)(
    buffer,
    count,
    (MPIABI_Datatype)datatype,
    root,
    (MPIABI_Comm)comm
  );
}
int PMPI_Bcast(
  void * buffer,
  int count,
  MPI_Datatype datatype,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Bcast)(
    buffer,
    count,
    (MPIABI_Datatype)datatype,
    root,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Gather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
) = NULL;
int MPI_Gather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Gather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm
  );
}
int PMPI_Gather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Gather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Gatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
) = NULL;
int MPI_Gatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Gatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm
  );
}
int PMPI_Gatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Gatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Scatter)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
) = NULL;
int MPI_Scatter(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Scatter)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm
  );
}
int PMPI_Scatter(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Scatter)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Scatterv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm
) = NULL;
int MPI_Scatterv(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Scatterv)(
    sendbuf,
    sendcounts,
    displs,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm
  );
}
int PMPI_Scatterv(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Scatterv)(
    sendbuf,
    sendcounts,
    displs,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Allgather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) = NULL;
int MPI_Allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Allgather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}
int PMPI_Allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Allgather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Allgatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) = NULL;
int MPI_Allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Allgatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}
int PMPI_Allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Allgatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Alltoall)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) = NULL;
int MPI_Alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Alltoall)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}
int PMPI_Alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Alltoall)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Alltoallv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) = NULL;
int MPI_Alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Alltoallv)(
    sendbuf,
    sendcounts,
    sdispls,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}
int PMPI_Alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Alltoallv)(
    sendbuf,
    sendcounts,
    sdispls,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Alltoallw)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Datatype * recvtypes,
  MPIABI_Comm comm
) = NULL;
int MPI_Alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm
) {
  return (*MPIABI_Alltoallw)(
    sendbuf,
    sendcounts,
    sdispls,
    (const MPIABI_Datatype *)sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    (const MPIABI_Datatype *)recvtypes,
    (MPIABI_Comm)comm
  );
}
int PMPI_Alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm
) {
  return (*MPIABI_Alltoallw)(
    sendbuf,
    sendcounts,
    sdispls,
    (const MPIABI_Datatype *)sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    (const MPIABI_Datatype *)recvtypes,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Reduce)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  int root,
  MPIABI_Comm comm
) = NULL;
int MPI_Reduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Reduce)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    root,
    (MPIABI_Comm)comm
  );
}
int PMPI_Reduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  int root,
  MPI_Comm comm
) {
  return (*MPIABI_Reduce)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    root,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Op_create)(
  MPIABI_User_function * user_fn,
  int commute,
  MPIABI_Op * op
) = NULL;
int MPI_Op_create(
  MPI_User_function * user_fn,
  int commute,
  MPI_Op * op
) {
  return (*MPIABI_Op_create)(
    (MPIABI_User_function *)user_fn,
    commute,
    (MPIABI_Op *)op
  );
}
int PMPI_Op_create(
  MPI_User_function * user_fn,
  int commute,
  MPI_Op * op
) {
  return (*MPIABI_Op_create)(
    (MPIABI_User_function *)user_fn,
    commute,
    (MPIABI_Op *)op
  );
}

int (* MPIABI_Op_free)(
  MPIABI_Op * op
) = NULL;
int MPI_Op_free(
  MPI_Op * op
) {
  return (*MPIABI_Op_free)(
    (MPIABI_Op *)op
  );
}
int PMPI_Op_free(
  MPI_Op * op
) {
  return (*MPIABI_Op_free)(
    (MPIABI_Op *)op
  );
}

int (* MPIABI_Allreduce)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
) = NULL;
int MPI_Allreduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
) {
  return (*MPIABI_Allreduce)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm
  );
}
int PMPI_Allreduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
) {
  return (*MPIABI_Allreduce)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Op_commutative)(
  MPIABI_Op op,
  int * commute
) = NULL;
int MPI_Op_commutative(
  MPI_Op op,
  int * commute
) {
  return (*MPIABI_Op_commutative)(
    (MPIABI_Op)op,
    commute
  );
}
int PMPI_Op_commutative(
  MPI_Op op,
  int * commute
) {
  return (*MPIABI_Op_commutative)(
    (MPIABI_Op)op,
    commute
  );
}

int (* MPIABI_Reduce_local)(
  const void * inbuf,
  void * inoutbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op
) = NULL;
int MPI_Reduce_local(
  const void * inbuf,
  void * inoutbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op
) {
  return (*MPIABI_Reduce_local)(
    inbuf,
    inoutbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op
  );
}
int PMPI_Reduce_local(
  const void * inbuf,
  void * inoutbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op
) {
  return (*MPIABI_Reduce_local)(
    inbuf,
    inoutbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op
  );
}

int (* MPIABI_Reduce_scatter_block)(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
) = NULL;
int MPI_Reduce_scatter_block(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
) {
  return (*MPIABI_Reduce_scatter_block)(
    sendbuf,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm
  );
}
int PMPI_Reduce_scatter_block(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
) {
  return (*MPIABI_Reduce_scatter_block)(
    sendbuf,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Reduce_scatter)(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
) = NULL;
int MPI_Reduce_scatter(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
) {
  return (*MPIABI_Reduce_scatter)(
    sendbuf,
    recvbuf,
    recvcounts,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm
  );
}
int PMPI_Reduce_scatter(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
) {
  return (*MPIABI_Reduce_scatter)(
    sendbuf,
    recvbuf,
    recvcounts,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Scan)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
) = NULL;
int MPI_Scan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
) {
  return (*MPIABI_Scan)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm
  );
}
int PMPI_Scan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
) {
  return (*MPIABI_Scan)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Exscan)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm
) = NULL;
int MPI_Exscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
) {
  return (*MPIABI_Exscan)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm
  );
}
int PMPI_Exscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm
) {
  return (*MPIABI_Exscan)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Ibarrier)(
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ibarrier(
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ibarrier)(
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ibarrier(
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ibarrier)(
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ibcast)(
  void * buffer,
  int count,
  MPIABI_Datatype datatype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ibcast(
  void * buffer,
  int count,
  MPI_Datatype datatype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ibcast)(
    buffer,
    count,
    (MPIABI_Datatype)datatype,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ibcast(
  void * buffer,
  int count,
  MPI_Datatype datatype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ibcast)(
    buffer,
    count,
    (MPIABI_Datatype)datatype,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Igather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Igather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Igather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Igather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Igather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Igatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Igatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Igatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Igatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Igatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Iscatter)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Iscatter(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iscatter)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Iscatter(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iscatter)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Iscatterv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Iscatterv(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iscatterv)(
    sendbuf,
    sendcounts,
    displs,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Iscatterv(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iscatterv)(
    sendbuf,
    sendcounts,
    displs,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Iallgather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Iallgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iallgather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Iallgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iallgather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Iallgatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Iallgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iallgatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Iallgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iallgatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ialltoall)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ialltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ialltoall)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ialltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ialltoall)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ialltoallv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ialltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ialltoallv)(
    sendbuf,
    sendcounts,
    sdispls,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ialltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ialltoallv)(
    sendbuf,
    sendcounts,
    sdispls,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ialltoallw)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Datatype * recvtypes,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ialltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ialltoallw)(
    sendbuf,
    sendcounts,
    sdispls,
    (const MPIABI_Datatype *)sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    (const MPIABI_Datatype *)recvtypes,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ialltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ialltoallw)(
    sendbuf,
    sendcounts,
    sdispls,
    (const MPIABI_Datatype *)sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    (const MPIABI_Datatype *)recvtypes,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ireduce)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  int root,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ireduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ireduce)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ireduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  int root,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ireduce)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Iallreduce)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Iallreduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iallreduce)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Iallreduce(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iallreduce)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ireduce_scatter_block)(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ireduce_scatter_block(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ireduce_scatter_block)(
    sendbuf,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ireduce_scatter_block(
  const void * sendbuf,
  void * recvbuf,
  int recvcount,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ireduce_scatter_block)(
    sendbuf,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ireduce_scatter)(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ireduce_scatter(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ireduce_scatter)(
    sendbuf,
    recvbuf,
    recvcounts,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ireduce_scatter(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ireduce_scatter)(
    sendbuf,
    recvbuf,
    recvcounts,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Iscan)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Iscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iscan)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Iscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iscan)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Iexscan)(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Op op,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Iexscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iexscan)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Iexscan(
  const void * sendbuf,
  void * recvbuf,
  int count,
  MPI_Datatype datatype,
  MPI_Op op,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Iexscan)(
    sendbuf,
    recvbuf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Op)op,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Group_size)(
  MPIABI_Group group,
  int * size
) = NULL;
int MPI_Group_size(
  MPI_Group group,
  int * size
) {
  return (*MPIABI_Group_size)(
    (MPIABI_Group)group,
    size
  );
}
int PMPI_Group_size(
  MPI_Group group,
  int * size
) {
  return (*MPIABI_Group_size)(
    (MPIABI_Group)group,
    size
  );
}

int (* MPIABI_Group_rank)(
  MPIABI_Group group,
  int * rank
) = NULL;
int MPI_Group_rank(
  MPI_Group group,
  int * rank
) {
  return (*MPIABI_Group_rank)(
    (MPIABI_Group)group,
    rank
  );
}
int PMPI_Group_rank(
  MPI_Group group,
  int * rank
) {
  return (*MPIABI_Group_rank)(
    (MPIABI_Group)group,
    rank
  );
}

int (* MPIABI_Group_translate_ranks)(
  MPIABI_Group group1,
  int n,
  const int * ranks1,
  MPIABI_Group group2,
  int * ranks2
) = NULL;
int MPI_Group_translate_ranks(
  MPI_Group group1,
  int n,
  const int * ranks1,
  MPI_Group group2,
  int * ranks2
) {
  return (*MPIABI_Group_translate_ranks)(
    (MPIABI_Group)group1,
    n,
    ranks1,
    (MPIABI_Group)group2,
    ranks2
  );
}
int PMPI_Group_translate_ranks(
  MPI_Group group1,
  int n,
  const int * ranks1,
  MPI_Group group2,
  int * ranks2
) {
  return (*MPIABI_Group_translate_ranks)(
    (MPIABI_Group)group1,
    n,
    ranks1,
    (MPIABI_Group)group2,
    ranks2
  );
}

int (* MPIABI_Group_compare)(
  MPIABI_Group group1,
  MPIABI_Group group2,
  int * result
) = NULL;
int MPI_Group_compare(
  MPI_Group group1,
  MPI_Group group2,
  int * result
) {
  return (*MPIABI_Group_compare)(
    (MPIABI_Group)group1,
    (MPIABI_Group)group2,
    result
  );
}
int PMPI_Group_compare(
  MPI_Group group1,
  MPI_Group group2,
  int * result
) {
  return (*MPIABI_Group_compare)(
    (MPIABI_Group)group1,
    (MPIABI_Group)group2,
    result
  );
}

int (* MPIABI_Comm_group)(
  MPIABI_Comm comm,
  MPIABI_Group * group
) = NULL;
int MPI_Comm_group(
  MPI_Comm comm,
  MPI_Group * group
) {
  return (*MPIABI_Comm_group)(
    (MPIABI_Comm)comm,
    (MPIABI_Group *)group
  );
}
int PMPI_Comm_group(
  MPI_Comm comm,
  MPI_Group * group
) {
  return (*MPIABI_Comm_group)(
    (MPIABI_Comm)comm,
    (MPIABI_Group *)group
  );
}

int (* MPIABI_Group_union)(
  MPIABI_Group group1,
  MPIABI_Group group2,
  MPIABI_Group * newgroup
) = NULL;
int MPI_Group_union(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_union)(
    (MPIABI_Group)group1,
    (MPIABI_Group)group2,
    (MPIABI_Group *)newgroup
  );
}
int PMPI_Group_union(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_union)(
    (MPIABI_Group)group1,
    (MPIABI_Group)group2,
    (MPIABI_Group *)newgroup
  );
}

int (* MPIABI_Group_intersection)(
  MPIABI_Group group1,
  MPIABI_Group group2,
  MPIABI_Group * newgroup
) = NULL;
int MPI_Group_intersection(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_intersection)(
    (MPIABI_Group)group1,
    (MPIABI_Group)group2,
    (MPIABI_Group *)newgroup
  );
}
int PMPI_Group_intersection(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_intersection)(
    (MPIABI_Group)group1,
    (MPIABI_Group)group2,
    (MPIABI_Group *)newgroup
  );
}

int (* MPIABI_Group_difference)(
  MPIABI_Group group1,
  MPIABI_Group group2,
  MPIABI_Group * newgroup
) = NULL;
int MPI_Group_difference(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_difference)(
    (MPIABI_Group)group1,
    (MPIABI_Group)group2,
    (MPIABI_Group *)newgroup
  );
}
int PMPI_Group_difference(
  MPI_Group group1,
  MPI_Group group2,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_difference)(
    (MPIABI_Group)group1,
    (MPIABI_Group)group2,
    (MPIABI_Group *)newgroup
  );
}

int (* MPIABI_Group_incl)(
  MPIABI_Group group,
  int n,
  const int * ranks,
  MPIABI_Group * newgroup
) = NULL;
int MPI_Group_incl(
  MPI_Group group,
  int n,
  const int * ranks,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_incl)(
    (MPIABI_Group)group,
    n,
    ranks,
    (MPIABI_Group *)newgroup
  );
}
int PMPI_Group_incl(
  MPI_Group group,
  int n,
  const int * ranks,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_incl)(
    (MPIABI_Group)group,
    n,
    ranks,
    (MPIABI_Group *)newgroup
  );
}

int (* MPIABI_Group_excl)(
  MPIABI_Group group,
  int n,
  const int * ranks,
  MPIABI_Group * newgroup
) = NULL;
int MPI_Group_excl(
  MPI_Group group,
  int n,
  const int * ranks,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_excl)(
    (MPIABI_Group)group,
    n,
    ranks,
    (MPIABI_Group *)newgroup
  );
}
int PMPI_Group_excl(
  MPI_Group group,
  int n,
  const int * ranks,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_excl)(
    (MPIABI_Group)group,
    n,
    ranks,
    (MPIABI_Group *)newgroup
  );
}

int (* MPIABI_Group_range_incl)(
  MPIABI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPIABI_Group * newgroup
) = NULL;
int MPI_Group_range_incl(
  MPI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_range_incl)(
    (MPIABI_Group)group,
    n,
    ranges,
    (MPIABI_Group *)newgroup
  );
}
int PMPI_Group_range_incl(
  MPI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_range_incl)(
    (MPIABI_Group)group,
    n,
    ranges,
    (MPIABI_Group *)newgroup
  );
}

int (* MPIABI_Group_range_excl)(
  MPIABI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPIABI_Group * newgroup
) = NULL;
int MPI_Group_range_excl(
  MPI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_range_excl)(
    (MPIABI_Group)group,
    n,
    ranges,
    (MPIABI_Group *)newgroup
  );
}
int PMPI_Group_range_excl(
  MPI_Group group,
  int n,
  MPIABI_array_int_3 * ranges,
  MPI_Group * newgroup
) {
  return (*MPIABI_Group_range_excl)(
    (MPIABI_Group)group,
    n,
    ranges,
    (MPIABI_Group *)newgroup
  );
}

int (* MPIABI_Group_free)(
  MPIABI_Group * group
) = NULL;
int MPI_Group_free(
  MPI_Group * group
) {
  return (*MPIABI_Group_free)(
    (MPIABI_Group *)group
  );
}
int PMPI_Group_free(
  MPI_Group * group
) {
  return (*MPIABI_Group_free)(
    (MPIABI_Group *)group
  );
}

int (* MPIABI_Comm_size)(
  MPIABI_Comm comm,
  int * size
) = NULL;
int MPI_Comm_size(
  MPI_Comm comm,
  int * size
) {
  return (*MPIABI_Comm_size)(
    (MPIABI_Comm)comm,
    size
  );
}
int PMPI_Comm_size(
  MPI_Comm comm,
  int * size
) {
  return (*MPIABI_Comm_size)(
    (MPIABI_Comm)comm,
    size
  );
}

int (* MPIABI_Comm_rank)(
  MPIABI_Comm comm,
  int * rank
) = NULL;
int MPI_Comm_rank(
  MPI_Comm comm,
  int * rank
) {
  return (*MPIABI_Comm_rank)(
    (MPIABI_Comm)comm,
    rank
  );
}
int PMPI_Comm_rank(
  MPI_Comm comm,
  int * rank
) {
  return (*MPIABI_Comm_rank)(
    (MPIABI_Comm)comm,
    rank
  );
}

int (* MPIABI_Comm_compare)(
  MPIABI_Comm comm1,
  MPIABI_Comm comm2,
  int * result
) = NULL;
int MPI_Comm_compare(
  MPI_Comm comm1,
  MPI_Comm comm2,
  int * result
) {
  return (*MPIABI_Comm_compare)(
    (MPIABI_Comm)comm1,
    (MPIABI_Comm)comm2,
    result
  );
}
int PMPI_Comm_compare(
  MPI_Comm comm1,
  MPI_Comm comm2,
  int * result
) {
  return (*MPIABI_Comm_compare)(
    (MPIABI_Comm)comm1,
    (MPIABI_Comm)comm2,
    result
  );
}

int (* MPIABI_Comm_dup)(
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm
) = NULL;
int MPI_Comm_dup(
  MPI_Comm comm,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_dup)(
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)newcomm
  );
}
int PMPI_Comm_dup(
  MPI_Comm comm,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_dup)(
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)newcomm
  );
}

int (* MPIABI_Comm_dup_with_info)(
  MPIABI_Comm comm,
  MPIABI_Info info,
  MPIABI_Comm * newcomm
) = NULL;
int MPI_Comm_dup_with_info(
  MPI_Comm comm,
  MPI_Info info,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_dup_with_info)(
    (MPIABI_Comm)comm,
    (MPIABI_Info)info,
    (MPIABI_Comm *)newcomm
  );
}
int PMPI_Comm_dup_with_info(
  MPI_Comm comm,
  MPI_Info info,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_dup_with_info)(
    (MPIABI_Comm)comm,
    (MPIABI_Info)info,
    (MPIABI_Comm *)newcomm
  );
}

int (* MPIABI_Comm_idup)(
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm,
  MPIABI_Request * request
) = NULL;
int MPI_Comm_idup(
  MPI_Comm comm,
  MPI_Comm * newcomm,
  MPI_Request * request
) {
  return (*MPIABI_Comm_idup)(
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)newcomm,
    (MPIABI_Request *)request
  );
}
int PMPI_Comm_idup(
  MPI_Comm comm,
  MPI_Comm * newcomm,
  MPI_Request * request
) {
  return (*MPIABI_Comm_idup)(
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)newcomm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Comm_create)(
  MPIABI_Comm comm,
  MPIABI_Group group,
  MPIABI_Comm * newcomm
) = NULL;
int MPI_Comm_create(
  MPI_Comm comm,
  MPI_Group group,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_create)(
    (MPIABI_Comm)comm,
    (MPIABI_Group)group,
    (MPIABI_Comm *)newcomm
  );
}
int PMPI_Comm_create(
  MPI_Comm comm,
  MPI_Group group,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_create)(
    (MPIABI_Comm)comm,
    (MPIABI_Group)group,
    (MPIABI_Comm *)newcomm
  );
}

int (* MPIABI_Comm_create_group)(
  MPIABI_Comm comm,
  MPIABI_Group group,
  int tag,
  MPIABI_Comm * newcomm
) = NULL;
int MPI_Comm_create_group(
  MPI_Comm comm,
  MPI_Group group,
  int tag,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_create_group)(
    (MPIABI_Comm)comm,
    (MPIABI_Group)group,
    tag,
    (MPIABI_Comm *)newcomm
  );
}
int PMPI_Comm_create_group(
  MPI_Comm comm,
  MPI_Group group,
  int tag,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_create_group)(
    (MPIABI_Comm)comm,
    (MPIABI_Group)group,
    tag,
    (MPIABI_Comm *)newcomm
  );
}

int (* MPIABI_Comm_split)(
  MPIABI_Comm comm,
  int color,
  int key,
  MPIABI_Comm * newcomm
) = NULL;
int MPI_Comm_split(
  MPI_Comm comm,
  int color,
  int key,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_split)(
    (MPIABI_Comm)comm,
    color,
    key,
    (MPIABI_Comm *)newcomm
  );
}
int PMPI_Comm_split(
  MPI_Comm comm,
  int color,
  int key,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_split)(
    (MPIABI_Comm)comm,
    color,
    key,
    (MPIABI_Comm *)newcomm
  );
}

int (* MPIABI_Comm_split_type)(
  MPIABI_Comm comm,
  int split_type,
  int key,
  MPIABI_Info info,
  MPIABI_Comm * newcomm
) = NULL;
int MPI_Comm_split_type(
  MPI_Comm comm,
  int split_type,
  int key,
  MPI_Info info,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_split_type)(
    (MPIABI_Comm)comm,
    split_type,
    key,
    (MPIABI_Info)info,
    (MPIABI_Comm *)newcomm
  );
}
int PMPI_Comm_split_type(
  MPI_Comm comm,
  int split_type,
  int key,
  MPI_Info info,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_split_type)(
    (MPIABI_Comm)comm,
    split_type,
    key,
    (MPIABI_Info)info,
    (MPIABI_Comm *)newcomm
  );
}

int (* MPIABI_Comm_free)(
  MPIABI_Comm * comm
) = NULL;
int MPI_Comm_free(
  MPI_Comm * comm
) {
  return (*MPIABI_Comm_free)(
    (MPIABI_Comm *)comm
  );
}
int PMPI_Comm_free(
  MPI_Comm * comm
) {
  return (*MPIABI_Comm_free)(
    (MPIABI_Comm *)comm
  );
}

int (* MPIABI_Comm_set_info)(
  MPIABI_Comm comm,
  MPIABI_Info info
) = NULL;
int MPI_Comm_set_info(
  MPI_Comm comm,
  MPI_Info info
) {
  return (*MPIABI_Comm_set_info)(
    (MPIABI_Comm)comm,
    (MPIABI_Info)info
  );
}
int PMPI_Comm_set_info(
  MPI_Comm comm,
  MPI_Info info
) {
  return (*MPIABI_Comm_set_info)(
    (MPIABI_Comm)comm,
    (MPIABI_Info)info
  );
}

int (* MPIABI_Comm_get_info)(
  MPIABI_Comm comm,
  MPIABI_Info * info
) = NULL;
int MPI_Comm_get_info(
  MPI_Comm comm,
  MPI_Info * info
) {
  return (*MPIABI_Comm_get_info)(
    (MPIABI_Comm)comm,
    (MPIABI_Info *)info
  );
}
int PMPI_Comm_get_info(
  MPI_Comm comm,
  MPI_Info * info
) {
  return (*MPIABI_Comm_get_info)(
    (MPIABI_Comm)comm,
    (MPIABI_Info *)info
  );
}

int (* MPIABI_Comm_test_inter)(
  MPIABI_Comm comm,
  int * flag
) = NULL;
int MPI_Comm_test_inter(
  MPI_Comm comm,
  int * flag
) {
  return (*MPIABI_Comm_test_inter)(
    (MPIABI_Comm)comm,
    flag
  );
}
int PMPI_Comm_test_inter(
  MPI_Comm comm,
  int * flag
) {
  return (*MPIABI_Comm_test_inter)(
    (MPIABI_Comm)comm,
    flag
  );
}

int (* MPIABI_Comm_remote_size)(
  MPIABI_Comm comm,
  int * size
) = NULL;
int MPI_Comm_remote_size(
  MPI_Comm comm,
  int * size
) {
  return (*MPIABI_Comm_remote_size)(
    (MPIABI_Comm)comm,
    size
  );
}
int PMPI_Comm_remote_size(
  MPI_Comm comm,
  int * size
) {
  return (*MPIABI_Comm_remote_size)(
    (MPIABI_Comm)comm,
    size
  );
}

int (* MPIABI_Comm_remote_group)(
  MPIABI_Comm comm,
  MPIABI_Group * group
) = NULL;
int MPI_Comm_remote_group(
  MPI_Comm comm,
  MPI_Group * group
) {
  return (*MPIABI_Comm_remote_group)(
    (MPIABI_Comm)comm,
    (MPIABI_Group *)group
  );
}
int PMPI_Comm_remote_group(
  MPI_Comm comm,
  MPI_Group * group
) {
  return (*MPIABI_Comm_remote_group)(
    (MPIABI_Comm)comm,
    (MPIABI_Group *)group
  );
}

int (* MPIABI_Intercomm_create)(
  MPIABI_Comm local_comm,
  int local_leader,
  MPIABI_Comm peer_comm,
  int remote_leader,
  int tag,
  MPIABI_Comm * newintercomm
) = NULL;
int MPI_Intercomm_create(
  MPI_Comm local_comm,
  int local_leader,
  MPI_Comm peer_comm,
  int remote_leader,
  int tag,
  MPI_Comm * newintercomm
) {
  return (*MPIABI_Intercomm_create)(
    (MPIABI_Comm)local_comm,
    local_leader,
    (MPIABI_Comm)peer_comm,
    remote_leader,
    tag,
    (MPIABI_Comm *)newintercomm
  );
}
int PMPI_Intercomm_create(
  MPI_Comm local_comm,
  int local_leader,
  MPI_Comm peer_comm,
  int remote_leader,
  int tag,
  MPI_Comm * newintercomm
) {
  return (*MPIABI_Intercomm_create)(
    (MPIABI_Comm)local_comm,
    local_leader,
    (MPIABI_Comm)peer_comm,
    remote_leader,
    tag,
    (MPIABI_Comm *)newintercomm
  );
}

int (* MPIABI_Intercomm_merge)(
  MPIABI_Comm intercomm,
  int high,
  MPIABI_Comm * newintracomm
) = NULL;
int MPI_Intercomm_merge(
  MPI_Comm intercomm,
  int high,
  MPI_Comm * newintracomm
) {
  return (*MPIABI_Intercomm_merge)(
    (MPIABI_Comm)intercomm,
    high,
    (MPIABI_Comm *)newintracomm
  );
}
int PMPI_Intercomm_merge(
  MPI_Comm intercomm,
  int high,
  MPI_Comm * newintracomm
) {
  return (*MPIABI_Intercomm_merge)(
    (MPIABI_Comm)intercomm,
    high,
    (MPIABI_Comm *)newintracomm
  );
}

int (* MPIABI_Comm_create_keyval)(
  MPIABI_Comm_copy_attr_function * comm_copy_attr_fn,
  MPIABI_Comm_delete_attr_function * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state
) = NULL;
int MPI_Comm_create_keyval(
  MPI_Comm_copy_attr_function * comm_copy_attr_fn,
  MPI_Comm_delete_attr_function * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state
) {
  return (*MPIABI_Comm_create_keyval)(
    (MPIABI_Comm_copy_attr_function *)comm_copy_attr_fn,
    (MPIABI_Comm_delete_attr_function *)comm_delete_attr_fn,
    comm_keyval,
    extra_state
  );
}
int PMPI_Comm_create_keyval(
  MPI_Comm_copy_attr_function * comm_copy_attr_fn,
  MPI_Comm_delete_attr_function * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state
) {
  return (*MPIABI_Comm_create_keyval)(
    (MPIABI_Comm_copy_attr_function *)comm_copy_attr_fn,
    (MPIABI_Comm_delete_attr_function *)comm_delete_attr_fn,
    comm_keyval,
    extra_state
  );
}

int (* MPIABI_Comm_free_keyval)(
  int * comm_keyval
) = NULL;
int MPI_Comm_free_keyval(
  int * comm_keyval
) {
  return (*MPIABI_Comm_free_keyval)(
    comm_keyval
  );
}
int PMPI_Comm_free_keyval(
  int * comm_keyval
) {
  return (*MPIABI_Comm_free_keyval)(
    comm_keyval
  );
}

int (* MPIABI_Comm_set_attr)(
  MPIABI_Comm comm,
  int comm_keyval,
  void * attribute_val
) = NULL;
int MPI_Comm_set_attr(
  MPI_Comm comm,
  int comm_keyval,
  void * attribute_val
) {
  return (*MPIABI_Comm_set_attr)(
    (MPIABI_Comm)comm,
    comm_keyval,
    attribute_val
  );
}
int PMPI_Comm_set_attr(
  MPI_Comm comm,
  int comm_keyval,
  void * attribute_val
) {
  return (*MPIABI_Comm_set_attr)(
    (MPIABI_Comm)comm,
    comm_keyval,
    attribute_val
  );
}

int (* MPIABI_Comm_get_attr)(
  MPIABI_Comm comm,
  int comm_keyval,
  void * attribute_val,
  int * flag
) = NULL;
int MPI_Comm_get_attr(
  MPI_Comm comm,
  int comm_keyval,
  void * attribute_val,
  int * flag
) {
  return (*MPIABI_Comm_get_attr)(
    (MPIABI_Comm)comm,
    comm_keyval,
    attribute_val,
    flag
  );
}
int PMPI_Comm_get_attr(
  MPI_Comm comm,
  int comm_keyval,
  void * attribute_val,
  int * flag
) {
  return (*MPIABI_Comm_get_attr)(
    (MPIABI_Comm)comm,
    comm_keyval,
    attribute_val,
    flag
  );
}

int (* MPIABI_Comm_delete_attr)(
  MPIABI_Comm comm,
  int comm_keyval
) = NULL;
int MPI_Comm_delete_attr(
  MPI_Comm comm,
  int comm_keyval
) {
  return (*MPIABI_Comm_delete_attr)(
    (MPIABI_Comm)comm,
    comm_keyval
  );
}
int PMPI_Comm_delete_attr(
  MPI_Comm comm,
  int comm_keyval
) {
  return (*MPIABI_Comm_delete_attr)(
    (MPIABI_Comm)comm,
    comm_keyval
  );
}

int (* MPIABI_Win_create_keyval)(
  MPIABI_Win_copy_attr_function * win_copy_attr_fn,
  MPIABI_Win_delete_attr_function * win_delete_attr_fn,
  int * win_keyval,
  void * extra_state
) = NULL;
int MPI_Win_create_keyval(
  MPI_Win_copy_attr_function * win_copy_attr_fn,
  MPI_Win_delete_attr_function * win_delete_attr_fn,
  int * win_keyval,
  void * extra_state
) {
  return (*MPIABI_Win_create_keyval)(
    (MPIABI_Win_copy_attr_function *)win_copy_attr_fn,
    (MPIABI_Win_delete_attr_function *)win_delete_attr_fn,
    win_keyval,
    extra_state
  );
}
int PMPI_Win_create_keyval(
  MPI_Win_copy_attr_function * win_copy_attr_fn,
  MPI_Win_delete_attr_function * win_delete_attr_fn,
  int * win_keyval,
  void * extra_state
) {
  return (*MPIABI_Win_create_keyval)(
    (MPIABI_Win_copy_attr_function *)win_copy_attr_fn,
    (MPIABI_Win_delete_attr_function *)win_delete_attr_fn,
    win_keyval,
    extra_state
  );
}

int (* MPIABI_Win_free_keyval)(
  int * win_keyval
) = NULL;
int MPI_Win_free_keyval(
  int * win_keyval
) {
  return (*MPIABI_Win_free_keyval)(
    win_keyval
  );
}
int PMPI_Win_free_keyval(
  int * win_keyval
) {
  return (*MPIABI_Win_free_keyval)(
    win_keyval
  );
}

int (* MPIABI_Win_set_attr)(
  MPIABI_Win win,
  int win_keyval,
  void * attribute_val
) = NULL;
int MPI_Win_set_attr(
  MPI_Win win,
  int win_keyval,
  void * attribute_val
) {
  return (*MPIABI_Win_set_attr)(
    (MPIABI_Win)win,
    win_keyval,
    attribute_val
  );
}
int PMPI_Win_set_attr(
  MPI_Win win,
  int win_keyval,
  void * attribute_val
) {
  return (*MPIABI_Win_set_attr)(
    (MPIABI_Win)win,
    win_keyval,
    attribute_val
  );
}

int (* MPIABI_Win_get_attr)(
  MPIABI_Win win,
  int win_keyval,
  void * attribute_val,
  int * flag
) = NULL;
int MPI_Win_get_attr(
  MPI_Win win,
  int win_keyval,
  void * attribute_val,
  int * flag
) {
  return (*MPIABI_Win_get_attr)(
    (MPIABI_Win)win,
    win_keyval,
    attribute_val,
    flag
  );
}
int PMPI_Win_get_attr(
  MPI_Win win,
  int win_keyval,
  void * attribute_val,
  int * flag
) {
  return (*MPIABI_Win_get_attr)(
    (MPIABI_Win)win,
    win_keyval,
    attribute_val,
    flag
  );
}

int (* MPIABI_Win_delete_attr)(
  MPIABI_Win win,
  int win_keyval
) = NULL;
int MPI_Win_delete_attr(
  MPI_Win win,
  int win_keyval
) {
  return (*MPIABI_Win_delete_attr)(
    (MPIABI_Win)win,
    win_keyval
  );
}
int PMPI_Win_delete_attr(
  MPI_Win win,
  int win_keyval
) {
  return (*MPIABI_Win_delete_attr)(
    (MPIABI_Win)win,
    win_keyval
  );
}

int (* MPIABI_Type_create_keyval)(
  MPIABI_Type_copy_attr_function * type_copy_attr_fn,
  MPIABI_Type_delete_attr_function * type_delete_attr_fn,
  int * type_keyval,
  void * extra_state
) = NULL;
int MPI_Type_create_keyval(
  MPI_Type_copy_attr_function * type_copy_attr_fn,
  MPI_Type_delete_attr_function * type_delete_attr_fn,
  int * type_keyval,
  void * extra_state
) {
  return (*MPIABI_Type_create_keyval)(
    (MPIABI_Type_copy_attr_function *)type_copy_attr_fn,
    (MPIABI_Type_delete_attr_function *)type_delete_attr_fn,
    type_keyval,
    extra_state
  );
}
int PMPI_Type_create_keyval(
  MPI_Type_copy_attr_function * type_copy_attr_fn,
  MPI_Type_delete_attr_function * type_delete_attr_fn,
  int * type_keyval,
  void * extra_state
) {
  return (*MPIABI_Type_create_keyval)(
    (MPIABI_Type_copy_attr_function *)type_copy_attr_fn,
    (MPIABI_Type_delete_attr_function *)type_delete_attr_fn,
    type_keyval,
    extra_state
  );
}

int (* MPIABI_Type_free_keyval)(
  int * type_keyval
) = NULL;
int MPI_Type_free_keyval(
  int * type_keyval
) {
  return (*MPIABI_Type_free_keyval)(
    type_keyval
  );
}
int PMPI_Type_free_keyval(
  int * type_keyval
) {
  return (*MPIABI_Type_free_keyval)(
    type_keyval
  );
}

int (* MPIABI_Type_set_attr)(
  MPIABI_Datatype type,
  int type_keyval,
  void * attribute_val
) = NULL;
int MPI_Type_set_attr(
  MPI_Datatype type,
  int type_keyval,
  void * attribute_val
) {
  return (*MPIABI_Type_set_attr)(
    (MPIABI_Datatype)type,
    type_keyval,
    attribute_val
  );
}
int PMPI_Type_set_attr(
  MPI_Datatype type,
  int type_keyval,
  void * attribute_val
) {
  return (*MPIABI_Type_set_attr)(
    (MPIABI_Datatype)type,
    type_keyval,
    attribute_val
  );
}

int (* MPIABI_Type_get_attr)(
  MPIABI_Datatype type,
  int type_keyval,
  void * attribute_val,
  int * flag
) = NULL;
int MPI_Type_get_attr(
  MPI_Datatype type,
  int type_keyval,
  void * attribute_val,
  int * flag
) {
  return (*MPIABI_Type_get_attr)(
    (MPIABI_Datatype)type,
    type_keyval,
    attribute_val,
    flag
  );
}
int PMPI_Type_get_attr(
  MPI_Datatype type,
  int type_keyval,
  void * attribute_val,
  int * flag
) {
  return (*MPIABI_Type_get_attr)(
    (MPIABI_Datatype)type,
    type_keyval,
    attribute_val,
    flag
  );
}

int (* MPIABI_Type_delete_attr)(
  MPIABI_Datatype type,
  int type_keyval
) = NULL;
int MPI_Type_delete_attr(
  MPI_Datatype type,
  int type_keyval
) {
  return (*MPIABI_Type_delete_attr)(
    (MPIABI_Datatype)type,
    type_keyval
  );
}
int PMPI_Type_delete_attr(
  MPI_Datatype type,
  int type_keyval
) {
  return (*MPIABI_Type_delete_attr)(
    (MPIABI_Datatype)type,
    type_keyval
  );
}

int (* MPIABI_Comm_set_name)(
  MPIABI_Comm comm,
  const char * comm_name
) = NULL;
int MPI_Comm_set_name(
  MPI_Comm comm,
  const char * comm_name
) {
  return (*MPIABI_Comm_set_name)(
    (MPIABI_Comm)comm,
    comm_name
  );
}
int PMPI_Comm_set_name(
  MPI_Comm comm,
  const char * comm_name
) {
  return (*MPIABI_Comm_set_name)(
    (MPIABI_Comm)comm,
    comm_name
  );
}

int (* MPIABI_Comm_get_name)(
  MPIABI_Comm comm,
  char * comm_name,
  int * resultlen
) = NULL;
int MPI_Comm_get_name(
  MPI_Comm comm,
  char * comm_name,
  int * resultlen
) {
  return (*MPIABI_Comm_get_name)(
    (MPIABI_Comm)comm,
    comm_name,
    resultlen
  );
}
int PMPI_Comm_get_name(
  MPI_Comm comm,
  char * comm_name,
  int * resultlen
) {
  return (*MPIABI_Comm_get_name)(
    (MPIABI_Comm)comm,
    comm_name,
    resultlen
  );
}

int (* MPIABI_Type_set_name)(
  MPIABI_Datatype type,
  const char * type_name
) = NULL;
int MPI_Type_set_name(
  MPI_Datatype type,
  const char * type_name
) {
  return (*MPIABI_Type_set_name)(
    (MPIABI_Datatype)type,
    type_name
  );
}
int PMPI_Type_set_name(
  MPI_Datatype type,
  const char * type_name
) {
  return (*MPIABI_Type_set_name)(
    (MPIABI_Datatype)type,
    type_name
  );
}

int (* MPIABI_Type_get_name)(
  MPIABI_Datatype type,
  char * type_name,
  int * resultlen
) = NULL;
int MPI_Type_get_name(
  MPI_Datatype type,
  char * type_name,
  int * resultlen
) {
  return (*MPIABI_Type_get_name)(
    (MPIABI_Datatype)type,
    type_name,
    resultlen
  );
}
int PMPI_Type_get_name(
  MPI_Datatype type,
  char * type_name,
  int * resultlen
) {
  return (*MPIABI_Type_get_name)(
    (MPIABI_Datatype)type,
    type_name,
    resultlen
  );
}

int (* MPIABI_Win_set_name)(
  MPIABI_Win win,
  const char * win_name
) = NULL;
int MPI_Win_set_name(
  MPI_Win win,
  const char * win_name
) {
  return (*MPIABI_Win_set_name)(
    (MPIABI_Win)win,
    win_name
  );
}
int PMPI_Win_set_name(
  MPI_Win win,
  const char * win_name
) {
  return (*MPIABI_Win_set_name)(
    (MPIABI_Win)win,
    win_name
  );
}

int (* MPIABI_Win_get_name)(
  MPIABI_Win win,
  char * win_name,
  int * resultlen
) = NULL;
int MPI_Win_get_name(
  MPI_Win win,
  char * win_name,
  int * resultlen
) {
  return (*MPIABI_Win_get_name)(
    (MPIABI_Win)win,
    win_name,
    resultlen
  );
}
int PMPI_Win_get_name(
  MPI_Win win,
  char * win_name,
  int * resultlen
) {
  return (*MPIABI_Win_get_name)(
    (MPIABI_Win)win,
    win_name,
    resultlen
  );
}

int (* MPIABI_Cart_create)(
  MPIABI_Comm comm_old,
  int ndims,
  const int * dims,
  const int * periods,
  int reorder,
  MPIABI_Comm * comm_cart
) = NULL;
int MPI_Cart_create(
  MPI_Comm comm_old,
  int ndims,
  const int * dims,
  const int * periods,
  int reorder,
  MPI_Comm * comm_cart
) {
  return (*MPIABI_Cart_create)(
    (MPIABI_Comm)comm_old,
    ndims,
    dims,
    periods,
    reorder,
    (MPIABI_Comm *)comm_cart
  );
}
int PMPI_Cart_create(
  MPI_Comm comm_old,
  int ndims,
  const int * dims,
  const int * periods,
  int reorder,
  MPI_Comm * comm_cart
) {
  return (*MPIABI_Cart_create)(
    (MPIABI_Comm)comm_old,
    ndims,
    dims,
    periods,
    reorder,
    (MPIABI_Comm *)comm_cart
  );
}

int (* MPIABI_Dims_create)(
  int nnodes,
  int ndims,
  int * dims
) = NULL;
int MPI_Dims_create(
  int nnodes,
  int ndims,
  int * dims
) {
  return (*MPIABI_Dims_create)(
    nnodes,
    ndims,
    dims
  );
}
int PMPI_Dims_create(
  int nnodes,
  int ndims,
  int * dims
) {
  return (*MPIABI_Dims_create)(
    nnodes,
    ndims,
    dims
  );
}

int (* MPIABI_Graph_create)(
  MPIABI_Comm comm_old,
  int nnodes,
  const int * index,
  const int * edges,
  int reorder,
  MPIABI_Comm * comm_graph
) = NULL;
int MPI_Graph_create(
  MPI_Comm comm_old,
  int nnodes,
  const int * index,
  const int * edges,
  int reorder,
  MPI_Comm * comm_graph
) {
  return (*MPIABI_Graph_create)(
    (MPIABI_Comm)comm_old,
    nnodes,
    index,
    edges,
    reorder,
    (MPIABI_Comm *)comm_graph
  );
}
int PMPI_Graph_create(
  MPI_Comm comm_old,
  int nnodes,
  const int * index,
  const int * edges,
  int reorder,
  MPI_Comm * comm_graph
) {
  return (*MPIABI_Graph_create)(
    (MPIABI_Comm)comm_old,
    nnodes,
    index,
    edges,
    reorder,
    (MPIABI_Comm *)comm_graph
  );
}

int (* MPIABI_Dist_graph_create_adjacent)(
  MPIABI_Comm comm_old,
  int indegree,
  const int * sources,
  const int * sourceweights,
  int outdegree,
  const int * destinations,
  const int * destweights,
  MPIABI_Info info,
  int reorder,
  MPIABI_Comm * comm_dist_graph
) = NULL;
int MPI_Dist_graph_create_adjacent(
  MPI_Comm comm_old,
  int indegree,
  const int * sources,
  const int * sourceweights,
  int outdegree,
  const int * destinations,
  const int * destweights,
  MPI_Info info,
  int reorder,
  MPI_Comm * comm_dist_graph
) {
  return (*MPIABI_Dist_graph_create_adjacent)(
    (MPIABI_Comm)comm_old,
    indegree,
    sources,
    sourceweights,
    outdegree,
    destinations,
    destweights,
    (MPIABI_Info)info,
    reorder,
    (MPIABI_Comm *)comm_dist_graph
  );
}
int PMPI_Dist_graph_create_adjacent(
  MPI_Comm comm_old,
  int indegree,
  const int * sources,
  const int * sourceweights,
  int outdegree,
  const int * destinations,
  const int * destweights,
  MPI_Info info,
  int reorder,
  MPI_Comm * comm_dist_graph
) {
  return (*MPIABI_Dist_graph_create_adjacent)(
    (MPIABI_Comm)comm_old,
    indegree,
    sources,
    sourceweights,
    outdegree,
    destinations,
    destweights,
    (MPIABI_Info)info,
    reorder,
    (MPIABI_Comm *)comm_dist_graph
  );
}

int (* MPIABI_Dist_graph_create)(
  MPIABI_Comm comm_old,
  int n,
  const int * sources,
  const int * degrees,
  const int * destinations,
  const int * weights,
  MPIABI_Info info,
  int reorder,
  MPIABI_Comm * comm_dist_graph
) = NULL;
int MPI_Dist_graph_create(
  MPI_Comm comm_old,
  int n,
  const int * sources,
  const int * degrees,
  const int * destinations,
  const int * weights,
  MPI_Info info,
  int reorder,
  MPI_Comm * comm_dist_graph
) {
  return (*MPIABI_Dist_graph_create)(
    (MPIABI_Comm)comm_old,
    n,
    sources,
    degrees,
    destinations,
    weights,
    (MPIABI_Info)info,
    reorder,
    (MPIABI_Comm *)comm_dist_graph
  );
}
int PMPI_Dist_graph_create(
  MPI_Comm comm_old,
  int n,
  const int * sources,
  const int * degrees,
  const int * destinations,
  const int * weights,
  MPI_Info info,
  int reorder,
  MPI_Comm * comm_dist_graph
) {
  return (*MPIABI_Dist_graph_create)(
    (MPIABI_Comm)comm_old,
    n,
    sources,
    degrees,
    destinations,
    weights,
    (MPIABI_Info)info,
    reorder,
    (MPIABI_Comm *)comm_dist_graph
  );
}

int (* MPIABI_Topo_test)(
  MPIABI_Comm comm,
  int * status
) = NULL;
int MPI_Topo_test(
  MPI_Comm comm,
  int * status
) {
  return (*MPIABI_Topo_test)(
    (MPIABI_Comm)comm,
    status
  );
}
int PMPI_Topo_test(
  MPI_Comm comm,
  int * status
) {
  return (*MPIABI_Topo_test)(
    (MPIABI_Comm)comm,
    status
  );
}

int (* MPIABI_Graphdims_get)(
  MPIABI_Comm comm,
  int * nnodes,
  int * nedges
) = NULL;
int MPI_Graphdims_get(
  MPI_Comm comm,
  int * nnodes,
  int * nedges
) {
  return (*MPIABI_Graphdims_get)(
    (MPIABI_Comm)comm,
    nnodes,
    nedges
  );
}
int PMPI_Graphdims_get(
  MPI_Comm comm,
  int * nnodes,
  int * nedges
) {
  return (*MPIABI_Graphdims_get)(
    (MPIABI_Comm)comm,
    nnodes,
    nedges
  );
}

int (* MPIABI_Graph_get)(
  MPIABI_Comm comm,
  int maxindex,
  int maxedges,
  int * index,
  int * edges
) = NULL;
int MPI_Graph_get(
  MPI_Comm comm,
  int maxindex,
  int maxedges,
  int * index,
  int * edges
) {
  return (*MPIABI_Graph_get)(
    (MPIABI_Comm)comm,
    maxindex,
    maxedges,
    index,
    edges
  );
}
int PMPI_Graph_get(
  MPI_Comm comm,
  int maxindex,
  int maxedges,
  int * index,
  int * edges
) {
  return (*MPIABI_Graph_get)(
    (MPIABI_Comm)comm,
    maxindex,
    maxedges,
    index,
    edges
  );
}

int (* MPIABI_Cartdim_get)(
  MPIABI_Comm comm,
  int * ndims
) = NULL;
int MPI_Cartdim_get(
  MPI_Comm comm,
  int * ndims
) {
  return (*MPIABI_Cartdim_get)(
    (MPIABI_Comm)comm,
    ndims
  );
}
int PMPI_Cartdim_get(
  MPI_Comm comm,
  int * ndims
) {
  return (*MPIABI_Cartdim_get)(
    (MPIABI_Comm)comm,
    ndims
  );
}

int (* MPIABI_Cart_get)(
  MPIABI_Comm comm,
  int maxdims,
  int * dims,
  int * periods,
  int * coords
) = NULL;
int MPI_Cart_get(
  MPI_Comm comm,
  int maxdims,
  int * dims,
  int * periods,
  int * coords
) {
  return (*MPIABI_Cart_get)(
    (MPIABI_Comm)comm,
    maxdims,
    dims,
    periods,
    coords
  );
}
int PMPI_Cart_get(
  MPI_Comm comm,
  int maxdims,
  int * dims,
  int * periods,
  int * coords
) {
  return (*MPIABI_Cart_get)(
    (MPIABI_Comm)comm,
    maxdims,
    dims,
    periods,
    coords
  );
}

int (* MPIABI_Cart_rank)(
  MPIABI_Comm comm,
  const int * coords,
  int * rank
) = NULL;
int MPI_Cart_rank(
  MPI_Comm comm,
  const int * coords,
  int * rank
) {
  return (*MPIABI_Cart_rank)(
    (MPIABI_Comm)comm,
    coords,
    rank
  );
}
int PMPI_Cart_rank(
  MPI_Comm comm,
  const int * coords,
  int * rank
) {
  return (*MPIABI_Cart_rank)(
    (MPIABI_Comm)comm,
    coords,
    rank
  );
}

int (* MPIABI_Cart_coords)(
  MPIABI_Comm comm,
  int rank,
  int maxdims,
  int * coords
) = NULL;
int MPI_Cart_coords(
  MPI_Comm comm,
  int rank,
  int maxdims,
  int * coords
) {
  return (*MPIABI_Cart_coords)(
    (MPIABI_Comm)comm,
    rank,
    maxdims,
    coords
  );
}
int PMPI_Cart_coords(
  MPI_Comm comm,
  int rank,
  int maxdims,
  int * coords
) {
  return (*MPIABI_Cart_coords)(
    (MPIABI_Comm)comm,
    rank,
    maxdims,
    coords
  );
}

int (* MPIABI_Graph_neighbors_count)(
  MPIABI_Comm comm,
  int rank,
  int * nneighbors
) = NULL;
int MPI_Graph_neighbors_count(
  MPI_Comm comm,
  int rank,
  int * nneighbors
) {
  return (*MPIABI_Graph_neighbors_count)(
    (MPIABI_Comm)comm,
    rank,
    nneighbors
  );
}
int PMPI_Graph_neighbors_count(
  MPI_Comm comm,
  int rank,
  int * nneighbors
) {
  return (*MPIABI_Graph_neighbors_count)(
    (MPIABI_Comm)comm,
    rank,
    nneighbors
  );
}

int (* MPIABI_Graph_neighbors)(
  MPIABI_Comm comm,
  int rank,
  int maxneighbors,
  int * neighbors
) = NULL;
int MPI_Graph_neighbors(
  MPI_Comm comm,
  int rank,
  int maxneighbors,
  int * neighbors
) {
  return (*MPIABI_Graph_neighbors)(
    (MPIABI_Comm)comm,
    rank,
    maxneighbors,
    neighbors
  );
}
int PMPI_Graph_neighbors(
  MPI_Comm comm,
  int rank,
  int maxneighbors,
  int * neighbors
) {
  return (*MPIABI_Graph_neighbors)(
    (MPIABI_Comm)comm,
    rank,
    maxneighbors,
    neighbors
  );
}

int (* MPIABI_Dist_graph_neighbors_count)(
  MPIABI_Comm comm,
  int * indegree,
  int * outdegree,
  int * weighted
) = NULL;
int MPI_Dist_graph_neighbors_count(
  MPI_Comm comm,
  int * indegree,
  int * outdegree,
  int * weighted
) {
  return (*MPIABI_Dist_graph_neighbors_count)(
    (MPIABI_Comm)comm,
    indegree,
    outdegree,
    weighted
  );
}
int PMPI_Dist_graph_neighbors_count(
  MPI_Comm comm,
  int * indegree,
  int * outdegree,
  int * weighted
) {
  return (*MPIABI_Dist_graph_neighbors_count)(
    (MPIABI_Comm)comm,
    indegree,
    outdegree,
    weighted
  );
}

int (* MPIABI_Dist_graph_neighbors)(
  MPIABI_Comm comm,
  int maxindeegree,
  int * sources,
  int * wourceweights,
  int maxoutdegree,
  int * destinations,
  int * destweights
) = NULL;
int MPI_Dist_graph_neighbors(
  MPI_Comm comm,
  int maxindeegree,
  int * sources,
  int * wourceweights,
  int maxoutdegree,
  int * destinations,
  int * destweights
) {
  return (*MPIABI_Dist_graph_neighbors)(
    (MPIABI_Comm)comm,
    maxindeegree,
    sources,
    wourceweights,
    maxoutdegree,
    destinations,
    destweights
  );
}
int PMPI_Dist_graph_neighbors(
  MPI_Comm comm,
  int maxindeegree,
  int * sources,
  int * wourceweights,
  int maxoutdegree,
  int * destinations,
  int * destweights
) {
  return (*MPIABI_Dist_graph_neighbors)(
    (MPIABI_Comm)comm,
    maxindeegree,
    sources,
    wourceweights,
    maxoutdegree,
    destinations,
    destweights
  );
}

int (* MPIABI_Cart_shift)(
  MPIABI_Comm comm,
  int direction,
  int disp,
  int * rank_source,
  int * rank_dest
) = NULL;
int MPI_Cart_shift(
  MPI_Comm comm,
  int direction,
  int disp,
  int * rank_source,
  int * rank_dest
) {
  return (*MPIABI_Cart_shift)(
    (MPIABI_Comm)comm,
    direction,
    disp,
    rank_source,
    rank_dest
  );
}
int PMPI_Cart_shift(
  MPI_Comm comm,
  int direction,
  int disp,
  int * rank_source,
  int * rank_dest
) {
  return (*MPIABI_Cart_shift)(
    (MPIABI_Comm)comm,
    direction,
    disp,
    rank_source,
    rank_dest
  );
}

int (* MPIABI_Cart_sub)(
  MPIABI_Comm comm,
  const int * remain_dims,
  MPIABI_Comm * newcomm
) = NULL;
int MPI_Cart_sub(
  MPI_Comm comm,
  const int * remain_dims,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Cart_sub)(
    (MPIABI_Comm)comm,
    remain_dims,
    (MPIABI_Comm *)newcomm
  );
}
int PMPI_Cart_sub(
  MPI_Comm comm,
  const int * remain_dims,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Cart_sub)(
    (MPIABI_Comm)comm,
    remain_dims,
    (MPIABI_Comm *)newcomm
  );
}

int (* MPIABI_Cart_map)(
  MPIABI_Comm comm,
  int ndims,
  const int * dims,
  const int * periods,
  int * newrank
) = NULL;
int MPI_Cart_map(
  MPI_Comm comm,
  int ndims,
  const int * dims,
  const int * periods,
  int * newrank
) {
  return (*MPIABI_Cart_map)(
    (MPIABI_Comm)comm,
    ndims,
    dims,
    periods,
    newrank
  );
}
int PMPI_Cart_map(
  MPI_Comm comm,
  int ndims,
  const int * dims,
  const int * periods,
  int * newrank
) {
  return (*MPIABI_Cart_map)(
    (MPIABI_Comm)comm,
    ndims,
    dims,
    periods,
    newrank
  );
}

int (* MPIABI_Graph_map)(
  MPIABI_Comm comm,
  int nnodes,
  const int * index,
  const int * edges,
  int * newrank
) = NULL;
int MPI_Graph_map(
  MPI_Comm comm,
  int nnodes,
  const int * index,
  const int * edges,
  int * newrank
) {
  return (*MPIABI_Graph_map)(
    (MPIABI_Comm)comm,
    nnodes,
    index,
    edges,
    newrank
  );
}
int PMPI_Graph_map(
  MPI_Comm comm,
  int nnodes,
  const int * index,
  const int * edges,
  int * newrank
) {
  return (*MPIABI_Graph_map)(
    (MPIABI_Comm)comm,
    nnodes,
    index,
    edges,
    newrank
  );
}

int (* MPIABI_Neighbor_allgather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) = NULL;
int MPI_Neighbor_allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Neighbor_allgather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}
int PMPI_Neighbor_allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Neighbor_allgather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Neighbor_allgatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) = NULL;
int MPI_Neighbor_allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Neighbor_allgatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}
int PMPI_Neighbor_allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Neighbor_allgatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Neighbor_alltoall)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) = NULL;
int MPI_Neighbor_alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Neighbor_alltoall)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)senddtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}
int PMPI_Neighbor_alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Neighbor_alltoall)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)senddtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Neighbor_alltoallv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm
) = NULL;
int MPI_Neighbor_alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Neighbor_alltoallv)(
    sendbuf,
    sendcounts,
    sdispls,
    (MPIABI_Datatype)senddtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}
int PMPI_Neighbor_alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm
) {
  return (*MPIABI_Neighbor_alltoallv)(
    sendbuf,
    sendcounts,
    sdispls,
    (MPIABI_Datatype)senddtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Neighbor_alltoallw)(
  const void * sendbuf,
  const int * sendcounts,
  const MPIABI_Aint * sdispls,
  const MPIABI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Aint * rdispls,
  const MPIABI_Datatype * recvtypes,
  MPIABI_Comm comm
) = NULL;
int MPI_Neighbor_alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const MPI_Aint * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPI_Aint * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm
) {
  return (*MPIABI_Neighbor_alltoallw)(
    sendbuf,
    sendcounts,
    (const MPIABI_Aint *)sdispls,
    (const MPIABI_Datatype *)sendtypes,
    recvbuf,
    recvcounts,
    (const MPIABI_Aint *)rdispls,
    (const MPIABI_Datatype *)recvtypes,
    (MPIABI_Comm)comm
  );
}
int PMPI_Neighbor_alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const MPI_Aint * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPI_Aint * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm
) {
  return (*MPIABI_Neighbor_alltoallw)(
    sendbuf,
    sendcounts,
    (const MPIABI_Aint *)sdispls,
    (const MPIABI_Datatype *)sendtypes,
    recvbuf,
    recvcounts,
    (const MPIABI_Aint *)rdispls,
    (const MPIABI_Datatype *)recvtypes,
    (MPIABI_Comm)comm
  );
}

int (* MPIABI_Ineighbor_allgather)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ineighbor_allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ineighbor_allgather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ineighbor_allgather(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ineighbor_allgather)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ineighbor_allgatherv)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ineighbor_allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ineighbor_allgatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ineighbor_allgatherv(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ineighbor_allgatherv)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)sendtype,
    recvbuf,
    recvcounts,
    displs,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ineighbor_alltoall)(
  const void * sendbuf,
  int sendcount,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ineighbor_alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ineighbor_alltoall)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)senddtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ineighbor_alltoall(
  const void * sendbuf,
  int sendcount,
  MPI_Datatype senddtype,
  void * recvbuf,
  int recvcount,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ineighbor_alltoall)(
    sendbuf,
    sendcount,
    (MPIABI_Datatype)senddtype,
    recvbuf,
    recvcount,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ineighbor_alltoallv)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPIABI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPIABI_Datatype recvtype,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ineighbor_alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ineighbor_alltoallv)(
    sendbuf,
    sendcounts,
    sdispls,
    (MPIABI_Datatype)senddtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ineighbor_alltoallv(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  MPI_Datatype senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  MPI_Datatype recvtype,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ineighbor_alltoallv)(
    sendbuf,
    sendcounts,
    sdispls,
    (MPIABI_Datatype)senddtype,
    recvbuf,
    recvcounts,
    rdispls,
    (MPIABI_Datatype)recvtype,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Ineighbor_alltoallw)(
  const void * sendbuf,
  const int * sendcounts,
  const MPIABI_Aint * sdispls,
  const MPIABI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Aint * rdispls,
  const MPIABI_Datatype * recvtypes,
  MPIABI_Comm comm,
  MPIABI_Request * request
) = NULL;
int MPI_Ineighbor_alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const MPI_Aint * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPI_Aint * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ineighbor_alltoallw)(
    sendbuf,
    sendcounts,
    (const MPIABI_Aint *)sdispls,
    (const MPIABI_Datatype *)sendtypes,
    recvbuf,
    recvcounts,
    (const MPIABI_Aint *)rdispls,
    (const MPIABI_Datatype *)recvtypes,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}
int PMPI_Ineighbor_alltoallw(
  const void * sendbuf,
  const int * sendcounts,
  const MPI_Aint * sdispls,
  const MPI_Datatype * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPI_Aint * rdispls,
  const MPI_Datatype * recvtypes,
  MPI_Comm comm,
  MPI_Request * request
) {
  return (*MPIABI_Ineighbor_alltoallw)(
    sendbuf,
    sendcounts,
    (const MPIABI_Aint *)sdispls,
    (const MPIABI_Datatype *)sendtypes,
    recvbuf,
    recvcounts,
    (const MPIABI_Aint *)rdispls,
    (const MPIABI_Datatype *)recvtypes,
    (MPIABI_Comm)comm,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Get_version)(
  int * version,
  int * subversion
) = NULL;
int MPI_Get_version(
  int * version,
  int * subversion
) {
  return (*MPIABI_Get_version)(
    version,
    subversion
  );
}
int PMPI_Get_version(
  int * version,
  int * subversion
) {
  return (*MPIABI_Get_version)(
    version,
    subversion
  );
}

int (* MPIABI_Get_library_version)(
  char * version,
  int * resultlen
) = NULL;
int MPI_Get_library_version(
  char * version,
  int * resultlen
) {
  return (*MPIABI_Get_library_version)(
    version,
    resultlen
  );
}
int PMPI_Get_library_version(
  char * version,
  int * resultlen
) {
  return (*MPIABI_Get_library_version)(
    version,
    resultlen
  );
}

int (* MPIABI_Get_processor_name)(
  char * name,
  int * resultlen
) = NULL;
int MPI_Get_processor_name(
  char * name,
  int * resultlen
) {
  return (*MPIABI_Get_processor_name)(
    name,
    resultlen
  );
}
int PMPI_Get_processor_name(
  char * name,
  int * resultlen
) {
  return (*MPIABI_Get_processor_name)(
    name,
    resultlen
  );
}

int (* MPIABI_Alloc_mem)(
  MPIABI_Aint size,
  MPIABI_Info info,
  void * baseptr
) = NULL;
int MPI_Alloc_mem(
  MPI_Aint size,
  MPI_Info info,
  void * baseptr
) {
  return (*MPIABI_Alloc_mem)(
    (MPIABI_Aint)size,
    (MPIABI_Info)info,
    baseptr
  );
}
int PMPI_Alloc_mem(
  MPI_Aint size,
  MPI_Info info,
  void * baseptr
) {
  return (*MPIABI_Alloc_mem)(
    (MPIABI_Aint)size,
    (MPIABI_Info)info,
    baseptr
  );
}

int (* MPIABI_Free_mem)(
  void * base
) = NULL;
int MPI_Free_mem(
  void * base
) {
  return (*MPIABI_Free_mem)(
    base
  );
}
int PMPI_Free_mem(
  void * base
) {
  return (*MPIABI_Free_mem)(
    base
  );
}

int (* MPIABI_Comm_create_errhandler)(
  MPIABI_Comm_errhandler_function * comm_errhandler_fn,
  MPIABI_Errhandler * errhandler
) = NULL;
int MPI_Comm_create_errhandler(
  MPI_Comm_errhandler_function * comm_errhandler_fn,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_Comm_create_errhandler)(
    (MPIABI_Comm_errhandler_function *)comm_errhandler_fn,
    (MPIABI_Errhandler *)errhandler
  );
}
int PMPI_Comm_create_errhandler(
  MPI_Comm_errhandler_function * comm_errhandler_fn,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_Comm_create_errhandler)(
    (MPIABI_Comm_errhandler_function *)comm_errhandler_fn,
    (MPIABI_Errhandler *)errhandler
  );
}

int (* MPIABI_Comm_set_errhandler)(
  MPIABI_Comm comm,
  MPIABI_Errhandler errhandler
) = NULL;
int MPI_Comm_set_errhandler(
  MPI_Comm comm,
  MPI_Errhandler errhandler
) {
  return (*MPIABI_Comm_set_errhandler)(
    (MPIABI_Comm)comm,
    (MPIABI_Errhandler)errhandler
  );
}
int PMPI_Comm_set_errhandler(
  MPI_Comm comm,
  MPI_Errhandler errhandler
) {
  return (*MPIABI_Comm_set_errhandler)(
    (MPIABI_Comm)comm,
    (MPIABI_Errhandler)errhandler
  );
}

int (* MPIABI_Comm_get_errhandler)(
  MPIABI_Comm comm,
  MPIABI_Errhandler * errhandler
) = NULL;
int MPI_Comm_get_errhandler(
  MPI_Comm comm,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_Comm_get_errhandler)(
    (MPIABI_Comm)comm,
    (MPIABI_Errhandler *)errhandler
  );
}
int PMPI_Comm_get_errhandler(
  MPI_Comm comm,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_Comm_get_errhandler)(
    (MPIABI_Comm)comm,
    (MPIABI_Errhandler *)errhandler
  );
}

int (* MPIABI_Win_create_errhandler)(
  MPIABI_Win_errhandler_function * win_errhandler_fn,
  MPIABI_Errhandler * errhandler
) = NULL;
int MPI_Win_create_errhandler(
  MPI_Win_errhandler_function * win_errhandler_fn,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_Win_create_errhandler)(
    (MPIABI_Win_errhandler_function *)win_errhandler_fn,
    (MPIABI_Errhandler *)errhandler
  );
}
int PMPI_Win_create_errhandler(
  MPI_Win_errhandler_function * win_errhandler_fn,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_Win_create_errhandler)(
    (MPIABI_Win_errhandler_function *)win_errhandler_fn,
    (MPIABI_Errhandler *)errhandler
  );
}

int (* MPIABI_Win_set_errhandler)(
  MPIABI_Win win,
  MPIABI_Errhandler errhandler
) = NULL;
int MPI_Win_set_errhandler(
  MPI_Win win,
  MPI_Errhandler errhandler
) {
  return (*MPIABI_Win_set_errhandler)(
    (MPIABI_Win)win,
    (MPIABI_Errhandler)errhandler
  );
}
int PMPI_Win_set_errhandler(
  MPI_Win win,
  MPI_Errhandler errhandler
) {
  return (*MPIABI_Win_set_errhandler)(
    (MPIABI_Win)win,
    (MPIABI_Errhandler)errhandler
  );
}

int (* MPIABI_Win_get_errhandler)(
  MPIABI_Win win,
  MPIABI_Errhandler * errhandler
) = NULL;
int MPI_Win_get_errhandler(
  MPI_Win win,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_Win_get_errhandler)(
    (MPIABI_Win)win,
    (MPIABI_Errhandler *)errhandler
  );
}
int PMPI_Win_get_errhandler(
  MPI_Win win,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_Win_get_errhandler)(
    (MPIABI_Win)win,
    (MPIABI_Errhandler *)errhandler
  );
}

int (* MPIABI_File_create_errhandler)(
  MPIABI_File_errhandler_function * file_errhandler_fn,
  MPIABI_Errhandler * errhandler
) = NULL;
int MPI_File_create_errhandler(
  MPI_File_errhandler_function * file_errhandler_fn,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_File_create_errhandler)(
    (MPIABI_File_errhandler_function *)file_errhandler_fn,
    (MPIABI_Errhandler *)errhandler
  );
}
int PMPI_File_create_errhandler(
  MPI_File_errhandler_function * file_errhandler_fn,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_File_create_errhandler)(
    (MPIABI_File_errhandler_function *)file_errhandler_fn,
    (MPIABI_Errhandler *)errhandler
  );
}

int (* MPIABI_File_set_errhandler)(
  MPIABI_File file,
  MPIABI_Errhandler errhandler
) = NULL;
int MPI_File_set_errhandler(
  MPI_File file,
  MPI_Errhandler errhandler
) {
  return (*MPIABI_File_set_errhandler)(
    (MPIABI_File)file,
    (MPIABI_Errhandler)errhandler
  );
}
int PMPI_File_set_errhandler(
  MPI_File file,
  MPI_Errhandler errhandler
) {
  return (*MPIABI_File_set_errhandler)(
    (MPIABI_File)file,
    (MPIABI_Errhandler)errhandler
  );
}

int (* MPIABI_File_get_errhandler)(
  MPIABI_File file,
  MPIABI_Errhandler * errhandler
) = NULL;
int MPI_File_get_errhandler(
  MPI_File file,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_File_get_errhandler)(
    (MPIABI_File)file,
    (MPIABI_Errhandler *)errhandler
  );
}
int PMPI_File_get_errhandler(
  MPI_File file,
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_File_get_errhandler)(
    (MPIABI_File)file,
    (MPIABI_Errhandler *)errhandler
  );
}

int (* MPIABI_Errhandler_free)(
  MPIABI_Errhandler * errhandler
) = NULL;
int MPI_Errhandler_free(
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_Errhandler_free)(
    (MPIABI_Errhandler *)errhandler
  );
}
int PMPI_Errhandler_free(
  MPI_Errhandler * errhandler
) {
  return (*MPIABI_Errhandler_free)(
    (MPIABI_Errhandler *)errhandler
  );
}

int (* MPIABI_Error_string)(
  int errorcode,
  char * string,
  int * resultlen
) = NULL;
int MPI_Error_string(
  int errorcode,
  char * string,
  int * resultlen
) {
  return (*MPIABI_Error_string)(
    errorcode,
    string,
    resultlen
  );
}
int PMPI_Error_string(
  int errorcode,
  char * string,
  int * resultlen
) {
  return (*MPIABI_Error_string)(
    errorcode,
    string,
    resultlen
  );
}

int (* MPIABI_Error_class)(
  int errorcode,
  int * errorclass
) = NULL;
int MPI_Error_class(
  int errorcode,
  int * errorclass
) {
  return (*MPIABI_Error_class)(
    errorcode,
    errorclass
  );
}
int PMPI_Error_class(
  int errorcode,
  int * errorclass
) {
  return (*MPIABI_Error_class)(
    errorcode,
    errorclass
  );
}

int (* MPIABI_Add_error_class)(
  int * errorclass
) = NULL;
int MPI_Add_error_class(
  int * errorclass
) {
  return (*MPIABI_Add_error_class)(
    errorclass
  );
}
int PMPI_Add_error_class(
  int * errorclass
) {
  return (*MPIABI_Add_error_class)(
    errorclass
  );
}

int (* MPIABI_Add_error_code)(
  int errorclass,
  int * errorcode
) = NULL;
int MPI_Add_error_code(
  int errorclass,
  int * errorcode
) {
  return (*MPIABI_Add_error_code)(
    errorclass,
    errorcode
  );
}
int PMPI_Add_error_code(
  int errorclass,
  int * errorcode
) {
  return (*MPIABI_Add_error_code)(
    errorclass,
    errorcode
  );
}

int (* MPIABI_Add_error_string)(
  int errorcode,
  const char * string
) = NULL;
int MPI_Add_error_string(
  int errorcode,
  const char * string
) {
  return (*MPIABI_Add_error_string)(
    errorcode,
    string
  );
}
int PMPI_Add_error_string(
  int errorcode,
  const char * string
) {
  return (*MPIABI_Add_error_string)(
    errorcode,
    string
  );
}

int (* MPIABI_Comm_call_errhandler)(
  MPIABI_Comm comm,
  int errorcode
) = NULL;
int MPI_Comm_call_errhandler(
  MPI_Comm comm,
  int errorcode
) {
  return (*MPIABI_Comm_call_errhandler)(
    (MPIABI_Comm)comm,
    errorcode
  );
}
int PMPI_Comm_call_errhandler(
  MPI_Comm comm,
  int errorcode
) {
  return (*MPIABI_Comm_call_errhandler)(
    (MPIABI_Comm)comm,
    errorcode
  );
}

int (* MPIABI_Win_call_errhandler)(
  MPIABI_Win win,
  int errorcode
) = NULL;
int MPI_Win_call_errhandler(
  MPI_Win win,
  int errorcode
) {
  return (*MPIABI_Win_call_errhandler)(
    (MPIABI_Win)win,
    errorcode
  );
}
int PMPI_Win_call_errhandler(
  MPI_Win win,
  int errorcode
) {
  return (*MPIABI_Win_call_errhandler)(
    (MPIABI_Win)win,
    errorcode
  );
}

int (* MPIABI_File_call_errhandler)(
  MPIABI_File file,
  int errorcode
) = NULL;
int MPI_File_call_errhandler(
  MPI_File file,
  int errorcode
) {
  return (*MPIABI_File_call_errhandler)(
    (MPIABI_File)file,
    errorcode
  );
}
int PMPI_File_call_errhandler(
  MPI_File file,
  int errorcode
) {
  return (*MPIABI_File_call_errhandler)(
    (MPIABI_File)file,
    errorcode
  );
}

double (* MPIABI_Wtime)(
) = NULL;
double MPI_Wtime(
) {
  return (*MPIABI_Wtime)(
  );
}
double PMPI_Wtime(
) {
  return (*MPIABI_Wtime)(
  );
}

double (* MPIABI_Wtick)(
) = NULL;
double MPI_Wtick(
) {
  return (*MPIABI_Wtick)(
  );
}
double PMPI_Wtick(
) {
  return (*MPIABI_Wtick)(
  );
}

int (* MPIABI_Init)(
  int * argc,
  char *** argv
) = NULL;
int MPI_Init(
  int * argc,
  char *** argv
) {
  return (*MPIABI_Init)(
    argc,
    argv
  );
}
int PMPI_Init(
  int * argc,
  char *** argv
) {
  return (*MPIABI_Init)(
    argc,
    argv
  );
}

int (* MPIABI_Finalize)(
) = NULL;
int MPI_Finalize(
) {
  return (*MPIABI_Finalize)(
  );
}
int PMPI_Finalize(
) {
  return (*MPIABI_Finalize)(
  );
}

int (* MPIABI_Initialized)(
  int * flag
) = NULL;
int MPI_Initialized(
  int * flag
) {
  return (*MPIABI_Initialized)(
    flag
  );
}
int PMPI_Initialized(
  int * flag
) {
  return (*MPIABI_Initialized)(
    flag
  );
}

int (* MPIABI_Abort)(
  MPIABI_Comm comm,
  int errorcode
) = NULL;
int MPI_Abort(
  MPI_Comm comm,
  int errorcode
) {
  return (*MPIABI_Abort)(
    (MPIABI_Comm)comm,
    errorcode
  );
}
int PMPI_Abort(
  MPI_Comm comm,
  int errorcode
) {
  return (*MPIABI_Abort)(
    (MPIABI_Comm)comm,
    errorcode
  );
}

int (* MPIABI_Finalized)(
  int * flag
) = NULL;
int MPI_Finalized(
  int * flag
) {
  return (*MPIABI_Finalized)(
    flag
  );
}
int PMPI_Finalized(
  int * flag
) {
  return (*MPIABI_Finalized)(
    flag
  );
}

int (* MPIABI_Info_create)(
  MPIABI_Info * info
) = NULL;
int MPI_Info_create(
  MPI_Info * info
) {
  return (*MPIABI_Info_create)(
    (MPIABI_Info *)info
  );
}
int PMPI_Info_create(
  MPI_Info * info
) {
  return (*MPIABI_Info_create)(
    (MPIABI_Info *)info
  );
}

int (* MPIABI_Info_set)(
  MPIABI_Info info,
  const char * key,
  const char * value
) = NULL;
int MPI_Info_set(
  MPI_Info info,
  const char * key,
  const char * value
) {
  return (*MPIABI_Info_set)(
    (MPIABI_Info)info,
    key,
    value
  );
}
int PMPI_Info_set(
  MPI_Info info,
  const char * key,
  const char * value
) {
  return (*MPIABI_Info_set)(
    (MPIABI_Info)info,
    key,
    value
  );
}

int (* MPIABI_Info_delete)(
  MPIABI_Info info,
  const char * key
) = NULL;
int MPI_Info_delete(
  MPI_Info info,
  const char * key
) {
  return (*MPIABI_Info_delete)(
    (MPIABI_Info)info,
    key
  );
}
int PMPI_Info_delete(
  MPI_Info info,
  const char * key
) {
  return (*MPIABI_Info_delete)(
    (MPIABI_Info)info,
    key
  );
}

int (* MPIABI_Info_get)(
  MPIABI_Info info,
  const char * key,
  int valuelen,
  char * value,
  int * flag
) = NULL;
int MPI_Info_get(
  MPI_Info info,
  const char * key,
  int valuelen,
  char * value,
  int * flag
) {
  return (*MPIABI_Info_get)(
    (MPIABI_Info)info,
    key,
    valuelen,
    value,
    flag
  );
}
int PMPI_Info_get(
  MPI_Info info,
  const char * key,
  int valuelen,
  char * value,
  int * flag
) {
  return (*MPIABI_Info_get)(
    (MPIABI_Info)info,
    key,
    valuelen,
    value,
    flag
  );
}

int (* MPIABI_Info_get_valuelen)(
  MPIABI_Info info,
  const char * key,
  int * valuelen,
  int * flag
) = NULL;
int MPI_Info_get_valuelen(
  MPI_Info info,
  const char * key,
  int * valuelen,
  int * flag
) {
  return (*MPIABI_Info_get_valuelen)(
    (MPIABI_Info)info,
    key,
    valuelen,
    flag
  );
}
int PMPI_Info_get_valuelen(
  MPI_Info info,
  const char * key,
  int * valuelen,
  int * flag
) {
  return (*MPIABI_Info_get_valuelen)(
    (MPIABI_Info)info,
    key,
    valuelen,
    flag
  );
}

int (* MPIABI_Info_get_nkeys)(
  MPIABI_Info info,
  int * nkeys
) = NULL;
int MPI_Info_get_nkeys(
  MPI_Info info,
  int * nkeys
) {
  return (*MPIABI_Info_get_nkeys)(
    (MPIABI_Info)info,
    nkeys
  );
}
int PMPI_Info_get_nkeys(
  MPI_Info info,
  int * nkeys
) {
  return (*MPIABI_Info_get_nkeys)(
    (MPIABI_Info)info,
    nkeys
  );
}

int (* MPIABI_Info_get_nthkey)(
  MPIABI_Info info,
  int n,
  char * key
) = NULL;
int MPI_Info_get_nthkey(
  MPI_Info info,
  int n,
  char * key
) {
  return (*MPIABI_Info_get_nthkey)(
    (MPIABI_Info)info,
    n,
    key
  );
}
int PMPI_Info_get_nthkey(
  MPI_Info info,
  int n,
  char * key
) {
  return (*MPIABI_Info_get_nthkey)(
    (MPIABI_Info)info,
    n,
    key
  );
}

int (* MPIABI_Info_dup)(
  MPIABI_Info info,
  MPIABI_Info * newinfo
) = NULL;
int MPI_Info_dup(
  MPI_Info info,
  MPI_Info * newinfo
) {
  return (*MPIABI_Info_dup)(
    (MPIABI_Info)info,
    (MPIABI_Info *)newinfo
  );
}
int PMPI_Info_dup(
  MPI_Info info,
  MPI_Info * newinfo
) {
  return (*MPIABI_Info_dup)(
    (MPIABI_Info)info,
    (MPIABI_Info *)newinfo
  );
}

int (* MPIABI_Info_free)(
  MPIABI_Info * info
) = NULL;
int MPI_Info_free(
  MPI_Info * info
) {
  return (*MPIABI_Info_free)(
    (MPIABI_Info *)info
  );
}
int PMPI_Info_free(
  MPI_Info * info
) {
  return (*MPIABI_Info_free)(
    (MPIABI_Info *)info
  );
}

int (* MPIABI_Comm_spawn)(
  const char * command,
  char ** argv,
  int maxprocs,
  MPIABI_Info info,
  int root,
  MPIABI_Comm comm,
  MPIABI_Comm * intercomm,
  int * array_off_errcodes
) = NULL;
int MPI_Comm_spawn(
  const char * command,
  char ** argv,
  int maxprocs,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * intercomm,
  int * array_off_errcodes
) {
  return (*MPIABI_Comm_spawn)(
    command,
    argv,
    maxprocs,
    (MPIABI_Info)info,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)intercomm,
    array_off_errcodes
  );
}
int PMPI_Comm_spawn(
  const char * command,
  char ** argv,
  int maxprocs,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * intercomm,
  int * array_off_errcodes
) {
  return (*MPIABI_Comm_spawn)(
    command,
    argv,
    maxprocs,
    (MPIABI_Info)info,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)intercomm,
    array_off_errcodes
  );
}

int (* MPIABI_Comm_get_parent)(
  MPIABI_Comm * parent
) = NULL;
int MPI_Comm_get_parent(
  MPI_Comm * parent
) {
  return (*MPIABI_Comm_get_parent)(
    (MPIABI_Comm *)parent
  );
}
int PMPI_Comm_get_parent(
  MPI_Comm * parent
) {
  return (*MPIABI_Comm_get_parent)(
    (MPIABI_Comm *)parent
  );
}

int (* MPIABI_Comm_spawn_multiple)(
  int count,
  char ** array_of_commands,
  char *** array_of_argv,
  const int * array_of_maxprocs,
  const MPIABI_Info * array_of_info,
  int root,
  MPIABI_Comm comm,
  MPIABI_Comm * intercomm,
  int * array_of_errcodes
) = NULL;
int MPI_Comm_spawn_multiple(
  int count,
  char ** array_of_commands,
  char *** array_of_argv,
  const int * array_of_maxprocs,
  const MPI_Info * array_of_info,
  int root,
  MPI_Comm comm,
  MPI_Comm * intercomm,
  int * array_of_errcodes
) {
  return (*MPIABI_Comm_spawn_multiple)(
    count,
    array_of_commands,
    array_of_argv,
    array_of_maxprocs,
    (const MPIABI_Info *)array_of_info,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)intercomm,
    array_of_errcodes
  );
}
int PMPI_Comm_spawn_multiple(
  int count,
  char ** array_of_commands,
  char *** array_of_argv,
  const int * array_of_maxprocs,
  const MPI_Info * array_of_info,
  int root,
  MPI_Comm comm,
  MPI_Comm * intercomm,
  int * array_of_errcodes
) {
  return (*MPIABI_Comm_spawn_multiple)(
    count,
    array_of_commands,
    array_of_argv,
    array_of_maxprocs,
    (const MPIABI_Info *)array_of_info,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)intercomm,
    array_of_errcodes
  );
}

int (* MPIABI_Open_port)(
  MPIABI_Info info,
  char * port_name
) = NULL;
int MPI_Open_port(
  MPI_Info info,
  char * port_name
) {
  return (*MPIABI_Open_port)(
    (MPIABI_Info)info,
    port_name
  );
}
int PMPI_Open_port(
  MPI_Info info,
  char * port_name
) {
  return (*MPIABI_Open_port)(
    (MPIABI_Info)info,
    port_name
  );
}

int (* MPIABI_Close_port)(
  const char * port_name
) = NULL;
int MPI_Close_port(
  const char * port_name
) {
  return (*MPIABI_Close_port)(
    port_name
  );
}
int PMPI_Close_port(
  const char * port_name
) {
  return (*MPIABI_Close_port)(
    port_name
  );
}

int (* MPIABI_Comm_accept)(
  const char * port_name,
  MPIABI_Info info,
  int root,
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm
) = NULL;
int MPI_Comm_accept(
  const char * port_name,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_accept)(
    port_name,
    (MPIABI_Info)info,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)newcomm
  );
}
int PMPI_Comm_accept(
  const char * port_name,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_accept)(
    port_name,
    (MPIABI_Info)info,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)newcomm
  );
}

int (* MPIABI_Comm_connect)(
  const char * port_name,
  MPIABI_Info info,
  int root,
  MPIABI_Comm comm,
  MPIABI_Comm * newcomm
) = NULL;
int MPI_Comm_connect(
  const char * port_name,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_connect)(
    port_name,
    (MPIABI_Info)info,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)newcomm
  );
}
int PMPI_Comm_connect(
  const char * port_name,
  MPI_Info info,
  int root,
  MPI_Comm comm,
  MPI_Comm * newcomm
) {
  return (*MPIABI_Comm_connect)(
    port_name,
    (MPIABI_Info)info,
    root,
    (MPIABI_Comm)comm,
    (MPIABI_Comm *)newcomm
  );
}

int (* MPIABI_Publish_name)(
  const char * service_name,
  MPIABI_Info info,
  const char * port_name
) = NULL;
int MPI_Publish_name(
  const char * service_name,
  MPI_Info info,
  const char * port_name
) {
  return (*MPIABI_Publish_name)(
    service_name,
    (MPIABI_Info)info,
    port_name
  );
}
int PMPI_Publish_name(
  const char * service_name,
  MPI_Info info,
  const char * port_name
) {
  return (*MPIABI_Publish_name)(
    service_name,
    (MPIABI_Info)info,
    port_name
  );
}

int (* MPIABI_Unpublish_name)(
  const char * service_name,
  MPIABI_Info info,
  const char * port_name
) = NULL;
int MPI_Unpublish_name(
  const char * service_name,
  MPI_Info info,
  const char * port_name
) {
  return (*MPIABI_Unpublish_name)(
    service_name,
    (MPIABI_Info)info,
    port_name
  );
}
int PMPI_Unpublish_name(
  const char * service_name,
  MPI_Info info,
  const char * port_name
) {
  return (*MPIABI_Unpublish_name)(
    service_name,
    (MPIABI_Info)info,
    port_name
  );
}

int (* MPIABI_Lookup_name)(
  const char * service_name,
  MPIABI_Info info,
  char * port_name
) = NULL;
int MPI_Lookup_name(
  const char * service_name,
  MPI_Info info,
  char * port_name
) {
  return (*MPIABI_Lookup_name)(
    service_name,
    (MPIABI_Info)info,
    port_name
  );
}
int PMPI_Lookup_name(
  const char * service_name,
  MPI_Info info,
  char * port_name
) {
  return (*MPIABI_Lookup_name)(
    service_name,
    (MPIABI_Info)info,
    port_name
  );
}

int (* MPIABI_Comm_disconnect)(
  MPIABI_Comm * comm
) = NULL;
int MPI_Comm_disconnect(
  MPI_Comm * comm
) {
  return (*MPIABI_Comm_disconnect)(
    (MPIABI_Comm *)comm
  );
}
int PMPI_Comm_disconnect(
  MPI_Comm * comm
) {
  return (*MPIABI_Comm_disconnect)(
    (MPIABI_Comm *)comm
  );
}

int (* MPIABI_Comm_join)(
  int fd,
  MPIABI_Comm * intercomm
) = NULL;
int MPI_Comm_join(
  int fd,
  MPI_Comm * intercomm
) {
  return (*MPIABI_Comm_join)(
    fd,
    (MPIABI_Comm *)intercomm
  );
}
int PMPI_Comm_join(
  int fd,
  MPI_Comm * intercomm
) {
  return (*MPIABI_Comm_join)(
    fd,
    (MPIABI_Comm *)intercomm
  );
}

int (* MPIABI_Win_create)(
  void * base,
  MPIABI_Aint size,
  int disp_unit,
  MPIABI_Info info,
  MPIABI_Comm comm,
  MPIABI_Win * win
) = NULL;
int MPI_Win_create(
  void * base,
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  MPI_Win * win
) {
  return (*MPIABI_Win_create)(
    base,
    (MPIABI_Aint)size,
    disp_unit,
    (MPIABI_Info)info,
    (MPIABI_Comm)comm,
    (MPIABI_Win *)win
  );
}
int PMPI_Win_create(
  void * base,
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  MPI_Win * win
) {
  return (*MPIABI_Win_create)(
    base,
    (MPIABI_Aint)size,
    disp_unit,
    (MPIABI_Info)info,
    (MPIABI_Comm)comm,
    (MPIABI_Win *)win
  );
}

int (* MPIABI_Win_allocate)(
  MPIABI_Aint size,
  int disp_unit,
  MPIABI_Info info,
  MPIABI_Comm comm,
  void * baseptr,
  MPIABI_Win * win
) = NULL;
int MPI_Win_allocate(
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  void * baseptr,
  MPI_Win * win
) {
  return (*MPIABI_Win_allocate)(
    (MPIABI_Aint)size,
    disp_unit,
    (MPIABI_Info)info,
    (MPIABI_Comm)comm,
    baseptr,
    (MPIABI_Win *)win
  );
}
int PMPI_Win_allocate(
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  void * baseptr,
  MPI_Win * win
) {
  return (*MPIABI_Win_allocate)(
    (MPIABI_Aint)size,
    disp_unit,
    (MPIABI_Info)info,
    (MPIABI_Comm)comm,
    baseptr,
    (MPIABI_Win *)win
  );
}

int (* MPIABI_Win_allocate_shared)(
  MPIABI_Aint size,
  int disp_unit,
  MPIABI_Info info,
  MPIABI_Comm comm,
  void * baseptr,
  MPIABI_Win * win
) = NULL;
int MPI_Win_allocate_shared(
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  void * baseptr,
  MPI_Win * win
) {
  return (*MPIABI_Win_allocate_shared)(
    (MPIABI_Aint)size,
    disp_unit,
    (MPIABI_Info)info,
    (MPIABI_Comm)comm,
    baseptr,
    (MPIABI_Win *)win
  );
}
int PMPI_Win_allocate_shared(
  MPI_Aint size,
  int disp_unit,
  MPI_Info info,
  MPI_Comm comm,
  void * baseptr,
  MPI_Win * win
) {
  return (*MPIABI_Win_allocate_shared)(
    (MPIABI_Aint)size,
    disp_unit,
    (MPIABI_Info)info,
    (MPIABI_Comm)comm,
    baseptr,
    (MPIABI_Win *)win
  );
}

int (* MPIABI_Win_shared_query)(
  MPIABI_Win win,
  int rank,
  MPIABI_Aint * size,
  int * disp_unit,
  void * baseptr
) = NULL;
int MPI_Win_shared_query(
  MPI_Win win,
  int rank,
  MPI_Aint * size,
  int * disp_unit,
  void * baseptr
) {
  return (*MPIABI_Win_shared_query)(
    (MPIABI_Win)win,
    rank,
    (MPIABI_Aint *)size,
    disp_unit,
    baseptr
  );
}
int PMPI_Win_shared_query(
  MPI_Win win,
  int rank,
  MPI_Aint * size,
  int * disp_unit,
  void * baseptr
) {
  return (*MPIABI_Win_shared_query)(
    (MPIABI_Win)win,
    rank,
    (MPIABI_Aint *)size,
    disp_unit,
    baseptr
  );
}

int (* MPIABI_Win_create_dynamic)(
  MPIABI_Info info,
  MPIABI_Comm comm,
  MPIABI_Win * win
) = NULL;
int MPI_Win_create_dynamic(
  MPI_Info info,
  MPI_Comm comm,
  MPI_Win * win
) {
  return (*MPIABI_Win_create_dynamic)(
    (MPIABI_Info)info,
    (MPIABI_Comm)comm,
    (MPIABI_Win *)win
  );
}
int PMPI_Win_create_dynamic(
  MPI_Info info,
  MPI_Comm comm,
  MPI_Win * win
) {
  return (*MPIABI_Win_create_dynamic)(
    (MPIABI_Info)info,
    (MPIABI_Comm)comm,
    (MPIABI_Win *)win
  );
}

int (* MPIABI_Win_attach)(
  MPIABI_Win win,
  void * base,
  MPIABI_Aint size
) = NULL;
int MPI_Win_attach(
  MPI_Win win,
  void * base,
  MPI_Aint size
) {
  return (*MPIABI_Win_attach)(
    (MPIABI_Win)win,
    base,
    (MPIABI_Aint)size
  );
}
int PMPI_Win_attach(
  MPI_Win win,
  void * base,
  MPI_Aint size
) {
  return (*MPIABI_Win_attach)(
    (MPIABI_Win)win,
    base,
    (MPIABI_Aint)size
  );
}

int (* MPIABI_Win_detach)(
  MPIABI_Win win,
  const void * base
) = NULL;
int MPI_Win_detach(
  MPI_Win win,
  const void * base
) {
  return (*MPIABI_Win_detach)(
    (MPIABI_Win)win,
    base
  );
}
int PMPI_Win_detach(
  MPI_Win win,
  const void * base
) {
  return (*MPIABI_Win_detach)(
    (MPIABI_Win)win,
    base
  );
}

int (* MPIABI_Win_free)(
  MPIABI_Win * win
) = NULL;
int MPI_Win_free(
  MPI_Win * win
) {
  return (*MPIABI_Win_free)(
    (MPIABI_Win *)win
  );
}
int PMPI_Win_free(
  MPI_Win * win
) {
  return (*MPIABI_Win_free)(
    (MPIABI_Win *)win
  );
}

int (* MPIABI_Win_get_group)(
  MPIABI_Win win,
  MPIABI_Group * group
) = NULL;
int MPI_Win_get_group(
  MPI_Win win,
  MPI_Group * group
) {
  return (*MPIABI_Win_get_group)(
    (MPIABI_Win)win,
    (MPIABI_Group *)group
  );
}
int PMPI_Win_get_group(
  MPI_Win win,
  MPI_Group * group
) {
  return (*MPIABI_Win_get_group)(
    (MPIABI_Win)win,
    (MPIABI_Group *)group
  );
}

int (* MPIABI_Win_set_info)(
  MPIABI_Win win,
  MPIABI_Info info
) = NULL;
int MPI_Win_set_info(
  MPI_Win win,
  MPI_Info info
) {
  return (*MPIABI_Win_set_info)(
    (MPIABI_Win)win,
    (MPIABI_Info)info
  );
}
int PMPI_Win_set_info(
  MPI_Win win,
  MPI_Info info
) {
  return (*MPIABI_Win_set_info)(
    (MPIABI_Win)win,
    (MPIABI_Info)info
  );
}

int (* MPIABI_Win_get_info)(
  MPIABI_Win win,
  MPIABI_Info * info_used
) = NULL;
int MPI_Win_get_info(
  MPI_Win win,
  MPI_Info * info_used
) {
  return (*MPIABI_Win_get_info)(
    (MPIABI_Win)win,
    (MPIABI_Info *)info_used
  );
}
int PMPI_Win_get_info(
  MPI_Win win,
  MPI_Info * info_used
) {
  return (*MPIABI_Win_get_info)(
    (MPIABI_Win)win,
    (MPIABI_Info *)info_used
  );
}

int (* MPIABI_Put)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win
) = NULL;
int MPI_Put(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win
) {
  return (*MPIABI_Put)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Win)win
  );
}
int PMPI_Put(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win
) {
  return (*MPIABI_Put)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Get)(
  void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win
) = NULL;
int MPI_Get(
  void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win
) {
  return (*MPIABI_Get)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Win)win
  );
}
int PMPI_Get(
  void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win
) {
  return (*MPIABI_Get)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Accumulate)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win
) = NULL;
int MPI_Accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win
) {
  return (*MPIABI_Accumulate)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Op)op,
    (MPIABI_Win)win
  );
}
int PMPI_Accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win
) {
  return (*MPIABI_Accumulate)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Op)op,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Get_accumulate)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPIABI_Datatype result_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win
) = NULL;
int MPI_Get_accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPI_Datatype result_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win
) {
  return (*MPIABI_Get_accumulate)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    result_addr,
    result_count,
    (MPIABI_Datatype)result_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Op)op,
    (MPIABI_Win)win
  );
}
int PMPI_Get_accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPI_Datatype result_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win
) {
  return (*MPIABI_Get_accumulate)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    result_addr,
    result_count,
    (MPIABI_Datatype)result_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Op)op,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Fetch_and_op)(
  const void * origin_addr,
  void * result_addr,
  MPIABI_Datatype datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  MPIABI_Op op,
  MPIABI_Win win
) = NULL;
int MPI_Fetch_and_op(
  const void * origin_addr,
  void * result_addr,
  MPI_Datatype datatype,
  int target_rank,
  MPI_Aint target_disp,
  MPI_Op op,
  MPI_Win win
) {
  return (*MPIABI_Fetch_and_op)(
    origin_addr,
    result_addr,
    (MPIABI_Datatype)datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    (MPIABI_Op)op,
    (MPIABI_Win)win
  );
}
int PMPI_Fetch_and_op(
  const void * origin_addr,
  void * result_addr,
  MPI_Datatype datatype,
  int target_rank,
  MPI_Aint target_disp,
  MPI_Op op,
  MPI_Win win
) {
  return (*MPIABI_Fetch_and_op)(
    origin_addr,
    result_addr,
    (MPIABI_Datatype)datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    (MPIABI_Op)op,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Compare_and_swap)(
  const void * origin_addr,
  const void * compare_addr,
  void * result_addr,
  MPIABI_Datatype datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  MPIABI_Win win
) = NULL;
int MPI_Compare_and_swap(
  const void * origin_addr,
  const void * compare_addr,
  void * result_addr,
  MPI_Datatype datatype,
  int target_rank,
  MPI_Aint target_disp,
  MPI_Win win
) {
  return (*MPIABI_Compare_and_swap)(
    origin_addr,
    compare_addr,
    result_addr,
    (MPIABI_Datatype)datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    (MPIABI_Win)win
  );
}
int PMPI_Compare_and_swap(
  const void * origin_addr,
  const void * compare_addr,
  void * result_addr,
  MPI_Datatype datatype,
  int target_rank,
  MPI_Aint target_disp,
  MPI_Win win
) {
  return (*MPIABI_Compare_and_swap)(
    origin_addr,
    compare_addr,
    result_addr,
    (MPIABI_Datatype)datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Rput)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win,
  MPIABI_Request * request
) = NULL;
int MPI_Rput(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win,
  MPI_Request * request
) {
  return (*MPIABI_Rput)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Win)win,
    (MPIABI_Request *)request
  );
}
int PMPI_Rput(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win,
  MPI_Request * request
) {
  return (*MPIABI_Rput)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Win)win,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Rget)(
  void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Win win,
  MPIABI_Request * request
) = NULL;
int MPI_Rget(
  void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win,
  MPI_Request * request
) {
  return (*MPIABI_Rget)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Win)win,
    (MPIABI_Request *)request
  );
}
int PMPI_Rget(
  void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Win win,
  MPI_Request * request
) {
  return (*MPIABI_Rget)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Win)win,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Raccumulate)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win,
  MPIABI_Request * request
) = NULL;
int MPI_Raccumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win,
  MPI_Request * request
) {
  return (*MPIABI_Raccumulate)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Op)op,
    (MPIABI_Win)win,
    (MPIABI_Request *)request
  );
}
int PMPI_Raccumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win,
  MPI_Request * request
) {
  return (*MPIABI_Raccumulate)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Op)op,
    (MPIABI_Win)win,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Rget_accumulate)(
  const void * origin_addr,
  int origin_count,
  MPIABI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPIABI_Datatype result_datatype,
  int target_rank,
  MPIABI_Aint target_disp,
  int target_count,
  MPIABI_Datatype target_datatype,
  MPIABI_Op op,
  MPIABI_Win win,
  MPIABI_Request * request
) = NULL;
int MPI_Rget_accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPI_Datatype result_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win,
  MPI_Request * request
) {
  return (*MPIABI_Rget_accumulate)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    result_addr,
    result_count,
    (MPIABI_Datatype)result_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Op)op,
    (MPIABI_Win)win,
    (MPIABI_Request *)request
  );
}
int PMPI_Rget_accumulate(
  const void * origin_addr,
  int origin_count,
  MPI_Datatype origin_datatype,
  void * result_addr,
  int result_count,
  MPI_Datatype result_datatype,
  int target_rank,
  MPI_Aint target_disp,
  int target_count,
  MPI_Datatype target_datatype,
  MPI_Op op,
  MPI_Win win,
  MPI_Request * request
) {
  return (*MPIABI_Rget_accumulate)(
    origin_addr,
    origin_count,
    (MPIABI_Datatype)origin_datatype,
    result_addr,
    result_count,
    (MPIABI_Datatype)result_datatype,
    target_rank,
    (MPIABI_Aint)target_disp,
    target_count,
    (MPIABI_Datatype)target_datatype,
    (MPIABI_Op)op,
    (MPIABI_Win)win,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Win_fence)(
  int assert,
  MPIABI_Win win
) = NULL;
int MPI_Win_fence(
  int assert,
  MPI_Win win
) {
  return (*MPIABI_Win_fence)(
    assert,
    (MPIABI_Win)win
  );
}
int PMPI_Win_fence(
  int assert,
  MPI_Win win
) {
  return (*MPIABI_Win_fence)(
    assert,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_start)(
  MPIABI_Group group,
  int assert,
  MPIABI_Win win
) = NULL;
int MPI_Win_start(
  MPI_Group group,
  int assert,
  MPI_Win win
) {
  return (*MPIABI_Win_start)(
    (MPIABI_Group)group,
    assert,
    (MPIABI_Win)win
  );
}
int PMPI_Win_start(
  MPI_Group group,
  int assert,
  MPI_Win win
) {
  return (*MPIABI_Win_start)(
    (MPIABI_Group)group,
    assert,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_complete)(
  MPIABI_Win win
) = NULL;
int MPI_Win_complete(
  MPI_Win win
) {
  return (*MPIABI_Win_complete)(
    (MPIABI_Win)win
  );
}
int PMPI_Win_complete(
  MPI_Win win
) {
  return (*MPIABI_Win_complete)(
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_post)(
  MPIABI_Group group,
  int assert,
  MPIABI_Win win
) = NULL;
int MPI_Win_post(
  MPI_Group group,
  int assert,
  MPI_Win win
) {
  return (*MPIABI_Win_post)(
    (MPIABI_Group)group,
    assert,
    (MPIABI_Win)win
  );
}
int PMPI_Win_post(
  MPI_Group group,
  int assert,
  MPI_Win win
) {
  return (*MPIABI_Win_post)(
    (MPIABI_Group)group,
    assert,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_wait)(
  MPIABI_Win win
) = NULL;
int MPI_Win_wait(
  MPI_Win win
) {
  return (*MPIABI_Win_wait)(
    (MPIABI_Win)win
  );
}
int PMPI_Win_wait(
  MPI_Win win
) {
  return (*MPIABI_Win_wait)(
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_test)(
  MPIABI_Win win,
  int * flag
) = NULL;
int MPI_Win_test(
  MPI_Win win,
  int * flag
) {
  return (*MPIABI_Win_test)(
    (MPIABI_Win)win,
    flag
  );
}
int PMPI_Win_test(
  MPI_Win win,
  int * flag
) {
  return (*MPIABI_Win_test)(
    (MPIABI_Win)win,
    flag
  );
}

int (* MPIABI_Win_lock)(
  int lock_type,
  int rank,
  int assert,
  MPIABI_Win win
) = NULL;
int MPI_Win_lock(
  int lock_type,
  int rank,
  int assert,
  MPI_Win win
) {
  return (*MPIABI_Win_lock)(
    lock_type,
    rank,
    assert,
    (MPIABI_Win)win
  );
}
int PMPI_Win_lock(
  int lock_type,
  int rank,
  int assert,
  MPI_Win win
) {
  return (*MPIABI_Win_lock)(
    lock_type,
    rank,
    assert,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_lock_all)(
  int assert,
  MPIABI_Win win
) = NULL;
int MPI_Win_lock_all(
  int assert,
  MPI_Win win
) {
  return (*MPIABI_Win_lock_all)(
    assert,
    (MPIABI_Win)win
  );
}
int PMPI_Win_lock_all(
  int assert,
  MPI_Win win
) {
  return (*MPIABI_Win_lock_all)(
    assert,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_unlock)(
  int rank,
  MPIABI_Win win
) = NULL;
int MPI_Win_unlock(
  int rank,
  MPI_Win win
) {
  return (*MPIABI_Win_unlock)(
    rank,
    (MPIABI_Win)win
  );
}
int PMPI_Win_unlock(
  int rank,
  MPI_Win win
) {
  return (*MPIABI_Win_unlock)(
    rank,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_unlock_all)(
  MPIABI_Win win
) = NULL;
int MPI_Win_unlock_all(
  MPI_Win win
) {
  return (*MPIABI_Win_unlock_all)(
    (MPIABI_Win)win
  );
}
int PMPI_Win_unlock_all(
  MPI_Win win
) {
  return (*MPIABI_Win_unlock_all)(
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_flush)(
  int rank,
  MPIABI_Win win
) = NULL;
int MPI_Win_flush(
  int rank,
  MPI_Win win
) {
  return (*MPIABI_Win_flush)(
    rank,
    (MPIABI_Win)win
  );
}
int PMPI_Win_flush(
  int rank,
  MPI_Win win
) {
  return (*MPIABI_Win_flush)(
    rank,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_flush_all)(
  MPIABI_Win win
) = NULL;
int MPI_Win_flush_all(
  MPI_Win win
) {
  return (*MPIABI_Win_flush_all)(
    (MPIABI_Win)win
  );
}
int PMPI_Win_flush_all(
  MPI_Win win
) {
  return (*MPIABI_Win_flush_all)(
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_flush_local)(
  int rank,
  MPIABI_Win win
) = NULL;
int MPI_Win_flush_local(
  int rank,
  MPI_Win win
) {
  return (*MPIABI_Win_flush_local)(
    rank,
    (MPIABI_Win)win
  );
}
int PMPI_Win_flush_local(
  int rank,
  MPI_Win win
) {
  return (*MPIABI_Win_flush_local)(
    rank,
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_flush_local_all)(
  MPIABI_Win win
) = NULL;
int MPI_Win_flush_local_all(
  MPI_Win win
) {
  return (*MPIABI_Win_flush_local_all)(
    (MPIABI_Win)win
  );
}
int PMPI_Win_flush_local_all(
  MPI_Win win
) {
  return (*MPIABI_Win_flush_local_all)(
    (MPIABI_Win)win
  );
}

int (* MPIABI_Win_sync)(
  MPIABI_Win win
) = NULL;
int MPI_Win_sync(
  MPI_Win win
) {
  return (*MPIABI_Win_sync)(
    (MPIABI_Win)win
  );
}
int PMPI_Win_sync(
  MPI_Win win
) {
  return (*MPIABI_Win_sync)(
    (MPIABI_Win)win
  );
}

int (* MPIABI_Grequest_start)(
  MPIABI_Grequest_query_function * query_fn,
  MPIABI_Grequest_free_function * free_fn,
  MPIABI_Grequest_cancel_function * cancel_fn,
  void * extra_state,
  MPIABI_Request * request
) = NULL;
int MPI_Grequest_start(
  MPI_Grequest_query_function * query_fn,
  MPI_Grequest_free_function * free_fn,
  MPI_Grequest_cancel_function * cancel_fn,
  void * extra_state,
  MPI_Request * request
) {
  return (*MPIABI_Grequest_start)(
    (MPIABI_Grequest_query_function *)query_fn,
    (MPIABI_Grequest_free_function *)free_fn,
    (MPIABI_Grequest_cancel_function *)cancel_fn,
    extra_state,
    (MPIABI_Request *)request
  );
}
int PMPI_Grequest_start(
  MPI_Grequest_query_function * query_fn,
  MPI_Grequest_free_function * free_fn,
  MPI_Grequest_cancel_function * cancel_fn,
  void * extra_state,
  MPI_Request * request
) {
  return (*MPIABI_Grequest_start)(
    (MPIABI_Grequest_query_function *)query_fn,
    (MPIABI_Grequest_free_function *)free_fn,
    (MPIABI_Grequest_cancel_function *)cancel_fn,
    extra_state,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_Grequest_complete)(
  MPIABI_Request request
) = NULL;
int MPI_Grequest_complete(
  MPI_Request request
) {
  return (*MPIABI_Grequest_complete)(
    (MPIABI_Request)request
  );
}
int PMPI_Grequest_complete(
  MPI_Request request
) {
  return (*MPIABI_Grequest_complete)(
    (MPIABI_Request)request
  );
}

int (* MPIABI_Status_set_elements)(
  MPIABI_Status * status,
  MPIABI_Datatype datatype,
  int count
) = NULL;
int MPI_Status_set_elements(
  MPI_Status * status,
  MPI_Datatype datatype,
  int count
) {
  return (*MPIABI_Status_set_elements)(
    (MPIABI_Status *)status,
    (MPIABI_Datatype)datatype,
    count
  );
}
int PMPI_Status_set_elements(
  MPI_Status * status,
  MPI_Datatype datatype,
  int count
) {
  return (*MPIABI_Status_set_elements)(
    (MPIABI_Status *)status,
    (MPIABI_Datatype)datatype,
    count
  );
}

int (* MPIABI_Status_set_elements_x)(
  MPIABI_Status * status,
  MPIABI_Datatype datatype,
  MPIABI_Count count
) = NULL;
int MPI_Status_set_elements_x(
  MPI_Status * status,
  MPI_Datatype datatype,
  MPI_Count count
) {
  return (*MPIABI_Status_set_elements_x)(
    (MPIABI_Status *)status,
    (MPIABI_Datatype)datatype,
    (MPIABI_Count)count
  );
}
int PMPI_Status_set_elements_x(
  MPI_Status * status,
  MPI_Datatype datatype,
  MPI_Count count
) {
  return (*MPIABI_Status_set_elements_x)(
    (MPIABI_Status *)status,
    (MPIABI_Datatype)datatype,
    (MPIABI_Count)count
  );
}

int (* MPIABI_Status_set_cancelled)(
  MPIABI_Status * status,
  int flag
) = NULL;
int MPI_Status_set_cancelled(
  MPI_Status * status,
  int flag
) {
  return (*MPIABI_Status_set_cancelled)(
    (MPIABI_Status *)status,
    flag
  );
}
int PMPI_Status_set_cancelled(
  MPI_Status * status,
  int flag
) {
  return (*MPIABI_Status_set_cancelled)(
    (MPIABI_Status *)status,
    flag
  );
}

int (* MPIABI_Init_thread)(
  int * argc,
  char * * * argv,
  int required,
  int * provided
) = NULL;
int MPI_Init_thread(
  int * argc,
  char * * * argv,
  int required,
  int * provided
) {
  return (*MPIABI_Init_thread)(
    argc,
    argv,
    required,
    provided
  );
}
int PMPI_Init_thread(
  int * argc,
  char * * * argv,
  int required,
  int * provided
) {
  return (*MPIABI_Init_thread)(
    argc,
    argv,
    required,
    provided
  );
}

int (* MPIABI_Query_thread)(
  int * provided
) = NULL;
int MPI_Query_thread(
  int * provided
) {
  return (*MPIABI_Query_thread)(
    provided
  );
}
int PMPI_Query_thread(
  int * provided
) {
  return (*MPIABI_Query_thread)(
    provided
  );
}

int (* MPIABI_Is_thread_main)(
  int * flag
) = NULL;
int MPI_Is_thread_main(
  int * flag
) {
  return (*MPIABI_Is_thread_main)(
    flag
  );
}
int PMPI_Is_thread_main(
  int * flag
) {
  return (*MPIABI_Is_thread_main)(
    flag
  );
}

int (* MPIABI_File_open)(
  MPIABI_Comm comm,
  const char * filename,
  int amode,
  MPIABI_Info info,
  MPIABI_File * fh
) = NULL;
int MPI_File_open(
  MPI_Comm comm,
  const char * filename,
  int amode,
  MPI_Info info,
  MPI_File * fh
) {
  return (*MPIABI_File_open)(
    (MPIABI_Comm)comm,
    filename,
    amode,
    (MPIABI_Info)info,
    (MPIABI_File *)fh
  );
}
int PMPI_File_open(
  MPI_Comm comm,
  const char * filename,
  int amode,
  MPI_Info info,
  MPI_File * fh
) {
  return (*MPIABI_File_open)(
    (MPIABI_Comm)comm,
    filename,
    amode,
    (MPIABI_Info)info,
    (MPIABI_File *)fh
  );
}

int (* MPIABI_File_close)(
  MPIABI_File * fh
) = NULL;
int MPI_File_close(
  MPI_File * fh
) {
  return (*MPIABI_File_close)(
    (MPIABI_File *)fh
  );
}
int PMPI_File_close(
  MPI_File * fh
) {
  return (*MPIABI_File_close)(
    (MPIABI_File *)fh
  );
}

int (* MPIABI_File_delete)(
  const char * filename,
  MPIABI_Info info
) = NULL;
int MPI_File_delete(
  const char * filename,
  MPI_Info info
) {
  return (*MPIABI_File_delete)(
    filename,
    (MPIABI_Info)info
  );
}
int PMPI_File_delete(
  const char * filename,
  MPI_Info info
) {
  return (*MPIABI_File_delete)(
    filename,
    (MPIABI_Info)info
  );
}

int (* MPIABI_File_set_size)(
  MPIABI_File fh,
  MPIABI_Offset size
) = NULL;
int MPI_File_set_size(
  MPI_File fh,
  MPI_Offset size
) {
  return (*MPIABI_File_set_size)(
    (MPIABI_File)fh,
    (MPIABI_Offset)size
  );
}
int PMPI_File_set_size(
  MPI_File fh,
  MPI_Offset size
) {
  return (*MPIABI_File_set_size)(
    (MPIABI_File)fh,
    (MPIABI_Offset)size
  );
}

int (* MPIABI_File_preallocate)(
  MPIABI_File fh,
  MPIABI_Offset size
) = NULL;
int MPI_File_preallocate(
  MPI_File fh,
  MPI_Offset size
) {
  return (*MPIABI_File_preallocate)(
    (MPIABI_File)fh,
    (MPIABI_Offset)size
  );
}
int PMPI_File_preallocate(
  MPI_File fh,
  MPI_Offset size
) {
  return (*MPIABI_File_preallocate)(
    (MPIABI_File)fh,
    (MPIABI_Offset)size
  );
}

int (* MPIABI_File_get_size)(
  MPIABI_File fh,
  MPIABI_Offset * size
) = NULL;
int MPI_File_get_size(
  MPI_File fh,
  MPI_Offset * size
) {
  return (*MPIABI_File_get_size)(
    (MPIABI_File)fh,
    (MPIABI_Offset *)size
  );
}
int PMPI_File_get_size(
  MPI_File fh,
  MPI_Offset * size
) {
  return (*MPIABI_File_get_size)(
    (MPIABI_File)fh,
    (MPIABI_Offset *)size
  );
}

int (* MPIABI_File_get_group)(
  MPIABI_File fh,
  MPIABI_Group * group
) = NULL;
int MPI_File_get_group(
  MPI_File fh,
  MPI_Group * group
) {
  return (*MPIABI_File_get_group)(
    (MPIABI_File)fh,
    (MPIABI_Group *)group
  );
}
int PMPI_File_get_group(
  MPI_File fh,
  MPI_Group * group
) {
  return (*MPIABI_File_get_group)(
    (MPIABI_File)fh,
    (MPIABI_Group *)group
  );
}

int (* MPIABI_File_get_amode)(
  MPIABI_File fh,
  int * amode
) = NULL;
int MPI_File_get_amode(
  MPI_File fh,
  int * amode
) {
  return (*MPIABI_File_get_amode)(
    (MPIABI_File)fh,
    amode
  );
}
int PMPI_File_get_amode(
  MPI_File fh,
  int * amode
) {
  return (*MPIABI_File_get_amode)(
    (MPIABI_File)fh,
    amode
  );
}

int (* MPIABI_File_set_info)(
  MPIABI_File fh,
  MPIABI_Info info
) = NULL;
int MPI_File_set_info(
  MPI_File fh,
  MPI_Info info
) {
  return (*MPIABI_File_set_info)(
    (MPIABI_File)fh,
    (MPIABI_Info)info
  );
}
int PMPI_File_set_info(
  MPI_File fh,
  MPI_Info info
) {
  return (*MPIABI_File_set_info)(
    (MPIABI_File)fh,
    (MPIABI_Info)info
  );
}

int (* MPIABI_File_get_info)(
  MPIABI_File fh,
  MPIABI_Info * info_used
) = NULL;
int MPI_File_get_info(
  MPI_File fh,
  MPI_Info * info_used
) {
  return (*MPIABI_File_get_info)(
    (MPIABI_File)fh,
    (MPIABI_Info *)info_used
  );
}
int PMPI_File_get_info(
  MPI_File fh,
  MPI_Info * info_used
) {
  return (*MPIABI_File_get_info)(
    (MPIABI_File)fh,
    (MPIABI_Info *)info_used
  );
}

int (* MPIABI_File_set_view)(
  MPIABI_File fh,
  MPIABI_Offset disp,
  MPIABI_Datatype etype,
  MPIABI_Datatype filetype,
  const char * datarep,
  MPIABI_Info info
) = NULL;
int MPI_File_set_view(
  MPI_File fh,
  MPI_Offset disp,
  MPI_Datatype etype,
  MPI_Datatype filetype,
  const char * datarep,
  MPI_Info info
) {
  return (*MPIABI_File_set_view)(
    (MPIABI_File)fh,
    (MPIABI_Offset)disp,
    (MPIABI_Datatype)etype,
    (MPIABI_Datatype)filetype,
    datarep,
    (MPIABI_Info)info
  );
}
int PMPI_File_set_view(
  MPI_File fh,
  MPI_Offset disp,
  MPI_Datatype etype,
  MPI_Datatype filetype,
  const char * datarep,
  MPI_Info info
) {
  return (*MPIABI_File_set_view)(
    (MPIABI_File)fh,
    (MPIABI_Offset)disp,
    (MPIABI_Datatype)etype,
    (MPIABI_Datatype)filetype,
    datarep,
    (MPIABI_Info)info
  );
}

int (* MPIABI_File_get_view)(
  MPIABI_File fh,
  MPIABI_Offset * disp,
  MPIABI_Datatype * etype,
  MPIABI_Datatype * filetype,
  char * datarep
) = NULL;
int MPI_File_get_view(
  MPI_File fh,
  MPI_Offset * disp,
  MPI_Datatype * etype,
  MPI_Datatype * filetype,
  char * datarep
) {
  return (*MPIABI_File_get_view)(
    (MPIABI_File)fh,
    (MPIABI_Offset *)disp,
    (MPIABI_Datatype *)etype,
    (MPIABI_Datatype *)filetype,
    datarep
  );
}
int PMPI_File_get_view(
  MPI_File fh,
  MPI_Offset * disp,
  MPI_Datatype * etype,
  MPI_Datatype * filetype,
  char * datarep
) {
  return (*MPIABI_File_get_view)(
    (MPIABI_File)fh,
    (MPIABI_Offset *)disp,
    (MPIABI_Datatype *)etype,
    (MPIABI_Datatype *)filetype,
    datarep
  );
}

int (* MPIABI_File_read_at)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_read_at(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read_at)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_read_at(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read_at)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_read_at_all)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_read_at_all(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read_at_all)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_read_at_all(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read_at_all)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_write_at)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_write_at(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write_at)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_write_at(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write_at)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_write_at_all)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_write_at_all(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write_at_all)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_write_at_all(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write_at_all)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_iread_at)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) = NULL;
int MPI_File_iread_at(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iread_at)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}
int PMPI_File_iread_at(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iread_at)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_File_iread_at_all)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) = NULL;
int MPI_File_iread_at_all(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iread_at_all)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}
int PMPI_File_iread_at_all(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iread_at_all)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_File_iwrite_at)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) = NULL;
int MPI_File_iwrite_at(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iwrite_at)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}
int PMPI_File_iwrite_at(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iwrite_at)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_File_iwrite_at_all)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) = NULL;
int MPI_File_iwrite_at_all(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iwrite_at_all)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}
int PMPI_File_iwrite_at_all(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iwrite_at_all)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_File_read)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_read(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_read(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_read_all)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_read_all(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read_all)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_read_all(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read_all)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_write)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_write(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_write(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_write_all)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_write_all(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write_all)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_write_all(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write_all)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_iread)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) = NULL;
int MPI_File_iread(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iread)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}
int PMPI_File_iread(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iread)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_File_iread_all)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) = NULL;
int MPI_File_iread_all(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iread_all)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}
int PMPI_File_iread_all(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iread_all)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_File_iwrite)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) = NULL;
int MPI_File_iwrite(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iwrite)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}
int PMPI_File_iwrite(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iwrite)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_File_iwrite_all)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) = NULL;
int MPI_File_iwrite_all(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iwrite_all)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}
int PMPI_File_iwrite_all(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iwrite_all)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_File_seek)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  int whence
) = NULL;
int MPI_File_seek(
  MPI_File fh,
  MPI_Offset offset,
  int whence
) {
  return (*MPIABI_File_seek)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    whence
  );
}
int PMPI_File_seek(
  MPI_File fh,
  MPI_Offset offset,
  int whence
) {
  return (*MPIABI_File_seek)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    whence
  );
}

int (* MPIABI_File_get_position)(
  MPIABI_File fh,
  MPIABI_Offset * offset
) = NULL;
int MPI_File_get_position(
  MPI_File fh,
  MPI_Offset * offset
) {
  return (*MPIABI_File_get_position)(
    (MPIABI_File)fh,
    (MPIABI_Offset *)offset
  );
}
int PMPI_File_get_position(
  MPI_File fh,
  MPI_Offset * offset
) {
  return (*MPIABI_File_get_position)(
    (MPIABI_File)fh,
    (MPIABI_Offset *)offset
  );
}

int (* MPIABI_File_get_byte_offset)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  MPIABI_Offset * disp
) = NULL;
int MPI_File_get_byte_offset(
  MPI_File fh,
  MPI_Offset offset,
  MPI_Offset * disp
) {
  return (*MPIABI_File_get_byte_offset)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    (MPIABI_Offset *)disp
  );
}
int PMPI_File_get_byte_offset(
  MPI_File fh,
  MPI_Offset offset,
  MPI_Offset * disp
) {
  return (*MPIABI_File_get_byte_offset)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    (MPIABI_Offset *)disp
  );
}

int (* MPIABI_File_read_shared)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_read_shared(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read_shared)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_read_shared(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read_shared)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_write_shared)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_write_shared(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write_shared)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_write_shared(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write_shared)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_iread_shared)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) = NULL;
int MPI_File_iread_shared(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iread_shared)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}
int PMPI_File_iread_shared(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iread_shared)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_File_iwrite_shared)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Request * request
) = NULL;
int MPI_File_iwrite_shared(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iwrite_shared)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}
int PMPI_File_iwrite_shared(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Request * request
) {
  return (*MPIABI_File_iwrite_shared)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Request *)request
  );
}

int (* MPIABI_File_read_ordered)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_read_ordered(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read_ordered)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_read_ordered(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_read_ordered)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_write_ordered)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype,
  MPIABI_Status * status
) = NULL;
int MPI_File_write_ordered(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write_ordered)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}
int PMPI_File_write_ordered(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype,
  MPI_Status * status
) {
  return (*MPIABI_File_write_ordered)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_seek_shared)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  int whence
) = NULL;
int MPI_File_seek_shared(
  MPI_File fh,
  MPI_Offset offset,
  int whence
) {
  return (*MPIABI_File_seek_shared)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    whence
  );
}
int PMPI_File_seek_shared(
  MPI_File fh,
  MPI_Offset offset,
  int whence
) {
  return (*MPIABI_File_seek_shared)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    whence
  );
}

int (* MPIABI_File_get_position_shared)(
  MPIABI_File fh,
  MPIABI_Offset * offset
) = NULL;
int MPI_File_get_position_shared(
  MPI_File fh,
  MPI_Offset * offset
) {
  return (*MPIABI_File_get_position_shared)(
    (MPIABI_File)fh,
    (MPIABI_Offset *)offset
  );
}
int PMPI_File_get_position_shared(
  MPI_File fh,
  MPI_Offset * offset
) {
  return (*MPIABI_File_get_position_shared)(
    (MPIABI_File)fh,
    (MPIABI_Offset *)offset
  );
}

int (* MPIABI_File_read_at_all_begin)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  void * buf,
  int count,
  MPIABI_Datatype datatype
) = NULL;
int MPI_File_read_at_all_begin(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_read_at_all_begin)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}
int PMPI_File_read_at_all_begin(
  MPI_File fh,
  MPI_Offset offset,
  void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_read_at_all_begin)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}

int (* MPIABI_File_read_at_all_end)(
  MPIABI_File fh,
  void * buf,
  MPIABI_Status * status
) = NULL;
int MPI_File_read_at_all_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_read_at_all_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}
int PMPI_File_read_at_all_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_read_at_all_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_write_at_all_begin)(
  MPIABI_File fh,
  MPIABI_Offset offset,
  const void * buf,
  int count,
  MPIABI_Datatype datatype
) = NULL;
int MPI_File_write_at_all_begin(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_write_at_all_begin)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}
int PMPI_File_write_at_all_begin(
  MPI_File fh,
  MPI_Offset offset,
  const void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_write_at_all_begin)(
    (MPIABI_File)fh,
    (MPIABI_Offset)offset,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}

int (* MPIABI_File_write_at_all_end)(
  MPIABI_File fh,
  const void * buf,
  MPIABI_Status * status
) = NULL;
int MPI_File_write_at_all_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_write_at_all_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}
int PMPI_File_write_at_all_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_write_at_all_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_read_all_begin)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype
) = NULL;
int MPI_File_read_all_begin(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_read_all_begin)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}
int PMPI_File_read_all_begin(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_read_all_begin)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}

int (* MPIABI_File_read_all_end)(
  MPIABI_File fh,
  void * buf,
  MPIABI_Status * status
) = NULL;
int MPI_File_read_all_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_read_all_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}
int PMPI_File_read_all_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_read_all_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_write_all_begin)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype
) = NULL;
int MPI_File_write_all_begin(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_write_all_begin)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}
int PMPI_File_write_all_begin(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_write_all_begin)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}

int (* MPIABI_File_write_all_end)(
  MPIABI_File fh,
  const void * buf,
  MPIABI_Status * status
) = NULL;
int MPI_File_write_all_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_write_all_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}
int PMPI_File_write_all_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_write_all_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_read_ordered_begin)(
  MPIABI_File fh,
  void * buf,
  int count,
  MPIABI_Datatype datatype
) = NULL;
int MPI_File_read_ordered_begin(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_read_ordered_begin)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}
int PMPI_File_read_ordered_begin(
  MPI_File fh,
  void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_read_ordered_begin)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}

int (* MPIABI_File_read_ordered_end)(
  MPIABI_File fh,
  void * buf,
  MPIABI_Status * status
) = NULL;
int MPI_File_read_ordered_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_read_ordered_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}
int PMPI_File_read_ordered_end(
  MPI_File fh,
  void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_read_ordered_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_write_ordered_begin)(
  MPIABI_File fh,
  const void * buf,
  int count,
  MPIABI_Datatype datatype
) = NULL;
int MPI_File_write_ordered_begin(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_write_ordered_begin)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}
int PMPI_File_write_ordered_begin(
  MPI_File fh,
  const void * buf,
  int count,
  MPI_Datatype datatype
) {
  return (*MPIABI_File_write_ordered_begin)(
    (MPIABI_File)fh,
    buf,
    count,
    (MPIABI_Datatype)datatype
  );
}

int (* MPIABI_File_write_ordered_end)(
  MPIABI_File fh,
  const void * buf,
  MPIABI_Status * status
) = NULL;
int MPI_File_write_ordered_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_write_ordered_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}
int PMPI_File_write_ordered_end(
  MPI_File fh,
  const void * buf,
  MPI_Status * status
) {
  return (*MPIABI_File_write_ordered_end)(
    (MPIABI_File)fh,
    buf,
    (MPIABI_Status *)status
  );
}

int (* MPIABI_File_get_type_extent)(
  MPIABI_File fh,
  MPIABI_Datatype datatype,
  MPIABI_Aint * extent
) = NULL;
int MPI_File_get_type_extent(
  MPI_File fh,
  MPI_Datatype datatype,
  MPI_Aint * extent
) {
  return (*MPIABI_File_get_type_extent)(
    (MPIABI_File)fh,
    (MPIABI_Datatype)datatype,
    (MPIABI_Aint *)extent
  );
}
int PMPI_File_get_type_extent(
  MPI_File fh,
  MPI_Datatype datatype,
  MPI_Aint * extent
) {
  return (*MPIABI_File_get_type_extent)(
    (MPIABI_File)fh,
    (MPIABI_Datatype)datatype,
    (MPIABI_Aint *)extent
  );
}

int (* MPIABI_Register_datarep)(
  const char * datarep,
  MPIABI_Datarep_conversion_function * read_conversion_fn,
  MPIABI_Datarep_conversion_function * write_conversion_fn,
  MPIABI_Datarep_extent_function * dtype_file_extent_fn,
  void * extra_state
) = NULL;
int MPI_Register_datarep(
  const char * datarep,
  MPI_Datarep_conversion_function * read_conversion_fn,
  MPI_Datarep_conversion_function * write_conversion_fn,
  MPI_Datarep_extent_function * dtype_file_extent_fn,
  void * extra_state
) {
  return (*MPIABI_Register_datarep)(
    datarep,
    (MPIABI_Datarep_conversion_function *)read_conversion_fn,
    (MPIABI_Datarep_conversion_function *)write_conversion_fn,
    (MPIABI_Datarep_extent_function *)dtype_file_extent_fn,
    extra_state
  );
}
int PMPI_Register_datarep(
  const char * datarep,
  MPI_Datarep_conversion_function * read_conversion_fn,
  MPI_Datarep_conversion_function * write_conversion_fn,
  MPI_Datarep_extent_function * dtype_file_extent_fn,
  void * extra_state
) {
  return (*MPIABI_Register_datarep)(
    datarep,
    (MPIABI_Datarep_conversion_function *)read_conversion_fn,
    (MPIABI_Datarep_conversion_function *)write_conversion_fn,
    (MPIABI_Datarep_extent_function *)dtype_file_extent_fn,
    extra_state
  );
}

int (* MPIABI_File_set_atomicity)(
  MPIABI_File fh,
  int flag
) = NULL;
int MPI_File_set_atomicity(
  MPI_File fh,
  int flag
) {
  return (*MPIABI_File_set_atomicity)(
    (MPIABI_File)fh,
    flag
  );
}
int PMPI_File_set_atomicity(
  MPI_File fh,
  int flag
) {
  return (*MPIABI_File_set_atomicity)(
    (MPIABI_File)fh,
    flag
  );
}

int (* MPIABI_File_get_atomicity)(
  MPIABI_File fh,
  int * flag
) = NULL;
int MPI_File_get_atomicity(
  MPI_File fh,
  int * flag
) {
  return (*MPIABI_File_get_atomicity)(
    (MPIABI_File)fh,
    flag
  );
}
int PMPI_File_get_atomicity(
  MPI_File fh,
  int * flag
) {
  return (*MPIABI_File_get_atomicity)(
    (MPIABI_File)fh,
    flag
  );
}

int (* MPIABI_File_sync)(
  MPIABI_File fh
) = NULL;
int MPI_File_sync(
  MPI_File fh
) {
  return (*MPIABI_File_sync)(
    (MPIABI_File)fh
  );
}
int PMPI_File_sync(
  MPI_File fh
) {
  return (*MPIABI_File_sync)(
    (MPIABI_File)fh
  );
}

int (* MPIABI_Type_create_f90_real)(
  int precision,
  int range,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_create_f90_real(
  int precision,
  int range,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_f90_real)(
    precision,
    range,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_create_f90_real(
  int precision,
  int range,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_f90_real)(
    precision,
    range,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_create_f90_complex)(
  int precision,
  int range,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_create_f90_complex(
  int precision,
  int range,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_f90_complex)(
    precision,
    range,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_create_f90_complex(
  int precision,
  int range,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_f90_complex)(
    precision,
    range,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_create_f90_integer)(
  int range,
  MPIABI_Datatype * newtype
) = NULL;
int MPI_Type_create_f90_integer(
  int range,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_f90_integer)(
    range,
    (MPIABI_Datatype *)newtype
  );
}
int PMPI_Type_create_f90_integer(
  int range,
  MPI_Datatype * newtype
) {
  return (*MPIABI_Type_create_f90_integer)(
    range,
    (MPIABI_Datatype *)newtype
  );
}

int (* MPIABI_Type_match_size)(
  int typeclass,
  int size,
  MPIABI_Datatype * datatype
) = NULL;
int MPI_Type_match_size(
  int typeclass,
  int size,
  MPI_Datatype * datatype
) {
  return (*MPIABI_Type_match_size)(
    typeclass,
    size,
    (MPIABI_Datatype *)datatype
  );
}
int PMPI_Type_match_size(
  int typeclass,
  int size,
  MPI_Datatype * datatype
) {
  return (*MPIABI_Type_match_size)(
    typeclass,
    size,
    (MPIABI_Datatype *)datatype
  );
}

MPIABI_Comm (* MPIABI_Comm_f2c)(
  MPIABI_Fint comm
) = NULL;
MPI_Comm MPI_Comm_f2c(
  MPI_Fint comm
) {
  return (MPI_Comm)(*MPIABI_Comm_f2c)(
    (MPIABI_Fint)comm
  );
}
MPI_Comm PMPI_Comm_f2c(
  MPI_Fint comm
) {
  return (MPI_Comm)(*MPIABI_Comm_f2c)(
    (MPIABI_Fint)comm
  );
}

MPIABI_Fint (* MPIABI_Comm_c2f)(
  MPIABI_Comm comm
) = NULL;
MPI_Fint MPI_Comm_c2f(
  MPI_Comm comm
) {
  return (MPI_Fint)(*MPIABI_Comm_c2f)(
    (MPIABI_Comm)comm
  );
}
MPI_Fint PMPI_Comm_c2f(
  MPI_Comm comm
) {
  return (MPI_Fint)(*MPIABI_Comm_c2f)(
    (MPIABI_Comm)comm
  );
}

MPIABI_Datatype (* MPIABI_Type_f2c)(
  MPIABI_Fint datatype
) = NULL;
MPI_Datatype MPI_Type_f2c(
  MPI_Fint datatype
) {
  return (MPI_Datatype)(*MPIABI_Type_f2c)(
    (MPIABI_Fint)datatype
  );
}
MPI_Datatype PMPI_Type_f2c(
  MPI_Fint datatype
) {
  return (MPI_Datatype)(*MPIABI_Type_f2c)(
    (MPIABI_Fint)datatype
  );
}

MPIABI_Fint (* MPIABI_Type_c2f)(
  MPIABI_Datatype datatype
) = NULL;
MPI_Fint MPI_Type_c2f(
  MPI_Datatype datatype
) {
  return (MPI_Fint)(*MPIABI_Type_c2f)(
    (MPIABI_Datatype)datatype
  );
}
MPI_Fint PMPI_Type_c2f(
  MPI_Datatype datatype
) {
  return (MPI_Fint)(*MPIABI_Type_c2f)(
    (MPIABI_Datatype)datatype
  );
}

MPIABI_Group (* MPIABI_Group_f2c)(
  MPIABI_Fint group
) = NULL;
MPI_Group MPI_Group_f2c(
  MPI_Fint group
) {
  return (MPI_Group)(*MPIABI_Group_f2c)(
    (MPIABI_Fint)group
  );
}
MPI_Group PMPI_Group_f2c(
  MPI_Fint group
) {
  return (MPI_Group)(*MPIABI_Group_f2c)(
    (MPIABI_Fint)group
  );
}

MPIABI_Fint (* MPIABI_Group_c2f)(
  MPIABI_Group group
) = NULL;
MPI_Fint MPI_Group_c2f(
  MPI_Group group
) {
  return (MPI_Fint)(*MPIABI_Group_c2f)(
    (MPIABI_Group)group
  );
}
MPI_Fint PMPI_Group_c2f(
  MPI_Group group
) {
  return (MPI_Fint)(*MPIABI_Group_c2f)(
    (MPIABI_Group)group
  );
}

MPIABI_Request (* MPIABI_Request_f2c)(
  MPIABI_Fint request
) = NULL;
MPI_Request MPI_Request_f2c(
  MPI_Fint request
) {
  return (MPI_Request)(*MPIABI_Request_f2c)(
    (MPIABI_Fint)request
  );
}
MPI_Request PMPI_Request_f2c(
  MPI_Fint request
) {
  return (MPI_Request)(*MPIABI_Request_f2c)(
    (MPIABI_Fint)request
  );
}

MPIABI_Fint (* MPIABI_Request_c2f)(
  MPIABI_Request request
) = NULL;
MPI_Fint MPI_Request_c2f(
  MPI_Request request
) {
  return (MPI_Fint)(*MPIABI_Request_c2f)(
    (MPIABI_Request)request
  );
}
MPI_Fint PMPI_Request_c2f(
  MPI_Request request
) {
  return (MPI_Fint)(*MPIABI_Request_c2f)(
    (MPIABI_Request)request
  );
}

MPIABI_File (* MPIABI_File_f2c)(
  MPIABI_Fint file
) = NULL;
MPI_File MPI_File_f2c(
  MPI_Fint file
) {
  return (MPI_File)(*MPIABI_File_f2c)(
    (MPIABI_Fint)file
  );
}
MPI_File PMPI_File_f2c(
  MPI_Fint file
) {
  return (MPI_File)(*MPIABI_File_f2c)(
    (MPIABI_Fint)file
  );
}

MPIABI_Fint (* MPIABI_File_c2f)(
  MPIABI_File file
) = NULL;
MPI_Fint MPI_File_c2f(
  MPI_File file
) {
  return (MPI_Fint)(*MPIABI_File_c2f)(
    (MPIABI_File)file
  );
}
MPI_Fint PMPI_File_c2f(
  MPI_File file
) {
  return (MPI_Fint)(*MPIABI_File_c2f)(
    (MPIABI_File)file
  );
}

MPIABI_Win (* MPIABI_Win_f2c)(
  MPIABI_Fint win
) = NULL;
MPI_Win MPI_Win_f2c(
  MPI_Fint win
) {
  return (MPI_Win)(*MPIABI_Win_f2c)(
    (MPIABI_Fint)win
  );
}
MPI_Win PMPI_Win_f2c(
  MPI_Fint win
) {
  return (MPI_Win)(*MPIABI_Win_f2c)(
    (MPIABI_Fint)win
  );
}

MPIABI_Fint (* MPIABI_Win_c2f)(
  MPIABI_Win win
) = NULL;
MPI_Fint MPI_Win_c2f(
  MPI_Win win
) {
  return (MPI_Fint)(*MPIABI_Win_c2f)(
    (MPIABI_Win)win
  );
}
MPI_Fint PMPI_Win_c2f(
  MPI_Win win
) {
  return (MPI_Fint)(*MPIABI_Win_c2f)(
    (MPIABI_Win)win
  );
}

MPIABI_Op (* MPIABI_Op_f2c)(
  MPIABI_Fint op
) = NULL;
MPI_Op MPI_Op_f2c(
  MPI_Fint op
) {
  return (MPI_Op)(*MPIABI_Op_f2c)(
    (MPIABI_Fint)op
  );
}
MPI_Op PMPI_Op_f2c(
  MPI_Fint op
) {
  return (MPI_Op)(*MPIABI_Op_f2c)(
    (MPIABI_Fint)op
  );
}

MPIABI_Fint (* MPIABI_Op_c2f)(
  MPIABI_Op op
) = NULL;
MPI_Fint MPI_Op_c2f(
  MPI_Op op
) {
  return (MPI_Fint)(*MPIABI_Op_c2f)(
    (MPIABI_Op)op
  );
}
MPI_Fint PMPI_Op_c2f(
  MPI_Op op
) {
  return (MPI_Fint)(*MPIABI_Op_c2f)(
    (MPIABI_Op)op
  );
}

MPIABI_Info (* MPIABI_Info_f2c)(
  MPIABI_Fint info
) = NULL;
MPI_Info MPI_Info_f2c(
  MPI_Fint info
) {
  return (MPI_Info)(*MPIABI_Info_f2c)(
    (MPIABI_Fint)info
  );
}
MPI_Info PMPI_Info_f2c(
  MPI_Fint info
) {
  return (MPI_Info)(*MPIABI_Info_f2c)(
    (MPIABI_Fint)info
  );
}

MPIABI_Fint (* MPIABI_Info_c2f)(
  MPIABI_Info info
) = NULL;
MPI_Fint MPI_Info_c2f(
  MPI_Info info
) {
  return (MPI_Fint)(*MPIABI_Info_c2f)(
    (MPIABI_Info)info
  );
}
MPI_Fint PMPI_Info_c2f(
  MPI_Info info
) {
  return (MPI_Fint)(*MPIABI_Info_c2f)(
    (MPIABI_Info)info
  );
}

MPIABI_Errhandler (* MPIABI_Errhandler_f2c)(
  MPIABI_Fint info
) = NULL;
MPI_Errhandler MPI_Errhandler_f2c(
  MPI_Fint info
) {
  return (MPI_Errhandler)(*MPIABI_Errhandler_f2c)(
    (MPIABI_Fint)info
  );
}
MPI_Errhandler PMPI_Errhandler_f2c(
  MPI_Fint info
) {
  return (MPI_Errhandler)(*MPIABI_Errhandler_f2c)(
    (MPIABI_Fint)info
  );
}

MPIABI_Fint (* MPIABI_Errhandler_c2f)(
  MPIABI_Errhandler info
) = NULL;
MPI_Fint MPI_Errhandler_c2f(
  MPI_Errhandler info
) {
  return (MPI_Fint)(*MPIABI_Errhandler_c2f)(
    (MPIABI_Errhandler)info
  );
}
MPI_Fint PMPI_Errhandler_c2f(
  MPI_Errhandler info
) {
  return (MPI_Fint)(*MPIABI_Errhandler_c2f)(
    (MPIABI_Errhandler)info
  );
}

MPIABI_Message (* MPIABI_Message_f2c)(
  MPIABI_Fint message
) = NULL;
MPI_Message MPI_Message_f2c(
  MPI_Fint message
) {
  return (MPI_Message)(*MPIABI_Message_f2c)(
    (MPIABI_Fint)message
  );
}
MPI_Message PMPI_Message_f2c(
  MPI_Fint message
) {
  return (MPI_Message)(*MPIABI_Message_f2c)(
    (MPIABI_Fint)message
  );
}

MPIABI_Fint (* MPIABI_Message_c2f)(
  MPIABI_Message message
) = NULL;
MPI_Fint MPI_Message_c2f(
  MPI_Message message
) {
  return (MPI_Fint)(*MPIABI_Message_c2f)(
    (MPIABI_Message)message
  );
}
MPI_Fint PMPI_Message_c2f(
  MPI_Message message
) {
  return (MPI_Fint)(*MPIABI_Message_c2f)(
    (MPIABI_Message)message
  );
}

int (* MPIABI_Status_f2c)(
  const MPIABI_Fint * f_status,
  MPIABI_Status * c_status
) = NULL;
int MPI_Status_f2c(
  const MPI_Fint * f_status,
  MPI_Status * c_status
) {
  return (*MPIABI_Status_f2c)(
    (const MPIABI_Fint *)f_status,
    (MPIABI_Status *)c_status
  );
}
int PMPI_Status_f2c(
  const MPI_Fint * f_status,
  MPI_Status * c_status
) {
  return (*MPIABI_Status_f2c)(
    (const MPIABI_Fint *)f_status,
    (MPIABI_Status *)c_status
  );
}

int (* MPIABI_Status_c2f)(
  const MPIABI_Status * c_status,
  MPIABI_Fint * f_status
) = NULL;
int MPI_Status_c2f(
  const MPI_Status * c_status,
  MPI_Fint * f_status
) {
  return (*MPIABI_Status_c2f)(
    (const MPIABI_Status *)c_status,
    (MPIABI_Fint *)f_status
  );
}
int PMPI_Status_c2f(
  const MPI_Status * c_status,
  MPI_Fint * f_status
) {
  return (*MPIABI_Status_c2f)(
    (const MPIABI_Status *)c_status,
    (MPIABI_Fint *)f_status
  );
}

int (* MPIXABI_Query_cuda_support)(
) = NULL;
int MPIX_Query_cuda_support(
) {
  return (*MPIXABI_Query_cuda_support)(
  );
}
int PMPIX_Query_cuda_support(
) {
  return (*MPIXABI_Query_cuda_support)(
  );
}

int (* MPIXABI_Query_hip_support)(
) = NULL;
int MPIX_Query_hip_support(
) {
  return (*MPIXABI_Query_hip_support)(
  );
}
int PMPIX_Query_hip_support(
) {
  return (*MPIXABI_Query_hip_support)(
  );
}

int (* MPIXABI_Query_rocm_support)(
) = NULL;
int MPIX_Query_rocm_support(
) {
  return (*MPIXABI_Query_rocm_support)(
  );
}
int PMPIX_Query_rocm_support(
) {
  return (*MPIXABI_Query_rocm_support)(
  );
}

int (* MPIXABI_Query_ze_support)(
) = NULL;
int MPIX_Query_ze_support(
) {
  return (*MPIXABI_Query_ze_support)(
  );
}
int PMPIX_Query_ze_support(
) {
  return (*MPIXABI_Query_ze_support)(
  );
}
