// Define Fortran MPI functions


void (* mpiabi_send_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_send_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_send_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    ierror
  );
}
void pmpi_send_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_send_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    ierror
  );
}

void (* mpiabi_recv_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_recv_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_recv_)(
    buf,
    count,
    datatype,
    source,
    tag,
    comm,
    status,
    ierror
  );
}
void pmpi_recv_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_recv_)(
    buf,
    count,
    datatype,
    source,
    tag,
    comm,
    status,
    ierror
  );
}

void (* mpiabi_get_count_)(
  const MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * count,
  MPIABI_Fint * ierror
) = NULL;
void mpi_get_count_(
  const MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * count,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_count_)(
    status,
    datatype,
    count,
    ierror
  );
}
void pmpi_get_count_(
  const MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * count,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_count_)(
    status,
    datatype,
    count,
    ierror
  );
}

void (* mpiabi_bsend_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_bsend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_bsend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    ierror
  );
}
void pmpi_bsend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_bsend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    ierror
  );
}

void (* mpiabi_ssend_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ssend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ssend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    ierror
  );
}
void pmpi_ssend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ssend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    ierror
  );
}

void (* mpiabi_rsend_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_rsend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_rsend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    ierror
  );
}
void pmpi_rsend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_rsend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    ierror
  );
}

void (* mpiabi_buffer_attach_)(
  void * buffer,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_buffer_attach_(
  void * buffer,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_buffer_attach_)(
    buffer,
    size,
    ierror
  );
}
void pmpi_buffer_attach_(
  void * buffer,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_buffer_attach_)(
    buffer,
    size,
    ierror
  );
}

void (* mpiabi_buffer_detach_)(
  void * buffer_addr,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_buffer_detach_(
  void * buffer_addr,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_buffer_detach_)(
    buffer_addr,
    size,
    ierror
  );
}
void pmpi_buffer_detach_(
  void * buffer_addr,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_buffer_detach_)(
    buffer_addr,
    size,
    ierror
  );
}

void (* mpiabi_isend_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_isend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_isend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}
void pmpi_isend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_isend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ibsend_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ibsend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ibsend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}
void pmpi_ibsend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ibsend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_issend_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_issend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_issend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}
void pmpi_issend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_issend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_irsend_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_irsend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_irsend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}
void pmpi_irsend_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_irsend_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_irecv_)(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_irecv_(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_irecv_)(
    buf,
    count,
    datatype,
    source,
    tag,
    comm,
    request,
    ierror
  );
}
void pmpi_irecv_(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_irecv_)(
    buf,
    count,
    datatype,
    source,
    tag,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_wait_)(
  MPIABI_Fint * request,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_wait_(
  MPIABI_Fint * request,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_wait_)(
    request,
    status,
    ierror
  );
}
void pmpi_wait_(
  MPIABI_Fint * request,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_wait_)(
    request,
    status,
    ierror
  );
}

void (* mpiabi_test_)(
  MPIABI_Fint * request,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_test_(
  MPIABI_Fint * request,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_test_)(
    request,
    flag,
    status,
    ierror
  );
}
void pmpi_test_(
  MPIABI_Fint * request,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_test_)(
    request,
    flag,
    status,
    ierror
  );
}

void (* mpiabi_request_free_)(
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_request_free_(
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_request_free_)(
    request,
    ierror
  );
}
void pmpi_request_free_(
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_request_free_)(
    request,
    ierror
  );
}

void (* mpiabi_waitany_)(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  int * index,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_waitany_(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  int * index,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_waitany_)(
    count,
    array_of_requests,
    index,
    status,
    ierror
  );
}
void pmpi_waitany_(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  int * index,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_waitany_)(
    count,
    array_of_requests,
    index,
    status,
    ierror
  );
}

void (* mpiabi_testany_)(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  int * index,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_testany_(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  int * index,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_testany_)(
    count,
    array_of_requests,
    index,
    flag,
    status,
    ierror
  );
}
void pmpi_testany_(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  int * index,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_testany_)(
    count,
    array_of_requests,
    index,
    flag,
    status,
    ierror
  );
}

void (* mpiabi_waitall_)(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) = NULL;
void mpi_waitall_(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_waitall_)(
    count,
    array_of_requests,
    array_of_statuses,
    ierror
  );
}
void pmpi_waitall_(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_waitall_)(
    count,
    array_of_requests,
    array_of_statuses,
    ierror
  );
}

void (* mpiabi_testall_)(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  int * flag,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) = NULL;
void mpi_testall_(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  int * flag,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_testall_)(
    count,
    array_of_requests,
    flag,
    array_of_statuses,
    ierror
  );
}
void pmpi_testall_(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  int * flag,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_testall_)(
    count,
    array_of_requests,
    flag,
    array_of_statuses,
    ierror
  );
}

void (* mpiabi_waitsome_)(
  const MPIABI_Fint * incount,
  MPIABI_Fint * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) = NULL;
void mpi_waitsome_(
  const MPIABI_Fint * incount,
  MPIABI_Fint * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_waitsome_)(
    incount,
    array_of_requests,
    outcount,
    array_of_indices,
    array_of_statuses,
    ierror
  );
}
void pmpi_waitsome_(
  const MPIABI_Fint * incount,
  MPIABI_Fint * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_waitsome_)(
    incount,
    array_of_requests,
    outcount,
    array_of_indices,
    array_of_statuses,
    ierror
  );
}

void (* mpiabi_testsome_)(
  const MPIABI_Fint * incount,
  MPIABI_Fint * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) = NULL;
void mpi_testsome_(
  const MPIABI_Fint * incount,
  MPIABI_Fint * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_testsome_)(
    incount,
    array_of_requests,
    outcount,
    array_of_indices,
    array_of_statuses,
    ierror
  );
}
void pmpi_testsome_(
  const MPIABI_Fint * incount,
  MPIABI_Fint * array_of_requests,
  int * outcount,
  int * array_of_indices,
  MPIABI_Fint * array_of_statuses,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_testsome_)(
    incount,
    array_of_requests,
    outcount,
    array_of_indices,
    array_of_statuses,
    ierror
  );
}

void (* mpiabi_request_get_status_)(
  const MPIABI_Fint * request,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_request_get_status_(
  const MPIABI_Fint * request,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_request_get_status_)(
    request,
    flag,
    status,
    ierror
  );
}
void pmpi_request_get_status_(
  const MPIABI_Fint * request,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_request_get_status_)(
    request,
    flag,
    status,
    ierror
  );
}

void (* mpiabi_iprobe_)(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_iprobe_(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iprobe_)(
    source,
    tag,
    comm,
    flag,
    status,
    ierror
  );
}
void pmpi_iprobe_(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  int * flag,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iprobe_)(
    source,
    tag,
    comm,
    flag,
    status,
    ierror
  );
}

void (* mpiabi_probe_)(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_probe_(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_probe_)(
    source,
    tag,
    comm,
    status,
    ierror
  );
}
void pmpi_probe_(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_probe_)(
    source,
    tag,
    comm,
    status,
    ierror
  );
}

void (* mpiabi_improbe_)(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  int * flag,
  MPIABI_Fint * message,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_improbe_(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  int * flag,
  MPIABI_Fint * message,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_improbe_)(
    source,
    tag,
    comm,
    flag,
    message,
    status,
    ierror
  );
}
void pmpi_improbe_(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  int * flag,
  MPIABI_Fint * message,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_improbe_)(
    source,
    tag,
    comm,
    flag,
    message,
    status,
    ierror
  );
}

void (* mpiabi_mprobe_)(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * message,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_mprobe_(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * message,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_mprobe_)(
    source,
    tag,
    comm,
    message,
    status,
    ierror
  );
}
void pmpi_mprobe_(
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * message,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_mprobe_)(
    source,
    tag,
    comm,
    message,
    status,
    ierror
  );
}

void (* mpiabi_mrecv_)(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * message,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_mrecv_(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * message,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_mrecv_)(
    buf,
    count,
    datatype,
    message,
    status,
    ierror
  );
}
void pmpi_mrecv_(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * message,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_mrecv_)(
    buf,
    count,
    datatype,
    message,
    status,
    ierror
  );
}

void (* mpiabi_imrecv_)(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * message,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_imrecv_(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * message,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_imrecv_)(
    buf,
    count,
    datatype,
    message,
    request,
    ierror
  );
}
void pmpi_imrecv_(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * message,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_imrecv_)(
    buf,
    count,
    datatype,
    message,
    request,
    ierror
  );
}

void (* mpiabi_cancel_)(
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_cancel_(
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cancel_)(
    request,
    ierror
  );
}
void pmpi_cancel_(
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cancel_)(
    request,
    ierror
  );
}

void (* mpiabi_test_cancelled_)(
  const MPIABI_Fint * status,
  int * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_test_cancelled_(
  const MPIABI_Fint * status,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_test_cancelled_)(
    status,
    flag,
    ierror
  );
}
void pmpi_test_cancelled_(
  const MPIABI_Fint * status,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_test_cancelled_)(
    status,
    flag,
    ierror
  );
}

void (* mpiabi_send_init_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_send_init_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_send_init_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}
void pmpi_send_init_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_send_init_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_bsend_init_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_bsend_init_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_bsend_init_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}
void pmpi_bsend_init_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_bsend_init_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ssend_init_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ssend_init_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ssend_init_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}
void pmpi_ssend_init_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ssend_init_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_rsend_init_)(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_rsend_init_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_rsend_init_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}
void pmpi_rsend_init_(
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_rsend_init_)(
    buf,
    count,
    datatype,
    dest,
    tag,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_recv_init_)(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_recv_init_(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_recv_init_)(
    buf,
    count,
    datatype,
    source,
    tag,
    comm,
    request,
    ierror
  );
}
void pmpi_recv_init_(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * tag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_recv_init_)(
    buf,
    count,
    datatype,
    source,
    tag,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_start_)(
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_start_(
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_start_)(
    request,
    ierror
  );
}
void pmpi_start_(
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_start_)(
    request,
    ierror
  );
}

void (* mpiabi_startall_)(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  MPIABI_Fint * ierror
) = NULL;
void mpi_startall_(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_startall_)(
    count,
    array_of_requests,
    ierror
  );
}
void pmpi_startall_(
  const MPIABI_Fint * count,
  MPIABI_Fint * array_of_requests,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_startall_)(
    count,
    array_of_requests,
    ierror
  );
}

void (* mpiabi_sendrecv_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * sendtag,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * recvtag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_sendrecv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * sendtag,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * recvtag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_sendrecv_)(
    sendbuf,
    sendcount,
    sendtype,
    dest,
    sendtag,
    recvbuf,
    recvcount,
    recvtype,
    source,
    recvtag,
    comm,
    status,
    ierror
  );
}
void pmpi_sendrecv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * sendtag,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * source,
  const MPIABI_Fint * recvtag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_sendrecv_)(
    sendbuf,
    sendcount,
    sendtype,
    dest,
    sendtag,
    recvbuf,
    recvcount,
    recvtype,
    source,
    recvtag,
    comm,
    status,
    ierror
  );
}

void (* mpiabi_sendrecv_replace_)(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * sendtag,
  const MPIABI_Fint * source,
  const MPIABI_Fint * recvtag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_sendrecv_replace_(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * sendtag,
  const MPIABI_Fint * source,
  const MPIABI_Fint * recvtag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_sendrecv_replace_)(
    buf,
    count,
    datatype,
    dest,
    sendtag,
    source,
    recvtag,
    comm,
    status,
    ierror
  );
}
void pmpi_sendrecv_replace_(
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * dest,
  const MPIABI_Fint * sendtag,
  const MPIABI_Fint * source,
  const MPIABI_Fint * recvtag,
  const MPIABI_Fint * comm,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_sendrecv_replace_)(
    buf,
    count,
    datatype,
    dest,
    sendtag,
    source,
    recvtag,
    comm,
    status,
    ierror
  );
}

void (* mpiabi_type_contiguous_)(
  const MPIABI_Fint * count,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_contiguous_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_contiguous_)(
    count,
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_contiguous_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_contiguous_)(
    count,
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_type_vector_)(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * stride,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_vector_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * stride,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_vector_)(
    count,
    blocklength,
    stride,
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_vector_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * stride,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_vector_)(
    count,
    blocklength,
    stride,
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_type_create_hvector_)(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * stride,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_create_hvector_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * stride,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_hvector_)(
    count,
    blocklength,
    stride,
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_create_hvector_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * stride,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_hvector_)(
    count,
    blocklength,
    stride,
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_type_hvector_)(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * stride,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_hvector_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * stride,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_hvector_)(
    count,
    blocklength,
    stride,
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_hvector_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * stride,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_hvector_)(
    count,
    blocklength,
    stride,
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_type_indexed_)(
  const MPIABI_Fint * count,
  const int * array_of_blocklengths,
  const int * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_indexed_(
  const MPIABI_Fint * count,
  const int * array_of_blocklengths,
  const int * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_indexed_)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_indexed_(
  const MPIABI_Fint * count,
  const int * array_of_blocklengths,
  const int * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_indexed_)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_type_create_hindexed_)(
  const MPIABI_Fint * count,
  const int * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_create_hindexed_(
  const MPIABI_Fint * count,
  const int * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_hindexed_)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_create_hindexed_(
  const MPIABI_Fint * count,
  const int * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_hindexed_)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_type_hindexed_)(
  const MPIABI_Fint * count,
  const int * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_hindexed_(
  const MPIABI_Fint * count,
  const int * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_hindexed_)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_hindexed_(
  const MPIABI_Fint * count,
  const int * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_hindexed_)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_type_create_indexed_block_)(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const int * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_create_indexed_block_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const int * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_indexed_block_)(
    count,
    blocklength,
    array_of_displacements,
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_create_indexed_block_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const int * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_indexed_block_)(
    count,
    blocklength,
    array_of_displacements,
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_type_create_hindexed_block_)(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_create_hindexed_block_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_hindexed_block_)(
    count,
    blocklength,
    array_of_displacements,
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_create_hindexed_block_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * blocklength,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_hindexed_block_)(
    count,
    blocklength,
    array_of_displacements,
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_type_create_struct_)(
  const MPIABI_Fint * count,
  const MPIABI_Fint * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * array_of_types,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_create_struct_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * array_of_types,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_struct_)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    array_of_types,
    newtype,
    ierror
  );
}
void pmpi_type_create_struct_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * array_of_types,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_struct_)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    array_of_types,
    newtype,
    ierror
  );
}

void (* mpiabi_type_struct_)(
  const MPIABI_Fint * count,
  const MPIABI_Fint * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * array_of_types,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_struct_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * array_of_types,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_struct_)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    array_of_types,
    newtype,
    ierror
  );
}
void pmpi_type_struct_(
  const MPIABI_Fint * count,
  const MPIABI_Fint * array_of_blocklengths,
  const MPIABI_Fint * array_of_displacements,
  const MPIABI_Fint * array_of_types,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_struct_)(
    count,
    array_of_blocklengths,
    array_of_displacements,
    array_of_types,
    newtype,
    ierror
  );
}

void (* mpiabi_type_create_subarray_)(
  const MPIABI_Fint * ndims,
  const int * array_of_sizes,
  const int * array_of_subsizes,
  const int * array_of_starts,
  const MPIABI_Fint * ordder,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_create_subarray_(
  const MPIABI_Fint * ndims,
  const int * array_of_sizes,
  const int * array_of_subsizes,
  const int * array_of_starts,
  const MPIABI_Fint * ordder,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_subarray_)(
    ndims,
    array_of_sizes,
    array_of_subsizes,
    array_of_starts,
    ordder,
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_create_subarray_(
  const MPIABI_Fint * ndims,
  const int * array_of_sizes,
  const int * array_of_subsizes,
  const int * array_of_starts,
  const MPIABI_Fint * ordder,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_subarray_)(
    ndims,
    array_of_sizes,
    array_of_subsizes,
    array_of_starts,
    ordder,
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_type_create_darray_)(
  const MPIABI_Fint * size,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * ndims,
  const int * array_of_gsizes,
  const int * array_of_distribs,
  const int * array_of_dargs,
  const int * array_of_psizes,
  const MPIABI_Fint * order,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_create_darray_(
  const MPIABI_Fint * size,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * ndims,
  const int * array_of_gsizes,
  const int * array_of_distribs,
  const int * array_of_dargs,
  const int * array_of_psizes,
  const MPIABI_Fint * order,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_darray_)(
    size,
    rank,
    ndims,
    array_of_gsizes,
    array_of_distribs,
    array_of_dargs,
    array_of_psizes,
    order,
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_create_darray_(
  const MPIABI_Fint * size,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * ndims,
  const int * array_of_gsizes,
  const int * array_of_distribs,
  const int * array_of_dargs,
  const int * array_of_psizes,
  const MPIABI_Fint * order,
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_darray_)(
    size,
    rank,
    ndims,
    array_of_gsizes,
    array_of_distribs,
    array_of_dargs,
    array_of_psizes,
    order,
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_get_address_)(
  const void * location,
  MPIABI_Fint * address,
  MPIABI_Fint * ierror
) = NULL;
void mpi_get_address_(
  const void * location,
  MPIABI_Fint * address,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_address_)(
    location,
    address,
    ierror
  );
}
void pmpi_get_address_(
  const void * location,
  MPIABI_Fint * address,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_address_)(
    location,
    address,
    ierror
  );
}

void (* mpiabi_address_)(
  const void * location,
  MPIABI_Fint * address,
  MPIABI_Fint * ierror
) = NULL;
void mpi_address_(
  const void * location,
  MPIABI_Fint * address,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_address_)(
    location,
    address,
    ierror
  );
}
void pmpi_address_(
  const void * location,
  MPIABI_Fint * address,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_address_)(
    location,
    address,
    ierror
  );
}

MPIABI_Fint (* mpiabi_aint_add_)(
  const MPIABI_Fint * base,
  const MPIABI_Fint * disp,
  MPIABI_Fint * ierror
) = NULL;
MPIABI_Fint mpi_aint_add_(
  const MPIABI_Fint * base,
  const MPIABI_Fint * disp,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_aint_add_)(
    base,
    disp,
    ierror
  );
}
MPIABI_Fint pmpi_aint_add_(
  const MPIABI_Fint * base,
  const MPIABI_Fint * disp,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_aint_add_)(
    base,
    disp,
    ierror
  );
}

MPIABI_Fint (* mpiabi_aint_diff_)(
  const MPIABI_Fint * addr1,
  const MPIABI_Fint * addr2,
  MPIABI_Fint * ierror
) = NULL;
MPIABI_Fint mpi_aint_diff_(
  const MPIABI_Fint * addr1,
  const MPIABI_Fint * addr2,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_aint_diff_)(
    addr1,
    addr2,
    ierror
  );
}
MPIABI_Fint pmpi_aint_diff_(
  const MPIABI_Fint * addr1,
  const MPIABI_Fint * addr2,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_aint_diff_)(
    addr1,
    addr2,
    ierror
  );
}

void (* mpiabi_type_size_)(
  const MPIABI_Fint * datatype,
  int * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_size_(
  const MPIABI_Fint * datatype,
  int * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_size_)(
    datatype,
    size,
    ierror
  );
}
void pmpi_type_size_(
  const MPIABI_Fint * datatype,
  int * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_size_)(
    datatype,
    size,
    ierror
  );
}

void (* mpiabi_type_size_x_)(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_size_x_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_size_x_)(
    datatype,
    size,
    ierror
  );
}
void pmpi_type_size_x_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_size_x_)(
    datatype,
    size,
    ierror
  );
}

void (* mpiabi_type_get_extent_)(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * lb,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_get_extent_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * lb,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_extent_)(
    datatype,
    lb,
    extent,
    ierror
  );
}
void pmpi_type_get_extent_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * lb,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_extent_)(
    datatype,
    lb,
    extent,
    ierror
  );
}

void (* mpiabi_type_extent_)(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_extent_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_extent_)(
    datatype,
    extent,
    ierror
  );
}
void pmpi_type_extent_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_extent_)(
    datatype,
    extent,
    ierror
  );
}

void (* mpiabi_type_lb_)(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * displacement,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_lb_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * displacement,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_lb_)(
    datatype,
    displacement,
    ierror
  );
}
void pmpi_type_lb_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * displacement,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_lb_)(
    datatype,
    displacement,
    ierror
  );
}

void (* mpiabi_type_ub_)(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * displacement,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_ub_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * displacement,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_ub_)(
    datatype,
    displacement,
    ierror
  );
}
void pmpi_type_ub_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * displacement,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_ub_)(
    datatype,
    displacement,
    ierror
  );
}

void (* mpiabi_type_get_extent_x_)(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * lb,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_get_extent_x_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * lb,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_extent_x_)(
    datatype,
    lb,
    extent,
    ierror
  );
}
void pmpi_type_get_extent_x_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * lb,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_extent_x_)(
    datatype,
    lb,
    extent,
    ierror
  );
}

void (* mpiabi_type_create_resized_)(
  const MPIABI_Fint * oldtype,
  const MPIABI_Fint * lb,
  const MPIABI_Fint * extent,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_create_resized_(
  const MPIABI_Fint * oldtype,
  const MPIABI_Fint * lb,
  const MPIABI_Fint * extent,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_resized_)(
    oldtype,
    lb,
    extent,
    newtype,
    ierror
  );
}
void pmpi_type_create_resized_(
  const MPIABI_Fint * oldtype,
  const MPIABI_Fint * lb,
  const MPIABI_Fint * extent,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_resized_)(
    oldtype,
    lb,
    extent,
    newtype,
    ierror
  );
}

void (* mpiabi_type_get_true_extent_)(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * true_lb,
  MPIABI_Fint * true_extent,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_get_true_extent_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * true_lb,
  MPIABI_Fint * true_extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_true_extent_)(
    datatype,
    true_lb,
    true_extent,
    ierror
  );
}
void pmpi_type_get_true_extent_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * true_lb,
  MPIABI_Fint * true_extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_true_extent_)(
    datatype,
    true_lb,
    true_extent,
    ierror
  );
}

void (* mpiabi_type_get_true_extent_x_)(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * true_lb,
  MPIABI_Fint * true_extent,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_get_true_extent_x_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * true_lb,
  MPIABI_Fint * true_extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_true_extent_x_)(
    datatype,
    true_lb,
    true_extent,
    ierror
  );
}
void pmpi_type_get_true_extent_x_(
  const MPIABI_Fint * datatype,
  MPIABI_Fint * true_lb,
  MPIABI_Fint * true_extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_true_extent_x_)(
    datatype,
    true_lb,
    true_extent,
    ierror
  );
}

void (* mpiabi_type_commit_)(
  MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_commit_(
  MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_commit_)(
    datatype,
    ierror
  );
}
void pmpi_type_commit_(
  MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_commit_)(
    datatype,
    ierror
  );
}

void (* mpiabi_type_free_)(
  MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_free_(
  MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_free_)(
    datatype,
    ierror
  );
}
void pmpi_type_free_(
  MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_free_)(
    datatype,
    ierror
  );
}

void (* mpiabi_type_dup_)(
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_dup_(
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_dup_)(
    oldtype,
    newtype,
    ierror
  );
}
void pmpi_type_dup_(
  const MPIABI_Fint * oldtype,
  MPIABI_Fint * newtype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_dup_)(
    oldtype,
    newtype,
    ierror
  );
}

void (* mpiabi_get_elements_)(
  const MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  int * count,
  MPIABI_Fint * ierror
) = NULL;
void mpi_get_elements_(
  const MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  int * count,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_elements_)(
    status,
    datatype,
    count,
    ierror
  );
}
void pmpi_get_elements_(
  const MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  int * count,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_elements_)(
    status,
    datatype,
    count,
    ierror
  );
}

void (* mpiabi_get_elements_x_)(
  const MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * count,
  MPIABI_Fint * ierror
) = NULL;
void mpi_get_elements_x_(
  const MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * count,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_elements_x_)(
    status,
    datatype,
    count,
    ierror
  );
}
void pmpi_get_elements_x_(
  const MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * count,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_elements_x_)(
    status,
    datatype,
    count,
    ierror
  );
}

void (* mpiabi_type_get_envelope_)(
  const MPIABI_Fint * datatype,
  int * num_integers,
  int * num_addresses,
  int * num_datatypes,
  int * combiner,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_get_envelope_(
  const MPIABI_Fint * datatype,
  int * num_integers,
  int * num_addresses,
  int * num_datatypes,
  int * combiner,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_envelope_)(
    datatype,
    num_integers,
    num_addresses,
    num_datatypes,
    combiner,
    ierror
  );
}
void pmpi_type_get_envelope_(
  const MPIABI_Fint * datatype,
  int * num_integers,
  int * num_addresses,
  int * num_datatypes,
  int * combiner,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_envelope_)(
    datatype,
    num_integers,
    num_addresses,
    num_datatypes,
    combiner,
    ierror
  );
}

void (* mpiabi_type_get_contents_)(
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * max_integers,
  const MPIABI_Fint * max_addresses,
  const MPIABI_Fint * max_datatypes,
  int * array_of_integers,
  MPIABI_Fint * array_of_addresses,
  MPIABI_Fint * array_of_datatypes,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_get_contents_(
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * max_integers,
  const MPIABI_Fint * max_addresses,
  const MPIABI_Fint * max_datatypes,
  int * array_of_integers,
  MPIABI_Fint * array_of_addresses,
  MPIABI_Fint * array_of_datatypes,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_contents_)(
    datatype,
    max_integers,
    max_addresses,
    max_datatypes,
    array_of_integers,
    array_of_addresses,
    array_of_datatypes,
    ierror
  );
}
void pmpi_type_get_contents_(
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * max_integers,
  const MPIABI_Fint * max_addresses,
  const MPIABI_Fint * max_datatypes,
  int * array_of_integers,
  MPIABI_Fint * array_of_addresses,
  MPIABI_Fint * array_of_datatypes,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_contents_)(
    datatype,
    max_integers,
    max_addresses,
    max_datatypes,
    array_of_integers,
    array_of_addresses,
    array_of_datatypes,
    ierror
  );
}

void (* mpiabi_pack_)(
  const void * inbuf,
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  void * outbuf,
  const MPIABI_Fint * outsize,
  int * position,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_pack_(
  const void * inbuf,
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  void * outbuf,
  const MPIABI_Fint * outsize,
  int * position,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_pack_)(
    inbuf,
    incount,
    datatype,
    outbuf,
    outsize,
    position,
    comm,
    ierror
  );
}
void pmpi_pack_(
  const void * inbuf,
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  void * outbuf,
  const MPIABI_Fint * outsize,
  int * position,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_pack_)(
    inbuf,
    incount,
    datatype,
    outbuf,
    outsize,
    position,
    comm,
    ierror
  );
}

void (* mpiabi_unpack_)(
  const void * inbuf,
  const MPIABI_Fint * insize,
  int * position,
  void * outbuf,
  const MPIABI_Fint * outcount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_unpack_(
  const void * inbuf,
  const MPIABI_Fint * insize,
  int * position,
  void * outbuf,
  const MPIABI_Fint * outcount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_unpack_)(
    inbuf,
    insize,
    position,
    outbuf,
    outcount,
    datatype,
    comm,
    ierror
  );
}
void pmpi_unpack_(
  const void * inbuf,
  const MPIABI_Fint * insize,
  int * position,
  void * outbuf,
  const MPIABI_Fint * outcount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_unpack_)(
    inbuf,
    insize,
    position,
    outbuf,
    outcount,
    datatype,
    comm,
    ierror
  );
}

void (* mpiabi_pack_size_)(
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * comm,
  int * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_pack_size_(
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * comm,
  int * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_pack_size_)(
    incount,
    datatype,
    comm,
    size,
    ierror
  );
}
void pmpi_pack_size_(
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * comm,
  int * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_pack_size_)(
    incount,
    datatype,
    comm,
    size,
    ierror
  );
}

void (* mpiabi_pack_external_)(
  const char * datarep,
  const void * inbuf,
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  void * outbuf,
  const MPIABI_Fint * outsize,
  MPIABI_Fint * position,
  MPIABI_Fint * ierror,
  size_t datarep_len
) = NULL;
void mpi_pack_external_(
  const char * datarep,
  const void * inbuf,
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  void * outbuf,
  const MPIABI_Fint * outsize,
  MPIABI_Fint * position,
  MPIABI_Fint * ierror,
  size_t datarep_len
) {
  return (* mpiabi_pack_external_)(
    datarep,
    inbuf,
    incount,
    datatype,
    outbuf,
    outsize,
    position,
    ierror,
    datarep_len
  );
}
void pmpi_pack_external_(
  const char * datarep,
  const void * inbuf,
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  void * outbuf,
  const MPIABI_Fint * outsize,
  MPIABI_Fint * position,
  MPIABI_Fint * ierror,
  size_t datarep_len
) {
  return (* mpiabi_pack_external_)(
    datarep,
    inbuf,
    incount,
    datatype,
    outbuf,
    outsize,
    position,
    ierror,
    datarep_len
  );
}

void (* mpiabi_unpack_external_)(
  const char * datarep,
  const void * inbuf,
  const MPIABI_Fint * insize,
  MPIABI_Fint * position,
  void * outbuf,
  const MPIABI_Fint * outcount,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror,
  size_t datarep_len
) = NULL;
void mpi_unpack_external_(
  const char * datarep,
  const void * inbuf,
  const MPIABI_Fint * insize,
  MPIABI_Fint * position,
  void * outbuf,
  const MPIABI_Fint * outcount,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror,
  size_t datarep_len
) {
  return (* mpiabi_unpack_external_)(
    datarep,
    inbuf,
    insize,
    position,
    outbuf,
    outcount,
    datatype,
    ierror,
    datarep_len
  );
}
void pmpi_unpack_external_(
  const char * datarep,
  const void * inbuf,
  const MPIABI_Fint * insize,
  MPIABI_Fint * position,
  void * outbuf,
  const MPIABI_Fint * outcount,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror,
  size_t datarep_len
) {
  return (* mpiabi_unpack_external_)(
    datarep,
    inbuf,
    insize,
    position,
    outbuf,
    outcount,
    datatype,
    ierror,
    datarep_len
  );
}

void (* mpiabi_pack_external_size_)(
  const char * datarep,
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror,
  size_t datarep_len
) = NULL;
void mpi_pack_external_size_(
  const char * datarep,
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror,
  size_t datarep_len
) {
  return (* mpiabi_pack_external_size_)(
    datarep,
    incount,
    datatype,
    size,
    ierror,
    datarep_len
  );
}
void pmpi_pack_external_size_(
  const char * datarep,
  const MPIABI_Fint * incount,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror,
  size_t datarep_len
) {
  return (* mpiabi_pack_external_size_)(
    datarep,
    incount,
    datatype,
    size,
    ierror,
    datarep_len
  );
}

void (* mpiabi_barrier_)(
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_barrier_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_barrier_)(
    comm,
    ierror
  );
}
void pmpi_barrier_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_barrier_)(
    comm,
    ierror
  );
}

void (* mpiabi_bcast_)(
  void * buffer,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_bcast_(
  void * buffer,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_bcast_)(
    buffer,
    count,
    datatype,
    root,
    comm,
    ierror
  );
}
void pmpi_bcast_(
  void * buffer,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_bcast_)(
    buffer,
    count,
    datatype,
    root,
    comm,
    ierror
  );
}

void (* mpiabi_gather_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_gather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_gather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    ierror
  );
}
void pmpi_gather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_gather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    ierror
  );
}

void (* mpiabi_gatherv_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_gatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_gatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    root,
    comm,
    ierror
  );
}
void pmpi_gatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_gatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    root,
    comm,
    ierror
  );
}

void (* mpiabi_scatter_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_scatter_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_scatter_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    ierror
  );
}
void pmpi_scatter_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_scatter_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    ierror
  );
}

void (* mpiabi_scatterv_)(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_scatterv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_scatterv_)(
    sendbuf,
    sendcounts,
    displs,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    ierror
  );
}
void pmpi_scatterv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_scatterv_)(
    sendbuf,
    sendcounts,
    displs,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    ierror
  );
}

void (* mpiabi_allgather_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_allgather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_allgather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    ierror
  );
}
void pmpi_allgather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_allgather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    ierror
  );
}

void (* mpiabi_allgatherv_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_allgatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_allgatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    comm,
    ierror
  );
}
void pmpi_allgatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_allgatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    comm,
    ierror
  );
}

void (* mpiabi_alltoall_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_alltoall_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_alltoall_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    ierror
  );
}
void pmpi_alltoall_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_alltoall_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    ierror
  );
}

void (* mpiabi_alltoallv_)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_alltoallv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_alltoallv_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtype,
    recvbuf,
    recvcounts,
    rdispls,
    recvtype,
    comm,
    ierror
  );
}
void pmpi_alltoallv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_alltoallv_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtype,
    recvbuf,
    recvcounts,
    rdispls,
    recvtype,
    comm,
    ierror
  );
}

void (* mpiabi_alltoallw_)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_alltoallw_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_alltoallw_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    recvtypes,
    comm,
    ierror
  );
}
void pmpi_alltoallw_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_alltoallw_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    recvtypes,
    comm,
    ierror
  );
}

void (* mpiabi_reduce_)(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_reduce_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_reduce_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    root,
    comm,
    ierror
  );
}
void pmpi_reduce_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_reduce_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    root,
    comm,
    ierror
  );
}

void (* mpiabi_op_create_)(
  MPIABI_Fint * user_fn,
  const MPIABI_Fint * commute,
  MPIABI_Fint * op,
  MPIABI_Fint * ierror
) = NULL;
void mpi_op_create_(
  MPIABI_Fint * user_fn,
  const MPIABI_Fint * commute,
  MPIABI_Fint * op,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_op_create_)(
    user_fn,
    commute,
    op,
    ierror
  );
}
void pmpi_op_create_(
  MPIABI_Fint * user_fn,
  const MPIABI_Fint * commute,
  MPIABI_Fint * op,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_op_create_)(
    user_fn,
    commute,
    op,
    ierror
  );
}

void (* mpiabi_op_free_)(
  MPIABI_Fint * op,
  MPIABI_Fint * ierror
) = NULL;
void mpi_op_free_(
  MPIABI_Fint * op,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_op_free_)(
    op,
    ierror
  );
}
void pmpi_op_free_(
  MPIABI_Fint * op,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_op_free_)(
    op,
    ierror
  );
}

void (* mpiabi_allreduce_)(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_allreduce_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_allreduce_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    ierror
  );
}
void pmpi_allreduce_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_allreduce_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    ierror
  );
}

void (* mpiabi_op_commutative_)(
  const MPIABI_Fint * op,
  int * commute,
  MPIABI_Fint * ierror
) = NULL;
void mpi_op_commutative_(
  const MPIABI_Fint * op,
  int * commute,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_op_commutative_)(
    op,
    commute,
    ierror
  );
}
void pmpi_op_commutative_(
  const MPIABI_Fint * op,
  int * commute,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_op_commutative_)(
    op,
    commute,
    ierror
  );
}

void (* mpiabi_reduce_local_)(
  const void * inbuf,
  void * inoutbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  MPIABI_Fint * ierror
) = NULL;
void mpi_reduce_local_(
  const void * inbuf,
  void * inoutbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_reduce_local_)(
    inbuf,
    inoutbuf,
    count,
    datatype,
    op,
    ierror
  );
}
void pmpi_reduce_local_(
  const void * inbuf,
  void * inoutbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_reduce_local_)(
    inbuf,
    inoutbuf,
    count,
    datatype,
    op,
    ierror
  );
}

void (* mpiabi_reduce_scatter_block_)(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_reduce_scatter_block_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_reduce_scatter_block_)(
    sendbuf,
    recvbuf,
    recvcount,
    datatype,
    op,
    comm,
    ierror
  );
}
void pmpi_reduce_scatter_block_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_reduce_scatter_block_)(
    sendbuf,
    recvbuf,
    recvcount,
    datatype,
    op,
    comm,
    ierror
  );
}

void (* mpiabi_reduce_scatter_)(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_reduce_scatter_(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_reduce_scatter_)(
    sendbuf,
    recvbuf,
    recvcounts,
    datatype,
    op,
    comm,
    ierror
  );
}
void pmpi_reduce_scatter_(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_reduce_scatter_)(
    sendbuf,
    recvbuf,
    recvcounts,
    datatype,
    op,
    comm,
    ierror
  );
}

void (* mpiabi_scan_)(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_scan_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_scan_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    ierror
  );
}
void pmpi_scan_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_scan_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    ierror
  );
}

void (* mpiabi_exscan_)(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_exscan_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_exscan_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    ierror
  );
}
void pmpi_exscan_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_exscan_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    ierror
  );
}

void (* mpiabi_ibarrier_)(
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ibarrier_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ibarrier_)(
    comm,
    request,
    ierror
  );
}
void pmpi_ibarrier_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ibarrier_)(
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ibcast_)(
  void * buffer,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ibcast_(
  void * buffer,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ibcast_)(
    buffer,
    count,
    datatype,
    root,
    comm,
    request,
    ierror
  );
}
void pmpi_ibcast_(
  void * buffer,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ibcast_)(
    buffer,
    count,
    datatype,
    root,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_igather_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_igather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_igather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    request,
    ierror
  );
}
void pmpi_igather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_igather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_igatherv_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_igatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_igatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    root,
    comm,
    request,
    ierror
  );
}
void pmpi_igatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_igatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    root,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_iscatter_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_iscatter_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iscatter_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    request,
    ierror
  );
}
void pmpi_iscatter_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iscatter_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_iscatterv_)(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_iscatterv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iscatterv_)(
    sendbuf,
    sendcounts,
    displs,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    request,
    ierror
  );
}
void pmpi_iscatterv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * displs,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iscatterv_)(
    sendbuf,
    sendcounts,
    displs,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    root,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_iallgather_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_iallgather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iallgather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    request,
    ierror
  );
}
void pmpi_iallgather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iallgather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_iallgatherv_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_iallgatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iallgatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    comm,
    request,
    ierror
  );
}
void pmpi_iallgatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iallgatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ialltoall_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ialltoall_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ialltoall_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    request,
    ierror
  );
}
void pmpi_ialltoall_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ialltoall_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ialltoallv_)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ialltoallv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ialltoallv_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtype,
    recvbuf,
    recvcounts,
    rdispls,
    recvtype,
    comm,
    request,
    ierror
  );
}
void pmpi_ialltoallv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ialltoallv_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtype,
    recvbuf,
    recvcounts,
    rdispls,
    recvtype,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ialltoallw_)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ialltoallw_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ialltoallw_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    recvtypes,
    comm,
    request,
    ierror
  );
}
void pmpi_ialltoallw_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ialltoallw_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    recvtypes,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ireduce_)(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ireduce_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ireduce_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    root,
    comm,
    request,
    ierror
  );
}
void pmpi_ireduce_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ireduce_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    root,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_iallreduce_)(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_iallreduce_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iallreduce_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    request,
    ierror
  );
}
void pmpi_iallreduce_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iallreduce_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ireduce_scatter_block_)(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ireduce_scatter_block_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ireduce_scatter_block_)(
    sendbuf,
    recvbuf,
    recvcount,
    datatype,
    op,
    comm,
    request,
    ierror
  );
}
void pmpi_ireduce_scatter_block_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ireduce_scatter_block_)(
    sendbuf,
    recvbuf,
    recvcount,
    datatype,
    op,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ireduce_scatter_)(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ireduce_scatter_(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ireduce_scatter_)(
    sendbuf,
    recvbuf,
    recvcounts,
    datatype,
    op,
    comm,
    request,
    ierror
  );
}
void pmpi_ireduce_scatter_(
  const void * sendbuf,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ireduce_scatter_)(
    sendbuf,
    recvbuf,
    recvcounts,
    datatype,
    op,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_iscan_)(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_iscan_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iscan_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    request,
    ierror
  );
}
void pmpi_iscan_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iscan_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_iexscan_)(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_iexscan_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iexscan_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    request,
    ierror
  );
}
void pmpi_iexscan_(
  const void * sendbuf,
  void * recvbuf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_iexscan_)(
    sendbuf,
    recvbuf,
    count,
    datatype,
    op,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_group_size_)(
  const MPIABI_Fint * group,
  int * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_size_(
  const MPIABI_Fint * group,
  int * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_size_)(
    group,
    size,
    ierror
  );
}
void pmpi_group_size_(
  const MPIABI_Fint * group,
  int * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_size_)(
    group,
    size,
    ierror
  );
}

void (* mpiabi_group_rank_)(
  const MPIABI_Fint * group,
  int * rank,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_rank_(
  const MPIABI_Fint * group,
  int * rank,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_rank_)(
    group,
    rank,
    ierror
  );
}
void pmpi_group_rank_(
  const MPIABI_Fint * group,
  int * rank,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_rank_)(
    group,
    rank,
    ierror
  );
}

void (* mpiabi_group_translate_ranks_)(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * n,
  const int * ranks1,
  const MPIABI_Fint * group2,
  int * ranks2,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_translate_ranks_(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * n,
  const int * ranks1,
  const MPIABI_Fint * group2,
  int * ranks2,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_translate_ranks_)(
    group1,
    n,
    ranks1,
    group2,
    ranks2,
    ierror
  );
}
void pmpi_group_translate_ranks_(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * n,
  const int * ranks1,
  const MPIABI_Fint * group2,
  int * ranks2,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_translate_ranks_)(
    group1,
    n,
    ranks1,
    group2,
    ranks2,
    ierror
  );
}

void (* mpiabi_group_compare_)(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  int * result,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_compare_(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  int * result,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_compare_)(
    group1,
    group2,
    result,
    ierror
  );
}
void pmpi_group_compare_(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  int * result,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_compare_)(
    group1,
    group2,
    result,
    ierror
  );
}

void (* mpiabi_comm_group_)(
  const MPIABI_Fint * comm,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_group_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_group_)(
    comm,
    group,
    ierror
  );
}
void pmpi_comm_group_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_group_)(
    comm,
    group,
    ierror
  );
}

void (* mpiabi_group_union_)(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_union_(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_union_)(
    group1,
    group2,
    newgroup,
    ierror
  );
}
void pmpi_group_union_(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_union_)(
    group1,
    group2,
    newgroup,
    ierror
  );
}

void (* mpiabi_group_intersection_)(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_intersection_(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_intersection_)(
    group1,
    group2,
    newgroup,
    ierror
  );
}
void pmpi_group_intersection_(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_intersection_)(
    group1,
    group2,
    newgroup,
    ierror
  );
}

void (* mpiabi_group_difference_)(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_difference_(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_difference_)(
    group1,
    group2,
    newgroup,
    ierror
  );
}
void pmpi_group_difference_(
  const MPIABI_Fint * group1,
  const MPIABI_Fint * group2,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_difference_)(
    group1,
    group2,
    newgroup,
    ierror
  );
}

void (* mpiabi_group_incl_)(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  const int * ranks,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_incl_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  const int * ranks,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_incl_)(
    group,
    n,
    ranks,
    newgroup,
    ierror
  );
}
void pmpi_group_incl_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  const int * ranks,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_incl_)(
    group,
    n,
    ranks,
    newgroup,
    ierror
  );
}

void (* mpiabi_group_excl_)(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  const int * ranks,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_excl_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  const int * ranks,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_excl_)(
    group,
    n,
    ranks,
    newgroup,
    ierror
  );
}
void pmpi_group_excl_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  const int * ranks,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_excl_)(
    group,
    n,
    ranks,
    newgroup,
    ierror
  );
}

void (* mpiabi_group_range_incl_)(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  MPIABI_Fint * ranges,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_range_incl_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  MPIABI_Fint * ranges,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_range_incl_)(
    group,
    n,
    ranges,
    newgroup,
    ierror
  );
}
void pmpi_group_range_incl_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  MPIABI_Fint * ranges,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_range_incl_)(
    group,
    n,
    ranges,
    newgroup,
    ierror
  );
}

void (* mpiabi_group_range_excl_)(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  MPIABI_Fint * ranges,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_range_excl_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  MPIABI_Fint * ranges,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_range_excl_)(
    group,
    n,
    ranges,
    newgroup,
    ierror
  );
}
void pmpi_group_range_excl_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * n,
  MPIABI_Fint * ranges,
  MPIABI_Fint * newgroup,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_range_excl_)(
    group,
    n,
    ranges,
    newgroup,
    ierror
  );
}

void (* mpiabi_group_free_)(
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) = NULL;
void mpi_group_free_(
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_free_)(
    group,
    ierror
  );
}
void pmpi_group_free_(
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_group_free_)(
    group,
    ierror
  );
}

void (* mpiabi_comm_size_)(
  const MPIABI_Fint * comm,
  int * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_size_(
  const MPIABI_Fint * comm,
  int * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_size_)(
    comm,
    size,
    ierror
  );
}
void pmpi_comm_size_(
  const MPIABI_Fint * comm,
  int * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_size_)(
    comm,
    size,
    ierror
  );
}

void (* mpiabi_comm_rank_)(
  const MPIABI_Fint * comm,
  int * rank,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_rank_(
  const MPIABI_Fint * comm,
  int * rank,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_rank_)(
    comm,
    rank,
    ierror
  );
}
void pmpi_comm_rank_(
  const MPIABI_Fint * comm,
  int * rank,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_rank_)(
    comm,
    rank,
    ierror
  );
}

void (* mpiabi_comm_compare_)(
  const MPIABI_Fint * comm1,
  const MPIABI_Fint * comm2,
  int * result,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_compare_(
  const MPIABI_Fint * comm1,
  const MPIABI_Fint * comm2,
  int * result,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_compare_)(
    comm1,
    comm2,
    result,
    ierror
  );
}
void pmpi_comm_compare_(
  const MPIABI_Fint * comm1,
  const MPIABI_Fint * comm2,
  int * result,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_compare_)(
    comm1,
    comm2,
    result,
    ierror
  );
}

void (* mpiabi_comm_dup_)(
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_dup_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_dup_)(
    comm,
    newcomm,
    ierror
  );
}
void pmpi_comm_dup_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_dup_)(
    comm,
    newcomm,
    ierror
  );
}

void (* mpiabi_comm_dup_with_info_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * info,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_dup_with_info_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * info,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_dup_with_info_)(
    comm,
    info,
    newcomm,
    ierror
  );
}
void pmpi_comm_dup_with_info_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * info,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_dup_with_info_)(
    comm,
    info,
    newcomm,
    ierror
  );
}

void (* mpiabi_comm_idup_)(
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_idup_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_idup_)(
    comm,
    newcomm,
    request,
    ierror
  );
}
void pmpi_comm_idup_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_idup_)(
    comm,
    newcomm,
    request,
    ierror
  );
}

void (* mpiabi_comm_create_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * group,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_create_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * group,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_create_)(
    comm,
    group,
    newcomm,
    ierror
  );
}
void pmpi_comm_create_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * group,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_create_)(
    comm,
    group,
    newcomm,
    ierror
  );
}

void (* mpiabi_comm_create_group_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * group,
  const MPIABI_Fint * tag,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_create_group_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * group,
  const MPIABI_Fint * tag,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_create_group_)(
    comm,
    group,
    tag,
    newcomm,
    ierror
  );
}
void pmpi_comm_create_group_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * group,
  const MPIABI_Fint * tag,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_create_group_)(
    comm,
    group,
    tag,
    newcomm,
    ierror
  );
}

void (* mpiabi_comm_split_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * color,
  const MPIABI_Fint * key,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_split_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * color,
  const MPIABI_Fint * key,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_split_)(
    comm,
    color,
    key,
    newcomm,
    ierror
  );
}
void pmpi_comm_split_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * color,
  const MPIABI_Fint * key,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_split_)(
    comm,
    color,
    key,
    newcomm,
    ierror
  );
}

void (* mpiabi_comm_split_type_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * split_type,
  const MPIABI_Fint * key,
  const MPIABI_Fint * info,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_split_type_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * split_type,
  const MPIABI_Fint * key,
  const MPIABI_Fint * info,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_split_type_)(
    comm,
    split_type,
    key,
    info,
    newcomm,
    ierror
  );
}
void pmpi_comm_split_type_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * split_type,
  const MPIABI_Fint * key,
  const MPIABI_Fint * info,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_split_type_)(
    comm,
    split_type,
    key,
    info,
    newcomm,
    ierror
  );
}

void (* mpiabi_comm_free_)(
  MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_free_(
  MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_free_)(
    comm,
    ierror
  );
}
void pmpi_comm_free_(
  MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_free_)(
    comm,
    ierror
  );
}

void (* mpiabi_comm_set_info_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_set_info_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_set_info_)(
    comm,
    info,
    ierror
  );
}
void pmpi_comm_set_info_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_set_info_)(
    comm,
    info,
    ierror
  );
}

void (* mpiabi_comm_get_info_)(
  const MPIABI_Fint * comm,
  MPIABI_Fint * info,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_get_info_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_get_info_)(
    comm,
    info,
    ierror
  );
}
void pmpi_comm_get_info_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_get_info_)(
    comm,
    info,
    ierror
  );
}

void (* mpiabi_comm_test_inter_)(
  const MPIABI_Fint * comm,
  int * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_test_inter_(
  const MPIABI_Fint * comm,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_test_inter_)(
    comm,
    flag,
    ierror
  );
}
void pmpi_comm_test_inter_(
  const MPIABI_Fint * comm,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_test_inter_)(
    comm,
    flag,
    ierror
  );
}

void (* mpiabi_comm_remote_size_)(
  const MPIABI_Fint * comm,
  int * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_remote_size_(
  const MPIABI_Fint * comm,
  int * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_remote_size_)(
    comm,
    size,
    ierror
  );
}
void pmpi_comm_remote_size_(
  const MPIABI_Fint * comm,
  int * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_remote_size_)(
    comm,
    size,
    ierror
  );
}

void (* mpiabi_comm_remote_group_)(
  const MPIABI_Fint * comm,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_remote_group_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_remote_group_)(
    comm,
    group,
    ierror
  );
}
void pmpi_comm_remote_group_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_remote_group_)(
    comm,
    group,
    ierror
  );
}

void (* mpiabi_intercomm_create_)(
  const MPIABI_Fint * local_comm,
  const MPIABI_Fint * local_leader,
  const MPIABI_Fint * peer_comm,
  const MPIABI_Fint * remote_leader,
  const MPIABI_Fint * tag,
  MPIABI_Fint * newintercomm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_intercomm_create_(
  const MPIABI_Fint * local_comm,
  const MPIABI_Fint * local_leader,
  const MPIABI_Fint * peer_comm,
  const MPIABI_Fint * remote_leader,
  const MPIABI_Fint * tag,
  MPIABI_Fint * newintercomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_intercomm_create_)(
    local_comm,
    local_leader,
    peer_comm,
    remote_leader,
    tag,
    newintercomm,
    ierror
  );
}
void pmpi_intercomm_create_(
  const MPIABI_Fint * local_comm,
  const MPIABI_Fint * local_leader,
  const MPIABI_Fint * peer_comm,
  const MPIABI_Fint * remote_leader,
  const MPIABI_Fint * tag,
  MPIABI_Fint * newintercomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_intercomm_create_)(
    local_comm,
    local_leader,
    peer_comm,
    remote_leader,
    tag,
    newintercomm,
    ierror
  );
}

void (* mpiabi_intercomm_merge_)(
  const MPIABI_Fint * intercomm,
  const MPIABI_Fint * high,
  MPIABI_Fint * newintracomm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_intercomm_merge_(
  const MPIABI_Fint * intercomm,
  const MPIABI_Fint * high,
  MPIABI_Fint * newintracomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_intercomm_merge_)(
    intercomm,
    high,
    newintracomm,
    ierror
  );
}
void pmpi_intercomm_merge_(
  const MPIABI_Fint * intercomm,
  const MPIABI_Fint * high,
  MPIABI_Fint * newintracomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_intercomm_merge_)(
    intercomm,
    high,
    newintracomm,
    ierror
  );
}

void (* mpiabi_comm_create_keyval_)(
  MPIABI_Fint * comm_copy_attr_fn,
  MPIABI_Fint * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_create_keyval_(
  MPIABI_Fint * comm_copy_attr_fn,
  MPIABI_Fint * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_create_keyval_)(
    comm_copy_attr_fn,
    comm_delete_attr_fn,
    comm_keyval,
    extra_state,
    ierror
  );
}
void pmpi_comm_create_keyval_(
  MPIABI_Fint * comm_copy_attr_fn,
  MPIABI_Fint * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_create_keyval_)(
    comm_copy_attr_fn,
    comm_delete_attr_fn,
    comm_keyval,
    extra_state,
    ierror
  );
}

void (* mpiabi_keyval_create_)(
  MPIABI_Fint * comm_copy_attr_fn,
  MPIABI_Fint * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) = NULL;
void mpi_keyval_create_(
  MPIABI_Fint * comm_copy_attr_fn,
  MPIABI_Fint * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_keyval_create_)(
    comm_copy_attr_fn,
    comm_delete_attr_fn,
    comm_keyval,
    extra_state,
    ierror
  );
}
void pmpi_keyval_create_(
  MPIABI_Fint * comm_copy_attr_fn,
  MPIABI_Fint * comm_delete_attr_fn,
  int * comm_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_keyval_create_)(
    comm_copy_attr_fn,
    comm_delete_attr_fn,
    comm_keyval,
    extra_state,
    ierror
  );
}

void (* mpiabi_comm_free_keyval_)(
  int * comm_keyval,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_free_keyval_(
  int * comm_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_free_keyval_)(
    comm_keyval,
    ierror
  );
}
void pmpi_comm_free_keyval_(
  int * comm_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_free_keyval_)(
    comm_keyval,
    ierror
  );
}

void (* mpiabi_keyval_free_)(
  int * comm_keyval,
  MPIABI_Fint * ierror
) = NULL;
void mpi_keyval_free_(
  int * comm_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_keyval_free_)(
    comm_keyval,
    ierror
  );
}
void pmpi_keyval_free_(
  int * comm_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_keyval_free_)(
    comm_keyval,
    ierror
  );
}

void (* mpiabi_comm_set_attr_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_set_attr_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_set_attr_)(
    comm,
    comm_keyval,
    attribute_val,
    ierror
  );
}
void pmpi_comm_set_attr_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_set_attr_)(
    comm,
    comm_keyval,
    attribute_val,
    ierror
  );
}

void (* mpiabi_attr_put_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) = NULL;
void mpi_attr_put_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_attr_put_)(
    comm,
    comm_keyval,
    attribute_val,
    ierror
  );
}
void pmpi_attr_put_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_attr_put_)(
    comm,
    comm_keyval,
    attribute_val,
    ierror
  );
}

void (* mpiabi_comm_get_attr_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_get_attr_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_get_attr_)(
    comm,
    comm_keyval,
    attribute_val,
    flag,
    ierror
  );
}
void pmpi_comm_get_attr_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_get_attr_)(
    comm,
    comm_keyval,
    attribute_val,
    flag,
    ierror
  );
}

void (* mpiabi_attr_get_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_attr_get_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_attr_get_)(
    comm,
    comm_keyval,
    attribute_val,
    flag,
    ierror
  );
}
void pmpi_attr_get_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_attr_get_)(
    comm,
    comm_keyval,
    attribute_val,
    flag,
    ierror
  );
}

void (* mpiabi_comm_delete_attr_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_delete_attr_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_delete_attr_)(
    comm,
    comm_keyval,
    ierror
  );
}
void pmpi_comm_delete_attr_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_delete_attr_)(
    comm,
    comm_keyval,
    ierror
  );
}

void (* mpiabi_attr_delete_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  MPIABI_Fint * ierror
) = NULL;
void mpi_attr_delete_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_attr_delete_)(
    comm,
    comm_keyval,
    ierror
  );
}
void pmpi_attr_delete_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * comm_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_attr_delete_)(
    comm,
    comm_keyval,
    ierror
  );
}

void (* mpiabi_win_create_keyval_)(
  MPIABI_Fint * win_copy_attr_fn,
  MPIABI_Fint * win_delete_attr_fn,
  int * win_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_create_keyval_(
  MPIABI_Fint * win_copy_attr_fn,
  MPIABI_Fint * win_delete_attr_fn,
  int * win_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_create_keyval_)(
    win_copy_attr_fn,
    win_delete_attr_fn,
    win_keyval,
    extra_state,
    ierror
  );
}
void pmpi_win_create_keyval_(
  MPIABI_Fint * win_copy_attr_fn,
  MPIABI_Fint * win_delete_attr_fn,
  int * win_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_create_keyval_)(
    win_copy_attr_fn,
    win_delete_attr_fn,
    win_keyval,
    extra_state,
    ierror
  );
}

void (* mpiabi_win_free_keyval_)(
  int * win_keyval,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_free_keyval_(
  int * win_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_free_keyval_)(
    win_keyval,
    ierror
  );
}
void pmpi_win_free_keyval_(
  int * win_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_free_keyval_)(
    win_keyval,
    ierror
  );
}

void (* mpiabi_win_set_attr_)(
  const MPIABI_Fint * win,
  const MPIABI_Fint * win_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_set_attr_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * win_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_set_attr_)(
    win,
    win_keyval,
    attribute_val,
    ierror
  );
}
void pmpi_win_set_attr_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * win_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_set_attr_)(
    win,
    win_keyval,
    attribute_val,
    ierror
  );
}

void (* mpiabi_win_get_attr_)(
  const MPIABI_Fint * win,
  const MPIABI_Fint * win_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_get_attr_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * win_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_get_attr_)(
    win,
    win_keyval,
    attribute_val,
    flag,
    ierror
  );
}
void pmpi_win_get_attr_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * win_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_get_attr_)(
    win,
    win_keyval,
    attribute_val,
    flag,
    ierror
  );
}

void (* mpiabi_win_delete_attr_)(
  const MPIABI_Fint * win,
  const MPIABI_Fint * win_keyval,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_delete_attr_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * win_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_delete_attr_)(
    win,
    win_keyval,
    ierror
  );
}
void pmpi_win_delete_attr_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * win_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_delete_attr_)(
    win,
    win_keyval,
    ierror
  );
}

void (* mpiabi_type_create_keyval_)(
  MPIABI_Fint * type_copy_attr_fn,
  MPIABI_Fint * type_delete_attr_fn,
  int * type_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_create_keyval_(
  MPIABI_Fint * type_copy_attr_fn,
  MPIABI_Fint * type_delete_attr_fn,
  int * type_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_keyval_)(
    type_copy_attr_fn,
    type_delete_attr_fn,
    type_keyval,
    extra_state,
    ierror
  );
}
void pmpi_type_create_keyval_(
  MPIABI_Fint * type_copy_attr_fn,
  MPIABI_Fint * type_delete_attr_fn,
  int * type_keyval,
  void * extra_state,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_create_keyval_)(
    type_copy_attr_fn,
    type_delete_attr_fn,
    type_keyval,
    extra_state,
    ierror
  );
}

void (* mpiabi_type_free_keyval_)(
  int * type_keyval,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_free_keyval_(
  int * type_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_free_keyval_)(
    type_keyval,
    ierror
  );
}
void pmpi_type_free_keyval_(
  int * type_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_free_keyval_)(
    type_keyval,
    ierror
  );
}

void (* mpiabi_type_set_attr_)(
  const MPIABI_Fint * type,
  const MPIABI_Fint * type_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_set_attr_(
  const MPIABI_Fint * type,
  const MPIABI_Fint * type_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_set_attr_)(
    type,
    type_keyval,
    attribute_val,
    ierror
  );
}
void pmpi_type_set_attr_(
  const MPIABI_Fint * type,
  const MPIABI_Fint * type_keyval,
  void * attribute_val,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_set_attr_)(
    type,
    type_keyval,
    attribute_val,
    ierror
  );
}

void (* mpiabi_type_get_attr_)(
  const MPIABI_Fint * type,
  const MPIABI_Fint * type_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_get_attr_(
  const MPIABI_Fint * type,
  const MPIABI_Fint * type_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_attr_)(
    type,
    type_keyval,
    attribute_val,
    flag,
    ierror
  );
}
void pmpi_type_get_attr_(
  const MPIABI_Fint * type,
  const MPIABI_Fint * type_keyval,
  void * attribute_val,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_get_attr_)(
    type,
    type_keyval,
    attribute_val,
    flag,
    ierror
  );
}

void (* mpiabi_type_delete_attr_)(
  const MPIABI_Fint * type,
  const MPIABI_Fint * type_keyval,
  MPIABI_Fint * ierror
) = NULL;
void mpi_type_delete_attr_(
  const MPIABI_Fint * type,
  const MPIABI_Fint * type_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_delete_attr_)(
    type,
    type_keyval,
    ierror
  );
}
void pmpi_type_delete_attr_(
  const MPIABI_Fint * type,
  const MPIABI_Fint * type_keyval,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_type_delete_attr_)(
    type,
    type_keyval,
    ierror
  );
}

void (* mpiabi_comm_set_name_)(
  const MPIABI_Fint * comm,
  const char * comm_name,
  MPIABI_Fint * ierror,
  size_t comm_name_len
) = NULL;
void mpi_comm_set_name_(
  const MPIABI_Fint * comm,
  const char * comm_name,
  MPIABI_Fint * ierror,
  size_t comm_name_len
) {
  return (* mpiabi_comm_set_name_)(
    comm,
    comm_name,
    ierror,
    comm_name_len
  );
}
void pmpi_comm_set_name_(
  const MPIABI_Fint * comm,
  const char * comm_name,
  MPIABI_Fint * ierror,
  size_t comm_name_len
) {
  return (* mpiabi_comm_set_name_)(
    comm,
    comm_name,
    ierror,
    comm_name_len
  );
}

void (* mpiabi_comm_get_name_)(
  const MPIABI_Fint * comm,
  char * comm_name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t comm_name_len
) = NULL;
void mpi_comm_get_name_(
  const MPIABI_Fint * comm,
  char * comm_name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t comm_name_len
) {
  return (* mpiabi_comm_get_name_)(
    comm,
    comm_name,
    resultlen,
    ierror,
    comm_name_len
  );
}
void pmpi_comm_get_name_(
  const MPIABI_Fint * comm,
  char * comm_name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t comm_name_len
) {
  return (* mpiabi_comm_get_name_)(
    comm,
    comm_name,
    resultlen,
    ierror,
    comm_name_len
  );
}

void (* mpiabi_type_set_name_)(
  const MPIABI_Fint * type,
  const char * type_name,
  MPIABI_Fint * ierror,
  size_t type_name_len
) = NULL;
void mpi_type_set_name_(
  const MPIABI_Fint * type,
  const char * type_name,
  MPIABI_Fint * ierror,
  size_t type_name_len
) {
  return (* mpiabi_type_set_name_)(
    type,
    type_name,
    ierror,
    type_name_len
  );
}
void pmpi_type_set_name_(
  const MPIABI_Fint * type,
  const char * type_name,
  MPIABI_Fint * ierror,
  size_t type_name_len
) {
  return (* mpiabi_type_set_name_)(
    type,
    type_name,
    ierror,
    type_name_len
  );
}

void (* mpiabi_type_get_name_)(
  const MPIABI_Fint * type,
  char * type_name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t type_name_len
) = NULL;
void mpi_type_get_name_(
  const MPIABI_Fint * type,
  char * type_name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t type_name_len
) {
  return (* mpiabi_type_get_name_)(
    type,
    type_name,
    resultlen,
    ierror,
    type_name_len
  );
}
void pmpi_type_get_name_(
  const MPIABI_Fint * type,
  char * type_name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t type_name_len
) {
  return (* mpiabi_type_get_name_)(
    type,
    type_name,
    resultlen,
    ierror,
    type_name_len
  );
}

void (* mpiabi_win_set_name_)(
  const MPIABI_Fint * win,
  const char * win_name,
  MPIABI_Fint * ierror,
  size_t win_name_len
) = NULL;
void mpi_win_set_name_(
  const MPIABI_Fint * win,
  const char * win_name,
  MPIABI_Fint * ierror,
  size_t win_name_len
) {
  return (* mpiabi_win_set_name_)(
    win,
    win_name,
    ierror,
    win_name_len
  );
}
void pmpi_win_set_name_(
  const MPIABI_Fint * win,
  const char * win_name,
  MPIABI_Fint * ierror,
  size_t win_name_len
) {
  return (* mpiabi_win_set_name_)(
    win,
    win_name,
    ierror,
    win_name_len
  );
}

void (* mpiabi_win_get_name_)(
  const MPIABI_Fint * win,
  char * win_name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t win_name_len
) = NULL;
void mpi_win_get_name_(
  const MPIABI_Fint * win,
  char * win_name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t win_name_len
) {
  return (* mpiabi_win_get_name_)(
    win,
    win_name,
    resultlen,
    ierror,
    win_name_len
  );
}
void pmpi_win_get_name_(
  const MPIABI_Fint * win,
  char * win_name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t win_name_len
) {
  return (* mpiabi_win_get_name_)(
    win,
    win_name,
    resultlen,
    ierror,
    win_name_len
  );
}

void (* mpiabi_cart_create_)(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * ndims,
  const int * dims,
  const int * periods,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_cart,
  MPIABI_Fint * ierror
) = NULL;
void mpi_cart_create_(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * ndims,
  const int * dims,
  const int * periods,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_cart,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_create_)(
    comm_old,
    ndims,
    dims,
    periods,
    reorder,
    comm_cart,
    ierror
  );
}
void pmpi_cart_create_(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * ndims,
  const int * dims,
  const int * periods,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_cart,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_create_)(
    comm_old,
    ndims,
    dims,
    periods,
    reorder,
    comm_cart,
    ierror
  );
}

void (* mpiabi_dims_create_)(
  const MPIABI_Fint * nnodes,
  const MPIABI_Fint * ndims,
  int * dims,
  MPIABI_Fint * ierror
) = NULL;
void mpi_dims_create_(
  const MPIABI_Fint * nnodes,
  const MPIABI_Fint * ndims,
  int * dims,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_dims_create_)(
    nnodes,
    ndims,
    dims,
    ierror
  );
}
void pmpi_dims_create_(
  const MPIABI_Fint * nnodes,
  const MPIABI_Fint * ndims,
  int * dims,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_dims_create_)(
    nnodes,
    ndims,
    dims,
    ierror
  );
}

void (* mpiabi_graph_create_)(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * nnodes,
  const int * index,
  const int * edges,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_graph,
  MPIABI_Fint * ierror
) = NULL;
void mpi_graph_create_(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * nnodes,
  const int * index,
  const int * edges,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_graph,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graph_create_)(
    comm_old,
    nnodes,
    index,
    edges,
    reorder,
    comm_graph,
    ierror
  );
}
void pmpi_graph_create_(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * nnodes,
  const int * index,
  const int * edges,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_graph,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graph_create_)(
    comm_old,
    nnodes,
    index,
    edges,
    reorder,
    comm_graph,
    ierror
  );
}

void (* mpiabi_dist_graph_create_adjacent_)(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * indegree,
  const int * sources,
  const int * sourceweights,
  const MPIABI_Fint * outdegree,
  const int * destinations,
  const int * destweights,
  const MPIABI_Fint * info,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_dist_graph,
  MPIABI_Fint * ierror
) = NULL;
void mpi_dist_graph_create_adjacent_(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * indegree,
  const int * sources,
  const int * sourceweights,
  const MPIABI_Fint * outdegree,
  const int * destinations,
  const int * destweights,
  const MPIABI_Fint * info,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_dist_graph,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_dist_graph_create_adjacent_)(
    comm_old,
    indegree,
    sources,
    sourceweights,
    outdegree,
    destinations,
    destweights,
    info,
    reorder,
    comm_dist_graph,
    ierror
  );
}
void pmpi_dist_graph_create_adjacent_(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * indegree,
  const int * sources,
  const int * sourceweights,
  const MPIABI_Fint * outdegree,
  const int * destinations,
  const int * destweights,
  const MPIABI_Fint * info,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_dist_graph,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_dist_graph_create_adjacent_)(
    comm_old,
    indegree,
    sources,
    sourceweights,
    outdegree,
    destinations,
    destweights,
    info,
    reorder,
    comm_dist_graph,
    ierror
  );
}

void (* mpiabi_dist_graph_create_)(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * n,
  const int * sources,
  const int * degrees,
  const int * destinations,
  const int * weights,
  const MPIABI_Fint * info,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_dist_graph,
  MPIABI_Fint * ierror
) = NULL;
void mpi_dist_graph_create_(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * n,
  const int * sources,
  const int * degrees,
  const int * destinations,
  const int * weights,
  const MPIABI_Fint * info,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_dist_graph,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_dist_graph_create_)(
    comm_old,
    n,
    sources,
    degrees,
    destinations,
    weights,
    info,
    reorder,
    comm_dist_graph,
    ierror
  );
}
void pmpi_dist_graph_create_(
  const MPIABI_Fint * comm_old,
  const MPIABI_Fint * n,
  const int * sources,
  const int * degrees,
  const int * destinations,
  const int * weights,
  const MPIABI_Fint * info,
  const MPIABI_Fint * reorder,
  MPIABI_Fint * comm_dist_graph,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_dist_graph_create_)(
    comm_old,
    n,
    sources,
    degrees,
    destinations,
    weights,
    info,
    reorder,
    comm_dist_graph,
    ierror
  );
}

void (* mpiabi_topo_test_)(
  const MPIABI_Fint * comm,
  int * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_topo_test_(
  const MPIABI_Fint * comm,
  int * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_topo_test_)(
    comm,
    status,
    ierror
  );
}
void pmpi_topo_test_(
  const MPIABI_Fint * comm,
  int * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_topo_test_)(
    comm,
    status,
    ierror
  );
}

void (* mpiabi_graphdims_get_)(
  const MPIABI_Fint * comm,
  int * nnodes,
  int * nedges,
  MPIABI_Fint * ierror
) = NULL;
void mpi_graphdims_get_(
  const MPIABI_Fint * comm,
  int * nnodes,
  int * nedges,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graphdims_get_)(
    comm,
    nnodes,
    nedges,
    ierror
  );
}
void pmpi_graphdims_get_(
  const MPIABI_Fint * comm,
  int * nnodes,
  int * nedges,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graphdims_get_)(
    comm,
    nnodes,
    nedges,
    ierror
  );
}

void (* mpiabi_graph_get_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * maxindex,
  const MPIABI_Fint * maxedges,
  int * index,
  int * edges,
  MPIABI_Fint * ierror
) = NULL;
void mpi_graph_get_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * maxindex,
  const MPIABI_Fint * maxedges,
  int * index,
  int * edges,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graph_get_)(
    comm,
    maxindex,
    maxedges,
    index,
    edges,
    ierror
  );
}
void pmpi_graph_get_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * maxindex,
  const MPIABI_Fint * maxedges,
  int * index,
  int * edges,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graph_get_)(
    comm,
    maxindex,
    maxedges,
    index,
    edges,
    ierror
  );
}

void (* mpiabi_cartdim_get_)(
  const MPIABI_Fint * comm,
  int * ndims,
  MPIABI_Fint * ierror
) = NULL;
void mpi_cartdim_get_(
  const MPIABI_Fint * comm,
  int * ndims,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cartdim_get_)(
    comm,
    ndims,
    ierror
  );
}
void pmpi_cartdim_get_(
  const MPIABI_Fint * comm,
  int * ndims,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cartdim_get_)(
    comm,
    ndims,
    ierror
  );
}

void (* mpiabi_cart_get_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * maxdims,
  int * dims,
  int * periods,
  int * coords,
  MPIABI_Fint * ierror
) = NULL;
void mpi_cart_get_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * maxdims,
  int * dims,
  int * periods,
  int * coords,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_get_)(
    comm,
    maxdims,
    dims,
    periods,
    coords,
    ierror
  );
}
void pmpi_cart_get_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * maxdims,
  int * dims,
  int * periods,
  int * coords,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_get_)(
    comm,
    maxdims,
    dims,
    periods,
    coords,
    ierror
  );
}

void (* mpiabi_cart_rank_)(
  const MPIABI_Fint * comm,
  const int * coords,
  int * rank,
  MPIABI_Fint * ierror
) = NULL;
void mpi_cart_rank_(
  const MPIABI_Fint * comm,
  const int * coords,
  int * rank,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_rank_)(
    comm,
    coords,
    rank,
    ierror
  );
}
void pmpi_cart_rank_(
  const MPIABI_Fint * comm,
  const int * coords,
  int * rank,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_rank_)(
    comm,
    coords,
    rank,
    ierror
  );
}

void (* mpiabi_cart_coords_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * maxdims,
  int * coords,
  MPIABI_Fint * ierror
) = NULL;
void mpi_cart_coords_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * maxdims,
  int * coords,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_coords_)(
    comm,
    rank,
    maxdims,
    coords,
    ierror
  );
}
void pmpi_cart_coords_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * maxdims,
  int * coords,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_coords_)(
    comm,
    rank,
    maxdims,
    coords,
    ierror
  );
}

void (* mpiabi_graph_neighbors_count_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * rank,
  int * nneighbors,
  MPIABI_Fint * ierror
) = NULL;
void mpi_graph_neighbors_count_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * rank,
  int * nneighbors,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graph_neighbors_count_)(
    comm,
    rank,
    nneighbors,
    ierror
  );
}
void pmpi_graph_neighbors_count_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * rank,
  int * nneighbors,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graph_neighbors_count_)(
    comm,
    rank,
    nneighbors,
    ierror
  );
}

void (* mpiabi_graph_neighbors_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * maxneighbors,
  int * neighbors,
  MPIABI_Fint * ierror
) = NULL;
void mpi_graph_neighbors_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * maxneighbors,
  int * neighbors,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graph_neighbors_)(
    comm,
    rank,
    maxneighbors,
    neighbors,
    ierror
  );
}
void pmpi_graph_neighbors_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * maxneighbors,
  int * neighbors,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graph_neighbors_)(
    comm,
    rank,
    maxneighbors,
    neighbors,
    ierror
  );
}

void (* mpiabi_dist_graph_neighbors_count_)(
  const MPIABI_Fint * comm,
  int * indegree,
  int * outdegree,
  int * weighted,
  MPIABI_Fint * ierror
) = NULL;
void mpi_dist_graph_neighbors_count_(
  const MPIABI_Fint * comm,
  int * indegree,
  int * outdegree,
  int * weighted,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_dist_graph_neighbors_count_)(
    comm,
    indegree,
    outdegree,
    weighted,
    ierror
  );
}
void pmpi_dist_graph_neighbors_count_(
  const MPIABI_Fint * comm,
  int * indegree,
  int * outdegree,
  int * weighted,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_dist_graph_neighbors_count_)(
    comm,
    indegree,
    outdegree,
    weighted,
    ierror
  );
}

void (* mpiabi_dist_graph_neighbors_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * maxindeegree,
  int * sources,
  int * wourceweights,
  const MPIABI_Fint * maxoutdegree,
  int * destinations,
  int * destweights,
  MPIABI_Fint * ierror
) = NULL;
void mpi_dist_graph_neighbors_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * maxindeegree,
  int * sources,
  int * wourceweights,
  const MPIABI_Fint * maxoutdegree,
  int * destinations,
  int * destweights,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_dist_graph_neighbors_)(
    comm,
    maxindeegree,
    sources,
    wourceweights,
    maxoutdegree,
    destinations,
    destweights,
    ierror
  );
}
void pmpi_dist_graph_neighbors_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * maxindeegree,
  int * sources,
  int * wourceweights,
  const MPIABI_Fint * maxoutdegree,
  int * destinations,
  int * destweights,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_dist_graph_neighbors_)(
    comm,
    maxindeegree,
    sources,
    wourceweights,
    maxoutdegree,
    destinations,
    destweights,
    ierror
  );
}

void (* mpiabi_cart_shift_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * direction,
  const MPIABI_Fint * disp,
  int * rank_source,
  int * rank_dest,
  MPIABI_Fint * ierror
) = NULL;
void mpi_cart_shift_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * direction,
  const MPIABI_Fint * disp,
  int * rank_source,
  int * rank_dest,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_shift_)(
    comm,
    direction,
    disp,
    rank_source,
    rank_dest,
    ierror
  );
}
void pmpi_cart_shift_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * direction,
  const MPIABI_Fint * disp,
  int * rank_source,
  int * rank_dest,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_shift_)(
    comm,
    direction,
    disp,
    rank_source,
    rank_dest,
    ierror
  );
}

void (* mpiabi_cart_sub_)(
  const MPIABI_Fint * comm,
  const int * remain_dims,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_cart_sub_(
  const MPIABI_Fint * comm,
  const int * remain_dims,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_sub_)(
    comm,
    remain_dims,
    newcomm,
    ierror
  );
}
void pmpi_cart_sub_(
  const MPIABI_Fint * comm,
  const int * remain_dims,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_sub_)(
    comm,
    remain_dims,
    newcomm,
    ierror
  );
}

void (* mpiabi_cart_map_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * ndims,
  const int * dims,
  const int * periods,
  int * newrank,
  MPIABI_Fint * ierror
) = NULL;
void mpi_cart_map_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * ndims,
  const int * dims,
  const int * periods,
  int * newrank,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_map_)(
    comm,
    ndims,
    dims,
    periods,
    newrank,
    ierror
  );
}
void pmpi_cart_map_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * ndims,
  const int * dims,
  const int * periods,
  int * newrank,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_cart_map_)(
    comm,
    ndims,
    dims,
    periods,
    newrank,
    ierror
  );
}

void (* mpiabi_graph_map_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * nnodes,
  const int * index,
  const int * edges,
  int * newrank,
  MPIABI_Fint * ierror
) = NULL;
void mpi_graph_map_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * nnodes,
  const int * index,
  const int * edges,
  int * newrank,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graph_map_)(
    comm,
    nnodes,
    index,
    edges,
    newrank,
    ierror
  );
}
void pmpi_graph_map_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * nnodes,
  const int * index,
  const int * edges,
  int * newrank,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_graph_map_)(
    comm,
    nnodes,
    index,
    edges,
    newrank,
    ierror
  );
}

void (* mpiabi_neighbor_allgather_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_neighbor_allgather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_neighbor_allgather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    ierror
  );
}
void pmpi_neighbor_allgather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_neighbor_allgather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    ierror
  );
}

void (* mpiabi_neighbor_allgatherv_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_neighbor_allgatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_neighbor_allgatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    comm,
    ierror
  );
}
void pmpi_neighbor_allgatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_neighbor_allgatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    comm,
    ierror
  );
}

void (* mpiabi_neighbor_alltoall_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_neighbor_alltoall_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_neighbor_alltoall_)(
    sendbuf,
    sendcount,
    senddtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    ierror
  );
}
void pmpi_neighbor_alltoall_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_neighbor_alltoall_)(
    sendbuf,
    sendcount,
    senddtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    ierror
  );
}

void (* mpiabi_neighbor_alltoallv_)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_neighbor_alltoallv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_neighbor_alltoallv_)(
    sendbuf,
    sendcounts,
    sdispls,
    senddtype,
    recvbuf,
    recvcounts,
    rdispls,
    recvtype,
    comm,
    ierror
  );
}
void pmpi_neighbor_alltoallv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_neighbor_alltoallv_)(
    sendbuf,
    sendcounts,
    sdispls,
    senddtype,
    recvbuf,
    recvcounts,
    rdispls,
    recvtype,
    comm,
    ierror
  );
}

void (* mpiabi_neighbor_alltoallw_)(
  const void * sendbuf,
  const int * sendcounts,
  const MPIABI_Fint * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_neighbor_alltoallw_(
  const void * sendbuf,
  const int * sendcounts,
  const MPIABI_Fint * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_neighbor_alltoallw_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    recvtypes,
    comm,
    ierror
  );
}
void pmpi_neighbor_alltoallw_(
  const void * sendbuf,
  const int * sendcounts,
  const MPIABI_Fint * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_neighbor_alltoallw_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    recvtypes,
    comm,
    ierror
  );
}

void (* mpiabi_ineighbor_allgather_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ineighbor_allgather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ineighbor_allgather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    request,
    ierror
  );
}
void pmpi_ineighbor_allgather_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ineighbor_allgather_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ineighbor_allgatherv_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ineighbor_allgatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ineighbor_allgatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    comm,
    request,
    ierror
  );
}
void pmpi_ineighbor_allgatherv_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * sendtype,
  void * recvbuf,
  const int * recvcounts,
  const int * displs,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ineighbor_allgatherv_)(
    sendbuf,
    sendcount,
    sendtype,
    recvbuf,
    recvcounts,
    displs,
    recvtype,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ineighbor_alltoall_)(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ineighbor_alltoall_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ineighbor_alltoall_)(
    sendbuf,
    sendcount,
    senddtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    request,
    ierror
  );
}
void pmpi_ineighbor_alltoall_(
  const void * sendbuf,
  const MPIABI_Fint * sendcount,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const MPIABI_Fint * recvcount,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ineighbor_alltoall_)(
    sendbuf,
    sendcount,
    senddtype,
    recvbuf,
    recvcount,
    recvtype,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ineighbor_alltoallv_)(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ineighbor_alltoallv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ineighbor_alltoallv_)(
    sendbuf,
    sendcounts,
    sdispls,
    senddtype,
    recvbuf,
    recvcounts,
    rdispls,
    recvtype,
    comm,
    request,
    ierror
  );
}
void pmpi_ineighbor_alltoallv_(
  const void * sendbuf,
  const int * sendcounts,
  const int * sdispls,
  const MPIABI_Fint * senddtype,
  void * recvbuf,
  const int * recvcounts,
  const int * rdispls,
  const MPIABI_Fint * recvtype,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ineighbor_alltoallv_)(
    sendbuf,
    sendcounts,
    sdispls,
    senddtype,
    recvbuf,
    recvcounts,
    rdispls,
    recvtype,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_ineighbor_alltoallw_)(
  const void * sendbuf,
  const int * sendcounts,
  const MPIABI_Fint * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_ineighbor_alltoallw_(
  const void * sendbuf,
  const int * sendcounts,
  const MPIABI_Fint * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ineighbor_alltoallw_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    recvtypes,
    comm,
    request,
    ierror
  );
}
void pmpi_ineighbor_alltoallw_(
  const void * sendbuf,
  const int * sendcounts,
  const MPIABI_Fint * sdispls,
  const MPIABI_Fint * sendtypes,
  void * recvbuf,
  const int * recvcounts,
  const MPIABI_Fint * rdispls,
  const MPIABI_Fint * recvtypes,
  const MPIABI_Fint * comm,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_ineighbor_alltoallw_)(
    sendbuf,
    sendcounts,
    sdispls,
    sendtypes,
    recvbuf,
    recvcounts,
    rdispls,
    recvtypes,
    comm,
    request,
    ierror
  );
}

void (* mpiabi_get_version_)(
  int * version,
  int * subversion,
  MPIABI_Fint * ierror
) = NULL;
void mpi_get_version_(
  int * version,
  int * subversion,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_version_)(
    version,
    subversion,
    ierror
  );
}
void pmpi_get_version_(
  int * version,
  int * subversion,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_version_)(
    version,
    subversion,
    ierror
  );
}

void (* mpiabi_get_library_version_)(
  char * version,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t version_len
) = NULL;
void mpi_get_library_version_(
  char * version,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t version_len
) {
  return (* mpiabi_get_library_version_)(
    version,
    resultlen,
    ierror,
    version_len
  );
}
void pmpi_get_library_version_(
  char * version,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t version_len
) {
  return (* mpiabi_get_library_version_)(
    version,
    resultlen,
    ierror,
    version_len
  );
}

void (* mpiabi_get_processor_name_)(
  char * name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t name_len
) = NULL;
void mpi_get_processor_name_(
  char * name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t name_len
) {
  return (* mpiabi_get_processor_name_)(
    name,
    resultlen,
    ierror,
    name_len
  );
}
void pmpi_get_processor_name_(
  char * name,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t name_len
) {
  return (* mpiabi_get_processor_name_)(
    name,
    resultlen,
    ierror,
    name_len
  );
}

void (* mpiabi_alloc_mem_)(
  const MPIABI_Fint * size,
  const MPIABI_Fint * info,
  void * baseptr,
  MPIABI_Fint * ierror
) = NULL;
void mpi_alloc_mem_(
  const MPIABI_Fint * size,
  const MPIABI_Fint * info,
  void * baseptr,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_alloc_mem_)(
    size,
    info,
    baseptr,
    ierror
  );
}
void pmpi_alloc_mem_(
  const MPIABI_Fint * size,
  const MPIABI_Fint * info,
  void * baseptr,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_alloc_mem_)(
    size,
    info,
    baseptr,
    ierror
  );
}

void (* mpiabi_free_mem_)(
  void * base,
  MPIABI_Fint * ierror
) = NULL;
void mpi_free_mem_(
  void * base,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_free_mem_)(
    base,
    ierror
  );
}
void pmpi_free_mem_(
  void * base,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_free_mem_)(
    base,
    ierror
  );
}

void (* mpiabi_comm_create_errhandler_)(
  MPIABI_Fint * comm_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_create_errhandler_(
  MPIABI_Fint * comm_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_create_errhandler_)(
    comm_errhandler_fn,
    errhandler,
    ierror
  );
}
void pmpi_comm_create_errhandler_(
  MPIABI_Fint * comm_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_create_errhandler_)(
    comm_errhandler_fn,
    errhandler,
    ierror
  );
}

void (* mpiabi_errhandler_create_)(
  MPIABI_Fint * comm_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_errhandler_create_(
  MPIABI_Fint * comm_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_errhandler_create_)(
    comm_errhandler_fn,
    errhandler,
    ierror
  );
}
void pmpi_errhandler_create_(
  MPIABI_Fint * comm_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_errhandler_create_)(
    comm_errhandler_fn,
    errhandler,
    ierror
  );
}

void (* mpiabi_comm_set_errhandler_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_set_errhandler_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_set_errhandler_)(
    comm,
    errhandler,
    ierror
  );
}
void pmpi_comm_set_errhandler_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_set_errhandler_)(
    comm,
    errhandler,
    ierror
  );
}

void (* mpiabi_errhandler_set_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_errhandler_set_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_errhandler_set_)(
    comm,
    errhandler,
    ierror
  );
}
void pmpi_errhandler_set_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_errhandler_set_)(
    comm,
    errhandler,
    ierror
  );
}

void (* mpiabi_comm_get_errhandler_)(
  const MPIABI_Fint * comm,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_get_errhandler_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_get_errhandler_)(
    comm,
    errhandler,
    ierror
  );
}
void pmpi_comm_get_errhandler_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_get_errhandler_)(
    comm,
    errhandler,
    ierror
  );
}

void (* mpiabi_errhandler_get_)(
  const MPIABI_Fint * comm,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_errhandler_get_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_errhandler_get_)(
    comm,
    errhandler,
    ierror
  );
}
void pmpi_errhandler_get_(
  const MPIABI_Fint * comm,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_errhandler_get_)(
    comm,
    errhandler,
    ierror
  );
}

void (* mpiabi_win_create_errhandler_)(
  MPIABI_Fint * win_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_create_errhandler_(
  MPIABI_Fint * win_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_create_errhandler_)(
    win_errhandler_fn,
    errhandler,
    ierror
  );
}
void pmpi_win_create_errhandler_(
  MPIABI_Fint * win_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_create_errhandler_)(
    win_errhandler_fn,
    errhandler,
    ierror
  );
}

void (* mpiabi_win_set_errhandler_)(
  const MPIABI_Fint * win,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_set_errhandler_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_set_errhandler_)(
    win,
    errhandler,
    ierror
  );
}
void pmpi_win_set_errhandler_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_set_errhandler_)(
    win,
    errhandler,
    ierror
  );
}

void (* mpiabi_win_get_errhandler_)(
  const MPIABI_Fint * win,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_get_errhandler_(
  const MPIABI_Fint * win,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_get_errhandler_)(
    win,
    errhandler,
    ierror
  );
}
void pmpi_win_get_errhandler_(
  const MPIABI_Fint * win,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_get_errhandler_)(
    win,
    errhandler,
    ierror
  );
}

void (* mpiabi_file_create_errhandler_)(
  MPIABI_Fint * file_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_create_errhandler_(
  MPIABI_Fint * file_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_create_errhandler_)(
    file_errhandler_fn,
    errhandler,
    ierror
  );
}
void pmpi_file_create_errhandler_(
  MPIABI_Fint * file_errhandler_fn,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_create_errhandler_)(
    file_errhandler_fn,
    errhandler,
    ierror
  );
}

void (* mpiabi_file_set_errhandler_)(
  const MPIABI_Fint * file,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_set_errhandler_(
  const MPIABI_Fint * file,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_set_errhandler_)(
    file,
    errhandler,
    ierror
  );
}
void pmpi_file_set_errhandler_(
  const MPIABI_Fint * file,
  const MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_set_errhandler_)(
    file,
    errhandler,
    ierror
  );
}

void (* mpiabi_file_get_errhandler_)(
  const MPIABI_Fint * file,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_get_errhandler_(
  const MPIABI_Fint * file,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_errhandler_)(
    file,
    errhandler,
    ierror
  );
}
void pmpi_file_get_errhandler_(
  const MPIABI_Fint * file,
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_errhandler_)(
    file,
    errhandler,
    ierror
  );
}

void (* mpiabi_errhandler_free_)(
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) = NULL;
void mpi_errhandler_free_(
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_errhandler_free_)(
    errhandler,
    ierror
  );
}
void pmpi_errhandler_free_(
  MPIABI_Fint * errhandler,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_errhandler_free_)(
    errhandler,
    ierror
  );
}

void (* mpiabi_error_string_)(
  const MPIABI_Fint * errorcode,
  char * string,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t string_len
) = NULL;
void mpi_error_string_(
  const MPIABI_Fint * errorcode,
  char * string,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t string_len
) {
  return (* mpiabi_error_string_)(
    errorcode,
    string,
    resultlen,
    ierror,
    string_len
  );
}
void pmpi_error_string_(
  const MPIABI_Fint * errorcode,
  char * string,
  int * resultlen,
  MPIABI_Fint * ierror,
  size_t string_len
) {
  return (* mpiabi_error_string_)(
    errorcode,
    string,
    resultlen,
    ierror,
    string_len
  );
}

void (* mpiabi_error_class_)(
  const MPIABI_Fint * errorcode,
  int * errorclass,
  MPIABI_Fint * ierror
) = NULL;
void mpi_error_class_(
  const MPIABI_Fint * errorcode,
  int * errorclass,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_error_class_)(
    errorcode,
    errorclass,
    ierror
  );
}
void pmpi_error_class_(
  const MPIABI_Fint * errorcode,
  int * errorclass,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_error_class_)(
    errorcode,
    errorclass,
    ierror
  );
}

void (* mpiabi_add_error_class_)(
  int * errorclass,
  MPIABI_Fint * ierror
) = NULL;
void mpi_add_error_class_(
  int * errorclass,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_add_error_class_)(
    errorclass,
    ierror
  );
}
void pmpi_add_error_class_(
  int * errorclass,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_add_error_class_)(
    errorclass,
    ierror
  );
}

void (* mpiabi_add_error_code_)(
  const MPIABI_Fint * errorclass,
  int * errorcode,
  MPIABI_Fint * ierror
) = NULL;
void mpi_add_error_code_(
  const MPIABI_Fint * errorclass,
  int * errorcode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_add_error_code_)(
    errorclass,
    errorcode,
    ierror
  );
}
void pmpi_add_error_code_(
  const MPIABI_Fint * errorclass,
  int * errorcode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_add_error_code_)(
    errorclass,
    errorcode,
    ierror
  );
}

void (* mpiabi_add_error_string_)(
  const MPIABI_Fint * errorcode,
  const char * string,
  MPIABI_Fint * ierror,
  size_t string_len
) = NULL;
void mpi_add_error_string_(
  const MPIABI_Fint * errorcode,
  const char * string,
  MPIABI_Fint * ierror,
  size_t string_len
) {
  return (* mpiabi_add_error_string_)(
    errorcode,
    string,
    ierror,
    string_len
  );
}
void pmpi_add_error_string_(
  const MPIABI_Fint * errorcode,
  const char * string,
  MPIABI_Fint * ierror,
  size_t string_len
) {
  return (* mpiabi_add_error_string_)(
    errorcode,
    string,
    ierror,
    string_len
  );
}

void (* mpiabi_comm_call_errhandler_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_call_errhandler_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_call_errhandler_)(
    comm,
    errorcode,
    ierror
  );
}
void pmpi_comm_call_errhandler_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_call_errhandler_)(
    comm,
    errorcode,
    ierror
  );
}

void (* mpiabi_win_call_errhandler_)(
  const MPIABI_Fint * win,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_call_errhandler_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_call_errhandler_)(
    win,
    errorcode,
    ierror
  );
}
void pmpi_win_call_errhandler_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_call_errhandler_)(
    win,
    errorcode,
    ierror
  );
}

void (* mpiabi_file_call_errhandler_)(
  const MPIABI_Fint * file,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_call_errhandler_(
  const MPIABI_Fint * file,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_call_errhandler_)(
    file,
    errorcode,
    ierror
  );
}
void pmpi_file_call_errhandler_(
  const MPIABI_Fint * file,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_call_errhandler_)(
    file,
    errorcode,
    ierror
  );
}

double (* mpiabi_wtime_)(
) = NULL;
double mpi_wtime_(
) {
  return (* mpiabi_wtime_)(
  );
}
double pmpi_wtime_(
) {
  return (* mpiabi_wtime_)(
  );
}

double (* mpiabi_wtick_)(
) = NULL;
double mpi_wtick_(
) {
  return (* mpiabi_wtick_)(
  );
}
double pmpi_wtick_(
) {
  return (* mpiabi_wtick_)(
  );
}

void (* mpiabi_init_)(
  MPIABI_Fint * ierror
) = NULL;
void mpi_init_(
  MPIABI_Fint * ierror
) {
  return (* mpiabi_init_)(
    ierror
  );
}
void pmpi_init_(
  MPIABI_Fint * ierror
) {
  return (* mpiabi_init_)(
    ierror
  );
}

void (* mpiabi_finalize_)(
) = NULL;
void mpi_finalize_(
) {
  return (* mpiabi_finalize_)(
  );
}
void pmpi_finalize_(
) {
  return (* mpiabi_finalize_)(
  );
}

void (* mpiabi_initialized_)(
  int * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_initialized_(
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_initialized_)(
    flag,
    ierror
  );
}
void pmpi_initialized_(
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_initialized_)(
    flag,
    ierror
  );
}

void (* mpiabi_abort_)(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) = NULL;
void mpi_abort_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_abort_)(
    comm,
    errorcode,
    ierror
  );
}
void pmpi_abort_(
  const MPIABI_Fint * comm,
  const MPIABI_Fint * errorcode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_abort_)(
    comm,
    errorcode,
    ierror
  );
}

void (* mpiabi_finalized_)(
  int * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_finalized_(
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_finalized_)(
    flag,
    ierror
  );
}
void pmpi_finalized_(
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_finalized_)(
    flag,
    ierror
  );
}

void (* mpiabi_info_create_)(
  MPIABI_Fint * info,
  MPIABI_Fint * ierror
) = NULL;
void mpi_info_create_(
  MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_info_create_)(
    info,
    ierror
  );
}
void pmpi_info_create_(
  MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_info_create_)(
    info,
    ierror
  );
}

void (* mpiabi_info_set_)(
  const MPIABI_Fint * info,
  const char * key,
  const char * value,
  MPIABI_Fint * ierror,
  size_t key_len,
  size_t value_len
) = NULL;
void mpi_info_set_(
  const MPIABI_Fint * info,
  const char * key,
  const char * value,
  MPIABI_Fint * ierror,
  size_t key_len,
  size_t value_len
) {
  return (* mpiabi_info_set_)(
    info,
    key,
    value,
    ierror,
    key_len,
    value_len
  );
}
void pmpi_info_set_(
  const MPIABI_Fint * info,
  const char * key,
  const char * value,
  MPIABI_Fint * ierror,
  size_t key_len,
  size_t value_len
) {
  return (* mpiabi_info_set_)(
    info,
    key,
    value,
    ierror,
    key_len,
    value_len
  );
}

void (* mpiabi_info_delete_)(
  const MPIABI_Fint * info,
  const char * key,
  MPIABI_Fint * ierror,
  size_t key_len
) = NULL;
void mpi_info_delete_(
  const MPIABI_Fint * info,
  const char * key,
  MPIABI_Fint * ierror,
  size_t key_len
) {
  return (* mpiabi_info_delete_)(
    info,
    key,
    ierror,
    key_len
  );
}
void pmpi_info_delete_(
  const MPIABI_Fint * info,
  const char * key,
  MPIABI_Fint * ierror,
  size_t key_len
) {
  return (* mpiabi_info_delete_)(
    info,
    key,
    ierror,
    key_len
  );
}

void (* mpiabi_info_get_)(
  const MPIABI_Fint * info,
  const char * key,
  const MPIABI_Fint * valuelen,
  char * value,
  int * flag,
  MPIABI_Fint * ierror,
  size_t key_len,
  size_t value_len
) = NULL;
void mpi_info_get_(
  const MPIABI_Fint * info,
  const char * key,
  const MPIABI_Fint * valuelen,
  char * value,
  int * flag,
  MPIABI_Fint * ierror,
  size_t key_len,
  size_t value_len
) {
  return (* mpiabi_info_get_)(
    info,
    key,
    valuelen,
    value,
    flag,
    ierror,
    key_len,
    value_len
  );
}
void pmpi_info_get_(
  const MPIABI_Fint * info,
  const char * key,
  const MPIABI_Fint * valuelen,
  char * value,
  int * flag,
  MPIABI_Fint * ierror,
  size_t key_len,
  size_t value_len
) {
  return (* mpiabi_info_get_)(
    info,
    key,
    valuelen,
    value,
    flag,
    ierror,
    key_len,
    value_len
  );
}

void (* mpiabi_info_get_valuelen_)(
  const MPIABI_Fint * info,
  const char * key,
  int * valuelen,
  int * flag,
  MPIABI_Fint * ierror,
  size_t key_len
) = NULL;
void mpi_info_get_valuelen_(
  const MPIABI_Fint * info,
  const char * key,
  int * valuelen,
  int * flag,
  MPIABI_Fint * ierror,
  size_t key_len
) {
  return (* mpiabi_info_get_valuelen_)(
    info,
    key,
    valuelen,
    flag,
    ierror,
    key_len
  );
}
void pmpi_info_get_valuelen_(
  const MPIABI_Fint * info,
  const char * key,
  int * valuelen,
  int * flag,
  MPIABI_Fint * ierror,
  size_t key_len
) {
  return (* mpiabi_info_get_valuelen_)(
    info,
    key,
    valuelen,
    flag,
    ierror,
    key_len
  );
}

void (* mpiabi_info_get_nkeys_)(
  const MPIABI_Fint * info,
  int * nkeys,
  MPIABI_Fint * ierror
) = NULL;
void mpi_info_get_nkeys_(
  const MPIABI_Fint * info,
  int * nkeys,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_info_get_nkeys_)(
    info,
    nkeys,
    ierror
  );
}
void pmpi_info_get_nkeys_(
  const MPIABI_Fint * info,
  int * nkeys,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_info_get_nkeys_)(
    info,
    nkeys,
    ierror
  );
}

void (* mpiabi_info_get_nthkey_)(
  const MPIABI_Fint * info,
  const MPIABI_Fint * n,
  char * key,
  MPIABI_Fint * ierror,
  size_t key_len
) = NULL;
void mpi_info_get_nthkey_(
  const MPIABI_Fint * info,
  const MPIABI_Fint * n,
  char * key,
  MPIABI_Fint * ierror,
  size_t key_len
) {
  return (* mpiabi_info_get_nthkey_)(
    info,
    n,
    key,
    ierror,
    key_len
  );
}
void pmpi_info_get_nthkey_(
  const MPIABI_Fint * info,
  const MPIABI_Fint * n,
  char * key,
  MPIABI_Fint * ierror,
  size_t key_len
) {
  return (* mpiabi_info_get_nthkey_)(
    info,
    n,
    key,
    ierror,
    key_len
  );
}

void (* mpiabi_info_dup_)(
  const MPIABI_Fint * info,
  MPIABI_Fint * newinfo,
  MPIABI_Fint * ierror
) = NULL;
void mpi_info_dup_(
  const MPIABI_Fint * info,
  MPIABI_Fint * newinfo,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_info_dup_)(
    info,
    newinfo,
    ierror
  );
}
void pmpi_info_dup_(
  const MPIABI_Fint * info,
  MPIABI_Fint * newinfo,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_info_dup_)(
    info,
    newinfo,
    ierror
  );
}

void (* mpiabi_info_free_)(
  MPIABI_Fint * info,
  MPIABI_Fint * ierror
) = NULL;
void mpi_info_free_(
  MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_info_free_)(
    info,
    ierror
  );
}
void pmpi_info_free_(
  MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_info_free_)(
    info,
    ierror
  );
}

void (* mpiabi_comm_spawn_)(
  const char * command,
  char ** argv,
  const MPIABI_Fint * maxprocs,
  const MPIABI_Fint * info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * intercomm,
  int * array_off_errcodes,
  MPIABI_Fint * ierror,
  size_t command_len,
  size_t argv_len
) = NULL;
void mpi_comm_spawn_(
  const char * command,
  char ** argv,
  const MPIABI_Fint * maxprocs,
  const MPIABI_Fint * info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * intercomm,
  int * array_off_errcodes,
  MPIABI_Fint * ierror,
  size_t command_len,
  size_t argv_len
) {
  return (* mpiabi_comm_spawn_)(
    command,
    argv,
    maxprocs,
    info,
    root,
    comm,
    intercomm,
    array_off_errcodes,
    ierror,
    command_len,
    argv_len
  );
}
void pmpi_comm_spawn_(
  const char * command,
  char ** argv,
  const MPIABI_Fint * maxprocs,
  const MPIABI_Fint * info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * intercomm,
  int * array_off_errcodes,
  MPIABI_Fint * ierror,
  size_t command_len,
  size_t argv_len
) {
  return (* mpiabi_comm_spawn_)(
    command,
    argv,
    maxprocs,
    info,
    root,
    comm,
    intercomm,
    array_off_errcodes,
    ierror,
    command_len,
    argv_len
  );
}

void (* mpiabi_comm_get_parent_)(
  MPIABI_Fint * parent,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_get_parent_(
  MPIABI_Fint * parent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_get_parent_)(
    parent,
    ierror
  );
}
void pmpi_comm_get_parent_(
  MPIABI_Fint * parent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_get_parent_)(
    parent,
    ierror
  );
}

void (* mpiabi_comm_spawn_multiple_)(
  const MPIABI_Fint * count,
  char ** array_of_commands,
  char *** array_of_argv,
  const int * array_of_maxprocs,
  const MPIABI_Fint * array_of_info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * intercomm,
  int * array_of_errcodes,
  MPIABI_Fint * ierror,
  size_t arrray_of_commands_len,
  size_t arrray_of_argv_len
) = NULL;
void mpi_comm_spawn_multiple_(
  const MPIABI_Fint * count,
  char ** array_of_commands,
  char *** array_of_argv,
  const int * array_of_maxprocs,
  const MPIABI_Fint * array_of_info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * intercomm,
  int * array_of_errcodes,
  MPIABI_Fint * ierror,
  size_t arrray_of_commands_len,
  size_t arrray_of_argv_len
) {
  return (* mpiabi_comm_spawn_multiple_)(
    count,
    array_of_commands,
    array_of_argv,
    array_of_maxprocs,
    array_of_info,
    root,
    comm,
    intercomm,
    array_of_errcodes,
    ierror,
    arrray_of_commands_len,
    arrray_of_argv_len
  );
}
void pmpi_comm_spawn_multiple_(
  const MPIABI_Fint * count,
  char ** array_of_commands,
  char *** array_of_argv,
  const int * array_of_maxprocs,
  const MPIABI_Fint * array_of_info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * intercomm,
  int * array_of_errcodes,
  MPIABI_Fint * ierror,
  size_t arrray_of_commands_len,
  size_t arrray_of_argv_len
) {
  return (* mpiabi_comm_spawn_multiple_)(
    count,
    array_of_commands,
    array_of_argv,
    array_of_maxprocs,
    array_of_info,
    root,
    comm,
    intercomm,
    array_of_errcodes,
    ierror,
    arrray_of_commands_len,
    arrray_of_argv_len
  );
}

void (* mpiabi_open_port_)(
  const MPIABI_Fint * info,
  char * port_name,
  MPIABI_Fint * ierror,
  size_t port_name_len
) = NULL;
void mpi_open_port_(
  const MPIABI_Fint * info,
  char * port_name,
  MPIABI_Fint * ierror,
  size_t port_name_len
) {
  return (* mpiabi_open_port_)(
    info,
    port_name,
    ierror,
    port_name_len
  );
}
void pmpi_open_port_(
  const MPIABI_Fint * info,
  char * port_name,
  MPIABI_Fint * ierror,
  size_t port_name_len
) {
  return (* mpiabi_open_port_)(
    info,
    port_name,
    ierror,
    port_name_len
  );
}

void (* mpiabi_close_port_)(
  const char * port_name,
  MPIABI_Fint * ierror,
  size_t port_name_len
) = NULL;
void mpi_close_port_(
  const char * port_name,
  MPIABI_Fint * ierror,
  size_t port_name_len
) {
  return (* mpiabi_close_port_)(
    port_name,
    ierror,
    port_name_len
  );
}
void pmpi_close_port_(
  const char * port_name,
  MPIABI_Fint * ierror,
  size_t port_name_len
) {
  return (* mpiabi_close_port_)(
    port_name,
    ierror,
    port_name_len
  );
}

void (* mpiabi_comm_accept_)(
  const char * port_name,
  const MPIABI_Fint * info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror,
  size_t port_name_len
) = NULL;
void mpi_comm_accept_(
  const char * port_name,
  const MPIABI_Fint * info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror,
  size_t port_name_len
) {
  return (* mpiabi_comm_accept_)(
    port_name,
    info,
    root,
    comm,
    newcomm,
    ierror,
    port_name_len
  );
}
void pmpi_comm_accept_(
  const char * port_name,
  const MPIABI_Fint * info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror,
  size_t port_name_len
) {
  return (* mpiabi_comm_accept_)(
    port_name,
    info,
    root,
    comm,
    newcomm,
    ierror,
    port_name_len
  );
}

void (* mpiabi_comm_connect_)(
  const char * port_name,
  const MPIABI_Fint * info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror,
  size_t port_name_len
) = NULL;
void mpi_comm_connect_(
  const char * port_name,
  const MPIABI_Fint * info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror,
  size_t port_name_len
) {
  return (* mpiabi_comm_connect_)(
    port_name,
    info,
    root,
    comm,
    newcomm,
    ierror,
    port_name_len
  );
}
void pmpi_comm_connect_(
  const char * port_name,
  const MPIABI_Fint * info,
  const MPIABI_Fint * root,
  const MPIABI_Fint * comm,
  MPIABI_Fint * newcomm,
  MPIABI_Fint * ierror,
  size_t port_name_len
) {
  return (* mpiabi_comm_connect_)(
    port_name,
    info,
    root,
    comm,
    newcomm,
    ierror,
    port_name_len
  );
}

void (* mpiabi_publish_name_)(
  const char * service_name,
  const MPIABI_Fint * info,
  const char * port_name,
  MPIABI_Fint * ierror,
  size_t service_name_len,
  size_t port_name_len
) = NULL;
void mpi_publish_name_(
  const char * service_name,
  const MPIABI_Fint * info,
  const char * port_name,
  MPIABI_Fint * ierror,
  size_t service_name_len,
  size_t port_name_len
) {
  return (* mpiabi_publish_name_)(
    service_name,
    info,
    port_name,
    ierror,
    service_name_len,
    port_name_len
  );
}
void pmpi_publish_name_(
  const char * service_name,
  const MPIABI_Fint * info,
  const char * port_name,
  MPIABI_Fint * ierror,
  size_t service_name_len,
  size_t port_name_len
) {
  return (* mpiabi_publish_name_)(
    service_name,
    info,
    port_name,
    ierror,
    service_name_len,
    port_name_len
  );
}

void (* mpiabi_unpublish_name_)(
  const char * service_name,
  const MPIABI_Fint * info,
  const char * port_name,
  MPIABI_Fint * ierror,
  size_t service_name_len,
  size_t port_name_len
) = NULL;
void mpi_unpublish_name_(
  const char * service_name,
  const MPIABI_Fint * info,
  const char * port_name,
  MPIABI_Fint * ierror,
  size_t service_name_len,
  size_t port_name_len
) {
  return (* mpiabi_unpublish_name_)(
    service_name,
    info,
    port_name,
    ierror,
    service_name_len,
    port_name_len
  );
}
void pmpi_unpublish_name_(
  const char * service_name,
  const MPIABI_Fint * info,
  const char * port_name,
  MPIABI_Fint * ierror,
  size_t service_name_len,
  size_t port_name_len
) {
  return (* mpiabi_unpublish_name_)(
    service_name,
    info,
    port_name,
    ierror,
    service_name_len,
    port_name_len
  );
}

void (* mpiabi_lookup_name_)(
  const char * service_name,
  const MPIABI_Fint * info,
  char * port_name,
  MPIABI_Fint * ierror,
  size_t service_name_len,
  size_t port_name_len
) = NULL;
void mpi_lookup_name_(
  const char * service_name,
  const MPIABI_Fint * info,
  char * port_name,
  MPIABI_Fint * ierror,
  size_t service_name_len,
  size_t port_name_len
) {
  return (* mpiabi_lookup_name_)(
    service_name,
    info,
    port_name,
    ierror,
    service_name_len,
    port_name_len
  );
}
void pmpi_lookup_name_(
  const char * service_name,
  const MPIABI_Fint * info,
  char * port_name,
  MPIABI_Fint * ierror,
  size_t service_name_len,
  size_t port_name_len
) {
  return (* mpiabi_lookup_name_)(
    service_name,
    info,
    port_name,
    ierror,
    service_name_len,
    port_name_len
  );
}

void (* mpiabi_comm_disconnect_)(
  MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_disconnect_(
  MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_disconnect_)(
    comm,
    ierror
  );
}
void pmpi_comm_disconnect_(
  MPIABI_Fint * comm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_disconnect_)(
    comm,
    ierror
  );
}

void (* mpiabi_comm_join_)(
  const MPIABI_Fint * fd,
  MPIABI_Fint * intercomm,
  MPIABI_Fint * ierror
) = NULL;
void mpi_comm_join_(
  const MPIABI_Fint * fd,
  MPIABI_Fint * intercomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_join_)(
    fd,
    intercomm,
    ierror
  );
}
void pmpi_comm_join_(
  const MPIABI_Fint * fd,
  MPIABI_Fint * intercomm,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_comm_join_)(
    fd,
    intercomm,
    ierror
  );
}

void (* mpiabi_win_create_)(
  void * base,
  const MPIABI_Fint * size,
  const MPIABI_Fint * disp_unit,
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_create_(
  void * base,
  const MPIABI_Fint * size,
  const MPIABI_Fint * disp_unit,
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_create_)(
    base,
    size,
    disp_unit,
    info,
    comm,
    win,
    ierror
  );
}
void pmpi_win_create_(
  void * base,
  const MPIABI_Fint * size,
  const MPIABI_Fint * disp_unit,
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_create_)(
    base,
    size,
    disp_unit,
    info,
    comm,
    win,
    ierror
  );
}

void (* mpiabi_win_allocate_)(
  const MPIABI_Fint * size,
  const MPIABI_Fint * disp_unit,
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  void * baseptr,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_allocate_(
  const MPIABI_Fint * size,
  const MPIABI_Fint * disp_unit,
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  void * baseptr,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_allocate_)(
    size,
    disp_unit,
    info,
    comm,
    baseptr,
    win,
    ierror
  );
}
void pmpi_win_allocate_(
  const MPIABI_Fint * size,
  const MPIABI_Fint * disp_unit,
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  void * baseptr,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_allocate_)(
    size,
    disp_unit,
    info,
    comm,
    baseptr,
    win,
    ierror
  );
}

void (* mpiabi_win_allocate_shared_)(
  const MPIABI_Fint * size,
  const MPIABI_Fint * disp_unit,
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  void * baseptr,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_allocate_shared_(
  const MPIABI_Fint * size,
  const MPIABI_Fint * disp_unit,
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  void * baseptr,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_allocate_shared_)(
    size,
    disp_unit,
    info,
    comm,
    baseptr,
    win,
    ierror
  );
}
void pmpi_win_allocate_shared_(
  const MPIABI_Fint * size,
  const MPIABI_Fint * disp_unit,
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  void * baseptr,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_allocate_shared_)(
    size,
    disp_unit,
    info,
    comm,
    baseptr,
    win,
    ierror
  );
}

void (* mpiabi_win_shared_query_)(
  const MPIABI_Fint * win,
  const MPIABI_Fint * rank,
  MPIABI_Fint * size,
  int * disp_unit,
  void * baseptr,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_shared_query_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * rank,
  MPIABI_Fint * size,
  int * disp_unit,
  void * baseptr,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_shared_query_)(
    win,
    rank,
    size,
    disp_unit,
    baseptr,
    ierror
  );
}
void pmpi_win_shared_query_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * rank,
  MPIABI_Fint * size,
  int * disp_unit,
  void * baseptr,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_shared_query_)(
    win,
    rank,
    size,
    disp_unit,
    baseptr,
    ierror
  );
}

void (* mpiabi_win_create_dynamic_)(
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_create_dynamic_(
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_create_dynamic_)(
    info,
    comm,
    win,
    ierror
  );
}
void pmpi_win_create_dynamic_(
  const MPIABI_Fint * info,
  const MPIABI_Fint * comm,
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_create_dynamic_)(
    info,
    comm,
    win,
    ierror
  );
}

void (* mpiabi_win_attach_)(
  const MPIABI_Fint * win,
  void * base,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_attach_(
  const MPIABI_Fint * win,
  void * base,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_attach_)(
    win,
    base,
    size,
    ierror
  );
}
void pmpi_win_attach_(
  const MPIABI_Fint * win,
  void * base,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_attach_)(
    win,
    base,
    size,
    ierror
  );
}

void (* mpiabi_win_detach_)(
  const MPIABI_Fint * win,
  const void * base,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_detach_(
  const MPIABI_Fint * win,
  const void * base,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_detach_)(
    win,
    base,
    ierror
  );
}
void pmpi_win_detach_(
  const MPIABI_Fint * win,
  const void * base,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_detach_)(
    win,
    base,
    ierror
  );
}

void (* mpiabi_win_free_)(
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_free_(
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_free_)(
    win,
    ierror
  );
}
void pmpi_win_free_(
  MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_free_)(
    win,
    ierror
  );
}

void (* mpiabi_win_get_group_)(
  const MPIABI_Fint * win,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_get_group_(
  const MPIABI_Fint * win,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_get_group_)(
    win,
    group,
    ierror
  );
}
void pmpi_win_get_group_(
  const MPIABI_Fint * win,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_get_group_)(
    win,
    group,
    ierror
  );
}

void (* mpiabi_win_set_info_)(
  const MPIABI_Fint * win,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_set_info_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_set_info_)(
    win,
    info,
    ierror
  );
}
void pmpi_win_set_info_(
  const MPIABI_Fint * win,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_set_info_)(
    win,
    info,
    ierror
  );
}

void (* mpiabi_win_get_info_)(
  const MPIABI_Fint * win,
  MPIABI_Fint * info_used,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_get_info_(
  const MPIABI_Fint * win,
  MPIABI_Fint * info_used,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_get_info_)(
    win,
    info_used,
    ierror
  );
}
void pmpi_win_get_info_(
  const MPIABI_Fint * win,
  MPIABI_Fint * info_used,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_get_info_)(
    win,
    info_used,
    ierror
  );
}

void (* mpiabi_put_)(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_put_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_put_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    win,
    ierror
  );
}
void pmpi_put_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_put_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    win,
    ierror
  );
}

void (* mpiabi_get_)(
  void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_get_(
  void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    win,
    ierror
  );
}
void pmpi_get_(
  void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    win,
    ierror
  );
}

void (* mpiabi_accumulate_)(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_accumulate_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_accumulate_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    op,
    win,
    ierror
  );
}
void pmpi_accumulate_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_accumulate_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    op,
    win,
    ierror
  );
}

void (* mpiabi_get_accumulate_)(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  void * result_addr,
  const MPIABI_Fint * result_count,
  const MPIABI_Fint * result_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_get_accumulate_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  void * result_addr,
  const MPIABI_Fint * result_count,
  const MPIABI_Fint * result_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_accumulate_)(
    origin_addr,
    origin_count,
    origin_datatype,
    result_addr,
    result_count,
    result_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    op,
    win,
    ierror
  );
}
void pmpi_get_accumulate_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  void * result_addr,
  const MPIABI_Fint * result_count,
  const MPIABI_Fint * result_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_get_accumulate_)(
    origin_addr,
    origin_count,
    origin_datatype,
    result_addr,
    result_count,
    result_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    op,
    win,
    ierror
  );
}

void (* mpiabi_fetch_and_op_)(
  const void * origin_addr,
  void * result_addr,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_fetch_and_op_(
  const void * origin_addr,
  void * result_addr,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_fetch_and_op_)(
    origin_addr,
    result_addr,
    datatype,
    target_rank,
    target_disp,
    op,
    win,
    ierror
  );
}
void pmpi_fetch_and_op_(
  const void * origin_addr,
  void * result_addr,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_fetch_and_op_)(
    origin_addr,
    result_addr,
    datatype,
    target_rank,
    target_disp,
    op,
    win,
    ierror
  );
}

void (* mpiabi_compare_and_swap_)(
  const void * origin_addr,
  const void * compare_addr,
  void * result_addr,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_compare_and_swap_(
  const void * origin_addr,
  const void * compare_addr,
  void * result_addr,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_compare_and_swap_)(
    origin_addr,
    compare_addr,
    result_addr,
    datatype,
    target_rank,
    target_disp,
    win,
    ierror
  );
}
void pmpi_compare_and_swap_(
  const void * origin_addr,
  const void * compare_addr,
  void * result_addr,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_compare_and_swap_)(
    origin_addr,
    compare_addr,
    result_addr,
    datatype,
    target_rank,
    target_disp,
    win,
    ierror
  );
}

void (* mpiabi_rput_)(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_rput_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_rput_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    win,
    request,
    ierror
  );
}
void pmpi_rput_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_rput_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    win,
    request,
    ierror
  );
}

void (* mpiabi_rget_)(
  void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_rget_(
  void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_rget_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    win,
    request,
    ierror
  );
}
void pmpi_rget_(
  void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_rget_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    win,
    request,
    ierror
  );
}

void (* mpiabi_raccumulate_)(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_raccumulate_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_raccumulate_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    op,
    win,
    request,
    ierror
  );
}
void pmpi_raccumulate_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_raccumulate_)(
    origin_addr,
    origin_count,
    origin_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    op,
    win,
    request,
    ierror
  );
}

void (* mpiabi_rget_accumulate_)(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  void * result_addr,
  const MPIABI_Fint * result_count,
  const MPIABI_Fint * result_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_rget_accumulate_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  void * result_addr,
  const MPIABI_Fint * result_count,
  const MPIABI_Fint * result_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_rget_accumulate_)(
    origin_addr,
    origin_count,
    origin_datatype,
    result_addr,
    result_count,
    result_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    op,
    win,
    request,
    ierror
  );
}
void pmpi_rget_accumulate_(
  const void * origin_addr,
  const MPIABI_Fint * origin_count,
  const MPIABI_Fint * origin_datatype,
  void * result_addr,
  const MPIABI_Fint * result_count,
  const MPIABI_Fint * result_datatype,
  const MPIABI_Fint * target_rank,
  const MPIABI_Fint * target_disp,
  const MPIABI_Fint * target_count,
  const MPIABI_Fint * target_datatype,
  const MPIABI_Fint * op,
  const MPIABI_Fint * win,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_rget_accumulate_)(
    origin_addr,
    origin_count,
    origin_datatype,
    result_addr,
    result_count,
    result_datatype,
    target_rank,
    target_disp,
    target_count,
    target_datatype,
    op,
    win,
    request,
    ierror
  );
}

void (* mpiabi_win_fence_)(
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_fence_(
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_fence_)(
    assert,
    win,
    ierror
  );
}
void pmpi_win_fence_(
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_fence_)(
    assert,
    win,
    ierror
  );
}

void (* mpiabi_win_start_)(
  const MPIABI_Fint * group,
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_start_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_start_)(
    group,
    assert,
    win,
    ierror
  );
}
void pmpi_win_start_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_start_)(
    group,
    assert,
    win,
    ierror
  );
}

void (* mpiabi_win_complete_)(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_complete_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_complete_)(
    win,
    ierror
  );
}
void pmpi_win_complete_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_complete_)(
    win,
    ierror
  );
}

void (* mpiabi_win_post_)(
  const MPIABI_Fint * group,
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_post_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_post_)(
    group,
    assert,
    win,
    ierror
  );
}
void pmpi_win_post_(
  const MPIABI_Fint * group,
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_post_)(
    group,
    assert,
    win,
    ierror
  );
}

void (* mpiabi_win_wait_)(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_wait_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_wait_)(
    win,
    ierror
  );
}
void pmpi_win_wait_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_wait_)(
    win,
    ierror
  );
}

void (* mpiabi_win_test_)(
  const MPIABI_Fint * win,
  int * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_test_(
  const MPIABI_Fint * win,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_test_)(
    win,
    flag,
    ierror
  );
}
void pmpi_win_test_(
  const MPIABI_Fint * win,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_test_)(
    win,
    flag,
    ierror
  );
}

void (* mpiabi_win_lock_)(
  const MPIABI_Fint * lock_type,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_lock_(
  const MPIABI_Fint * lock_type,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_lock_)(
    lock_type,
    rank,
    assert,
    win,
    ierror
  );
}
void pmpi_win_lock_(
  const MPIABI_Fint * lock_type,
  const MPIABI_Fint * rank,
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_lock_)(
    lock_type,
    rank,
    assert,
    win,
    ierror
  );
}

void (* mpiabi_win_lock_all_)(
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_lock_all_(
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_lock_all_)(
    assert,
    win,
    ierror
  );
}
void pmpi_win_lock_all_(
  const MPIABI_Fint * assert,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_lock_all_)(
    assert,
    win,
    ierror
  );
}

void (* mpiabi_win_unlock_)(
  const MPIABI_Fint * rank,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_unlock_(
  const MPIABI_Fint * rank,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_unlock_)(
    rank,
    win,
    ierror
  );
}
void pmpi_win_unlock_(
  const MPIABI_Fint * rank,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_unlock_)(
    rank,
    win,
    ierror
  );
}

void (* mpiabi_win_unlock_all_)(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_unlock_all_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_unlock_all_)(
    win,
    ierror
  );
}
void pmpi_win_unlock_all_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_unlock_all_)(
    win,
    ierror
  );
}

void (* mpiabi_win_flush_)(
  const MPIABI_Fint * rank,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_flush_(
  const MPIABI_Fint * rank,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_flush_)(
    rank,
    win,
    ierror
  );
}
void pmpi_win_flush_(
  const MPIABI_Fint * rank,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_flush_)(
    rank,
    win,
    ierror
  );
}

void (* mpiabi_win_flush_all_)(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_flush_all_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_flush_all_)(
    win,
    ierror
  );
}
void pmpi_win_flush_all_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_flush_all_)(
    win,
    ierror
  );
}

void (* mpiabi_win_flush_local_)(
  const MPIABI_Fint * rank,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_flush_local_(
  const MPIABI_Fint * rank,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_flush_local_)(
    rank,
    win,
    ierror
  );
}
void pmpi_win_flush_local_(
  const MPIABI_Fint * rank,
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_flush_local_)(
    rank,
    win,
    ierror
  );
}

void (* mpiabi_win_flush_local_all_)(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_flush_local_all_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_flush_local_all_)(
    win,
    ierror
  );
}
void pmpi_win_flush_local_all_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_flush_local_all_)(
    win,
    ierror
  );
}

void (* mpiabi_win_sync_)(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) = NULL;
void mpi_win_sync_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_sync_)(
    win,
    ierror
  );
}
void pmpi_win_sync_(
  const MPIABI_Fint * win,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_win_sync_)(
    win,
    ierror
  );
}

void (* mpiabi_grequest_complete_)(
  const MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_grequest_complete_(
  const MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_grequest_complete_)(
    request,
    ierror
  );
}
void pmpi_grequest_complete_(
  const MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_grequest_complete_)(
    request,
    ierror
  );
}

void (* mpiabi_status_set_elements_)(
  MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * count,
  MPIABI_Fint * ierror
) = NULL;
void mpi_status_set_elements_(
  MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * count,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_status_set_elements_)(
    status,
    datatype,
    count,
    ierror
  );
}
void pmpi_status_set_elements_(
  MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * count,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_status_set_elements_)(
    status,
    datatype,
    count,
    ierror
  );
}

void (* mpiabi_status_set_elements_x_)(
  MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * count,
  MPIABI_Fint * ierror
) = NULL;
void mpi_status_set_elements_x_(
  MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * count,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_status_set_elements_x_)(
    status,
    datatype,
    count,
    ierror
  );
}
void pmpi_status_set_elements_x_(
  MPIABI_Fint * status,
  const MPIABI_Fint * datatype,
  const MPIABI_Fint * count,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_status_set_elements_x_)(
    status,
    datatype,
    count,
    ierror
  );
}

void (* mpiabi_status_set_cancelled_)(
  MPIABI_Fint * status,
  const MPIABI_Fint * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_status_set_cancelled_(
  MPIABI_Fint * status,
  const MPIABI_Fint * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_status_set_cancelled_)(
    status,
    flag,
    ierror
  );
}
void pmpi_status_set_cancelled_(
  MPIABI_Fint * status,
  const MPIABI_Fint * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_status_set_cancelled_)(
    status,
    flag,
    ierror
  );
}

void (* mpiabi_init_thread_)(
  const MPIABI_Fint * required,
  int * provided,
  MPIABI_Fint * ierror
) = NULL;
void mpi_init_thread_(
  const MPIABI_Fint * required,
  int * provided,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_init_thread_)(
    required,
    provided,
    ierror
  );
}
void pmpi_init_thread_(
  const MPIABI_Fint * required,
  int * provided,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_init_thread_)(
    required,
    provided,
    ierror
  );
}

void (* mpiabi_query_thread_)(
  int * provided,
  MPIABI_Fint * ierror
) = NULL;
void mpi_query_thread_(
  int * provided,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_query_thread_)(
    provided,
    ierror
  );
}
void pmpi_query_thread_(
  int * provided,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_query_thread_)(
    provided,
    ierror
  );
}

void (* mpiabi_is_thread_main_)(
  int * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_is_thread_main_(
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_is_thread_main_)(
    flag,
    ierror
  );
}
void pmpi_is_thread_main_(
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_is_thread_main_)(
    flag,
    ierror
  );
}

void (* mpiabi_file_open_)(
  const MPIABI_Fint * comm,
  const char * filename,
  const MPIABI_Fint * amode,
  const MPIABI_Fint * info,
  MPIABI_Fint * fh,
  MPIABI_Fint * ierror,
  size_t filename_len
) = NULL;
void mpi_file_open_(
  const MPIABI_Fint * comm,
  const char * filename,
  const MPIABI_Fint * amode,
  const MPIABI_Fint * info,
  MPIABI_Fint * fh,
  MPIABI_Fint * ierror,
  size_t filename_len
) {
  return (* mpiabi_file_open_)(
    comm,
    filename,
    amode,
    info,
    fh,
    ierror,
    filename_len
  );
}
void pmpi_file_open_(
  const MPIABI_Fint * comm,
  const char * filename,
  const MPIABI_Fint * amode,
  const MPIABI_Fint * info,
  MPIABI_Fint * fh,
  MPIABI_Fint * ierror,
  size_t filename_len
) {
  return (* mpiabi_file_open_)(
    comm,
    filename,
    amode,
    info,
    fh,
    ierror,
    filename_len
  );
}

void (* mpiabi_file_close_)(
  MPIABI_Fint * fh,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_close_(
  MPIABI_Fint * fh,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_close_)(
    fh,
    ierror
  );
}
void pmpi_file_close_(
  MPIABI_Fint * fh,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_close_)(
    fh,
    ierror
  );
}

void (* mpiabi_file_delete_)(
  const char * filename,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror,
  size_t filename_len
) = NULL;
void mpi_file_delete_(
  const char * filename,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror,
  size_t filename_len
) {
  return (* mpiabi_file_delete_)(
    filename,
    info,
    ierror,
    filename_len
  );
}
void pmpi_file_delete_(
  const char * filename,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror,
  size_t filename_len
) {
  return (* mpiabi_file_delete_)(
    filename,
    info,
    ierror,
    filename_len
  );
}

void (* mpiabi_file_set_size_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_set_size_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_set_size_)(
    fh,
    size,
    ierror
  );
}
void pmpi_file_set_size_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_set_size_)(
    fh,
    size,
    ierror
  );
}

void (* mpiabi_file_preallocate_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_preallocate_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_preallocate_)(
    fh,
    size,
    ierror
  );
}
void pmpi_file_preallocate_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_preallocate_)(
    fh,
    size,
    ierror
  );
}

void (* mpiabi_file_get_size_)(
  const MPIABI_Fint * fh,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_get_size_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_size_)(
    fh,
    size,
    ierror
  );
}
void pmpi_file_get_size_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * size,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_size_)(
    fh,
    size,
    ierror
  );
}

void (* mpiabi_file_get_group_)(
  const MPIABI_Fint * fh,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_get_group_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_group_)(
    fh,
    group,
    ierror
  );
}
void pmpi_file_get_group_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * group,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_group_)(
    fh,
    group,
    ierror
  );
}

void (* mpiabi_file_get_amode_)(
  const MPIABI_Fint * fh,
  int * amode,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_get_amode_(
  const MPIABI_Fint * fh,
  int * amode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_amode_)(
    fh,
    amode,
    ierror
  );
}
void pmpi_file_get_amode_(
  const MPIABI_Fint * fh,
  int * amode,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_amode_)(
    fh,
    amode,
    ierror
  );
}

void (* mpiabi_file_set_info_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_set_info_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_set_info_)(
    fh,
    info,
    ierror
  );
}
void pmpi_file_set_info_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_set_info_)(
    fh,
    info,
    ierror
  );
}

void (* mpiabi_file_get_info_)(
  const MPIABI_Fint * fh,
  MPIABI_Fint * info_used,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_get_info_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * info_used,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_info_)(
    fh,
    info_used,
    ierror
  );
}
void pmpi_file_get_info_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * info_used,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_info_)(
    fh,
    info_used,
    ierror
  );
}

void (* mpiabi_file_set_view_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * disp,
  const MPIABI_Fint * etype,
  const MPIABI_Fint * filetype,
  const char * datarep,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror,
  size_t datarep_len
) = NULL;
void mpi_file_set_view_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * disp,
  const MPIABI_Fint * etype,
  const MPIABI_Fint * filetype,
  const char * datarep,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror,
  size_t datarep_len
) {
  return (* mpiabi_file_set_view_)(
    fh,
    disp,
    etype,
    filetype,
    datarep,
    info,
    ierror,
    datarep_len
  );
}
void pmpi_file_set_view_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * disp,
  const MPIABI_Fint * etype,
  const MPIABI_Fint * filetype,
  const char * datarep,
  const MPIABI_Fint * info,
  MPIABI_Fint * ierror,
  size_t datarep_len
) {
  return (* mpiabi_file_set_view_)(
    fh,
    disp,
    etype,
    filetype,
    datarep,
    info,
    ierror,
    datarep_len
  );
}

void (* mpiabi_file_get_view_)(
  const MPIABI_Fint * fh,
  MPIABI_Fint * disp,
  MPIABI_Fint * etype,
  MPIABI_Fint * filetype,
  char * datarep,
  MPIABI_Fint * ierror,
  size_t datarep_len
) = NULL;
void mpi_file_get_view_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * disp,
  MPIABI_Fint * etype,
  MPIABI_Fint * filetype,
  char * datarep,
  MPIABI_Fint * ierror,
  size_t datarep_len
) {
  return (* mpiabi_file_get_view_)(
    fh,
    disp,
    etype,
    filetype,
    datarep,
    ierror,
    datarep_len
  );
}
void pmpi_file_get_view_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * disp,
  MPIABI_Fint * etype,
  MPIABI_Fint * filetype,
  char * datarep,
  MPIABI_Fint * ierror,
  size_t datarep_len
) {
  return (* mpiabi_file_get_view_)(
    fh,
    disp,
    etype,
    filetype,
    datarep,
    ierror,
    datarep_len
  );
}

void (* mpiabi_file_read_at_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_at_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_at_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_read_at_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_at_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_read_at_all_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_at_all_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_at_all_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_read_at_all_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_at_all_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_write_at_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_at_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_at_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_write_at_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_at_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_write_at_all_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_at_all_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_at_all_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_write_at_all_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_at_all_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_iread_at_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_iread_at_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iread_at_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}
void pmpi_file_iread_at_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iread_at_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}

void (* mpiabi_file_iread_at_all_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_iread_at_all_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iread_at_all_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}
void pmpi_file_iread_at_all_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iread_at_all_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}

void (* mpiabi_file_iwrite_at_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_iwrite_at_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iwrite_at_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}
void pmpi_file_iwrite_at_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iwrite_at_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}

void (* mpiabi_file_iwrite_at_all_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_iwrite_at_all_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iwrite_at_all_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}
void pmpi_file_iwrite_at_all_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iwrite_at_all_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}

void (* mpiabi_file_read_)(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_read_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_read_all_)(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_all_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_all_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_read_all_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_all_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_write_)(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_write_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_write_all_)(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_all_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_all_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_write_all_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_all_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_iread_)(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_iread_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iread_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}
void pmpi_file_iread_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iread_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}

void (* mpiabi_file_iread_all_)(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_iread_all_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iread_all_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}
void pmpi_file_iread_all_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iread_all_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}

void (* mpiabi_file_iwrite_)(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_iwrite_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iwrite_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}
void pmpi_file_iwrite_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iwrite_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}

void (* mpiabi_file_iwrite_all_)(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_iwrite_all_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iwrite_all_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}
void pmpi_file_iwrite_all_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iwrite_all_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}

void (* mpiabi_file_seek_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const MPIABI_Fint * whence,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_seek_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const MPIABI_Fint * whence,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_seek_)(
    fh,
    offset,
    whence,
    ierror
  );
}
void pmpi_file_seek_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const MPIABI_Fint * whence,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_seek_)(
    fh,
    offset,
    whence,
    ierror
  );
}

void (* mpiabi_file_get_position_)(
  const MPIABI_Fint * fh,
  MPIABI_Fint * offset,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_get_position_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * offset,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_position_)(
    fh,
    offset,
    ierror
  );
}
void pmpi_file_get_position_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * offset,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_position_)(
    fh,
    offset,
    ierror
  );
}

void (* mpiabi_file_get_byte_offset_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  MPIABI_Fint * disp,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_get_byte_offset_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  MPIABI_Fint * disp,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_byte_offset_)(
    fh,
    offset,
    disp,
    ierror
  );
}
void pmpi_file_get_byte_offset_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  MPIABI_Fint * disp,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_byte_offset_)(
    fh,
    offset,
    disp,
    ierror
  );
}

void (* mpiabi_file_read_shared_)(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_shared_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_shared_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_read_shared_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_shared_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_write_shared_)(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_shared_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_shared_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_write_shared_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_shared_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_iread_shared_)(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_iread_shared_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iread_shared_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}
void pmpi_file_iread_shared_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iread_shared_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}

void (* mpiabi_file_iwrite_shared_)(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_iwrite_shared_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iwrite_shared_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}
void pmpi_file_iwrite_shared_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * request,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_iwrite_shared_)(
    fh,
    buf,
    count,
    datatype,
    request,
    ierror
  );
}

void (* mpiabi_file_read_ordered_)(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_ordered_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_ordered_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_read_ordered_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_ordered_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_write_ordered_)(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_ordered_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_ordered_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}
void pmpi_file_write_ordered_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_ordered_)(
    fh,
    buf,
    count,
    datatype,
    status,
    ierror
  );
}

void (* mpiabi_file_seek_shared_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const MPIABI_Fint * whence,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_seek_shared_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const MPIABI_Fint * whence,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_seek_shared_)(
    fh,
    offset,
    whence,
    ierror
  );
}
void pmpi_file_seek_shared_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const MPIABI_Fint * whence,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_seek_shared_)(
    fh,
    offset,
    whence,
    ierror
  );
}

void (* mpiabi_file_get_position_shared_)(
  const MPIABI_Fint * fh,
  MPIABI_Fint * offset,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_get_position_shared_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * offset,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_position_shared_)(
    fh,
    offset,
    ierror
  );
}
void pmpi_file_get_position_shared_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * offset,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_position_shared_)(
    fh,
    offset,
    ierror
  );
}

void (* mpiabi_file_read_at_all_begin_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_at_all_begin_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_at_all_begin_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    ierror
  );
}
void pmpi_file_read_at_all_begin_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_at_all_begin_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    ierror
  );
}

void (* mpiabi_file_read_at_all_end_)(
  const MPIABI_Fint * fh,
  void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_at_all_end_(
  const MPIABI_Fint * fh,
  void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_at_all_end_)(
    fh,
    buf,
    status,
    ierror
  );
}
void pmpi_file_read_at_all_end_(
  const MPIABI_Fint * fh,
  void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_at_all_end_)(
    fh,
    buf,
    status,
    ierror
  );
}

void (* mpiabi_file_write_at_all_begin_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_at_all_begin_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_at_all_begin_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    ierror
  );
}
void pmpi_file_write_at_all_begin_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * offset,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_at_all_begin_)(
    fh,
    offset,
    buf,
    count,
    datatype,
    ierror
  );
}

void (* mpiabi_file_write_at_all_end_)(
  const MPIABI_Fint * fh,
  const void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_at_all_end_(
  const MPIABI_Fint * fh,
  const void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_at_all_end_)(
    fh,
    buf,
    status,
    ierror
  );
}
void pmpi_file_write_at_all_end_(
  const MPIABI_Fint * fh,
  const void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_at_all_end_)(
    fh,
    buf,
    status,
    ierror
  );
}

void (* mpiabi_file_read_all_begin_)(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_all_begin_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_all_begin_)(
    fh,
    buf,
    count,
    datatype,
    ierror
  );
}
void pmpi_file_read_all_begin_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_all_begin_)(
    fh,
    buf,
    count,
    datatype,
    ierror
  );
}

void (* mpiabi_file_read_all_end_)(
  const MPIABI_Fint * fh,
  void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_all_end_(
  const MPIABI_Fint * fh,
  void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_all_end_)(
    fh,
    buf,
    status,
    ierror
  );
}
void pmpi_file_read_all_end_(
  const MPIABI_Fint * fh,
  void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_all_end_)(
    fh,
    buf,
    status,
    ierror
  );
}

void (* mpiabi_file_write_all_begin_)(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_all_begin_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_all_begin_)(
    fh,
    buf,
    count,
    datatype,
    ierror
  );
}
void pmpi_file_write_all_begin_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_all_begin_)(
    fh,
    buf,
    count,
    datatype,
    ierror
  );
}

void (* mpiabi_file_write_all_end_)(
  const MPIABI_Fint * fh,
  const void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_all_end_(
  const MPIABI_Fint * fh,
  const void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_all_end_)(
    fh,
    buf,
    status,
    ierror
  );
}
void pmpi_file_write_all_end_(
  const MPIABI_Fint * fh,
  const void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_all_end_)(
    fh,
    buf,
    status,
    ierror
  );
}

void (* mpiabi_file_read_ordered_begin_)(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_ordered_begin_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_ordered_begin_)(
    fh,
    buf,
    count,
    datatype,
    ierror
  );
}
void pmpi_file_read_ordered_begin_(
  const MPIABI_Fint * fh,
  void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_ordered_begin_)(
    fh,
    buf,
    count,
    datatype,
    ierror
  );
}

void (* mpiabi_file_read_ordered_end_)(
  const MPIABI_Fint * fh,
  void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_read_ordered_end_(
  const MPIABI_Fint * fh,
  void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_ordered_end_)(
    fh,
    buf,
    status,
    ierror
  );
}
void pmpi_file_read_ordered_end_(
  const MPIABI_Fint * fh,
  void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_read_ordered_end_)(
    fh,
    buf,
    status,
    ierror
  );
}

void (* mpiabi_file_write_ordered_begin_)(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_ordered_begin_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_ordered_begin_)(
    fh,
    buf,
    count,
    datatype,
    ierror
  );
}
void pmpi_file_write_ordered_begin_(
  const MPIABI_Fint * fh,
  const void * buf,
  const MPIABI_Fint * count,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_ordered_begin_)(
    fh,
    buf,
    count,
    datatype,
    ierror
  );
}

void (* mpiabi_file_write_ordered_end_)(
  const MPIABI_Fint * fh,
  const void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_write_ordered_end_(
  const MPIABI_Fint * fh,
  const void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_ordered_end_)(
    fh,
    buf,
    status,
    ierror
  );
}
void pmpi_file_write_ordered_end_(
  const MPIABI_Fint * fh,
  const void * buf,
  MPIABI_Fint * status,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_write_ordered_end_)(
    fh,
    buf,
    status,
    ierror
  );
}

void (* mpiabi_file_get_type_extent_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_get_type_extent_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_type_extent_)(
    fh,
    datatype,
    extent,
    ierror
  );
}
void pmpi_file_get_type_extent_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * datatype,
  MPIABI_Fint * extent,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_type_extent_)(
    fh,
    datatype,
    extent,
    ierror
  );
}

void (* mpiabi_file_set_atomicity_)(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_set_atomicity_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_set_atomicity_)(
    fh,
    flag,
    ierror
  );
}
void pmpi_file_set_atomicity_(
  const MPIABI_Fint * fh,
  const MPIABI_Fint * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_set_atomicity_)(
    fh,
    flag,
    ierror
  );
}

void (* mpiabi_file_get_atomicity_)(
  const MPIABI_Fint * fh,
  int * flag,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_get_atomicity_(
  const MPIABI_Fint * fh,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_atomicity_)(
    fh,
    flag,
    ierror
  );
}
void pmpi_file_get_atomicity_(
  const MPIABI_Fint * fh,
  int * flag,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_get_atomicity_)(
    fh,
    flag,
    ierror
  );
}

void (* mpiabi_file_sync_)(
  const MPIABI_Fint * fh,
  MPIABI_Fint * ierror
) = NULL;
void mpi_file_sync_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_sync_)(
    fh,
    ierror
  );
}
void pmpi_file_sync_(
  const MPIABI_Fint * fh,
  MPIABI_Fint * ierror
) {
  return (* mpiabi_file_sync_)(
    fh,
    ierror
  );
}
