C
C  This file is part of MUMPS 5.8.0, released
C  on Sun May  4 17:45:59 UTC 2025
C
C
C  Copyright 1991-2025 CERFACS, CNRS, ENS Lyon, INP Toulouse, Inria,
C  Mumps Technologies, University of Bordeaux.
C
C  This version of MUMPS is provided to you free of charge. It is
C  released under the CeCILL-C license 
C  (see doc/CeCILL-C_V1-en.txt, doc/CeCILL-C_V1-fr.txt, and
C  https://cecill.info/licences/Licence_CeCILL-C_V1-en.html)
C
      SUBROUTINE SMUMPS_SCATTER_DIST_RHS(
     &           NSLAVES, N,
     &           MYID_NODES, COMM_NODES,
     &           NRHS_COL, NRHS_loc, LRHS_loc,
     &           MAP_RHS_loc,
     &           IRHS_loc, RHS_loc, RHS_loc_size,
     &           RHSINTR, LD_RHSINTR,
     &           POSINRHSINTR_FWD, NB_FS_IN_RHSINTR,
     &           LSCAL,
#if defined(USE_OLD_SCALING)
     &           scaling_data_dr,
#else
     &           SCALING_RHSINTR_FWD, LSCALING_RHSINTR_FWD,
#endif
     &           LP, LPOK, KEEP, NB_BYTES_LOC, INFO )
      USE SMUMPS_STRUC_DEF
!$    USE OMP_LIB
      IMPLICIT NONE
      INTEGER, INTENT(IN)    :: NSLAVES, N, MYID_NODES
      INTEGER, INTENT(IN)    :: NRHS_loc, LRHS_loc
      INTEGER, INTENT(IN)    :: NRHS_COL
      INTEGER, INTENT(IN)    :: COMM_NODES
      INTEGER, INTENT(IN)    :: MAP_RHS_loc(max(1,NRHS_loc))
      INTEGER, INTENT(IN)    :: IRHS_loc(NRHS_loc)
      INTEGER(8), INTENT(IN) :: RHS_loc_size
      REAL, INTENT(IN)    :: RHS_loc(RHS_loc_size)
      INTEGER, INTENT(IN)    :: NB_FS_IN_RHSINTR, LD_RHSINTR
      INTEGER, INTENT(IN)    :: POSINRHSINTR_FWD(N)
      REAL, INTENT(OUT)   :: RHSINTR(LD_RHSINTR, NRHS_COL)
      INTEGER                :: KEEP(500)
      LOGICAL, INTENT(IN)    :: LSCAL
#if defined(USE_OLD_SCALING)
      type scaling_data_t
        SEQUENCE
        REAL,    dimension(:), pointer :: SCALING
        REAL,    dimension(:), pointer :: SCALING_LOC
        INTEGER, dimension(:), pointer :: SCALING_IND 
      end type scaling_data_t
      type(scaling_data_t), INTENT(IN) :: scaling_data_dr
#else
      INTEGER :: LSCALING_RHSINTR_FWD
      REAL :: SCALING_RHSINTR_FWD( LSCALING_RHSINTR_FWD )
#endif
      LOGICAL, INTENT(IN)    :: LPOK
      INTEGER, INTENT(IN)    :: LP      
      INTEGER, INTENT(INOUT) :: INFO(2) 
      INTEGER(8), INTENT(OUT):: NB_BYTES_LOC
      INCLUDE 'mpif.h'
      INTEGER :: IERR_MPI
      LOGICAL :: OMP_FLAG
!$    INTEGER :: CHUNK, NOMP
!$    INTEGER(8) :: CHUNK8
      INTEGER :: allocok
      INTEGER :: MAXRECORDS
      INTEGER, ALLOCATABLE, DIMENSION(:) :: NBROWSTOSEND 
      INTEGER, ALLOCATABLE, DIMENSION(:) :: NEXTROWTOSEND 
      REAL, ALLOCATABLE, DIMENSION(:,:)   :: BUFR
      INTEGER, ALLOCATABLE, DIMENSION(:) :: BUFRECI 
      REAL, ALLOCATABLE, DIMENSION(:) :: BUFRECR
      LOGICAL, ALLOCATABLE, DIMENSION(:) :: IS_SEND_ACTIVE, TOUCHED
      INTEGER, ALLOCATABLE, DIMENSION(:) :: MPI_REQI, MPI_REQR
      INTEGER, ALLOCATABLE, DIMENSION(:) :: IRHS_loc_sorted
      INTEGER :: Iloc  
      INTEGER :: Iloc_sorted 
      INTEGER :: IREQ  
      INTEGER :: IMAP, IPROC_MAX 
      INTEGER :: IFS   
      INTEGER :: MAX_ACTIVE_SENDS
      INTEGER :: NB_ACTIVE_SENDS
      INTEGER :: NB_FS_TOUCHED
      INTEGER :: NBROWSTORECV                
      REAL, PARAMETER :: ZERO = 0.0E0
#if defined(AVOID_MPI_IN_PLACE)
      INTEGER :: allocoktmp
#endif
!$    NOMP = OMP_GET_MAX_THREADS()
      NB_BYTES_LOC = 0_8
      ALLOCATE( NBROWSTOSEND    (NSLAVES),
     &          NEXTROWTOSEND   (NSLAVES),
     &          IRHS_loc_sorted (NRHS_loc),
     &          stat=allocok )
      IF (allocok > 0) THEN
        INFO(1) = -13
        INFO(2) = NSLAVES+NSLAVES+NRHS_loc
      ELSE
        NB_BYTES_LOC = int(2*NSLAVES+NRHS_loc,8)*KEEP(34)
      ENDIF
#if defined(AVOID_MPI_IN_PLACE)
      allocoktmp=allocok
      CALL MPI_ALLREDUCE( allocoktmp, allocok, 1,
#else
      CALL MPI_ALLREDUCE( MPI_IN_PLACE, allocok, 1,
#endif
     &                    MPI_INTEGER, MPI_SUM,
     &                    COMM_NODES, IERR_MPI )
      IF (allocok .GT. 0) RETURN
      NBROWSTOSEND(1:NSLAVES) = 0
      DO Iloc = 1, NRHS_loc
        IF (IRHS_loc(Iloc) .GE. 1 .AND.
     &      IRHS_loc(Iloc) .LE. N) THEN
          IMAP = MAP_RHS_loc(Iloc)
          NBROWSTOSEND(IMAP+1) = NBROWSTOSEND(IMAP+1)+1
        ENDIF
      ENDDO
      NEXTROWTOSEND(1)=1 
      DO IMAP=1, NSLAVES-1
        NEXTROWTOSEND(IMAP+1)=NEXTROWTOSEND(IMAP)+NBROWSTOSEND(IMAP)
      ENDDO
      NBROWSTOSEND=0
      DO Iloc = 1, NRHS_loc
        IF (IRHS_loc(Iloc) .GE. 1 .AND.
     &      IRHS_loc(Iloc) .LE. N) THEN
          IMAP = MAP_RHS_loc(Iloc)
          Iloc_sorted = NEXTROWTOSEND(IMAP+1)+NBROWSTOSEND(IMAP+1)
          IRHS_loc_sorted(Iloc_sorted) = Iloc
          NBROWSTOSEND(IMAP+1)=NBROWSTOSEND(IMAP+1)+1
        ENDIF
      ENDDO
      CALL SMUMPS_DR_BUILD_NBROWSTORECV()
      MAX_ACTIVE_SENDS = min(10, NSLAVES)
      IF (KEEP(72) .EQ.1 ) THEN
        MAXRECORDS = 15
      ELSE
        MAXRECORDS = min(200000,2000000/NRHS_COL)
        MAXRECORDS = min(MAXRECORDS,
     &                50000000 / MAX_ACTIVE_SENDS / NRHS_COL)
        MAXRECORDS = max(MAXRECORDS, 50)
      ENDIF
      ALLOCATE(BUFR(MAXRECORDS*NRHS_COL,
     &                        MAX_ACTIVE_SENDS),   
     &         MPI_REQI(MAX_ACTIVE_SENDS),         
     &         MPI_REQR(MAX_ACTIVE_SENDS),         
     &         IS_SEND_ACTIVE(MAX_ACTIVE_SENDS),
     &         BUFRECI(MAXRECORDS),                
     &         BUFRECR(MAXRECORDS*NRHS_COL),       
     &         TOUCHED(NB_FS_IN_RHSINTR),          
     &         stat=allocok)
      IF (allocok .GT. 0) THEN
        IF (LP .GT. 0) WRITE(LP, '(A)')
     &    'Error: Allocation problem in SMUMPS_SCATTER_DIST_RHS'
        INFO(1)=-13
        INFO(2)=NRHS_COL*MAXRECORDS*MAX_ACTIVE_SENDS+
     &          3*MAX_ACTIVE_SENDS+MAXRECORDS*(1+NRHS_COL)
     &          + NB_FS_IN_RHSINTR
      ENDIF
      NB_BYTES_LOC=NB_BYTES_LOC +
     &  KEEP(34) * ( int(2*MAX_ACTIVE_SENDS,8) + int(MAXRECORDS,8) ) +
     &  KEEP(34) * (int(MAX_ACTIVE_SENDS,8) + int(NB_FS_IN_RHSINTR,8)) +
     &  KEEP(35) * (
     &      int( MAXRECORDS,8)*int(NRHS_COL,8)*int(MAX_ACTIVE_SENDS,8)
     &      + int(MAXRECORDS,8) * int(NRHS_COL,8) )
      CALL MPI_ALLREDUCE( MPI_IN_PLACE, allocok, 1,
     &                    MPI_INTEGER, MPI_SUM,
     &                    COMM_NODES, IERR_MPI )
      IF (allocok .NE. 0) RETURN
      NB_ACTIVE_SENDS = 0
      DO IREQ = 1, MAX_ACTIVE_SENDS
        IS_SEND_ACTIVE(IREQ) = .FALSE.
      ENDDO
      NB_FS_TOUCHED = 0
      DO IFS = 1, NB_FS_IN_RHSINTR
        TOUCHED(IFS) = .FALSE.
      ENDDO
      IPROC_MAX=maxloc(NBROWSTOSEND,DIM=1)-1
      DO WHILE (NBROWSTOSEND(IPROC_MAX+1) .NE. 0)
        IF (IPROC_MAX .EQ. MYID_NODES) THEN
          CALL SMUMPS_DR_ASSEMBLE_LOCAL()
        ELSE
          CALL SMUMPS_DR_TRY_SEND(IPROC_MAX)
        ENDIF
        CALL SMUMPS_DR_TRY_RECV()
        CALL SMUMPS_DR_TRY_FREE_SEND()
        IPROC_MAX=maxloc(NBROWSTOSEND,DIM=1)-1
      ENDDO
      DO WHILE ( NBROWSTORECV .NE. 0)
        CALL SMUMPS_DR_TRY_RECV()
        CALL SMUMPS_DR_TRY_FREE_SEND()
      ENDDO
      DO WHILE (NB_ACTIVE_SENDS .NE. 0)
        CALL SMUMPS_DR_TRY_FREE_SEND()
      ENDDO
      CALL SMUMPS_DR_EMPTY_ROWS()
      RETURN
      CONTAINS
        SUBROUTINE SMUMPS_DR_BUILD_NBROWSTORECV()
        INTEGER :: IPROC
        DO IPROC = 0, NSLAVES-1
          CALL MPI_REDUCE( NBROWSTOSEND(IPROC+1), NBROWSTORECV,
     &                   1, MPI_INTEGER,
     &                   MPI_SUM, IPROC, COMM_NODES, IERR_MPI )
        ENDDO
        END SUBROUTINE SMUMPS_DR_BUILD_NBROWSTORECV
        SUBROUTINE SMUMPS_DR_TRY_RECV()
        IMPLICIT NONE
        INCLUDE 'mumps_tags.h'
        INTEGER :: MPI_STATUS(MPI_STATUS_SIZE), MSGSOU
        INTEGER :: NBRECORDS
        LOGICAL :: FLAG
        CALL MPI_IPROBE( MPI_ANY_SOURCE, DistRhsI, COMM_NODES,
     &                   FLAG, MPI_STATUS, IERR_MPI )
        IF (FLAG) THEN
          MSGSOU = MPI_STATUS( MPI_SOURCE )
          CALL MPI_GET_COUNT(MPI_STATUS, MPI_INTEGER,
     &                       NBRECORDS, IERR_MPI)
          CALL MPI_RECV(BUFRECI(1), NBRECORDS, MPI_INTEGER,
     &                  MSGSOU, DistRhsI,
     &                  COMM_NODES, MPI_STATUS, IERR_MPI)
          CALL MPI_RECV(BUFRECR(1), NBRECORDS*NRHS_COL,
     &                  MPI_REAL,
     &                  MSGSOU, DistRhsR,
     &                  COMM_NODES, MPI_STATUS, IERR_MPI)
          CALL SMUMPS_DR_ASSEMBLE_FROM_BUFREC(NBRECORDS,
     &                                        BUFRECI, BUFRECR)
        ENDIF
        RETURN
        END SUBROUTINE SMUMPS_DR_TRY_RECV
        SUBROUTINE SMUMPS_DR_ASSEMBLE_FROM_BUFREC
     &             (NBRECORDS, BUFRECI_ARG, BUFRECR_ARG)
        IMPLICIT NONE
        INTEGER, INTENT(IN) :: NBRECORDS
        INTEGER, INTENT(INOUT) :: BUFRECI_ARG(NBRECORDS) 
        REAL, INTENT(IN) :: BUFRECR_ARG(NBRECORDS,
     &                                     NRHS_COL)
        INTEGER :: I, K, IRHSINTR, IFIRSTNOTTOUCHED, ILASTNOTTOUCHED
        IFIRSTNOTTOUCHED = NBRECORDS+1
        ILASTNOTTOUCHED  = 0
        DO I = 1, NBRECORDS
          IF (BUFRECI(I) .LE. 0) THEN
            WRITE(*,*) "Internal error 1 in SMUMPS_DR_TRY_RECV",
     &      I, BUFRECI(I), BUFRECI(1)
            CALL MUMPS_ABORT()
          ENDIF
          IRHSINTR=POSINRHSINTR_FWD(BUFRECI(I))
          BUFRECI_ARG(I)=IRHSINTR
          IF ( .NOT. TOUCHED(IRHSINTR) ) THEN
            IFIRSTNOTTOUCHED=min(IFIRSTNOTTOUCHED,I)
            ILASTNOTTOUCHED=max(ILASTNOTTOUCHED,I)
          ENDIF
        ENDDO
        OMP_FLAG = .FALSE.
!$      OMP_FLAG = ( NRHS_COL.GE.KEEP(362) .AND.
!$   &               NRHS_COL*NBRECORDS .GE. KEEP(363)/2)
        IF (OMP_FLAG) THEN
!$OMP PARALLEL DO PRIVATE(I,IRHSINTR)
        DO K = 1, NRHS_COL
          DO I = IFIRSTNOTTOUCHED, ILASTNOTTOUCHED
            IRHSINTR=BUFRECI_ARG(I)
            IF (.NOT. TOUCHED(IRHSINTR)) THEN
              RHSINTR(IRHSINTR,K)=ZERO
            ENDIF
          ENDDO
#if ! defined(USE_OLD_SCALING)
          IF (LSCAL) THEN
            DO I = 1, NBRECORDS
              IRHSINTR=BUFRECI_ARG(I)
              RHSINTR(IRHSINTR,K) = RHSINTR(IRHSINTR,K) +
     &                            SCALING_RHSINTR_FWD(IRHSINTR) *
     &                            BUFRECR_ARG(I,K)
            ENDDO
          ELSE
#endif
            DO I = 1, NBRECORDS
              IRHSINTR=BUFRECI_ARG(I)
              RHSINTR(IRHSINTR,K) = RHSINTR(IRHSINTR,K) +
     &                            BUFRECR_ARG(I,K)
            ENDDO
#if ! defined(USE_OLD_SCALING)
          ENDIF
#endif
        ENDDO
!$OMP END PARALLEL DO
        ELSE
          DO K = 1, NRHS_COL
            DO I = IFIRSTNOTTOUCHED, ILASTNOTTOUCHED
              IRHSINTR=BUFRECI_ARG(I)
              IF (.NOT. TOUCHED(IRHSINTR)) THEN
                RHSINTR(IRHSINTR,K)=ZERO
              ENDIF
            ENDDO
#if ! defined(USE_OLD_SCALING)
            IF ( LSCAL ) THEN
              DO I = 1, NBRECORDS
                IRHSINTR=BUFRECI_ARG(I)
                RHSINTR(IRHSINTR,K) = RHSINTR(IRHSINTR,K) +
     &                                SCALING_RHSINTR_FWD(IRHSINTR) *
     &                                BUFRECR_ARG(I,K)
              ENDDO
            ELSE
#endif
              DO I = 1, NBRECORDS
                IRHSINTR=BUFRECI_ARG(I)
                RHSINTR(IRHSINTR,K) = RHSINTR(IRHSINTR,K) +
     &                                BUFRECR_ARG(I,K)
              ENDDO
#if ! defined(USE_OLD_SCALING)
            ENDIF
#endif
          ENDDO
        ENDIF
        DO I = 1, NBRECORDS
          IRHSINTR = BUFRECI_ARG(I)
          IF (.NOT. TOUCHED(IRHSINTR)) THEN
            NB_FS_TOUCHED = NB_FS_TOUCHED + 1
            TOUCHED(IRHSINTR) = .TRUE.
          ENDIF
        ENDDO
        NBROWSTORECV = NBROWSTORECV - NBRECORDS
        RETURN
        END SUBROUTINE SMUMPS_DR_ASSEMBLE_FROM_BUFREC
        SUBROUTINE SMUMPS_DR_ASSEMBLE_LOCAL()
        INTEGER :: NBRECORDS, I, K, IFIRSTNOTTOUCHED
        INTEGER :: Iloc       
        INTEGER :: Iglob      
        INTEGER :: IRHSINTR   
        INTEGER(8) :: ISHIFT
        IF ( NBROWSTOSEND(MYID_NODES+1) .EQ. 0) THEN
          WRITE(*,*) "Internal error in SMUMPS_DR_ASSEMBLE_LOCAL"
          CALL MUMPS_ABORT()
        ENDIF
        NBRECORDS=min(MAXRECORDS, NBROWSTOSEND(MYID_NODES+1))
        IFIRSTNOTTOUCHED=NBRECORDS+1
        DO I = 1, NBRECORDS
          IRHSINTR = POSINRHSINTR_FWD(IRHS_loc(
     &               IRHS_loc_sorted(NEXTROWTOSEND(MYID_NODES+1)+I-1)))
          IF (.NOT. TOUCHED(IRHSINTR)) THEN
            IFIRSTNOTTOUCHED=I
            EXIT
          ENDIF
        ENDDO
        IF (LSCAL) THEN
!$        OMP_FLAG = (NRHS_COL.GE.KEEP(362) .AND.
!$   &                NRHS_COL*NBRECORDS .GE. KEEP(363)/2)
!$OMP PARALLEL DO PRIVATE(K, ISHIFT, I, IRHSINTR, Iloc, Iglob)
!$OMP&  FIRSTPRIVATE(NBRECORDS) IF (OMP_FLAG)
          DO K = 1, NRHS_COL
            ISHIFT = int(K-1,8) * int(LRHS_loc,8)
            DO I = IFIRSTNOTTOUCHED, NBRECORDS
              IRHSINTR = POSINRHSINTR_FWD(IRHS_loc(
     &               IRHS_loc_sorted(NEXTROWTOSEND(MYID_NODES+1)+I-1)))
               IF (.NOT. TOUCHED(IRHSINTR)) THEN
                 RHSINTR(IRHSINTR,K)=ZERO
               ENDIF
            ENDDO
            DO I = 1, NBRECORDS
              Iloc = IRHS_loc_sorted(NEXTROWTOSEND(MYID_NODES+1)+I-1)
              Iglob = IRHS_loc(Iloc)
              IRHSINTR = POSINRHSINTR_FWD(Iglob)
              RHSINTR(IRHSINTR,K) = RHSINTR(IRHSINTR,K)+
     &                              RHS_loc(Iloc+ISHIFT)*
#if defined(USE_OLD_SCALING)
     &                        scaling_data_dr%SCALING_LOC(Iloc)
#else
     &                        SCALING_RHSINTR_FWD(IRHSINTR)
#endif
            ENDDO
          ENDDO
!$OMP END PARALLEL DO
        ELSE
!$        OMP_FLAG = (NRHS_COL.GE.KEEP(362) .AND.
!$   &                NRHS_COL*NBRECORDS .GE. KEEP(363)/2)
!$OMP PARALLEL DO PRIVATE(K, ISHIFT, I, IRHSINTR, Iloc, Iglob)
!$OMP&  FIRSTPRIVATE(NBRECORDS) IF (OMP_FLAG)
          DO K = 1, NRHS_COL
            ISHIFT = int(K-1,8) * int(LRHS_loc,8)
            DO I = IFIRSTNOTTOUCHED, NBRECORDS
              IRHSINTR = POSINRHSINTR_FWD(IRHS_loc(
     &               IRHS_loc_sorted(NEXTROWTOSEND(MYID_NODES+1)+I-1)))
               IF (.NOT. TOUCHED(IRHSINTR)) THEN
                 RHSINTR(IRHSINTR,K)=ZERO
               ENDIF
            ENDDO
            DO I = 1, NBRECORDS
              Iloc = IRHS_loc_sorted(NEXTROWTOSEND(MYID_NODES+1)+I-1)
              Iglob = IRHS_loc(Iloc)
              IRHSINTR = POSINRHSINTR_FWD(Iglob)
              RHSINTR(IRHSINTR,K) = RHSINTR(IRHSINTR,K) +
     &                              RHS_loc(Iloc+ISHIFT)
            ENDDO
          ENDDO
!$OMP END PARALLEL DO
        ENDIF
        DO I = 1, NBRECORDS
          IRHSINTR = POSINRHSINTR_FWD(IRHS_loc(
     &               IRHS_loc_sorted(NEXTROWTOSEND(MYID_NODES+1)+I-1)))
          IF (.NOT. TOUCHED(IRHSINTR)) THEN
            NB_FS_TOUCHED = NB_FS_TOUCHED + 1
            TOUCHED(IRHSINTR) = .TRUE.
          ENDIF
        ENDDO
        NEXTROWTOSEND(MYID_NODES+1)=NEXTROWTOSEND(MYID_NODES+1)+
     &                              NBRECORDS
        NBROWSTOSEND(MYID_NODES+1)=NBROWSTOSEND(MYID_NODES+1)-
     &                             NBRECORDS
        NBROWSTORECV = NBROWSTORECV - NBRECORDS
        RETURN
        END SUBROUTINE SMUMPS_DR_ASSEMBLE_LOCAL
        SUBROUTINE SMUMPS_DR_GET_NEW_BUF( IBUF )
        INTEGER, INTENT(OUT) :: IBUF
        INTEGER :: I
        IBUF = -1
        IF (NB_ACTIVE_SENDS .NE. MAX_ACTIVE_SENDS) THEN
          DO I=1, MAX_ACTIVE_SENDS
            IF (.NOT. IS_SEND_ACTIVE(I)) THEN
              IBUF = I
              EXIT
            ENDIF
          ENDDO
        ENDIF
        RETURN
        END SUBROUTINE SMUMPS_DR_GET_NEW_BUF
        SUBROUTINE SMUMPS_DR_TRY_FREE_SEND()
        INTEGER :: MPI_STATUS(MPI_STATUS_SIZE)
        INTEGER :: I
        LOGICAL :: FLAG
        IF (NB_ACTIVE_SENDS .GT. 0) THEN
          DO I=1, MAX_ACTIVE_SENDS
            IF (IS_SEND_ACTIVE(I)) THEN
              CALL MPI_TEST( MPI_REQR(I), FLAG, MPI_STATUS, IERR_MPI )
              IF (FLAG) THEN
                 CALL MPI_WAIT(MPI_REQI(I), MPI_STATUS, IERR_MPI)
                 NB_ACTIVE_SENDS = NB_ACTIVE_SENDS - 1
                 IS_SEND_ACTIVE(I)=.FALSE.
                 IF (NB_ACTIVE_SENDS .EQ. 0) THEN
                   RETURN
                 ENDIF
              ENDIF
            ENDIF
          ENDDO
        ENDIF
        RETURN
        END SUBROUTINE SMUMPS_DR_TRY_FREE_SEND
        SUBROUTINE SMUMPS_DR_TRY_SEND(IPROC_ARG)
        IMPLICIT NONE
        INTEGER, INTENT(IN)    :: IPROC_ARG
        INCLUDE 'mumps_tags.h'
        INTEGER :: NBRECORDS, IBUF, I, K
        INTEGER(8) :: IPOSRHS 
        INTEGER    :: IPOSBUF 
        IF (IPROC_ARG .EQ. MYID_NODES) THEN
          WRITE(*,*) "Internal error 1 in SMUMPS_DR_TRY_SEND"
          CALL MUMPS_ABORT()
        ENDIF
        IF (NBROWSTOSEND(IPROC_ARG+1) .EQ. 0) THEN
          WRITE(*,*) "Internal error 2 in SMUMPS_DR_TRY_SEND"
          CALL MUMPS_ABORT()
        ENDIF
        CALL SMUMPS_DR_GET_NEW_BUF(IBUF)
        IF (IBUF .GT. 0) THEN
          NBRECORDS = min(MAXRECORDS,NBROWSTOSEND(IPROC_ARG+1))
!$        OMP_FLAG = .FALSE.
!$        CHUNK = NRHS_COL*NBRECORDS
!$        IF (CHUNK .GE. KEEP(363)) THEN
!$          OMP_FLAG = .TRUE.
!$          CHUNK = max((CHUNK+NOMP-1)/NOMP,KEEP(363)/2)
!$        ENDIF
          IF (LSCAL) THEN
!$OMP PARALLEL DO COLLAPSE(2) SCHEDULE(STATIC,CHUNK)
!$OMP& PRIVATE(K, I, IPOSBUF, IPOSRHS, Iloc) IF (OMP_FLAG)
            DO K=1, NRHS_COL
              DO I = 1, NBRECORDS
                IPOSBUF = (K-1)*NBRECORDS
                IPOSRHS = int(K-1,8)*int(LRHS_loc,8)
                Iloc = IRHS_loc_sorted(NEXTROWTOSEND(IPROC_ARG+1)+I-1)
                BUFR( IPOSBUF + I, IBUF )
     &                = RHS_loc( IPOSRHS + Iloc )
#if defined(USE_OLD_SCALING)
     &                  * scaling_data_dr%SCALING_LOC(Iloc)
#endif
              ENDDO
            ENDDO
!$OMP END PARALLEL DO
          ELSE
!$OMP PARALLEL DO COLLAPSE(2) SCHEDULE(STATIC,CHUNK)
!$OMP& PRIVATE(K, I, IPOSBUF, IPOSRHS, Iloc) IF (OMP_FLAG)
            DO K=1, NRHS_COL
              DO I = 1, NBRECORDS
                IPOSBUF = (K-1)*NBRECORDS
                IPOSRHS = int(K-1,8)*int(LRHS_loc,8)
                Iloc = IRHS_loc_sorted(NEXTROWTOSEND(IPROC_ARG+1)+I-1)
                BUFR( IPOSBUF + I, IBUF )
     &              = RHS_loc( IPOSRHS + Iloc )
              ENDDO
            ENDDO
!$OMP END PARALLEL DO
          ENDIF
          DO I = 1, NBRECORDS
            Iloc = IRHS_loc_sorted(NEXTROWTOSEND(IPROC_ARG+1)+I-1)
            IRHS_loc_sorted(NEXTROWTOSEND(IPROC_ARG+1)+I-1)
     &           = IRHS_loc(Iloc)
          ENDDO
          CALL MPI_ISEND( IRHS_loc_sorted(NEXTROWTOSEND(IPROC_ARG+1)),
     &                    NBRECORDS, MPI_INTEGER, IPROC_ARG, DistRhsI,
     &                    COMM_NODES, MPI_REQI(IBUF), IERR_MPI )
          CALL MPI_ISEND( BUFR(1,IBUF), NBRECORDS*NRHS_COL,
     &                    MPI_REAL,
     &                    IPROC_ARG, DistRhsR,
     &                    COMM_NODES, MPI_REQR(IBUF), IERR_MPI )
          NEXTROWTOSEND(IPROC_ARG+1)=NEXTROWTOSEND(IPROC_ARG+1)+
     &                               NBRECORDS
          NBROWSTOSEND(IPROC_ARG+1)=NBROWSTOSEND(IPROC_ARG+1)-NBRECORDS
          NB_ACTIVE_SENDS = NB_ACTIVE_SENDS + 1
          IS_SEND_ACTIVE(IBUF)=.TRUE.
        ENDIF
        RETURN
        END SUBROUTINE SMUMPS_DR_TRY_SEND
        SUBROUTINE SMUMPS_DR_EMPTY_ROWS()
        INTEGER :: K, IFS
        IF ( NB_FS_TOUCHED .NE. NB_FS_IN_RHSINTR ) THEN
!$        OMP_FLAG = (NRHS_COL .GE. KEEP(362)) .AND.
!$   &    (NRHS_COL*NB_FS_IN_RHSINTR >  KEEP(363)/2)
!$OMP PARALLEL DO FIRSTPRIVATE(NB_FS_IN_RHSINTR)
!$OMP&    PRIVATE(IFS) IF (OMP_FLAG)
          DO K = 1, NRHS_COL
            DO IFS = 1, NB_FS_IN_RHSINTR
              IF ( .NOT. TOUCHED(IFS) ) THEN
                RHSINTR( IFS, K) = ZERO
              ENDIF
            ENDDO
            DO IFS = NB_FS_IN_RHSINTR +1, LD_RHSINTR
              RHSINTR (IFS, K) = ZERO
            ENDDO
          ENDDO
!$OMP END PARALLEL DO
        ELSE
!$        OMP_FLAG = .FALSE.
!$        CHUNK8 = int(NRHS_COL,8)*int(LD_RHSINTR-NB_FS_IN_RHSINTR,8)
!$        CHUNK8 = max(CHUNK8,1_8)
!$        IF (CHUNK8 .GE. int(KEEP(363),8)) THEN
!$          OMP_FLAG = .TRUE.
!$          CHUNK8 = max((CHUNK8+NOMP-1)/NOMP,int(KEEP(363)/2,8))
!$        ENDIF
!$OMP PARALLEL DO COLLAPSE(2) SCHEDULE(STATIC,CHUNK8)
!$OMP&  IF (OMP_FLAG)
          DO K = 1, NRHS_COL
            DO IFS = NB_FS_IN_RHSINTR +1, LD_RHSINTR
             RHSINTR (IFS, K) = ZERO
            ENDDO
          ENDDO
!$OMP END PARALLEL DO
        ENDIF
        RETURN
        END SUBROUTINE SMUMPS_DR_EMPTY_ROWS
      END SUBROUTINE SMUMPS_SCATTER_DIST_RHS
      SUBROUTINE SMUMPS_SOL_INIT_IRHS_loc(id)
      USE SMUMPS_STRUC_DEF
      IMPLICIT NONE
        TYPE (SMUMPS_STRUC) :: id
        INTEGER, PARAMETER :: MASTER = 0
        INTEGER            :: ROW_OR_COL_INDICES 
        INTEGER            :: IERR_MPI
        LOGICAL            :: I_AM_SLAVE
        INTEGER, POINTER   :: idIRHS_loc(:)
        INTEGER, POINTER   :: UNS_PERM(:)
        INTEGER            :: UNS_PERM_TO_BE_DONE, I, allocok
        INTEGER, TARGET    :: IDUMMY(1)
        INCLUDE 'mpif.h'
        NULLIFY(UNS_PERM)
        IF (id%JOB .NE. 9) THEN
          WRITE(*,*) "Internal error 1 in SMUMPS_SOL_INIT_IRHS_loc"
          CALL MUMPS_ABORT()
        ENDIF
        I_AM_SLAVE = ( id%MYID .ne. MASTER  .OR.
     &               ( id%MYID .eq. MASTER .AND.
     &                 id%KEEP(46) .eq. 1 ) )
        IF (id%MYID .EQ. MASTER) THEN
          IF (id%KEEP(50).NE.0) THEN
            ROW_OR_COL_INDICES = 0
          ELSE
            IF (id%ICNTL(20).EQ.10 .OR. id%KEEP(50).EQ.0) THEN
              ROW_OR_COL_INDICES = 0 
            ELSE IF (id%ICNTL(20).EQ.11) THEN
              ROW_OR_COL_INDICES = 1 
            ELSE 
              ROW_OR_COL_INDICES = 0 
            ENDIF
            IF (id%ICNTL(9) .NE. 1) THEN
              ROW_OR_COL_INDICES = 1 - ROW_OR_COL_INDICES
            ENDIF
          ENDIF
          IF (id%KEEP(23).NE.0 .AND. id%ICNTL(9) .NE.1) THEN
            UNS_PERM_TO_BE_DONE = 1
          ELSE
            UNS_PERM_TO_BE_DONE = 0
          ENDIF
        ENDIF
        CALL MPI_BCAST(ROW_OR_COL_INDICES,1,MPI_INTEGER,MASTER,
     &               id%COMM,IERR_MPI)
        CALL MPI_BCAST(UNS_PERM_TO_BE_DONE,1,MPI_INTEGER,MASTER,
     &               id%COMM,IERR_MPI)
        IF ( I_AM_SLAVE ) THEN
          IF (id%KEEP(89) .GT. 0) THEN
            IF (.NOT. associated(id%IRHS_loc)) THEN
              id%INFO(1)=-22
              id%INFO(2)=17
            ELSE IF (size(id%IRHS_loc) < id%KEEP(89) ) THEN
              id%INFO(1)=-22
              id%INFO(2)=17
            ENDIF
          ENDIF
        ENDIF
        CALL MUMPS_PROPINFO( id%ICNTL(1),
     &                       id%INFO(1),
     &                       id%COMM, id%MYID )
        IF (id%INFO(1).LT.0) goto 500
        IF (I_AM_SLAVE) THEN
          IF (associated(id%IRHS_loc)) THEN
            IF (size(id%IRHS_loc) .GT. 0) THEN
              idIRHS_loc => id%IRHS_loc
            ELSE
              idIRHS_loc => IDUMMY
            ENDIF
          ELSE
            idIRHS_loc => IDUMMY
          ENDIF
          CALL MUMPS_GET_INDICES
     &    (id%MYID_NODES, id%NSLAVES, id%N,
     &    id%PTLUST_S(1), id%KEEP(1), id%KEEP8(1), id%IS(1),
     &    max(1, id%KEEP(32)),
     &    id%STEP(1), id%PROCNODE_STEPS(1), idIRHS_loc(1),
     &    ROW_OR_COL_INDICES)
        ENDIF
        IF (UNS_PERM_TO_BE_DONE .EQ. 1) THEN
          IF (id%MYID.NE.MASTER) THEN
            ALLOCATE(UNS_PERM(id%N),stat=allocok)
            IF (allocok > 0) THEN
                id%INFO(1)=-13
                id%INFO(2)=id%N
                GOTO 100
            ENDIF
          ENDIF
 100      CONTINUE
          CALL MUMPS_PROPINFO( id%ICNTL(1),
     &                         id%INFO(1),
     &                         id%COMM, id%MYID )
          IF (id%INFO(1) .LT. 0) GOTO 500
          IF ( id%MYID .EQ. MASTER ) THEN
            UNS_PERM => id%UNS_PERM
          ENDIF
          CALL MPI_BCAST(UNS_PERM(1),id%N,MPI_INTEGER,MASTER,
     &               id%COMM,IERR_MPI)
          IF (I_AM_SLAVE .AND. id%KEEP(89) .NE.0) THEN
            DO I=1, id%KEEP(89)
              id%IRHS_loc(I)=UNS_PERM(id%IRHS_loc(I))
            ENDDO
          ENDIF
        ENDIF
 500    CONTINUE
        IF (id%MYID.NE.MASTER) THEN
           IF (associated(UNS_PERM)) DEALLOCATE(UNS_PERM)
        ENDIF
        NULLIFY(UNS_PERM)
        RETURN
      END SUBROUTINE SMUMPS_SOL_INIT_IRHS_loc
