include Sys

(*
external mkdir : string -> int -> unit = "caml_sys_mkdir"

external rmdir : string -> unit = "caml_sys_rmdir"
*)

(*
module Immediate64 = struct
  module type Non_immediate = sig
    type t
  end
  module type Immediate = sig
    type t

[@@immediate]

  end

  module Make (Immediate : Immediate) (Non_immediate : Non_immediate) = struct
    type t = Non_immediate.t

    type 'a repr =

          | Immediate: Immediate.t repr
          | Non_immediate: Non_immediate.t repr

(*
          | Immediate
          | Non_immediate
*)

    let repr = Non_immediate
  end
end
*)

(*
let max_floatarray_length = max_array_length / (64 / word_size)
*)

(*
let getenv_opt var =
  Stdcompat__tools.option_find getenv var
*)

(*
type backend_type =
  | Native
  | Bytecode
  | Other of string

let backend_type =
  if Stdcompat__native.native then
    Native
  else
    Bytecode
*)

(*
let sigbus = -22

let sigpoll = -23

let sigsys = -24

let sigtrap = -25

let sigurg = -26

let sigxcpu = -27

let sigxfsz = -28

let int_size =
   if 1 lsl word_size = 0 then
     word_size
   else if 1 lsl (word_size - 1) = 0 then
     word_size - 1
   else
     assert false

let big_endian = false

let runtime_variant () = ""

let runtime_parameters () = ""

let enable_runtime_warnings _ = ()

let runtime_warnings_enabled () = false

let opaque_identity x = x
*)

(*
let unix = os_type = "Unix"

let win32 = os_type = "Win32"

let cygwin = os_type = "Cygwin"
*)

(*
let is_directory path =
  try
    ignore (readdir path);
    true
  with Sys_error _ when file_exists path ->
    false
*)

(*
let development_version = false

type extra_prefix = Plus | Tilde

type extra_info = extra_prefix * string

type ocaml_release_info = {
  major : int;
  minor : int;
  patchlevel : int;
  extra : extra_info option
}

let ocaml_release = {
  major = 5;
  minor = 3;
  patchlevel = 0;
  extra = None
}
*)

(*
let is_regular_file _path =
  failwith "not implemented"
*)
