# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Linear model tests."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _LinearModelTest
else:
    import _LinearModelTest

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.metamodel
import openturns.weightedexperiment
import openturns.orthogonalbasis
import openturns.randomvector

def LinearModelFisher(*args):
    r"""
    Test the nullity of the linear regression model coefficients.

    **Available usages**:

        LinearModelTest.LinearModelFisher(*firstSample, secondSample*)

        LinearModelTest.LinearModelFisher(*firstSample, secondSample, level*)

        LinearModelTest.LinearModelFisher(*firstSample, secondSample, linearModelResult*)

        LinearModelTest.LinearModelFisher(*firstSample, secondSample, linearModelResult, level*)


    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModelResult : :class:`~openturns.LinearModelResult`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= first kind risk), it must be
        :math:`< 1`, equal to 0.05 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.LinearModelTest.LinearModelResidualMean

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples.
    The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\vect{X} = (X_i)_{i \leq n}` is as follows:

    .. math::

        \tilde{Y} = a_0 + \sum_{i=1}^n a_i X_i + \epsilon

    where :math:`\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    The LinearModelFisher test checks the nullity of the regression linear model
    coefficients (Fisher distribution is used).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.SymbolicFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelFisher(firstSample, secondSample)
    >>> print(test_result.getPValue())
    5.1...e-12

    """
    return _LinearModelTest.LinearModelFisher(*args)

def LinearModelResidualMean(*args):
    r"""
    Test zero mean value of the residual of the linear regression model.

    **Available usages**:

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample*)

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, level*)

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, linearModelResult*)

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, linearModelResult, level*)


    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModelResult : :class:`~openturns.LinearModelResult`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= first kind risk), it must be
        :math:`< 1`, equal to 0.05 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.LinearModelTest.LinearModelFisher
    openturns.LinearModelTest.LinearModelHarrisonMcCabe

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples.
    The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\vect{X} = (X_i)_{i \leq n}` is as follows:

    .. math::

        \tilde{Y} = a_0 + \sum_{i=1}^n a_i X_i + \epsilon

    where :math:`\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    The LinearModelResidualMean Test checks, under the hypothesis of a gaussian
    sample, if the mean of the residual is equal to zero. It is based on the Student
    test (equality of mean for two gaussian samples).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.SymbolicFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelResidualMean(firstSample, secondSample)

    """
    return _LinearModelTest.LinearModelResidualMean(*args)

def LinearModelHarrisonMcCabe(*args):
    r"""
    Test the homoskedasticity of the linear regression model residuals.

    **Available usages**:

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample*)

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, linearModelResult*)

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, level, breakPoint, simulationSize*)

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, linearModelResult, level, breakPoint, simulationSize*)

    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModelResult : :class:`~openturns.LinearModelResult`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= first kind risk), it must be
        :math:`< 1`, equal to 0.05 by default.
    breakPoint : positive float :math:`< 1`
        Percentage of data to be taken as breakPoint in the variances. It must be
        :math:`< 1`, equal to 0.5 by default.
    simulationSize : positive int
        Size of the sample used to compute the p-value. Default is 1000.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.LinearModelTest.LinearModelBreuschPagan
    openturns.LinearModelTest.LinearModelResidualMean
    openturns.LinearModelTest.LinearModelDurbinWatson

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples.
    The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\vect{X} = (X_i)_{i \leq n}` is as follows:

    .. math::

        \tilde{Y} = a_0 + \sum_{i=1}^n a_i X_i + \epsilon

    where :math:`\epsilon` is the residual.

    The Harrison-McCabe test checks the heteroskedasticity of the residuals. The
    breakpoint in the variances is set by default to the half of the sample. The
    p-value is estimed using simulation. If the binary quality measure is false, then
    the homoskedasticity hypothesis can be rejected with respect to the given level.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.SymbolicFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelHarrisonMcCabe(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=HarrisonMcCabe binaryQualityMeasure=true p-value threshold=0.05 p-value=0.142 statistic=0.373225 description=[]

    """
    return _LinearModelTest.LinearModelHarrisonMcCabe(*args)

def LinearModelBreuschPagan(*args):
    r"""
    Test the homoskedasticity of the linear regression model residuals.

    **Available usages**:

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample*)

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, linearModelResult*)

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, level*)

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, linearModelResult, level*)

    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModelResult : :class:`~openturns.LinearModelResult`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= first kind risk), it must be
        :math:`< 1`, equal to 0.05 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.LinearModelTest.LinearModelHarrisonMcCabe
    openturns.LinearModelTest.LinearModelResidualMean,
    openturns.LinearModelTest.LinearModelDurbinWatson

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples.
    The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\vect{X} = (X_i)_{i \leq n}` is as follows:

    .. math::

        \tilde{Y} = a_0 + \sum_{i=1}^n a_i X_i + \epsilon

    where :math:`\epsilon` is the residual.

    The Breusch-Pagan test checks the heteroskedasticity of the residuals. A linear
    regression model is fitted on the squared residuals. The statistic is computed
    using the Studendized version with the chi-squared distribution. If the binary
    quality measure is false, then the homoskedasticity hypothesis can be rejected
    with respect to the given level.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.SymbolicFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelBreuschPagan(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=BreuschPagan binaryQualityMeasure=true p-value threshold=0.05 p-value=0.700772 statistic=0.14767 description=[]

    """
    return _LinearModelTest.LinearModelBreuschPagan(*args)

def LinearModelDurbinWatson(*args):
    r"""
    Test the autocorrelation of the linear regression model residuals.

    **Available usages**:

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample*)

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, hypothesis, level*)

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, linearModelResult*)

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, linearModelResult, hypothesis, level*)

    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1. This sample should be ordered in increasing order.
    linearModelResult : :class:`~openturns.LinearModelResult`
        A linear model. If not provided, it is built using the given samples.
    hypothesis : str
        Hypothesis H0 for the residuals. It can be : 'Equal' to 0, 'Less' than 0 or
        'Greater' than 0. Default is set to 'Equal' to 0.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= first kind risk), it must be
        :math:`< 1`, equal to 0.05 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.LinearModelTest.LinearModelBreuschPagan
    openturns.LinearModelTest.LinearModelHarrisonMcCabe
    openturns.LinearModelTest.LinearModelResidualMean

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples.
    The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\vect{X} = (X_i)_{i \leq n}` is as follows:

    .. math::

        \tilde{Y} = a_0 + \sum_{i=1}^n a_i X_i + \epsilon

    where :math:`\epsilon` is the residual.

    The Durbin-Watson test checks the autocorrelation of the residuals. It is possible
    to test is the autocorrelation is equal to 0.
    The p-value is computed using a normal approximation based on the mean and variance of the
    Durbin-Watson test statistic. If the binary quality measure is false, then the
    given autocorrelation hypothesis can be rejected with respect to the given level.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.SymbolicFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelDurbinWatson(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=DurbinWatson binaryQualityMeasure=true p-value threshold=0.05 p-value=0.653603 statistic=0.448763 description=[H0: auto.cor=0]

    """
    return _LinearModelTest.LinearModelDurbinWatson(*args)

def PartialRegression(firstSample, secondSample, selection, level=0.05):
    r"""
    Test whether two discrete samples are independent.

    **Available usages**:

        LinearModelTest.PartialRegression(*firstSample, secondSample, selection*)

        LinearModelTest.PartialRegression(*firstSample, secondSample, selection, level*)


    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension :math:`n \geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    selection : sequence of int, maximum integer value :math:`< n`
        List of indices selecting which subsets of the first sample will successively
        be tested with the second sample through the regression test.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= first kind risk), it must be
        :math:`< 1`, equal to 0.05 by default.

    Returns
    -------
    testResults : Collection of :class:`~openturns.TestResult`
        Results for each component of the linear model including intercept.

    See Also
    --------
    openturns.LinearModelTest.FullRegression
    openturns.LinearModelTest.LinearModelFisher

    Notes
    -----
    The Partial Regression Test is used to assess the linearity between a subset of
    components of *firstSample* and *secondSample*.
    The parameter *selection* enables to select specific subsets of the
    *firstSample* to be tested.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> dim = 3
    >>> distCol = [ot.Normal()] * dim
    >>> S = ot.CorrelationMatrix(dim)
    >>> S[0, dim - 1] = 0.99
    >>> copula = ot.NormalCopula(S)
    >>> distribution = ot.JointDistribution(distCol, copula)
    >>> sample = distribution.getSample(30)
    >>> firstSample = sample[:, :2]
    >>> secondSample = sample[:, 2]
    >>> selection = [1]
    >>> test_result = ot.LinearModelTest.PartialRegression(firstSample, secondSample, selection)
    >>> print(test_result[1])
    class=TestResult name=Unnamed type=Regression binaryQualityMeasure=true p-value threshold=0.05 p-value=0.579638 statistic=-0.560438 description=[]
    """
    return _LinearModelTest.PartialRegression(firstSample, secondSample, selection, level)

def FullRegression(firstSample, secondSample, level=0.05):
    r"""
    Test whether two discrete samples are not linear.

    **Available usages**:

        LinearModelTest.FullRegression(*firstSample, secondSample*)

        LinearModelTest.FullRegression(*firstSample, secondSample, level*)


    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension :math:`n \geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= first kind risk), it must be
        :math:`< 1`, equal to 0.05 by default.

    Returns
    -------
    testResults : Collection of :class:`~openturns.TestResult`
        Results for each component of the linear model including intercept.

    See Also
    --------
    openturns.LinearModelTest.PartialRegression
    openturns.LinearModelTest.LinearModelFisher

    Notes
    -----
    The Full Regression Test is used to check the quality of the linear regression
    model between two samples: *firstSample* of dimension *n* and *secondSample* of
    dimension 1. If *firstSample[i]* is the sample extracted from
    *firstSample* (:math:`i^{th}` coordinate of each point of the sample),
    FullRegression performs the linear regression test on all
    *firstSample[i]* and *secondSample*. The linear regression test tests if the
    linear regression model between two scalar samples is not significant.
    It is based on the deviation analysis of the regression.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> dim = 3
    >>> distCol = [ot.Normal()] * dim
    >>> S = ot.CorrelationMatrix(dim)
    >>> S[0, dim - 1] = 0.99
    >>> copula = ot.NormalCopula(S)
    >>> distribution = ot.JointDistribution(distCol, copula)
    >>> sample = distribution.getSample(30)
    >>> firstSample = sample[:, :2]
    >>> secondSample = sample[:, 2]
    >>> test_result = ot.LinearModelTest.FullRegression(firstSample, secondSample)
    >>> print(test_result)
    [class=TestResult name=Unnamed type=Regression binaryQualityMeasure=true p-value threshold=0.05 p-value=0.605 statistic=-0.52335 description=[],class=TestResult name=Unnamed type=Regression binaryQualityMeasure=false p-value threshold=0.05 p-value=9.70282e-27 statistic=44.256 description=[],class=TestResult name=Unnamed type=Regression binaryQualityMeasure=true p-value threshold=0.05 p-value=0.11352 statistic=1.63564 description=[]]
    """
    return _LinearModelTest.FullRegression(firstSample, secondSample, level)

