# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Normality tests."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _NormalityTest
else:
    import _NormalityTest

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula

def AndersonDarlingNormal(sample, level=0.05):
    r"""
    Evaluate whether a sample follows a normal distribution.

    Refer to :ref:`anderson_darling_test`.

    Parameters
    ----------
    sample : 2-d sequence of float
        Tested sample.
    level : positive float, optional
        Threshold p-value of the test (= first kind risk), it must be
        :math:`< 1`, equal to 0.05 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.NormalityTest.CramerVonMisesNormal

    Notes
    -----
    The test is used to check whether the sample follows a normal distribution. This
    test gives more importance to extreme values.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> test_result = ot.NormalityTest.AndersonDarlingNormal(sample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=AndersonDarlingNormal binaryQualityMeasure=true p-value threshold=0.05 p-value=0.7268 statistic=0.255405 description=[]

    """
    return _NormalityTest.AndersonDarlingNormal(sample, level)

def CramerVonMisesNormal(sample, level=0.05):
    r"""
    Evaluate whether a sample follows a normal distribution.

    Refer to :ref:`cramer_vonmises_test`.

    Parameters
    ----------
    sample : 2-d sequence of float
        Tested sample.
    level : positive float, optional
        Threshold p-value of the test (= first kind risk), it must be
        :math:`< 1`, equal to 0.05 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.NormalityTest.AndersonDarlingNormal

    Notes
    -----
    The test is used to check whether the sample follows a normal distribution. The 
    test concerns the deviation squared and integrated over the entire variation
    domain, it often appears to be more robust than the Kolmogorov-Smirnov test.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> test_result = ot.NormalityTest.CramerVonMisesNormal(sample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=CramerVonMisesNormal binaryQualityMeasure=true p-value threshold=0.05 p-value=0.682524 statistic=0.0399704 description=[]

    """
    return _NormalityTest.CramerVonMisesNormal(sample, level)

