# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Special function."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _SpecFunc
else:
    import _SpecFunc

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo

def IsNormal(value):
    r"""
    Check for non-NaN and non-Inf values.

    Parameters
    ----------
    v : float

    Returns
    -------
    result : bool
    """
    return _SpecFunc.IsNormal(value)

def BesselI0(x):
    r"""
    Modified first kind Bessel function of order 0.

    .. math::

        \forall x \in \Rset, \quad
        \mathrm{I}_0(x) = \sum_{m=0}^\infty\frac{1}{m!^2}\left(\frac{x}{2}\right)^{2m}

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.BesselI0(x)

def LogBesselI0(x):
    r"""
    Logarithm of the modified first kind Bessel function of order 0.

    .. math::

        \forall x \in \Rset, \quad
        LogBesselI0(x) = \log (\mathrm{I}_0(x))

    See also
    --------
    openturns.SpecFunc.BesselI0

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.LogBesselI0(x)

def BesselI1(x):
    r"""
    Modified first kind Bessel function of order 1.

    .. math::

        \forall x \in \Rset, \quad
        \mathrm{I}_1(x) = \sum_{m=0}^\infty\frac{1}{m!(m+1)!}\left(\frac{x}{2}\right)^{2m+1}

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.BesselI1(x)

def LogBesselI1(x):
    r"""
    Logarithm of the modified first kind Bessel function of order 1.

    .. math::

        \forall x \in \Rset, \quad
        LogBesselI1(x) = \log (\mathrm{I}_1(x))

    See also
    --------
    openturns.SpecFunc.BesselI1

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.LogBesselI1(x)

def DeltaLogBesselI10(x):
    r"""
    Difference between the logarithms of Bessel I1 and I0.

    .. math::

        \forall x \in \Rset, \quad
        \mathrm{DeltaLogBesselI10}(x) = \log(\mathrm{I}_1(x)) - \log(\mathrm{I}_0(x))

    See also
    --------
    openturns.SpecFunc.BesselI0
    openturns.SpecFunc.BesselI1

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.DeltaLogBesselI10(x)

def LogBesselK(nu, x):
    r"""
    Logarithm of the modified second kind Bessel function of order :math:`\nu`.

    .. math::

        \forall x \in \Rset, \quad
        LogBesselK(\nu, x) = \log(\mathrm{K}_{\nu}(x))

    See also
    --------
    openturns.SpecFunc.BesselK

    Parameters
    ----------
    nu : float
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.LogBesselK(nu, x)

def BesselK(nu, x):
    r"""
    Modified second kind Bessel function of order :math:`\nu`.

    .. math::

        \forall x \in \Rset, \quad
        \mathrm{K}_{\nu}(x) = \frac{\pi}{2}\frac{\mathrm{I}_{-\nu}(x)-\mathrm{I}_{\nu}(x)}{\sin{\nu\pi}}

    Parameters
    ----------
    nu : float
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.BesselK(nu, x)

def BesselKDerivative(nu, x):
    r"""
    Derivative of the modified second kind Bessel function of order :math:`\nu`.

    .. math::

        \forall x \in \Rset, \quad
        \mathrm{K'}_{\nu}(x) = \frac{\mathrm{K}_{\nu-1}(x) + \mathrm{K}_{\nu+1}(x)}{-2}

    Parameters
    ----------
    nu : float
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.BesselKDerivative(nu, x)

def Beta(a, b):
    r"""
    Beta function :math:`\mathrm{B}`.

    .. math::

        \forall (a, b) > 0, \quad
        \mathrm{B}(a, b) = \int_0^1 t^{a-1}(1-t)^{b-1}\di{t}

    Parameters
    ----------
    a, b : float :math:`\in \Rset^*_+`

    Returns
    -------
    result : float
    """
    return _SpecFunc.Beta(a, b)

def IncompleteBeta(a, b, x, tail=False):
    r"""
    Incomplete Beta function.

    .. math::

        \forall (a, b) > 0, t \in [0, 1], \quad
        \mathrm{B}(x; a, b) = \int_0^x t^{a-1}(1-t)^{b-1}\di{t}

    Parameters
    ----------
    a, b : float :math:`\in \Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \mathrm{B}(x; a, b)`.
        - If *tail* is *True*: :math:`result = \mathrm{B}(a, b) - \mathrm{B}(x; a, b)`.
    """
    return _SpecFunc.IncompleteBeta(a, b, x, tail)

def IncompleteBetaInverse(a, b, x, tail=False):
    r"""
    Inverse of the incomplete Beta function.

    .. math::

        \forall (a, b) > 0 \quad
        IncompleteBetaInverse(x; a, b) = \mathrm{B}^{-1}(x/\mathrm{B}(a, b); a, b)

    See also
    --------
    openturns.SpecFunc.IncompleteBeta
    openturns.SpecFunc.RegularizedIncompleteBetaInverse

    Parameters
    ----------
    a, b : float :math:`\in \Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \mathrm{B}^{-1}(x/\mathrm{B}(a, b); a, b)`.
        - If *tail* is *True*: :math:`result = 1 - \mathrm{B}^{-1}(x/\mathrm{B}(a, b); b, a)`.
    """
    return _SpecFunc.IncompleteBetaInverse(a, b, x, tail)

def RegularizedIncompleteBeta(a, b, x, tail=False):
    r"""
    Regularized incomplete Beta function.

    .. math::

        \forall (a, b) > 0 \quad
        \mathrm{I}(x; a, b) = \frac{\mathrm{B}(x; a, b)}{\mathrm{B}(a, b)}
                            = \frac{1}{\mathrm{B}(a, b)} \int_0^x t^{a-1}(1-t)^{b-1}\di{t}

    with :math:`B(a, b)` the Beta function and :math:`B(x; a, b)` the incomplete
    Beta function.

    See also
    --------
    openturns.SpecFunc.IncompleteBeta
    openturns.SpecFunc.Beta

    Parameters
    ----------
    a, b : float :math:`\in \Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \mathrm{I}(x; a, b)`.
        - If *tail* is *True*: :math:`result = 1 - \mathrm{I}(x; a, b)`.
    """
    return _SpecFunc.RegularizedIncompleteBeta(a, b, x, tail)

def RegularizedIncompleteBetaInverse(a, b, x, tail=False):
    r"""
    Inverse of the regularized incomplete Beta function.

    .. math::

        \forall (a, b) > 0, \quad
        RegularizedIncompleteBetaInverse(x; a, b) = \mathrm{I}^{-1}(x; a, b)

    See also
    --------
    openturns.SpecFunc.RegularizedIncompleteBeta

    Parameters
    ----------
    a, b : float :math:`\in \Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \mathrm{I}^{-1}(x; a, b)`.
        - If *tail* is *True*: :math:`result = 1 - \mathrm{I}^{-1}(x; b, a)`.
    """
    return _SpecFunc.RegularizedIncompleteBetaInverse(a, b, x, tail)

def LogBeta(a, b):
    r"""
    Logarithm of the Beta function.

    .. math::

        \forall (a, b) > 0, \quad
        LogBeta(a, b) = \log (\mathrm{B}(a, b))

    See also
    --------
    openturns.SpecFunc.Beta

    Parameters
    ----------
    a, b : float :math:`\in \Rset^*_+`

    Returns
    -------
    result : float
    """
    return _SpecFunc.LogBeta(a, b)

def Dawson(*args):
    r"""
    Dawson function.

    .. math::

        \forall x \in \Cset, \quad
        \mathrm{D}_+(x) = \exp(-x^2)\int_0^x \exp(t^2)\di{t}

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _SpecFunc.Dawson(*args)

def Debye(x, n):
    r"""
    Debye function of order :math:`n`.

    .. math::

        \forall x \in \Rset, \forall n \in \Nset^* \text{and} \, n \leq 20, \quad
        \mathrm{D}_n(x) = \frac{n}{x^n} \int_0^x \frac{t^n}{\exp(t)-1}\di{t}

    Parameters
    ----------
    x : float
    n : int :math:`\in \{1, \cdots, 20\}`

    Returns
    -------
    result : float
    """
    return _SpecFunc.Debye(x, n)

def DiLog(x):
    r"""
    Dilogarithm function.

    .. math::

        \forall x \in ]-\infty, 1[, \quad
        Li_2(x) = -\int_0^x \frac{\log (1-t)}{t}\di{t}

    Parameters
    ----------
    x : float :math:`\in ]-\infty, 1[`

    Returns
    -------
    result : float
    """
    return _SpecFunc.DiLog(x)

def Ei(*args):
    r"""
    Exponential integral function.

    .. math::

        \forall z \in \Cset, \quad
        \mathrm{Ei}(z) = -\int_{-z}^{\infty} \frac{\exp(-t)}{t}\di{t}

    Parameters
    ----------
    z : float or complex

    Returns
    -------
    result : float or complex (same as z)
    """
    return _SpecFunc.Ei(*args)

def Faddeeva(z):
    r"""
    Complex Faddeeva function.

    .. math::

        \forall x \in \Cset, \quad
        \mathrm{W}(x) = \exp(-x^2)\mathrm{erfc}(-ix)

    with :math:`ErfC` the complementary error function.

    See also
    --------
    openturns.SpecFunc.ErfC

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : complex
    """
    return _SpecFunc.Faddeeva(z)

def FaddeevaIm(x):
    r"""
    Imaginary part of the Faddeeva function.

    .. math::

        \forall x \in \Rset, \quad
        FaddeevaIm(x) = \Im (\mathrm{W}(x))

    See also
    --------
    openturns.SpecFunc.Faddeeva

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.FaddeevaIm(x)

def Factorial(n):
    r"""
    Factorial function.

    .. math::

        \forall n \in \Nset, \quad
        \mathrm{Factorial}(n) = n!

    See also
    --------
    openturns.SpecFunc.LogFactorial

    Parameters
    ----------
    n : int

    Returns
    -------
    result : float
    """
    return _SpecFunc.Factorial(n)

def LogFactorial(n):
    r"""
    Logarithm of the factorial function.

    .. math::

        \forall n \in \Nset, \quad
        LogFactorial(n) = \log(n!)

    See also
    --------
    openturns.SpecFunc.Stirlerr

    Parameters
    ----------
    n : int

    Returns
    -------
    result : float
    """
    return _SpecFunc.LogFactorial(n)

def IGamma1pm1(a):
    r"""
    IGamma1pm1 function.

    .. math::

        \forall x \in \Rset, \quad
        IGamma1pm1(a, x) = \int_0^x t^{a-1}\exp(-t)\di{t}

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.IGamma1pm1(a)

def GammaCorrection(a):
    r"""
    GammaCorrection function.

    .. math::

        \forall x \in \Rset^*_+, \quad
        GammaCorrection(a) = \log (\Gamma(a)) - \log (\sqrt{2\Pi}) + a - (a - 0.5) \log(a)

    with :math:`\Gamma` the Gamma function.

    See also
    --------
    openturns.SpecFunc.Gamma

    Parameters
    ----------
    a : float :math:`\in \Rset^*_+`

    Returns
    -------
    result : float
    """
    return _SpecFunc.GammaCorrection(a)

def Gamma(*args):
    r"""
    Gamma function :math:`\Gamma`.

    .. math::

        \forall a \in \Cset, \quad
        \Gamma(a) = \int_0^{\infty} t^{a-1}\exp(-t)\di{t}

    Parameters
    ----------
    a : float or complex

    Returns
    -------
    result : float or complex
    """
    return _SpecFunc.Gamma(*args)

def LogGamma1p(a):
    r"""
    LogGamma1p function.

    .. math::

        \forall a \in \Rset, \quad
        LogGamma1p(a) = \log (\Gamma(1+a))

    with :math:`\Gamma` the Gamma function.

    See also
    --------
    openturns.SpecFunc.Gamma

    Parameters
    ----------
    a : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.LogGamma1p(a)

def LogGamma(*args):
    r"""
    Logarithm of the Gamma function.

    .. math::

        \forall a \in \Cset, \quad
        LogGamma(a) = \log (\Gamma(a))

    See also
    --------
    openturns.SpecFunc.Gamma

    Parameters
    ----------
    a : float or complex

    Returns
    -------
    result : float or complex
    """
    return _SpecFunc.LogGamma(*args)

def IncompleteGamma(a, x, tail=False):
    r"""
    Incomplete Gamma function.

    .. math::

        \forall x \in \Rset, \quad
        \gamma(a, x) = \int_0^x t^{a-1}\exp(-t)\di{t}

    Parameters
    ----------
    a : float :math:`\in \Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \gamma(a, x)`.
        - If *tail* is *True*: :math:`result = \Gamma(a) - \gamma(a, x)`.
    """
    return _SpecFunc.IncompleteGamma(a, x, tail)

def IncompleteGammaInverse(a, x, tail=False):
    r"""
    Inverse of the incomplete Gamma function with respect to :math:`x`.

    .. math::

        IncompleteGammaInverse(a, x) = \gamma^{-1}(a, x)

    See also
    --------
    openturns.SpecFunc.IncompleteGamma

    Parameters
    ----------
    a : float :math:`\in \Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \mathrm{P}^{-1}(a, x/\Gamma(a))`.
        - If *tail* is *True*: :math:`result = \mathrm{P}^{-1}(a, (1-x)/\Gamma(a))`.
    """
    return _SpecFunc.IncompleteGammaInverse(a, x, tail)

def RegularizedIncompleteGamma(a, x, tail=False):
    r"""
    Regularized incomplete Gamma function.

    .. math::

        \forall x \in \Rset, \quad
        \mathrm{P}(a, x) = \frac{\gamma(a, x)}{\Gamma(a)}
                         = \frac{1}{\Gamma(a)}\int_0^x t^{a-1}\exp(-t)\di{t}

    See also
    --------
    openturns.SpecFunc.Gamma
    openturns.SpecFunc.IncompleteGamma

    Parameters
    ----------
    a : float :math:`\in \Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \mathrm{P}(a, x)`.
        - If *tail* is *True*: :math:`result = \Gamma(a) - \mathrm{P}(a, x)`.
    """
    return _SpecFunc.RegularizedIncompleteGamma(a, x, tail)

def RegularizedIncompleteGammaInverse(a, x, tail=False):
    r"""
    Inverse of the regularized incomplete Gamma function.

    .. math::

        \forall x \in \Rset, \quad
        RegularizedIncompleteGammaInverse(a, x) = \mathrm{P}^{-1}(a, x)

    See also
    --------
    openturns.SpecFunc.Gamma
    openturns.SpecFunc.RegularizedIncompleteGamma

    Parameters
    ----------
    a : float :math:`\in \Rset^*_+`
    x : float :math:`\in [0, 1]`
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \mathrm{P}^{-1}(a, x)`.
        - If *tail* is *True*: :math:`result = \mathrm{P}^{-1}(a, 1-x)`.
    """
    return _SpecFunc.RegularizedIncompleteGammaInverse(a, x, tail)

def DiGamma(*args):
    r"""
    Digamma function.

    .. math::

        \Psi(x) = \frac{1}{\Gamma(x)}\frac{\mathrm{d} \Gamma(x)}{\mathrm{d}x}

    with :math:`\Gamma` the Gamma function.

    See also
    --------
    openturns.SpecFunc.Gamma

    Parameters
    ----------
    x : float :math:`\in \Rset^*_+` or complex :math:`\in \Cset \setminus \Rset_-`

    Returns
    -------
    result : float or complex
    """
    return _SpecFunc.DiGamma(*args)

def Psi(*args):
    r"""
    Psi function, alias for digamma function.

    .. math::

        \Psi(x) = \frac{1}{\Gamma(x)}\frac{\mathrm{d} \Gamma(x)}{\mathrm{d}x}

    with :math:`\Gamma` the Gamma function.

    See also
    --------
    openturns.SpecFunc.Gamma
    openturns.SpecFunc.DiGamma

    Parameters
    ----------
    x : float :math:`\in \Rset^*_+` or complex :math:`\in \Cset \setminus \Rset_-`

    Returns
    -------
    result : float or complex
    """
    return _SpecFunc.Psi(*args)

def DiGammaInv(a):
    r"""
    Inverse of the DiGamma function.

    .. math::

        DiGammaInv(x) = \Psi^{-1} (x)

    See also
    --------
    openturns.SpecFunc.DiGamma

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.DiGammaInv(a)

def TriGamma(x):
    r"""
    TriGamma function.

    .. math::

        \Psi_1(x) = \frac{1}{\Gamma(x)}\frac{\mathrm{d}^2 \Gamma(x)}{\mathrm{d}x^2}

    with :math:`\Gamma` the Gamma function.

    See also
    --------
    openturns.SpecFunc.Gamma

    Parameters
    ----------
    x : float :math:`\in \Rset^*_+`

    Returns
    -------
    result : float
    """
    return _SpecFunc.TriGamma(x)

def Stirlerr(n):
    r"""
    Error of the Stirling approximation of the factorial logarithm.

    .. math::

        \forall n \in \Nset, \quad
        Stirlerr(n) = \log(n!) - \log\left(sqrt{2\pi n}\left(\dfrac{n}{e}\right)^n\right)

    See also
    --------
    openturns.SpecFunc.LogFactorial

    Parameters
    ----------
    n : int

    Returns
    -------
    result : float
    """
    return _SpecFunc.Stirlerr(n)

def HyperGeom_1_1(*args):
    r"""
    Hypergeometric function of type (1,1).

    .. math::

        {}_1F_1(p_1, q_1, x) = \sum_{n=0}^{\infty}
                               \left[
                               \prod_{k=0}^{n-1} \frac{(p_1 + k)}{(q_1 + k)}
                               \right]  \frac{x^n}{n!}

    Parameters
    ----------
    p1, q1 : float
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _SpecFunc.HyperGeom_1_1(*args)

def HyperGeom_2_1(p1, p2, q1, x):
    r"""
    Hypergeometric function of type (2,1).

    .. math::

        {}_2F_1(p_1, p_2, q_1, x) = \sum_{n=0}^{\infty}
                                    \left[
                                    \prod_{k=0}^{n-1} \frac{(p_1 + k)(p_2 + k)}{(q_1 + k)}
                                    \right] \frac{x^n}{n!}

    Parameters
    ----------
    p1, p2, q1, x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.HyperGeom_2_1(p1, p2, q1, x)

def HyperGeom_2_2(p1, p2, q1, q2, x):
    r"""
    Hypergeometric function of type (2,2).

    .. math::

        {}_2F_2(p_1, p_2, q_1, q_2, x) = \sum_{n=0}^{\infty}
                             \left[
                             \prod_{k=0}^{n-1} \frac{(p_1 + k)(p_2 + k)}{(q_1 + k) (q_2 + k)}
                             \right] \frac{x^n}{n!}

    Parameters
    ----------
    p1, p2, q1, q2, x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.HyperGeom_2_2(p1, p2, q1, q2, x)

def Erf(*args):
    r"""
    Error function Erf.

    .. math::

        \forall x \in \Cset, \quad
        Erf(x) = \frac{2}{\sqrt{\pi}} \int_0^x \exp(-t^2)\di{t}

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _SpecFunc.Erf(*args)

def ErfI(*args):
    r"""
    Imaginary error function ErfI.

    .. math::

        \forall x \in \Cset, \quad
        ErfI(x) = -i Erf(ix)

    with :math:`Erf` the error function.

    See also
    --------
    openturns.SpecFunc.Erf

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _SpecFunc.ErfI(*args)

def ErfC(*args):
    r"""
    Complementary error function ErfC.

    .. math::

        \forall x \in \Cset, \quad
        ErfC(x) = 1 - Erf(x)

    with :math:`Erf` the error function.

    See also
    --------
    openturns.SpecFunc.Erf

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _SpecFunc.ErfC(*args)

def ErfCX(*args):
    r"""
    ErfCX function.

    .. math::

        \forall x \in \Cset, \quad
        ErfCX(x) = \exp(x^2).ErfC(x)

    with :math:`ErfC` the complementary error function.

    See also
    --------
    openturns.SpecFunc.ErfC

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _SpecFunc.ErfCX(*args)

def ErfInverse(x):
    r"""
    Inverse of the error function Erf.

    .. math::

        \forall x \in \Cset, \quad
        ErfInverse(x) = Erf^{-1} (x)

    See also
    --------
    openturns.SpecFunc.Erf

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _SpecFunc.ErfInverse(x)

def LambertW(x, principal=True):
    r"""
    Lambert W function.

    The Lambert W function :math:`\mathrm{W}(x)` is defined by the relation:

    .. math::

        x = \mathrm{W}(x) \exp(\mathrm{W}(x))

    Parameters
    ----------
    x : float
    principal : bool, optional
        By default, *principal* is *True*.

    Returns
    -------
    result : float
        - If *principal* is *True* : :math:`result = \mathrm{W}_0(x)`.
          :math:`\mathrm{W}_0(x)` is referred to as the principal branch of the Lambert W
          function. It denotes the upper part of the function whose domain is
          :math:`[-1/e, +\infty[` and range :math:`[-1, +\infty[`.
        - If *principal* is *False* : :math:`result = \mathrm{W}_{-1}(x)`.
          :math:`\mathrm{W}_{-1}(x)` is the second real branch of the Lambert W function.
          It denotes the lower part of the function whose domain is
          :math:`[-1/e, 0[` and range :math:`]-\infty, -1]`.
    """
    return _SpecFunc.LambertW(x, principal)

def Log1p(z):
    r"""
    Log1p function.

    .. math::

        \forall x \in \Cset, \quad
        Log1p(x) = \log (1+x)

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : complex
    """
    return _SpecFunc.Log1p(z)

def Expm1(z):
    r"""
    Expm1 function.

    .. math::

        \forall x \in \Cset, \quad
        Expm1(x) = \exp(x)-1

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : complex
    """
    return _SpecFunc.Expm1(z)

def Log1MExp(x):
    r"""
    Log1MExp function.

    .. math::

        \forall x \in \Rset^+, \quad
        Log1MExp(x) = \log (1-\exp(-x))

    Parameters
    ----------
    x : float :math:`\in \Rset^*_+`

    Returns
    -------
    result : complex
    """
    return _SpecFunc.Log1MExp(x)

def NextPowerOfTwo(n):
    r"""
    Smallest power of two greater or equal to the given :math:`n`.

    .. math::

        NextPowerOfTwo(n) = 2^{\lceil \log_2(n)\rceil}

    Parameters
    ----------
    n : positive int

    Returns
    -------
    result : positive int

    Examples
    --------
    >>> import openturns as ot
    >>> int(ot.SpecFunc.NextPowerOfTwo(42))
    64
    """
    return _SpecFunc.NextPowerOfTwo(n)

def IPow(*args):
    r"""
    Raise the given :math:`x` to the integral power :math:`n`.

    .. math::

        IPow(m, n) = m^n
        IPow(x, n) = x^n

    Parameters
    ----------
    m : int
    n : int
    x : float

    Returns
    -------
    result : int or float
        The result has the same type as the first argument.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.SpecFunc.IPow(-2.5, 3)
    -15.625
    >>> ot.SpecFunc.IPow(5, 3)
    125
    """
    return _SpecFunc.IPow(*args)

def IRoot(x, n):
    r"""
    Extract the :math:`n` integral root of the given :math:`x`.

    .. math::

        IRoot(x, n) = \sqrt[n]{x}

    Parameters
    ----------
    n : int
    x : float

    Returns
    -------
    result : float

    Examples
    --------
    >>> import openturns as ot
    >>> ot.SpecFunc.IRoot(-15.625, 3)
    -2.5
    """
    return _SpecFunc.IRoot(x, n)

def Log2(n):
    r"""
    Integer base 2 logarithm of :math:`n`.

    .. math::

        Log2(n) = \log_2(n)

    Parameters
    ----------
    n : positive int

    Returns
    -------
    result : positive int

    Examples
    --------
    >>> import openturns as ot
    >>> int(ot.SpecFunc.Log2(42))
    5
    """
    return _SpecFunc.Log2(n)

def BitCount(n):
    r"""
    Compute the number of bits set to 1 in an integer.

    Parameters
    ----------
    n : positive int

    Returns
    -------
    result : positive int

    Examples
    --------
    >>> import openturns as ot
    >>> int(ot.SpecFunc.BitCount(42))
    3
    """
    return _SpecFunc.BitCount(n)

def LogBinomialCoefficient(n, k):
    r"""
    Compute the natural logarithm of the binomial coefficient.

    .. math::

        LogBinomialCoefficient(n, k) = \log\left( \frac{n!}{k! (n-k)!} \right)

    Parameters
    ----------
    n : nonegative int
    k : nonegative int

    Returns
    -------
    result : float

    Examples
    --------
    >>> import openturns as ot
    >>> ot.SpecFunc.LogBinomialCoefficient(10, 5)
    5.5294...
    """
    return _SpecFunc.LogBinomialCoefficient(n, k)

def AccurateSum(v):
    r"""
    Accurate summation.

    Returns the value :math:`\sum_{i=0}^{n-1}x_i` using extended precision (if
    available) or Kahan's method

    Parameters
    ----------
    x : sequence of float

    Returns
    -------
    result : float
    """
    return _SpecFunc.AccurateSum(v)

def Clip01(prob, tail=False):
    r"""
    Clip a value on [0, 1].

    This function can be useful when we want to ensure that a
    given number can be considered as a probability, even if
    there are e.g. rounding errors.

    Parameters
    ----------
    p : float
        Value to clip
    tail : bool, default=False
        If False, then return min(1, max(0,p)). Otherwise return 1 - min(1, max(0,p)). 

    Returns
    -------
    clip : float
        Clipped value.

    Examples
    --------
    >>> import openturns as ot
    >>> p = ot.SpecFunc.Clip01(1.01)
    """
    return _SpecFunc.Clip01(prob, tail)

cvar = _SpecFunc.cvar
ISQRT2PI = cvar.ISQRT2PI
SQRT2PI = cvar.SQRT2PI
LOGSQRT2PI = cvar.LOGSQRT2PI
EulerConstant = cvar.EulerConstant
PI2_6 = cvar.PI2_6
PI_SQRT6 = cvar.PI_SQRT6
EULERSQRT6_PI = cvar.EULERSQRT6_PI
PI2_3 = cvar.PI2_3
SQRT3_PI = cvar.SQRT3_PI
PI_SQRT3 = cvar.PI_SQRT3
TWOPI = cvar.TWOPI
ZETA3 = cvar.ZETA3
MinScalar = cvar.MinScalar
LogMinScalar = cvar.LogMinScalar
Infinity = cvar.Infinity
MaxScalar = cvar.MaxScalar
LogMaxScalar = cvar.LogMaxScalar
LowestScalar = cvar.LowestScalar
ScalarEpsilon = cvar.ScalarEpsilon
MaximumIteration = cvar.MaximumIteration
Precision = cvar.Precision

