# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Experimental features."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _experimental
else:
    import _experimental

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.typ
import openturns.common
import openturns.base
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
class LatentVariableModel(openturns.statistics.CovarianceModelImplementation):
    r"""
    Latent variable covariance function.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    nLevels : int
        Number of levels :math:`\ell` characterizing the categorical variable.
    latentDim : int
        The dimension :math:`d_\ell` of the latent space onto which the categorical variable levels are projected.

    Notes
    -----
    The *Latent variable covariance function* is a covariance model allowing to compute the covariance between 
    different unordered values (or levels) of a categorical variable :math:`z`.

    The underlying idea is that each categorical level is mapped onto a distinct point in a :math:`d_l`-dimensional latent space. 
    The covariance between the various levels is then computed as the :class:`~openturns.SquaredExponential` covariance between 
    the mappings in the latent space.
    Let :math:`\phi(\cdot):\mathcal{Z}\rightarrow\mathbb{R}^{d_l}` be the mapping function, the covariance function between
    two discrete values :math:`z_i` and :math:`z_j` is computed as:

    .. math::
        C(z_i, z_j) = e^{-\frac{1}{2}  \left\| \vect{s}- \vect{t} \right\|_{2}^{2}}, \quad \forall (\phi(z_i), \phi(z_j)) \in \cD

    The coordinates of the mapping points are part of the covariance model parameters, together with the latent squared 
    exponential model scale and amplitude. It is important to note that in order to compensate for possible rotations 
    and translations of the mapping points, the coordinates of the first level mapping are fixed to the latent space 
    origin, whereas all of the coordinates of the second level mapping are fixed to :math:`0`, except for the first one. 
    As a result, the number of active latent variable coordinates is equal to:

    .. math::
        d_\ell (\ell - 2) + 1.

    In practice, the class distinguishes between the `fullLatentVariables` attribute, which contains the actual latent variables
    coordinates, and the `activeLatentVariables` attribute, which contains only the coordinates that can be modified.
    Additional information can be found in [zhang2020]_.

    Is is important to note that for the sake of simplicity, the categorical variable levels **must be** represented as integers, 
    ranging from :math:`0` to :math:`l-1`. However, this representation is purely practical, and the actual values
    assigned to each level have no practical meaning or effect: only the latent variables coordinates have an effect on the
    covariance value. Moreover, these categorical variables, which are encoded using numerical values, can be of a non-numerical
    nature (e.g., types of material, architectural choices, colors, etc.).

    Finally, for a similar reason, when using this type of kernel when defining a Gaussian process, it is suggested to 
    rely on a constant functional basis: please use the :class:`~openturns.ConstantBasisFactory` class.


    See Also
    --------
    openturns.CovarianceModel

    Examples
    --------
    Create a latent model covariance function with a latent space of dimension 2, for a categorical variable 
    characterized by 3 levels:

    >>> import openturns.experimental as otexp
    >>> covModel = otexp.LatentVariableModel(3, 2)
    >>> activeCoordinates = [0.1, 0.3, -0.4]
    >>> covModel.setLatentVariables(activeCoordinates)
    >>> print(covModel(1, 2))
    [[ 0.904837 ]]
    >>> print(covModel(0, 2))
    [[ 0.882497 ]]
    >>> print(covModel(1, 1))
    [[ 1 ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.LatentVariableModel_getClassName(self)

    def computeAsScalar(self, *args):
        r"""
        Compute the covariance function for scalar model.

        Parameters
        ----------
        s, t : floats
        	Must have integer values between :math:`0` and :math:`l-1`

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the dimension of the process is :math:`d=1`.
        It evaluates :math:`C(s, t)`.
        """
        return _experimental.LatentVariableModel_computeAsScalar(self, *args)

    def __repr__(self):
        return _experimental.LatentVariableModel___repr__(self)

    def __str__(self, *args):
        return _experimental.LatentVariableModel___str__(self, *args)

    def setFullParameter(self, parameter):
        r"""
        Set the full parameters of the covariance function.

        Parameters
        ----------
        parameter : :class:`~openturns.Point`
            List of the full parameter of the covariance function i.e.
            the scale parameter :math:`\vect{\theta} \in \Rset`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset`, and
            the latent variables coordinates,  :math:`\vect{x}_{lat} \in \Rset^{latentDim * nLevels - 2 * latentDim + 1}`
        """
        return _experimental.LatentVariableModel_setFullParameter(self, parameter)

    def getFullParameter(self):
        r"""
        Get the full parameters of the covariance function.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            List of the full parameter of the covariance function i.e.
            the scale parameter :math:`\vect{\theta} \in \Rset`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset`, and
            the latent variables coordinates,  :math:`\vect{x}_{lat} \in \Rset^{latentDim * nLevels - 2 * latentDim + 1}`
        """
        return _experimental.LatentVariableModel_getFullParameter(self)

    def setScale(self, scale):
        r"""
        Set the scale parameter :math:`\vect{\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` to be used in the
            covariance function.
            Its size must be equal to the input dimension of the covariance function.
        """
        return _experimental.LatentVariableModel_setScale(self, scale)

    def setAmplitude(self, amplitude):
        r"""
        Set the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` to be used in the
            covariance function.
            Its size must be equal to the dimension of the covariance function.
        """
        return _experimental.LatentVariableModel_setAmplitude(self, amplitude)

    def setNuggetFactor(self, nuggetFactor):
        r"""
        Set the nugget factor for the variance of the observation error.

        Acts on the discretized covariance matrix.

        Parameters
        ----------
        nuggetFactor : float
            nugget factor to be used to model the variance of the observation error.
        """
        return _experimental.LatentVariableModel_setNuggetFactor(self, nuggetFactor)

    def setLatentVariables(self, latentVariablesCoordinates):
        r"""
        Number of levels accessor.

        Parameters
        ----------
        LatentVariables : sequence of float 
            Active coordinates of the categorical levels in the latent space.
        """
        return _experimental.LatentVariableModel_setLatentVariables(self, latentVariablesCoordinates)

    def getFullLatentVariables(self):
        r"""
        Latent variables accessor.

        Returns
        -------
        activeLatentVariables : :class:`~openturns.Point`
            Coordinates of the categorical levels in the latent space.
        """
        return _experimental.LatentVariableModel_getFullLatentVariables(self)

    def getActiveLatentVariables(self):
        r"""
        Active latent variables accessor.

        Parameters
        ----------
        activeLatentVariables : :class:`~openturns.Point`
            Active coordinates of the categorical levels in the latent space. 
            The inactive coordinates are set to 0 (i.e., the first latent 
            variable is projected onto the Euclidean space origin, and the second
            latent variable can only be located along the first axis).
        """
        return _experimental.LatentVariableModel_getActiveLatentVariables(self)

    def getFullParameterDescription(self):
        r"""
        Get the description full parameters of the covariance function.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the full parameter of the covariance function.

        """
        return _experimental.LatentVariableModel_getFullParameterDescription(self)

    def getLatentDimension(self):
        r"""
        Latent dimension accessor.

        Returns
        -------
        latentDimension : int
            Dimension of the latent space.
        """
        return _experimental.LatentVariableModel_getLatentDimension(self)

    def getLevelNumber(self):
        r"""
        Level number accessor.

        Returns
        -------
        nLevels : int
            Number of levels :math:`\ell` characterizing the categorical variable.

        """
        return _experimental.LatentVariableModel_getLevelNumber(self)

    def draw(self, *args):
        r"""Not yet implemented"""
        return _experimental.LatentVariableModel_draw(self, *args)

    def __init__(self, *args):
        _experimental.LatentVariableModel_swiginit(self, _experimental.new_LatentVariableModel(*args))
    __swig_destroy__ = _experimental.delete_LatentVariableModel

# Register LatentVariableModel in _experimental:
_experimental.LatentVariableModel_swigregister(LatentVariableModel)
class SamplePartition(openturns.common.PersistentObject):
    r"""
    Select partition of samples.

    Class to define subset of points, and select new ones, see :meth:`getPeakOverThreshold`.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    sample : 2-d sequence of float
        A sample of dimension 1.
    indices : sequence of int 2-tuple or sequence of int, optional
        Flat indices of population in the partition or
        list of (start,end) ranges.
        If not provided the default is to consider one single group with all the sample values.

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> ref = ot.Uniform().getSample(10)
    >>> sp1 = otexp.SamplePartition(ref, [[0, 3], [5, 9]])
    >>> sp2 = otexp.SamplePartition(ref, [0, 1, 2, 3])

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SamplePartition_getClassName(self)

    def getPeakOverThreshold(self, threshold, r):
        r"""
        Compute extreme values using Peaks Over Threshold (POT) method.

        Parameters
        ----------
        sample : 2-d sequence of float
            A sample of dimension 1.
        threshold : float
            The threshold value
        r : int
            Minimum number of consecutive values below the threshold between clusters

        Returns
        -------
        peaks : :class:`~openturns.Sample`
            The peaks for each cluster
        clusters : :class:`openturns.experimental.SamplePartition`
            The clusters partition

        """
        return _experimental.SamplePartition_getPeakOverThreshold(self, threshold, r)

    def getSample(self):
        r"""
        Sample accessor.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The internal sample

        """
        return _experimental.SamplePartition_getSample(self)

    def getIndicesCollection(self):
        r"""
        Partition indices accessor.

        Returns
        -------
        indicesCollection : :class:`~openturns.IndicesCollection`
            List of partitions ranges as (start,end) indices.

        """
        return _experimental.SamplePartition_getIndicesCollection(self)

    def draw(self, threshold):
        r"""
        Draw clusters and peaks.

        Parameters
        ----------
        threshold : float
            The threshold value

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph of clusters, peaks.

        """
        return _experimental.SamplePartition_draw(self, threshold)

    def __repr__(self):
        return _experimental.SamplePartition___repr__(self)

    def __str__(self, *args):
        return _experimental.SamplePartition___str__(self, *args)

    def __init__(self, *args):
        _experimental.SamplePartition_swiginit(self, _experimental.new_SamplePartition(*args))
    __swig_destroy__ = _experimental.delete_SamplePartition

# Register SamplePartition in _experimental:
_experimental.SamplePartition_swigregister(SamplePartition)

def __SamplePartition_ExtractFromDataFrame(full, partial):
    """
    Extract a partition from a pandas dataframe as a SamplePartition.

    Parameters
    ----------
    full : pandas DataFrame
        Full data
    partial : pandas DataFrame
        Filtered data from the full Dataframe

    Returns
    -------
    partition : :class:`openturns.experimental.SamplePartition`
        The resulting partition
    """

# retrieve the partial indices wrt to the global indices in the full data
    partial_indices = [i for i, x in enumerate(full.index.isin(partial.index)) if x]

# convert the full dataframe to a Sample
    full_sample = openturns.typ.Sample.BuildFromDataFrame(full)

    return openturns.experimental.SamplePartition(full_sample, partial_indices)
SamplePartition.ExtractFromDataFrame = __SamplePartition_ExtractFromDataFrame

class LeastSquaresEquationsSolver(openturns.solver.SolverImplementation):
    r"""
    Solve systems of non-linear equations using a least squares method.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    absError : positive float
        Absolute error between two successive iterates at the end point.
        Default value is defined in the `ResourceMap` via the `Solver-DefaultAbsoluteError`
        key is set to :math:`10^{-5}`.
    relError : positive float
        Relative error between the two last successive iterates with
        regards to the last iterate.
        Default value is defined in the `ResourceMap` via the `Solver-DefaultRelativeError`
        key is set to :math:`10^{-5}`.
    resError : positive float
        Absolute threshold on `f(x)` for accepting a given solution. 
        It is also used as residual error for the least square optimizer.
        value.
        Default value is defined in the `ResourceMap` via the `Solver-DefaultResidualError`
        and is set to :math:`0`.
    maximumFunctionEvaluation : int
        The maximum number of evaluations of the function. 
        Default value is defined in the `ResourceMap` via the `Solver-DefaultMaximumFunctionEvaluation`
        and is set to :math:`100`.

    See also
    --------
    openturns.Solver, openturns.OptimizationAlgorithm

    Notes
    -----
    LeastSquaresEquationsSolver might fail and not obtain a result lower than the
    specified threshold, in this case an error is thrown.

    Examples
    --------

    >>> import openturns as ot
    >>> from openturns.experimental import LeastSquaresEquationsSolver
    >>> inputs = ['x', 'y']
    >>> formulas = ['y*x-sin(2*x)', '1 + cos(y) + x']
    >>> analytical = ot.SymbolicFunction(inputs, formulas)
    >>> algo = LeastSquaresEquationsSolver()
    >>> algo.setResidualError(1e-8)
    >>> starting_point = [2.0, 1.0]
    >>> solution = algo.solve(analytical, starting_point)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.LeastSquaresEquationsSolver_getClassName(self)

    def __repr__(self):
        return _experimental.LeastSquaresEquationsSolver___repr__(self)

    def solve(self, *args):
        r"""
        Solve a system of non-linear equations.


        Parameters
        ----------
        function : :class:`~openturns.Function`
            The vectorial function of the system of equations :math:`function_i(x) = 0 \forall i \in {1,...,n}` to be solved. Remark that it is an unbounded resolution.
        startingPoint : sequence of floats
            The starting point of the optimization algorithm.
        bounds : :class:`~openturns.Interval`
            Bounds for searching the solution of the system of equations.

        Returns
        -------
        result : :class:`~openturns.Point`
            The result of the root research.

        Notes
        -----
        LeastSquaresEquationsSolver might fail and not obtain a result lower than the
        specified threshold, in this case an error is thrown.
        """
        return _experimental.LeastSquaresEquationsSolver_solve(self, *args)

    def getOptimizationAlgorithm(self):
        r"""
        Get the used algorithm for the optimization.

        Returns
        -------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
            The used optimization algorithm.

        """
        return _experimental.LeastSquaresEquationsSolver_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, algorithm):
        r"""
        Set the used algorithm for the optimization.

        Parameters
        ----------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
            The optimization algorithm to be used.

        """
        return _experimental.LeastSquaresEquationsSolver_setOptimizationAlgorithm(self, algorithm)

    def __init__(self, *args):
        _experimental.LeastSquaresEquationsSolver_swiginit(self, _experimental.new_LeastSquaresEquationsSolver(*args))
    __swig_destroy__ = _experimental.delete_LeastSquaresEquationsSolver

# Register LeastSquaresEquationsSolver in _experimental:
_experimental.LeastSquaresEquationsSolver_swigregister(LeastSquaresEquationsSolver)
class ConstantEvaluation(openturns.func.EvaluationImplementation):
    r"""
    Constant evaluation.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    inputDimension : int, optional
        Input dimension, default is 1
    constant : sequence of float, optional
        Constant value, default is [0]

    Examples
    --------
    >>> import openturns.experimental as otexp
    >>> f = otexp.ConstantEvaluation(2, [1.0, 2.0, 3.0])
    >>> print(f([5.0, 6.0]))
    [1,2,3]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ConstantEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _experimental.ConstantEvaluation___eq__(self, *args)

    def __repr__(self):
        return _experimental.ConstantEvaluation___repr__(self)

    def __str__(self, *args):
        return _experimental.ConstantEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _experimental.ConstantEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _experimental.ConstantEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _experimental.ConstantEvaluation_getOutputDimension(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or sequence of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _experimental.ConstantEvaluation_getMarginal(self, *args)

    def getConstant(self):
        r"""
        Constant accessor.

        Returns
        -------
        constant : :class:`~openturns.Point`
            Constant value

        """
        return _experimental.ConstantEvaluation_getConstant(self)

    def __init__(self, *args):
        _experimental.ConstantEvaluation_swiginit(self, _experimental.new_ConstantEvaluation(*args))
    __swig_destroy__ = _experimental.delete_ConstantEvaluation

# Register ConstantEvaluation in _experimental:
_experimental.ConstantEvaluation_swigregister(ConstantEvaluation)
class ConstantFunction(openturns.func.Function):
    r"""
    Constant function.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    inputDimension : int, optional
        Input dimension, default is 1
    constant : sequence of float, optional
        Constant value, default is [0]

    Examples
    --------
    >>> import openturns.experimental as otexp
    >>> f = otexp.ConstantFunction(2, [1.0, 2.0, 3.0])
    >>> print(f([5.0, 6.0]))
    [1,2,3]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ConstantFunction_getClassName(self)

    def __eq__(self, *args):
        return _experimental.ConstantFunction___eq__(self, *args)

    def __repr__(self):
        return _experimental.ConstantFunction___repr__(self)

    def __str__(self, *args):
        return _experimental.ConstantFunction___str__(self, *args)

    def __init__(self, *args):
        _experimental.ConstantFunction_swiginit(self, _experimental.new_ConstantFunction(*args))
    __swig_destroy__ = _experimental.delete_ConstantFunction

# Register ConstantFunction in _experimental:
_experimental.ConstantFunction_swigregister(ConstantFunction)
class VertexFieldToPointFunction(openturns.func.FieldToPointFunctionImplementation):
    r"""
    Restriction of a field function at a specific node.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Assuming :math:`f` is a function :math:`f : \Rset^{d} \rightarrow \cM_{N'} \times (\Rset^{d'})^{N'}`
    with :math:`\cM_{N'}` a mesh of :math:`\cD' \subset \Rset^{n'}`.,
    the vertex function extract the values matching the mesh index :math:`i \in [1, N']`

    .. math::

        f: \left| \begin{array}{rcl}
                   \cM_N \times (\Rset^d)^N & \rightarrow & \cM_N \times (\Rset^{d'})^{N} \\
                    F & \mapsto & F'
                  \end{array} \right.

    Parameters
    ----------
    inputMesh : :class:`~openturns.Mesh`
        Mesh
    dimension : int
        Input, output dimension
    indices : sequence of int
        Mesh indices

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> N = 10
    >>> mesh = ot.RegularGrid(0, 1, N)
    >>> f = otexp.VertexFieldToPointFunction(mesh, 1, [-1 % N])

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.VertexFieldToPointFunction_getClassName(self)

    def __eq__(self, *args):
        return _experimental.VertexFieldToPointFunction___eq__(self, *args)

    def __call__(self, *args):
        return _experimental.VertexFieldToPointFunction___call__(self, *args)

    def __repr__(self):
        return _experimental.VertexFieldToPointFunction___repr__(self)

    def __str__(self, *args):
        return _experimental.VertexFieldToPointFunction___str__(self, *args)

    def __init__(self, *args):
        _experimental.VertexFieldToPointFunction_swiginit(self, _experimental.new_VertexFieldToPointFunction(*args))
    __swig_destroy__ = _experimental.delete_VertexFieldToPointFunction

# Register VertexFieldToPointFunction in _experimental:
_experimental.VertexFieldToPointFunction_swigregister(VertexFieldToPointFunction)
import openturns.model_copula
import openturns.dist_bundle2
import openturns.dist_bundle3
import openturns.orthogonalbasis
import openturns.weightedexperiment
class ExperimentIntegration(openturns.common.PersistentObject):
    r"""
    Create a quadrature rule for numerical integration based on a weighted experiment.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    weightedExperiment : :class:`~openturns.WeightedExperiment`
        The weighted experimental design.

    See also
    --------
    openturns.WeightedExperiment

    Notes
    -----
    This class creates an integration method using a weighted experimental
    design.
    It can be used on a function with arbitrary input and
    output.


    Examples
    --------
    Integrate the Ishigami physical model.

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> from openturns.usecases import ishigami_function
    >>> im = ishigami_function.IshigamiModel()
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sampleSize = 32768
    >>> experiment = ot.MonteCarloExperiment(im.inputDistribution, sampleSize)
    >>> integration = otexp.ExperimentIntegration(experiment)
    >>> approximatedOutputMean = integration.integrate(im.model)
    >>> print(approximatedOutputMean)
    [3.5...]

    Compute the L2 norm of a function.

    >>> im = ishigami_function.IshigamiModel()
    >>> centeredIshigamiFunction = ot.SymbolicFunction(
    ...     ['x1', 'x2', 'x3'],
    ...     ['sin(x1) + 7 * (sin(x2))^2 + 0.1 * x3^4 * sin(x1) - 3.5']
    ... )
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sampleSize = 65536
    >>> experiment = ot.MonteCarloExperiment(im.inputDistribution, sampleSize)
    >>> integration = otexp.ExperimentIntegration(experiment)
    >>> functionNorm = integration.computeL2Norm(centeredIshigamiFunction)
    >>> print(functionNorm)
    [3.7...]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ExperimentIntegration_getClassName(self)

    def __repr__(self):
        return _experimental.ExperimentIntegration___repr__(self)

    def integrate(self, g):
        r"""
        Integrate the function.

        This method returns an approximation of the expected value of the physical model:

        .. math::

            \Expect{ \model(\inputRV)}
            = \int_{\physicalInputSpace} \model(\inputReal) 
            \inputProbabilityDensityFunction(\inputReal) d\inputReal

        where :math:`\inputProbabilityDensityFunction` is the probability density 
        function of the input random vector :math:`\inputRV`.

        Parameters
        ----------
        g : :class:`~openturns.Function`
            The function to integrate.

        Returns
        -------
        approximateIntegral : :class:`~openturns.Point`
            The approximated integral of the function.
            The dimension of the :class:`~openturns.Point` is equal
            to the output dimension of the function `g`.

        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> from openturns.usecases import ishigami_function
        >>> im = ishigami_function.IshigamiModel()
        >>> print(im.expectation)
        3.5
        >>> sampleSize = 2 ** 12  # Sobol' sequence is a base 2 sequence
        >>> sequence = ot.SobolSequence(im.dim)
        >>> experiment = ot.LowDiscrepancyExperiment(sequence, im.inputDistribution, 
        ...                                          sampleSize, False)
        >>> integration = otexp.ExperimentIntegration(experiment)
        >>> approximatedOutputMean = integration.integrate(im.model)
        >>> print(approximatedOutputMean[0])
        3.5...
        """
        return _experimental.ExperimentIntegration_integrate(self, g)

    def computeL2Norm(self, g):
        r"""
        Compute the norm of the function.

        This method returns an approximation of the :math:`L^2(\inputProbabilityDensityFunction)` norm of the physical model:

        .. math::

            \|\model\|_{L^2(\inputProbabilityDensityFunction)}
            & = \left( \Expect{\model(\inputRV)^2} \right)^{1/2} \\
            & = \left( \int_{\physicalInputSpace} \left(\model(\inputReal)\right)^2
            \inputProbabilityDensityFunction(\inputReal) d\inputReal \right)^{1/2}

        where :math:`\inputProbabilityDensityFunction` is the probability density 
        function of the input random vector.

        Parameters
        ----------
        g : :class:`~openturns.Function`
            The function which norm is to be computed.

        Returns
        -------
        functionNorm : :class:`~openturns.Point`
            The approximated L2 norm of the function.
            The dimension of the :class:`~openturns.Point` is equal
            to the output dimension of the function `g`.

        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> import math
        >>> from openturns.usecases import ishigami_function
        >>> im = ishigami_function.IshigamiModel()
        >>> print(math.sqrt(im.variance))
        3.72...
        >>> centeredIshigamiFunction = ot.SymbolicFunction(['x1', 'x2', 'x3'],
        ... ['sin(x1) + 7 * (sin(x2))^2 + 0.1 * x3^4 * sin(x1) - 3.5'])
        >>> sampleSize = 2 ** 12  # Sobol' sequence is a base 2 sequence
        >>> sequence = ot.SobolSequence(im.dim)
        >>> experiment = ot.LowDiscrepancyExperiment(sequence, im.inputDistribution, sampleSize, False)
        >>> integration = otexp.ExperimentIntegration(experiment)
        >>> functionNorm = integration.computeL2Norm(centeredIshigamiFunction)
        >>> print(functionNorm[0])
        3.7...
        """
        return _experimental.ExperimentIntegration_computeL2Norm(self, g)

    def __init__(self, *args):
        _experimental.ExperimentIntegration_swiginit(self, _experimental.new_ExperimentIntegration(*args))
    __swig_destroy__ = _experimental.delete_ExperimentIntegration

# Register ExperimentIntegration in _experimental:
_experimental.ExperimentIntegration_swigregister(ExperimentIntegration)
class FejerExperiment(openturns.weightedexperiment.WeightedExperimentImplementation):
    r"""
    Fejer experiment.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    This class computes Fejer and Clenshaw–Curtis quadrature,
    `see also here <https://en.wikipedia.org/wiki/Clenshaw%E2%80%93Curtis_quadrature>`_

    For any :math:`k=0,1,...,n-1`, let :math:`\theta_k = \dfrac{k\pi}{n}`.
    The Clenshaw-Curtis nodes are:

    .. math::

        x_k = \cos(\theta_k)

    for any :math:`k=0,1,...,n-1` and its associated weights are:

    .. math::

        w_k = \dfrac{c_k}{n}\left(1-\sum_{j=1}^{\lfloor n/2\rfloor}\dfrac{b_j}{4j^2-1}\cos\left(2j\theta_k\right)\right)

    where:

    .. math::

        b_j =
        \begin{cases}
        2 & \textrm{ if } j < n/2, \\
        1 & \textrm{ otherwise},
        \end{cases}

    and:

    .. math::

        c_k =
        \begin{cases}
        1 & \textrm{ if } k = 0 \textrm{ or } n - 1, \\
        2 & \textrm{ otherwise}.
        \end{cases}

    The type-1 Fejer quadrature rule uses the nodes:

    .. math::

        x_k = \cos(\theta_{k + 1/2})

    for any :math:`k=0,1,...,n-1` and the associated weights are:

    .. math::

        w_k = \dfrac{2}{n}\left(1-2\sum_{j=1}^{\lfloor n/2\rfloor}\dfrac{1}{4j^2-1}\cos\left(j\theta_{2k+1}\right)\right)

    Finally, the type-2 Fejer quadrature rule is very close to the Clenshaw-Curtis rule. The two methods share the same
    nodes (except the endpoints that are set to `0` within the `Fejer` method).  The weights of the type-2 Fejer quadrature rule are:

    .. math::

        w_k=\dfrac{4}{n+1}\sin\theta_k\sum_{j=1}^{\lfloor n/2\rfloor}\dfrac{\sin\left((2j-1)\theta_k\right)}{2j-1}

    for any :math:`k=0,1,...,n-1`.

    Parameters
    ----------
    discretization : sequence of int, optional
        The number of nodes in each dimension. The sequence must be non-empty and must contain only positive values.
        The default discretization is *FejerExperiment-DefaultMarginalNodesNumber* in each dimension,
        see :class:`~openturns.ResourceMap`.
    rule : int, optional
        Possible values include:

        - ot.FejerExperiment.FEJERTYPE1,
        - ot.FejerExperiment.FEJERTYPE2,
        - ot.FejerExperiment.CLENSHAWCURTIS.

        Default is `ot.FejerExperiment.CLENSHAWCURTIS`

    See also
    --------
    openturns.FejerAlgorithm

    Examples
    --------
    Create an experiment:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> rule = otexp.FejerExperiment.FEJERTYPE1
    >>> experiment = otexp.FejerExperiment([3], rule)
    >>> experiment.setBounds(ot.Interval(4.0, 5.0))
    >>> nodes, weights = experiment.generateWithWeights()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.FejerExperiment_getClassName(self)
    FEJERTYPE1 = _experimental.FejerExperiment_FEJERTYPE1
    FEJERTYPE2 = _experimental.FejerExperiment_FEJERTYPE2
    CLENSHAWCURTIS = _experimental.FejerExperiment_CLENSHAWCURTIS

    def __repr__(self):
        return _experimental.FejerExperiment___repr__(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _experimental.FejerExperiment_hasUniformWeights(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _experimental.FejerExperiment_generateWithWeights(self)

    def isRandom(self):
        r"""
        Accessor to the randomness of quadrature.

        Parameters
        ----------
        isRandom : bool
            Is true if the design of experiments is random.
            Otherwise, the design of experiment is assumed to be deterministic.
        """
        return _experimental.FejerExperiment_isRandom(self)

    def setBounds(self, bounds):
        r"""
        Accessor to the design bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            The bounds used for rescaling.
        """
        return _experimental.FejerExperiment_setBounds(self, bounds)

    def getBounds(self):
        r"""
        Accessor to the design bounds.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            The bounds used for rescaling.
        """
        return _experimental.FejerExperiment_getBounds(self)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`\sampleSize` of points constituting the design of experiments.
        """
        return _experimental.FejerExperiment_setSize(self, size)

    def getSize(self):
        r"""
        Accessor to the size of the generated sample.

        Returns
        -------
        size : positive int
            Number :math:`\sampleSize` of points constituting the design of experiments.
        """
        return _experimental.FejerExperiment_getSize(self)

    def setDiscretization(self, discretization):
        r"""
        Accessor to the discretization of the tensorized rule.

        Parameters
        ----------
        discretization : :class:`~openturns.Indices`
            The number of integration point in each dimension.
        """
        return _experimental.FejerExperiment_setDiscretization(self, discretization)

    def getDiscretization(self):
        r"""
        Accessor to the discretization of the tensorized rule.

        Returns
        -------
        discretization : :class:`~openturns.Indices`
            The number of integration point in each dimension.
        """
        return _experimental.FejerExperiment_getDiscretization(self)

    def setRuleType(self, ruleType):
        r"""
        Accessor to the generation rule.

        Parameters
        ----------
        ruleType : int
            The generation rule. Possible values include:

            - ot.FejerExperiment.FEJERTYPE1,
            - ot.FejerExperiment.FEJERTYPE2,
            - ot.FejerExperiment.CLENSHAWCURTIS.
        """
        return _experimental.FejerExperiment_setRuleType(self, ruleType)

    def getRuleType(self):
        r"""
        Accessor to the generation rule.

        Returns
        -------
        ruleType : int
            The generation rule.
        """
        return _experimental.FejerExperiment_getRuleType(self)

    def setLevels(self, levels):
        r"""
        Accessor to the experiment nesting levels.

        Parameters
        ----------
        levels : sequence of int
            Nesting level for each component.
        """
        return _experimental.FejerExperiment_setLevels(self, levels)

    def setUseNestedLevels(self, useNestedLevels):
        r"""
        Accessor to the levels interpretation flag.

        Parameters
        ----------
        useNestedLevels : bool
            Whether the level is raised to the power of two (only for FEJERTYPE2, CLENSHAWCURTIS nested rules) or interpreted as raw size.
        """
        return _experimental.FejerExperiment_setUseNestedLevels(self, useNestedLevels)

    def getUseNestedLevels(self):
        r"""
        Accessor to the levels interpretation flag.

        Returns
        -------
        useNestedLevels : bool
            Whether the level is raised to the power of two (only for FEJERTYPE2, CLENSHAWCURTIS nested rules) or interpreted as raw size.
        """
        return _experimental.FejerExperiment_getUseNestedLevels(self)

    def __init__(self, *args):
        _experimental.FejerExperiment_swiginit(self, _experimental.new_FejerExperiment(*args))
    __swig_destroy__ = _experimental.delete_FejerExperiment

# Register FejerExperiment in _experimental:
_experimental.FejerExperiment_swigregister(FejerExperiment)
import openturns.metamodel
import openturns.randomvector
import openturns.transformation
import openturns.analytical
class ANCOVA(object):
    r"""
    ANalysis of COVAriance method (ANCOVA).

    Refer to :ref:`sensitivity_ancova`.

    Parameters
    ----------
    functionalChaosResult : :class:`~openturns.FunctionalChaosResult`
        Functional chaos result approximating the model response with
        uncorrelated inputs.
    correlatedInput : 2-d sequence of float
        Correlated inputs used to compute the real values of the output.
        Its dimension must be equal to the number of inputs of the model.

    Notes
    -----
    ANCOVA, a variance-based method described in [caniou2012]_, is a generalization
    of the ANOVA (ANalysis Of VAriance) decomposition for models with correlated
    input parameters.

    Let us consider a model :math:`Y = h(\vect{X})` without making any hypothesis
    on the dependence structure of :math:`\vect{X} = \{X^1, \ldots, X^{n_X} \}`, a
    n_X-dimensional random vector. The covariance decomposition requires a functional
    decomposition of the model. Thus the model response :math:`Y` is expanded as a
    sum of functions of increasing dimension as follows:

    .. math::
        :label: model

        h(\vect{X}) = h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u)

    :math:`h_0` is the mean of :math:`Y`. Each function :math:`h_u` represents,
    for any non empty set :math:`u\subseteq\{1, \dots, n_X\}`, the combined
    contribution of the variables :math:`X_u` to :math:`Y`.

    Using the properties of the covariance, the variance of :math:`Y` can be
    decomposed into a variance part and a covariance part as follows:

    .. math::

        Var[Y]&= Cov\left[h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u), h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u)\right] \\
              &= \sum_{u\subseteq\{1,\dots,n_X\}} \left[Var[h_u(X_u)] + Cov[h_u(X_u), \sum_{v\subseteq\{1,\dots,n_X\}, v\cap u=\varnothing} h_v(X_v)]\right]

    This variance formula enables to define each total part of variance of
    :math:`Y` due to :math:`X_u`, :math:`S_u`, as the sum of a *physical*
    (or *uncorrelated*) part and a *correlated* part such as:

    .. math::

        S_u = \frac{Cov[Y, h_u(X_u)]} {Var[Y]} = S_u^U + S_u^C

    where :math:`S_u^U` is the uncorrelated part of variance of Y due to :math:`X_u`:

    .. math::

        S_u^U = \frac{Var[h_u(X_u)]} {Var[Y]}

    and :math:`S_u^C` is the contribution of the correlation of :math:`X_u` with the
    other parameters:

    .. math::

        S_u^C = \frac{Cov\left[h_u(X_u), \displaystyle \sum_{v\subseteq\{1,\dots,n_X\}, v\cap u=\varnothing} h_v(X_v)\right]}
                     {Var[Y]}

    As the computational cost of the indices with the numerical model :math:`h`
    can be very high, [caniou2012]_ suggests to approximate the model response with
    a polynomial chaos expansion:

    .. math::

        Y \simeq \hat{h} = \sum_{j=0}^{P-1} \alpha_j \Psi_j(x)

    However, for the sake of computational simplicity, the latter is constructed
    considering *independent* components :math:`\{X^1,\dots,X^{n_X}\}`. Thus the
    chaos basis is not orthogonal with respect to the correlated inputs under
    consideration, and it is only used as a metamodel to generate approximated
    evaluations of the model response and its summands :eq:`model`.

    The next step consists in identifying the component functions. For instance, for
    :math:`u = \{1\}`:

    .. math::

        h_1(X_1) = \sum_{\alpha | \alpha_1 \neq 0, \alpha_{i \neq 1} = 0} y_{\alpha} \Psi_{\alpha}(\vect{X})

    where :math:`\alpha` is a set of degrees associated to the :math:`n_X` univariate
    polynomial :math:`\psi_i^{\alpha_i}(X_i)`.

    Then the model response :math:`Y` is evaluated using a sample
    :math:`X=\{x_k, k=1,\dots,N\}` of the correlated joint distribution. Finally,
    the several indices are computed using the model response and its component
    functions that have been identified on the polynomial chaos.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Model and distribution definition
    >>> model = ot.SymbolicFunction(['X1','X2'], ['4.*X1 + 5.*X2'])
    >>> distribution = ot.JointDistribution([ot.Normal()] * 2)
    >>> S = ot.CorrelationMatrix(2)
    >>> S[1, 0] = 0.3
    >>> R = ot.NormalCopula().GetCorrelationFromSpearmanCorrelation(S)
    >>> CorrelatedInputDistribution = ot.JointDistribution([ot.Normal()] * 2, ot.NormalCopula(R))
    >>> sample = CorrelatedInputDistribution.getSample(200)
    >>> # Functional chaos computation
    >>> productBasis = ot.OrthogonalProductPolynomialFactory([ot.HermiteFactory()] * 2, ot.LinearEnumerateFunction(2))
    >>> adaptiveStrategy = ot.FixedStrategy(productBasis, 15)
    >>> experiment = ot.MonteCarloExperiment(distribution, 100)
    >>> X = experiment.generate()
    >>> Y = model(X)
    >>> algo = ot.FunctionalChaosAlgorithm(X, Y, distribution, adaptiveStrategy)
    >>> algo.run()
    >>> ancovaResult = ot.ANCOVA(algo.getResult(), sample)
    >>> indices = ancovaResult.getIndices()
    >>> print(indices)
    [0.408398,0.591602]
    >>> uncorrelatedIndices = ancovaResult.getUncorrelatedIndices()
    >>> print(uncorrelatedIndices)
    [0.284905,0.468108]
    >>> # Get indices measuring the correlated effects
    >>> print(indices - uncorrelatedIndices)
    [0.123494,0.123494]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getUncorrelatedIndices(self, marginalIndex=0):
        r"""
        Accessor to the ANCOVA indices measuring uncorrelated effects.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the ANCOVA indices measuring uncorrelated effects of the inputs.
            The effects of the correlation are represented by the indices resulting
            from the subtraction of the :meth:`getIndices` and
            :meth:`getUncorrelatedIndices` lists.
        """
        return _experimental.ANCOVA_getUncorrelatedIndices(self, marginalIndex)

    def getIndices(self, marginalIndex=0):
        r"""
        Accessor to the ANCOVA indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the ANCOVA indices measuring the contribution of the
            input variables to the variance of the model. These indices are made up
            of a *physical* part and a *correlated* part. The first one is obtained
            thanks to :meth:`getUncorrelatedIndices`.
            The effects of the correlation are represented by the indices resulting
            from the subtraction of the :meth:`getIndices` and
            :meth:`getUncorrelatedIndices` lists.
        """
        return _experimental.ANCOVA_getIndices(self, marginalIndex)

    def __init__(self, *args):
        _experimental.ANCOVA_swiginit(self, _experimental.new_ANCOVA(*args))
    __swig_destroy__ = _experimental.delete_ANCOVA

# Register ANCOVA in _experimental:
_experimental.ANCOVA_swigregister(ANCOVA)
class FAST(object):
    r"""
    Fourier Amplitude Sensitivity Testing (FAST).

    Refer to :ref:`sensitivity_fast`.

    Parameters
    ----------
    model : :class:`~openturns.Function`
        Definition of the model to analyse.
    distribution : :class:`~openturns.Distribution`
        Contains the distributions of each model's input.
        Its dimension must be equal to the number of inputs.
    N : int, :math:`N > Nr`
        Size of the sample from which the Fourier series are calculated.
        It represents the length of the discretization of the s-space.
    Nr : int, :math:`Nr \geq 1`, optional
        Number of resamplings. The extended FAST method involves a part of
        randomness in the computation of the indices. So it can be asked to
        realize the procedure *Nr* times and then to calculate the
        arithmetic means of the results over the *Nr* estimates.
    M : int, :math:`0 < M < N`, optional
        Interference factor usually equal to 4 or higher.
        It corresponds to the truncation level of the Fourier series, i.e. the
        number of harmonics that are retained in the decomposition.

    Notes
    -----
    FAST is a sensitivity analysis method which is based upon the ANOVA
    decomposition of the variance of the model response :math:`y = f(\vect{X})`,
    the latter being represented by its Fourier expansion.
    :math:`\vect{X}=\{X^1,\dots,X^{n_X}\}` is an input random vector of :math:`n_X`
    independent components.

    OpenTURNS implements the extended FAST method consisting in computing
    alternately the first order and the total-effect indices of each input.
    This approach, widely described in the paper by [saltelli1999]_, relies upon a
    Fourier decomposition of the model response. Its key idea is to recast this
    representation as a function of a *scalar* parameter :math:`s`, by defining
    parametric curves :math:`s \mapsto x_i(s), i=1, \dots, n_X` exploring the
    support of the input random vector :math:`\vect{X}`.

    Then the Fourier expansion of the model response is:

    .. math::

        f(s) = \sum_{k \in \Zset^N} A_k cos(ks) + B_k sin(ks)

    where :math:`A_k` and :math:`B_k` are Fourier coefficients whose estimates are:

    .. math::

        \hat{A}_k &= \frac{1}{N} \sum_{j=1}^N f(x_j^1,\dots,x_j^{N_X}) cos\left(\frac{2k\pi (j-1)}{N} \right) \quad , \quad -\frac{N}{2} \leq k \leq \frac{N}{2} \\
        \hat{B}_k &= \frac{1}{N} \sum_{j=1}^N f(x_j^1,\dots,x_j^{N_X}) sin\left(\frac{2k\pi (j-1)}{N} \right) \quad , \quad -\frac{N}{2} \leq k \leq \frac{N}{2}


    The first order indices are estimated by:

    .. math::

        \hat{S}_i = \frac{\hat{D}_i}{\hat{D}}
                  = \frac{\sum_{p=1}^M(\hat{A}_{p\omega_i}^2 + \hat{B}_{p\omega_i}^2)^2}
                          {\sum_{n=1}^{(N-1)/2}(\hat{A}_n^2 + \hat{B}_n^2)^2}

    and the total order indices by:

    .. math::

        \hat{T}_i = 1 - \frac{\hat{D}_{-i}}{\hat{D}}
                  = 1 - \frac{\sum_{k=1}^{\omega_i/2}(\hat{A}_k^2 + \hat{B}_k^2)^2}
                              {\sum_{n=1}^{(N-1)/2}(\hat{A}_n^2 + \hat{B}_n^2)^2}

    where :math:`\hat{D}` is the total variance, :math:`\hat{D}_i` the portion
    of :math:`D` arising from the uncertainty of the :math:`i^{th}` input and
    :math:`\hat{D}_{-i}` is the part of the variance due to all the inputs
    except the :math:`i^{th}` input.

    :math:`N` is the size of the sample using to compute the Fourier series and
    :math:`M` is the interference factor. *Saltelli et al.* (1999) recommended to
    set :math:`M` to a value in the range :math:`[4, 6]`.
    :math:`\{\omega_i\}, \forall i=1, \dots, n_X` is a set of integer frequencies
    assigned to each input :math:`X^i`. The frequency associated with the input
    for which the sensitivity indices are computed, is set to the maximum admissible
    frequency satisfying the Nyquist criterion (which ensures to avoid aliasing effects):

    .. math::

        \omega_i = \frac{N - 1}{2M}

    In the paper by Saltelli et al. (1999), for high sample size, it is suggested
    that :math:`16 \leq \omega_i/N_r \leq 64`.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> sensitivityAnalysis = ot.FAST(model, distribution, 101)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.311097,0.441786,0.000396837]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Accessor to the first order indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the first order indices of all the inputs.
        """
        return _experimental.FAST_getFirstOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Accessor to the total order indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's  marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the total-effect order indices of all the inputs.
        """
        return _experimental.FAST_getTotalOrderIndices(self, marginalIndex)

    def getFFTAlgorithm(self):
        r"""
        Accessor to the FFT algorithm implementation.

        Returns
        -------
        fft : a :class:`~openturns.FFT`
            A FFT algorithm.
        """
        return _experimental.FAST_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, fft):
        r"""
        Accessor to the FFT algorithm implementation.

        Parameters
        ----------
        fft : a :class:`~openturns.FFT`
            A FFT algorithm.
        """
        return _experimental.FAST_setFFTAlgorithm(self, fft)

    def setBlockSize(self, blockSize):
        r"""
        Set the block size.

        Parameters
        ----------
        k : positive int
            Size of each block the sample is split into, this allows one to save space
            while allowing multithreading, when available we recommend to use
            the number of available CPUs, set by default to :math:`1`.
        """
        return _experimental.FAST_setBlockSize(self, blockSize)

    def getBlockSize(self):
        r"""
        Get the block size.

        Returns
        -------
        k : positive int
            Size of each block the sample is split into, this allows one to save space
            while allowing multithreading, when available we recommend to use
            the number of available CPUs, set by default to 1.
        """
        return _experimental.FAST_getBlockSize(self)

    def __init__(self, *args):
        _experimental.FAST_swiginit(self, _experimental.new_FAST(*args))
    __swig_destroy__ = _experimental.delete_FAST

# Register FAST in _experimental:
_experimental.FAST_swigregister(FAST)
class SobolIndicesAlgorithmImplementation(openturns.common.PersistentObject):
    r"""

    Sensitivity analysis.

    Notes
    -----
    This method measures the influence of each component of an input random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on an output random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see [sobol1993]_).
    It computes, for every output random variable :math:`Y_k` (:math:`1 \leqslant k \leqslant n_Y`),
    the part of its variance due to each input component :math:`X_i` (:math:`1 \leqslant i \leqslant n_X`) of :math:`\vect{X}`.
    Sobol' indices are introduced in :ref:`sensitivity_sobol`. 

    Several estimators of :math:`V_i`, :math:`V_i^T` and :math:`V_{-i}` are provided by the :class:`SobolIndicesAlgorithm` implementations:

    - :class:`~openturns.SaltelliSensitivityAlgorithm` for the `Saltelli` method,
    - :class:`~openturns.JansenSensitivityAlgorithm` for the `Jansen` method,
    - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm` for the `Mauntz-Kucherenko` method,
    - :class:`~openturns.MartinezSensitivityAlgorithm` for the `Martinez` method.

    Specific formulas for :math:`\widehat{V}_i`, :math:`\widehat{V}_i^T` and :math:`\widehat{V}_{-i}` are given in the corresponding documentation pages.


    For multivariate outputs i.e. when :math:`n_Y>1`, we compute the Sobol' indices with respect to each output variable. 
    In this case, the methods :meth:`getFirstOrderIndices` and 
    :meth:`getTotalOrderIndices` return the Sobol' indices of the first output, 
    but the index of the output can be specified as input argument.
    Aggregated indices can be retrieved with the :meth:`getAggregatedFirstOrderIndices` 
    and :meth:`getAggregatedTotalOrderIndices` methods. 


    Notice that the distribution of the estimators of the first
    and total order indices can be estimated
    thanks to the :meth:`getFirstOrderIndicesDistribution` and
    :meth:`getTotalOrderIndicesDistribution` methods.
    This is done either through bootstrapping or using an asymptotic estimator.
    The :class:`~openturns.ResourceMap` key `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution`
    stores a boolean that decides the default behavior,
    but it can be overridden by the method :meth:`setUseAsymptoticDistribution`.

    Corresponding confidence intervals are provided by the methods
    :meth:`getFirstOrderIndicesInterval` and :meth:`getTotalOrderIndicesInterval`.
    Their confidence level can be adjusted with :meth:`setConfidenceLevel`.
    The default confidence level is stored in the :class:`~openturns.ResourceMap`
    and can be accessed with the `SobolIndicesAlgorithm-DefaultConfidenceLevel` key.

    Indices estimates can be slightly outside of [0,1] if the estimator has not converged.
    For the same reason some first order indices estimates can be greater than the corresponding total order indices estimates.

    The asymptotic estimator of the distribution requires an asymptotic estimate
    of its variance, which is computed using the [janon2014]_
    delta method, as expained in the technical report [pmfre01116]_.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getClassName(self)

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Get first order Sobol indices.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing first order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getFirstOrderIndices(self, marginalIndex)

    def getFirstOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated first order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for first order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getFirstOrderIndicesInterval(self)

    def getSecondOrderIndices(self, marginalIndex=0):
        r"""
        Get second order Sobol indices.

        Notes
        -----
        Let :math:`n_X \in \Nset` be the input dimension of the random vector.
        For any pair of indices :math:`i, j \in \{1, ..., n_x\}` such that :math:`i \neq j`,
        this method computes the Sobol' interaction index between :math:`i` and :math:`j`:

        .. math::
            S_{\{i, j\}} = \frac{V_{\{i,j\}}}{\Var{Y}}

        The second order Sobol' index :math:`S_{i,j}`  measures the part of
        the variance of :math:`Y` explained by the interaction of :math:`X_i` and :math:`X_j`.
        Hence, the closed Sobol' index of the group :math:`\{i, j\}` is:

        .. math::
            S_{\{i, j\}}^{\operatorname{cl}} = S_i + S_j + S_{\{i, j\}}.

        Conversely, if the closed Sobol' index :math:`S_{\{i, j\}}^{\operatorname{cl}}` is known,
        then the interaction Sobol' index can be computed from the equation:

        .. math::
            S_{\{i, j\}} = S_{\{i, j\}}^{\operatorname{cl}} - S_i - S_j.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.SymmetricMatrix`
            Tensor containing second order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getSecondOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Get total order Sobol indices.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing total order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getTotalOrderIndices(self, marginalIndex)

    def getTotalOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated total order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for total order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getTotalOrderIndicesInterval(self)

    def getAggregatedFirstOrderIndices(self):
        r"""
        Get the evaluation of aggregated first order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated first order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getAggregatedFirstOrderIndices(self)

    def getAggregatedTotalOrderIndices(self):
        r"""
        Get the evaluation of aggregated total order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated total order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getAggregatedTotalOrderIndices(self)

    def getBootstrapSize(self):
        r"""
        Get the number of bootstrap sampling size.

        Returns
        -------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Set the number of bootstrap sampling size.

        Default value is 0.

        Parameters
        ----------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _experimental.SobolIndicesAlgorithmImplementation_setBootstrapSize(self, bootstrapSize)

    def getConfidenceLevel(self):
        r"""
        Get the confidence interval level for confidence intervals.

        Returns
        -------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getConfidenceLevel(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Set the confidence interval level for confidence intervals.

        Parameters
        ----------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _experimental.SobolIndicesAlgorithmImplementation_setConfidenceLevel(self, confidenceLevel)

    def setUseAsymptoticDistribution(self, useAsymptoticDistribution):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Default value is set by the `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution` key.

        Parameters
        ----------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _experimental.SobolIndicesAlgorithmImplementation_setUseAsymptoticDistribution(self, useAsymptoticDistribution)

    def getUseAsymptoticDistribution(self):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Returns
        -------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getUseAsymptoticDistribution(self)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated first order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for first order Sobol indices for each component.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated total order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for total order Sobol indices for each component.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getTotalOrderIndicesDistribution(self)

    def __repr__(self):
        return _experimental.SobolIndicesAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _experimental.SobolIndicesAlgorithmImplementation___str__(self, *args)

    @staticmethod
    def DrawImportanceFactors(*args):
        r"""
        Draw the importance factors.

        Available usages:
            DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

            DrawImportanceFactors(*values, names, title='Importance Factors'*)

        Parameters
        ----------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component. The descriptions are used to build labels for the created Pie.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Importance factors.
        names : sequence of str
            Variables' names used to build labels for the created Pie.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Pie` of the importance factors of
            the variables.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_DrawImportanceFactors(*args)

    @staticmethod
    def DrawSobolIndices(*args):
        r"""
        Draw the Sobol' indices.

        Parameters
        ----------
        inputDescription : sequence of str
            Variable names
        firstOrderIndices : sequence of float
            First order indices values
        totalOrderIndices : sequence of float
            Total order indices values
        fo_ci : :class:`~openturns.Interval`, optional
            First order indices confidence interval
        to_ci : :class:`~openturns.Interval`, optional
            Total order indices confidence interval

        Returns
        -------
        graph : :class:`~openturns.Graph`
            For each variable, draws first and total indices
        """
        return _experimental.SobolIndicesAlgorithmImplementation_DrawSobolIndices(*args)

    @staticmethod
    def DrawCorrelationCoefficients(*args):
        r"""
        Draw the correlation coefficients. 
         As correlation coefficients are considered, values might be positive or negative.

        Available usages:
            DrawCorrelationCoefficients(*correlationCoefficients, title='Correlation coefficients'*)

            DrawCorrelationCoefficients(*values, names, title='Correlation coefficients'*)

        Parameters
        ----------
        correlationCoefficients : :class:`~openturns.PointWithDescription`
            Sequence containing the correlation coefficients with a description for each
            component. The descriptions are used to build labels for the created graph.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Correlation coefficients.
        names : sequence of str
            Variables' names used to build labels for the created the graph.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Cloud` and a :class:`~openturns.Text` 
            of the correlation coefficients.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_DrawCorrelationCoefficients(*args)

    def draw(self, *args):
        r"""
        Draw sensitivity indices.

        Usage:
          draw()

          draw(*marginalIndex*)

        With the first usage, draw the aggregated first and total order indices.
        With the second usage, draw the first and total order indices of a specific marginal in case of vectorial output

        Parameters
        ----------
        marginalIndex: int
            marginal of interest (case of second usage)

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.

        Notes
        -----
        If number of bootstrap sampling is not 0, and confidence level associated > 0,
        the graph includes confidence interval plots in the first usage.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_draw(self, *args)

    def setDesign(self, inputDesign, outputDesign, size):
        r"""
        Sample accessor.

        Allows one to estimate indices from a predefined Sobol design.

        Parameters
        ----------
        inputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained
            thanks to the SobolIndicesAlgorithmImplementation.Generate method
        outputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained as the evaluation
            of a Function (model) on the previous inputDesign
        N : int
            Base size of the Sobol design
        """
        return _experimental.SobolIndicesAlgorithmImplementation_setDesign(self, inputDesign, outputDesign, size)

    def __init__(self, *args):
        _experimental.SobolIndicesAlgorithmImplementation_swiginit(self, _experimental.new_SobolIndicesAlgorithmImplementation(*args))
    __swig_destroy__ = _experimental.delete_SobolIndicesAlgorithmImplementation

# Register SobolIndicesAlgorithmImplementation in _experimental:
_experimental.SobolIndicesAlgorithmImplementation_swigregister(SobolIndicesAlgorithmImplementation)
class _SobolIndicesAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject_swiginit(self, _experimental.new__SobolIndicesAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _experimental.delete__SobolIndicesAlgorithmImplementationTypedInterfaceObject

# Register _SobolIndicesAlgorithmImplementationTypedInterfaceObject in _experimental:
_experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject_swigregister(_SobolIndicesAlgorithmImplementationTypedInterfaceObject)
class SobolIndicesAlgorithm(_SobolIndicesAlgorithmImplementationTypedInterfaceObject):
    r"""

    Sensitivity analysis.

    Notes
    -----
    This method measures the influence of each component of an input random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on an output random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see [sobol1993]_).
    It computes, for every output random variable :math:`Y_k` (:math:`1 \leqslant k \leqslant n_Y`),
    the part of its variance due to each input component :math:`X_i` (:math:`1 \leqslant i \leqslant n_X`) of :math:`\vect{X}`.
    Sobol' indices are introduced in :ref:`sensitivity_sobol`. 

    Several estimators of :math:`V_i`, :math:`V_i^T` and :math:`V_{-i}` are provided by the :class:`SobolIndicesAlgorithm` implementations:

    - :class:`~openturns.SaltelliSensitivityAlgorithm` for the `Saltelli` method,
    - :class:`~openturns.JansenSensitivityAlgorithm` for the `Jansen` method,
    - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm` for the `Mauntz-Kucherenko` method,
    - :class:`~openturns.MartinezSensitivityAlgorithm` for the `Martinez` method.

    Specific formulas for :math:`\widehat{V}_i`, :math:`\widehat{V}_i^T` and :math:`\widehat{V}_{-i}` are given in the corresponding documentation pages.


    For multivariate outputs i.e. when :math:`n_Y>1`, we compute the Sobol' indices with respect to each output variable. 
    In this case, the methods :meth:`getFirstOrderIndices` and 
    :meth:`getTotalOrderIndices` return the Sobol' indices of the first output, 
    but the index of the output can be specified as input argument.
    Aggregated indices can be retrieved with the :meth:`getAggregatedFirstOrderIndices` 
    and :meth:`getAggregatedTotalOrderIndices` methods. 


    Notice that the distribution of the estimators of the first
    and total order indices can be estimated
    thanks to the :meth:`getFirstOrderIndicesDistribution` and
    :meth:`getTotalOrderIndicesDistribution` methods.
    This is done either through bootstrapping or using an asymptotic estimator.
    The :class:`~openturns.ResourceMap` key `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution`
    stores a boolean that decides the default behavior,
    but it can be overridden by the method :meth:`setUseAsymptoticDistribution`.

    Corresponding confidence intervals are provided by the methods
    :meth:`getFirstOrderIndicesInterval` and :meth:`getTotalOrderIndicesInterval`.
    Their confidence level can be adjusted with :meth:`setConfidenceLevel`.
    The default confidence level is stored in the :class:`~openturns.ResourceMap`
    and can be accessed with the `SobolIndicesAlgorithm-DefaultConfidenceLevel` key.

    Indices estimates can be slightly outside of [0,1] if the estimator has not converged.
    For the same reason some first order indices estimates can be greater than the corresponding total order indices estimates.

    The asymptotic estimator of the distribution requires an asymptotic estimate
    of its variance, which is computed using the [janon2014]_
    delta method, as expained in the technical report [pmfre01116]_.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SobolIndicesAlgorithm_getClassName(self)

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Get first order Sobol indices.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing first order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithm_getFirstOrderIndices(self, marginalIndex)

    def getFirstOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated first order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for first order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _experimental.SobolIndicesAlgorithm_getFirstOrderIndicesInterval(self)

    def getSecondOrderIndices(self, marginalIndex=0):
        r"""
        Get second order Sobol indices.

        Notes
        -----
        Let :math:`n_X \in \Nset` be the input dimension of the random vector.
        For any pair of indices :math:`i, j \in \{1, ..., n_x\}` such that :math:`i \neq j`,
        this method computes the Sobol' interaction index between :math:`i` and :math:`j`:

        .. math::
            S_{\{i, j\}} = \frac{V_{\{i,j\}}}{\Var{Y}}

        The second order Sobol' index :math:`S_{i,j}`  measures the part of
        the variance of :math:`Y` explained by the interaction of :math:`X_i` and :math:`X_j`.
        Hence, the closed Sobol' index of the group :math:`\{i, j\}` is:

        .. math::
            S_{\{i, j\}}^{\operatorname{cl}} = S_i + S_j + S_{\{i, j\}}.

        Conversely, if the closed Sobol' index :math:`S_{\{i, j\}}^{\operatorname{cl}}` is known,
        then the interaction Sobol' index can be computed from the equation:

        .. math::
            S_{\{i, j\}} = S_{\{i, j\}}^{\operatorname{cl}} - S_i - S_j.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.SymmetricMatrix`
            Tensor containing second order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithm_getSecondOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Get total order Sobol indices.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing total order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithm_getTotalOrderIndices(self, marginalIndex)

    def getTotalOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated total order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for total order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _experimental.SobolIndicesAlgorithm_getTotalOrderIndicesInterval(self)

    def getAggregatedFirstOrderIndices(self):
        r"""
        Get the evaluation of aggregated first order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated first order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithm_getAggregatedFirstOrderIndices(self)

    def getAggregatedTotalOrderIndices(self):
        r"""
        Get the evaluation of aggregated total order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated total order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithm_getAggregatedTotalOrderIndices(self)

    def getBootstrapSize(self):
        r"""
        Get the number of bootstrap sampling size.

        Returns
        -------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _experimental.SobolIndicesAlgorithm_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Set the number of bootstrap sampling size.

        Default value is 0.

        Parameters
        ----------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _experimental.SobolIndicesAlgorithm_setBootstrapSize(self, bootstrapSize)

    def getConfidenceLevel(self):
        r"""
        Get the confidence interval level for confidence intervals.

        Returns
        -------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _experimental.SobolIndicesAlgorithm_getConfidenceLevel(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Set the confidence interval level for confidence intervals.

        Parameters
        ----------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _experimental.SobolIndicesAlgorithm_setConfidenceLevel(self, confidenceLevel)

    def setUseAsymptoticDistribution(self, useAsymptoticDistribution):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Default value is set by the `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution` key.

        Parameters
        ----------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _experimental.SobolIndicesAlgorithm_setUseAsymptoticDistribution(self, useAsymptoticDistribution)

    def getUseAsymptoticDistribution(self):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Returns
        -------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _experimental.SobolIndicesAlgorithm_getUseAsymptoticDistribution(self)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated first order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for first order Sobol indices for each component.
        """
        return _experimental.SobolIndicesAlgorithm_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated total order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for total order Sobol indices for each component.
        """
        return _experimental.SobolIndicesAlgorithm_getTotalOrderIndicesDistribution(self)

    @staticmethod
    def DrawImportanceFactors(*args):
        r"""
        Draw the importance factors.

        Available usages:
            DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

            DrawImportanceFactors(*values, names, title='Importance Factors'*)

        Parameters
        ----------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component. The descriptions are used to build labels for the created Pie.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Importance factors.
        names : sequence of str
            Variables' names used to build labels for the created Pie.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Pie` of the importance factors of
            the variables.
        """
        return _experimental.SobolIndicesAlgorithm_DrawImportanceFactors(*args)

    @staticmethod
    def DrawSobolIndices(*args):
        r"""
        Draw the Sobol' indices.

        Parameters
        ----------
        inputDescription : sequence of str
            Variable names
        firstOrderIndices : sequence of float
            First order indices values
        totalOrderIndices : sequence of float
            Total order indices values
        fo_ci : :class:`~openturns.Interval`, optional
            First order indices confidence interval
        to_ci : :class:`~openturns.Interval`, optional
            Total order indices confidence interval

        Returns
        -------
        graph : :class:`~openturns.Graph`
            For each variable, draws first and total indices
        """
        return _experimental.SobolIndicesAlgorithm_DrawSobolIndices(*args)

    @staticmethod
    def DrawCorrelationCoefficients(*args):
        r"""
        Draw the correlation coefficients. 
         As correlation coefficients are considered, values might be positive or negative.

        Available usages:
            DrawCorrelationCoefficients(*correlationCoefficients, title='Correlation coefficients'*)

            DrawCorrelationCoefficients(*values, names, title='Correlation coefficients'*)

        Parameters
        ----------
        correlationCoefficients : :class:`~openturns.PointWithDescription`
            Sequence containing the correlation coefficients with a description for each
            component. The descriptions are used to build labels for the created graph.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Correlation coefficients.
        names : sequence of str
            Variables' names used to build labels for the created the graph.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Cloud` and a :class:`~openturns.Text` 
            of the correlation coefficients.
        """
        return _experimental.SobolIndicesAlgorithm_DrawCorrelationCoefficients(*args)

    def draw(self, *args):
        r"""
        Draw sensitivity indices.

        Usage:
          draw()

          draw(*marginalIndex*)

        With the first usage, draw the aggregated first and total order indices.
        With the second usage, draw the first and total order indices of a specific marginal in case of vectorial output

        Parameters
        ----------
        marginalIndex: int
            marginal of interest (case of second usage)

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.

        Notes
        -----
        If number of bootstrap sampling is not 0, and confidence level associated > 0,
        the graph includes confidence interval plots in the first usage.
        """
        return _experimental.SobolIndicesAlgorithm_draw(self, *args)

    def setDesign(self, inputDesign, outputDesign, size):
        r"""
        Sample accessor.

        Allows one to estimate indices from a predefined Sobol design.

        Parameters
        ----------
        inputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained
            thanks to the SobolIndicesAlgorithmImplementation.Generate method
        outputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained as the evaluation
            of a Function (model) on the previous inputDesign
        N : int
            Base size of the Sobol design
        """
        return _experimental.SobolIndicesAlgorithm_setDesign(self, inputDesign, outputDesign, size)

    def __repr__(self):
        return _experimental.SobolIndicesAlgorithm___repr__(self)

    def __str__(self, *args):
        return _experimental.SobolIndicesAlgorithm___str__(self, *args)

    def __init__(self, *args):
        _experimental.SobolIndicesAlgorithm_swiginit(self, _experimental.new_SobolIndicesAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_SobolIndicesAlgorithm

# Register SobolIndicesAlgorithm in _experimental:
_experimental.SobolIndicesAlgorithm_swigregister(SobolIndicesAlgorithm)
class MartinezSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Martinez method.

    Available constructors:
        MartinezSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        MartinezSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        MartinezSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    model : :class:`~openturns.Function`
        Model to evaluate input samples.
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [martinez2011]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of the first and total order Sobol' indices used by this class are respectively:

    .. math::

       \hat{S}_i & = \tilde{\rho}_n\left(\tilde{\vect{g}}(\mat{B}), \tilde{\vect{g}}(\mat{E}^i)\right) \\
       \widehat{S}_i^T & = 1 - \tilde{\rho}_n\left(\tilde{\vect{g}}(\mat{A}), \tilde{\vect{g}}(\mat{E}^i)\right) \\

    where :math:`\tilde{\rho}_n` is the modified sample correlation (under the assumption that the
    sample has a zero mean) defined, for any pair of vectors
    :math:`(\vect{z}, \vect{z}') \in \Rset^N \times \Rset^N`, by:

    .. math::

       \tilde{\rho}_n \left(\vect{z}, \vect{z}'\right) = 
       \frac{\sum_{k=1}^N z_k z_k'}
       {\sqrt{\sum_{k=1}^N z_k^2} \sqrt{\sum_{k=1}^N \left( z_k' \right)^2}}

    where :math:`\tilde{\vect{g}}` is the centered model based on the sample.

    The class constructor ``MartinezSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the ``outputDesign``, and therefore for the  ``inputDesign``.
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.



    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 10000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.MartinezSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.308902,0.459187,0.00683867]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.567786,0.430754,0.244293]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.MartinezSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _experimental.MartinezSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _experimental.MartinezSensitivityAlgorithm_swiginit(self, _experimental.new_MartinezSensitivityAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_MartinezSensitivityAlgorithm

# Register MartinezSensitivityAlgorithm in _experimental:
_experimental.MartinezSensitivityAlgorithm_swigregister(MartinezSensitivityAlgorithm)
class SaltelliSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Saltelli method.

    Available constructors:
        SaltelliSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        SaltelliSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        SaltelliSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    model : :class:`~openturns.Function`
        Model to evaluate input samples.
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [saltelli2002]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of :math:`V_i` and :math:`V_{-i}` used by this class are respectively:

    .. math::

       \widehat{V}_i & =  \frac{1}{N-1}\sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k)  \tilde{\vect{g}}(\vect{E}_k) 
       - \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k)\right) 
       \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k)\right) \\
       \widehat{V}_{-i} & =  \frac{1}{N-1}\sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k)  \tilde{\vect{g}}(\vect{E}_k) 
       - \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k)\right) 
       \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k)\right)

    where :math:`\tilde{\vect{g}}` is the centered model based on the sample. 

    The class constructor ``SaltelliSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the  ``outputDesign``, and therefore for the  ``inputDesign`` .
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.



    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 10000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.SaltelliSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.302745,0.460846,0.0066916]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.574996,0.427126,0.256689]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SaltelliSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _experimental.SaltelliSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _experimental.SaltelliSensitivityAlgorithm_swiginit(self, _experimental.new_SaltelliSensitivityAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_SaltelliSensitivityAlgorithm

# Register SaltelliSensitivityAlgorithm in _experimental:
_experimental.SaltelliSensitivityAlgorithm_swigregister(SaltelliSensitivityAlgorithm)
class JansenSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Jansen method.

    Available constructors:
        JansenSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        JansenSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        JansenSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    model : :class:`~openturns.Function`
        Model to evaluate input samples.
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [jansen1999]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of :math:`V_i` and :math:`V_i^T` used by this class are respectively:

    .. math::

       \widehat{V}_i & = \frac{1}{N-1} \sum_{k=1}^N \tilde{\vect{g}}(\vect{A}_k)^2 - \frac{1}{2N-1} \sum_{k=1}^N \left( \tilde{\vect{g}}(\vect{E}_k) - \tilde{\vect{g}}(\vect{B}_k) \right)^2 \\
       \widehat{V}_i^T & = \frac{1}{2N-1} \sum_{k=1}^N \left( \tilde{\vect{g}}(\vect{E}_k) -  \tilde{\vect{g}}(\vect{A}_k) \right)^2

    where :math:`\tilde{\vect{g}}` is the centered model based on the sample. 

    The class constructor ``JansenSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the ``outputDesign``, and therefore for the  ``inputDesign``.
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.



    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 10000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.JansenSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.322419,0.457314,0.0260925]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.55841,0.433746,0.240408]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.JansenSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _experimental.JansenSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _experimental.JansenSensitivityAlgorithm_swiginit(self, _experimental.new_JansenSensitivityAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_JansenSensitivityAlgorithm

# Register JansenSensitivityAlgorithm in _experimental:
_experimental.JansenSensitivityAlgorithm_swigregister(JansenSensitivityAlgorithm)
class MauntzKucherenkoSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using MauntzKucherenko method.

    Available constructors:
        MauntzKucherenkoSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        MauntzKucherenkoSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        MauntzKucherenkoSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    model : :class:`~openturns.Function`
        Model to evaluate input samples.
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [sobol2007]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of :math:`V_i` and :math:`V_{-i}` used by this class are respectively:

    .. math::

       \widehat{V}_i & = \frac{1}{N-1} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k) \left( \tilde{\vect{g}}(\vect{E}_k) - \tilde{\vect{g}}(\vect{A}_k) \right) \\
       \widehat{VT}_{i} & = \frac{1}{N-1} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k) \left( \tilde{\vect{g}}(\vect{A}_k) -  \tilde{\vect{g}}(\vect{E}_k) \right)

    where :math:`\tilde{\vect{g}}` is the centered model based on the sample. 

    The class constructor ``MauntzKucherenkoSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the ``outputDesign``, and therefore for the  ``inputDesign``.
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 100000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.MauntzKucherenkoSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.311678,0.439075,0.00401876]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.556564,0.439185,0.24036]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.MauntzKucherenkoSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _experimental.MauntzKucherenkoSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _experimental.MauntzKucherenkoSensitivityAlgorithm_swiginit(self, _experimental.new_MauntzKucherenkoSensitivityAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_MauntzKucherenkoSensitivityAlgorithm

# Register MauntzKucherenkoSensitivityAlgorithm in _experimental:
_experimental.MauntzKucherenkoSensitivityAlgorithm_swigregister(MauntzKucherenkoSensitivityAlgorithm)
class SobolIndicesExperiment(openturns.weightedexperiment.WeightedExperimentImplementation):
    r"""
    Experiment to computeSobol' indices.

    Available constructors:
        SobolIndicesExperiment(*distribution, size, computeSecondOrder=False*)

        SobolIndicesExperiment(*experiment, computeSecondOrder=False*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Size :math:`N` of each of the two independent initial samples.
        For the total size of the experiment see notes below.
    experiment : :class:`~openturns.WeightedExperiment`
        Design of experiment used to sample the distribution.
    computeSecondOrder : bool, defaults to False
        Whether to add points to compute second order indices

    Notes
    -----
    Sensitivity algorithms rely on the definition of specific designs.

    The :meth:`generate` method of this class produces a :class:`~openturns.Sample`
    to be supplied to the constructor of one of the :class:`~openturns.SobolIndicesAlgorithm` implementations:

    - :class:`~openturns.SaltelliSensitivityAlgorithm`,
    - :class:`~openturns.MartinezSensitivityAlgorithm`,
    - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm`,
    - :class:`~openturns.JansenSensitivityAlgorithm`.

    The chosen :class:`~openturns.SobolIndicesAlgorithm` implementation then uses the sample as *input design*,
    which means it represents (but is not a realization of) a random vector :math:`\vect{X} = \left( X^1, \ldots, X^{n_X} \right)`.

    Either the :class:`~openturns.Distribution` of :math:`\vect{X}`
    or a :class:`~openturns.WeightedExperiment` that represents it
    must be supplied to the class constructor.

    If a :class:`~openturns.WeightedExperiment` is supplied, the class uses it directly.

    If the distribution of :math:`\vect{X}` is supplied, the class generates a :class:`~openturns.WeightedExperiment`.
    To do this, it duplicates the distribution: every marginal is repeated once to produce
    a :math:`2 n_X`-dimensional distribution.
    This trick makes it possible to choose a :class:`~openturns.WeightedExperiment` with non-iid samples
    (that is a :class:`~openturns.LHSExperiment` or a :class:`~openturns.LowDiscrepancyExperiment`)
    to represent the original :math:`n_X`-dimensional distribution.

    The type of :class:`~openturns.WeightedExperiment` depends on the value of ``'SobolIndicesExperiment-SamplingMethod'`` in the :class:`~openturns.ResourceMap`:

        - ``'MonteCarlo'`` for a :class:`~openturns.MonteCarloExperiment`.
        - ``'LHS'`` for an :class:`~openturns.LHSExperiment` with *alwaysShuffle* and *randomShift* set to *True*.
        - ``'QMC'`` for a :class:`~openturns.LowDiscrepancyExperiment` (with *randomize* flag set to *False*) built from a :class:`~openturns.SobolSequence`.

    ``'MonteCarlo'`` is the default choice because it allows the chosen :class:`~openturns.SobolIndicesAlgorithm` implementation to use the asymptotic distribution of the estimators of the Sobol' indices.

    Note that ``'QMC'`` is only possible if :math:`2 n_X \leqslant` :class:`~openturns.SobolSequence`:code:`.MaximumDimension`.
    If ``'QMC'`` is specified but :math:`2 n_X >` :class:`~openturns.SobolSequence`:code:`.MaximumDimension`, the class falls back to ``'LHS'``.

    >>> from openturns import SobolSequence
    >>> print(SobolSequence.MaximumDimension)
    1111

    Regardless of the type of :class:`~openturns.WeightedExperiment`,
    the class splits it into two samples with the same size :math:`N`:
    :math:`\mat{A}` and :math:`\mat{B}`.
    Their columns are mixed in order to produce a very large sample: the *inputDesign* argument
    taken by one of the constructors of every :class:`~openturns.SobolIndicesAlgorithm` implementation.

    If *computeSecondOrder* is set to *False*, the input design is of size :math:`N(2+n_X)`.
    The first :math:`N` rows contain the sample :math:`\mat{A}` and the next :math:`N` rows the sample :math:`\mat{B}`.
    The last :math:`N n_X` rows contain :math:`n_X` copies of :math:`\mat{A}`,
    each with a different column replaced by the corresponding column from :math:`\mat{B}`
    (they are the matrices :math:`\mat{E}^i` from the documentation page of :class:`~openturns.SobolIndicesAlgorithm`).

    If *computeSecondOrder* is set to *True* and :math:`n_X = 2`, the input design is the same as in
    the case where *computeSecondOrder* is *False* (see [saltelli2002]_).

    If *computeSecondOrder* is set to *True* and :math:`n_X \neq 2`, the input design size is :math:`N(2+2 n_X)`.
    The first :math:`N(2+n_X)` rows are the same as when *computeSecondOrder* is *False*.
    The last :math:`N n_X` rows contain :math:`n_X` copies of :math:`\mat{B}`,
    each with a different column replaced by the corresponding column from :math:`\mat{A}`
    (they are the matrices :math:`\mat{C}^i` from the documentation page of :class:`~openturns.SobolIndicesAlgorithm`).

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Create a sample suitable to estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> size = 10
    >>> experiment = ot.SobolIndicesExperiment(distribution, size)
    >>> sample = experiment.generate()

    Create a sample suitable to estimate first, total order and second order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> size = 10
    >>> computeSecondOrder = True
    >>> experiment = ot.SobolIndicesExperiment(distribution, size, computeSecondOrder)
    >>> sample = experiment.generate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SobolIndicesExperiment_getClassName(self)

    def __repr__(self):
        return _experimental.SobolIndicesExperiment___repr__(self)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`\sampleSize` of points constituting the design of experiments.
        """
        return _experimental.SobolIndicesExperiment_setSize(self, size)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _experimental.SobolIndicesExperiment_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _experimental.SobolIndicesExperiment_getDistribution(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _experimental.SobolIndicesExperiment_hasUniformWeights(self)

    def generateWithWeights(self, weights):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _experimental.SobolIndicesExperiment_generateWithWeights(self, weights)

    def getWeightedExperiment(self):
        r"""
        Experiment accessor.

        Returns
        -------
        experiment : :class:`~openturns.WeightedExperiment`
            The internal experiment.
        """
        return _experimental.SobolIndicesExperiment_getWeightedExperiment(self)

    def __init__(self, *args):
        _experimental.SobolIndicesExperiment_swiginit(self, _experimental.new_SobolIndicesExperiment(*args))
    __swig_destroy__ = _experimental.delete_SobolIndicesExperiment

# Register SobolIndicesExperiment in _experimental:
_experimental.SobolIndicesExperiment_swigregister(SobolIndicesExperiment)
class SimulationResult(openturns.common.PersistentObject):
    r"""
    EventSimulation result base class.

    Notes
    -----
    Structure created by the method run() of a :class:`~openturns.EventSimulation`,
    and obtained thanks to the method getResult().
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SimulationResult_getClassName(self)

    def getOuterSampling(self):
        r"""
        Accessor to the outer sampling.

        Returns
        -------
        outerSampling : int
            Number of groups of terms in the probability simulation estimator.
        """
        return _experimental.SimulationResult_getOuterSampling(self)

    def setOuterSampling(self, outerSampling):
        r"""
        Accessor to the outer sampling.

        Parameters
        ----------
        outerSampling : int, :math:`outerSampling \geq 0`
            Number of groups of terms in the probability simulation estimator.
        """
        return _experimental.SimulationResult_setOuterSampling(self, outerSampling)

    def getBlockSize(self):
        r"""
        Accessor to the block size.

        Returns
        -------
        blockSize : int
            Number of terms in the probability simulation estimator grouped together.
        """
        return _experimental.SimulationResult_getBlockSize(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 0`
            Number of terms in the probability simulation estimator grouped together.
        """
        return _experimental.SimulationResult_setBlockSize(self, blockSize)

    def setTimeDuration(self, time):
        r"""
        Accessor to the elapsed time.

        Parameters
        ----------
        time : float
            Simulation duration in seconds
        """
        return _experimental.SimulationResult_setTimeDuration(self, time)

    def getTimeDuration(self):
        r"""
        Accessor to the elapsed time.

        Returns
        -------
        time : float
            Simulation duration in seconds
        """
        return _experimental.SimulationResult_getTimeDuration(self)

    def __repr__(self):
        return _experimental.SimulationResult___repr__(self)

    def __init__(self, *args):
        _experimental.SimulationResult_swiginit(self, _experimental.new_SimulationResult(*args))
    __swig_destroy__ = _experimental.delete_SimulationResult

# Register SimulationResult in _experimental:
_experimental.SimulationResult_swigregister(SimulationResult)
class ProbabilitySimulationResult(SimulationResult):
    r"""
    Probability simulation result.

    Notes
    -----
    Structure created by the method run() of a :class:`~openturns.EventSimulation`,
    and obtained thanks to the method getResult().

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> limitState = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3.*E*I)'])
    >>> # Enable the history mechanism in order to use the getImportanceFactors method
    >>> limitState = ot.MemoizeFunction(limitState)
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> output = ot.CompositeRandomVector(limitState, ot.RandomVector(distribution))
    >>> event = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> experiment = ot.MonteCarloExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> importanceFactors = result.getImportanceFactors()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ProbabilitySimulationResult_getClassName(self)

    def getEvent(self):
        r"""
        Accessor to the event.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _experimental.ProbabilitySimulationResult_getEvent(self)

    def setEvent(self, event):
        r"""
        Accessor to the event.

        Parameters
        ----------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _experimental.ProbabilitySimulationResult_setEvent(self, event)

    def getProbabilityEstimate(self):
        r"""
        Accessor to the probability estimate.

        Returns
        -------
        probaEstimate : float
            Estimate of the event probability.
        """
        return _experimental.ProbabilitySimulationResult_getProbabilityEstimate(self)

    def setProbabilityEstimate(self, probabilityEstimate):
        r"""
        Accessor to the probability estimate.

        Parameters
        ----------
        probaEstimate : float, :math:`0 \leq P_e \leq 1`
            Estimate of the event probability.
        """
        return _experimental.ProbabilitySimulationResult_setProbabilityEstimate(self, probabilityEstimate)

    def getVarianceEstimate(self):
        r"""
        Accessor to the variance estimate.

        Returns
        -------
        varianceEstimate : float
            Variance estimate.
        """
        return _experimental.ProbabilitySimulationResult_getVarianceEstimate(self)

    def setVarianceEstimate(self, varianceEstimate):
        r"""
        Accessor to the variance estimate.

        Parameters
        ----------
        varianceEstimate : float, :math:`Var_e \geq 0`
            Variance estimate.
        """
        return _experimental.ProbabilitySimulationResult_setVarianceEstimate(self, varianceEstimate)

    def getProbabilityDistribution(self):
        r"""
        Accessor to the asymptotic probability distribution.

        Returns
        -------
        probaDistribution : :class:`~openturns.Normal`
            Asymptotic normal distribution of the event probability estimate.
        """
        return _experimental.ProbabilitySimulationResult_getProbabilityDistribution(self)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _experimental.ProbabilitySimulationResult_getCoefficientOfVariation(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the standard deviation.

        Returns
        -------
        sigma : float
            Standard deviation of the estimator at the end of the simulation.
        """
        return _experimental.ProbabilitySimulationResult_getStandardDeviation(self)

    def getMeanPointInEventDomain(self):
        r"""
        Accessor to the mean point conditioned to the event realization.

        Returns
        -------
        meanPoint : :class:`~openturns.Point`
            Mean point in the physical space of all the simulations generated by the
            :class:`~openturns.EventSimulation` algorithm that failed into the event domain.

        Notes
        -----
        .. warning::
            This notion is only available if the history mechanism of the model is
            activated (see :class:`~openturns.MemoizeFunction`).
        """
        return _experimental.ProbabilitySimulationResult_getMeanPointInEventDomain(self)

    def getImportanceFactors(self):
        r"""
        Accessor to the importance factors.

        Returns
        -------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component.

        Notes
        -----
        The importance factors :math:`\alpha_i` are evaluated from the coordinates of
        the mean point of event domain :math:`\vect{X}^*_{event}`, mapped into the
        standard space as follows:

        .. math::

          \alpha_i = \displaystyle \frac{\left(U_{i}^*\right)^2}{||\vect{U}^*||^2}

        where :math:`\vect{U}^* = T(\vect{X}^*_{event})`
        with :math:`T` the iso-probabilistic transformation and the mean point
        :math:`\vect{X}^*_{event} = \displaystyle \frac{1}{n} \sum_{i=1}^{n} \vect{X}_i 1_{event}(\vect{X}_i)`.

        .. warning::
            This notion is only available if the history mechanism of the model is
            activated (see :class:`~openturns.MemoizeFunction`).

        See also
        --------
        drawImportanceFactors
        """
        return _experimental.ProbabilitySimulationResult_getImportanceFactors(self)

    def drawImportanceFactors(self):
        r"""
        Draw the importance factors.

        .. warning::
            It is necessary to enable the history of the model to perform this analysis
            (see :class:`~openturns.MemoizeFunction`).

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Importance factor graph.

        See also
        --------
        getImportanceFactors
        """
        return _experimental.ProbabilitySimulationResult_drawImportanceFactors(self)

    def getConfidenceLength(self, *args):
        r"""
        Accessor to the confidence length.

        Parameters
        ----------
        level : float, :math:`level \in ]0, 1[`
            Confidence level. By default, it is :math:`0.95`.

        Returns
        -------
        confidenceLength : float
            Length of the confidence interval at the confidence level *level*.
        """
        return _experimental.ProbabilitySimulationResult_getConfidenceLength(self, *args)

    def __repr__(self):
        return _experimental.ProbabilitySimulationResult___repr__(self)

    def __init__(self, *args):
        _experimental.ProbabilitySimulationResult_swiginit(self, _experimental.new_ProbabilitySimulationResult(*args))
    __swig_destroy__ = _experimental.delete_ProbabilitySimulationResult

# Register ProbabilitySimulationResult in _experimental:
_experimental.ProbabilitySimulationResult_swigregister(ProbabilitySimulationResult)
class SimulationAlgorithm(openturns.common.PersistentObject):
    r"""
    Base class for simulation algorithms.

    See also
    --------
    ProbabilitySimulationAlgorithm, ExpectationSimulationAlgorithm
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SimulationAlgorithm_getClassName(self)

    def setMaximumOuterSampling(self, maximumOuterSampling):
        r"""
        Accessor to the maximum iterations number.

        Parameters
        ----------
        outerSampling : int
            Maximum number of iterations, each iteration performing a block of evaluations.
        """
        return _experimental.SimulationAlgorithm_setMaximumOuterSampling(self, maximumOuterSampling)

    def getMaximumOuterSampling(self):
        r"""
        Accessor to the maximum iterations number.

        Returns
        -------
        outerSampling : int
            Maximum number of iterations, each iteration performing a block of evaluations.
        """
        return _experimental.SimulationAlgorithm_getMaximumOuterSampling(self)

    def setMaximumCoefficientOfVariation(self, maximumCoefficientOfVariation):
        r"""
        Accessor to the maximum coefficient of variation.

        Parameters
        ----------
        coefficient : float
            Maximum coefficient of variation of the simulated sample.
        """
        return _experimental.SimulationAlgorithm_setMaximumCoefficientOfVariation(self, maximumCoefficientOfVariation)

    def getMaximumCoefficientOfVariation(self):
        r"""
        Accessor to the maximum coefficient of variation.

        Returns
        -------
        coefficient : float
            Maximum coefficient of variation of the simulated sample.
        """
        return _experimental.SimulationAlgorithm_getMaximumCoefficientOfVariation(self)

    def setMaximumStandardDeviation(self, maximumStandardDeviation):
        r"""
        Accessor to the maximum standard deviation.

        Parameters
        ----------
        sigma : float, :math:`\sigma > 0`
            Maximum standard deviation of the estimator.
        """
        return _experimental.SimulationAlgorithm_setMaximumStandardDeviation(self, maximumStandardDeviation)

    def getMaximumStandardDeviation(self):
        r"""
        Accessor to the maximum standard deviation.

        Returns
        -------
        sigma : float, :math:`\sigma > 0`
            Maximum standard deviation of the estimator.
        """
        return _experimental.SimulationAlgorithm_getMaximumStandardDeviation(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 1`
            Number of simultaneous evaluations of the limit-state function.
            It is set by default to 1.

        Notes
        -----
        If the function supports batch evaluations this parameter can be set to the number
        of available CPUs to benefit from parallel execution (multithreading, multiprocessing, ...);
        except for the Directional Sampling, where we recommend to set it to 1.
        It also decides the frequency of the stopping criteria and progress callbacks update
        as they are called once the whole block of fonction evaluations is completed.

        """
        return _experimental.SimulationAlgorithm_setBlockSize(self, blockSize)

    def getBlockSize(self):
        r"""
        Accessor to the block size.

        Returns
        -------
        blockSize : int
            Number of simultaneous evaluations of the limit-state function.
            It is set by default to 1.
        """
        return _experimental.SimulationAlgorithm_getBlockSize(self)

    def __repr__(self):
        return _experimental.SimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.SimulationAlgorithm_run(self)

    def setConvergenceStrategy(self, convergenceStrategy):
        r"""
        Accessor to the convergence strategy.

        Parameters
        ----------
        storage_strategy : :class:`~openturns.HistoryStrategy`
            Storage strategy used to store the values of the probability estimator
            and its variance during the simulation algorithm.
        """
        return _experimental.SimulationAlgorithm_setConvergenceStrategy(self, convergenceStrategy)

    def getConvergenceStrategy(self):
        r"""
        Accessor to the convergence strategy.

        Returns
        -------
        storage_strategy : :class:`~openturns.HistoryStrategy`
            Storage strategy used to store the values of the probability estimator
            and its variance during the simulation algorithm.
        """
        return _experimental.SimulationAlgorithm_getConvergenceStrategy(self)

    def setMaximumTimeDuration(self, maximumTimeDuration):
        r"""
        Accessor to the maximum duration.

        Parameters
        ----------
        maximumTimeDuration : float
            Maximum optimization duration in seconds.
        """
        return _experimental.SimulationAlgorithm_setMaximumTimeDuration(self, maximumTimeDuration)

    def getMaximumTimeDuration(self):
        r"""
        Accessor to the maximum duration.

        Returns
        -------
        maximumTimeDuration : float
            Maximum optimization duration in seconds.
        """
        return _experimental.SimulationAlgorithm_getMaximumTimeDuration(self)

    def __init__(self, *args):
        _experimental.SimulationAlgorithm_swiginit(self, _experimental.new_SimulationAlgorithm(*args))

    def setProgressCallback(self, *args):
        r"""
        Set up a progress callback.

        Can be used to programmatically report the progress of a simulation.

        Parameters
        ----------
        callback : callable
            Takes a float as argument as percentage of progress.

        Examples
        --------
        >>> import sys
        >>> import openturns as ot
        >>> experiment = ot.MonteCarloExperiment()
        >>> X = ot.RandomVector(ot.Normal())
        >>> Y = ot.CompositeRandomVector(ot.SymbolicFunction(['X'], ['1.1*X']), X)
        >>> event = ot.ThresholdEvent(Y, ot.Less(), -2.0)
        >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
        >>> algo.setMaximumOuterSampling(100)
        >>> algo.setMaximumCoefficientOfVariation(-1.0)
        >>> def report_progress(progress):
        ...     sys.stderr.write('-- progress=' + str(progress) + '%\n')
        >>> algo.setProgressCallback(report_progress)
        >>> algo.run()
        """
        return _experimental.SimulationAlgorithm_setProgressCallback(self, *args)

    def setStopCallback(self, *args):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop a simulation.

        Parameters
        ----------
        callback : callable
            Returns an int deciding whether to stop or continue.
        """
        return _experimental.SimulationAlgorithm_setStopCallback(self, *args)
    __swig_destroy__ = _experimental.delete_SimulationAlgorithm

# Register SimulationAlgorithm in _experimental:
_experimental.SimulationAlgorithm_swigregister(SimulationAlgorithm)
class EventSimulation(SimulationAlgorithm):
    r"""
    Base class for sampling methods.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        The event we are computing the probability of.
    convergenceStrategy : :class:`~openturns.HistoryStrategy`, optional
        Storage strategy used to store the values of the probability estimator and
        its variance during the simulation algorithm.

    Notes
    -----
    Base class for sampling methods, using the probability distribution of a random
    vector :math:`\vect{X}` to evaluate the failure probability:

    .. math::

        P_f = \int_{\Rset^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \leq 0 \}}f_{\uX}(\ux)\di{\ux}
            = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\}`.
    :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise.

    The EventSimulation object provides a generic simulation service for non-composite
    events, and its derived classes provide dedicated algorithms:

    - :class:`~openturns.ProbabilitySimulationAlgorithm`

    - :class:`~openturns.DirectionalSampling`

    - :class:`~openturns.PostAnalyticalControlledImportanceSampling`,

    - :class:`~openturns.PostAnalyticalImportanceSampling`,

    See also
    --------
    SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.EventSimulation_getClassName(self)

    def __init__(self, *args):
        _experimental.EventSimulation_swiginit(self, _experimental.new_EventSimulation(*args))

    def getEvent(self):
        r"""
        Accessor to the event.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _experimental.EventSimulation_getEvent(self)

    def getResult(self):
        r"""
        Accessor to the results.

        Returns
        -------
        results : :class:`~openturns.SimulationResult`
            Structure containing all the results obtained after simulation and created
            by the method :py:meth:`run`.
        """
        return _experimental.EventSimulation_getResult(self)

    def __repr__(self):
        return _experimental.EventSimulation___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        openturns.EventSimulation.setBlockSize
        openturns.EventSimulation.setMaximumOuterSampling
        openturns.ResourceMap
        openturns.SimulationResult
        """
        return _experimental.EventSimulation_run(self)

    def drawProbabilityConvergence(self, *args):
        r"""
        Draw the probability convergence at a given level.

        Parameters
        ----------
        level : float, optional
            The probability convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            probability convergence graph
        """
        return _experimental.EventSimulation_drawProbabilityConvergence(self, *args)
    __swig_destroy__ = _experimental.delete_EventSimulation

# Register EventSimulation in _experimental:
_experimental.EventSimulation_swigregister(EventSimulation)
class ProbabilitySimulationAlgorithm(EventSimulation):
    r"""
    Iterative sampling methods.

    Refer to :ref:`monte_carlo_simulation`, :ref:`importance_simulation`, :ref:`lhs_simulation`, :ref:`qmc_simulation`.

    Available constructor:
        ProbabilitySimulationAlgorithm(*event, experiment, convergenceStrategy=ot.Compact()*)

        ProbabilitySimulationAlgorithm(*event, convergenceStrategy=ot.Compact()*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        The event we are computing the probability of, must be composite.
    experiment : :class:`~openturns.WeightedExperiment`
        Sequential experiment
    convergenceStrategy : :class:`~openturns.HistoryStrategy`, optional
        Storage strategy used to store the values of the probability estimator and
        its variance during the simulation algorithm.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event 

    .. math::

        \cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\} 

    If we have the set :math:`\left\{ \vect{x}_1,\ldots,\vect{x}_N \right\}` of
    :math:`N` independent samples of the random vector :math:`\vect{X}`, we can
    estimate :math:`\widehat{P}_f` as follows:

    .. math::

        \widehat{P}_{f,MC} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }

    where :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise;
    the idea here is in fact to estimate the required probability by the proportion
    of cases, among the :math:`N` samples of :math:`\vect{X}`, for which the event
    :math:`\cD_f` occurs.

    By the law of large numbers, we know that this estimation converges to the
    required value :math:`P_f` as the sample size :math:`N` tends to infinity.

    The Central Limit Theorem allows one to build an asymptotic confidence interval
    using the normal limit distribution as follows:

    .. math::

        \lim_{N\rightarrow\infty}\Prob{P_f\in[\widehat{P}_{f,\inf},\widehat{P}_{f,\sup}]}=\alpha

    with :math:`\widehat{P}_{f,\inf}=\widehat{P}_f - q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`,
    :math:`\widehat{P}_{f,\sup}=\widehat{P}_f + q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`
    and :math:`q_\alpha` is the :math:`(1+\alpha)/2`-quantile of the standard
    normal distribution.


    A ProbabilitySimulationAlgorithm object makes sense with the following sequential experiments:

    - :class:`~openturns.MonteCarloExperiment`

    - :class:`~openturns.ImportanceSamplingExperiment`

    - :class:`~openturns.LowDiscrepancyExperiment`

    - :class:`~openturns.LHSExperiment`

    The estimator built by Monte Carlo method is:

    .. math::

        \widehat{P}_{f,MC} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }

    where :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise;
    the idea here is in fact to estimate the required probability by the proportion
    of cases, among the :math:`N` samples of :math:`\vect{X}`, for which the event
    :math:`\cD_f` occurs.

    By the law of large numbers, we know that this estimation converges to the
    required value :math:`P_f` as the sample size :math:`N` tends to infinity.

    The Central Limit Theorem allows one to build an asymptotic confidence interval
    using the normal limit distribution as follows:

    .. math::

        \lim_{N\rightarrow\infty}\Prob{P_f\in[\widehat{P}_{f,\inf},\widehat{P}_{f,\sup}]}=\alpha

    with :math:`\widehat{P}_{f,\inf}=\widehat{P}_f - q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`,
    :math:`\widehat{P}_{f,\sup}=\widehat{P}_f + q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`
    and :math:`q_\alpha` is the :math:`(1+\alpha)/2`-quantile of the standard
    normal distribution.

    The estimator built by Importance Sampling method is:

    .. math::

        \widehat{P}_{f,IS} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{\{g(\vect{Y}_{\:i}),\vect{d}) \leq 0 \}}
                                          \frac{f_{\uX}(\vect{Y}_{\:i})}
                                               {f_{\vect{Y}}(\vect{Y}_{\:i})}


    where:

    - :math:`N` is the total number of computations,

    - the random vectors :math:`\{\vect{Y}_i, i=1\hdots N\}` are independent,
      identically distributed and following the probability density function
      :math:`f_{\uY}`.


    See also
    --------
    EventSimulation

    Examples
    --------
    Estimate a probability by Monte Carlo

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.CompositeRandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> event = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> # We create a Monte Carlo algorithm
    >>> experiment = ot.MonteCarloExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.140000

    Estimate a probability by Importance Sampling

    >>> ot.RandomGenerator.SetSeed(0)
    >>> # assume we obtained a design point from FORM
    >>> standardSpaceDesignPoint = [-0.0310363,0.841879,0.445462,-0.332318]
    >>> standardEvent = ot.StandardEvent(event)
    >>> importanceDensity = ot.Normal(standardSpaceDesignPoint, ot.CovarianceMatrix(4))
    >>> experiment = ot.ImportanceSamplingExperiment(importanceDensity)
    >>> algo = ot.ProbabilitySimulationAlgorithm(standardEvent, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.153315

    Estimate a probability by Quasi Monte Carlo

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LowDiscrepancyExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.141667

    Estimate a probability by Randomized Quasi Monte Carlo

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LowDiscrepancyExperiment()
    >>> experiment.setRandomize(True)
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.160000

    Estimate a probability by Randomized LHS

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment()
    >>> experiment.setAlwaysShuffle(True)
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.140000
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ProbabilitySimulationAlgorithm_getClassName(self)

    def __init__(self, *args):
        _experimental.ProbabilitySimulationAlgorithm_swiginit(self, _experimental.new_ProbabilitySimulationAlgorithm(*args))

    def getExperiment(self):
        r"""
        Accessor to the experiment.

        Returns
        -------
        experiment : :class:`~openturns.WeightedExperiment`
            The experiment that is sampled at each iteration.
        """
        return _experimental.ProbabilitySimulationAlgorithm_getExperiment(self)

    def setExperiment(self, experiment):
        r"""
        Accessor to the experiment.

        Parameters
        ----------
        experiment : :class:`~openturns.WeightedExperiment`
            The experiment that is sampled at each iteration.
        """
        return _experimental.ProbabilitySimulationAlgorithm_setExperiment(self, experiment)

    def __repr__(self):
        return _experimental.ProbabilitySimulationAlgorithm___repr__(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 1`
            Number of simultaneous evaluations of the limit-state function.
            It is set by default to 1.

        Notes
        -----
        If the function supports batch evaluations this parameter can be set to the number
        of available CPUs to benefit from parallel execution (multithreading, multiprocessing, ...);
        except for the Directional Sampling, where we recommend to set it to 1.
        It also decides the frequency of the stopping criteria and progress callbacks update
        as they are called once the whole block of fonction evaluations is completed.

        """
        return _experimental.ProbabilitySimulationAlgorithm_setBlockSize(self, blockSize)
    __swig_destroy__ = _experimental.delete_ProbabilitySimulationAlgorithm

# Register ProbabilitySimulationAlgorithm in _experimental:
_experimental.ProbabilitySimulationAlgorithm_swigregister(ProbabilitySimulationAlgorithm)
class PostAnalyticalSimulation(EventSimulation):
    r"""
    Post analytical simulation.

    See also
    --------
    PostAnalyticalImportanceSampling, PostAnalyticalControlledImportanceSampling

    Notes
    -----
    This class inherits from EventSimulation.

    The principle is to perform a simulation study to evaluate the threshold
    exceedance probability according to an importance density centered around the
    design point, in the standard space. The importance distribution is the standard
    distribution of the standard space.

    A PostAnalyticalSimulation object can be created only through its derivative
    classes : :class:`~openturns.PostAnalyticalImportanceSampling` or
    :class:`~openturns.PostAnalyticalControlledImportanceSampling`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PostAnalyticalSimulation_getClassName(self)

    def getAnalyticalResult(self):
        r"""
        Accessor to the analytical result.

        Returns
        -------
        result : :class:`~openturns.AnalyticalResult`
            Result of the analytical study which has been performed just before the 
            simulation study centered around the importance factor.
        """
        return _experimental.PostAnalyticalSimulation_getAnalyticalResult(self)

    def getControlProbability(self):
        r"""
        Accessor to the control probability.

        Returns
        -------
        p : float,
            The probability of the analytical result.

        Notes
        -----
        The control probability :math:`p` is deduced from the corresponding analytical result:

        .. math::

            p = E(-\beta_{HL})

        where :math:`\beta_{HL}` denotes the Hasofer reliability index and :math:`E`
        the univariate standard CDF of the elliptical distribution in the standard space.
        """
        return _experimental.PostAnalyticalSimulation_getControlProbability(self)

    def __repr__(self):
        return _experimental.PostAnalyticalSimulation___repr__(self)

    def __init__(self, *args):
        _experimental.PostAnalyticalSimulation_swiginit(self, _experimental.new_PostAnalyticalSimulation(*args))
    __swig_destroy__ = _experimental.delete_PostAnalyticalSimulation

# Register PostAnalyticalSimulation in _experimental:
_experimental.PostAnalyticalSimulation_swigregister(PostAnalyticalSimulation)
class Wilks(openturns.common.Object):
    r"""
    Class to estimate a confidence interval on a quantile.

    Refer to :ref:`quantile_confidence_estimation`.

    Parameters
    ----------
    X : :class:`~openturns.RandomVector`,
        A random vector of dimension 1.

    Notes
    -----
    This static class estimates an upper bound of the quantile of level :math:`\alpha \in [0,1]` of the random variable :math:`X`
    with a confidence greater than :math:`\beta`, using a given order statistics.

    Let :math:`x_{\alpha}` be the unknown quantile of level :math:`\alpha` of the random variable :math:`X` of dimension 1.
    Let :math:`(X_1, \dots, X_\sampleSize)` be a sample of independent and identically distributed variables according to :math:`X`.
    Let :math:`X_{(k)}` be the :math:`k` -th order statistics of :math:`(X_1, \dots, X_\sampleSize)` which means that
    :math:`X_{(k)}` is the :math:`k` -th maximum of :math:`(X_1, \dots, X_\sampleSize)` for :math:`1 \leq k \leq \sampleSize`.
    For example, :math:`X_{(1)} = \min (X_1, \dots, X_\sampleSize)` is the minimum
    and :math:`X_{(\sampleSize)} = \max (X_1, \dots, X_\sampleSize)` is the maximum. We have:

    .. math::

        X_{(1)} \leq X_{(2)} \leq \dots \leq X_{(\sampleSize)}

    Given :math:`\alpha`, :math:`\beta` and :math:`i`, the class estimates the minimal size :math:`\sampleSize` such that:

    .. math::

        \Prob{x_{\alpha} \leq X_{(\sampleSize-i)}} \geq \beta

    Once the minimal size :math:`\sampleSize`  has been estimated, a sample of size :math:`\sampleSize` can be generated from
    :math:`X` and an upper bound of :math:`x_{\alpha}` is estimated by the value of the :math:`X_{(\sampleSize-i)}` on the sample.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex=0):
        r"""
        Evaluate the minimum size of the sample.

        Parameters
        ----------
        alpha : positive float in :math:`[0,1)`
            The level :math:`\alpha` of the quantile.
        beta : positive float in :math:`[0,1)`,
            The confidence level on the upper bound.
        i : int
            The index such that :math:`X_{(\sampleSize -i)}` is an upper bound of :math:`x_{\alpha}`
            with confidence :math:`\beta`.
            Default value is :math:`i = 0`.

        Returns
        -------
        n : int,
            The minimum size of the sample.

        Notes
        -----
        The minimum sample size :math:`\sampleSize` is such that:

        .. math::

            \Prob{x_{\alpha} \leq X_{(\sampleSize-i)}} \geq \beta

        """
        return _experimental.Wilks_ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex)

    def computeQuantileBound(self, quantileLevel, confidenceLevel, marginIndex=0):
        r"""
        Evaluate an upper bound of a quantile.

        Parameters
        ----------
        alpha : positive float in :math:`[0,1)`
            The level :math:`\alpha` of the quantile.
        beta : positive float in :math:`[0,1)`
            The confidence level on the upper bound.
        i : int
            The index such that :math:`X_{(\sampleSize -i)}` is an upper bound of :math:`x_{\alpha}`
            with confidence level :math:`\beta`.
            Default value is :math:`i = 0`.

        Returns
        -------
        upperBound : :class:`~openturns.Point`
            The estimate of the quantile upper bound.

        Notes
        -----
        The method starts by evaluating the minimum sample size :math:`\sampleSize` such that:

        .. math::

            \Prob{x_{\alpha} \leq X_{(\sampleSize-i)}} \geq \beta

        Then, it generates a sample of size  :math:`\sampleSize` from the random vector :math:`X`. The upper bound of :math:`x_{\alpha}`
        is :math:`x_{(\sampleSize-i)}`, that is, the :math:`\sampleSize - i`-th observation in the ordered sample.

        """
        return _experimental.Wilks_computeQuantileBound(self, quantileLevel, confidenceLevel, marginIndex)

    def __init__(self, *args):
        _experimental.Wilks_swiginit(self, _experimental.new_Wilks(*args))
    __swig_destroy__ = _experimental.delete_Wilks

# Register Wilks in _experimental:
_experimental.Wilks_swigregister(Wilks)
class PostAnalyticalControlledImportanceSampling(PostAnalyticalSimulation):
    r"""
    Post analytical controlled importance sampling.

    Importance sampling algorithm around the design point, controlled by
    the tangent hyperplane.

    Parameters
    ----------
    analyticalResult : :class:`~openturns.AnalyticalResult`
        Result structure.

    Notes
    -----
    Let :math:`\inputRV` be a random vector of dimension :math:`\inputDim`, distributed according to
    the measure :math:`\inputMeasure`, and :math:`\model: \Rset^\inputDim \rightarrow \Rset`
    be the *limit state function* (where we only wrote the random input parameters). We define the event
    :math:`\cD_f` by:

    .. math::

        \cD_f = \{\vect{x} \in \Rset^{\inputDim} \, | \,\model(\vect{x}) \leq 0\}

    The post analytical controlled importance sampling algorithm estimates the probability of the domain :math:`\cD_f`:

    .. math::

        P_f = \Prob{\model\left( \inputRV \right) \leq 0}
            = \int_{\Rset^{\inputDim}} \mathbf{1}_{\{\model(\vect{x}) \leq 0 \}}\inputMeasure(\vect{x})\di{\vect{x}}


    The post analytical controlled importance sampling algorithm is  a variance reduction sampling
    method, which is
    performed in the standard space, where the random vector follows a spherical distribution (see
    :ref:`isoprobabilistic_transformation` to get more details).
    It is an additive correction of the :class:`~openturns.FORM` approximation of the probability
    :math:`P_f`. See
    :class:`~openturns.Analytical` for the description of the first steps of the FORM analysis.

    Let :math:`\ell` be the function defined by: 

    .. math::

        \ell(\vect{u}) = \vect{u}^*.\vect{u} - \beta^2

    where :math:`\vect{u}^*` is the design point in the standard space, and :math:`\beta` the distance
    of the design point from the origin of the standard space: :math:`\beta = \| \vect{u}^*\|`.

    The tangent hyperplane at the design point in the standard space is defined by the equation:

    .. math::

        \{ \vect{u} \in \Rset^{\inputDim} \, | \,  \ell(\vect{u}) = 0 \}

    Let :math:`G: \Rset^\inputDim \rightarrow \Rset` be the model in the standard space: if :math:`T` is the iso-probabilistic
    transformation such that :math:`T(\vect{X}) = \vect{U}`, then:

    .. math::

       G(\vect{u}) = \model \circ T^{-1}(\vect{u})

    Let :math:`\cD_f^{std}` be the domain :math:`\cD_f` in the standard space. We assume that the domain
    :math:`\cD_f^{std}` does not contain the origin of the standard space. Thus, it is defined by:

    .. math::

        \cD_f^{std} & = \{\vect{u} \in \Rset^{\inputDim} \, | \,   G(\vect{u}) \leq 0  \} \\
              & = \{\vect{u} \in \Rset^{\inputDim} \, | \,   \ell(\vect{u}) \geq 0  \} \cup
              \{\vect{u} \in \Rset^{\inputDim} \, | \,   \ell(\vect{u}) \leq 0 , G(\vect{u}) \leq 0 \}
              \setminus
              \{\vect{u} \in \Rset^{\inputDim} \, | \,   \ell(\vect{u}) \geq 0 , G(\vect{u}) \geq 0 \}

    Thus, we have:

    .. math::

        P_f & = \Prob{\ell(\vect{U}) \geq 0} + \Prob{\ell(\vect{U}) \leq 0,  G(\RVU) \leq 0} -
        \Prob{\ell(\vect{U}) \geq 0,  G(\RVU) \geq 0}\\
            & = \Prob{\ell(\vect{U}) \geq 0} + \delta_1 - \delta_2

    where :math:`\Prob{\ell(\vect{U} \geq 0} = E(-\beta)` is known exactly. :math:`E` is the univariate
    standard CDF of the spherical distribution in the standard space.

    If :math:`\delta_1 \ll \Prob{\ell(\vect{U} \geq 0}`
    and :math:`\delta_2 \ll \Prob{\ell(\vect{U} \geq 0}`, then we use :math:`\ell(\vect{U})` as a
    controlled
    variable and we use an importance sampling around the design point in the standard space.

    We denote by :math:`(\vect{u}_i)_{1 \leq i \leq \sampleSize}` a sample generated from the spherical
    distribution
    centered on the origin of the standard space, whose pdf is denoted by :math:`e`. Let :math:`e^*` be
    the pdf of the
    spherical distribution centered on the design point :math:`\vect{u}^*`.

    The estimate of :math:`P_f` is defined by:

    .. math::

        \tilde{P}_f & =  E(-\beta) + \tilde{\delta}_1 - \tilde{\delta}_2\\
                    & = E(-\beta) + \dfrac{1}{\sampleSize} \sum_{i=1}^\sampleSize \left( 1_{ \left \{ \ell(\vect{u})_i \leq 0,
        G(\vect{u}_i)  \leq 0 \right\} } - 1_{ \left \{ \ell(\vect{u})_i \geq 0,  G(\vect{u}_i)  \geq
        0\right \} } \right) \dfrac{e(\vect{u}_i)}{e^*(\vect{u}_i)}

    The hypotheses :math:`\delta_1 \ll \Prob{\ell(\vect{U} \geq 0}`
    and :math:`\delta_2 \ll \Prob{\ell(\vect{U} \geq 0}` are verified if the FORM
    approximation is valid.

    The coefficient of variation of :math:`\tilde{P}_f` is:

    .. math::

        \Cov{\tilde{P}_f}  = \dfrac{ \sqrt{ \Var{ \tilde{P}_f}}}{\Expect{\tilde{P}_f}} 
                          = \dfrac{ \sqrt{ \Var{ \tilde{\delta}_1 - \tilde{\delta}_2 } }}
                         { E(-\beta) + \Expect{\tilde{\delta}_1 - \tilde{\delta}_2} } \ll  \dfrac{ \sqrt{ \Var{ \tilde{\delta}_1 - \tilde{\delta}_2 } } } {\Expect{\tilde{\delta}_1 - \tilde{\delta}_2}}

    See also
    --------
    PostAnalyticalImportanceSampling

    Examples
    --------
    >>> import openturns as ot

    Create the output random vector :math:`Y = \model(\inputRV)`:

    >>> f = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> X = ot.RandomVector(distribution)
    >>> Y = ot.CompositeRandomVector(f, X)

    Create the event :math:`\cD_f = \{\vect{x} \in \Rset^{\inputDim} \, | \,\model(\vect{x}) \leq -3.0\}`:

    >>> event = ot.ThresholdEvent(Y, ot.Less(), -3.0)

    Create the FORM algorithm and launch it:

    >>> solver = ot.AbdoRackwitz()
    >>> solver.setStartingPoint(distribution.getMean())
    >>> analytical = ot.FORM(solver, event)
    >>> analytical.run()
    >>> analyticalResult = analytical.getResult()

    Create the post analytical importance sampling algorithm and launch it:

    >>> algo = ot.PostAnalyticalControlledImportanceSampling(analyticalResult)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> pf = result.getProbabilityEstimate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PostAnalyticalControlledImportanceSampling_getClassName(self)

    def __repr__(self):
        return _experimental.PostAnalyticalControlledImportanceSampling___repr__(self)

    def __init__(self, *args):
        _experimental.PostAnalyticalControlledImportanceSampling_swiginit(self, _experimental.new_PostAnalyticalControlledImportanceSampling(*args))
    __swig_destroy__ = _experimental.delete_PostAnalyticalControlledImportanceSampling

# Register PostAnalyticalControlledImportanceSampling in _experimental:
_experimental.PostAnalyticalControlledImportanceSampling_swigregister(PostAnalyticalControlledImportanceSampling)
class PostAnalyticalImportanceSampling(PostAnalyticalSimulation):
    r"""
    Post analytical importance sampling.

    Simulation method where the original distribution is replaced by the
    distribution in the standard space centered around the provided design point.

    This method, based on importance sampling, uses a normal instrumental 
    distribution in the standard space (see [lemaire2009]_ page 255, [melchers1990]_).

    Parameters
    ----------
    analyticalResult : :class:`~openturns.AnalyticalResult`
        Result which contains the whole information on the analytical study
        performed before the simulation study: in particular, the standard
        distribution of the standard space and the standard space design point.

    See also
    --------
    PostAnalyticalControlledImportanceSampling, NAIS, CrossEntropyImportanceSampling

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> X = ot.RandomVector(distribution)
    >>> Y = ot.CompositeRandomVector(f, X)
    >>> event = ot.ThresholdEvent(Y, ot.Less(), -3.0)
    >>> solver = ot.AbdoRackwitz()
    >>> solver.setStartingPoint(distribution.getMean())
    >>> analytical = ot.FORM(solver, event)
    >>> analytical.run()
    >>> analyticalResult = analytical.getResult()
    >>> algo = ot.PostAnalyticalImportanceSampling(analyticalResult)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> pf = result.getProbabilityEstimate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PostAnalyticalImportanceSampling_getClassName(self)

    def __repr__(self):
        return _experimental.PostAnalyticalImportanceSampling___repr__(self)

    def __init__(self, *args):
        _experimental.PostAnalyticalImportanceSampling_swiginit(self, _experimental.new_PostAnalyticalImportanceSampling(*args))
    __swig_destroy__ = _experimental.delete_PostAnalyticalImportanceSampling

# Register PostAnalyticalImportanceSampling in _experimental:
_experimental.PostAnalyticalImportanceSampling_swigregister(PostAnalyticalImportanceSampling)
class RootStrategyImplementation(openturns.common.PersistentObject):
    r"""
    Base class for root strategies.

    *RootStrategy* is used through its derived classes:

    - :class:`~openturns.SafeAndSlow`

    - :class:`~openturns.RiskyAndFast`

    - :class:`~openturns.MediumSafe`

    See also
    --------
    DirectionalSampling
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.RootStrategyImplementation_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental.RootStrategyImplementation_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental.RootStrategyImplementation_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental.RootStrategyImplementation_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategyImplementation_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategyImplementation_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategyImplementation_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategyImplementation_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental.RootStrategyImplementation_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental.RootStrategyImplementation_getOriginValue(self)

    def __repr__(self):
        return _experimental.RootStrategyImplementation___repr__(self)

    def __init__(self, *args):
        _experimental.RootStrategyImplementation_swiginit(self, _experimental.new_RootStrategyImplementation(*args))
    __swig_destroy__ = _experimental.delete_RootStrategyImplementation

# Register RootStrategyImplementation in _experimental:
_experimental.RootStrategyImplementation_swigregister(RootStrategyImplementation)
class _RootStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _experimental._RootStrategyImplementationTypedInterfaceObject_swiginit(self, _experimental.new__RootStrategyImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _experimental._RootStrategyImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experimental._RootStrategyImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experimental._RootStrategyImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _experimental._RootStrategyImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _experimental._RootStrategyImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _experimental.delete__RootStrategyImplementationTypedInterfaceObject

# Register _RootStrategyImplementationTypedInterfaceObject in _experimental:
_experimental._RootStrategyImplementationTypedInterfaceObject_swigregister(_RootStrategyImplementationTypedInterfaceObject)
class RootStrategy(_RootStrategyImplementationTypedInterfaceObject):
    r"""
    Base class for root strategies.

    *RootStrategy* is used through its derived classes:

    - :class:`~openturns.SafeAndSlow`

    - :class:`~openturns.RiskyAndFast`

    - :class:`~openturns.MediumSafe`

    See also
    --------
    DirectionalSampling
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.RootStrategy_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental.RootStrategy_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental.RootStrategy_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental.RootStrategy_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategy_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategy_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategy_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategy_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental.RootStrategy_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental.RootStrategy_getOriginValue(self)

    def __repr__(self):
        return _experimental.RootStrategy___repr__(self)

    def __init__(self, *args):
        _experimental.RootStrategy_swiginit(self, _experimental.new_RootStrategy(*args))
    __swig_destroy__ = _experimental.delete_RootStrategy

# Register RootStrategy in _experimental:
_experimental.RootStrategy_swigregister(RootStrategy)
class SamplingStrategyImplementation(openturns.common.PersistentObject):
    r"""
    Base class for directions sampling strategies.

    Parameters
    ----------
    dimension : int
        The dimension of the standard space.

        By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    RandomDirection, OrthogonalDirection
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SamplingStrategyImplementation_getClassName(self)

    def generate(self):
        r"""
        Generate the directions.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The directions generated  according to the sampling strategy.

        Notes
        -----
        The sample is the collection of the points on the unit sphere in the standard space
        associated to the generated directions.
        """
        return _experimental.SamplingStrategyImplementation_generate(self)

    def getUniformUnitVectorRealization(self, *args):
        r"""
        Accessor to a realization according to the uniform distribution.

        Parameters
        ----------
        dimension : int
            The dimension of the sphere unity (which is the dimension of the standard
            space).

        Returns
        -------
        sample : :class:`~openturns.Point`
            The realization of a vector on the sphere unity, according to the uniform
            distribution.
        """
        return _experimental.SamplingStrategyImplementation_getUniformUnitVectorRealization(self, *args)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental.SamplingStrategyImplementation_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental.SamplingStrategyImplementation_getDimension(self)

    def __repr__(self):
        return _experimental.SamplingStrategyImplementation___repr__(self)

    def __init__(self, *args):
        _experimental.SamplingStrategyImplementation_swiginit(self, _experimental.new_SamplingStrategyImplementation(*args))
    __swig_destroy__ = _experimental.delete_SamplingStrategyImplementation

# Register SamplingStrategyImplementation in _experimental:
_experimental.SamplingStrategyImplementation_swigregister(SamplingStrategyImplementation)
class _SamplingStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _experimental._SamplingStrategyImplementationTypedInterfaceObject_swiginit(self, _experimental.new__SamplingStrategyImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _experimental._SamplingStrategyImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experimental._SamplingStrategyImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experimental._SamplingStrategyImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _experimental._SamplingStrategyImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _experimental._SamplingStrategyImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _experimental.delete__SamplingStrategyImplementationTypedInterfaceObject

# Register _SamplingStrategyImplementationTypedInterfaceObject in _experimental:
_experimental._SamplingStrategyImplementationTypedInterfaceObject_swigregister(_SamplingStrategyImplementationTypedInterfaceObject)
class SamplingStrategy(_SamplingStrategyImplementationTypedInterfaceObject):
    r"""
    Base class for directions sampling strategies.

    Parameters
    ----------
    dimension : int
        The dimension of the standard space.

        By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    RandomDirection, OrthogonalDirection
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SamplingStrategy_getClassName(self)

    def generate(self):
        r"""
        Generate the directions.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The directions generated  according to the sampling strategy.

        Notes
        -----
        The sample is the collection of the points on the unit sphere in the standard space
        associated to the generated directions.
        """
        return _experimental.SamplingStrategy_generate(self)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental.SamplingStrategy_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental.SamplingStrategy_getDimension(self)

    def __repr__(self):
        return _experimental.SamplingStrategy___repr__(self)

    def __init__(self, *args):
        _experimental.SamplingStrategy_swiginit(self, _experimental.new_SamplingStrategy(*args))
    __swig_destroy__ = _experimental.delete_SamplingStrategy

# Register SamplingStrategy in _experimental:
_experimental.SamplingStrategy_swigregister(SamplingStrategy)
class DirectionalSampling(EventSimulation):
    r"""
    Directional sampling algorithm.

    Refer to :ref:`directional_simulation`.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.
    rootStrategy : :class:`~openturns.RootStrategy`, optional
        Strategy used to evaluate the frontiers of
        the event along each direction in the standard space.
        By default :class:`~openturns.SafeAndSlow`.
    samplingStrategy : :class:`~openturns.SamplingStrategy`, optional
        Strategy used to sample directions in the standard space.
        By default :class:`~openturns.RandomDirection`.

    Notes
    -----
    Let :math:`\inputRV` be a random vector of dimension :math:`\inputDim`, distributed according to
    the measure :math:`\inputMeasure`, and :math:`\model: \Rset^\inputDim \rightarrow \Rset`
    be the *limit state function* (where we only wrote the random input parameters).
    We define the event :math:`\cD_f` by:

    .. math::

        \cD_f = \{\vect{x} \in \Rset^{\inputDim} \, | \,\model(\vect{x}) \leq 0\}

    The directional sampling algorithm estimates the probability of the event :math:`\cD_f`:

    .. math::

        P_f = \Prob{\model\left( \inputRV \right) \leq 0}
            = \int_{\Rset^{\inputDim}} \mathbf{1}_{\{\model(\vect{x}) \leq 0 \}}\inputMeasure(\vect{x})\di{\vect{x}}


    The directional sampling algorithm is a variance reduction sampling method.
    As it is performed in the standard space, it uses the iso-probabilistic transformation associated to :math:`\inputMeasure`
    (see :ref:`isoprobabilistic_transformation` for details).

    Let :math:`T` be the iso-probabilistic transformation: :math:`T(\vect{X}) = \vect{Z}`. The
    random vector :math:`\vect{Z}` follows a spherical distribution, which means that it is written
    as:

    .. math::

        \vect{Z} = R \vect{U}

    where :math:`R` is a scalar random variable following the radial distribution, :math:`\vect{U}` is a random
    vector that follows the uniform distribution on the unit sphere of dimension :math:`\inputDim`,
    denoted by :math:`\cS_\inputDim`, and :math:`(R, \vect{U})` are independent.

    Then the probability :math:`P_f` can be written as:

    .. math::

        P_f & = \dfrac{1}{|\cS_\inputDim|} \int_{\cS_\inputDim} \left \{ \int_{\Rset^+} 1_{\left\{\model \circ T^{-1}(r\vect{u}) \leq 0 \right\}} p_R(r) dr \right\} \, d\vect{u} \\

    For a given direction :math:`\vect{u}`, let :math:`I_{\vect{u}}` be:

    .. math::

       I_{\vect{u}} = \{r \in \Rset^+ \, | \, \model \circ T^{-1}(r\vect{u})\leq 0 \}

    Then, we have:

    .. math::

        \int_{\Rset^+} 1_{\left\{\model \circ T^{-1}(r\vect{u}) \leq 0\right\}} p_R(r) dr = \Prob{R \in I_{\vect{u}}}

    As the radial distribution of :math:`R` is known, we can evaluate exactly the probability :math:`\Prob{R \in I_{\vect{u}}}`
    for any direction :math:`\vect{u}`.

    The integral with respect to the directions is evaluated using a sampling method, defined by the :class:`~openturns.SamplingStrategy`.

    The directional sampling algorithm follows the steps:

    - A sample :math:`(\vect{u}_i)` is generated in the standard space and projected in the hyperplane normal to the important direction,
      this point forms the origin of the line;

    - Along each direction :math:`i`, we find the frontiers of :math:`\cD_f`, i.e. the solutions
      of :math:`\model \circ T^{-1}(r\vect{u}_i) = 0` according to the :class:`~openturns.RootStrategy`.
      From these solutions, we deduce the subset :math:`I_i \subset \Rset^+` that belongs to
      :math:`\cD_f`;

    - For each subset :math:`I_i`, we compute the probability
      :math:`q_i = \Prob{R \in I_{\vect{u}_i}}`.

    The probability :math:`P_f` is computed from all the  :math:`q_i` probabilities. If :math:`N` directions have been used, then:

    .. math::

        \widehat{P}_{f,DS} = \frac{1}{N} \sum_{i=1}^N q_i

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)

    Create the output random vector :math:`Y = \model(\inputRV)`:

    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> input_RV = ot.RandomVector(myDistribution)
    >>> output_RV = ot.CompositeRandomVector(myFunction, input_RV)

    Create the event :math:`\cD_f = \{\vect{x} \in \Rset^{\inputDim} \, | \,\model(\vect{x}) \leq -3.0\}`:

    >>> threshold = -3.0
    >>> event = ot.ThresholdEvent(output_RV, ot.Less(), -3.0)

    Create the directional sampling algorithm and the convergence criteria: 

    >>> myAlgo = ot.DirectionalSampling(event, ot.MediumSafe(), ot.OrthogonalDirection())
    >>> myAlgo.setMaximumOuterSampling(150)
    >>> myAlgo.setBlockSize(4)
    >>> myAlgo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation

    Run the algorithm and extract the estimated probability:

    >>> myAlgo.run()
    >>> print('Probability estimate=%.6f' % myAlgo.getResult().getProbabilityEstimate())
    Probability estimate=0.169716
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.DirectionalSampling_getClassName(self)

    def setRootStrategy(self, rootStrategy):
        r"""
        Set the root strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy to evaluate the frontiers of
            the event along each direction in the standard space.
        """
        return _experimental.DirectionalSampling_setRootStrategy(self, rootStrategy)

    def getRootStrategy(self):
        r"""
        Get the root strategy.

        Returns
        -------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy used to evaluate the frontiers of
            the event along each direction in the standard space.
        """
        return _experimental.DirectionalSampling_getRootStrategy(self)

    def setSamplingStrategy(self, samplingStrategy):
        r"""
        Set the direction sampling strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy used
            to sample directions in the standard space.
        """
        return _experimental.DirectionalSampling_setSamplingStrategy(self, samplingStrategy)

    def getSamplingStrategy(self):
        r"""
        Get the direction sampling strategy.

        Returns
        -------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy used to sample
            directions in the standard space.
        """
        return _experimental.DirectionalSampling_getSamplingStrategy(self)

    def __repr__(self):
        return _experimental.DirectionalSampling___repr__(self)

    def __init__(self, *args):
        _experimental.DirectionalSampling_swiginit(self, _experimental.new_DirectionalSampling(*args))
    __swig_destroy__ = _experimental.delete_DirectionalSampling

# Register DirectionalSampling in _experimental:
_experimental.DirectionalSampling_swigregister(DirectionalSampling)
class OrthogonalDirection(SamplingStrategyImplementation):
    r"""
    Directions sampling following the orthogonal direction strategy.

    Parameters
    ----------
    dimension : int
        The dimension of the standard space.

        By default, :math:`dimension = 0` but automatically updated by the calling class.
    k : int
        The number of elements in the linear combinations.

        By default, :math:`k = 1` but automatically updated by the calling class.

    See also
    --------
    RandomDirection

    Notes
    -----
    The orthogonal direction strategy is parameterized by :math:`k \in \{1, \ldots, \inputDim\}`, where :math:`\inputDim` is
    the dimension of the standard space. We generate some directions in the standard space according to the following steps:

    - one direct orthonormalized basis :math:`(\vect{e}_1, \ldots, \vect{e}_\inputDim)` uniformly distributed in
      the set of direct orthonormal bases;
    - we consider all the normalized linear combinations of :math:`k` vectors chosen within the :math:`\inputDim` vectors
      of the basis, where the coefficients of the linear combinations are in :math:`\{+1, -1\}`.

    Thus, this process generates :math:`\binom{k}{\inputDim} 2^k` directions.

    If :math:`k = 1`, we consider all the axes of the space, i.e. :math:`\inputDim` directions.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.OrthogonalDirection_getClassName(self)

    def generate(self):
        r"""
        Generate the directions.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The :math:`\binom{k}{\inputDim} 2^k` directions generated according to the strategy.

        Notes
        -----
        The sample is the collection of the :math:`\binom{k}{\inputDim} 2^k` points on the unit sphere in the standard space
        associated to the generated directions.
        """
        return _experimental.OrthogonalDirection_generate(self)

    def __repr__(self):
        return _experimental.OrthogonalDirection___repr__(self)

    def __init__(self, *args):
        _experimental.OrthogonalDirection_swiginit(self, _experimental.new_OrthogonalDirection(*args))
    __swig_destroy__ = _experimental.delete_OrthogonalDirection

# Register OrthogonalDirection in _experimental:
_experimental.OrthogonalDirection_swigregister(OrthogonalDirection)
class RandomDirection(SamplingStrategyImplementation):
    r"""
    Directions sampling following the random direction strategy.

    Parameters
    ----------
    dimension : int
        The dimension of the standard space.

        By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    OrthogonalDirection

    Notes
    -----
    The random direction strategy generates some directions in the standard space according to the following steps:

    - we generate some points on the sphere unity in the standard space according to the uniform distribution,
    - we consider both opposite directions so built.

    Thus, this process generates 2 directions.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.RandomDirection_getClassName(self)

    def generate(self):
        r"""
        Generate the directions.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Both directions generated  according to the strategy.

        Notes
        -----
        The sample is the collection of the points on the unit sphere in the standard space
        associated to the generated directions.
        """
        return _experimental.RandomDirection_generate(self)

    def __repr__(self):
        return _experimental.RandomDirection___repr__(self)

    def __init__(self, *args):
        _experimental.RandomDirection_swiginit(self, _experimental.new_RandomDirection(*args))
    __swig_destroy__ = _experimental.delete_RandomDirection

# Register RandomDirection in _experimental:
_experimental.RandomDirection_swigregister(RandomDirection)
class MediumSafe(RootStrategyImplementation):
    r"""
    MediumSafe method.

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *MediumSafe* strategy is the following: for each direction, we go along the
    direction by step of length *stepSize* from the origin to the maximum distant
    point (at distance *maximumDistance* from the center of the standard space) and
    we check whether there is a sign changement on each segment so formed.

    At the first sign changement, we research one root in the concerned segment
    with the selected non linear solver. Then, the segment
    *[root, maximum distant point]* is considered within the failure space.

    If *stepSize* is small enough, this strategy guarantees us to find the root which
    is the nearest from the origin.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.MediumSafe_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental.MediumSafe_solve(self, function, value)

    def __repr__(self):
        return _experimental.MediumSafe___repr__(self)

    def __init__(self, *args):
        _experimental.MediumSafe_swiginit(self, _experimental.new_MediumSafe(*args))
    __swig_destroy__ = _experimental.delete_MediumSafe

# Register MediumSafe in _experimental:
_experimental.MediumSafe_swigregister(MediumSafe)
class RiskyAndFast(RootStrategyImplementation):
    r"""
    RiskyAndFast method.

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *RiskyAndFast* strategy is the following: for each direction, we check
    whether there is a sign changement of the standard limit state function between
    the maximum distant point (at distance *maximumDistance* from the center of the
    standard space) and the center of the standard space.

    In case of sign changement, we search one root in the segment
    *[origin, maximum distant point]* with the selected non linear solver.

    As soon as founded, the segment *[root, infinity point]* is considered within
    the failure space.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.RiskyAndFast_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental.RiskyAndFast_solve(self, function, value)

    def __repr__(self):
        return _experimental.RiskyAndFast___repr__(self)

    def __init__(self, *args):
        _experimental.RiskyAndFast_swiginit(self, _experimental.new_RiskyAndFast(*args))
    __swig_destroy__ = _experimental.delete_RiskyAndFast

# Register RiskyAndFast in _experimental:
_experimental.RiskyAndFast_swigregister(RiskyAndFast)
class SafeAndSlow(RootStrategyImplementation):
    r"""
    SafeAndSlow method.

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *SafeAndSlow* strategy is the following: for each direction, we go along
    the direction by step of length *stepSize* from the origin to the maximum
    distant point(at distance *maximumDistance* from the center of the standard
    space) and we check whether there is a sign changement on each segment so
    formed.

    We go until the maximum distant point. Then, for all the segments where we
    detected the presence of a root, we research the root with the selected non
    linear solver. We evaluate the contribution to the failure probability of each
    segment.

    If *stepSize* is small enough, this strategy guarantees us to find all the roots
    in the direction and the contribution of this direction to the failure
    probability is precisely evaluated.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SafeAndSlow_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental.SafeAndSlow_solve(self, function, value)

    def __repr__(self):
        return _experimental.SafeAndSlow___repr__(self)

    def __init__(self, *args):
        _experimental.SafeAndSlow_swiginit(self, _experimental.new_SafeAndSlow(*args))
    __swig_destroy__ = _experimental.delete_SafeAndSlow

# Register SafeAndSlow in _experimental:
_experimental.SafeAndSlow_swigregister(SafeAndSlow)
class SimulationSensitivityAnalysis(openturns.common.PersistentObject):
    r"""
    Class to perform a sensitivity analysis based on a reliability event.

    Available constructor:
        SimulationSensitivityAnalysis(*event, inputSample, outputSample*)

        SimulationSensitivityAnalysis(*event*)

        SimulationSensitivityAnalysis(*simulationRes*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        An event which it composite (test is with the method
        :meth:`isComposite <openturns.RandomVector.isComposite>`).
    inputSample, outputSample : 2-d sequence of float
        Input sample and output sample of a model evaluated apart.
    simulationRes : :class:`~openturns.ProbabilitySimulationResult`
        A simulation result.

    Notes
    -----
    The simulation sensitivity analysis is based on:

    - in the first usage, the *inputSample* and *outputSample* given:
    - in the second usage, the samples which have been stored by the function
      defining the event. Care if the sample is not a statistical sample: post
      treatment proposed by the object might not be right.
    - in the third usage, the samples generated by the
      :class:`~openturns.EventSimulation` that produced *simulationRes*.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SimulationSensitivityAnalysis_getClassName(self)

    def computeMeanPointInEventDomain(self, *args):
        r"""
        Accessor to the mean point.

        Returns
        -------
        mean : :class:`~openturns.Point`
            The mean point in the failure domain.

        Notes
        -----
        This method computes the mean point in the physical space of all the simulations
        generated by the simulation that failed into the event domain.

        Be careful: this notion is only valid for Monte Carlo or LHS sampling as the
        mean is evaluated from the equation :eq:`mean_point` (only uniform weights over
        the realizations :math:`\vect{X}_i`.
        """
        return _experimental.SimulationSensitivityAnalysis_computeMeanPointInEventDomain(self, *args)

    def computeImportanceFactors(self, *args):
        r"""
        Compute the importance factors.

        Returns
        -------
        impFactors : :class:`~openturns.PointWithDescription`
            The importance factors.

        Notes
        -----
        The importance factors, given in :eq:`importance_factor`, are evaluated from the
        coordinates of the mean point :eq:`mean_point` of the event domain, mapped into
        the standard space as follows:

        .. math::
            :label: mean_point

            \vect{X}^*_{event} = \frac{1}{n} \sum_{i=1}^n \vect{X}_i 1_{event} (\vect{X}_i)

        .. math::
            :label: importance_factor

            \alpha_i = \frac{ (U_i^*)^2 }{ \left\| \vect{U}^* \right\| }

        where

        .. math::

            \vect{U}^* = T(\vect{X}^*_{event})

        Be careful: this notion is only valid for :class:`~openturns.MonteCarloExperiment` or
        :class:`~openturns.LHSExperiment` sampling as the mean is evaluated from the equation
        :eq:`importance_factor` (only uniform weights over the realizations
        :math:`\vect{X}_i`.
        """
        return _experimental.SimulationSensitivityAnalysis_computeImportanceFactors(self, *args)

    def computeEventProbabilitySensitivity(self):
        r"""
        Compute the sensitivity to the probability.

        The sensitivity of the probability Pf wrt the distribution parameters :math:`\theta` is written:

        .. math::

            \vect{sens_{Pf}}_j = \frac{1}{n} \sum_{i=1}^n \mathbf{1}_{event} \vect{\frac{\delta log(f_{\uX})(\vect{X}_i)}{\delta \theta_j}}

        Returns
        -------
        sensitivity_pf : :class:`~openturns.PointWithDescription`
            The probability sensitivity.
        """
        return _experimental.SimulationSensitivityAnalysis_computeEventProbabilitySensitivity(self)

    def drawImportanceFactors(self):
        r"""
        Draw the importance factors.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph containing the pie corresponding to the importance factors of the probabilistic variables.
        """
        return _experimental.SimulationSensitivityAnalysis_drawImportanceFactors(self)

    def drawImportanceFactorsRange(self, *args):
        r"""
        Draw the importance factors evolution.

        Parameters
        ----------
        probabilityScale : bool
            Set True if the limits are the probability levels; set False if the limits are
            the thresholds defining the event.
        lower, upper : floats
            Define the boundaries of the probability levels :math:`p_{min}` and
            :math:`p_{max}` or those of the thresholds :math:`s_{min}` and :math:`s_{max}`. 

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph that draws the evolution of the importance factors of each direction
            with respect to :math:`p \in [p_{min}, p_{max}]` or
            :math:`s \in [s_{min}, s_{max}]`. The importance factors are evaluated from
            the definition :eq:`importance_factor` for each threshold *s* or probability
            *p*.
        """
        return _experimental.SimulationSensitivityAnalysis_drawImportanceFactorsRange(self, *args)

    def getInputSample(self):
        r"""
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The input sample.
        """
        return _experimental.SimulationSensitivityAnalysis_getInputSample(self)

    def getOutputSample(self):
        r"""
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The output sample.
        """
        return _experimental.SimulationSensitivityAnalysis_getOutputSample(self)

    def getThreshold(self):
        r"""
        Accessor to the threshold.

        Returns
        -------
        s : float
            The threshold.
        """
        return _experimental.SimulationSensitivityAnalysis_getThreshold(self)

    def getTransformation(self):
        r"""
        Accessor to the isoprobabilistic transformation function.

        Returns
        -------
        transformation : :class:`~openturns.Function`
            The isoprobabilistic transformation function.
        """
        return _experimental.SimulationSensitivityAnalysis_getTransformation(self)

    def getComparisonOperator(self):
        r"""
        Accessor to the comparison operator.

        Returns
        -------
        operator : :class:`~openturns.ComparisonOperator`
            The comparison operator.
        """
        return _experimental.SimulationSensitivityAnalysis_getComparisonOperator(self)

    def __repr__(self):
        return _experimental.SimulationSensitivityAnalysis___repr__(self)

    def __init__(self, *args):
        _experimental.SimulationSensitivityAnalysis_swiginit(self, _experimental.new_SimulationSensitivityAnalysis(*args))
    __swig_destroy__ = _experimental.delete_SimulationSensitivityAnalysis

# Register SimulationSensitivityAnalysis in _experimental:
_experimental.SimulationSensitivityAnalysis_swigregister(SimulationSensitivityAnalysis)
class SubsetSamplingResult(ProbabilitySimulationResult):
    r"""
    Subset sampling result.

    See also
    --------
    SubsetSampling, SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SubsetSamplingResult_getClassName(self)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _experimental.SubsetSamplingResult_getCoefficientOfVariation(self)

    def __repr__(self):
        return _experimental.SubsetSamplingResult___repr__(self)

    def __init__(self, *args):
        _experimental.SubsetSamplingResult_swiginit(self, _experimental.new_SubsetSamplingResult(*args))
    __swig_destroy__ = _experimental.delete_SubsetSamplingResult

# Register SubsetSamplingResult in _experimental:
_experimental.SubsetSamplingResult_swigregister(SubsetSamplingResult)
class SubsetSampling(EventSimulation):
    r"""
    Subset simulation.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability.
    proposalRange : float, optional
        Proposal range length
    targetProbability : float, optional
        Value of :math:`P(F_i|F_{i-1})` between successive steps

    Notes
    -----
    The goal is to estimate the following probability

    .. math::

        P_f = \int_{\mathcal D_f} f_{\uX}(\ux)\di{\ux}\\
            = \int_{\mathbb R^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \:\leq 0\: \}}f_{\uX}(\ux)\di{\ux}\\
            = \Prob {\{g(\uX,\underline{d}) \leq 0\}}


    The idea of the subset simulation method [au2001]_ is to replace simulating a
    rare failure event in the original probability space by a sequence of
    simulations of more frequent conditional events :math:`F_i`

    .. math::

        F_1 \supset F_2 \supset \dots \supset F_m = F


    The original probability estimate rewrites

    .. math::

        P_f = P(F_m) = P(\bigcap \limits_{i=1}^m F_i) = P(F_1) \prod_{i=2}^m P(F_i|F_{i-1})


    And each conditional subset failure region is chosen by setting the threshold
    :math:`g_i` so that :math:`P(F_i|F_{i-1})` leads to a conditional failure
    probability of order :math:`0.1`

    .. math::

        F_i =\Prob {\{g(\uX,\underline{d}) \leq g_i\}}


    The conditional samples are generated by the means of Markov Chains,
    using the Metropolis Hastings algorithm.

    :math:`N` being the number of simulations per subset, and :math:`p_{0i}` the
    conditional probability of each subset event, and :math:`\gamma_i` the
    autocorrelation between Markov chain samples.

    .. math::

        \delta^2 = \sum_{i=1}^m \delta^2_i = \sum_{i=1}^m (1+\gamma_i) \frac{1-p_{0i}}{p_{0i}N}


    The first event :math:`F_1` not being conditional, :math:`\delta^2_1`
    expresses as the classic Monte Carlo c.o.v.

    See also
    --------
    EventSimulation
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SubsetSampling_getClassName(self)

    def setProposalRange(self, proposalRange):
        r"""
        Proposal range length accessor.

        Parameters
        ----------
        range : float
            Range length.
        """
        return _experimental.SubsetSampling_setProposalRange(self, proposalRange)

    def getProposalRange(self):
        r"""
        Proposal range length accessor.

        Returns
        -------
        range : float
            Range length.
        """
        return _experimental.SubsetSampling_getProposalRange(self)

    def setConditionalProbability(self, conditionalProbability):
        r"""
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Parameters
        ----------
        prob : float
            Conditional probability value.
        """
        return _experimental.SubsetSampling_setConditionalProbability(self, conditionalProbability)

    def getConditionalProbability(self):
        r"""
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Returns
        -------
        prob : float
            Conditional probability value.
        """
        return _experimental.SubsetSampling_getConditionalProbability(self)

    def setMinimumProbability(self, minimumProbability):
        r"""
        Minimum probability accessor.

        Allows one to stop the algorithm if the probability becomes too small.

        Parameters
        ----------
        prob_min : float, defaults to the square root of SpecFunc.MinScalar
            Minimum probability.
        """
        return _experimental.SubsetSampling_setMinimumProbability(self, minimumProbability)

    def getMinimumProbability(self):
        r"""
        Minimum probability accessor.

        Returns
        -------
        prob_min : float
            Minimum probability.
        """
        return _experimental.SubsetSampling_getMinimumProbability(self)

    def getStepsNumber(self):
        r"""
        Subset steps number accessor.

        Returns
        -------
        n : int
            Number of subset steps, including the initial Monte Carlo sampling.
        """
        return _experimental.SubsetSampling_getStepsNumber(self)

    def getThresholdPerStep(self):
        r"""
        Threshold accessor.

        Returns
        -------
        threshold : :class:`~openturns.Point`
            Threshold values at each step.
        """
        return _experimental.SubsetSampling_getThresholdPerStep(self)

    def getGammaPerStep(self):
        r"""
        Autocorrelation accessor.

        Returns
        -------
        prob : :class:`~openturns.Point`
            Autocorrelation values at each step.
        """
        return _experimental.SubsetSampling_getGammaPerStep(self)

    def getCoefficientOfVariationPerStep(self):
        r"""
        Coefficient of variation per step accessor.

        Returns
        -------
        coef : :class:`~openturns.Point`
            Coefficient of variation at each subset step.
        """
        return _experimental.SubsetSampling_getCoefficientOfVariationPerStep(self)

    def getProbabilityEstimatePerStep(self):
        r"""
        Probability estimate accessor.

        Returns
        -------
        prob : :class:`~openturns.Point`
            Probability estimate at each step.
        """
        return _experimental.SubsetSampling_getProbabilityEstimatePerStep(self)

    def setKeepSample(self, keepSample):
        r"""
        Sample storage accessor.

        Parameters
        ----------
        keepsample : bool
            Whether to keep the working samples at each iteration.
        """
        return _experimental.SubsetSampling_setKeepSample(self, keepSample)
    EVENT0 = _experimental.SubsetSampling_EVENT0
    EVENT1 = _experimental.SubsetSampling_EVENT1
    BOTH = _experimental.SubsetSampling_BOTH

    def getInputSample(self, *args):
        r"""
        Input sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _experimental.SubsetSampling_getInputSample(self, *args)

    def getOutputSample(self, *args):
        r"""
        Output sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample.
        """
        return _experimental.SubsetSampling_getOutputSample(self, *args)

    def setInitialExperiment(self, initialExperiment):
        r"""
        Initial experiment accessor.

        Parameters
        ----------
        initialExperiment : :class:`~openturns.WeightedExperiment`
            Experiment for first step.
        """
        return _experimental.SubsetSampling_setInitialExperiment(self, initialExperiment)

    def getInitialExperiment(self):
        r"""
        Initial experiment accessor.

        Returns
        -------
        initialExperiment : :class:`~openturns.WeightedExperiment`
            Experiment for first step.
        """
        return _experimental.SubsetSampling_getInitialExperiment(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        openturns.EventSimulation.setBlockSize
        openturns.EventSimulation.setMaximumOuterSampling
        openturns.ResourceMap
        openturns.SimulationResult
        """
        return _experimental.SubsetSampling_run(self)

    def __repr__(self):
        return _experimental.SubsetSampling___repr__(self)

    def __init__(self, *args):
        _experimental.SubsetSampling_swiginit(self, _experimental.new_SubsetSampling(*args))
    __swig_destroy__ = _experimental.delete_SubsetSampling

# Register SubsetSampling in _experimental:
_experimental.SubsetSampling_swigregister(SubsetSampling)
class AdaptiveDirectionalStratification(EventSimulation):
    r"""
    Adaptive directional simulation.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.
    rootStrategy : :class:`~openturns.RootStrategy`, optional
        Strategy adopted to evaluate the intersections of each direction with the
        limit state function and take into account the contribution of the
        direction to the event probability.
        Set to :class:`~openturns.SafeAndSlow` by default.
    samplingStrategy : :class:`~openturns.SamplingStrategy`, optional
        Strategy adopted to sample directions.
        Set to :class:`~openturns.RandomDirection` by default.

    Notes
    -----
    Let :math:`\mathcal D_f` denote the failure domain defined as
    :math:`\mathcal D_f = \{\ux \in \mathbb R^{n_X} | g(\ux) \leq 0\}`, where
    :math:`\ux` are realization of the random vector :math:`\uX` and :math:`g` is the limit-state
    function as defined elsewhere in the documentation.

    The purpose of the ADS-2 algorithm and its variants is to estimate the
    following probability:

    .. math::

      P_f = \int_{\mathcal D_f} f_{\uX}(\ux)\di{\ux} \\
          = \int_{\mathbb R^{n_X}} \mathbf{1}_{\{g(\ux) \:\leq 0\: \}}\,f_{\uX}(\ux)\di{\ux} \\
          = \Prob{\{g(\uX) \leq 0\}}.

    Principles

    The ADS-2 method [munoz2011]_ combines the stratified and directional sampling concepts.
    Stratified sampling consists in splitting the support of the random vector
    :math:`\ux` into :math:`m` mutually exclusive and collectively exhaustive subsets.
    Here, ADS-2 splits the standard space into :math:`m = 2^d` quadrants, where
    :math:`d` is the dimension of the random vector :math:`\uX`.
    Stratified sampling is often run in two steps: (i) a learning step is used for
    polling the input space and detect the subsets that contribute most to the
    probability and (ii) an estimation step is used for estimating
    the probability by weighted sampling (some subsets are more sampled than the others).
    Directional sampling uses the spheric symmetry of the standard space for
    estimating the failure probability as the average of conditional probabilities
    calculated on directions drawn at random in the standard space.

    The learning step uses an a priori number of random directions that is
    uniformly distributed over the quadrants, meaning the weights are as follows:

    .. math::

        \omega^1_i = \frac{1}{m}, \quad i = 1, \ldots, m.


    Directional sampling is used for estimating the failure probability in each quadrant:

    .. math::

        \hat P_i^{DS} = \Prob{\{g(\uX) \leq 0\} \mid \uX \in \mathbb{Q}_i},\,i = 1, \ldots, m.


    and the corresponding estimation variances are denoted as :math:`\sigma_i^{DS\,2}`.
    These probabilities are estimated using the same number :math:`N^0_i` of random
    directions per quadrant as told by the uniform weights distribution.

    The probability of interest is then computed as a weighted average of the
    previously defined conditional probabilities:

    .. math::

        \hat P_f = \sum\limits_{i=1}^m \omega_i \hat P_i^{DS}


    where :math:`\hat P_i^{DS}` is the conditional probability estimator in the i-th quadrant. The corresponding variance of the stratified estimator reads:

    .. math::

        \sigma^2 = \frac{1}{N_l} \left( \sum\limits_{i=1}^m \omega_i \sigma_i^{DS} \right) ^2


    where :math:`\sigma_i^{DS\,2}` is the variance of the conditional probability
    estimator in the i-th quadrant.

    At the end of the learning step, the weights :math:`\omega_i` are updated so
    as to minimize the stratified estimator variance.
    Indeed, it can be shown that the updated weights:

    .. math::

        \omega^2_i = \frac{\omega^1_i \sigma_i^{DS}}{\sum\limits_{j=1}^m \omega^1_j \sigma_j^{DS}}, i = 1, \ldots, m,


    minimize the final estimation variance in \eqref{eq:pf_est_sda2_var}.
    Note that some weights might be zero (due to a somewhat arbitrary rounding of
    the conditional probabilities' estimation variance). The quadrants associated
    with a zero-weight will not be sampled in the estimation step.

    Eventually, the estimation step proceeds in essentially the same way as the
    learning step with different weights for the quadrants though.
    \eqref{eq:pf_est_sda2} and \eqref{eq:pf_est_sda2_var} are used for evaluating
    the final probability probability estimate and its variance.

    The computational budget per step is parametrized by a fraction
    :math:`\gamma_l, l = 1,\,2` of the total budget :math:`N`, such that :math:`\gamma_1 + \gamma_2 = 1`.
    The number of directions sampled in quadrant :math:`i` at step :math:`l` is then defined as follows:

    .. math::

        N^l_i = N * \gamma_l * \omega_i.


    The number of evaluation of the limit-state function :math:`g` is of course
    greater than the total budget :math:`N` since directional sampling is used.

    Variants

    The ADS-2+ variant performs a dimension reduction step after the learning step
    for reducing the number of stratified quadrants. The statistic :math:`\tilde T_k`
    aggregates the sensitivity of expectation along dimension :math:`k`.
    It is defined as follows:

    .. math::

        \tilde T_k = \sum\limits_{i_l \in \lbrace -1,1 \rbrace,l \neq k} \lvert \tilde I_{(i_1,\dots,i_{k-1},-1,i_{k+1},\dots,i_p)} - \tilde I_{(i_1,\dots,i_{k-1},1,i_{k+1},\dots,i_p)} \rvert.

    It is used for ranking the contributions of the quadrants.
    Then, only the :math:`d' < d` most influential variables according to
    :math:`\tilde T_k` are stratified, leaving the remaining variables simulated without
    stratification. The corresponding quadrants will not be sampled.

    The DP-ADS-2 variant combines the ADS method with a rotation of the quadrants.
    The idea is to get a possible design point (available e.g. after a
    preliminary FORM analysis) on the bisector of one of the quadrants to make the
    stratification even more efficient and thus save some evaluations of the model.

    This 2-step algorithm can be generalized to :math:`L > 2` steps by adding more
    than one learning step. For now, only ADS-2 is implemented.

    See also
    --------
    EventSimulation
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.AdaptiveDirectionalStratification_getClassName(self)

    def __repr__(self):
        return _experimental.AdaptiveDirectionalStratification___repr__(self)

    def setRootStrategy(self, rootStrategy):
        r"""
        Set the root strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _experimental.AdaptiveDirectionalStratification_setRootStrategy(self, rootStrategy)

    def getRootStrategy(self):
        r"""
        Get the root strategy.

        Returns
        -------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _experimental.AdaptiveDirectionalStratification_getRootStrategy(self)

    def setSamplingStrategy(self, samplingStrategy):
        r"""
        Set the direction sampling strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _experimental.AdaptiveDirectionalStratification_setSamplingStrategy(self, samplingStrategy)

    def getSamplingStrategy(self):
        r"""
        Get the direction sampling strategy.

        Returns
        -------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _experimental.AdaptiveDirectionalStratification_getSamplingStrategy(self)

    def setGamma(self, gamma):
        r"""
        Gamma accessor.

        The computational budget per step :math:`\gamma_l`.

        Parameters
        ----------
        gamma : sequence of float
            Gamma value.
        """
        return _experimental.AdaptiveDirectionalStratification_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Gamma accessor.

        The computational budget per step :math:`\gamma_l`.

        Returns
        -------
        gamma : :class:`~openturns.Point`
            Gamma value.
        """
        return _experimental.AdaptiveDirectionalStratification_getGamma(self)

    def setQuadrantOrientation(self, quadrantOrientation):
        r"""
        Quadrant orientation accessor.

        Parameters
        ----------
        orientation : sequence of float
            Quadrant orientation.
        """
        return _experimental.AdaptiveDirectionalStratification_setQuadrantOrientation(self, quadrantOrientation)

    def getQuadrantOrientation(self):
        r"""
        Quadrant orientation accessor.

        Returns
        -------
        orientation : :class:`~openturns.Point`
            Quadrant orientation.
        """
        return _experimental.AdaptiveDirectionalStratification_getQuadrantOrientation(self)

    def setPartialStratification(self, partialStratification):
        r"""
        Partial stratification accessor.

        Parameters
        ----------
        partialStratification : bool
            Partial stratification.
        """
        return _experimental.AdaptiveDirectionalStratification_setPartialStratification(self, partialStratification)

    def getPartialStratification(self):
        r"""
        Partial stratification accessor.

        Returns
        -------
        partialStratification : bool
            Partial stratification.
        """
        return _experimental.AdaptiveDirectionalStratification_getPartialStratification(self)

    def setMaximumStratificationDimension(self, maximumStratificationDimension):
        r"""
        Maximum stratification dimension accessor.

        Parameters
        ----------
        max : int
            Maximum stratification dimension.
        """
        return _experimental.AdaptiveDirectionalStratification_setMaximumStratificationDimension(self, maximumStratificationDimension)

    def getMaximumStratificationDimension(self):
        r"""
        Maximum stratification dimension accessor.

        Returns
        -------
        max : int
            Maximum stratification dimension.
        """
        return _experimental.AdaptiveDirectionalStratification_getMaximumStratificationDimension(self)

    def getTStatistic(self):
        r"""
        T statistic accessor.

        The statistic :math:`\tilde T_k` aggregates the sensitivity of expectation.

        Returns
        -------
        gamma : :class:`~openturns.Point`
            T statistic value.
        """
        return _experimental.AdaptiveDirectionalStratification_getTStatistic(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        openturns.EventSimulation.setBlockSize
        openturns.EventSimulation.setMaximumOuterSampling
        openturns.ResourceMap
        openturns.SimulationResult
        """
        return _experimental.AdaptiveDirectionalStratification_run(self)

    def __init__(self, *args):
        _experimental.AdaptiveDirectionalStratification_swiginit(self, _experimental.new_AdaptiveDirectionalStratification(*args))
    __swig_destroy__ = _experimental.delete_AdaptiveDirectionalStratification

# Register AdaptiveDirectionalStratification in _experimental:
_experimental.AdaptiveDirectionalStratification_swigregister(AdaptiveDirectionalStratification)
class ExpectationSimulationResult(SimulationResult):
    r"""
    Expectation simulation result.

    Gathers the results of a :class:`~openturns.ExpectationSimulationAlgorithm`
    algorithm.

    See also
    --------
    ExpectationSimulationAlgorithm
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ExpectationSimulationResult_getClassName(self)

    def getRandomVector(self):
        r"""
        Accessor to the random variable.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Random variable we want to study.
        """
        return _experimental.ExpectationSimulationResult_getRandomVector(self)

    def setRandomVector(self, randomVector):
        r"""
        Accessor to the random variable.

        Parameters
        ----------
        event : :class:`~openturns.RandomVector`
            Random variable we want to study.
        """
        return _experimental.ExpectationSimulationResult_setRandomVector(self, randomVector)

    def getExpectationEstimate(self):
        r"""
        Accessor to the expectation estimate.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the expectation.
        """
        return _experimental.ExpectationSimulationResult_getExpectationEstimate(self)

    def setExpectationEstimate(self, expectationEstimate):
        r"""
        Accessor to the expectation estimate.

        Parameters
        ----------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the expectation.
        """
        return _experimental.ExpectationSimulationResult_setExpectationEstimate(self, expectationEstimate)

    def getVarianceEstimate(self):
        r"""
        Accessor to the variance estimate.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the variance.
        """
        return _experimental.ExpectationSimulationResult_getVarianceEstimate(self)

    def setVarianceEstimate(self, varianceEstimate):
        r"""
        Accessor to the variance estimate.

        Parameters
        ----------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the variance.
        """
        return _experimental.ExpectationSimulationResult_setVarianceEstimate(self, varianceEstimate)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        coefficientOfVariation : :class:`~openturns.Point`
            Coefficient of variation.
        """
        return _experimental.ExpectationSimulationResult_getCoefficientOfVariation(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        standardDeviation : :class:`~openturns.Point`
            Standard deviation.
        """
        return _experimental.ExpectationSimulationResult_getStandardDeviation(self)

    def getExpectationDistribution(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Distribution`
            Distribution of the expectation.
        """
        return _experimental.ExpectationSimulationResult_getExpectationDistribution(self)

    def __repr__(self):
        return _experimental.ExpectationSimulationResult___repr__(self)

    def __init__(self, *args):
        _experimental.ExpectationSimulationResult_swiginit(self, _experimental.new_ExpectationSimulationResult(*args))
    __swig_destroy__ = _experimental.delete_ExpectationSimulationResult

# Register ExpectationSimulationResult in _experimental:
_experimental.ExpectationSimulationResult_swigregister(ExpectationSimulationResult)
class ExpectationSimulationAlgorithm(SimulationAlgorithm):
    r"""
    Expectation computation using sampling.

    Incremental Monte Carlo sampling algorithm to estimate the mean :math:`\Expect{\vect{X}}` of a random vector
    :math:`\vect{X}`.

    Parameters
    ----------
    X : :class:`~openturns.RandomVector`
        The random vector to study.

    Notes
    -----
    Let :math:`\vect{X}\in\Rset^{n_X}` be a random vector. 
    This algorithm estimates :math:`\Expect{\vect{X}}` using the smallest possible sample 
    size which satisfies pre-defined stopping rules. 
    It increases the sample size :math:`n` incrementally until a stopping criterion is met. 
    Hence, both the mean and the variance must be finite. 
    For example, consider the Student distribution with :math:`\nu` degrees of freedom. 
    If :math:`\nu=1` (where the expectation is undefined) 
    or :math:`\nu=2` (where the variance is undefined), 
    then the algorithm cannot succeed. 

    The algorithm is based on two nested loops:

    - the outer loop sets the number of iterations of the algorithm; 
      this can be configured using :meth:`setMaximumOuterSampling`,

    - the inner loop sets the number of function calls which can be parallelized; 
      this can be configured using :meth:`setBlockSize`.

    The algorithm allows one to get the best possible performance on distributed
    supercomputers and multi-core workstations. 
    For example, if the block size is equal to 100, then the sample size 
    is successively equal to 100, 200, etc... 
    Each block of evaluation of the outputs can be parallelized, which may improve the performance of the algorithm.
    We suggest to set the block size as a multiple of the number of cores. 

    The algorithm stops either when the maximum number of outer iterations is reached or when the target precision is met. 
    The latter stopping criterion is based on either the coefficient of variation of the 
    sample mean (relative criterion) or the standard deviation of the sample 
    mean (absolute criterion). 

    We consider :math:`\vect{n}` independent realizations :math:`\vect{x}^{(1)}`, 
    ..., :math:`\vect{x}^{(n)}\in\Rset^{n_X}` of the random vector :math:`\vect{X}`. 
    We estimate :math:`\Expect{\vect{X}}` with the sample mean:

    .. math::

        \overline{\vect{x}} = \frac{1}{n} \sum_{j=1}^n \vect{x}^{(j)}.

    We estimate :math:`\Var{X_i}` for :math:`i = 1, \ldots, n_X` 
    with the unbiased sample variance:

    .. math::

        \hat{\sigma}^2_i = \frac{1}{n - 1} \sum_{j=1}^n \left(x^{(j)}_i - \overline{x}_i\right)^2.

    for :math:`i = 1, \ldots, n_X`.

    The expected value of the sample mean is:

    .. math::

        \Expect{\overline{X}_i} = \Expect{X_i}

    and, since the observations are independent, the variance of the sample mean is:

    .. math::

        \Var{\overline{X}_i} = \frac{\Var{X_i}}{n}.

    for :math:`i = 1, \ldots, n_X`, since the observations are independent.

    Moreover, we can estimate the standard deviation of the sample mean with:

    .. math::

        \hat{\sigma}\left(\overline{X}_i\right) = \frac{\hat{\sigma}_i}{\sqrt{n}}

    for :math:`i = 1, \ldots, n_X`.

    If the expectation :math:`\Expect{X_i}` is nonzero, the coefficient of variation of the sample mean is:

    .. math::

        CV\left(\overline{X}_i\right) = \frac{\sqrt{\Var{\overline{X}_i}}}{\left|\Expect{\overline{X}_i}\right|} = \frac{\sqrt{\Var{X_i}}/\sqrt{n}}{\left|\Expect{X_i}\right|}

    for :math:`i = 1, \ldots, n_X`.

    We can estimate it with

    .. math::

        \widehat{CV}\left(\overline{X}_i\right) = \frac{\hat{\sigma}_i/\sqrt{n}}{\left|\overline{x}_i\right|}

    for :math:`i = 1, \ldots, n_X`.

    When the sample size :math:`n` increases, the sample standard deviation and the sample coefficient of variation decrease to zero at the Monte-Carlo rate of :math:`1/\sqrt{n}`. 

    There are 3 mathematical stopping criteria available:

    - through an operator on the componentwise coefficients of variation (by default),
    - through an operator on the componentwise standard deviations,
    - on the maximum standard deviation per component.

    A low coefficient of variation guarantees relative accuracy, while a low standard deviation guarantees absolute accuracy. 

    If the chosen condition is found to be true, the algorithm stops.

    Let :math:`n_X` be the dimension of the random vector :math:`\vect{X}`. 
    Let :math:`\max_{cov}\in\Rset` be the maximum coefficient of variation. 
    The criterion on the componentwise coefficients of variation is defined using either:

    - the maximum (by default):

    .. math::

        \max_{i=1,\ldots,n_X} \frac{\hat{\sigma}_i / \sqrt{n}}{|\overline{x}_i|} \leq \max_{cov},

    - the norm-1:

    .. math::

        \sum_{i=1}^{n_X} \frac{\hat{\sigma}_i / \sqrt{n}}{|\overline{x}_i|} \leq \max_{cov},

    - the norm-2:

    .. math::

        \sqrt{\sum_{i=1}^{n_X} \left(\frac{\hat{\sigma}_i / \sqrt{n}}{|\overline{x}_i|}\right)^2} \leq \max_{cov},

    - or disabled.

    The type of operator on the coefficient of variation is set using :meth:`setCoefficientOfVariationCriterionType`.

    The default type is set by the `ExpectationSimulationAlgorithm-DefaultCoefficientOfVariationCriterionType` key of the :class:`~openturns.ResourceMap`.

    The threshold :math:`\max_{cov}` can be set using :meth:`setMaximumCoefficientOfVariation`.

    Let :math:`\max_{\sigma}\in\Rset` be the maximum value of the standard deviation. 
    The criterion on the componentwise standard deviations is defined using either:

    - the maximum (by default): 

    .. math::

        \max_{i=1,\ldots,n_X} \hat{\sigma}_i / \sqrt{n} \leq \max_{\sigma},

    - the norm-1: 

    .. math::

        \sum_{i=1}^{n_X} \left|\hat{\sigma}_i / \sqrt{n}\right| \leq \max_{\sigma},

    - the norm-2: 

    .. math::

        \sqrt{\sum_{i=1}^{n_X} \left(\hat{\sigma}_i / \sqrt{n} \right)^2} \leq \max_{\sigma},

    - or disabled. 

    The type of operator on the coefficient of variation can be set using :meth:`setStandardDeviationCriterionType`.

    The default type is set by the `ExpectationSimulationAlgorithm-DefaultStandardDeviationCriterionType` key of the :class:`~openturns.ResourceMap`.

    The threshold :math:`\max_{\sigma}` can be set using :meth:`setMaximumStandardDeviation`.

    Let :math:`\max_{\sigma_1}, \ldots, \max_{\sigma_{n_X}}` be the 
    componentwise maximum standard deviations. 
    The criterion on the maximum deviation per component is defined by:

    .. math::

        \sigma_i \leq \max_{\sigma_i}

    for :math:`i = 1, \ldots, n_X`.

    The threshold vector :math:`\max_{\sigma_i}` can be set using :meth:`setMaximumStandardDeviationPerComponent`.

    By default this criterion is disabled.

    The default values of the parameters are based on the 
    following keys of the :class:`~openturns.ResourceMap`:

    - `SimulationAlgorithm-DefaultMaximumOuterSampling`,
    - `SimulationAlgorithm-DefaultMaximumCoefficientOfVariation`,
    - `SimulationAlgorithm-DefaultMaximumStandardDeviation`.

    In general, criteria based on coefficients of variation (C.O.V.) should be used because
    they guarantee a relative accuracy on the estimate of the mean.
    However, we may happen to estimate an expected value equal to zero
    (perhaps for teaching or research purposes).
    The default value of `SimulationAlgorithm-DefaultMaximumStandardDeviation` is
    :math:`0`, which means that standard deviation-based criteria are disabled by default
    (in order to let C.O.V.-based criteria be used by default).
    If the expected value of :math:`\vect{X}` is zero,
    the algorithm is likely to reach the maximum number of outer iterations.
    If this happens, please configure the maximum standard deviation
    in order to match the scale of the random variable at hand.

    See also
    --------
    ExpectationSimulationResult, SimulationAlgorithm

    Examples
    --------

    In the following example, we perform at most :math:`8 \times 10000 = 80000` evaluations 
    of the model. 
    However, the algorithm may stop earlier if the coefficient of variation 
    of the sample mean falls below the threshold. 

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Create a composite random vector
    >>> model = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0] * 4, ot.IdentityMatrix(4))
    >>> vect = ot.RandomVector(distribution)
    >>> X = ot.CompositeRandomVector(model, vect)
    >>> algo = ot.ExpectationSimulationAlgorithm(X)
    >>> algo.setMaximumOuterSampling(10000)
    >>> algo.setBlockSize(8)  # The number of cores we usually have.
    >>> algo.setMaximumCoefficientOfVariation(0.01)  # 1% C.O.V.
    >>> algo.run()
    >>> result = algo.getResult()
    >>> expectation = result.getExpectationEstimate()
    >>> print(expectation)
    [-1.41067]

    The following statement retrieves the asymptotically Gaussian distribution 
    of the sample mean. 
    This may be useful for users who want to compute a confidence interval of 
    the sample mean. 

    >>> expectationDistribution = result.getExpectationDistribution()

    The following code prints the outer sample (i.e. the number of outer iterations 
    of the algorithm) and the sample size. 
    We see that the algorithm stops based on the accuracy criterion. 

    >>> outer_sampling = result.getOuterSampling()
    >>> print('outer_sampling=', outer_sampling)
    outer_sampling= 1662
    >>> block_size = result.getBlockSize()
    >>> sample_size = outer_sampling * block_size
    >>> print('sample_size=', sample_size)
    sample_size= 13296

    In the following example, we disable the coefficient of variation criterion. 
    Therefore, the only remaining criterion is based on the number of iterations. 

    >>> algo = ot.ExpectationSimulationAlgorithm(X)
    >>> algo.setMaximumOuterSampling(1000)
    >>> algo.setBlockSize(1)
    >>> algo.setCoefficientOfVariationCriterionType('NONE')
    >>> algo.run()
    >>> result = algo.getResult()
    >>> outer_sampling = result.getOuterSampling()
    >>> print('outer_sampling=', outer_sampling)
    outer_sampling= 1000

    In the following example, we compute the mean of a dimension 4 random vector. 
    We use a standard deviation-based stopping criterion with a different threshold for every component. 
    We must disable the coefficient of variation-based stopping criterion, otherwise,
    in this example, it will trigger first.
    The comparison with the exact mean is satisfactory, given the relatively 
    small sample size.

    >>> from openturns.usecases import cantilever_beam
    >>> cb = cantilever_beam.CantileverBeam()
    >>> sigma = cb.distribution.getStandardDeviation()
    >>> print('sigma=', sigma)
    sigma= [1.73582e+09,30,0.0288675,7.10585e-09]
    >>> componentwise_max_sigma = sigma / 32.0
    >>> print('componentwise_max_sigma=', componentwise_max_sigma)
    componentwise_max_sigma= [5.42445e+07,0.9375,0.00090211,2.22058e-10]
    >>> X = ot.RandomVector(cb.distribution)
    >>> algo = ot.ExpectationSimulationAlgorithm(X)
    >>> algo.setMaximumOuterSampling(1000)
    >>> algo.setBlockSize(8)
    >>> algo.setCoefficientOfVariationCriterionType('NONE')
    >>> algo.setMaximumStandardDeviationPerComponent(componentwise_max_sigma)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> expectation = result.getExpectationEstimate()
    >>> outer_sampling = result.getOuterSampling()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ExpectationSimulationAlgorithm_getClassName(self)

    def __init__(self, *args):
        _experimental.ExpectationSimulationAlgorithm_swiginit(self, _experimental.new_ExpectationSimulationAlgorithm(*args))

    def getRandomVector(self):
        r"""
        Accessor to the random vector.

        Returns
        -------
        X : :class:`~openturns.RandomVector`
            Random vector we want to study.
        """
        return _experimental.ExpectationSimulationAlgorithm_getRandomVector(self)

    def getResult(self):
        r"""
        Accessor to the result.

        Returns
        -------
        result : :class:`~openturns.ExpectationSimulationResult`
            The simulation result.
        """
        return _experimental.ExpectationSimulationAlgorithm_getResult(self)

    def setCoefficientOfVariationCriterionType(self, criterionType):
        r"""
        Accessor to the criterion operator.

        Parameters
        ----------
        result : str
            The criterion operator, either NONE, MAX, NORM1 or NORM2.
        """
        return _experimental.ExpectationSimulationAlgorithm_setCoefficientOfVariationCriterionType(self, criterionType)

    def getCoefficientOfVariationCriterionType(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        result : str
            The criterion operator.
        """
        return _experimental.ExpectationSimulationAlgorithm_getCoefficientOfVariationCriterionType(self)

    def setStandardDeviationCriterionType(self, criterionType):
        r"""
        Accessor to the criterion operator.

        Parameters
        ----------
        result : str
            The criterion operator, either NONE, MAX, NORM1 or NORM2
        """
        return _experimental.ExpectationSimulationAlgorithm_setStandardDeviationCriterionType(self, criterionType)

    def getStandardDeviationCriterionType(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        result : str
            The criterion operator.
        """
        return _experimental.ExpectationSimulationAlgorithm_getStandardDeviationCriterionType(self)

    def setMaximumStandardDeviationPerComponent(self, maximumStandardDeviation):
        r"""
        Accessor to the maximum standard deviation.

        Parameters
        ----------
        sigmaMax : sequence of float
            The maximum standard deviation on each component.

            If empty, the stopping criterion is not applied.
        """
        return _experimental.ExpectationSimulationAlgorithm_setMaximumStandardDeviationPerComponent(self, maximumStandardDeviation)

    def getMaximumStandardDeviationPerComponent(self):
        r"""
        Accessor to the maximum standard deviation.

        Returns
        -------
        sigmaMax : sequence of float
            The maximum standard deviation on each component.
        """
        return _experimental.ExpectationSimulationAlgorithm_getMaximumStandardDeviationPerComponent(self)

    def __repr__(self):
        return _experimental.ExpectationSimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.ExpectationSimulationAlgorithm_run(self)

    def drawExpectationConvergence(self, *args):
        r"""
        Draw the expectation convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _experimental.ExpectationSimulationAlgorithm_drawExpectationConvergence(self, *args)
    __swig_destroy__ = _experimental.delete_ExpectationSimulationAlgorithm

# Register ExpectationSimulationAlgorithm in _experimental:
_experimental.ExpectationSimulationAlgorithm_swigregister(ExpectationSimulationAlgorithm)
class SobolSimulationResult(SimulationResult):
    r"""
    Sobol simulation result.

    Gathers the results of a :class:`~openturns.SobolSimulationAlgorithm`
    algorithm.

    Parameters
    ----------
    fo_dist : :class:`~openturns.Distribution`
        The random vector to study.
    to_dist : :class:`~openturns.Distribution`
        The function to study.
    outer_sampling : int
        The number of iterations.
    experiment_size : int
        The Sobol' experiment size
    block_size : int
        The block size.

    See also
    --------
    SobolSimulationAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> fo_dist = ot.Normal([0.154081,0.872087,0.0122877,0.0433801], [0.00982468,0.0302524,0.00911937,0.00926643], ot.CorrelationMatrix(4))
    >>> to_dist = ot.Normal([0.16743,0.795477,0.0124454,0.045178], [0.0068919,0.00950876,0.00204324,0.0038844], ot.CorrelationMatrix(4))
    >>> result = ot.SobolSimulationResult(fo_dist, to_dist, 250, 100, 1)
    >>> fo = result.getFirstOrderIndicesEstimate()
    >>> to = result.getTotalOrderIndicesEstimate()
    >>> fo_dist = result.getFirstOrderIndicesDistribution()
    >>> to_dist = result.getTotalOrderIndicesDistribution()
    >>> graph = result.draw()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SobolSimulationResult_getClassName(self)

    def getFirstOrderIndicesEstimate(self):
        r"""
        Accessor to the first order indices estimate.

        Returns
        -------
        estimate : :class:`~openturns.Point`
            Estimate of the first order indices.
        """
        return _experimental.SobolSimulationResult_getFirstOrderIndicesEstimate(self)

    def getTotalOrderIndicesEstimate(self):
        r"""
        Accessor to the total order indices estimate.

        Returns
        -------
        estimate : :class:`~openturns.Point`
            Estimate of the total order indices.
        """
        return _experimental.SobolSimulationResult_getTotalOrderIndicesEstimate(self)

    def setFirstOrderIndicesDistribution(self, firstOrderIndicesDistribution):
        r"""
        Accessor to the first order indices distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the first order indices.
        """
        return _experimental.SobolSimulationResult_setFirstOrderIndicesDistribution(self, firstOrderIndicesDistribution)

    def setTotalOrderIndicesDistribution(self, totalOrderIndicesDistribution):
        r"""
        Accessor to the total order indices distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the total order indices.
        """
        return _experimental.SobolSimulationResult_setTotalOrderIndicesDistribution(self, totalOrderIndicesDistribution)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Accessor to the first order indices distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the first order indices.
        """
        return _experimental.SobolSimulationResult_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Accessor to the total order indices distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the total order indices.
        """
        return _experimental.SobolSimulationResult_getTotalOrderIndicesDistribution(self)

    def setExperimentSize(self, experimentSize):
        r"""
        Accessor to the experiment size.

        Parameters
        ----------
        size : int
            Internal size :math:`N` of the Sobol design of experiment.
            See :class:`~openturns.SobolIndicesExperiment`
        """
        return _experimental.SobolSimulationResult_setExperimentSize(self, experimentSize)

    def getExperimentSize(self):
        r"""
        Accessor to the experiment size.

        Returns
        -------
        size : int
            Internal size :math:`N` of the Sobol design of experiment.
            See :class:`~openturns.SobolIndicesExperiment`
        """
        return _experimental.SobolSimulationResult_getExperimentSize(self)

    def __repr__(self):
        return _experimental.SobolSimulationResult___repr__(self)

    def draw(self, confidenceLevel=0.95):
        r"""
        Draw sensitivity indices.

        Parameters
        ----------
        confidence_level : float, default=0.95
            Confidence level for intervals

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.
        """
        return _experimental.SobolSimulationResult_draw(self, confidenceLevel)

    def __init__(self, *args):
        _experimental.SobolSimulationResult_swiginit(self, _experimental.new_SobolSimulationResult(*args))
    __swig_destroy__ = _experimental.delete_SobolSimulationResult

# Register SobolSimulationResult in _experimental:
_experimental.SobolSimulationResult_swigregister(SobolSimulationResult)
class SobolSimulationAlgorithm(SimulationAlgorithm):
    r"""
    Sobol indices computation using iterative sampling.

    The algorithm uses sampling of the distribution of the random vector :math:`\vect{X}` through the model :math:`f`
    to iteratively estimate the Sobol indices.

    At each iteration a Sobol' experiment is generated and evaluated by blocks through the model :math:`f`.
    Then the distribution of the indices (first and total order) is computed on this current replication sample.
    At the end of each iteration we update the global distribution of the indices.

    Parameters
    ----------
    X : :class:`~openturns.Distribution`
        The random vector to study.
    f : :class:`~openturns.Function`
        The function to study.
    estimator : :class:`~openturns.SobolIndicesAlgorithm`
        The estimator of the indices.

    Notes
    -----
    The algorithm can operate on a multivariate model :math:`f`, in this case it operates on aggregated indices.

    Several estimators are available (Saltelli, Jansen, ...).

    Let us denote by :math:`n_X` the number of input variables. 
    For any :math:`j = 1, \ldots, n_X`, let us denote by :math:`\Phi_j^F` (resp. :math:`\Phi_j^T`) the cumulative distribution 
    function of the gaussian asymptotic distribution of the estimator 
    of the Sobol' first (resp. total) order indice.
    Let :math:`\alpha\in[0,1]` be the level of the confidence interval and :math:`\epsilon\in(0,1]` the 
    length of this confidence interval. 
    The algorithms stops when, on all components, first and total order indices haved been 
    estimated with enough precision.

    The precision is said to be sufficient if the length of the :math:`\alpha`-level confidence interval 
    is smaller than :math:`\epsilon`:

    .. math::

        (\Phi_j^F)^{-1}(1-\alpha/2) - (\Phi_j^F)^{-1}(\alpha/2) \leq \epsilon \textrm{ and } 
        (\Phi_j^T)^{-1}(1-\alpha/2) - (\Phi_j^T)^{-1}(\alpha/2) \leq \epsilon

    for all :math:`j = 1, \ldots, n_X`.

    The total number of samples evaluated by the algorithm is :math:`n_{iter} \times N \times (2 + n_X)` (no second order indices) where

    - :math:`n_{iter}` is the actual number of outer iterations, as caped by :meth:`setMaximumOuterSampling`
    - :math:`N` is the internal size of the Sobol' experiment, as set by :meth:`setExperimentSize`
    - :math:`n_X` is the input dimension

    That is why unlike other simulation algorithms the total of evaluations is not equal to
    the product of iterations (obtained by `getOuterSampling` from the result) by the block size (:meth:`getBlockSize`).

    This class makes use of the following :class:`~openturns.ResourceMap` entries:

    - `SobolSimulationAlgorithm-DefaultIndexQuantileLevel`: default float value for the confidence level :math:`\alpha`
    - `SobolSimulationAlgorithm-DefaultIndexQuantileEpsilon`: default float value for the confidence length :math:`\epsilon`
    - `SobolSimulationAlgorithm-DefaultExperimentSize`: default integer value for :math:`N`

    See also
    --------
    SobolSimulationResult, SobolIndicesExperiment, SobolIndicesAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> model = ot.SymbolicFunction(['x1', 'x2', 'x3'], ['x1*x2+x3'])
    >>> estimator = ot.SaltelliSensitivityAlgorithm()
    >>> estimator.setUseAsymptoticDistribution(True)
    >>> algo = ot.SobolSimulationAlgorithm(distribution, model, estimator)
    >>> algo.setMaximumOuterSampling(25)  # maximum number of iterations
    >>> algo.setExperimentSize(100)  # size of Sobol experiment at each iteration
    >>> algo.setBlockSize(4) # number of points evaluated simultaneously
    >>> algo.setIndexQuantileLevel(0.05)  # alpha
    >>> algo.setIndexQuantileEpsilon(1e-2)  # epsilon
    >>> algo.run()
    >>> result = algo.getResult()
    >>> fo = result.getFirstOrderIndicesEstimate()
    >>> foDist = result.getFirstOrderIndicesDistribution()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SobolSimulationAlgorithm_getClassName(self)

    def __init__(self, *args):
        _experimental.SobolSimulationAlgorithm_swiginit(self, _experimental.new_SobolSimulationAlgorithm(*args))

    def getDistribution(self):
        r"""
        Accessor to the batch size.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the random variable.
        """
        return _experimental.SobolSimulationAlgorithm_getDistribution(self)

    def getResult(self):
        r"""
        Accessor to the result.

        Returns
        -------
        result : :class:`~openturns.SobolSimulationResult`
            The simulation result.
        """
        return _experimental.SobolSimulationAlgorithm_getResult(self)

    def setIndexQuantileLevel(self, indexQuantileLevel):
        r"""
        Accessor to the quantile level.

        Parameters
        ----------
        alpha : float
            The quantile level.
        """
        return _experimental.SobolSimulationAlgorithm_setIndexQuantileLevel(self, indexQuantileLevel)

    def getIndexQuantileLevel(self):
        r"""
        Accessor to the quantile level.

        Returns
        -------
        alpha : float
            The quantile level.
        """
        return _experimental.SobolSimulationAlgorithm_getIndexQuantileLevel(self)

    def setIndexQuantileEpsilon(self, indexQuantileEpsilon):
        r"""
        Accessor to the quantile tolerance.

        Parameters
        ----------
        epsilon : float
            The quantile tolerance
        """
        return _experimental.SobolSimulationAlgorithm_setIndexQuantileEpsilon(self, indexQuantileEpsilon)

    def getIndexQuantileEpsilon(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        epsilon : float
            The quantile tolerance
        """
        return _experimental.SobolSimulationAlgorithm_getIndexQuantileEpsilon(self)

    def setEstimator(self, estimator):
        r"""
        Sobol estimator accessor.

        Parameters
        ----------
        estimator : :class:`~openturns.SobolIndicesAlgorithm`
            The estimator of the indices.
        """
        return _experimental.SobolSimulationAlgorithm_setEstimator(self, estimator)

    def getEstimator(self):
        r"""
        Sobol estimator accessor.

        Returns
        -------
        estimator : :class:`~openturns.SobolIndicesAlgorithm`
            The estimator of the indices.
        """
        return _experimental.SobolSimulationAlgorithm_getEstimator(self)

    def setExperimentSize(self, experimentSize):
        r"""
        Accessor to the experiment size.

        Parameters
        ----------
        size : int
            Internal size :math:`N` of the Sobol design of experiment.
            See :class:`~openturns.SobolIndicesExperiment`
        """
        return _experimental.SobolSimulationAlgorithm_setExperimentSize(self, experimentSize)

    def getExperimentSize(self):
        r"""
        Accessor to the experiment size.

        Returns
        -------
        size : int
            Internal size :math:`N` of the Sobol design of experiment.
            See :class:`~openturns.SobolIndicesExperiment`
        """
        return _experimental.SobolSimulationAlgorithm_getExperimentSize(self)

    def __repr__(self):
        return _experimental.SobolSimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.SobolSimulationAlgorithm_run(self)

    def drawFirstOrderIndexConvergence(self, *args):
        r"""
        Draw the first order Sobol index convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _experimental.SobolSimulationAlgorithm_drawFirstOrderIndexConvergence(self, *args)

    def drawTotalOrderIndexConvergence(self, *args):
        r"""
        Draw the total order Sobol index convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _experimental.SobolSimulationAlgorithm_drawTotalOrderIndexConvergence(self, *args)
    __swig_destroy__ = _experimental.delete_SobolSimulationAlgorithm

# Register SobolSimulationAlgorithm in _experimental:
_experimental.SobolSimulationAlgorithm_swigregister(SobolSimulationAlgorithm)
class NAISResult(ProbabilitySimulationResult):
    r"""
    NAIS result.

    See also
    --------
    NAIS, SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.NAISResult_getClassName(self)

    def getAuxiliaryInputSample(self):
        r"""
        Accessor of the auxiliary distribution input sample at the final NAIS step.

        Returns
        -------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final NAIS step.
        """
        return _experimental.NAISResult_getAuxiliaryInputSample(self)

    def setAuxiliaryInputSample(self, auxiliaryInputSample):
        r"""
        Accessor of the auxiliary distribution input sample at the final NAIS step.

        Parameters
        ----------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final NAIS step.
        """
        return _experimental.NAISResult_setAuxiliaryInputSample(self, auxiliaryInputSample)

    def getWeights(self):
        r"""
        Auxiliary distribution input sample associated weights accessor of the final NAIS step.

        Returns
        -------
        weights : :class:`~openturns.Point`
            Auxiliary distribution input sample associated weights.
        """
        return _experimental.NAISResult_getWeights(self)

    def setWeights(self, weights):
        r"""
        Auxiliary distribution input sample associated weights accessor of the final NAIS step.

        Parameters
        ----------
        weights : :class:`~openturns.Point`
            Auxiliary distribution input sample associated weights.
        """
        return _experimental.NAISResult_setWeights(self, weights)

    def getAuxiliaryOutputSample(self):
        r"""
        Accessor of the auxiliary distribution output sample at the final NAIS step.

        Returns
        -------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final NAIS step.
        """
        return _experimental.NAISResult_getAuxiliaryOutputSample(self)

    def setAuxiliaryOutputSample(self, auxiliaryInputSample):
        r"""
        Accessor of the auxiliary distribution output sample at the final NAIS step.

        Parameters
        ----------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final NAIS step.
        """
        return _experimental.NAISResult_setAuxiliaryOutputSample(self, auxiliaryInputSample)

    def getAuxiliaryDistribution(self):
        r"""
        Accessor of the auxiliary distribution at the final NAIS step.

        Returns
        -------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final NAIS step.
        """
        return _experimental.NAISResult_getAuxiliaryDistribution(self)

    def setAuxiliaryDistribution(self, auxiliaryDistribution):
        r"""
        Accessor of the auxiliary distribution at the final NAIS step.

        Parameters
        ----------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final NAIS step.
        """
        return _experimental.NAISResult_setAuxiliaryDistribution(self, auxiliaryDistribution)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _experimental.NAISResult_getCoefficientOfVariation(self)

    def __init__(self, *args):
        _experimental.NAISResult_swiginit(self, _experimental.new_NAISResult(*args))
    __swig_destroy__ = _experimental.delete_NAISResult

# Register NAISResult in _experimental:
_experimental.NAISResult_swigregister(NAISResult)
class NAIS(EventSimulation):
    r"""
    Nonparametric Adaptive Importance Sampling (NAIS) algorithm.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.

    quantileLevel : float  :math:`0<quantileLevel<1`
        Intermediate quantile level.

    Notes
    -----
    The following explanations are given for a failure event defined as :math:`g(\mathbf{X})<T` with :math:`\mathbf{X}` 
    a random vector following a joint PDF :math:`f_\mathbf{X}`, :math:`T` a threshold and :math:`g` a limit state function,
    without loss of generality.

    The Importance Sampling (IS) probability estimate :math:`\widehat{P}^\text{IS}` is given by:

    .. math::

        \widehat{P}^\text{IS}=\frac{1}{N} \sum_{i=1}^{N} {\mathbf{1}}_{g(\mathbf{x}_i)<T} \frac{h_0(\mathbf{x}_i)}{h(\mathbf{x}_i)},

    with :math:`h_0 = f_\mathbf{X}` the PDF of :math:`\mathbf{X}`, :math:`h` the auxiliary PDF of Importance Sampling, 
    :math:`N` the number of independent samples generated with :math:`h` and :math:`{\mathbf{1}}_{g(\mathbf{x}_i)<T}` the 
    indicator function of the failure domain. 

    The optimal density minimizing the variance of the estimator :math:`h_{opt}` is defined as:

    .. math::

        h_{opt}=\frac{{\mathbf{1}}_{g(x)<T}h_0}{P},

    with :math:`P` the failure probability which is inaccessible in practice since this probability is the quantity of interest
    and unknown. 

    The objective of Non parametric Adaptive Importance Sampling (NAIS) [morio2015]_ is to approximate 
    the IS optimal auxiliary density :math:`h_{opt}` from the preceding equation 
    with a kernel density function (e.g. Gaussian kernel). 
    Its iterative principle is described by the following steps.

    1. :math:`k=1` and set the quantile level :math:`\rho \in [0,1]`

    2. Generate the population :math:`\mathbf{x}_1^{(k)},...,\mathbf{x}_N^{(k)}` according to the PDF :math:`h_{k-1}`, apply the 
       function :math:`g` in order to have :math:`y_1^{(k)}=g(\mathbf{x}_1^{(k)}),...,y_N^{(k)} = g(\mathbf{x}_N^{(k)})`

    3. Compute the empirical quantile of level :math:`\rho` :math:`q_k=\max(T,y^{(k)}_{\left \lfloor \rho N \right\rfloor})`

    4. Estimate :math:`I_k= \frac{1}{kN} \displaystyle \sum_{j=1}^{k}\sum_{i=1}^{N} {\mathbf{1}}_{g(\mathbf{x}_i^{(j)}) \leq q_k} \frac{h_0(\mathbf{x}_i^{(j)})}{h_{j-1}(\mathbf{x}_i^{(j)})}` 

    5. Update the Gaussian kernel sampling PDF with:

       .. math::

           h_{k}(\mathbf{x})=\frac{1}{k N I_k \det\left(B_{k+1}\right)}\sum_{j=1}^{k}\sum_{i=1}^{N}  w_{j}(\mathbf{x}_i^{(j)})K_d\left(B_{k+1}^{-1}\left(\mathbf{x}-\mathbf{x}_i^{(j)}\right)\right)

       where :math:`K_d` is the PDF of the standard :math:`d`-dimensional normal distribution,
       :math:`B_{k+1}=\text{diag}(b^1_{k+1},...,b^d_{k+1})` 
       and :math:`w_j={\mathbf{1}}_{g(\mathbf{x}_i^{(j)}) \leq q_k} \frac{h_0(\mathbf{x}_i^{(j)})}{h_{j-1}(\mathbf{x}_i^{(j)})}`. 
       The coefficients of the matrix :math:`B_{k+1}` can be approximated (Silverman Rule) or postulated according to the AMISE 
       (Asymptotic Mean Integrated Square Error) criterion for example.

    6. If :math:`q_k>T`, :math:`k\leftarrow k+1`, go to Step 2

    7. Estimate the probability :math:`\widehat{P}^{NAIS}(g(\mathbf{\mathbf{X}}<T))=\frac{1}{N}\displaystyle \sum_{i=1}^{N} \mathbf{1}_{g(\mathbf{x}_i^{(k)})<T} \frac{h_0(\mathbf{x}_i^{(k)})}{h_{k-1}(\mathbf{x}_i^{(k)})}`

    The NAIS algorithm with the Silverman rule is implemented in the current NAIS class.

    See also
    --------
    SubsetSampling

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # We create the function defining the limit state
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> # We define a joint PDF of interest 
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.CompositeRandomVector(myFunction, vect)
    >>> # We create an event from this RandomVector
    >>> myEvent = ot.ThresholdEvent(output, ot.Less(), -10.0)
    >>> # We create a NAIS algorithm
    >>> algo = ot.NAIS(myEvent, 0.1)
    >>> # Perform the simulation
    >>> algo.run()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.NAIS_getClassName(self)

    def getQuantileLevel(self):
        r"""
        Accessor to the intermediate quantile level.

        Returns
        -------
        quantileLevel : float
            Intermediate quantile level.
        """
        return _experimental.NAIS_getQuantileLevel(self)

    def setQuantileLevel(self, quantileLevel):
        r"""
        Accessor to the intermediate quantile level.

        Parameters
        ----------
        quantileLevel : float  :math:`0<quantileLevel<1`
            Intermediate quantile level.
        """
        return _experimental.NAIS_setQuantileLevel(self, quantileLevel)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        openturns.EventSimulation.setBlockSize
        openturns.EventSimulation.setMaximumOuterSampling
        openturns.ResourceMap
        openturns.SimulationResult
        """
        return _experimental.NAIS_run(self)

    def getResult(self):
        r"""
        Accessor to the results.

        Returns
        -------
        results : :class:`~openturns.SimulationResult`
            Structure containing all the results obtained after simulation and created
            by the method :py:meth:`run`.
        """
        return _experimental.NAIS_getResult(self)

    def getThresholdPerStep(self):
        r"""
        Threshold accessor.

        Returns
        -------
        threshold : :class:`~openturns.Point`
            Threshold values at each step.
        """
        return _experimental.NAIS_getThresholdPerStep(self)

    def getStepsNumber(self):
        r"""
        Subset steps number accessor.

        Returns
        -------
        n : int
            Number of subset steps, including the initial Monte Carlo sampling.
        """
        return _experimental.NAIS_getStepsNumber(self)

    def setKeepSample(self, keepSample):
        r"""
        Sample storage accessor.

        Parameters
        ----------
        keepsample : bool
            Whether to keep the working samples at each iteration.
        """
        return _experimental.NAIS_setKeepSample(self, keepSample)
    EVENT0 = _experimental.NAIS_EVENT0
    EVENT1 = _experimental.NAIS_EVENT1
    BOTH = _experimental.NAIS_BOTH

    def getInputSample(self, *args):
        r"""
        Input sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _experimental.NAIS_getInputSample(self, *args)

    def getOutputSample(self, *args):
        r"""
        Output sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample.
        """
        return _experimental.NAIS_getOutputSample(self, *args)

    def __init__(self, *args):
        _experimental.NAIS_swiginit(self, _experimental.new_NAIS(*args))
    __swig_destroy__ = _experimental.delete_NAIS

# Register NAIS in _experimental:
_experimental.NAIS_swigregister(NAIS)
class CrossEntropyResult(ProbabilitySimulationResult):
    r"""
    Cross Entropy result.

    See also
    --------
    CrossEntropyImportanceSampling, PhysicalSpaceCrossEntropyImportanceSampling, StandardSpaceCrossEntropyImportanceSampling
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.CrossEntropyResult_getClassName(self)

    def getAuxiliaryInputSample(self):
        r"""
        Accessor to the auxiliary distribution input sample at the final Cross Entropy algorithm step.

        Returns
        -------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_getAuxiliaryInputSample(self)

    def setAuxiliaryInputSample(self, auxiliaryInputSample):
        r"""
        Accessor to the auxiliary distribution input sample at the final Cross Entropy algorithm step.

        Parameters
        ----------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_setAuxiliaryInputSample(self, auxiliaryInputSample)

    def getAuxiliaryOutputSample(self):
        r"""
        Accessor to the auxiliary distribution output sample at the final Cross Entropy algorithm step.

        Returns
        -------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_getAuxiliaryOutputSample(self)

    def setAuxiliaryOutputSample(self, auxiliaryInputSample):
        r"""
        Accessor to the auxiliary distribution output sample at the final Cross Entropy algorithm step.

        Parameters
        ----------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_setAuxiliaryOutputSample(self, auxiliaryInputSample)

    def getAuxiliaryDistribution(self):
        r"""
        Accessor to the auxiliary distribution at the final Cross Entropy algorithm step.

        Returns
        -------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_getAuxiliaryDistribution(self)

    def setAuxiliaryDistribution(self, auxiliaryDistribution):
        r"""
        Accessor to the auxiliary distribution at the final Cross Entropy algorithm step.

        Parameters
        ----------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_setAuxiliaryDistribution(self, auxiliaryDistribution)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _experimental.CrossEntropyResult_getCoefficientOfVariation(self)

    def __init__(self, *args):
        _experimental.CrossEntropyResult_swiginit(self, _experimental.new_CrossEntropyResult(*args))
    __swig_destroy__ = _experimental.delete_CrossEntropyResult

# Register CrossEntropyResult in _experimental:
_experimental.CrossEntropyResult_swigregister(CrossEntropyResult)
class CrossEntropyImportanceSampling(EventSimulation):
    r"""
    Cross-Entropy Importance Sampling algorithm.

    See also
    --------
    StandardSpaceCrossEntropyImportanceSampling, PhysicalSpaceCrossEntropyImportanceSampling, CrossEntropyResult

    Notes
    -----
    This class inherits from :class:`~openturns.EventSimulation`.

    The principle is to perform a simulation study to evaluate the threshold exceedance probability according to an importance density obtained using Cross Entropy algorithm.

    A CrossEntropyImportanceSampling object can be created only through its derivative classes,
    :class:`~openturns.StandardSpaceCrossEntropyImportanceSampling` or :class:`~openturns.PhysicalSpaceCrossEntropyImportanceSampling`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.CrossEntropyImportanceSampling_getClassName(self)

    def getQuantileLevel(self):
        r"""
        Accessor to the intermediate quantile level.

        Returns
        -------
        quantileLevel : float
            Result of Cross Entropy algorithm.
        """
        return _experimental.CrossEntropyImportanceSampling_getQuantileLevel(self)

    def setQuantileLevel(self, quantileLevel):
        r"""
        Accessor to the intermediate quantile level.

        Parameters
        ----------
        quantileLevel : float
            Intermediate quantile level, must belong to the interval (0,1).
        """
        return _experimental.CrossEntropyImportanceSampling_setQuantileLevel(self, quantileLevel)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        openturns.EventSimulation.setBlockSize
        openturns.EventSimulation.setMaximumOuterSampling
        openturns.ResourceMap
        openturns.SimulationResult
        """
        return _experimental.CrossEntropyImportanceSampling_run(self)

    def getResult(self):
        r"""
        Accessor to the intermediate quantile level.

        Returns
        -------
        CrossEntropyResult : :class:`~openturns.CrossEntropyResult`
            Contains all the results of the Cross Entropy algorithm simulation.
        """
        return _experimental.CrossEntropyImportanceSampling_getResult(self)

    def getThresholdPerStep(self):
        r"""
        Threshold accessor.

        Returns
        -------
        threshold : :class:`~openturns.Point`
            Threshold values at each step.
        """
        return _experimental.CrossEntropyImportanceSampling_getThresholdPerStep(self)

    def getStepsNumber(self):
        r"""
        Subset steps number accessor.

        Returns
        -------
        n : int
            Number of subset steps, including the initial Monte Carlo sampling.
        """
        return _experimental.CrossEntropyImportanceSampling_getStepsNumber(self)

    def setKeepSample(self, keepSample):
        r"""
        Sample storage accessor.

        Parameters
        ----------
        keepsample : bool
            Whether to keep the working samples at each iteration.
        """
        return _experimental.CrossEntropyImportanceSampling_setKeepSample(self, keepSample)
    EVENT0 = _experimental.CrossEntropyImportanceSampling_EVENT0
    EVENT1 = _experimental.CrossEntropyImportanceSampling_EVENT1
    BOTH = _experimental.CrossEntropyImportanceSampling_BOTH

    def getInputSample(self, *args):
        r"""
        Input sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _experimental.CrossEntropyImportanceSampling_getInputSample(self, *args)

    def getOutputSample(self, *args):
        r"""
        Output sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample.
        """
        return _experimental.CrossEntropyImportanceSampling_getOutputSample(self, *args)

    def __init__(self, *args):
        _experimental.CrossEntropyImportanceSampling_swiginit(self, _experimental.new_CrossEntropyImportanceSampling(*args))
    __swig_destroy__ = _experimental.delete_CrossEntropyImportanceSampling

# Register CrossEntropyImportanceSampling in _experimental:
_experimental.CrossEntropyImportanceSampling_swigregister(CrossEntropyImportanceSampling)
class StandardSpaceCrossEntropyImportanceSampling(CrossEntropyImportanceSampling):
    r"""
    Standard Space Cross-Entropy Importance Sampling.

    Parameters
    ----------
    event : :class:`~openturns.ThresholdEvent`
        Event we are computing the probability of.

    quantileLevel : float  :math:`0<quantileLevel<1`
        Intermediate quantile level. The default number can be tweaked with the `CrossEntropyImportanceSampling-DefaultQuantileLevel` key from :class:`~openturns.ResourceMap`.

    Notes
    -----
    The following explanations are given for a failure event defined as :math:`g(\vect{X})<T` with :math:`\vect{X}` 
    a random vector following a joint PDF :math:`f_\vect{X}`, :math:`T` a threshold and :math:`g` a limit state function,
    without loss of generality.

    The Importance Sampling (IS) probability estimate :math:`\widehat{P}^\text{IS}` is given by:

    .. math::

        \widehat{P}^\text{IS}=\frac{1}{N} \sum_{i=1}^{N} {\vect{1}}_{g(\vect{x}_i)<T} \frac{f_\vect{X}(\vect{x}_i)}{h(\vect{x}_i)},

    with :math:`h` the auxiliary PDF of Importance Sampling, 
    :math:`N` the number of independent samples generated with :math:`h` and :math:`{\vect{1}}_{g(\vect{x}_i)<T}` the 
    indicator function of the failure domain. 

    The optimal density :math:`h_{opt}` minimizing the variance of the estimator :math:`h_{opt}` is defined as:

    .. math::

        h_{opt}=\frac{{\vect{1}}_{g(\vect{x})<T}f_\vect{X}}{P},

    with :math:`P` the failure probability which is inaccessible in practice since this probability is the quantity of interest and unknown.

    The Standard Space Cross-Entropy Importance Sampling [rubinstein2017]_ uses a parametric auxiliary distribution :math:`h_\vect{\lambda}` in order to optimize its parameters to compute the probability of interest with accuracy. 
    This process is performed in the standard space using a Normal distribution as the auxiliary distribution. Indeed, in the standard space, the optimal value of the mean and standard deviations are given analytically, see [morio2015]_ for details. 

    We note  :math:`G(\vect{u})` the limit state function in standard space and  :math:`g(\vect{x})` its counterpart in the physical space. :math:`f_\vect{U}` stands for the initial distribution in standard space, i.e. the Normal law. The algorithm is as follows:


    1. :math:`k=1`, set the quantile level :math:`\rho \in [0,1]` and :math:`h_0 = f_{\vect{U}}`

    2. Generate the population :math:`\vect{u}_1^{(k)},...,\vect{u}_N^{(k)}` according to the PDF :math:`h_{k-1}`, apply the 
       function :math:`G` in order to have :math:`y_1^{(k)}=G(\vect{u}_1^{(k)}),...,y_N^{(k)} = G(\vect{u}_N^{(k)})`

    3. Compute the   :math:`\rho`-quantile :math:`q_k=\max(T,y^{(k)}_{\left \lfloor \rho N \right\rfloor})` using the floor of :math:`\rho N`.

    4. If :math:`q_k>T`, go to Step 7

    4. Update the mean and standard deviation of the auxiliary distribution:

    .. math::

           \mu_{k}= \frac{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} \vect{u}_i^{(k)}}{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} }

    .. math::

           \sigma_{k}= \frac{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} (\vect{u}_i^{(k)}-\mu_k)^2}{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} }


    6. :math:`k\leftarrow k+1`, go to Step 2

    7. Estimate the probability :math:`\widehat{P}^{CE}(g(\vect{\vect{X}})<T)=\widehat{P}^{CE}(G(\vect{\vect{U}})<T)=\frac{1}{N}\displaystyle \sum_{i=1}^{N} \vect{1}_{G(\vect{u}_i^{(k)})<T} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}(\vect{u}_i^{(k)})}}`




    See also
    --------
    PhysicalSpaceCrossEntropyImportanceSampling, CrossEntropyImportanceSampling, CrossEntropyResult


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution_R = ot.LogNormalMuSigma(300.0, 30.0, 0.0).getDistribution()
    >>> distribution_F = ot.Normal(75e3, 5e3)
    >>> marginals = [distribution_R, distribution_F]
    >>> distribution = ot.JointDistribution(marginals)
    >>> # create the model
    >>> model = ot.SymbolicFunction(['R', 'F'], ['R - F / (pi_ * 100.0)'])  
    >>> # create the event 
    >>> vect = ot.RandomVector(distribution)
    >>> g = ot.CompositeRandomVector(model, vect)
    >>> event = ot.ThresholdEvent(g, ot.Less(), 0.0)
    >>> myIS = ot.StandardSpaceCrossEntropyImportanceSampling(event, 0.3)
    >>> # run StandardSpaceCrossEntropyImportanceSampling
    >>> myIS.run()
    >>> myResult = myIS.getResult()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.StandardSpaceCrossEntropyImportanceSampling_getClassName(self)

    def __init__(self, *args):
        _experimental.StandardSpaceCrossEntropyImportanceSampling_swiginit(self, _experimental.new_StandardSpaceCrossEntropyImportanceSampling(*args))
    __swig_destroy__ = _experimental.delete_StandardSpaceCrossEntropyImportanceSampling

# Register StandardSpaceCrossEntropyImportanceSampling in _experimental:
_experimental.StandardSpaceCrossEntropyImportanceSampling_swigregister(StandardSpaceCrossEntropyImportanceSampling)
class PhysicalSpaceCrossEntropyImportanceSampling(CrossEntropyImportanceSampling):
    r"""
    Physical Space Cross-Entropy Importance Sampling.

    Parameters
    ----------
    event : :class:`~openturns.ThresholdEvent`
        Event we are computing the probability of.

    activeParameters : sequence of integers
        List of active parameters indices for the auxiliary distribution.

    initialAuxiliaryDistributionParameters : sequence of floats
        Initial value of active parameters of the auxiliary distribution.

    bounds : :class:`~openturns.Interval`
        Bounds on the active parameters of the auxiliary distribution.

    auxiliaryDistribution : :class:`~openturns.Distribution`
        Auxiliary distribution for the Cross Entropy Importance Sampling algorithm.

    quantileLevel : float  :math:`0<quantileLevel<1`
        Intermediate quantile level. The default number can be tweaked with the `CrossEntropyImportanceSampling-DefaultQuantileLevel` key from :class:`~openturns.ResourceMap`.

    Notes
    -----    

    The following explanations are given for a failure event defined as :math:`g(\vect{X})<T` with :math:`\vect{X}` 
    a random vector following a joint PDF :math:`f_\vect{X}`, :math:`T` a threshold and :math:`g` a limit state function,
    without loss of generality.

    The Importance Sampling (IS) probability estimate :math:`\widehat{P}^\text{IS}` is given by:

    .. math::

        \widehat{P}^\text{IS}=\frac{1}{N} \sum_{i=1}^{N} {\vect{1}}_{g(\vect{x}_i)<T} \frac{f_\vect{X}(\vect{x}_i)}{h(\vect{x}_i)},

    with :math:`h` the auxiliary PDF of Importance Sampling, 
    :math:`N` the number of independent samples generated with :math:`h` and :math:`{\vect{1}}_{g(\vect{x}_i)<T}` the 
    indicator function of the failure domain. 

    The optimal density :math:`h_{opt}` minimizing the variance of the estimator is defined as:

    .. math::

        h_{opt}=\frac{{\vect{1}}_{g(\vect{x})<T}f_\vect{X}}{P},

    with :math:`P` the failure probability which is inaccessible in practice since this probability is the quantity of interest
    and unknown.

    The Physical Space Cross-Entropy Importance Sampling algorithm [rubinstein2017]_ uses a parametric auxiliary distribution :math:`h_\vect{\lambda}` in order to optimize its parameters to compute the probability of interest with accuracy.

    It involves an auxiliary optimization problem to find the auxiliary distribution parameters :math:`\vect{\lambda}` minimizing the Kullback-Leibler divergence with respect to :math:`h_{opt}`. The following algorithm is used:

    1. :math:`k=1`, set the quantile level :math:`\rho \in [0,1]` and :math:`h_0 = f_{\vect{X}}`

    2. Generate the population :math:`\vect{x}_1^{(k)},...,\vect{x}_N^{(k)}` according to the PDF :math:`h_{k-1}`, apply the 
       function :math:`g` in order to have :math:`y_1^{(k)}=g(\vect{x}_1^{(k)}),...,y_N^{(k)} = g(\vect{x}_N^{(k)})`

    3. Compute the empirical :math:`\rho`-quantile :math:`q_k=\max(T,y^{(k)}_{\left \lfloor \rho N \right\rfloor})` using the floor of :math:`\rho N`.

    4. If :math:`q_k>T`: go to Step 7

    5. Estimate the auxiliary distribution parameters:

       .. math::

           \vect{\lambda}_{k}= \textrm{argmax}_{\lambda} \frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{g(\vect{x}_i^{(k)}) \leq q_k} \frac{f_\vect{X}(\vect{x}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{x}_i^{(k)})} \log(h_{\vect{\lambda}}(\vect{x}_i^{(k)}))

    6. :math:`k\leftarrow k+1`, go to Step 2

    7. Estimate the probability :math:`\widehat{P}^{CE}(g(\vect{\vect{X}})<T)=\frac{1}{N}\displaystyle \sum_{i=1}^{N} \vect{1}_{g(\vect{x}_i^{(k)})<T} \frac{f_\vect{X}(\vect{x}_i^{(k)})}{h_{\vect{\lambda}_{k-1}(\vect{x}_i^{(k)})}}`.


    Default solver for the optimization of auxiliary distribution is `LD_LBFGS` from :class:`~openturns.NLopt`.

    See also
    --------
    StandardSpaceCrossEntropyImportanceSampling, CrossEntropyImportanceSampling, CrossEntropyResult


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution_R = ot.LogNormalMuSigma(300.0, 30.0, 0.0).getDistribution()
    >>> distribution_F = ot.Normal(75e3, 5e3)
    >>> marginals = [distribution_R, distribution_F]
    >>> distribution = ot.JointDistribution(marginals)
    >>> # create the model
    >>> model = ot.SymbolicFunction(['R', 'F'], ['R-F/(pi_*100.0)'])   
    >>> # create the event 
    >>> vect = ot.RandomVector(distribution)
    >>> G = ot.CompositeRandomVector(model, vect)
    >>> event = ot.ThresholdEvent(G, ot.Less(), 0.0)
    >>> distribution_marginR = ot.LogNormalMuSigma().getDistribution()
    >>> distribution_marginF = ot.Normal()
    >>> aux_marginals = [distribution_marginR, distribution_marginF]
    >>> aux_distribution = ot.JointDistribution(aux_marginals)
    >>> # definition of auxiliary distribution parameters to be optimized
    >>> active_parameters = [0,1,2,3,4]
    >>> ### WARNING : native parameters of distribution have to be considered
    >>> bounds = ot.Interval([3,0.09,0.,50e3,2e3], [7,0.5,0.5,100e3,10e3])# bounds on the active parameters
    >>> initial_theta= [5.70,0.1,0.,75e3,5e3] # initial value of the active parameters
    >>> my_IS_physical = ot.PhysicalSpaceCrossEntropyImportanceSampling(event,aux_distribution,active_parameters,initial_theta,bounds,0.3)
    >>> my_IS_physical.run()
    >>> myResult = my_IS_physical.getResult()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PhysicalSpaceCrossEntropyImportanceSampling_getClassName(self)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the optimization algorithm used to update auxiliary distribution parameters.

        Parameters
        ----------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
        """
        return _experimental.PhysicalSpaceCrossEntropyImportanceSampling_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the optimization algorithm used to update auxiliary distribution parameters.

        Returns
        -------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
        """
        return _experimental.PhysicalSpaceCrossEntropyImportanceSampling_getOptimizationAlgorithm(self)

    def __init__(self, *args):
        _experimental.PhysicalSpaceCrossEntropyImportanceSampling_swiginit(self, _experimental.new_PhysicalSpaceCrossEntropyImportanceSampling(*args))
    __swig_destroy__ = _experimental.delete_PhysicalSpaceCrossEntropyImportanceSampling

# Register PhysicalSpaceCrossEntropyImportanceSampling in _experimental:
_experimental.PhysicalSpaceCrossEntropyImportanceSampling_swigregister(PhysicalSpaceCrossEntropyImportanceSampling)
class _RootStrategyImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_experimental._RootStrategyImplementationPointer_ptr__get, _experimental._RootStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        _experimental._RootStrategyImplementationPointer_swiginit(self, _experimental.new__RootStrategyImplementationPointer(*args))
    __swig_destroy__ = _experimental.delete__RootStrategyImplementationPointer

    def reset(self):
        return _experimental._RootStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _experimental._RootStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _experimental._RootStrategyImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _experimental._RootStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _experimental._RootStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _experimental._RootStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _experimental._RootStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _experimental._RootStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _experimental._RootStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _experimental._RootStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental._RootStrategyImplementationPointer_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental._RootStrategyImplementationPointer_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental._RootStrategyImplementationPointer_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental._RootStrategyImplementationPointer_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental._RootStrategyImplementationPointer_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental._RootStrategyImplementationPointer_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental._RootStrategyImplementationPointer_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental._RootStrategyImplementationPointer_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental._RootStrategyImplementationPointer_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental._RootStrategyImplementationPointer_getOriginValue(self)

    def __repr__(self):
        return _experimental._RootStrategyImplementationPointer___repr__(self)

    def __eq__(self, other):
        return _experimental._RootStrategyImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _experimental._RootStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _experimental._RootStrategyImplementationPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _experimental._RootStrategyImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _experimental._RootStrategyImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _experimental._RootStrategyImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experimental._RootStrategyImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experimental._RootStrategyImplementationPointer_setName(self, name)

# Register _RootStrategyImplementationPointer in _experimental:
_experimental._RootStrategyImplementationPointer_swigregister(_RootStrategyImplementationPointer)
class _SamplingStrategyImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_experimental._SamplingStrategyImplementationPointer_ptr__get, _experimental._SamplingStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        _experimental._SamplingStrategyImplementationPointer_swiginit(self, _experimental.new__SamplingStrategyImplementationPointer(*args))
    __swig_destroy__ = _experimental.delete__SamplingStrategyImplementationPointer

    def reset(self):
        return _experimental._SamplingStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _experimental._SamplingStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _experimental._SamplingStrategyImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _experimental._SamplingStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _experimental._SamplingStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _experimental._SamplingStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _experimental._SamplingStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _experimental._SamplingStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _experimental._SamplingStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _experimental._SamplingStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental._SamplingStrategyImplementationPointer_getClassName(self)

    def generate(self):
        r"""
        Generate the directions.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The directions generated  according to the sampling strategy.

        Notes
        -----
        The sample is the collection of the points on the unit sphere in the standard space
        associated to the generated directions.
        """
        return _experimental._SamplingStrategyImplementationPointer_generate(self)

    def getUniformUnitVectorRealization(self, *args):
        r"""
        Accessor to a realization according to the uniform distribution.

        Parameters
        ----------
        dimension : int
            The dimension of the sphere unity (which is the dimension of the standard
            space).

        Returns
        -------
        sample : :class:`~openturns.Point`
            The realization of a vector on the sphere unity, according to the uniform
            distribution.
        """
        return _experimental._SamplingStrategyImplementationPointer_getUniformUnitVectorRealization(self, *args)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental._SamplingStrategyImplementationPointer_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental._SamplingStrategyImplementationPointer_getDimension(self)

    def __repr__(self):
        return _experimental._SamplingStrategyImplementationPointer___repr__(self)

    def __eq__(self, other):
        return _experimental._SamplingStrategyImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _experimental._SamplingStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _experimental._SamplingStrategyImplementationPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _experimental._SamplingStrategyImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _experimental._SamplingStrategyImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _experimental._SamplingStrategyImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experimental._SamplingStrategyImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experimental._SamplingStrategyImplementationPointer_setName(self, name)

# Register _SamplingStrategyImplementationPointer in _experimental:
_experimental._SamplingStrategyImplementationPointer_swigregister(_SamplingStrategyImplementationPointer)
import openturns.model_process
import openturns.dist_bundle1
class CubaIntegration(openturns.algo.IntegrationAlgorithmImplementation):
    r"""
    Multidimensional integration algorithms.

    Parameters
    ----------
    algorithmName : str
        The name of the integration routine to use. It must be 'cuhre', 'divonne',
        'suave', or 'vegas'.

    Notes
    -----
    The Cuba algorithms enable one to approximate the definite integral:

    .. math::

        \int_{I_n} f(x_1, ..., x_n) \di{x_1}...\di{x_n}


    which takes values in :math:`\Rset^p`, with :math:`f: \Rset^n \mapsto \Rset^p`,
    :math:`I_n=[a_1, b_1]\times\cdots\times[a_n, b_n]\subset\Rset^n`,
    having :math:`a_i<b_i` for all :math:`i=1,...,n`.

    The four available integration routines work on vector integrands. While Cuhre
    is deterministic, the three other ones use Monte Carlo methods. Cuhre employs a
    cubature rule for subregion estimation in an adaptative subdivision scheme.
    Divonne works by stratified sampling. Suave combines techniques from importance
    sampling and subregion sampling. Vegas uses importance sampling for variance
    reduction. The result is returned as a :class:`~openturns.Point` of dimension
    :math:`p`, which is the number of components of the return value of the
    :class:`~openturns.Function` that one will integrate.

    All the integration routines and the parameters are discussed in [hahn2005]_.

    Examples
    --------
    Create a Cuba algorithm:

    >>> import openturns.experimental as otexp
    >>> algo = otexp.CubaIntegration('vegas')

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.CubaIntegration_getClassName(self)

    def integrate(self, *args):
        r"""
        Evaluation of the integral of :math:`f w` on an interval.

        Parameters
        ----------
        f : :class:`~openturns.Function`, :math:`f: \Rset^n \mapsto \Rset^p`
            The integrand function.
        interval : :class:`~openturns.Interval`, :math:`interval \subset \Rset^n` 
            The integration domain.

        Returns
        -------
        value : :class:`~openturns.Point`
            Approximation of the integral. Its dimension is :math:`p`.

        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> f = ot.SymbolicFunction(['x', 'y', 'z'], ['sin(x) * cos(y) * exp(z)'])
        >>> interval = ot.Interval([0.0] * 3, [1.0] * 3)
        >>> algoC = otexp.CubaIntegration('vegas')
        >>> value = algoC.integrate(f, interval)  # doctest: +SKIP

        """
        return _experimental.CubaIntegration_integrate(self, *args)

    def getMaximumRelativeError(self):
        r"""
        Accessor to the relative accuracy required in the integration.

        Returns
        -------
        maximumRelativeError : float
            The relative accuracy that the *integrate* method attempts to achieve.
        """
        return _experimental.CubaIntegration_getMaximumRelativeError(self)

    def setMaximumRelativeError(self, maximumRelativeError):
        r"""
        Accessor to the relative accuracy required in the integration.

        Parameters
        ----------
        maximumRelativeError : float
            The relative accuracy that the *integrate* method attempts to achieve.
        """
        return _experimental.CubaIntegration_setMaximumRelativeError(self, maximumRelativeError)

    def getMaximumAbsoluteError(self):
        r"""
        Accessor to the absolute accuracy required in the integration.

        Returns
        -------
        maximumAbsoluteError : float
            The absolute accuracy that the *integrate* method attempts to achieve.
        """
        return _experimental.CubaIntegration_getMaximumAbsoluteError(self)

    def setMaximumAbsoluteError(self, maximumAbsoluteError):
        r"""
        Accessor to the absolute accuracy required in the integration.

        Parameters
        ----------
        maximumAbsoluteError : float
            The absolute accuracy that the *integrate* method attempts to achieve.
        """
        return _experimental.CubaIntegration_setMaximumAbsoluteError(self, maximumAbsoluteError)

    def getAlgorithmName(self):
        r"""
        Accessor to the name of the integration routine to be used.

        Returns
        -------
        algorithmName : str
            The name of the integration routine used by the algorithm.
        """
        return _experimental.CubaIntegration_getAlgorithmName(self)

    def setAlgorithmName(self, optAlgo):
        r"""
        Accessor to the name of the integration routine to be used.

        Parameters
        ----------
        algorithmName : str
            The name of the integration routine used by the algorithm. It must be 'cuhre', 'divonne', 'suave', or 'vegas'.
        """
        return _experimental.CubaIntegration_setAlgorithmName(self, optAlgo)

    def getMaximumCallsNumber(self):
        r"""
        Accessor to the maximal number of integrand calls.

        Returns
        -------
        N : int
            The maximal number of times the algorithm will attempt to call the integrand.
        """
        return _experimental.CubaIntegration_getMaximumCallsNumber(self)

    def setMaximumCallsNumber(self, maximumCallsNumber):
        r"""
        Accessor to the maximal number of integrand calls.

        Parameters
        ----------
        N : int, :math:`N>0`
            The maximal number of times the algorithm will attempt to call the integrand.
        """
        return _experimental.CubaIntegration_setMaximumCallsNumber(self, maximumCallsNumber)

    @staticmethod
    def GetAlgorithmNames():
        r"""
        Retrieves the names of the available integration algorithms.

        Returns
        -------
        algoName : :class:`~openturns.Description`
            The names of the available integration algorithms.
        """
        return _experimental.CubaIntegration_GetAlgorithmNames()

    def __repr__(self):
        return _experimental.CubaIntegration___repr__(self)

    def __str__(self, *args):
        return _experimental.CubaIntegration___str__(self, *args)

    def __init__(self, *args):
        _experimental.CubaIntegration_swiginit(self, _experimental.new_CubaIntegration(*args))
    __swig_destroy__ = _experimental.delete_CubaIntegration

# Register CubaIntegration in _experimental:
_experimental.CubaIntegration_swigregister(CubaIntegration)
class PointToFieldFunctionalChaosAlgorithm(openturns.common.PersistentObject):
    r"""
    Functional metamodel algorithm based on chaos decomposition.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    The present algorithm makes it possible to build a response surface of the
    function :math:`h` defined by the equation:

    .. math::
        h: \left|
          \begin{array}{ccl}
             \Rset^p & \rightarrow & \cM_N \times (\Rset^d)^N \\
             \vect{X} & \mapsto & \mat{Y}
          \end{array}
        \right.

    with :math:`\cM_N` a mesh of :math:`\cD \subset \Rset^n`.

    The mapping :math:`h` is known from the :math:`N` vectors :math:`(\vect{X}_1, \dots, \vect{X}_N)`
    of the associated input random vector :math:`\vect{X}` and :math:`N` fields :math:`(\mat{Y}_1,\dots,\mat{Y}_N)`
    that fully characterize the output process :math:`\mat{Y}`.

    The linear projection function :math:`\pi_{ \vect{\lambda}, \vect{\varphi}}` of
    the Karhunen-Loeve decomposition by SVD is used to project the output fields
    (see :class:`~openturns.KarhunenLoeveSVDAlgorithm` and :class:`~openturns.KarhunenLoeveAlgorithm` for the notations):

    .. math::
        \pi_{\vect{\lambda}, \vect{\varphi}}: \left|
          \begin{array}{ccl}
            L^2(\cD, \Rset^d) & \rightarrow & \cS^{\Nset} \\
            f & \mapsto &\left(\dfrac{1}{\sqrt{\lambda_k}}\int_{\cD}f(\vect{t}) \vect{\varphi}_k(\vect{t})\, d\vect{t}\right)_{k \geq 1}
          \end{array}
        \right.

    where :math:`\cS^{\Nset}  = \left \{ (\zeta_k)_{k \geq 1} \in  \Rset^{\Nset} \, | \, \sum_{k=1}^{\infty}\lambda_k \zeta_k^2 < +\infty \right \}`.

    The Karhunen-Loeve algorithm allows one to replace this integral by a specific weighted and finite sum
    and to write the projections of the j-th marginal of i-th output field :math:`\mat{Y}_i^j` by multiplication
    with the projection matrix :math:`\mat{M}_j \in \Rset^{K_j} \times \Rset^{Nd}`:

    .. math::

        \mat{M}_j \mat{Y}_i^j = \left( \begin{array}{l} \xi_1^j \\ \vdots \\ \xi_{K_j}^j \end{array} \right)
        \in \Rset^{K_j}, \quad \forall i \in [1, n], \forall j \in [1, d]

    with :math:`K_j` the retained number of modes in the decomposition of the j-th output.
    The projections of all the :math:`d` components of :math:`n` fields are assembled in the :math:`\mat{Q}` matrix:

    .. math::

        \begin{align*}
            \mat{Q} = \mat{M} \mat{Y} =
            \left(
              \begin{array}{l}
                \mat{M}_1 \mat{Y}^1 \\
                \vdots \\
                \mat{M}_d \mat{Y}^d
              \end{array}
            \right) \in \Rset^{K_T} \times \Rset^n
         \end{align*}

    with :math:`K_T = \sum_{j=1}^d{K_j}` the total number of modes across output components.

    Then a functional chaos decomposition is built between the input samples :math:`\vect{X}`
    and the projected modes sample :math:`\mat{Q}`.
    The :class:`~openturns.ResourceMap` string entry `PointToFieldFunctionalChaosAlgorithm-Expansion`
    allows one to switch between :class:`~openturns.LeastSquaresExpansion` and :class:`~openturns.FunctionalChaosAlgorithm`.

    .. math::

        \tilde{g}(x) = \sum_{k=1}^{K_c} \beta_{\vect{\alpha}_k} \Psi_{\vect{\alpha}_k}(x)

    with :math:`K_c` the number of terms in the chaos decomposition.

    The final metamodel consists in the composition of the functional chaos metamodel
    and the Karhunen-Loeve projections.

    .. math::
        \tilde{h}: \left|
          \begin{array}{ccccl}
             \Rset^p & \rightarrow & \Rset^{K_T} & \rightarrow & \cM_N \times (\Rset^d)^N\\
             \vect{X} & \mapsto & \vect{Q} & \mapsto & \mat{Y}
          \end{array}
        \right.

    Here the projected modes sample has a dimension :math:`K_T` but being on the output side
    of the functional chaos expansion (FCE) this approach is not affected by the curse of dimensionality,
    it will just require as much FCE marginals runs.

    Parameters
    ----------
    x : :class:`~openturns.Sample`
        Input sample.
    y : :class:`~openturns.ProcessSample`
        Output process sample.
    distribution : :class:`~openturns.Distribution`
        Input distribution

    See Also
    --------
    openturns.FieldToPointFunctionalChaosAlgorithm
    openturns.FieldFunctionalChaosSobolIndices
    openturns.KarhunenLoeveAlgorithm
    openturns.FunctionalChaosAlgorithm

    Notes
    -----
    As the output process decomposition is done with the values decomposition approach,
    it is possible to control the number of modes retained per output,
    the idea being to avoid a large output dimension for the chaos decomposition step.
    As done in :class:`~openturns.KarhunenLoeveSVDAlgorithm`, the :func:`setThreshold`
    and :func:`setNbModes` methods allow one to control the spectrum ratio and maximum count.

    In the case of homogenous data (if variables have the same unit or scale),
    it is also possible to recompress the modes at the global level with :func:`setRecompress`.
    When enabled, the eigenvalues are gathered and sorted so as to find a global
    spectrum cut-off value by which the spectrum of each output is truncated.
    The default value can be set through the :class:`~openturns.ResourceMap` key
    *PointToFieldFunctionalChaosAlgorithm-DefaultRecompress*.

    For the chaos metamodel step, it is possible to specify the basis size with
    the :class:`~openturns.ResourceMap` key *FunctionalChaosAlgorithm-BasisSize*.

    It is possible to partition output variables into independent blocks with :func:`setBlockIndices`.
    This way Karhunen-Loeve process decompositions are done on each block rather
    than on all output variables at once (at the price of increased chaos decomposition output dimension)
    which then makes sensitivity analysis possible for each output variable
    or group of output variables.

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> ot.RandomGenerator.SetSeed(0)
    >>> mesh = ot.RegularGrid(0.0, 0.1, 20)
    >>> X = ot.Normal(4)
    >>> x = X.getSample(50)
    >>> g = ot.SymbolicFunction(['t', 'x1', 'x2', 'x3', 'x4'], ['x1 + x2 * sin(t)', 'x2 + x3 * cos(t)', 'x4 * t'])
    >>> f = ot.VertexValuePointToFieldFunction(g, mesh)
    >>> y = f(x)
    >>> algo = otexp.PointToFieldFunctionalChaosAlgorithm(x, y, X)
    >>> algo.setThreshold(4e-2)
    >>> # Temporarily lower the basis size for the sake of this example.
    >>> ot.ResourceMap.SetAsUnsignedInteger('FunctionalChaosAlgorithm-BasisSize', 100)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> metamodel = result.getPointToFieldMetaModel()
    >>> y0hat = metamodel(x[0])
    >>> ot.ResourceMap.Reload()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_getClassName(self)

    def getInputSample(self):
        r"""
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_getInputSample(self)

    def getOutputProcessSample(self):
        r"""
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.ProcessSample`
            Output sample.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_getOutputProcessSample(self)

    def getBlockIndices(self):
        r"""
        Accessor to the output block indices.

        Returns
        -------
        blockIndices : :class:`~openturns.IndicesCollection`
            Independent output components indices.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_getBlockIndices(self)

    def setBlockIndices(self, blockIndices):
        r"""
        Accessor to the output block indices.

        Parameters
        ----------
        blockIndices : 2-d sequence of int
            Independent output components indices.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_setBlockIndices(self, blockIndices)

    def getThreshold(self):
        r"""
        Accessor to the eigenvalues cutoff ratio.

        Returns
        -------
        s : float, :math:`\geq 0`
            The threshold :math:`s`.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_getThreshold(self)

    def setThreshold(self, threshold):
        r"""
        Accessor to the eigenvalues cutoff ratio.

        Parameters
        ----------
        s : float, :math:`\geq 0`
            The threshold :math:`s`.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_setThreshold(self, threshold)

    def getNbModes(self):
        r"""
        Accessor to the maximum number of modes to compute.

        Returns
        -------
        n : int
            The maximum number of modes to compute.
            The actual number of modes also depends on the threshold criterion.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_getNbModes(self)

    def setNbModes(self, nbModes):
        r"""
        Accessor to the maximum number of modes to compute.

        Parameters
        ----------
        n : int
            The maximum number of modes to compute.
            The actual number of modes also depends on the threshold criterion.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_setNbModes(self, nbModes)

    def getRecompress(self):
        r"""
        Accessor to the recompression flag.

        Returns
        -------
        recompress : bool
            Whether to recompress the output Karhunen-Loeve decompositions.
            This can only be enabled if the scale of the output variable blocks is the same.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_getRecompress(self)

    def setRecompress(self, recompress):
        r"""
        Accessor to the recompression flag.

        Parameters
        ----------
        recompress : bool
            Whether to recompress the output Karhunen-Loeve decompositions.
            The modes are truncated a second time according to a global eigen value
            bound across output decompositions.
            This can only be enabled if the scale of the output variable blocks is the same.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_setRecompress(self, recompress)

    def __repr__(self):
        return _experimental.PointToFieldFunctionalChaosAlgorithm___repr__(self)

    def run(self):
        r"""
        Compute the response surfaces.

        Notes
        -----
        It computes the response surfaces and creates a
        :class:`~openturns.MetaModelResult` structure containing all the results.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_run(self)

    def getResult(self):
        r"""
        Result accessor.

        Returns
        -------
        result : :class:`openturns.FieldFunctionalChaosResult`
            Result class.
        """
        return _experimental.PointToFieldFunctionalChaosAlgorithm_getResult(self)

    def __init__(self, *args):
        _experimental.PointToFieldFunctionalChaosAlgorithm_swiginit(self, _experimental.new_PointToFieldFunctionalChaosAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_PointToFieldFunctionalChaosAlgorithm

# Register PointToFieldFunctionalChaosAlgorithm in _experimental:
_experimental.PointToFieldFunctionalChaosAlgorithm_swigregister(PointToFieldFunctionalChaosAlgorithm)
class SequentialSamplingAlgorithmImplementation(openturns.common.PersistentObject):
    r"""
    Approximation algorithm.

    Notes
    -----
    This class is not usable because it has sense only within the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SequentialSamplingAlgorithmImplementation_getClassName(self)

    def getInputSample(self):
        r"""
        Accessor to the input sample.

        Returns
        -------
        x : :class:`~openturns.Sample`
            Input sample
        """
        return _experimental.SequentialSamplingAlgorithmImplementation_getInputSample(self)

    def getOutputSample(self):
        r"""
        Accessor to the output sample.

        Returns
        -------
        y : :class:`~openturns.Sample`
            Input sample
        """
        return _experimental.SequentialSamplingAlgorithmImplementation_getOutputSample(self)

    def getGenerationIndices(self):
        r"""
        Accessor to the generation indices.

        Returns
        -------
        generationIndices : :class:`~openturns.Indices`
            Indices of last element for each generation.
            This is updated each time the `update()` method is evaluated.
        """
        return _experimental.SequentialSamplingAlgorithmImplementation_getGenerationIndices(self)

    def __repr__(self):
        return _experimental.SequentialSamplingAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _experimental.SequentialSamplingAlgorithmImplementation___str__(self, *args)

    def generate(self, size=1):
        r"""
        Generate a new sample.

        Parameters
        ----------
        size : int
            Size of sample to generate

        Returns
        -------
        x : :class:`~openturns.Sample`
            New input sample.

        """
        return _experimental.SequentialSamplingAlgorithmImplementation_generate(self, size)

    def update(self, x, y):
        r"""
        Update the current sample.

        Adds a new incremental sample (input and output) to the existing sample.

        Parameters
        ----------
        x, y : :class:`~openturns.Sample`
            New incremental sample.

        """
        return _experimental.SequentialSamplingAlgorithmImplementation_update(self, x, y)

    def __init__(self, *args):
        _experimental.SequentialSamplingAlgorithmImplementation_swiginit(self, _experimental.new_SequentialSamplingAlgorithmImplementation(*args))
    __swig_destroy__ = _experimental.delete_SequentialSamplingAlgorithmImplementation

# Register SequentialSamplingAlgorithmImplementation in _experimental:
_experimental.SequentialSamplingAlgorithmImplementation_swigregister(SequentialSamplingAlgorithmImplementation)
class _SequentialSamplingAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _experimental._SequentialSamplingAlgorithmImplementationTypedInterfaceObject_swiginit(self, _experimental.new__SequentialSamplingAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _experimental._SequentialSamplingAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experimental._SequentialSamplingAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experimental._SequentialSamplingAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _experimental._SequentialSamplingAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _experimental._SequentialSamplingAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _experimental.delete__SequentialSamplingAlgorithmImplementationTypedInterfaceObject

# Register _SequentialSamplingAlgorithmImplementationTypedInterfaceObject in _experimental:
_experimental._SequentialSamplingAlgorithmImplementationTypedInterfaceObject_swigregister(_SequentialSamplingAlgorithmImplementationTypedInterfaceObject)
class SequentialSamplingAlgorithm(_SequentialSamplingAlgorithmImplementationTypedInterfaceObject):
    r"""
    Approximation algorithm.

    Notes
    -----
    This class is not usable because it has sense only within the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SequentialSamplingAlgorithm_getClassName(self)

    def getInputSample(self):
        r"""
        Accessor to the input sample.

        Returns
        -------
        x : :class:`~openturns.Sample`
            Input sample
        """
        return _experimental.SequentialSamplingAlgorithm_getInputSample(self)

    def getOutputSample(self):
        r"""
        Accessor to the output sample.

        Returns
        -------
        y : :class:`~openturns.Sample`
            Input sample
        """
        return _experimental.SequentialSamplingAlgorithm_getOutputSample(self)

    def getGenerationIndices(self):
        r"""
        Accessor to the generation indices.

        Returns
        -------
        generationIndices : :class:`~openturns.Indices`
            Indices of last element for each generation.
            This is updated each time the `update()` method is evaluated.
        """
        return _experimental.SequentialSamplingAlgorithm_getGenerationIndices(self)

    def __repr__(self):
        return _experimental.SequentialSamplingAlgorithm___repr__(self)

    def __str__(self, *args):
        return _experimental.SequentialSamplingAlgorithm___str__(self, *args)

    def generate(self, size=1):
        r"""
        Generate a new sample.

        Parameters
        ----------
        size : int
            Size of sample to generate

        Returns
        -------
        x : :class:`~openturns.Sample`
            New input sample.

        """
        return _experimental.SequentialSamplingAlgorithm_generate(self, size)

    def update(self, x, y):
        r"""
        Update the current sample.

        Adds a new incremental sample (input and output) to the existing sample.

        Parameters
        ----------
        x, y : :class:`~openturns.Sample`
            New incremental sample.

        """
        return _experimental.SequentialSamplingAlgorithm_update(self, x, y)

    def __init__(self, *args):
        _experimental.SequentialSamplingAlgorithm_swiginit(self, _experimental.new_SequentialSamplingAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_SequentialSamplingAlgorithm

# Register SequentialSamplingAlgorithm in _experimental:
_experimental.SequentialSamplingAlgorithm_swigregister(SequentialSamplingAlgorithm)
class LOLAVoronoi(SequentialSamplingAlgorithmImplementation):
    r"""
    LOLA-Voronoi sequential design algorithm.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    This class implements the design of experiments algorithm described in [crombecq2011]_ which allows one
    to sequentially generate new input samples according to the input measure and model output.
    It combines an exploration criterion based on Voronoi tesselation to identify
    undersampled input design regions and an exploitation criterion based on a measure
    of the nonlinearity of the model.

    Lets define a random vector :math:`\vect{X}` with measure :math:`\inputMeasure(\vect{x})` and dimension :math:`d`,
    :math:`\sampleSize` initial points :math:`\vect{p}_i, \forall i \in [1,\sampleSize]` and a model :math:`\model`.

    The exploration criterion score of the point :math:`\vect{p}_i` is equal to the probability of its Voronoi cell,
    which can be written as:

    .. math::

        v(\vect{p}_i)
        &= \int_{\vect{x} \in \mathcal{V}_i} \inputMeasure(\vect{x}) d\vect{x} \\
        &= \Expect{1_{\mathcal{V}_i}(\vect{X})}

    for :math:`i \in\{1, ..., \sampleSize\}` where :math:`\sampleSize` is the sample size and :math:`1_{\mathcal{V}_i}`
    is the indicator function of the `i`-th Voronoi cell:

    .. math::
        1_{\mathcal{V}_i}(\vect{x}) = 
        \begin{cases}
        1 & \textrm{ if } \vect{x} \in \mathcal{V}_i \\
        0 & \textrm{otherwise.}
        \end{cases}

    The Voronoi score is approximated using a Monte Carlo experiment.

    For the nonlinearity criterion the algorithm only uses the data available and chooses a
    set of neighbouring samples :math:`N(\vect{p}_i) = \{\vect{p}_{i1}, \hdots, \vect{p}_{im}\}`
    with :math:`m = 2 d` to build the gradient approximation of the model :math:`\model`
    at the point :math:`\vect{p}_i`, denoted by :math:`\mat{J}_i`.

    The LOLA algorithm local nonlinearity score of the point :math:`\vect{p}_{r}` is the cumulated error between the model
    and the linear approximation built from its neighbourhood.
    For each component :math:`\model_k` of the model, the local nonlinearity score is given by:

    .. math::

        e_k(\vect{p}_r) = \sum_{i=1}^m | \model_k(\vect{p}_{ri}) - (\model_k(\vect{p}_r) + \mat{J}_i(\vect{p}_{ri} - \vect{p}_r)) |

    for :math:`i \in \{1, ..., \sampleSize\}` where :math:`\model` is the model
    and :math:`\model(\vect{p}_{r}) + \mat{J}_i (\vect{p}_{ri} - \vect{p}_{r})`
    is its linear approximation in the neighbourhood of the point :math:`\vect{p}_{r}`.

    In order to aggregate all the :math:`e_k(\vect{p}_r) \forall k \in [1, d_Y]`, we can use two different norms:

    .. math::

        e(\vect{p}_r) = \frac{1}{d_Y} \sum_{k=1}^{d_Y} e_k(\vect{p}_r)

    or

    .. math::

        e(\vect{p}_r) = \max_{k=1, .. d_Y} e_k(\vect{p}_r)

    Now the two metrics are combined into the hybrid score given by:

    .. math::

        h(\vect{p}_i) = \lambda v(\vect{p}_i) + (1 - \lambda) \frac{e(\vect{p}_i)}{\sum_{j=1}^n e(\vect{p}_j)}

    for :math:`i \in \{1, ..., \sampleSize\}`, with :math:`\lambda` a tradeoff coefficient.

    To generate a new point, random points are generated by Monte Carlo close to
    the reference point :math:`\vect{p}_i` with highest hybrid score.
    The new point is selected among the generated sample inside the Voronoi cell of :math:`\vect{p}_i`
    and farthest away from :math:`\vect{p}_i` and its neighbours.
    To generate a batch of :math:`n_{new}` points this procedure is repeated on the :math:`n_{new}`
    reference points with highest hybrid score taking into account the voronoi cells of the new candidates.

    Parameters
    ----------
    x : 2-d sequence of float
        Initial input sample
    y : 2-d sequence of float
        Initial output sample
    distribution : :class:`~openturns.Distribution`
        Distribution to generate new input samples

    Notes
    -----
    Various :class:`~openturns.ResourceMap` entries allow for a more fine-grained control over the algorithm:

    - The entry `LOLAVoronoi-DefaultNeighbourhoodCandidatesNumber` defines the number of extra closest neighbours
      around each reference point to consider for selection of the neighbourhood with greatest combined score used for the LOLA criterion.
    - The entry `LOLAVoronoi-DefaultVoronoiSamplingSize` controls the sampling size used
      to estimate the Voronoi cells relative volume or generate new candidates.
    - The entry `LOLAVoronoi-MaximumCombinationsNumber` controls the maximum
      number of existing point subsets will be tested to get the best neighbourhood for the exploitation criterion.
    - The entry `LOLAVoronoi-UseTruncatedDistribution` controls the way the :math:`\inputMeasure(\vect{x})` distribution is truncated
      to the bounding box `B` of the Voronoi cell being sampled.
      If the flag is set to False, the sampling is done by a rejection method with respect to :math:`\inputMeasure(\vect{x})` and `B`.
      The advantage is to avoid the expensive computation of the normalization factor of the truncation of :math:`\inputMeasure(\vect{x})`.
      The drawback is that the acceptation rate might be low.
      If the flag is set to True, the truncated distribution of :math:`\inputMeasure(\vect{x})` to `B` is explicitly built and sampled.
      The advantage is to possibly use the CDF inversion method to sample this truncated distribution: all the points are accepted.
      But the CDF inversion method is only available if the copula of :math:`\inputMeasure(\vect{x})` is the independent one:
      otherwise a rejection method is used and the advantage of this option is lost.
      The drawback is the automatic computation of the normalization factor of the truncation of :math:`\inputMeasure(\vect{x})`
      which is used only if the CDF inversion method is used.
      As a result, the default value is False.
    - The string entry `LOLAVoronoi-NonLinearityAggregationMethod` controls how the non-linearity score is computed
      across multiple outputs from the gradient vectors: either `Maximum` (default) to distinguish the most nonlinear regions
      or `Average` that will smooth the score but can be a good alternative when there are only a few outputs.
    - The string entry `LOLAVoronoi-DecompositionMethod` selects the least-squares method to compute the gradient.
    - The float entry `LOLAVoronoi-HybridScoreTradeoff` is the value of the tradeoff coefficient :math:`\lambda`.

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> formula = '-4 * exp((-25 / 8) * (a0^2 + a1^2)) + 7 * exp((-125 / 4) * (a0^2 + a1^2))'
    >>> f1 = ot.SymbolicFunction(['a0', 'a1'], [formula])
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 2)
    >>> x0 = ot.LowDiscrepancyExperiment(ot.HaltonSequence(), distribution, 10).generate()
    >>> y0 = f1(x0)
    >>> algo = otexp.LOLAVoronoi(x0, y0, distribution)

    Now add 2 blocks of 3 points:

    >>> for i in range(2):
    ...     x = algo.generate(3)
    ...     y = f1(x)
    ...     algo.update(x, y)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.LOLAVoronoi_getClassName(self)

    def __repr__(self):
        return _experimental.LOLAVoronoi___repr__(self)

    def generate(self, size):
        r"""
        Generate a new sample.

        Parameters
        ----------
        size : int
            Size of sample to generate

        Returns
        -------
        x : :class:`~openturns.Sample`
            New input sample.

        """
        return _experimental.LOLAVoronoi_generate(self, size)

    def setVoronoiSamplingSize(self, voronoiSamplingSize):
        r"""
        Voronoi sampling size accessor.

        Parameters
        ----------
        voronoiSamplingSize : int
            The sampling size used to estimate the Voronoi cells relative volume or generate new candidates.
            The default value is set to the `LOLAVoronoi-DefaultVoronoiSamplingSize` entry from :class:`~openturns.ResourceMap`.

        """
        return _experimental.LOLAVoronoi_setVoronoiSamplingSize(self, voronoiSamplingSize)

    def getVoronoiSamplingSize(self):
        r"""
        Voronoi sampling size accessor.

        Returns
        -------
        voronoiSamplingSize : int
            The sampling size used to estimate the Voronoi cells relative volume or generate new candidates.
            The default value is set to the `LOLAVoronoi-DefaultVoronoiSamplingSize` entry from :class:`~openturns.ResourceMap`.

        """
        return _experimental.LOLAVoronoi_getVoronoiSamplingSize(self)

    def setNeighbourhoodCandidatesNumber(self, neighbourhoodCandidatesNumber):
        r"""
        Neighbourhood candidates number accessor.

        Parameters
        ----------
        neighbourhoodCandidatesNumber : int
            The number of extra closest neighbour around each reference point to consider
            for selection of the neighbourhood with greatest combined score used for the LOLA criterion.
            The default value is set to the `LOLAVoronoi-DefaultNeighbourhoodCandidatesNumber` entry from :class:`~openturns.ResourceMap`.

        """
        return _experimental.LOLAVoronoi_setNeighbourhoodCandidatesNumber(self, neighbourhoodCandidatesNumber)

    def getNeighbourhoodCandidatesNumber(self):
        r"""
        Neighbourhood candidates number accessor.

        Returns
        -------
        neighbourhoodCandidatesNumber : int
            The number of extra closest neighbour around each reference point to consider
            for selection of the neighbourhood with greatest combined score used for the LOLA criterion.
            The default value is set to the `LOLAVoronoi-DefaultNeighbourhoodCandidatesNumber` entry from :class:`~openturns.ResourceMap`.

        """
        return _experimental.LOLAVoronoi_getNeighbourhoodCandidatesNumber(self)

    def getLOLAScore(self):
        r"""
        LOLA score accessor.

        Returns
        -------
        lolaScore : :class:`~openturns.Sample`
            The exploitation score :math:`e(p_i)` for the current sample.
            Note that unlike :math:`v(p_i)` this is scaled in :math:`[0, 1]`.

        """
        return _experimental.LOLAVoronoi_getLOLAScore(self)

    def getVoronoiScore(self):
        r"""
        Voronoi score accessor.

        Returns
        -------
        voronoiScore : :class:`~openturns.Sample`
            The exploration score :math:`v(p_i)` for the current sample.

        """
        return _experimental.LOLAVoronoi_getVoronoiScore(self)

    def getHybridScore(self):
        r"""
        Hybrid score accessor.

        Returns
        -------
        hybridScore : :class:`~openturns.Sample`
            The hybrid score :math:`h(p_i)` for the current sample.

        """
        return _experimental.LOLAVoronoi_getHybridScore(self)

    def __init__(self, *args):
        _experimental.LOLAVoronoi_swiginit(self, _experimental.new_LOLAVoronoi(*args))
    __swig_destroy__ = _experimental.delete_LOLAVoronoi

# Register LOLAVoronoi in _experimental:
_experimental.LOLAVoronoi_swigregister(LOLAVoronoi)
class QuantileConfidence(openturns.common.PersistentObject):
    r"""
    Estimate confidence intervals of a quantile.

    Refer to :ref:`quantile_confidence_estimation`.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    alpha : float
        Quantile level
    beta : float, optional
        Confidence level. Default value is 0.95

    Notes
    -----
    This class estimates bounds of the quantile of level :math:`\alpha \in [0,1]` of the random variable :math:`X`
    with a confidence greater than :math:`\beta` using a given order statistics.

    Let :math:`x_{\alpha}` be the unknown quantile of level :math:`\alpha` of the random variable :math:`X` of dimension 1.
    Let :math:`(X_1, \dots, X_\sampleSize)` be a sample of independent and identically distributed variables according to :math:`X`.

    The bounds of the interval are computed from order statistics that we now introduce.
    Let :math:`X_{(k)}` be the :math:`k` -th order statistics of :math:`(X_1, \dots, X_\sampleSize)` which means that
    :math:`X_{(k)}` is the :math:`k` -th maximum of :math:`(X_1, \dots, X_\sampleSize)` for :math:`1 \leq k \leq \sampleSize`.

    For example, :math:`X_{(1)} = \min (X_1, \dots, X_\sampleSize)` is the minimum
    and :math:`X_{(\sampleSize)} = \max (X_1, \dots, X_\sampleSize)` is the maximum.

    We have:

    .. math::

        X_{(1)} \leq X_{(2)} \leq \dots \leq X_{(\sampleSize)}

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> alpha = 0.05
    >>> beta = 0.95
    >>> sample = ot.Gumbel().getSample(100)
    >>> algo = otexp.QuantileConfidence(alpha, beta)
    >>> ci = algo.computeUnilateralConfidenceInterval(sample)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.QuantileConfidence_getClassName(self)

    def computeUnilateralRank(self, size, tail=False):
        r"""
        Evaluate an unilateral rank of a quantile.

        The lower tail rank :math:`k_{low}` is the largest integer :math:`k` such that:

        .. math::

            \Prob{X_{(k)} \leq x_{\alpha}} \geq \beta.

        In other words, the interval :math:`\left[ X_{(k_{low})}, +\infty\right[` is a unilateral confidence
        interval for the quantile :math:`x_\alpha` with confidence :math:`\beta`.

        It is given by:

        .. math::

            k_{low} = \overline{F}^{-1}_{n, \alpha}(\beta)

        where :math:`\overline{F}^{-1}_{n, \alpha}` is the complementary quantile function 
        of the binomial distribution with parameters :math:`n` and :math:`\alpha`.

        The problem has a solution only if:

        .. math::

            1 - (1 - \alpha)^n \geq \beta.

        The upper tail rank :math:`k_{up}` is the smallest integer :math:`k` such that:

        .. math::

            \Prob{x_{\alpha} \leq X_{(k)}} \geq \beta.

        In other words, the interval :math:`\left]-\infty, X_{(k_{up})}\right]` is a unilateral confidence
        interval for the quantile :math:`x_\alpha` with confidence :math:`\beta`.
        The solution is:

        .. math::

            k_{up} = F^{-1}_{n, \alpha}(\beta)

        where :math:`F^{-1}_{n, \alpha}` is the quantile function of the cumulative distribution function of the 
        binomial distribution with parameters :math:`n` and :math:`\alpha`.
        The problem has a solution only if:

        .. math::

            1 - \alpha^n \geq \beta.

        Parameters
        ----------
        size : int
            Sample size
        tail : bool, optional
            True indicates the interval is bounded by a lower value.
            False indicates the interval is bounded by an upper value. Default value is False.

        Returns
        -------
        rank : int
            Rank :math:`k \in \{0, \hdots, n-1\}`

        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> alpha = 0.05
        >>> beta = 0.95
        >>> algo = otexp.QuantileConfidence(alpha, beta)
        >>> rank = algo.computeUnilateralRank(100)
        >>> print(rank)
        9

        """
        return _experimental.QuantileConfidence_computeUnilateralRank(self, size, tail)

    def computeBilateralRank(self, size):
        r"""
        Evaluate the bilateral rank of a quantile.

        The bilateral ranks :math:`k_1, k_2` are the integers minimizing the probability:

        .. math::

            \argmin_{0 \leq k_1 \leq k_2 \leq n - 1 \, | \, \Prob{k_1 < X \leq k_2} \geq \beta} \Prob{k_1 < X \leq k_2}

        where :math:`X \sim \cB(n, \alpha)` is the binomial distribution with parameters :math:`n` and :math:`\alpha`.

        so that:

        .. math::

            \Prob{X_{(k_1)} \leq x_{\alpha} \leq X_{(k_2)}} \geq \beta.

        These ranks exist only if:

        .. math::

            1 - \alpha^n - (1-\alpha)^n \ge \beta.

        Parameters
        ----------
        size : int
            Sample size :math:`n`

        Returns
        -------
        ranks : :class:`~openturns.Indices` of size 2
            Pair of lower and upper ranks :math:`(k_1, k_2)` such that :math:`0 \leq k_1 \leq k_2 \leq n - 1`.

        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> alpha = 0.05
        >>> beta = 0.95
        >>> algo = otexp.QuantileConfidence(alpha, beta)
        >>> k1, k2 = algo.computeBilateralRank(100)
        >>> print((k1, k2))
        (1, 10)

        """
        return _experimental.QuantileConfidence_computeBilateralRank(self, size)

    def computeUnilateralConfidenceInterval(self, sample, tail=False):
        r"""
        Evaluate an unilateral confidence interval of a quantile.

        The lower tail confidence interval is given by the order statistics:

        .. math::

            [X_{(k_{low})}, +\infty[

        so that:

        .. math::

            \Prob{X_{(k_{low})} \leq x_{\alpha}} \geq \beta.

        and the upper tail confidence interval is given by the order statistics:

        .. math::

            ]-\infty, X_{(k_{up})}]

        so that:

        .. math::

            \Prob{x_{\alpha} \leq X_{(k_{up})}} \geq \beta.

        where the lower or upper ranks :math:`0 \leq k_{low} \leq n - 1, 0 \leq k_{up} \leq n - 1` are given by :meth:`computeUnilateralRank`.

        Parameters
        ----------
        sample : 2-d sequence of float
            Quantile level
        tail : bool, optional
            True indicates the interval is bounded by a lower value.
            False indicates the interval is bounded by an upper value. Default value is False.

        Returns
        -------
        ci : :class:`~openturns.Interval`
            Quantile confidence interval

        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> alpha = 0.05
        >>> beta = 0.95
        >>> algo = otexp.QuantileConfidence(alpha, beta)
        >>> sample = ot.Gumbel().getSample(100)
        >>> ci = algo.computeUnilateralConfidenceInterval(sample)

        """
        return _experimental.QuantileConfidence_computeUnilateralConfidenceInterval(self, sample, tail)

    def computeBilateralConfidenceInterval(self, sample):
        r"""
        Evaluate a bilateral confidence interval of a quantile.

        The confidence interval for the quantile of level :math:`\alpha` is given by the order statistics:

        .. math::

            [X_{(k_1)}, X_{(k_2)}]

        so that:

        .. math::

            \Prob{X_{(k_1)} \leq x_{\alpha} \leq X_{(k_2)}} \geq \beta

        where the ranks :math:`0 \leq k_1 \leq k_2 \leq n - 1` are given by :meth:`computeBilateralRank`.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample of the variable :math:`X`

        Returns
        -------
        ci : :class:`~openturns.Interval`
            Quantile confidence interval

        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> alpha = 0.05
        >>> beta = 0.95
        >>> algo = otexp.QuantileConfidence(alpha, beta)
        >>> sample = ot.Gumbel().getSample(60)
        >>> ci = algo.computeBilateralConfidenceInterval(sample)

        """
        return _experimental.QuantileConfidence_computeBilateralConfidenceInterval(self, sample)

    def computeUnilateralMinimumSampleSize(self, rank=0, tail=False):
        r"""
        Evaluate the minimum sample size for the unilateral case.

        For the lower bound the minimal unilateral sample size is the smallest integer :math:`n` such that:

        .. math::

            \Prob{X_{(r)} \leq x_{\alpha}} \geq \beta.

        For the upper bound the minimal unilateral sample size is the smallest integer :math:`n` such that:

        .. math::

            \Prob{x_{\alpha} \leq X_{(n-r-1)}} \geq \beta.

        In the general case the minimum size of the sample is the smallest :math:`n` such that:

        .. math::

            F_{n,\alpha}(n-r-1) \geq \beta

        where :math:`F_{n,\alpha}` is the cumulative distribution function of the Binomial distribution with parameters :math:`n` and :math:`\alpha`.

        When the rank :math:`r` is zero the solution is analytical.

        - For the lower bound the minimum sample size is the integer that satisfies:

          .. math::

              1 - (1 - \alpha)^n \geq \beta

          which is given by:

          .. math::

              n_{low} = \left\lceil \frac{\log(1-\beta)}{\log(1-\alpha)} \right\rceil.

        - And for the upper bound the minimum sample size is the integer that satisfies:

          .. math::

              1 - \alpha^n \geq \beta

          which is given by:

          .. math::

              n_{up} = \left\lceil \frac{\log(1-\beta)}{\log(\alpha)} \right\rceil.

        Parameters
        ----------
        rank : int, optional
            Rank of the quantile. Default value is 0.
        tail : bool, optional
            True indicates the interval is bounded by a lower value.
            False indicates the interval is bounded by an upper value. Default value is False.

        Returns
        -------
        size : int
            Minimum sample size

        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> alpha = 0.05
        >>> beta = 0.95
        >>> algo = otexp.QuantileConfidence(alpha, beta)
        >>> size = algo.computeUnilateralMinimumSampleSize(0)
        >>> print(size)
        59

        """
        return _experimental.QuantileConfidence_computeUnilateralMinimumSampleSize(self, rank, tail)

    def computeBilateralMinimumSampleSize(self):
        r"""
        Evaluate the minimum size of the sample for the bilateral case.

        The minimal bilateral sample size is the smallest integer :math:`n` such that:

        .. math::

            \Prob{X_{(1)} \leq x_{\alpha} \leq X_{(n)}} \geq \beta.

        In other words, this is the minimum sample size such that the interval
        :math:`\left[X_{(1)}, X_{(n)} \right]` is a confidence interval of the quantile :math:`x_\alpha`
        with confidence :math:`\beta`.
        The solution of this problem is the minimum value of :math:`n` such that:

        .. math::

            1-\alpha^n-(1-\alpha)^n \geq \beta

        The sample size :math:`n` is searched inside the bounds given by the inequality:

        .. math::

            \left\lfloor \frac{\log(1 - \beta)}{\log(\gamma)} \right\rfloor \leq n \leq \left\lceil \frac{\log(\frac{1-\beta}{2})}{\log(\gamma)} \right\rceil

        where :math:`\gamma = \max(\alpha, 1- \alpha)`.

        Returns
        -------
        size : int
            Minimum sample size :math:`n`

        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> alpha = 0.05
        >>> beta = 0.95
        >>> algo = otexp.QuantileConfidence(alpha, beta)
        >>> size = algo.computeBilateralMinimumSampleSize()
        >>> print(size)
        59

        """
        return _experimental.QuantileConfidence_computeBilateralMinimumSampleSize(self)

    def computeAsymptoticBilateralRank(self, size):
        r"""
        Evaluate the asymptotic bilateral rank of a quantile.

        This method computes two integers :math:`(k_1, k_2)` such that:

        .. math::
            \lim_{n \rightarrow \infty} \Prob{X_{(k_1)} \leq x_\alpha \leq X_{(k_2)}} = \beta, 0 \leq k_1 \leq k_2 \leq n - 1

        In other words, the interval :math:`\left[X_{(k_1)}, X_{(k_2)} \right]` is an asymptotic
        confidence interval for :math:`x_\alpha` with asymptotic confidence :math:`\beta`.
        The asymptotic bilateral ranks :math:`k_1, k_2 \in \llbracket 0, n - 1 \rrbracket` are estimated from:

        .. math::

            k_1 & = \left\lfloor n \alpha - \sqrt{n} z_{1-\beta/2} \sqrt{\alpha (1 - \alpha)} \right\rfloor - 1 \\
            k_2 & = \left\lfloor n \alpha + \sqrt{n} z_{1-\beta/2} \sqrt{\alpha (1 - \alpha)} \right\rfloor - 1

        with :math:`z_{1-\beta/2}` the standard Gaussian quantile of order :math:`1-\beta/2`, see [delmas2006]_ proposition 12.2.13 page 257.

        Parameters
        ----------
        size : int
            Sample size

        Returns
        -------
        ranks : :class:`~openturns.Indices` of size 2
            Pair of lower and upper ranks :math:`(k_1, k_2)` with :math:`0 \leq k_1 \leq k_2 \leq n-1`.

        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> alpha = 0.05
        >>> beta = 0.95
        >>> algo = otexp.QuantileConfidence(alpha, beta)
        >>> k1, k2 = algo.computeAsymptoticBilateralRank(100)
        >>> print(k1, k2)
        0 8

        """
        return _experimental.QuantileConfidence_computeAsymptoticBilateralRank(self, size)

    def computeAsymptoticBilateralConfidenceInterval(self, sample):
        r"""
        Evaluate asymptotic bilateral bounds of a quantile.

        The asymptotic bounds are given by the order statistics:

        .. math::

            [X_{(k_1)}, X_{(k_2)}]

        so that:

        .. math::

            \lim_{n \rightarrow \infty} \Prob{X_{(k_1)} \leq x_{\alpha} \leq X_{(k_2)}} \geq \beta

        where the ranks :math:`0 \leq k_1 \leq k_2 \leq n - 1` are given by :meth:`computeAsymptoticBilateralRank`.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample of the variable :math:`X`

        Returns
        -------
        ci : :class:`~openturns.Interval`
            Quantile confidence interval

        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> alpha = 0.05
        >>> beta = 0.95
        >>> algo = otexp.QuantileConfidence(alpha, beta)
        >>> sample = ot.Gumbel().getSample(60)
        >>> ci = algo.computeAsymptoticBilateralConfidenceInterval(sample)

        """
        return _experimental.QuantileConfidence_computeAsymptoticBilateralConfidenceInterval(self, sample)

    def setAlpha(self, alpha):
        r"""
        Quantile level accessor.

        Parameters
        ----------
        alpha : float
            Quantile level

        """
        return _experimental.QuantileConfidence_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Quantile level accessor.

        Returns
        -------
        alpha : float
            Quantile level

        """
        return _experimental.QuantileConfidence_getAlpha(self)

    def setBeta(self, beta):
        r"""
        Confidence level accessor.

        Parameters
        ----------
        beta : float
            Confidence level

        """
        return _experimental.QuantileConfidence_setBeta(self, beta)

    def getBeta(self):
        r"""
        Confidence level accessor.

        Returns
        -------
        beta : float
            Confidence level

        """
        return _experimental.QuantileConfidence_getBeta(self)

    def __repr__(self):
        return _experimental.QuantileConfidence___repr__(self)

    def __str__(self, *args):
        return _experimental.QuantileConfidence___str__(self, *args)

    def __init__(self, *args):
        _experimental.QuantileConfidence_swiginit(self, _experimental.new_QuantileConfidence(*args))
    __swig_destroy__ = _experimental.delete_QuantileConfidence

# Register QuantileConfidence in _experimental:
_experimental.QuantileConfidence_swigregister(QuantileConfidence)
class LineSampling(EventSimulation):
    r"""
    Line sampling algorithm.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.


    This class implements the line sampling algorithm from [koutsourelakis2004]_ with adaptation
    of the important direction from [angelis2015]_, which is also known as adaptive line sampling.

    Let :math:`\inputRV` be a random vector of dimension :math:`\inputDim`, distributed according to
    the measure :math:`\inputMeasure`, and :math:`\model: \Rset^\inputDim \rightarrow \Rset`
    be the *limit state function* (where we only write the random input parameters).
    We define the event :math:`\cD_f` by:

    .. math::

        \cD_f = \{\vect{x} \in \Rset^{\inputDim} \, | \,\model(\vect{x}) \leq 0\}

    The line sampling algorithm estimates the probability of the event :math:`\cD_f`:

    .. math::

        P_f = \Prob{\model\left( \inputRV \right) \leq 0}
            = \int_{\Rset^{\inputDim}} \mathbf{1}_{\{\model(\vect{x}) \leq 0 \}}\inputMeasure(\vect{x})\di{\vect{x}}

    Let :math:`T` be the iso-probabilistic transformation to the standard space: :math:`T(\vect{X}) = \vect{Z}`. The
    random vector :math:`\vect{Z}` is a :math:`\inputDim`-dimensional Gaussian vector following the standard normal distribution.

    For any direction :math:`\vect{\alpha} \in \Rset^d` such that :math:`||\vect{\alpha}||_2=1`,
    let :math:`P_{\vect{\alpha}}` be the orthogonal projection from :math:`\Rset^d` to the one-dimensional vector space (line)
    spanned by :math:`\vect{\alpha}` (we call :math:`\vect{\alpha}` the *important direction*)  and let :math:`P^{\perp}_{\vect{\alpha}}` be the orthogonal projection from :math:`\Rset^d`
    to the hyperplane of :math:`\Rset^d` normal to the one-dimensional vector space spanned by :math:`\vect{\alpha}`.

    Then :math:`P_f` can be rewritten:

    .. math::

        P_f = \Expect{\Prob{P_{\vect{\alpha}}(\vect{Z}) + P^{\perp}_{\vect{\alpha}}(\vect{Z}) \in T(\cD_f) | P^{\perp}_{\vect{\alpha}}(\vect{Z})}}

    Since :math:`\vect{Z}` follows a standard multivariate normal distribution, :math:`P_{\vect{\alpha}}(\vect{Z})`
    and :math:`P^{\perp}_{\vect{\alpha}}(\vect{Z})` are independent.

    Therefore, given that :math:`P_{\vect{\alpha}}(\vect{Z})` follows the same distribution as :math:`R \vect{\alpha}`
    where :math:`R` is a scalar random variable following the standard normal distribution, we have:

    .. math::

        P_f = \Expect{\Prob{R \vect{\alpha} + P^{\perp}_{\vect{\alpha}}(\vect{Z}) \in T(\cD_f) | P^{\perp}_{\vect{\alpha}}(\vect{Z})}}

    Now, for any vector :math:`\vect{u} \in \Rset^d` that is orthogonal to :math:`\vect{\alpha}`,
    we define :math:`I_u` as the set

    .. math::

        I_u = \{ r \in \Rset, r \vect{\alpha} + u \in T(\cD_f) \}

    We can rewrite

    .. math::

        P_f = \Expect{\Prob{R \in I_{P_{\vect{\alpha}}(\vect{Z})} | P^{\perp}_{\vect{\alpha}}(\vect{Z}}}

    Letting :math:`I_u^0` be the interior of :math:`I_u`, we assume :math:`I_u^0` to be the union
    of a finite number of open intervals.

    Then there exists :math:`n_u \in \Nset` and :math:`r_0, \hdots, r_{2 n_u + 1} \in \Rset \cup \{-\infty, +\infty\}` such that
    :math:`r_0 < \hdots < r_{2 n_u + 1}` and :math:`I_u^0 = \bigcup_{i=0}^{n_u} (r_{2i}, r_{2i+1})`.

    :math:`r_0` is either :math:`-\infty` or a root of :math:`r \mapsto g \circ T^{-1}(r \vect{\alpha} + u)`.
    :math:`r_{2 n_u + 1}` is either :math:`+\infty` or a root of :math:`r \mapsto g \circ T^{-1}(r \vect{\alpha} + u)`.
    All the other :math:`r_j` are roots of :math:`r \mapsto g \circ T^{-1}(r \vect{\alpha} + u)`.

    With :math:`\Phi` denoting the CDF of the standard normal distribution we have

    .. math::

        \Prob{R \in I_u} = \Prob{I_u^0} = \sum_{i=0}^{n_u} \Prob{r_{2 i} < R < r_{2 i + 1}} \\
                         = \sum_{i=0}^{n_u} \Prob{R < r_{2 i + 1}} - \Prob{R \leq r_{2 i}} \\
                         = \sum_{0 < i < 2 n_u + 1} (-1)^{j+1} \Phi(r_j)

    The generic line sampling algorithm follows the steps for :math:`k=1, \hdots \sampleSize`:

    - Draw a sample :math:`\vect{z_k} \sim Z` and project it on the hyperplane normal to :math:`\vect{\alpha}`
      to obtain :math:`P^{\perp}_{\vect{\alpha}}(\vect{z_k})`.

    - Find the roots of :math:`r \mapsto g \circ T^{-1}(r \vect{\alpha} + P^{\perp}_{\vect{\alpha}}(\vect{z_k}))`.

    - Use the roots to compute :math:`p_{\vect{z_k}} = \Prob{R \in I_{P^{\perp}_{\vect{\alpha}}(\vect{z_k})}}`.

    The global probability :math:`P_f` is computed from all the :math:`p_{\vect{z_k}}` probabilities.

    .. math::

        \widehat{P}_{f,LS} = \frac{1}{\sampleSize} \sum_{i=1}^{\sampleSize} p_{\vect{z_k}}

    The adaptive variant of the algorithm consists in updating the important direction :math:`\vect{\alpha}`
    by the selecting the direction given by the nearest intersection with the frontiers of :math:`\cD_f` from the origin
    as given by the root search for each new line explored.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability.
    initialAlpha : sequence of float
        The initial important direction :math:`\vect{\alpha}`.
    rootStrategy : :class:`~openturns.RootStrategy`, optional
        Strategy used to evaluate the frontiers of
        the event along each direction in the standard space.
        By default :class:`~openturns.SafeAndSlow`.

    Notes
    -----
    Various :class:`~openturns.ResourceMap` entries allow for a more fine-grained control over the algorithm:

    - The boolean entry `LineSampling-DefaultSearchOppositeDirection` sets the default value of the flag
      activating the additional search in the opposite direction of the important direction.
    - The boolean entry `LineSampling-DefaultAdaptiveImportantDirection` sets the default value of the flag
      activating the use of adaptive important direction as opposed to a fixed important direction.

    See also
    --------
    openturns.DirectionalSampling
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.LineSampling_getClassName(self)

    def setInitialAlpha(self, initialAlpha):
        r"""
        Initial important direction accessor.

        Parameters
        ----------
        alpha : sequence of float
            Initial important direction.
        """
        return _experimental.LineSampling_setInitialAlpha(self, initialAlpha)

    def getInitialAlpha(self):
        r"""
        Initial important direction accessor.

        Returns
        -------
        alpha : :class:`~openturns.Point`
            Initial important direction.
        """
        return _experimental.LineSampling_getInitialAlpha(self)

    def setRootStrategy(self, rootStrategy):
        r"""
        Set the root strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy to evaluate the frontiers of
            the event along each direction in the standard space.
        """
        return _experimental.LineSampling_setRootStrategy(self, rootStrategy)

    def getRootStrategy(self):
        r"""
        Get the root strategy.

        Returns
        -------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy used to evaluate the frontiers of
            the event along each direction in the standard space.
        """
        return _experimental.LineSampling_getRootStrategy(self)

    def setSearchOppositeDirection(self, searchOppositeDirection):
        r"""
        Opposite direction search flag accessor.

        Parameters
        ----------
        searchOppositeDirection : bool
            Whether to search in the opposite direction of the important direction.
        """
        return _experimental.LineSampling_setSearchOppositeDirection(self, searchOppositeDirection)

    def getSearchOppositeDirection(self):
        r"""
        Opposite direction search flag accessor.

        Returns
        -------
        searchOppositeDirection : bool
            Whether to search in the opposite direction of the important direction.
        """
        return _experimental.LineSampling_getSearchOppositeDirection(self)

    def setAdaptiveImportantDirection(self, adaptiveImportantDirection):
        r"""
        Accessor to the adaptive important direction flag.

        Parameters
        ----------
        adaptiveImportantDirection : bool
            Whether the important direction is adapted according to new design points.
        """
        return _experimental.LineSampling_setAdaptiveImportantDirection(self, adaptiveImportantDirection)

    def getAdaptiveImportantDirection(self):
        r"""
        Accessor to the adaptive important direction flag.

        Returns
        -------
        adaptiveImportantDirection : bool
            Whether the important direction is adapted according to new design points.
        """
        return _experimental.LineSampling_getAdaptiveImportantDirection(self)

    def setStoreHistory(self, storeHistory):
        r"""
        Accessor to the important direction history.

        Parameters
        ----------
        storeHistory : bool
            Whether to store alpha, root values and points histories.
        """
        return _experimental.LineSampling_setStoreHistory(self, storeHistory)

    def getStoreHistory(self):
        r"""
        Accessor to the important direction history.

        Returns
        -------
        storeHistory : bool
            Whether to store alpha, root values and points histories.
        """
        return _experimental.LineSampling_getStoreHistory(self)

    def getAlphaHistory(self):
        r"""
        Accessor to the important direction history.

        Returns
        -------
        alphaHistory : :class:`~openturns.Sample`
            Storage strategy used to store the important direction vectors during the simulation.
        """
        return _experimental.LineSampling_getAlphaHistory(self)

    def getRootPointsHistory(self):
        r"""
        Accessor to the root points history.

        Returns
        -------
        rootPointsHistory : sequence of :class:`~openturns.Sample`
            The list of root points for each line.
        """
        return _experimental.LineSampling_getRootPointsHistory(self)

    def getRootValuesHistory(self):
        r"""
        Accessor to the root values history.

        Returns
        -------
        rootValuesHistory : sequence of :class:`~openturns.Point`
            The list of root values for each line.
        """
        return _experimental.LineSampling_getRootValuesHistory(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        openturns.EventSimulation.setBlockSize
        openturns.EventSimulation.setMaximumOuterSampling
        openturns.ResourceMap
        openturns.SimulationResult
        """
        return _experimental.LineSampling_run(self)

    def __repr__(self):
        return _experimental.LineSampling___repr__(self)

    def __init__(self, *args):
        _experimental.LineSampling_swiginit(self, _experimental.new_LineSampling(*args))
    __swig_destroy__ = _experimental.delete_LineSampling

# Register LineSampling in _experimental:
_experimental.LineSampling_swigregister(LineSampling)
class RankSobolSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using rank-based method.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        The input sample used for the Sobol' sensitivity analysis
    outputDesign : :class:`~openturns.Sample`
        The output sample used for the Sobol' sensitivity analysis

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> from openturns.usecases import ishigami_function
    >>> im = ishigami_function.IshigamiModel()
    >>> x = im.inputDistribution.getSample(100)
    >>> y = im.model(x)
    >>> algo = otexp.RankSobolSensitivityAlgorithm(x, y)
    >>> indices = algo.getFirstOrderIndices()

    Notes
    -----
    This method allows one to compute the first order Sobol' indices given some input / output samples [gamboa2022]_. It is not yet extended to higher order indices as well as total order indices.

    Considering the input random vector :math:`\vect{X} = (X_1,\dots,X_{n_X})` and let :math:`\vect{Y} = (Y_1,\dots,Y_{n_Y})` be the output of the physical model:

    .. math::

        \vect{Y} = g(X_1,\dots,X_{n_X}) 

    In the following description Y is considered as scalar, without loss of generality. 

    Main assumptions:

    - :math:`X_1,\dots,X_{n_X}` are independent and scalar

    - :math:`\mathbb{E}[\parallel Y \parallel^2] < \infty`


    We want to estimate the first order Sobol' index :math:`S_k` with respect to :math:`X_k` for :math:`k\in\{1,\dots,{n_X}\}` 

    .. math::

        S_k = \frac{\mathbb{V}(\mathbb{E}[Y|X_k])}{\mathbb{V}(Y)}

    Let's consider a i.i.d. N-sample of the input/output pair :math:`(X_k,Y)` given by:

    .. math::

        (X_{k,1},Y_1),(X_{k,2},Y_2),\dots,(X_{k,N},Y_N)

    The pairs :math:`(X_{k,(1)},Y_{(k,1)}),(X_{k,(2)},Y_{(k,2)}),\dots,(X_{k,(N)},Y_{(k,N)})` are ranked (noted using lower scripts under brackets) in such a way that:
    :math:`X_{k,(1)} \leq X_{k,(2)} \leq \dots \leq X_{k,(N)}.`

    The first order Sobol' indices estimated based on ranks are given by:

    .. math::

        S_{k_{N,rank}} = \frac{\frac{1}{N}\sum_{i=1}^{N} Y_{(k,i)}Y_{(k,i+1)}-\left(\frac{1}{N}\sum_{i=1}^N Y_i\right)^2}{\frac{1}{N}\sum_{i=1}^N Y_i^2-\left(\frac{1}{N}\sum_{i=1}^N Y_i\right)^2}

    where the permutation is defined such that :math:`Y_{(k,N+1)} = Y_{(k,1)}`.

    Confidence intervals are obtained via bootstrap without replacement. 

    The ratio of the bootstrap's sample size with respect to the total size of the input sample is fixed in the `RankSobolSensitivityAlgorithm-DefaultBootstrapSampleRatio` ResourceMap key.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.RankSobolSensitivityAlgorithm_getClassName(self)

    def draw(self):
        r"""
        Draw sensitivity indices.

        Usage:
          draw()

        Draw the aggregated first order Sobol' indices.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.

        Notes
        -----
        If number of bootstrap sampling is greater than 1, the graph includes confidence interval plots in the first usage. This is defined in the `SobolIndicesAlgorithm-DefaultBootstrapSize` ResourceMap key.
        """
        return _experimental.RankSobolSensitivityAlgorithm_draw(self)

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Get first order Sobol indices.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing first order Sobol indices.
        """
        return _experimental.RankSobolSensitivityAlgorithm_getFirstOrderIndices(self, marginalIndex)

    def __repr__(self):
        return _experimental.RankSobolSensitivityAlgorithm___repr__(self)

    def getSecondOrderIndices(self, marginalIndex=0):
        r"""Method not yet implemented."""
        return _experimental.RankSobolSensitivityAlgorithm_getSecondOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""Method not yet implemented."""
        return _experimental.RankSobolSensitivityAlgorithm_getTotalOrderIndices(self, marginalIndex)

    def getTotalOrderIndicesInterval(self):
        r"""Method not yet implemented."""
        return _experimental.RankSobolSensitivityAlgorithm_getTotalOrderIndicesInterval(self)

    def getAggregatedTotalOrderIndices(self):
        r"""Method not yet implemented."""
        return _experimental.RankSobolSensitivityAlgorithm_getAggregatedTotalOrderIndices(self)

    def setUseAsymptoticDistribution(self, arg2):
        r"""Method not yet implemented."""
        return _experimental.RankSobolSensitivityAlgorithm_setUseAsymptoticDistribution(self, arg2)

    def getUseAsymptoticDistribution(self):
        r"""Method not yet implemented."""
        return _experimental.RankSobolSensitivityAlgorithm_getUseAsymptoticDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""Method not yet implemented."""
        return _experimental.RankSobolSensitivityAlgorithm_getTotalOrderIndicesDistribution(self)

    def setDesign(self, inputDesign, outputDesign, size):
        r"""
        Sample accessor.

        Allows one to estimate indices from a predefined Sobol design.

        Parameters
        ----------
        inputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained
            thanks to the SobolIndicesAlgorithmImplementation.Generate method
        outputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained as the evaluation
            of a Function (model) on the previous inputDesign
        N : int
            Base size of the Sobol design
        """
        return _experimental.RankSobolSensitivityAlgorithm_setDesign(self, inputDesign, outputDesign, size)

    def __init__(self, *args):
        _experimental.RankSobolSensitivityAlgorithm_swiginit(self, _experimental.new_RankSobolSensitivityAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_RankSobolSensitivityAlgorithm

# Register RankSobolSensitivityAlgorithm in _experimental:
_experimental.RankSobolSensitivityAlgorithm_swigregister(RankSobolSensitivityAlgorithm)
class CombinationsDistribution(openturns.model_copula.DistributionImplementation):
    r"""
    Combinations distribution.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    This class is the discrete uniform distribution on the set of the :math:`C_n^k` combinations of :math:`k` elements among :math:`n` elements. 
    Let :math:`E` be a set of :math:`n` elements and  :math:`\cC_{k,n}` the set of combinations of elements of :math:`E`: 

    .. math::

        \cC_{k,n} = \left\{ A \subset E, \mathbf{card}(A) = k\right\}

    We show that :math:`\cC_{k,n}` is in bijection with the  set :math:`\cF_{k,n}` of strictly increasing functions
    from :math:`\llbracket 1, k \rrbracket`  into :math:`\llbracket 1, n \rrbracket`.
    As a result, this class is also the discrete uniform distribution on the set :math:`\cF_{k,n}`.
    Let each function in  :math:`\cF_{k,n}` be represented by the :math:`k`-upplet denoted by :math:`(i(0), \ldots, i(k-1)) \in \Nset^k`.
    Then the support :math:`\cS` of the CombinationDistribution is included in :math:`\Nset^k` and is defined by:

    .. math::

        \cS = \{\vect{s} \in \Nset^k \, | \,  s_i \in \llbracket 1, n \rrbracket, s_1 < \ldots < s_k \} = \{\vect{s} \in \Nset^k \, | \, 1 \leq s_1 < \ldots < s_k \leq n \}

    Its probability distribution function is defined as:

    .. math::

        \Prob{\vect{X} = (i_0, \hdots, i_{k-1})} = \frac{1}{\binom{n}{k}}

    Parameters
    ----------
    k : int, :math:`k > 0`
    n : int, :math:`n > 0`

    See also
    --------
    openturns.Combinations

    Examples
    --------
    Create a distribution:

    >>> import openturns.experimental as otexp
    >>> distribution = otexp.CombinationsDistribution(6, 8)

    Get a realization: it is a vector :math:`(s_0, \ldots, s_{k-1})` associated to the increasing function :math:`f: i \rightarrow s_i` or,
    equivalenty, to the combination of the elements :math:`s_i` of the set :math:`E`.

    >>> x = distribution.getRealization()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.CombinationsDistribution_getClassName(self)

    def __eq__(self, *args):
        return _experimental.CombinationsDistribution___eq__(self, *args)

    def __repr__(self):
        return _experimental.CombinationsDistribution___repr__(self)

    def __str__(self, *args):
        return _experimental.CombinationsDistribution___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _experimental.CombinationsDistribution_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _experimental.CombinationsDistribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _experimental.CombinationsDistribution_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d

        This method is overloaded by most of the actual distributions. Many generic
        algorithms are available depending on the properties of the
        distribution and can be used by actual distributions:

        - for discrete distributions, it is a summation of the probabilities
          of the points contributing to the CDF;
        - for absolutely continuous distributions, it is done using an adaptive
          integration of the PDF using :class:`~openturns.IteratedQuadrature`;
        - for unimodal absolutely continuous distributions, it is done using an
          adaptive integration of the PDF using
          :class:`~openturns.IteratedQuadrature` over a front of boxes starting
          from the projection of the cell containing the mode and advancing in
          all the directions toward the point at which one want to compute the
          CDF and the directions pointing toward :math:`-\infty`. The size of
          the boxes is controlled by a parameter set by the actual distribution
          and the maximum number of cells to explore is controlled by the
          *Distribution-DefaultCDFIteration* entry of :class:`~openturns.ResourceMap`


        """
        return _experimental.CombinationsDistribution_computeCDF(self, *args)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _experimental.CombinationsDistribution_computeQuantile(self, *args)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, d\right]

        See Also
        --------
        getKendallTau
        """
        return _experimental.CombinationsDistribution_getSpearmanCorrelation(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _experimental.CombinationsDistribution_getKendallTau(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _experimental.CombinationsDistribution_getMarginal(self, *args)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _experimental.CombinationsDistribution_getSupport(self, *args)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _experimental.CombinationsDistribution_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _experimental.CombinationsDistribution_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _experimental.CombinationsDistribution_isIntegral(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _experimental.CombinationsDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _experimental.CombinationsDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _experimental.CombinationsDistribution_getParameterDescription(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _experimental.CombinationsDistribution_getParametersCollection(self)

    def setK(self, k):
        r"""
        Accessor to the parameter :math:`k`.

        Parameters
        ----------
        k : int, :math:`k > 0`
        """
        return _experimental.CombinationsDistribution_setK(self, k)

    def getK(self):
        r"""
        Accessor to the parameter :math:`k`.

        Returns
        -------
        k : int
        """
        return _experimental.CombinationsDistribution_getK(self)

    def setN(self, n):
        r"""
        Accessor to the parameter :math:`n`.

        Parameters
        ----------
        n : int, :math:`n > 0`
        """
        return _experimental.CombinationsDistribution_setN(self, n)

    def getN(self):
        r"""
        Accessor to the parameter :math:`n`.

        Returns
        -------
        n : int
        """
        return _experimental.CombinationsDistribution_getN(self)

    def __init__(self, *args):
        _experimental.CombinationsDistribution_swiginit(self, _experimental.new_CombinationsDistribution(*args))
    __swig_destroy__ = _experimental.delete_CombinationsDistribution

# Register CombinationsDistribution in _experimental:
_experimental.CombinationsDistribution_swigregister(CombinationsDistribution)
class PointConditionalDistribution(openturns.model_copula.DistributionImplementation):
    r"""
    Distribution conditioned by a deterministic vector.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Let :math:`\inputRV` be a random vector of dimension :math:`\inputDim`. Let :math:`\cI \subset \{1, \dots, \inputDim \}`
    be a set of indices of components of  :math:`\inputRV`, :math:`\overline{\cI}` its complementary in
    :math:\{1, \dots, \inputDim \}` and :math:`\vect{x}_\cI` a real vector of dimension equal to the cardinal of :math:`\cI`.
    Then this class implements the distribution of:

    .. math::

        \inputRV_{\overline{\cI}}|\inputRV_\cI = \vect{x}_\cI


    This class requires the following features:

    - each component :math:`X_i` is continuous or discrete: e.g., it can not be a :class:`~openturns.Mixture` of
      discrete and continuous distributions,
    - the copula of :math:`\inputRV` is continuous: e.g., it can not be the :class:`~openturns.MinCopula`,
    - the random vector :math:`\inputRV_{\overline{\cI}}` is continuous or discrete: all its components must be discrete
      or all its components must be continuous,
    - the random vector :math:`\inputRV_{\cI}` may have some discrete components and some continuous components. 

    Then, the pdf (probability density function if :math:`\inputRV_{\overline{\cI}}` is continuous or probability distribution function if
    :math:`\inputRV_{\overline{\cI}}` is discrete) of :math:`\inputRV_{\overline{\cI}}|\inputRV_\cI = \vect{x}_\cI` is defined by (in the following expression, we assumed a particular order of the conditioned components among the whole set of components for easy reading):

    .. math::
        :label: condPDF

        p_{\inputRV_{\overline{\cI}}|\inputRV_\cI = \vect{x}_\cI}(x_{\overline{\cI}})  = \dfrac{p_{\inputRV}(\vect{x
        }_{\overline{\cI}}, \vect{x}_{\cI})}{p_{\inputRV_{\cI}}(\vect{x}_{\cI})}

    where:

    .. math::

        p_{\inputRV}(\vect{x})  = \left( \prod_{i=1}^\inputDim p_i(x_i)\right) c(F_1(x_1), \dots,
        F_\inputDim(x_\inputDim))

    with:

    - :math:`c` is the probability density copula of :math:`\inputRV`,
    - if :math:`X_i` is a continuous component, :math:`p_i` is its probability density function,
    - if :math:`X_i` is a discrete component, :math:`p_i = \sum_{x^i_k \in \cS^i} \Prob{X_i = x^i_k} \delta_{x^i_k}` where
      :math:`\cS^i = \{ x^i_k \}` is its support and :math:`\delta_{x^i_k}` the Dirac distribution centered on
      :math:`x^i_k`.

    Then, if :math:`\inputRV_{\overline{\cI}}` is continuous, we have:

    .. math::

        p_{\inputRV_{\cI}}(\vect{x}_{\cI})  = \int p_{\inputRV}(\vect{x}_{\overline{\cI}}, \vect{x}_{\cI}) \,
        \di{\vect{x}_{\overline{\cI}}}

    and if :math:`\inputRV_{\overline{\cI}}` is discrete with its support denoted by :math:`\cS(\vect{X}_{\overline{\cI}}) = \prod_{i \in \overline{\cI}} S^i`, we have:

    .. math::

        p_{\inputRV_{\cI}}(\vect{x}_{\cI})  & = \sum_{\vect{x}_{\overline{\cI}} \in \cS(\inputRV_{\overline{\cI}})}
        p_{\inputRV}(\vect{x}_{\overline{\cI}}, \vect{x}_{\cI})

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`,
        Distribution of :math:`\inputRV`.
    conditioningIndices : sequence of int,
        Conditioning vector indices :math:`\cI`.
    conditioningValues : sequence of float,
        Conditioning vector values :math:`\vect{x}_\cI`.

    Notes
    -----
    Simplification mechanisms to compute :eq:`condPDF` are implemented for some distributions.
    To know if a simplification is used, ask the method *hasSimplifiedVersion*.

    If the dimension of :math:`\inputRV_\cI` is greater than 1, the default integration algorithm is the :class:`~openturns.experimental.CubaIntegration` defined in the entry  *PointConditionalDistribution-CubaAlgorithm* if available and the
    :class:`~openturns.SimplicialCubature` algorithm if not. If the
    dimension of :math:`\inputRV_\cI` is 1, then the default integration algorithm is the :class:`~openturns.GaussKronrod` algorithm with its default
    quadrature formula.

    In the case where no simplification mechanism has been implemented for the distribution of :math:`\inputRV`, then the range of
    the conditioned distribution is computed according to one of the following strategies. The default strategy is defined in the
    :class:`~openturns.ResourceMap`, entry *PointConditionalDistribution-RangeAdaptationMethod*.


    **Strategy None**: The numerical range of :math:`\inputRV_{\overline{\cI}}|\inputRV_\cI = \vect{x}_\cI` is the same as the
    numerical range of :math:`\inputRV_{\overline{\cI}}`.
    This range is exact for all distributions with bounded support. For distributions with unbounded support,
    it is potentially false when the conditional values are very close to the bounds of the initial numerical support.


    **Strategy Normal**: Let  :math:`\vect{Y}` be the Gaussian vector of dimension :math:`\inputDim`, which mean vector
    is defined by :math:`\vect{\mu} = \Expect{\inputRV}` and covariance matrix is defined by :math:`\mat{C} = \Cov{\inputRV}`.
    Then, we build the conditioned Gaussian vector:

    .. math::

        \vect{Y}_{\overline{\cI}}|\vect{Y}_\cI = \vect{x}_\cI


    The numerical range :math:`\cD \left(\vect{Y}_{\overline{\cI}}|\vect{Y}_\cI = \vect{x}_\cI \right)` of
    :math:`\vect{Y}_{\overline{\cI}}|\vect{Y}_\cI = \vect{x}_\cI` is known exactly thanks to the simplification mechanism
    implemented for Gaussian vectors. We assign to :math:`\inputRV_{\overline{\cI}}|\inputRV_\cI = \vect{x}_\cI` the
    range :math:`\cD \left(\vect{Y}_{\overline{\cI}}|\vect{Y}_\cI = \vect{x}_\cI \right)`:

    .. math::

        \cD\left(\inputRV_{\overline{\cI}}|\inputRV_\cI = \vect{x}_\cI \right) = \cD \left(\vect{Y}_{\overline{\cI}}|\vect{Y}_\cI
        = \vect{x}_\cI \right)


    **Strategy NormalCopula**: Let  :math:`\vect{Y}` be the Gaussian vector of dimension :math:`\inputDim`, with zero mean,
    unit variance and which correlation matrix :math:`\mat{R}` is defined from the Spearman correlation matrix of :math:`\inputRV`:
    :math:`\left( \rho_S(X_i, X_j) \right)_{1 \leq i, j \leq \inputDim}`. Thus, :math:`\vect{Y}` is the standard representant
    of the normal copula having the same correlation as :math:`\inputRV`.

    For each conditioning value :math:`x_i`, we define the quantile :math:`q_i` of the normal distribution with zero mean and unit
    variance associated to the same order as :math:`x_i`, for :math:`i \in \cI`:

    .. math::

        q_i & = \Phi^{-1} \circ F_i \left (x_i \right)

    where :math:`\Phi` is the CDF of the normal distribution with zero mean and unit variance. Then, we build the conditioned
    Gaussian vector:

    .. math::

        \vect{Y}_{\overline{\cI}}|\vect{Y}_\cI = \vect{q}_\cI

    which numerical range :math:`\cD\left(\vect{Y}_{\overline{\cI}}|\vect{Y}_\cI = \vect{q}_\cI \right)` can be exactly computed.
    Let it be:

    .. math::

        \cD\left(\vect{Y}_{\overline{\cI}}|\vect{Y}_\cI = \vect{q}_\cI \right) = \prod_{i\in \overline{\cI}}
        \left[ y_i^{min}, y_i^{max}\right]

    Then, inversely, we compute the quantiles of each :math:`F_i` for :math:`i \in \cI` which have the same order as the bounds
    :math:`y_i^{min}` and :math:`y_i^{max}` with respect :math:`\Phi`:

    .. math::

        x_i^{min} & = F_i^{-1}\circ \Phi \left (y_i^{min} \right) \\
        x_i^{max} & = F_i^{-1}\circ \Phi \left (y_i^{max} \right)

    We assign to :math:`\inputRV_{\overline{\cI}}|\inputRV_\cI = \vect{x}_\cI` the numerical range defined by:

    .. math::

        \cD \left(\vect{X}_{\overline{\cI}}|\vect{X}_\cI = \vect{x}_\cI \right) = \prod_{i\in \overline{\cI}} \left[ x_i^{min},
        x_i^{max}\right]


    Several :class:`~openturns.ResourceMap` entries allow for a more fine-grained control over the distribution:

    - The boolean entry *PointConditionalDistribution-UseSimplifiedVersion* decides if simplification is enabled.
    - The string entry *PointConditionalDistribution-CubaAlgorithm* defines the default Cuba algorithm used to compute the CDF when the conditioning 
      values are mutivariate.
    - The string entry *PointConditionalDistribution-OptimizationAlgorithm* defines the default optimization algorithm name used.
    - The integer entry *PointConditionalDistribution-RatioUniformCandidateNumber* sets the number
      of candidates to find a feasible points for the ratio of uniforms method initialization.
    - The boolean entry *PointConditionalDistribution-InitializeSampling* decides whether to initialize the ratio of uniforms method.
    - The integer entry *PointConditionalDistribution-SmallDimension* is the dimension threshold
      from which to switch to CDF inversion sampling instead of ratio of uniforms (for continuous distributions).
    - The boolean entry *PointConditionalDistribution-InitializeTransformation* decides whether
      to initialize the iso-probabilistic transformation.
    - The boolean entry *PointConditionalDistribution-UseGenericConditionalMethods* decides whether
      the generic conditional methods are used (see :meth:`~openturns.Distribution.computeConditionalCDF()` for example). These methods can only be
      used when we want to create the distribution of :math:`X_d|(X_1, \dots, X_{d-1}) = (x_1, \dots, x_{d-1})` or when :math:`\inputRV` is bivariate
      with a symmetric copula.

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> indices = [1]
    >>> values = [2.0]
    >>> normal = ot.Normal(3)
    >>> R = ot.CorrelationMatrix(3)
    >>> R[1, 0] = R[2, 0] = R[2, 1] = 0.9
    >>> normal.setR(R)
    >>> distribution = otexp.PointConditionalDistribution(normal, indices, values)
    >>> sample = distribution.getSample(2)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PointConditionalDistribution_getClassName(self)

    def __eq__(self, *args):
        return _experimental.PointConditionalDistribution___eq__(self, *args)

    def __repr__(self):
        return _experimental.PointConditionalDistribution___repr__(self)

    def __str__(self, *args):
        return _experimental.PointConditionalDistribution___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _experimental.PointConditionalDistribution_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, getSampleByInversion, getSampleByQMC
        """
        return _experimental.PointConditionalDistribution_getSample(self, size)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _experimental.PointConditionalDistribution_computeDDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _experimental.PointConditionalDistribution_computeLogPDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _experimental.PointConditionalDistribution_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d

        This method is overloaded by most of the actual distributions. Many generic
        algorithms are available depending on the properties of the
        distribution and can be used by actual distributions:

        - for discrete distributions, it is a summation of the probabilities
          of the points contributing to the CDF;
        - for absolutely continuous distributions, it is done using an adaptive
          integration of the PDF using :class:`~openturns.IteratedQuadrature`;
        - for unimodal absolutely continuous distributions, it is done using an
          adaptive integration of the PDF using
          :class:`~openturns.IteratedQuadrature` over a front of boxes starting
          from the projection of the cell containing the mode and advancing in
          all the directions toward the point at which one want to compute the
          CDF and the directions pointing toward :math:`-\infty`. The size of
          the boxes is controlled by a parameter set by the actual distribution
          and the maximum number of cells to explore is controlled by the
          *Distribution-DefaultCDFIteration* entry of :class:`~openturns.ResourceMap`


        """
        return _experimental.PointConditionalDistribution_computeCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _experimental.PointConditionalDistribution_computeProbability(self, interval)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _experimental.PointConditionalDistribution_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Sequence of conditional PDF values at *x*.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            \left(\dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.
        """
        return _experimental.PointConditionalDistribution_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _experimental.PointConditionalDistribution_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at *x*.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            \left(F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`F_{X_1}(x_1)`.
        """
        return _experimental.PointConditionalDistribution_computeSequentialConditionalCDF(self, x)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _experimental.PointConditionalDistribution_computeConditionalQuantile(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        p : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Sequence of conditional quantiles values at *p*

        Notes
        -----
        The sequential conditional quantile function is defined by:

        .. math::

            \left(F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p_j; x_1, \dots, x_{j-1})\right)_{i=1,\ldots,d}

        where :math:`F^{-1}` is the quantile function and
        where :math:`x_1,\ldots,x_{j-1}` are defined recursively as :math:`x_1=F_1^{-1}(p_1)` and for :math:`2\leq j \leq d`,
        :math:`x_j=F_{X_j}^{-1}(p_j|X_1=x_1,\ldots,X_{j-1}=x_{j-1})`: the conditioning part is the set of already
        computed conditional quantiles.
        """
        return _experimental.PointConditionalDistribution_computeSequentialConditionalQuantile(self, q)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _experimental.PointConditionalDistribution_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _experimental.PointConditionalDistribution_getInverseIsoProbabilisticTransformation(self)

    def computeQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _experimental.PointConditionalDistribution_computeQuantile(self, prob, tail)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _experimental.PointConditionalDistribution_computeScalarQuantile(self, prob, tail)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _experimental.PointConditionalDistribution_getMarginal(self, *args)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _experimental.PointConditionalDistribution_hasIndependentCopula(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _experimental.PointConditionalDistribution_hasEllipticalCopula(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _experimental.PointConditionalDistribution_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _experimental.PointConditionalDistribution_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _experimental.PointConditionalDistribution_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _experimental.PointConditionalDistribution_isIntegral(self)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _experimental.PointConditionalDistribution_getSupport(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _experimental.PointConditionalDistribution_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _experimental.PointConditionalDistribution_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _experimental.PointConditionalDistribution_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _experimental.PointConditionalDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _experimental.PointConditionalDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _experimental.PointConditionalDistribution_getParameterDescription(self)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _experimental.PointConditionalDistribution_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _experimental.PointConditionalDistribution_computeCDFGradient(self, *args)

    def getDistribution(self):
        r"""
        Underlying distribution accessor.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution :math:`\cL_\theta(\inputReal)`
        """
        return _experimental.PointConditionalDistribution_getDistribution(self)

    def getConditioningIndices(self):
        r"""
        Conditioning vector indices accessor.

        Returns
        -------
        conditioningIndices : :class:`~openturns.Indices`
            Conditioning vector indices :math:`\cI`
        """
        return _experimental.PointConditionalDistribution_getConditioningIndices(self)

    def getConditioningValues(self):
        r"""
        Conditioning vector values accessor.

        Returns
        -------
        conditioningValues : :class:`~openturns.Point`
            Conditioning vector values :math:`\vect{x}_\cI`
        """
        return _experimental.PointConditionalDistribution_getConditioningValues(self)

    def getSimplifiedVersion(self):
        r"""
        Simplified distribution accessor.

        Returns
        -------
        simplified : :class:`~openturns.Distribution`
            Simplified distribution.

        Notes
        -----
        When a simplified version of the conditional exists, it avoids to use the generic methods:
        it is more efficient and more precise.
        """
        return _experimental.PointConditionalDistribution_getSimplifiedVersion(self)

    def setIntegrationAlgorithm(self, integrationAlgorithm):
        r"""
        Accessor to the integration algorithm used to compute the CDF.

        Parameters
        ----------
        algo : :class:`~openturns.IntegrationAlgorithm`
            Integration algorithm used to compute the CDF.
        """
        return _experimental.PointConditionalDistribution_setIntegrationAlgorithm(self, integrationAlgorithm)

    def getIntegrationAlgorithm(self):
        r"""
        Accessor to the integration algorithm used to compute the CDF.

        Returns
        -------
        algo : :class:`~openturns.IntegrationAlgorithm`
            Integration algorithm used to compute the CDF.

        Notes
        -----
        By default, if the dimension of :math:`\inputRV_\cI` is greater than 1, the integration algorithm is the :class:`~openturns.experimental.CubaIntegration` defined in the entry  `PointConditionalDistribution-CubaAlgorithm` if available and the :class:`~openturns.SimplicialCubature` algorithm if not. If the
        dimension of :math:`\inputRV_\cI` is 1, then the integration algorithm is the :class:`~openturns.GaussKronrod` algorithm with ts default quadrature
        formula.
        """
        return _experimental.PointConditionalDistribution_getIntegrationAlgorithm(self)

    def __init__(self, *args):
        _experimental.PointConditionalDistribution_swiginit(self, _experimental.new_PointConditionalDistribution(*args))
    __swig_destroy__ = _experimental.delete_PointConditionalDistribution

# Register PointConditionalDistribution in _experimental:
_experimental.PointConditionalDistribution_swigregister(PointConditionalDistribution)
class MarginalUniformOrderStatistics(openturns.dist_bundle2.MarginalDistribution):
    r"""
    Marginal uniformOrderStatistics.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    This class gives access to the marginals of the joint distribution of the :math:`n` order statistics
    of the Uniform distribution over :math:`[0,1]`, implemented in the class :class:`~openturns.experimental.UniformOrderStatistics`.

    Parameters
    ----------
    n : int
       The dimension of underlying uniform order statistics distribution, must be strictly positive.
    indices : sequence of int
        Marginal indices, must be strictly increasing.

    See also
    --------
    openturns.experimental.UniformOrderStatistics

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.MarginalUniformOrderStatistics_getClassName(self)

    def getN(self):
        r"""
        Accessor to the size of the underlying uniform order statistics.

        Returns
        -------
        N : int
            Size of the order statistics.
        """
        return _experimental.MarginalUniformOrderStatistics_getN(self)

    def __eq__(self, *args):
        return _experimental.MarginalUniformOrderStatistics___eq__(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _experimental.MarginalUniformOrderStatistics_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _experimental.MarginalUniformOrderStatistics_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d

        This method is overloaded by most of the actual distributions. Many generic
        algorithms are available depending on the properties of the
        distribution and can be used by actual distributions:

        - for discrete distributions, it is a summation of the probabilities
          of the points contributing to the CDF;
        - for absolutely continuous distributions, it is done using an adaptive
          integration of the PDF using :class:`~openturns.IteratedQuadrature`;
        - for unimodal absolutely continuous distributions, it is done using an
          adaptive integration of the PDF using
          :class:`~openturns.IteratedQuadrature` over a front of boxes starting
          from the projection of the cell containing the mode and advancing in
          all the directions toward the point at which one want to compute the
          CDF and the directions pointing toward :math:`-\infty`. The size of
          the boxes is controlled by a parameter set by the actual distribution
          and the maximum number of cells to explore is controlled by the
          *Distribution-DefaultCDFIteration* entry of :class:`~openturns.ResourceMap`


        """
        return _experimental.MarginalUniformOrderStatistics_computeCDF(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _experimental.MarginalUniformOrderStatistics_getMarginal(self, *args)

    def __repr__(self):
        return _experimental.MarginalUniformOrderStatistics___repr__(self)

    def __str__(self, *args):
        return _experimental.MarginalUniformOrderStatistics___str__(self, *args)

    def __init__(self, *args):
        _experimental.MarginalUniformOrderStatistics_swiginit(self, _experimental.new_MarginalUniformOrderStatistics(*args))
    __swig_destroy__ = _experimental.delete_MarginalUniformOrderStatistics

# Register MarginalUniformOrderStatistics in _experimental:
_experimental.MarginalUniformOrderStatistics_swigregister(MarginalUniformOrderStatistics)
class PosteriorDistribution(openturns.model_copula.DistributionImplementation):
    r"""
    Distribution conditioned by observations.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Let :math:`\inputRV` be a random vector such that :math:`\inputRV|\vect{\Theta}` follows the distribution
    :math:`\mathcal{L}_{\inputRV|\vect{\Theta}}`,
    with :math:`\vect{\Theta}=g(\vect{Y})` and :math:`\vect{Y}` following the prior distribution :math:`\mathcal{L}_{\vect{Y}}`. The function
    :math:`g` is the link function which input dimension
    is the dimension of :math:`\mathcal{L}_{\vect{Y}}` and which output dimension the dimension of :math:`\vect{\Theta}`.

    This class implements the posterior distribution of :math:`\vect{Y}` given that we have a sample :math:`(\vect{s}_1, \dots, \vect{s}_\sampleSize)` of
    :math:`\vect{X}`.

    This class requires the following features:

    - the :math:`\inputRV` may be continuous, discrete or neither: e.g., it can be a
      :class:`~openturns.Mixture` of discrete and continuous distributions. In that case, its parameters set is the union of the
      parameters set of each of its atoms (the weights of the mixture are not considered as parameters).
    - each component :math:`Y_i` is continuous or discrete: e.g., it can not be a :class:`~openturns.Mixture` of
      discrete and continuous distributions, (the random vector :math:`\vect{Y}` may have some discrete components and some continuous components), 
    - the copula of :math:`\vect{Y}` is continuous: e.g., it can not be the :class:`~openturns.MinCopula`.

    If  :math:`\vect{Y}` and :math:`\vect{X}` are continuous random vector, then the posterior PDF of :math:`\vect{Y}` is defined by:

    .. math::
        :label: postPDF

        f_{\vect{Y}|\inputRV_1 = \vect{x}_1, \dots, \inputRV_\sampleSize =  \vect{x}_\sampleSize}(\vect{y}) = \frac{f_{\vect{Y}}(\vect{y})
        \prod_{i=1}^\sampleSize f_{\inputRV|\vect{\theta} = g(\vect{y})}(\vect{x}_i)}{\int f_{\vect{Y}}(\vect{y})\prod_{i=1}^\sampleSize
        f_{\inputRV|\vect{\theta} = g(\vect{y})}(\vect{x}_i) d \vect{y}}

    with :math:`f_{\inputRV|\vect{\theta} = g(\vect{y})}` the PDF of the distribution of :math:`\inputRV|\vect{\Theta}`
    where :math:`\vect{\Theta}` has been replaced by :math:`g(\vect{y})` and :math:`f_{\vect{Y}}` the PDF of the prior distribution
    of  :math:`\vect{Y}`.

    Note that the denominator  of :eq:`postPDF` is the PDF of the deconditioned distribution of :math:`\inputRV|\vect{\Theta}=g(\vect{Y})`
    with respect to the prior distribution of :math:`\vect{Y}`.

    In the other cases, the PDF is the probability distribution function for the discrete components and the :math:`\int` are replaced by some
    :math:`\sum`.

    Parameters
    ----------
    deconditioned : :class:`~openturns.DeconditionedDistribution`
        The distribution of density :math:`f_{\vect{X}}(\vect{x}) = \int f_{\vect{X}|\vect{\Theta}=\vect{y}}(\vect{x}|\vect{y}) f_{\vect{Y}}(\vect{y})\di{\vect{y}}`.
    observations : 2-d sequence of float
        Observations :math:`\vect{x}_i`.

    See Also
    --------
    openturns.DeconditionedDistribution
    openturns.MetropolisHastings

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> ot.RandomGenerator.SetSeed(0)
    >>> conditionedDistribution = ot.Normal()
    >>> # Deconditioned distribution
    >>> atoms = [ot.Uniform(0.0, 1.0), ot.Uniform(1.0, 2.0)]
    >>> conditioning = ot.JointDistribution(atoms)
    >>> deconditioned = ot.DeconditionedDistribution(conditionedDistribution, conditioning)
    >>> # Observations
    >>> observationsSize = 5
    >>> observationsDistribution = ot.Distribution(conditionedDistribution)
    >>> observationsDistribution.setParameter(conditioning.getMean())
    >>> observations = observationsDistribution.getSample(observationsSize)
    >>> # Posterior distribution
    >>> distribution = otexp.PosteriorDistribution(deconditioned, observations)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PosteriorDistribution_getClassName(self)

    def __eq__(self, *args):
        return _experimental.PosteriorDistribution___eq__(self, *args)

    def __repr__(self):
        return _experimental.PosteriorDistribution___repr__(self)

    def __str__(self, *args):
        return _experimental.PosteriorDistribution___str__(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _experimental.PosteriorDistribution_computeLogPDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _experimental.PosteriorDistribution_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d

        This method is overloaded by most of the actual distributions. Many generic
        algorithms are available depending on the properties of the
        distribution and can be used by actual distributions:

        - for discrete distributions, it is a summation of the probabilities
          of the points contributing to the CDF;
        - for absolutely continuous distributions, it is done using an adaptive
          integration of the PDF using :class:`~openturns.IteratedQuadrature`;
        - for unimodal absolutely continuous distributions, it is done using an
          adaptive integration of the PDF using
          :class:`~openturns.IteratedQuadrature` over a front of boxes starting
          from the projection of the cell containing the mode and advancing in
          all the directions toward the point at which one want to compute the
          CDF and the directions pointing toward :math:`-\infty`. The size of
          the boxes is controlled by a parameter set by the actual distribution
          and the maximum number of cells to explore is controlled by the
          *Distribution-DefaultCDFIteration* entry of :class:`~openturns.ResourceMap`


        """
        return _experimental.PosteriorDistribution_computeCDF(self, *args)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _experimental.PosteriorDistribution_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _experimental.PosteriorDistribution_setParametersCollection(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _experimental.PosteriorDistribution_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, getSampleByInversion, getSampleByQMC
        """
        return _experimental.PosteriorDistribution_getSample(self, size)

    def setDeconditionedDistribution(self, deconditionedDistribution):
        r"""
        Deconditioned distribution accessor.

        Parameters
        ----------
        deconditioned : :class:`~openturns.DeconditionedDistribution`
            The deconditioned distribution.
        """
        return _experimental.PosteriorDistribution_setDeconditionedDistribution(self, deconditionedDistribution)

    def getDeconditionedDistribution(self):
        r"""
        Deconditioned distribution accessor.

        Returns
        -------
        deconditioned : :class:`~openturns.DeconditionedDistribution`
            The deconditioned distribution.
        """
        return _experimental.PosteriorDistribution_getDeconditionedDistribution(self)

    def setConditionedDistribution(self, conditionedDistribution):
        r"""
        Accessor to the distribution's conditioned distribution parameter *conditionedDistribution*.

        Parameters
        ----------
        conditionedDistribution : :class:`~openturns.Distribution`
            the distribution of :math:`\vect{X}|\vect{\Theta}`,
            whose parameters will be overwritten by :math:`g(\vect{Y})`.

        """
        return _experimental.PosteriorDistribution_setConditionedDistribution(self, conditionedDistribution)

    def getConditionedDistribution(self):
        r"""
        Accessor to the distribution's conditioned distribution parameter *conditionedDistribution*.

        Returns
        -------
        conditionedDistribution : :class:`~openturns.Distribution`
            the distribution of :math:`\vect{X}|\vect{\Theta}`,
            whose parameters will be overwritten by :math:`g(\vect{Y})`.

        """
        return _experimental.PosteriorDistribution_getConditionedDistribution(self)

    def setConditioningDistribution(self, conditioningDistribution):
        r"""
        Accessor to the distribution's conditioned distribution parameter *conditioningDistribution*.

        Parameters
        ----------
        conditioningDistribution : :class:`~openturns.Distribution`
            the distribution of :math:`\vect{Y}`, specified with its parameters.

        """
        return _experimental.PosteriorDistribution_setConditioningDistribution(self, conditioningDistribution)

    def getConditioningDistribution(self):
        r"""
        Accessor to the distribution's conditioned distribution parameter *conditioningDistribution*.

        Returns
        -------
        conditioningDistribution : :class:`~openturns.Distribution`
            the distribution of :math:`\vect{Y}`, specified with its parameters.

        """
        return _experimental.PosteriorDistribution_getConditioningDistribution(self)

    def setLinkFunction(self, linkFunction):
        r"""
        Accessor to the distribution's conditioned distribution parameter *linkFunction*.

        Parameters
        ----------
        linkFunction : :class:`~openturns.Function`
            the function :math:`g: \Rset^p \rightarrow \Rset^q`, where :math:`p` is the dimension of
            *conditioningDist* and :math:`q` is the dimension of :math:`\vect{\Theta}`.

        """
        return _experimental.PosteriorDistribution_setLinkFunction(self, linkFunction)

    def getLinkFunction(self):
        r"""
        Accessor to the distribution's conditioned distribution parameter *linkFunction*.

        Returns
        -------
        linkFunction : :class:`~openturns.Function`
            the function :math:`g: \Rset^p \rightarrow \Rset^q`, where :math:`p` is the dimension of
            *conditioningDist* and :math:`q` is the dimension of :math:`\vect{\Theta}`.

        """
        return _experimental.PosteriorDistribution_getLinkFunction(self)

    def setObservations(self, observations):
        r"""
        Accessor to the observations.

        Parameters
        ----------
        observations : 2-d sequence of float
            Observations.
        """
        return _experimental.PosteriorDistribution_setObservations(self, observations)

    def getObservations(self):
        r"""
        Accessor to the observations.

        Returns
        -------
        observations : :class:`~openturns.Sample`
            Observations.
        """
        return _experimental.PosteriorDistribution_getObservations(self)

    def getLogNormalizationFactor(self):
        r"""
        Normalization factor accessor.

        Returns
        -------
        factor : float
            Log-scale normalization factor.
        """
        return _experimental.PosteriorDistribution_getLogNormalizationFactor(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _experimental.PosteriorDistribution_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _experimental.PosteriorDistribution_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _experimental.PosteriorDistribution_getKurtosis(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _experimental.PosteriorDistribution_isContinuous(self)

    def computeNormalizedLikelihood(self, theta):
        r"""
        Compute the likelihood including the normalization constant.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^\inputDim`.

        Returns
        -------
        value : float
            The value of the likelihood at *x*.

        Notes
        -----
        The normalized likelihood is the PDF of the posterior distribution defined in :eq:`postPDF`.
        """
        return _experimental.PosteriorDistribution_computeNormalizedLikelihood(self, theta)

    def computeLogNormalizedLikelihood(self, theta):
        r"""
        Compute the log-likelihood including the normalization constant.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^\inputDim`.

        Returns
        -------
        value : float
            The value of the log-likelihood at *x*.

        Notes
        -----
        The normalized log-likelihood is the log-PDF of the posterior distribution defined in :eq:`postPDF`.
        """
        return _experimental.PosteriorDistribution_computeLogNormalizedLikelihood(self, theta)

    def __init__(self, *args):
        _experimental.PosteriorDistribution_swiginit(self, _experimental.new_PosteriorDistribution(*args))
    __swig_destroy__ = _experimental.delete_PosteriorDistribution

# Register PosteriorDistribution in _experimental:
_experimental.PosteriorDistribution_swigregister(PosteriorDistribution)
class UniformOrderStatistics(openturns.model_copula.DistributionImplementation):
    r"""
    UniformOrderStatistics distribution.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    dimension : int
        The dimension of the distribution.

    See also
    --------
    openturns.MaximumEntropyOrderStatisticsDistribution

    Notes
    -----
    Let :math:`X` be a random variable and :math:`\vect{X}_{(1:n)} = (X_{(1)},\dots,X_{(n)})`
    be the random vector of all its order statistics  of size :math:`n`.

    This class implements the joint distribution of :math:`\vect{X}_{(1:n)}` when :math:`X` is
    distributed according to the Uniform distribution over :math:`[0,1]`. Its probability density
    function is defined by (see [arnold2008]_ eq. 2.2.4 page 11):

    .. math::

        f_{\vect{X}_{(1:n)}}(\vect{x}) = n!\,\mathbf{1}_{\cS}(\vect{x}) \quad \vect{x} \in
        \Rset^n

    where :math:`\cS\subset\Rset^n` is defined by:

    .. math::
       \cS=\left\{(x_1,\dots,x_n)\in[0,1]^n\,|\,0 \leq x_1 \leq \dots \leq x_n \leq 1\right\}.

    Let :math:`\cV` be defined by:

    .. math::
       \cV=\left\{(\underbrace{0,\dots,0}_{k}, \underbrace{1,\dots,1}_{n-k}), \; k\in\{0,\dots,n\}\right\},

    then, :math:`\cS` is the simplex with vertices :math:`\cV`:

    .. math::
       \cS = \left\{\sum_{k = 1}^{n + 1} \lambda_k v_k \, \left|\right.\, v_k \in \cV, \;
       \lambda_k \in [0,1], \; \sum_{k = 1}^{n + 1} \lambda_k = 1\right\}.

    If  :math:`X` is a random variable distributed according to
    :math:`\cL`, which PDF (if defined) is :math:`f` and CDF is :math:`F`, then the random vector
    of its :math:`n`  order statistics is distributed as the random vector
    :math:`(F^{-1}(U_{(1)}), \dots, F^{-1}(U_{(n)}))` where the :math:`U_{(i)}`
    are the order statistics of the Uniform distribution over :math:`[0,1]`:

    .. math::
        (X_{(1)},\dots,X_{(n)}) \sim (F^{-1}(U_{(1)}), \dots, F^{-1}(U_{(n)}))

    Then the CDF of :math:`\vect{X}_{(1:n)}` is defined for :math:`\vect{x} \in \Rset^n` by:

    .. math::
        F_{\vect{X}_{(1:n)}}(\vect{x}) = F_{\vect{U}_{(1:n)}}(F(x_1), \dots, F(x_n))

    and its PDF (if defined) by:

    .. math::

        f_{\vect{X}_{(1:n)}}(\vect{x}) = n!\prod_{i=1}^n f(x_i) \,\mathbf{1}_{\cS}(\vect{x})

    Thus, to get the joint distribution of :math:`\vect{X}_{(1:n)}`, we use the
    :class:`~openturns.JointDistribution` whose all marginals are  :math:`\cL`
    and whose core is a :class:`~openturns.experimental.UniformOrderStatistics`.

    Examples
    --------
    Create  joint distribution of :math:`\vect{U}_{(1:n)}` with :math:`n=10`:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> n = 10
    >>> unif_orderStat = otexp.UniformOrderStatistics(n)

    Create the joint distribution of :math:`\vect{X}_{(1:n)}` where
    :math:`X` is distributed as a Normal distribution, with zero mean and unit standard
    deviation:

    >>> X_dist = ot.Normal()
    >>> normal_orderStat = ot.JointDistribution([X_dist]*n, otexp.UniformOrderStatistics(n))
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.UniformOrderStatistics_getClassName(self)

    def __eq__(self, *args):
        return _experimental.UniformOrderStatistics___eq__(self, *args)

    def __repr__(self):
        return _experimental.UniformOrderStatistics___repr__(self)

    def __str__(self, *args):
        return _experimental.UniformOrderStatistics___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _experimental.UniformOrderStatistics_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _experimental.UniformOrderStatistics_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _experimental.UniformOrderStatistics_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d

        This method is overloaded by most of the actual distributions. Many generic
        algorithms are available depending on the properties of the
        distribution and can be used by actual distributions:

        - for discrete distributions, it is a summation of the probabilities
          of the points contributing to the CDF;
        - for absolutely continuous distributions, it is done using an adaptive
          integration of the PDF using :class:`~openturns.IteratedQuadrature`;
        - for unimodal absolutely continuous distributions, it is done using an
          adaptive integration of the PDF using
          :class:`~openturns.IteratedQuadrature` over a front of boxes starting
          from the projection of the cell containing the mode and advancing in
          all the directions toward the point at which one want to compute the
          CDF and the directions pointing toward :math:`-\infty`. The size of
          the boxes is controlled by a parameter set by the actual distribution
          and the maximum number of cells to explore is controlled by the
          *Distribution-DefaultCDFIteration* entry of :class:`~openturns.ResourceMap`


        """
        return _experimental.UniformOrderStatistics_computeCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _experimental.UniformOrderStatistics_computeProbability(self, interval)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _experimental.UniformOrderStatistics_computeEntropy(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _experimental.UniformOrderStatistics_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _experimental.UniformOrderStatistics_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _experimental.UniformOrderStatistics_getKurtosis(self)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _experimental.UniformOrderStatistics_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _experimental.UniformOrderStatistics_getParameterDescription(self)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _experimental.UniformOrderStatistics_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Sequence of conditional PDF values at *x*.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            \left(\dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.
        """
        return _experimental.UniformOrderStatistics_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _experimental.UniformOrderStatistics_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at *x*.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            \left(F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`F_{X_1}(x_1)`.
        """
        return _experimental.UniformOrderStatistics_computeSequentialConditionalCDF(self, x)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _experimental.UniformOrderStatistics_computeConditionalQuantile(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        p : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Sequence of conditional quantiles values at *p*

        Notes
        -----
        The sequential conditional quantile function is defined by:

        .. math::

            \left(F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p_j; x_1, \dots, x_{j-1})\right)_{i=1,\ldots,d}

        where :math:`F^{-1}` is the quantile function and
        where :math:`x_1,\ldots,x_{j-1}` are defined recursively as :math:`x_1=F_1^{-1}(p_1)` and for :math:`2\leq j \leq d`,
        :math:`x_j=F_{X_j}^{-1}(p_j|X_1=x_1,\ldots,X_{j-1}=x_{j-1})`: the conditioning part is the set of already
        computed conditional quantiles.
        """
        return _experimental.UniformOrderStatistics_computeSequentialConditionalQuantile(self, q)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _experimental.UniformOrderStatistics_getMarginal(self, *args)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _experimental.UniformOrderStatistics_hasIndependentCopula(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _experimental.UniformOrderStatistics_hasEllipticalCopula(self)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, d\right]

        See Also
        --------
        getKendallTau
        """
        return _experimental.UniformOrderStatistics_getSpearmanCorrelation(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _experimental.UniformOrderStatistics_getKendallTau(self)

    def __init__(self, *args):
        _experimental.UniformOrderStatistics_swiginit(self, _experimental.new_UniformOrderStatistics(*args))
    __swig_destroy__ = _experimental.delete_UniformOrderStatistics

# Register UniformOrderStatistics in _experimental:
_experimental.UniformOrderStatistics_swigregister(UniformOrderStatistics)
class GeneralizedParetoValidation(openturns.common.PersistentObject):
    r"""
    Validation of GeneralizedExtremeValue inference.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    result : :class:`~openturns.DistributionFactoryResult`
        Inference result to validate.
    sample : 2-d sequence of float
        Data on which the inference was performed.

    See also
    --------
    openturns.GeneralizedExtremeValueFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.GeneralizedParetoValidation_getClassName(self)

    def drawReturnLevel(self):
        r"""
        Draw the return level with confidence interval.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The return level graph.

        Notes
        -----
        The *return level* plot consists of the points:

        .. math::
            \left\{ \left( m, \hat{z}_m\right), m >0 \right\}

        and the points:

        .. math::
            \left\{ \left( m, z_{m}^{emp}\right), m> 0\right\}

        where :math:`z_{m}^{emp}` is the empirical :math:`m`-observation return level and :math:`\hat{z}_{m}` the 
        :math:`m`-observation return level calculated with the fitted GPD.
        """
        return _experimental.GeneralizedParetoValidation_drawReturnLevel(self)

    def drawPDF(self):
        r"""
        Draw the estimated density and the data histogram.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The estimated density and the data histogram.

        """
        return _experimental.GeneralizedParetoValidation_drawPDF(self)

    def drawDiagnosticPlot(self):
        r"""
        Draw the 4 usual diagnostic plots.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Returns a grid of 4 graphs:
             - the QQ-plot,
             - the PP-plot,
             - the return level graph (with confidence lines),
             - the density graph.

        Notes
        -----
        The 4 graphs are the *probability-probability* plot, the *quantile-quantile* plot, the *return level* plot, the data histogram with the fitted model density.


        If :math:`(z_{(1)} \leq z_{(2)} \leq \dots \leq z_{(n)})` denotes the ordered block maximum data and :math:`\hat{G}` the cumulative distribution function of the GPD distribution fitted on the data, the graphs are defined as follows.

        The *probability-probability* plot consists of the points:

        .. math::
            \left\{ \left( i/(n+1), \hat{G}(z_{(i)}) \right), i=1, \dots , m\right\}


        The *quantile-quantile* plot consists of the points:

        .. math::
            \left\{  \left(  z_{(i)},  \hat{G}^{-1}(i/(n+1))  \right), i=1, \dots , n\right\} 

        The *return level* plot consists of the points:

        .. math::
            \left\{ \left( m, \hat{z}_m\right), m> 0\right\}

        and the points:

        .. math::
            \left\{ \left( m, z_{m}^{emp}\right), m> 0\right\}

        where :math:`z_{m}^{emp}` is the empirical :math:`m`-observation return level and :math:`\hat{z}_{m}` the 
        :math:`m`-observation return level calculated with the fitted GPD.

        """
        return _experimental.GeneralizedParetoValidation_drawDiagnosticPlot(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Confidence level accessor.

        Parameters
        ----------
        level : float
            Confidence level for the confidence lines.

        """
        return _experimental.GeneralizedParetoValidation_setConfidenceLevel(self, confidenceLevel)

    def getConfidenceLevel(self):
        r"""
        Confidence level accessor.

        Returns
        -------
        level : float
            Confidence level for the confidence lines.

        """
        return _experimental.GeneralizedParetoValidation_getConfidenceLevel(self)

    def __repr__(self):
        return _experimental.GeneralizedParetoValidation___repr__(self)

    def __init__(self, *args):
        _experimental.GeneralizedParetoValidation_swiginit(self, _experimental.new_GeneralizedParetoValidation(*args))
    __swig_destroy__ = _experimental.delete_GeneralizedParetoValidation

# Register GeneralizedParetoValidation in _experimental:
_experimental.GeneralizedParetoValidation_swigregister(GeneralizedParetoValidation)
class FunctionalChaosValidation(openturns.metamodel.MetaModelValidation):
    r"""
    Validate a functional chaos metamodel.


    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    result : :class:`~openturns.FunctionalChaosResult`
        A functional chaos result obtained from a polynomial chaos expansion.

    splitter : :class:`~openturns.SplitterImplementation`, optional
        The cross-validation method.
        The default is :class:`~openturns.LeaveOneOutSplitter`.

    See also
    --------
    openturns.FunctionalChaosAlgorithm, openturns.FunctionalChaosResult

    Notes
    -----
    A `FunctionalChaosValidation` object is used for the validation of a functional chaos expansion.
    It is based on the fast (analytical) leave-one-out and fast K-Fold
    cross-validation methods presented in :ref:`pce_cross_validation`.

    Analytical cross-validation can only be performed accurately if some
    conditions are met.

    - This can only be done if the coefficients of the expansion are estimated
      using least squares regression: if the expansion is computed from integration,
      then an exception is produced.
    - This can only be done if the coefficients of the expansion are estimated
      using full expansion, without model selection: if the expansion is computed
      with model selection, then an exception is produced by default.
      This is because model selection leads to supposedly improved coefficients,
      so that the hypotheses required to estimate the mean squared error
      using the cross-validation method are not satisfied anymore.
      As a consequence, using the analytical formula without taking model selection into
      account leads to a biased, overly optimistic, mean squared
      error.
      More precisely, the analytical formula produces a MSE which is lower
      than the true one on average.
      Model selection is involved in the expansion if the
      :class:`~openturns.LeastSquaresMetaModelSelectionFactory`
      or :class:`~openturns.CleaningStrategy` classes are involved.
      If the :class:`~openturns.PenalizedLeastSquaresAlgorithmFactory` class
      is used, then no model selection is involved and the analytical
      cross-validation methods can be used.
      If model selection is involved, the naive methods based on the
      :class:`~openturns.LeaveOneOutSplitter` and :class:`~openturns.KFoldSplitter`
      classes can be used, but this can be much slower than the
      analytical methods implemented in the :class:`~openturns.experimental.FunctionalChaosValidation`
      class.
      In many cases, however, the order of magnitude of the estimate from the
      analytical formula applied to a sparse model is correct: the estimate of
      the MSE is only slightly lower than the true value.
      In order to enable the calculation of the analytical MSE estimator
      on a sparse model, please set the `FunctionalChaosValidation-ModelSelection`
      key of the :class:`~openturns.ResourceMap` to `True`: use this
      option at your own risks.

    We suggest to use leave-one-out (LOO) cross validation when possible,
    because it produces a more accurate estimate of the error than K-Fold does.
    If K-Fold is required, we suggest to use the largest possible value of :math:`k`.

    The predictions of the leave-one-one or K-Fold surrogate models
    are based on the hold-out method.
    For example, if we use the leave-one-out cross-validation method,
    the :math:`i`-th prediction is the prediction of the linear model
    trained using the hold-out sample where the :math:`i`-th observation
    was removed.
    This produces a sample of residuals which can be retrieved using
    the :meth:`~openturns.experimental.FunctionalChaosValidation.getResidualSample` method.
    The :meth:`~openturns.experimental.FunctionalChaosValidation.drawValidation` method performs
    similarly.

    If the weights of the observations are not equal, the analytical method
    may not necessarily provide an accurate estimator of the mean squared error (MSE).
    This is because LOO and K-Fold cross-validation do not take the weights
    into account.
    Since the :class:`~openturns.FunctionalChaosResult` object does not know
    if the weights are equal, no exception can be generated.

    If the sample was not produced from Monte Carlo, then the leave-one-out
    cross-validation method may not necessarily provide an accurate estimator
    of the MSE.
    Indeed, one assumption for cross validation using LOO or K-Fold is to have
    independent observations, which is required to state that the LOO sample MSE
    is an estimator of the true MSE.
    For example, using cross-validation on a quasi-Monte Carlo (QMC) experiment may
    not necessarily provide an accurate estimate of the MSE, because the
    internal structure of the QMC is broken by the different splits:
    the elementary volumes are not filled as expected anymore and the
    space-filling properties of the sequence are lost.

    Examples
    --------
    Create a polynomial chaos for the Ishigami function.
    We use the :class:`~openturns.PenalizedLeastSquaresAlgorithmFactory` class
    to specify the method to compute the coefficients.
    We may use the :class:`~openturns.LeastSquaresMetaModelSelectionFactory` class
    in order to create a sparse polynomial chaos expansion, but this
    prevents us from using the fast analytical formulas and get an
    accurate estimator of the MSE.

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> from math import pi
    >>> from openturns.usecases import ishigami_function
    >>> im = ishigami_function.IshigamiModel()
    >>> sampleSize = 500 
    >>> inputTrain = im.inputDistribution.getSample(sampleSize)
    >>> outputTrain = im.model(inputTrain)
    >>> multivariateBasis = ot.OrthogonalProductPolynomialFactory([im.X1, im.X2, im.X3])
    >>> selectionAlgorithm = ot.PenalizedLeastSquaresAlgorithmFactory()
    >>> projectionStrategy = ot.LeastSquaresStrategy(inputTrain, outputTrain, selectionAlgorithm)
    >>> totalDegree = 8
    >>> enumerateFunction = multivariateBasis.getEnumerateFunction()
    >>> basisSize = enumerateFunction.getStrataCumulatedCardinal(totalDegree)
    >>> adaptiveStrategy = ot.FixedStrategy(multivariateBasis, basisSize)
    >>> chaosalgo = ot.FunctionalChaosAlgorithm(
    ...     inputTrain, outputTrain, im.inputDistribution, adaptiveStrategy, projectionStrategy
    ... )
    >>> chaosalgo.run()
    >>> result = chaosalgo.getResult()

    Validate the polynomial chaos expansion using leave-one-out cross-validation.

    >>> splitterLOO = ot.LeaveOneOutSplitter(sampleSize)
    >>> validation = otexp.FunctionalChaosValidation(result, splitterLOO)
    >>> r2Score = validation.computeR2Score()
    >>> print('R2 = ', r2Score[0])
    R2 =  0.99...

    Validate the polynomial chaos expansion using K-Fold cross-validation
    and set the :math:`k` parameter.

    >>> kParameter = 10
    >>> splitterKF = ot.KFoldSplitter(sampleSize, kParameter)
    >>> validation = otexp.FunctionalChaosValidation(
    ...     result, splitterKF
    ... )

    Draw the validation graph.

    >>> graph = validation.drawValidation()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.FunctionalChaosValidation_getClassName(self)

    def __repr__(self):
        return _experimental.FunctionalChaosValidation___repr__(self)

    def getFunctionalChaosResult(self):
        r"""
        Result accessor.

        Returns
        -------
        result : :class:`~openturns.FunctionalChaosResult`
            The result provided.
        """
        return _experimental.FunctionalChaosValidation_getFunctionalChaosResult(self)

    def getSplitter(self):
        r"""
        Get the cross-validation method.

        Returns
        -------
        splitter : :class:`~openturns.SplitterImplementation`
            The cross-validation method.
        """
        return _experimental.FunctionalChaosValidation_getSplitter(self)

    def __init__(self, *args):
        _experimental.FunctionalChaosValidation_swiginit(self, _experimental.new_FunctionalChaosValidation(*args))
    __swig_destroy__ = _experimental.delete_FunctionalChaosValidation

# Register FunctionalChaosValidation in _experimental:
_experimental.FunctionalChaosValidation_swigregister(FunctionalChaosValidation)
class LinearModelValidation(openturns.metamodel.MetaModelValidation):
    r"""
    Validate a linear regression metamodel.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    result : :class:`~openturns.LinearModelResult`
        A linear model result resulting from linear least squares regression.

    splitter : :class:`~openturns.SplitterImplementation`
        The cross-validation method.
        The default is :class:`~openturns.LeaveOneOutSplitter`.

    See also
    --------
    openturns.LinearModelResult

    Notes
    -----
    A `LinearModelValidation` object is used for the validation of a linear model.
    It is based on the fast (analytical) leave-one-out and fast K-Fold
    cross-validation methods presented in :ref:`cross_validation`.

    Analytical cross-validation can only be performed if all coefficients are estimated without model selection:
    if the coefficients are computed with model selection, then an exception is
    produced by default.
    This is because model selection leads to supposedly improved coefficients,
    so that the hypotheses required to estimate the mean squared error
    using the cross-validation method are not satisfied anymore.
    As a consequence, using the analytical formula without taking into
    account for the model selection leads to a biased, optimistic, mean squared
    error.
    More precisely, the analytical formula produces a MSE which is lower
    than the true one on average.
    Model selection is involved if the
    :class:`~openturns.LinearModelStepwiseAlgorithm` class is involved.
    If the :class:`~openturns.LinearModelAlgorithm` class
    is used, then no model selection is involved and the analytical
    cross-validation methods can be used.
    If model selection is involved, the naive methods based on the
    :class:`~openturns.LeaveOneOutSplitter` and :class:`~openturns.KFoldSplitter`
    classes can be used directly, but this can be much slower than the
    analytical methods implemented in the :class:`~openturns.experimental.LinearModelValidation`
    class.
    In many cases, however, the order of magnitude of the estimate from the
    analytical formula applied to a sparse model is correct: the estimate of
    the MSE is only slightly lower than the true value.
    In order to enable the calculation of the analytical MSE estimator
    on a sparse model, please set the `LinearModelValidation-ModelSelection`
    key of the :class:`~openturns.ResourceMap` to `False`: use this
    option at your own risks.

    We suggest to use leave-one-out cross validation when possible,
    because it produces a more accurate estimate of the error than K-Fold does.
    If K-Fold is required, we suggest to use the largest possible value of :math:`k`.

    The predictions of the leave-one-one or K-Fold surrogate models
    are based on the hold-out method.
    For example, if we use the leave-one-out cross-validation method,
    the :math:`i`-th prediction is the prediction of the linear model
    trained using the hold-out sample where the :math:`i`-th observation
    was removed.
    This produces a sample of residuals which can be retrieved using
    the :class:`~openturns.experimental.LinearModelValidation.getResidualSample` method.
    The :class:`~openturns.experimental.LinearModelValidation.drawValidation` performs
    similarly.

    Examples
    --------
    Create a linear model.

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> ot.RandomGenerator.SetSeed(0)
    >>> func = ot.SymbolicFunction(
    ...     ['x1', 'x2', 'x3'],
    ...     ['x1 + x2 + sin(x2 * 2 * pi_) / 5 + 1e-3 * x3^2']
    ... )
    >>> dimension = 3
    >>> distribution = ot.JointDistribution([ot.Normal()] * dimension)
    >>> sampleSize = 20
    >>> inputSample = distribution.getSample(sampleSize)
    >>> outputSample = func(inputSample)
    >>> algo = ot.LinearModelAlgorithm(inputSample, outputSample)
    >>> algo.run()
    >>> result = algo.getResult()

    Validate the linear model using leave-one-out cross-validation.

    >>> validation = otexp.LinearModelValidation(result)

    We can use a specific cross-validation splitter if needed.

    >>> splitterLOO = ot.LeaveOneOutSplitter(sampleSize)
    >>> validation = otexp.LinearModelValidation(result, splitterLOO)
    >>> r2Score = validation.computeR2Score()
    >>> print('R2 = ', r2Score[0])
    R2 =  0.98...

    Validate the linear model using K-Fold cross-validation.

    >>> splitterKFold = ot.KFoldSplitter(sampleSize)
    >>> validation = otexp.LinearModelValidation(result, splitterKFold)

    Validate the linear model using K-Fold cross-validation and set K.

    >>> kFoldParameter = 10
    >>> splitterKFold = ot.KFoldSplitter(sampleSize, kFoldParameter)
    >>> validation = otexp.LinearModelValidation(result, splitterKFold)

    Draw the validation graph.

    >>> graph = validation.drawValidation()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.LinearModelValidation_getClassName(self)

    def __repr__(self):
        return _experimental.LinearModelValidation___repr__(self)

    def getLinearModelResult(self):
        r"""
        Get the linear model result.

        Returns
        -------
        linearModelResult : :class:`~openturns.LinearModelResult`
            The linear model result.
        """
        return _experimental.LinearModelValidation_getLinearModelResult(self)

    def getSplitter(self):
        r"""
        Get the cross-validation method.

        Returns
        -------
        splitter : :class:`~openturns.SplitterImplementation`
            The cross-validation method.
        """
        return _experimental.LinearModelValidation_getSplitter(self)

    def __init__(self, *args):
        _experimental.LinearModelValidation_swiginit(self, _experimental.new_LinearModelValidation(*args))
    __swig_destroy__ = _experimental.delete_LinearModelValidation

# Register LinearModelValidation in _experimental:
_experimental.LinearModelValidation_swigregister(LinearModelValidation)
class GaussianProcessFitterResult(openturns.metamodel.MetaModelResult):
    r"""
    Gaussian process fitter result.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Refer to :ref:`gaussian_process_regression`.

    Parameters
    ----------
    inputSample, outputSample : :class:`~openturns.Sample`
        The samples :math:`(\vect{x}_k)_{1 \leq k \leq \sampleSize} \in \Rset^{\inputDim}` and :math:`(\vect{y}_k)_{1 \leq k \leq \sampleSize}\in \Rset^{\outputDim}`.
    metaModel : :class:`~openturns.Function`
        The metamodel: :math:`\metaModel`, defined in :eq:`metaModelGPF` by the trend function.
    regressionMatrix : :class:`~openturns.Matrix`
        The regression matrix, e.g the evaluation of the basis functions
        upon the input design sample.
    basis :  :class:`~openturns.Basis`
        Functional basis of size :math:`b` : :math:`(\varphi_j: \Rset^{\inputDim} \rightarrow \Rset)` for :math:`j \in [1, b]`.
        Its size should be equal to zero if the trend is not estimated.
    trendCoef : sequence of float
        The trend coefficients vectors :math:`(\vect{\beta}^1, \dots, \vect{\beta}^{\outputDim})`.
    covarianceModel : :class:`~openturns.CovarianceModel`
        The covariance model of the Gaussian process with its optimized parameters.
    optimalLogLikelihood : float
        The maximum log-likelihood corresponding to the model.
    linAlgMethod : int
        The used linear algebra method to fit the model:

        - otexp.GaussianProcessFitterResult.LAPACK or 0: using `LAPACK` to fit the model,

        - otexp.GaussianProcessFitterResult.HMAT or 1: using `HMAT` to fit the model.

    Notes
    -----
    The structure is usually created by the method :py:meth:`~openturns.experimental.GaussianProcessFitter.run` of the class
    :class:`~openturns.experimental.GaussianProcessFitter` and obtained with its method
    :py:meth:`~openturns.experimental.GaussianProcessFitter.getResult()`.

    Refer to :ref:`gaussian_process_regression` (Step 1) to get all the notations and the theoretical aspects. We only detail here the notions related to the class.

    This class creates the metamodel
    :math:`\metaModel: \Rset^{\inputDim} \rightarrow \Rset^{\outputDim}` defined by the estimated trend
    function:

    .. math::
        :label: metaModelGPF

        \metaModel(\vect{x}) = \vect{\mu}(\vect{x}) = \left(
          \begin{array}{l}
            \mu_1(\vect{x}) \\
            \vdots  \\
            \mu_\outputDim(\vect{x})
           \end{array}
         \right)

    with :math:`\mu_\ell(\vect{x}) = \sum_{j=1}^{b} \beta_j^\ell \varphi_j(\vect{x})` and :math:`\varphi_j: \Rset^\inputDim \rightarrow \Rset` the trend functions for :math:`1 \leq j \leq b` and :math:`1 \leq \ell \leq \outputDim`.

    Examples
    --------
    Create the model :math:`\model: \Rset \mapsto \Rset` and the samples:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> g = ot.SymbolicFunction(['x'],  ['x * sin(x)'])
    >>> sampleX = [[1.0], [2.0], [3.0], [4.0], [5.0], [6.0]]
    >>> sampleY = g(sampleX)

    Create the algorithm:

    >>> basis = ot.Basis([ot.SymbolicFunction(['x'], ['x']), ot.SymbolicFunction(['x'], ['x^2'])])
    >>> covarianceModel = ot.GeneralizedExponential([2.0], 2.0)
    >>> algo = otexp.GaussianProcessFitter(sampleX, sampleY, covarianceModel, basis)
    >>> algo.run()

    Get the result:

    >>> result = algo.getResult()

    Get the metamodel :math:`\metaModel(\vect{x}) = \vect{\mu}(\vect{x})`:

    >>> metaModel = result.getMetaModel()
    >>> graph = metaModel.draw(0.0, 7.0)
    >>> cloud = ot.Cloud(sampleX, sampleY)
    >>> cloud.setPointStyle('fcircle')
    >>> graph = ot.Graph()
    >>> graph.add(cloud)
    >>> graph.add(g.draw(0.0, 7.0))

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.GaussianProcessFitterResult_getClassName(self)
    LAPACK = _experimental.GaussianProcessFitterResult_LAPACK
    HMAT = _experimental.GaussianProcessFitterResult_HMAT

    def __repr__(self):
        return _experimental.GaussianProcessFitterResult___repr__(self)

    def __str__(self, *args):
        return _experimental.GaussianProcessFitterResult___str__(self, *args)

    def getBasis(self):
        r"""
        Accessor to the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`
            Functional basis to estimate the trend: :math:`(\varphi_j)_{1 \leq j \leq b}: \Rset^\inputDim \rightarrow \Rset`.

        Notes
        -----
        If the trend is not estimated, the basis is empty. The same basis is used for each marginal output.
        """
        return _experimental.GaussianProcessFitterResult_getBasis(self)

    def getTrendCoefficients(self):
        r"""
        Accessor to the trend coefficients.

        Returns
        -------
        trendCoef : sequence of float
            The trend coefficients vectors :math:`(\vect{\beta}^1, \dots, \vect{\beta}^{\outputDim})` as a :class:`~openturns.Point`.

        Notes
        -----
        As the same basis is used for each marginal output, each :math:`\vect{\beta}^\ell` vector is of dimension
        :math:`b`, the size of the functional basis.
        """
        return _experimental.GaussianProcessFitterResult_getTrendCoefficients(self)

    def getCovarianceModel(self):
        r"""
        Accessor to the covariance model.

        Returns
        -------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model of the Gaussian process :math:`\vect{W}` with its optimized parameters.

        """
        return _experimental.GaussianProcessFitterResult_getCovarianceModel(self)

    def getOptimalLogLikelihood(self):
        r"""
        Accessor to the optimal log-likelihood of the model.

        Returns
        -------
        optimalLogLikelihood : float
            The value of the log-likelihood corresponding to the model.

        """
        return _experimental.GaussianProcessFitterResult_getOptimalLogLikelihood(self)

    def getLinearAlgebraMethod(self):
        r"""
        Accessor to the linear algebra method used to fit.

        Returns
        -------
        linAlgMethod : int
            The used linear algebra method to fit the model:

            - otexp.GaussianProcessFitterResult.LAPACK or 0: using `LAPACK` to fit the model,

            - otexp.GaussianProcessFitterResult.HMAT or 1: using `HMAT` to fit the model.

        """
        return _experimental.GaussianProcessFitterResult_getLinearAlgebraMethod(self)

    def getRegressionMatrix(self):
        r"""
        Accessor to the regression matrix.

        Returns
        -------
        process : :class:`~openturns.Matrix`
            Returns the regression matrix.

        Notes
        -----
        The regression matrix, e.g the evaluation of the basis functions
        upon the input design sample. It contains :math:`\sampleSize` lines and as many column as
        the size of the functional basis. The column :math:`k` is defined as:

        .. math::

            \left(\varphi_k(\vect{x}_1), \dots,\varphi_k(\vect{x}_\sampleSize) \right).


        """
        return _experimental.GaussianProcessFitterResult_getRegressionMatrix(self)

    def getNoise(self):
        r"""
        Accessor to the Gaussian process.

        Returns
        -------
        process : :class:`~openturns.Process`
            The Gaussian process :math:`\vect{W}` its the optimized parameters.

        """
        return _experimental.GaussianProcessFitterResult_getNoise(self)

    def __init__(self, *args):
        _experimental.GaussianProcessFitterResult_swiginit(self, _experimental.new_GaussianProcessFitterResult(*args))
    __swig_destroy__ = _experimental.delete_GaussianProcessFitterResult

# Register GaussianProcessFitterResult in _experimental:
_experimental.GaussianProcessFitterResult_swigregister(GaussianProcessFitterResult)
class GaussianProcessFitter(openturns.metamodel.MetaModelAlgorithm):
    r"""
    Fit gaussian process models

    Refer to :ref:`gaussian_process_regression`.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.


    Parameters
    ----------
    inputSample, outputSample : :class:`~openturns.Sample` or 2d-array
        The samples :math:`(\vect{x}_k)_{1 \leq k \leq \sampleSize} \in \Rset^\inputDim` and :math:`(\vect{y}_k)_{1 \leq k \leq \sampleSize}\in \Rset^{\outputDim}`.

    covarianceModel : :class:`~openturns.CovarianceModel`
        Covariance model of the Gaussian process. See notes for the details.

    basis : :class:`~openturns.Basis`
        Functional basis to estimate the trend: :math:`(\varphi_j)_{1 \leq j \leq b}: \Rset^\inputDim \rightarrow \Rset`.

        The same basis is used for each marginal output.

        Default value is `Basis(0)`, i.e. no trend to estimate.

    Notes
    -----

    Refer to :ref:`gaussian_process_regression` (Step 1) to get all the notations and the theoretical aspects.
    We only detail here the notions related to the class.

    We suppose we have a sample :math:`(\vect{x}_k, \vect{y}_k)_{1 \leq k \leq \sampleSize}`
    where :math:`\vect{y}_k = \model(\vect{x}_k)` for all :math:`k`, with :math:`\model:\Rset^\inputDim \mapsto
    \Rset^{\outputDim}` a given function.

    The class creates the Gaussian process  :math:`\vect{Y}(\omega, \vect{x})` such that the sample
    :math:`(\vect{y}_k)_{1 \leq k \leq \sampleSize}` is considered as its restriction  on
    :math:`(\vect{x}_k)_{1 \leq k \leq \sampleSize}`. It is defined by:

    .. math::

        \vect{Y}(\omega, \vect{x}) = \vect{\mu}(\vect{x}) + \vect{W}(\omega, \vect{x})

    where :math:`\vect{\mu} = (\mu_1, \dots, \mu_\outputDim)` with :math:`\mu_\ell(\vect{x}) = \sum_{j=1}^{b}
    \beta_j^\ell \varphi_j(\vect{x})` and :math:`\varphi_j: \Rset^\inputDim \rightarrow \Rset` the trend function
    basis for :math:`1 \leq j \leq b` and :math:`1 \leq \ell \leq \outputDim`.

    Furthermore, :math:`\vect{W}` is a Gaussian process of dimension :math:`\outputDim` with zero mean and a specified
    covariance model.

    The *GaussianProcessFitter* class estimates the coefficients :math:`\beta_j^\ell` and :math:`\vect{p}` 
    where :math:`\vect{p}` is the vector of the parameters of the covariance model  that has been declared as
    *active*: see
    :class:`openturns.CovarianceModel` to get details on the activation of the estimation of the other
    parameters.

    The estimation is done by maximizing the *reduced* log-likelihood of the mode, defined in :eq:`logLikelihoodGP`.

    The default optimizer is :class:`~openturns.Cobyla` and can be changed thanks to the
    :meth:`setOptimizationAlgorithm` method.
    User could also change the default optimization solver by setting the entry 
    `GaussianProcessFitter-DefaultOptimizationAlgorithm` of :class:`~openturns.ResourceMap` to one of the :class:`~openturns.NLopt`
    solver names.

    It is also possible to proceed as follows:

    * ask for the reduced log-likelihood function thanks to the :meth:`getReducedLogLikelihoodFunction` method,
    * optimize it with respect to the parameters :math:`\vect{\theta}` and :math:`\vect{\sigma}` using any optimization algorithms
      (that can take into account some additional constraints if needed),
    * set the optimal parameter value into the covariance model used in the *GaussianProcessFitter*,
    * tell the algorithm not to optimize the parameter using the :meth:`setOptimizeParameters` method.

    The behaviour of the reduction is controlled by the following keys in :class:`~openturns.ResourceMap`:

    * *ResourceMap.SetAsBool('GaussianProcessFitter-UseAnalyticalAmplitudeEstimate', True)* to use the reduction associated to
      :math:`\sigma`. It has no effect if :math:`d>1` or if :math:`d=1` and :math:`\sigma` is not part of :math:`\vect{p}`,
    * *ResourceMap.SetAsBool('GaussianProcessFitter-UnbiasedVariance', True)* allows one to use the *unbiased* estimate of
      :math:`\sigma` where :math:`\dfrac{1}{\sampleSize}` is replaced by :math:`\dfrac{1}{\sampleSize-\outputDim}` in the optimality condition for :math:`\sigma`.

    With huge samples, the `hierarchical matrix <http://en.wikipedia.org/wiki/Hierarchical_matrix>`_
    implementation could be used if `hmat-oss` support has been enabled.

    This implementation, which is based on a compressed representation of an approximated covariance matrix
    (and its Cholesky factor), has a better complexity both in terms of memory requirements
    and floating point operations. To use it, the entry `GaussianProcessFitter-LinearAlgebra` of the :class:`openturns.ResourceMap` class should be
    instancied to `HMAT`. Default value of the key is `LAPACK`.

    Examples
    --------
    Create the model :math:`\model: \Rset \mapsto \Rset` and the samples:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> g = ot.SymbolicFunction(['x'], ['x + x * sin(x)'])
    >>> inputSample = ot.Sample([[1.0], [3.0], [5.0], [6.0], [7.0], [8.0]])
    >>> outputSample = g(inputSample)

    Create the algorithm:

    >>> g1 = ot.SymbolicFunction(['x'], ['sin(x)'])
    >>> g2 = ot.SymbolicFunction(['x'], ['x'])
    >>> g3 = ot.SymbolicFunction(['x'], ['cos(x)'])
    >>> basis = ot.Basis([g1, g2, g3])
    >>> covarianceModel = ot.SquaredExponential([1.0])
    >>> covarianceModel.setActiveParameter([])
    >>> algo = otexp.GaussianProcessFitter(inputSample, outputSample, covarianceModel, basis)
    >>> algo.run()

    Get the resulting  metamodel which is the trend function of the Gaussian process:

    >>> result = algo.getResult()
    >>> metamodel = result.getMetaModel()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.GaussianProcessFitter_getClassName(self)

    def __repr__(self):
        return _experimental.GaussianProcessFitter___repr__(self)

    def run(self):
        r"""
        Compute the response surface.

        Notes
        -----
        It computes the response surface and creates a
        :class:`~openturns.experimental.GaussianProcessFitterResult` structure containing all the results.
        """
        return _experimental.GaussianProcessFitter_run(self)

    def getResult(self):
        r"""
        Get the results of the metamodel computation.

        Returns
        -------
        result : :class:`~openturns.experimental.GaussianProcessFitterResult`
            Structure containing all the results obtained after computation
            and created by the method :py:meth:`run`.

        """
        return _experimental.GaussianProcessFitter_getResult(self)

    def getReducedLogLikelihoodFunction(self):
        r"""
        Accessor to the log-likelihood function that writes as argument of the covariance's model parameters.

        Returns
        -------
        logLikelihood : :class:`~openturns.Function`
            The log-likelihood function degined in :eq:`logLikelihoodGP` as a function of the active parameters of the covariance model.

        Notes
        -----
        The log-likelihood function may be useful for some postprocessing: maximization using external optimizers for example.


        Examples
        --------
        Create the model :math:`\model: \Rset \mapsto \Rset` and the samples:

        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> g = ot.SymbolicFunction(['x0'], ['x0 * sin(x0)'])
        >>> inputSample = ot.Sample([[1.0], [3.0], [5.0], [6.0], [7.0], [8.0]])
        >>> outputSample = g(inputSample)

        Create the algorithm:

        >>> basis = ot.ConstantBasisFactory().build()
        >>> covarianceModel = ot.SquaredExponential(1)
        >>> algo = otexp.GaussianProcessFitter(inputSample, outputSample, covarianceModel, basis)
        >>> algo.run()

        Get the log-likelihood function:

        >>> likelihoodFunction = algo.getReducedLogLikelihoodFunction()

        """
        return _experimental.GaussianProcessFitter_getReducedLogLikelihoodFunction(self)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to solver used to optimize the covariance model parameters.

        Returns
        -------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
            Solver used to optimize the covariance model parameters.
            Default optimizer is :class:`~openturns.Cobyla`
        """
        return _experimental.GaussianProcessFitter_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the solver used to optimize the covariance model parameters.

        Parameters
        ----------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
            Solver used to optimize the covariance model parameters.
        """
        return _experimental.GaussianProcessFitter_setOptimizationAlgorithm(self, solver)

    def getOptimizeParameters(self):
        r"""
        Accessor to the covariance model parameters optimization flag.

        Returns
        -------
        optimizeParameters : bool
            Whether to optimize the covariance model parameters.
        """
        return _experimental.GaussianProcessFitter_getOptimizeParameters(self)

    def setOptimizeParameters(self, optimizeParameters):
        r"""
        Accessor to the covariance model parameters optimization flag.

        Parameters
        ----------
        optimizeParameters : bool
            Whether to optimize the covariance model parameters.
        """
        return _experimental.GaussianProcessFitter_setOptimizeParameters(self, optimizeParameters)

    def setOptimizationBounds(self, optimizationBounds):
        r"""
        Optimization bounds accessor.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            Bounds for covariance model parameter optimization.

        Notes
        -----
        Parameters involved by this method are:

         - Scale parameters,
         - Amplitude parameters if output dimension is greater than one or
           analytical sigma disabled,
         - Additional parameters.

        Lower & upper bounds are defined in resource map.
        Default lower upper bounds value for all parameters is
        :math:`10^{-2}` and defined thanks to the
        `GaussianProcessFitter-DefaultOptimizationLowerBound`
        resource map key.

        For scale parameters, default upper bounds are set as :math:`2`
        times the difference between the max and min values of `X` for
        each coordinate, `X` being the (transformed) input sample.
        The value :math:`2` is defined in resource map
        (`GaussianProcessFitter-DefaultOptimizationScaleFactor`).

        Finally for other parameters (amplitude,...), default upper bound is set
        to :math:`100` (corresponding resource map key is
        `GaussianProcessFitter-DefaultOptimizationUpperBound`)

        """
        return _experimental.GaussianProcessFitter_setOptimizationBounds(self, optimizationBounds)

    def getOptimizationBounds(self):
        r"""
        Optimization bounds accessor.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            Bounds for covariance model parameter optimization.
        """
        return _experimental.GaussianProcessFitter_getOptimizationBounds(self)

    def getKeepCholeskyFactor(self):
        r"""
        Keep Cholesky factor accessor.

        Returns
        -------
        keepCholesky : bool
            Tells whether we keep or not the final Cholesky factor.
        """
        return _experimental.GaussianProcessFitter_getKeepCholeskyFactor(self)

    def setKeepCholeskyFactor(self, keepCholeskyFactor):
        r"""
        Keep Cholesky factor setter.

        Parameters
        ----------
        keepCholesky : bool
            Tells whether we keep or not the final Cholesky factor.
        """
        return _experimental.GaussianProcessFitter_setKeepCholeskyFactor(self, keepCholeskyFactor)

    def setMethod(self, method):
        r"""
         Accessor to the linear algebra method.

        Parameters
        ----------
        linAlgMethod : int
            The used linear algebra method to fit the model:

            - otexp.GaussianProcessFitterResult.LAPACK or 0: using `LAPACK` to fit the model,

            - otexp.GaussianProcessFitterResult.HMAT or 1: using `HMAT` to fit the model.
        """
        return _experimental.GaussianProcessFitter_setMethod(self, method)

    def getMethod(self):
        r"""
         Accessor to the linear algebra method.

        Returns
        -------
        linAlgMethod : int
            The used linear algebra method to fit the model:

            - otexp.GaussianProcessFitterResult.LAPACK or 0: using `LAPACK` to fit the model,

            - otexp.GaussianProcessFitterResult.HMAT or 1: using `HMAT` to fit the model.
        """
        return _experimental.GaussianProcessFitter_getMethod(self)

    def __init__(self, *args):
        _experimental.GaussianProcessFitter_swiginit(self, _experimental.new_GaussianProcessFitter(*args))
    __swig_destroy__ = _experimental.delete_GaussianProcessFitter

# Register GaussianProcessFitter in _experimental:
_experimental.GaussianProcessFitter_swigregister(GaussianProcessFitter)
class GaussianProcessRegressionResult(openturns.metamodel.MetaModelResult):
    r"""
    Gaussian process regression (aka kriging) result.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Refer to :ref:`gaussian_process_regression`.

    Parameters
    ----------
    gpfitResult : :class:`~openturns.experimental.GaussianProcessFitterResult`
        Structure result of a gaussian process fitter.
    covarianceCoefficients : 2-d sequence of float
        The :math:`\vect{\gamma}` defined in :eq:`gammaDefinition`.

    Notes
    -----
    The structure is usually created by the method :py:meth:`~openturns.experimental.GaussianProcessRegression.run`, and obtained thanks to the `getResult()` method.

    Refer to the documentation of :class:`~openturns.experimental.GaussianProcessRegression` to get details on
    the notations.

    Examples
    --------
    Create the model :math:`\model: \Rset \mapsto \Rset` and the samples:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> g = ot.SymbolicFunction(['x'],  ['x * sin(x)'])
    >>> sampleX = [[1.0], [2.0], [3.0], [4.0], [5.0], [6.0]]
    >>> sampleY = g(sampleX)

    Create the algorithm:

    >>> basis = ot.Basis([ot.SymbolicFunction(['x'], ['x']), ot.SymbolicFunction(['x'], ['x^2'])])
    >>> covarianceModel = ot.GeneralizedExponential([2.0], 2.0)
    >>> fit_algo = otexp.GaussianProcessFitter(sampleX, sampleY, covarianceModel, basis)
    >>> fit_algo.run()

    Create the interpolating Gaussian process approximation:

    >>> algo = otexp.GaussianProcessRegression(fit_algo.getResult())
    >>> algo.run()

    Get the resulting interpolating metamodel :math:`\metaModel`:

    >>> result = algo.getResult()
    >>> metaModel = result.getMetaModel()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.GaussianProcessRegressionResult_getClassName(self)

    def __repr__(self):
        return _experimental.GaussianProcessRegressionResult___repr__(self)

    def __str__(self, *args):
        return _experimental.GaussianProcessRegressionResult___str__(self, *args)

    def getBasis(self):
        r"""
        Accessor to the collection of basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`
            Functional basis to estimate the trend: :math:`(\varphi_j)_{1 \leq j \leq b}: \Rset^\inputDim
            \rightarrow \Rset`.

        Notes
        -----
        If the trend is not estimated, the basis is empty. The same basis is used for each marginal output.
        """
        return _experimental.GaussianProcessRegressionResult_getBasis(self)

    def getTrendCoefficients(self):
        r"""
        Accessor to the trend coefficients.

        Returns
        -------
        trendCoef : sequence of float
            The trend coefficients vectors :math:`(\vect{\beta}^1, \dots, \vect{\beta}^{\outputDim})` as a
            :class:`~openturns.Point`.

        Notes
        -----
        As the same basis is used for each marginal output, each :math:`\vect{\beta}^\ell` vector is of dimension
        :math:`b`, the size of the functional basis.

        """
        return _experimental.GaussianProcessRegressionResult_getTrendCoefficients(self)

    def getCovarianceModel(self):
        r"""
        Accessor to the covariance model.

        Returns
        -------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model of the Gaussian process :math:`\vect{W}`.

        """
        return _experimental.GaussianProcessRegressionResult_getCovarianceModel(self)

    def getOptimalLogLikelihood(self):
        r"""
        Accessor to the optimal log-likelihood of the model.

        Returns
        -------
        optimalLogLikelihood : float
            The value of the log-likelihood corresponding to the model.

        """
        return _experimental.GaussianProcessRegressionResult_getOptimalLogLikelihood(self)

    def getLinearAlgebraMethod(self):
        r"""
        Accessor to the linear algebra method used to fit.

        Returns
        -------
        linAlgMethod : int
            The used linear algebra method to fit the model:

            - otexp.GaussianProcessFitterResult.LAPACK or 0: using `LAPACK` to fit the model,

            - otexp.GaussianProcessFitterResult.HMAT or 1: using `HMAT` to fit the model.

        """
        return _experimental.GaussianProcessRegressionResult_getLinearAlgebraMethod(self)

    def getRegressionMatrix(self):
        r"""
        Accessor to the regression matrix.

        Returns
        -------
        process : :class:`~openturns.Matrix`
            Returns the regression matrix.

        Notes
        -----
        The regression matrix, e.g the evaluation of the basis function
        upon the input design sample. It contains :math:`\sampleSize \times \outputDim` lines and as many column as
        the size of the functional basis. The column :math:`k` is defined as:

        .. math::

            \left(\varphi_k(\vect{x}_1), \dots,\varphi_k(\vect{x}_\sampleSize) \right).


        """
        return _experimental.GaussianProcessRegressionResult_getRegressionMatrix(self)

    def getNoise(self):
        r"""
        Accessor to the Gaussian process.

        Returns
        -------
        process : :class:`~openturns.Process`
            The Gaussian process :math:`\vect{W}` its the optimized parameters.

        """
        return _experimental.GaussianProcessRegressionResult_getNoise(self)

    def getCovarianceCoefficients(self):
        r"""
        Accessor to the covariance coefficients.

        Returns
        -------
        covCoeff : :class:`~openturns.Sample`
            The :math:`\vect{\gamma}` defined in :eq:`gammaDefinition`.

        """
        return _experimental.GaussianProcessRegressionResult_getCovarianceCoefficients(self)

    def __init__(self, *args):
        _experimental.GaussianProcessRegressionResult_swiginit(self, _experimental.new_GaussianProcessRegressionResult(*args))
    __swig_destroy__ = _experimental.delete_GaussianProcessRegressionResult

# Register GaussianProcessRegressionResult in _experimental:
_experimental.GaussianProcessRegressionResult_swigregister(GaussianProcessRegressionResult)
class GaussianProcessRegression(openturns.metamodel.MetaModelAlgorithm):
    r"""
    Gaussian process regression algorithm.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Available constructors:
        GaussianProcessRegression(*gprFitterResult*)

        GaussianProcessRegression(*inputSample, outputSample, covarianceModel, trendFunction*)

    Parameters
    ----------
    gprFitterResult : :class:`~openturns.experimental.GaussianProcessFitterResult`
        The result class built by :class:`~openturns.experimental.GaussianProcessFitter`.
    inputSample, outputSample : 2-d sequence of float
        The samples :math:`(\vect{x}_k)_{1 \leq k \leq \sampleSize} \in \Rset^{\inputDim}` and :math:`(\vect{y}_k)_{1 \leq k \leq \sampleSize} \in \Rset^{\outputDim}` upon which the meta-model is built.
    covarianceModel : :class:`~openturns.CovarianceModel`
        The covariance model used for the underlying Gaussian process approximation.
    trendFunction : :class:`~openturns.Function`
        The trend function.

    Notes
    -----

    Refer to :ref:`gaussian_process_regression` (step 2) to get all the notations and the theoretical aspects. We only detail here the notions related to the class.

    We suppose we have a sample :math:`(\vect{x}_k, \vect{y}_k)_{1 \leq k \leq \sampleSize}` where :math:`\vect{y}_k = \model(\vect{x}_k)` for all *k*, with :math:`\model:\Rset^{\inputDim} \mapsto \Rset^{\outputDim}` the model.

    The underlying Gaussian process approximation :math:`\vect{Y}` can be fulfilled with two different ways: 

    * Within the first constructor: we suppose that the Gaussian process approximation has already been
      calibrated using the class :class:`~openturns.experimental.GaussianProcessFitter`;
    * Within the second constructor: all the elements defining the Gaussian process approximation are specified
      separately: the data set, the covariance model and the trend function.

    The objective of the *GaussianProcessRegression* is to condition the Gaussian process approximation :math:`\vect{Y}` to the data set: thus, we make the Gaussian process approximation become interpolating over the dataset.

    In all cases, no estimation of the underlying Gaussian process approximation :math:`\vect{Y}` is performed. Refer to :class:`~openturns.experimental.GaussianProcessFitter` to get more details on the notation. The Gaussian process :math:`\vect{Y}` is defined by:

    .. math::

        \vect{Y}(\omega, \vect{x}) = \vect{\mu}(\vect{x}) + \vect{W}(\omega, \vect{x})

    where :math:`\vect{\mu} : \Rset^\inputDim \rightarrow \Rset^outputDim` is the trend function and :math:`\vect{W}` is a Gaussian process of dimension :math:`\outputDim` with zero mean and a specified covariance function.

    The Gaussian Process Regression denoted by :math:`\vect{Z}` is the Gaussian process :math:`\vect{Y}` conditioned to the data
    set:

    .. math::

        \vect{Z}(\omega, \vect{x}) = \vect{Y}(\omega, \vect{x})\, | \,  \cC

    where :math:`\cC` is the condition :math:`\vect{Y}(\omega, \vect{x}_k) = \vect{y}_k` for
    :math:`1 \leq k \leq \sampleSize`.

    Then, :math:`\vect{Z}` is a Gaussian process, which mean and covariance function are defined in :eq:`expectationGPR` and
    :eq:`covarianceGPR_point`.

    The Gaussian Process Regression metamodel :math:`\metaModel` is defined by the mean of :math:`\vect{Z}`. Its expression is
    detailed in :eq:`GPRmetamodel`.

    In order to get services related to the conditional covariance, use the class :class:`~openturns.experimental.GaussianProcessConditionalCovariance`.

    Examples
    --------
    Create the model :math:`\model: \Rset \mapsto \Rset` and the samples:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> g = ot.SymbolicFunction(['x'],  ['x * sin(x)'])
    >>> sampleX = [[1.0], [2.0], [3.0], [4.0], [5.0], [6.0], [7.0], [8.0]]
    >>> sampleY = g(sampleX)

    Create the algorithm:

    >>> basis = ot.Basis([ot.SymbolicFunction(['x'], ['x']), ot.SymbolicFunction(['x'], ['x^2'])])
    >>> covarianceModel = ot.SquaredExponential([1.0])
    >>> covarianceModel.setActiveParameter([])
    >>> fit_algo = otexp.GaussianProcessFitter(sampleX, sampleY, covarianceModel, basis)
    >>> fit_algo.run()

    Get the resulting interpolating metamodel :math:`\metaModel`:

    >>> fit_result = fit_algo.getResult()
    >>> algo = otexp.GaussianProcessRegression(fit_result)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> metamodel = result.getMetaModel()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.GaussianProcessRegression_getClassName(self)

    def __repr__(self):
        return _experimental.GaussianProcessRegression___repr__(self)

    def run(self):
        r"""
        Compute the response surface.

        Notes
        -----
        It computes the Gaussian Process interpolating approximation and creates a
        :class:`~openturns.experimental.GaussianProcessRegressionResult` structure containing all the results.
        """
        return _experimental.GaussianProcessRegression_run(self)

    def getResult(self):
        r"""
        Get the results of the metamodel computation.

        Returns
        -------
        result : :class:`~openturns.experimental.GaussianProcessRegressionResult`
            Structure containing all the results obtained, created by the method :py:meth:`run`.

        """
        return _experimental.GaussianProcessRegression_getResult(self)

    def __init__(self, *args):
        _experimental.GaussianProcessRegression_swiginit(self, _experimental.new_GaussianProcessRegression(*args))
    __swig_destroy__ = _experimental.delete_GaussianProcessRegression

# Register GaussianProcessRegression in _experimental:
_experimental.GaussianProcessRegression_swigregister(GaussianProcessRegression)
class GaussianProcessConditionalCovariance(openturns.common.PersistentObject):
    r"""
    Conditional covariance post processing of a Gaussian Process Regression result.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.


    Parameters
    ----------
    gprResult :  :class:`~openturns.experimental.GaussianProcessRegressionResult`
        The result class built by :class:`~openturns.experimental.GaussianProcessRegression`.


    Notes
    -----


    Refer to :ref:`gaussian_process_regression` (step 3) to get all the notations and the theoretical aspects. We only detail here the notions related to the class.


    We suppose we have a sample :math:`(\vect{x}_k, \vect{y}_k)_{1 \leq k \leq \sampleSize}` where :math:`\vect{y}_k = \model(\vect{x}_k)` for all *k*, with :math:`\model:\Rset^{\inputDim} \mapsto \Rset^{\outputDim}` the model. The  Gaussian process approximation :math:`\vect{Y}` is defined by:

    .. math::

        \vect{Y}(\omega, \vect{x}) = \vect{\mu}(\vect{x}) + \vect{W}(\omega, \vect{x})

    where :math:`\vect{\mu} : \Rset^\inputDim \rightarrow \Rset^outputDim` is the trend function and :math:`\vect{W}` is a Gaussian process of dimension :math:`\outputDim` with zero mean and a specified covariance function. The Gaussian process regression denoted by :math:`\vect{Z}` is defined by:

    .. math::

        \vect{Z}(\omega, \vect{x}) = \vect{Y}(\omega, \vect{x})\, | \,  \cC

    where :math:`\cC` is the condition :math:`\vect{Y}(\omega, \vect{x}_k) = \vect{y}_k` for
    :math:`1 \leq k \leq \sampleSize`.

    The class provides services related to the conditional covariance of the Gaussian process regression :math:`\vect{Z}`.

    Examples
    --------
    Create the model :math:`g: \Rset \mapsto \Rset` and the samples:

    >>> import openturns as ot
    >>> from openturns.experimental import GaussianProcessRegression
    >>> from openturns.experimental import GaussianProcessConditionalCovariance
    >>> trend = ot.SymbolicFunction(['x'],  ['1'])
    >>> sampleX = [[1.0], [2.0], [3.0], [4.0], [5.0], [6.0]]
    >>> sampleY = trend(sampleX)

    Create the algorithm:

    >>> covarianceModel = ot.SquaredExponential([1.0])
    >>> covarianceModel.setActiveParameter([])

    >>> algo = GaussianProcessRegression(sampleX, sampleY, covarianceModel, trend)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> condCov = GaussianProcessConditionalCovariance(result)
    >>> c = condCov([1.1])


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.GaussianProcessConditionalCovariance_getClassName(self)

    def __repr__(self):
        return _experimental.GaussianProcessConditionalCovariance___repr__(self)

    def __str__(self, *args):
        return _experimental.GaussianProcessConditionalCovariance___str__(self, *args)

    def getConditionalMean(self, *args):
        r"""
        Compute the conditional mean of the Gaussian process on a point or a sample of points.

        Parameters
        ----------
        x : sequence of float
            The point :math:`\vect{x}` where the conditional mean of the output has to be evaluated.
        sampleX : 2-d sequence of float
             The sample :math:`(\vect{\xi}_1, \dots, \vect{\xi}_N)` where the conditional mean of the output has to be evaluated (*N* can be equal to 1).

        Returns
        -------
        condMean : :class:`~openturns.Point`
            The conditional mean the Gaussian process regression :math:`\vect{Z}` defined in :eq:`GPRdef` at point :math:`\vect{x}` or on the sample :math:`(\vect{\xi}_1, \dots, \vect{\xi}_N)`:

            .. math::

                \left(
                  \begin{array}{l}
                    \Expect{\vect{Z}(\omega, \vect{\xi}_1)}\\
                    \dots  \\
                    \Expect{\vect{Z}(\omega, \vect{\xi}_N)}
                  \end{array}
                \right)

            This vector is in :math:`\Rset^{N \times \outputDim}`.

        """
        return _experimental.GaussianProcessConditionalCovariance_getConditionalMean(self, *args)

    def getConditionalCovariance(self, *args):
        r"""
        Compute the conditional covariance of the Gaussian process on a point (or several points).

        Parameters
        ----------
        x : sequence of float
            The point :math:`\vect{x}` where the conditional covariance of the output has to be evaluated.
        sampleX : 2-d sequence of float
             The sample :math:`(\vect{\xi}_1, \dots, \vect{\xi}_N)` where the conditional covariance of the output has to be evaluated (*N* can be equal to 1).

        Returns
        -------
        condCov : :class:`~openturns.CovarianceMatrix`
            The conditional covariance of the Gaussian process regression  :math:`\vect{Z}` defined in :eq:`GPRdef` at point :math:`\vect{x}` is defined in :eq:`covarianceGPR_point`. When computed on the sample :math:`(\vect{\xi}_1, \dots, \vect{\xi}_N)`, the covariance matrix is defined in :eq:`covarianceGPR_sample`.
        """
        return _experimental.GaussianProcessConditionalCovariance_getConditionalCovariance(self, *args)

    def getDiagonalCovarianceCollection(self, xi):
        r"""
        Compute the conditional covariance of the Gaussian process on a sample.

        Parameters
        ----------
        sampleX : 2-d sequence of float
             The sample :math:`(\vect{\xi}_1, \dots, \vect{\xi}_N)` where the conditional marginal covariance of the output has to be evaluated (*N* can be equal to 1).

        Returns
        -------
        condCov : :class:`~openturns.CovarianceMatrixCollection`
            The collection of conditional covariance matrices :math:`\Cov{\vect{Z}(\omega, \vect{\xi}_i)}
            = \mat{\Sigma_{ii}}` for :math:`1 \leq i \leq N` defined in :eq:`covarianceGPR_sample`.

        Notes
        -----
        Each element of the collection corresponds to the conditional covariance with respect to the input learning set
        (e.g. a pointwise evaluation of the `getDiagonalCovariance`). The returned collection is
        of size :math:`N` and contains matrices in :math:`\cM_{\outputDim, \outputDim}(\Rset)`.
        """
        return _experimental.GaussianProcessConditionalCovariance_getDiagonalCovarianceCollection(self, xi)

    def getDiagonalCovariance(self, xi):
        r"""
        Compute the diagonal conditional covariance of the Gaussian process on a point.

        Parameters
        ----------
        x : sequence of float
            The point :math:`\vect{x}` where the conditional marginal covariance of the output has to be evaluated.

        Returns
        -------
        condCov : :class:`~openturns.CovarianceMatrix`
            The conditional covariance :math:`\Cov{\vect{Y}(\omega, \vect{x})\, | \,  \cC}` at point :math:`\vect{x}`.
        """
        return _experimental.GaussianProcessConditionalCovariance_getDiagonalCovariance(self, xi)

    def getConditionalMarginalVariance(self, *args):
        r"""
        Compute the conditional variance of the Gaussian process on a point (or several points).

        Parameters
        ----------
        x : sequence of float
            The point :math:`\vect{x}` where the conditional variance of the output has to be evaluated.
        sampleX : 2-d sequence of float
             The sample :math:`(\vect{\xi}_1, \dots, \vect{\xi}_N)` where the conditional variance of the output has to be evaluated (*N* can be equal to 1).
        marginalIndex : int
            Marginal of interest (for multiple outputs).

            Default value is 0 (first component).
        marginalIndices : sequence of int
            Marginals of interest (for multiple outputs).

        Returns
        -------
        var : float
              The variance of the specified marginal of the Gaussian process regression  :math:`\vect{Z}`
              defined in :eq:`GPRdef` at the specified point.

        varPoint : sequence of float
            The marginal variances of each marginal of interest computed at each given point.


        Notes
        -----
        If only one  marginal :math:`k`  of interest  and one point  :math:`\vect{x}` have been specified,
        the method returns :math:`\Var{Z_k(\omega, \vect{x})}` where :math:`\vect{Z}` is the Gaussian
        process regression  defined in :eq:`GPRdef`.

        If several marginal of interest :math:`(k_1, \dots, k_M)` or several points :math:`(\vect{\xi}_1,
        \dots, \vect{\xi}_N)` have been specified, the method returns the concatenation of
        sequence of variances :math:`(\Var{Z_{k_1}(\omega, \vect{\xi}_j)}, \dots, \Var{Z_{k_M}(\omega, \vect{\xi}_j)})` for each :math:`1 \leq j \leq N`.
        """
        return _experimental.GaussianProcessConditionalCovariance_getConditionalMarginalVariance(self, *args)

    def __call__(self, *args):
        r"""
        Compute the conditional Gaussian distribution on a new point / sample conditionally to the observed paths.

        Parameters
        ----------
        pt : sequence of float
            The point :math:`\vect{x}` where the conditional distribution of the output has to be evaluated.
        sampleX : 2-d sequence of float
             The sample :math:`(\vect{\xi}_1, \dots, \vect{\xi}_N)` where the conditional distribution of the output has to be evaluated (*N* can be equal to 1).

        Returns
        -------
        condDist : :class:`~openturns.Normal`
            The conditional Gaussian distribution.

        Notes
        -----
        The conditional distribution of the Gaussian
        process regression :math:`\vect{Z}` defined in :eq:`GPRdef` and computed at :math:`\vect{x}` or at :math:`(\vect{\xi}_1, \dots, \vect{\xi}_N)`.
        In the first case, the method returns a Gaussian distribution of dimension :math:`\outputDim`,
        while in the second case, the method returns a Gaussian distribution of dimension
        :math:`N \times \outputDim`. The mean and the coarance matrix of the resulting distribution are
        computed by :meth:`getConditionalMean` and :meth:`getConditionalCovariance`.
        """
        return _experimental.GaussianProcessConditionalCovariance___call__(self, *args)

    def __init__(self, *args):
        _experimental.GaussianProcessConditionalCovariance_swiginit(self, _experimental.new_GaussianProcessConditionalCovariance(*args))
    __swig_destroy__ = _experimental.delete_GaussianProcessConditionalCovariance

# Register GaussianProcessConditionalCovariance in _experimental:
_experimental.GaussianProcessConditionalCovariance_swigregister(GaussianProcessConditionalCovariance)
class EfficientGlobalOptimization(openturns.optim.OptimizationAlgorithmImplementation):
    r"""
    Efficient Global Optimization algorithm.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    The EGO algorithm [jones1998]_ is an adaptative optimization method based on Gaussian process regression.
    An initial design of experiment is used to build a first metamodel.
    At each iteration a new point that maximizes a criterion is chosen as optimizer candidate.
    The criterion uses a tradeoff between the metamodel value and the conditional variance.
    Then the new point is evaluated using the original model and the metamodel is
    relearnt on the extended design of experiment.

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        The optimization problem to solve
    gprResult : :class:`~openturns.experimental.GaussianProcessRegressionResult`
        The result of the metamodel on the first design of experiment

    Notes
    -----
    Each point added to the metamodel design seeks to improve the current minimum.
    We chose the point so as to maximize an improvement criterion based on the
    metamodel.

    .. math::

        I(x_{new}) = max(f_{min} - Y_{new}, 0)

    The default criteria is called EI (Expected Improvement) and aims at maximizing
    the mean improvement:

    .. math::

        EI(x_{new}) = \mathbb{E}\left[I(x_{new})\right] = \mathbb{E}\left[max(f_{min} - Y_{new}, 0)\right]

    This criterion is explicited using the Gaussian process mean and variance:

    .. math::

        \mathbb{E}\left[I(x_{new})\right] = (f_{min} - m_K(x_{new})) \Phi\left( \frac{f_{min} - m_K(x_{new})}{s_K(x_{new})} \right) + s_K(x_{new}) \phi\left( \frac{f_{min} - m_K(x_{new})}{s_K(x_{new})} \right)

    In case the covariance model of the Gaussian process model has a non-zero nugget factor :math:`\sigma_{\epsilon}`
    (i.e. the emulated function is noisy) the AEI (Augmented Expected Improvement) formulation is used.
    Because we do not have access to the real minimum of the function in this case, a quantile
    of the Gaussian process conditional mean is used, with the constant :math:`c`:

    .. math:: u(x) = m_K(x) + c s_K(x)

    This criterion is minimized over the design points:

    .. math:: x_{min} = \argmax_{x_i} (u(x_i))

    The AEI criterion is:

    .. math::

        AEI(x_{new}) = \mathbb{E}\left[max(m_K(x_{min}) - Y_{new}, 0)\right] \times \left(1 - \frac{\sigma_{\epsilon}(x_{new})}{\sqrt{\sigma_{\epsilon}^2(x_{new})+s^2_K(x_{new})}} \right)

    with

    .. math::

        \mathbb{E}\left[max(m_K(x_{min}) - Y_{new}, 0)\right] = (m_K(x_{min}) - m_K(x_{new})) \Phi\left( \frac{m_K(x_{min}) - m_K(x_{new})}{s_K(x_{new})} \right) + s_K(x_{new}) \phi\left( \frac{m_K(x_{min}) - m_K(x_{new})}{s_K(x_{new})} \right)

    By default the criteria is minimized using :class:`~openturns.MultiStart`
    with starting points uniformly sampled in the optimization problem bounds,
    see :func:`setMultiStartExperimentSize` and :func:`setMultiStartNumber`.
    This behavior can be overridden by using another solver with :func:`setOptimizationAlgorithm`.

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> ot.RandomGenerator.SetSeed(0)
    >>> dim = 4
    >>> model = ot.SymbolicFunction(['x1', 'x2', 'x3', 'x4'], ['x1*x1+x2^3*x1+x3+x4'])
    >>> model = ot.MemoizeFunction(model)
    >>> bounds = ot.Interval([-5.0] * dim, [5.0] * dim)
    >>> problem = ot.OptimizationProblem()
    >>> problem.setObjective(model)
    >>> problem.setBounds(bounds)
    >>> inputSample = ot.JointDistribution([ot.Uniform(-5.0, 5.0)] * dim).getSample(30)
    >>> outputSample = model(inputSample)
    >>> yMin0 = outputSample.getMin()
    >>> covarianceModel = ot.SquaredExponential([2.0] * dim, [0.1])
    >>> basis = ot.ConstantBasisFactory(dim).build()
    >>> fitter = otexp.GaussianProcessFitter(inputSample, outputSample, covarianceModel, basis)
    >>> fitter.run()
    >>> gpr = otexp.GaussianProcessRegression(fitter.getResult())
    >>> gpr.run()
    >>> algo = otexp.EfficientGlobalOptimization(problem, gpr.getResult())
    >>> algo.setMaximumCallsNumber(2)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> updatedGPRResult = algo.getGaussianProcessRegressionResult()
    >>> updatedOutputSample = updatedGPRResult.getOutputSample()
    >>> yMin = updatedOutputSample.getMin()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.EfficientGlobalOptimization_getClassName(self)

    def __repr__(self):
        return _experimental.EfficientGlobalOptimization___repr__(self)

    def run(self):
        r"""Launch the optimization."""
        return _experimental.EfficientGlobalOptimization_run(self)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Expected improvement solver accessor.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used to optimize the expected improvement
        """
        return _experimental.EfficientGlobalOptimization_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Expected improvement solver accessor.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used to optimize the expected improvement
        """
        return _experimental.EfficientGlobalOptimization_getOptimizationAlgorithm(self)

    def getMultiStartExperimentSize(self):
        r"""
        Size of the design to draw starting points.

        Returns
        -------
        multiStartExperimentSize : int
            The size of the Monte Carlo design from which to select the best starting
            points.
        """
        return _experimental.EfficientGlobalOptimization_getMultiStartExperimentSize(self)

    def setMultiStartExperimentSize(self, multiStartExperimentSize):
        r"""
        Size of the design to draw starting points.

        Parameters
        ----------
        multiStartExperimentSize : int
            The size of the Monte Carlo design from which to select the best starting
            points.
            The default number can be tweaked with the
            `EfficientGlobalOptimization-DefaultMultiStartExperimentSize` key from
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.EfficientGlobalOptimization_setMultiStartExperimentSize(self, multiStartExperimentSize)

    def getMultiStartNumber(self):
        r"""
        Number of starting points for the criterion optimization.

        Returns
        -------
        multiStartNumber : int
            The number of starting points for the criterion optimization.
        """
        return _experimental.EfficientGlobalOptimization_getMultiStartNumber(self)

    def setMultiStartNumber(self, multiStartNumberSize):
        r"""
        Number of starting points for the criterion optimization.

        Parameters
        ----------
        multiStartNumber : int
            The number of starting points for the criterion optimization.
            The default number can be tweaked with the
            `EfficientGlobalOptimization-DefaultMultiStartNumber` key from
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.EfficientGlobalOptimization_setMultiStartNumber(self, multiStartNumberSize)

    def getParameterEstimationPeriod(self):
        r"""
        Parameter estimation period accessor.

        Returns
        -------
        period : int
            The number of iterations between covariance parameters re-learn.
            Default is 1 (each iteration). Can be set to 0 (never).
        """
        return _experimental.EfficientGlobalOptimization_getParameterEstimationPeriod(self)

    def setParameterEstimationPeriod(self, parameterEstimationPeriod):
        r"""
        Parameter estimation period accessor.

        Parameters
        ----------
        period : int
            The number of iterations between covariance parameters re-learn.
            Default is 1 (each iteration). Can be set to 0 (never).
            The default number can be tweaked with the
            `EfficientGlobalOptimization-DefaultParameterEstimationPeriod` key from
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.EfficientGlobalOptimization_setParameterEstimationPeriod(self, parameterEstimationPeriod)

    def setCorrelationLengthFactor(self, b):
        r"""
        Correlation length stopping criterion factor accessor.

        When a correlation length becomes smaller than the minimal distance between
        design point for a single component that means the model tends to be noisy,
        and the EGO formulation is not adapted anymore.

        Parameters
        ----------
        b : float
            Used to define a stopping criterion on the minimum correlation length:
            :math:`\theta_i < \frac{\Delta_i^{min}}{b}`
            with :math:`\Delta^{min}` the minimum distance between design points.
        """
        return _experimental.EfficientGlobalOptimization_setCorrelationLengthFactor(self, b)

    def getCorrelationLengthFactor(self):
        r"""
        Correlation length stopping criterion factor accessor.

        When a correlation length becomes smaller than the minimal distance between
        design point for a single component that means the model tends to be noisy,
        and the EGO formulation is not adapted anymore.

        Returns
        -------
        b : float
            Used to define a stopping criterion on the minimum correlation length:
            :math:`\theta_i < \frac{\Delta_i^{min}}{b}`
            with :math:`\Delta^{min}` the minimum distance between design points.
        """
        return _experimental.EfficientGlobalOptimization_getCorrelationLengthFactor(self)

    def setAEITradeoff(self, c):
        r"""
        AEI tradeoff constant accessor.

        Parameters
        ----------
        c : float
            Used to define a quantile of the Gaussian process prediction at the design points.
            :math:`u(x)=m_K(x)+c*s_K(x)`
        """
        return _experimental.EfficientGlobalOptimization_setAEITradeoff(self, c)

    def getAEITradeoff(self):
        r"""
        AEI tradeoff constant accessor.

        Returns
        -------
        c : float
            Used to define a quantile of the Gaussian process prediction at the design points.
            :math:`u(x)=m_K(x)+c*s_K(x)`
        """
        return _experimental.EfficientGlobalOptimization_getAEITradeoff(self)

    def getExpectedImprovement(self):
        r"""
        Expected improvement values.

        Returns
        -------
        ei : :class:`~openturns.Sample`
            The expected improvement optimal values.
        """
        return _experimental.EfficientGlobalOptimization_getExpectedImprovement(self)

    def getGaussianProcessRegressionResult(self):
        r"""
        Retrieve the GPR result.

        Notes
        -----
        Before :meth:`run` is called, this method returns the result passed to the constructor.
        Once :meth:`run` has been called, it returns an updated result that takes new observations into account.

        Returns
        -------
        gprResult : :class:`~openturns.experimental.GaussianProcessRegressionResult`
            Result that takes all observations into account.
        """
        return _experimental.EfficientGlobalOptimization_getGaussianProcessRegressionResult(self)

    def getKrigingResult(self):
        return _experimental.EfficientGlobalOptimization_getKrigingResult(self)

    def __init__(self, *args):
        _experimental.EfficientGlobalOptimization_swiginit(self, _experimental.new_EfficientGlobalOptimization(*args))
    __swig_destroy__ = _experimental.delete_EfficientGlobalOptimization

# Register EfficientGlobalOptimization in _experimental:
_experimental.EfficientGlobalOptimization_swigregister(EfficientGlobalOptimization)
class _MultiStartCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _experimental.delete__MultiStartCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _experimental._MultiStartCollection_clear(self)

    def __len__(self):
        return _experimental._MultiStartCollection___len__(self)

    def __eq__(self, rhs):
        return _experimental._MultiStartCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _experimental._MultiStartCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _experimental._MultiStartCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _experimental._MultiStartCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _experimental._MultiStartCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _experimental._MultiStartCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _experimental._MultiStartCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _experimental._MultiStartCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _experimental._MultiStartCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _experimental._MultiStartCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _experimental._MultiStartCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _experimental._MultiStartCollection_find(self, val)

    def __repr__(self):
        return _experimental._MultiStartCollection___repr__(self)

    def __str__(self, *args):
        return _experimental._MultiStartCollection___str__(self, *args)

    def __init__(self, *args):
        _experimental._MultiStartCollection_swiginit(self, _experimental.new__MultiStartCollection(*args))

# Register _MultiStartCollection in _experimental:
_experimental._MultiStartCollection_swigregister(_MultiStartCollection)
class RatioOfUniforms(openturns.randomvector.RandomVectorImplementation):
    r"""
    Ratio of Uniforms simulation algorithm.


    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Available constructors:
        RatioOfUniforms(*dist*)

        RatioOfUniforms(*logUnscaledF, rangeF, isScaled*)

    Parameters
    ----------
    dist : :class:`~openturns.Distribution`
        Distribution to sample.

        With that constructor, the range is the distribution range and *isScaled* = True.

    logUnscaledPDF : :class:`~openturns.Function`
       Function :math:`\log F` such that :math:`f = F\, 1_{I}`  is proportional to the PDF :math:`p` we want to sample.

    rangeF : :class:`~openturns.Interval`
        Interval :math:`I \subset \Rset^\inputDim` outside which :math:`p=0`.

    isScaled : bool, optional
        Flag telling if the input *logUnscaledPDF* is such that :math:`f = F\, 1_{I}` is an actual PDF of a distribution.

        Default value is False.

    Notes
    -----
    This algorithm samples a multivariate distribution whose probability density probability is known up to a multiplicative factor, see [stadlober1990]_ for the unidimensional case and [gobet2016]_ for the multivariate case.

    Let :math:`p` be a probability density function of dimension :math:`\inputDim` and
    :math:`f: \Rset^\inputDim \rightarrow \Rset^+` a function such that:

    .. math::

        p(\vect{x}) = cf(\vect{x})\quad  \forall \vect{x} \in \Rset^\inputDim

    with :math:`c \in \Rset^+_*`. We can write :math:`f` as:

    .. math::

        f(\vect{x}) = F(\vect{x})\, 1_{I}\quad \forall \vect{x}  \in I

    with :math:`I \subset \Rset^\inputDim`. It implies that the numerical range of :math:`p` is inluced in :math:`I`. We note:

    .. math::

       I = \prod_{i=1}^\inputDim \left[a_i, b_i \right]

    If the function :math:`f` is an actual PDF and :math:`I` its numerical range, then :math:`c=1`.
    In the general case, :math:`c` is unknown and assumed to be difficult to compute.

    Let :math:`r \in \Rset^+_*`. By default, :math:`r=1`. Let :math:`A_{f,r}` be the domain defined by:

    .. math::

        A_{f,r} & = \left\{ (u, v_1, \dots, v_\inputDim) \in \Rset^{\inputDim+1}\, |\, 0 \leq u \leq f\left(\dfrac{v_1}{u^r},
        \dots, \dfrac{v_\inputDim}{u^r}\right)^{\frac{1}{1+r\inputDim}}\right \}

    The Lebesgue measure of :math:`A_{f,r}`  is equal to :math:`\dfrac{1}{c(1+rd)}`.

    Let :math:`(U, V_1, \dots, V_\inputDim)` be a random variable uniformly distributed on  :math:`A_{f,r}`.
    Then, :math:`\left( \dfrac{V_1}{U^r}, \dots, \dfrac{V_\inputDim}{U^r}\right)` is a random vector
    distributed according to :math:`p`.

    Under the condition that the functions :math:`\vect{x} \rightarrow f(\vect{x})^{\frac{1}{1+r\inputDim}}` and
    :math:`\vect{x} \rightarrow x_if(\vect{x})^{\frac{1}{1+r\inputDim}}` for all :math:`i` are bounded, then the domain
    :math:`A_{f,r}` is bounded and can be included in a rectangular bounding box :math:`\tilde{A}_{f,r}`
    defined by:

    .. math::
        :label: tildeArf_def

        \tilde{A}_{f,r} & = \left[0, \sup_{\vect{x}} f(\vect{x})^{\frac{1}{1+r\inputDim}} \right] \times \prod_i
        \left[ \inf_{\vect{x}} x_i f(\vect{x})^{\frac{r}{1+r\inputDim}} ,  \sup_{\vect{x}} x_i f(\vect{x})^{\frac{r}
        {1+r\inputDim}}\right]\\
                        & = [0, u_{sup}] \times \prod_{i=1}^d [v_{inf, i}, v_{sup, i}]


    This allows one to sample uniformly the set :math:`A_{f,r}` by rejection sampling inside
    :math:`\tilde{A}_{f,r}`.

    **How to calculate the rectangular bounding box** :math:`\tilde{A}_{f,r}` **?**

    The upper bound :math:`u_{sup}` is calculated by maximizing the log of the function rather than the function:

    .. math::

        \sup_{\vect{x}} \log f(\vect{x})

    To compute the second part of :math:`\tilde{A}_{f,r}`, we note that:

    - If the upper bound :math:`b_i \leq 0`, then:

      .. math::

          v_{sup, i} = \sup_{\vect{x}} x_i f(\vect{x})^{\frac{r}{1+rd}} =\sup_{\vect{x}, x_i \leq 0} x_i
          f(\vect{x})^{\frac{r}{1+r\inputDim}} = 0

      Otherwise, we solve the maximization problem for :math:`x_i \in \Rset^+`:

      .. math::

          v_{inf, i} = \sup_{\vect{x}} x_i f(\vect{x})^{\frac{r}{1+r\inputDim}} =\sup_{\vect{x}, x_i \geq 0} x_i
          f(\vect{x})^{\frac{r}{1+r\inputDim}}

      which is equivalent to the problem:

      .. math::

          \sup_{\vect{x}, x_i \geq 0} \log x_i  + \dfrac{r}{1+r\inputDim} \log f(\vect{x})

    - If the lower bound :math:`a_i \geq 0`, then:

      .. math::

          \inf_{\vect{x}} x_i f(\vect{x})^{\frac{r}{1+rd}} = \inf_{\vect{x}, x_i \geq 0} x_i
          f(\vect{x})^{\frac{r}{1+r\inputDim}} = 0

      Otherwise, we solve the minimization problem for :math:`x_i \in \Rset^-` and note that:

      .. math::

        \inf_{\vect{x} } x_i f(\vect{x})^{\frac{r}{1+r\inputDim}} = \inf_{\vect{x},  x_i \leq 0 } x_i
        f(\vect{x})^{\frac{r}{1+r\inputDim}} = - \sup_{\vect{x},  x_i \leq 0 } |x_i| f(\vect{x})^{\frac{r
        }{1+r\inputDim}}

      which is equivalent to the problem:

      .. math::

         \sup_{\vect{x}, x_i \leq 0} \log |x_i|  + \dfrac{r}{1+r\inputDim} \log f(\vect{x})

    For the effective solution of these optimization problems, the initial point :math:`\vect{x}_0` must be
    such that :math:`f(\vect{x}_0)>0`. Such points are found by scrolling through a Sobol multivariate
    low discrepancy sequence: the maximum number of points of the sequence
    to generate is fixed by the entry *RatioOfUniforms-CandidateNumber* of :class:`~openturns.ResourceMap`. The maximum number of
    points selected as starting points is controlled by the entry *RatioOfUniforms-MaximumMultiStart*.
    All the optimization problems are solved using a :class:`~openturns.MultiStart`
    algorithm based on these selected starting points. When no point has been selected, an exception is sent.

    The acceptance ratio of the rejection algorithm is defined by:

    .. math::
       :label: acceptRatio

       \tau_{accept} =  \frac{|A_{f,r}|}{|\tilde{A}_{f,r}|} = \dfrac{1}{c(1+r\inputDim)} \dfrac{1}{u_{sup}
       \prod_{i=1}^d \left(v_{sup, i} - v_{inf, i} \right)}

    It is computed by the *initialize* method: if :math:`c=1`, the rate is computed by :eq:`acceptRatio`.
    If not, it is estimated as :eq:`acceptRatioEstimate`.

    This class uses the following entries of :class:`~openturns.ResourceMap`:

    - *RatioOfUniforms-OptimizationAlgorithm*: the optimization algorithm used to compute the bounding box of
      :math:`\tilde{A}_{f,r}`,
    - *RatioOfUniforms-CandidateNumber*: maximum number of points of the Sobol low discrepancy sequence of dimension
      :math:`\inputDim` used to find admissible starting points,
    - *RatioOfUniforms-MaximumMultiStart*: maximum number of points selected as starting points
      for the multistart optimization algorithm,
    - *RatioOfUniforms-NormalizationSampleSize*: size of the sample used to estimate the acceptance ratio.


    Examples
    --------
    Create a ratio of uniforms algorithm and get the multistart optimization problems used to
    compute the bounds of :math:`\tilde{A}_{f,r}`:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> from math import pi
    >>> f = ot.SymbolicFunction('x', '(1.5+sin(x))*exp(x)')
    >>> log_UnscaledPDF = ot.ComposedFunction(ot.SymbolicFunction('x', 'log(x)'), f)
    >>> range_PDF = ot.Interval(0.0, 2.0 * pi)
    >>> ratioOfU = otexp.RatioOfUniforms(log_UnscaledPDF, range_PDF, False)
    >>> collMultiStart = ratioOfU.initialize()
    >>> x = ratioOfU.getRealization()
    >>> sample = ratioOfU.getSample(10)
    >>> ratioOfU = otexp.RatioOfUniforms(ot.Student(8.5, 3))
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.RatioOfUniforms_getClassName(self)

    def __repr__(self):
        return _experimental.RatioOfUniforms___repr__(self)

    def __str__(self, *args):
        return _experimental.RatioOfUniforms___str__(self, *args)

    def setLogUnscaledPDFAndRange(self, logUnscaledPDF, range, isScaled):
        r"""
        Accessor to the function :math:`\log F` and the range :math:`I`.

        Parameters
        ----------
        logUnscaledPDF : :class:`~openturns.Function`
          Function :math:`\log F` where :math:`F\, 1_{I} \propto p`, the PDF we want to sample.

        rangeF : :class:`~openturns.Interval`
            Interval :math:`I \in \Rset^\inputDim` outside which :math:`p=0`.
        """
        return _experimental.RatioOfUniforms_setLogUnscaledPDFAndRange(self, logUnscaledPDF, range, isScaled)

    def getLogUnscaledPDF(self):
        r"""
        Accessor to the function :math:`\log F`.

        Returns
        -------
        logUnscaledPDF : :class:`~openturns.Function`,
           Function :math:`\log F` such that :math:`f = F\, 1_{I}`  is proportional to the PDF :math:`p` we want to sample.
        """
        return _experimental.RatioOfUniforms_getLogUnscaledPDF(self)

    def getRange(self):
        r"""
        Accessor to the interval :math:`I` where the function :math:`f\propto p`.

        Returns
        -------
        rangeF : :class:`~openturns.Interval`
            Interval :math:`I \subset \Rset^\inputDim` where the function :math:`f\propto p`.

        Notes
        -----
        As :math:`p \propto f = F\, 1_I`, then :math:`p = 0` outside :math:`I`.
        """
        return _experimental.RatioOfUniforms_getRange(self)

    def getSupU(self):
        r"""
        Accessor to the :math:`U`-upper bound of :math:`\tilde{A}_{f,r}`.

        Returns
        -------
        supU : float, positive
            The :math:`U`-upper bound of :math:`\tilde{A}_{f,r}` defined in :eq:`tildeArf_def`.

        Notes
        -----
        The :math:`U`-upper bound of :math:`\tilde{A}_{f,r}` is  :math:`\sup_{\vect{x}} f(\vect{x})^{\frac{1}{1+r\inputDim}}`.
        """
        return _experimental.RatioOfUniforms_getSupU(self)

    def getInfV(self):
        r"""
        Accessor to the :math:`V`-lower bound of :math:`\tilde{A}_{f,r}`.

        Returns
        -------
        infV : :class:`~openturns.Point`
            The :math:`V`-lower bound of :math:`\tilde{A}_{f,r}` defined in :eq:`tildeArf_def`.

        Notes
        -----
        The :math:`V`-lower bound of :math:`\tilde{A}_{f,r}` is
        :math:`\left( \inf_{\vect{x}} x_i f(\vect{x})^{\frac{r}{1+r\inputDim}} \right)_{1 \leq i \leq \inputDim}`.
        """
        return _experimental.RatioOfUniforms_getInfV(self)

    def getSupV(self):
        r"""
        Accessor to the :math:`V`-upper bound of :math:`\tilde{A}_{f,r}`.

        Returns
        -------
        infV : :class:`~openturns.Point`
            The :math:`V`-upper bound of :math:`\tilde{A}_{f,r}` defined in :eq:`tildeArf_def`.

        Notes
        -----
        The :math:`V`-upper bound of :math:`\tilde{A}_{f,r}` is
        :math:`\left( \sup_{\vect{x}} x_i f(\vect{x})^{\frac{r}{1+r\inputDim}} \right)_{1 \leq i \leq \inputDim}`.
        """
        return _experimental.RatioOfUniforms_getSupV(self)

    def setOptimizationAlgorithm(self, optimizationAlgorithm):
        r"""
        Accessor to the optimization algorithm.

        Parameters
        ----------
        algo : :class:`~openturns.OptimizationAlgorithm`
            Optimization algorithm that computes the bounds of :math:`\tilde{A}_{f,r}`.
        """
        return _experimental.RatioOfUniforms_setOptimizationAlgorithm(self, optimizationAlgorithm)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the optimization algorithm.

        Returns
        -------
        algo : :class:`~openturns.OptimizationAlgorithm`
            Optimization algorithm that computes the bounds of :math:`\tilde{A}_{f,r}`.
        """
        return _experimental.RatioOfUniforms_getOptimizationAlgorithm(self)

    def setCandidateNumber(self, candidateNumber):
        r"""
        Accessor to the maximum number of points tested to find admissible starting points.

        Parameters
        ----------
        n : int, :math:`n>0`
            Maximum number of points tested to find admissible points for the optimization algorithm.

        Notes
        -----
        As long as the number of selected starting points is less than the number
        defined in :class:`~openturns.ResourceMap`,
        entry *RatioOfUniforms-MaximumMultiStart*, a new point of the Sobol low
        discrepancy sequence of dimension :math:`\inputDim` is considered. The maximum
        points of the Sobol sequence is :math:`n`. If no starting point has been
        selected, a warning is sent.
        """
        return _experimental.RatioOfUniforms_setCandidateNumber(self, candidateNumber)

    def getCandidateNumber(self):
        r"""
        Accessor to the maximum number of points tested to find admissible starting points.

        Returns
        -------
        n : int, :math:`n>0`
            Maximum number of points tested to find admissible points for the optimization algorithm.

        Notes
        -----
        As long as the number of selected starting points is less than the number
        defined in :class:`~openturns.ResourceMap`,
        entry *RatioOfUniforms-MaximumMultiStart*, a new point of the Sobol low
        discrepancy sequence of dimension :math:`\inputDim` is considered. The maximum
        points of the Sobol sequence is :math:`n`. If no starting point has been
        selected, a warning is sent.
        """
        return _experimental.RatioOfUniforms_getCandidateNumber(self)

    def setMaximumMultiStart(self, maximumMultiStart):
        r"""
        Accessor to the maximum number of starting points for the multistart algorithm.

        Parameters
        ----------
        n : int, :math:`n>0`
            Maximum number of starting points for the multistart algorithm.

        Notes
        -----
        A tested point :math:`\vect{x} \in I` is kept as a starting point of the multistart algorithm if :math:`f(\vect{x})>0`.
        """
        return _experimental.RatioOfUniforms_setMaximumMultiStart(self, maximumMultiStart)

    def getMaximumMultiStart(self):
        r"""
        Accessor to the maximum number of starting points for the multistart algorithm.

        Returns
        -------
        n : int
            Maximum number of starting points for the multistart algorithm.

        Notes
        -----
        A tested point :math:`\vect{x} \in I` is a starting point of the multistart algorithm if :math:`f(\vect{x})>0`.
        """
        return _experimental.RatioOfUniforms_getMaximumMultiStart(self)

    def setR(self, r):
        r"""
        Accessor to the :math:`r` parameter.

        Parameters
        ----------
        r : float
            The :math:`r` parameter.

        Notes
        -----
        This method triggers the initialization of the class.
        """
        return _experimental.RatioOfUniforms_setR(self, r)

    def getR(self):
        r"""
        Accessor to the :math:`r` parameter.

        Returns
        -------
        r : float
            The :math:`r` parameter.
        """
        return _experimental.RatioOfUniforms_getR(self)

    def getC(self):
        r"""
        Accessor to the :math:`c` normalization factor.

        Returns
        -------
        c : float, :math:`c >0`,
            The :math:`c` normalization factor.

        Notes
        -----
        If the class has been created with a scaled function, then :math:`c=1`.

        If the class has been created with an unscaled function, the acceptance ratio is estimated at the initialization
        of the class by the method *initialize*. From :math:`\hat{\tau}_{accept}` defined in :eq:`acceptRatioEstimate`,
        we get an estimate of the  normalization factor defined by:

        .. math::

          \hat{c} = \dfrac{1}{\hat{\tau}_{accept}(1+r\inputDim)} \dfrac{1}{u_{sup}\prod_{i=1}^d \left(v_{sup, i} - v_{inf, i} \right)}


        """
        return _experimental.RatioOfUniforms_getC(self)

    def getAcceptanceRatio(self):
        r"""
        Accessor to the acceptance ratio.

        Returns
        -------
        accepRatio : float, :math:`0 \leq \tau_{accept} \leq 1`,
            Acceptance ratio :math:`\tau_{accept}`.

        Notes
        -----
        The acceptance ratio is computed at the initialization of the class by the ethod *initialize*, according to :eq:`acceptRatio` where :math:`c=1` 
        if the class has been created with a log-PDF and estimated by :eq:`acceptRatioEstimate` in the other case.
        """
        return _experimental.RatioOfUniforms_getAcceptanceRatio(self)

    def initialize(self):
        r"""
        Trigger to the initializationof the class.


        Returns
        -------
        collMutliStart : collection of :class:`~openturns.MultiStart`
            Collection of the multistart optimization algorithms used to compute the bounds of :math:`\tilde{A}_{f,r}`.

        Notes
        -----
        A call to that method triggers the computation of the bounding box :math:`\tilde{A}_{f,r}`
        and the estimation of the acceptance ratio.

        The methods returns a collection of multistart optimization algorithms containing:

        - the multistart optimization algorithm used to compute :math:`u_{sup}`,
        - for each :math:`i`, the multistart optimization algorithm used to compute :math:`v_{inf, i}` if required, the one used to
          compute :math:`v_{sup, i}` if required.

        Then, the size of the collection of :class:`~openturns.MultiStart` is less than :math:`2\inputDim + 1` and at least 1.
        These multistart optimization algorithms give access to the starting points used to compute the optimization problem and all the results associated.

        Within the initialization of the class, the acceptance ratio is computed: 

        - If the class has been created with a scaled function, the acceptance ratio is defined by :eq:`acceptRatio` where
          :math:`c=1`. If the acceptance ratio is greater than 1, then it means that the optimization problem has not worked
          well and a warning is sent.
        - If the class has been created with an unscaled function, the acceptance ratio is estimated with the method
          *getSampleWithTryNumber*: if :math:`n_{try}` is the number of realizations uniformly generated inside
          :math:`\tilde{A}_{f,r}` to get :math:`n_{accept}` accepted realizations, then we have:

          .. math::
             :label: acceptRatioEstimate

             \hat{\tau}_{accept} = \dfrac{n_{accept}}{n_{try}}

          In that case, :math:`\hat{\tau}_{accept}` is always less than 1.
        """
        return _experimental.RatioOfUniforms_initialize(self)

    def isInitialized(self):
        r"""
        Flag telling if the algorithm has been initialized.

        Returns
        -------
        answer: bool
            Flag telling if the bounding box :math:`\tilde{A}_{f,r}` and the acceptance ratio
            has already been computed.
        """
        return _experimental.RatioOfUniforms_isInitialized(self)

    def getRealization(self):
        r"""
        Generate a realization.

        Returns
        -------
        point: :class:`~openturns.Point`
            A pseudo-random realization of the distribution.
        """
        return _experimental.RatioOfUniforms_getRealization(self)

    def getSample(self, size):
        r"""
        Generate a sample.

        Returns
        -------
        sample: :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.
        """
        return _experimental.RatioOfUniforms_getSample(self, size)

    def getSampleWithTryNumber(self, size):
        r"""
        Sample with number of realizations needed to get it.

        Parameters
        ----------
        size : int,
            The number of accepted realizations of the rejection algorithm.

        Returns
        -------
        sample: :class:`~openturns.Sample`,
            A pseudo-random realization of the distribution of size *size*.

        tryNumber : int,
            The number realizations needed to produce *size* accepted realizations.

        Notes
        -----
        The rejection algorithm produces *tryNumber* realizations of the uniform distribution on :math:`\tilde{A}_{f,r}` to produce *size* realizations inside :math:`A_{f,r}`.
        """
        return _experimental.RatioOfUniforms_getSampleWithTryNumber(self, size)

    def __init__(self, *args):
        _experimental.RatioOfUniforms_swiginit(self, _experimental.new_RatioOfUniforms(*args))
    __swig_destroy__ = _experimental.delete_RatioOfUniforms

# Register RatioOfUniforms in _experimental:
_experimental.RatioOfUniforms_swigregister(RatioOfUniforms)
class GaussianProcessRandomVector(openturns.randomvector.UsualRandomVector):
    r"""
    GaussianProcessRandom vector, a conditioned Gaussian process.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    gprResult : :class:`~openturns.experimental.GaussianProcessRegressionResult`
        Structure that contains elements of computation of a Gaussian Process Regression algorithm
    points : 1-d or 2-d sequence of float
        Sequence of values defining a :class:`~openturns.Point` or a :class:`~openturns.Sample`.

    Notes
    -----
    GaussianProcessRandomVector helps to create Gaussian random vector, :math:`Y: \Rset^n \mapsto \Rset^d`, with stationary covariance function  :math:`\cC^{stat}: \Rset^n \mapsto \cM_{d \times d}(\Rset)`, conditionally to some observations.

    Let :math:`Y(x=x_1)=y_1,\cdots,Y(x=x_n)=y_n` be the observations of the Gaussian process. We assume the same Gaussian prior as in the :class:`~openturns.experimental.GaussianProcessRegression`:

    .. math::

        Y(\vect{x}) = \Tr{\vect{f}(\vect{x})} \vect{\beta} + Z(\vect{x})

    with :math:`\Tr{\vect{f}(\vect{x})} \vect{\beta}` a general linear model, :math:`Z(\vect{x})` a zero-mean Gaussian process with a stationary autocorrelation function :math:`\cC^{stat}`:

    .. math::

        \mathbb{E}[Z(\vect{x}), Z(\vect{\tilde{x}})] = \sigma^2 \cC^{stat}_{\theta}(\vect{x} - \vect{\tilde{x}})

    The objective is to generate realizations of the random vector :math:`Y`, on new points :math:`\vect{\tilde{x}}`, conditionally to these observations. For that purpose, :class:`~openturns.experimental.GaussianProcessRegression` build such a prior and stores results in a :class:`~openturns.experimental.GaussianProcessRegressionResult` structure on a first step. This structure is given as input argument.

    Then, in a second step, both the prior and the covariance on input points :math:`\vect{\tilde{x}}`, conditionally to the previous observations, are evaluated (respectively :math:`Y(\vect{\tilde{x}})` and :math:`\cC^{stat}_{\theta}(\vect{\tilde{x}})`).

    Finally realizations are randomly generated by the Gaussian distribution :math:`\cN ( Y(\vect{\tilde{x}}), \cC^{stat}_{\theta}(\vect{\tilde{x}}) )`

    This class inherits from :class:`~openturns.UsualRandomVector`. Thus it stores the previous distribution and returns elements thanks to that distribution (realization, mean, covariance, sample...)

    Examples
    --------
    Create the model :math:`\cM: \Rset \mapsto \Rset` and the samples:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> f = ot.SymbolicFunction(['x'],  ['x * sin(x)'])
    >>> sampleX = [[1.0], [2.0], [3.0], [4.0], [5.0], [6.0], [7.0], [8.0]]
    >>> sampleY = f(sampleX)

    Create the algorithm:

    >>> basis = ot.Basis([ot.SymbolicFunction(['x'], ['x']), ot.SymbolicFunction(['x'], ['x^2'])])
    >>> covarianceModel = ot.SquaredExponential([1.0])
    >>> covarianceModel.setActiveParameter([])
    >>> fit_algo = otexp.GaussianProcessFitter(sampleX, sampleY, covarianceModel, basis)
    >>> fit_algo.run()
    >>> gpr_algo = otexp.GaussianProcessRegression(fit_algo.getResult())
    >>> gpr_algo.run()

    Get the results:

    >>> gpr_result = gpr_algo.getResult()
    >>> rvector = otexp.GaussianProcessRandomVector(gpr_result, [[0.0]])

    Get a sample of the random vector:

    >>> sample = rvector.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.GaussianProcessRandomVector_getClassName(self)

    def __repr__(self):
        return _experimental.GaussianProcessRandomVector___repr__(self)

    def getRealization(self):
        r"""
        Compute a realization of the conditional Gaussian process (conditional on the learning set).

        The realization predicts the value on the given input *points*.

        Returns
        -------
        realization : :class:`~openturns.Point`
            Sequence of values of the Gaussian process.

        See also
        --------
        getSample
        """
        return _experimental.GaussianProcessRandomVector_getRealization(self)

    def getSample(self, size):
        r"""
        Compute a sample of realizations of the conditional Gaussian process (conditional on the learning set).

        The realization predicts the value on the given input *points*.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            2-d float sequence of values of the Gaussian process.

        See also
        --------
        getRealization
        """
        return _experimental.GaussianProcessRandomVector_getSample(self, size)

    def getGaussianProcessRegressionResult(self):
        r"""
        Return the Gaussian Process Regression result structure.

        Returns
        -------
        gprResult : :class:`~openturns.experimental.GaussianProcessRegressionResult`
            The structure containing the elements of a Gaussian Process Regression.
        """
        return _experimental.GaussianProcessRandomVector_getGaussianProcessRegressionResult(self)

    def __init__(self, *args):
        _experimental.GaussianProcessRandomVector_swiginit(self, _experimental.new_GaussianProcessRandomVector(*args))
    __swig_destroy__ = _experimental.delete_GaussianProcessRandomVector

# Register GaussianProcessRandomVector in _experimental:
_experimental.GaussianProcessRandomVector_swigregister(GaussianProcessRandomVector)
class ConditionedGaussianProcess(openturns.model_process.GaussianProcess):
    r"""
    Conditioned Gaussian process.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    gprResult : :class:`~openturns.experimental.GaussianProcessRegressionResult`
        Structure that contains all the elements of Gaussian Process Regression computations.
    mesh : :class:`~openturns.Mesh`
        Mesh :math:`\cM` over which the domain :math:`\cD` is discretized.

    Notes
    -----
    This class helps to generate fields from the conditioned gaussian process resulting
    from a Gaussian process regression algorithm.

    Refer to the documentation of :class:`~openturns.experimental.GaussianProcessRegression` to get details on
    the notations.

    Examples
    --------
    We consider the model :math:`g: \Rset^2 \rightarrow \Rset` defined by :math:`g(x,y) = cos(x/2) + sin(y)`.

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> ot.RandomGenerator.SetSeed(0)
    >>> model = ot.SymbolicFunction(['x', 'y'], ['cos(0.5*x) + sin(y)'])

    Then we define the train sample as a box with 8 levels on the x-axis and 5 levels on the y-axis.

    >>> levels = [8.0, 5.0]
    >>> box = ot.Box(levels)
    >>> x_train = box.generate()
    >>> x_train *= 10
    >>> y_train = model(x_train)

    We define the covariance model as a :class:`~openturns.SquaredExponential` model:

    >>> dim = 2
    >>> covarianceModel = ot.SquaredExponential([1.0, 1.0], [1.0])

    We define the functions basis to estimate the trend: this basis only contains constant functions:

    >>> basis = ot.ConstantBasisFactory(dim).build()

    We estimate the Gaussian process regression, using first the class
    :class:`~openturns.experimental.GaussianProcessFitter`, then
    using the class :class:`~openturns.experimental.GaussianProcessRegression`:

    >>> fitter_algo = otexp.GaussianProcessFitter(x_train, y_train, covarianceModel, basis)
    >>> fitter_algo.run()
    >>> fitter_result = fitter_algo.getResult()
    >>> gpr_algo = otexp.GaussianProcessRegression(fitter_result)
    >>> gpr_algo.run()
    >>> gpr_result = gpr_algo.getResult()

    Now, we define the mesh on which the gconditionned gaussian process  is generated:

    >>> vertices = [[1.0, 0.0], [2.0, 0.0], [2.0, 1.0], [1.0, 1.0], [1.5, 0.5]]
    >>> simplices = [[0, 1, 4], [1, 2, 4], [2, 3, 4], [3, 0, 4]]
    >>> mesh2D = ot.Mesh(vertices, simplices)
    >>> process = otexp.ConditionedGaussianProcess(gpr_result, mesh2D)

    We get a realization of the conditioned Gaussian process:

    >>> realization = process.getRealization()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ConditionedGaussianProcess_getClassName(self)

    def __repr__(self):
        return _experimental.ConditionedGaussianProcess___repr__(self)

    def __str__(self, *args):
        return _experimental.ConditionedGaussianProcess___str__(self, *args)

    def getRealization(self):
        r"""
        Return a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            A realization of the process.
        """
        return _experimental.ConditionedGaussianProcess_getRealization(self)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _experimental.ConditionedGaussianProcess_isNormal(self)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _experimental.ConditionedGaussianProcess_isStationary(self)

    def setMesh(self, mesh):
        r"""
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _experimental.ConditionedGaussianProcess_setMesh(self, mesh)

    def setTimeGrid(self, timeGrid):
        r"""
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _experimental.ConditionedGaussianProcess_setTimeGrid(self, timeGrid)

    def setSamplingMethod(self, *args):
        r"""
        Set the used method for getRealization.

        Available parameters are :

          * 0 (GaussianProcess.CHOLESKY) : Cholesky factor sampling (default method)

          * 1 (GaussianProcess.HMAT) : H-Matrix method (if H-Mat available)

          * 2 (GaussianProcess.GALLIGAOGIBBS) : Gibbs method (in dimension 1 only)

        Parameters
        ----------
        samplingMethod : int
            Fix a method for sampling.


        """
        return _experimental.ConditionedGaussianProcess_setSamplingMethod(self, *args)

    def __init__(self, *args):
        _experimental.ConditionedGaussianProcess_swiginit(self, _experimental.new_ConditionedGaussianProcess(*args))
    __swig_destroy__ = _experimental.delete_ConditionedGaussianProcess

# Register ConditionedGaussianProcess in _experimental:
_experimental.ConditionedGaussianProcess_swigregister(ConditionedGaussianProcess)

