# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""EventSimulation uncertainty propagation algorithms."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _simulation
else:
    import _simulation

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.transformation
import openturns.metamodel
import openturns.weightedexperiment
import openturns.orthogonalbasis
import openturns.randomvector
import openturns.analytical
class ANCOVA(object):
    r"""
    ANalysis of COVAriance method (ANCOVA).

    Refer to :ref:`sensitivity_ancova`.

    Parameters
    ----------
    functionalChaosResult : :class:`~openturns.FunctionalChaosResult`
        Functional chaos result approximating the model response with
        uncorrelated inputs.
    correlatedInput : 2-d sequence of float
        Correlated inputs used to compute the real values of the output.
        Its dimension must be equal to the number of inputs of the model.

    Notes
    -----
    ANCOVA, a variance-based method described in [caniou2012]_, is a generalization
    of the ANOVA (ANalysis Of VAriance) decomposition for models with correlated
    input parameters.

    Let us consider a model :math:`Y = h(\vect{X})` without making any hypothesis
    on the dependence structure of :math:`\vect{X} = \{X^1, \ldots, X^{n_X} \}`, a
    n_X-dimensional random vector. The covariance decomposition requires a functional
    decomposition of the model. Thus the model response :math:`Y` is expanded as a
    sum of functions of increasing dimension as follows:

    .. math::
        :label: model

        h(\vect{X}) = h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u)

    :math:`h_0` is the mean of :math:`Y`. Each function :math:`h_u` represents,
    for any non empty set :math:`u\subseteq\{1, \dots, n_X\}`, the combined
    contribution of the variables :math:`X_u` to :math:`Y`.

    Using the properties of the covariance, the variance of :math:`Y` can be
    decomposed into a variance part and a covariance part as follows:

    .. math::

        Var[Y]&= Cov\left[h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u), h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u)\right] \\
              &= \sum_{u\subseteq\{1,\dots,n_X\}} \left[Var[h_u(X_u)] + Cov[h_u(X_u), \sum_{v\subseteq\{1,\dots,n_X\}, v\cap u=\varnothing} h_v(X_v)]\right]

    This variance formula enables to define each total part of variance of
    :math:`Y` due to :math:`X_u`, :math:`S_u`, as the sum of a *physical*
    (or *uncorrelated*) part and a *correlated* part such as:

    .. math::

        S_u = \frac{Cov[Y, h_u(X_u)]} {Var[Y]} = S_u^U + S_u^C

    where :math:`S_u^U` is the uncorrelated part of variance of Y due to :math:`X_u`:

    .. math::

        S_u^U = \frac{Var[h_u(X_u)]} {Var[Y]}

    and :math:`S_u^C` is the contribution of the correlation of :math:`X_u` with the
    other parameters:

    .. math::

        S_u^C = \frac{Cov\left[h_u(X_u), \displaystyle \sum_{v\subseteq\{1,\dots,n_X\}, v\cap u=\varnothing} h_v(X_v)\right]}
                     {Var[Y]}

    As the computational cost of the indices with the numerical model :math:`h`
    can be very high, [caniou2012]_ suggests to approximate the model response with
    a polynomial chaos expansion:

    .. math::

        Y \simeq \hat{h} = \sum_{j=0}^{P-1} \alpha_j \Psi_j(x)

    However, for the sake of computational simplicity, the latter is constructed
    considering *independent* components :math:`\{X^1,\dots,X^{n_X}\}`. Thus the
    chaos basis is not orthogonal with respect to the correlated inputs under
    consideration, and it is only used as a metamodel to generate approximated
    evaluations of the model response and its summands :eq:`model`.

    The next step consists in identifying the component functions. For instance, for
    :math:`u = \{1\}`:

    .. math::

        h_1(X_1) = \sum_{\alpha | \alpha_1 \neq 0, \alpha_{i \neq 1} = 0} y_{\alpha} \Psi_{\alpha}(\vect{X})

    where :math:`\alpha` is a set of degrees associated to the :math:`n_X` univariate
    polynomial :math:`\psi_i^{\alpha_i}(X_i)`.

    Then the model response :math:`Y` is evaluated using a sample
    :math:`X=\{x_k, k=1,\dots,N\}` of the correlated joint distribution. Finally,
    the several indices are computed using the model response and its component
    functions that have been identified on the polynomial chaos.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Model and distribution definition
    >>> model = ot.SymbolicFunction(['X1','X2'], ['4.*X1 + 5.*X2'])
    >>> distribution = ot.JointDistribution([ot.Normal()] * 2)
    >>> S = ot.CorrelationMatrix(2)
    >>> S[1, 0] = 0.3
    >>> R = ot.NormalCopula().GetCorrelationFromSpearmanCorrelation(S)
    >>> CorrelatedInputDistribution = ot.JointDistribution([ot.Normal()] * 2, ot.NormalCopula(R))
    >>> sample = CorrelatedInputDistribution.getSample(200)
    >>> # Functional chaos computation
    >>> productBasis = ot.OrthogonalProductPolynomialFactory([ot.HermiteFactory()] * 2, ot.LinearEnumerateFunction(2))
    >>> adaptiveStrategy = ot.FixedStrategy(productBasis, 15)
    >>> experiment = ot.MonteCarloExperiment(distribution, 100)
    >>> X = experiment.generate()
    >>> Y = model(X)
    >>> algo = ot.FunctionalChaosAlgorithm(X, Y, distribution, adaptiveStrategy)
    >>> algo.run()
    >>> ancovaResult = ot.ANCOVA(algo.getResult(), sample)
    >>> indices = ancovaResult.getIndices()
    >>> print(indices)
    [0.408398,0.591602]
    >>> uncorrelatedIndices = ancovaResult.getUncorrelatedIndices()
    >>> print(uncorrelatedIndices)
    [0.284905,0.468108]
    >>> # Get indices measuring the correlated effects
    >>> print(indices - uncorrelatedIndices)
    [0.123494,0.123494]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getUncorrelatedIndices(self, marginalIndex=0):
        r"""
        Accessor to the ANCOVA indices measuring uncorrelated effects.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the ANCOVA indices measuring uncorrelated effects of the inputs.
            The effects of the correlation are represented by the indices resulting
            from the subtraction of the :meth:`getIndices` and
            :meth:`getUncorrelatedIndices` lists.
        """
        return _simulation.ANCOVA_getUncorrelatedIndices(self, marginalIndex)

    def getIndices(self, marginalIndex=0):
        r"""
        Accessor to the ANCOVA indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the ANCOVA indices measuring the contribution of the
            input variables to the variance of the model. These indices are made up
            of a *physical* part and a *correlated* part. The first one is obtained
            thanks to :meth:`getUncorrelatedIndices`.
            The effects of the correlation are represented by the indices resulting
            from the subtraction of the :meth:`getIndices` and
            :meth:`getUncorrelatedIndices` lists.
        """
        return _simulation.ANCOVA_getIndices(self, marginalIndex)

    def __init__(self, *args):
        _simulation.ANCOVA_swiginit(self, _simulation.new_ANCOVA(*args))
    __swig_destroy__ = _simulation.delete_ANCOVA

# Register ANCOVA in _simulation:
_simulation.ANCOVA_swigregister(ANCOVA)
class FAST(object):
    r"""
    Fourier Amplitude Sensitivity Testing (FAST).

    Refer to :ref:`sensitivity_fast`.

    Parameters
    ----------
    model : :class:`~openturns.Function`
        Definition of the model to analyse.
    distribution : :class:`~openturns.Distribution`
        Contains the distributions of each model's input.
        Its dimension must be equal to the number of inputs.
    N : int, :math:`N > Nr`
        Size of the sample from which the Fourier series are calculated.
        It represents the length of the discretization of the s-space.
    Nr : int, :math:`Nr \geq 1`, optional
        Number of resamplings. The extended FAST method involves a part of
        randomness in the computation of the indices. So it can be asked to
        realize the procedure *Nr* times and then to calculate the
        arithmetic means of the results over the *Nr* estimates.
    M : int, :math:`0 < M < N`, optional
        Interference factor usually equal to 4 or higher.
        It corresponds to the truncation level of the Fourier series, i.e. the
        number of harmonics that are retained in the decomposition.

    Notes
    -----
    FAST is a sensitivity analysis method which is based upon the ANOVA
    decomposition of the variance of the model response :math:`y = f(\vect{X})`,
    the latter being represented by its Fourier expansion.
    :math:`\vect{X}=\{X^1,\dots,X^{n_X}\}` is an input random vector of :math:`n_X`
    independent components.

    OpenTURNS implements the extended FAST method consisting in computing
    alternately the first order and the total-effect indices of each input.
    This approach, widely described in the paper by [saltelli1999]_, relies upon a
    Fourier decomposition of the model response. Its key idea is to recast this
    representation as a function of a *scalar* parameter :math:`s`, by defining
    parametric curves :math:`s \mapsto x_i(s), i=1, \dots, n_X` exploring the
    support of the input random vector :math:`\vect{X}`.

    Then the Fourier expansion of the model response is:

    .. math::

        f(s) = \sum_{k \in \Zset^N} A_k cos(ks) + B_k sin(ks)

    where :math:`A_k` and :math:`B_k` are Fourier coefficients whose estimates are:

    .. math::

        \hat{A}_k &= \frac{1}{N} \sum_{j=1}^N f(x_j^1,\dots,x_j^{N_X}) cos\left(\frac{2k\pi (j-1)}{N} \right) \quad , \quad -\frac{N}{2} \leq k \leq \frac{N}{2} \\
        \hat{B}_k &= \frac{1}{N} \sum_{j=1}^N f(x_j^1,\dots,x_j^{N_X}) sin\left(\frac{2k\pi (j-1)}{N} \right) \quad , \quad -\frac{N}{2} \leq k \leq \frac{N}{2}


    The first order indices are estimated by:

    .. math::

        \hat{S}_i = \frac{\hat{D}_i}{\hat{D}}
                  = \frac{\sum_{p=1}^M(\hat{A}_{p\omega_i}^2 + \hat{B}_{p\omega_i}^2)^2}
                          {\sum_{n=1}^{(N-1)/2}(\hat{A}_n^2 + \hat{B}_n^2)^2}

    and the total order indices by:

    .. math::

        \hat{T}_i = 1 - \frac{\hat{D}_{-i}}{\hat{D}}
                  = 1 - \frac{\sum_{k=1}^{\omega_i/2}(\hat{A}_k^2 + \hat{B}_k^2)^2}
                              {\sum_{n=1}^{(N-1)/2}(\hat{A}_n^2 + \hat{B}_n^2)^2}

    where :math:`\hat{D}` is the total variance, :math:`\hat{D}_i` the portion
    of :math:`D` arising from the uncertainty of the :math:`i^{th}` input and
    :math:`\hat{D}_{-i}` is the part of the variance due to all the inputs
    except the :math:`i^{th}` input.

    :math:`N` is the size of the sample using to compute the Fourier series and
    :math:`M` is the interference factor. *Saltelli et al.* (1999) recommended to
    set :math:`M` to a value in the range :math:`[4, 6]`.
    :math:`\{\omega_i\}, \forall i=1, \dots, n_X` is a set of integer frequencies
    assigned to each input :math:`X^i`. The frequency associated with the input
    for which the sensitivity indices are computed, is set to the maximum admissible
    frequency satisfying the Nyquist criterion (which ensures to avoid aliasing effects):

    .. math::

        \omega_i = \frac{N - 1}{2M}

    In the paper by Saltelli et al. (1999), for high sample size, it is suggested
    that :math:`16 \leq \omega_i/N_r \leq 64`.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> sensitivityAnalysis = ot.FAST(model, distribution, 101)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.311097,0.441786,0.000396837]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Accessor to the first order indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the first order indices of all the inputs.
        """
        return _simulation.FAST_getFirstOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Accessor to the total order indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's  marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the total-effect order indices of all the inputs.
        """
        return _simulation.FAST_getTotalOrderIndices(self, marginalIndex)

    def getFFTAlgorithm(self):
        r"""
        Accessor to the FFT algorithm implementation.

        Returns
        -------
        fft : a :class:`~openturns.FFT`
            A FFT algorithm.
        """
        return _simulation.FAST_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, fft):
        r"""
        Accessor to the FFT algorithm implementation.

        Parameters
        ----------
        fft : a :class:`~openturns.FFT`
            A FFT algorithm.
        """
        return _simulation.FAST_setFFTAlgorithm(self, fft)

    def setBlockSize(self, blockSize):
        r"""
        Set the block size.

        Parameters
        ----------
        k : positive int
            Size of each block the sample is split into, this allows one to save space
            while allowing multithreading, when available we recommend to use
            the number of available CPUs, set by default to :math:`1`.
        """
        return _simulation.FAST_setBlockSize(self, blockSize)

    def getBlockSize(self):
        r"""
        Get the block size.

        Returns
        -------
        k : positive int
            Size of each block the sample is split into, this allows one to save space
            while allowing multithreading, when available we recommend to use
            the number of available CPUs, set by default to 1.
        """
        return _simulation.FAST_getBlockSize(self)

    def __init__(self, *args):
        _simulation.FAST_swiginit(self, _simulation.new_FAST(*args))
    __swig_destroy__ = _simulation.delete_FAST

# Register FAST in _simulation:
_simulation.FAST_swigregister(FAST)
class SobolIndicesAlgorithmImplementation(openturns.common.PersistentObject):
    r"""

    Sensitivity analysis.

    Notes
    -----
    This method measures the influence of each component of an input random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on an output random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see [sobol1993]_).
    It computes, for every output random variable :math:`Y_k` (:math:`1 \leqslant k \leqslant n_Y`),
    the part of its variance due to each input component :math:`X_i` (:math:`1 \leqslant i \leqslant n_X`) of :math:`\vect{X}`.
    Sobol' indices are introduced in :ref:`sensitivity_sobol`. 

    Several estimators of :math:`V_i`, :math:`V_i^T` and :math:`V_{-i}` are provided by the :class:`SobolIndicesAlgorithm` implementations:

    - :class:`~openturns.SaltelliSensitivityAlgorithm` for the `Saltelli` method,
    - :class:`~openturns.JansenSensitivityAlgorithm` for the `Jansen` method,
    - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm` for the `Mauntz-Kucherenko` method,
    - :class:`~openturns.MartinezSensitivityAlgorithm` for the `Martinez` method.

    Specific formulas for :math:`\widehat{V}_i`, :math:`\widehat{V}_i^T` and :math:`\widehat{V}_{-i}` are given in the corresponding documentation pages.


    For multivariate outputs i.e. when :math:`n_Y>1`, we compute the Sobol' indices with respect to each output variable. 
    In this case, the methods :meth:`getFirstOrderIndices` and 
    :meth:`getTotalOrderIndices` return the Sobol' indices of the first output, 
    but the index of the output can be specified as input argument.
    Aggregated indices can be retrieved with the :meth:`getAggregatedFirstOrderIndices` 
    and :meth:`getAggregatedTotalOrderIndices` methods. 


    Notice that the distribution of the estimators of the first
    and total order indices can be estimated
    thanks to the :meth:`getFirstOrderIndicesDistribution` and
    :meth:`getTotalOrderIndicesDistribution` methods.
    This is done either through bootstrapping or using an asymptotic estimator.
    The :class:`~openturns.ResourceMap` key `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution`
    stores a boolean that decides the default behavior,
    but it can be overridden by the method :meth:`setUseAsymptoticDistribution`.

    Corresponding confidence intervals are provided by the methods
    :meth:`getFirstOrderIndicesInterval` and :meth:`getTotalOrderIndicesInterval`.
    Their confidence level can be adjusted with :meth:`setConfidenceLevel`.
    The default confidence level is stored in the :class:`~openturns.ResourceMap`
    and can be accessed with the `SobolIndicesAlgorithm-DefaultConfidenceLevel` key.

    Indices estimates can be slightly outside of [0,1] if the estimator has not converged.
    For the same reason some first order indices estimates can be greater than the corresponding total order indices estimates.

    The asymptotic estimator of the distribution requires an asymptotic estimate
    of its variance, which is computed using the [janon2014]_
    delta method, as expained in the technical report [pmfre01116]_.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getClassName(self)

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Get first order Sobol indices.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing first order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getFirstOrderIndices(self, marginalIndex)

    def getFirstOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated first order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for first order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getFirstOrderIndicesInterval(self)

    def getSecondOrderIndices(self, marginalIndex=0):
        r"""
        Get second order Sobol indices.

        Notes
        -----
        Let :math:`n_X \in \Nset` be the input dimension of the random vector.
        For any pair of indices :math:`i, j \in \{1, ..., n_x\}` such that :math:`i \neq j`,
        this method computes the Sobol' interaction index between :math:`i` and :math:`j`:

        .. math::
            S_{\{i, j\}} = \frac{V_{\{i,j\}}}{\Var{Y}}

        The second order Sobol' index :math:`S_{i,j}`  measures the part of
        the variance of :math:`Y` explained by the interaction of :math:`X_i` and :math:`X_j`.
        Hence, the closed Sobol' index of the group :math:`\{i, j\}` is:

        .. math::
            S_{\{i, j\}}^{\operatorname{cl}} = S_i + S_j + S_{\{i, j\}}.

        Conversely, if the closed Sobol' index :math:`S_{\{i, j\}}^{\operatorname{cl}}` is known,
        then the interaction Sobol' index can be computed from the equation:

        .. math::
            S_{\{i, j\}} = S_{\{i, j\}}^{\operatorname{cl}} - S_i - S_j.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.SymmetricMatrix`
            Tensor containing second order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getSecondOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Get total order Sobol indices.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing total order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getTotalOrderIndices(self, marginalIndex)

    def getTotalOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated total order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for total order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getTotalOrderIndicesInterval(self)

    def getAggregatedFirstOrderIndices(self):
        r"""
        Get the evaluation of aggregated first order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated first order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getAggregatedFirstOrderIndices(self)

    def getAggregatedTotalOrderIndices(self):
        r"""
        Get the evaluation of aggregated total order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated total order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getAggregatedTotalOrderIndices(self)

    def getBootstrapSize(self):
        r"""
        Get the number of bootstrap sampling size.

        Returns
        -------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Set the number of bootstrap sampling size.

        Default value is 0.

        Parameters
        ----------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _simulation.SobolIndicesAlgorithmImplementation_setBootstrapSize(self, bootstrapSize)

    def getConfidenceLevel(self):
        r"""
        Get the confidence interval level for confidence intervals.

        Returns
        -------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getConfidenceLevel(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Set the confidence interval level for confidence intervals.

        Parameters
        ----------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _simulation.SobolIndicesAlgorithmImplementation_setConfidenceLevel(self, confidenceLevel)

    def setUseAsymptoticDistribution(self, useAsymptoticDistribution):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Default value is set by the `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution` key.

        Parameters
        ----------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _simulation.SobolIndicesAlgorithmImplementation_setUseAsymptoticDistribution(self, useAsymptoticDistribution)

    def getUseAsymptoticDistribution(self):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Returns
        -------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getUseAsymptoticDistribution(self)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated first order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for first order Sobol indices for each component.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated total order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for total order Sobol indices for each component.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getTotalOrderIndicesDistribution(self)

    def __repr__(self):
        return _simulation.SobolIndicesAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _simulation.SobolIndicesAlgorithmImplementation___str__(self, *args)

    @staticmethod
    def DrawImportanceFactors(*args):
        r"""
        Draw the importance factors.

        Available usages:
            DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

            DrawImportanceFactors(*values, names, title='Importance Factors'*)

        Parameters
        ----------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component. The descriptions are used to build labels for the created Pie.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Importance factors.
        names : sequence of str
            Variables' names used to build labels for the created Pie.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Pie` of the importance factors of
            the variables.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_DrawImportanceFactors(*args)

    @staticmethod
    def DrawSobolIndices(*args):
        r"""
        Draw the Sobol' indices.

        Parameters
        ----------
        inputDescription : sequence of str
            Variable names
        firstOrderIndices : sequence of float
            First order indices values
        totalOrderIndices : sequence of float
            Total order indices values
        fo_ci : :class:`~openturns.Interval`, optional
            First order indices confidence interval
        to_ci : :class:`~openturns.Interval`, optional
            Total order indices confidence interval

        Returns
        -------
        graph : :class:`~openturns.Graph`
            For each variable, draws first and total indices
        """
        return _simulation.SobolIndicesAlgorithmImplementation_DrawSobolIndices(*args)

    @staticmethod
    def DrawCorrelationCoefficients(*args):
        r"""
        Draw the correlation coefficients. 
         As correlation coefficients are considered, values might be positive or negative.

        Available usages:
            DrawCorrelationCoefficients(*correlationCoefficients, title='Correlation coefficients'*)

            DrawCorrelationCoefficients(*values, names, title='Correlation coefficients'*)

        Parameters
        ----------
        correlationCoefficients : :class:`~openturns.PointWithDescription`
            Sequence containing the correlation coefficients with a description for each
            component. The descriptions are used to build labels for the created graph.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Correlation coefficients.
        names : sequence of str
            Variables' names used to build labels for the created the graph.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Cloud` and a :class:`~openturns.Text` 
            of the correlation coefficients.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_DrawCorrelationCoefficients(*args)

    def draw(self, *args):
        r"""
        Draw sensitivity indices.

        Usage:
          draw()

          draw(*marginalIndex*)

        With the first usage, draw the aggregated first and total order indices.
        With the second usage, draw the first and total order indices of a specific marginal in case of vectorial output

        Parameters
        ----------
        marginalIndex: int
            marginal of interest (case of second usage)

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.

        Notes
        -----
        If number of bootstrap sampling is not 0, and confidence level associated > 0,
        the graph includes confidence interval plots in the first usage.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_draw(self, *args)

    def setDesign(self, inputDesign, outputDesign, size):
        r"""
        Sample accessor.

        Allows one to estimate indices from a predefined Sobol design.

        Parameters
        ----------
        inputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained
            thanks to the SobolIndicesAlgorithmImplementation.Generate method
        outputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained as the evaluation
            of a Function (model) on the previous inputDesign
        N : int
            Base size of the Sobol design
        """
        return _simulation.SobolIndicesAlgorithmImplementation_setDesign(self, inputDesign, outputDesign, size)

    def __init__(self, *args):
        _simulation.SobolIndicesAlgorithmImplementation_swiginit(self, _simulation.new_SobolIndicesAlgorithmImplementation(*args))
    __swig_destroy__ = _simulation.delete_SobolIndicesAlgorithmImplementation

# Register SobolIndicesAlgorithmImplementation in _simulation:
_simulation.SobolIndicesAlgorithmImplementation_swigregister(SobolIndicesAlgorithmImplementation)
class _SobolIndicesAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _simulation._SobolIndicesAlgorithmImplementationTypedInterfaceObject_swiginit(self, _simulation.new__SobolIndicesAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _simulation._SobolIndicesAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation._SobolIndicesAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation._SobolIndicesAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _simulation._SobolIndicesAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _simulation._SobolIndicesAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _simulation.delete__SobolIndicesAlgorithmImplementationTypedInterfaceObject

# Register _SobolIndicesAlgorithmImplementationTypedInterfaceObject in _simulation:
_simulation._SobolIndicesAlgorithmImplementationTypedInterfaceObject_swigregister(_SobolIndicesAlgorithmImplementationTypedInterfaceObject)
class SobolIndicesAlgorithm(_SobolIndicesAlgorithmImplementationTypedInterfaceObject):
    r"""

    Sensitivity analysis.

    Notes
    -----
    This method measures the influence of each component of an input random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on an output random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see [sobol1993]_).
    It computes, for every output random variable :math:`Y_k` (:math:`1 \leqslant k \leqslant n_Y`),
    the part of its variance due to each input component :math:`X_i` (:math:`1 \leqslant i \leqslant n_X`) of :math:`\vect{X}`.
    Sobol' indices are introduced in :ref:`sensitivity_sobol`. 

    Several estimators of :math:`V_i`, :math:`V_i^T` and :math:`V_{-i}` are provided by the :class:`SobolIndicesAlgorithm` implementations:

    - :class:`~openturns.SaltelliSensitivityAlgorithm` for the `Saltelli` method,
    - :class:`~openturns.JansenSensitivityAlgorithm` for the `Jansen` method,
    - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm` for the `Mauntz-Kucherenko` method,
    - :class:`~openturns.MartinezSensitivityAlgorithm` for the `Martinez` method.

    Specific formulas for :math:`\widehat{V}_i`, :math:`\widehat{V}_i^T` and :math:`\widehat{V}_{-i}` are given in the corresponding documentation pages.


    For multivariate outputs i.e. when :math:`n_Y>1`, we compute the Sobol' indices with respect to each output variable. 
    In this case, the methods :meth:`getFirstOrderIndices` and 
    :meth:`getTotalOrderIndices` return the Sobol' indices of the first output, 
    but the index of the output can be specified as input argument.
    Aggregated indices can be retrieved with the :meth:`getAggregatedFirstOrderIndices` 
    and :meth:`getAggregatedTotalOrderIndices` methods. 


    Notice that the distribution of the estimators of the first
    and total order indices can be estimated
    thanks to the :meth:`getFirstOrderIndicesDistribution` and
    :meth:`getTotalOrderIndicesDistribution` methods.
    This is done either through bootstrapping or using an asymptotic estimator.
    The :class:`~openturns.ResourceMap` key `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution`
    stores a boolean that decides the default behavior,
    but it can be overridden by the method :meth:`setUseAsymptoticDistribution`.

    Corresponding confidence intervals are provided by the methods
    :meth:`getFirstOrderIndicesInterval` and :meth:`getTotalOrderIndicesInterval`.
    Their confidence level can be adjusted with :meth:`setConfidenceLevel`.
    The default confidence level is stored in the :class:`~openturns.ResourceMap`
    and can be accessed with the `SobolIndicesAlgorithm-DefaultConfidenceLevel` key.

    Indices estimates can be slightly outside of [0,1] if the estimator has not converged.
    For the same reason some first order indices estimates can be greater than the corresponding total order indices estimates.

    The asymptotic estimator of the distribution requires an asymptotic estimate
    of its variance, which is computed using the [janon2014]_
    delta method, as expained in the technical report [pmfre01116]_.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SobolIndicesAlgorithm_getClassName(self)

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Get first order Sobol indices.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing first order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithm_getFirstOrderIndices(self, marginalIndex)

    def getFirstOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated first order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for first order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _simulation.SobolIndicesAlgorithm_getFirstOrderIndicesInterval(self)

    def getSecondOrderIndices(self, marginalIndex=0):
        r"""
        Get second order Sobol indices.

        Notes
        -----
        Let :math:`n_X \in \Nset` be the input dimension of the random vector.
        For any pair of indices :math:`i, j \in \{1, ..., n_x\}` such that :math:`i \neq j`,
        this method computes the Sobol' interaction index between :math:`i` and :math:`j`:

        .. math::
            S_{\{i, j\}} = \frac{V_{\{i,j\}}}{\Var{Y}}

        The second order Sobol' index :math:`S_{i,j}`  measures the part of
        the variance of :math:`Y` explained by the interaction of :math:`X_i` and :math:`X_j`.
        Hence, the closed Sobol' index of the group :math:`\{i, j\}` is:

        .. math::
            S_{\{i, j\}}^{\operatorname{cl}} = S_i + S_j + S_{\{i, j\}}.

        Conversely, if the closed Sobol' index :math:`S_{\{i, j\}}^{\operatorname{cl}}` is known,
        then the interaction Sobol' index can be computed from the equation:

        .. math::
            S_{\{i, j\}} = S_{\{i, j\}}^{\operatorname{cl}} - S_i - S_j.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.SymmetricMatrix`
            Tensor containing second order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithm_getSecondOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Get total order Sobol indices.

        Parameters
        ----------
        marginalIndex : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing total order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithm_getTotalOrderIndices(self, marginalIndex)

    def getTotalOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated total order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for total order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _simulation.SobolIndicesAlgorithm_getTotalOrderIndicesInterval(self)

    def getAggregatedFirstOrderIndices(self):
        r"""
        Get the evaluation of aggregated first order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated first order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithm_getAggregatedFirstOrderIndices(self)

    def getAggregatedTotalOrderIndices(self):
        r"""
        Get the evaluation of aggregated total order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated total order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithm_getAggregatedTotalOrderIndices(self)

    def getBootstrapSize(self):
        r"""
        Get the number of bootstrap sampling size.

        Returns
        -------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _simulation.SobolIndicesAlgorithm_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Set the number of bootstrap sampling size.

        Default value is 0.

        Parameters
        ----------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _simulation.SobolIndicesAlgorithm_setBootstrapSize(self, bootstrapSize)

    def getConfidenceLevel(self):
        r"""
        Get the confidence interval level for confidence intervals.

        Returns
        -------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _simulation.SobolIndicesAlgorithm_getConfidenceLevel(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Set the confidence interval level for confidence intervals.

        Parameters
        ----------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _simulation.SobolIndicesAlgorithm_setConfidenceLevel(self, confidenceLevel)

    def setUseAsymptoticDistribution(self, useAsymptoticDistribution):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Default value is set by the `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution` key.

        Parameters
        ----------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _simulation.SobolIndicesAlgorithm_setUseAsymptoticDistribution(self, useAsymptoticDistribution)

    def getUseAsymptoticDistribution(self):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Returns
        -------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _simulation.SobolIndicesAlgorithm_getUseAsymptoticDistribution(self)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated first order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for first order Sobol indices for each component.
        """
        return _simulation.SobolIndicesAlgorithm_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated total order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for total order Sobol indices for each component.
        """
        return _simulation.SobolIndicesAlgorithm_getTotalOrderIndicesDistribution(self)

    @staticmethod
    def DrawImportanceFactors(*args):
        r"""
        Draw the importance factors.

        Available usages:
            DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

            DrawImportanceFactors(*values, names, title='Importance Factors'*)

        Parameters
        ----------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component. The descriptions are used to build labels for the created Pie.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Importance factors.
        names : sequence of str
            Variables' names used to build labels for the created Pie.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Pie` of the importance factors of
            the variables.
        """
        return _simulation.SobolIndicesAlgorithm_DrawImportanceFactors(*args)

    @staticmethod
    def DrawSobolIndices(*args):
        r"""
        Draw the Sobol' indices.

        Parameters
        ----------
        inputDescription : sequence of str
            Variable names
        firstOrderIndices : sequence of float
            First order indices values
        totalOrderIndices : sequence of float
            Total order indices values
        fo_ci : :class:`~openturns.Interval`, optional
            First order indices confidence interval
        to_ci : :class:`~openturns.Interval`, optional
            Total order indices confidence interval

        Returns
        -------
        graph : :class:`~openturns.Graph`
            For each variable, draws first and total indices
        """
        return _simulation.SobolIndicesAlgorithm_DrawSobolIndices(*args)

    @staticmethod
    def DrawCorrelationCoefficients(*args):
        r"""
        Draw the correlation coefficients. 
         As correlation coefficients are considered, values might be positive or negative.

        Available usages:
            DrawCorrelationCoefficients(*correlationCoefficients, title='Correlation coefficients'*)

            DrawCorrelationCoefficients(*values, names, title='Correlation coefficients'*)

        Parameters
        ----------
        correlationCoefficients : :class:`~openturns.PointWithDescription`
            Sequence containing the correlation coefficients with a description for each
            component. The descriptions are used to build labels for the created graph.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Correlation coefficients.
        names : sequence of str
            Variables' names used to build labels for the created the graph.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Cloud` and a :class:`~openturns.Text` 
            of the correlation coefficients.
        """
        return _simulation.SobolIndicesAlgorithm_DrawCorrelationCoefficients(*args)

    def draw(self, *args):
        r"""
        Draw sensitivity indices.

        Usage:
          draw()

          draw(*marginalIndex*)

        With the first usage, draw the aggregated first and total order indices.
        With the second usage, draw the first and total order indices of a specific marginal in case of vectorial output

        Parameters
        ----------
        marginalIndex: int
            marginal of interest (case of second usage)

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.

        Notes
        -----
        If number of bootstrap sampling is not 0, and confidence level associated > 0,
        the graph includes confidence interval plots in the first usage.
        """
        return _simulation.SobolIndicesAlgorithm_draw(self, *args)

    def setDesign(self, inputDesign, outputDesign, size):
        r"""
        Sample accessor.

        Allows one to estimate indices from a predefined Sobol design.

        Parameters
        ----------
        inputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained
            thanks to the SobolIndicesAlgorithmImplementation.Generate method
        outputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained as the evaluation
            of a Function (model) on the previous inputDesign
        N : int
            Base size of the Sobol design
        """
        return _simulation.SobolIndicesAlgorithm_setDesign(self, inputDesign, outputDesign, size)

    def __repr__(self):
        return _simulation.SobolIndicesAlgorithm___repr__(self)

    def __str__(self, *args):
        return _simulation.SobolIndicesAlgorithm___str__(self, *args)

    def __init__(self, *args):
        _simulation.SobolIndicesAlgorithm_swiginit(self, _simulation.new_SobolIndicesAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_SobolIndicesAlgorithm

# Register SobolIndicesAlgorithm in _simulation:
_simulation.SobolIndicesAlgorithm_swigregister(SobolIndicesAlgorithm)
class MartinezSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Martinez method.

    Available constructors:
        MartinezSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        MartinezSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        MartinezSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    model : :class:`~openturns.Function`
        Model to evaluate input samples.
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [martinez2011]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of the first and total order Sobol' indices used by this class are respectively:

    .. math::

       \hat{S}_i & = \tilde{\rho}_n\left(\tilde{\vect{g}}(\mat{B}), \tilde{\vect{g}}(\mat{E}^i)\right) \\
       \widehat{S}_i^T & = 1 - \tilde{\rho}_n\left(\tilde{\vect{g}}(\mat{A}), \tilde{\vect{g}}(\mat{E}^i)\right) \\

    where :math:`\tilde{\rho}_n` is the modified sample correlation (under the assumption that the
    sample has a zero mean) defined, for any pair of vectors
    :math:`(\vect{z}, \vect{z}') \in \Rset^N \times \Rset^N`, by:

    .. math::

       \tilde{\rho}_n \left(\vect{z}, \vect{z}'\right) = 
       \frac{\sum_{k=1}^N z_k z_k'}
       {\sqrt{\sum_{k=1}^N z_k^2} \sqrt{\sum_{k=1}^N \left( z_k' \right)^2}}

    where :math:`\tilde{\vect{g}}` is the centered model based on the sample.

    The class constructor ``MartinezSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the ``outputDesign``, and therefore for the  ``inputDesign``.
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.



    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 10000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.MartinezSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.308902,0.459187,0.00683867]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.567786,0.430754,0.244293]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.MartinezSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _simulation.MartinezSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _simulation.MartinezSensitivityAlgorithm_swiginit(self, _simulation.new_MartinezSensitivityAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_MartinezSensitivityAlgorithm

# Register MartinezSensitivityAlgorithm in _simulation:
_simulation.MartinezSensitivityAlgorithm_swigregister(MartinezSensitivityAlgorithm)
class SaltelliSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Saltelli method.

    Available constructors:
        SaltelliSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        SaltelliSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        SaltelliSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    model : :class:`~openturns.Function`
        Model to evaluate input samples.
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [saltelli2002]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of :math:`V_i` and :math:`V_{-i}` used by this class are respectively:

    .. math::

       \widehat{V}_i & =  \frac{1}{N-1}\sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k)  \tilde{\vect{g}}(\vect{E}_k) 
       - \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k)\right) 
       \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k)\right) \\
       \widehat{V}_{-i} & =  \frac{1}{N-1}\sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k)  \tilde{\vect{g}}(\vect{E}_k) 
       - \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k)\right) 
       \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k)\right)

    where :math:`\tilde{\vect{g}}` is the centered model based on the sample. 

    The class constructor ``SaltelliSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the  ``outputDesign``, and therefore for the  ``inputDesign`` .
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.



    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 10000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.SaltelliSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.302745,0.460846,0.0066916]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.574996,0.427126,0.256689]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SaltelliSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _simulation.SaltelliSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _simulation.SaltelliSensitivityAlgorithm_swiginit(self, _simulation.new_SaltelliSensitivityAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_SaltelliSensitivityAlgorithm

# Register SaltelliSensitivityAlgorithm in _simulation:
_simulation.SaltelliSensitivityAlgorithm_swigregister(SaltelliSensitivityAlgorithm)
class JansenSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Jansen method.

    Available constructors:
        JansenSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        JansenSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        JansenSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    model : :class:`~openturns.Function`
        Model to evaluate input samples.
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [jansen1999]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of :math:`V_i` and :math:`V_i^T` used by this class are respectively:

    .. math::

       \widehat{V}_i & = \frac{1}{N-1} \sum_{k=1}^N \tilde{\vect{g}}(\vect{A}_k)^2 - \frac{1}{2N-1} \sum_{k=1}^N \left( \tilde{\vect{g}}(\vect{E}_k) - \tilde{\vect{g}}(\vect{B}_k) \right)^2 \\
       \widehat{V}_i^T & = \frac{1}{2N-1} \sum_{k=1}^N \left( \tilde{\vect{g}}(\vect{E}_k) -  \tilde{\vect{g}}(\vect{A}_k) \right)^2

    where :math:`\tilde{\vect{g}}` is the centered model based on the sample. 

    The class constructor ``JansenSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the ``outputDesign``, and therefore for the  ``inputDesign``.
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.



    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 10000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.JansenSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.322419,0.457314,0.0260925]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.55841,0.433746,0.240408]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.JansenSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _simulation.JansenSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _simulation.JansenSensitivityAlgorithm_swiginit(self, _simulation.new_JansenSensitivityAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_JansenSensitivityAlgorithm

# Register JansenSensitivityAlgorithm in _simulation:
_simulation.JansenSensitivityAlgorithm_swigregister(JansenSensitivityAlgorithm)
class MauntzKucherenkoSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using MauntzKucherenko method.

    Available constructors:
        MauntzKucherenkoSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        MauntzKucherenkoSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        MauntzKucherenkoSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    model : :class:`~openturns.Function`
        Model to evaluate input samples.
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [sobol2007]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of :math:`V_i` and :math:`V_{-i}` used by this class are respectively:

    .. math::

       \widehat{V}_i & = \frac{1}{N-1} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k) \left( \tilde{\vect{g}}(\vect{E}_k) - \tilde{\vect{g}}(\vect{A}_k) \right) \\
       \widehat{VT}_{i} & = \frac{1}{N-1} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k) \left( \tilde{\vect{g}}(\vect{A}_k) -  \tilde{\vect{g}}(\vect{E}_k) \right)

    where :math:`\tilde{\vect{g}}` is the centered model based on the sample. 

    The class constructor ``MauntzKucherenkoSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the ``outputDesign``, and therefore for the  ``inputDesign``.
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 100000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.MauntzKucherenkoSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.311678,0.439075,0.00401876]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.556564,0.439185,0.24036]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.MauntzKucherenkoSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _simulation.MauntzKucherenkoSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _simulation.MauntzKucherenkoSensitivityAlgorithm_swiginit(self, _simulation.new_MauntzKucherenkoSensitivityAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_MauntzKucherenkoSensitivityAlgorithm

# Register MauntzKucherenkoSensitivityAlgorithm in _simulation:
_simulation.MauntzKucherenkoSensitivityAlgorithm_swigregister(MauntzKucherenkoSensitivityAlgorithm)
class SobolIndicesExperiment(openturns.weightedexperiment.WeightedExperimentImplementation):
    r"""
    Experiment to computeSobol' indices.

    Available constructors:
        SobolIndicesExperiment(*distribution, size, computeSecondOrder=False*)

        SobolIndicesExperiment(*experiment, computeSecondOrder=False*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Size :math:`N` of each of the two independent initial samples.
        For the total size of the experiment see notes below.
    experiment : :class:`~openturns.WeightedExperiment`
        Design of experiment used to sample the distribution.
    computeSecondOrder : bool, defaults to False
        Whether to add points to compute second order indices

    Notes
    -----
    Sensitivity algorithms rely on the definition of specific designs.

    The :meth:`generate` method of this class produces a :class:`~openturns.Sample`
    to be supplied to the constructor of one of the :class:`~openturns.SobolIndicesAlgorithm` implementations:

    - :class:`~openturns.SaltelliSensitivityAlgorithm`,
    - :class:`~openturns.MartinezSensitivityAlgorithm`,
    - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm`,
    - :class:`~openturns.JansenSensitivityAlgorithm`.

    The chosen :class:`~openturns.SobolIndicesAlgorithm` implementation then uses the sample as *input design*,
    which means it represents (but is not a realization of) a random vector :math:`\vect{X} = \left( X^1, \ldots, X^{n_X} \right)`.

    Either the :class:`~openturns.Distribution` of :math:`\vect{X}`
    or a :class:`~openturns.WeightedExperiment` that represents it
    must be supplied to the class constructor.

    If a :class:`~openturns.WeightedExperiment` is supplied, the class uses it directly.

    If the distribution of :math:`\vect{X}` is supplied, the class generates a :class:`~openturns.WeightedExperiment`.
    To do this, it duplicates the distribution: every marginal is repeated once to produce
    a :math:`2 n_X`-dimensional distribution.
    This trick makes it possible to choose a :class:`~openturns.WeightedExperiment` with non-iid samples
    (that is a :class:`~openturns.LHSExperiment` or a :class:`~openturns.LowDiscrepancyExperiment`)
    to represent the original :math:`n_X`-dimensional distribution.

    The type of :class:`~openturns.WeightedExperiment` depends on the value of ``'SobolIndicesExperiment-SamplingMethod'`` in the :class:`~openturns.ResourceMap`:

        - ``'MonteCarlo'`` for a :class:`~openturns.MonteCarloExperiment`.
        - ``'LHS'`` for an :class:`~openturns.LHSExperiment` with *alwaysShuffle* and *randomShift* set to *True*.
        - ``'QMC'`` for a :class:`~openturns.LowDiscrepancyExperiment` (with *randomize* flag set to *False*) built from a :class:`~openturns.SobolSequence`.

    ``'MonteCarlo'`` is the default choice because it allows the chosen :class:`~openturns.SobolIndicesAlgorithm` implementation to use the asymptotic distribution of the estimators of the Sobol' indices.

    Note that ``'QMC'`` is only possible if :math:`2 n_X \leqslant` :class:`~openturns.SobolSequence`:code:`.MaximumDimension`.
    If ``'QMC'`` is specified but :math:`2 n_X >` :class:`~openturns.SobolSequence`:code:`.MaximumDimension`, the class falls back to ``'LHS'``.

    >>> from openturns import SobolSequence
    >>> print(SobolSequence.MaximumDimension)
    1111

    Regardless of the type of :class:`~openturns.WeightedExperiment`,
    the class splits it into two samples with the same size :math:`N`:
    :math:`\mat{A}` and :math:`\mat{B}`.
    Their columns are mixed in order to produce a very large sample: the *inputDesign* argument
    taken by one of the constructors of every :class:`~openturns.SobolIndicesAlgorithm` implementation.

    If *computeSecondOrder* is set to *False*, the input design is of size :math:`N(2+n_X)`.
    The first :math:`N` rows contain the sample :math:`\mat{A}` and the next :math:`N` rows the sample :math:`\mat{B}`.
    The last :math:`N n_X` rows contain :math:`n_X` copies of :math:`\mat{A}`,
    each with a different column replaced by the corresponding column from :math:`\mat{B}`
    (they are the matrices :math:`\mat{E}^i` from the documentation page of :class:`~openturns.SobolIndicesAlgorithm`).

    If *computeSecondOrder* is set to *True* and :math:`n_X = 2`, the input design is the same as in
    the case where *computeSecondOrder* is *False* (see [saltelli2002]_).

    If *computeSecondOrder* is set to *True* and :math:`n_X \neq 2`, the input design size is :math:`N(2+2 n_X)`.
    The first :math:`N(2+n_X)` rows are the same as when *computeSecondOrder* is *False*.
    The last :math:`N n_X` rows contain :math:`n_X` copies of :math:`\mat{B}`,
    each with a different column replaced by the corresponding column from :math:`\mat{A}`
    (they are the matrices :math:`\mat{C}^i` from the documentation page of :class:`~openturns.SobolIndicesAlgorithm`).

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Create a sample suitable to estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> size = 10
    >>> experiment = ot.SobolIndicesExperiment(distribution, size)
    >>> sample = experiment.generate()

    Create a sample suitable to estimate first, total order and second order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> size = 10
    >>> computeSecondOrder = True
    >>> experiment = ot.SobolIndicesExperiment(distribution, size, computeSecondOrder)
    >>> sample = experiment.generate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SobolIndicesExperiment_getClassName(self)

    def __repr__(self):
        return _simulation.SobolIndicesExperiment___repr__(self)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`\sampleSize` of points constituting the design of experiments.
        """
        return _simulation.SobolIndicesExperiment_setSize(self, size)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _simulation.SobolIndicesExperiment_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _simulation.SobolIndicesExperiment_getDistribution(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _simulation.SobolIndicesExperiment_hasUniformWeights(self)

    def generateWithWeights(self, weights):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _simulation.SobolIndicesExperiment_generateWithWeights(self, weights)

    def getWeightedExperiment(self):
        r"""
        Experiment accessor.

        Returns
        -------
        experiment : :class:`~openturns.WeightedExperiment`
            The internal experiment.
        """
        return _simulation.SobolIndicesExperiment_getWeightedExperiment(self)

    def __init__(self, *args):
        _simulation.SobolIndicesExperiment_swiginit(self, _simulation.new_SobolIndicesExperiment(*args))
    __swig_destroy__ = _simulation.delete_SobolIndicesExperiment

# Register SobolIndicesExperiment in _simulation:
_simulation.SobolIndicesExperiment_swigregister(SobolIndicesExperiment)
class SimulationResult(openturns.common.PersistentObject):
    r"""
    EventSimulation result base class.

    Notes
    -----
    Structure created by the method run() of a :class:`~openturns.EventSimulation`,
    and obtained thanks to the method getResult().
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SimulationResult_getClassName(self)

    def getOuterSampling(self):
        r"""
        Accessor to the outer sampling.

        Returns
        -------
        outerSampling : int
            Number of groups of terms in the probability simulation estimator.
        """
        return _simulation.SimulationResult_getOuterSampling(self)

    def setOuterSampling(self, outerSampling):
        r"""
        Accessor to the outer sampling.

        Parameters
        ----------
        outerSampling : int, :math:`outerSampling \geq 0`
            Number of groups of terms in the probability simulation estimator.
        """
        return _simulation.SimulationResult_setOuterSampling(self, outerSampling)

    def getBlockSize(self):
        r"""
        Accessor to the block size.

        Returns
        -------
        blockSize : int
            Number of terms in the probability simulation estimator grouped together.
        """
        return _simulation.SimulationResult_getBlockSize(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 0`
            Number of terms in the probability simulation estimator grouped together.
        """
        return _simulation.SimulationResult_setBlockSize(self, blockSize)

    def setTimeDuration(self, time):
        r"""
        Accessor to the elapsed time.

        Parameters
        ----------
        time : float
            Simulation duration in seconds
        """
        return _simulation.SimulationResult_setTimeDuration(self, time)

    def getTimeDuration(self):
        r"""
        Accessor to the elapsed time.

        Returns
        -------
        time : float
            Simulation duration in seconds
        """
        return _simulation.SimulationResult_getTimeDuration(self)

    def __repr__(self):
        return _simulation.SimulationResult___repr__(self)

    def __init__(self, *args):
        _simulation.SimulationResult_swiginit(self, _simulation.new_SimulationResult(*args))
    __swig_destroy__ = _simulation.delete_SimulationResult

# Register SimulationResult in _simulation:
_simulation.SimulationResult_swigregister(SimulationResult)
class ProbabilitySimulationResult(SimulationResult):
    r"""
    Probability simulation result.

    Notes
    -----
    Structure created by the method run() of a :class:`~openturns.EventSimulation`,
    and obtained thanks to the method getResult().

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> limitState = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3.*E*I)'])
    >>> # Enable the history mechanism in order to use the getImportanceFactors method
    >>> limitState = ot.MemoizeFunction(limitState)
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> output = ot.CompositeRandomVector(limitState, ot.RandomVector(distribution))
    >>> event = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> experiment = ot.MonteCarloExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> importanceFactors = result.getImportanceFactors()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.ProbabilitySimulationResult_getClassName(self)

    def getEvent(self):
        r"""
        Accessor to the event.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _simulation.ProbabilitySimulationResult_getEvent(self)

    def setEvent(self, event):
        r"""
        Accessor to the event.

        Parameters
        ----------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _simulation.ProbabilitySimulationResult_setEvent(self, event)

    def getProbabilityEstimate(self):
        r"""
        Accessor to the probability estimate.

        Returns
        -------
        probaEstimate : float
            Estimate of the event probability.
        """
        return _simulation.ProbabilitySimulationResult_getProbabilityEstimate(self)

    def setProbabilityEstimate(self, probabilityEstimate):
        r"""
        Accessor to the probability estimate.

        Parameters
        ----------
        probaEstimate : float, :math:`0 \leq P_e \leq 1`
            Estimate of the event probability.
        """
        return _simulation.ProbabilitySimulationResult_setProbabilityEstimate(self, probabilityEstimate)

    def getVarianceEstimate(self):
        r"""
        Accessor to the variance estimate.

        Returns
        -------
        varianceEstimate : float
            Variance estimate.
        """
        return _simulation.ProbabilitySimulationResult_getVarianceEstimate(self)

    def setVarianceEstimate(self, varianceEstimate):
        r"""
        Accessor to the variance estimate.

        Parameters
        ----------
        varianceEstimate : float, :math:`Var_e \geq 0`
            Variance estimate.
        """
        return _simulation.ProbabilitySimulationResult_setVarianceEstimate(self, varianceEstimate)

    def getProbabilityDistribution(self):
        r"""
        Accessor to the asymptotic probability distribution.

        Returns
        -------
        probaDistribution : :class:`~openturns.Normal`
            Asymptotic normal distribution of the event probability estimate.
        """
        return _simulation.ProbabilitySimulationResult_getProbabilityDistribution(self)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _simulation.ProbabilitySimulationResult_getCoefficientOfVariation(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the standard deviation.

        Returns
        -------
        sigma : float
            Standard deviation of the estimator at the end of the simulation.
        """
        return _simulation.ProbabilitySimulationResult_getStandardDeviation(self)

    def getMeanPointInEventDomain(self):
        r"""
        Accessor to the mean point conditioned to the event realization.

        Returns
        -------
        meanPoint : :class:`~openturns.Point`
            Mean point in the physical space of all the simulations generated by the
            :class:`~openturns.EventSimulation` algorithm that failed into the event domain.

        Notes
        -----
        .. warning::
            This notion is only available if the history mechanism of the model is
            activated (see :class:`~openturns.MemoizeFunction`).
        """
        return _simulation.ProbabilitySimulationResult_getMeanPointInEventDomain(self)

    def getImportanceFactors(self):
        r"""
        Accessor to the importance factors.

        Returns
        -------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component.

        Notes
        -----
        The importance factors :math:`\alpha_i` are evaluated from the coordinates of
        the mean point of event domain :math:`\vect{X}^*_{event}`, mapped into the
        standard space as follows:

        .. math::

          \alpha_i = \displaystyle \frac{\left(U_{i}^*\right)^2}{||\vect{U}^*||^2}

        where :math:`\vect{U}^* = T(\vect{X}^*_{event})`
        with :math:`T` the iso-probabilistic transformation and the mean point
        :math:`\vect{X}^*_{event} = \displaystyle \frac{1}{n} \sum_{i=1}^{n} \vect{X}_i 1_{event}(\vect{X}_i)`.

        .. warning::
            This notion is only available if the history mechanism of the model is
            activated (see :class:`~openturns.MemoizeFunction`).

        See also
        --------
        drawImportanceFactors
        """
        return _simulation.ProbabilitySimulationResult_getImportanceFactors(self)

    def drawImportanceFactors(self):
        r"""
        Draw the importance factors.

        .. warning::
            It is necessary to enable the history of the model to perform this analysis
            (see :class:`~openturns.MemoizeFunction`).

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Importance factor graph.

        See also
        --------
        getImportanceFactors
        """
        return _simulation.ProbabilitySimulationResult_drawImportanceFactors(self)

    def getConfidenceLength(self, *args):
        r"""
        Accessor to the confidence length.

        Parameters
        ----------
        level : float, :math:`level \in ]0, 1[`
            Confidence level. By default, it is :math:`0.95`.

        Returns
        -------
        confidenceLength : float
            Length of the confidence interval at the confidence level *level*.
        """
        return _simulation.ProbabilitySimulationResult_getConfidenceLength(self, *args)

    def __repr__(self):
        return _simulation.ProbabilitySimulationResult___repr__(self)

    def __init__(self, *args):
        _simulation.ProbabilitySimulationResult_swiginit(self, _simulation.new_ProbabilitySimulationResult(*args))
    __swig_destroy__ = _simulation.delete_ProbabilitySimulationResult

# Register ProbabilitySimulationResult in _simulation:
_simulation.ProbabilitySimulationResult_swigregister(ProbabilitySimulationResult)
class SimulationAlgorithm(openturns.common.PersistentObject):
    r"""
    Base class for simulation algorithms.

    See also
    --------
    ProbabilitySimulationAlgorithm, ExpectationSimulationAlgorithm
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SimulationAlgorithm_getClassName(self)

    def setMaximumOuterSampling(self, maximumOuterSampling):
        r"""
        Accessor to the maximum iterations number.

        Parameters
        ----------
        outerSampling : int
            Maximum number of iterations, each iteration performing a block of evaluations.
        """
        return _simulation.SimulationAlgorithm_setMaximumOuterSampling(self, maximumOuterSampling)

    def getMaximumOuterSampling(self):
        r"""
        Accessor to the maximum iterations number.

        Returns
        -------
        outerSampling : int
            Maximum number of iterations, each iteration performing a block of evaluations.
        """
        return _simulation.SimulationAlgorithm_getMaximumOuterSampling(self)

    def setMaximumCoefficientOfVariation(self, maximumCoefficientOfVariation):
        r"""
        Accessor to the maximum coefficient of variation.

        Parameters
        ----------
        coefficient : float
            Maximum coefficient of variation of the simulated sample.
        """
        return _simulation.SimulationAlgorithm_setMaximumCoefficientOfVariation(self, maximumCoefficientOfVariation)

    def getMaximumCoefficientOfVariation(self):
        r"""
        Accessor to the maximum coefficient of variation.

        Returns
        -------
        coefficient : float
            Maximum coefficient of variation of the simulated sample.
        """
        return _simulation.SimulationAlgorithm_getMaximumCoefficientOfVariation(self)

    def setMaximumStandardDeviation(self, maximumStandardDeviation):
        r"""
        Accessor to the maximum standard deviation.

        Parameters
        ----------
        sigma : float, :math:`\sigma > 0`
            Maximum standard deviation of the estimator.
        """
        return _simulation.SimulationAlgorithm_setMaximumStandardDeviation(self, maximumStandardDeviation)

    def getMaximumStandardDeviation(self):
        r"""
        Accessor to the maximum standard deviation.

        Returns
        -------
        sigma : float, :math:`\sigma > 0`
            Maximum standard deviation of the estimator.
        """
        return _simulation.SimulationAlgorithm_getMaximumStandardDeviation(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 1`
            Number of simultaneous evaluations of the limit-state function.
            It is set by default to 1.

        Notes
        -----
        If the function supports batch evaluations this parameter can be set to the number
        of available CPUs to benefit from parallel execution (multithreading, multiprocessing, ...);
        except for the Directional Sampling, where we recommend to set it to 1.
        It also decides the frequency of the stopping criteria and progress callbacks update
        as they are called once the whole block of fonction evaluations is completed.

        """
        return _simulation.SimulationAlgorithm_setBlockSize(self, blockSize)

    def getBlockSize(self):
        r"""
        Accessor to the block size.

        Returns
        -------
        blockSize : int
            Number of simultaneous evaluations of the limit-state function.
            It is set by default to 1.
        """
        return _simulation.SimulationAlgorithm_getBlockSize(self)

    def __repr__(self):
        return _simulation.SimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.SimulationAlgorithm_run(self)

    def setConvergenceStrategy(self, convergenceStrategy):
        r"""
        Accessor to the convergence strategy.

        Parameters
        ----------
        storage_strategy : :class:`~openturns.HistoryStrategy`
            Storage strategy used to store the values of the probability estimator
            and its variance during the simulation algorithm.
        """
        return _simulation.SimulationAlgorithm_setConvergenceStrategy(self, convergenceStrategy)

    def getConvergenceStrategy(self):
        r"""
        Accessor to the convergence strategy.

        Returns
        -------
        storage_strategy : :class:`~openturns.HistoryStrategy`
            Storage strategy used to store the values of the probability estimator
            and its variance during the simulation algorithm.
        """
        return _simulation.SimulationAlgorithm_getConvergenceStrategy(self)

    def setMaximumTimeDuration(self, maximumTimeDuration):
        r"""
        Accessor to the maximum duration.

        Parameters
        ----------
        maximumTimeDuration : float
            Maximum optimization duration in seconds.
        """
        return _simulation.SimulationAlgorithm_setMaximumTimeDuration(self, maximumTimeDuration)

    def getMaximumTimeDuration(self):
        r"""
        Accessor to the maximum duration.

        Returns
        -------
        maximumTimeDuration : float
            Maximum optimization duration in seconds.
        """
        return _simulation.SimulationAlgorithm_getMaximumTimeDuration(self)

    def __init__(self, *args):
        _simulation.SimulationAlgorithm_swiginit(self, _simulation.new_SimulationAlgorithm(*args))

    def setProgressCallback(self, *args):
        r"""
        Set up a progress callback.

        Can be used to programmatically report the progress of a simulation.

        Parameters
        ----------
        callback : callable
            Takes a float as argument as percentage of progress.

        Examples
        --------
        >>> import sys
        >>> import openturns as ot
        >>> experiment = ot.MonteCarloExperiment()
        >>> X = ot.RandomVector(ot.Normal())
        >>> Y = ot.CompositeRandomVector(ot.SymbolicFunction(['X'], ['1.1*X']), X)
        >>> event = ot.ThresholdEvent(Y, ot.Less(), -2.0)
        >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
        >>> algo.setMaximumOuterSampling(100)
        >>> algo.setMaximumCoefficientOfVariation(-1.0)
        >>> def report_progress(progress):
        ...     sys.stderr.write('-- progress=' + str(progress) + '%\n')
        >>> algo.setProgressCallback(report_progress)
        >>> algo.run()
        """
        return _simulation.SimulationAlgorithm_setProgressCallback(self, *args)

    def setStopCallback(self, *args):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop a simulation.

        Parameters
        ----------
        callback : callable
            Returns an int deciding whether to stop or continue.
        """
        return _simulation.SimulationAlgorithm_setStopCallback(self, *args)
    __swig_destroy__ = _simulation.delete_SimulationAlgorithm

# Register SimulationAlgorithm in _simulation:
_simulation.SimulationAlgorithm_swigregister(SimulationAlgorithm)
class EventSimulation(SimulationAlgorithm):
    r"""
    Base class for sampling methods.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        The event we are computing the probability of.
    convergenceStrategy : :class:`~openturns.HistoryStrategy`, optional
        Storage strategy used to store the values of the probability estimator and
        its variance during the simulation algorithm.

    Notes
    -----
    Base class for sampling methods, using the probability distribution of a random
    vector :math:`\vect{X}` to evaluate the failure probability:

    .. math::

        P_f = \int_{\Rset^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \leq 0 \}}f_{\uX}(\ux)\di{\ux}
            = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\}`.
    :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise.

    The EventSimulation object provides a generic simulation service for non-composite
    events, and its derived classes provide dedicated algorithms:

    - :class:`~openturns.ProbabilitySimulationAlgorithm`

    - :class:`~openturns.DirectionalSampling`

    - :class:`~openturns.PostAnalyticalControlledImportanceSampling`,

    - :class:`~openturns.PostAnalyticalImportanceSampling`,

    See also
    --------
    SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.EventSimulation_getClassName(self)

    def __init__(self, *args):
        _simulation.EventSimulation_swiginit(self, _simulation.new_EventSimulation(*args))

    def getEvent(self):
        r"""
        Accessor to the event.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _simulation.EventSimulation_getEvent(self)

    def getResult(self):
        r"""
        Accessor to the results.

        Returns
        -------
        results : :class:`~openturns.SimulationResult`
            Structure containing all the results obtained after simulation and created
            by the method :py:meth:`run`.
        """
        return _simulation.EventSimulation_getResult(self)

    def __repr__(self):
        return _simulation.EventSimulation___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        openturns.EventSimulation.setBlockSize
        openturns.EventSimulation.setMaximumOuterSampling
        openturns.ResourceMap
        openturns.SimulationResult
        """
        return _simulation.EventSimulation_run(self)

    def drawProbabilityConvergence(self, *args):
        r"""
        Draw the probability convergence at a given level.

        Parameters
        ----------
        level : float, optional
            The probability convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            probability convergence graph
        """
        return _simulation.EventSimulation_drawProbabilityConvergence(self, *args)
    __swig_destroy__ = _simulation.delete_EventSimulation

# Register EventSimulation in _simulation:
_simulation.EventSimulation_swigregister(EventSimulation)
class ProbabilitySimulationAlgorithm(EventSimulation):
    r"""
    Iterative sampling methods.

    Refer to :ref:`monte_carlo_simulation`, :ref:`importance_simulation`, :ref:`lhs_simulation`, :ref:`qmc_simulation`.

    Available constructor:
        ProbabilitySimulationAlgorithm(*event, experiment, convergenceStrategy=ot.Compact()*)

        ProbabilitySimulationAlgorithm(*event, convergenceStrategy=ot.Compact()*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        The event we are computing the probability of, must be composite.
    experiment : :class:`~openturns.WeightedExperiment`
        Sequential experiment
    convergenceStrategy : :class:`~openturns.HistoryStrategy`, optional
        Storage strategy used to store the values of the probability estimator and
        its variance during the simulation algorithm.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event 

    .. math::

        \cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\} 

    If we have the set :math:`\left\{ \vect{x}_1,\ldots,\vect{x}_N \right\}` of
    :math:`N` independent samples of the random vector :math:`\vect{X}`, we can
    estimate :math:`\widehat{P}_f` as follows:

    .. math::

        \widehat{P}_{f,MC} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }

    where :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise;
    the idea here is in fact to estimate the required probability by the proportion
    of cases, among the :math:`N` samples of :math:`\vect{X}`, for which the event
    :math:`\cD_f` occurs.

    By the law of large numbers, we know that this estimation converges to the
    required value :math:`P_f` as the sample size :math:`N` tends to infinity.

    The Central Limit Theorem allows one to build an asymptotic confidence interval
    using the normal limit distribution as follows:

    .. math::

        \lim_{N\rightarrow\infty}\Prob{P_f\in[\widehat{P}_{f,\inf},\widehat{P}_{f,\sup}]}=\alpha

    with :math:`\widehat{P}_{f,\inf}=\widehat{P}_f - q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`,
    :math:`\widehat{P}_{f,\sup}=\widehat{P}_f + q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`
    and :math:`q_\alpha` is the :math:`(1+\alpha)/2`-quantile of the standard
    normal distribution.


    A ProbabilitySimulationAlgorithm object makes sense with the following sequential experiments:

    - :class:`~openturns.MonteCarloExperiment`

    - :class:`~openturns.ImportanceSamplingExperiment`

    - :class:`~openturns.LowDiscrepancyExperiment`

    - :class:`~openturns.LHSExperiment`

    The estimator built by Monte Carlo method is:

    .. math::

        \widehat{P}_{f,MC} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }

    where :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise;
    the idea here is in fact to estimate the required probability by the proportion
    of cases, among the :math:`N` samples of :math:`\vect{X}`, for which the event
    :math:`\cD_f` occurs.

    By the law of large numbers, we know that this estimation converges to the
    required value :math:`P_f` as the sample size :math:`N` tends to infinity.

    The Central Limit Theorem allows one to build an asymptotic confidence interval
    using the normal limit distribution as follows:

    .. math::

        \lim_{N\rightarrow\infty}\Prob{P_f\in[\widehat{P}_{f,\inf},\widehat{P}_{f,\sup}]}=\alpha

    with :math:`\widehat{P}_{f,\inf}=\widehat{P}_f - q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`,
    :math:`\widehat{P}_{f,\sup}=\widehat{P}_f + q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`
    and :math:`q_\alpha` is the :math:`(1+\alpha)/2`-quantile of the standard
    normal distribution.

    The estimator built by Importance Sampling method is:

    .. math::

        \widehat{P}_{f,IS} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{\{g(\vect{Y}_{\:i}),\vect{d}) \leq 0 \}}
                                          \frac{f_{\uX}(\vect{Y}_{\:i})}
                                               {f_{\vect{Y}}(\vect{Y}_{\:i})}


    where:

    - :math:`N` is the total number of computations,

    - the random vectors :math:`\{\vect{Y}_i, i=1\hdots N\}` are independent,
      identically distributed and following the probability density function
      :math:`f_{\uY}`.


    See also
    --------
    EventSimulation

    Examples
    --------
    Estimate a probability by Monte Carlo

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.CompositeRandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> event = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> # We create a Monte Carlo algorithm
    >>> experiment = ot.MonteCarloExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.140000

    Estimate a probability by Importance Sampling

    >>> ot.RandomGenerator.SetSeed(0)
    >>> # assume we obtained a design point from FORM
    >>> standardSpaceDesignPoint = [-0.0310363,0.841879,0.445462,-0.332318]
    >>> standardEvent = ot.StandardEvent(event)
    >>> importanceDensity = ot.Normal(standardSpaceDesignPoint, ot.CovarianceMatrix(4))
    >>> experiment = ot.ImportanceSamplingExperiment(importanceDensity)
    >>> algo = ot.ProbabilitySimulationAlgorithm(standardEvent, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.153315

    Estimate a probability by Quasi Monte Carlo

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LowDiscrepancyExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.141667

    Estimate a probability by Randomized Quasi Monte Carlo

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LowDiscrepancyExperiment()
    >>> experiment.setRandomize(True)
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.160000

    Estimate a probability by Randomized LHS

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment()
    >>> experiment.setAlwaysShuffle(True)
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.140000
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.ProbabilitySimulationAlgorithm_getClassName(self)

    def __init__(self, *args):
        _simulation.ProbabilitySimulationAlgorithm_swiginit(self, _simulation.new_ProbabilitySimulationAlgorithm(*args))

    def getExperiment(self):
        r"""
        Accessor to the experiment.

        Returns
        -------
        experiment : :class:`~openturns.WeightedExperiment`
            The experiment that is sampled at each iteration.
        """
        return _simulation.ProbabilitySimulationAlgorithm_getExperiment(self)

    def setExperiment(self, experiment):
        r"""
        Accessor to the experiment.

        Parameters
        ----------
        experiment : :class:`~openturns.WeightedExperiment`
            The experiment that is sampled at each iteration.
        """
        return _simulation.ProbabilitySimulationAlgorithm_setExperiment(self, experiment)

    def __repr__(self):
        return _simulation.ProbabilitySimulationAlgorithm___repr__(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 1`
            Number of simultaneous evaluations of the limit-state function.
            It is set by default to 1.

        Notes
        -----
        If the function supports batch evaluations this parameter can be set to the number
        of available CPUs to benefit from parallel execution (multithreading, multiprocessing, ...);
        except for the Directional Sampling, where we recommend to set it to 1.
        It also decides the frequency of the stopping criteria and progress callbacks update
        as they are called once the whole block of fonction evaluations is completed.

        """
        return _simulation.ProbabilitySimulationAlgorithm_setBlockSize(self, blockSize)
    __swig_destroy__ = _simulation.delete_ProbabilitySimulationAlgorithm

# Register ProbabilitySimulationAlgorithm in _simulation:
_simulation.ProbabilitySimulationAlgorithm_swigregister(ProbabilitySimulationAlgorithm)
class PostAnalyticalSimulation(EventSimulation):
    r"""
    Post analytical simulation.

    See also
    --------
    PostAnalyticalImportanceSampling, PostAnalyticalControlledImportanceSampling

    Notes
    -----
    This class inherits from EventSimulation.

    The principle is to perform a simulation study to evaluate the threshold
    exceedance probability according to an importance density centered around the
    design point, in the standard space. The importance distribution is the standard
    distribution of the standard space.

    A PostAnalyticalSimulation object can be created only through its derivative
    classes : :class:`~openturns.PostAnalyticalImportanceSampling` or
    :class:`~openturns.PostAnalyticalControlledImportanceSampling`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.PostAnalyticalSimulation_getClassName(self)

    def getAnalyticalResult(self):
        r"""
        Accessor to the analytical result.

        Returns
        -------
        result : :class:`~openturns.AnalyticalResult`
            Result of the analytical study which has been performed just before the 
            simulation study centered around the importance factor.
        """
        return _simulation.PostAnalyticalSimulation_getAnalyticalResult(self)

    def getControlProbability(self):
        r"""
        Accessor to the control probability.

        Returns
        -------
        p : float,
            The probability of the analytical result.

        Notes
        -----
        The control probability :math:`p` is deduced from the corresponding analytical result:

        .. math::

            p = E(-\beta_{HL})

        where :math:`\beta_{HL}` denotes the Hasofer reliability index and :math:`E`
        the univariate standard CDF of the elliptical distribution in the standard space.
        """
        return _simulation.PostAnalyticalSimulation_getControlProbability(self)

    def __repr__(self):
        return _simulation.PostAnalyticalSimulation___repr__(self)

    def __init__(self, *args):
        _simulation.PostAnalyticalSimulation_swiginit(self, _simulation.new_PostAnalyticalSimulation(*args))
    __swig_destroy__ = _simulation.delete_PostAnalyticalSimulation

# Register PostAnalyticalSimulation in _simulation:
_simulation.PostAnalyticalSimulation_swigregister(PostAnalyticalSimulation)
class Wilks(openturns.common.Object):
    r"""
    Class to estimate a confidence interval on a quantile.

    Refer to :ref:`quantile_confidence_estimation`.

    Parameters
    ----------
    X : :class:`~openturns.RandomVector`,
        A random vector of dimension 1.

    Notes
    -----
    This static class estimates an upper bound of the quantile of level :math:`\alpha \in [0,1]` of the random variable :math:`X`
    with a confidence greater than :math:`\beta`, using a given order statistics.

    Let :math:`x_{\alpha}` be the unknown quantile of level :math:`\alpha` of the random variable :math:`X` of dimension 1.
    Let :math:`(X_1, \dots, X_\sampleSize)` be a sample of independent and identically distributed variables according to :math:`X`.
    Let :math:`X_{(k)}` be the :math:`k` -th order statistics of :math:`(X_1, \dots, X_\sampleSize)` which means that
    :math:`X_{(k)}` is the :math:`k` -th maximum of :math:`(X_1, \dots, X_\sampleSize)` for :math:`1 \leq k \leq \sampleSize`.
    For example, :math:`X_{(1)} = \min (X_1, \dots, X_\sampleSize)` is the minimum
    and :math:`X_{(\sampleSize)} = \max (X_1, \dots, X_\sampleSize)` is the maximum. We have:

    .. math::

        X_{(1)} \leq X_{(2)} \leq \dots \leq X_{(\sampleSize)}

    Given :math:`\alpha`, :math:`\beta` and :math:`i`, the class estimates the minimal size :math:`\sampleSize` such that:

    .. math::

        \Prob{x_{\alpha} \leq X_{(\sampleSize-i)}} \geq \beta

    Once the minimal size :math:`\sampleSize`  has been estimated, a sample of size :math:`\sampleSize` can be generated from
    :math:`X` and an upper bound of :math:`x_{\alpha}` is estimated by the value of the :math:`X_{(\sampleSize-i)}` on the sample.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex=0):
        r"""
        Evaluate the minimum size of the sample.

        Parameters
        ----------
        alpha : positive float in :math:`[0,1)`
            The level :math:`\alpha` of the quantile.
        beta : positive float in :math:`[0,1)`,
            The confidence level on the upper bound.
        i : int
            The index such that :math:`X_{(\sampleSize -i)}` is an upper bound of :math:`x_{\alpha}`
            with confidence :math:`\beta`.
            Default value is :math:`i = 0`.

        Returns
        -------
        n : int,
            The minimum size of the sample.

        Notes
        -----
        The minimum sample size :math:`\sampleSize` is such that:

        .. math::

            \Prob{x_{\alpha} \leq X_{(\sampleSize-i)}} \geq \beta

        """
        return _simulation.Wilks_ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex)

    def computeQuantileBound(self, quantileLevel, confidenceLevel, marginIndex=0):
        r"""
        Evaluate an upper bound of a quantile.

        Parameters
        ----------
        alpha : positive float in :math:`[0,1)`
            The level :math:`\alpha` of the quantile.
        beta : positive float in :math:`[0,1)`
            The confidence level on the upper bound.
        i : int
            The index such that :math:`X_{(\sampleSize -i)}` is an upper bound of :math:`x_{\alpha}`
            with confidence level :math:`\beta`.
            Default value is :math:`i = 0`.

        Returns
        -------
        upperBound : :class:`~openturns.Point`
            The estimate of the quantile upper bound.

        Notes
        -----
        The method starts by evaluating the minimum sample size :math:`\sampleSize` such that:

        .. math::

            \Prob{x_{\alpha} \leq X_{(\sampleSize-i)}} \geq \beta

        Then, it generates a sample of size  :math:`\sampleSize` from the random vector :math:`X`. The upper bound of :math:`x_{\alpha}`
        is :math:`x_{(\sampleSize-i)}`, that is, the :math:`\sampleSize - i`-th observation in the ordered sample.

        """
        return _simulation.Wilks_computeQuantileBound(self, quantileLevel, confidenceLevel, marginIndex)

    def __init__(self, *args):
        _simulation.Wilks_swiginit(self, _simulation.new_Wilks(*args))
    __swig_destroy__ = _simulation.delete_Wilks

# Register Wilks in _simulation:
_simulation.Wilks_swigregister(Wilks)
class PostAnalyticalControlledImportanceSampling(PostAnalyticalSimulation):
    r"""
    Post analytical controlled importance sampling.

    Importance sampling algorithm around the design point, controlled by
    the tangent hyperplane.

    Parameters
    ----------
    analyticalResult : :class:`~openturns.AnalyticalResult`
        Result structure.

    Notes
    -----
    Let :math:`\inputRV` be a random vector of dimension :math:`\inputDim`, distributed according to
    the measure :math:`\inputMeasure`, and :math:`\model: \Rset^\inputDim \rightarrow \Rset`
    be the *limit state function* (where we only wrote the random input parameters). We define the event
    :math:`\cD_f` by:

    .. math::

        \cD_f = \{\vect{x} \in \Rset^{\inputDim} \, | \,\model(\vect{x}) \leq 0\}

    The post analytical controlled importance sampling algorithm estimates the probability of the domain :math:`\cD_f`:

    .. math::

        P_f = \Prob{\model\left( \inputRV \right) \leq 0}
            = \int_{\Rset^{\inputDim}} \mathbf{1}_{\{\model(\vect{x}) \leq 0 \}}\inputMeasure(\vect{x})\di{\vect{x}}


    The post analytical controlled importance sampling algorithm is  a variance reduction sampling
    method, which is
    performed in the standard space, where the random vector follows a spherical distribution (see
    :ref:`isoprobabilistic_transformation` to get more details).
    It is an additive correction of the :class:`~openturns.FORM` approximation of the probability
    :math:`P_f`. See
    :class:`~openturns.Analytical` for the description of the first steps of the FORM analysis.

    Let :math:`\ell` be the function defined by: 

    .. math::

        \ell(\vect{u}) = \vect{u}^*.\vect{u} - \beta^2

    where :math:`\vect{u}^*` is the design point in the standard space, and :math:`\beta` the distance
    of the design point from the origin of the standard space: :math:`\beta = \| \vect{u}^*\|`.

    The tangent hyperplane at the design point in the standard space is defined by the equation:

    .. math::

        \{ \vect{u} \in \Rset^{\inputDim} \, | \,  \ell(\vect{u}) = 0 \}

    Let :math:`G: \Rset^\inputDim \rightarrow \Rset` be the model in the standard space: if :math:`T` is the iso-probabilistic
    transformation such that :math:`T(\vect{X}) = \vect{U}`, then:

    .. math::

       G(\vect{u}) = \model \circ T^{-1}(\vect{u})

    Let :math:`\cD_f^{std}` be the domain :math:`\cD_f` in the standard space. We assume that the domain
    :math:`\cD_f^{std}` does not contain the origin of the standard space. Thus, it is defined by:

    .. math::

        \cD_f^{std} & = \{\vect{u} \in \Rset^{\inputDim} \, | \,   G(\vect{u}) \leq 0  \} \\
              & = \{\vect{u} \in \Rset^{\inputDim} \, | \,   \ell(\vect{u}) \geq 0  \} \cup
              \{\vect{u} \in \Rset^{\inputDim} \, | \,   \ell(\vect{u}) \leq 0 , G(\vect{u}) \leq 0 \}
              \setminus
              \{\vect{u} \in \Rset^{\inputDim} \, | \,   \ell(\vect{u}) \geq 0 , G(\vect{u}) \geq 0 \}

    Thus, we have:

    .. math::

        P_f & = \Prob{\ell(\vect{U}) \geq 0} + \Prob{\ell(\vect{U}) \leq 0,  G(\RVU) \leq 0} -
        \Prob{\ell(\vect{U}) \geq 0,  G(\RVU) \geq 0}\\
            & = \Prob{\ell(\vect{U}) \geq 0} + \delta_1 - \delta_2

    where :math:`\Prob{\ell(\vect{U} \geq 0} = E(-\beta)` is known exactly. :math:`E` is the univariate
    standard CDF of the spherical distribution in the standard space.

    If :math:`\delta_1 \ll \Prob{\ell(\vect{U} \geq 0}`
    and :math:`\delta_2 \ll \Prob{\ell(\vect{U} \geq 0}`, then we use :math:`\ell(\vect{U})` as a
    controlled
    variable and we use an importance sampling around the design point in the standard space.

    We denote by :math:`(\vect{u}_i)_{1 \leq i \leq \sampleSize}` a sample generated from the spherical
    distribution
    centered on the origin of the standard space, whose pdf is denoted by :math:`e`. Let :math:`e^*` be
    the pdf of the
    spherical distribution centered on the design point :math:`\vect{u}^*`.

    The estimate of :math:`P_f` is defined by:

    .. math::

        \tilde{P}_f & =  E(-\beta) + \tilde{\delta}_1 - \tilde{\delta}_2\\
                    & = E(-\beta) + \dfrac{1}{\sampleSize} \sum_{i=1}^\sampleSize \left( 1_{ \left \{ \ell(\vect{u})_i \leq 0,
        G(\vect{u}_i)  \leq 0 \right\} } - 1_{ \left \{ \ell(\vect{u})_i \geq 0,  G(\vect{u}_i)  \geq
        0\right \} } \right) \dfrac{e(\vect{u}_i)}{e^*(\vect{u}_i)}

    The hypotheses :math:`\delta_1 \ll \Prob{\ell(\vect{U} \geq 0}`
    and :math:`\delta_2 \ll \Prob{\ell(\vect{U} \geq 0}` are verified if the FORM
    approximation is valid.

    The coefficient of variation of :math:`\tilde{P}_f` is:

    .. math::

        \Cov{\tilde{P}_f}  = \dfrac{ \sqrt{ \Var{ \tilde{P}_f}}}{\Expect{\tilde{P}_f}} 
                          = \dfrac{ \sqrt{ \Var{ \tilde{\delta}_1 - \tilde{\delta}_2 } }}
                         { E(-\beta) + \Expect{\tilde{\delta}_1 - \tilde{\delta}_2} } \ll  \dfrac{ \sqrt{ \Var{ \tilde{\delta}_1 - \tilde{\delta}_2 } } } {\Expect{\tilde{\delta}_1 - \tilde{\delta}_2}}

    See also
    --------
    PostAnalyticalImportanceSampling

    Examples
    --------
    >>> import openturns as ot

    Create the output random vector :math:`Y = \model(\inputRV)`:

    >>> f = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> X = ot.RandomVector(distribution)
    >>> Y = ot.CompositeRandomVector(f, X)

    Create the event :math:`\cD_f = \{\vect{x} \in \Rset^{\inputDim} \, | \,\model(\vect{x}) \leq -3.0\}`:

    >>> event = ot.ThresholdEvent(Y, ot.Less(), -3.0)

    Create the FORM algorithm and launch it:

    >>> solver = ot.AbdoRackwitz()
    >>> solver.setStartingPoint(distribution.getMean())
    >>> analytical = ot.FORM(solver, event)
    >>> analytical.run()
    >>> analyticalResult = analytical.getResult()

    Create the post analytical importance sampling algorithm and launch it:

    >>> algo = ot.PostAnalyticalControlledImportanceSampling(analyticalResult)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> pf = result.getProbabilityEstimate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.PostAnalyticalControlledImportanceSampling_getClassName(self)

    def __repr__(self):
        return _simulation.PostAnalyticalControlledImportanceSampling___repr__(self)

    def __init__(self, *args):
        _simulation.PostAnalyticalControlledImportanceSampling_swiginit(self, _simulation.new_PostAnalyticalControlledImportanceSampling(*args))
    __swig_destroy__ = _simulation.delete_PostAnalyticalControlledImportanceSampling

# Register PostAnalyticalControlledImportanceSampling in _simulation:
_simulation.PostAnalyticalControlledImportanceSampling_swigregister(PostAnalyticalControlledImportanceSampling)
class PostAnalyticalImportanceSampling(PostAnalyticalSimulation):
    r"""
    Post analytical importance sampling.

    Simulation method where the original distribution is replaced by the
    distribution in the standard space centered around the provided design point.

    This method, based on importance sampling, uses a normal instrumental 
    distribution in the standard space (see [lemaire2009]_ page 255, [melchers1990]_).

    Parameters
    ----------
    analyticalResult : :class:`~openturns.AnalyticalResult`
        Result which contains the whole information on the analytical study
        performed before the simulation study: in particular, the standard
        distribution of the standard space and the standard space design point.

    See also
    --------
    PostAnalyticalControlledImportanceSampling, NAIS, CrossEntropyImportanceSampling

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> X = ot.RandomVector(distribution)
    >>> Y = ot.CompositeRandomVector(f, X)
    >>> event = ot.ThresholdEvent(Y, ot.Less(), -3.0)
    >>> solver = ot.AbdoRackwitz()
    >>> solver.setStartingPoint(distribution.getMean())
    >>> analytical = ot.FORM(solver, event)
    >>> analytical.run()
    >>> analyticalResult = analytical.getResult()
    >>> algo = ot.PostAnalyticalImportanceSampling(analyticalResult)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> pf = result.getProbabilityEstimate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.PostAnalyticalImportanceSampling_getClassName(self)

    def __repr__(self):
        return _simulation.PostAnalyticalImportanceSampling___repr__(self)

    def __init__(self, *args):
        _simulation.PostAnalyticalImportanceSampling_swiginit(self, _simulation.new_PostAnalyticalImportanceSampling(*args))
    __swig_destroy__ = _simulation.delete_PostAnalyticalImportanceSampling

# Register PostAnalyticalImportanceSampling in _simulation:
_simulation.PostAnalyticalImportanceSampling_swigregister(PostAnalyticalImportanceSampling)
class RootStrategyImplementation(openturns.common.PersistentObject):
    r"""
    Base class for root strategies.

    *RootStrategy* is used through its derived classes:

    - :class:`~openturns.SafeAndSlow`

    - :class:`~openturns.RiskyAndFast`

    - :class:`~openturns.MediumSafe`

    See also
    --------
    DirectionalSampling
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RootStrategyImplementation_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.RootStrategyImplementation_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategyImplementation_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategyImplementation_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategyImplementation_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategyImplementation_getOriginValue(self)

    def __repr__(self):
        return _simulation.RootStrategyImplementation___repr__(self)

    def __init__(self, *args):
        _simulation.RootStrategyImplementation_swiginit(self, _simulation.new_RootStrategyImplementation(*args))
    __swig_destroy__ = _simulation.delete_RootStrategyImplementation

# Register RootStrategyImplementation in _simulation:
_simulation.RootStrategyImplementation_swigregister(RootStrategyImplementation)
class _RootStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _simulation._RootStrategyImplementationTypedInterfaceObject_swiginit(self, _simulation.new__RootStrategyImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _simulation._RootStrategyImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation._RootStrategyImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation._RootStrategyImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _simulation._RootStrategyImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _simulation._RootStrategyImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _simulation.delete__RootStrategyImplementationTypedInterfaceObject

# Register _RootStrategyImplementationTypedInterfaceObject in _simulation:
_simulation._RootStrategyImplementationTypedInterfaceObject_swigregister(_RootStrategyImplementationTypedInterfaceObject)
class RootStrategy(_RootStrategyImplementationTypedInterfaceObject):
    r"""
    Base class for root strategies.

    *RootStrategy* is used through its derived classes:

    - :class:`~openturns.SafeAndSlow`

    - :class:`~openturns.RiskyAndFast`

    - :class:`~openturns.MediumSafe`

    See also
    --------
    DirectionalSampling
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RootStrategy_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.RootStrategy_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategy_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategy_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategy_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategy_getOriginValue(self)

    def __repr__(self):
        return _simulation.RootStrategy___repr__(self)

    def __init__(self, *args):
        _simulation.RootStrategy_swiginit(self, _simulation.new_RootStrategy(*args))
    __swig_destroy__ = _simulation.delete_RootStrategy

# Register RootStrategy in _simulation:
_simulation.RootStrategy_swigregister(RootStrategy)
class SamplingStrategyImplementation(openturns.common.PersistentObject):
    r"""
    Base class for directions sampling strategies.

    Parameters
    ----------
    dimension : int
        The dimension of the standard space.

        By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    RandomDirection, OrthogonalDirection
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SamplingStrategyImplementation_getClassName(self)

    def generate(self):
        r"""
        Generate the directions.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The directions generated  according to the sampling strategy.

        Notes
        -----
        The sample is the collection of the points on the unit sphere in the standard space
        associated to the generated directions.
        """
        return _simulation.SamplingStrategyImplementation_generate(self)

    def getUniformUnitVectorRealization(self, *args):
        r"""
        Accessor to a realization according to the uniform distribution.

        Parameters
        ----------
        dimension : int
            The dimension of the sphere unity (which is the dimension of the standard
            space).

        Returns
        -------
        sample : :class:`~openturns.Point`
            The realization of a vector on the sphere unity, according to the uniform
            distribution.
        """
        return _simulation.SamplingStrategyImplementation_getUniformUnitVectorRealization(self, *args)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategyImplementation_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategyImplementation_getDimension(self)

    def __repr__(self):
        return _simulation.SamplingStrategyImplementation___repr__(self)

    def __init__(self, *args):
        _simulation.SamplingStrategyImplementation_swiginit(self, _simulation.new_SamplingStrategyImplementation(*args))
    __swig_destroy__ = _simulation.delete_SamplingStrategyImplementation

# Register SamplingStrategyImplementation in _simulation:
_simulation.SamplingStrategyImplementation_swigregister(SamplingStrategyImplementation)
class _SamplingStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _simulation._SamplingStrategyImplementationTypedInterfaceObject_swiginit(self, _simulation.new__SamplingStrategyImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _simulation._SamplingStrategyImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation._SamplingStrategyImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation._SamplingStrategyImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _simulation._SamplingStrategyImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _simulation._SamplingStrategyImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _simulation.delete__SamplingStrategyImplementationTypedInterfaceObject

# Register _SamplingStrategyImplementationTypedInterfaceObject in _simulation:
_simulation._SamplingStrategyImplementationTypedInterfaceObject_swigregister(_SamplingStrategyImplementationTypedInterfaceObject)
class SamplingStrategy(_SamplingStrategyImplementationTypedInterfaceObject):
    r"""
    Base class for directions sampling strategies.

    Parameters
    ----------
    dimension : int
        The dimension of the standard space.

        By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    RandomDirection, OrthogonalDirection
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SamplingStrategy_getClassName(self)

    def generate(self):
        r"""
        Generate the directions.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The directions generated  according to the sampling strategy.

        Notes
        -----
        The sample is the collection of the points on the unit sphere in the standard space
        associated to the generated directions.
        """
        return _simulation.SamplingStrategy_generate(self)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategy_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategy_getDimension(self)

    def __repr__(self):
        return _simulation.SamplingStrategy___repr__(self)

    def __init__(self, *args):
        _simulation.SamplingStrategy_swiginit(self, _simulation.new_SamplingStrategy(*args))
    __swig_destroy__ = _simulation.delete_SamplingStrategy

# Register SamplingStrategy in _simulation:
_simulation.SamplingStrategy_swigregister(SamplingStrategy)
class DirectionalSampling(EventSimulation):
    r"""
    Directional sampling algorithm.

    Refer to :ref:`directional_simulation`.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.
    rootStrategy : :class:`~openturns.RootStrategy`, optional
        Strategy used to evaluate the frontiers of
        the event along each direction in the standard space.
        By default :class:`~openturns.SafeAndSlow`.
    samplingStrategy : :class:`~openturns.SamplingStrategy`, optional
        Strategy used to sample directions in the standard space.
        By default :class:`~openturns.RandomDirection`.

    Notes
    -----
    Let :math:`\inputRV` be a random vector of dimension :math:`\inputDim`, distributed according to
    the measure :math:`\inputMeasure`, and :math:`\model: \Rset^\inputDim \rightarrow \Rset`
    be the *limit state function* (where we only wrote the random input parameters).
    We define the event :math:`\cD_f` by:

    .. math::

        \cD_f = \{\vect{x} \in \Rset^{\inputDim} \, | \,\model(\vect{x}) \leq 0\}

    The directional sampling algorithm estimates the probability of the event :math:`\cD_f`:

    .. math::

        P_f = \Prob{\model\left( \inputRV \right) \leq 0}
            = \int_{\Rset^{\inputDim}} \mathbf{1}_{\{\model(\vect{x}) \leq 0 \}}\inputMeasure(\vect{x})\di{\vect{x}}


    The directional sampling algorithm is a variance reduction sampling method.
    As it is performed in the standard space, it uses the iso-probabilistic transformation associated to :math:`\inputMeasure`
    (see :ref:`isoprobabilistic_transformation` for details).

    Let :math:`T` be the iso-probabilistic transformation: :math:`T(\vect{X}) = \vect{Z}`. The
    random vector :math:`\vect{Z}` follows a spherical distribution, which means that it is written
    as:

    .. math::

        \vect{Z} = R \vect{U}

    where :math:`R` is a scalar random variable following the radial distribution, :math:`\vect{U}` is a random
    vector that follows the uniform distribution on the unit sphere of dimension :math:`\inputDim`,
    denoted by :math:`\cS_\inputDim`, and :math:`(R, \vect{U})` are independent.

    Then the probability :math:`P_f` can be written as:

    .. math::

        P_f & = \dfrac{1}{|\cS_\inputDim|} \int_{\cS_\inputDim} \left \{ \int_{\Rset^+} 1_{\left\{\model \circ T^{-1}(r\vect{u}) \leq 0 \right\}} p_R(r) dr \right\} \, d\vect{u} \\

    For a given direction :math:`\vect{u}`, let :math:`I_{\vect{u}}` be:

    .. math::

       I_{\vect{u}} = \{r \in \Rset^+ \, | \, \model \circ T^{-1}(r\vect{u})\leq 0 \}

    Then, we have:

    .. math::

        \int_{\Rset^+} 1_{\left\{\model \circ T^{-1}(r\vect{u}) \leq 0\right\}} p_R(r) dr = \Prob{R \in I_{\vect{u}}}

    As the radial distribution of :math:`R` is known, we can evaluate exactly the probability :math:`\Prob{R \in I_{\vect{u}}}`
    for any direction :math:`\vect{u}`.

    The integral with respect to the directions is evaluated using a sampling method, defined by the :class:`~openturns.SamplingStrategy`.

    The directional sampling algorithm follows the steps:

    - A sample :math:`(\vect{u}_i)` is generated in the standard space and projected in the hyperplane normal to the important direction,
      this point forms the origin of the line;

    - Along each direction :math:`i`, we find the frontiers of :math:`\cD_f`, i.e. the solutions
      of :math:`\model \circ T^{-1}(r\vect{u}_i) = 0` according to the :class:`~openturns.RootStrategy`.
      From these solutions, we deduce the subset :math:`I_i \subset \Rset^+` that belongs to
      :math:`\cD_f`;

    - For each subset :math:`I_i`, we compute the probability
      :math:`q_i = \Prob{R \in I_{\vect{u}_i}}`.

    The probability :math:`P_f` is computed from all the  :math:`q_i` probabilities. If :math:`N` directions have been used, then:

    .. math::

        \widehat{P}_{f,DS} = \frac{1}{N} \sum_{i=1}^N q_i

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)

    Create the output random vector :math:`Y = \model(\inputRV)`:

    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> input_RV = ot.RandomVector(myDistribution)
    >>> output_RV = ot.CompositeRandomVector(myFunction, input_RV)

    Create the event :math:`\cD_f = \{\vect{x} \in \Rset^{\inputDim} \, | \,\model(\vect{x}) \leq -3.0\}`:

    >>> threshold = -3.0
    >>> event = ot.ThresholdEvent(output_RV, ot.Less(), -3.0)

    Create the directional sampling algorithm and the convergence criteria: 

    >>> myAlgo = ot.DirectionalSampling(event, ot.MediumSafe(), ot.OrthogonalDirection())
    >>> myAlgo.setMaximumOuterSampling(150)
    >>> myAlgo.setBlockSize(4)
    >>> myAlgo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation

    Run the algorithm and extract the estimated probability:

    >>> myAlgo.run()
    >>> print('Probability estimate=%.6f' % myAlgo.getResult().getProbabilityEstimate())
    Probability estimate=0.169716
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.DirectionalSampling_getClassName(self)

    def setRootStrategy(self, rootStrategy):
        r"""
        Set the root strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy to evaluate the frontiers of
            the event along each direction in the standard space.
        """
        return _simulation.DirectionalSampling_setRootStrategy(self, rootStrategy)

    def getRootStrategy(self):
        r"""
        Get the root strategy.

        Returns
        -------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy used to evaluate the frontiers of
            the event along each direction in the standard space.
        """
        return _simulation.DirectionalSampling_getRootStrategy(self)

    def setSamplingStrategy(self, samplingStrategy):
        r"""
        Set the direction sampling strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy used
            to sample directions in the standard space.
        """
        return _simulation.DirectionalSampling_setSamplingStrategy(self, samplingStrategy)

    def getSamplingStrategy(self):
        r"""
        Get the direction sampling strategy.

        Returns
        -------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy used to sample
            directions in the standard space.
        """
        return _simulation.DirectionalSampling_getSamplingStrategy(self)

    def __repr__(self):
        return _simulation.DirectionalSampling___repr__(self)

    def __init__(self, *args):
        _simulation.DirectionalSampling_swiginit(self, _simulation.new_DirectionalSampling(*args))
    __swig_destroy__ = _simulation.delete_DirectionalSampling

# Register DirectionalSampling in _simulation:
_simulation.DirectionalSampling_swigregister(DirectionalSampling)
class OrthogonalDirection(SamplingStrategyImplementation):
    r"""
    Directions sampling following the orthogonal direction strategy.

    Parameters
    ----------
    dimension : int
        The dimension of the standard space.

        By default, :math:`dimension = 0` but automatically updated by the calling class.
    k : int
        The number of elements in the linear combinations.

        By default, :math:`k = 1` but automatically updated by the calling class.

    See also
    --------
    RandomDirection

    Notes
    -----
    The orthogonal direction strategy is parameterized by :math:`k \in \{1, \ldots, \inputDim\}`, where :math:`\inputDim` is
    the dimension of the standard space. We generate some directions in the standard space according to the following steps:

    - one direct orthonormalized basis :math:`(\vect{e}_1, \ldots, \vect{e}_\inputDim)` uniformly distributed in
      the set of direct orthonormal bases;
    - we consider all the normalized linear combinations of :math:`k` vectors chosen within the :math:`\inputDim` vectors
      of the basis, where the coefficients of the linear combinations are in :math:`\{+1, -1\}`.

    Thus, this process generates :math:`\binom{k}{\inputDim} 2^k` directions.

    If :math:`k = 1`, we consider all the axes of the space, i.e. :math:`\inputDim` directions.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.OrthogonalDirection_getClassName(self)

    def generate(self):
        r"""
        Generate the directions.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The :math:`\binom{k}{\inputDim} 2^k` directions generated according to the strategy.

        Notes
        -----
        The sample is the collection of the :math:`\binom{k}{\inputDim} 2^k` points on the unit sphere in the standard space
        associated to the generated directions.
        """
        return _simulation.OrthogonalDirection_generate(self)

    def __repr__(self):
        return _simulation.OrthogonalDirection___repr__(self)

    def __init__(self, *args):
        _simulation.OrthogonalDirection_swiginit(self, _simulation.new_OrthogonalDirection(*args))
    __swig_destroy__ = _simulation.delete_OrthogonalDirection

# Register OrthogonalDirection in _simulation:
_simulation.OrthogonalDirection_swigregister(OrthogonalDirection)
class RandomDirection(SamplingStrategyImplementation):
    r"""
    Directions sampling following the random direction strategy.

    Parameters
    ----------
    dimension : int
        The dimension of the standard space.

        By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    OrthogonalDirection

    Notes
    -----
    The random direction strategy generates some directions in the standard space according to the following steps:

    - we generate some points on the sphere unity in the standard space according to the uniform distribution,
    - we consider both opposite directions so built.

    Thus, this process generates 2 directions.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RandomDirection_getClassName(self)

    def generate(self):
        r"""
        Generate the directions.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Both directions generated  according to the strategy.

        Notes
        -----
        The sample is the collection of the points on the unit sphere in the standard space
        associated to the generated directions.
        """
        return _simulation.RandomDirection_generate(self)

    def __repr__(self):
        return _simulation.RandomDirection___repr__(self)

    def __init__(self, *args):
        _simulation.RandomDirection_swiginit(self, _simulation.new_RandomDirection(*args))
    __swig_destroy__ = _simulation.delete_RandomDirection

# Register RandomDirection in _simulation:
_simulation.RandomDirection_swigregister(RandomDirection)
class MediumSafe(RootStrategyImplementation):
    r"""
    MediumSafe method.

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *MediumSafe* strategy is the following: for each direction, we go along the
    direction by step of length *stepSize* from the origin to the maximum distant
    point (at distance *maximumDistance* from the center of the standard space) and
    we check whether there is a sign changement on each segment so formed.

    At the first sign changement, we research one root in the concerned segment
    with the selected non linear solver. Then, the segment
    *[root, maximum distant point]* is considered within the failure space.

    If *stepSize* is small enough, this strategy guarantees us to find the root which
    is the nearest from the origin.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.MediumSafe_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.MediumSafe_solve(self, function, value)

    def __repr__(self):
        return _simulation.MediumSafe___repr__(self)

    def __init__(self, *args):
        _simulation.MediumSafe_swiginit(self, _simulation.new_MediumSafe(*args))
    __swig_destroy__ = _simulation.delete_MediumSafe

# Register MediumSafe in _simulation:
_simulation.MediumSafe_swigregister(MediumSafe)
class RiskyAndFast(RootStrategyImplementation):
    r"""
    RiskyAndFast method.

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *RiskyAndFast* strategy is the following: for each direction, we check
    whether there is a sign changement of the standard limit state function between
    the maximum distant point (at distance *maximumDistance* from the center of the
    standard space) and the center of the standard space.

    In case of sign changement, we search one root in the segment
    *[origin, maximum distant point]* with the selected non linear solver.

    As soon as founded, the segment *[root, infinity point]* is considered within
    the failure space.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RiskyAndFast_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.RiskyAndFast_solve(self, function, value)

    def __repr__(self):
        return _simulation.RiskyAndFast___repr__(self)

    def __init__(self, *args):
        _simulation.RiskyAndFast_swiginit(self, _simulation.new_RiskyAndFast(*args))
    __swig_destroy__ = _simulation.delete_RiskyAndFast

# Register RiskyAndFast in _simulation:
_simulation.RiskyAndFast_swigregister(RiskyAndFast)
class SafeAndSlow(RootStrategyImplementation):
    r"""
    SafeAndSlow method.

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *SafeAndSlow* strategy is the following: for each direction, we go along
    the direction by step of length *stepSize* from the origin to the maximum
    distant point(at distance *maximumDistance* from the center of the standard
    space) and we check whether there is a sign changement on each segment so
    formed.

    We go until the maximum distant point. Then, for all the segments where we
    detected the presence of a root, we research the root with the selected non
    linear solver. We evaluate the contribution to the failure probability of each
    segment.

    If *stepSize* is small enough, this strategy guarantees us to find all the roots
    in the direction and the contribution of this direction to the failure
    probability is precisely evaluated.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SafeAndSlow_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.SafeAndSlow_solve(self, function, value)

    def __repr__(self):
        return _simulation.SafeAndSlow___repr__(self)

    def __init__(self, *args):
        _simulation.SafeAndSlow_swiginit(self, _simulation.new_SafeAndSlow(*args))
    __swig_destroy__ = _simulation.delete_SafeAndSlow

# Register SafeAndSlow in _simulation:
_simulation.SafeAndSlow_swigregister(SafeAndSlow)
class SimulationSensitivityAnalysis(openturns.common.PersistentObject):
    r"""
    Class to perform a sensitivity analysis based on a reliability event.

    Available constructor:
        SimulationSensitivityAnalysis(*event, inputSample, outputSample*)

        SimulationSensitivityAnalysis(*event*)

        SimulationSensitivityAnalysis(*simulationRes*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        An event which it composite (test is with the method
        :meth:`isComposite <openturns.RandomVector.isComposite>`).
    inputSample, outputSample : 2-d sequence of float
        Input sample and output sample of a model evaluated apart.
    simulationRes : :class:`~openturns.ProbabilitySimulationResult`
        A simulation result.

    Notes
    -----
    The simulation sensitivity analysis is based on:

    - in the first usage, the *inputSample* and *outputSample* given:
    - in the second usage, the samples which have been stored by the function
      defining the event. Care if the sample is not a statistical sample: post
      treatment proposed by the object might not be right.
    - in the third usage, the samples generated by the
      :class:`~openturns.EventSimulation` that produced *simulationRes*.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SimulationSensitivityAnalysis_getClassName(self)

    def computeMeanPointInEventDomain(self, *args):
        r"""
        Accessor to the mean point.

        Returns
        -------
        mean : :class:`~openturns.Point`
            The mean point in the failure domain.

        Notes
        -----
        This method computes the mean point in the physical space of all the simulations
        generated by the simulation that failed into the event domain.

        Be careful: this notion is only valid for Monte Carlo or LHS sampling as the
        mean is evaluated from the equation :eq:`mean_point` (only uniform weights over
        the realizations :math:`\vect{X}_i`.
        """
        return _simulation.SimulationSensitivityAnalysis_computeMeanPointInEventDomain(self, *args)

    def computeImportanceFactors(self, *args):
        r"""
        Compute the importance factors.

        Returns
        -------
        impFactors : :class:`~openturns.PointWithDescription`
            The importance factors.

        Notes
        -----
        The importance factors, given in :eq:`importance_factor`, are evaluated from the
        coordinates of the mean point :eq:`mean_point` of the event domain, mapped into
        the standard space as follows:

        .. math::
            :label: mean_point

            \vect{X}^*_{event} = \frac{1}{n} \sum_{i=1}^n \vect{X}_i 1_{event} (\vect{X}_i)

        .. math::
            :label: importance_factor

            \alpha_i = \frac{ (U_i^*)^2 }{ \left\| \vect{U}^* \right\| }

        where

        .. math::

            \vect{U}^* = T(\vect{X}^*_{event})

        Be careful: this notion is only valid for :class:`~openturns.MonteCarloExperiment` or
        :class:`~openturns.LHSExperiment` sampling as the mean is evaluated from the equation
        :eq:`importance_factor` (only uniform weights over the realizations
        :math:`\vect{X}_i`.
        """
        return _simulation.SimulationSensitivityAnalysis_computeImportanceFactors(self, *args)

    def computeEventProbabilitySensitivity(self):
        r"""
        Compute the sensitivity to the probability.

        The sensitivity of the probability Pf wrt the distribution parameters :math:`\theta` is written:

        .. math::

            \vect{sens_{Pf}}_j = \frac{1}{n} \sum_{i=1}^n \mathbf{1}_{event} \vect{\frac{\delta log(f_{\uX})(\vect{X}_i)}{\delta \theta_j}}

        Returns
        -------
        sensitivity_pf : :class:`~openturns.PointWithDescription`
            The probability sensitivity.
        """
        return _simulation.SimulationSensitivityAnalysis_computeEventProbabilitySensitivity(self)

    def drawImportanceFactors(self):
        r"""
        Draw the importance factors.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph containing the pie corresponding to the importance factors of the probabilistic variables.
        """
        return _simulation.SimulationSensitivityAnalysis_drawImportanceFactors(self)

    def drawImportanceFactorsRange(self, *args):
        r"""
        Draw the importance factors evolution.

        Parameters
        ----------
        probabilityScale : bool
            Set True if the limits are the probability levels; set False if the limits are
            the thresholds defining the event.
        lower, upper : floats
            Define the boundaries of the probability levels :math:`p_{min}` and
            :math:`p_{max}` or those of the thresholds :math:`s_{min}` and :math:`s_{max}`. 

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph that draws the evolution of the importance factors of each direction
            with respect to :math:`p \in [p_{min}, p_{max}]` or
            :math:`s \in [s_{min}, s_{max}]`. The importance factors are evaluated from
            the definition :eq:`importance_factor` for each threshold *s* or probability
            *p*.
        """
        return _simulation.SimulationSensitivityAnalysis_drawImportanceFactorsRange(self, *args)

    def getInputSample(self):
        r"""
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The input sample.
        """
        return _simulation.SimulationSensitivityAnalysis_getInputSample(self)

    def getOutputSample(self):
        r"""
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The output sample.
        """
        return _simulation.SimulationSensitivityAnalysis_getOutputSample(self)

    def getThreshold(self):
        r"""
        Accessor to the threshold.

        Returns
        -------
        s : float
            The threshold.
        """
        return _simulation.SimulationSensitivityAnalysis_getThreshold(self)

    def getTransformation(self):
        r"""
        Accessor to the isoprobabilistic transformation function.

        Returns
        -------
        transformation : :class:`~openturns.Function`
            The isoprobabilistic transformation function.
        """
        return _simulation.SimulationSensitivityAnalysis_getTransformation(self)

    def getComparisonOperator(self):
        r"""
        Accessor to the comparison operator.

        Returns
        -------
        operator : :class:`~openturns.ComparisonOperator`
            The comparison operator.
        """
        return _simulation.SimulationSensitivityAnalysis_getComparisonOperator(self)

    def __repr__(self):
        return _simulation.SimulationSensitivityAnalysis___repr__(self)

    def __init__(self, *args):
        _simulation.SimulationSensitivityAnalysis_swiginit(self, _simulation.new_SimulationSensitivityAnalysis(*args))
    __swig_destroy__ = _simulation.delete_SimulationSensitivityAnalysis

# Register SimulationSensitivityAnalysis in _simulation:
_simulation.SimulationSensitivityAnalysis_swigregister(SimulationSensitivityAnalysis)
class SubsetSamplingResult(ProbabilitySimulationResult):
    r"""
    Subset sampling result.

    See also
    --------
    SubsetSampling, SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SubsetSamplingResult_getClassName(self)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _simulation.SubsetSamplingResult_getCoefficientOfVariation(self)

    def __repr__(self):
        return _simulation.SubsetSamplingResult___repr__(self)

    def __init__(self, *args):
        _simulation.SubsetSamplingResult_swiginit(self, _simulation.new_SubsetSamplingResult(*args))
    __swig_destroy__ = _simulation.delete_SubsetSamplingResult

# Register SubsetSamplingResult in _simulation:
_simulation.SubsetSamplingResult_swigregister(SubsetSamplingResult)
class SubsetSampling(EventSimulation):
    r"""
    Subset simulation.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability.
    proposalRange : float, optional
        Proposal range length
    targetProbability : float, optional
        Value of :math:`P(F_i|F_{i-1})` between successive steps

    Notes
    -----
    The goal is to estimate the following probability

    .. math::

        P_f = \int_{\mathcal D_f} f_{\uX}(\ux)\di{\ux}\\
            = \int_{\mathbb R^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \:\leq 0\: \}}f_{\uX}(\ux)\di{\ux}\\
            = \Prob {\{g(\uX,\underline{d}) \leq 0\}}


    The idea of the subset simulation method [au2001]_ is to replace simulating a
    rare failure event in the original probability space by a sequence of
    simulations of more frequent conditional events :math:`F_i`

    .. math::

        F_1 \supset F_2 \supset \dots \supset F_m = F


    The original probability estimate rewrites

    .. math::

        P_f = P(F_m) = P(\bigcap \limits_{i=1}^m F_i) = P(F_1) \prod_{i=2}^m P(F_i|F_{i-1})


    And each conditional subset failure region is chosen by setting the threshold
    :math:`g_i` so that :math:`P(F_i|F_{i-1})` leads to a conditional failure
    probability of order :math:`0.1`

    .. math::

        F_i =\Prob {\{g(\uX,\underline{d}) \leq g_i\}}


    The conditional samples are generated by the means of Markov Chains,
    using the Metropolis Hastings algorithm.

    :math:`N` being the number of simulations per subset, and :math:`p_{0i}` the
    conditional probability of each subset event, and :math:`\gamma_i` the
    autocorrelation between Markov chain samples.

    .. math::

        \delta^2 = \sum_{i=1}^m \delta^2_i = \sum_{i=1}^m (1+\gamma_i) \frac{1-p_{0i}}{p_{0i}N}


    The first event :math:`F_1` not being conditional, :math:`\delta^2_1`
    expresses as the classic Monte Carlo c.o.v.

    See also
    --------
    EventSimulation
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SubsetSampling_getClassName(self)

    def setProposalRange(self, proposalRange):
        r"""
        Proposal range length accessor.

        Parameters
        ----------
        range : float
            Range length.
        """
        return _simulation.SubsetSampling_setProposalRange(self, proposalRange)

    def getProposalRange(self):
        r"""
        Proposal range length accessor.

        Returns
        -------
        range : float
            Range length.
        """
        return _simulation.SubsetSampling_getProposalRange(self)

    def setConditionalProbability(self, conditionalProbability):
        r"""
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Parameters
        ----------
        prob : float
            Conditional probability value.
        """
        return _simulation.SubsetSampling_setConditionalProbability(self, conditionalProbability)

    def getConditionalProbability(self):
        r"""
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Returns
        -------
        prob : float
            Conditional probability value.
        """
        return _simulation.SubsetSampling_getConditionalProbability(self)

    def setMinimumProbability(self, minimumProbability):
        r"""
        Minimum probability accessor.

        Allows one to stop the algorithm if the probability becomes too small.

        Parameters
        ----------
        prob_min : float, defaults to the square root of SpecFunc.MinScalar
            Minimum probability.
        """
        return _simulation.SubsetSampling_setMinimumProbability(self, minimumProbability)

    def getMinimumProbability(self):
        r"""
        Minimum probability accessor.

        Returns
        -------
        prob_min : float
            Minimum probability.
        """
        return _simulation.SubsetSampling_getMinimumProbability(self)

    def getStepsNumber(self):
        r"""
        Subset steps number accessor.

        Returns
        -------
        n : int
            Number of subset steps, including the initial Monte Carlo sampling.
        """
        return _simulation.SubsetSampling_getStepsNumber(self)

    def getThresholdPerStep(self):
        r"""
        Threshold accessor.

        Returns
        -------
        threshold : :class:`~openturns.Point`
            Threshold values at each step.
        """
        return _simulation.SubsetSampling_getThresholdPerStep(self)

    def getGammaPerStep(self):
        r"""
        Autocorrelation accessor.

        Returns
        -------
        prob : :class:`~openturns.Point`
            Autocorrelation values at each step.
        """
        return _simulation.SubsetSampling_getGammaPerStep(self)

    def getCoefficientOfVariationPerStep(self):
        r"""
        Coefficient of variation per step accessor.

        Returns
        -------
        coef : :class:`~openturns.Point`
            Coefficient of variation at each subset step.
        """
        return _simulation.SubsetSampling_getCoefficientOfVariationPerStep(self)

    def getProbabilityEstimatePerStep(self):
        r"""
        Probability estimate accessor.

        Returns
        -------
        prob : :class:`~openturns.Point`
            Probability estimate at each step.
        """
        return _simulation.SubsetSampling_getProbabilityEstimatePerStep(self)

    def setKeepSample(self, keepSample):
        r"""
        Sample storage accessor.

        Parameters
        ----------
        keepsample : bool
            Whether to keep the working samples at each iteration.
        """
        return _simulation.SubsetSampling_setKeepSample(self, keepSample)
    EVENT0 = _simulation.SubsetSampling_EVENT0
    EVENT1 = _simulation.SubsetSampling_EVENT1
    BOTH = _simulation.SubsetSampling_BOTH

    def getInputSample(self, *args):
        r"""
        Input sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _simulation.SubsetSampling_getInputSample(self, *args)

    def getOutputSample(self, *args):
        r"""
        Output sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample.
        """
        return _simulation.SubsetSampling_getOutputSample(self, *args)

    def setInitialExperiment(self, initialExperiment):
        r"""
        Initial experiment accessor.

        Parameters
        ----------
        initialExperiment : :class:`~openturns.WeightedExperiment`
            Experiment for first step.
        """
        return _simulation.SubsetSampling_setInitialExperiment(self, initialExperiment)

    def getInitialExperiment(self):
        r"""
        Initial experiment accessor.

        Returns
        -------
        initialExperiment : :class:`~openturns.WeightedExperiment`
            Experiment for first step.
        """
        return _simulation.SubsetSampling_getInitialExperiment(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        openturns.EventSimulation.setBlockSize
        openturns.EventSimulation.setMaximumOuterSampling
        openturns.ResourceMap
        openturns.SimulationResult
        """
        return _simulation.SubsetSampling_run(self)

    def __repr__(self):
        return _simulation.SubsetSampling___repr__(self)

    def __init__(self, *args):
        _simulation.SubsetSampling_swiginit(self, _simulation.new_SubsetSampling(*args))
    __swig_destroy__ = _simulation.delete_SubsetSampling

# Register SubsetSampling in _simulation:
_simulation.SubsetSampling_swigregister(SubsetSampling)
class AdaptiveDirectionalStratification(EventSimulation):
    r"""
    Adaptive directional simulation.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.
    rootStrategy : :class:`~openturns.RootStrategy`, optional
        Strategy adopted to evaluate the intersections of each direction with the
        limit state function and take into account the contribution of the
        direction to the event probability.
        Set to :class:`~openturns.SafeAndSlow` by default.
    samplingStrategy : :class:`~openturns.SamplingStrategy`, optional
        Strategy adopted to sample directions.
        Set to :class:`~openturns.RandomDirection` by default.

    Notes
    -----
    Let :math:`\mathcal D_f` denote the failure domain defined as
    :math:`\mathcal D_f = \{\ux \in \mathbb R^{n_X} | g(\ux) \leq 0\}`, where
    :math:`\ux` are realization of the random vector :math:`\uX` and :math:`g` is the limit-state
    function as defined elsewhere in the documentation.

    The purpose of the ADS-2 algorithm and its variants is to estimate the
    following probability:

    .. math::

      P_f = \int_{\mathcal D_f} f_{\uX}(\ux)\di{\ux} \\
          = \int_{\mathbb R^{n_X}} \mathbf{1}_{\{g(\ux) \:\leq 0\: \}}\,f_{\uX}(\ux)\di{\ux} \\
          = \Prob{\{g(\uX) \leq 0\}}.

    Principles

    The ADS-2 method [munoz2011]_ combines the stratified and directional sampling concepts.
    Stratified sampling consists in splitting the support of the random vector
    :math:`\ux` into :math:`m` mutually exclusive and collectively exhaustive subsets.
    Here, ADS-2 splits the standard space into :math:`m = 2^d` quadrants, where
    :math:`d` is the dimension of the random vector :math:`\uX`.
    Stratified sampling is often run in two steps: (i) a learning step is used for
    polling the input space and detect the subsets that contribute most to the
    probability and (ii) an estimation step is used for estimating
    the probability by weighted sampling (some subsets are more sampled than the others).
    Directional sampling uses the spheric symmetry of the standard space for
    estimating the failure probability as the average of conditional probabilities
    calculated on directions drawn at random in the standard space.

    The learning step uses an a priori number of random directions that is
    uniformly distributed over the quadrants, meaning the weights are as follows:

    .. math::

        \omega^1_i = \frac{1}{m}, \quad i = 1, \ldots, m.


    Directional sampling is used for estimating the failure probability in each quadrant:

    .. math::

        \hat P_i^{DS} = \Prob{\{g(\uX) \leq 0\} \mid \uX \in \mathbb{Q}_i},\,i = 1, \ldots, m.


    and the corresponding estimation variances are denoted as :math:`\sigma_i^{DS\,2}`.
    These probabilities are estimated using the same number :math:`N^0_i` of random
    directions per quadrant as told by the uniform weights distribution.

    The probability of interest is then computed as a weighted average of the
    previously defined conditional probabilities:

    .. math::

        \hat P_f = \sum\limits_{i=1}^m \omega_i \hat P_i^{DS}


    where :math:`\hat P_i^{DS}` is the conditional probability estimator in the i-th quadrant. The corresponding variance of the stratified estimator reads:

    .. math::

        \sigma^2 = \frac{1}{N_l} \left( \sum\limits_{i=1}^m \omega_i \sigma_i^{DS} \right) ^2


    where :math:`\sigma_i^{DS\,2}` is the variance of the conditional probability
    estimator in the i-th quadrant.

    At the end of the learning step, the weights :math:`\omega_i` are updated so
    as to minimize the stratified estimator variance.
    Indeed, it can be shown that the updated weights:

    .. math::

        \omega^2_i = \frac{\omega^1_i \sigma_i^{DS}}{\sum\limits_{j=1}^m \omega^1_j \sigma_j^{DS}}, i = 1, \ldots, m,


    minimize the final estimation variance in \eqref{eq:pf_est_sda2_var}.
    Note that some weights might be zero (due to a somewhat arbitrary rounding of
    the conditional probabilities' estimation variance). The quadrants associated
    with a zero-weight will not be sampled in the estimation step.

    Eventually, the estimation step proceeds in essentially the same way as the
    learning step with different weights for the quadrants though.
    \eqref{eq:pf_est_sda2} and \eqref{eq:pf_est_sda2_var} are used for evaluating
    the final probability probability estimate and its variance.

    The computational budget per step is parametrized by a fraction
    :math:`\gamma_l, l = 1,\,2` of the total budget :math:`N`, such that :math:`\gamma_1 + \gamma_2 = 1`.
    The number of directions sampled in quadrant :math:`i` at step :math:`l` is then defined as follows:

    .. math::

        N^l_i = N * \gamma_l * \omega_i.


    The number of evaluation of the limit-state function :math:`g` is of course
    greater than the total budget :math:`N` since directional sampling is used.

    Variants

    The ADS-2+ variant performs a dimension reduction step after the learning step
    for reducing the number of stratified quadrants. The statistic :math:`\tilde T_k`
    aggregates the sensitivity of expectation along dimension :math:`k`.
    It is defined as follows:

    .. math::

        \tilde T_k = \sum\limits_{i_l \in \lbrace -1,1 \rbrace,l \neq k} \lvert \tilde I_{(i_1,\dots,i_{k-1},-1,i_{k+1},\dots,i_p)} - \tilde I_{(i_1,\dots,i_{k-1},1,i_{k+1},\dots,i_p)} \rvert.

    It is used for ranking the contributions of the quadrants.
    Then, only the :math:`d' < d` most influential variables according to
    :math:`\tilde T_k` are stratified, leaving the remaining variables simulated without
    stratification. The corresponding quadrants will not be sampled.

    The DP-ADS-2 variant combines the ADS method with a rotation of the quadrants.
    The idea is to get a possible design point (available e.g. after a
    preliminary FORM analysis) on the bisector of one of the quadrants to make the
    stratification even more efficient and thus save some evaluations of the model.

    This 2-step algorithm can be generalized to :math:`L > 2` steps by adding more
    than one learning step. For now, only ADS-2 is implemented.

    See also
    --------
    EventSimulation
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.AdaptiveDirectionalStratification_getClassName(self)

    def __repr__(self):
        return _simulation.AdaptiveDirectionalStratification___repr__(self)

    def setRootStrategy(self, rootStrategy):
        r"""
        Set the root strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _simulation.AdaptiveDirectionalStratification_setRootStrategy(self, rootStrategy)

    def getRootStrategy(self):
        r"""
        Get the root strategy.

        Returns
        -------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _simulation.AdaptiveDirectionalStratification_getRootStrategy(self)

    def setSamplingStrategy(self, samplingStrategy):
        r"""
        Set the direction sampling strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _simulation.AdaptiveDirectionalStratification_setSamplingStrategy(self, samplingStrategy)

    def getSamplingStrategy(self):
        r"""
        Get the direction sampling strategy.

        Returns
        -------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _simulation.AdaptiveDirectionalStratification_getSamplingStrategy(self)

    def setGamma(self, gamma):
        r"""
        Gamma accessor.

        The computational budget per step :math:`\gamma_l`.

        Parameters
        ----------
        gamma : sequence of float
            Gamma value.
        """
        return _simulation.AdaptiveDirectionalStratification_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Gamma accessor.

        The computational budget per step :math:`\gamma_l`.

        Returns
        -------
        gamma : :class:`~openturns.Point`
            Gamma value.
        """
        return _simulation.AdaptiveDirectionalStratification_getGamma(self)

    def setQuadrantOrientation(self, quadrantOrientation):
        r"""
        Quadrant orientation accessor.

        Parameters
        ----------
        orientation : sequence of float
            Quadrant orientation.
        """
        return _simulation.AdaptiveDirectionalStratification_setQuadrantOrientation(self, quadrantOrientation)

    def getQuadrantOrientation(self):
        r"""
        Quadrant orientation accessor.

        Returns
        -------
        orientation : :class:`~openturns.Point`
            Quadrant orientation.
        """
        return _simulation.AdaptiveDirectionalStratification_getQuadrantOrientation(self)

    def setPartialStratification(self, partialStratification):
        r"""
        Partial stratification accessor.

        Parameters
        ----------
        partialStratification : bool
            Partial stratification.
        """
        return _simulation.AdaptiveDirectionalStratification_setPartialStratification(self, partialStratification)

    def getPartialStratification(self):
        r"""
        Partial stratification accessor.

        Returns
        -------
        partialStratification : bool
            Partial stratification.
        """
        return _simulation.AdaptiveDirectionalStratification_getPartialStratification(self)

    def setMaximumStratificationDimension(self, maximumStratificationDimension):
        r"""
        Maximum stratification dimension accessor.

        Parameters
        ----------
        max : int
            Maximum stratification dimension.
        """
        return _simulation.AdaptiveDirectionalStratification_setMaximumStratificationDimension(self, maximumStratificationDimension)

    def getMaximumStratificationDimension(self):
        r"""
        Maximum stratification dimension accessor.

        Returns
        -------
        max : int
            Maximum stratification dimension.
        """
        return _simulation.AdaptiveDirectionalStratification_getMaximumStratificationDimension(self)

    def getTStatistic(self):
        r"""
        T statistic accessor.

        The statistic :math:`\tilde T_k` aggregates the sensitivity of expectation.

        Returns
        -------
        gamma : :class:`~openturns.Point`
            T statistic value.
        """
        return _simulation.AdaptiveDirectionalStratification_getTStatistic(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        openturns.EventSimulation.setBlockSize
        openturns.EventSimulation.setMaximumOuterSampling
        openturns.ResourceMap
        openturns.SimulationResult
        """
        return _simulation.AdaptiveDirectionalStratification_run(self)

    def __init__(self, *args):
        _simulation.AdaptiveDirectionalStratification_swiginit(self, _simulation.new_AdaptiveDirectionalStratification(*args))
    __swig_destroy__ = _simulation.delete_AdaptiveDirectionalStratification

# Register AdaptiveDirectionalStratification in _simulation:
_simulation.AdaptiveDirectionalStratification_swigregister(AdaptiveDirectionalStratification)
class ExpectationSimulationResult(SimulationResult):
    r"""
    Expectation simulation result.

    Gathers the results of a :class:`~openturns.ExpectationSimulationAlgorithm`
    algorithm.

    See also
    --------
    ExpectationSimulationAlgorithm
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.ExpectationSimulationResult_getClassName(self)

    def getRandomVector(self):
        r"""
        Accessor to the random variable.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Random variable we want to study.
        """
        return _simulation.ExpectationSimulationResult_getRandomVector(self)

    def setRandomVector(self, randomVector):
        r"""
        Accessor to the random variable.

        Parameters
        ----------
        event : :class:`~openturns.RandomVector`
            Random variable we want to study.
        """
        return _simulation.ExpectationSimulationResult_setRandomVector(self, randomVector)

    def getExpectationEstimate(self):
        r"""
        Accessor to the expectation estimate.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the expectation.
        """
        return _simulation.ExpectationSimulationResult_getExpectationEstimate(self)

    def setExpectationEstimate(self, expectationEstimate):
        r"""
        Accessor to the expectation estimate.

        Parameters
        ----------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the expectation.
        """
        return _simulation.ExpectationSimulationResult_setExpectationEstimate(self, expectationEstimate)

    def getVarianceEstimate(self):
        r"""
        Accessor to the variance estimate.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the variance.
        """
        return _simulation.ExpectationSimulationResult_getVarianceEstimate(self)

    def setVarianceEstimate(self, varianceEstimate):
        r"""
        Accessor to the variance estimate.

        Parameters
        ----------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the variance.
        """
        return _simulation.ExpectationSimulationResult_setVarianceEstimate(self, varianceEstimate)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        coefficientOfVariation : :class:`~openturns.Point`
            Coefficient of variation.
        """
        return _simulation.ExpectationSimulationResult_getCoefficientOfVariation(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        standardDeviation : :class:`~openturns.Point`
            Standard deviation.
        """
        return _simulation.ExpectationSimulationResult_getStandardDeviation(self)

    def getExpectationDistribution(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Distribution`
            Distribution of the expectation.
        """
        return _simulation.ExpectationSimulationResult_getExpectationDistribution(self)

    def __repr__(self):
        return _simulation.ExpectationSimulationResult___repr__(self)

    def __init__(self, *args):
        _simulation.ExpectationSimulationResult_swiginit(self, _simulation.new_ExpectationSimulationResult(*args))
    __swig_destroy__ = _simulation.delete_ExpectationSimulationResult

# Register ExpectationSimulationResult in _simulation:
_simulation.ExpectationSimulationResult_swigregister(ExpectationSimulationResult)
class ExpectationSimulationAlgorithm(SimulationAlgorithm):
    r"""
    Expectation computation using sampling.

    Incremental Monte Carlo sampling algorithm to estimate the mean :math:`\Expect{\vect{X}}` of a random vector
    :math:`\vect{X}`.

    Parameters
    ----------
    X : :class:`~openturns.RandomVector`
        The random vector to study.

    Notes
    -----
    Let :math:`\vect{X}\in\Rset^{n_X}` be a random vector. 
    This algorithm estimates :math:`\Expect{\vect{X}}` using the smallest possible sample 
    size which satisfies pre-defined stopping rules. 
    It increases the sample size :math:`n` incrementally until a stopping criterion is met. 
    Hence, both the mean and the variance must be finite. 
    For example, consider the Student distribution with :math:`\nu` degrees of freedom. 
    If :math:`\nu=1` (where the expectation is undefined) 
    or :math:`\nu=2` (where the variance is undefined), 
    then the algorithm cannot succeed. 

    The algorithm is based on two nested loops:

    - the outer loop sets the number of iterations of the algorithm; 
      this can be configured using :meth:`setMaximumOuterSampling`,

    - the inner loop sets the number of function calls which can be parallelized; 
      this can be configured using :meth:`setBlockSize`.

    The algorithm allows one to get the best possible performance on distributed
    supercomputers and multi-core workstations. 
    For example, if the block size is equal to 100, then the sample size 
    is successively equal to 100, 200, etc... 
    Each block of evaluation of the outputs can be parallelized, which may improve the performance of the algorithm.
    We suggest to set the block size as a multiple of the number of cores. 

    The algorithm stops either when the maximum number of outer iterations is reached or when the target precision is met. 
    The latter stopping criterion is based on either the coefficient of variation of the 
    sample mean (relative criterion) or the standard deviation of the sample 
    mean (absolute criterion). 

    We consider :math:`\vect{n}` independent realizations :math:`\vect{x}^{(1)}`, 
    ..., :math:`\vect{x}^{(n)}\in\Rset^{n_X}` of the random vector :math:`\vect{X}`. 
    We estimate :math:`\Expect{\vect{X}}` with the sample mean:

    .. math::

        \overline{\vect{x}} = \frac{1}{n} \sum_{j=1}^n \vect{x}^{(j)}.

    We estimate :math:`\Var{X_i}` for :math:`i = 1, \ldots, n_X` 
    with the unbiased sample variance:

    .. math::

        \hat{\sigma}^2_i = \frac{1}{n - 1} \sum_{j=1}^n \left(x^{(j)}_i - \overline{x}_i\right)^2.

    for :math:`i = 1, \ldots, n_X`.

    The expected value of the sample mean is:

    .. math::

        \Expect{\overline{X}_i} = \Expect{X_i}

    and, since the observations are independent, the variance of the sample mean is:

    .. math::

        \Var{\overline{X}_i} = \frac{\Var{X_i}}{n}.

    for :math:`i = 1, \ldots, n_X`, since the observations are independent.

    Moreover, we can estimate the standard deviation of the sample mean with:

    .. math::

        \hat{\sigma}\left(\overline{X}_i\right) = \frac{\hat{\sigma}_i}{\sqrt{n}}

    for :math:`i = 1, \ldots, n_X`.

    If the expectation :math:`\Expect{X_i}` is nonzero, the coefficient of variation of the sample mean is:

    .. math::

        CV\left(\overline{X}_i\right) = \frac{\sqrt{\Var{\overline{X}_i}}}{\left|\Expect{\overline{X}_i}\right|} = \frac{\sqrt{\Var{X_i}}/\sqrt{n}}{\left|\Expect{X_i}\right|}

    for :math:`i = 1, \ldots, n_X`.

    We can estimate it with

    .. math::

        \widehat{CV}\left(\overline{X}_i\right) = \frac{\hat{\sigma}_i/\sqrt{n}}{\left|\overline{x}_i\right|}

    for :math:`i = 1, \ldots, n_X`.

    When the sample size :math:`n` increases, the sample standard deviation and the sample coefficient of variation decrease to zero at the Monte-Carlo rate of :math:`1/\sqrt{n}`. 

    There are 3 mathematical stopping criteria available:

    - through an operator on the componentwise coefficients of variation (by default),
    - through an operator on the componentwise standard deviations,
    - on the maximum standard deviation per component.

    A low coefficient of variation guarantees relative accuracy, while a low standard deviation guarantees absolute accuracy. 

    If the chosen condition is found to be true, the algorithm stops.

    Let :math:`n_X` be the dimension of the random vector :math:`\vect{X}`. 
    Let :math:`\max_{cov}\in\Rset` be the maximum coefficient of variation. 
    The criterion on the componentwise coefficients of variation is defined using either:

    - the maximum (by default):

    .. math::

        \max_{i=1,\ldots,n_X} \frac{\hat{\sigma}_i / \sqrt{n}}{|\overline{x}_i|} \leq \max_{cov},

    - the norm-1:

    .. math::

        \sum_{i=1}^{n_X} \frac{\hat{\sigma}_i / \sqrt{n}}{|\overline{x}_i|} \leq \max_{cov},

    - the norm-2:

    .. math::

        \sqrt{\sum_{i=1}^{n_X} \left(\frac{\hat{\sigma}_i / \sqrt{n}}{|\overline{x}_i|}\right)^2} \leq \max_{cov},

    - or disabled.

    The type of operator on the coefficient of variation is set using :meth:`setCoefficientOfVariationCriterionType`.

    The default type is set by the `ExpectationSimulationAlgorithm-DefaultCoefficientOfVariationCriterionType` key of the :class:`~openturns.ResourceMap`.

    The threshold :math:`\max_{cov}` can be set using :meth:`setMaximumCoefficientOfVariation`.

    Let :math:`\max_{\sigma}\in\Rset` be the maximum value of the standard deviation. 
    The criterion on the componentwise standard deviations is defined using either:

    - the maximum (by default): 

    .. math::

        \max_{i=1,\ldots,n_X} \hat{\sigma}_i / \sqrt{n} \leq \max_{\sigma},

    - the norm-1: 

    .. math::

        \sum_{i=1}^{n_X} \left|\hat{\sigma}_i / \sqrt{n}\right| \leq \max_{\sigma},

    - the norm-2: 

    .. math::

        \sqrt{\sum_{i=1}^{n_X} \left(\hat{\sigma}_i / \sqrt{n} \right)^2} \leq \max_{\sigma},

    - or disabled. 

    The type of operator on the coefficient of variation can be set using :meth:`setStandardDeviationCriterionType`.

    The default type is set by the `ExpectationSimulationAlgorithm-DefaultStandardDeviationCriterionType` key of the :class:`~openturns.ResourceMap`.

    The threshold :math:`\max_{\sigma}` can be set using :meth:`setMaximumStandardDeviation`.

    Let :math:`\max_{\sigma_1}, \ldots, \max_{\sigma_{n_X}}` be the 
    componentwise maximum standard deviations. 
    The criterion on the maximum deviation per component is defined by:

    .. math::

        \sigma_i \leq \max_{\sigma_i}

    for :math:`i = 1, \ldots, n_X`.

    The threshold vector :math:`\max_{\sigma_i}` can be set using :meth:`setMaximumStandardDeviationPerComponent`.

    By default this criterion is disabled.

    The default values of the parameters are based on the 
    following keys of the :class:`~openturns.ResourceMap`:

    - `SimulationAlgorithm-DefaultMaximumOuterSampling`,
    - `SimulationAlgorithm-DefaultMaximumCoefficientOfVariation`,
    - `SimulationAlgorithm-DefaultMaximumStandardDeviation`.

    In general, criteria based on coefficients of variation (C.O.V.) should be used because
    they guarantee a relative accuracy on the estimate of the mean.
    However, we may happen to estimate an expected value equal to zero
    (perhaps for teaching or research purposes).
    The default value of `SimulationAlgorithm-DefaultMaximumStandardDeviation` is
    :math:`0`, which means that standard deviation-based criteria are disabled by default
    (in order to let C.O.V.-based criteria be used by default).
    If the expected value of :math:`\vect{X}` is zero,
    the algorithm is likely to reach the maximum number of outer iterations.
    If this happens, please configure the maximum standard deviation
    in order to match the scale of the random variable at hand.

    See also
    --------
    ExpectationSimulationResult, SimulationAlgorithm

    Examples
    --------

    In the following example, we perform at most :math:`8 \times 10000 = 80000` evaluations 
    of the model. 
    However, the algorithm may stop earlier if the coefficient of variation 
    of the sample mean falls below the threshold. 

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Create a composite random vector
    >>> model = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0] * 4, ot.IdentityMatrix(4))
    >>> vect = ot.RandomVector(distribution)
    >>> X = ot.CompositeRandomVector(model, vect)
    >>> algo = ot.ExpectationSimulationAlgorithm(X)
    >>> algo.setMaximumOuterSampling(10000)
    >>> algo.setBlockSize(8)  # The number of cores we usually have.
    >>> algo.setMaximumCoefficientOfVariation(0.01)  # 1% C.O.V.
    >>> algo.run()
    >>> result = algo.getResult()
    >>> expectation = result.getExpectationEstimate()
    >>> print(expectation)
    [-1.41067]

    The following statement retrieves the asymptotically Gaussian distribution 
    of the sample mean. 
    This may be useful for users who want to compute a confidence interval of 
    the sample mean. 

    >>> expectationDistribution = result.getExpectationDistribution()

    The following code prints the outer sample (i.e. the number of outer iterations 
    of the algorithm) and the sample size. 
    We see that the algorithm stops based on the accuracy criterion. 

    >>> outer_sampling = result.getOuterSampling()
    >>> print('outer_sampling=', outer_sampling)
    outer_sampling= 1662
    >>> block_size = result.getBlockSize()
    >>> sample_size = outer_sampling * block_size
    >>> print('sample_size=', sample_size)
    sample_size= 13296

    In the following example, we disable the coefficient of variation criterion. 
    Therefore, the only remaining criterion is based on the number of iterations. 

    >>> algo = ot.ExpectationSimulationAlgorithm(X)
    >>> algo.setMaximumOuterSampling(1000)
    >>> algo.setBlockSize(1)
    >>> algo.setCoefficientOfVariationCriterionType('NONE')
    >>> algo.run()
    >>> result = algo.getResult()
    >>> outer_sampling = result.getOuterSampling()
    >>> print('outer_sampling=', outer_sampling)
    outer_sampling= 1000

    In the following example, we compute the mean of a dimension 4 random vector. 
    We use a standard deviation-based stopping criterion with a different threshold for every component. 
    We must disable the coefficient of variation-based stopping criterion, otherwise,
    in this example, it will trigger first.
    The comparison with the exact mean is satisfactory, given the relatively 
    small sample size.

    >>> from openturns.usecases import cantilever_beam
    >>> cb = cantilever_beam.CantileverBeam()
    >>> sigma = cb.distribution.getStandardDeviation()
    >>> print('sigma=', sigma)
    sigma= [1.73582e+09,30,0.0288675,7.10585e-09]
    >>> componentwise_max_sigma = sigma / 32.0
    >>> print('componentwise_max_sigma=', componentwise_max_sigma)
    componentwise_max_sigma= [5.42445e+07,0.9375,0.00090211,2.22058e-10]
    >>> X = ot.RandomVector(cb.distribution)
    >>> algo = ot.ExpectationSimulationAlgorithm(X)
    >>> algo.setMaximumOuterSampling(1000)
    >>> algo.setBlockSize(8)
    >>> algo.setCoefficientOfVariationCriterionType('NONE')
    >>> algo.setMaximumStandardDeviationPerComponent(componentwise_max_sigma)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> expectation = result.getExpectationEstimate()
    >>> outer_sampling = result.getOuterSampling()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.ExpectationSimulationAlgorithm_getClassName(self)

    def __init__(self, *args):
        _simulation.ExpectationSimulationAlgorithm_swiginit(self, _simulation.new_ExpectationSimulationAlgorithm(*args))

    def getRandomVector(self):
        r"""
        Accessor to the random vector.

        Returns
        -------
        X : :class:`~openturns.RandomVector`
            Random vector we want to study.
        """
        return _simulation.ExpectationSimulationAlgorithm_getRandomVector(self)

    def getResult(self):
        r"""
        Accessor to the result.

        Returns
        -------
        result : :class:`~openturns.ExpectationSimulationResult`
            The simulation result.
        """
        return _simulation.ExpectationSimulationAlgorithm_getResult(self)

    def setCoefficientOfVariationCriterionType(self, criterionType):
        r"""
        Accessor to the criterion operator.

        Parameters
        ----------
        result : str
            The criterion operator, either NONE, MAX, NORM1 or NORM2.
        """
        return _simulation.ExpectationSimulationAlgorithm_setCoefficientOfVariationCriterionType(self, criterionType)

    def getCoefficientOfVariationCriterionType(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        result : str
            The criterion operator.
        """
        return _simulation.ExpectationSimulationAlgorithm_getCoefficientOfVariationCriterionType(self)

    def setStandardDeviationCriterionType(self, criterionType):
        r"""
        Accessor to the criterion operator.

        Parameters
        ----------
        result : str
            The criterion operator, either NONE, MAX, NORM1 or NORM2
        """
        return _simulation.ExpectationSimulationAlgorithm_setStandardDeviationCriterionType(self, criterionType)

    def getStandardDeviationCriterionType(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        result : str
            The criterion operator.
        """
        return _simulation.ExpectationSimulationAlgorithm_getStandardDeviationCriterionType(self)

    def setMaximumStandardDeviationPerComponent(self, maximumStandardDeviation):
        r"""
        Accessor to the maximum standard deviation.

        Parameters
        ----------
        sigmaMax : sequence of float
            The maximum standard deviation on each component.

            If empty, the stopping criterion is not applied.
        """
        return _simulation.ExpectationSimulationAlgorithm_setMaximumStandardDeviationPerComponent(self, maximumStandardDeviation)

    def getMaximumStandardDeviationPerComponent(self):
        r"""
        Accessor to the maximum standard deviation.

        Returns
        -------
        sigmaMax : sequence of float
            The maximum standard deviation on each component.
        """
        return _simulation.ExpectationSimulationAlgorithm_getMaximumStandardDeviationPerComponent(self)

    def __repr__(self):
        return _simulation.ExpectationSimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.ExpectationSimulationAlgorithm_run(self)

    def drawExpectationConvergence(self, *args):
        r"""
        Draw the expectation convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _simulation.ExpectationSimulationAlgorithm_drawExpectationConvergence(self, *args)
    __swig_destroy__ = _simulation.delete_ExpectationSimulationAlgorithm

# Register ExpectationSimulationAlgorithm in _simulation:
_simulation.ExpectationSimulationAlgorithm_swigregister(ExpectationSimulationAlgorithm)
class SobolSimulationResult(SimulationResult):
    r"""
    Sobol simulation result.

    Gathers the results of a :class:`~openturns.SobolSimulationAlgorithm`
    algorithm.

    Parameters
    ----------
    fo_dist : :class:`~openturns.Distribution`
        The random vector to study.
    to_dist : :class:`~openturns.Distribution`
        The function to study.
    outer_sampling : int
        The number of iterations.
    experiment_size : int
        The Sobol' experiment size
    block_size : int
        The block size.

    See also
    --------
    SobolSimulationAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> fo_dist = ot.Normal([0.154081,0.872087,0.0122877,0.0433801], [0.00982468,0.0302524,0.00911937,0.00926643], ot.CorrelationMatrix(4))
    >>> to_dist = ot.Normal([0.16743,0.795477,0.0124454,0.045178], [0.0068919,0.00950876,0.00204324,0.0038844], ot.CorrelationMatrix(4))
    >>> result = ot.SobolSimulationResult(fo_dist, to_dist, 250, 100, 1)
    >>> fo = result.getFirstOrderIndicesEstimate()
    >>> to = result.getTotalOrderIndicesEstimate()
    >>> fo_dist = result.getFirstOrderIndicesDistribution()
    >>> to_dist = result.getTotalOrderIndicesDistribution()
    >>> graph = result.draw()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SobolSimulationResult_getClassName(self)

    def getFirstOrderIndicesEstimate(self):
        r"""
        Accessor to the first order indices estimate.

        Returns
        -------
        estimate : :class:`~openturns.Point`
            Estimate of the first order indices.
        """
        return _simulation.SobolSimulationResult_getFirstOrderIndicesEstimate(self)

    def getTotalOrderIndicesEstimate(self):
        r"""
        Accessor to the total order indices estimate.

        Returns
        -------
        estimate : :class:`~openturns.Point`
            Estimate of the total order indices.
        """
        return _simulation.SobolSimulationResult_getTotalOrderIndicesEstimate(self)

    def setFirstOrderIndicesDistribution(self, firstOrderIndicesDistribution):
        r"""
        Accessor to the first order indices distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the first order indices.
        """
        return _simulation.SobolSimulationResult_setFirstOrderIndicesDistribution(self, firstOrderIndicesDistribution)

    def setTotalOrderIndicesDistribution(self, totalOrderIndicesDistribution):
        r"""
        Accessor to the total order indices distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the total order indices.
        """
        return _simulation.SobolSimulationResult_setTotalOrderIndicesDistribution(self, totalOrderIndicesDistribution)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Accessor to the first order indices distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the first order indices.
        """
        return _simulation.SobolSimulationResult_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Accessor to the total order indices distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the total order indices.
        """
        return _simulation.SobolSimulationResult_getTotalOrderIndicesDistribution(self)

    def setExperimentSize(self, experimentSize):
        r"""
        Accessor to the experiment size.

        Parameters
        ----------
        size : int
            Internal size :math:`N` of the Sobol design of experiment.
            See :class:`~openturns.SobolIndicesExperiment`
        """
        return _simulation.SobolSimulationResult_setExperimentSize(self, experimentSize)

    def getExperimentSize(self):
        r"""
        Accessor to the experiment size.

        Returns
        -------
        size : int
            Internal size :math:`N` of the Sobol design of experiment.
            See :class:`~openturns.SobolIndicesExperiment`
        """
        return _simulation.SobolSimulationResult_getExperimentSize(self)

    def __repr__(self):
        return _simulation.SobolSimulationResult___repr__(self)

    def draw(self, confidenceLevel=0.95):
        r"""
        Draw sensitivity indices.

        Parameters
        ----------
        confidence_level : float, default=0.95
            Confidence level for intervals

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.
        """
        return _simulation.SobolSimulationResult_draw(self, confidenceLevel)

    def __init__(self, *args):
        _simulation.SobolSimulationResult_swiginit(self, _simulation.new_SobolSimulationResult(*args))
    __swig_destroy__ = _simulation.delete_SobolSimulationResult

# Register SobolSimulationResult in _simulation:
_simulation.SobolSimulationResult_swigregister(SobolSimulationResult)
class SobolSimulationAlgorithm(SimulationAlgorithm):
    r"""
    Sobol indices computation using iterative sampling.

    The algorithm uses sampling of the distribution of the random vector :math:`\vect{X}` through the model :math:`f`
    to iteratively estimate the Sobol indices.

    At each iteration a Sobol' experiment is generated and evaluated by blocks through the model :math:`f`.
    Then the distribution of the indices (first and total order) is computed on this current replication sample.
    At the end of each iteration we update the global distribution of the indices.

    Parameters
    ----------
    X : :class:`~openturns.Distribution`
        The random vector to study.
    f : :class:`~openturns.Function`
        The function to study.
    estimator : :class:`~openturns.SobolIndicesAlgorithm`
        The estimator of the indices.

    Notes
    -----
    The algorithm can operate on a multivariate model :math:`f`, in this case it operates on aggregated indices.

    Several estimators are available (Saltelli, Jansen, ...).

    Let us denote by :math:`n_X` the number of input variables. 
    For any :math:`j = 1, \ldots, n_X`, let us denote by :math:`\Phi_j^F` (resp. :math:`\Phi_j^T`) the cumulative distribution 
    function of the gaussian asymptotic distribution of the estimator 
    of the Sobol' first (resp. total) order indice.
    Let :math:`\alpha\in[0,1]` be the level of the confidence interval and :math:`\epsilon\in(0,1]` the 
    length of this confidence interval. 
    The algorithms stops when, on all components, first and total order indices haved been 
    estimated with enough precision.

    The precision is said to be sufficient if the length of the :math:`\alpha`-level confidence interval 
    is smaller than :math:`\epsilon`:

    .. math::

        (\Phi_j^F)^{-1}(1-\alpha/2) - (\Phi_j^F)^{-1}(\alpha/2) \leq \epsilon \textrm{ and } 
        (\Phi_j^T)^{-1}(1-\alpha/2) - (\Phi_j^T)^{-1}(\alpha/2) \leq \epsilon

    for all :math:`j = 1, \ldots, n_X`.

    The total number of samples evaluated by the algorithm is :math:`n_{iter} \times N \times (2 + n_X)` (no second order indices) where

    - :math:`n_{iter}` is the actual number of outer iterations, as caped by :meth:`setMaximumOuterSampling`
    - :math:`N` is the internal size of the Sobol' experiment, as set by :meth:`setExperimentSize`
    - :math:`n_X` is the input dimension

    That is why unlike other simulation algorithms the total of evaluations is not equal to
    the product of iterations (obtained by `getOuterSampling` from the result) by the block size (:meth:`getBlockSize`).

    This class makes use of the following :class:`~openturns.ResourceMap` entries:

    - `SobolSimulationAlgorithm-DefaultIndexQuantileLevel`: default float value for the confidence level :math:`\alpha`
    - `SobolSimulationAlgorithm-DefaultIndexQuantileEpsilon`: default float value for the confidence length :math:`\epsilon`
    - `SobolSimulationAlgorithm-DefaultExperimentSize`: default integer value for :math:`N`

    See also
    --------
    SobolSimulationResult, SobolIndicesExperiment, SobolIndicesAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.JointDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> model = ot.SymbolicFunction(['x1', 'x2', 'x3'], ['x1*x2+x3'])
    >>> estimator = ot.SaltelliSensitivityAlgorithm()
    >>> estimator.setUseAsymptoticDistribution(True)
    >>> algo = ot.SobolSimulationAlgorithm(distribution, model, estimator)
    >>> algo.setMaximumOuterSampling(25)  # maximum number of iterations
    >>> algo.setExperimentSize(100)  # size of Sobol experiment at each iteration
    >>> algo.setBlockSize(4) # number of points evaluated simultaneously
    >>> algo.setIndexQuantileLevel(0.05)  # alpha
    >>> algo.setIndexQuantileEpsilon(1e-2)  # epsilon
    >>> algo.run()
    >>> result = algo.getResult()
    >>> fo = result.getFirstOrderIndicesEstimate()
    >>> foDist = result.getFirstOrderIndicesDistribution()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SobolSimulationAlgorithm_getClassName(self)

    def __init__(self, *args):
        _simulation.SobolSimulationAlgorithm_swiginit(self, _simulation.new_SobolSimulationAlgorithm(*args))

    def getDistribution(self):
        r"""
        Accessor to the batch size.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the random variable.
        """
        return _simulation.SobolSimulationAlgorithm_getDistribution(self)

    def getResult(self):
        r"""
        Accessor to the result.

        Returns
        -------
        result : :class:`~openturns.SobolSimulationResult`
            The simulation result.
        """
        return _simulation.SobolSimulationAlgorithm_getResult(self)

    def setIndexQuantileLevel(self, indexQuantileLevel):
        r"""
        Accessor to the quantile level.

        Parameters
        ----------
        alpha : float
            The quantile level.
        """
        return _simulation.SobolSimulationAlgorithm_setIndexQuantileLevel(self, indexQuantileLevel)

    def getIndexQuantileLevel(self):
        r"""
        Accessor to the quantile level.

        Returns
        -------
        alpha : float
            The quantile level.
        """
        return _simulation.SobolSimulationAlgorithm_getIndexQuantileLevel(self)

    def setIndexQuantileEpsilon(self, indexQuantileEpsilon):
        r"""
        Accessor to the quantile tolerance.

        Parameters
        ----------
        epsilon : float
            The quantile tolerance
        """
        return _simulation.SobolSimulationAlgorithm_setIndexQuantileEpsilon(self, indexQuantileEpsilon)

    def getIndexQuantileEpsilon(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        epsilon : float
            The quantile tolerance
        """
        return _simulation.SobolSimulationAlgorithm_getIndexQuantileEpsilon(self)

    def setEstimator(self, estimator):
        r"""
        Sobol estimator accessor.

        Parameters
        ----------
        estimator : :class:`~openturns.SobolIndicesAlgorithm`
            The estimator of the indices.
        """
        return _simulation.SobolSimulationAlgorithm_setEstimator(self, estimator)

    def getEstimator(self):
        r"""
        Sobol estimator accessor.

        Returns
        -------
        estimator : :class:`~openturns.SobolIndicesAlgorithm`
            The estimator of the indices.
        """
        return _simulation.SobolSimulationAlgorithm_getEstimator(self)

    def setExperimentSize(self, experimentSize):
        r"""
        Accessor to the experiment size.

        Parameters
        ----------
        size : int
            Internal size :math:`N` of the Sobol design of experiment.
            See :class:`~openturns.SobolIndicesExperiment`
        """
        return _simulation.SobolSimulationAlgorithm_setExperimentSize(self, experimentSize)

    def getExperimentSize(self):
        r"""
        Accessor to the experiment size.

        Returns
        -------
        size : int
            Internal size :math:`N` of the Sobol design of experiment.
            See :class:`~openturns.SobolIndicesExperiment`
        """
        return _simulation.SobolSimulationAlgorithm_getExperimentSize(self)

    def __repr__(self):
        return _simulation.SobolSimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.SobolSimulationAlgorithm_run(self)

    def drawFirstOrderIndexConvergence(self, *args):
        r"""
        Draw the first order Sobol index convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _simulation.SobolSimulationAlgorithm_drawFirstOrderIndexConvergence(self, *args)

    def drawTotalOrderIndexConvergence(self, *args):
        r"""
        Draw the total order Sobol index convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _simulation.SobolSimulationAlgorithm_drawTotalOrderIndexConvergence(self, *args)
    __swig_destroy__ = _simulation.delete_SobolSimulationAlgorithm

# Register SobolSimulationAlgorithm in _simulation:
_simulation.SobolSimulationAlgorithm_swigregister(SobolSimulationAlgorithm)
class NAISResult(ProbabilitySimulationResult):
    r"""
    NAIS result.

    See also
    --------
    NAIS, SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.NAISResult_getClassName(self)

    def getAuxiliaryInputSample(self):
        r"""
        Accessor of the auxiliary distribution input sample at the final NAIS step.

        Returns
        -------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final NAIS step.
        """
        return _simulation.NAISResult_getAuxiliaryInputSample(self)

    def setAuxiliaryInputSample(self, auxiliaryInputSample):
        r"""
        Accessor of the auxiliary distribution input sample at the final NAIS step.

        Parameters
        ----------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final NAIS step.
        """
        return _simulation.NAISResult_setAuxiliaryInputSample(self, auxiliaryInputSample)

    def getWeights(self):
        r"""
        Auxiliary distribution input sample associated weights accessor of the final NAIS step.

        Returns
        -------
        weights : :class:`~openturns.Point`
            Auxiliary distribution input sample associated weights.
        """
        return _simulation.NAISResult_getWeights(self)

    def setWeights(self, weights):
        r"""
        Auxiliary distribution input sample associated weights accessor of the final NAIS step.

        Parameters
        ----------
        weights : :class:`~openturns.Point`
            Auxiliary distribution input sample associated weights.
        """
        return _simulation.NAISResult_setWeights(self, weights)

    def getAuxiliaryOutputSample(self):
        r"""
        Accessor of the auxiliary distribution output sample at the final NAIS step.

        Returns
        -------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final NAIS step.
        """
        return _simulation.NAISResult_getAuxiliaryOutputSample(self)

    def setAuxiliaryOutputSample(self, auxiliaryInputSample):
        r"""
        Accessor of the auxiliary distribution output sample at the final NAIS step.

        Parameters
        ----------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final NAIS step.
        """
        return _simulation.NAISResult_setAuxiliaryOutputSample(self, auxiliaryInputSample)

    def getAuxiliaryDistribution(self):
        r"""
        Accessor of the auxiliary distribution at the final NAIS step.

        Returns
        -------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final NAIS step.
        """
        return _simulation.NAISResult_getAuxiliaryDistribution(self)

    def setAuxiliaryDistribution(self, auxiliaryDistribution):
        r"""
        Accessor of the auxiliary distribution at the final NAIS step.

        Parameters
        ----------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final NAIS step.
        """
        return _simulation.NAISResult_setAuxiliaryDistribution(self, auxiliaryDistribution)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _simulation.NAISResult_getCoefficientOfVariation(self)

    def __init__(self, *args):
        _simulation.NAISResult_swiginit(self, _simulation.new_NAISResult(*args))
    __swig_destroy__ = _simulation.delete_NAISResult

# Register NAISResult in _simulation:
_simulation.NAISResult_swigregister(NAISResult)
class NAIS(EventSimulation):
    r"""
    Nonparametric Adaptive Importance Sampling (NAIS) algorithm.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.

    quantileLevel : float  :math:`0<quantileLevel<1`
        Intermediate quantile level.

    Notes
    -----
    The following explanations are given for a failure event defined as :math:`g(\mathbf{X})<T` with :math:`\mathbf{X}` 
    a random vector following a joint PDF :math:`f_\mathbf{X}`, :math:`T` a threshold and :math:`g` a limit state function,
    without loss of generality.

    The Importance Sampling (IS) probability estimate :math:`\widehat{P}^\text{IS}` is given by:

    .. math::

        \widehat{P}^\text{IS}=\frac{1}{N} \sum_{i=1}^{N} {\mathbf{1}}_{g(\mathbf{x}_i)<T} \frac{h_0(\mathbf{x}_i)}{h(\mathbf{x}_i)},

    with :math:`h_0 = f_\mathbf{X}` the PDF of :math:`\mathbf{X}`, :math:`h` the auxiliary PDF of Importance Sampling, 
    :math:`N` the number of independent samples generated with :math:`h` and :math:`{\mathbf{1}}_{g(\mathbf{x}_i)<T}` the 
    indicator function of the failure domain. 

    The optimal density minimizing the variance of the estimator :math:`h_{opt}` is defined as:

    .. math::

        h_{opt}=\frac{{\mathbf{1}}_{g(x)<T}h_0}{P},

    with :math:`P` the failure probability which is inaccessible in practice since this probability is the quantity of interest
    and unknown. 

    The objective of Non parametric Adaptive Importance Sampling (NAIS) [morio2015]_ is to approximate 
    the IS optimal auxiliary density :math:`h_{opt}` from the preceding equation 
    with a kernel density function (e.g. Gaussian kernel). 
    Its iterative principle is described by the following steps.

    1. :math:`k=1` and set the quantile level :math:`\rho \in [0,1]`

    2. Generate the population :math:`\mathbf{x}_1^{(k)},...,\mathbf{x}_N^{(k)}` according to the PDF :math:`h_{k-1}`, apply the 
       function :math:`g` in order to have :math:`y_1^{(k)}=g(\mathbf{x}_1^{(k)}),...,y_N^{(k)} = g(\mathbf{x}_N^{(k)})`

    3. Compute the empirical quantile of level :math:`\rho` :math:`q_k=\max(T,y^{(k)}_{\left \lfloor \rho N \right\rfloor})`

    4. Estimate :math:`I_k= \frac{1}{kN} \displaystyle \sum_{j=1}^{k}\sum_{i=1}^{N} {\mathbf{1}}_{g(\mathbf{x}_i^{(j)}) \leq q_k} \frac{h_0(\mathbf{x}_i^{(j)})}{h_{j-1}(\mathbf{x}_i^{(j)})}` 

    5. Update the Gaussian kernel sampling PDF with:

       .. math::

           h_{k}(\mathbf{x})=\frac{1}{k N I_k \det\left(B_{k+1}\right)}\sum_{j=1}^{k}\sum_{i=1}^{N}  w_{j}(\mathbf{x}_i^{(j)})K_d\left(B_{k+1}^{-1}\left(\mathbf{x}-\mathbf{x}_i^{(j)}\right)\right)

       where :math:`K_d` is the PDF of the standard :math:`d`-dimensional normal distribution,
       :math:`B_{k+1}=\text{diag}(b^1_{k+1},...,b^d_{k+1})` 
       and :math:`w_j={\mathbf{1}}_{g(\mathbf{x}_i^{(j)}) \leq q_k} \frac{h_0(\mathbf{x}_i^{(j)})}{h_{j-1}(\mathbf{x}_i^{(j)})}`. 
       The coefficients of the matrix :math:`B_{k+1}` can be approximated (Silverman Rule) or postulated according to the AMISE 
       (Asymptotic Mean Integrated Square Error) criterion for example.

    6. If :math:`q_k>T`, :math:`k\leftarrow k+1`, go to Step 2

    7. Estimate the probability :math:`\widehat{P}^{NAIS}(g(\mathbf{\mathbf{X}}<T))=\frac{1}{N}\displaystyle \sum_{i=1}^{N} \mathbf{1}_{g(\mathbf{x}_i^{(k)})<T} \frac{h_0(\mathbf{x}_i^{(k)})}{h_{k-1}(\mathbf{x}_i^{(k)})}`

    The NAIS algorithm with the Silverman rule is implemented in the current NAIS class.

    See also
    --------
    SubsetSampling

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # We create the function defining the limit state
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> # We define a joint PDF of interest 
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.CompositeRandomVector(myFunction, vect)
    >>> # We create an event from this RandomVector
    >>> myEvent = ot.ThresholdEvent(output, ot.Less(), -10.0)
    >>> # We create a NAIS algorithm
    >>> algo = ot.NAIS(myEvent, 0.1)
    >>> # Perform the simulation
    >>> algo.run()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.NAIS_getClassName(self)

    def getQuantileLevel(self):
        r"""
        Accessor to the intermediate quantile level.

        Returns
        -------
        quantileLevel : float
            Intermediate quantile level.
        """
        return _simulation.NAIS_getQuantileLevel(self)

    def setQuantileLevel(self, quantileLevel):
        r"""
        Accessor to the intermediate quantile level.

        Parameters
        ----------
        quantileLevel : float  :math:`0<quantileLevel<1`
            Intermediate quantile level.
        """
        return _simulation.NAIS_setQuantileLevel(self, quantileLevel)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        openturns.EventSimulation.setBlockSize
        openturns.EventSimulation.setMaximumOuterSampling
        openturns.ResourceMap
        openturns.SimulationResult
        """
        return _simulation.NAIS_run(self)

    def getResult(self):
        r"""
        Accessor to the results.

        Returns
        -------
        results : :class:`~openturns.SimulationResult`
            Structure containing all the results obtained after simulation and created
            by the method :py:meth:`run`.
        """
        return _simulation.NAIS_getResult(self)

    def getThresholdPerStep(self):
        r"""
        Threshold accessor.

        Returns
        -------
        threshold : :class:`~openturns.Point`
            Threshold values at each step.
        """
        return _simulation.NAIS_getThresholdPerStep(self)

    def getStepsNumber(self):
        r"""
        Subset steps number accessor.

        Returns
        -------
        n : int
            Number of subset steps, including the initial Monte Carlo sampling.
        """
        return _simulation.NAIS_getStepsNumber(self)

    def setKeepSample(self, keepSample):
        r"""
        Sample storage accessor.

        Parameters
        ----------
        keepsample : bool
            Whether to keep the working samples at each iteration.
        """
        return _simulation.NAIS_setKeepSample(self, keepSample)
    EVENT0 = _simulation.NAIS_EVENT0
    EVENT1 = _simulation.NAIS_EVENT1
    BOTH = _simulation.NAIS_BOTH

    def getInputSample(self, *args):
        r"""
        Input sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _simulation.NAIS_getInputSample(self, *args)

    def getOutputSample(self, *args):
        r"""
        Output sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample.
        """
        return _simulation.NAIS_getOutputSample(self, *args)

    def __init__(self, *args):
        _simulation.NAIS_swiginit(self, _simulation.new_NAIS(*args))
    __swig_destroy__ = _simulation.delete_NAIS

# Register NAIS in _simulation:
_simulation.NAIS_swigregister(NAIS)
class CrossEntropyResult(ProbabilitySimulationResult):
    r"""
    Cross Entropy result.

    See also
    --------
    CrossEntropyImportanceSampling, PhysicalSpaceCrossEntropyImportanceSampling, StandardSpaceCrossEntropyImportanceSampling
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.CrossEntropyResult_getClassName(self)

    def getAuxiliaryInputSample(self):
        r"""
        Accessor to the auxiliary distribution input sample at the final Cross Entropy algorithm step.

        Returns
        -------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final Cross Entropy algorithm step.
        """
        return _simulation.CrossEntropyResult_getAuxiliaryInputSample(self)

    def setAuxiliaryInputSample(self, auxiliaryInputSample):
        r"""
        Accessor to the auxiliary distribution input sample at the final Cross Entropy algorithm step.

        Parameters
        ----------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final Cross Entropy algorithm step.
        """
        return _simulation.CrossEntropyResult_setAuxiliaryInputSample(self, auxiliaryInputSample)

    def getAuxiliaryOutputSample(self):
        r"""
        Accessor to the auxiliary distribution output sample at the final Cross Entropy algorithm step.

        Returns
        -------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final Cross Entropy algorithm step.
        """
        return _simulation.CrossEntropyResult_getAuxiliaryOutputSample(self)

    def setAuxiliaryOutputSample(self, auxiliaryInputSample):
        r"""
        Accessor to the auxiliary distribution output sample at the final Cross Entropy algorithm step.

        Parameters
        ----------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final Cross Entropy algorithm step.
        """
        return _simulation.CrossEntropyResult_setAuxiliaryOutputSample(self, auxiliaryInputSample)

    def getAuxiliaryDistribution(self):
        r"""
        Accessor to the auxiliary distribution at the final Cross Entropy algorithm step.

        Returns
        -------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final Cross Entropy algorithm step.
        """
        return _simulation.CrossEntropyResult_getAuxiliaryDistribution(self)

    def setAuxiliaryDistribution(self, auxiliaryDistribution):
        r"""
        Accessor to the auxiliary distribution at the final Cross Entropy algorithm step.

        Parameters
        ----------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final Cross Entropy algorithm step.
        """
        return _simulation.CrossEntropyResult_setAuxiliaryDistribution(self, auxiliaryDistribution)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _simulation.CrossEntropyResult_getCoefficientOfVariation(self)

    def __init__(self, *args):
        _simulation.CrossEntropyResult_swiginit(self, _simulation.new_CrossEntropyResult(*args))
    __swig_destroy__ = _simulation.delete_CrossEntropyResult

# Register CrossEntropyResult in _simulation:
_simulation.CrossEntropyResult_swigregister(CrossEntropyResult)
class CrossEntropyImportanceSampling(EventSimulation):
    r"""
    Cross-Entropy Importance Sampling algorithm.

    See also
    --------
    StandardSpaceCrossEntropyImportanceSampling, PhysicalSpaceCrossEntropyImportanceSampling, CrossEntropyResult

    Notes
    -----
    This class inherits from :class:`~openturns.EventSimulation`.

    The principle is to perform a simulation study to evaluate the threshold exceedance probability according to an importance density obtained using Cross Entropy algorithm.

    A CrossEntropyImportanceSampling object can be created only through its derivative classes,
    :class:`~openturns.StandardSpaceCrossEntropyImportanceSampling` or :class:`~openturns.PhysicalSpaceCrossEntropyImportanceSampling`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.CrossEntropyImportanceSampling_getClassName(self)

    def getQuantileLevel(self):
        r"""
        Accessor to the intermediate quantile level.

        Returns
        -------
        quantileLevel : float
            Result of Cross Entropy algorithm.
        """
        return _simulation.CrossEntropyImportanceSampling_getQuantileLevel(self)

    def setQuantileLevel(self, quantileLevel):
        r"""
        Accessor to the intermediate quantile level.

        Parameters
        ----------
        quantileLevel : float
            Intermediate quantile level, must belong to the interval (0,1).
        """
        return _simulation.CrossEntropyImportanceSampling_setQuantileLevel(self, quantileLevel)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        openturns.EventSimulation.setBlockSize
        openturns.EventSimulation.setMaximumOuterSampling
        openturns.ResourceMap
        openturns.SimulationResult
        """
        return _simulation.CrossEntropyImportanceSampling_run(self)

    def getResult(self):
        r"""
        Accessor to the intermediate quantile level.

        Returns
        -------
        CrossEntropyResult : :class:`~openturns.CrossEntropyResult`
            Contains all the results of the Cross Entropy algorithm simulation.
        """
        return _simulation.CrossEntropyImportanceSampling_getResult(self)

    def getThresholdPerStep(self):
        r"""
        Threshold accessor.

        Returns
        -------
        threshold : :class:`~openturns.Point`
            Threshold values at each step.
        """
        return _simulation.CrossEntropyImportanceSampling_getThresholdPerStep(self)

    def getStepsNumber(self):
        r"""
        Subset steps number accessor.

        Returns
        -------
        n : int
            Number of subset steps, including the initial Monte Carlo sampling.
        """
        return _simulation.CrossEntropyImportanceSampling_getStepsNumber(self)

    def setKeepSample(self, keepSample):
        r"""
        Sample storage accessor.

        Parameters
        ----------
        keepsample : bool
            Whether to keep the working samples at each iteration.
        """
        return _simulation.CrossEntropyImportanceSampling_setKeepSample(self, keepSample)
    EVENT0 = _simulation.CrossEntropyImportanceSampling_EVENT0
    EVENT1 = _simulation.CrossEntropyImportanceSampling_EVENT1
    BOTH = _simulation.CrossEntropyImportanceSampling_BOTH

    def getInputSample(self, *args):
        r"""
        Input sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _simulation.CrossEntropyImportanceSampling_getInputSample(self, *args)

    def getOutputSample(self, *args):
        r"""
        Output sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample.
        """
        return _simulation.CrossEntropyImportanceSampling_getOutputSample(self, *args)

    def __init__(self, *args):
        _simulation.CrossEntropyImportanceSampling_swiginit(self, _simulation.new_CrossEntropyImportanceSampling(*args))
    __swig_destroy__ = _simulation.delete_CrossEntropyImportanceSampling

# Register CrossEntropyImportanceSampling in _simulation:
_simulation.CrossEntropyImportanceSampling_swigregister(CrossEntropyImportanceSampling)
class StandardSpaceCrossEntropyImportanceSampling(CrossEntropyImportanceSampling):
    r"""
    Standard Space Cross-Entropy Importance Sampling.

    Parameters
    ----------
    event : :class:`~openturns.ThresholdEvent`
        Event we are computing the probability of.

    quantileLevel : float  :math:`0<quantileLevel<1`
        Intermediate quantile level. The default number can be tweaked with the `CrossEntropyImportanceSampling-DefaultQuantileLevel` key from :class:`~openturns.ResourceMap`.

    Notes
    -----
    The following explanations are given for a failure event defined as :math:`g(\vect{X})<T` with :math:`\vect{X}` 
    a random vector following a joint PDF :math:`f_\vect{X}`, :math:`T` a threshold and :math:`g` a limit state function,
    without loss of generality.

    The Importance Sampling (IS) probability estimate :math:`\widehat{P}^\text{IS}` is given by:

    .. math::

        \widehat{P}^\text{IS}=\frac{1}{N} \sum_{i=1}^{N} {\vect{1}}_{g(\vect{x}_i)<T} \frac{f_\vect{X}(\vect{x}_i)}{h(\vect{x}_i)},

    with :math:`h` the auxiliary PDF of Importance Sampling, 
    :math:`N` the number of independent samples generated with :math:`h` and :math:`{\vect{1}}_{g(\vect{x}_i)<T}` the 
    indicator function of the failure domain. 

    The optimal density :math:`h_{opt}` minimizing the variance of the estimator :math:`h_{opt}` is defined as:

    .. math::

        h_{opt}=\frac{{\vect{1}}_{g(\vect{x})<T}f_\vect{X}}{P},

    with :math:`P` the failure probability which is inaccessible in practice since this probability is the quantity of interest and unknown.

    The Standard Space Cross-Entropy Importance Sampling [rubinstein2017]_ uses a parametric auxiliary distribution :math:`h_\vect{\lambda}` in order to optimize its parameters to compute the probability of interest with accuracy. 
    This process is performed in the standard space using a Normal distribution as the auxiliary distribution. Indeed, in the standard space, the optimal value of the mean and standard deviations are given analytically, see [morio2015]_ for details. 

    We note  :math:`G(\vect{u})` the limit state function in standard space and  :math:`g(\vect{x})` its counterpart in the physical space. :math:`f_\vect{U}` stands for the initial distribution in standard space, i.e. the Normal law. The algorithm is as follows:


    1. :math:`k=1`, set the quantile level :math:`\rho \in [0,1]` and :math:`h_0 = f_{\vect{U}}`

    2. Generate the population :math:`\vect{u}_1^{(k)},...,\vect{u}_N^{(k)}` according to the PDF :math:`h_{k-1}`, apply the 
       function :math:`G` in order to have :math:`y_1^{(k)}=G(\vect{u}_1^{(k)}),...,y_N^{(k)} = G(\vect{u}_N^{(k)})`

    3. Compute the   :math:`\rho`-quantile :math:`q_k=\max(T,y^{(k)}_{\left \lfloor \rho N \right\rfloor})` using the floor of :math:`\rho N`.

    4. If :math:`q_k>T`, go to Step 7

    4. Update the mean and standard deviation of the auxiliary distribution:

    .. math::

           \mu_{k}= \frac{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} \vect{u}_i^{(k)}}{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} }

    .. math::

           \sigma_{k}= \frac{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} (\vect{u}_i^{(k)}-\mu_k)^2}{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} }


    6. :math:`k\leftarrow k+1`, go to Step 2

    7. Estimate the probability :math:`\widehat{P}^{CE}(g(\vect{\vect{X}})<T)=\widehat{P}^{CE}(G(\vect{\vect{U}})<T)=\frac{1}{N}\displaystyle \sum_{i=1}^{N} \vect{1}_{G(\vect{u}_i^{(k)})<T} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}(\vect{u}_i^{(k)})}}`




    See also
    --------
    PhysicalSpaceCrossEntropyImportanceSampling, CrossEntropyImportanceSampling, CrossEntropyResult


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution_R = ot.LogNormalMuSigma(300.0, 30.0, 0.0).getDistribution()
    >>> distribution_F = ot.Normal(75e3, 5e3)
    >>> marginals = [distribution_R, distribution_F]
    >>> distribution = ot.JointDistribution(marginals)
    >>> # create the model
    >>> model = ot.SymbolicFunction(['R', 'F'], ['R - F / (pi_ * 100.0)'])  
    >>> # create the event 
    >>> vect = ot.RandomVector(distribution)
    >>> g = ot.CompositeRandomVector(model, vect)
    >>> event = ot.ThresholdEvent(g, ot.Less(), 0.0)
    >>> myIS = ot.StandardSpaceCrossEntropyImportanceSampling(event, 0.3)
    >>> # run StandardSpaceCrossEntropyImportanceSampling
    >>> myIS.run()
    >>> myResult = myIS.getResult()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.StandardSpaceCrossEntropyImportanceSampling_getClassName(self)

    def __init__(self, *args):
        _simulation.StandardSpaceCrossEntropyImportanceSampling_swiginit(self, _simulation.new_StandardSpaceCrossEntropyImportanceSampling(*args))
    __swig_destroy__ = _simulation.delete_StandardSpaceCrossEntropyImportanceSampling

# Register StandardSpaceCrossEntropyImportanceSampling in _simulation:
_simulation.StandardSpaceCrossEntropyImportanceSampling_swigregister(StandardSpaceCrossEntropyImportanceSampling)
class PhysicalSpaceCrossEntropyImportanceSampling(CrossEntropyImportanceSampling):
    r"""
    Physical Space Cross-Entropy Importance Sampling.

    Parameters
    ----------
    event : :class:`~openturns.ThresholdEvent`
        Event we are computing the probability of.

    activeParameters : sequence of integers
        List of active parameters indices for the auxiliary distribution.

    initialAuxiliaryDistributionParameters : sequence of floats
        Initial value of active parameters of the auxiliary distribution.

    bounds : :class:`~openturns.Interval`
        Bounds on the active parameters of the auxiliary distribution.

    auxiliaryDistribution : :class:`~openturns.Distribution`
        Auxiliary distribution for the Cross Entropy Importance Sampling algorithm.

    quantileLevel : float  :math:`0<quantileLevel<1`
        Intermediate quantile level. The default number can be tweaked with the `CrossEntropyImportanceSampling-DefaultQuantileLevel` key from :class:`~openturns.ResourceMap`.

    Notes
    -----    

    The following explanations are given for a failure event defined as :math:`g(\vect{X})<T` with :math:`\vect{X}` 
    a random vector following a joint PDF :math:`f_\vect{X}`, :math:`T` a threshold and :math:`g` a limit state function,
    without loss of generality.

    The Importance Sampling (IS) probability estimate :math:`\widehat{P}^\text{IS}` is given by:

    .. math::

        \widehat{P}^\text{IS}=\frac{1}{N} \sum_{i=1}^{N} {\vect{1}}_{g(\vect{x}_i)<T} \frac{f_\vect{X}(\vect{x}_i)}{h(\vect{x}_i)},

    with :math:`h` the auxiliary PDF of Importance Sampling, 
    :math:`N` the number of independent samples generated with :math:`h` and :math:`{\vect{1}}_{g(\vect{x}_i)<T}` the 
    indicator function of the failure domain. 

    The optimal density :math:`h_{opt}` minimizing the variance of the estimator is defined as:

    .. math::

        h_{opt}=\frac{{\vect{1}}_{g(\vect{x})<T}f_\vect{X}}{P},

    with :math:`P` the failure probability which is inaccessible in practice since this probability is the quantity of interest
    and unknown.

    The Physical Space Cross-Entropy Importance Sampling algorithm [rubinstein2017]_ uses a parametric auxiliary distribution :math:`h_\vect{\lambda}` in order to optimize its parameters to compute the probability of interest with accuracy.

    It involves an auxiliary optimization problem to find the auxiliary distribution parameters :math:`\vect{\lambda}` minimizing the Kullback-Leibler divergence with respect to :math:`h_{opt}`. The following algorithm is used:

    1. :math:`k=1`, set the quantile level :math:`\rho \in [0,1]` and :math:`h_0 = f_{\vect{X}}`

    2. Generate the population :math:`\vect{x}_1^{(k)},...,\vect{x}_N^{(k)}` according to the PDF :math:`h_{k-1}`, apply the 
       function :math:`g` in order to have :math:`y_1^{(k)}=g(\vect{x}_1^{(k)}),...,y_N^{(k)} = g(\vect{x}_N^{(k)})`

    3. Compute the empirical :math:`\rho`-quantile :math:`q_k=\max(T,y^{(k)}_{\left \lfloor \rho N \right\rfloor})` using the floor of :math:`\rho N`.

    4. If :math:`q_k>T`: go to Step 7

    5. Estimate the auxiliary distribution parameters:

       .. math::

           \vect{\lambda}_{k}= \textrm{argmax}_{\lambda} \frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{g(\vect{x}_i^{(k)}) \leq q_k} \frac{f_\vect{X}(\vect{x}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{x}_i^{(k)})} \log(h_{\vect{\lambda}}(\vect{x}_i^{(k)}))

    6. :math:`k\leftarrow k+1`, go to Step 2

    7. Estimate the probability :math:`\widehat{P}^{CE}(g(\vect{\vect{X}})<T)=\frac{1}{N}\displaystyle \sum_{i=1}^{N} \vect{1}_{g(\vect{x}_i^{(k)})<T} \frac{f_\vect{X}(\vect{x}_i^{(k)})}{h_{\vect{\lambda}_{k-1}(\vect{x}_i^{(k)})}}`.


    Default solver for the optimization of auxiliary distribution is `LD_LBFGS` from :class:`~openturns.NLopt`.

    See also
    --------
    StandardSpaceCrossEntropyImportanceSampling, CrossEntropyImportanceSampling, CrossEntropyResult


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution_R = ot.LogNormalMuSigma(300.0, 30.0, 0.0).getDistribution()
    >>> distribution_F = ot.Normal(75e3, 5e3)
    >>> marginals = [distribution_R, distribution_F]
    >>> distribution = ot.JointDistribution(marginals)
    >>> # create the model
    >>> model = ot.SymbolicFunction(['R', 'F'], ['R-F/(pi_*100.0)'])   
    >>> # create the event 
    >>> vect = ot.RandomVector(distribution)
    >>> G = ot.CompositeRandomVector(model, vect)
    >>> event = ot.ThresholdEvent(G, ot.Less(), 0.0)
    >>> distribution_marginR = ot.LogNormalMuSigma().getDistribution()
    >>> distribution_marginF = ot.Normal()
    >>> aux_marginals = [distribution_marginR, distribution_marginF]
    >>> aux_distribution = ot.JointDistribution(aux_marginals)
    >>> # definition of auxiliary distribution parameters to be optimized
    >>> active_parameters = [0,1,2,3,4]
    >>> ### WARNING : native parameters of distribution have to be considered
    >>> bounds = ot.Interval([3,0.09,0.,50e3,2e3], [7,0.5,0.5,100e3,10e3])# bounds on the active parameters
    >>> initial_theta= [5.70,0.1,0.,75e3,5e3] # initial value of the active parameters
    >>> my_IS_physical = ot.PhysicalSpaceCrossEntropyImportanceSampling(event,aux_distribution,active_parameters,initial_theta,bounds,0.3)
    >>> my_IS_physical.run()
    >>> myResult = my_IS_physical.getResult()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.PhysicalSpaceCrossEntropyImportanceSampling_getClassName(self)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the optimization algorithm used to update auxiliary distribution parameters.

        Parameters
        ----------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
        """
        return _simulation.PhysicalSpaceCrossEntropyImportanceSampling_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the optimization algorithm used to update auxiliary distribution parameters.

        Returns
        -------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
        """
        return _simulation.PhysicalSpaceCrossEntropyImportanceSampling_getOptimizationAlgorithm(self)

    def __init__(self, *args):
        _simulation.PhysicalSpaceCrossEntropyImportanceSampling_swiginit(self, _simulation.new_PhysicalSpaceCrossEntropyImportanceSampling(*args))
    __swig_destroy__ = _simulation.delete_PhysicalSpaceCrossEntropyImportanceSampling

# Register PhysicalSpaceCrossEntropyImportanceSampling in _simulation:
_simulation.PhysicalSpaceCrossEntropyImportanceSampling_swigregister(PhysicalSpaceCrossEntropyImportanceSampling)
class _RootStrategyImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_simulation._RootStrategyImplementationPointer_ptr__get, _simulation._RootStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        _simulation._RootStrategyImplementationPointer_swiginit(self, _simulation.new__RootStrategyImplementationPointer(*args))
    __swig_destroy__ = _simulation.delete__RootStrategyImplementationPointer

    def reset(self):
        return _simulation._RootStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _simulation._RootStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _simulation._RootStrategyImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _simulation._RootStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _simulation._RootStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _simulation._RootStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _simulation._RootStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _simulation._RootStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _simulation._RootStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _simulation._RootStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation._RootStrategyImplementationPointer_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation._RootStrategyImplementationPointer_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation._RootStrategyImplementationPointer_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation._RootStrategyImplementationPointer_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation._RootStrategyImplementationPointer_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation._RootStrategyImplementationPointer_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation._RootStrategyImplementationPointer_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation._RootStrategyImplementationPointer_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation._RootStrategyImplementationPointer_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation._RootStrategyImplementationPointer_getOriginValue(self)

    def __repr__(self):
        return _simulation._RootStrategyImplementationPointer___repr__(self)

    def __eq__(self, other):
        return _simulation._RootStrategyImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _simulation._RootStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _simulation._RootStrategyImplementationPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _simulation._RootStrategyImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _simulation._RootStrategyImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _simulation._RootStrategyImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation._RootStrategyImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation._RootStrategyImplementationPointer_setName(self, name)

# Register _RootStrategyImplementationPointer in _simulation:
_simulation._RootStrategyImplementationPointer_swigregister(_RootStrategyImplementationPointer)
class _SamplingStrategyImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_simulation._SamplingStrategyImplementationPointer_ptr__get, _simulation._SamplingStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        _simulation._SamplingStrategyImplementationPointer_swiginit(self, _simulation.new__SamplingStrategyImplementationPointer(*args))
    __swig_destroy__ = _simulation.delete__SamplingStrategyImplementationPointer

    def reset(self):
        return _simulation._SamplingStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _simulation._SamplingStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _simulation._SamplingStrategyImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _simulation._SamplingStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _simulation._SamplingStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _simulation._SamplingStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _simulation._SamplingStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _simulation._SamplingStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _simulation._SamplingStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _simulation._SamplingStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation._SamplingStrategyImplementationPointer_getClassName(self)

    def generate(self):
        r"""
        Generate the directions.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The directions generated  according to the sampling strategy.

        Notes
        -----
        The sample is the collection of the points on the unit sphere in the standard space
        associated to the generated directions.
        """
        return _simulation._SamplingStrategyImplementationPointer_generate(self)

    def getUniformUnitVectorRealization(self, *args):
        r"""
        Accessor to a realization according to the uniform distribution.

        Parameters
        ----------
        dimension : int
            The dimension of the sphere unity (which is the dimension of the standard
            space).

        Returns
        -------
        sample : :class:`~openturns.Point`
            The realization of a vector on the sphere unity, according to the uniform
            distribution.
        """
        return _simulation._SamplingStrategyImplementationPointer_getUniformUnitVectorRealization(self, *args)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation._SamplingStrategyImplementationPointer_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation._SamplingStrategyImplementationPointer_getDimension(self)

    def __repr__(self):
        return _simulation._SamplingStrategyImplementationPointer___repr__(self)

    def __eq__(self, other):
        return _simulation._SamplingStrategyImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _simulation._SamplingStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _simulation._SamplingStrategyImplementationPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _simulation._SamplingStrategyImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _simulation._SamplingStrategyImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _simulation._SamplingStrategyImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation._SamplingStrategyImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation._SamplingStrategyImplementationPointer_setName(self, name)

# Register _SamplingStrategyImplementationPointer in _simulation:
_simulation._SamplingStrategyImplementationPointer_swigregister(_SamplingStrategyImplementationPointer)

