# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Test routines."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _testing
else:
    import _testing

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.typ
import openturns.common
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.model_copula
import openturns.base
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
class TestFailed(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, message):
        _testing.TestFailed_swiginit(self, _testing.new_TestFailed(message))
    __swig_destroy__ = _testing.delete_TestFailed

    def what(self):
        return _testing.TestFailed_what(self)

# Register TestFailed in _testing:
_testing.TestFailed_swigregister(TestFailed)

def __lshift__(os, obj):
    return _testing.__lshift__(os, obj)

def assert_almost_equal(*args):
    r"""
    Raises an exception if two objects are not equal up to desired tolerance.

    Similar to numpy.testing.assert_allclose.

    Parameters
    ----------
    a, b : float, Point, Matrix, Distribution, Mesh, Field or ProcessSample
        Elements to compare
    rtol : float
        Relative tolerance, default is 1e-5
    atol : float
        Absolute tolerance, default is 1e-8
    errMsg : str
        Error message emitted when comparison fails

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.testing as ott
    >>> dist = ot.Uniform(0.0, 1.0)
    >>> ott.assert_almost_equal(dist.getMean(), [0.5])

    """
    return _testing.assert_almost_equal(*args)
class DistributionValidation(object):
    r"""
    Automates distribution tests.

    It helps performing tests to validate :class:`~openturns.Distribution` services:

    - Comparison operators
    - PDF: analytical PDF vs finite-difference estimate from CDF
    - Log PDF: verify consistency of PDF and LogPDF values
    - DDF: analytical DDF vs finite-difference estimate from PDF
    - CCDF: verify consistency between CDF and complementary CDF
    - Survival function: verify consistency between survival and CDF values
    - Inverse survival function: verify consistency between inverse survival and survival
    - Quantile function: verify consistency between quantile and CDF values
    - Probability of an interval: verify probabilities of the range, full numerical range
    - Fitting: Pass Kolmogorov or Chi2 test for different sampling sizes
    - Entropy test: verify consistency between analytical entropy and empirical entropy
    - Moments: verify consistency between analytical moments and empirical moments
    - Parameters: verify setParameter/getParameter accessors consistency
    - Gradients: assess PDF/CDF analytical gradients consistency against their finite difference estimates
    - Minimum volume interval: verify the probability of the interval
    - Minimum volume level-set: verify the probability of the level-set
    - Confidence interval: verify the probability of the level-set
    - Characteristic function
    - Conditional PDF/CDF/Quantiles: verify consistency of sequential version
    - Iso probabilistic transformation: verify bijection and gradients

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The distribution instance to test.

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.testing as ott
    >>> dist = ot.Uniform(0.0, 1.0)
    >>> checker = ott.DistributionValidation(dist)
    >>> ot.Log.Show(ot.Log.TRACE)  # doctest: +SKIP
    >>> checker.run()  # doctest: +SKIP

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _testing.DistributionValidation_swiginit(self, _testing.new_DistributionValidation(*args))

    def run(self):
        r"""
        Run all tests.

        The method raises an exception on the first test that fails.
        Enable :class:`~openturns.Log` at `TRACE` level to see more details.
        """
        return _testing.DistributionValidation_run(self)

    def skipPDF(self):
        r"""Disables PDF test."""
        return _testing.DistributionValidation_skipPDF(self)

    def skipCDF(self):
        r"""Disables CDF test."""
        return _testing.DistributionValidation_skipCDF(self)

    def skipComplementaryCDF(self):
        r"""Disables CCDF test."""
        return _testing.DistributionValidation_skipComplementaryCDF(self)

    def skipDDF(self):
        r"""Disables DDF test."""
        return _testing.DistributionValidation_skipDDF(self)

    def skipMoments(self):
        r"""Disables moments test."""
        return _testing.DistributionValidation_skipMoments(self)

    def skipCorrelation(self):
        r"""Disables Correlation test."""
        return _testing.DistributionValidation_skipCorrelation(self)

    def skipDependenceMeasures(self):
        r"""Disables dependence measure test."""
        return _testing.DistributionValidation_skipDependenceMeasures(self)

    def skipMinimumVolumeLevelSet(self):
        r"""Disables minimum volume level set test."""
        return _testing.DistributionValidation_skipMinimumVolumeLevelSet(self)

    def skipMinimumVolumeInterval(self):
        r"""Disables minimum volume interval test."""
        return _testing.DistributionValidation_skipMinimumVolumeInterval(self)

    def skipConfidenceInterval(self):
        r"""Disables confidence interval test."""
        return _testing.DistributionValidation_skipConfidenceInterval(self)

    def skipParameters(self):
        r"""Disables parameters test."""
        return _testing.DistributionValidation_skipParameters(self)

    def skipProbability(self):
        r"""Disables probability test."""
        return _testing.DistributionValidation_skipProbability(self)

    def skipQuantile(self):
        r"""Disables quantile test."""
        return _testing.DistributionValidation_skipQuantile(self)

    def skipInverseSurvival(self):
        r"""Disables inverse survival function test."""
        return _testing.DistributionValidation_skipInverseSurvival(self)

    def skipCharacteristicFunction(self):
        r"""Disables characteristic function test."""
        return _testing.DistributionValidation_skipCharacteristicFunction(self)

    def skipGeneratingFunction(self):
        r"""Disables generating function test."""
        return _testing.DistributionValidation_skipGeneratingFunction(self)

    def skipGradient(self):
        r"""Disables PDF/CDF gradients test."""
        return _testing.DistributionValidation_skipGradient(self)

    def skipEntropy(self):
        r"""Disables entropy test."""
        return _testing.DistributionValidation_skipEntropy(self)

    def skipConditional(self):
        r"""Disables conditional test."""
        return _testing.DistributionValidation_skipConditional(self)

    def skipTransformation(self):
        r"""Disables transformation test."""
        return _testing.DistributionValidation_skipTransformation(self)

    def setEntropyTolerance(self, entropyTolerance):
        r"""
        Entropy test tolerance accessor.

        Parameters
        ----------
        entropyTolerance : float
            Relative and absolute tolerance of the analytical/empirical entropy comparison.

        """
        return _testing.DistributionValidation_setEntropyTolerance(self, entropyTolerance)

    def setCDFTolerance(self, cdfTolerance):
        r"""
        CDF test tolerance accessor.

        Parameters
        ----------
        cdfTolerance : float
            Relative and absolute tolerance of the cdf, probability, ccdf and survival tests.

        """
        return _testing.DistributionValidation_setCDFTolerance(self, cdfTolerance)

    def setPDFTolerance(self, pdfTolerance):
        r"""
        PDF test tolerance accessor.

        Parameters
        ----------
        pdfTolerance : float
            Relative and absolute tolerance of the pdf.

        """
        return _testing.DistributionValidation_setPDFTolerance(self, pdfTolerance)

    def setDDFTolerance(self, ddfTolerance):
        r"""
        DDF test tolerance accessor.

        Parameters
        ----------
        ddfTolerance : float
            Relative and absolute tolerance of the ddf.

        """
        return _testing.DistributionValidation_setDDFTolerance(self, ddfTolerance)

    def setParameterTolerance(self, parameterTolerance):
        r"""
        PDF/CDF parameter gradient test tolerance accessor.

        Parameters
        ----------
        parameterTolerance : float
            Relative and absolute tolerance of the PDF/CDF parameter gradient.

        """
        return _testing.DistributionValidation_setParameterTolerance(self, parameterTolerance)

    def setQuantileTolerance(self, quantileTolerance):
        r"""
        Quantile test tolerance accessor.

        Parameters
        ----------
        quatileTolerance : float
            Relative and absolute tolerance of the quantile and inverse survival.

        """
        return _testing.DistributionValidation_setQuantileTolerance(self, quantileTolerance)

    def setDomainTolerance(self, domainTolerance):
        r"""
        Domain test tolerance accessor.

        Parameters
        ----------
        domainTolerance : float
            Relative and absolute tolerance of the mini volume, level set or confidence interval tests.

        """
        return _testing.DistributionValidation_setDomainTolerance(self, domainTolerance)

    def setEntropySamplingSize(self, entropySamplingSize):
        r"""
        Sampling size accessor for entropy test.

        Parameters
        ----------
        entropySamplingSize : int
            Sampling size for entropy test.

        """
        return _testing.DistributionValidation_setEntropySamplingSize(self, entropySamplingSize)

    def setDomainSamplingSize(self, domainSamplingSize):
        r"""
        Sampling size accessor for domain tests.

        Parameters
        ----------
        domainSamplingSize : int
            Sampling size for domain tests (minimum volume interval, level set or confidence intervals).

        """
        return _testing.DistributionValidation_setDomainSamplingSize(self, domainSamplingSize)

    def setMeanTolerance(self, meanTolerance):
        r"""
        Mean test tolerance accessor.

        Parameters
        ----------
        meanTolerance : float
            Relative and absolute tolerance of the analytical/empirical mean comparison.

        """
        return _testing.DistributionValidation_setMeanTolerance(self, meanTolerance)

    def setStandardDeviationTolerance(self, standardDeviationTolerance):
        r"""
        Standard deviation test tolerance accessor.

        Parameters
        ----------
        standardDeviationTolerance : float
            Relative and absolute tolerance of the analytical/empirical deviation comparison.

        """
        return _testing.DistributionValidation_setStandardDeviationTolerance(self, standardDeviationTolerance)

    def setSkewnessTolerance(self, skewnessTolerance):
        r"""
        Skewness test tolerance accessor.

        Parameters
        ----------
        skewnessTolerance : float
            Relative and absolute tolerance of the analytical/empirical skewness comparison.

        """
        return _testing.DistributionValidation_setSkewnessTolerance(self, skewnessTolerance)

    def setKurtosisTolerance(self, kurtosisTolerance):
        r"""
        Kurtosis test tolerance accessor.

        Parameters
        ----------
        kurtosisTolerance : float
            Relative and absolute tolerance of the analytical/empirical kurtosis comparison.

        """
        return _testing.DistributionValidation_setKurtosisTolerance(self, kurtosisTolerance)

    def setCorrelationTolerance(self, correlationTolerance):
        r"""
        Correlation test tolerance accessor.

        Parameters
        ----------
        correlationTolerance : float
            Relative and absolute tolerance of the analytical/empirical correlations comparison.

        """
        return _testing.DistributionValidation_setCorrelationTolerance(self, correlationTolerance)

    def setMomentsSamplingSize(self, momentsSamplingSize):
        r"""
        Sampling size accessor for moments test.

        Parameters
        ----------
        momentsSamplingSize : int
            Sampling size for moments test.

        """
        return _testing.DistributionValidation_setMomentsSamplingSize(self, momentsSamplingSize)

    def setPDFSamplingSize(self, pdfSamplingSize):
        r"""
        Sampling size accessor for PDF test.

        Parameters
        ----------
        pdfSamplingSize : int
            Sampling size for PDF test.

        """
        return _testing.DistributionValidation_setPDFSamplingSize(self, pdfSamplingSize)

    def setCDFSamplingSize(self, cdfSamplingSize):
        r"""
        Sampling size accessor for CDF test.

        Parameters
        ----------
        cdfSamplingSize : int
            Sampling size for CDF test.

        """
        return _testing.DistributionValidation_setCDFSamplingSize(self, cdfSamplingSize)

    def setFittingSamplingSize(self, fittingSamplingSize):
        r"""
        Sampling size accessor for fitting test.

        Parameters
        ----------
        fittingSamplingSize : int
            Sampling size for fitting test.

        """
        return _testing.DistributionValidation_setFittingSamplingSize(self, fittingSamplingSize)
    __swig_destroy__ = _testing.delete_DistributionValidation

# Register DistributionValidation in _testing:
_testing.DistributionValidation_swigregister(DistributionValidation)

from contextlib import contextmanager

@contextmanager
def assert_raises(exception_class):
    """Checks for an exception to be raised.

    Similar to numpy.testing.assert_raises.

    Parameters
    ----------
    exception_class : Exception
        Exception type

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.testing as ott
    >>> with ott.assert_raises(ValueError):
    ...     raise ValueError
    """
    try:
        yield
        raise AssertionError(f"{exception_class.__name__} not raised")
    except exception_class:
        pass


