# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.4.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Polynomial primitives."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or __package__ or "." in __name__:
    from . import _orthogonalbasis
else:
    import _orthogonalbasis

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.weightedexperiment
class OrthogonalUniVariatePolynomial(openturns.func.UniVariatePolynomialImplementation):
    r"""
    Base class for orthogonal univariate polynomials.

    .. warning::

        Orthogonal univariate polynomials are not intended to be created manually.
        They should be constructed with the subclasses of
        :class:`~openturns.OrthogonalUniVariatePolynomialFamily` (like e.g.
        :class:`~openturns.HermiteFactory`). Constructor parameters are therefore
        intentionally not documented.

    See Also
    --------
    OrthogonalUniVariatePolynomialFamily

    Examples
    --------
    >>> import openturns as ot

    Create a univariate polynomial from a list of coefficients:

    >>> for i in range(3):
    ...     print(ot.OrthogonalUniVariatePolynomialFamily().build(i))
    1
    X
    -0.707107 + 0.707107 * X^2
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomial_getClassName(self)

    def __call__(self, x):
        return _orthogonalbasis.OrthogonalUniVariatePolynomial___call__(self, x)

    def getRecurrenceCoefficients(self):
        r"""
        Accessor to the recurrence coefficients.

        Returns
        -------
        recurrence_coefficients : list of :class:`Point`
            The list of recurrence coefficients that defined the orthogonal univariate
            polynomial from the very first univariate orthogonal polynomial
            :math:`P_0`.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \quad i > 1

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial = ot.OrthogonalUniVariatePolynomialFamily().build(2)
        >>> print(polynomial.getRecurrenceCoefficients())
        0 : [  1         0         0        ]
        1 : [  0.707107  0        -0.707107 ]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomial_getRecurrenceCoefficients(self)

    def getRoots(self):
        r"""
        Compute the roots of the polynomial.

        Returns
        -------
        roots : list of complex values
            Polynomial's roots.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getRoots())
        [(-0.333333,0.471405),(-0.333333,-0.471405)]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomial_getRoots(self)

    def __init__(self, *args):
        _orthogonalbasis.OrthogonalUniVariatePolynomial_swiginit(self, _orthogonalbasis.new_OrthogonalUniVariatePolynomial(*args))
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariatePolynomial

# Register OrthogonalUniVariatePolynomial in _orthogonalbasis:
_orthogonalbasis.OrthogonalUniVariatePolynomial_swigregister(OrthogonalUniVariatePolynomial)
class OrthogonalUniVariatePolynomialFactory(openturns.common.PersistentObject):
    r"""
    Base class for orthogonal univariate polynomial factories.

    See also
    --------
    StandardDistributionPolynomialFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_getClassName(self)
    ANALYSIS = _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_ANALYSIS
    PROBABILITY = _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_PROBABILITY

    def __repr__(self):
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory___repr__(self)

    def build(self, degree):
        r"""
        Build the :math:`k`-th order orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Returns
        -------
        polynomial : :class:`~openturns.OrthogonalUniVariatePolynomial`
            Requested orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.build(2))
        -0.707107 + 0.707107 * X^2
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_build(self, degree)

    def buildRecurrenceCoefficientsCollection(self, degree):
        r"""
        Build the recurrence coefficients.

        Build the recurrence coefficients of the orthogonal univariate polynomial
        family up to the :math:`k`-th order.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Returns
        -------
        recurrence_coefficients : list of :class:`~openturns.Point`
            All the tecurrence coefficients up to the requested order.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.buildRecurrenceCoefficientsCollection(2))
        0 : [  1         0         0        ]
        1 : [  0.707107  0        -0.707107 ]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_buildRecurrenceCoefficientsCollection(self, degree)

    def buildCoefficients(self, degree):
        r"""
        Build the :math:`k`-th order orthogonal univariate polynomial coefficients.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Returns
        -------
        coefficients : :class:`~openturns.Point`
            Coefficients of the requested orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.buildCoefficients(2))
        [-0.707107,0,0.707107]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_buildCoefficients(self, degree)

    def getRoots(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`k > 0`
            Polynomial order.

        Returns
        -------
        roots : :class:`~openturns.Point`
            The roots of the :math:`k`-th order orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRoots(3))
        [-1.73205,...,1.73205]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_getRoots(self, n)

    def getNodesAndWeights(self, n):
        r"""
        Build the :math:`k`-th order quadrature scheme.

        Associated with the orthogonal univariate polynomials family.

        Parameters
        ----------
        k : int, :math:`0 < k`
            Polynomial order.

        Returns
        -------
        nodes : :class:`~openturns.Point`
            The nodes of the :math:`k`-th order quadrature scheme.
        weights : :class:`~openturns.Point`
            The weights of the :math:`k`-th order quadrature scheme.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> nodes, weights = polynomial_factory.getNodesAndWeights(3)
        >>> print(nodes)
        [-1.73205,...,1.73205]
        >>> print(weights)
        [0.166667,0.666667,0.166667]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_getNodesAndWeights(self, n)

    def getMeasure(self):
        r"""
        Accessor to the associated probability measure.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            The associated probability measure (according to which the polynomials are
            orthogonal).

        Notes
        -----
        Two polynomials P and Q are orthogonal with respect to the **probability
        measure** :math:`w(x) \di{x}` if and only if their dot product:

        .. math::

            \langle P, Q \rangle = \int_{\alpha}^{\beta} P(x) Q(x) w(x)\di{x}
                                 = 0

        where :math:`\alpha \in \Rset \cup \{-\infty\}` and
        :math:`\beta \in \Rset \cup \{+\infty\}`.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getMeasure())
        Normal(mu = 0, sigma = 1)

        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_getMeasure(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_getRecurrenceCoefficients(self, n)

    def __init__(self, *args):
        _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_swiginit(self, _orthogonalbasis.new_OrthogonalUniVariatePolynomialFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariatePolynomialFactory

# Register OrthogonalUniVariatePolynomialFactory in _orthogonalbasis:
_orthogonalbasis.OrthogonalUniVariatePolynomialFactory_swigregister(OrthogonalUniVariatePolynomialFactory)
class CharlierFactory(OrthogonalUniVariatePolynomialFactory):
    r"""
    Charlier specific orthonormal univariate polynomial family.

    For :class:`~openturns.Poisson`'s distribution.

    Parameters
    ----------
    lambda : float, :math:`\lambda > 0`
        Location parameter of :class:`~openturns.Poisson`'s distribution.

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \quad 1 < i

    The recurrence coefficients for the Charlier polynomials come analytically and
    read:

    .. math::

        \begin{array}{rcl}
            a_i & = & \displaystyle - \frac{1}{\sqrt{\lambda (i + 1)}} \\
            b_i & = & \displaystyle \frac{i + \lambda}{\sqrt{\lambda (i + 1)}} \\
            c_i & = & \displaystyle - \sqrt{1 - \frac{1}{i + 1}}
        \end{array}, \quad 1 < i

    where :math:`\lambda` is the location parameter of
    :class:`~openturns.Poisson`'s distribution.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.CharlierFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    1 - X
    0.707107 - 2.12132 * X + 0.707107 * X^2
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.CharlierFactory_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.CharlierFactory_getRecurrenceCoefficients(self, n)

    def getLambda(self):
        r"""
        Accessor to the location parameter of :class:`~openturns.Poisson`.

        Returns
        -------
        lambda : float
            Location parameter of :class:`~openturns.Poisson`'s distribution.
        """
        return _orthogonalbasis.CharlierFactory_getLambda(self)

    def __repr__(self):
        return _orthogonalbasis.CharlierFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.CharlierFactory_swiginit(self, _orthogonalbasis.new_CharlierFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_CharlierFactory

# Register CharlierFactory in _orthogonalbasis:
_orthogonalbasis.CharlierFactory_swigregister(CharlierFactory)
class ChebychevFactory(OrthogonalUniVariatePolynomialFactory):
    r"""
    Chebychev specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Arcsine` distribution.

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \quad i > 0

    The recurrence coefficients for the Chebychev polynomials come analytically and
    read :math:`a_0=\sqrt{2}, b_0=0, c_0=0`, :math:`a_1=2, b_1=0,c_1=-\sqrt{2}` and for :math:`i>1`, :math:`a_i=2, b_i=0, c_i=-1`.


    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.ChebychevFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    1.41421 * X
    -1.41421 + 2.82843 * X^2
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.ChebychevFactory_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.ChebychevFactory_getRecurrenceCoefficients(self, n)

    def getRoots(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`k > 0`
            Polynomial order.

        Returns
        -------
        roots : :class:`~openturns.Point`
            The roots of the :math:`k`-th order orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRoots(3))
        [-1.73205,...,1.73205]
        """
        return _orthogonalbasis.ChebychevFactory_getRoots(self, n)

    def getNodesAndWeights(self, n):
        r"""
        Build the :math:`k`-th order quadrature scheme.

        Associated with the orthogonal univariate polynomials family.

        Parameters
        ----------
        k : int, :math:`0 < k`
            Polynomial order.

        Returns
        -------
        nodes : :class:`~openturns.Point`
            The nodes of the :math:`k`-th order quadrature scheme.
        weights : :class:`~openturns.Point`
            The weights of the :math:`k`-th order quadrature scheme.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> nodes, weights = polynomial_factory.getNodesAndWeights(3)
        >>> print(nodes)
        [-1.73205,...,1.73205]
        >>> print(weights)
        [0.166667,0.666667,0.166667]
        """
        return _orthogonalbasis.ChebychevFactory_getNodesAndWeights(self, n)

    def __repr__(self):
        return _orthogonalbasis.ChebychevFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.ChebychevFactory_swiginit(self, _orthogonalbasis.new_ChebychevFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_ChebychevFactory

# Register ChebychevFactory in _orthogonalbasis:
_orthogonalbasis.ChebychevFactory_swigregister(ChebychevFactory)
class HermiteFactory(OrthogonalUniVariatePolynomialFactory):
    r"""
    Hermite specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Normal` distribution.

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \quad 1 < i

    The recurrence coefficients for the Hermite polynomials come analytically and
    read:

    .. math::

        \begin{array}{rcl}
            a_i & = & \displaystyle \frac{1}{\sqrt{i + 1}} \\
            b_i & = & 0 \\
            c_i & = & \displaystyle - \sqrt{\frac{i}{i + 1}}
        \end{array}, \quad 1 < i

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.HermiteFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    X
    -0.707107 + 0.707107 * X^2
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.HermiteFactory_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.HermiteFactory_getRecurrenceCoefficients(self, n)

    def __repr__(self):
        return _orthogonalbasis.HermiteFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.HermiteFactory_swiginit(self, _orthogonalbasis.new_HermiteFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_HermiteFactory

# Register HermiteFactory in _orthogonalbasis:
_orthogonalbasis.HermiteFactory_swigregister(HermiteFactory)
class JacobiFactory(OrthogonalUniVariatePolynomialFactory):
    r"""
    Jacobi specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Beta` distribution.

    Parameters
    ----------
    arg1 : float
        If `parameters_set == ot.JacobiFactory.PROBABILITY`: default shape
        parameter :math:`r > 0` of the :class:`~openturns.Beta` distribution.

        If `parameters_set == ot.JacobiFactory.ANALYSIS`: alternative shape
        parameter :math:`\alpha = t - r - 1 > -1` of the :class:`~openturns.Beta`
        distribution.
    arg2 : float
        If `parameters_set == ot.JacobiFactory.PROBABILITY`: default shape
        parameter :math:`t > r` of the :class:`~openturns.Beta` distribution.

        If `parameters_set == ot.JacobiFactory.ANALYSIS`: alternative shape
        parameter :math:`\beta = r - 1` of the :class:`~openturns.Beta`
        distribution.
    parameters_set : int, optional
        Integer telling which parameters set is used for defining the distribution
        (amongst `ot.JacobiFactory.ANALYSIS, ot.JacobiFactory.PROBABILITY`).

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \quad 1 < i

    The recurrence coefficients for the Jacobi polynomials come analytically and
    read:

    .. math::

        \begin{array}{rcl}
            a_i & = & \displaystyle K_{2,i} (2 i + \alpha + \beta + 2) \\
            b_i & = & \displaystyle K_{2,i} \frac{(\alpha - \beta)(\alpha + \beta)}
                                                 {2 i + \alpha + \beta} \\
            c_i & = & \displaystyle - \frac{2 i + \alpha + \beta + 2}
                                           {2 i + \alpha + \beta}
                                    \left[(i + \alpha) (i + \beta)
                                          (i + \alpha + \beta) i
                                          \frac{K_{1,i}}
                                               {2 i + \alpha + \beta - 1}
                                          \right]^{1/2}
        \end{array}, \quad 1 < i

    where :math:`\alpha` and :math:`\beta` are the alternative shape parameters
    of the :class:`~openturns.Beta` distribution, and:

    .. math::

        \begin{array}{rcl}
            K_{1,i} & = & \displaystyle \frac{2 i + \alpha + \beta + 3}
                                             {(i + 1) (i + \alpha + 1)
                                              (i + \beta + 1)
                                              (i + \alpha + \beta + 1)} \\
            K_{2,i} & = & \displaystyle \frac{1}{2}
                                        \sqrt{(2 i + \alpha + \beta + 1) K_{1,i}}
        \end{array}, \quad i > 1

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.JacobiFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    2.23607 * X
    -0.935414 + 4.67707 * X^2
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.JacobiFactory_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.JacobiFactory_getRecurrenceCoefficients(self, n)

    def getAlpha(self):
        r"""
        Accessor to the alternative shape parameter :math:`\alpha`.

        Of the :class:`~openturns.Beta` distribution.

        Returns
        -------
        alpha : float
            Alternative shape parameter :math:`\alpha = r - 1` of the
            :class:`~openturns.Beta` distribution.
        """
        return _orthogonalbasis.JacobiFactory_getAlpha(self)

    def getBeta(self):
        r"""
        Accessor to the alternative shape parameter :math:`\beta`.

        Of the :class:`~openturns.Beta` distribution.

        Returns
        -------
        beta : float
            Alternative shape parameter :math:`\beta = t - r - 1` of the
            :class:`~openturns.Beta` distribution.
        """
        return _orthogonalbasis.JacobiFactory_getBeta(self)

    def __repr__(self):
        return _orthogonalbasis.JacobiFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.JacobiFactory_swiginit(self, _orthogonalbasis.new_JacobiFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_JacobiFactory

# Register JacobiFactory in _orthogonalbasis:
_orthogonalbasis.JacobiFactory_swigregister(JacobiFactory)
class KrawtchoukFactory(OrthogonalUniVariatePolynomialFactory):
    r"""
    Krawtchouk specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Binomial` distribution.

    Parameters
    ----------
    n : int, :math:`n > 0`
        Number of experiment parameter of the :class:`~openturns.Binomial`
        distribution.
    p : float, :math:`0 < p < 1`
        Success probability parameter of the :class:`~openturns.Binomial`
        distribution.

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \quad 1 < i < n

    The recurrence coefficients for the Krawtchouk polynomials come analytically
    and read:

    .. math::

        \begin{array}{rcl}
            a_i & = & \displaystyle - \frac{1}
                                           {\sqrt{(i + 1) (n - i) p (1 - p)}} \\
            b_i & = & \displaystyle \frac{p (n - i) + i (1 - p)}
                                         {\sqrt{(i + 1) (n - i) p (1 - p)}} \\
            c_i & = & \displaystyle - \sqrt{(1 - \frac{1}{i + 1})
                                            (1 + \frac{1}{n - i})}
        \end{array}, \quad 1 < i

    where :math:`n` and :math:`p` are the parameters of the
    :class:`~openturns.Binomial` distribution.

    .. warning::

        The Krawtchouk polynomials are only defined up to a degree :math:`m` equal
        to :math:`n - 1`. Indeed, for :math:`i = n`, some factors in the
        denominators of the recurrence coefficients would be equal to zero.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.KrawtchoukFactory(3, 0.5)
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    -1.73205 + 1.1547 * X
    1.73205 - 3.4641 * X + 1.1547 * X^2
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.KrawtchoukFactory_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.KrawtchoukFactory_getRecurrenceCoefficients(self, n)

    def getN(self):
        r"""
        Accessor to the :math:`n` parameter.

        Returns
        -------
        n : int
            Number of experiments parameter of the :class:`~openturns.Binomial`
            distribution.
        """
        return _orthogonalbasis.KrawtchoukFactory_getN(self)

    def getP(self):
        r"""
        Accessor to the :math:`p` parameter.

        Returns
        -------
        p : float
            Success probability parameter of the :class:`~openturns.Binomial`
            distribution.
        """
        return _orthogonalbasis.KrawtchoukFactory_getP(self)

    def __repr__(self):
        return _orthogonalbasis.KrawtchoukFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.KrawtchoukFactory_swiginit(self, _orthogonalbasis.new_KrawtchoukFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_KrawtchoukFactory

# Register KrawtchoukFactory in _orthogonalbasis:
_orthogonalbasis.KrawtchoukFactory_swigregister(KrawtchoukFactory)
class LaguerreFactory(OrthogonalUniVariatePolynomialFactory):
    r"""
    Laguerre specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Gamma` distribution.

    Parameters
    ----------
    k : float
        If `parameters_set == ot.JacobiFactory.PROBABILITY`: default shape
        parameter :math:`k > 0` of the :class:`~openturns.Gamma` distribution.

        If `parameters_set == ot.JacobiFactory.ANALYSIS`: alternative shape
        parameter :math:`k_a = k - 1 > -1` of the :class:`~openturns.Gamma`
        distribution.
    parameters_set : int, optional
        Integer telling which parameters set is used for defining the distribution
        (amongst `ot.LaguerreFactory.ANALYSIS, ot.LaguerreFactory.PROBABILITY`).

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \quad 1 < i

    The recurrence coefficients for the Laguerre polynomials come analytically and
    read:

    .. math::

        \begin{array}{rcl}
            a_i & = & \omega_i \\
            b_i & = & - (2 i + k_a + 1) \omega_i \\
            c_i & = & - \sqrt{(i + k_a) i} \omega_i
        \end{array}, \quad 1 < i

    where :math:`k_a` is the alternative shape parameter of the
    :class:`~openturns.Gamma` distribution, and:

    .. math::

        \omega_i = \frac{1}{\sqrt{(i + 1) (i + k_a + 1)}} , \quad 1 < i

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.LaguerreFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    -1 + X
    1 - 2 * X + 0.5 * X^2
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.LaguerreFactory_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.LaguerreFactory_getRecurrenceCoefficients(self, n)

    def getK(self):
        r"""
        Accessor to the alternative shape parameter :math:`k_a`.

        Of the :class:`~openturns.Gamma` distribution.

        Returns
        -------
        k_a : float
            Alternative shape parameter :math:`k_a = k - 1` of the
            :class:`~openturns.Gamma` distribution.
        """
        return _orthogonalbasis.LaguerreFactory_getK(self)

    def __repr__(self):
        return _orthogonalbasis.LaguerreFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.LaguerreFactory_swiginit(self, _orthogonalbasis.new_LaguerreFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_LaguerreFactory

# Register LaguerreFactory in _orthogonalbasis:
_orthogonalbasis.LaguerreFactory_swigregister(LaguerreFactory)
class LegendreFactory(OrthogonalUniVariatePolynomialFactory):
    r"""
    Legendre specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Uniform` distribution.

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \quad 1 < i

    The recurrence coefficients for the Legendre polynomials come analytically and
    read:

    .. math::

        \begin{array}{rcl}
            a_i & = & \displaystyle \frac{\sqrt{(2 i + 1) (2 i + 3)}}
                                         {i + 1} \\
            b_i & = & 0 \\
            c_i & = & \displaystyle - \frac{i \sqrt{2 i + 3}}
                                           {(i + 1) \sqrt{2 i - 1}}
        \end{array}, \quad 1 < i

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.LegendreFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    1.73205 * X
    -1.11803 + 3.3541 * X^2
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.LegendreFactory_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.LegendreFactory_getRecurrenceCoefficients(self, n)

    def __repr__(self):
        return _orthogonalbasis.LegendreFactory___repr__(self)

    def getRoots(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`k > 0`
            Polynomial order.

        Returns
        -------
        roots : :class:`~openturns.Point`
            The roots of the :math:`k`-th order orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRoots(3))
        [-1.73205,...,1.73205]
        """
        return _orthogonalbasis.LegendreFactory_getRoots(self, n)

    def getNodesAndWeights(self, n):
        r"""
        Build the :math:`k`-th order quadrature scheme.

        Associated with the orthogonal univariate polynomials family.

        Parameters
        ----------
        k : int, :math:`0 < k`
            Polynomial order.

        Returns
        -------
        nodes : :class:`~openturns.Point`
            The nodes of the :math:`k`-th order quadrature scheme.
        weights : :class:`~openturns.Point`
            The weights of the :math:`k`-th order quadrature scheme.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> nodes, weights = polynomial_factory.getNodesAndWeights(3)
        >>> print(nodes)
        [-1.73205,...,1.73205]
        >>> print(weights)
        [0.166667,0.666667,0.166667]
        """
        return _orthogonalbasis.LegendreFactory_getNodesAndWeights(self, n)

    def __init__(self, *args):
        _orthogonalbasis.LegendreFactory_swiginit(self, _orthogonalbasis.new_LegendreFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_LegendreFactory

# Register LegendreFactory in _orthogonalbasis:
_orthogonalbasis.LegendreFactory_swigregister(LegendreFactory)
class HistogramPolynomialFactory(OrthogonalUniVariatePolynomialFactory):
    r"""
    Histogram specific orthonormal univariate polynomial family.


    Parameters
    ----------
    first : float
        Lower bound.
    width : positive sequence of float
        :math:`\ell_i` is the width of the class :math:`i`.
    height : positive sequence of float
        :math:`h_i` is the frequency of the class :math:`i`.

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \quad 1 < i

    The recurrence coefficients for the HistogramPolynomial polynomials are computed from the recurrence of 
    the associated monic polynomials (see :class:`~openturns.AdaptiveStieltjesAlgorithm`) but with an exact
    evaluation of the dot-products.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.HistogramPolynomialFactory(1.0, [1.0, 2.0], [4.0, 2.0])
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    -2.56273 + 1.13899 * X
    7.80593 - 7.42767 * X + 1.5268 * X^2

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.HistogramPolynomialFactory_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.HistogramPolynomialFactory_getRecurrenceCoefficients(self, n)

    def getFirst(self):
        r"""
        Accessor to the distribution lower bound.

        Returns
        -------
        first : float
            Lower bound.
        """
        return _orthogonalbasis.HistogramPolynomialFactory_getFirst(self)

    def getWidth(self):
        r"""
        Accessor to the width sequence of the classes.

        Returns
        -------
        width : positive sequence of float
            Width sequence of the classes.
        """
        return _orthogonalbasis.HistogramPolynomialFactory_getWidth(self)

    def getHeight(self):
        r"""
        Accessor to the frequency sequence of the classes.

        Returns
        -------
        height : positive sequence of float
            Frequency sequence of the classes.
        """
        return _orthogonalbasis.HistogramPolynomialFactory_getHeight(self)

    def __repr__(self):
        return _orthogonalbasis.HistogramPolynomialFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.HistogramPolynomialFactory_swiginit(self, _orthogonalbasis.new_HistogramPolynomialFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_HistogramPolynomialFactory

# Register HistogramPolynomialFactory in _orthogonalbasis:
_orthogonalbasis.HistogramPolynomialFactory_swigregister(HistogramPolynomialFactory)
class MeixnerFactory(OrthogonalUniVariatePolynomialFactory):
    r"""
    Meixner specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Polya` distribution.

    Parameters
    ----------
    r : float, :math:`r > 0`
        Number of failures parameter of the :class:`~openturns.Polya`
        distribution.
    p : float, :math:`0 < p < 1`
        Success probability parameter of the :class:`~openturns.Polya`
        distribution.

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \quad 1 < i

    The recurrence coefficients for the Meixner polynomials come analytically
    and read:

    .. math::

        \begin{array}{rcl}
            a_i & = & \displaystyle \frac{p - 1}
                                         {\sqrt{p (i + 1) (i + r)}} \\
            b_i & = & \displaystyle \frac{p (i + r) + i}
                                         {\sqrt{p (i + 1) (i + r)}} \\
            c_i & = & \displaystyle - \frac{\sqrt{p i (i + r - 1)}}
                                           {\sqrt{p (i + 1) (i + r)}} \\
        \end{array}, \quad 1 < i

    where :math:`r` and :math:`p` are the parameters of the
    :class:`~openturns.Polya` distribution.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.MeixnerFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    0.707107 - 0.707107 * X
    0.5 - 1.25 * X + 0.25 * X^2
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.MeixnerFactory_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.MeixnerFactory_getRecurrenceCoefficients(self, n)

    def getR(self):
        r"""
        Accessor to the number of failures parameter :math:`r`.

        Of the :class:`~openturns.Polya` distribution.

        Returns
        -------
        r : int
            Number of failures parameter of the :class:`~openturns.Polya`
            distribution.
        """
        return _orthogonalbasis.MeixnerFactory_getR(self)

    def getP(self):
        r"""
        Accessor to the success probability parameter :math:`p`.

        Of the :class:`~openturns.Polya` distribution.

        Returns
        -------
        p : float
            Success probability parameter of the :class:`~openturns.Polya`
            distribution.
        """
        return _orthogonalbasis.MeixnerFactory_getP(self)

    def __repr__(self):
        return _orthogonalbasis.MeixnerFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.MeixnerFactory_swiginit(self, _orthogonalbasis.new_MeixnerFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_MeixnerFactory

# Register MeixnerFactory in _orthogonalbasis:
_orthogonalbasis.MeixnerFactory_swigregister(MeixnerFactory)
class _OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _orthogonalbasis._OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject_swiginit(self, _orthogonalbasis.new__OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _orthogonalbasis._OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _orthogonalbasis._OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _orthogonalbasis._OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _orthogonalbasis._OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _orthogonalbasis._OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _orthogonalbasis.delete__OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject

# Register _OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject in _orthogonalbasis:
_orthogonalbasis._OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject_swigregister(_OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject)
class PolynomialFamilyCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _orthogonalbasis.delete_PolynomialFamilyCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _orthogonalbasis.PolynomialFamilyCollection_clear(self)

    def __len__(self):
        return _orthogonalbasis.PolynomialFamilyCollection___len__(self)

    def __eq__(self, rhs):
        return _orthogonalbasis.PolynomialFamilyCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _orthogonalbasis.PolynomialFamilyCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _orthogonalbasis.PolynomialFamilyCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _orthogonalbasis.PolynomialFamilyCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _orthogonalbasis.PolynomialFamilyCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _orthogonalbasis.PolynomialFamilyCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _orthogonalbasis.PolynomialFamilyCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _orthogonalbasis.PolynomialFamilyCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _orthogonalbasis.PolynomialFamilyCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _orthogonalbasis.PolynomialFamilyCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _orthogonalbasis.PolynomialFamilyCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _orthogonalbasis.PolynomialFamilyCollection_find(self, val)

    def __repr__(self):
        return _orthogonalbasis.PolynomialFamilyCollection___repr__(self)

    def __str__(self, *args):
        return _orthogonalbasis.PolynomialFamilyCollection___str__(self, *args)

    def __init__(self, *args):
        _orthogonalbasis.PolynomialFamilyCollection_swiginit(self, _orthogonalbasis.new_PolynomialFamilyCollection(*args))

# Register PolynomialFamilyCollection in _orthogonalbasis:
_orthogonalbasis.PolynomialFamilyCollection_swigregister(PolynomialFamilyCollection)
class OrthogonalUniVariatePolynomialFamily(_OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject):
    r"""
    Base class for orthogonal univariate polynomial factories.

    See also
    --------
    StandardDistributionPolynomialFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_getClassName(self)

    def __repr__(self):
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily___repr__(self)

    def build(self, degree):
        r"""
        Build the :math:`k`-th order orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Returns
        -------
        polynomial : :class:`~openturns.OrthogonalUniVariatePolynomial`
            Requested orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.build(2))
        -0.707107 + 0.707107 * X^2
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_build(self, degree)

    def getRoots(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`k > 0`
            Polynomial order.

        Returns
        -------
        roots : :class:`~openturns.Point`
            The roots of the :math:`k`-th order orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRoots(3))
        [-1.73205,...,1.73205]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_getRoots(self, n)

    def getNodesAndWeights(self, n):
        r"""
        Build the :math:`k`-th order quadrature scheme.

        Associated with the orthogonal univariate polynomials family.

        Parameters
        ----------
        k : int, :math:`0 < k`
            Polynomial order.

        Returns
        -------
        nodes : :class:`~openturns.Point`
            The nodes of the :math:`k`-th order quadrature scheme.
        weights : :class:`~openturns.Point`
            The weights of the :math:`k`-th order quadrature scheme.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> nodes, weights = polynomial_factory.getNodesAndWeights(3)
        >>> print(nodes)
        [-1.73205,...,1.73205]
        >>> print(weights)
        [0.166667,0.666667,0.166667]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_getNodesAndWeights(self, n)

    def getMeasure(self):
        r"""
        Accessor to the associated probability measure.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            The associated probability measure (according to which the polynomials are
            orthogonal).

        Notes
        -----
        Two polynomials P and Q are orthogonal with respect to the **probability
        measure** :math:`w(x) \di{x}` if and only if their dot product:

        .. math::

            \langle P, Q \rangle = \int_{\alpha}^{\beta} P(x) Q(x) w(x)\di{x}
                                 = 0

        where :math:`\alpha \in \Rset \cup \{-\infty\}` and
        :math:`\beta \in \Rset \cup \{+\infty\}`.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getMeasure())
        Normal(mu = 0, sigma = 1)

        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_getMeasure(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_getRecurrenceCoefficients(self, n)

    def __init__(self, *args):
        _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_swiginit(self, _orthogonalbasis.new_OrthogonalUniVariatePolynomialFamily(*args))
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariatePolynomialFamily

# Register OrthogonalUniVariatePolynomialFamily in _orthogonalbasis:
_orthogonalbasis.OrthogonalUniVariatePolynomialFamily_swigregister(OrthogonalUniVariatePolynomialFamily)
class OrthonormalizationAlgorithmImplementation(openturns.common.PersistentObject):
    r"""
    Algorithm used to build the orthonormal basis.

    With respect to a specific distribution.

    Available constructors:
        OrthonormalizationAlgorithm(*orthoAlgoImp*)

        OrthonormalizationAlgorithm(*measure*)

    Parameters
    ----------
    orthoAlgoImp : OrthonormalizationAlgorithmImplementation
        An orthonormalization algorithm implementation.
    measure : :class:`~openturns.Distribution`
        A distribution for which the orthonormal polynomial basis is built. 

    See also
    --------
    AdaptiveStieltjesAlgorithm

    Notes
    -----
    It enables to build the orthonormal polynomial basis with respect to the given 
    distribution.

    In the first usage, the algorithm orthoAlgoImp is used (that specifies the
    associated distribution). In the second usage, the Gram-Schmidt algorithm is
    used by default. Only the distribution *measure* is specified.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementation_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients.

        Parameters
        ----------
        n : int
            Index ot the recurrence step.

        Returns
        -------
        coef : sequence of float
            Calculate the coefficients of recurrence :math:`a_0`, :math:`a_1`, :math:`a_2`
            such that
            :math:`P_{n+1}(x) = (a_0 \times x + a_1) \times P_n(x) + a_2 \times P_{n-1}(x)`.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementation_getRecurrenceCoefficients(self, n)

    def __repr__(self):
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementation___repr__(self)

    def getMeasure(self):
        r"""
        Accessor to the measure.

        Returns
        -------
        m : :class:`~openturns.Distribution`
            The measure for which the orthonormal polynomial basis is built.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementation_getMeasure(self)

    def setMeasure(self, measure):
        r"""
        Accessor to the measure.

        Parameters
        ----------
        m : :class:`~openturns.Distribution`
            The measure for which the orthonormal polynomial basis is built.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementation_setMeasure(self, measure)

    def __init__(self, *args):
        _orthogonalbasis.OrthonormalizationAlgorithmImplementation_swiginit(self, _orthogonalbasis.new_OrthonormalizationAlgorithmImplementation(*args))
    __swig_destroy__ = _orthogonalbasis.delete_OrthonormalizationAlgorithmImplementation

# Register OrthonormalizationAlgorithmImplementation in _orthogonalbasis:
_orthogonalbasis.OrthonormalizationAlgorithmImplementation_swigregister(OrthonormalizationAlgorithmImplementation)
class _OrthonormalizationAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _orthogonalbasis._OrthonormalizationAlgorithmImplementationTypedInterfaceObject_swiginit(self, _orthogonalbasis.new__OrthonormalizationAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _orthogonalbasis._OrthonormalizationAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _orthogonalbasis._OrthonormalizationAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _orthogonalbasis._OrthonormalizationAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _orthogonalbasis._OrthonormalizationAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _orthogonalbasis._OrthonormalizationAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _orthogonalbasis.delete__OrthonormalizationAlgorithmImplementationTypedInterfaceObject

# Register _OrthonormalizationAlgorithmImplementationTypedInterfaceObject in _orthogonalbasis:
_orthogonalbasis._OrthonormalizationAlgorithmImplementationTypedInterfaceObject_swigregister(_OrthonormalizationAlgorithmImplementationTypedInterfaceObject)
class OrthonormalizationAlgorithm(_OrthonormalizationAlgorithmImplementationTypedInterfaceObject):
    r"""
    Algorithm used to build the orthonormal basis.

    With respect to a specific distribution.

    Available constructors:
        OrthonormalizationAlgorithm(*orthoAlgoImp*)

        OrthonormalizationAlgorithm(*measure*)

    Parameters
    ----------
    orthoAlgoImp : OrthonormalizationAlgorithmImplementation
        An orthonormalization algorithm implementation.
    measure : :class:`~openturns.Distribution`
        A distribution for which the orthonormal polynomial basis is built. 

    See also
    --------
    AdaptiveStieltjesAlgorithm

    Notes
    -----
    It enables to build the orthonormal polynomial basis with respect to the given 
    distribution.

    In the first usage, the algorithm orthoAlgoImp is used (that specifies the
    associated distribution). In the second usage, the Gram-Schmidt algorithm is
    used by default. Only the distribution *measure* is specified.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthonormalizationAlgorithm_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients.

        Parameters
        ----------
        n : int
            Index ot the recurrence step.

        Returns
        -------
        coef : sequence of float
            Calculate the coefficients of recurrence :math:`a_0`, :math:`a_1`, :math:`a_2`
            such that
            :math:`P_{n+1}(x) = (a_0 \times x + a_1) \times P_n(x) + a_2 \times P_{n-1}(x)`.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithm_getRecurrenceCoefficients(self, n)

    def getMeasure(self):
        r"""
        Accessor to the measure.

        Returns
        -------
        m : :class:`~openturns.Distribution`
            The measure for which the orthonormal polynomial basis is built.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithm_getMeasure(self)

    def setMeasure(self, measure):
        r"""
        Accessor to the measure.

        Parameters
        ----------
        m : :class:`~openturns.Distribution`
            The measure for which the orthonormal polynomial basis is built.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithm_setMeasure(self, measure)

    def __repr__(self):
        return _orthogonalbasis.OrthonormalizationAlgorithm___repr__(self)

    def __str__(self, *args):
        return _orthogonalbasis.OrthonormalizationAlgorithm___str__(self, *args)

    def __init__(self, *args):
        _orthogonalbasis.OrthonormalizationAlgorithm_swiginit(self, _orthogonalbasis.new_OrthonormalizationAlgorithm(*args))
    __swig_destroy__ = _orthogonalbasis.delete_OrthonormalizationAlgorithm

# Register OrthonormalizationAlgorithm in _orthogonalbasis:
_orthogonalbasis.OrthonormalizationAlgorithm_swigregister(OrthonormalizationAlgorithm)
class AdaptiveStieltjesAlgorithm(OrthonormalizationAlgorithmImplementation):
    r"""
    AdaptiveStieltjes algorithm used to build the orthonormal basis.

    The algorithm builds a polynomial basis orthonormal with respect to a specific distribution.

    Parameters
    ----------
    measure : :class:`~openturns.Distribution`
        A measure for which the orthonormal polynomial basis is built. 

    See also
    --------
    OrthonormalizationAlgorithm

    Notes
    -----
    It implements an adaptive Stieltjes algorithm that builds the polynomial family
    orthonormal with respect to the distribution *measure*, using the
    :class:`~openturns.GaussKronrod` adaptive integration method to compute the
    following dot-products: :math:`R_n=\langle Q_n, Q_n\rangle` and
    :math:`S_n=\langle xQ_n, Q_n\rangle` where :math:`Q_n` is the monic polynomial
    associated to the orthonormal polynomial :math:`P_n`, needed to compute the
    coefficients of the three-terms recurrence relation that defines :math:`P_n`
    (see :class:`~openturns.OrthogonalUniVariatePolynomialFamily`):

    .. math::

        a_n = 1/\sqrt{\beta_{n+1}}\quad b_n = -\alpha_n/\sqrt{\beta_{n+1}}\quad c_n = -\sqrt{\beta_n/\beta_{n+1}}

    where :math:`\alpha_n = S_n / R_n`, :math:`\beta_n  = R_n / R_{n-1}`, :math:`n>0` and :math:`\beta_0 = 0`.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.AdaptiveStieltjesAlgorithm_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients.

        Parameters
        ----------
        n : int
            Index ot the recurrence step.

        Returns
        -------
        coef : sequence of float
            Calculate the coefficients of recurrence :math:`a_0`, :math:`a_1`, :math:`a_2`
            such that
            :math:`P_{n+1}(x) = (a_0 \times x + a_1) \times P_n(x) + a_2 \times P_{n-1}(x)`.
        """
        return _orthogonalbasis.AdaptiveStieltjesAlgorithm_getRecurrenceCoefficients(self, n)

    def __repr__(self):
        return _orthogonalbasis.AdaptiveStieltjesAlgorithm___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.AdaptiveStieltjesAlgorithm_swiginit(self, _orthogonalbasis.new_AdaptiveStieltjesAlgorithm(*args))
    __swig_destroy__ = _orthogonalbasis.delete_AdaptiveStieltjesAlgorithm

# Register AdaptiveStieltjesAlgorithm in _orthogonalbasis:
_orthogonalbasis.AdaptiveStieltjesAlgorithm_swigregister(AdaptiveStieltjesAlgorithm)
class StandardDistributionPolynomialFactory(OrthogonalUniVariatePolynomialFactory):
    r"""
    Build orthonormal or orthogonal univariate polynomial families.

    Parameters
    ----------
    arg : :class:`~openturns.Distribution` or :class:`~openturns.OrthonormalizationAlgorithm`
        Either a :class:`~openturns.Distribution` implementing the probability
        measure according to which the polynomial family is orthonormal **or** an
        :class:`~openturns.OrthonormalizationAlgorithm`.

        In the first case, the implementation will switch to the suitable specific
        orthonormal univariate polynomial family if any (see the notes below), or
        it will default to the :class:`~openturns.AdaptiveStieltjesAlgorithm` to build
        an orthonormal univariate polynomial family.

    Notes
    -----
    Use this functionality with caution:

       - The polynomials exist if and only if the distribution admits finite
         moments of all orders. Even if some algorithms manage to compute something, it
         will be plain numerical noise.
       - Even if the polynomials exist, they form an Hilbertian basis with respect to the
         dot product induced by the distribution if and only if the distribution is
         **determinate**, ie is characterized by its moments. For example, the
         :class:`~openturns.LogNormal` distribution has orthonormal polynomials of
         arbitrary degree but the projection onto the functional space generated by
         these polynomials (see :class:`~openturns.FunctionalChaosAlgorithm`) may
         converge to a function that differs significantly from the function being
         projected (see [ernst2012]_).
         See :ref:`functional_chaos` for more details on this topic.

    OpenTURNS implements the following **specific orthonormal** [#orthonormal]_
    univariate polynomial families together with their associated **standard
    distributions**.

    .. table::

        +-----------------------------------------------------------------------+---------------------------------------+
        | Standard distribution                                                 | Polynomial                            |
        +=======================================================================+=======================================+
        | :class:`~openturns.Normal`                                            | :class:`~openturns.HermiteFactory`    |
        | :math:`\cN(\mu = 0, \sigma = 1)`                                      |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.Uniform`                                           | :class:`~openturns.LegendreFactory`   |
        | :math:`\cU(a = -1, b = 1)`                                            |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.Gamma`                                             | :class:`~openturns.LaguerreFactory`   |
        | :math:`\Gamma(k = k_a + 1, \lambda = 1, \gamma = 0)`                  |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.Beta`                                              | :class:`~openturns.JacobiFactory`     |
        | :math:`{\rm B}(r = \beta + 1, t = \alpha + \beta + 2, a = -1, b = 1)` |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.Poisson`                                           | :class:`~openturns.CharlierFactory`   |
        | :math:`\cP(\lambda)`                                                  |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.Binomial`                                          | :class:`~openturns.KrawtchoukFactory` |
        | :math:`\cB(n, p)`                                                     |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.Polya`                                             | :class:`~openturns.MeixnerFactory`    |
        | :math:`\cB^-(r, p)`                                                   |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+

    Aside, OpenTURNS also implements generic algorithms for building orthonormal
    univariate polynomial families with respect to any arbitrary probability
    measure (implemented as a :class:`~openturns.Distribution`).
    OpenTURNS implements the following :class:`~openturns.OrthonormalizationAlgorithm`'s, 
    :class:`~openturns.AdaptiveStieltjesAlgorithm` (default).

    .. [#orthonormal] A polynomial family :math:`(P_n)_{n \geq 0}` is said to be
        orthonormal with respect to the probability measure :math:`w(z) \di{z}` if
        and only if:

        .. math::

            \scalarproduct{P_i}{P_j} = \int_{\supp{w}} P_i(z) P_j(z) w(z) \di{z}
                                     = \delta_{ij}, \quad i, j = 1, \ldots, n

        where :math:`\delta_{ij}` denotes Kronecker's delta.

    See also
    --------
    :ref:`orthogonal_polynomials`, AdaptiveStieltjesAlgorithm

    Examples
    --------
    >>> import openturns as ot

    Build the specific orthonormal polynomial factory associated to the normal
    distribution (Hermite):

    >>> polynomial_factory = ot.StandardDistributionPolynomialFactory(ot.Normal())
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    X
    -0.707107 + 0.707107 * X^2

    Build an orthonormal polynomial factory for the WeibullMin distribution with
    the default orthonormalization algorithm:

    >>> polynomial_factory = ot.StandardDistributionPolynomialFactory(ot.WeibullMin())
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    -1 + X
    1 - 2 * X + 0.5 * X^2

    Build an orthonormal polynomial factory for the log-normal distribution with
    Chebychev's othonormalization algorithm:

    >>> algorithm = ot.AdaptiveStieltjesAlgorithm(ot.WeibullMin())
    >>> polynomial_factory = ot.StandardDistributionPolynomialFactory(algorithm)
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    -1 + X
    1 - 2 * X + 0.5 * X^2

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.StandardDistributionPolynomialFactory_getClassName(self)

    def getRecurrenceCoefficients(self, n):
        r"""
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.StandardDistributionPolynomialFactory_getRecurrenceCoefficients(self, n)

    def getHasSpecificFamily(self):
        r"""
        Accessor to the specific family boolean.

        Returns
        -------
        hasSpecificFamily : bool
            True if the factory has a specific orthogonal polynomial family.
        """
        return _orthogonalbasis.StandardDistributionPolynomialFactory_getHasSpecificFamily(self)

    def getOrthonormalizationAlgorithm(self):
        r"""
        Accessor to the orthonormalization algorithm.

        Returns
        -------
        orthonormalizationAlgorithm : :class:`~openturns.OrthonormalizationAlgorithm`
            The univariate polynomial orthonormalization algorithm.
        """
        return _orthogonalbasis.StandardDistributionPolynomialFactory_getOrthonormalizationAlgorithm(self)

    def getSpecificFamily(self):
        r"""
        Accessor to the specific orthonormal polynomial family.

        Returns
        -------
        specificFamily : :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
            The specific orthonormal univariate polynomial family.
        """
        return _orthogonalbasis.StandardDistributionPolynomialFactory_getSpecificFamily(self)

    def __repr__(self):
        return _orthogonalbasis.StandardDistributionPolynomialFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.StandardDistributionPolynomialFactory_swiginit(self, _orthogonalbasis.new_StandardDistributionPolynomialFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_StandardDistributionPolynomialFactory

# Register StandardDistributionPolynomialFactory in _orthogonalbasis:
_orthogonalbasis.StandardDistributionPolynomialFactory_swigregister(StandardDistributionPolynomialFactory)
class OrthogonalFunctionFactory(openturns.func.BasisImplementation):
    r"""
    Orthogonal basis.

    Notes
    -----
    OrthogonalBasis is the interface class of the OrthogonalFunctionFactory
    implementation, which is an
    :class:`~openturns.OrthogonalProductPolynomialFactory` in the particular case
    of polynomial chaos expansion.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> # Create an orthogonal basis
    >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(polynomialCollection)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalFunctionFactory_getClassName(self)

    def build(self, *args):
        r"""
        Get the term of the basis collection at a given index or multi-indices.

        Parameters
        ----------
        index : int
            Indicates the term of the basis which must be constructed. In other words,
            *index* is used by a bijection from :math:`\Nset` to :math:`\Nset^d`
            (with :math:`d` the dimension of the basis). The bijection is detailed in
            :class:`~openturns.EnumerateFunction`.
        indices : sequence of int
            Indicates the term of the basis which must be constructed. In other words,
            *indices* is used by a bijection from :math:`\Nset^d` to :math:`\Nset`
            (with :math:`d` the dimension of the basis). The bijection is the inverse of
            :class:`~openturns.EnumerateFunction`.

        Returns
        -------
        function : :class:`~openturns.Function`
            The term of the basis collection at the index *index* or the inverse of
            *indices*.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis =  ot.OrthogonalProductPolynomialFactory(polynomialCollection)
        >>> termBasis = productBasis.build(4)
        >>> print(termBasis.getEvaluation())
        -1.11803 + 3.3541 * x0^2
        >>> termBasis = productBasis.build(5)
        >>> print(termBasis.getEvaluation())
        1.73205 * x0 * (-1 + x1)
        >>> termBasis2 = productBasis.build([1, 1, 0])
        >>> print(termBasis2.getEvaluation())
        1.73205 * x0 * (-1 + x1)

        """
        return _orthogonalbasis.OrthogonalFunctionFactory_build(self, *args)

    def getMeasure(self):
        r"""
        Get the measure upon which the basis is orthogonal.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            Measure upon which the basis is orthogonal.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis = ot.OrthogonalProductPolynomialFactory(polynomialCollection)
        >>> measure = productBasis.getMeasure()
        >>> print(measure.getMarginal(0))
        Uniform(a = -1, b = 1)
        >>> print(measure.getMarginal(1))
        Gamma(k = 1, lambda = 1, gamma = 0)
        >>> print(measure.getMarginal(2))
        Normal(mu = 0, sigma = 1)
        """
        return _orthogonalbasis.OrthogonalFunctionFactory_getMeasure(self)

    def getEnumerateFunction(self):
        r"""
        Return the enumerate function.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            Enumerate function that translates unidimensional indices into
            multidimensional indices.
        """
        return _orthogonalbasis.OrthogonalFunctionFactory_getEnumerateFunction(self)

    def getMarginal(self, indices):
        r"""
        Get the marginal orthogonal functions.

        Parameters
        ----------
        indices : sequence of int, :math:`0 \leq i < \inputDim`
            List of marginal indices of the input variables.

        Returns
        -------
        functionFamilylist : list of :class:`~openturns.OrthogonalBasis`
            The marginal orthogonal functions.
        """
        return _orthogonalbasis.OrthogonalFunctionFactory_getMarginal(self, indices)

    def isOrthogonal(self):
        r"""
        Tell whether the basis is orthogonal.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is orthogonal.
        """
        return _orthogonalbasis.OrthogonalFunctionFactory_isOrthogonal(self)

    def isTensorProduct(self):
        r"""
        Tell whether the basis is a tensor product

        Returns
        -------
        isTensorProduct : bool
            `True` if the basis is a tensor product.
        """
        return _orthogonalbasis.OrthogonalFunctionFactory_isTensorProduct(self)

    def __repr__(self):
        return _orthogonalbasis.OrthogonalFunctionFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.OrthogonalFunctionFactory_swiginit(self, _orthogonalbasis.new_OrthogonalFunctionFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalFunctionFactory

# Register OrthogonalFunctionFactory in _orthogonalbasis:
_orthogonalbasis.OrthogonalFunctionFactory_swigregister(OrthogonalFunctionFactory)
class _OrthogonalFunctionFactoryTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _orthogonalbasis._OrthogonalFunctionFactoryTypedInterfaceObject_swiginit(self, _orthogonalbasis.new__OrthogonalFunctionFactoryTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _orthogonalbasis._OrthogonalFunctionFactoryTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _orthogonalbasis._OrthogonalFunctionFactoryTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _orthogonalbasis._OrthogonalFunctionFactoryTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _orthogonalbasis._OrthogonalFunctionFactoryTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _orthogonalbasis._OrthogonalFunctionFactoryTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _orthogonalbasis.delete__OrthogonalFunctionFactoryTypedInterfaceObject

# Register _OrthogonalFunctionFactoryTypedInterfaceObject in _orthogonalbasis:
_orthogonalbasis._OrthogonalFunctionFactoryTypedInterfaceObject_swigregister(_OrthogonalFunctionFactoryTypedInterfaceObject)
class OrthogonalBasis(_OrthogonalFunctionFactoryTypedInterfaceObject):
    r"""
    Orthogonal basis.

    Notes
    -----
    OrthogonalBasis is the interface class of the OrthogonalFunctionFactory
    implementation, which is an
    :class:`~openturns.OrthogonalProductPolynomialFactory` in the particular case
    of polynomial chaos expansion.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> # Create an orthogonal basis
    >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(polynomialCollection)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalBasis_getClassName(self)

    def build(self, *args):
        r"""
        Get the term of the basis collection at a given index or multi-indices.

        Parameters
        ----------
        index : int
            Indicates the term of the basis which must be constructed. In other words,
            *index* is used by a bijection from :math:`\Nset` to :math:`\Nset^d`
            (with :math:`d` the dimension of the basis). The bijection is detailed in
            :class:`~openturns.EnumerateFunction`.
        indices : sequence of int
            Indicates the term of the basis which must be constructed. In other words,
            *indices* is used by a bijection from :math:`\Nset^d` to :math:`\Nset`
            (with :math:`d` the dimension of the basis). The bijection is the inverse of
            :class:`~openturns.EnumerateFunction`.

        Returns
        -------
        function : :class:`~openturns.Function`
            The term of the basis collection at the index *index* or the inverse of
            *indices*.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis =  ot.OrthogonalProductPolynomialFactory(polynomialCollection)
        >>> termBasis = productBasis.build(4)
        >>> print(termBasis.getEvaluation())
        -1.11803 + 3.3541 * x0^2
        >>> termBasis = productBasis.build(5)
        >>> print(termBasis.getEvaluation())
        1.73205 * x0 * (-1 + x1)
        >>> termBasis2 = productBasis.build([1, 1, 0])
        >>> print(termBasis2.getEvaluation())
        1.73205 * x0 * (-1 + x1)

        """
        return _orthogonalbasis.OrthogonalBasis_build(self, *args)

    def getMeasure(self):
        r"""
        Get the measure upon which the basis is orthogonal.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            Measure upon which the basis is orthogonal.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis = ot.OrthogonalProductPolynomialFactory(polynomialCollection)
        >>> measure = productBasis.getMeasure()
        >>> print(measure.getMarginal(0))
        Uniform(a = -1, b = 1)
        >>> print(measure.getMarginal(1))
        Gamma(k = 1, lambda = 1, gamma = 0)
        >>> print(measure.getMarginal(2))
        Normal(mu = 0, sigma = 1)
        """
        return _orthogonalbasis.OrthogonalBasis_getMeasure(self)

    def getEnumerateFunction(self):
        r"""
        Return the enumerate function.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            Enumerate function that translates unidimensional indices into
            multidimensional indices.
        """
        return _orthogonalbasis.OrthogonalBasis_getEnumerateFunction(self)

    def __repr__(self):
        return _orthogonalbasis.OrthogonalBasis___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.OrthogonalBasis_swiginit(self, _orthogonalbasis.new_OrthogonalBasis(*args))
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalBasis

# Register OrthogonalBasis in _orthogonalbasis:
_orthogonalbasis.OrthogonalBasis_swigregister(OrthogonalBasis)
class OrthogonalUniVariateFunctionFactory(openturns.func.UniVariateFunctionFactory):
    r"""Base class for orthogonal univariate function factories."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFactory_getClassName(self)
    ANALYSIS = _orthogonalbasis.OrthogonalUniVariateFunctionFactory_ANALYSIS
    PROBABILITY = _orthogonalbasis.OrthogonalUniVariateFunctionFactory_PROBABILITY

    def __repr__(self):
        return _orthogonalbasis.OrthogonalUniVariateFunctionFactory___repr__(self)

    def getMeasure(self):
        r"""
        Accessor to the associated probability measure.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            The associated probability measure (according to which the functions are
            orthogonal).

        Notes
        -----
        Two functions P and Q are orthogonal with respect to the **probability
        measure** :math:`w(x) \di{x}` if and only if their scalar product:

        .. math::

            \langle P, Q \rangle = \int_{\alpha}^{\beta} P(x) Q(x) w(x) \di{x}
                                 = 0

        where :math:`\alpha \in \Rset \cup \{-\infty\}` and
        :math:`\beta \in \Rset \cup \{+\infty\}`.
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFactory_getMeasure(self)

    def __init__(self, *args):
        _orthogonalbasis.OrthogonalUniVariateFunctionFactory_swiginit(self, _orthogonalbasis.new_OrthogonalUniVariateFunctionFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariateFunctionFactory

# Register OrthogonalUniVariateFunctionFactory in _orthogonalbasis:
_orthogonalbasis.OrthogonalUniVariateFunctionFactory_swigregister(OrthogonalUniVariateFunctionFactory)
class _OrthogonalUniVariateFunctionFactoryTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _orthogonalbasis._OrthogonalUniVariateFunctionFactoryTypedInterfaceObject_swiginit(self, _orthogonalbasis.new__OrthogonalUniVariateFunctionFactoryTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _orthogonalbasis._OrthogonalUniVariateFunctionFactoryTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _orthogonalbasis._OrthogonalUniVariateFunctionFactoryTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _orthogonalbasis._OrthogonalUniVariateFunctionFactoryTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _orthogonalbasis._OrthogonalUniVariateFunctionFactoryTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _orthogonalbasis._OrthogonalUniVariateFunctionFactoryTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _orthogonalbasis.delete__OrthogonalUniVariateFunctionFactoryTypedInterfaceObject

# Register _OrthogonalUniVariateFunctionFactoryTypedInterfaceObject in _orthogonalbasis:
_orthogonalbasis._OrthogonalUniVariateFunctionFactoryTypedInterfaceObject_swigregister(_OrthogonalUniVariateFunctionFactoryTypedInterfaceObject)
class OrthogonalUniVariateFunctionFamily(_OrthogonalUniVariateFunctionFactoryTypedInterfaceObject):
    r"""
    Base class for orthogonal univariate polynomial factories.

    See also
    --------
    StandardDistributionPolynomialFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFamily_getClassName(self)

    def __init__(self, *args):
        _orthogonalbasis.OrthogonalUniVariateFunctionFamily_swiginit(self, _orthogonalbasis.new_OrthogonalUniVariateFunctionFamily(*args))

    def __repr__(self):
        return _orthogonalbasis.OrthogonalUniVariateFunctionFamily___repr__(self)

    def build(self, order):
        r"""
        Build the :math:`k`-th order orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \leq k`
            Polynomial order.

        Returns
        -------
        polynomial : :class:`~openturns.OrthogonalUniVariatePolynomial`
            Requested orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.build(2))
        -0.707107 + 0.707107 * X^2
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFamily_build(self, order)

    def getMeasure(self):
        r"""
        Accessor to the associated probability measure.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            The associated probability measure (according to which the polynomials are
            orthogonal).

        Notes
        -----
        Two polynomials P and Q are orthogonal with respect to the **probability
        measure** :math:`w(x) \di{x}` if and only if their dot product:

        .. math::

            \langle P, Q \rangle = \int_{\alpha}^{\beta} P(x) Q(x) w(x)\di{x}
                                 = 0

        where :math:`\alpha \in \Rset \cup \{-\infty\}` and
        :math:`\beta \in \Rset \cup \{+\infty\}`.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getMeasure())
        Normal(mu = 0, sigma = 1)

        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFamily_getMeasure(self)
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariateFunctionFamily

# Register OrthogonalUniVariateFunctionFamily in _orthogonalbasis:
_orthogonalbasis.OrthogonalUniVariateFunctionFamily_swigregister(OrthogonalUniVariateFunctionFamily)
class OrthogonalUniVariatePolynomialFunctionFactory(OrthogonalUniVariateFunctionFactory):
    r"""
    Polynomial specific orthogonal univariate function factory.

    Available constructor:
        OrthogonalUniVariatePolynomialFunctionFactory()

        OrthogonalUniVariatePolynomialFunctionFactory(*polynomialFactory*)

    Parameters
    ----------
    polynomialFactory : :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
        The polynomial factory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomialFactory = ot.HermiteFactory()
    >>> functionFactory = ot.OrthogonalUniVariatePolynomialFunctionFactory(polynomialFactory)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFunctionFactory_getClassName(self)

    def __repr__(self):
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFunctionFactory___repr__(self)

    def build(self, order):
        r"""
        Build the :math:`n`-th order orthogonal univariate function.

        Parameters
        ----------
        n : int, :math:`0 \leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested orthogonal univariate function.
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFunctionFactory_build(self, order)

    def __init__(self, *args):
        _orthogonalbasis.OrthogonalUniVariatePolynomialFunctionFactory_swiginit(self, _orthogonalbasis.new_OrthogonalUniVariatePolynomialFunctionFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariatePolynomialFunctionFactory

# Register OrthogonalUniVariatePolynomialFunctionFactory in _orthogonalbasis:
_orthogonalbasis.OrthogonalUniVariatePolynomialFunctionFactory_swigregister(OrthogonalUniVariatePolynomialFunctionFactory)
class OrthogonalProductFunctionFactory(OrthogonalFunctionFactory):
    r"""
    Base class for orthogonal multivariate functions.

    Parameters
    ----------
    functions : list of :class:`~openturns.OrthogonalUniVariateFunctionFamily`
        List of orthogonal univariate function factories with the same
        dimension as the orthogonal basis.
    enumerateFunction : :class:`~openturns.EnumerateFunction`, optional
        Associates to an integer its multi-index image in the :math:`\Nset^d`
        dimension, which is the dimension of the basis. This multi-index represents
        the collection of degrees of the univariate polynomials.

    Notes
    -----
    OrthogonalProductFunctionFactory is a particular case of implementation of
    the :class:`~openturns.OrthogonalBasis` in the case of polynomial chaos
    expansion. It provides to the OrthogonalBasis the persistent types of the
    univariate orthogonal polynomials (e.g. Hermite, Legendre, Laguerre and Jacobi)
    needed to determine the distribution measure of projection of the input
    variable. Let's note that the exact hessian and gradient have been implemented
    for the product of polynomials.
    To facilitate the construction of the basis it is recommended to use the class
    :class:`~openturns.StandardDistributionPolynomialFactory`.

    See also
    --------
    OrthogonalProductPolynomialFactory

    Examples
    --------
    Create from a list of orthogonal functions.

    >>> import openturns as ot
    >>> funcColl = [ot.HaarWaveletFactory(), ot.FourierSeriesFactory()]
    >>> productBasis = ot.OrthogonalProductFunctionFactory(funcColl)

    Set an enumerate function.

    >>> funcColl = [ot.HaarWaveletFactory(), ot.FourierSeriesFactory()]
    >>> inputDimension = len(funcColl)
    >>> enumerateFunction = ot.LinearEnumerateFunction(inputDimension)
    >>> productBasis = ot.OrthogonalProductFunctionFactory(funcColl, enumerateFunction)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalProductFunctionFactory_getClassName(self)

    def build(self, *args):
        r"""
        Get the term of the basis collection at a given index or multi-indices.

        Parameters
        ----------
        index : int
            Indicates the term of the basis which must be constructed. In other words,
            *index* is used by a bijection from :math:`\Nset` to :math:`\Nset^d`
            (with :math:`d` the dimension of the basis). The bijection is detailed in
            :class:`~openturns.EnumerateFunction`.
        indices : sequence of int
            Indicates the term of the basis which must be constructed. In other words,
            *indices* is used by a bijection from :math:`\Nset^d` to :math:`\Nset`
            (with :math:`d` the dimension of the basis). The bijection is the inverse of
            :class:`~openturns.EnumerateFunction`.

        Returns
        -------
        function : :class:`~openturns.Function`
            The term of the basis collection at the index *index* or the inverse of
            *indices*.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis =  ot.OrthogonalProductPolynomialFactory(polynomialCollection)
        >>> termBasis = productBasis.build(4)
        >>> print(termBasis.getEvaluation())
        -1.11803 + 3.3541 * x0^2
        >>> termBasis = productBasis.build(5)
        >>> print(termBasis.getEvaluation())
        1.73205 * x0 * (-1 + x1)
        >>> termBasis2 = productBasis.build([1, 1, 0])
        >>> print(termBasis2.getEvaluation())
        1.73205 * x0 * (-1 + x1)

        """
        return _orthogonalbasis.OrthogonalProductFunctionFactory_build(self, *args)

    def getEnumerateFunction(self):
        r"""
        Return the enumerate function.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            Enumerate function that translates unidimensional indices into
            multidimensional indices.
        """
        return _orthogonalbasis.OrthogonalProductFunctionFactory_getEnumerateFunction(self)

    def getFunctionFamilyCollection(self):
        r"""
        Get the collection of univariate orthogonal function families.

        Returns
        -------
        polynomialFamily : list of :class:`~openturns.OrthogonalUniVariateFunctionFamily`
            List of orthogonal univariate function families.
        """
        return _orthogonalbasis.OrthogonalProductFunctionFactory_getFunctionFamilyCollection(self)

    def getMarginal(self, indices):
        r"""
        Get the marginal orthogonal functions.

        Parameters
        ----------
        indices : sequence of int, :math:`0 \leq i < \inputDim`
            List of marginal indices of the input variables.

        Returns
        -------
        functionFamilylist : list of :class:`~openturns.OrthogonalUniVariateFunctionFamily`
            The marginal orthogonal functions.

        Examples
        --------
        >>> import openturns as ot
        >>> funcColl = [ot.HaarWaveletFactory(), ot.FourierSeriesFactory(), ot.HaarWaveletFactory()]
        >>> productBasis = ot.OrthogonalProductFunctionFactory(funcColl)
        >>> marginalProduct = productBasis.getMarginal([0, 2])  #  [ot.HaarWaveletFactory(), ot.HaarWaveletFactory()]
        """
        return _orthogonalbasis.OrthogonalProductFunctionFactory_getMarginal(self, indices)

    def isTensorProduct(self):
        r"""
        Tell whether the basis is a tensor product

        Returns
        -------
        isTensorProduct : bool
            `True` if the basis is a tensor product.
        """
        return _orthogonalbasis.OrthogonalProductFunctionFactory_isTensorProduct(self)

    def __repr__(self):
        return _orthogonalbasis.OrthogonalProductFunctionFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.OrthogonalProductFunctionFactory_swiginit(self, _orthogonalbasis.new_OrthogonalProductFunctionFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalProductFunctionFactory

# Register OrthogonalProductFunctionFactory in _orthogonalbasis:
_orthogonalbasis.OrthogonalProductFunctionFactory_swigregister(OrthogonalProductFunctionFactory)
class OrthogonalProductPolynomialFactory(OrthogonalFunctionFactory):
    r"""
    Base class for orthogonal multivariate polynomials.

    Available constructors:
        OrthogonalProductPolynomialFactory(*polynomials*)

        OrthogonalProductPolynomialFactory(*polynomials, enumerateFunction*)

        OrthogonalProductPolynomialFactory(*marginals*)

        OrthogonalProductPolynomialFactory(*marginals, enumerateFunction*)

    Parameters
    ----------
    polynomials : sequence of :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
        List of orthogonal univariate polynomials factories with the same
        dimension as the orthogonal basis.
    enumerateFunction : :class:`~openturns.EnumerateFunction`
        Associates to an integer its multi-index image in the :math:`\Nset^d`
        dimension, which is the dimension of the basis. This multi-index represents
        the collection of degrees of the univariate polynomials.
    marginals : sequence of :class:`~openturns.Distribution`
        List of physical space marginals.

    Notes
    -----
    OrthogonalProductPolynomialFactory is a particular case of implementation of
    the :class:`~openturns.OrthogonalBasis` in the case of polynomial chaos
    expansion. It provides to the OrthogonalBasis the persistent types of the
    univariate orthogonal polynomials (e.g. Hermite, Legendre, Laguerre and Jacobi)
    needed to determine the distribution measure of projection of the input
    variable. Let's note that the exact hessian and gradient have been implemented
    for the product of polynomials.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    Create from a collection of orthogonal polynomials.

    >>> import openturns as ot
    >>> polyColl = [ot.HermiteFactory(), ot.LegendreFactory(), ot.LaguerreFactory()]
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(polyColl)

    Easy way to create a multivariate orthonormal basis from a distribution.

    >>> Xdist = ot.JointDistribution([ot.Normal(), ot.Uniform(), ot.Gamma(2.75, 1.0)])
    >>> marginals = [Xdist.getMarginal(i) for i in range(Xdist.getDimension())]
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(marginals)

    Set an enumerate function.

    >>> polyColl = [ot.HermiteFactory(), ot.LegendreFactory(), ot.LaguerreFactory()]
    >>> enumerateFunction = ot.LinearEnumerateFunction(3)
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(polyColl, enumerateFunction)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_getClassName(self)

    def build(self, *args):
        r"""
        Get the term of the basis collection at a given index or multi-indices.

        Parameters
        ----------
        index : int
            Indicates the term of the basis which must be constructed. In other words,
            *index* is used by a bijection from :math:`\Nset` to :math:`\Nset^d`
            (with :math:`d` the dimension of the basis). The bijection is detailed in
            :class:`~openturns.EnumerateFunction`.
        indices : sequence of int
            Indicates the term of the basis which must be constructed. In other words,
            *indices* is used by a bijection from :math:`\Nset^d` to :math:`\Nset`
            (with :math:`d` the dimension of the basis). The bijection is the inverse of
            :class:`~openturns.EnumerateFunction`.

        Returns
        -------
        function : :class:`~openturns.Function`
            The term of the basis collection at the index *index* or the inverse of
            *indices*.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis =  ot.OrthogonalProductPolynomialFactory(polynomialCollection)
        >>> termBasis = productBasis.build(4)
        >>> print(termBasis.getEvaluation())
        -1.11803 + 3.3541 * x0^2
        >>> termBasis = productBasis.build(5)
        >>> print(termBasis.getEvaluation())
        1.73205 * x0 * (-1 + x1)
        >>> termBasis2 = productBasis.build([1, 1, 0])
        >>> print(termBasis2.getEvaluation())
        1.73205 * x0 * (-1 + x1)

        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_build(self, *args)

    def getEnumerateFunction(self):
        r"""
        Return the enumerate function.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            Enumerate function that translates unidimensional indices into
            multidimensional indices.
        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_getEnumerateFunction(self)

    def getPolynomialFamilyCollection(self):
        r"""
        Get the collection of univariate orthogonal polynomial families.

        Returns
        -------
        polynomialFamily : list of :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
            List of orthogonal univariate polynomials families.
        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_getPolynomialFamilyCollection(self)

    def getNodesAndWeights(self, degrees):
        r"""
        Get the nodes and the weights.

        Parameters
        ----------
        degrees : list of positive int (:math:`k_1, \dots, k_n`)
            List of :math:`n` polynomial orders associated with the :math:`n`
            univariate polynomials of the basis.

        Returns
        -------
        nodes : :class:`~openturns.Sample`
        weights : :class:`~openturns.Point`
            Nodes and weights of the multivariate polynomial associated with the
            marginal degrees (:math:`k_1, \dots, k_n`) as the tensor product
            of the marginal orthogonal univariate polynomials, to build multivariate
            quadrature rules.

        See also
        --------
        OrthogonalUniVariatePolynomialFamily.getNodesAndWeights

        Examples
        --------
        >>> import openturns as ot
        >>> # Define the model
        >>> myModel = ot.SymbolicFunction(['x1','x2','x3'], ['1+x1*x2 + 2*x3^2'])
        >>> # Create a distribution of dimension 3
        >>> Xdist = ot.JointDistribution([ot.Normal(), ot.Uniform(), ot.Gamma(2.75, 1.0)])
        >>> # Construct the multivariate orthonormal basis
        >>> polyColl = [ot.HermiteFactory(), ot.LegendreFactory(), ot.LaguerreFactory(2.75)]
        >>> enumerateFunction = ot.LinearEnumerateFunction(3)
        >>> productBasis = ot.OrthogonalProductPolynomialFactory(polyColl, enumerateFunction)
        >>> nodes, weights = productBasis.getNodesAndWeights([2, 3, 1])
        >>> print(nodes[:2])
            [ v0        v1        v2        ]
        0 : [ -1        -0.774597  3.75     ]
        1 : [  1        -0.774597  3.75     ]
        >>> print(weights[:2])
        [0.138889,0.138889]
        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_getNodesAndWeights(self, degrees)

    def getMarginal(self, indices):
        r"""
        Get the marginal orthogonal polynomials.

        Parameters
        ----------
        indices : sequence of int, :math:`0 \leq i < \inputDim`
            List of marginal indices of the input variables.

        Returns
        -------
        polynomialFamilylist : list of :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
            The marginal orthogonal polynomials.

        Examples
        --------
        >>> import openturns as ot
        >>> funcColl = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis = ot.OrthogonalProductPolynomialFactory(funcColl)
        >>> marginalProduct = productBasis.getMarginal([0, 2])  # [ot.LegendreFactory(), ot.HermiteFactory()]
        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_getMarginal(self, indices)

    def isTensorProduct(self):
        r"""
        Tell whether the basis is a tensor product

        Returns
        -------
        isTensorProduct : bool
            `True` if the basis is a tensor product.
        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_isTensorProduct(self)

    def __repr__(self):
        return _orthogonalbasis.OrthogonalProductPolynomialFactory___repr__(self)

    def __str__(self, *args):
        return _orthogonalbasis.OrthogonalProductPolynomialFactory___str__(self, *args)

    def __repr_markdown__(self):
        return _orthogonalbasis.OrthogonalProductPolynomialFactory___repr_markdown__(self)

    def __init__(self, *args):
        _orthogonalbasis.OrthogonalProductPolynomialFactory_swiginit(self, _orthogonalbasis.new_OrthogonalProductPolynomialFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalProductPolynomialFactory

# Register OrthogonalProductPolynomialFactory in _orthogonalbasis:
_orthogonalbasis.OrthogonalProductPolynomialFactory_swigregister(OrthogonalProductPolynomialFactory)

def __OrthogonalProductPolynomialFactory_repr_html(self):
    """Get HTML representation."""
    polynomialCollection = self.getPolynomialFamilyCollection()
    dimension = len(polynomialCollection)
    enumerateFunction = self.getEnumerateFunction()
    distribution = self.getMeasure()
    description = distribution.getDescription()
    html = ""
    html += "<ul>\n"
    html += f"  <li>dimension: {dimension}</li>\n"
    html += f"  <li>enumerate function: {enumerateFunction}</li>\n"
    html += "</ul>\n"
    html += "\n"
# Table of marginals
    html += "<table>\n"
# Header
    html += "  <tr>\n"
    html += "    <th>Index</th>\n"
    html += "    <th>Name</th>\n"
    html += "    <th>Distribution</th>\n"
    html += "    <th>Univariate polynomial</th>\n"
    html += "  </tr>\n"
# Content
    for i in range(dimension):
        univariatePolynomial = polynomialCollection[i]
        univariateImplementation = univariatePolynomial.getImplementation()
        html += "  <tr>\n"
        html += f"    <td>{i}</td>\n"
        html += f"    <td>{description[i]}</td>\n"
        marginalName = distribution.getMarginal(i).getImplementation().getClassName()
        html += f"    <td>{marginalName}</td>\n"
        try:
            hasSpecificFamily = univariateImplementation.getHasSpecificFamily()
            if hasSpecificFamily:
                marginalPolynomial = univariateImplementation.getSpecificFamily()
                polynomialImplementation = marginalPolynomial.getImplementation()
                className = polynomialImplementation.getClassName()
            else:
                orthoAlgorithm = univariateImplementation.getOrthonormalizationAlgorithm()
                orthoImplementation = orthoAlgorithm.getImplementation()
                className = orthoImplementation.getClassName()
        except:
            className = univariateImplementation.getClassName()
        html += f"    <td>{className}</td>\n"
        html += "  </tr>\n"
    html += "</table>\n"

    return html

OrthogonalProductPolynomialFactory._repr_html_ = __OrthogonalProductPolynomialFactory_repr_html

class FourierSeriesFactory(OrthogonalUniVariateFunctionFactory):
    r"""
    Fourier series function factory.

    Generates the Fourier basis defined as follows:

    .. math::

        \begin{array}{lcl}
          \psi_0(x)      & = & 1 \\
          \psi_{2k+1}(x) & = & \sqrt{2}\sin(kx) \\
          \psi_{2k+2}(x) & = & \sqrt{2}\cos(kx)
        \end{array}

    This basis is orthogonal with respect to the uniform distribution
    with minimum bound :math:`-\pi` and maximum bound :math:`\pi`.
    Moreover, the basis functions have unit norm.

    See also
    --------
    OrthogonalUniVariatePolynomialFunctionFactory

    Examples
    --------
    The next example creates a tensor-product basis of Fourier functions.

    >>> import openturns as ot
    >>> inputDimension = 3
    >>> familyColl = [ot.FourierSeriesFactory()] * inputDimension
    >>> enumerateFunction = ot.LinearEnumerateFunction(inputDimension)
    >>> basis = ot.OrthogonalProductFunctionFactory(familyColl, enumerateFunction)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.FourierSeriesFactory_getClassName(self)

    def __repr__(self):
        return _orthogonalbasis.FourierSeriesFactory___repr__(self)

    def build(self, order):
        r"""
        Build the :math:`n`-th order orthogonal univariate function.

        Parameters
        ----------
        n : int, :math:`0 \leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested orthogonal univariate function.
        """
        return _orthogonalbasis.FourierSeriesFactory_build(self, order)

    def __init__(self, *args):
        _orthogonalbasis.FourierSeriesFactory_swiginit(self, _orthogonalbasis.new_FourierSeriesFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_FourierSeriesFactory

# Register FourierSeriesFactory in _orthogonalbasis:
_orthogonalbasis.FourierSeriesFactory_swigregister(FourierSeriesFactory)
class HaarWaveletFactory(OrthogonalUniVariateFunctionFactory):
    r"""
    Haar wavelet function factory.

    Generates the Haar basis defined as follows:

    .. math::

        \begin{array}{lcl}
          \psi_0(x) & = & \fcar{[0, 1]}{x} \\
          \psi_n(x) & = & \frac{1}{2^{j/2}}\left[\fcar{[\frac{k}{2^j},\frac{k+1/2}{2^j}]}{x}-\fcar{[\frac{k+1/2}{2^j},\frac{k+1}{2^j}]}{x}\right]
        \end{array}

    where :math:`n = 2^j + k`, :math:`0 \leq k < 2^j`, :math:`0 \leq j`.

    See also
    --------
    OrthogonalUniVariatePolynomialFunctionFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.HaarWaveletFactory_getClassName(self)

    def __repr__(self):
        return _orthogonalbasis.HaarWaveletFactory___repr__(self)

    def build(self, order):
        r"""
        Build the :math:`n`-th order orthogonal univariate function.

        Parameters
        ----------
        n : int, :math:`0 \leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested orthogonal univariate function.
        """
        return _orthogonalbasis.HaarWaveletFactory_build(self, order)

    def __init__(self, *args):
        _orthogonalbasis.HaarWaveletFactory_swiginit(self, _orthogonalbasis.new_HaarWaveletFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_HaarWaveletFactory

# Register HaarWaveletFactory in _orthogonalbasis:
_orthogonalbasis.HaarWaveletFactory_swigregister(HaarWaveletFactory)
class SoizeGhanemFactory(OrthogonalFunctionFactory):
    r"""
    SoizeGhanem orthonormal multivariate functional family.

    For the any multivariate distribution with continuous copula.

    Available constructor:
        SoizeGhanemFactory(*measure, useCopula*)

        SoizeGhanemFactory(*measure, phi, useCopula*)


    Parameters
    ----------
    measure : :class:`~openturns.Distribution`
        The measure defining the inner product of the factory.
    phi : :class:`~openturns.EnumerateFunction`
        The function mapping the index of the multivariate basis function to the multi-index of the marginal variables.
        Default is to use the :class:`~openturns.LinearEnumerateFunction`.
    useCopula : bool
        Flag to tell if the copula density has to be used directly or indirectly through the joint PDF of the measure. Default is True.

    Notes
    -----
    This class implements the multivariate orthonormal basis associated with an arbitrary multidimensional distribution with continuous copula and marginals with well-defined orthonormal polyomials of arbitrary order. The details are in [soizeghanem2004]_.

    See also
    --------
        StandardDistributionPolynomialFactory, OrthogonalProductPolynomialFactory, experimental.FiniteOrthogonalFunctionFactory

    Examples
    --------
    >>> import openturns as ot
    >>> marginals = [ot.Uniform(-1.0, 1.0), ot.Normal(0.0, 1.0)]
    >>> copula = ot.ClaytonCopula(1.0)
    >>> distribution = ot.JointDistribution(marginals, copula)
    >>> factory = ot.SoizeGhanemFactory(distribution)
    >>> point = [0.5]*2
    >>> for i in range(3):
    ...     value = factory.build(i)(point)
    ...     print('SoizeGhanem_' + str(i) + '(' + str(point) + ')=' + str(value))
    SoizeGhanem_0([0.5, 0.5])=[0.870518]
    SoizeGhanem_1([0.5, 0.5])=[0.753891]
    SoizeGhanem_2([0.5, 0.5])=[0.435259]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.SoizeGhanemFactory_getClassName(self)

    def build(self, *args):
        r"""
        Get the term of the basis collection at a given index or multi-indices.

        Parameters
        ----------
        index : int
            Indicates the term of the basis which must be constructed. In other words,
            *index* is used by a bijection from :math:`\Nset` to :math:`\Nset^d`
            (with :math:`d` the dimension of the basis). The bijection is detailed in
            :class:`~openturns.EnumerateFunction`.
        indices : sequence of int
            Indicates the term of the basis which must be constructed. In other words,
            *indices* is used by a bijection from :math:`\Nset^d` to :math:`\Nset`
            (with :math:`d` the dimension of the basis). The bijection is the inverse of
            :class:`~openturns.EnumerateFunction`.

        Returns
        -------
        function : :class:`~openturns.Function`
            The term of the basis collection at the index *index* or the inverse of
            *indices*.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis =  ot.OrthogonalProductPolynomialFactory(polynomialCollection)
        >>> termBasis = productBasis.build(4)
        >>> print(termBasis.getEvaluation())
        -1.11803 + 3.3541 * x0^2
        >>> termBasis = productBasis.build(5)
        >>> print(termBasis.getEvaluation())
        1.73205 * x0 * (-1 + x1)
        >>> termBasis2 = productBasis.build([1, 1, 0])
        >>> print(termBasis2.getEvaluation())
        1.73205 * x0 * (-1 + x1)

        """
        return _orthogonalbasis.SoizeGhanemFactory_build(self, *args)

    def getEnumerateFunction(self):
        r"""
        Return the enumerate function.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            Enumerate function that translates unidimensional indices into
            multidimensional indices.
        """
        return _orthogonalbasis.SoizeGhanemFactory_getEnumerateFunction(self)

    def getMarginal(self, indices):
        r"""
        Get the marginal orthogonal functions.

        Parameters
        ----------
        indices : sequence of int, :math:`0 \leq i < \inputDim`
            List of marginal indices of the input variables.

        Returns
        -------
        functionFamilylist : list of :class:`~openturns.OrthogonalBasis`
            The marginal orthogonal functions.
        """
        return _orthogonalbasis.SoizeGhanemFactory_getMarginal(self, indices)

    def isTensorProduct(self):
        r"""
        Tell whether the basis is a tensor product

        Returns
        -------
        isTensorProduct : bool
            `True` if the basis is a tensor product.
        """
        return _orthogonalbasis.SoizeGhanemFactory_isTensorProduct(self)

    def __repr__(self):
        return _orthogonalbasis.SoizeGhanemFactory___repr__(self)

    def __init__(self, *args):
        _orthogonalbasis.SoizeGhanemFactory_swiginit(self, _orthogonalbasis.new_SoizeGhanemFactory(*args))
    __swig_destroy__ = _orthogonalbasis.delete_SoizeGhanemFactory

# Register SoizeGhanemFactory in _orthogonalbasis:
_orthogonalbasis.SoizeGhanemFactory_swigregister(SoizeGhanemFactory)

