// This code was autogenerated with `dbus-codegen-rust --file test.xml`, see https://github.com/diwic/dbus-rs
use dbus::{self as dbus, blocking::{Connection, stdintf::org_freedesktop_dbus::PropertiesPropertiesChanged}};
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;
use gtk::glib::Sender;

use crate::message::Message;

pub static mut CANCEL_BATTERY_CHECK: bool = false;
static mut LAST_ADDRESS: String = String::new();
static mut PATH: String = String::new();

pub trait OrgBluezBattery1 {
    fn percentage(&self) -> Result<u8, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> OrgBluezBattery1 for blocking::Proxy<'a, C> {
    fn percentage(&self) -> Result<u8, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.Battery1", "Percentage")
    }
}

// if battery state changes, then update the UI
fn handle_properties_updated(sender: Sender<Message>) {
    let conn = Connection::new_system().unwrap();
    let proxy = conn.with_proxy("org.bluez", unsafe {&PATH}, std::time::Duration::from_millis(5000));
    
    let reported = if let Ok(val) = proxy.percentage() {
        val as i8
    }
    else {
        -1
    };
    sender.send(Message::UpdateBatteryLevel(reported)).expect("cannot send message");
}

/// Gets (and continues getting) the battery level of a device until it is canceled
pub fn get_battery_for_device(address: String, adapter: String, sender: Sender<Message>) {
    unsafe {
        if address == LAST_ADDRESS {
            println!("stopped checking battery, last addressed matched");
            return;
        }
        else {
            LAST_ADDRESS = address.clone();
        }
    }

	// to get the path to this device make it so the full path is 
	// something like "/org/bluez/dev_XX_XX_XX_XX_XX_XX"
	let fixed_address = "dev_".to_string() + &address.replace(':', "_");
	let path = "/org/bluez/".to_string() + &adapter + "/" + &fixed_address;
	unsafe {
		PATH = path.clone();
	}
	// println!("full path to device is: {}", path);

	let conn = Connection::new_system().unwrap();
    let proxy = conn.with_proxy("org.bluez", path, std::time::Duration::from_millis(5000));

    let sender_clone = sender.clone();
    proxy.match_signal(move |_: PropertiesPropertiesChanged, _: &Connection, _: &dbus::Message| {
        let clone = sender_clone.clone();
	    handle_properties_updated(clone);
	    true
    }).expect("can't match signal");

    // send a first reported battery to the UI as we don't want to wait for the battery to change to let the user know what it is
    // as that could take an unreasonably long time with the dbus implementation
    // should add a fallback (or maybe make this the fallback) with a better get battery method
    let first_reported = if let Ok(val) = proxy.percentage() {
        val as i8
    }
    else {
        -1
    };
    
    sender.send(Message::UpdateBatteryLevel(first_reported)).expect("cannot send message");
    
    // get battery till canceled
    loop {
        conn.process(std::time::Duration::from_millis(1000)).expect("cannot process battery check request");
        unsafe {
            if CANCEL_BATTERY_CHECK && address != LAST_ADDRESS {
                println!("stopped checking battery");
                CANCEL_BATTERY_CHECK = false;
                break;
            }
        }
    }
}
