/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayFeatureTypeTrajectory;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.math.PointLL;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcGridderFeatureTypeTrajectory
extends NcGridder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public boolean setBounds(double b1, double b2) {
        return true;
    }

    public double[][] regridAsIs(NcArray a) {
        NcArrayFeatureTypeTrajectory nca = (NcArrayFeatureTypeTrajectory)a;
        boolean hasBad = nca.hasBadValues();
        int icount = nca.getLength();
        ArrayList<double[]> alist = new ArrayList<double[]>(icount);
        boolean lastWasNull = false;
        for (int i = 0; i < icount; ++i) {
            PointLL pt = nca.lonLatAt(i);
            double[] item = new double[3];
            if (pt == null) {
                if (lastWasNull) continue;
                item[0] = Double.NaN;
                item[1] = Double.NaN;
                item[2] = Double.NaN;
                lastWasNull = true;
            } else {
                double val = nca.valueAt(i);
                if (hasBad && nca.isMissingOrInvalid(val)) {
                    item[0] = Double.NaN;
                    item[1] = Double.NaN;
                    item[2] = Double.NaN;
                    if (lastWasNull) continue;
                    lastWasNull = true;
                } else {
                    item[0] = pt.getLon();
                    item[1] = pt.getLat();
                    item[2] = val;
                    lastWasNull = false;
                }
            }
            alist.add(item);
        }
        LOGGER.trace("in {}, out {}", (Object)icount, (Object)alist.size());
        return (double[][])alist.toArray((T[])new double[0][]);
    }
}

