/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.util.DescribedItem;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ImageOutputFormat implements DescribedItem
{
    GIF(new String[]{"GIF"}, true),
    JPEG(new String[]{"JPEG", "JPG"}, true),
    PDF(new String[]{"PDF"}, false),
    PNG(new String[]{"PNG"}, true),
    PS(new String[]{"PS"}, false),
    SVG(new String[]{"SVG"}, false),
    TIFF(new String[]{"TIFF", "TIF"}, true);

    private static final Logger LOGGER;
    private String[] extensions_;
    private boolean isBitmap_;

    private ImageOutputFormat(String[] extensions, boolean isBitmap) {
        this.extensions_ = extensions;
        this.isBitmap_ = isBitmap;
    }

    @Override
    public String getDescription() {
        return this.name();
    }

    public String toString() {
        return this.name();
    }

    public boolean isBitmap() {
        return this.isBitmap_;
    }

    @Override
    public boolean matches(String text) {
        for (int i = 0; i < this.extensions_.length; ++i) {
            if (!this.extensions_[i].equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public static ImageOutputFormat matching(String text) {
        Objects.requireNonNull(text, "Extension text cannot be null");
        for (ImageOutputFormat value : ImageOutputFormat.values()) {
            if (!value.matches(text)) continue;
            return value;
        }
        return null;
    }

    public static ImageOutputFormat matching(File ff, boolean pngDefault) {
        Objects.requireNonNull(ff, "File cannot be null");
        String fext = FileUtils.extractFnameExt(ff);
        if (fext == null) {
            LOGGER.trace("Could not extract a filetype extension from file's name.");
            if (pngDefault) {
                LOGGER.trace("Returning specified default PNG.");
                return PNG;
            }
            return null;
        }
        ImageOutputFormat format = ImageOutputFormat.matching(fext);
        if (format == null) {
            LOGGER.debug("Could not determine output file format from filename extension.");
            if (pngDefault) {
                LOGGER.trace("Returning specified default PNG.");
                return PNG;
            }
            return null;
        }
        return format;
    }

    static {
        LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

