/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.TwoHemisphereAzimuthalProjection;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Airy2H
extends TwoHemisphereAzimuthalProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Airy (Two-Hemisphere)";
    private static final double RADIUS_FACTOR;
    private static final double CONST_B;

    public Airy2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public Airy2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 44040256, width, height, xmargin, ymargin, RADIUS_FACTOR);
        this.finishConstruction();
    }

    @Override
    protected double getKForLambdaPPhiP(double lambdaPRad, double phiPRad) {
        double cosZ = Math.cos(phiPRad) * Math.cos(lambdaPRad);
        if (cosZ == 1.0) {
            return 0.5 * (1.0 - CONST_B);
        }
        double onePCosZ = 1.0 + cosZ;
        double oneMCosZ = 1.0 - cosZ;
        return -Math.log(0.5 * onePCosZ) / oneMCosZ + 2.0 * CONST_B / onePCosZ;
    }

    @Override
    protected final double getZRadForRho(double rho) {
        double rhoOverRS = rho * this.invRS_;
        double z = rho * 1.5707963267948966 / this.rhoBorder_;
        for (int iter = 0; iter < 33; ++iter) {
            double dfunc;
            double halfZ = 0.5 * z;
            double cosHalfZ = Math.cos(halfZ);
            double secHalfZ = 1.0 / cosHalfZ;
            double secsqHalfZ = secHalfZ * secHalfZ;
            double lnSecHalfZ = Math.log(secHalfZ);
            double sinHalfZ = Math.sin(halfZ);
            double sinsqHalfZ = sinHalfZ * sinHalfZ;
            double cscsqHalfZ = 1.0 / sinsqHalfZ;
            double tanHalfZ = Math.tan(halfZ);
            double cotHalfZ = 1.0 / tanHalfZ;
            double func = 2.0 * (cotHalfZ * lnSecHalfZ + CONST_B * tanHalfZ) - rhoOverRS;
            double dz = -func / (dfunc = -cscsqHalfZ * lnSecHalfZ + 1.0 + CONST_B * secsqHalfZ);
            if (Double.isNaN(dz)) {
                z = 1.5533430342749532;
                continue;
            }
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }

    static {
        double halfBeta = 0.7853981633974483;
        double cosHalfBeta = Math.cos(0.7853981633974483);
        double secHalfBeta = 1.0 / cosHalfBeta;
        double lnSecHalfBeta = Math.log(secHalfBeta);
        double tanHalfBeta = Math.tan(0.7853981633974483);
        double tansqHalfBeta = tanHalfBeta * tanHalfBeta;
        double cotsqHalfBeta = 1.0 / tansqHalfBeta;
        CONST_B = cotsqHalfBeta * lnSecHalfBeta;
        double tanHalfZ = tanHalfBeta;
        double secHalfZ = secHalfBeta;
        double cotHalfZ = 1.0 / tanHalfZ;
        double lnSecHalfZ = Math.log(secHalfZ);
        RADIUS_FACTOR = 2.0 * (cotHalfZ * lnSecHalfZ + tanHalfZ * CONST_B);
    }
}

