/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.map.proj.Interruption;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mollweide
extends InterruptedPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Mollweide";
    public static final int PROPERTIES = 16785416;
    private static final double CSUBX = 0.9003163161571062;
    private static final double CSUBY = 1.4142135623730951;
    private static final double CSUBX_B = 1.0;
    private static final double CSUBY_B = 1.2732395447351628;
    private static final double MAX_X_OVER_RS = 2.8284271247461903;
    private static final double MAX_Y_OVER_RS = 1.4142135623730951;
    private double cSubX_ = 0.9003163161571062;
    private double cSubY_ = 1.4142135623730951;
    private double xFactor0_;
    private final ProjBooleanParameter bromParam_;

    public Mollweide(int width, int height) {
        this(width, height, 0, 0);
    }

    public Mollweide(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16785416, width, height, xmargin, ymargin, 2.8284271247461903, 1.4142135623730951);
        ProjListParameter interrupt = (ProjListParameter)this.getParameter(0);
        interrupt.setDefault(Interruption.CONTS.toString());
        interrupt.setValue(Interruption.CONTS.toString());
        this.bromParam_ = new ProjBooleanParameter("Apply Bromley's scaling", "Apply Bromley's scaling", false);
        this.addParameter(this.bromParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.bromParam_)) {
            this.setBromleyScaling(this.bromParam_.isSelected());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setBromleyScaling(boolean b) {
        if (b) {
            this.cSubX_ = 1.0;
            this.cSubY_ = 1.2732395447351628;
        } else {
            this.cSubX_ = 0.9003163161571062;
            this.cSubY_ = 1.4142135623730951;
        }
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.setMaxXYOverRS(this.cSubX_ * Math.PI, this.cSubY_);
    }

    @Override
    protected final void finishScaling() {
        this.xFactor0_ = this.invRS_ / this.cSubX_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (lat > 89.99999) {
            if (this.isInterrupted()) {
                return this.transformLL2XYIgnoreMargins(lon, 89.99999);
            }
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - this.cSubY_ * this.rS_);
        }
        if (lat < -89.99999) {
            if (this.isInterrupted()) {
                return this.transformLL2XYIgnoreMargins(lon, -89.99999);
            }
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + this.cSubY_ * this.rS_);
        }
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double piSinPhi = Math.PI * sinPhi;
        double thetaRad = phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - piSinPhi;
            double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double y = this.cSubY_ * Math.sin(thetaRad);
        if (this.isInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double nlon = MapUtils.normalizeMP180(lon);
            double dlon = nlon - gore[1];
            double dx = Math.toRadians(dlon) * this.cSubX_ * Math.cos(thetaRad);
            double cx = this.lonToLambdaRad(gore[1]) * this.cSubX_;
            x = cx + dx;
        } else {
            x = this.lonToLambdaRad(lon) * this.cSubX_ * Math.cos(thetaRad);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double thetaRad = Math.asin(y * this.invRS_ / this.cSubY_);
        double phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = this.invRS_ / (this.cSubX_ * Math.cos(thetaRad));
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Mollweide mollweide = this;
        synchronized (mollweide) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double yFactor = yOverRS / this.cSubY_;
                if (yFactor > 1.0) continue;
                double thetaRad = Math.asin(yFactor);
                double twoThetaRad = 2.0 * thetaRad;
                double sinPhi = (twoThetaRad + Math.sin(twoThetaRad)) * 0.3183098861837907;
                double phiRad = Math.asin(sinPhi);
                double phi = Math.toDegrees(phiRad);
                if (phi == 90.0) {
                    this.setInvPoint(0, iy, 0.0, 90.0);
                    continue;
                }
                if (phi == -90.0) {
                    this.setInvPoint(0, iy, 0.0, -90.0);
                    continue;
                }
                double xFactor = this.invRS_ / (this.cSubX_ * Math.cos(thetaRad));
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setInvPoint(ix, iy, lon, phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLinesUninterrupted(Graphics2D g2d) {
        ProjGraphicUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
    }

    @Override
    protected void drawBorderLinesInterrupted(Graphics2D g2d) {
        int ii;
        double[][] north = this.getGores()[0];
        double[][] south = this.getGores()[1];
        for (ii = 0; ii < north.length; ++ii) {
            if (ii == 0) {
                this.drawMeridianInterrupted(g2d, north[ii][0] + 1.0E-5, 90.0, true, true, false);
            } else {
                this.drawMeridianInterrupted(g2d, north[ii][0] + 1.0E-5, 90.0, true, false, false);
            }
            if (ii == north.length - 1) {
                this.drawMeridianInterrupted(g2d, north[ii][2] - 1.0E-5, 90.0, true, true, false);
                continue;
            }
            this.drawMeridianInterrupted(g2d, north[ii][2] - 1.0E-5, 90.0, true, false, false);
        }
        for (ii = 0; ii < south.length; ++ii) {
            if (ii != 0) {
                this.drawMeridianInterrupted(g2d, south[ii][0] + 1.0E-5, 90.0, false, true, false);
            }
            if (ii == south.length - 1) continue;
            this.drawMeridianInterrupted(g2d, south[ii][2] - 1.0E-5, 90.0, false, true, false);
        }
    }

    @Override
    protected void drawMeridianUninterrupted(Graphics2D g2d, double lon, double maxLat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (absLambdaRad < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
            double rectW = 2.0 * this.cSubX_ * absLambdaRad * this.rS_;
            double rectX = lambdaRad < 0.0 ? dotEq.x : dotEq.x - rectW;
            double rectH = 2.0 * this.cSubY_ * this.rS_;
            double rectY = (double)this.outCenterY_ - this.cSubY_ * this.rS_;
            if (lambdaRad > 0.0) {
                GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotS, dotN);
            } else {
                GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotN, dotS);
            }
        }
    }

    @Override
    protected void drawMeridianInterrupted(Graphics2D g2d, double lon, double maxLat) {
        this.drawMeridianInterrupted(g2d, lon, maxLat, true, true, true);
    }

    private void drawMeridianInterrupted(Graphics2D g2d, double lon, double maxLat, boolean drawNorth, boolean drawSouth, boolean skipIfBorder) {
        Point2D.Double dotS;
        Point2D.Double dotNP = this.transformLL2XY(lon, 90.0);
        Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
        Point2D.Double dotSP = this.transformLL2XY(lon, -90.0);
        if (dotNP == null) {
            LOGGER.debug("Got null NP dot for lon {}", (Object)lon);
            return;
        }
        if (dotEq == null) {
            LOGGER.debug("Got null EQ dot for lon {}", (Object)lon);
            return;
        }
        if (dotSP == null) {
            LOGGER.debug("Got null SP dot for lon {}", (Object)lon);
            return;
        }
        Point2D.Double dotN = maxLat > 89.99999 ? dotNP : this.transformLL2XY(lon, maxLat);
        Point2D.Double double_ = dotS = maxLat > 89.99999 ? dotSP : this.transformLL2XY(lon, -maxLat);
        if (drawNorth && drawSouth && Math.abs(dotNP.x - dotSP.x) < 1.0E-5 && Math.abs(dotNP.x - dotEq.x) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
            return;
        }
        for (int i = 0; i < 2; ++i) {
            boolean north;
            boolean bl = north = i == 0;
            if (north && !drawNorth || !north && !drawSouth) continue;
            double[] gore = i == 0 ? this.getGore(lon, 45.0) : this.getGore(lon, -45.0);
            double llon = gore[0];
            double clon = gore[1];
            double rlon = gore[2];
            if (skipIfBorder) {
                double dleft = MapUtils.normalizeMP180(lon - llon);
                double dright = MapUtils.normalizeMP180(lon - rlon);
                if (Math.abs(dleft) < 1.0E-5 || Math.abs(dright) < 1.0E-5) continue;
            }
            if (north) {
                if (Math.abs(dotNP.x - dotEq.x) < 1.0E-5) {
                    g2d.draw(new Line2D.Double(dotEq.x, dotEq.y, dotN.x, dotN.y));
                    continue;
                }
            } else if (Math.abs(dotSP.x - dotEq.x) < 1.0E-5) {
                g2d.draw(new Line2D.Double(dotS.x, dotS.y, dotEq.x, dotEq.y));
                continue;
            }
            double dlon = MapUtils.normalizeMP180(lon - clon);
            double lambdaRad = Math.toRadians(dlon);
            double absLambdaRad = Math.abs(lambdaRad);
            double rectW = 2.0 * this.cSubX_ * absLambdaRad * this.rS_;
            double rectX = lambdaRad < 0.0 ? dotEq.x : dotEq.x - rectW;
            double rectH = 2.0 * this.cSubY_ * this.rS_;
            double rectY = (double)this.outCenterY_ - this.cSubY_ * this.rS_;
            if (north) {
                if (lambdaRad >= 0.0) {
                    GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotEq, dotN);
                    continue;
                }
                GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotN, dotEq);
                continue;
            }
            if (lambdaRad >= 0.0) {
                GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotS, dotEq);
                continue;
            }
            GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotEq, dotS);
        }
    }
}

