/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnyderMEPointedPole
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Snyder Minimum-Error Pointed Pole";
    private static final double A1 = 1.27326;
    private static final double A3 = -0.04222;
    private static final double A5 = -0.0293;
    private static final double THREE_A3 = -0.12666;
    private static final double FIVE_A5 = -0.1465;
    private static final double MAX_X_OVER_RS = 2.467361460809099;
    private static final double MAX_Y_OVER_RS = 1.5561972319930646;

    public SnyderMEPointedPole(int width, int height) {
        this(width, height, 0, 0);
    }

    public SnyderMEPointedPole(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.467361460809099, 1.5561972319930646);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(Math.abs(lat));
        double phiRad2 = phiRad * phiRad;
        double phiRad4 = phiRad2 * phiRad2;
        double y = phiRad * (1.27326 + -0.04222 * phiRad2 + -0.0293 * phiRad4);
        double dyDphi = 1.27326 + -0.12666 * phiRad2 + -0.1465 * phiRad4;
        double lambdaRad = this.lonToLambdaRad(lon);
        double x = lambdaRad * Math.cos(phiRad) / dyDphi;
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = this.iteratePhiRad(absYOverRS);
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double phiRad2 = phiRad * phiRad;
        double phiRad4 = phiRad2 * phiRad2;
        double dyDphi = 1.27326 + -0.12666 * phiRad2 + -0.1465 * phiRad4;
        double d = lambdaRad = phiRad < 1.5707963267948966 ? absXOverRS * dyDphi / Math.cos(phiRad) : 0.0;
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        SnyderMEPointedPole snyderMEPointedPole = this;
        synchronized (snyderMEPointedPole) {
            double y;
            double yOverRS;
            double phiRad;
            block3: for (int iy = 0; iy < this.dyMax_ && !((phiRad = this.iteratePhiRad(Math.abs(yOverRS = (y = (double)iy + 0.5) * this.invRS_))) > 1.5707963267948966); ++iy) {
                double phiRad2 = phiRad * phiRad;
                double phiRad4 = phiRad2 * phiRad2;
                double dyDphiOverCosPhi = (1.27326 + -0.12666 * phiRad2 + -0.1465 * phiRad4) / Math.cos(phiRad);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double d = lambdaRad = phiRad < 1.5707963267948966 ? xOverRS * dyDphiOverCosPhi : 0.0;
                    if (lambdaRad > Math.PI) continue block3;
                    double phi = Math.toDegrees(phiRad);
                    double lambda = Math.toDegrees(lambdaRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    private double iteratePhiRad(double yOverRS) {
        double phiRad = 1.5707963267948966 * (yOverRS / 1.5561972319930646);
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            double func = phiRad * (1.27326 + -0.04222 * phiRad2 + -0.0293 * phiRad4) - yOverRS;
            double dfunc = 1.27326 + -0.12666 * phiRad2 + -0.1465 * phiRad4;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }
}

