/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpilhausOceanicConformal
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Spilhaus Oceanic (Conformal)";
    public static final int PROPERTIES = 4096;
    private static final double LOBE_DX = 1.885618016720417;
    private static final double LOBE_DY = 1.4142135623730951;
    private static final double MAX_X_OVER_RS = 2.0;
    private static final double MAX_Y_OVER_RS = 1.4142135623730951;
    private LonLatRotator rotMatrices_ = new LonLatRotator(15.0, -70.0, 90.0);

    public SpilhausOceanicConformal(int width, int height) {
        this(width, height, 0, 0);
    }

    public SpilhausOceanicConformal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4096, width, height, xmargin, ymargin, 2.0, 1.4142135623730951);
        this.finishConstruction();
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double[] llP = this.rotMatrices_.rotate(lon, lat);
        return this.transformLpLp2XYIgnoreMargins(llP[0], llP[1]);
    }

    private Point2D.Double transformLpLp2XYIgnoreMargins(double lonP, double latP) {
        double lambdaPRad = Math.toRadians(lonP);
        double lambdaPRadOver2 = 0.5 * lambdaPRad;
        double phiPRad = Math.toRadians(latP);
        double phiPRadOver2 = 0.5 * phiPRad;
        if (Math.abs(lambdaPRadOver2) < 1.0E-5 && Math.abs(phiPRadOver2) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(phiPRadOver2) < 1.0E-5) {
            double xp = Math.sin(lambdaPRadOver2) / (1.0 + Math.cos(lambdaPRadOver2));
            x = 0.5 * xp * (3.0 + xp * xp);
            y = 0.0;
        } else if (Math.abs(lambdaPRadOver2) < 1.0E-5) {
            double tanHalfPhiP = Math.tan(phiPRadOver2);
            double xtanHalfPhiP = Math.sqrt(1.0 - tanHalfPhiP * tanHalfPhiP);
            double yp = tanHalfPhiP / (1.0 + xtanHalfPhiP);
            x = 0.0;
            y = 0.5 * yp * (3.0 - yp * yp);
        } else {
            double tanHalfPhiP = Math.tan(phiPRadOver2);
            double xtanHalfPhiP = Math.sqrt(1.0 - tanHalfPhiP * tanHalfPhiP);
            double denom = 1.0 + Math.cos(lambdaPRadOver2) * xtanHalfPhiP;
            double xp = Math.sin(lambdaPRadOver2) * xtanHalfPhiP / denom;
            double yp = tanHalfPhiP / denom;
            double xp2 = xp * xp;
            double yp2 = yp * yp;
            x = 0.5 * xp * (3.0 + xp2 - 3.0 * yp2);
            y = 0.5 * yp * (3.0 + 3.0 * xp2 - yp2);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double capY;
        double capY2;
        double capX2;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(x) < 1.0E-5 && Math.abs(y) < 1.0E-5) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double v = Math.abs(yOverRS);
        double v2 = v * v;
        double u = Math.abs(xOverRS);
        double u2 = u * u;
        double onePlusU2PlusV2 = 1.0 + u2 + v2;
        double sinSq3Eta = 0.5 * (onePlusU2PlusV2 - Math.sqrt(onePlusU2PlusV2 * onePlusU2PlusV2 - 4.0 * v2));
        double sin3Eta = Math.sqrt(sinSq3Eta);
        double etaRad = Math.asin(sin3Eta) / 3.0;
        double cosh3Xi = v / sin3Eta;
        double xiRad = MathUtils.arcosh(cosh3Xi) / 3.0;
        double capX = 2.0 * Math.sinh(xiRad) * Math.cos(etaRad);
        double lambdaPRad = 2.0 * Math.atan2(2.0 * capX, 1.0 - (capX2 = capX * capX) - (capY2 = (capY = 2.0 * Math.cosh(xiRad) * Math.sin(etaRad)) * capY));
        if (Double.isNaN(lambdaPRad) || lambdaPRad > Math.PI) {
            return null;
        }
        double phiPRad = 2.0 * Math.atan2(2.0 * capY, 1.0 + capX2 + capY2);
        if (Double.isNaN(phiPRad)) {
            return null;
        }
        double lambdaP = Math.toDegrees(lambdaPRad);
        double phiP = Math.toDegrees(phiPRad);
        if (x < 0.0) {
            lambdaP = -lambdaP;
        }
        if (y < 0.0) {
            phiP = -phiP;
        }
        double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        SpilhausOceanicConformal spilhausOceanicConformal = this;
        synchronized (spilhausOceanicConformal) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double v = y * this.invRS_;
                double v2 = v * v;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double u = x * this.invRS_;
                    double u2 = u * u;
                    double onePlusU2PlusV2 = 1.0 + u2 + v2;
                    double sinSq3Eta = 0.5 * (onePlusU2PlusV2 - Math.sqrt(onePlusU2PlusV2 * onePlusU2PlusV2 - 4.0 * v2));
                    double sin3Eta = Math.sqrt(sinSq3Eta);
                    double etaRad = Math.asin(sin3Eta) / 3.0;
                    double cosh3Xi = v / sin3Eta;
                    double xiRad = Math.log(cosh3Xi + Math.sqrt(cosh3Xi * cosh3Xi - 1.0)) / 3.0;
                    double capX = 2.0 * Math.sinh(xiRad) * Math.cos(etaRad);
                    double capY = 2.0 * Math.cosh(xiRad) * Math.sin(etaRad);
                    double capX2 = capX * capX;
                    double capY2 = capY * capY;
                    double lambdaPRad = 2.0 * Math.atan2(2.0 * capX, 1.0 - capX2 - capY2);
                    double phiPRad = 2.0 * Math.atan2(2.0 * capY, 1.0 + capX2 + capY2);
                    if (lambdaPRad > Math.PI && u > 1.885618016720417) continue block3;
                    if (lambdaPRad > Math.PI) continue;
                    double lambdaP = Math.toDegrees(lambdaPRad);
                    double phiP = Math.toDegrees(phiPRad);
                    double[] llTR = this.rotMatrices_.inverse(lambdaP, phiP);
                    double[] llBR = this.rotMatrices_.inverse(lambdaP, -phiP);
                    double[] llBL = this.rotMatrices_.inverse(-lambdaP, -phiP);
                    double[] llTL = this.rotMatrices_.inverse(-lambdaP, phiP);
                    this.setInvPoint(ix, iy, llTR[0], llTR[1]);
                    this.setInvPoint(ix, -iy - 1, llBR[0], llBR[1]);
                    this.setInvPoint(-ix - 1, -iy - 1, llBL[0], llBL[1]);
                    this.setInvPoint(-ix - 1, iy, llTL[0], llTL[1]);
                }
            }
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda < 1.0E-5) {
            return;
        }
        super.drawMeridian(g2d, lon, maxLat, label);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier[] curves = this.makeOuterBeziers();
        if (curves != null) {
            if (curves[0] != null) {
                curves[0].draw(g2d);
            }
            if (curves[1] != null) {
                curves[1].draw(g2d);
            }
        }
    }

    private Bezier[] makeOuterBeziers() {
        double edgeLon = 179.99999;
        int np = 105;
        double fact = 0.8571428571428571;
        Point2D.Double[] dotsE = new Point2D.Double[211];
        Point2D.Double[] dotsW = new Point2D.Double[211];
        for (int j = 0; j <= 105; ++j) {
            double jj = 0.8571428571428571 * (double)j;
            Point2D.Double dot = this.transformLpLp2XYIgnoreMargins(179.99999, jj);
            if (dot == null) {
                LOGGER.warn("Null outer border point");
                return null;
            }
            dotsE[105 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[105 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[105 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[105 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        return new Bezier[]{new Bezier(false, dotsE), new Bezier(false, dotsW)};
    }
}

