/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.graphics.plot.PlotPropertyMap;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataGeneral2D;
import gov.nasa.giss.panoply.data.PanDataLatTime;
import gov.nasa.giss.panoply.data.PanDataLatVert;
import gov.nasa.giss.panoply.data.PanDataLonLatGridded;
import gov.nasa.giss.panoply.data.PanDataLonLatTrajectory;
import gov.nasa.giss.panoply.data.PanDataLonLatZonal;
import gov.nasa.giss.panoply.data.PanDataLonTime;
import gov.nasa.giss.panoply.data.PanDataLonVert;
import gov.nasa.giss.panoply.data.PanDataTime1D;
import gov.nasa.giss.panoply.data.PanDataTimeLat;
import gov.nasa.giss.panoply.data.PanDataTimeVert;
import gov.nasa.giss.panoply.plot.PanColorContourPlot;
import gov.nasa.giss.panoply.plot.PanHorizontalLinePlot;
import gov.nasa.giss.panoply.plot.PanLatTimePlot;
import gov.nasa.giss.panoply.plot.PanLatVertPlot;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanLonTimePlot;
import gov.nasa.giss.panoply.plot.PanLonVertPlot;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotConstraints;
import gov.nasa.giss.panoply.plot.PanPlotLayoutMeta;
import gov.nasa.giss.panoply.plot.PanPlotScaleMeta;
import gov.nasa.giss.panoply.plot.PanPlotUtils;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plot.PanTimeLatPlot;
import gov.nasa.giss.panoply.plot.PanTimeYPlot;
import gov.nasa.giss.panoply.plot.PanVerticalLinePlot;
import gov.nasa.giss.panoply.plot.PanZonalAverageLinePlot;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotHolder;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefs.PanSavedSettings;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanStringUtils;
import gov.nasa.giss.panoply.util.PanVectorType;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.time.UnixTimeFormatter;
import gov.nasa.giss.util.task.Task;
import gov.nasa.giss.util.task.TaskListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotMeta
extends PlotPropertyMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean NO_TASKS = false;
    private final PanPlotType ptype_;
    private PanData data_;
    private PanPlot plot_;
    private PanPlotFrame pframe_;
    private PanPlotScaleMeta smeta_;
    private PanProjectionMeta projmeta_;
    private PanPlotLayoutMeta layout_;
    private final PanActionHash actionHash_ = new PanActionHash(50);
    private boolean initializing_;
    private boolean replacing_;

    public PanPlotMeta(PanPlotType ptype) {
        this(ptype, 120);
    }

    public PanPlotMeta(PanPlotType ptype, int sizeFactor) {
        this.ptype_ = ptype;
        this.layout_ = new PanPlotLayoutMeta(this);
        this.init(sizeFactor);
    }

    protected void init(int sizeFactor) {
        int hfactor;
        int wfactor;
        this.initializing_ = true;
        PanPreferences prefs = PanPreferences.getSharedInstance();
        switch (this.ptype_) {
            case LON_LAT: {
                wfactor = prefs.getInt("plot:lonlat.size.width");
                hfactor = prefs.getInt("plot:lonlat.size.height");
                break;
            }
            case LL_TRAJ: {
                wfactor = prefs.getInt("plot:lonlat.size.width");
                hfactor = prefs.getInt("plot:lonlat.size.height");
                break;
            }
            case LAT_TIME: {
                wfactor = prefs.getInt("plot:lattime.size.width");
                hfactor = prefs.getInt("plot:lattime.size.height");
                break;
            }
            case LAT_VERT: {
                wfactor = prefs.getInt("plot:latvert.size.width");
                hfactor = prefs.getInt("plot:latvert.size.height");
                break;
            }
            case LON_TIME: {
                wfactor = prefs.getInt("plot:lontime.size.width");
                hfactor = prefs.getInt("plot:lontime.size.height");
                break;
            }
            case LON_VERT: {
                wfactor = prefs.getInt("plot:lonvert.size.width");
                hfactor = prefs.getInt("plot:lonvert.size.height");
                break;
            }
            case TIME_LAT: {
                wfactor = prefs.getInt("plot:timelat.size.width");
                hfactor = prefs.getInt("plot:timelat.size.height");
                break;
            }
            case TIME_VERT: {
                wfactor = prefs.getInt("plot:timevert.size.width");
                hfactor = prefs.getInt("plot:timevert.size.height");
                break;
            }
            case GENERAL_CC: {
                wfactor = prefs.getInt("plot:xy.size.width");
                hfactor = prefs.getInt("plot:xy.size.height");
                break;
            }
            case HORZ_LINE: 
            case LL_ZONAL: {
                wfactor = prefs.getInt("plot:lineplot.horz.size.width");
                hfactor = prefs.getInt("plot:lineplot.horz.size.height");
                break;
            }
            case VERT_LINE: {
                wfactor = prefs.getInt("plot:lineplot.vert.size.width");
                hfactor = prefs.getInt("plot:lineplot.vert.size.height");
                break;
            }
            default: {
                LOGGER.warn("Unknown plot type {}", (Object)this.ptype_);
                wfactor = 80;
                hfactor = 45;
            }
        }
        wfactor = PanPlotConstraints.constrainWidthFactor(wfactor);
        hfactor = PanPlotConstraints.constrainHeightFactor(hfactor);
        this.setInt("size.factor", sizeFactor);
        this.setInt("size.width", wfactor);
        this.setInt("size.height", hfactor);
        this.set("combination", PanCombinationType.A1_ONLY.name());
        this.initCommonParams(prefs);
        this.initAxesParams(prefs);
        if (this.ptype_.isLinePlot()) {
            this.initLinePlotParams(prefs);
        } else {
            this.initColorContourParams(prefs);
            this.initVectorParams(prefs);
        }
        if (this.ptype_.isLonLatMap()) {
            this.initMapParams(prefs);
            if (this.ptype_.isLonLatTrajectory()) {
                this.initTrajectoryParams(prefs);
            }
        }
        this.layout_.setInitialized();
        this.initializing_ = false;
    }

    private void initCommonParams(PanPreferences prefs) {
        this.setFloat("title.size", prefs.getFloat("plot:title.size"));
        this.setFloat("subtitle.size", prefs.getFloat("plot:subtitle.size"));
        this.setFloat("footnote.size", prefs.getFloat("plot:footnote.size"));
        this.setBoolean("include.title", true);
        this.setBoolean("include.colorbar", true);
        this.setBoolean("include.strokeinfo", true);
        this.setBoolean("include.axes", true);
        this.setBoolean("include.footnotes", true);
        this.setBoolean("include.margins", true);
        this.setColor("color.background", prefs.getColor("plot:color.background"));
        this.setString("labels.font", prefs.getString("plot:labels.font"));
        this.setBoolean("labels.super10", prefs.getBoolean("plot:labels.super10"));
        this.setString("title.text", "PLOT TITLE");
        this.setString("subtitle.text", "");
        this.setString("footnote.left", "");
        this.setString("footnote.right", "");
        this.setDouble("scale.min", 0.0);
        this.setDouble("scale.max", 1.0);
        this.setDouble("scale.coefficient", prefs.getDouble("plot:scale.coefficient"));
        this.setInt("scale.exponent", prefs.getInt("plot:scale.exponent"));
        this.setString("scale.units", "XXX");
        this.setString("scale.method", prefs.getString("plot:scale.method"));
        this.setInt("scale.div.major", prefs.getInt("plot:scale.div.major"));
        this.setInt("scale.div.minor", prefs.getInt("plot:scale.div.minor"));
        this.setString("scale.tick.format", prefs.getString("plot:scale.tick.format"));
        this.setFloat("scale.tick.size", prefs.getFloat("plot:scale.tick.size"));
        this.setBoolean("scale.label.custom", false);
        this.setString("scale.label.text", "SCALE CAPTION");
        this.setBoolean("footnote.minmax.vis", prefs.getBoolean("plot:footnote.minmax.vis"));
        this.setString("footnote.minmax.format", prefs.getString("plot:footnote.minmax.format"));
    }

    private void initAxesParams(PanPreferences prefs) {
        if (this.ptype_.isLonLatMap()) {
            return;
        }
        this.setString("xaxis.method", PanAxisMethod.SCALAR.name());
        this.setDouble("xaxis.begin", Double.NaN);
        this.setDouble("xaxis.end", Double.NaN);
        this.setString("xaxis.units", "");
        this.setString("xaxis.tick.format", "%.1f");
        this.setInt("xaxis.div.major", prefs.getInt("plot:xaxis.div.major"));
        this.setInt("xaxis.div.minor", prefs.getInt("plot:xaxis.div.minor"));
        this.setBoolean("xaxis.label.custom", false);
        this.setString("xaxis.label.text", "X AXIS");
        this.setString("yaxis.method", PanAxisMethod.SCALAR.name());
        this.setDouble("yaxis.begin", Double.NaN);
        this.setDouble("yaxis.end", Double.NaN);
        this.setString("yaxis.units", "");
        this.setInt("yaxis.div.major", prefs.getInt("plot:yaxis.div.major"));
        this.setInt("yaxis.div.minor", prefs.getInt("plot:yaxis.div.minor"));
        this.setString("yaxis.tick.format", "%.1f");
        this.setBoolean("yaxis.label.custom", false);
        this.setString("yaxis.label.text", "Y AXIS");
        if (this.ptype_.isLinePlot()) {
            this.setFloat("xaxis.label.size", prefs.getFloat("plot:lineplot.xaxis.label.size"));
            this.setFloat("yaxis.label.size", prefs.getFloat("plot:lineplot.yaxis.label.size"));
            this.setBoolean("axes.offset", prefs.getBoolean("plot:lineplot.axes.offset"));
            this.setInt("axes.tickmark.weight", prefs.getInt("plot:lineplot.axes.tickmark.weight"));
            this.setString("axes.tickmark.color", prefs.getString("plot:lineplot.axes.tickmark.color"));
            this.setFloat("xaxis.tick.size", prefs.getFloat("plot:lineplot.xaxis.tick.size"));
            this.setFloat("yaxis.tick.size", prefs.getFloat("plot:lineplot.yaxis.tick.size"));
            switch (this.ptype_) {
                case VERT_LINE: {
                    this.setString("scale.method", PanScaleMethod.SCALAR.name().toLowerCase());
                    this.setFloat("scale.label.size", prefs.getFloat("plot:lineplot.xaxis.label.size"));
                    this.setFloat("scale.tick.size", prefs.getFloat("plot:lineplot.xaxis.tick.size"));
                    break;
                }
                case HORZ_LINE: 
                case LL_ZONAL: {
                    this.setFloat("scale.label.size", prefs.getFloat("plot:lineplot.yaxis.label.size"));
                    this.setFloat("scale.tick.size", prefs.getFloat("plot:lineplot.yaxis.tick.size"));
                    break;
                }
            }
        } else {
            this.setFloat("xaxis.label.size", prefs.getFloat("plot:ccplot.xaxis.label.size"));
            this.setFloat("yaxis.label.size", prefs.getFloat("plot:ccplot.yaxis.label.size"));
            this.setBoolean("axes.offset", prefs.getBoolean("plot:ccplot.axes.offset"));
            this.setInt("axes.tickmark.weight", prefs.getInt("plot:ccplot.axes.tickmark.weight"));
            this.setString("axes.tickmark.color", prefs.getString("plot:ccplot.axes.tickmark.color"));
            this.setFloat("xaxis.tick.size", prefs.getFloat("plot:ccplot.xaxis.tick.size"));
            this.setFloat("yaxis.tick.size", prefs.getFloat("plot:ccplot.yaxis.tick.size"));
            switch (this.ptype_) {
                case LAT_TIME: {
                    this.setDouble("xaxis.begin", prefs.getDouble("plot:lattime.xaxis.begin"));
                    this.setDouble("xaxis.end", prefs.getDouble("plot:lattime.xaxis.end"));
                    this.setString("xaxis.label.text", "Latitude (\u00b0N)");
                    this.setString("yaxis.tick.format", "yyyy-MM-dd");
                    this.setString("yaxis.label.text", "TIME AXIS");
                    break;
                }
                case LAT_VERT: {
                    this.setDouble("xaxis.begin", prefs.getDouble("plot:latvert.xaxis.begin"));
                    this.setDouble("xaxis.end", prefs.getDouble("plot:latvert.xaxis.end"));
                    this.setString("xaxis.label.text", "Latitude (\u00b0N)");
                    this.setString("yaxis.method", prefs.getString("plot:latvert.yaxis.method"));
                    this.setString("yaxis.label.text", "VERTICAL AXIS");
                    this.setString("yaxis.tick.format", prefs.getString("plot:latvert.yaxis.tick.format"));
                    break;
                }
                case LON_TIME: {
                    this.setDouble("xaxis.begin", prefs.getDouble("plot:lontime.xaxis.begin"));
                    this.setDouble("xaxis.end", prefs.getDouble("plot:lontime.xaxis.end"));
                    this.setString("xaxis.label.text", "Longitude (\u00b0E)");
                    this.setString("yaxis.label.text", "TIME AXIS");
                    break;
                }
                case LON_VERT: {
                    this.setDouble("xaxis.begin", prefs.getDouble("plot:lonvert.xaxis.begin"));
                    this.setDouble("xaxis.end", prefs.getDouble("plot:lonvert.xaxis.end"));
                    this.setString("xaxis.label.text", "Longitude (\u00b0E)");
                    this.setString("yaxis.method", prefs.getString("plot:lonvert.yaxis.method"));
                    this.setString("yaxis.label.text", "VERTICAL AXIS");
                    this.setString("yaxis.tick.format", prefs.getString("plot:lonvert.yaxis.tick.format"));
                    break;
                }
                case TIME_LAT: {
                    this.setString("xaxis.tick.format", "yyyy-MM-dd");
                    this.setInt("xaxis.div.major", prefs.getInt("plot:timelat.xaxis.div.major"));
                    this.setInt("xaxis.div.minor", prefs.getInt("plot:timelat.xaxis.div.minor"));
                    this.setString("xaxis.label.text", "TIME AXIS");
                    this.setDouble("yaxis.end", prefs.getDouble("plot:timelat.yaxis.end"));
                    this.setDouble("yaxis.begin", prefs.getDouble("plot:timelat.yaxis.begin"));
                    this.setString("yaxis.label.text", "Latitude (\u00b0N)");
                    break;
                }
                case TIME_VERT: {
                    this.setString("xaxis.tick.format", "yyyy-MM-dd");
                    this.setInt("xaxis.div.major", prefs.getInt("plot:timevert.xaxis.div.major"));
                    this.setInt("xaxis.div.minor", prefs.getInt("plot:timevert.xaxis.div.minor"));
                    this.setString("xaxis.label.text", "TIME AXIS");
                    this.setString("yaxis.method", prefs.getString("plot:timevert.yaxis.method"));
                    this.setString("yaxis.label.text", "VERTICAL AXIS");
                    this.setString("yaxis.tick.format", prefs.getString("plot:timevert.yaxis.tick.format"));
                    break;
                }
                case GENERAL_CC: {
                    this.setInt("xaxis.div.major", prefs.getInt("plot:xy.xaxis.div.major"));
                    this.setInt("xaxis.div.minor", prefs.getInt("plot:xy.xaxis.div.minor"));
                    this.setString("xaxis.tick.format", prefs.getString("plot:xy.xaxis.tick.format"));
                    this.setInt("yaxis.div.major", prefs.getInt("plot:xy.yaxis.div.major"));
                    this.setInt("yaxis.div.minor", prefs.getInt("plot:xy.yaxis.div.minor"));
                    this.setString("yaxis.tick.format", prefs.getString("plot:xy.yaxis.tick.format"));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown plot type enum");
                }
            }
        }
    }

    private void initLinePlotParams(PanPreferences prefs) {
        this.setBoolean("scale.autofit", prefs.getBoolean("plot:scale.autofit"));
        this.setInt("grid.weight", prefs.getInt("plot:lineplot.grid.weight"));
        this.setString("grid.style", prefs.getString("plot:lineplot.grid.style"));
        this.setInt("border.weight", prefs.getInt("plot:border.weight"));
        this.setColor(PanParamKeys.STROKE_COLOR[0], prefs.getColor(PanParamKeys.P_LINE_STROKE_COLOR[0]));
        this.setColor(PanParamKeys.STROKE_COLOR[1], prefs.getColor(PanParamKeys.P_LINE_STROKE_COLOR[1]));
        this.setString(PanParamKeys.STROKE_STYLE[0], prefs.getString(PanParamKeys.P_LINE_STROKE_STYLE[0]));
        this.setString(PanParamKeys.STROKE_STYLE[1], prefs.getString(PanParamKeys.P_LINE_STROKE_STYLE[1]));
        this.setInt(PanParamKeys.STROKE_WGT[0], prefs.getInt(PanParamKeys.P_LINE_STROKE_WGT[0]));
        this.setInt(PanParamKeys.STROKE_WGT[1], prefs.getInt(PanParamKeys.P_LINE_STROKE_WGT[1]));
        this.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[0], false);
        this.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[1], false);
        this.setFloat("stroke.label.size", 11.0f);
        this.setString(PanParamKeys.STROKE_LABEL_TEXT[0], "STROKE 1 CAPTION");
        this.setString(PanParamKeys.STROKE_LABEL_TEXT[1], "STROKE 2 CAPTION");
    }

    private void initColorContourParams(PanPreferences prefs) {
        this.setBoolean("interpolate", prefs.getBoolean("plot:interpolate"));
        this.setColor("colorbar.invalids", prefs.getColor("plot:colorbar.invalids"));
        this.setBoolean("scale.autofit", prefs.getBoolean("plot:scale.autofit"));
        this.setColor("grid.color", prefs.getColor("plot:ccplot.grid.color"));
        this.setInt("grid.weight", prefs.getInt("plot:ccplot.grid.weight"));
        this.setString("grid.style", prefs.getString("plot:ccplot.grid.style"));
        this.setInt("border.weight", prefs.getInt("plot:border.weight"));
        this.set("colorbar.name", prefs.get("plot:colorbar.name"));
        this.setString("colorbar.location", prefs.getString("plot:colorbar.location"));
        this.setBoolean("colorbar.reverse", prefs.getBoolean("plot:colorbar.reverse"));
        this.set("colorbar.length", prefs.getInt("plot:colorbar.length"));
        this.setString("colorbar.tick.length", prefs.getString("plot:colorbar.tick.length"));
        this.set("colorbar.border.weight", prefs.getInt("plot:colorbar.border.weight"));
        this.setString("colorbar.outlier.shape", prefs.getString("plot:colorbar.outlier.shape"));
        this.setString("colorbar.outlier.side", prefs.getString("plot:colorbar.outlier.side"));
        this.setString("colorbar.outlier.gap", prefs.getString("plot:colorbar.outlier.gap"));
        this.setString("colorbar.label.location", prefs.getString("plot:colorbar.label.location"));
        this.setFloat("scale.label.size", prefs.getFloat("plot:scale.label.size"));
        this.setFloat("scale.tick.size", prefs.getFloat("plot:scale.tick.size"));
        this.setInt("contour.weight", prefs.getInt("plot:contour.weight"));
        this.setString("contour.style", prefs.getString("plot:contour.style"));
        this.setColor("contour.color", prefs.getColor("plot:contour.color"));
        this.setString("contour.location", prefs.getString("plot:contour.location"));
        this.setBoolean("contour.label.vis", prefs.getBoolean("plot:contour.label.vis"));
        this.setFloat("contour.label.size", prefs.getFloat("plot:contour.label.size"));
        this.setInt("vector.weight", prefs.getInt("plot:vector.weight"));
        this.setString("vector.style", prefs.getString("plot:vector.style"));
        this.setColor("vector.color", prefs.getColor("plot:vector.color"));
        this.setInt("vector.spacing", prefs.getInt("plot:vector.spacing"));
        this.setDouble("vector.refvalue", 1.0);
        this.setBoolean("vector.sample", prefs.getBoolean("plot:vector.sample"));
    }

    private void initVectorParams(PanPreferences prefs) {
        if (!this.ptype_.supportsVectorPlots()) {
            return;
        }
        switch (this.ptype_) {
            case LON_LAT: {
                this.setString("vector.dir1", prefs.getString("plot:lonlat.vector.dir1"));
                this.setString("vector.dir2", prefs.getString("plot:lonlat.vector.dir2"));
                break;
            }
            case LAT_VERT: {
                this.setString("vector.dir1", "North");
                this.setString("vector.dir2", "Up");
                break;
            }
            case LON_VERT: {
                this.setString("vector.dir1", "East");
                this.setString("vector.dir2", "Up");
                break;
            }
            case GENERAL_CC: {
                this.setString("vector.dir1", "Right");
                this.setString("vector.dir2", "Up");
                break;
            }
            default: {
                LOGGER.debug("Plot type {} does not have vectors", (Object)this.ptype_);
            }
        }
    }

    private void initMapParams(PanPreferences prefs) {
        int i;
        String pname = prefs.getString("plot:proj.name");
        this.projmeta_ = new PanProjectionMeta();
        this.projmeta_.setProjection(pname);
        this.setString("proj.name", pname);
        this.setDouble("proj.lon0", prefs.getDouble("plot:proj.lon0"));
        this.setDouble("proj.lat0", prefs.getDouble("plot:proj.lat0"));
        for (i = 0; i < 5; ++i) {
            Object s = this.projmeta_.getXParamValue(i);
            if (s == null) continue;
            String k = "proj.xparam." + (i + 1);
            try {
                this.set(k, s);
                continue;
            }
            catch (Exception exc) {
                LOGGER.debug("Unable to init map param {}, {}", (Object)i, (Object)exc.toString());
            }
        }
        this.setInt("border.weight", prefs.getInt("plot:border.weight"));
        this.setFloat("grid.spacing.lon", prefs.getFloat("plot:grid.spacing.lon"));
        this.setFloat("grid.spacing.lat", prefs.getFloat("plot:grid.spacing.lat"));
        this.setBoolean("grid.offset.lat", prefs.getBoolean("plot:grid.offset.lat"));
        this.setBoolean("grid.lon.pruned", prefs.getBoolean("plot:grid.lon.pruned"));
        this.setInt("grid.label.step", prefs.getInt("plot:grid.label.step"));
        this.setFloat("grid.label.size", prefs.getFloat("plot:grid.label.size"));
        for (i = 0; i < 3; ++i) {
            this.setString(PanParamKeys.OVERLAY_NAME[i], prefs.getString(PanParamKeys.P_OVERLAY_NAME[i]));
            this.setColor(PanParamKeys.OVERLAY_COLOR[i], prefs.getColor(PanParamKeys.P_OVERLAY_COLOR[i]));
            this.setBoolean(PanParamKeys.OVERLAY_INVERT[i], prefs.getBoolean(PanParamKeys.P_OVERLAY_INVERT[i]));
            this.set(PanParamKeys.OVERLAY_STYLE[i], prefs.get(PanParamKeys.P_OVERLAY_STYLE[i]));
            this.set(PanParamKeys.OVERLAY_SYMBOL_ID[i], prefs.get(PanParamKeys.P_OVERLAY_SYMBOL_ID[i]));
            this.setFloat(PanParamKeys.OVERLAY_SYMBOL_SIZE[i], prefs.getFloat(PanParamKeys.P_OVERLAY_SYMBOL_SIZE[i]));
            this.setInt(PanParamKeys.OVERLAY_WGT[i], prefs.getInt(PanParamKeys.P_OVERLAY_WGT[i]));
        }
        if (prefs.getBoolean("beta:numberlays")) {
            this.setBoolean("beta.numberlay.enabled", prefs.getBoolean("plot:beta.numberlay.enabled"));
            this.setBoolean("beta.numberlay.invalids", prefs.getBoolean("plot:beta.numberlay.invalids"));
            this.setColor("beta.numberlay.color", prefs.getColor("plot:beta.numberlay.color"));
            this.setInt("beta.numberlay.weight", prefs.getInt("plot:beta.numberlay.weight"));
            this.setFloat("beta.numberlay.size", prefs.getFloat("plot:beta.numberlay.size"));
            this.setDouble("beta.numberlay.lon.spacing", prefs.getDouble("plot:beta.numberlay.lon.spacing"));
            this.setDouble("beta.numberlay.lat.spacing", prefs.getDouble("plot:beta.numberlay.lat.spacing"));
            this.setBoolean("beta.numberlay.lon.offset", prefs.getBoolean("plot:beta.numberlay.lon.offset"));
            this.setBoolean("beta.numberlay.lat.offset", prefs.getBoolean("plot:beta.numberlay.lat.offset"));
        } else {
            this.setBoolean("beta.numberlay.enabled", false);
        }
        if (prefs.getBoolean("beta:underlays")) {
            this.setBoolean("beta.alpha.enabled", prefs.getBoolean("plot:beta.alpha.enabled"));
            this.setString("beta.alpha.method", prefs.getString("plot:beta.alpha.method"));
            this.setInt("beta.alpha.lavel.1", prefs.getInt("plot:beta.alpha.lavel.1"));
            this.setInt("beta.alpha.lavel.2", prefs.getInt("plot:beta.alpha.lavel.2"));
            this.setBoolean("beta.alpha.knockout", prefs.getBoolean("plot:beta.alpha.knockout"));
            this.setString("beta.alpha.underlay", prefs.getString("plot:beta.alpha.underlay"));
        } else {
            this.setBoolean("beta.alpha.knockout", false);
        }
        this.setBoolean("proj.shading.vis", prefs.getBoolean("plot:proj.shading.vis"));
        this.setInt("proj.shading.opacity", prefs.getInt("plot:proj.shading.opacity"));
        this.setDouble("proj.subsolar.lon", prefs.getDouble("plot:proj.subsolar.lon"));
        this.setDouble("proj.subsolar.lat", prefs.getDouble("plot:proj.subsolar.lat"));
    }

    private void initTrajectoryParams(PanPreferences prefs) {
        this.setColor("feature.background", prefs.getColor("plot:feature.background"));
        this.setBoolean("feature.nanskip", prefs.getBoolean("plot:feature.nanskip"));
        this.set(PanParamKeys.FEATURE_SYMBOL_ID[0], prefs.get(PanParamKeys.P_FEATURE_SYMBOL_ID[0]));
        this.set(PanParamKeys.FEATURE_SYMBOL_ID[1], prefs.get(PanParamKeys.P_FEATURE_SYMBOL_ID[1]));
        this.setFloat(PanParamKeys.FEATURE_SYMBOL_SIZE[0], prefs.getFloat(PanParamKeys.P_FEATURE_SYMBOL_SIZE[0]));
        this.setFloat(PanParamKeys.FEATURE_SYMBOL_SIZE[1], prefs.getFloat(PanParamKeys.P_FEATURE_SYMBOL_SIZE[1]));
        this.setBoolean(PanParamKeys.FEATURE_SYMBOL_FILL[0], prefs.getBoolean(PanParamKeys.P_FEATURE_SYMBOL_FILL[0]));
        this.setBoolean(PanParamKeys.FEATURE_SYMBOL_FILL[1], prefs.getBoolean(PanParamKeys.P_FEATURE_SYMBOL_FILL[1]));
        this.setColor(PanParamKeys.STROKE_COLOR[0], prefs.getColor(PanParamKeys.P_TRAJ_STROKE_COLOR[0]));
        this.setColor(PanParamKeys.STROKE_COLOR[1], prefs.getColor(PanParamKeys.P_TRAJ_STROKE_COLOR[1]));
        this.setString(PanParamKeys.STROKE_STYLE[0], prefs.getString(PanParamKeys.P_TRAJ_STROKE_STYLE[0]));
        this.setString(PanParamKeys.STROKE_STYLE[1], prefs.getString(PanParamKeys.P_TRAJ_STROKE_STYLE[1]));
        this.setInt(PanParamKeys.STROKE_WGT[0], prefs.getInt(PanParamKeys.P_TRAJ_STROKE_WGT[0]));
        this.setInt(PanParamKeys.STROKE_WGT[1], prefs.getInt(PanParamKeys.P_TRAJ_STROKE_WGT[1]));
        this.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[0], false);
        this.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[1], false);
        this.setFloat("stroke.label.size", 11.0f);
        this.setString(PanParamKeys.STROKE_LABEL_TEXT[0], "STROKE 1 CAPTION");
        this.setString(PanParamKeys.STROKE_LABEL_TEXT[1], "STROKE 2 CAPTION");
    }

    public PanPlotType getType() {
        return this.ptype_;
    }

    public PanData getData() {
        return this.data_;
    }

    public PanPlot getPlot() {
        return this.plot_;
    }

    public PanPlotLayoutMeta getLayout() {
        return this.layout_;
    }

    public PanPlotScaleMeta getScaleMeta() {
        return this.smeta_;
    }

    public PanProjectionMeta getProjectionMeta() {
        return this.projmeta_;
    }

    public PanPlotFrame getFrame() {
        return this.pframe_;
    }

    public void setFrame(PanPlotFrame pf) {
        this.pframe_ = pf;
    }

    public PanActionHash getActionHash() {
        return this.actionHash_;
    }

    public Action getAction(String key) {
        return (Action)this.actionHash_.get(key);
    }

    public void putAction(String key, Action action) {
        this.actionHash_.put(key, action);
    }

    public PanData createData(NcVariable ncvar) {
        LOGGER.trace("{}", (Object)ncvar);
        PanData data = this.createData(ncvar, new Object[0]);
        return data;
    }

    public PanData createData(NcVariable ncvar, Object ... axisInfo) {
        if (this.data_ != null) {
            throw new IllegalArgumentException("Data object already exists.");
        }
        LOGGER.trace("{}, {}", (Object)ncvar.getShortName(), (Object)axisInfo);
        NcArray ncarray = null;
        try {
            ncarray = PanPlotUtils.createArray(ncvar, this.ptype_, axisInfo);
            LOGGER.trace("ncarray {}", (Object)ncarray.getClass().getSimpleName());
        }
        catch (IllegalArgumentException exc) {
            LOGGER.trace("IllegalArgumentException reported when creating NcArray");
            throw exc;
        }
        catch (NcException exc) {
            LOGGER.trace("NcException reported when creating NcArray: {}", (Object)exc.getMessage());
            throw exc;
        }
        catch (Exception exc) {
            String msg = exc.toString().replaceFirst(".*: ", "");
            LOGGER.trace("{} reported when creating NcArray", (Object)exc.getClass().getSimpleName());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new RuntimeException(msg);
        }
        catch (Error err) {
            LOGGER.error("{} reported when creating NcArray", (Object)err.getClass().getSimpleName());
            if (LOGGER.isTraceEnabled()) {
                err.printStackTrace();
            }
            throw err;
        }
        if (ncarray == null) {
            LOGGER.trace("Got null NcArray");
            throw new RuntimeException("Array creation returned null object.");
        }
        LOGGER.trace("Got NcArray of type {}", (Object)ncarray.getClass().getSimpleName());
        Dimension dsize = (Dimension)this.layout_.get("size.gridding");
        try {
            switch (this.ptype_) {
                case LON_LAT: {
                    this.data_ = new PanDataLonLatGridded(this, ncarray, dsize);
                    break;
                }
                case LAT_TIME: {
                    this.data_ = new PanDataLatTime(this, ncarray, dsize);
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getYAxis(), "yaxis.tick.format");
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.begin"), this.getDouble("xaxis.end"));
                    break;
                }
                case LAT_VERT: {
                    this.data_ = new PanDataLatVert(this, ncarray, dsize);
                    ((PanDataLatVert)this.data_).setYAxisMethod(PanAxisMethod.matching(this.getString("yaxis.method")));
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.begin"), this.getDouble("xaxis.end"));
                    break;
                }
                case LON_TIME: {
                    this.data_ = new PanDataLonTime(this, ncarray, dsize);
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getYAxis(), "yaxis.tick.format");
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.begin"), this.getDouble("xaxis.end"));
                    break;
                }
                case LON_VERT: {
                    this.data_ = new PanDataLonVert(this, ncarray, dsize);
                    ((PanDataLonVert)this.data_).setYAxisMethod(PanAxisMethod.matching(this.getString("yaxis.method")));
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.begin"), this.getDouble("xaxis.end"));
                    break;
                }
                case TIME_LAT: {
                    this.data_ = new PanDataTimeLat(this, ncarray, dsize);
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getXAxis(), "xaxis.tick.format");
                    ((PanDataGeneral2D)this.data_).setGridBottomAndTop(this.getDouble("yaxis.begin"), this.getDouble("yaxis.end"));
                    break;
                }
                case TIME_VERT: {
                    this.data_ = new PanDataTimeVert(this, ncarray, dsize);
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getXAxis(), "xaxis.tick.format");
                    ((PanDataTimeVert)this.data_).setYAxisMethod(PanAxisMethod.matching(this.getString("yaxis.method")));
                    ((PanDataGeneral2D)this.data_).setGridBottomAndTop(this.getDouble("yaxis.begin"), this.getDouble("yaxis.end"));
                    break;
                }
                case GENERAL_CC: {
                    this.data_ = new PanDataGeneral2D(this, ncarray, dsize);
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getXAxis(), "xaxis.tick.format");
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getYAxis(), "yaxis.tick.format");
                    break;
                }
                case HORZ_LINE: 
                case VERT_LINE: {
                    NcAxis axis = ((NcArray1D)ncarray).getAxis();
                    boolean axisIsTime = axis instanceof NcTimeAxis;
                    LOGGER.trace("Axis is NcTimeAxis = {}.", (Object)axisIsTime);
                    if (axisIsTime && ((NcTimeAxis)axis).isUnixTime()) {
                        LOGGER.trace("Looks like a PanDataTime1D.");
                        this.data_ = new PanDataTime1D(this, ncarray);
                        this.setAxisFormatPatternIfTime(axis, "xaxis.tick.format");
                        break;
                    }
                    LOGGER.trace("Looks like a plain PanData1D.");
                    this.data_ = new PanData1D(this, ncarray);
                    break;
                }
                case LL_ZONAL: {
                    this.data_ = new PanDataLonLatZonal(this, ncarray, dsize);
                    break;
                }
                case LL_TRAJ: {
                    this.data_ = new PanDataLonLatTrajectory(this, ncarray);
                    break;
                }
                default: {
                    LOGGER.error("Default reached. Data obj not created");
                    break;
                }
            }
        }
        catch (Exception exc) {
            String msg;
            LOGGER.error("Exception creating data object: {}", (Object)exc.getClass().getSimpleName());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            if ((msg = exc.toString().replaceAll(".*: ", "")).contains("EOF")) {
                msg = "End of file exception.";
            }
            throw new RuntimeException(msg);
        }
        return this.data_;
    }

    private void setAxisFormatPatternIfTime(NcAxis axis, String axisFormatKey) {
        if (axis instanceof NcTimeAxis && ((NcTimeAxis)axis).isUnixTime()) {
            NcTimeAxis tax = (NcTimeAxis)axis;
            String s = ((UnixTimeFormatter)tax.getFormatter()).getPattern();
            this.setString(axisFormatKey, s);
        }
    }

    public PanPlot createPlot() {
        double[] range;
        PanAxisMethod method;
        if (this.data_ == null) {
            throw new RuntimeException("Data object not yet created.");
        }
        PanPreferences prefs = PanPreferences.getSharedInstance();
        this.smeta_ = new PanPlotScaleMeta(this, this.data_);
        this.setString("title.text", this.data_.getArray(0).getLongName());
        if (this.ptype_ == PanPlotType.GENERAL_CC || this.ptype_ == PanPlotType.TIME_LAT || this.ptype_ == PanPlotType.TIME_VERT) {
            method = PanAxisMethod.matching(this.getString("xaxis.method"));
            range = ((PanDataGeneral2D)this.data_).getDefaultLeftAndRight(method);
            String xunits = ((PanDataGeneral2D)this.data_).getDataXAxisUnits();
            this.setGridLeftAndRight(range[0], range[1]);
            this.setString("xaxis.units", xunits);
            ((PanDataGeneral2D)this.data_).setGridLeftAndRight(range[0], range[1]);
        }
        if (this.ptype_ == PanPlotType.GENERAL_CC || this.ptype_ == PanPlotType.LAT_VERT || this.ptype_ == PanPlotType.LON_VERT || this.ptype_ == PanPlotType.TIME_VERT || this.ptype_ == PanPlotType.LAT_TIME || this.ptype_ == PanPlotType.LON_TIME) {
            method = PanAxisMethod.matching(this.getString("yaxis.method"));
            range = ((PanDataGeneral2D)this.data_).getDefaultBottomAndTop(method);
            String yunits = ((PanDataGeneral2D)this.data_).getDataYAxisUnits();
            this.setGridBottomAndTop(range[0], range[1]);
            this.setString("yaxis.units", yunits);
        }
        if (this.ptype_.isLinePlot()) {
            switch (this.ptype_) {
                case VERT_LINE: {
                    PanAxisMethod ymethod = PanAxisMethod.matching(this.getString("yaxis.method"));
                    double[] yrange = ((PanData1D)this.data_).getDefaultAxisRange(ymethod);
                    ((PanData1D)this.data_).setAxisBounds(yrange[0], yrange[1]);
                    this.setDouble("yaxis.begin", yrange[0]);
                    this.setDouble("yaxis.end", yrange[1]);
                    break;
                }
                case HORZ_LINE: {
                    PanAxisMethod xmethod = PanAxisMethod.matching(this.getString("xaxis.method"));
                    double[] xrange = ((PanData1D)this.data_).getDefaultAxisRange(xmethod);
                    ((PanData1D)this.data_).setAxisBounds(xrange[0], xrange[1]);
                    this.setDouble("xaxis.begin", xrange[0]);
                    this.setDouble("xaxis.end", xrange[1]);
                    break;
                }
                case LL_ZONAL: {
                    this.setDouble("xaxis.begin", prefs.getDouble("plot:llzonal.xaxis.begin"));
                    this.setDouble("xaxis.end", prefs.getDouble("plot:llzonal.xaxis.end"));
                    this.setString("xaxis.label.text", "Latitude (\u00b0N)");
                    break;
                }
            }
        }
        double dmin = this.data_.getMinValue();
        double dmax = this.data_.getMaxValue();
        if (Double.isNaN(dmin)) {
            dmin = 0.0;
            dmax = 1.0E-25;
        }
        if (dmax == dmin) {
            dmax = dmin + 1.0E-25;
        }
        this.setDouble("scale.min", dmin);
        this.setDouble("scale.max", dmax);
        double dmag = 0.75 * MathUtils.max(1.0, Math.abs(dmin), Math.abs(dmax));
        if (this.ptype_ == PanPlotType.LON_LAT || this.ptype_ == PanPlotType.LAT_VERT || this.ptype_ == PanPlotType.LON_VERT || this.ptype_ == PanPlotType.GENERAL_CC) {
            this.setDouble("vector.refvalue", dmag);
        }
        this.plot_ = this.createPlotObject();
        Dimension psize = (Dimension)this.layout_.get("size.pixels");
        LOGGER.trace("psize {},{}", (Object)psize.width, (Object)psize.height);
        this.plot_.setSize(psize);
        return this.plot_;
    }

    private PanPlot createPlotObject() {
        switch (this.ptype_) {
            case LON_LAT: {
                return new PanLonLatPlot(this);
            }
            case LAT_TIME: {
                return new PanLatTimePlot(this);
            }
            case LAT_VERT: {
                return new PanLatVertPlot(this);
            }
            case LON_TIME: {
                return new PanLonTimePlot(this);
            }
            case LON_VERT: {
                return new PanLonVertPlot(this);
            }
            case TIME_LAT: {
                return new PanTimeLatPlot(this);
            }
            case TIME_VERT: {
                return new PanTimeYPlot(this);
            }
            case GENERAL_CC: {
                return new PanColorContourPlot(this);
            }
            case HORZ_LINE: {
                return new PanHorizontalLinePlot(this);
            }
            case VERT_LINE: {
                return new PanVerticalLinePlot(this);
            }
            case LL_ZONAL: {
                return new PanZonalAverageLinePlot(this);
            }
            case LL_TRAJ: {
                return new PanLonLatPlot(this);
            }
        }
        LOGGER.error("Unknown plot type enum {}", (Object)this.ptype_);
        throw new RuntimeException("Unknown plot type " + this.ptype_);
    }

    @Override
    public Object put(final String key, final Object value) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.pframe_ == null || this.replacing_) {
            return this.beginPut(key, value);
        }
        if (onEDT) {
            String s = key.replaceAll(".*\\.", "");
            Task task = new Task("Setting parameter " + s){

                @Override
                protected Object beginTask() {
                    return PanPlotMeta.this.beginPut(key, value);
                }

                @Override
                protected void finishTask() {
                    if (key.equals("scale.autofit")) {
                        LOGGER.trace("put 2 finishTask {}", (Object)key);
                    }
                    PanPlotMeta.this.refreshPlot();
                }
            };
            this.pframe_.addTask(task);
            return null;
        }
        Object o = this.beginPut(key, value);
        if (this.pframe_ == null) {
            this.refreshPlot();
        }
        return o;
    }

    protected Object beginPut(String key, Object value) {
        try {
            if (this.isProjectionNameKey(key) || this.isProjectionParamKey(key)) {
                this.handleProjectionParam(key, value);
            }
            return super.put(key, value);
        }
        catch (IllegalArgumentException exc) {
            throw exc;
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    protected synchronized void firePropertyChanged(String key) {
        super.firePropertyChanged(key);
    }

    @Override
    public Object setGroup(final Object[] ... keyValuePairs) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (onEDT && this.pframe_ != null) {
            Task task = new Task("Setting parameter group"){

                @Override
                protected Object beginTask() {
                    return PanPlotMeta.this.beginSetGroup(keyValuePairs);
                }

                @Override
                protected void finishTask() {
                    PanPlotMeta.this.finishSetGroup();
                }
            };
            this.pframe_.addTask(task);
            return null;
        }
        Object o = this.beginSetGroup(keyValuePairs);
        this.finishSetGroup();
        return o;
    }

    protected Object beginSetGroup(Object[] ... keyValuePairs) {
        int i;
        LOGGER.trace("");
        for (i = 0; i < keyValuePairs.length; ++i) {
            if (!this.isProjectionNameKey((String)keyValuePairs[i][0])) continue;
            this.handleProjectionName((String)keyValuePairs[i][1]);
        }
        for (i = 0; i < keyValuePairs.length; ++i) {
            if (!this.isProjectionParamKey((String)keyValuePairs[i][0])) continue;
            this.handleProjectionParam((String)keyValuePairs[i][0], keyValuePairs[i][1]);
        }
        return super.setGroup(keyValuePairs);
    }

    protected void finishSetGroup() {
        if (this.pframe_ == null) {
            return;
        }
        LOGGER.trace("");
        this.refreshPlot();
    }

    private boolean isProjectionNameKey(String key) {
        return key.equals("proj.name");
    }

    private boolean isProjectionParamKey(String key) {
        return key.equals("proj.lon0") || key.equals("proj.lat0") || key.contains("proj.xparam");
    }

    private void handleProjectionName(String name) {
        if (!(this.plot_ instanceof PanLonLatPlot)) {
            return;
        }
        this.projmeta_.setProjection(name);
        AbstractProjection proj = this.projmeta_.getProjection();
        int pcount = proj.getExtraParamCount();
        for (int i = 0; i < pcount; ++i) {
            String pkeyx = "proj.xparam." + (i + 1);
            Object value = this.projmeta_.getXParamValue(i);
            super.set(pkeyx, value);
        }
    }

    private boolean handleProjectionParam(String pkey, Object value) {
        if (this.isProjectionNameKey(pkey)) {
            this.handleProjectionName((String)value);
        } else if (pkey.equals("proj.lon0")) {
            LOGGER.trace("PROJ_CENTER_LON {}", value);
            if (value instanceof Double) {
                this.projmeta_.setCenterLon((Double)value);
            } else {
                this.projmeta_.setCenterLon(StringUtils.parseDouble(value.toString()));
            }
        } else if (pkey.equals("proj.lat0")) {
            if (value instanceof Double) {
                this.projmeta_.setCenterLat((Double)value);
            } else {
                this.projmeta_.setCenterLat(StringUtils.parseDouble(value.toString()));
            }
        } else if (pkey.contains("proj.xparam")) {
            int pid = Integer.valueOf(pkey.substring(pkey.length() - 1)) - 1;
            return this.projmeta_.setExtraParameter(pid, value);
        }
        return true;
    }

    @Override
    public void setBoolean(String pkey, boolean pvalue) {
        switch (pkey) {
            case "interpolate": {
                this.setDataInterpolated(pvalue, null);
                super.setBoolean(pkey, pvalue);
                break;
            }
            case "colorbar.location": 
            case "include.title": 
            case "include.axes": 
            case "include.colorbar": 
            case "include.strokeinfo": 
            case "include.footnotes": 
            case "include.margins": 
            case "axes.offset": {
                this.layout_.set(pkey, pvalue);
                super.setBoolean(pkey, pvalue);
                this.resizeFrameIfNecessary();
                break;
            }
            default: {
                super.setBoolean(pkey, pvalue);
            }
        }
    }

    @Override
    public void setColor(String pkey, Color pvalue) {
        if (pkey.equals("color.background")) {
            // empty if block
        }
        super.setColor(pkey, pvalue);
    }

    @Override
    public void setDouble(String pkey, double pvalue) {
        if (this.initializing_) {
            super.setDouble(pkey, pvalue);
            return;
        }
        switch (pkey) {
            case "scale.coefficient": {
                double scvalue = pvalue;
                if (Double.isNaN(scvalue) || scvalue == 0.0) {
                    scvalue = 1.0;
                } else if (Math.abs(scvalue) > 1000.0) {
                    scvalue = 1000.0 * Math.signum(pvalue);
                }
                super.setDouble(pkey, scvalue);
                this.setDataScalingCoefficient(scvalue, null);
                break;
            }
            case "xaxis.begin": {
                if (this.ptype_ == PanPlotType.VERT_LINE) {
                    LOGGER.trace("Trying to set X axis range on vert line plot");
                    return;
                }
                double rval = this.getDouble("xaxis.end");
                this.setGridLeftAndRight(pvalue, rval);
                break;
            }
            case "xaxis.end": {
                if (this.ptype_ == PanPlotType.VERT_LINE) {
                    LOGGER.trace("Trying to set X axis range on vert line plot");
                    return;
                }
                double lval = this.getDouble("xaxis.begin");
                this.setGridLeftAndRight(lval, pvalue);
                break;
            }
            case "yaxis.begin": {
                if (this.ptype_ == PanPlotType.HORZ_LINE) {
                    LOGGER.trace("Trying to set Y axis range on horizontal line plot");
                    return;
                }
                double tval = this.getDouble("yaxis.end");
                this.setGridBottomAndTop(pvalue, tval);
                break;
            }
            case "yaxis.end": {
                if (this.ptype_ == PanPlotType.HORZ_LINE) {
                    LOGGER.trace("Trying to set Y axis range on horizontal line plot");
                    return;
                }
                double bval = this.getDouble("yaxis.begin");
                this.setGridBottomAndTop(bval, pvalue);
                break;
            }
        }
        super.setDouble(pkey, pvalue);
    }

    @Override
    public void setFloat(String pkey, float pvalue) {
        if (pkey.equals("title.size") || pkey.equals("subtitle.size") || pkey.equals("footnote.size") || pkey.equals("xaxis.label.size") || pkey.equals("xaxis.tick.size") || pkey.equals("scale.label.size") || pkey.equals("scale.tick.size") || pkey.equals("stroke.label.size")) {
            this.layout_.set(pkey, Float.valueOf(pvalue));
            super.setFloat(pkey, pvalue);
            this.resizeFrameIfNecessary();
        } else {
            super.setFloat(pkey, pvalue);
        }
    }

    @Override
    public void setInt(String pkey, int pvalue) {
        switch (pkey) {
            case "size.factor": {
                int sfactor = PanPlotConstraints.constrainSizeFactor(pvalue);
                this.layout_.set(pkey, sfactor);
                super.setInt(pkey, sfactor);
                this.resizeFrameIfNecessary();
                break;
            }
            case "size.width": 
            case "size.height": {
                this.layout_.set(pkey, pvalue);
                super.setInt(pkey, pvalue);
                this.resizeFrameIfNecessary();
                break;
            }
            case "scale.exponent": {
                int sevalue = pvalue;
                if (Math.abs(sevalue) > 50) {
                    sevalue = 50 * Integer.signum(sevalue);
                }
                super.setInt(pkey, sevalue);
                this.setDataScalingExponent(sevalue, null);
                break;
            }
            default: {
                super.setInt(pkey, pvalue);
            }
        }
    }

    @Override
    public void setString(String pkey, String ppvalue) {
        String pvalue = StringUtils.unescapeUnicode(ppvalue);
        switch (pkey) {
            case "xaxis.method": {
                this.handleXAxisMethod(pvalue);
                break;
            }
            case "yaxis.method": {
                this.handleYAxisMethod(pvalue);
                break;
            }
            case "xaxis.units": {
                if (this.data_ != null) {
                    if (this.data_ instanceof PanDataGeneral2D) {
                        ((PanDataGeneral2D)this.data_).setXAxisUnits(pvalue);
                    } else {
                        ((PanData1D)this.data_).setAxisUnits(pvalue);
                    }
                }
                super.setString(pkey, pvalue);
                break;
            }
            case "yaxis.units": {
                if (this.data_ != null) {
                    if (this.data_ instanceof PanDataGeneral2D) {
                        ((PanDataGeneral2D)this.data_).setYAxisUnits(pvalue);
                    } else {
                        ((PanData1D)this.data_).setAxisUnits(pvalue);
                    }
                }
                super.setString(pkey, pvalue);
                break;
            }
            case "xaxis.tick.format": 
            case "yaxis.tick.format": {
                super.setString(pkey, pvalue);
                break;
            }
            case "combination": {
                this.setDataCombination(pvalue, null);
                break;
            }
            case "scale.units": {
                this.setScaleUnits(pvalue, null);
                break;
            }
            case "colorbar.name": {
                super.setString(pkey, pvalue);
                if (this.smeta_ == null) break;
                this.smeta_.getColorTable();
                break;
            }
            case "colorbar.location": 
            case "colorbar.label.location": 
            case "colorbar.outlier.gap": {
                LOGGER.trace("{} {}", (Object)pkey, (Object)pvalue);
                this.layout_.set(pkey, pvalue);
                super.setString(pkey, pvalue);
                this.resizeFrameIfNecessary();
                break;
            }
            default: {
                super.setString(pkey, pvalue);
            }
        }
    }

    public void applySavedSettings(PanSavedSettings pss) {
        LOGGER.trace("{}", (Object)pss.getName());
        if (pss.getPlotType() != this.ptype_) {
            LOGGER.trace("type mismatch {}, {}", (Object)pss.getPlotType(), (Object)this.ptype_);
            throw new IllegalArgumentException("Settings are wrong plot type.");
        }
        this.replacing_ = true;
        final PanSavedSettings pssx = pss.getCopy();
        final PanPlot newPlot = this.createPlotObject();
        Task task = new Task("Applying saved settings"){

            @Override
            protected Object beginTask() {
                LOGGER.trace("Begin applying saved settings");
                if (pssx.containsKey("ptype")) {
                    pssx.remove("ptype");
                }
                if (pssx.containsKey("combination")) {
                    pssx.remove("combination");
                }
                if (pssx.containsKey("proj.name")) {
                    PanPlotMeta.this.applySavedSetting(pssx, "proj.name");
                }
                if (pssx.containsKey("scale.method")) {
                    PanPlotMeta.this.applySavedSetting(pssx, "scale.method");
                }
                if (pssx.containsKey("scale.units")) {
                    PanPlotMeta.this.applySavedSetting(pssx, "scale.units");
                }
                if (pssx.containsKey("colorbar.location")) {
                    PanPlotMeta.this.applySavedSetting(pssx, "colorbar.location");
                }
                if (pssx.containsKey("xaxis.method")) {
                    PanPlotMeta.this.applySavedSetting(pssx, "xaxis.method");
                }
                if (pssx.containsKey("yaxis.method")) {
                    PanPlotMeta.this.applySavedSetting(pssx, "yaxis.method");
                }
                if (pssx.containsKey("colorbar.location")) {
                    PanPlotMeta.this.applySavedSetting(pssx, "colorbar.location");
                }
                if (pssx.containsKey("scale.units")) {
                    String oldstr = PanPlotMeta.this.getString("scale.units");
                    Object newValue = pssx.get("scale.units");
                    String newstr = newValue == null ? null : newValue.toString();
                    boolean compat = NcUnitUtils.isCompatible(oldstr, newstr);
                    LOGGER.trace("New units string is comptable, {}", (Object)compat);
                    if (compat) {
                        PanPlotMeta.this.applySavedSetting(pssx, "scale.units");
                    } else {
                        pssx.remove("scale.units");
                    }
                }
                List<String> keys = pssx.keySet();
                for (String pkey : keys) {
                    PanPlotMeta.this.applySavedSetting(pssx, pkey);
                }
                return null;
            }

            @Override
            protected void finishTask() {
                LOGGER.trace("Finish applying saved settings");
                PanPlotMeta.this.plot_ = newPlot;
                PanPlotMeta.this.layout_.setInitialized();
                PanPlotMeta.this.pframe_.replacePlot(newPlot);
                PanPlotMeta.this.refreshControls();
                PanPlotMeta.this.replacing_ = false;
            }
        };
        this.pframe_.addTask(task);
    }

    private void applySavedSetting(PanSavedSettings pssx, String pkey) {
        boolean keyIsKnown = this.containsKey(pkey);
        if (!keyIsKnown) {
            LOGGER.debug("Plot does not use settings key {}", (Object)pkey);
            return;
        }
        Object oldValue = this.get(pkey);
        Object newValue = pssx.get(pkey);
        String strvalue = newValue.toString();
        if (pkey.equals("scale.units") && "XXX".equalsIgnoreCase(strvalue)) {
            LOGGER.trace("Saved settings contained XXX for units. Ignoring it.");
            return;
        }
        if (PanStringUtils.isNoneString(strvalue)) {
            this.set(pkey, null);
        } else if (oldValue instanceof String) {
            if ("null".equalsIgnoreCase(strvalue)) {
                this.setString(pkey, "");
            } else {
                this.setString(pkey, strvalue);
            }
        } else if (oldValue instanceof Double) {
            this.setDouble(pkey, strvalue);
        } else if (oldValue instanceof Float) {
            this.setFloat(pkey, strvalue);
        } else if (oldValue instanceof Integer) {
            this.setInt(pkey, strvalue);
        } else if (oldValue instanceof Boolean) {
            this.setBoolean(pkey, strvalue);
        } else if (oldValue instanceof Color) {
            try {
                this.setColor(pkey, strvalue);
            }
            catch (Exception exc) {
                LOGGER.warn("Could not parse color {} for key {}", (Object)strvalue, (Object)pkey);
            }
        } else if (!pkey.startsWith("overlay.") || !pkey.endsWith(".name")) {
            if (oldValue == null) {
                LOGGER.debug("Could not set {}. Old value is null", (Object)pkey, (Object)null);
            } else {
                if (pkey.equals("colorbar.outlier.gap")) {
                    LOGGER.trace("String CBAR_OUTLIER_GAP new {}, old {}", newValue, oldValue);
                }
                LOGGER.trace("Could not set {}. Class should be {}", (Object)pkey, (Object)oldValue.getClass());
            }
        }
        pssx.remove(pkey);
    }

    private void handleXAxisMethod(String newName) {
        double newVal2;
        double newVal1;
        double[] range;
        String oldName = this.getString("xaxis.method");
        PanAxisMethod newMethod = PanAxisMethod.matching(newName);
        String xnewName = newMethod.name();
        if (this.data_ == null) {
            super.set("xaxis.method", xnewName);
            return;
        }
        switch (this.ptype_) {
            case LON_LAT: 
            case LL_TRAJ: {
                return;
            }
            case LL_ZONAL: {
                LOGGER.info("Cannot reset X axis method for a zonal average line plot.");
                return;
            }
            case HORZ_LINE: {
                PanData1D data1d = (PanData1D)this.data_;
                range = data1d.getDefaultAxisRange(newMethod);
                break;
            }
            case VERT_LINE: {
                throw new RuntimeException("X axis for vertical line plot is the scale");
            }
            default: {
                if (this.data_ instanceof PanDataGeneral2D) {
                    PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
                    range = data2d.getDefaultLeftAndRight(newMethod);
                    break;
                }
                LOGGER.warn("Mystery case {}", (Object)this.ptype_);
                throw new RuntimeException("Mystery case");
            }
        }
        double oldVal1 = this.getDouble("xaxis.begin");
        double oldVal2 = this.getDouble("xaxis.end");
        if (Double.isNaN(oldVal1)) {
            oldVal1 = range[0];
        }
        if (Double.isNaN(oldVal2)) {
            oldVal2 = range[1];
        }
        PanAxisMethod oldMethod = PanAxisMethod.matching(oldName);
        if (newMethod == PanAxisMethod.INDEX || oldMethod == null || oldMethod == PanAxisMethod.INDEX) {
            newVal1 = range[0];
            newVal2 = range[1];
        } else if (newMethod == PanAxisMethod.LOG10) {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
            if (newVal1 <= 0.0) {
                newVal1 = 1.0E-50;
            }
            if (newVal2 <= 0.0) {
                newVal2 = 1.0E-50;
            }
            if (newVal2 == newVal1) {
                newVal2 += 1.0E-25;
            }
        } else {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
        }
        this.setGroup({"xaxis.method", xnewName}, {"xaxis.begin", newVal1}, {"xaxis.end", newVal2});
        if (this.data_ instanceof PanDataGeneral2D) {
            PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
            data2d.setXAxisMethod(newMethod);
            data2d.setGridLeftAndRight(newVal1, newVal2);
        } else if (this.ptype_ == PanPlotType.HORZ_LINE) {
            PanData1D data1d = (PanData1D)this.data_;
            data1d.setAxisMethod(newMethod);
            data1d.setAxisBounds(newVal1, newVal2);
        }
    }

    private void handleYAxisMethod(String newName) {
        double newVal2;
        double newVal1;
        double[] range;
        PanAxisMethod newMethod = PanAxisMethod.matching(newName);
        String ynewName = newMethod.name();
        if (this.data_ == null) {
            super.set("yaxis.method", ynewName);
            return;
        }
        switch (this.ptype_) {
            case LON_LAT: 
            case LL_TRAJ: {
                LOGGER.debug("Lon-lat map plot. No reason to set Y axis method.");
                return;
            }
            case LL_ZONAL: {
                throw new RuntimeException("Y axis for zonal average line plot is the scale");
            }
            case HORZ_LINE: {
                throw new RuntimeException("Y axis for horizontal line plot is the scale");
            }
            case VERT_LINE: {
                PanData1D data1d = (PanData1D)this.data_;
                range = data1d.getDefaultAxisRange(newMethod);
                break;
            }
            default: {
                if (this.data_ instanceof PanDataGeneral2D) {
                    PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
                    range = data2d.getDefaultBottomAndTop(newMethod);
                    break;
                }
                LOGGER.warn("Mystery case {}", (Object)this.ptype_);
                throw new RuntimeException("Mystery case");
            }
        }
        double oldVal1 = this.getDouble("yaxis.begin");
        double oldVal2 = this.getDouble("yaxis.end");
        if (Double.isNaN(oldVal1)) {
            oldVal1 = range[0];
        }
        if (Double.isNaN(oldVal2)) {
            oldVal2 = range[1];
        }
        String oldName = this.getString("yaxis.method");
        PanAxisMethod oldMethod = PanAxisMethod.matching(oldName);
        if (newMethod == PanAxisMethod.INDEX || oldMethod == null || oldMethod == PanAxisMethod.INDEX) {
            newVal1 = range[0];
            newVal2 = range[1];
        } else if (newMethod == PanAxisMethod.LOG10) {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
            if (newVal2 <= 0.0) {
                newVal2 = 1.0E-50;
            }
            if (newVal1 <= 0.0) {
                newVal1 = 1.0E-50;
            }
            if (newVal2 == newVal1) {
                newVal2 += 1.0E-25;
            }
        } else {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
        }
        this.setGroup({"yaxis.method", ynewName}, {"yaxis.begin", newVal1}, {"yaxis.end", newVal2});
        if (this.data_ instanceof PanDataGeneral2D) {
            PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
            data2d.setYAxisMethod(newMethod);
            data2d.setGridBottomAndTop(newVal1, newVal2);
        } else if (this.ptype_ == PanPlotType.VERT_LINE) {
            PanData1D data1d = (PanData1D)this.data_;
            data1d.setAxisMethod(newMethod);
            data1d.setAxisBounds(newVal1, newVal2);
        }
    }

    public void setGridLeftAndRight(double left, double right) {
        if (this.data_ == null) {
            return;
        }
        this.setGroup({"xaxis.begin", left}, {"xaxis.end", right});
        switch (this.ptype_) {
            case HORZ_LINE: {
                ((PanData1D)this.data_).setAxisBounds(left, right);
                break;
            }
            case VERT_LINE: {
                LOGGER.trace("How did we get here? Should have gone to setting scale min/max.");
                break;
            }
            case LL_ZONAL: {
                ((PanDataLonLatZonal)this.data_).setAxisBounds(left, right);
                break;
            }
            default: {
                if (this.data_ instanceof PanDataGeneral2D) {
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(left, right);
                    break;
                }
                LOGGER.trace("called for plot type {}", (Object)this.ptype_);
            }
        }
    }

    public void setGridBottomAndTop(double bottom, double top) {
        this.setGroup({"yaxis.begin", bottom}, {"yaxis.end", top});
        if (this.data_ == null) {
            return;
        }
        switch (this.ptype_) {
            case VERT_LINE: {
                ((PanData1D)this.data_).setAxisBounds(bottom, top);
                break;
            }
            case HORZ_LINE: 
            case LL_ZONAL: {
                LOGGER.trace("How did we get here? Should have gone to setting scale min/max.");
                break;
            }
            default: {
                if (this.data_ instanceof PanDataGeneral2D) {
                    ((PanDataGeneral2D)this.data_).setGridBottomAndTop(bottom, top);
                    break;
                }
                LOGGER.trace("called for plot type {}", (Object)this.ptype_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNcArray(final int idx, final NcArray nca, TaskListener tl) {
        PanPlotMeta panPlotMeta = this;
        synchronized (panPlotMeta) {
            if (this.data_ == null) {
                return;
            }
            if (this.pframe_ == null) {
                this.beginSetNcArray(idx, nca);
                this.finishSetNcArray(idx);
            } else {
                Task task = new Task("Adding variable"){

                    @Override
                    protected Object beginTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var now null; canceling setNcArray task.");
                            this.cancel(true);
                            return null;
                        }
                        PanPlotMeta.this.beginSetNcArray(idx, nca);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var now null; canceling setNcArray completion.");
                            return;
                        }
                        PanPlotMeta.this.finishSetNcArray(idx);
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
    }

    private void beginSetNcArray(int idx, NcArray nca) {
        this.data_.setArray(idx, nca);
    }

    private void finishSetNcArray(int idx) {
        if (this.pframe_ == null) {
            return;
        }
        this.pframe_.updateArrayDataPanel(idx);
        this.refreshPlot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSlice(final int arrayNum, final int dimNum, final int index, TaskListener tl) {
        if (this.replacing_) {
            LOGGER.trace("called while applying saved settings");
            LOGGER.trace("how did that heppen?");
            return;
        }
        PanPlotMeta panPlotMeta = this;
        synchronized (panPlotMeta) {
            if (this.data_ == null) {
                return;
            }
            if (this.pframe_ == null) {
                this.beginSetDataSlice(arrayNum, dimNum, index);
                this.finishSetDataSlice();
            } else {
                Task task = new Task("Changing array slice"){

                    @Override
                    protected Object beginTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataSlice task.");
                            this.cancel(true);
                            return null;
                        }
                        PanPlotMeta.this.beginSetDataSlice(arrayNum, dimNum, index);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataSlice completion.");
                            return;
                        }
                        PanPlotMeta.this.finishSetDataSlice();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
    }

    private void beginSetDataSlice(int arrayNum, int dimNum, int index) {
        this.data_.setSlice(arrayNum, dimNum, index);
    }

    private void finishSetDataSlice() {
        this.data_.fireDataEvent(PanDataEvent.EType.SLICE_CHANGED);
        this.refreshPlot();
    }

    public synchronized void setDataCombination(String value, TaskListener tl) {
        if (this.replacing_) {
            LOGGER.trace("called while applying saved settings");
        }
        final PanCombinationType ctype = PanCombinationType.matching(value);
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ == null) {
            LOGGER.trace("data object is still null");
        } else if (this.pframe_ == null || this.replacing_) {
            this.beginSetDataCombination(ctype);
            this.finishSetDataCombination();
        } else {
            if (onEDT) {
                // empty if block
            }
            Task task = new Task("Changing array combination type"){

                @Override
                protected Object beginTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataCombination task.");
                        this.cancel(true);
                        return null;
                    }
                    PanPlotMeta.this.beginSetDataCombination(ctype);
                    return null;
                }

                @Override
                protected void finishTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataCombination completion.");
                        return;
                    }
                    PanPlotMeta.this.finishSetDataCombination();
                }
            };
            if (tl != null) {
                task.addTaskListener(tl);
            }
            this.pframe_.addTask(task);
        }
        super.set("combination", value);
    }

    private void beginSetDataCombination(PanCombinationType ctype) {
        LOGGER.trace("");
        this.data_.setCombinationType(ctype);
    }

    private void finishSetDataCombination() {
        LOGGER.trace("");
        this.data_.fireDataEvent(PanDataEvent.EType.COMBINATION_CHANGED);
        PanCombinationType ctype = this.data_.getCombinationType();
        if (ctype == PanCombinationType.VECTOR) {
            LOGGER.trace("validateComboVectorComponents");
            this.validateComboVectorComponents();
        }
        this.refreshPlot();
    }

    private void validateComboVectorComponents() {
        if (!(this.data_ instanceof PanDataLonLatGridded)) {
            return;
        }
        PanDataLonLatGridded lldata = (PanDataLonLatGridded)this.data_;
        lldata.getUnitsChoices();
        PanVectorType vtype = lldata.getVectorType();
        String dir1 = this.getString("vector.dir1");
        String dir2 = this.getString("vector.dir2");
        if (vtype == PanVectorType.XY) {
            if ("magnitude".equalsIgnoreCase(dir1) || "magnitude".equalsIgnoreCase(dir2)) {
                this.setGroup({"vector.dir1", this.getString("plot:lonlat.vector.dir1")}, {"vector.dir2", this.getString("plot:lonlat.vector.dir2")});
            }
        } else if (!"magnitude".equalsIgnoreCase(dir1) && !"magnitude".equalsIgnoreCase(dir2)) {
            String vdir;
            String string = vdir = lldata.isVectorAngleUpstream() ? "Upstream" : "Downstream";
            if (vtype == PanVectorType.MAG_ANGLE) {
                this.setGroup({"vector.dir1", "Magnitude"}, {"vector.dir2", vdir});
            } else {
                this.setGroup({"vector.dir1", vdir}, {"vector.dir2", "Magnitude"});
            }
        }
    }

    private synchronized void setDataInterpolated(final boolean interpolated, TaskListener tl) {
        if (this.replacing_) {
            LOGGER.trace("called while applying saved settings");
        }
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ == null) {
            LOGGER.trace("data object is still null");
        } else if (this.pframe_ == null || this.replacing_) {
            this.beginSetDataInterpolated(interpolated);
            this.finishSetDataInterpolated();
        } else {
            if (onEDT) {
                // empty if block
            }
            Task task = new Task("Toggling interpolation"){

                @Override
                protected Object beginTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataInterpolated task.");
                        this.cancel(true);
                        return null;
                    }
                    PanPlotMeta.this.beginSetDataInterpolated(interpolated);
                    return null;
                }

                @Override
                protected void finishTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataInterpolated completion.");
                        return;
                    }
                    PanPlotMeta.this.finishSetDataInterpolated();
                }
            };
            if (tl != null) {
                task.addTaskListener(tl);
            }
            this.pframe_.addTask(task);
        }
        super.setBoolean("interpolate", interpolated);
    }

    private void beginSetDataInterpolated(boolean interpolated) {
        this.data_.setInterpolated(interpolated);
    }

    private void finishSetDataInterpolated() {
        this.data_.fireDataEvent(PanDataEvent.EType.INTERPOLATION_CHANGED);
        this.refreshPlot();
    }

    private synchronized void setScaleUnits(final String units, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ == null) {
            LOGGER.trace("data object is still null");
        } else if (this.pframe_ == null) {
            this.beginSetDataUnits(units);
            this.finishSetDataUnits();
        } else {
            if (onEDT) {
                // empty if block
            }
            Task task = new Task("Setting units"){

                @Override
                protected Object beginTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataUnits task.");
                        this.cancel(true);
                        return null;
                    }
                    PanPlotMeta.this.beginSetDataUnits(units);
                    return null;
                }

                @Override
                protected void finishTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataUnits completion.");
                        return;
                    }
                    PanPlotMeta.this.finishSetDataUnits();
                }
            };
            if (tl != null) {
                task.addTaskListener(tl);
            }
            this.pframe_.addTask(task);
        }
        super.setString("scale.units", units);
    }

    private void beginSetDataUnits(String unitsStr) {
        this.data_.setUnits(unitsStr);
    }

    private void finishSetDataUnits() {
        this.data_.fireDataEvent(PanDataEvent.EType.UNITS_CHANGED);
        this.refreshPlot();
    }

    private synchronized void setDataScalingCoefficient(final double coeff, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ == null) {
            LOGGER.trace("data object is still null");
        } else if (this.pframe_ == null || this.replacing_) {
            this.beginSetDataScalingCoefficient(coeff);
            this.finishSetDataScalingCoefficient();
        } else {
            if (onEDT) {
                // empty if block
            }
            Task task = new Task("Setting scaling"){

                @Override
                protected Object beginTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataScalingCoefficient task.");
                        this.cancel(true);
                        return null;
                    }
                    PanPlotMeta.this.beginSetDataScalingCoefficient(coeff);
                    return null;
                }

                @Override
                protected void finishTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataScalingCoefficient completion.");
                        return;
                    }
                    PanPlotMeta.this.finishSetDataScalingCoefficient();
                }
            };
            if (tl != null) {
                task.addTaskListener(tl);
            }
            this.pframe_.addTask(task);
        }
        super.setDouble("scale.coefficient", coeff);
    }

    private void beginSetDataScalingCoefficient(double coeff) {
        LOGGER.trace("{}", (Object)coeff);
        this.data_.setScalingCoefficient(coeff);
    }

    private void finishSetDataScalingCoefficient() {
        this.data_.fireDataEvent(PanDataEvent.EType.SCALING_CHANGED);
        this.refreshPlot();
    }

    private synchronized void setDataScalingExponent(final int tenPower, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ == null) {
            LOGGER.trace("data object is still null");
        } else if (this.pframe_ == null || this.replacing_) {
            this.beginSetDataScalingExponent(tenPower);
            this.finishSetDataScalingExponent();
        } else {
            if (onEDT) {
                // empty if block
            }
            Task task = new Task("Setting scaling"){

                @Override
                protected Object beginTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataScalingExponent task.");
                        this.cancel(true);
                        return null;
                    }
                    PanPlotMeta.this.beginSetDataScalingExponent(tenPower);
                    return null;
                }

                @Override
                protected void finishTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataScalingExponent completion.");
                        return;
                    }
                    PanPlotMeta.this.finishSetDataScalingExponent();
                }
            };
            if (tl != null) {
                task.addTaskListener(tl);
            }
            this.pframe_.addTask(task);
        }
        super.setInt("scale.exponent", tenPower);
    }

    private void beginSetDataScalingExponent(int tenPower) {
        this.data_.setScalingExponent(tenPower);
    }

    private void finishSetDataScalingExponent() {
        this.data_.fireDataEvent(PanDataEvent.EType.SCALING_CHANGED);
        this.refreshPlot();
    }

    private void refreshControls() {
        LOGGER.trace("");
        if (this.pframe_ == null) {
            return;
        }
        EventQueue.invokeLater(() -> LOGGER.trace("refreshControls does nothing"));
    }

    private void refreshPlot() {
        if (this.pframe_ == null) {
            return;
        }
        if (this.replacing_) {
            return;
        }
        PanPlotHolder ph = this.pframe_.getPlotHolder();
        if (ph == null) {
            return;
        }
        EventQueue.invokeLater(() -> ph.repaint());
    }

    private void resizeFrameIfNecessary() {
        if (this.pframe_ == null) {
            return;
        }
        if (this.replacing_) {
            return;
        }
        EventQueue.invokeLater(() -> this.pframe_.resizeToFitDisplay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanActionHash panActionHash = this.actionHash_;
        synchronized (panActionHash) {
            this.actionHash_.clear();
        }
        this.removePlotPropertyListeners();
    }
}

