/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.data.PanDataXTime;
import gov.nasa.giss.panoply.plot.PanColorContourPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanXTimePlot
extends PanColorContourPlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PanXTimePlot(PanPlotMeta pmeta) {
        super(pmeta);
        if (this.yAxisFormatter_.isFormattedTime()) {
            String pattern = this.yAxisFormatter_.getPattern();
            LOGGER.trace("Time axis pattern {}", (Object)pattern);
            if (pattern != null) {
                if (pattern.endsWith("Z")) {
                    pattern = pattern.replace(" Z", "");
                    pattern = pattern.replace("Z", "");
                    this.yAxisFormatter_.setPattern(pattern);
                }
                this.pmeta_.setString("yaxis.tick.format", pattern);
            }
        }
        this.parameterChangedPrivate("all");
    }

    @Override
    protected String getYAxisLabelStr() {
        if (this.yAxisLabelText_ != null) {
            return this.yAxisLabelText_;
        }
        if (this.yAxisFormatter_.isFormattedTime()) {
            if (this.yAxisFormatter_.getPattern().charAt(0) == '%') {
                return "Time (" + this.yAxisFormatter_.getUnitsStr() + ")";
            }
            return "Time";
        }
        NcAxis yaxis = ((PanData2D)this.data_).getYAxis();
        String unitsStr = yaxis.getUnitsStr();
        if (unitsStr == null || unitsStr.isEmpty()) {
            return "Time";
        }
        return "Time (" + unitsStr + ')';
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("yaxis.tick.format")) {
            String pattern = this.pmeta_.getString("yaxis.tick.format");
            this.yAxisFormatter_.setPattern(pattern);
            if (pattern != null && !pattern.isEmpty()) {
                ((PanDataXTime)this.data_).setTimeFormat(pattern);
            }
        }
    }
}

