/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanArraySlicer;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.lang.invoke.MethodHandles;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanArraySlicePanel
extends PanControlsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final NcArray nca_;
    private PanArraySlicer[] slicers_;

    public PanArraySlicePanel(PanPlotMeta pmeta, PanMenuBar mbar, NcArray ncarray, int vnum) {
        super("array-slicer " + vnum, pmeta, mbar);
        this.nca_ = ncarray;
        String btitle = ncarray == null ? "Array " + (vnum + 1) : "Array " + (vnum + 1) + ": " + ncarray.getShortName();
        this.setName(btitle);
        this.setBorder(PanGuiUtils.WINDOID_SECT_BORDER);
        this.setLayout(new BoxLayout(this, 1));
        if (ncarray == null) {
            JLabel sliceLabel = new JLabel("None selected");
            GuiUtils.setSizeSmall(sliceLabel);
            sliceLabel.setAlignmentX(0.0f);
            this.add(sliceLabel);
        } else if (!ncarray.hasFreeDimensions()) {
            JLabel sliceLabel = new JLabel("No additional dimensions.");
            GuiUtils.setSizeSmall(sliceLabel);
            this.add(QuickBox.createLeftBox(sliceLabel));
        } else {
            NcDimension[] freeDims = ncarray.getFreeDimensions();
            this.slicers_ = new PanArraySlicer[freeDims.length];
            for (int i = 0; i < freeDims.length; ++i) {
                PanArraySlicer slicer;
                if (freeDims[i] == null) {
                    this.slicers_[i] = null;
                    continue;
                }
                int ii = i;
                this.slicers_[i] = slicer = new PanArraySlicer(freeDims[i], ncarray.isAveragingDimension(i));
                this.add(QuickBox.createLeftBox(slicer));
                slicer.addActionListener(e -> {
                    int index = slicer.getSelectedIndex();
                    PanPlotFrame pf = this.getPlotFrame();
                    pf.getMeta().setDataSlice(vnum, ii, index, null);
                });
            }
        }
    }

    public NcArray getVariableArray() {
        return this.nca_;
    }

    public int getItemCount() {
        if (this.slicers_ == null) {
            return 0;
        }
        return this.slicers_.length;
    }

    public PanArraySlicer getSlicer(int idx) {
        if (this.slicers_ == null) {
            return null;
        }
        if (idx < 0 || idx >= this.slicers_.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.slicers_[idx];
    }

    @Override
    public void flush() {
        for (Component child : this.getComponents()) {
            ActionListener[] listeners;
            if (!(child instanceof PanArraySlicer)) continue;
            PanArraySlicer slicer = (PanArraySlicer)child;
            for (ActionListener al : listeners = slicer.getActionListeners()) {
                slicer.removeActionListener(al);
            }
        }
        super.flush();
    }

    @Override
    public void setSize(Dimension d) {
        LOGGER.trace("{}", (Object)d);
        super.setSize(d);
    }
}

