/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatNumberlayControls
extends PanControlsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_7G = new PrintfFormat("%.7g");
    private PanCheckBox showNumbersCB_;
    private PanCheckBox hideInvalidsCB_;
    private FloatComboBox labelSizeCombo_;
    private ColorComboBox labelColorCombo_;
    private GTextField lonSpacingTF_;
    private GTextField latSpacingTF_;
    private PanCheckBox lonOffsetCB_;
    private PanCheckBox latOffsetCB_;

    public PanLonLatNumberlayControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("numberlay-controls", pmeta, mbar);
        this.createLayout();
        this.attachListeners();
    }

    private void createLayout() {
        this.showNumbersCB_ = PanCheckBox.small("beta.numberlay.enabled", "Show overlay of data values", this.pmeta_.getBoolean("beta.numberlay.enabled"));
        QuickBox enabledBox = QuickBox.createLeftBox(this.showNumbersCB_);
        this.hideInvalidsCB_ = PanCheckBox.small("beta.numberlay.invalids", "Omit invalid values", !this.pmeta_.getBoolean("beta.numberlay.invalids"));
        QuickBox invalidsBox = QuickBox.createLeftBox(this.hideInvalidsCB_);
        JLabel s1Label = new JLabel("Spacing:\u2009");
        JLabel s2Label = new JLabel("Lon:\u2009");
        JLabel s3Label = new JLabel("\u00d7 Lat:\u2009");
        this.lonSpacingTF_ = GTextField.createDoubleField(this.pmeta_.getDouble("beta.numberlay.lon.spacing"), 6);
        this.latSpacingTF_ = GTextField.createDoubleField(this.pmeta_.getDouble("beta.numberlay.lat.spacing"), 6);
        this.lonSpacingTF_.setName("beta.numberlay.lon.spacing");
        this.latSpacingTF_.setName("beta.numberlay.lat.spacing");
        QuickBox spacingBox = QuickBox.createLeftBox(s1Label, s2Label, this.lonSpacingTF_, s3Label, this.latSpacingTF_);
        this.lonOffsetCB_ = PanCheckBox.small("beta.numberlay.lon.offset", "Numbers on lon axis are offset from prime meridian", this.pmeta_.getBoolean("beta.numberlay.lon.offset"));
        QuickBox lonBox = QuickBox.createLeftBox(this.lonOffsetCB_);
        this.latOffsetCB_ = PanCheckBox.small("beta.numberlay.lat.offset", "Numbers on lat axis are offset from Equator", this.pmeta_.getBoolean("beta.numberlay.lat.offset"));
        QuickBox latBox = QuickBox.createLeftBox(this.latOffsetCB_);
        JLabel labelsLabel = new JLabel("Labels:\u2009");
        JLabel sizeLabel = new JLabel("Size:\u2009");
        JLabel colorLabel = new JLabel("\u2014 Color:\u2009");
        this.labelSizeCombo_ = FloatComboBox.create(2.0f, 10.0f);
        this.labelSizeCombo_.setName("beta.numberlay.size");
        this.labelSizeCombo_.setValue(this.pmeta_.getFloat("beta.numberlay.size"));
        this.labelColorCombo_ = new ColorComboBox();
        this.labelColorCombo_.setName("beta.numberlay.color");
        this.labelColorCombo_.setSelectedColor(this.pmeta_.getColor("beta.numberlay.color"));
        QuickBox fontBox = QuickBox.createLeftBox(labelsLabel, sizeLabel, this.labelSizeCombo_, colorLabel, this.labelColorCombo_);
        this.setLayout(new BoxLayout(this, 1));
        this.add(enabledBox);
        this.add(invalidsBox);
        this.add(fontBox);
        this.add(spacingBox);
        this.add(lonBox);
        this.add(latBox);
        GuiUtils.setSizeSmall(this);
        GuiUtils.matchLabelWidths(labelsLabel, s1Label);
    }

    private void attachListeners() {
        this.showNumbersCB_.addItemListener(e -> this.pmeta_.setBoolean("beta.numberlay.enabled", this.showNumbersCB_.isSelected()));
        this.hideInvalidsCB_.addItemListener(e -> this.pmeta_.setBoolean("beta.numberlay.invalids", !this.hideInvalidsCB_.isSelected()));
        FocusAdapter lonSpacingFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonLatNumberlayControls.this.handleLonSpacing();
            }
        };
        FocusAdapter latSpacingFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonLatNumberlayControls.this.handleLatSpacing();
            }
        };
        this.lonSpacingTF_.addFocusListener(lonSpacingFL);
        this.latSpacingTF_.addFocusListener(latSpacingFL);
        this.lonSpacingTF_.addActionListener(e -> this.handleLonSpacing());
        this.latSpacingTF_.addActionListener(e -> this.handleLatSpacing());
        this.lonOffsetCB_.addItemListener(e -> this.pmeta_.setBoolean("beta.numberlay.lon.offset", e.getStateChange() == 1));
        this.latOffsetCB_.addItemListener(e -> this.pmeta_.setBoolean("beta.numberlay.lat.offset", e.getStateChange() == 1));
        this.labelSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.labelSizeCombo_.getValue();
            this.pmeta_.setFloat("beta.numberlay.size", value);
        });
        this.labelColorCombo_.addItemListener(e -> {
            Color cold;
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.labelColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("beta.numberlay.color"))) {
                this.pmeta_.setColor("beta.numberlay.color", cnew);
            }
        });
    }

    private void handleLonSpacing() {
        if (this.lonSpacingTF_ == null) {
            return;
        }
        String s = this.lonSpacingTF_.getText();
        double oldSpacing = this.pmeta_.getDouble("beta.numberlay.lon.spacing");
        try {
            double spacing = StringUtils.parseDouble(s);
            if (spacing <= 0.001) {
                if (spacing <= 0.0) {
                    LOGGER.warn("Lon spacing must be > 0.");
                } else {
                    LOGGER.warn("Lon spacing is too fine.");
                }
                this.lonSpacingTF_.setText(PFORMAT_7G.sprintfx(oldSpacing));
                return;
            }
            this.pmeta_.setDouble("beta.numberlay.lon.spacing", spacing);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lon spacing TF '{}'", (Object)s);
            this.lonSpacingTF_.setText(PFORMAT_7G.sprintfx(oldSpacing));
        }
    }

    private void handleLatSpacing() {
        if (this.latSpacingTF_ == null) {
            return;
        }
        String s = this.latSpacingTF_.getText();
        double oldSpacing = this.pmeta_.getDouble("beta.numberlay.lat.spacing");
        try {
            double spacing = StringUtils.parseDouble(s);
            if (spacing <= 0.001) {
                if (spacing <= 0.0) {
                    LOGGER.warn("Lat spacing must be > 0.");
                } else {
                    LOGGER.warn("Lat spacing is too fine.");
                }
                this.latSpacingTF_.setText(PFORMAT_7G.sprintfx(oldSpacing));
                return;
            }
            this.pmeta_.setDouble("beta.numberlay.lat.spacing", spacing);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lat spacing TF '{}'", (Object)s);
            this.latSpacingTF_.setText(PFORMAT_7G.sprintfx(oldSpacing));
        }
    }
}

