/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanShadingPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_7G = new PrintfFormat("%.7g");
    private PanCheckBox visCB_;
    private PanIntSpinner opacitySpinner_;
    private GTextField subsolarLonTF_;
    private GTextField subsolarLatTF_;

    public PanShadingPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Lat Map Plot Shading"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a map plot, set\u2026");
        this.visCB_ = PanCheckBox.create("Show nightside shading");
        JLabel s21Label = new JLabel("Darkness:\u2009");
        JLabel s22Label = new JLabel("%");
        this.opacitySpinner_ = PanIntSpinner.createPct(prefs_.getInt("plot:proj.shading.opacity"));
        QuickBox s2Box = QuickBox.createLeftBox(this.opacitySpinner_, s22Label);
        JLabel s3Label = new JLabel("Subsolar Pt:\u2009");
        JLabel s31Label = new JLabel("Lon:\u2009");
        JLabel s32Label = new JLabel("\u00b0E, Lat:\u2009");
        JLabel s33Label = new JLabel("\u00b0N");
        this.subsolarLonTF_ = GTextField.createDoubleField();
        this.subsolarLatTF_ = GTextField.createDoubleField();
        QuickBox s3Box = QuickBox.createLeftBox(s31Label, this.subsolarLonTF_, s32Label, this.subsolarLatTF_, s33Label);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 4, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 2, 1));
        this.add((Component)this.visCB_, new FGConstraint(0, 1, 2, 1));
        this.add((Component)s21Label, new FGConstraint(0, 2));
        this.add((Component)s2Box, new FGConstraint(1, 2));
        this.add((Component)s3Label, new FGConstraint(0, 3));
        this.add((Component)s3Box, new FGConstraint(1, 3));
    }

    private void attachListeners() {
        this.visCB_.addItemListener(e -> prefs_.setBoolean("plot:proj.shading.vis", this.visCB_.isSelected()));
        this.opacitySpinner_.addChangeListener(e -> prefs_.setInt("plot:proj.shading.opacity", this.opacitySpinner_.getIntValue()));
        FocusAdapter lonlatFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanShadingPrefsPanel.this.handleSubsolarTF();
            }
        };
        this.subsolarLonTF_.addFocusListener(lonlatFL);
        this.subsolarLatTF_.addFocusListener(lonlatFL);
        this.subsolarLonTF_.addActionListener(e -> this.handleSubsolarTF());
        this.subsolarLatTF_.addActionListener(e -> this.handleSubsolarTF());
    }

    private void handleSubsolarTF() {
        double lat;
        if (this.subsolarLonTF_ == null || this.subsolarLatTF_ == null) {
            return;
        }
        double lon = this.getSubsolarLon();
        if (Double.isNaN(lon)) {
            lon = prefs_.getDouble("plot:proj.subsolar.lon");
            this.subsolarLonTF_.setText(PFORMAT_7G.sprintfx(lon));
        }
        boolean shifted = false;
        while (lon > 180.0) {
            lon -= 360.0;
            shifted = true;
        }
        while (lon < -180.0) {
            lon += 360.0;
            shifted = true;
        }
        if (shifted) {
            this.subsolarLonTF_.setText(PFORMAT_7G.sprintfx(lon));
        }
        if (Math.abs(lat = this.getSubsolarLat()) > 90.0) {
            lat = 90.0 * Math.signum(lat);
            this.subsolarLatTF_.setText(PFORMAT_7G.sprintfx(lat));
        }
        prefs_.setDouble("plot:proj.subsolar.lon", lon);
        prefs_.setDouble("plot:proj.subsolar.lat", lat);
    }

    private double getSubsolarLon() {
        String s = this.subsolarLonTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lon TF '{}'", (Object)s);
            return Double.NaN;
        }
    }

    private double getSubsolarLat() {
        String s = this.subsolarLatTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lat TF '{}')", (Object)s);
            return Double.NaN;
        }
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        this.visCB_.setSelected(prefs_.getBoolean("plot:proj.shading.vis"));
        this.opacitySpinner_.setValue(prefs_.getInt("plot:proj.shading.opacity"));
        this.subsolarLonTF_.setText(PFORMAT_7G.sprintfx(prefs_.getDouble("plot:proj.subsolar.lon")));
        this.subsolarLatTF_.setText(PFORMAT_7G.sprintfx(prefs_.getDouble("plot:proj.subsolar.lat")));
    }
}

