/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.task;

import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.data.PanDataLonLatTrajectory;
import gov.nasa.giss.panoply.io.PanDataWriter;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanExportGridOption;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.util.task.Task;
import java.awt.Component;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportGridTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotFrame parent_;
    private final File file_;
    private final Hashtable<PanExportGridOption, String> opts_;
    private String errMsg_;

    public PanExportGridTask(PanPlotFrame parent, File file, Hashtable<PanExportGridOption, String> opts) {
        super("Exporting internal grid file");
        this.parent_ = parent;
        this.file_ = file;
        this.opts_ = opts;
    }

    @Override
    protected Object beginTask() {
        block8: {
            try {
                LOGGER.trace("Begin writing");
                PanData data = this.parent_.getData();
                if (data instanceof PanData2D) {
                    PanDataWriter.write2D((PanData2D)this.parent_.getData(), this.file_, this.opts_);
                } else if (data instanceof PanData1D) {
                    PanDataWriter.write1D((PanData1D)this.parent_.getData(), this.file_, this.opts_);
                } else if (data instanceof PanDataLonLatTrajectory) {
                    PanDataWriter.writeTrajectory((PanDataLonLatTrajectory)this.parent_.getData(), this.file_, this.opts_);
                } else {
                    SlowMessage.show((Component)this.parent_, "Output Error", new StringBuilder("Unknown export data class ").append(data.getClass().getSimpleName()));
                }
                LOGGER.trace("Done writing");
            }
            catch (Exception exc) {
                this.errMsg_ = exc.toString().replaceAll("\\:.*", "");
                LOGGER.error("Could not write NC file.");
                LOGGER.error(exc.toString());
                if (!LOGGER.isTraceEnabled()) break block8;
                exc.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.errMsg_ == null) {
            this.parent_.setControlWindoidsVisible(true);
        } else {
            SlowMessage.show((Component)this.parent_, "Output Error", new StringBuilder("Unable to write NC file: ").append(this.errMsg_));
        }
    }
}

