/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.CalendarUtils;
import gov.nasa.giss.time.ClimateModelCalendar;
import gov.nasa.giss.time.TimePatterns;
import gov.nasa.giss.time.UnixTimeFormatter;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.SimpleTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelativeTime
implements UnixTimeFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private int incrementField_;
    private boolean fractionalIncrements_;
    private SimpleDateFormat dtFormat_;
    private Date epoch_;
    private Calendar calendar_;
    private boolean zeroBasedYear_;

    public RelativeTime(String unitsStr) throws ParseException {
        this(unitsStr, "gregorian", false);
    }

    public RelativeTime(String unitsStr, String calendarName) throws ParseException {
        this(unitsStr, calendarName, false);
    }

    public RelativeTime(String unitsStr, String calendarName, boolean fractional) throws ParseException {
        this.initMe(unitsStr, calendarName, fractional);
    }

    protected void initMe(String unitsStr, String calendarName, boolean fractional) throws ParseException {
        Objects.requireNonNull(unitsStr, "Units string cannot be null.");
        if (unitsStr.isEmpty()) {
            throw new IllegalArgumentException("Units string is empty.");
        }
        String lcunitsStr = unitsStr.toLowerCase();
        this.calendar_ = CalendarUtils.getCalendar(calendarName);
        LOGGER.trace("calendar looks like {}", (Object)this.calendar_.getClass().getSimpleName());
        this.fractionalIncrements_ = fractional;
        int sinceIndex = lcunitsStr.indexOf(" since ");
        if (sinceIndex < 1) {
            throw new ParseException("Not relative time units", -1);
        }
        this.initIncrementUnits(unitsStr);
        Object originStr = unitsStr.substring(sinceIndex + 7);
        LOGGER.trace("originStr {}", originStr);
        if (this.calendar_ instanceof ClimateModelCalendar) {
            int firstDash = ((String)originStr).indexOf(45);
            if (firstDash > 0) {
                String ystr = ((String)originStr).substring(0, firstDash);
                try {
                    ystr = ystr.replaceAll("\\D", "");
                    int year = Integer.parseInt(ystr);
                    if (year == 0) {
                        this.zeroBasedYear_ = true;
                        originStr = "0001" + ((String)originStr).substring(firstDash);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            LOGGER.trace("CMC origin {}, zeroBasedYear {}", originStr, (Object)this.zeroBasedYear_);
        }
        if (((String)originStr).matches(".* \\+\\d\\d:.*")) {
            originStr = ((String)originStr).replaceAll(" \\+", " GMT+");
        } else if (((String)originStr).matches(".* \\-\\d\\d:.*")) {
            originStr = ((String)originStr).replaceAll(" \\-", "GMT-");
        }
        this.initFormat((String)originStr);
    }

    private void initIncrementUnits(String units) throws ParseException {
        String lcunits = units.toLowerCase();
        if (lcunits.startsWith("year")) {
            this.incrementField_ = 1;
        } else if (lcunits.startsWith("month")) {
            this.incrementField_ = 2;
        } else if (lcunits.startsWith("day") || lcunits.startsWith("d ")) {
            this.incrementField_ = 5;
        } else if (lcunits.startsWith("hour") || lcunits.startsWith("hr ")) {
            this.incrementField_ = 10;
        } else if (lcunits.startsWith("minute") || lcunits.startsWith("min ")) {
            this.incrementField_ = 12;
        } else if (lcunits.startsWith("sec") || lcunits.startsWith("s ")) {
            this.incrementField_ = 13;
        } else if (lcunits.startsWith("msec") || lcunits.startsWith("millisec")) {
            this.incrementField_ = 14;
        } else {
            throw new ParseException("I don't know how to handle units '" + units + "'", -1);
        }
        LOGGER.trace("Increment field {}", (Object)this.incrementField_);
    }

    private void initFormat(String originStr) throws ParseException {
        LOGGER.trace("originStr {}", (Object)originStr);
        this.dtFormat_ = new SimpleDateFormat();
        this.dtFormat_.setLenient(true);
        this.dtFormat_.setCalendar(this.calendar_);
        String matchedFormat = null;
        Object outputFormat = null;
        boolean hasTimeZone = false;
        for (String pattern : TimePatterns.PATTERNS) {
            try {
                this.applyPattern(pattern);
                this.epoch_ = this.dtFormat_.parse(originStr);
                LOGGER.trace("Possibility: epoch {}, pattern {}", (Object)this.epoch_, (Object)pattern);
                matchedFormat = pattern;
                hasTimeZone = matchedFormat.toLowerCase().contains("z") || originStr.endsWith("UTC");
                this.applyPattern("yyyy-MM-dd HH:mm:ss.SSS");
                if (this.incrementField_ == 14) {
                    outputFormat = "yyyy-MM-dd HH:mm:ss.SSS";
                    break;
                }
                this.calendar_.setTime(this.epoch_);
                if (this.calendar_.get(14) != 0) {
                    outputFormat = "yyyy-MM-dd HH:mm:ss.SSS";
                    break;
                }
                this.applyPattern("yyyy-MM-dd HH:mm:ss");
                if (this.incrementField_ == 14 || this.incrementField_ == 13) {
                    outputFormat = "yyyy-MM-dd HH:mm:ss";
                    break;
                }
                this.calendar_.setTime(this.epoch_);
                if (this.calendar_.get(13) != 0) {
                    outputFormat = "yyyy-MM-dd HH:mm:ss";
                    break;
                }
                this.applyPattern("yyyy-MM-dd HH:mm");
                if (this.calendar_.get(12) != 0 || this.incrementField_ == 12) {
                    outputFormat = "yyyy-MM-dd HH:mm";
                    if (!this.fractionalIncrements_) break;
                    outputFormat = "yyyy-MM-dd HH:mm:ss";
                    break;
                }
                if (this.incrementField_ == 5 && pattern.contains("mm")) {
                    outputFormat = "yyyy-MM-dd HH:mm";
                    break;
                }
                this.applyPattern("yyyy-MM-dd HH");
                if (this.calendar_.get(10) != 0 || this.incrementField_ == 10) {
                    outputFormat = "yyyy-MM-dd HH:mm";
                    break;
                }
                this.applyPattern("yyyy-MM-dd");
                if (this.calendar_.get(5) != 1 || this.incrementField_ == 5) {
                    outputFormat = "yyyy-MM-dd";
                    break;
                }
                this.applyPattern("yyyy-MM");
                outputFormat = "yyyy-MM";
                if (((String)outputFormat).startsWith("yyyy-MM-dd")) {
                    outputFormat = "yyyy-MM-dd HH:mm";
                    break;
                }
                if (!((String)outputFormat).startsWith("yyyy-MM")) break;
                LOGGER.trace("Relative time units with fractional months are a bad idea.");
                outputFormat = "yyyy-MM-dd";
                break;
            }
            catch (Exception exception) {
            }
        }
        if (matchedFormat == null) {
            throw new ParseException("Cannot parse '" + originStr + "'", -1);
        }
        LOGGER.trace("Matched format {}", (Object)matchedFormat);
        if (hasTimeZone) {
            LOGGER.trace("Has TZ {}", (Object)hasTimeZone);
            outputFormat = outputFormat + " Z";
        }
        LOGGER.trace("Output format {}, epoch formatted {}", outputFormat, (Object)this.format(0L));
        this.applyPattern((String)outputFormat);
        if (hasTimeZone && originStr.endsWith("UTC")) {
            SimpleTimeZone utc = new SimpleTimeZone(0, "UTC");
            this.calendar_.setTimeZone(utc);
            this.dtFormat_.setTimeZone(utc);
        }
    }

    @Override
    public String getPattern() {
        return this.dtFormat_.toPattern();
    }

    @Override
    public void applyPattern(String pattern) {
        Objects.requireNonNull(pattern, "Pattern may not be null.");
        this.dtFormat_.applyPattern(pattern);
    }

    @Override
    public String format(Number delta) {
        if (delta instanceof Long || delta instanceof Integer || delta instanceof Short) {
            return this.format(delta.longValue());
        }
        return this.format(delta.doubleValue());
    }

    @Override
    public String format(long delta) {
        this.applyOffset(this.incrementField_, delta);
        return this.formatDate();
    }

    @Override
    public String format(double delta) {
        if (Double.isNaN(delta)) {
            throw new IllegalArgumentException("Cannot add NaN value.");
        }
        if (Double.isInfinite(delta)) {
            throw new IllegalArgumentException("Cannot add infinite value.");
        }
        if (delta > 9.223372036854776E18) {
            LOGGER.error("Relative format error: {} > Long.MAX_VALUE", (Object)delta);
            throw new IllegalArgumentException("Time delta out of valid range.");
        }
        double whole = Math.floor(delta);
        if (delta == whole) {
            return this.format((long)delta);
        }
        this.applyOffset(this.incrementField_, (long)whole);
        double fraction = delta - whole;
        double seconds = 0.0;
        if (this.incrementField_ == 1) {
            seconds = fraction * 12.0 * 30.0 * 24.0 * 60.0 * 60.0;
        } else if (this.incrementField_ == 2) {
            seconds = fraction * 30.0 * 24.0 * 60.0 * 60.0;
        } else if (this.incrementField_ == 5) {
            seconds = fraction * 24.0 * 60.0 * 60.0;
        } else if (this.incrementField_ == 10) {
            seconds = fraction * 60.0 * 60.0;
        } else if (this.incrementField_ == 12) {
            seconds = fraction * 60.0;
        }
        RelativeTime.applyOffset(13, (long)seconds, this.calendar_);
        return this.formatDate();
    }

    private void applyOffset(int field, long delta) {
        this.calendar_.setTime(this.epoch_);
        RelativeTime.applyOffset(field, delta, this.calendar_);
    }

    private static void applyOffset(int field, long delta, Calendar cal) {
        if (delta == 0L) {
            return;
        }
        if (delta < Integer.MAX_VALUE && delta > Integer.MIN_VALUE) {
            cal.add(field, (int)delta);
        } else if (delta >= Integer.MAX_VALUE) {
            long d;
            LOGGER.trace("{} > MAX_INT", (Object)delta);
            for (d = delta; d > 2147483000L; d -= 2147483000L) {
                cal.add(field, 2147483000);
            }
            cal.add(field, (int)d);
        } else {
            long d;
            LOGGER.trace("{} < MIN_INT", (Object)delta);
            for (d = delta; d < -2147483000L; d += 2147483000L) {
                cal.add(field, -2147483000);
            }
            cal.add(field, (int)d);
        }
    }

    private String formatDate() {
        Date d = this.calendar_.getTime();
        if (!this.zeroBasedYear_) {
            return this.dtFormat_.format(d);
        }
        int year = this.calendar_.get(1);
        if (year == 1) {
            return this.dtFormat_.format(d).replaceFirst("1", "0");
        }
        this.calendar_.set(1, year - 1);
        return this.dtFormat_.format(this.calendar_.getTime());
    }
}

