/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.windoid;

import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.windoid.WindoidFocusListener;
import gov.nasa.giss.ui.windoid.WindoidHeader;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.lang.invoke.MethodHandles;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Windoid
extends JWindow {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MINI_GAP = 1;
    private WindoidHeader header_;
    private JPanel content_;
    private boolean collapsible_;
    private boolean collapsed_;

    public Windoid(String title, JFrame owner) {
        this(title, owner, false);
    }

    public Windoid(String title, JFrame owner, boolean collapsible) {
        super(owner);
        this.setType(Window.Type.UTILITY);
        this.collapsible_ = collapsible;
        Container cpane = super.getContentPane();
        cpane.setLayout(new BoxLayout(cpane, 1));
        if (!PlatformUtils.isMacintosh() && cpane instanceof JComponent) {
            ((JComponent)cpane).setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }
        if (title != null) {
            this.setName(title);
        }
        this.header_ = new WindoidHeader(title, false);
        cpane.add(this.header_);
        cpane.add(Box.createVerticalStrut(1));
        this.setFocusableWindowState(true);
        this.setFocusable(true);
        this.addWindowFocusListener(new WindoidFocusListener());
    }

    @Override
    public final Container getContentPane() {
        LOGGER.debug("Accessing content pane not allowed in Windoid");
        return null;
    }

    public WindoidHeader getHeader() {
        return this.header_;
    }

    public boolean isCloseable() {
        return this.header_.isCloseable();
    }

    public boolean isCollapsible() {
        return this.collapsible_;
    }

    public void setCloseable(boolean bb) {
        this.header_.setCloseable(bb);
    }

    public void toggleCollapsed() {
        if (!this.collapsible_) {
            LOGGER.trace("Windoid is collapsible");
            return;
        }
        this.setCollapsed(!this.collapsed_);
    }

    public boolean isCollapsed() {
        return this.collapsed_;
    }

    public void setCollapsed(boolean collapsed) {
        if (!this.collapsible_) {
            LOGGER.trace("Windoid is collapsible");
            return;
        }
        this.collapsed_ = collapsed;
        if (collapsed) {
            Dimension pref = this.content_.getPreferredSize();
            pref.height = 0;
            this.content_.setPreferredSize(pref);
            this.content_.setMinimumSize(pref);
            this.content_.setMaximumSize(pref);
        } else {
            this.content_.setPreferredSize(null);
            this.content_.setMinimumSize(null);
            this.content_.setMaximumSize(null);
        }
        this.invalidate();
        this.pack();
        this.repaint();
    }

    public void addContent(JPanel panel) {
        if (this.content_ != null) {
            super.getContentPane().remove(this.content_);
        }
        this.content_ = panel;
        if (this.content_ != null) {
            super.getContentPane().add(this.content_);
        }
    }

    public JPanel removeContent() {
        super.getContentPane().remove(this.content_);
        JPanel jp = this.content_;
        this.content_ = null;
        return jp;
    }

    public JComponent getContent() {
        return this.content_;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public boolean isParentActive() {
        JFrame active = GuiUtils.getActiveFrame();
        Window owner = this.getOwner();
        return owner != null && owner.equals(active);
    }

    @Override
    public void invalidate() {
        this.setSize(this.getPreferredSize());
        super.invalidate();
        this.validate();
        this.repaint();
    }

    @Override
    public void validate() {
        super.validate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.content_ == null) {
            return this.header_.getPreferredSize();
        }
        Dimension d1 = this.header_.getPreferredSize();
        Dimension d2 = this.content_.getPreferredSize();
        return new Dimension(Math.max(d1.width, d2.width), d1.height + 1 + d2.height);
    }

    @Override
    public void paintComponents(Graphics g) {
        Window ww = GuiUtils.getFocusedWindow();
        this.header_.setInFocusedWindow(ww == this);
        super.paintComponents(g);
    }
}

