/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import org.jcodec.containers.mp4.BoxFactory;
import org.jcodec.containers.mp4.Boxes;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.MdtaBox;
import org.jcodec.containers.mp4.boxes.NodeBox;

public class KeysBox
extends NodeBox {
    private static final String FOURCC = "keys";

    public KeysBox(Header atom) {
        super(atom);
        this.factory = new BoxFactory(new LocalBoxes());
    }

    public KeysBox() {
        this(Header.createHeader(FOURCC, 0L));
    }

    @Override
    public void parse(ByteBuffer input) {
        int vf = input.getInt();
        int cnt = input.getInt();
        super.parse(input);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        out.putInt(0);
        out.putInt(this.boxes.size());
        super.doWrite(out);
    }

    public static String fourcc() {
        return FOURCC;
    }

    @Override
    public int estimateSize() {
        return 8 + super.estimateSize();
    }

    private static class LocalBoxes
    extends Boxes {
        private LocalBoxes() {
            this.mappings.put(MdtaBox.fourcc(), MdtaBox.class);
        }
    }
}

