/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CantersPolyconicW32
extends QuadSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Canters Polyconic W32";
    public static final int PROPERTIES = 32;
    private static final double CP1 = 1.1145;
    private static final double CP3 = -0.0185;
    private static final double CP5 = -0.0201;
    private static final double THREE_CP3 = -0.055499999999999994;
    private static final double FIVE_CP5 = -0.1005;
    private static final double MAX_X_OVER_RS = 2.5378439881078423;
    private static final double MAX_Y_OVER_RS = 1.4101123430422131;

    public CantersPolyconicW32(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPolyconicW32(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, 2.5378439881078423, 1.4101123430422131);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double halfLambdaRad = 0.5 * this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double cosBeta = cosPhi * Math.cos(halfLambdaRad);
        double betaTerm = Math.sqrt(0.5 * (1.0 + cosBeta));
        if (betaTerm < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double sinPhi = Math.sin(phiRad);
        double invBetaTerm = 1.0 / betaTerm;
        double capX = 2.0 * cosPhi * Math.sin(halfLambdaRad) * invBetaTerm;
        double capY = sinPhi * invBetaTerm;
        double capY2 = capY * capY;
        double capY4 = capY2 * capY2;
        double yp = (1.1145 + -0.0185 * capY2 + -0.0201 * capY4) * capY;
        double dyp = 1.1145 + -0.055499999999999994 * capY2 + -0.1005 * capY4;
        double xp = capX / dyp;
        double x = (double)this.outCenterX_ + xp * this.rS_;
        double y = (double)this.outCenterY_ - yp * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double dyp;
        double xp;
        double capX;
        double[] lambdaPhiRad;
        double capY4;
        double capY2;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yp = y * this.invRS_;
        double capY = 1.5707963267948966 * yp / this.ymRS_;
        for (int iter = 0; iter < 33; ++iter) {
            capY2 = capY * capY;
            capY4 = capY2 * capY2;
            double func = (1.1145 + -0.0185 * capY2 + -0.0201 * capY4) * capY;
            double dfunc = 1.1145 + -0.055499999999999994 * capY2 + -0.1005 * capY4;
            double dCapY = -(func - yp) / dfunc;
            capY += dCapY;
            if (Math.abs(dCapY) < 1.0E-5) break;
        }
        if ((lambdaPhiRad = this.transformXY2LambdaPhiRad(capX = (xp = x * this.invRS_) * (dyp = 1.1145 + -0.055499999999999994 * (capY2 = capY * capY) + -0.1005 * (capY4 = capY2 * capY2)), capY)) == null) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaPhiRad[0]), Math.toDegrees(lambdaPhiRad[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CantersPolyconicW32 cantersPolyconicW32 = this;
        synchronized (cantersPolyconicW32) {
            double y;
            double capY = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
                double capY4;
                double capY2;
                double yp = y * this.invRS_;
                capY += 1.0E-5;
                for (int iter = 0; iter < 33; ++iter) {
                    capY2 = capY * capY;
                    capY4 = capY2 * capY2;
                    double func = (1.1145 + -0.0185 * capY2 + -0.0201 * capY4) * capY;
                    double dfunc = 1.1145 + -0.055499999999999994 * capY2 + -0.1005 * capY4;
                    double dCapY = -(func - yp) / dfunc;
                    capY += dCapY;
                    if (Math.abs(dCapY) < 1.0E-5) break;
                }
                capY2 = capY * capY;
                capY4 = capY2 * capY2;
                double dyp = 1.1145 + -0.055499999999999994 * capY2 + -0.1005 * capY4;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xp = x * this.invRS_;
                    double capX = xp * dyp;
                    double[] lambdaPhiRad = this.transformXY2LambdaPhiRad(capX, capY);
                    if (lambdaPhiRad == null || Double.isNaN(lambdaPhiRad[0])) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaPhiRad[0]), Math.toDegrees(lambdaPhiRad[1]));
                }
            }
        }
    }

    private double[] transformXY2LambdaPhiRad(double capX, double capY) {
        double lambdaRad;
        double sinHalfBeta = 0.5 * Math.hypot(0.5 * capX, capY);
        double halfBetaRad = Math.asin(sinHalfBeta);
        double cosHalfBeta = Math.cos(halfBetaRad);
        double phiRad = Math.asin(capY * cosHalfBeta);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double cosBeta = Math.cos(2.0 * halfBetaRad);
        double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.atan2(0.5 * capX * cosHalfBeta, cosBeta);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        super.drawMeridian(g2d, this.lambdaC_ + 179.99999, 90.0, null);
        super.drawMeridian(g2d, this.lambdaC_ - 179.99999, -90.0, null);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, maxLat, label);
    }
}

