/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.GlobalCylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralCylindrical
extends GlobalCylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Central Cylindrical";
    private static final double DEFAULT_TOPLAT = 60.0;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = Math.tan(Math.toRadians(60.0));
    private double topLat_ = 60.0;
    private final ProjDoubleParameter topLatParam_ = new ProjDoubleParameter("Latitude at top of map", "Max. Latitude", "\u00b0", 60.0, 45.0, 89.0, true, false);

    public CentralCylindrical(int width, int height) {
        this(width, height, 0, 0);
    }

    public CentralCylindrical(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, MAX_Y_OVER_RS);
        this.addParameter(this.topLatParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.topLatParam_)) {
            this.setTopLatitude(this.topLatParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setTopLatitude(double lat) {
        this.topLat_ = Math.abs(lat);
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double heightFactor = Math.tan(Math.toRadians(this.topLat_));
        this.setMaxXYOverRS(Math.PI, heightFactor);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > this.topLat_) {
            return null;
        }
        double x = this.lonToLambdaRad(lon);
        double y = Math.tan(Math.toRadians(lat));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = Math.atan(y * this.invRS_);
        if (Math.abs(Math.toDegrees(phiRad)) > this.topLat_) {
            return null;
        }
        double lambdaRad = x * this.invRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CentralCylindrical centralCylindrical = this;
        synchronized (centralCylindrical) {
            double y;
            double phiRad;
            double phi;
            for (int iy = 0; iy < this.dyMax_ && !((phi = Math.toDegrees(phiRad = Math.atan((y = (double)iy + 0.5) * this.invRS_))) > this.topLat_); ++iy) {
                double x;
                double lambdaRad;
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        Point2D.Double dot = this.transformLL2XY(lon, this.topLat_ - 1.0E-10);
        Point2D.Double dotL = this.transformLL2XY(lon, -0.75 * this.topLat_);
        if (dot == null) {
            return;
        }
        float top = this.outCenterY_ - this.dyMax_;
        float bottom = this.outCenterY_ + this.dyMax_;
        if (label == null || label.length() == 0) {
            GraphicUtils.drawLine(g2d, dot.x, top, dot.x, bottom);
            return;
        }
        Graphics2D g2x = (Graphics2D)g2d.create();
        Shape oldclip = g2x.getClip();
        if (oldclip == null) {
            oldclip = this.getMarginRectClose();
        }
        FontMetrics fm = g2x.getFontMetrics();
        int w = fm.stringWidth(label);
        int des = fm.getDescent();
        int fh = fm.getHeight();
        int fh2 = fh / 2;
        int fh4 = fh / 4;
        float labelx = (float)(dotL.x - 0.5 * (double)w);
        g2x.drawString(label, labelx, (float)(dotL.y - (double)des));
        Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dotL.y - (double)fh, w + fh2, fh);
        Area clipArea = new Area(oldclip);
        Area textArea = new Area(textRect);
        clipArea.subtract(textArea);
        g2x.setClip(clipArea);
        GraphicUtils.drawLine(g2x, dot.x, top, dot.x, bottom);
        g2x.dispose();
    }
}

