/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.QuadEllipseProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fournier1
extends QuadEllipseProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Fournier I Globular";
    public static final int PROPERTIES = 0x4000020;
    private static final double PI_OVER_6 = 0.5235987755982988;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;
    private final ProjBooleanParameter globalParam_ = new ProjBooleanParameter("Show full globe rather than hemisphere", "Global", true);
    private boolean global_ = true;

    public Fournier1(int width, int height) {
        this(width, height, 0, 0);
    }

    public Fournier1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x4000020, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.globalParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.globalParam_)) {
            this.setGlobal(this.globalParam_.isSelected());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setGlobal(boolean b) {
        this.global_ = b;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        if (this.global_) {
            this.setMaxXYOverRS(Math.PI, 1.5707963267948966);
        } else {
            this.setMaxXYOverRS(1.5707963267948966);
        }
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > Math.PI) {
            return null;
        }
        if (!this.global_ && absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double x = 0.0;
        double y = 0.0;
        if (absLambdaRad < 1.0E-5 || Math.abs(phiRad) == 1.5707963267948966) {
            x = 0.0;
            y = phiRad;
        } else if (phiRad == 0.0) {
            x = lambdaRad;
            y = 0.0;
        } else if (Math.abs(lambdaRad) == 1.5707963267948966) {
            x = lambdaRad * Math.cos(phiRad);
            y = 1.5707963267948966 * Math.sin(phiRad);
        } else {
            double absPhiRad = Math.abs(phiRad);
            double lambdaRad2 = lambdaRad * lambdaRad;
            double fourLambdaRad2 = 4.0 * lambdaRad2;
            double phiRad2 = phiRad * phiRad;
            double sinPhi = Math.sin(absPhiRad);
            double valC = 2.4674011002723395;
            double valP = Math.PI * sinPhi;
            double valS = (2.4674011002723395 - phiRad2) / (valP - 2.0 * absPhiRad);
            double valR = valS - absPhiRad;
            double sqTerm = fourLambdaRad2 * lambdaRad2 + Math.PI * 2 * lambdaRad2 * (2.0 * valS * sinPhi - Math.PI) + Math.PI * Math.PI * valR * valR;
            double cosT = (Math.PI * Math.sqrt(sqTerm) - fourLambdaRad2 * valS) / (valR * (Math.PI * Math.PI - fourLambdaRad2));
            y = valS - valR * cosT;
            x = lambdaRad * Math.sqrt(1.0 - y * y / 2.4674011002723395);
            if (phiRad < 0.0) {
                y = -y;
            }
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double fguess;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, 0.0);
        }
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (this.global_ ? Math.hypot(0.5 * absx, absy) > (double)this.dyMax_ : Math.hypot(absx, absy) > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double lambdaRad = absXOverRS / Math.sqrt(1.0 - absYOverRS * absYOverRS / 2.4674011002723395);
        if (lambdaRad > Math.PI || !this.global_ && lambdaRad > 1.5707963267948966) {
            return null;
        }
        if (y == 0.0) {
            double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
            return new PointLL(this.lambdaC_ + lambda, 0.0);
        }
        double x2PlusY2 = absXOverRS * absXOverRS + absYOverRS * absYOverRS;
        double phiRad = fguess = lambdaRad < 0.5235987755982988 ? absYOverRS : Math.asin(absYOverRS / Math.sqrt(x2PlusY2));
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double piSinPhi = Math.PI * sinPhi;
            double s = (2.4674011002723395 - phiRad * phiRad) / (piSinPhi - 2.0 * phiRad);
            double r = s - phiRad;
            double dsdphi = (2.0 * r - Math.PI * s * cosPhi) / (piSinPhi - 2.0 * phiRad);
            double func = x2PlusY2 - 2.4674011002723395 - 2.0 * absYOverRS * s + s * piSinPhi;
            double dfunc = (piSinPhi - 2.0 * absYOverRS) * dsdphi + Math.PI * s * cosPhi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        try {
            return new PointLL(this.lambdaC_ + lambda, phi);
        }
        catch (Exception exc) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Fournier1 fournier1 = this;
        synchronized (fournier1) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double xOverRs;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double yOverRs = y * this.invRS_;
                double phiRad = y / (double)this.dyMax_ * 1.5707963267948966;
                for (int ix = 0; !(ix >= this.dxMax_ || (lambdaRad = (xOverRs = (x = (double)ix + 0.5) * this.invRS_) / Math.sqrt(1.0 - yOverRs * yOverRs / 2.4674011002723395)) > Math.PI || !this.global_ && lambdaRad > 1.5707963267948966); ++ix) {
                    double x2PlusY2 = xOverRs * xOverRs + yOverRs * yOverRs;
                    for (int iter = 0; iter < 33; ++iter) {
                        double cosPhi = Math.cos(phiRad);
                        double sinPhi = Math.sin(phiRad);
                        double piSinPhi = Math.PI * sinPhi;
                        double s = (2.4674011002723395 - phiRad * phiRad) / (piSinPhi - 2.0 * phiRad);
                        double r = s - phiRad;
                        double dsdphi = (2.0 * r - Math.PI * s * cosPhi) / (piSinPhi - 2.0 * phiRad);
                        double func = x2PlusY2 - 2.4674011002723395 - 2.0 * yOverRs * s + s * piSinPhi;
                        double dfunc = (piSinPhi - 2.0 * yOverRs) * dsdphi + Math.PI * s * cosPhi;
                        double dphiRad = -func / dfunc;
                        phiRad += dphiRad;
                        if (Math.abs(dphiRad) < 1.0E-5) break;
                    }
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (this.global_) {
            Point2D.Double dot1 = this.transformLL2XY(this.lambdaC_ - 179.99999, lat);
            Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_, lat);
            Point2D.Double dot3 = this.transformLL2XY(this.lambdaC_ + 179.99999, lat);
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        } else {
            Point2D.Double dot1 = this.transformLL2XY(this.lambdaC_ - 89.99999, lat);
            Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_, lat);
            Point2D.Double dot3 = this.transformLL2XY(this.lambdaC_ + 89.99999, lat);
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        Point2D.Double dotSP;
        double lambda = this.lonToLambda(lon);
        double absLambda = Math.abs(lambda);
        if (this.global_ ? absLambda > 179.99999 : absLambda > 89.99999) {
            return;
        }
        Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
        if (dotEq == null) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (dotN == null || dotS == null) {
            return;
        }
        if (Math.abs(dotN.x - dotEq.x) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
            return;
        }
        Point2D.Double dotNP = maxLat > 89.99999 ? dotN : this.transformLL2XY(lon, 90.0);
        Point2D.Double double_ = dotSP = maxLat > 89.99999 ? dotS : this.transformLL2XY(lon, -90.0);
        if (dotNP == null || dotSP == null) {
            return;
        }
        double hw = Math.abs(dotEq.x - dotNP.x);
        double rectX = dotNP.x - hw;
        double rectW = 2.0 * hw;
        double rectH = dotSP.y - dotNP.y;
        if (dotEq.x > dotN.x) {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotS, dotN);
        } else {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotN, dotS);
        }
    }
}

