/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.io;

import gov.nasa.giss.graphics.GPrintable;
import gov.nasa.giss.graphics.PaperSize;
import gov.nasa.giss.img.GImageIO;
import gov.nasa.giss.img.ImageOutputFormat;
import gov.nasa.giss.img.SvgUtils;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanDisplayFrame;
import gov.nasa.giss.panoply.util.PanConstants;
import gov.nasa.giss.ui.SlowMessage;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanImageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static boolean saveImage(File f, PanDisplayFrame df) {
        return PanImageUtils.saveImage(f, df.getPrintable(), df);
    }

    public static boolean saveImage(File f, GPrintable plot, PanDisplayFrame listener) {
        try {
            ImageOutputFormat format = ImageOutputFormat.matching(f, false);
            switch (format) {
                case GIF: {
                    return GImageIO.saveAsGif(f, plot);
                }
                case JPEG: {
                    return GImageIO.saveAsJpeg(f, plot);
                }
                case PNG: {
                    return GImageIO.saveAsPng(f, plot);
                }
                case TIFF: {
                    return GImageIO.saveAsTiff(f, plot, PanConstants.SOFTWARE);
                }
                case PDF: {
                    return PanImageUtils.saveAsPdf(f, plot);
                }
                case PS: {
                    return PanImageUtils.saveAsPs(f, plot);
                }
                case SVG: {
                    return PanImageUtils.saveAsSvg(f, plot);
                }
            }
            throw new RuntimeException("Unknown output graphic extension.");
        }
        catch (Exception exc) {
            LOGGER.error("Could not save image to a file.");
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            if (listener != null) {
                SlowMessage.show((Component)listener, "Save Error", "Unable to save image. " + exc.toString());
            }
            return false;
        }
    }

    public static boolean saveAsPdf(File f, GPrintable plot) throws IOException {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        boolean vectorized = prefs.getBoolean("files:save.pspdf.vectorized");
        PaperSize pps = PaperSize.matching(prefs.getString("files:save.pspdf.paper"));
        return PanImageUtils.saveAsPdf(f, plot, vectorized, pps);
    }

    public static boolean saveAsPdf(File f, GPrintable plot, boolean vectorized, String paperSize) throws IOException {
        PaperSize pps = PaperSize.matching(paperSize);
        return GImageIO.saveAsPdf(f, plot, vectorized, pps, PanConstants.SOFTWARE);
    }

    public static boolean saveAsPdf(File f, GPrintable plot, boolean vectorized, PaperSize pps) throws IOException {
        return GImageIO.saveAsPdf(f, plot, vectorized, pps, PanConstants.SOFTWARE);
    }

    public static boolean saveAsPs(File f, GPrintable plot) throws IOException {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        boolean vectorized = prefs.getBoolean("files:save.pspdf.vectorized");
        PaperSize pps = PaperSize.matching(prefs.getString("files:save.pspdf.paper"));
        return GImageIO.saveAsPs(f, plot, vectorized, pps, PanConstants.SOFTWARE);
    }

    public static boolean saveAsPs(File f, GPrintable plot, boolean vectorized, String paperSize) throws IOException {
        PaperSize pps = PaperSize.matching(paperSize);
        return GImageIO.saveAsPs(f, plot, vectorized, pps, PanConstants.SOFTWARE);
    }

    public static boolean saveAsSvg(File f, GPrintable plot) throws IOException {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        boolean vectorized = prefs.getBoolean("files:save.pspdf.vectorized");
        return PanImageUtils.saveAsSvg(f, plot, vectorized);
    }

    public static boolean saveAsSvg(File f, GPrintable plot, boolean vectorized) throws IOException {
        return SvgUtils.save(f, plot, vectorized);
    }

    private PanImageUtils() {
    }
}

