/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.about.PanAboutFrame;
import gov.nasa.giss.panoply.action.PanMinimizeFrameAction;
import gov.nasa.giss.panoply.action.PanShowAboutFrameAction;
import gov.nasa.giss.panoply.action.PanShowColorTableFrameAction;
import gov.nasa.giss.panoply.action.PanShowLoggingFrameAction;
import gov.nasa.giss.panoply.action.PanShowOverlayFrameAction;
import gov.nasa.giss.panoply.action.PanShowPreferencesFrameAction;
import gov.nasa.giss.panoply.action.PanShowSourcesFrameAction;
import gov.nasa.giss.panoply.colortable.PanColorTableFrame;
import gov.nasa.giss.panoply.log.PanLoggingFrame;
import gov.nasa.giss.panoply.macos.PanHiddenMacFrame;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.overlay.PanOverlayFrame;
import gov.nasa.giss.panoply.plotui.PanPlotControlsMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotWindoid;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefsui.PanPreferencesFrame;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.menu.GissCheckBoxMenuItem;
import gov.nasa.giss.ui.menu.GissMenuItem;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanWindowMenu
extends PanMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JCheckBoxMenuItem miShowSources_;
    private final JCheckBoxMenuItem miShowColorTables_;
    private final JCheckBoxMenuItem miShowOverlays_;
    private final JCheckBoxMenuItem miPreferences_;
    private final JCheckBoxMenuItem miAbout_;
    private final JCheckBoxMenuItem miShowLogging_;
    private final Hashtable<PanPlotControlsID, JCheckBoxMenuItem> cbItems_ = new Hashtable(5);
    private final int coreItemsCount_;

    public PanWindowMenu(PanFrame parent) {
        super(parent, "window-menu");
        PanPreferences prefs = PanPreferences.getSharedInstance();
        AbstractAction a = new PanMinimizeFrameAction(this.pframe_);
        GissMenuItem jmi = this.makeItemFromProperties("minimize-window", a);
        this.add(jmi);
        if (PlatformUtils.isMacintosh()) {
            jmi.setEnabled(!(parent instanceof PanHiddenMacFrame));
        } else {
            jmi.setEnabled(true);
        }
        this.addSeparator();
        a = PanShowSourcesFrameAction.getSharedInstance();
        this.miShowSources_ = this.makeCheckBoxItemFromProperties("show-sources-window", a);
        this.add(this.miShowSources_).setEnabled(true);
        a = PanShowColorTableFrameAction.getSharedInstance();
        this.miShowColorTables_ = this.makeCheckBoxItemFromProperties("show-colorbar-window", a);
        this.add(this.miShowColorTables_).setEnabled(true);
        a = PanShowOverlayFrameAction.getSharedInstance();
        this.miShowOverlays_ = this.makeCheckBoxItemFromProperties("show-overlay-window", a);
        this.add(this.miShowOverlays_).setEnabled(true);
        if (PanPlotControlsMeta.isFloating()) {
            GissCheckBoxMenuItem mi;
            this.addSeparator();
            if (PanPlotControlsMeta.isUnified()) {
                mi = this.makeCheckBoxItemFromProperties("show-unified-controls", null);
                this.cbItems_.put(PanPlotControlsID.UNIFIED, mi);
                this.add(mi).setEnabled(false);
            } else {
                mi = this.makeCheckBoxItemFromProperties("show-array-controls", null);
                this.cbItems_.put(PanPlotControlsID.ARRAYS, mi);
                this.add(mi).setEnabled(false);
                mi = this.makeCheckBoxItemFromProperties("show-contour-controls", null);
                this.cbItems_.put(PanPlotControlsID.CONTOURS, mi);
                this.add(mi).setEnabled(false);
                mi = this.makeCheckBoxItemFromProperties("show-grid-controls", null);
                this.cbItems_.put(PanPlotControlsID.GRID, mi);
                this.add(mi).setEnabled(false);
                mi = this.makeCheckBoxItemFromProperties("show-label-controls", null);
                this.cbItems_.put(PanPlotControlsID.LABELS, mi);
                this.add(mi).setEnabled(false);
                mi = this.makeCheckBoxItemFromProperties("show-layout-controls", null);
                this.cbItems_.put(PanPlotControlsID.LAYOUT, mi);
                this.add(mi).setEnabled(false);
                mi = this.makeCheckBoxItemFromProperties("show-overlay-controls", null);
                this.cbItems_.put(PanPlotControlsID.OVERLAYS, mi);
                this.add(mi).setEnabled(false);
                mi = this.makeCheckBoxItemFromProperties("show-map-controls", null);
                this.cbItems_.put(PanPlotControlsID.MAP, mi);
                this.add(mi).setEnabled(false);
                mi = this.makeCheckBoxItemFromProperties("show-scale-controls", null);
                this.cbItems_.put(PanPlotControlsID.SCALE, mi);
                this.add(mi).setEnabled(false);
                mi = this.makeCheckBoxItemFromProperties("show-shading-controls", null);
                this.cbItems_.put(PanPlotControlsID.SHADING, mi);
                this.add(mi).setEnabled(false);
                mi = this.makeCheckBoxItemFromProperties("show-stroke-controls", null);
                this.cbItems_.put(PanPlotControlsID.STROKE, mi);
                this.add(mi).setEnabled(false);
                mi = this.makeCheckBoxItemFromProperties("show-trajectory-controls", null);
                this.cbItems_.put(PanPlotControlsID.TRAJECTORY, mi);
                this.add(mi).setEnabled(false);
                mi = this.makeCheckBoxItemFromProperties("show-vector-controls", null);
                this.cbItems_.put(PanPlotControlsID.VECTORS, mi);
                this.add(mi).setEnabled(false);
                this.addSeparator();
                if (PanUtils.isBeta()) {
                    if (prefs.getBoolean("beta:underlays")) {
                        mi = this.makeCheckBoxItemFromProperties("show-alpha-controls", null);
                        this.cbItems_.put(PanPlotControlsID.ALPHA, mi);
                        this.add(mi).setEnabled(false);
                    }
                    if (prefs.getBoolean("beta:numberlays")) {
                        mi = this.makeCheckBoxItemFromProperties("show-numberlay-controls", null);
                        this.cbItems_.put(PanPlotControlsID.NUMBERLAY, mi);
                        this.add(mi).setEnabled(false);
                    }
                    if (prefs.getBoolean("beta:underlays") || prefs.getBoolean("beta:numberlays")) {
                        this.addSeparator();
                    }
                }
            }
        }
        this.coreItemsCount_ = this.getItemCount();
        if (PanUtils.isBeta()) {
            a = PanShowLoggingFrameAction.getSharedInstance();
            this.miShowLogging_ = this.makeCheckBoxItemFromProperties("develop-frame", a);
        } else {
            this.miShowLogging_ = null;
        }
        if (PlatformUtils.isMacintosh()) {
            this.miPreferences_ = null;
            this.miAbout_ = null;
        } else {
            PanShowPreferencesFrameAction a1 = PanShowPreferencesFrameAction.getSharedInstance();
            PanShowAboutFrameAction a2 = PanShowAboutFrameAction.getSharedInstance();
            this.miPreferences_ = this.makeCheckBoxItemFromProperties("show-preferences-2", a1);
            this.miAbout_ = this.makeCheckBoxItemFromProperties("show-about", a2);
            this.add(this.miPreferences_).setEnabled(true);
            this.add(this.miAbout_).setEnabled(true);
        }
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        Window ww;
        JCheckBoxMenuItem mi;
        int n;
        int n2;
        Window[] windowArray;
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window == null) {
            return;
        }
        int msize = this.getItemCount();
        for (int i = this.coreItemsCount_; i < msize; ++i) {
            this.remove(this.coreItemsCount_);
        }
        this.miShowSources_.setSelected(window instanceof PanSourcesFrame);
        this.miShowColorTables_.setSelected(window instanceof PanColorTableFrame);
        this.miShowOverlays_.setSelected(window instanceof PanOverlayFrame);
        PanPlotFrame[] plotFrames = PanPlotFrame.getAllPlotFrames();
        if (plotFrames.length > 0) {
            this.addSeparator();
            windowArray = plotFrames;
            n2 = windowArray.length;
            for (n = 0; n < n2; ++n) {
                Window pf;
                Window ff = pf = windowArray[n];
                mi = this.makeCheckBoxItem(((Frame)ff).getTitle(), null);
                mi.addActionListener(arg_0 -> PanWindowMenu.lambda$refreshPrivate$0((PanPlotFrame)ff, mi, arg_0));
                this.add(mi).setEnabled(true);
                mi.setSelected(ff == window);
            }
        }
        windowArray = Window.getWindows();
        n2 = windowArray.length;
        for (n = 0; !(n >= n2 || (ww = windowArray[n]) instanceof PanLoggingFrame && ww.isVisible()); ++n) {
        }
        if (this.miShowLogging_ != null) {
            this.addSeparator();
            this.add(this.miShowLogging_).setEnabled(true);
            this.miShowLogging_.setSelected(window instanceof PanLoggingFrame);
        }
        if (this.miPreferences_ != null || this.miAbout_ != null) {
            this.addSeparator();
            if (this.miPreferences_ != null) {
                this.add(this.miPreferences_).setEnabled(true);
                this.miPreferences_.setSelected(this.pframe_ instanceof PanPreferencesFrame);
            }
            if (this.miAbout_ != null) {
                this.add(this.miAbout_).setEnabled(true);
                this.miAbout_.setSelected(this.pframe_ instanceof PanAboutFrame);
            }
        }
        if (this.pframe_ instanceof PanPlotFrame) {
            PanPlotFrame ff = (PanPlotFrame)this.pframe_;
            for (PanPlotControlsID cid : PanPlotControlsID.values()) {
                mi = this.cbItems_.get(cid);
                if (mi == null) continue;
                PanPlotWindoid windoid = ff.getControlsWindoid(cid);
                mi.setSelected(windoid != null && windoid.isVisible());
            }
        }
    }

    private static /* synthetic */ void lambda$refreshPrivate$0(PanPlotFrame ff, JCheckBoxMenuItem mi, ActionEvent e) {
        ff.reveal();
        mi.setSelected(true);
    }
}

