/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.map.symbol.SymbolID;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanOverlayComboBox;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import gov.nasa.giss.ui.panel.PanelSection;
import gov.nasa.giss.util.reslist.ResourceListDataEvent;
import gov.nasa.giss.util.reslist.ResourceListDataListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatOverlayControls
extends PanControlsPanel
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanOverlayComboBox[] overlayCombo_;
    private ColorComboBox[] colorCombo_;
    private JLabel[] weightLabel_;
    private PanIntSpinner[] weightSpinner_;
    private DescribedEnumComboBox[] styleCombo_;
    private DescribedEnumComboBox[] symbolCombo_;
    private FloatComboBox[] symbolSizeCombo_;
    private PanCheckBox[] maskInvertCB_;
    private Box[] row3_;
    private QuickBox[] strokeRow_;
    private QuickBox[] symbolRow_;
    private QuickBox[] maskRow_;
    private boolean refreshing_;

    public PanLonLatOverlayControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("overlay-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
        PanResourceUtils.getOverlayList().addListDataListener(this);
    }

    private void createLayout() {
        this.overlayCombo_ = new PanOverlayComboBox[3];
        this.colorCombo_ = new ColorComboBox[3];
        this.weightLabel_ = new JLabel[3];
        this.weightSpinner_ = new PanIntSpinner[3];
        this.maskInvertCB_ = new PanCheckBox[3];
        this.styleCombo_ = new DescribedEnumComboBox[3];
        this.symbolCombo_ = new DescribedEnumComboBox[3];
        this.symbolSizeCombo_ = new FloatComboBox[3];
        this.row3_ = new Box[3];
        this.strokeRow_ = new QuickBox[3];
        this.symbolRow_ = new QuickBox[3];
        this.maskRow_ = new QuickBox[3];
        this.setLayout(new BoxLayout(this, 1));
        for (int i = 0; i < 3; ++i) {
            this.add(this.createSection(i));
        }
    }

    private JPanel createSection(int idx) {
        String title = "Overlay " + (idx + 1);
        JLabel oNameLabel = new JLabel("Name:\u2009");
        this.overlayCombo_[idx] = PanOverlayComboBox.small(PanParamKeys.OVERLAY_NAME[idx], true);
        QuickBox row1 = QuickBox.createLeftBox(oNameLabel, this.overlayCombo_[idx]);
        JLabel oColorLabel = new JLabel("Color:\u2009");
        this.colorCombo_[idx] = new ColorComboBox();
        this.colorCombo_[idx].setName(PanParamKeys.OVERLAY_COLOR[idx]);
        this.weightLabel_[idx] = new JLabel("\u2014 Weight:\u2009");
        this.weightSpinner_[idx] = PanIntSpinner.smallWeight(PanParamKeys.OVERLAY_WGT[idx], this.pmeta_.getInt(PanParamKeys.OVERLAY_WGT[idx]), 0, 400);
        JLabel wgtPctLabel = new JLabel("%");
        QuickBox row2 = QuickBox.createLeftBox(oColorLabel, this.colorCombo_[idx], this.weightLabel_[idx], this.weightSpinner_[idx], wgtPctLabel);
        this.maskInvertCB_[idx] = PanCheckBox.small(PanParamKeys.OVERLAY_INVERT[idx], "Invert");
        this.maskRow_[idx] = QuickBox.createLeftBox(this.maskInvertCB_[idx]);
        JLabel oStyleLabel = new JLabel("Style:\u2009");
        this.styleCombo_[idx] = new DescribedEnumComboBox(PanStrokePattern.class);
        this.styleCombo_[idx].setName(PanParamKeys.OVERLAY_STYLE[idx]);
        this.strokeRow_[idx] = QuickBox.createLeftBox(oStyleLabel, this.styleCombo_[idx]);
        JLabel oSymbolLabel = new JLabel("Symbol:\u2009");
        JLabel oSymbolSizeLabel = new JLabel("\u2014 Size:\u2009");
        this.symbolCombo_[idx] = new DescribedEnumComboBox(SymbolID.class);
        this.symbolCombo_[idx].setName(PanParamKeys.OVERLAY_SYMBOL_ID[idx]);
        this.symbolCombo_[idx].removeItem(SymbolID.NONE);
        this.symbolSizeCombo_[idx] = FloatComboBox.create(2.0f, 16.0f);
        this.symbolSizeCombo_[idx].setName(PanParamKeys.OVERLAY_SYMBOL_SIZE[idx]);
        this.symbolRow_[idx] = QuickBox.createLeftBox(oSymbolLabel, this.symbolCombo_[idx], oSymbolSizeLabel, this.symbolSizeCombo_[idx]);
        this.row3_[idx] = new Box(0);
        this.row3_[idx].add(this.strokeRow_[idx]);
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        jp.setBorder(PanGuiUtils.WINDOID_SECT_BORDER);
        jp.setOpaque(false);
        jp.add(row1);
        this.add(Box.createVerticalStrut(1));
        jp.add(row2);
        this.add(Box.createVerticalStrut(1));
        jp.add(this.row3_[idx]);
        PanelSection ws = new PanelSection(title, jp);
        GuiUtils.setSizeSmall(ws);
        GuiUtils.matchLabelWidths(oNameLabel, oColorLabel, oStyleLabel, oSymbolLabel);
        return ws;
    }

    private void attachListeners() {
        int ii = 0;
        while (ii < 3) {
            int i = ii++;
            this.overlayCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.overlayCombo_[i].isRefreshing()) {
                    return;
                }
                Object o = this.overlayCombo_[i].getSelectedItem();
                String oname = (String)o;
                this.pmeta_.setString(PanParamKeys.OVERLAY_NAME[i], oname);
                this.scheduleRefreshTask();
            });
            this.maskInvertCB_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setBoolean(PanParamKeys.OVERLAY_INVERT[i], this.maskInvertCB_[i].isSelected());
            });
            this.styleCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.put(PanParamKeys.OVERLAY_STYLE[i], (Object)this.styleCombo_[i].getEnumName());
            });
            this.colorCombo_[i].addItemListener(e -> {
                Color cold;
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                Color cnew = this.colorCombo_[i].getSelectedColor();
                if (!cnew.equals(cold = this.pmeta_.getColor(PanParamKeys.OVERLAY_COLOR[i]))) {
                    this.pmeta_.setColor(PanParamKeys.OVERLAY_COLOR[i], cnew);
                }
            });
            this.weightSpinner_[i].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setInt(PanParamKeys.OVERLAY_WGT[i], this.weightSpinner_[i].getIntValue());
            });
            this.symbolCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.set(PanParamKeys.OVERLAY_SYMBOL_ID[i], this.symbolCombo_[i].getEnumName());
            });
            this.symbolSizeCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.setFloat(PanParamKeys.OVERLAY_SYMBOL_SIZE[i], this.symbolSizeCombo_[i].getValue());
            });
        }
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        MapOverlay olay;
        Object source;
        if (e == null) {
            return;
        }
        Component cc = e.getComponent();
        if (cc == null) {
            return;
        }
        JFrame jf = null;
        if (cc instanceof JFrame) {
            jf = (JFrame)cc;
        } else if (cc instanceof JComponent) {
            jf = GuiUtils.getParentFrame((JComponent)cc);
        } else {
            return;
        }
        JFrame pframe = GuiUtils.getParentFrame(this);
        if (jf == pframe && (source = e.getSource()) instanceof OverlayResourceList && (olay = PanResourceUtils.getOverlay(e.getIndex0())) != null) {
            EventQueue.invokeLater(() -> this.overlayCombo_[0].setSelectedItem(olay));
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanLonLatOverlayControls panLonLatOverlayControls = this;
        synchronized (panLonLatOverlayControls) {
            for (int i = 0; i < 3; ++i) {
                this.overlayCombo_[i].flush();
                this.overlayCombo_[i] = null;
            }
            super.flush();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        for (int i = 0; i < 3; ++i) {
            String oname = this.pmeta_.getString(PanParamKeys.OVERLAY_NAME[i]);
            MapOverlay oo = PanResourceUtils.getOverlay(oname);
            if (oo == null) {
                this.overlayCombo_[i].setSelectedItem("None");
            } else {
                this.overlayCombo_[i].setSelectedItem(oname);
            }
            this.colorCombo_[i].setSelectedColor(this.pmeta_.getColor(PanParamKeys.OVERLAY_COLOR[i]));
            this.maskInvertCB_[i].setSelected(this.pmeta_.getBoolean(PanParamKeys.OVERLAY_INVERT[i]));
            this.styleCombo_[i].setSelItemMatching(this.pmeta_.getString(PanParamKeys.OVERLAY_STYLE[i]));
            this.symbolCombo_[i].setSelItemMatching(this.pmeta_.getString(PanParamKeys.OVERLAY_SYMBOL_ID[i]));
            this.symbolSizeCombo_[i].setValue(this.pmeta_.getFloat(PanParamKeys.OVERLAY_SYMBOL_SIZE[i]));
            this.row3_[i].removeAll();
            this.weightLabel_[i].setText("\u2014 Weight:\u2009");
            if (oo == null) {
                this.row3_[i].add(this.strokeRow_[i]);
            } else if (oo.isOutline()) {
                this.row3_[i].add(this.strokeRow_[i]);
            } else if (oo.isPoints()) {
                this.row3_[i].add(this.symbolRow_[i]);
            } else if (oo.isMask()) {
                this.weightLabel_[i].setText("\u2014 Opacity:\u2009");
                this.row3_[i].add(this.maskRow_[i]);
            } else {
                LOGGER.trace("row {} - unknown overlay type", (Object)i);
                this.row3_[i].add(this.strokeRow_[i]);
            }
            this.row3_[i].invalidate();
        }
        this.refreshing_ = false;
        this.setSize(this.getPreferredSize());
        this.validate();
        this.repaint();
    }
}

