/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui.table;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLonLatUgrid;
import gov.nasa.giss.panoply.plotui.table.PanArrayTableModel;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanArrayLonLatUgridTableModel
extends PanArrayTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected NcArrayLonLatUgrid array_;

    public PanArrayLonLatUgridTableModel(NcArray array) {
        if (!(array instanceof NcArrayLonLatUgrid)) {
            throw new IllegalArgumentException("NcArray is not an NcArrayLonLatUgrid.");
        }
        this.array_ = (NcArrayLonLatUgrid)((Object)array);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        try {
            int rows = this.array_.getLength();
            if (rows > 105000) {
                return 100001;
            }
            return rows;
        }
        catch (Exception exc) {
            LOGGER.trace("exc {}", (Object)exc.getClass().getSimpleName());
            return 0;
        }
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Lon";
            }
            case 1: {
                return "Lat";
            }
            case 2: {
                return "Value";
            }
        }
        return "";
    }

    @Override
    public String getRowName(int row) {
        int rows = this.array_.getLength();
        if (row == 100000 && rows > 105000) {
            return "more...";
        }
        int rowx = this.flippedBT_ ? rows - 1 - row : row;
        return Integer.toString(rowx + 1);
    }

    @Override
    public Object getValueAt(int row, int col) {
        int rows = this.array_.getLength();
        if (row == 100000 && rows > 105000) {
            return "more...";
        }
        int rowx = this.flippedBT_ ? rows - 1 - row : row;
        switch (col) {
            case 0: {
                double lon = this.array_.longitudeAt(rowx);
                return this.valFormatter_.sprintfx(lon);
            }
            case 1: {
                double lat = this.array_.latitudeAt(rowx);
                return this.valFormatter_.sprintfx(lat);
            }
            case 2: {
                return this.valFormatter_.sprintfx(this.array_.valueAt(rowx));
            }
        }
        return "ERR";
    }

    @Override
    public void setFlipBT(boolean flipped) {
        this.flippedBT_ = flipped;
        this.fireTableDataChanged();
    }

    @Override
    public void setFlipLR(boolean flipped) {
    }
}

